/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.interpolation.BiCubicSpline;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Matrix;
import flanagan.plot.PlotGraph;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SurfaceSmooth {
    private double[] xData = null;
    private double[] yData = null;
    private double[][] zData = null;
    private BigDecimal[] xBDdata = null;
    private BigDecimal[] yBDdata = null;
    private BigDecimal[][] zBDdata = null;
    private int nPointsX = 0;
    private int nPointsY = 0;
    private int nPoints = 0;
    private boolean arbprec = false;
    private double[][] zDataMovAv = null;
    private BigDecimal[][] zDataMovAvBD = null;
    private double[][] zDataSavGol = null;
    private double[][] derivSavGol = null;
    private int[][] sgCoeffIndices = null;
    private int nSGcoeff = 0;
    private int lastMethod = 0;
    private int nMethods = 2;
    private int maWindowWidthx = 0;
    private int maWindowWidthy = 0;
    private int sgWindowWidthx = 0;
    private int sgWindowWidthy = 0;
    private int sgPolyDeg = 4;
    private double[][] sgArrayC = null;
    private boolean calcSavGol = false;
    private boolean calcMovAv = false;
    private boolean nthSet = false;
    private double extentMovAv = -1.0;
    private double extentSavGol = -1.0;
    private BiCubicSpline bcsSavGol = null;
    private BiCubicSpline bcsMovAv = null;
    private int trunc = 4;

    public SurfaceSmooth(double[] dArray, double[] dArray2, double[][] dArray3) {
        this.xData = dArray;
        this.yData = dArray2;
        this.zData = dArray3;
        this.polyIndices();
        this.check();
        this.ascend();
    }

    public SurfaceSmooth(double[][] dArray) {
        int n;
        int n2 = dArray.length;
        this.zData = dArray;
        this.yData = new double[n2];
        for (n = 0; n < n2; ++n) {
            this.yData[n] = n;
        }
        n2 = dArray[0].length;
        this.xData = new double[n2];
        for (n = 0; n < n2; ++n) {
            this.xData[n] = n;
        }
        this.polyIndices();
        this.check();
    }

    public SurfaceSmooth(float[] fArray, float[] fArray2, float[][] fArray3) {
        ArrayMaths arrayMaths = new ArrayMaths(fArray);
        this.xData = arrayMaths.array();
        arrayMaths = new ArrayMaths((Object[])fArray3);
        this.yData = arrayMaths.array();
        arrayMaths = new ArrayMaths(fArray3[0]);
        this.zData[0] = arrayMaths.array();
        arrayMaths = new ArrayMaths(fArray3[1]);
        this.zData[1] = arrayMaths.array();
        this.polyIndices();
        this.check();
        this.ascend();
    }

    public SurfaceSmooth(float[][] fArray) {
        int n;
        int n2 = fArray.length;
        int n3 = fArray[0].length;
        this.zData = new double[n2][n3];
        this.xData = new double[n3];
        this.yData = new double[n2];
        for (n = 0; n < n3; ++n) {
            this.xData[n] = n;
        }
        for (n = 0; n < n2; ++n) {
            this.yData[n] = n;
        }
        for (n = 0; n < n2; ++n) {
            for (int j = 0; j < n3; ++j) {
                this.zData[n][j] = fArray[n][j];
            }
        }
        this.polyIndices();
        this.check();
    }

    public SurfaceSmooth(long[] lArray, long[] lArray2, long[][] lArray3) {
        ArrayMaths arrayMaths = new ArrayMaths(lArray);
        this.xData = arrayMaths.array();
        arrayMaths = new ArrayMaths(lArray2);
        this.yData = arrayMaths.array();
        arrayMaths = new ArrayMaths(lArray3[0]);
        this.zData[0] = arrayMaths.array();
        arrayMaths = new ArrayMaths(lArray3[1]);
        this.zData[1] = arrayMaths.array();
        this.polyIndices();
        this.check();
        this.ascend();
    }

    public SurfaceSmooth(long[][] lArray) {
        int n;
        int n2 = lArray.length;
        int n3 = lArray[0].length;
        this.zData = new double[n2][n3];
        this.xData = new double[n3];
        this.yData = new double[n2];
        for (n = 0; n < n3; ++n) {
            this.xData[n] = n;
        }
        for (n = 0; n < n2; ++n) {
            this.yData[n] = n;
        }
        for (n = 0; n < n2; ++n) {
            for (int j = 0; j < n3; ++j) {
                this.zData[n][j] = lArray[n][j];
            }
        }
        this.polyIndices();
        this.check();
    }

    public SurfaceSmooth(int[] nArray, int[] nArray2, int[][] nArray3) {
        ArrayMaths arrayMaths = new ArrayMaths(nArray);
        this.xData = arrayMaths.array();
        arrayMaths = new ArrayMaths(nArray2);
        this.yData = arrayMaths.array();
        arrayMaths = new ArrayMaths(nArray3[0]);
        this.zData[0] = arrayMaths.array();
        arrayMaths = new ArrayMaths(nArray3[1]);
        this.zData[1] = arrayMaths.array();
        this.polyIndices();
        this.check();
        this.ascend();
    }

    public SurfaceSmooth(int[][] nArray) {
        int n;
        int n2 = nArray.length;
        int n3 = nArray[0].length;
        this.zData = new double[n2][n3];
        this.xData = new double[n3];
        this.yData = new double[n2];
        for (n = 0; n < n3; ++n) {
            this.xData[n] = n;
        }
        for (n = 0; n < n2; ++n) {
            this.yData[n] = n;
        }
        for (n = 0; n < n2; ++n) {
            for (int j = 0; j < n3; ++j) {
                this.zData[n][j] = nArray[n][j];
            }
        }
        this.polyIndices();
        this.check();
    }

    public SurfaceSmooth(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2, BigDecimal[][] bigDecimalArray3) {
        this.arbprec = true;
        this.xBDdata = bigDecimalArray;
        int n = bigDecimalArray3.length;
        this.yBDdata = bigDecimalArray2;
        int n2 = bigDecimalArray3[0].length;
        ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray);
        this.xData = arrayMaths.array();
        arrayMaths = new ArrayMaths(bigDecimalArray2);
        this.yData = arrayMaths.array();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                this.zData[j][k] = bigDecimalArray3[j][k].doubleValue();
                this.zBDdata[j][k] = bigDecimalArray3[j][k];
            }
        }
        this.polyIndices();
        this.check();
        this.ascend();
    }

    public SurfaceSmooth(BigDecimal[][] bigDecimalArray) {
        String string;
        int n;
        this.arbprec = true;
        int n2 = bigDecimalArray.length;
        int n3 = bigDecimalArray[0].length;
        this.zData = new double[n2][n3];
        this.xData = new double[n3];
        this.yData = new double[n2];
        this.zBDdata = new BigDecimal[n2][n3];
        this.xBDdata = new BigDecimal[n3];
        this.yBDdata = new BigDecimal[n2];
        for (n = 0; n < n3; ++n) {
            this.xData[n] = n;
            string = new Integer(n).toString();
            this.xBDdata[n] = new BigDecimal(string);
        }
        for (n = 0; n < n2; ++n) {
            this.yData[n] = n;
            string = new Integer(n).toString();
            this.yBDdata[n] = new BigDecimal(string);
        }
        for (n = 0; n < n2; ++n) {
            for (int j = 0; j < n3; ++j) {
                this.zData[n][j] = bigDecimalArray[n][j].doubleValue();
                this.zBDdata[n][j] = bigDecimalArray[n][j];
            }
        }
        this.polyIndices();
        this.check();
    }

    public SurfaceSmooth(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2, BigInteger[][] bigIntegerArray3) {
        int n;
        this.arbprec = true;
        int n2 = bigIntegerArray.length;
        int n3 = bigIntegerArray2.length;
        this.xData = new double[n2];
        this.yData = new double[n3];
        this.xBDdata = new BigDecimal[n2];
        this.yBDdata = new BigDecimal[n3];
        this.zBDdata = new BigDecimal[bigIntegerArray3.length][bigIntegerArray3[0].length];
        for (n = 0; n < n2; ++n) {
            this.xBDdata[n] = new BigDecimal(bigIntegerArray[n]);
            this.xData[n] = bigIntegerArray[n].doubleValue();
        }
        for (n = 0; n < n3; ++n) {
            this.yBDdata[n] = new BigDecimal(bigIntegerArray2[n]);
            this.yData[n] = bigIntegerArray2[n].doubleValue();
        }
        for (n = 0; n < bigIntegerArray3.length; ++n) {
            for (int j = 0; j < bigIntegerArray3[0].length; ++j) {
                this.zBDdata[n][j] = new BigDecimal(bigIntegerArray3[n][j]);
                this.zData[n][j] = bigIntegerArray3[n][j].doubleValue();
            }
        }
        this.polyIndices();
        this.check();
        this.ascend();
    }

    public SurfaceSmooth(BigInteger[][] bigIntegerArray) {
        String string;
        int n;
        this.arbprec = true;
        int n2 = bigIntegerArray.length;
        int n3 = bigIntegerArray[0].length;
        this.zData = new double[n2][n3];
        this.xData = new double[n2];
        this.yData = new double[n3];
        this.zBDdata = new BigDecimal[n2][n3];
        this.xBDdata = new BigDecimal[n2];
        this.yBDdata = new BigDecimal[n3];
        for (n = 0; n < n3; ++n) {
            this.xData[n] = n;
            string = new Integer(n).toString();
            this.xBDdata[n] = new BigDecimal(string);
        }
        for (n = 0; n < n2; ++n) {
            this.yData[n] = n;
            string = new Integer(n).toString();
            this.yBDdata[n] = new BigDecimal(string);
        }
        for (n = 0; n < n2; ++n) {
            for (int j = 0; j < n3; ++j) {
                this.zData[n][j] = bigIntegerArray[n][j].doubleValue();
                this.zBDdata[n][j] = new BigDecimal(bigIntegerArray[n][j]);
            }
        }
        this.polyIndices();
        this.check();
    }

    public SurfaceSmooth(double[] dArray, double[] dArray2, Matrix matrix) {
        this.xData = dArray;
        this.yData = dArray2;
        this.zData = matrix.getArrayCopy();
        this.polyIndices();
        this.check();
        this.ascend();
    }

    public SurfaceSmooth(Matrix matrix) {
        int n;
        this.zData = matrix.getArrayCopy();
        int n2 = this.zData.length;
        int n3 = this.zData[0].length;
        for (n = 0; n < n3; ++n) {
            this.xData[n] = n;
        }
        for (n = 0; n < n2; ++n) {
            this.yData[n] = n;
        }
        this.polyIndices();
        this.polyIndices();
        this.check();
        this.ascend();
    }

    public SurfaceSmooth() {
    }

    private void polyIndices() {
        int n;
        this.nSGcoeff = 0;
        for (n = 1; n <= this.sgPolyDeg + 1; ++n) {
            this.nSGcoeff += n;
        }
        this.sgCoeffIndices = new int[this.nSGcoeff][2];
        n = 0;
        for (int j = 0; j <= this.sgPolyDeg; ++j) {
            int n2 = 0;
            while (n2 <= this.sgPolyDeg - j) {
                this.sgCoeffIndices[n][0] = j;
                this.sgCoeffIndices[n++][1] = n2++;
            }
        }
    }

    private void check() {
        this.nPointsY = this.yData.length;
        this.nPointsX = this.xData.length;
        this.nPoints = this.nPointsX * this.nPointsY;
        int n = this.zData.length;
        int n2 = this.zData[0].length;
        if (this.nPointsX == n2) {
            if (this.nPointsY != n) {
                throw new IllegalArgumentException("The lengths of the x data arrays, " + this.nPointsX + " and " + this.nPointsY + ", do not match the dimensions of the  y data matrix, " + n + " and " + n2);
            }
        } else if (this.nPointsY == n2) {
            if (this.nPointsX != n) {
                throw new IllegalArgumentException("The lengths of the x data arrays, " + this.nPointsX + " and " + this.nPointsY + ", do not match the dimensions of the  y data matrix, " + n + " and " + n2);
            }
            this.zData = this.transpose(this.zData);
            System.out.println("zData transposed to match the dimensions of the xData and yData");
        }
        if (!this.arbprec) {
            int n3;
            this.xBDdata = new BigDecimal[this.nPointsX];
            this.yBDdata = new BigDecimal[this.nPointsY];
            for (n3 = 0; n3 < this.nPointsX; ++n3) {
                this.xBDdata[n3] = new BigDecimal(new Double(this.xData[n3]).toString());
            }
            for (n3 = 0; n3 < this.nPointsY; ++n3) {
                this.yBDdata[n3] = new BigDecimal(new Double(this.yData[n3]).toString());
            }
        }
    }

    private double[][] transpose(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n2][n];
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                dArray2[k][j] = dArray[j][k];
            }
        }
        return dArray2;
    }

    private void ascend() {
        int n;
        int n2;
        BigDecimal[][] bigDecimalArray;
        BigDecimal[] bigDecimalArray2;
        double[][] dArray;
        double[] dArray2;
        int[] nArray;
        ArrayMaths arrayMaths;
        boolean bl = true;
        boolean bl2 = true;
        int n3 = 1;
        while (bl) {
            if (this.yData[n3] < this.yData[n3 - 1]) {
                bl = false;
                bl2 = false;
                continue;
            }
            if (++n3 < this.nPointsY) continue;
            bl = false;
        }
        if (!bl2) {
            arrayMaths = new ArrayMaths(this.yData);
            arrayMaths = arrayMaths.sort();
            nArray = arrayMaths.originalIndices();
            dArray2 = new double[this.nPointsY];
            dArray = new double[this.nPointsY][this.nPointsX];
            bigDecimalArray2 = new BigDecimal[this.nPointsY];
            bigDecimalArray = null;
            if (this.arbprec) {
                bigDecimalArray = new BigDecimal[this.nPointsY][this.nPointsX];
            }
            for (n2 = 0; n2 < this.nPointsY; ++n2) {
                dArray2[n2] = this.yData[nArray[n2]];
                bigDecimalArray2[n2] = this.yBDdata[nArray[n2]];
                for (n = 0; n < this.nPointsX; ++n) {
                    dArray[n2][n] = this.zData[nArray[n2]][n];
                    if (!this.arbprec) continue;
                    bigDecimalArray[n2][n] = this.zBDdata[nArray[n2]][n];
                }
            }
            for (n2 = 0; n2 < this.nPointsY; ++n2) {
                this.yData[n2] = dArray2[n2];
                this.yBDdata[n2] = bigDecimalArray2[n2];
                for (n = 0; n < this.nPointsX; ++n) {
                    this.zData[n2][n] = dArray[n2][n];
                    if (!this.arbprec) continue;
                    this.zBDdata[n2][n] = bigDecimalArray[n2][n];
                }
            }
        }
        bl = true;
        bl2 = true;
        n3 = 1;
        while (bl) {
            if (this.xData[n3] < this.xData[n3 - 1]) {
                bl = false;
                bl2 = false;
                continue;
            }
            if (++n3 < this.nPointsX) continue;
            bl = false;
        }
        if (!bl2) {
            arrayMaths = new ArrayMaths(this.xData);
            arrayMaths = arrayMaths.sort();
            nArray = arrayMaths.originalIndices();
            dArray2 = new double[this.nPointsX];
            dArray = new double[this.nPointsY][this.nPointsX];
            bigDecimalArray2 = new BigDecimal[this.nPointsX];
            bigDecimalArray = null;
            if (this.arbprec) {
                bigDecimalArray = new BigDecimal[this.nPointsY][this.nPointsX];
            }
            for (n2 = 0; n2 < this.nPointsX; ++n2) {
                dArray2[n2] = this.xData[nArray[n2]];
                bigDecimalArray2[n2] = this.xBDdata[nArray[n2]];
                for (n = 0; n < this.nPointsY; ++n) {
                    dArray[n][n2] = this.zData[n][nArray[n2]];
                    if (!this.arbprec) continue;
                    bigDecimalArray[n][n2] = this.zBDdata[n][nArray[n2]];
                }
            }
            for (n2 = 0; n2 < this.nPointsX; ++n2) {
                this.xData[n2] = dArray2[n2];
                this.xBDdata[n2] = bigDecimalArray2[n2];
                for (n = 0; n < this.nPointsY; ++n) {
                    this.zData[n][n2] = dArray[n][n2];
                    if (!this.arbprec) continue;
                    this.zBDdata[n][n2] = bigDecimalArray[n][n2];
                }
            }
        }
    }

    public double[][] movingAverage(int n, int n2) {
        this.lastMethod = 1;
        this.zDataMovAv = new double[this.nPointsY][this.nPointsX];
        this.zDataMovAvBD = new BigDecimal[this.nPointsY][this.nPointsX];
        this.maWindowWidthx = this.windowLength(n);
        int n3 = (this.maWindowWidthx - 1) / 2;
        this.maWindowWidthy = this.windowLength(n2);
        int n4 = (this.maWindowWidthy - 1) / 2;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (int j = 0; j < this.nPointsX; ++j) {
            n5 = j >= n3 ? j - n3 : 0;
            n6 = j <= this.nPointsX - n3 - 1 ? j + n3 : this.nPointsX - 1;
            int n9 = n6 - n5 + 1;
            for (int k = 0; k < this.nPointsY; ++k) {
                n7 = k >= n4 ? k - n4 : 0;
                n8 = k <= this.nPointsY - n4 - 1 ? k + n4 : this.nPointsY - 1;
                int n10 = n8 - n7 + 1;
                if (this.arbprec) {
                    BigDecimal bigDecimal = new BigDecimal("0.0");
                    for (int i2 = n5; i2 <= n6; ++i2) {
                        for (int i3 = n7; i3 <= n8; ++i3) {
                            bigDecimal = bigDecimal.add(this.zBDdata[i3][i2]);
                        }
                    }
                    String string = new Integer(n9 * n10).toString();
                    this.zDataMovAvBD[k][j] = bigDecimal.divide(new BigDecimal(string), 4);
                    this.zDataMovAv[k][j] = this.zDataMovAvBD[k][j].doubleValue();
                    continue;
                }
                double d = 0.0;
                for (int i4 = n5; i4 <= n6; ++i4) {
                    for (int i5 = n7; i5 <= n8; ++i5) {
                        d += this.zData[i5][i4];
                    }
                }
                this.zDataMovAv[k][j] = d / (double)(n9 * n10);
                String string = new Double(this.zDataMovAv[k][j]).toString();
                this.zDataMovAvBD[k][j] = new BigDecimal(string);
            }
        }
        this.bcsMovAv = new BiCubicSpline(this.yData, this.xData, this.zDataMovAv);
        this.calcMovAv = true;
        return Conv.copy(this.zDataMovAv);
    }

    public double[][] movingAverage(int n) {
        return this.movingAverage(n, n);
    }

    public BigDecimal[][] movingAverageAsBigDecimal(int n, int n2) {
        this.movingAverage(n, n2);
        return Conv.copy(this.zDataMovAvBD);
    }

    public BigDecimal[][] movingAverageAsBigDecimal(int n) {
        this.movingAverage(n, n);
        return Conv.copy(this.zDataMovAvBD);
    }

    private int windowLength(int n) {
        int n2 = 0;
        n2 = Fmath.isEven(n) ? n + 1 : n;
        return n2;
    }

    public double[][] savitzkyGolay(int n, int n2) {
        this.lastMethod = 2;
        this.zDataSavGol = new double[this.nPointsY][this.nPointsX];
        this.sgWindowWidthx = this.windowLength(n);
        this.sgWindowWidthy = this.windowLength(n2);
        this.savitzkyGolayCommon(this.sgWindowWidthx, this.sgWindowWidthy);
        this.bcsSavGol = new BiCubicSpline(this.yData, this.xData, Conv.copy(this.zDataSavGol));
        this.calcSavGol = true;
        return Conv.copy(this.zDataSavGol);
    }

    public double[][] savitzkyGolay(int n) {
        return this.savitzkyGolay(n, n);
    }

    private double[][] savitzkyGolayCommon(int n, int n2) {
        int n3 = (n - 1) / 2;
        int n4 = (n2 - 1) / 2;
        double[] dArray = this.savitzkyGolayFilter(n3, n3, n4, n4)[0];
        double[][] dArray2 = this.padData(this.zData, n3, n4);
        for (int j = n4; j < this.nPointsY + n4; ++j) {
            for (int k = n3; k < this.nPointsX + n3; ++k) {
                double d = 0.0;
                int n5 = 0;
                for (int i2 = j - n4; i2 <= j + n4; ++i2) {
                    for (int i3 = k - n3; i3 <= k + n3; ++i3) {
                        d += dArray2[i2][i3] * dArray[n5++];
                    }
                }
                this.zDataSavGol[j - n4][k - n3] = d;
            }
        }
        return this.zDataSavGol;
    }

    private double[][] padData(double[][] dArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = dArray.length;
        int n6 = dArray[0].length;
        double[][] dArray2 = new double[n5 + 2 * n2][n6 + 2 * n];
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                dArray2[n4 + n2][n3 + n] = dArray[n4][n3];
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            for (n3 = n; n3 < n6 + n; ++n3) {
                dArray2[n4][n3] = dArray2[n2][n3];
            }
        }
        for (n4 = 0; n4 < n; ++n4) {
            for (n3 = n2; n3 < n5 + n2; ++n3) {
                dArray2[n3][n4] = dArray2[n3][n];
            }
        }
        for (n4 = n + n6; n4 < n6 + 2 * n; ++n4) {
            for (n3 = n2; n3 < n5 + n2; ++n3) {
                dArray2[n3][n4] = dArray2[n3][n + n6 - 1];
            }
        }
        for (n4 = n2 + n5; n4 < n5 + 2 * n2; ++n4) {
            for (n3 = n; n3 < n6 + n; ++n3) {
                dArray2[n4][n3] = dArray2[n5 + n2 - 1][n3];
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            for (n3 = 0; n3 < n; ++n3) {
                dArray2[n4][n3] = dArray2[n2][n];
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            for (n3 = n6 + n; n3 < n6 + 2 * n; ++n3) {
                dArray2[n4][n3] = dArray2[n2][n6 + n - 1];
            }
        }
        for (n4 = n5 + n2; n4 < n5 + 2 * n2; ++n4) {
            for (n3 = 0; n3 < n; ++n3) {
                dArray2[n4][n3] = dArray2[n5 + n2 - 1][n];
            }
        }
        for (n4 = n5 + n2; n4 < n5 + 2 * n2; ++n4) {
            for (n3 = n6 + n; n3 < n6 + 2 * n; ++n3) {
                dArray2[n4][n3] = dArray2[n5 + n2 - 1][n6 + n - 1];
            }
        }
        return dArray2;
    }

    public double[][][] savitzkyGolay(int n, int n2, int n3, int n4) {
        if (n4 + n3 > this.sgPolyDeg) {
            throw new IllegalArgumentException("The sum of the derivative orders " + n3 + " plus " + n4 + ", must be less than or equal to the polynomial degree, " + this.sgPolyDeg + ".");
        }
        this.lastMethod = 2;
        double[][][] dArray = new double[2][this.nPointsY][this.nPointsX];
        this.sgWindowWidthx = this.windowLength(n);
        int n5 = (this.sgWindowWidthx - 1) / 2;
        this.sgWindowWidthy = this.windowLength(n2);
        int n6 = (this.sgWindowWidthy - 1) / 2;
        if (!this.calcSavGol) {
            this.savitzkyGolay(n, n2);
        }
        dArray[0] = this.zDataSavGol;
        int n7 = 0;
        boolean bl = true;
        int n8 = this.sgCoeffIndices.length;
        while (bl) {
            if (this.sgCoeffIndices[n7][0] == n3 && this.sgCoeffIndices[n7][1] == n4) {
                bl = false;
            }
            if (++n7 < n8) continue;
            throw new IllegalArgumentException("It should not have been possible to reach this situation, m = " + n3 + ", n = " + n4);
        }
        double[] dArray2 = this.sgArrayC[n7];
        double[][] dArray3 = this.padData(this.zData, n5, n6);
        for (int j = n6; j < this.nPointsY + n6; ++j) {
            for (int k = n5; k < this.nPointsX + n5; ++k) {
                double d = 0.0;
                int n9 = 0;
                for (int i2 = j - n6; i2 <= j + n6; ++i2) {
                    for (int i3 = k - n5; i3 <= k + n5; ++i3) {
                        d += dArray3[i2][i3] * dArray2[n9++];
                    }
                }
                dArray[1][j - n6][k - n5] = d;
            }
        }
        this.derivSavGol = dArray[1];
        this.nthSet = true;
        return dArray;
    }

    public double[][] savitzkyGolayFilter(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n + n2 + 1;
        int n7 = n3 + n4 + 1;
        int n8 = n6 * n7;
        double[] dArray = new double[n8];
        int[][] nArray = new int[n8][2];
        int n9 = 0;
        for (int j = 0; j < n6; ++j) {
            for (n5 = 0; n5 < n7; ++n5) {
                nArray[n9][0] = j - n;
                nArray[n9++][1] = n5 - n3;
            }
        }
        double[][] dArray2 = new double[n8][this.nSGcoeff];
        for (n5 = 0; n5 < n8; ++n5) {
            for (int j = 0; j < this.nSGcoeff; ++j) {
                dArray2[n5][j] = Math.pow(nArray[n5][0], this.sgCoeffIndices[j][0]) * Math.pow(nArray[n5][1], this.sgCoeffIndices[j][1]);
            }
        }
        Matrix matrix = new Matrix(dArray2);
        Matrix matrix2 = matrix.transpose();
        Matrix matrix3 = matrix2.times(matrix);
        Matrix matrix4 = matrix3.inverse();
        Matrix matrix5 = matrix4.times(matrix2);
        this.sgArrayC = matrix5.getArrayCopy();
        return this.sgArrayC;
    }

    public static double[][] savitzkyGolayFilter(int n, int n2, int n3, int n4, int n5) {
        SurfaceSmooth surfaceSmooth = new SurfaceSmooth();
        surfaceSmooth.setSGpolyDegree(n5);
        return surfaceSmooth.savitzkyGolayFilter(n, n2, n3, n4);
    }

    public double[][] getSGcoefficients() {
        if (this.sgArrayC == null) {
            throw new IllegalArgumentException("No Savitzky-Golay coefficients have been calculated");
        }
        return this.sgArrayC;
    }

    public int[][] getSGPolyIndices() {
        return this.sgCoeffIndices;
    }

    public static int[][] filterIndices(int n) {
        SurfaceSmooth surfaceSmooth = new SurfaceSmooth();
        surfaceSmooth.setSGpolyDegree(n);
        return surfaceSmooth.getSGPolyIndices();
    }

    public void setSGpolyDegree(int n) {
        this.sgPolyDeg = n;
        this.polyIndices();
    }

    public int getSGpolyDegree() {
        return this.sgPolyDeg;
    }

    public double[][] getMovingAverageValues() {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        return Conv.copy(this.zDataMovAv);
    }

    public BigDecimal[][] getMovingAverageValuesAsBigDecimal() {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        return Conv.copy(this.zDataMovAvBD);
    }

    public double[][] getSavitzkyGolaySmoothedValues() {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        return Conv.copy(this.zDataSavGol);
    }

    public double[][] getSavitzkyDerivatives() {
        if (!this.nthSet) {
            throw new IllegalArgumentException("No Savitzky-Golay derivative smoothing method has been called");
        }
        return Conv.copy(this.derivSavGol);
    }

    public double extentMovingAverage() {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        this.extentMovAv = this.extent(this.zData, this.zDataMovAv);
        return this.extentMovAv;
    }

    public double extentSavitzkyGolay() {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        this.extentSavGol = this.extent(this.zData, this.zDataSavGol);
        return this.extentSavGol;
    }

    private double extent(double[][] dArray, double[][] dArray2) {
        ArrayMaths arrayMaths = new ArrayMaths((Object[])dArray);
        double d = arrayMaths.getMinimum();
        double d2 = arrayMaths.getMaximum();
        double d3 = d2 - d;
        double d4 = 0.0;
        for (int j = 0; j < this.nPointsX; ++j) {
            for (int k = 0; k < this.nPointsY; ++k) {
                d4 += Math.abs(dArray[k][j] - dArray2[k][j]) / d3;
            }
        }
        return d4 /= (double)this.nPoints;
    }

    public double interpolateSavitzkyGolay(double d, double d2) {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        return this.bcsSavGol.interpolate(d2, d);
    }

    public double interpolateMovingAverage(double d, double d2) {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        return this.bcsMovAv.interpolate(d2, d);
    }

    public void plotSavitzkyGolayX(int n) {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        if (n >= this.nPointsY) {
            throw new IllegalArgumentException("The index, " + n + ", must be less than the number of y values, " + this.nPointsY);
        }
        int n2 = 0;
        double d = Fmath.truncate(this.yData[n], this.trunc);
        this.commonPlot(n2, n, d);
    }

    public void plotSavitzkyGolayX(double d) {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        int n = 0;
        int n2 = this.findValue(this.yData, d);
        d = Fmath.truncate(this.yData[n2], this.trunc);
        this.commonPlot(n, n2, d);
    }

    public void plotSavitzkyGolayY(int n) {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        if (n >= this.nPointsX) {
            throw new IllegalArgumentException("The index, " + n + ", must be less than the number of x values, " + this.nPointsX);
        }
        int n2 = 1;
        double d = Fmath.truncate(this.xData[n], this.trunc);
        this.commonPlot(n2, n, d);
    }

    public void plotSavitzkyGolayY(double d) {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        int n = 1;
        int n2 = this.findValue(this.xData, d);
        d = Fmath.truncate(this.xData[n2], this.trunc);
        this.commonPlot(n, n2, d);
    }

    public void plotMovingAverageX(int n) {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        if (n >= this.nPointsY) {
            throw new IllegalArgumentException("The index, " + n + ", must be less than the number of y values, " + this.nPointsY);
        }
        int n2 = 2;
        double d = Fmath.truncate(this.yData[n], this.trunc);
        this.commonPlot(n2, n, d);
    }

    public void plotMovingAverageX(double d) {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        int n = 2;
        int n2 = this.findValue(this.yData, d);
        d = Fmath.truncate(this.yData[n2], this.trunc);
        this.commonPlot(n, n2, d);
    }

    public void plotMovingAverageY(int n) {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        if (n >= this.nPointsX) {
            throw new IllegalArgumentException("The index, " + n + ", must be less than the number of x values, " + this.nPointsX);
        }
        int n2 = 3;
        double d = Fmath.truncate(this.xData[n], this.trunc);
        this.commonPlot(n2, n, d);
    }

    public void plotMovingAverageY(double d) {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        int n = 3;
        int n2 = this.findValue(this.xData, d);
        d = Fmath.truncate(this.xData[n2], this.trunc);
        this.commonPlot(n, n2, d);
    }

    private int findValue(double[] dArray, double d) {
        int n = dArray.length;
        boolean bl = true;
        int n2 = 0;
        while (bl) {
            if (Fmath.isEqualWithinLimits(dArray[n2], d, Math.abs(d) * 0.001)) {
                bl = false;
                continue;
            }
            if (++n2 < n) continue;
            throw new IllegalArgumentException("The entered plot value, " + d + ",  must equal an entered data value");
        }
        return n2;
    }

    private void commonPlot(int n, int n2, double d) {
        String string = null;
        String string2 = null;
        String string3 = ",  Original data - circles,  Smoothed data - squares";
        String string4 = null;
        String string5 = null;
        int[] nArray = new int[]{0, this.nPointsX / 4, this.nPointsX / 2, 3 * this.nPointsX / 4, this.nPointsX - 1};
        int[] nArray2 = new int[]{0, this.nPointsY / 4, this.nPointsY / 2, 3 * this.nPointsY / 4, this.nPointsY - 1};
        double[][] dArrayArray = new double[8][];
        double[] dArray = new double[5];
        double[] dArray2 = new double[5];
        double[] dArray3 = new double[5];
        double[] dArray4 = new double[5];
        switch (n) {
            case 0: {
                int n3;
                string = "Savitzky-Golay smoothing with an x by y window of " + this.sgWindowWidthx + " by " + this.sgWindowWidthy + " points";
                string2 = "Plot of z versus x values for a y value of " + d + string3;
                string4 = "x values";
                string5 = "y values";
                dArrayArray[0] = this.xData;
                dArrayArray[1] = this.zData[n2];
                dArrayArray[2] = this.xData;
                dArrayArray[3] = this.zDataSavGol[n2];
                for (n3 = 0; n3 < 5; ++n3) {
                    dArray[n3] = this.xData[nArray[n3]];
                    dArray3[n3] = this.zData[n2][nArray[n3]];
                    dArray2[n3] = this.xData[nArray[n3]];
                    dArray4[n3] = this.zDataSavGol[n2][nArray[n3]];
                }
                break;
            }
            case 1: {
                int n3;
                string = "Savitzky-Golay smoothing with an x by y window of " + this.sgWindowWidthx + " by " + this.sgWindowWidthy + " points";
                string2 = "Plot of z versus y values for a x value of " + d + string3;
                string4 = "y values";
                string5 = "x values";
                dArrayArray[0] = this.yData;
                dArrayArray[2] = this.yData;
                dArrayArray[1] = new double[this.nPointsY];
                dArrayArray[3] = new double[this.nPointsY];
                for (n3 = 0; n3 < this.nPointsY; ++n3) {
                    dArrayArray[1][n3] = this.zData[n3][n2];
                    dArrayArray[3][n3] = this.zDataSavGol[n3][n2];
                }
                for (n3 = 0; n3 < 5; ++n3) {
                    dArray[n3] = this.yData[nArray2[n3]];
                    dArray3[n3] = dArrayArray[1][nArray2[n3]];
                    dArray2[n3] = this.yData[nArray2[n3]];
                    dArray4[n3] = dArrayArray[3][nArray2[n3]];
                }
                break;
            }
            case 2: {
                int n3;
                string = "Moving Average smoothing with an x by y window of " + this.sgWindowWidthx + " by " + this.sgWindowWidthy + " points";
                string2 = "Plot of z versus x values for a y value of " + d + string3;
                string4 = "x values";
                string5 = "y values";
                dArrayArray[0] = this.xData;
                dArrayArray[1] = this.zData[n2];
                dArrayArray[2] = this.xData;
                dArrayArray[3] = this.zDataMovAv[n2];
                for (n3 = 0; n3 < 5; ++n3) {
                    dArray[n3] = this.xData[nArray[n3]];
                    dArray3[n3] = this.zData[n2][nArray[n3]];
                    dArray2[n3] = this.xData[nArray[n3]];
                    dArray4[n3] = this.zDataMovAv[n2][nArray[n3]];
                }
                break;
            }
            case 3: {
                int n3;
                string = "Moving Average smoothing with an x by y window of " + this.sgWindowWidthx + " by " + this.sgWindowWidthy + " points";
                string2 = "Plot of z versus y values for a x value of " + d + string3;
                string4 = "y values";
                string5 = "x values";
                dArrayArray[0] = this.yData;
                dArrayArray[2] = this.yData;
                dArrayArray[1] = new double[this.nPointsY];
                dArrayArray[3] = new double[this.nPointsY];
                for (n3 = 0; n3 < this.nPointsY; ++n3) {
                    dArrayArray[1][n3] = this.zData[n3][n2];
                    dArrayArray[3][n3] = this.zDataMovAv[n3][n2];
                }
                for (n3 = 0; n3 < 5; ++n3) {
                    dArray[n3] = this.yData[nArray2[n3]];
                    dArray3[n3] = dArrayArray[1][nArray2[n3]];
                    dArray2[n3] = this.yData[nArray2[n3]];
                    dArray4[n3] = dArrayArray[3][nArray2[n3]];
                }
                break;
            }
        }
        dArrayArray[4] = dArray;
        dArrayArray[5] = dArray3;
        dArrayArray[6] = dArray2;
        dArrayArray[7] = dArray4;
        PlotGraph plotGraph = new PlotGraph(dArrayArray);
        int[] nArray3 = new int[]{0, 0, 1, 2};
        int[] nArray4 = new int[]{3, 3, 0, 0};
        plotGraph.setPoint(nArray3);
        plotGraph.setLine(nArray4);
        plotGraph.setGraphTitle(string);
        plotGraph.setGraphTitle2(string2);
        plotGraph.setXaxisLegend(string4);
        plotGraph.setYaxisLegend(string5);
        plotGraph.plot();
    }
}

