/*
 * Decompiled with CFR 0.152.
 */
package flanagan.circuits;

import flanagan.analysis.ErrorProp;
import flanagan.analysis.Regression;
import flanagan.analysis.RegressionFunction2;
import flanagan.analysis.Stat;
import flanagan.circuits.ImpedSpecModel;
import flanagan.circuits.ImpedSpecRegressionFunction1;
import flanagan.circuits.ImpedSpecRegressionFunction2;
import flanagan.circuits.Impedance;
import flanagan.complex.Complex;
import flanagan.complex.ComplexErrorProp;
import flanagan.io.FileOutput;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.plot.PlotGraph;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class ImpedSpecRegression
extends Regression {
    private String regressionTitle = null;
    private boolean fileType = false;
    private Complex appliedVoltage = null;
    private boolean appliedVoltageSet = false;
    private Complex appliedVoltageError = null;
    private boolean voltageErrorSet = false;
    private Complex referenceImpedance = null;
    private boolean referenceSet = false;
    private double[] frequencies = null;
    private double[] omegas = null;
    private double[] log10frequencies = null;
    private double[] log10omegas = null;
    private int numberOfFrequencies = 0;
    private boolean frequenciesSet = false;
    private Complex[] voltages = null;
    private Complex[] voltageWeights = null;
    private double[] voltageMagnitudes = null;
    private double[] voltageMagnitudeWeights = null;
    private double[] voltagePhasesRad = null;
    private double[] voltagePhaseWeightsRad = null;
    private double[] voltagePhasesDeg = null;
    private double[] voltagePhaseWeightsDeg = null;
    private double[] realV = null;
    private double[] realVweights = null;
    private double[] imagV = null;
    private double[] imagVweights = null;
    private boolean weightsSet = true;
    private int dataEnteredTypePointer = -1;
    private String[] dataEnteredType = new String[]{"Complex voltage (as real and imaginary parts)", "Complex voltage (as Complex)", "Voltage Magnitude and phase (in radians)", "Voltage Magnitude and phase (in degrees)", "Complex impedance (as real and imaginary parts)", "Complex impedance (as Complex)", "Magnitude and phase (in radians)", "Magnitude and phase (in degrees)"};
    private boolean voltageOrImpedance = true;
    private Complex[] impedances = null;
    private Complex[] impedanceWeights = null;
    private double[] impedanceMagnitudes = null;
    private double[] impedanceMagnitudeWeights = null;
    private double[] impedancePhasesRad = null;
    private double[] impedancePhaseWeightsRad = null;
    private double[] impedancePhasesDeg = null;
    private double[] impedancePhaseWeightsDeg = null;
    private double[] realZ = null;
    private double[] realZweights = null;
    private double[] imagZ = null;
    private double[] imagZweights = null;
    private boolean impedancesSet = false;
    private double[] xRegression = null;
    private double[][] yRegression = null;
    private double[][] wRegression = null;
    private int modelNumber = 0;
    private int numberOfParameters = 0;
    private String[] parameterSymbols = null;
    private boolean modelSet = false;
    private boolean estimatesNeeded = false;
    private boolean supressDefaultConstraints = false;
    private boolean supressAddedConstraints = false;
    private boolean supressAllConstraints = false;
    private ArrayList<Object> constraints = null;
    private int numberOfAddedConstraints = -1;
    private boolean constraintsAdded = false;
    private double[] initialEstimates = null;
    private double[] initialSteps = null;
    private double[] bestEstimates = null;
    private double[] standardDeviations = null;
    private double[] coefficientsOfVariation = null;
    private double[][] correlationCoefficients = null;
    private double[] preMinimumGradients = null;
    private double[] postMinimumGradients = null;
    private int degreesOfFreedom = 0;
    private double sumOfSquares = 0.0;
    private double reducedSumOfSquares = 0.0;
    private double chiSquare = Double.NaN;
    private double reducedChiSquare = Double.NaN;
    private double[] realZresiduals = null;
    private double[] imagZresiduals = null;
    private double[] calculatedRealZ = null;
    private double[] calculatedImagZ = null;
    private Complex[] calculatedImpedances = null;
    private double[] calculatedImpedanceMagnitudes = null;
    private double[] calculatedImpedancePhasesRad = null;
    private double[] calculatedImpedancePhasesDeg = null;
    private double[] calculatedRealV = null;
    private double[] calculatedImagV = null;
    private Complex[] calculatedVoltages = null;
    private double[] calculatedVoltageMagnitudes = null;
    private double[] calculatedVoltagePhasesRad = null;
    private double[] calculatedVoltagePhasesDeg = null;
    ArrayList<Object> results = null;
    private boolean estimatesSet = false;
    private ImpedSpecModel userModel = null;
    private boolean userModelSet = false;
    private RegressionFunction2 regressionFunction = null;
    private double tolerance = 1.0E-9;
    private int maximumIterations = 10000;
    private int numberOfIterations1 = -1;
    private int numberOfIterations2 = -1;
    private boolean regressionDone = false;
    private int numberOfLineFrequencies = 8000;
    private boolean logOrLinear = true;
    private double[] lineFrequencies = null;
    private double[] log10lineFrequencies = null;

    public ImpedSpecRegression() {
        this.regressionTitle = "  ";
    }

    public ImpedSpecRegression(String string) {
        this.regressionTitle = string;
    }

    public void setAppliedVoltage(double d) {
        this.appliedVoltage = new Complex(d, 0.0);
        this.appliedVoltageError = new Complex(0.0, 0.0);
        this.appliedVoltageSet = true;
        if (this.referenceSet && this.frequenciesSet) {
            this.calculateExperimentalImpedances();
        }
    }

    public void appliedVoltage(double d, double d2) {
        this.appliedVoltage = new Complex(d, 0.0);
        this.appliedVoltageSet = true;
        this.appliedVoltage = new Complex(d2, 0.0);
        this.voltageErrorSet = true;
        if (this.referenceSet && this.frequenciesSet) {
            this.calculateExperimentalImpedances();
        }
    }

    public void setReferenceImpedance(double d) {
        this.referenceImpedance = new Complex(d, 0.0);
        this.referenceSet = true;
        if (this.appliedVoltageSet && this.frequenciesSet) {
            this.calculateExperimentalImpedances();
        }
    }

    public void setReferenceImpedance(double d, double d2) {
        this.referenceImpedance = new Complex(d, d2);
        this.referenceSet = true;
        if (this.appliedVoltageSet && this.frequenciesSet) {
            this.calculateExperimentalImpedances();
        }
    }

    public void setReferenceImpedance(Complex complex) {
        this.referenceImpedance = complex;
        this.referenceSet = true;
        if (this.appliedVoltageSet && this.frequenciesSet) {
            this.calculateExperimentalImpedances();
        }
    }

    public void voltageDataAsComplex(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[dArray.length];
        double[] dArray5 = new double[dArray.length];
        this.weightsSet = false;
        this.voltageDataAsComplex(dArray, dArray2, dArray3, dArray4, dArray5);
    }

    public void voltageDataAsComplex(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        this.numberOfFrequencies = dArray.length;
        if (this.numberOfFrequencies != dArray2.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of Real[voltages], " + dArray2.length);
        }
        if (this.numberOfFrequencies != dArray3.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of Imag[voltages], " + dArray3.length);
        }
        if (this.numberOfFrequencies != dArray4.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of real weights, " + dArray4.length);
        }
        if (this.numberOfFrequencies != dArray5.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of imag weights, " + dArray5.length);
        }
        this.frequencies = Conv.copy(dArray);
        this.setAllFrequencyArrays();
        this.setCalculatedArrayLengths();
        this.realV = Conv.copy(dArray2);
        this.imagV = Conv.copy(dArray3);
        this.realVweights = Conv.copy(dArray4);
        this.imagVweights = Conv.copy(dArray5);
        this.voltageMagnitudes = new double[this.numberOfFrequencies];
        this.voltagePhasesDeg = new double[this.numberOfFrequencies];
        this.voltagePhasesRad = new double[this.numberOfFrequencies];
        this.voltages = Complex.oneDarray(this.numberOfFrequencies);
        for (int j = 0; j < this.numberOfFrequencies; ++j) {
            this.voltages[j] = new Complex(this.realV[j], this.imagV[j]);
            this.voltageMagnitudes[j] = this.voltages[j].abs();
            this.voltagePhasesRad[j] = this.voltages[j].arg();
            this.voltagePhasesDeg[j] = Math.toDegrees(this.voltagePhasesRad[j]);
        }
        this.frequenciesSet = true;
        this.setImpedanceArrayLengths();
        this.calculateExperimentalImpedances();
        this.dataEnteredTypePointer = 4;
        this.voltageOrImpedance = true;
        if (this.estimatesNeeded) {
            this.setInitialEstimates();
        }
    }

    public void voltageDataAsComplex(double[] dArray, Complex[] complexArray) {
        Complex[] complexArray2 = Complex.oneDarray(complexArray.length, 0.0, 0.0);
        this.weightsSet = false;
        this.voltageDataAsComplex(dArray, complexArray, complexArray2);
    }

    public void voltageDataAsComplex(double[] dArray, Complex[] complexArray, Complex[] complexArray2) {
        this.numberOfFrequencies = dArray.length;
        if (this.numberOfFrequencies != complexArray.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of voltages, " + complexArray.length);
        }
        if (this.numberOfFrequencies != complexArray2.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of weights, " + complexArray2.length);
        }
        this.frequencies = Conv.copy(dArray);
        this.setAllFrequencyArrays();
        this.setCalculatedArrayLengths();
        this.voltages = Complex.copy(complexArray);
        this.voltageWeights = Complex.copy(complexArray2);
        this.voltageMagnitudes = new double[this.numberOfFrequencies];
        this.voltagePhasesDeg = new double[this.numberOfFrequencies];
        this.voltagePhasesRad = new double[this.numberOfFrequencies];
        this.realV = new double[this.numberOfFrequencies];
        this.imagV = new double[this.numberOfFrequencies];
        this.realVweights = new double[this.numberOfFrequencies];
        this.imagVweights = new double[this.numberOfFrequencies];
        for (int j = 0; j < this.numberOfFrequencies; ++j) {
            this.realV[j] = this.voltages[j].getReal();
            this.imagV[j] = this.voltages[j].getImag();
            this.realVweights[j] = complexArray2[j].getReal();
            this.imagVweights[j] = complexArray2[j].getImag();
            this.voltageMagnitudes[j] = this.voltages[j].abs();
            this.voltagePhasesRad[j] = this.voltages[j].arg();
            this.voltagePhasesDeg[j] = Math.toDegrees(this.voltagePhasesRad[j]);
        }
        this.frequenciesSet = true;
        this.setImpedanceArrayLengths();
        this.calculateExperimentalImpedances();
        this.voltageOrImpedance = true;
        this.dataEnteredTypePointer = 1;
        if (this.estimatesNeeded) {
            this.setInitialEstimates();
        }
    }

    public void voltageDataAsPhasorRad(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[dArray.length];
        double[] dArray5 = new double[dArray.length];
        this.weightsSet = false;
        this.voltageDataAsPhasorRad(dArray, dArray2, dArray3, dArray4, dArray5);
    }

    public void voltageDataAsPhasorRad(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        this.numberOfFrequencies = dArray.length;
        if (this.numberOfFrequencies != dArray2.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of magnitudes, " + dArray2.length);
        }
        if (this.numberOfFrequencies != dArray3.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of phases, " + dArray3.length);
        }
        if (this.numberOfFrequencies != dArray4.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of magnitude weights, " + dArray4.length);
        }
        if (this.numberOfFrequencies != dArray5.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of phase weights, " + dArray5.length);
        }
        this.frequencies = Conv.copy(dArray);
        this.setAllFrequencyArrays();
        this.setCalculatedArrayLengths();
        this.voltageMagnitudes = Conv.copy(dArray2);
        this.voltageMagnitudeWeights = Conv.copy(dArray4);
        this.voltagePhaseWeightsRad = Conv.copy(dArray5);
        this.voltages = Complex.oneDarray(this.numberOfFrequencies);
        this.voltagePhasesDeg = new double[this.numberOfFrequencies];
        this.realV = new double[this.numberOfFrequencies];
        this.imagV = new double[this.numberOfFrequencies];
        this.realVweights = new double[this.numberOfFrequencies];
        this.imagVweights = new double[this.numberOfFrequencies];
        for (int j = 0; j < this.numberOfFrequencies; ++j) {
            this.voltagePhasesDeg[j] = Math.toDegrees(this.voltagePhasesRad[j]);
            this.voltages[j].polar(dArray2[j], dArray3[j]);
            this.realV[j] = this.voltages[j].getReal();
            this.imagV[j] = this.voltages[j].getImag();
            ErrorProp errorProp = new ErrorProp(dArray2[j], this.voltageMagnitudeWeights[j]);
            ErrorProp errorProp2 = new ErrorProp(dArray3[j], dArray5[j]);
            ComplexErrorProp complexErrorProp = new ComplexErrorProp();
            complexErrorProp.polar(errorProp, errorProp2);
            this.realVweights[j] = complexErrorProp.getRealError();
            this.imagVweights[j] = complexErrorProp.getImagError();
        }
        this.frequenciesSet = true;
        this.setImpedanceArrayLengths();
        this.calculateExperimentalImpedances();
        this.voltageOrImpedance = true;
        this.dataEnteredTypePointer = 2;
        if (this.estimatesNeeded) {
            this.setInitialEstimates();
        }
    }

    public void voltageDataAsPhasorDeg(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[dArray.length];
        double[] dArray5 = new double[dArray.length];
        this.weightsSet = false;
        this.voltageDataAsPhasorDeg(dArray, dArray2, dArray3, dArray4, dArray5);
    }

    public void voltageDataAsPhasorDeg(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        this.numberOfFrequencies = dArray.length;
        if (this.numberOfFrequencies != dArray2.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of magnitudes, " + dArray2.length);
        }
        if (this.numberOfFrequencies != dArray3.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of phases, " + dArray3.length);
        }
        if (this.numberOfFrequencies != dArray4.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of magnitude weights, " + dArray4.length);
        }
        if (this.numberOfFrequencies != dArray5.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of phase weights, " + dArray5.length);
        }
        this.frequencies = Conv.copy(dArray);
        this.setAllFrequencyArrays();
        this.setCalculatedArrayLengths();
        this.voltageMagnitudes = Conv.copy(dArray2);
        this.voltagePhasesDeg = Conv.copy(dArray3);
        this.voltages = Complex.oneDarray(this.numberOfFrequencies);
        this.voltagePhasesRad = new double[this.numberOfFrequencies];
        this.voltagePhaseWeightsRad = new double[this.numberOfFrequencies];
        this.voltageMagnitudeWeights = Conv.copy(dArray4);
        this.voltagePhaseWeightsDeg = Conv.copy(dArray5);
        this.realV = new double[this.numberOfFrequencies];
        this.imagV = new double[this.numberOfFrequencies];
        this.realVweights = new double[this.numberOfFrequencies];
        this.imagVweights = new double[this.numberOfFrequencies];
        for (int j = 0; j < this.numberOfFrequencies; ++j) {
            this.voltagePhasesRad[j] = Math.toRadians(this.voltagePhasesDeg[j]);
            this.voltagePhaseWeightsRad[j] = Math.toRadians(dArray5[j]);
            this.voltages[j].polar(dArray2[j], this.voltagePhasesRad[j]);
            this.realV[j] = this.voltages[j].getReal();
            this.imagV[j] = this.voltages[j].getImag();
            ErrorProp errorProp = new ErrorProp(dArray2[j], this.voltageMagnitudeWeights[j]);
            ErrorProp errorProp2 = new ErrorProp(this.voltagePhasesRad[j], this.voltagePhaseWeightsRad[j]);
            ComplexErrorProp complexErrorProp = new ComplexErrorProp();
            complexErrorProp.polar(errorProp, errorProp2);
            this.realVweights[j] = complexErrorProp.getRealError();
            this.imagVweights[j] = complexErrorProp.getImagError();
        }
        this.frequenciesSet = true;
        this.setImpedanceArrayLengths();
        this.calculateExperimentalImpedances();
        this.voltageOrImpedance = true;
        this.dataEnteredTypePointer = 3;
        if (this.estimatesNeeded) {
            this.setInitialEstimates();
        }
    }

    public void impedanceDataAsComplex(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[dArray.length];
        double[] dArray5 = new double[dArray.length];
        this.weightsSet = false;
        this.impedanceDataAsComplex(dArray, dArray2, dArray3, dArray4, dArray5);
    }

    public void impedanceDataAsComplex(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        this.numberOfFrequencies = dArray.length;
        if (this.numberOfFrequencies != dArray2.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of Real[impedances], " + dArray2.length);
        }
        if (this.numberOfFrequencies != dArray3.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of Imag[impedances], " + dArray3.length);
        }
        if (this.numberOfFrequencies != dArray4.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of real weights, " + dArray4.length);
        }
        if (this.numberOfFrequencies != dArray5.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of imag weights, " + dArray5.length);
        }
        this.frequencies = Conv.copy(dArray);
        this.setAllFrequencyArrays();
        this.setCalculatedArrayLengths();
        this.realZ = Conv.copy(dArray2);
        this.imagZ = Conv.copy(dArray3);
        this.realZweights = Conv.copy(dArray4);
        this.imagZweights = Conv.copy(dArray5);
        this.impedanceMagnitudes = new double[this.numberOfFrequencies];
        this.impedancePhasesDeg = new double[this.numberOfFrequencies];
        this.impedancePhasesRad = new double[this.numberOfFrequencies];
        this.impedances = Complex.oneDarray(this.numberOfFrequencies);
        for (int j = 0; j < this.numberOfFrequencies; ++j) {
            this.impedances[j] = new Complex(this.realZ[j], this.imagZ[j]);
            this.impedanceMagnitudes[j] = this.impedances[j].abs();
            this.impedancePhasesRad[j] = this.impedances[j].arg();
            this.impedancePhasesDeg[j] = Math.toDegrees(this.impedancePhasesRad[j]);
        }
        this.frequenciesSet = true;
        this.impedancesSet = true;
        this.dataEnteredTypePointer = 4;
        this.voltageOrImpedance = false;
        if (this.estimatesNeeded) {
            this.setInitialEstimates();
        }
    }

    public void impedanceDataAsComplex(double[] dArray, Complex[] complexArray) {
        Complex[] complexArray2 = Complex.oneDarray(complexArray.length, 0.0, 0.0);
        this.weightsSet = false;
        this.impedanceDataAsComplex(dArray, complexArray, complexArray2);
    }

    public void impedanceDataAsComplex(double[] dArray, Complex[] complexArray, Complex[] complexArray2) {
        this.numberOfFrequencies = dArray.length;
        if (this.numberOfFrequencies != complexArray.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of impedances, " + complexArray.length);
        }
        if (this.numberOfFrequencies != complexArray2.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of weights, " + complexArray2.length);
        }
        this.frequencies = Conv.copy(dArray);
        this.setAllFrequencyArrays();
        this.setCalculatedArrayLengths();
        this.impedances = Complex.copy(complexArray);
        this.impedanceWeights = Complex.copy(complexArray2);
        this.impedanceMagnitudes = new double[this.numberOfFrequencies];
        this.impedancePhasesDeg = new double[this.numberOfFrequencies];
        this.impedancePhasesRad = new double[this.numberOfFrequencies];
        this.realZ = new double[this.numberOfFrequencies];
        this.imagZ = new double[this.numberOfFrequencies];
        this.realZweights = new double[this.numberOfFrequencies];
        this.imagZweights = new double[this.numberOfFrequencies];
        for (int j = 0; j < this.numberOfFrequencies; ++j) {
            this.realZ[j] = this.impedances[j].getReal();
            this.imagZ[j] = this.impedances[j].getImag();
            this.realZweights[j] = complexArray2[j].getReal();
            this.imagZweights[j] = complexArray2[j].getImag();
            this.impedanceMagnitudes[j] = this.impedances[j].abs();
            this.impedancePhasesRad[j] = this.impedances[j].arg();
            this.impedancePhasesDeg[j] = Math.toDegrees(this.impedancePhasesRad[j]);
        }
        this.frequenciesSet = true;
        this.impedancesSet = true;
        this.voltageOrImpedance = false;
        this.dataEnteredTypePointer = 5;
        if (this.estimatesNeeded) {
            this.setInitialEstimates();
        }
    }

    public void impedanceDataAsPhasorRad(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[dArray.length];
        double[] dArray5 = new double[dArray.length];
        this.weightsSet = false;
        this.impedanceDataAsPhasorRad(dArray, dArray2, dArray3, dArray4, dArray5);
    }

    public void impedanceDataAsPhasorRad(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        this.numberOfFrequencies = dArray.length;
        if (this.numberOfFrequencies != dArray2.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of magnitudes, " + dArray2.length);
        }
        if (this.numberOfFrequencies != dArray3.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of phases, " + dArray3.length);
        }
        if (this.numberOfFrequencies != dArray4.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of magnitude weights, " + dArray4.length);
        }
        if (this.numberOfFrequencies != dArray5.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of phase weights, " + dArray5.length);
        }
        this.frequencies = Conv.copy(dArray);
        this.setAllFrequencyArrays();
        this.setCalculatedArrayLengths();
        this.impedanceMagnitudes = Conv.copy(dArray2);
        this.impedanceMagnitudeWeights = Conv.copy(dArray4);
        this.impedancePhaseWeightsRad = Conv.copy(dArray5);
        this.impedances = Complex.oneDarray(this.numberOfFrequencies);
        this.impedancePhasesDeg = new double[this.numberOfFrequencies];
        this.realZ = new double[this.numberOfFrequencies];
        this.imagZ = new double[this.numberOfFrequencies];
        this.realZweights = new double[this.numberOfFrequencies];
        this.imagZweights = new double[this.numberOfFrequencies];
        for (int j = 0; j < this.numberOfFrequencies; ++j) {
            this.impedancePhasesDeg[j] = Math.toDegrees(this.impedancePhasesRad[j]);
            this.impedances[j].polar(dArray2[j], dArray3[j]);
            this.realZ[j] = this.impedances[j].getReal();
            this.imagZ[j] = this.impedances[j].getImag();
            ErrorProp errorProp = new ErrorProp(dArray2[j], this.impedanceMagnitudeWeights[j]);
            ErrorProp errorProp2 = new ErrorProp(dArray3[j], dArray5[j]);
            ComplexErrorProp complexErrorProp = new ComplexErrorProp();
            complexErrorProp.polar(errorProp, errorProp2);
            this.realZweights[j] = complexErrorProp.getRealError();
            this.imagZweights[j] = complexErrorProp.getImagError();
        }
        this.frequenciesSet = true;
        this.impedancesSet = true;
        this.voltageOrImpedance = false;
        this.dataEnteredTypePointer = 6;
        if (this.estimatesNeeded) {
            this.setInitialEstimates();
        }
    }

    public void impedanceDataAsPhasorDeg(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[dArray.length];
        double[] dArray5 = new double[dArray.length];
        this.weightsSet = false;
        this.impedanceDataAsPhasorDeg(dArray, dArray2, dArray3, dArray4, dArray5);
    }

    public void impedanceDataAsPhasorDeg(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        this.numberOfFrequencies = dArray.length;
        if (this.numberOfFrequencies != dArray2.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of magnitudes, " + dArray2.length);
        }
        if (this.numberOfFrequencies != dArray3.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of phases, " + dArray3.length);
        }
        if (this.numberOfFrequencies != dArray4.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of magnitude weights, " + dArray4.length);
        }
        if (this.numberOfFrequencies != dArray5.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of phase weights, " + dArray5.length);
        }
        this.frequencies = Conv.copy(dArray);
        this.setAllFrequencyArrays();
        this.setCalculatedArrayLengths();
        this.impedanceMagnitudes = Conv.copy(dArray2);
        this.impedancePhasesDeg = Conv.copy(dArray3);
        this.impedances = Complex.oneDarray(this.numberOfFrequencies);
        this.impedancePhasesRad = new double[this.numberOfFrequencies];
        this.impedancePhaseWeightsRad = new double[this.numberOfFrequencies];
        this.impedanceMagnitudeWeights = Conv.copy(dArray4);
        this.impedancePhaseWeightsDeg = Conv.copy(dArray5);
        this.realZ = new double[this.numberOfFrequencies];
        this.imagZ = new double[this.numberOfFrequencies];
        this.realZweights = new double[this.numberOfFrequencies];
        this.imagZweights = new double[this.numberOfFrequencies];
        for (int j = 0; j < this.numberOfFrequencies; ++j) {
            this.impedancePhasesRad[j] = Math.toRadians(this.impedancePhasesDeg[j]);
            this.impedancePhaseWeightsRad[j] = Math.toRadians(dArray5[j]);
            this.impedances[j].polar(dArray2[j], this.impedancePhasesRad[j]);
            this.realZ[j] = this.impedances[j].getReal();
            this.imagZ[j] = this.impedances[j].getImag();
            ErrorProp errorProp = new ErrorProp(dArray2[j], this.impedanceMagnitudeWeights[j]);
            ErrorProp errorProp2 = new ErrorProp(this.impedancePhasesRad[j], this.impedancePhaseWeightsRad[j]);
            ComplexErrorProp complexErrorProp = new ComplexErrorProp();
            complexErrorProp.polar(errorProp, errorProp2);
            this.realZweights[j] = complexErrorProp.getRealError();
            this.imagZweights[j] = complexErrorProp.getImagError();
        }
        this.frequenciesSet = true;
        this.impedancesSet = true;
        this.voltageOrImpedance = false;
        this.dataEnteredTypePointer = 7;
        if (this.estimatesNeeded) {
            this.setInitialEstimates();
        }
    }

    private void setAllFrequencyArrays() {
        this.log10frequencies = new double[this.numberOfFrequencies];
        this.omegas = new double[this.numberOfFrequencies];
        this.log10omegas = new double[this.numberOfFrequencies];
        for (int j = 0; j < this.numberOfFrequencies; ++j) {
            this.log10frequencies[j] = Math.log10(this.frequencies[j]);
            this.omegas[j] = Math.PI * 2 * this.frequencies[j];
            this.log10omegas[j] = Math.log10(this.omegas[j]);
        }
        this.frequenciesSet = true;
    }

    private void setCalculatedArrayLengths() {
        this.realZresiduals = new double[this.numberOfFrequencies];
        this.imagZresiduals = new double[this.numberOfFrequencies];
        this.calculatedRealZ = new double[this.numberOfFrequencies];
        this.calculatedImagZ = new double[this.numberOfFrequencies];
        this.calculatedImpedances = Complex.oneDarray(this.numberOfFrequencies);
        this.calculatedImpedanceMagnitudes = new double[this.numberOfFrequencies];
        this.calculatedImpedancePhasesRad = new double[this.numberOfFrequencies];
        this.calculatedImpedancePhasesDeg = new double[this.numberOfFrequencies];
        if (this.appliedVoltageSet && this.referenceSet) {
            this.calculatedRealV = new double[this.numberOfFrequencies];
            this.calculatedImagV = new double[this.numberOfFrequencies];
            this.calculatedVoltages = Complex.oneDarray(this.numberOfFrequencies);
            this.calculatedVoltageMagnitudes = new double[this.numberOfFrequencies];
            this.calculatedVoltagePhasesRad = new double[this.numberOfFrequencies];
            this.calculatedVoltagePhasesDeg = new double[this.numberOfFrequencies];
        }
    }

    private void setImpedanceArrayLengths() {
        this.realZ = new double[this.numberOfFrequencies];
        this.imagZ = new double[this.numberOfFrequencies];
        this.realZweights = new double[this.numberOfFrequencies];
        this.imagZweights = new double[this.numberOfFrequencies];
        this.impedances = Complex.oneDarray(this.numberOfFrequencies);
        this.impedanceMagnitudes = new double[this.numberOfFrequencies];
        this.impedancePhasesRad = new double[this.numberOfFrequencies];
        this.impedancePhasesDeg = new double[this.numberOfFrequencies];
    }

    private void calculateExperimentalImpedances() {
        if (this.referenceSet && this.appliedVoltageSet) {
            for (int j = 0; j < this.numberOfFrequencies; ++j) {
                this.impedances[j] = this.referenceImpedance.times(this.voltages[j]).over(this.appliedVoltage.minus(this.voltages[j]));
                this.realZ[j] = this.impedances[j].getReal();
                this.imagZ[j] = this.impedances[j].getImag();
                this.impedanceMagnitudes[j] = this.impedances[j].abs();
                this.impedancePhasesRad[j] = this.impedances[j].arg();
                this.impedancePhasesDeg[j] = Math.toDegrees(this.impedancePhasesRad[j]);
                if (this.weightsSet && this.voltageErrorSet) {
                    ComplexErrorProp complexErrorProp = new ComplexErrorProp(this.appliedVoltage.getReal(), this.appliedVoltageError.getReal(), this.appliedVoltage.getImag(), this.appliedVoltageError.getImag());
                    ComplexErrorProp complexErrorProp2 = new ComplexErrorProp(this.realV[j], this.realVweights[j], this.imagV[j], this.imagVweights[j]);
                    ComplexErrorProp complexErrorProp3 = new ComplexErrorProp(this.referenceImpedance.getReal(), 0.0, this.referenceImpedance.getImag(), 0.0);
                    ComplexErrorProp complexErrorProp4 = complexErrorProp2.over(complexErrorProp).times(complexErrorProp3);
                    this.realZweights[j] = complexErrorProp4.getRealError();
                    this.imagZweights[j] = complexErrorProp4.getImagError();
                }
                this.impedancesSet = true;
            }
        }
    }

    public void setModel(ImpedSpecModel impedSpecModel, String[] stringArray, double[] dArray, double[] dArray2) {
        this.userModel = impedSpecModel;
        this.parameterSymbols = stringArray;
        this.numberOfParameters = stringArray.length;
        if (this.numberOfParameters != dArray.length) {
            throw new IllegalArgumentException("The number of parameter symbols, " + this.numberOfParameters + ", does not equal the number of initial estimates, " + dArray.length);
        }
        if (this.numberOfParameters != dArray2.length) {
            throw new IllegalArgumentException("The number of parameter symbols, " + this.numberOfParameters + ", does not equal the number of initial steps, " + dArray2.length);
        }
        this.initialEstimates = dArray;
        this.initialSteps = dArray2;
        this.setEstimateArrayDimensions();
        this.estimatesSet = true;
        this.userModelSet = true;
    }

    public void setModel(ImpedSpecModel impedSpecModel, String[] stringArray, double[] dArray) {
        this.userModel = impedSpecModel;
        this.parameterSymbols = stringArray;
        this.numberOfParameters = stringArray.length;
        if (this.numberOfParameters != dArray.length) {
            throw new IllegalArgumentException("The number of parameter symbols, " + this.numberOfParameters + ", does not equal the number of initial estimates, " + dArray.length);
        }
        this.initialEstimates = dArray;
        this.initialSteps = new double[this.numberOfParameters];
        for (int j = 0; j < this.numberOfParameters; ++j) {
            this.initialSteps[j] = Math.abs(this.initialEstimates[j]) * 0.1;
        }
        this.setEstimateArrayDimensions();
        this.estimatesSet = true;
        this.userModelSet = true;
    }

    public void setModel(int n, double[] dArray, double[] dArray2) {
        this.numberOfParameters = dArray.length;
        if (this.numberOfParameters != Impedance.modelComponents(n).length) {
            throw new IllegalArgumentException("The number of parameter estimates, " + this.numberOfParameters + ", does not equal the number of parameters, " + Impedance.modelComponents(n).length + ", in model number " + n);
        }
        if (this.numberOfParameters != dArray2.length) {
            throw new IllegalArgumentException("The number of parameter estimates, " + this.numberOfParameters + ", does not equal the number of parameter steps, " + dArray2.length);
        }
        this.modelNumber = n;
        this.initialEstimates = dArray;
        this.initialSteps = dArray2;
        this.parameterSymbols = Impedance.modelComponents(n);
        this.setEstimateArrayDimensions();
        this.estimatesSet = true;
        this.modelSet = true;
    }

    public void setModel(int n, double[] dArray) {
        this.numberOfParameters = dArray.length;
        if (this.numberOfParameters != Impedance.modelComponents(n).length) {
            throw new IllegalArgumentException("The number of parameter estimates, " + this.numberOfParameters + ", does not equal the number of parameters, " + Impedance.modelComponents(n).length + ", in model number " + n);
        }
        this.modelNumber = n;
        this.initialEstimates = dArray;
        this.parameterSymbols = Impedance.modelComponents(n);
        this.initialSteps = new double[this.numberOfParameters];
        for (int j = 0; j < this.numberOfParameters; ++j) {
            this.initialSteps[j] = Math.abs(this.initialEstimates[j]) * 0.1;
        }
        this.setEstimateArrayDimensions();
        this.estimatesSet = true;
        this.modelSet = true;
    }

    public void setModel(int n) {
        this.modelNumber = n;
        this.parameterSymbols = Impedance.modelComponents(n);
        this.numberOfParameters = this.parameterSymbols.length;
        this.setEstimateArrayDimensions();
        this.setInitialEstimates();
        this.estimatesSet = true;
        this.modelSet = true;
    }

    private void setEstimateArrayDimensions() {
        this.bestEstimates = new double[this.numberOfParameters];
        this.standardDeviations = new double[this.numberOfParameters];
        this.coefficientsOfVariation = new double[this.numberOfParameters];
        this.preMinimumGradients = new double[this.numberOfParameters];
        this.postMinimumGradients = new double[this.numberOfParameters];
        this.correlationCoefficients = new double[this.numberOfParameters][this.numberOfParameters];
    }

    private void setInitialEstimates() {
        if (this.impedancesSet && this.frequenciesSet) {
            int n;
            this.degreesOfFreedom = this.numberOfFrequencies - this.numberOfParameters;
            if (this.degreesOfFreedom <= 0) {
                throw new IllegalArgumentException("Degrees of freedom, " + this.degreesOfFreedom + ", are less than 1");
            }
            double d = Stat.mean(this.realZ);
            double d2 = Fmath.minimum(this.realZ);
            int n2 = Fmath.indexOf(this.realZ, d2);
            double d3 = Fmath.maximum(this.realZ);
            int n3 = Fmath.indexOf(this.realZ, d3);
            double d4 = Stat.mean(this.imagZ);
            double d5 = Fmath.minimum(this.imagZ);
            int n4 = Fmath.indexOf(this.imagZ, d5);
            double d6 = Fmath.maximum(this.imagZ);
            int n5 = Fmath.indexOf(this.imagZ, d6);
            double d7 = Math.max(Math.abs(d5), Math.abs(d6));
            int n6 = Fmath.indexOf(this.imagZ, d7);
            if (n6 == -1) {
                n6 = Fmath.indexOf(this.imagZ, -d7);
            }
            if (n6 == -1) {
                n6 = this.numberOfFrequencies / 2;
            }
            double d8 = Stat.geometricMean(this.log10frequencies);
            switch (this.modelNumber) {
                case 1: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = d;
                    break;
                }
                case 2: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    double d9 = 0.0;
                    for (int j = 0; j < this.numberOfFrequencies; ++j) {
                        d9 += 1.0 / Math.abs(this.imagZ[j] * this.omegas[j]);
                    }
                    this.initialEstimates[0] = d9 / (double)this.numberOfFrequencies;
                    break;
                }
                case 3: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    double d10 = 0.0;
                    for (int j = 0; j < this.numberOfFrequencies; ++j) {
                        d10 += Math.abs(this.imagZ[j] / this.omegas[j]);
                    }
                    this.initialEstimates[0] = d10 / (double)this.numberOfFrequencies;
                    break;
                }
                case 4: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    double d11 = 0.0;
                    for (int j = 0; j < this.numberOfFrequencies; ++j) {
                        d11 += Math.abs(this.realZ[j] * Math.sqrt(this.omegas[j]));
                        d11 += Math.abs(this.imagZ[j] * Math.sqrt(this.omegas[j]));
                    }
                    this.initialEstimates[0] = d11 / (2.0 * (double)this.numberOfFrequencies);
                    break;
                }
                case 5: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    double d12 = 0.0;
                    for (int j = 0; j < this.numberOfFrequencies; ++j) {
                        d12 += Math.abs(this.realZ[j] * Math.sqrt(this.omegas[j]));
                        d12 += Math.abs(this.imagZ[j] * Math.sqrt(this.omegas[j]));
                    }
                    this.initialEstimates[0] = d12 / (2.0 * (double)this.numberOfFrequencies);
                    this.initialEstimates[1] = Math.abs(d / this.initialEstimates[0]);
                    break;
                }
                case 6: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    double d13 = 0.0;
                    for (int j = 0; j < this.numberOfFrequencies; ++j) {
                        d13 += this.imagZ[j] / this.realZ[j];
                    }
                    double d14 = Math.abs(Math.atan(d13 /= (double)this.numberOfFrequencies));
                    double d15 = Math.cos(d14);
                    double d16 = Math.sin(d14);
                    this.initialEstimates[1] = d14 / 1.5707963267948966;
                    double d17 = 0.0;
                    for (int j = 0; j < this.numberOfFrequencies; ++j) {
                        d17 += Math.abs(this.realZ[j] / (d15 * Math.pow(this.omegas[j], this.initialEstimates[1])));
                        d17 += Math.abs(this.imagZ[j] / (d16 * Math.pow(this.omegas[j], this.initialEstimates[1])));
                    }
                    this.initialEstimates[0] = d17 / (2.0 * (double)this.numberOfFrequencies);
                    break;
                }
                case 7: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = d;
                    double d18 = 0.0;
                    for (int j = 0; j < this.numberOfFrequencies; ++j) {
                        d18 += 1.0 / Math.abs(this.imagZ[j] * this.omegas[j]);
                    }
                    this.initialEstimates[1] = d18 / (double)this.numberOfFrequencies;
                    break;
                }
                case 8: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = d;
                    double d19 = 0.0;
                    for (int j = 0; j < this.numberOfFrequencies; ++j) {
                        d19 += Math.abs(this.imagZ[j] / this.omegas[j]);
                    }
                    this.initialEstimates[1] = d19 / (double)this.numberOfFrequencies;
                    break;
                }
                case 9: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    double d20 = 0.0;
                    double d21 = 0.0;
                    for (int j = 1; j < this.numberOfFrequencies; ++j) {
                        double d22 = (this.frequencies[j] - this.frequencies[j - 1]) / this.frequencies[j] / (this.imagZ[j] * this.frequencies[j - 1] - this.imagZ[j - 1] * this.frequencies[j]);
                        double d23 = (this.imagZ[j] + 1.0 / (d22 * this.frequencies[j])) / this.frequencies[j];
                        d20 += d23;
                        d21 += d22;
                    }
                    this.initialEstimates[0] = d20 / (double)(this.numberOfFrequencies - 1);
                    this.initialEstimates[1] = d21 / (double)(this.numberOfFrequencies - 1);
                    break;
                }
                case 10: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = d3;
                    this.initialEstimates[1] = 1.0 / (d3 * this.frequencies[n4]);
                    break;
                }
                case 11: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = d3;
                    this.initialEstimates[1] = d3 / this.frequencies[n5];
                    break;
                }
                case 12: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    double d24 = 1.0 / this.frequencies[n4];
                    double d25 = 0.0;
                    double d26 = 0.0;
                    for (int j = 1; j < this.numberOfFrequencies; ++j) {
                        double d27 = this.imagZ[j] * (this.frequencies[j] * d24 - 1.0 / this.frequencies[j]);
                        d25 += d27;
                        d26 += d24 / d27;
                    }
                    this.initialEstimates[0] = d25 / (double)this.numberOfFrequencies;
                    this.initialEstimates[1] = d26 / (double)this.numberOfFrequencies;
                    break;
                }
                case 13: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[2] = d2;
                    this.initialEstimates[0] = d3 - d2;
                    this.initialEstimates[1] = 1.0 / (this.initialEstimates[0] * this.frequencies[n4]);
                    break;
                }
                case 14: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[2] = d2;
                    this.initialEstimates[0] = d3 - d2;
                    double d28 = 0.0;
                    double d29 = 0.0;
                    for (int j = 1; j < this.numberOfFrequencies; ++j) {
                        double d30 = (this.frequencies[j] - this.frequencies[j - 1]) / this.frequencies[j] / (this.imagZ[j] * this.frequencies[j - 1] - this.imagZ[j - 1] * this.frequencies[j]);
                        double d31 = (this.imagZ[j] + 1.0 / (d30 * this.frequencies[j])) / this.frequencies[j];
                        d28 += d31;
                        d29 += d30;
                    }
                    this.initialEstimates[3] = d28 / (double)(this.numberOfFrequencies - 1);
                    this.initialEstimates[1] = d29 / (double)(this.numberOfFrequencies - 1);
                    break;
                }
                case 15: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[2] = d2;
                    this.initialEstimates[0] = d3 - d2;
                    double d32 = 1.0 / this.frequencies[n4];
                    double d33 = 0.0;
                    double d34 = 0.0;
                    for (int j = 1; j < this.numberOfFrequencies; ++j) {
                        double d35 = this.imagZ[j] * (this.frequencies[j] * d32 - 1.0 / this.frequencies[j]);
                        d33 += d35;
                        d34 += d32 / d35;
                    }
                    this.initialEstimates[3] = d33 / (double)this.numberOfFrequencies;
                    this.initialEstimates[1] = d34 / (double)this.numberOfFrequencies;
                    break;
                }
                case 16: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = d3;
                    double d36 = 0.0;
                    for (int j = 0; j < this.numberOfFrequencies; ++j) {
                        d36 += 1.0 / Math.abs(this.imagZ[j] * this.omegas[j]);
                    }
                    this.initialEstimates[1] = 2.0 * d36 / (double)this.numberOfFrequencies;
                    this.initialEstimates[2] = this.initialEstimates[1];
                    break;
                }
                case 17: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = d3;
                    double d37 = 0.0;
                    for (int j = 0; j < this.numberOfFrequencies; ++j) {
                        d37 += 1.0 / Math.abs(this.imagZ[j] * this.omegas[j]);
                    }
                    this.initialEstimates[1] = d37 / (2.0 * (double)this.numberOfFrequencies);
                    this.initialEstimates[2] = this.initialEstimates[1];
                }
                case 18: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = d2;
                    this.initialEstimates[2] = d3 - d2;
                    double d38 = 0.0;
                    for (int j = 0; j < this.numberOfFrequencies; ++j) {
                        d38 += 1.0 / Math.abs(this.imagZ[j] * this.omegas[j]);
                    }
                    this.initialEstimates[1] = 2.0 * d38 / (double)this.numberOfFrequencies;
                    this.initialEstimates[3] = this.initialEstimates[1];
                    break;
                }
                case 19: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = d3 / 2.0;
                    this.initialEstimates[2] = this.initialEstimates[0];
                    this.initialEstimates[1] = 2.0 / (this.initialEstimates[0] * this.frequencies[n4]);
                    this.initialEstimates[3] = this.initialEstimates[1];
                    break;
                }
                case 20: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[4] = d2;
                    this.initialEstimates[0] = (d3 - d2) / 2.0;
                    this.initialEstimates[2] = this.initialEstimates[0];
                    this.initialEstimates[1] = 2.0 / (this.initialEstimates[0] * this.frequencies[n4]);
                    this.initialEstimates[3] = this.initialEstimates[1];
                    break;
                }
                case 21: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[4] = d2;
                    this.initialEstimates[0] = (d3 - d2) / 2.0;
                    this.initialEstimates[2] = this.initialEstimates[0];
                    double d39 = 0.0;
                    for (int j = 0; j < this.numberOfFrequencies; ++j) {
                        d39 += 1.0 / Math.abs(this.imagZ[j] * this.omegas[j]);
                    }
                    this.initialEstimates[1] = d39 / (2.0 * (double)this.numberOfFrequencies);
                    this.initialEstimates[3] = this.initialEstimates[1];
                    break;
                }
                case 22: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = d3 / 3.0;
                    this.initialEstimates[2] = this.initialEstimates[0];
                    this.initialEstimates[4] = this.initialEstimates[0];
                    this.initialEstimates[1] = 3.0 / (this.initialEstimates[0] * this.frequencies[n4]);
                    this.initialEstimates[3] = this.initialEstimates[1];
                    this.initialEstimates[5] = this.initialEstimates[1];
                    break;
                }
                case 23: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[6] = d2;
                    this.initialEstimates[0] = (d3 - d2) / 3.0;
                    this.initialEstimates[2] = this.initialEstimates[0];
                    this.initialEstimates[4] = this.initialEstimates[0];
                    this.initialEstimates[1] = 3.0 / (this.initialEstimates[0] * this.frequencies[n4]);
                    this.initialEstimates[3] = this.initialEstimates[1];
                    this.initialEstimates[5] = this.initialEstimates[1];
                    break;
                }
                case 24: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[3] = d2;
                    this.initialEstimates[0] = d3 - d2;
                    double d40 = 0.0;
                    if (n4 < this.numberOfFrequencies - 3) {
                        this.initialEstimates[1] = 1.0 / (this.initialEstimates[0] * this.frequencies[n4]);
                        for (int j = n4; j < this.numberOfFrequencies; ++j) {
                            d40 += Math.abs(this.realZ[j] * Math.sqrt(this.omegas[j]));
                            d40 += Math.abs(this.imagZ[j] * Math.sqrt(this.omegas[j]));
                        }
                        this.initialEstimates[2] = d40 / (2.0 * (double)(this.numberOfFrequencies - n4));
                        break;
                    }
                    this.initialEstimates[1] = 1.0 / (this.initialEstimates[0] * d8);
                    for (int j = 0; j < this.numberOfFrequencies; ++j) {
                        d40 += Math.abs(this.realZ[j] * Math.sqrt(this.omegas[j]));
                        d40 += Math.abs(this.imagZ[j] * Math.sqrt(this.omegas[j]));
                    }
                    this.initialEstimates[2] = d40 / (2.0 * (double)this.numberOfFrequencies);
                    break;
                }
                case 25: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[4] = d2;
                    this.initialEstimates[0] = d3 - d2;
                    double d41 = 0.0;
                    if (n4 < this.numberOfFrequencies - 3) {
                        this.initialEstimates[1] = 1.0 / (this.initialEstimates[0] * this.frequencies[n4]);
                        for (int j = n4; j < this.numberOfFrequencies; ++j) {
                            d41 += Math.abs(this.realZ[j] * Math.sqrt(this.omegas[j]));
                            d41 += Math.abs(this.imagZ[j] * Math.sqrt(this.omegas[j]));
                        }
                        this.initialEstimates[2] = d41 / (2.0 * (double)(this.numberOfFrequencies - n4));
                        this.initialEstimates[3] = Math.abs(d / this.initialEstimates[2]);
                        break;
                    }
                    this.initialEstimates[1] = 1.0 / (this.initialEstimates[0] * d8);
                    for (int j = 0; j < this.numberOfFrequencies; ++j) {
                        d41 += Math.abs(this.realZ[j] * Math.sqrt(this.omegas[j]));
                        d41 += Math.abs(this.imagZ[j] * Math.sqrt(this.omegas[j]));
                    }
                    this.initialEstimates[2] = d41 / (2.0 * (double)this.numberOfFrequencies);
                    this.initialEstimates[3] = Math.abs(d / this.initialEstimates[2]);
                    break;
                }
                case 26: {
                    int n7;
                    double d42;
                    double d43;
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[4] = d2;
                    this.initialEstimates[0] = d3 - d2;
                    double d44 = 0.0;
                    if (n4 < this.numberOfFrequencies - 3) {
                        this.initialEstimates[1] = 1.0 / (this.initialEstimates[0] * this.frequencies[n4]);
                        for (int j = n4; j < this.numberOfFrequencies; ++j) {
                            d44 += this.imagZ[j] / this.realZ[j];
                        }
                        d43 = Math.abs(Math.atan(d44 /= (double)(this.numberOfFrequencies - n4)));
                        double d45 = Math.cos(d43);
                        double d46 = Math.sin(d43);
                        this.initialEstimates[3] = d43 / 1.5707963267948966;
                        d42 = 0.0;
                        for (n7 = n4; n7 < this.numberOfFrequencies; ++n7) {
                            d42 += Math.abs(this.realZ[n7] / (d45 * Math.pow(this.omegas[n7], this.initialEstimates[1])));
                            d42 += Math.abs(this.imagZ[n7] / (d46 * Math.pow(this.omegas[n7], this.initialEstimates[1])));
                        }
                        this.initialEstimates[2] = d42 / (2.0 * (double)(this.numberOfFrequencies - n4));
                        break;
                    }
                    this.initialEstimates[1] = 1.0 / (this.initialEstimates[0] * d8);
                    for (int j = 0; j < this.numberOfFrequencies; ++j) {
                        d44 += this.imagZ[j] / this.realZ[j];
                    }
                    d43 = Math.abs(Math.atan(d44 /= (double)this.numberOfFrequencies));
                    double d47 = Math.cos(d43);
                    double d48 = Math.sin(d43);
                    this.initialEstimates[3] = d43 / 1.5707963267948966;
                    d42 = 0.0;
                    for (n7 = 0; n7 < this.numberOfFrequencies; ++n7) {
                        d42 += Math.abs(this.realZ[n7] / (d47 * Math.pow(this.omegas[n7], this.initialEstimates[1])));
                        d42 += Math.abs(this.imagZ[n7] / (d48 * Math.pow(this.omegas[n7], this.initialEstimates[1])));
                    }
                    this.initialEstimates[2] = d42 / (2.0 * (double)this.numberOfFrequencies);
                    break;
                }
                case 27: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = d3 / 2.0;
                    this.initialEstimates[2] = this.initialEstimates[0];
                    double d43 = 0.0;
                    if (n4 < this.numberOfFrequencies - 3) {
                        this.initialEstimates[1] = 2.0 / (this.initialEstimates[0] * this.frequencies[n4]);
                        this.initialEstimates[3] = this.initialEstimates[1];
                        for (int j = n4; j < this.numberOfFrequencies; ++j) {
                            d43 += Math.abs(this.realZ[j] * Math.sqrt(this.omegas[j]));
                            d43 += Math.abs(this.imagZ[j] * Math.sqrt(this.omegas[j]));
                        }
                        this.initialEstimates[4] = d43 / (2.0 * (double)(this.numberOfFrequencies - n4));
                        break;
                    }
                    this.initialEstimates[1] = 2.0 / (this.initialEstimates[0] * d8);
                    this.initialEstimates[3] = this.initialEstimates[1];
                    for (int j = n4; j < this.numberOfFrequencies; ++j) {
                        d43 += Math.abs(this.realZ[j] * Math.sqrt(this.omegas[j]));
                        d43 += Math.abs(this.imagZ[j] * Math.sqrt(this.omegas[j]));
                    }
                    this.initialEstimates[4] = d43 / (2.0 * (double)this.numberOfFrequencies);
                    break;
                }
                case 28: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[6] = d2;
                    this.initialEstimates[0] = (d3 - d2) / 2.0;
                    this.initialEstimates[2] = this.initialEstimates[0];
                    double d49 = 0.0;
                    if (n4 < this.numberOfFrequencies - 3) {
                        this.initialEstimates[1] = 3.0 / (this.initialEstimates[0] * this.frequencies[n4]);
                        this.initialEstimates[3] = this.initialEstimates[1];
                        this.initialEstimates[5] = this.initialEstimates[1];
                        for (int j = n4; j < this.numberOfFrequencies; ++j) {
                            d49 += Math.abs(this.realZ[j] * Math.sqrt(this.omegas[j]));
                            d49 += Math.abs(this.imagZ[j] * Math.sqrt(this.omegas[j]));
                        }
                        this.initialEstimates[4] = d49 / (2.0 * (double)(this.numberOfFrequencies - n4));
                        break;
                    }
                    this.initialEstimates[1] = 3.0 / (this.initialEstimates[0] * d8);
                    this.initialEstimates[3] = this.initialEstimates[1];
                    this.initialEstimates[5] = this.initialEstimates[1];
                    for (int j = n4; j < this.numberOfFrequencies; ++j) {
                        d49 += Math.abs(this.realZ[j] * Math.sqrt(this.omegas[j]));
                        d49 += Math.abs(this.imagZ[j] * Math.sqrt(this.omegas[j]));
                    }
                    this.initialEstimates[4] = d49 / (2.0 * (double)this.numberOfFrequencies);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Automatically calculated initial estimates are only presntly available for models 1 to 28");
                }
            }
            this.initialSteps = new double[this.numberOfParameters];
            for (n = 0; n < this.numberOfParameters; ++n) {
                this.initialSteps[n] = Math.abs(this.initialEstimates[n]) * 0.1;
            }
            for (n = 0; n < this.numberOfParameters; ++n) {
                if (this.initialSteps[n] != 0.0) continue;
                if (this.parameterSymbols[n].trim().substring(0, 1).equals("R")) {
                    this.initialSteps[n] = d3 * 0.01;
                }
                if (this.parameterSymbols[n].trim().substring(0, 1).equals("C")) {
                    this.initialSteps[n] = 0.01 / (d7 * this.frequencies[n6]);
                }
                if (this.parameterSymbols[n].trim().substring(0, 1).equals("L")) {
                    this.initialSteps[n] = d7 * 0.01 / this.frequencies[n6];
                }
                if (this.parameterSymbols[n].trim().substring(0, 1).equals("W")) {
                    this.initialSteps[n] = 0.01 / (d7 * Math.sqrt(this.frequencies[n6]));
                }
                if (this.parameterSymbols[n].trim().substring(0, 2).equals("Fs")) {
                    this.initialSteps[n] = 0.01 / (d7 * Math.sqrt(this.frequencies[n6]));
                }
                if (this.parameterSymbols[n].trim().substring(0, 2).equals("Fd")) {
                    this.initialSteps[n] = 0.05;
                }
                if (this.parameterSymbols[n].trim().substring(0, 2).equals("Qs")) {
                    this.initialSteps[n] = 0.01 / (d7 * Math.sqrt(this.frequencies[n6]));
                }
                if (!this.parameterSymbols[n].trim().substring(0, 2).equals("Qa")) continue;
                this.initialSteps[n] = 0.005;
            }
            this.estimatesSet = true;
        } else {
            this.estimatesNeeded = true;
        }
    }

    @Override
    public double[] getInitialEstimates() {
        if (!this.estimatesSet) {
            throw new IllegalArgumentException("No initial estimates have been entered or calculated");
        }
        return this.initialEstimates;
    }

    public String[] getCircuitComponents() {
        return this.parameterSymbols;
    }

    public void addNewConstraint(int n, int n2, double d) {
        this.constraints.add(new Integer(n));
        this.constraints.add(new Integer(n2));
        this.constraints.add(new Double(d));
        ++this.numberOfAddedConstraints;
        this.constraintsAdded = true;
    }

    public void addNewConstraint(String string, int n, double d) {
        if (this.numberOfParameters == 0) {
            throw new IllegalArgumentException("No model number or model parameters entered");
        }
        int n2 = -1;
        for (int j = 0; j < this.numberOfParameters; ++j) {
            if (!this.parameterSymbols[j].trim().equals(string.trim())) continue;
            n2 = j;
        }
        if (n2 == -1) {
            throw new IllegalArgumentException("Parameter symbol, " + string + ", not found");
        }
        this.constraints.add(new Integer(n2));
        this.constraints.add(new Integer(n));
        this.constraints.add(new Double(d));
        ++this.numberOfAddedConstraints;
        this.constraintsAdded = true;
    }

    public void removeDefaultConstraints() {
        this.supressDefaultConstraints = true;
    }

    public void restoreDefaultConstraints() {
        this.supressDefaultConstraints = false;
    }

    public void removeAddedConstraints() {
        this.supressAddedConstraints = true;
        this.constraintsAdded = false;
    }

    public void removeAllConstraints() {
        this.supressDefaultConstraints = true;
        this.supressAddedConstraints = true;
        this.constraintsAdded = false;
    }

    public void resetMaximumNumberOfIterations(int n) {
        this.maximumIterations = n;
    }

    public void resetTolerance(double d) {
        this.tolerance = d;
    }

    public ArrayList<Object> getRegressionResultsAsArrayList() {
        if (!this.regressionDone) {
            this.regression();
        }
        return this.results;
    }

    public Vector<Object> getRegressionResultsAsVector() {
        if (!this.regressionDone) {
            this.regression();
        }
        int n = this.results.size();
        Vector<Object> vector = new Vector<Object>(n);
        for (int j = 0; j < n; ++j) {
            vector.add(this.results.get(j));
        }
        return vector;
    }

    public Vector<Object> getRegressionResults() {
        return this.getRegressionResults();
    }

    private void setRegressionArrays() {
        int n;
        this.xRegression = new double[this.numberOfFrequencies];
        this.yRegression = new double[2][this.numberOfFrequencies];
        if (this.weightsSet) {
            this.wRegression = new double[2][this.numberOfFrequencies];
        }
        for (n = 0; n < this.numberOfFrequencies; ++n) {
            this.xRegression[n] = this.omegas[n];
            this.yRegression[0][n] = this.realZ[n];
            this.yRegression[1][n] = this.imagZ[n];
        }
        if (this.weightsSet) {
            for (n = 0; n < this.numberOfFrequencies; ++n) {
                this.wRegression[0][n] = this.realZweights[n];
                this.wRegression[1][n] = this.imagZweights[n];
            }
        }
    }

    public ArrayList<Object> regression() {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        this.degreesOfFreedom = this.numberOfFrequencies - this.numberOfParameters;
        if (this.degreesOfFreedom <= 0) {
            throw new IllegalArgumentException("Degrees of freedom, " + this.degreesOfFreedom + ", are less than 1");
        }
        if (!this.impedancesSet) {
            throw new IllegalArgumentException("No impedances or voltages have been entered");
        }
        if (!this.estimatesSet && !this.userModelSet) {
            this.setInitialEstimates();
        }
        this.setRegressionArrays();
        this.results = new ArrayList();
        this.results.add(new Integer(this.numberOfFrequencies));
        this.results.add(new Integer(this.numberOfParameters));
        this.results.add(new Integer(this.degreesOfFreedom));
        this.results.add(this.parameterSymbols);
        this.results.add(Conv.copy(this.initialEstimates));
        this.results.add(Conv.copy(this.initialSteps));
        if (this.weightsSet) {
            this.enterData(this.xRegression, this.yRegression, this.wRegression);
        } else {
            this.enterData(this.xRegression, this.yRegression);
        }
        if (this.userModelSet) {
            object = new ImpedSpecRegressionFunction2();
            ((ImpedSpecRegressionFunction2)object).numberOfFrequencies = this.numberOfFrequencies;
            ((ImpedSpecRegressionFunction2)object).isModel = this.userModel;
            this.regressionFunction = object;
        } else {
            object = new ImpedSpecRegressionFunction1();
            ((ImpedSpecRegressionFunction1)object).numberOfFrequencies = this.numberOfFrequencies;
            ((ImpedSpecRegressionFunction1)object).modelNumber = this.modelNumber;
            this.regressionFunction = object;
        }
        object = null;
        int[] nArray = null;
        double[] dArray = null;
        if (this.constraintsAdded) {
            object = new int[this.numberOfAddedConstraints];
            nArray = new int[this.numberOfAddedConstraints];
            dArray = new double[this.numberOfAddedConstraints];
            n4 = 0;
            for (int j = 0; j < this.numberOfAddedConstraints; ++j) {
                double d;
                int n5;
                n3 = (Integer)this.constraints.get(n4);
                object[j] = n3;
                nArray[j] = n5 = ((Integer)this.constraints.get(++n4)).intValue();
                dArray[j] = d = ((Double)this.constraints.get(++n4)).doubleValue();
                ++n4;
                this.addConstraint(n3, n5, d);
            }
        }
        if (!this.supressDefaultConstraints) {
            for (n4 = 0; n4 < this.numberOfParameters; ++n4) {
                double d = 0.0;
                double d2 = 1.0;
                if (this.constraintsAdded) {
                    for (n2 = 0; n2 < this.numberOfAddedConstraints; ++n2) {
                        if (object[n2] != n4) continue;
                        if (nArray[n2] == 1) {
                            d2 = dArray[n2];
                            continue;
                        }
                        d = dArray[n2];
                    }
                }
                this.addConstraint(n4, -1, d);
                if (!this.parameterSymbols[n4].trim().substring(0, 1).equals("Qa")) continue;
                this.addConstraint(n4, 1, d2);
            }
        }
        this.simplex2(this.regressionFunction, Conv.copy(this.initialEstimates), Conv.copy(this.initialSteps), this.tolerance, this.maximumIterations);
        this.numberOfIterations1 = this.getNiter();
        double[] dArray2 = this.getCoeff();
        double[] dArray3 = new double[this.numberOfParameters];
        for (n3 = 0; n3 < this.numberOfParameters; ++n3) {
            dArray3[n3] = Math.abs(dArray2[n3]) * 0.1;
        }
        this.simplex2(this.regressionFunction, dArray2, dArray3, this.tolerance, this.maximumIterations);
        this.bestEstimates = this.getCoeff();
        this.results.add(this.bestEstimates);
        this.standardDeviations = this.getCoeffSd();
        this.results.add(this.standardDeviations);
        this.coefficientsOfVariation = this.getCoeffVar();
        this.results.add(this.coefficientsOfVariation);
        this.correlationCoefficients = this.getCorrCoeffMatrix();
        this.results.add(this.correlationCoefficients);
        double[][] dArray4 = new double[this.numberOfParameters][2];
        if (this.getGrad() == null) {
            for (n = 0; n < this.numberOfParameters; ++n) {
                this.preMinimumGradients[n] = Double.NaN;
                this.postMinimumGradients[n] = Double.NaN;
            }
        } else {
            dArray4 = this.getGrad();
            for (n = 0; n < this.numberOfParameters; ++n) {
                this.preMinimumGradients[n] = dArray4[n][0];
                this.postMinimumGradients[n] = dArray4[n][1];
            }
        }
        this.results.add(this.preMinimumGradients);
        this.results.add(this.postMinimumGradients);
        this.sumOfSquares = this.getSumOfSquares();
        this.results.add(new Double(this.sumOfSquares));
        this.reducedSumOfSquares = this.sumOfSquares / (double)this.degreesOfFreedom;
        this.results.add(new Double(this.reducedSumOfSquares));
        if (this.weightsSet) {
            this.chiSquare = this.getChiSquare();
            this.results.add(new Double(this.chiSquare));
            this.reducedChiSquare = this.getReducedChiSquare();
            this.results.add(new Double(this.reducedChiSquare));
        } else {
            this.results.add(null);
            this.results.add(null);
        }
        this.numberOfIterations2 = this.getNiter();
        this.results.add(new Integer(this.numberOfIterations1));
        this.results.add(new Integer(this.numberOfIterations2));
        this.results.add(new Integer(this.maximumIterations));
        this.results.add(this.dataEnteredType[this.dataEnteredTypePointer]);
        this.results.add(this.frequencies);
        this.results.add(this.log10frequencies);
        this.results.add(this.omegas);
        this.results.add(this.log10omegas);
        this.results.add(this.impedanceMagnitudes);
        this.results.add(this.impedancePhasesRad);
        this.results.add(this.impedancePhasesDeg);
        this.results.add(this.impedances);
        this.results.add(this.realZ);
        this.results.add(this.imagZ);
        double[] dArray5 = this.getYcalc();
        for (int j = 0; j < this.numberOfFrequencies; ++j) {
            this.calculatedRealZ[j] = dArray5[j];
            this.calculatedImagZ[j] = dArray5[j + this.numberOfFrequencies];
        }
        this.results.add(this.calculatedRealZ);
        this.results.add(this.calculatedImagZ);
        double[] dArray6 = this.getResiduals();
        for (n2 = 0; n2 < this.numberOfFrequencies; ++n2) {
            this.realZresiduals[n2] = dArray6[n2];
            this.imagZresiduals[n2] = dArray6[n2 + this.numberOfFrequencies];
        }
        this.results.add(this.realZresiduals);
        this.results.add(this.imagZresiduals);
        if (this.weightsSet) {
            switch (this.dataEnteredTypePointer) {
                case 0: {
                    this.results.add(this.realVweights);
                    this.results.add(this.imagVweights);
                    break;
                }
                case 1: {
                    this.results.add(this.voltageWeights);
                    this.results.add(null);
                    break;
                }
                case 2: {
                    this.results.add(this.voltageMagnitudeWeights);
                    this.results.add(this.voltagePhaseWeightsRad);
                    break;
                }
                case 3: {
                    this.results.add(this.voltageMagnitudeWeights);
                    this.results.add(this.voltagePhaseWeightsDeg);
                    break;
                }
                case 4: {
                    this.results.add(this.realZweights);
                    this.results.add(this.imagZweights);
                    break;
                }
                case 5: {
                    this.results.add(this.impedanceWeights);
                    this.results.add(null);
                    break;
                }
                case 6: {
                    this.results.add(this.impedanceMagnitudeWeights);
                    this.results.add(this.impedancePhaseWeightsRad);
                    break;
                }
                case 7: {
                    this.results.add(this.impedanceMagnitudeWeights);
                    this.results.add(this.impedancePhaseWeightsDeg);
                    break;
                }
                default: {
                    this.results.add(null);
                    this.results.add(null);
                }
            }
            this.results.add(this.realZweights);
            this.results.add(this.imagZweights);
        } else {
            for (n2 = 0; n2 < 4; ++n2) {
                this.results.add(null);
            }
        }
        for (n2 = 0; n2 < this.numberOfFrequencies; ++n2) {
            this.calculatedImpedances[n2] = new Complex(this.calculatedRealZ[n2], this.calculatedImagZ[n2]);
            this.calculatedImpedanceMagnitudes[n2] = this.calculatedImpedances[n2].abs();
            this.calculatedImpedancePhasesRad[n2] = this.calculatedImpedances[n2].arg();
            this.calculatedImpedancePhasesDeg[n2] = Math.toDegrees(this.calculatedImpedancePhasesRad[n2]);
        }
        this.results.add(this.calculatedImpedances);
        this.results.add(this.calculatedImpedanceMagnitudes);
        this.results.add(this.calculatedImpedancePhasesRad);
        this.results.add(this.calculatedImpedancePhasesDeg);
        if (this.appliedVoltageSet && this.referenceSet) {
            for (n2 = 0; n2 < this.numberOfFrequencies; ++n2) {
                this.calculatedVoltages[n2] = this.appliedVoltage.times(this.calculatedImpedances[n2]).over(this.calculatedImpedances[n2].plus(this.referenceImpedance));
                this.calculatedRealV[n2] = this.calculatedVoltages[n2].getReal();
                this.calculatedImagV[n2] = this.calculatedVoltages[n2].getImag();
                this.calculatedVoltageMagnitudes[n2] = this.calculatedVoltages[n2].abs();
                this.calculatedVoltagePhasesRad[n2] = this.calculatedVoltages[n2].arg();
                this.calculatedVoltagePhasesDeg[n2] = Math.toDegrees(this.calculatedVoltagePhasesRad[n2]);
            }
            this.results.add(this.calculatedVoltages);
            this.results.add(this.calculatedRealV);
            this.results.add(this.calculatedImagV);
            this.results.add(this.calculatedVoltageMagnitudes);
            this.results.add(this.calculatedVoltagePhasesRad);
            this.results.add(this.calculatedVoltagePhasesDeg);
        } else {
            for (n2 = 0; n2 < 6; ++n2) {
                this.results.add(null);
            }
        }
        this.regressionDone = true;
        return this.results;
    }

    @Override
    public double[] getBestEstimates() {
        if (!this.regressionDone) {
            this.regression();
        }
        return this.bestEstimates;
    }

    public double[] getStandardDeviations() {
        if (!this.regressionDone) {
            this.regression();
        }
        return this.standardDeviations;
    }

    public int getFirstNumberOfIterations() {
        return this.numberOfIterations1;
    }

    public int getSecondNumberOfIterations() {
        return this.numberOfIterations2;
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    public void setLinearPlot() {
        this.logOrLinear = false;
    }

    public void setLog10Plot() {
        this.logOrLinear = true;
    }

    private void calculateLineFrequencies() {
        double d = Fmath.minimum(this.frequencies);
        double d2 = Fmath.maximum(this.frequencies);
        if (this.logOrLinear) {
            int n;
            double d3 = Fmath.log10(d);
            double d4 = Fmath.log10(d2);
            double d5 = (d4 - d3) / (double)(this.numberOfLineFrequencies - 1);
            this.lineFrequencies = new double[this.numberOfLineFrequencies];
            this.log10lineFrequencies = new double[this.numberOfLineFrequencies];
            this.log10lineFrequencies[0] = d3;
            this.log10lineFrequencies[this.numberOfLineFrequencies - 1] = d4;
            for (n = 1; n < this.numberOfLineFrequencies - 1; ++n) {
                this.log10lineFrequencies[n] = this.log10lineFrequencies[n - 1] + d5;
            }
            for (n = 0; n < this.numberOfLineFrequencies; ++n) {
                this.lineFrequencies[n] = Math.pow(10.0, this.log10lineFrequencies[n]);
            }
        } else {
            int n;
            double d6 = (d2 - d) / (double)(this.numberOfLineFrequencies - 1);
            this.lineFrequencies = new double[this.numberOfLineFrequencies];
            this.lineFrequencies[0] = d;
            this.log10lineFrequencies = new double[this.numberOfLineFrequencies];
            this.lineFrequencies[this.numberOfLineFrequencies - 1] = d2;
            for (n = 1; n < this.numberOfLineFrequencies - 1; ++n) {
                this.lineFrequencies[n] = this.lineFrequencies[n - 1] + d6;
            }
            for (n = 0; n < this.numberOfLineFrequencies; ++n) {
                this.log10lineFrequencies[n] = Fmath.log10(this.lineFrequencies[n]);
            }
        }
    }

    private String[] dateAndTime() {
        Date date = new Date();
        String[] stringArray = new String[]{DateFormat.getDateInstance().format(date), DateFormat.getTimeInstance().format(date)};
        return stringArray;
    }

    public ArrayList<Object> plotColeCole() {
        int n;
        String[] stringArray = this.dateAndTime();
        String string = "ImpedSpecRegression program:  Cole - Cole plot   [" + stringArray[0] + "    " + stringArray[1] + "]";
        String string2 = this.regressionTitle;
        if (!this.regressionDone) {
            this.regression();
        }
        this.calculateLineFrequencies();
        double[][] dArray = PlotGraph.data(2, this.numberOfLineFrequencies);
        for (n = 0; n < this.numberOfFrequencies; ++n) {
            dArray[0][n] = this.realZ[this.numberOfFrequencies - n - 1];
            dArray[1][n] = -this.imagZ[this.numberOfFrequencies - n - 1];
        }
        if (this.userModelSet) {
            for (n = 0; n < this.numberOfLineFrequencies; ++n) {
                dArray[2][n] = this.userModel.modelImpedance(this.bestEstimates, this.lineFrequencies[this.numberOfLineFrequencies - n - 1] * 2.0 * Math.PI).getReal();
                dArray[3][n] = -this.userModel.modelImpedance(this.bestEstimates, this.lineFrequencies[this.numberOfLineFrequencies - n - 1] * 2.0 * Math.PI).getImag();
            }
        } else {
            for (n = 0; n < this.numberOfLineFrequencies; ++n) {
                dArray[2][n] = Impedance.modelImpedance(this.bestEstimates, this.lineFrequencies[this.numberOfLineFrequencies - n - 1] * 2.0 * Math.PI, this.modelNumber).getReal();
                dArray[3][n] = -Impedance.modelImpedance(this.bestEstimates, this.lineFrequencies[this.numberOfLineFrequencies - n - 1] * 2.0 * Math.PI, this.modelNumber).getImag();
            }
        }
        PlotGraph plotGraph = new PlotGraph(dArray);
        int[] nArray = new int[]{0, 3};
        plotGraph.setLine(nArray);
        int[] nArray2 = new int[]{1, 0};
        plotGraph.setPoint(nArray2);
        plotGraph.setGraphTitle(string);
        plotGraph.setGraphTitle2(string2);
        plotGraph.setXaxisLegend("Real[Impedance / ohms]");
        plotGraph.setYaxisLegend("-Imag[Impedance / ohms]");
        plotGraph.plot();
        return this.results;
    }

    public ArrayList<Object> plotImpedanceMagnitudes() {
        Object object;
        int n;
        String[] stringArray = this.dateAndTime();
        String string = "ImpedSpecRegression program:  Impedance magnitude versus frequency plot   [" + stringArray[0] + "    " + stringArray[1] + "]";
        String string2 = this.regressionTitle;
        if (!this.regressionDone) {
            this.regression();
        }
        this.calculateLineFrequencies();
        double[][] dArray = PlotGraph.data(2, this.numberOfLineFrequencies);
        if (this.logOrLinear) {
            for (n = 0; n < this.numberOfFrequencies; ++n) {
                dArray[0][n] = this.log10frequencies[n];
                dArray[1][n] = this.impedanceMagnitudes[n];
            }
        } else {
            for (n = 0; n < this.numberOfFrequencies; ++n) {
                dArray[0][n] = this.frequencies[n];
                dArray[1][n] = this.impedanceMagnitudes[n];
            }
        }
        if (this.logOrLinear) {
            if (this.userModelSet) {
                for (n = 0; n < this.numberOfLineFrequencies; ++n) {
                    dArray[2][n] = this.log10lineFrequencies[n];
                    object = this.userModel.modelImpedance(this.bestEstimates, this.lineFrequencies[n] * 2.0 * Math.PI);
                    dArray[3][n] = ((Complex)object).abs();
                }
            } else {
                for (n = 0; n < this.numberOfLineFrequencies; ++n) {
                    dArray[2][n] = this.log10lineFrequencies[n];
                    object = Impedance.modelImpedance(this.bestEstimates, this.lineFrequencies[n] * 2.0 * Math.PI, this.modelNumber);
                    dArray[3][n] = ((Complex)object).abs();
                }
            }
        } else if (this.userModelSet) {
            for (n = 0; n < this.numberOfLineFrequencies; ++n) {
                dArray[2][n] = this.lineFrequencies[n];
                object = this.userModel.modelImpedance(this.bestEstimates, this.lineFrequencies[n] * 2.0 * Math.PI);
                dArray[3][n] = ((Complex)object).abs();
            }
        } else {
            for (n = 0; n < this.numberOfLineFrequencies; ++n) {
                dArray[2][n] = this.lineFrequencies[n];
                object = Impedance.modelImpedance(this.bestEstimates, this.lineFrequencies[n] * 2.0 * Math.PI, this.modelNumber);
                dArray[3][n] = ((Complex)object).abs();
            }
        }
        PlotGraph plotGraph = new PlotGraph(dArray);
        object = new int[]{0, 3};
        plotGraph.setLine((int[])object);
        int[] nArray = new int[]{1, 0};
        plotGraph.setPoint(nArray);
        plotGraph.setGraphTitle(string);
        plotGraph.setGraphTitle2(string2);
        if (this.logOrLinear) {
            plotGraph.setXaxisLegend("Log10[Frequency / Hz]");
        } else {
            plotGraph.setXaxisLegend("Frequency / Hz");
        }
        plotGraph.setYaxisLegend("Impedance Magnitude");
        plotGraph.plot();
        return this.results;
    }

    public ArrayList<Object> plotImpedancePhases() {
        Object object;
        int n;
        String[] stringArray = this.dateAndTime();
        String string = "ImpedSpecRegression program:  Impedance phase versus frequency plot   [" + stringArray[0] + "    " + stringArray[1] + "]";
        String string2 = this.regressionTitle;
        if (!this.regressionDone) {
            this.regression();
        }
        this.calculateLineFrequencies();
        double[][] dArray = PlotGraph.data(2, this.numberOfLineFrequencies);
        if (this.logOrLinear) {
            for (n = 0; n < this.numberOfFrequencies; ++n) {
                dArray[0][n] = this.log10frequencies[n];
                dArray[1][n] = this.impedancePhasesDeg[n];
            }
        } else {
            for (n = 0; n < this.numberOfFrequencies; ++n) {
                dArray[0][n] = this.frequencies[n];
                dArray[1][n] = this.impedancePhasesDeg[n];
            }
        }
        if (this.logOrLinear) {
            if (this.userModelSet) {
                for (n = 0; n < this.numberOfLineFrequencies; ++n) {
                    dArray[2][n] = this.log10lineFrequencies[n];
                    object = this.userModel.modelImpedance(this.bestEstimates, this.lineFrequencies[n] * 2.0 * Math.PI);
                    dArray[3][n] = Math.toDegrees(((Complex)object).arg());
                }
            } else {
                for (n = 0; n < this.numberOfLineFrequencies; ++n) {
                    dArray[2][n] = this.log10lineFrequencies[n];
                    object = Impedance.modelImpedance(this.bestEstimates, this.lineFrequencies[n] * 2.0 * Math.PI, this.modelNumber);
                    dArray[3][n] = Math.toDegrees(((Complex)object).arg());
                }
            }
        } else if (this.userModelSet) {
            for (n = 0; n < this.numberOfLineFrequencies; ++n) {
                dArray[2][n] = this.lineFrequencies[n];
                object = this.userModel.modelImpedance(this.bestEstimates, this.lineFrequencies[n] * 2.0 * Math.PI);
                dArray[3][n] = Math.toDegrees(((Complex)object).arg());
            }
        } else {
            for (n = 0; n < this.numberOfLineFrequencies; ++n) {
                dArray[2][n] = this.lineFrequencies[n];
                object = Impedance.modelImpedance(this.bestEstimates, this.lineFrequencies[n] * 2.0 * Math.PI, this.modelNumber);
                dArray[3][n] = Math.toDegrees(((Complex)object).arg());
            }
        }
        PlotGraph plotGraph = new PlotGraph(dArray);
        object = new int[]{0, 3};
        plotGraph.setLine((int[])object);
        int[] nArray = new int[]{1, 0};
        plotGraph.setPoint(nArray);
        plotGraph.setGraphTitle(string);
        plotGraph.setGraphTitle2(string2);
        if (this.logOrLinear) {
            plotGraph.setXaxisLegend("Log10[Frequency / Hz]");
        } else {
            plotGraph.setXaxisLegend("Frequency / Hz");
        }
        plotGraph.setYaxisLegend("Impedance Phase / degrees");
        plotGraph.plot();
        return this.results;
    }

    public ArrayList<Object> plotVoltageMagnitudes() {
        if (!this.regressionDone) {
            this.regression();
        }
        if (this.referenceSet && this.appliedVoltageSet) {
            Object object;
            Object object2;
            int n;
            String[] stringArray = this.dateAndTime();
            String string = "ImpedSpecRegression program:  Voltage magnitude versus frequency plot   [" + stringArray[0] + "    " + stringArray[1] + "]";
            String string2 = this.regressionTitle;
            this.calculateLineFrequencies();
            double[][] dArray = PlotGraph.data(2, this.numberOfLineFrequencies);
            if (this.logOrLinear) {
                for (n = 0; n < this.numberOfFrequencies; ++n) {
                    dArray[0][n] = this.log10frequencies[n];
                    dArray[1][n] = this.voltageMagnitudes[n];
                }
            } else {
                for (n = 0; n < this.numberOfFrequencies; ++n) {
                    dArray[0][n] = this.frequencies[n];
                    dArray[1][n] = this.voltageMagnitudes[n];
                }
            }
            if (this.logOrLinear) {
                if (this.userModelSet) {
                    for (n = 0; n < this.numberOfLineFrequencies; ++n) {
                        dArray[2][n] = this.log10lineFrequencies[n];
                        object2 = this.userModel.modelImpedance(this.bestEstimates, this.lineFrequencies[n] * 2.0 * Math.PI);
                        object = ((Complex)object2).times(this.appliedVoltage).over(this.referenceImpedance.plus((Complex)object2));
                        dArray[3][n] = ((Complex)object).abs();
                    }
                } else {
                    for (n = 0; n < this.numberOfLineFrequencies; ++n) {
                        dArray[2][n] = this.log10lineFrequencies[n];
                        object2 = Impedance.modelImpedance(this.bestEstimates, this.lineFrequencies[n] * 2.0 * Math.PI, this.modelNumber);
                        object = ((Complex)object2).times(this.appliedVoltage).over(this.referenceImpedance.plus((Complex)object2));
                        dArray[3][n] = ((Complex)object).abs();
                    }
                }
            } else if (this.userModelSet) {
                for (n = 0; n < this.numberOfLineFrequencies; ++n) {
                    dArray[2][n] = this.lineFrequencies[n];
                    object2 = this.userModel.modelImpedance(this.bestEstimates, this.lineFrequencies[n] * 2.0 * Math.PI);
                    object = ((Complex)object2).times(this.appliedVoltage).over(this.referenceImpedance.plus((Complex)object2));
                    dArray[3][n] = ((Complex)object).abs();
                }
            } else {
                for (n = 0; n < this.numberOfLineFrequencies; ++n) {
                    dArray[2][n] = this.lineFrequencies[n];
                    object2 = Impedance.modelImpedance(this.bestEstimates, this.lineFrequencies[n] * 2.0 * Math.PI, this.modelNumber);
                    object = ((Complex)object2).times(this.appliedVoltage).over(this.referenceImpedance.plus((Complex)object2));
                    dArray[3][n] = ((Complex)object).abs();
                }
            }
            PlotGraph plotGraph = new PlotGraph(dArray);
            object2 = new int[]{0, 3};
            plotGraph.setLine((int[])object2);
            object = new int[]{1, 0};
            plotGraph.setPoint((int[])object);
            plotGraph.setGraphTitle(string);
            plotGraph.setGraphTitle2(string2);
            if (this.logOrLinear) {
                plotGraph.setXaxisLegend("Log10[Frequency / Hz]");
            } else {
                plotGraph.setXaxisLegend("Frequency / Hz");
            }
            plotGraph.setYaxisLegend("Voltage Magnitude");
            plotGraph.plot();
        } else {
            System.out.println("The voltage magnitudes cannot be plotted as no reference impedance or applied voltage has been entered");
        }
        return this.results;
    }

    public ArrayList<Object> plotVoltagePhases() {
        if (!this.regressionDone) {
            this.regression();
        }
        if (this.referenceSet && this.appliedVoltageSet) {
            Object object;
            Object object2;
            int n;
            String[] stringArray = this.dateAndTime();
            String string = "ImpedSpecRegression program:  Voltage phase versus frequency plot   [" + stringArray[0] + "    " + stringArray[1] + "]";
            String string2 = this.regressionTitle;
            this.calculateLineFrequencies();
            double[][] dArray = PlotGraph.data(2, this.numberOfLineFrequencies);
            if (this.logOrLinear) {
                for (n = 0; n < this.numberOfFrequencies; ++n) {
                    dArray[0][n] = this.log10frequencies[n];
                    dArray[1][n] = this.voltagePhasesDeg[n];
                }
            } else {
                for (n = 0; n < this.numberOfFrequencies; ++n) {
                    dArray[0][n] = this.frequencies[n];
                    dArray[1][n] = this.voltagePhasesDeg[n];
                }
            }
            if (this.logOrLinear) {
                if (this.userModelSet) {
                    for (n = 0; n < this.numberOfLineFrequencies; ++n) {
                        dArray[2][n] = this.log10lineFrequencies[n];
                        object2 = this.userModel.modelImpedance(this.bestEstimates, this.lineFrequencies[n] * 2.0 * Math.PI);
                        object = ((Complex)object2).times(this.appliedVoltage).over(this.referenceImpedance.plus((Complex)object2));
                        dArray[3][n] = Math.toDegrees(((Complex)object).arg());
                    }
                } else {
                    for (n = 0; n < this.numberOfLineFrequencies; ++n) {
                        dArray[2][n] = this.log10lineFrequencies[n];
                        object2 = Impedance.modelImpedance(this.bestEstimates, this.lineFrequencies[n] * 2.0 * Math.PI, this.modelNumber);
                        object = ((Complex)object2).times(this.appliedVoltage).over(this.referenceImpedance.plus((Complex)object2));
                        dArray[3][n] = Math.toDegrees(((Complex)object).arg());
                    }
                }
            } else if (this.userModelSet) {
                for (n = 0; n < this.numberOfLineFrequencies; ++n) {
                    dArray[2][n] = this.lineFrequencies[n];
                    object2 = this.userModel.modelImpedance(this.bestEstimates, this.lineFrequencies[n] * 2.0 * Math.PI);
                    object = ((Complex)object2).times(this.appliedVoltage).over(this.referenceImpedance.plus((Complex)object2));
                    dArray[3][n] = Math.toDegrees(((Complex)object).arg());
                }
            } else {
                for (n = 0; n < this.numberOfLineFrequencies; ++n) {
                    dArray[2][n] = this.lineFrequencies[n];
                    object2 = Impedance.modelImpedance(this.bestEstimates, this.lineFrequencies[n] * 2.0 * Math.PI, this.modelNumber);
                    object = ((Complex)object2).times(this.appliedVoltage).over(this.referenceImpedance.plus((Complex)object2));
                    dArray[3][n] = Math.toDegrees(((Complex)object).arg());
                }
            }
            PlotGraph plotGraph = new PlotGraph(dArray);
            object2 = new int[]{0, 3};
            plotGraph.setLine((int[])object2);
            object = new int[]{1, 0};
            plotGraph.setPoint((int[])object);
            plotGraph.setGraphTitle(string);
            plotGraph.setGraphTitle2(string2);
            if (this.logOrLinear) {
                plotGraph.setXaxisLegend("Log10[Frequency / Hz]");
            } else {
                plotGraph.setXaxisLegend("Frequency / Hz");
            }
            plotGraph.setYaxisLegend("Voltage Phases / degrees");
            plotGraph.plot();
        } else {
            System.out.println("The voltage magnitudes cannot be plotted as no reference impedance or applied voltage has been entered");
        }
        return this.results;
    }

    public ArrayList<Object> printToTextFile() {
        String string = "ImpedSpecRegressionOutput.txt";
        this.fileType = true;
        return this.printToTextFile(string);
    }

    public ArrayList<Object> printToTextFile(String string) {
        int n;
        if (!this.regressionDone) {
            this.regression();
        }
        int n2 = 11;
        int n3 = 4;
        int n4 = (string = string.trim()).indexOf(46);
        if (n4 == -1) {
            string = string + ".txt";
        }
        FileOutput fileOutput = null;
        fileOutput = this.fileType ? new FileOutput(string, 'n') : new FileOutput(string);
        fileOutput.println("ImpedSpecRegression Program Output File:  " + this.regressionTitle);
        fileOutput.dateAndTimeln(string);
        fileOutput.println();
        if (this.modelSet) {
            fileOutput.println("Circuit - model number " + this.modelNumber);
        } else {
            fileOutput.println("Circuit supplied by the user");
        }
        fileOutput.println();
        fileOutput.println("Circuit Parameters");
        fileOutput.println("Best Estimates");
        fileOutput.print("Parameter", n2);
        fileOutput.print("Best", n2);
        fileOutput.print("Standard", n2);
        fileOutput.print("Coeff. of", n2);
        fileOutput.print("Pre-", n2);
        fileOutput.println("Post-");
        fileOutput.print("   ", n2);
        fileOutput.print("estimate", n2);
        fileOutput.print("deviation", n2);
        fileOutput.print("variation", n2);
        fileOutput.print("gradient", n2);
        fileOutput.println("gradient");
        for (n = 0; n < this.numberOfParameters; ++n) {
            fileOutput.print(this.parameterSymbols[n], n2);
            fileOutput.print(Fmath.truncate(this.bestEstimates[n], n3), n2);
            fileOutput.print(Fmath.truncate(this.standardDeviations[n], n3), n2);
            fileOutput.print(Fmath.truncate(this.coefficientsOfVariation[n], n3), n2);
            fileOutput.print(Fmath.truncate(this.preMinimumGradients[n], n3), n2);
            fileOutput.println(Fmath.truncate(this.postMinimumGradients[n], n3));
        }
        fileOutput.println();
        fileOutput.println("Initial Estimates");
        fileOutput.print("Parameter", n2);
        fileOutput.print("Initial", n2);
        fileOutput.println("initial");
        fileOutput.print("   ", n2);
        fileOutput.print("estimate", n2);
        fileOutput.println("step size");
        for (n = 0; n < this.numberOfParameters; ++n) {
            fileOutput.print(this.parameterSymbols[n], n2);
            fileOutput.print(Fmath.truncate(this.initialEstimates[n], n3), n2);
            fileOutput.println(Fmath.truncate(this.initialSteps[n], n3));
        }
        fileOutput.println();
        fileOutput.println("Sum of squares of the Real[Z] and Imag[Z] residuals:         " + Fmath.truncate(this.sumOfSquares, n3));
        fileOutput.println("Reduced sum of squares of the Real[Z] and Imag[Z] residuals: " + Fmath.truncate(this.sumOfSquares / (double)this.degreesOfFreedom, n3));
        fileOutput.println("Degrees of freedom: " + this.degreesOfFreedom);
        if (this.weightsSet) {
            fileOutput.println("Chi square:         " + Fmath.truncate(this.chiSquare, n3));
            fileOutput.println("Reduced chi square: " + Fmath.truncate(this.reducedChiSquare, n3));
        }
        fileOutput.println("Number of iterations taken in the first regression:      " + this.numberOfIterations1);
        fileOutput.println("Number of iterations taken in the second regression:     " + this.numberOfIterations2);
        fileOutput.println("Maximum number of iterations allowed in each regression: " + this.maximumIterations);
        fileOutput.println();
        if (this.appliedVoltageSet) {
            fileOutput.println("Applied voltage: " + this.appliedVoltage.getReal());
        }
        if (this.referenceSet) {
            fileOutput.println("Reference impedance: " + this.referenceImpedance);
        }
        fileOutput.println();
        n2 = 14;
        fileOutput.println("Fitted and entered data [frequencies, calculated impedances, data as entered]");
        fileOutput.print("Entered data type:  ");
        fileOutput.println(this.dataEnteredType[this.dataEnteredTypePointer]);
        fileOutput.println();
        fileOutput.print("Frequency", n2);
        fileOutput.print("Experimental", n2);
        fileOutput.print("Calculated", n2);
        fileOutput.print("Experimental", n2);
        fileOutput.print("Calculated", n2);
        switch (this.dataEnteredTypePointer) {
            case 0: {
                fileOutput.print("Real", n2);
                fileOutput.print("Imag", n2);
                break;
            }
            case 1: {
                fileOutput.print("Complex", n2);
                break;
            }
            case 2: {
                fileOutput.print("Magnitude", n2);
                fileOutput.print("Phase (rad)", n2);
                break;
            }
            case 3: {
                fileOutput.print("Magnitude", n2);
                fileOutput.print("Phase (deg)", n2);
                break;
            }
            case 4: {
                fileOutput.print("Real", n2);
                fileOutput.print("Imag", n2);
                break;
            }
            case 5: {
                fileOutput.print("Complex", n2);
                break;
            }
            case 6: {
                fileOutput.print("Magnitude", n2);
                fileOutput.print("Phase (rad)", n2);
                break;
            }
            case 7: {
                fileOutput.print("Magnitude", n2);
                fileOutput.print("Phase (deg)", n2);
            }
        }
        fileOutput.println();
        fileOutput.print("Frequency", n2);
        fileOutput.print("Real[Z]", n2);
        fileOutput.print("Real[Z]", n2);
        fileOutput.print("Imag[Z]", n2);
        fileOutput.print("Imag[Z]", n2);
        switch (this.dataEnteredTypePointer) {
            case 0: {
                fileOutput.print("[voltage]", n2);
                fileOutput.print("[voltage]", n2);
                break;
            }
            case 1: {
                fileOutput.print("voltage", n2);
                break;
            }
            case 2: {
                fileOutput.print("[voltage]", n2);
                fileOutput.print("[voltage]", n2);
                break;
            }
            case 3: {
                fileOutput.print("[voltage]", n2);
                fileOutput.print("[voltage]", n2);
                break;
            }
            case 4: {
                fileOutput.print("[impedance]", n2);
                fileOutput.print("[impedance]", n2);
                break;
            }
            case 5: {
                fileOutput.print("impedance", n2);
                break;
            }
            case 6: {
                fileOutput.print("[impedance]", n2);
                fileOutput.print("[impedance]", n2);
                break;
            }
            case 7: {
                fileOutput.print("[impedance]", n2);
                fileOutput.print("[impedance]", n2);
            }
        }
        fileOutput.println();
        for (n = 0; n < this.numberOfFrequencies; ++n) {
            fileOutput.print(Fmath.truncate(this.frequencies[n], n3), n2);
            fileOutput.print(Fmath.truncate(this.realZ[n], n3), n2);
            fileOutput.print(Fmath.truncate(this.calculatedRealZ[n], n3), n2);
            fileOutput.print(Fmath.truncate(this.imagZ[n], n3), n2);
            fileOutput.print(Fmath.truncate(this.calculatedImagZ[n], n3), n2);
            switch (this.dataEnteredTypePointer) {
                case 0: {
                    fileOutput.print(Fmath.truncate(this.realV[n], n3), n2);
                    fileOutput.print(Fmath.truncate(this.imagV[n], n3), n2);
                    break;
                }
                case 1: {
                    fileOutput.print(Complex.truncate(this.voltages[n], n3), n2);
                    break;
                }
                case 2: {
                    fileOutput.print(Fmath.truncate(this.voltageMagnitudes[n], n3), n2);
                    fileOutput.print(Fmath.truncate(this.voltagePhasesRad[n], n3), n2);
                    break;
                }
                case 3: {
                    fileOutput.print(Fmath.truncate(this.voltageMagnitudes[n], n3), n2);
                    fileOutput.print(Fmath.truncate(this.voltagePhasesDeg[n], n3), n2);
                    break;
                }
                case 4: {
                    fileOutput.print(Fmath.truncate(this.realZ[n], n3), n2);
                    fileOutput.print(Fmath.truncate(this.imagZ[n], n3), n2);
                    break;
                }
                case 5: {
                    fileOutput.print(Complex.truncate(this.impedances[n], n3), n2);
                    break;
                }
                case 6: {
                    fileOutput.print(Fmath.truncate(this.impedanceMagnitudes[n], n3), n2);
                    fileOutput.print(Fmath.truncate(this.impedancePhasesRad[n], n3), n2);
                    break;
                }
                case 7: {
                    fileOutput.print(Fmath.truncate(this.impedanceMagnitudes[n], n3), n2);
                    fileOutput.print(Fmath.truncate(this.impedancePhasesDeg[n], n3), n2);
                }
            }
            fileOutput.println();
        }
        fileOutput.close();
        return this.results;
    }

    public ArrayList<Object> printToExcelFile() {
        String string = "ImpedSpecRegressionOutput.txt";
        this.fileType = true;
        return this.printToExcelFile(string);
    }

    public ArrayList<Object> printToExcelFile(String string) {
        int n;
        if (!this.regressionDone) {
            this.regression();
        }
        int n2 = 11;
        int n3 = 4;
        int n4 = (string = string.trim()).indexOf(46);
        string = n4 == -1 ? string + ".xls" : string.substring(0, n4) + ".xls";
        FileOutput fileOutput = null;
        fileOutput = this.fileType ? new FileOutput(string, 'n') : new FileOutput(string);
        fileOutput.println("ImpedSpecRegression Program Output File:  " + this.regressionTitle);
        fileOutput.dateAndTimeln(string);
        fileOutput.println();
        if (this.modelSet) {
            fileOutput.println("Circuit - model number " + this.modelNumber);
        } else {
            fileOutput.println("Circuit supplied by the user");
        }
        fileOutput.println();
        fileOutput.println("Circuit Parameters");
        fileOutput.println("Best Estimates");
        fileOutput.printtab("Parameter", n2);
        fileOutput.printtab("Best", n2);
        fileOutput.printtab("Standard", n2);
        fileOutput.printtab("Coeff. of", n2);
        fileOutput.printtab("Pre-", n2);
        fileOutput.println("Post-");
        fileOutput.printtab("   ", n2);
        fileOutput.printtab("estimate", n2);
        fileOutput.printtab("deviation", n2);
        fileOutput.printtab("variation", n2);
        fileOutput.printtab("gradient", n2);
        fileOutput.println("gradient");
        for (n = 0; n < this.numberOfParameters; ++n) {
            fileOutput.printtab(this.parameterSymbols[n], n2);
            fileOutput.printtab(Fmath.truncate(this.bestEstimates[n], n3), n2);
            fileOutput.printtab(Fmath.truncate(this.standardDeviations[n], n3), n2);
            fileOutput.printtab(Fmath.truncate(this.coefficientsOfVariation[n], n3), n2);
            fileOutput.printtab(Fmath.truncate(this.preMinimumGradients[n], n3), n2);
            fileOutput.println(Fmath.truncate(this.postMinimumGradients[n], n3));
        }
        fileOutput.println();
        fileOutput.println("Initial Estimates");
        fileOutput.printtab("Parameter", n2);
        fileOutput.printtab("Initial", n2);
        fileOutput.println("initial");
        fileOutput.printtab("   ", n2);
        fileOutput.printtab("estimate", n2);
        fileOutput.println("step size");
        for (n = 0; n < this.numberOfParameters; ++n) {
            fileOutput.printtab(this.parameterSymbols[n], n2);
            fileOutput.printtab(Fmath.truncate(this.initialEstimates[n], n3), n2);
            fileOutput.println(Fmath.truncate(this.initialSteps[n], n3));
        }
        fileOutput.println();
        fileOutput.println("Sum of squares of the Real[Z] and Imag[z] residuals:         " + Fmath.truncate(this.sumOfSquares, n3));
        fileOutput.println("Reduced sum of squares of the Real[Z] and Imag[z] residuals: " + Fmath.truncate(this.sumOfSquares / (double)this.degreesOfFreedom, n3));
        fileOutput.println("Degrees of freedom: " + this.degreesOfFreedom);
        if (this.weightsSet) {
            fileOutput.println("Chi square:         " + Fmath.truncate(this.chiSquare, n3));
            fileOutput.println("Reduced chi square: " + Fmath.truncate(this.reducedChiSquare, n3));
        }
        fileOutput.println("Number of iterations taken in the first regression:      " + this.numberOfIterations1);
        fileOutput.println("Number of iterations taken in the second regression:     " + this.numberOfIterations2);
        fileOutput.println("Maximum number of iterations allowed in each regression: " + this.maximumIterations);
        fileOutput.println();
        n2 = 14;
        fileOutput.println("Fitted and entered data [frequencies, calculated impedances, data as entered]");
        fileOutput.print("Entered data type:  ");
        fileOutput.println(this.dataEnteredType[this.dataEnteredTypePointer]);
        fileOutput.println();
        fileOutput.printtab("Frequency", n2);
        fileOutput.printtab("Experimental", n2);
        fileOutput.printtab("Calculated", n2);
        fileOutput.printtab("Experimental", n2);
        fileOutput.printtab("Calculated", n2);
        switch (this.dataEnteredTypePointer) {
            case 0: {
                fileOutput.printtab("Real", n2);
                fileOutput.printtab("Imag", n2);
                break;
            }
            case 1: {
                fileOutput.printtab("Complex", n2);
                break;
            }
            case 2: {
                fileOutput.printtab("Magnitude", n2);
                fileOutput.printtab("Phase (rad)", n2);
                break;
            }
            case 3: {
                fileOutput.printtab("Magnitude", n2);
                fileOutput.printtab("Phase (deg)", n2);
                break;
            }
            case 4: {
                fileOutput.printtab("Real", n2);
                fileOutput.printtab("Imag", n2);
                break;
            }
            case 5: {
                fileOutput.printtab("Complex", n2);
                break;
            }
            case 6: {
                fileOutput.printtab("Magnitude", n2);
                fileOutput.printtab("Phase (rad)", n2);
                break;
            }
            case 7: {
                fileOutput.printtab("Magnitude", n2);
                fileOutput.printtab("Phase (deg)", n2);
            }
        }
        fileOutput.println();
        fileOutput.printtab("Frequency", n2);
        fileOutput.printtab("Real[Z]", n2);
        fileOutput.printtab("Real[Z]", n2);
        fileOutput.printtab("Imag[Z]", n2);
        fileOutput.printtab("Imag[Z]", n2);
        switch (this.dataEnteredTypePointer) {
            case 0: {
                fileOutput.printtab("[voltage]", n2);
                fileOutput.printtab("[voltage]", n2);
                break;
            }
            case 1: {
                fileOutput.printtab("voltage", n2);
                break;
            }
            case 2: {
                fileOutput.printtab("[voltage]", n2);
                fileOutput.printtab("[voltage]", n2);
                break;
            }
            case 3: {
                fileOutput.printtab("[voltage]", n2);
                fileOutput.printtab("[voltage]", n2);
                break;
            }
            case 4: {
                fileOutput.printtab("[impedance]", n2);
                fileOutput.printtab("[impedance]", n2);
                break;
            }
            case 5: {
                fileOutput.printtab("impedance", n2);
                break;
            }
            case 6: {
                fileOutput.printtab("[impedance]", n2);
                fileOutput.printtab("[impedance]", n2);
                break;
            }
            case 7: {
                fileOutput.printtab("[impedance]", n2);
                fileOutput.printtab("[impedance]", n2);
            }
        }
        fileOutput.println();
        for (n = 0; n < this.numberOfFrequencies; ++n) {
            fileOutput.printtab(Fmath.truncate(this.frequencies[n], n3), n2);
            fileOutput.printtab(Fmath.truncate(this.realZ[n], n3), n2);
            fileOutput.printtab(Fmath.truncate(this.calculatedRealZ[n], n3), n2);
            fileOutput.printtab(Fmath.truncate(this.imagZ[n], n3), n2);
            fileOutput.printtab(Fmath.truncate(this.calculatedImagZ[n], n3), n2);
            switch (this.dataEnteredTypePointer) {
                case 0: {
                    fileOutput.printtab(Fmath.truncate(this.realV[n], n3), n2);
                    fileOutput.printtab(Fmath.truncate(this.imagV[n], n3), n2);
                    break;
                }
                case 1: {
                    fileOutput.printtab(Complex.truncate(this.voltages[n], n3), n2);
                    break;
                }
                case 2: {
                    fileOutput.printtab(Fmath.truncate(this.voltageMagnitudes[n], n3), n2);
                    fileOutput.printtab(Fmath.truncate(this.voltagePhasesRad[n], n3), n2);
                    break;
                }
                case 3: {
                    fileOutput.printtab(Fmath.truncate(this.voltageMagnitudes[n], n3), n2);
                    fileOutput.printtab(Fmath.truncate(this.voltagePhasesDeg[n], n3), n2);
                    break;
                }
                case 4: {
                    fileOutput.printtab(Fmath.truncate(this.realZ[n], n3), n2);
                    fileOutput.printtab(Fmath.truncate(this.imagZ[n], n3), n2);
                    break;
                }
                case 5: {
                    fileOutput.printtab(Complex.truncate(this.impedances[n], n3), n2);
                    break;
                }
                case 6: {
                    fileOutput.printtab(Fmath.truncate(this.impedanceMagnitudes[n], n3), n2);
                    fileOutput.printtab(Fmath.truncate(this.impedancePhasesRad[n], n3), n2);
                    break;
                }
                case 7: {
                    fileOutput.printtab(Fmath.truncate(this.impedanceMagnitudes[n], n3), n2);
                    fileOutput.printtab(Fmath.truncate(this.impedancePhasesDeg[n], n3), n2);
                }
            }
            fileOutput.println();
        }
        fileOutput.close();
        return this.results;
    }
}

