/*
 * Decompiled with CFR 0.152.
 */
package flanagan.circuits;

import flanagan.circuits.Impedance;
import flanagan.circuits.TransmissionLine;

public class ParallelPlateLine
extends TransmissionLine {
    private double plateWidth = -1.0;
    private double plateSeparation = -1.0;
    private boolean distancesSet = false;
    private double relativePermittivity = 1.0;
    private double relativePermeability = 1.0;

    public ParallelPlateLine() {
        this.title = "Parallel Plate Line";
    }

    public ParallelPlateLine(String string) {
        this.title = string;
    }

    public void setPlateWidth(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("The plate width, " + d + ", must be greater than zero");
        }
        this.plateWidth = d;
        if (this.plateSeparation != -1.0) {
            this.distancesSet = true;
        }
        if (this.distancesSet) {
            this.calculateDistributedCapacitanceAndInductance();
        }
    }

    public void setPlateSeparation(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("The plate separation, " + d + ", must be greater than zero");
        }
        this.plateSeparation = d;
        if (this.plateWidth != -1.0) {
            this.distancesSet = true;
        }
        if (this.distancesSet) {
            this.calculateDistributedCapacitanceAndInductance();
        }
    }

    public void setRelativePermittivity(double d) {
        this.relativePermittivity = d;
        if (this.distancesSet) {
            this.calculateDistributedCapacitanceAndInductance();
        }
    }

    public void setRelativePermeability(double d) {
        this.relativePermeability = d;
        if (this.distancesSet) {
            this.calculateDistributedCapacitanceAndInductance();
        }
    }

    private void calculateDistributedCapacitanceAndInductance() {
        this.distributedCapacitance = Impedance.parallelPlateCapacitance(1.0, this.plateWidth, this.plateSeparation, this.relativePermittivity);
        this.distributedInductance = Impedance.parallelPlateInductance(1.0, this.plateWidth, this.plateSeparation, this.relativePermeability);
    }

    @Override
    public ParallelPlateLine copy() {
        if (this == null) {
            return null;
        }
        ParallelPlateLine parallelPlateLine = new ParallelPlateLine();
        parallelPlateLine.plateWidth = this.plateWidth;
        parallelPlateLine.plateSeparation = this.plateSeparation;
        parallelPlateLine.distancesSet = this.distancesSet;
        parallelPlateLine.relativePermittivity = this.relativePermittivity;
        parallelPlateLine.relativePermeability = this.relativePermeability;
        parallelPlateLine.title = this.title;
        parallelPlateLine.distributedResistance = this.distributedResistance;
        parallelPlateLine.distributedConductance = this.distributedConductance;
        parallelPlateLine.distributedCapacitance = this.distributedCapacitance;
        parallelPlateLine.distributedInductance = this.distributedInductance;
        parallelPlateLine.distributedImpedance = this.distributedImpedance.copy();
        parallelPlateLine.distributedAdmittance = this.distributedAdmittance.copy();
        parallelPlateLine.loadImpedance = this.loadImpedance.copy();
        parallelPlateLine.lineLength = this.lineLength;
        parallelPlateLine.segmentLength = this.segmentLength;
        parallelPlateLine.frequency = this.frequency;
        parallelPlateLine.segmentLength = this.segmentLength;
        parallelPlateLine.omega = this.omega;
        parallelPlateLine.inputVoltage = this.inputVoltage.copy();
        parallelPlateLine.inputCurrent = this.inputCurrent.copy();
        parallelPlateLine.outputVoltage = this.outputVoltage.copy();
        parallelPlateLine.outputCurrent = this.outputCurrent.copy();
        parallelPlateLine.idealWavelength = this.idealWavelength;
        parallelPlateLine.generalWavelength = this.generalWavelength;
        parallelPlateLine.lowLossWavelength = this.lowLossWavelength;
        parallelPlateLine.idealPhaseVelocity = this.idealPhaseVelocity;
        parallelPlateLine.generalPhaseVelocity = this.generalPhaseVelocity;
        parallelPlateLine.lowLossPhaseVelocity = this.lowLossPhaseVelocity;
        parallelPlateLine.idealGroupVelocity = this.idealGroupVelocity;
        parallelPlateLine.generalGroupVelocity = this.generalGroupVelocity;
        parallelPlateLine.lowLossGroupVelocity = this.lowLossGroupVelocity;
        parallelPlateLine.delta = this.delta;
        parallelPlateLine.idealAttenuationConstant = this.idealAttenuationConstant;
        parallelPlateLine.generalAttenuationConstant = this.generalAttenuationConstant;
        parallelPlateLine.lowLossAttenuationConstant = this.lowLossAttenuationConstant;
        parallelPlateLine.idealPhaseConstant = this.idealPhaseConstant;
        parallelPlateLine.generalPhaseConstant = this.generalPhaseConstant;
        parallelPlateLine.lowLossPhaseConstant = this.lowLossPhaseConstant;
        parallelPlateLine.idealPropagationConstant = this.idealPropagationConstant.copy();
        parallelPlateLine.loadImpedance = this.loadImpedance.copy();
        parallelPlateLine.loadImpedance = this.loadImpedance.copy();
        parallelPlateLine.loadImpedance = this.loadImpedance.copy();
        parallelPlateLine.generalPropagationConstant = this.generalPropagationConstant.copy();
        parallelPlateLine.lowLossPropagationConstant = this.lowLossPropagationConstant.copy();
        parallelPlateLine.idealCharacteristicImpedance = this.idealCharacteristicImpedance.copy();
        parallelPlateLine.idealRealCharacteristicImpedance = this.idealRealCharacteristicImpedance;
        parallelPlateLine.generalCharacteristicImpedance = this.generalCharacteristicImpedance.copy();
        parallelPlateLine.lowLossCharacteristicImpedance = this.lowLossCharacteristicImpedance.copy();
        parallelPlateLine.idealInputImpedance = this.idealInputImpedance.copy();
        parallelPlateLine.generalInputImpedance = this.generalInputImpedance.copy();
        parallelPlateLine.lowLossInputImpedance = this.lowLossInputImpedance.copy();
        parallelPlateLine.idealShortedLineImpedance = this.idealShortedLineImpedance.copy();
        parallelPlateLine.generalShortedLineImpedance = this.generalShortedLineImpedance.copy();
        parallelPlateLine.lowLossShortedLineImpedance = this.lowLossShortedLineImpedance.copy();
        parallelPlateLine.idealOpenLineImpedance = this.idealOpenLineImpedance.copy();
        parallelPlateLine.generalOpenLineImpedance = this.generalOpenLineImpedance.copy();
        parallelPlateLine.lowLossOpenLineImpedance = this.lowLossOpenLineImpedance.copy();
        parallelPlateLine.idealQuarterWaveLineImpedance = this.idealQuarterWaveLineImpedance.copy();
        parallelPlateLine.generalQuarterWaveLineImpedance = this.generalQuarterWaveLineImpedance.copy();
        parallelPlateLine.lowLossQuarterWaveLineImpedance = this.lowLossQuarterWaveLineImpedance.copy();
        parallelPlateLine.idealHalfWaveLineImpedance = this.idealHalfWaveLineImpedance.copy();
        parallelPlateLine.generalHalfWaveLineImpedance = this.generalHalfWaveLineImpedance.copy();
        parallelPlateLine.lowLossHalfWaveLineImpedance = this.lowLossHalfWaveLineImpedance.copy();
        parallelPlateLine.idealRefectionCoefficient = this.idealRefectionCoefficient.copy();
        parallelPlateLine.generalRefectionCoefficient = this.generalRefectionCoefficient.copy();
        parallelPlateLine.lowLossRefectionCoefficient = this.lowLossRefectionCoefficient.copy();
        parallelPlateLine.idealStandingWaveRatio = this.idealStandingWaveRatio;
        parallelPlateLine.generalStandingWaveRatio = this.generalStandingWaveRatio;
        parallelPlateLine.lowLossStandingWaveRatio = this.lowLossStandingWaveRatio;
        parallelPlateLine.idealABCDmatrix = this.idealABCDmatrix.copy();
        parallelPlateLine.generalABCDmatrix = this.generalABCDmatrix.copy();
        parallelPlateLine.lowLossABCDmatrix = this.lowLossABCDmatrix.copy();
        parallelPlateLine.numberOfPoints = this.numberOfPoints;
        return parallelPlateLine;
    }

    @Override
    public Object clone() {
        ParallelPlateLine parallelPlateLine = null;
        if (this != null) {
            ParallelPlateLine parallelPlateLine2 = new ParallelPlateLine();
            parallelPlateLine2.plateWidth = this.plateWidth;
            parallelPlateLine2.plateSeparation = this.plateSeparation;
            parallelPlateLine2.distancesSet = this.distancesSet;
            parallelPlateLine2.relativePermittivity = this.relativePermittivity;
            parallelPlateLine2.relativePermeability = this.relativePermeability;
            parallelPlateLine2.title = this.title;
            parallelPlateLine2.distributedResistance = this.distributedResistance;
            parallelPlateLine2.distributedConductance = this.distributedConductance;
            parallelPlateLine2.distributedCapacitance = this.distributedCapacitance;
            parallelPlateLine2.distributedInductance = this.distributedInductance;
            parallelPlateLine2.distributedImpedance = this.distributedImpedance.copy();
            parallelPlateLine2.distributedAdmittance = this.distributedAdmittance.copy();
            parallelPlateLine2.loadImpedance = this.loadImpedance.copy();
            parallelPlateLine2.lineLength = this.lineLength;
            parallelPlateLine2.segmentLength = this.segmentLength;
            parallelPlateLine2.frequency = this.frequency;
            parallelPlateLine2.segmentLength = this.segmentLength;
            parallelPlateLine2.omega = this.omega;
            parallelPlateLine2.inputVoltage = this.inputVoltage.copy();
            parallelPlateLine2.inputCurrent = this.inputCurrent.copy();
            parallelPlateLine2.outputVoltage = this.outputVoltage.copy();
            parallelPlateLine2.outputCurrent = this.outputCurrent.copy();
            parallelPlateLine2.idealWavelength = this.idealWavelength;
            parallelPlateLine2.generalWavelength = this.generalWavelength;
            parallelPlateLine2.lowLossWavelength = this.lowLossWavelength;
            parallelPlateLine2.idealPhaseVelocity = this.idealPhaseVelocity;
            parallelPlateLine2.generalPhaseVelocity = this.generalPhaseVelocity;
            parallelPlateLine2.lowLossPhaseVelocity = this.lowLossPhaseVelocity;
            parallelPlateLine2.idealGroupVelocity = this.idealGroupVelocity;
            parallelPlateLine2.generalGroupVelocity = this.generalGroupVelocity;
            parallelPlateLine2.lowLossGroupVelocity = this.lowLossGroupVelocity;
            parallelPlateLine2.delta = this.delta;
            parallelPlateLine2.idealAttenuationConstant = this.idealAttenuationConstant;
            parallelPlateLine2.generalAttenuationConstant = this.generalAttenuationConstant;
            parallelPlateLine2.lowLossAttenuationConstant = this.lowLossAttenuationConstant;
            parallelPlateLine2.idealPhaseConstant = this.idealPhaseConstant;
            parallelPlateLine2.generalPhaseConstant = this.generalPhaseConstant;
            parallelPlateLine2.lowLossPhaseConstant = this.lowLossPhaseConstant;
            parallelPlateLine2.idealPropagationConstant = this.idealPropagationConstant.copy();
            parallelPlateLine2.loadImpedance = this.loadImpedance.copy();
            parallelPlateLine2.loadImpedance = this.loadImpedance.copy();
            parallelPlateLine2.loadImpedance = this.loadImpedance.copy();
            parallelPlateLine2.generalPropagationConstant = this.generalPropagationConstant.copy();
            parallelPlateLine2.lowLossPropagationConstant = this.lowLossPropagationConstant.copy();
            parallelPlateLine2.idealCharacteristicImpedance = this.idealCharacteristicImpedance.copy();
            parallelPlateLine2.idealRealCharacteristicImpedance = this.idealRealCharacteristicImpedance;
            parallelPlateLine2.generalCharacteristicImpedance = this.generalCharacteristicImpedance.copy();
            parallelPlateLine2.lowLossCharacteristicImpedance = this.lowLossCharacteristicImpedance.copy();
            parallelPlateLine2.idealInputImpedance = this.idealInputImpedance.copy();
            parallelPlateLine2.generalInputImpedance = this.generalInputImpedance.copy();
            parallelPlateLine2.lowLossInputImpedance = this.lowLossInputImpedance.copy();
            parallelPlateLine2.idealShortedLineImpedance = this.idealShortedLineImpedance.copy();
            parallelPlateLine2.generalShortedLineImpedance = this.generalShortedLineImpedance.copy();
            parallelPlateLine2.lowLossShortedLineImpedance = this.lowLossShortedLineImpedance.copy();
            parallelPlateLine2.idealOpenLineImpedance = this.idealOpenLineImpedance.copy();
            parallelPlateLine2.generalOpenLineImpedance = this.generalOpenLineImpedance.copy();
            parallelPlateLine2.lowLossOpenLineImpedance = this.lowLossOpenLineImpedance.copy();
            parallelPlateLine2.idealQuarterWaveLineImpedance = this.idealQuarterWaveLineImpedance.copy();
            parallelPlateLine2.generalQuarterWaveLineImpedance = this.generalQuarterWaveLineImpedance.copy();
            parallelPlateLine2.lowLossQuarterWaveLineImpedance = this.lowLossQuarterWaveLineImpedance.copy();
            parallelPlateLine2.idealHalfWaveLineImpedance = this.idealHalfWaveLineImpedance.copy();
            parallelPlateLine2.generalHalfWaveLineImpedance = this.generalHalfWaveLineImpedance.copy();
            parallelPlateLine2.lowLossHalfWaveLineImpedance = this.lowLossHalfWaveLineImpedance.copy();
            parallelPlateLine2.idealRefectionCoefficient = this.idealRefectionCoefficient.copy();
            parallelPlateLine2.generalRefectionCoefficient = this.generalRefectionCoefficient.copy();
            parallelPlateLine2.lowLossRefectionCoefficient = this.lowLossRefectionCoefficient.copy();
            parallelPlateLine2.idealStandingWaveRatio = this.idealStandingWaveRatio;
            parallelPlateLine2.generalStandingWaveRatio = this.generalStandingWaveRatio;
            parallelPlateLine2.lowLossStandingWaveRatio = this.lowLossStandingWaveRatio;
            parallelPlateLine2.idealABCDmatrix = this.idealABCDmatrix.copy();
            parallelPlateLine2.generalABCDmatrix = this.generalABCDmatrix.copy();
            parallelPlateLine2.lowLossABCDmatrix = this.lowLossABCDmatrix.copy();
            parallelPlateLine2.numberOfPoints = this.numberOfPoints;
            parallelPlateLine = parallelPlateLine2;
        }
        return parallelPlateLine;
    }
}

