/*
 * Decompiled with CFR 0.152.
 */
package flanagan.circuits;

import flanagan.circuits.Phasor;
import flanagan.complex.Complex;
import flanagan.complex.ComplexMatrix;
import flanagan.math.Fmath;
import flanagan.math.Matrix;

public class PhasorMatrix {
    private int nrow = 0;
    private int ncol = 0;
    private Phasor[][] matrix = null;
    private int[] index = null;
    private double dswap = 1.0;
    private static final double TINY = 1.0E-30;

    public PhasorMatrix(int n, int n2) {
        this.nrow = n;
        this.ncol = n2;
        this.matrix = Phasor.twoDarray(n, n2);
        this.index = new int[n];
        for (int j = 0; j < n; ++j) {
            this.index[j] = j;
        }
        this.dswap = 1.0;
    }

    public PhasorMatrix(int n, int n2, Phasor phasor) {
        this.nrow = n;
        this.ncol = n2;
        this.matrix = Phasor.twoDarray(n, n2, phasor);
        this.index = new int[n];
        for (int j = 0; j < n; ++j) {
            this.index[j] = j;
        }
        this.dswap = 1.0;
    }

    public PhasorMatrix(Phasor[][] phasorArray) {
        int n;
        this.nrow = phasorArray.length;
        this.ncol = phasorArray[0].length;
        for (n = 0; n < this.nrow; ++n) {
            if (phasorArray[n].length == this.ncol) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        this.matrix = phasorArray;
        this.index = new int[this.nrow];
        for (n = 0; n < this.nrow; ++n) {
            this.index[n] = n;
        }
        this.dswap = 1.0;
    }

    public PhasorMatrix(PhasorMatrix phasorMatrix) {
        this.nrow = phasorMatrix.nrow;
        this.ncol = phasorMatrix.ncol;
        this.matrix = phasorMatrix.matrix;
        this.index = phasorMatrix.index;
        this.dswap = phasorMatrix.dswap;
    }

    public void setTwoDarray(Phasor[][] phasorArray) {
        if (this.nrow != phasorArray.length) {
            throw new IllegalArgumentException("row length of this PhasorMatrix differs from that of the 2D array argument");
        }
        if (this.ncol != phasorArray[0].length) {
            throw new IllegalArgumentException("column length of this PhasorMatrix differs from that of the 2D array argument");
        }
        for (int j = 0; j < this.nrow; ++j) {
            if (phasorArray[j].length != this.ncol) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            for (int k = 0; k < this.ncol; ++k) {
                this.matrix[j][k] = Phasor.copy(phasorArray[j][k]);
            }
        }
    }

    public void setElement(int n, int n2, Phasor phasor) {
        this.matrix[n][n2] = Phasor.copy(phasor);
    }

    public void setElement(int n, int n2, double d, double d2) {
        this.matrix[n][n2].reset(d, d2);
    }

    public void setSubMatrix(int n, int n2, Phasor[][] phasorArray) {
        int n3 = phasorArray.length;
        int n4 = phasorArray[0].length;
        if (n > n3) {
            throw new IllegalArgumentException("row indices inverted");
        }
        if (n2 > n4) {
            throw new IllegalArgumentException("column indices inverted");
        }
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        for (int j = 0; j < n5; ++j) {
            for (int k = 0; k < n6; ++k) {
                this.matrix[n + j][n2 + k] = Phasor.copy(phasorArray[j][k]);
            }
        }
    }

    public void setSubMatrix(int n, int n2, int n3, int n4, Phasor[][] phasorArray) {
        if (n + n3 - 1 >= this.nrow) {
            throw new IllegalArgumentException("Sub-matrix position is outside the row bounds of this Matrix");
        }
        if (n2 + n4 - 1 >= this.ncol) {
            throw new IllegalArgumentException("Sub-matrix position is outside the column bounds of this Matrix");
        }
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        for (int j = 0; j < n5; ++j) {
            for (int k = 0; k < n6; ++k) {
                this.matrix[n + j][n2 + k] = Phasor.copy(phasorArray[j][k]);
            }
        }
    }

    public void setSubMatrix(int[] nArray, int[] nArray2, Phasor[][] phasorArray) {
        int n = nArray.length;
        int n2 = nArray2.length;
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                this.matrix[nArray[j]][nArray2[k]] = Phasor.copy(phasorArray[j][k]);
            }
        }
    }

    public static PhasorMatrix identityMatrix(int n) {
        PhasorMatrix phasorMatrix = new PhasorMatrix(n, n);
        for (int j = 0; j < n; ++j) {
            phasorMatrix.matrix[j][j] = Phasor.plusOne();
        }
        return phasorMatrix;
    }

    public static PhasorMatrix scalarMatrix(int n, Phasor phasor) {
        PhasorMatrix phasorMatrix = new PhasorMatrix(n, n);
        Phasor[][] phasorArray = phasorMatrix.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = j; k < n; ++k) {
                if (j != k) continue;
                phasorArray[j][k] = Phasor.copy(phasor);
            }
        }
        return phasorMatrix;
    }

    public static PhasorMatrix diagonalMatrix(int n, Phasor[] phasorArray) {
        if (phasorArray.length != n) {
            throw new IllegalArgumentException("matrix dimension differs from diagonal array length");
        }
        PhasorMatrix phasorMatrix = new PhasorMatrix(n, n);
        Phasor[][] phasorArray2 = phasorMatrix.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = j; k < n; ++k) {
                if (j != k) continue;
                phasorArray2[j][k] = Phasor.copy(phasorArray[j]);
            }
        }
        return phasorMatrix;
    }

    public static PhasorMatrix columnMatrix(Phasor[] phasorArray) {
        int n = phasorArray.length;
        PhasorMatrix phasorMatrix = new PhasorMatrix(n, 1);
        for (int j = 0; j < n; ++j) {
            phasorMatrix.matrix[j][0] = phasorArray[j];
        }
        return phasorMatrix;
    }

    public static PhasorMatrix rowMatrix(Phasor[] phasorArray) {
        int n = phasorArray.length;
        PhasorMatrix phasorMatrix = new PhasorMatrix(1, n);
        for (int j = 0; j < n; ++j) {
            phasorMatrix.matrix[0][j] = phasorArray[j];
        }
        return phasorMatrix;
    }

    public int getNrow() {
        return this.nrow;
    }

    public int getNcol() {
        return this.ncol;
    }

    public Phasor[][] getArrayReference() {
        return this.matrix;
    }

    public Phasor[][] getArray() {
        return this.matrix;
    }

    public Phasor[][] getArrayPointer() {
        return this.matrix;
    }

    public Phasor[][] getArrayCopy() {
        Phasor[][] phasorArray = new Phasor[this.nrow][this.ncol];
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < this.ncol; ++k) {
                phasorArray[j][k] = Phasor.copy(this.matrix[j][k]);
            }
        }
        return phasorArray;
    }

    public Phasor getElementReference(int n, int n2) {
        return this.matrix[n][n2];
    }

    public Phasor getElementPointer(int n, int n2) {
        return this.matrix[n][n2];
    }

    public Phasor getElementCopy(int n, int n2) {
        return Phasor.copy(this.matrix[n][n2]);
    }

    public PhasorMatrix getSubMatrix(int n, int n2, int n3, int n4) {
        if (n + n3 - 1 >= this.nrow) {
            throw new IllegalArgumentException("Sub-matrix position is outside the row bounds of this Matrix");
        }
        if (n2 + n4 - 1 >= this.ncol) {
            throw new IllegalArgumentException("Sub-matrix position is outside the column bounds of this Matrix");
        }
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        PhasorMatrix phasorMatrix = new PhasorMatrix(n5, n6);
        Phasor[][] phasorArray = phasorMatrix.getArrayReference();
        for (int j = 0; j < n5; ++j) {
            for (int k = 0; k < n6; ++k) {
                phasorArray[j][k] = Phasor.copy(this.matrix[n + j][n2 + k]);
            }
        }
        return phasorMatrix;
    }

    public PhasorMatrix getSubMatrix(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = nArray2.length;
        PhasorMatrix phasorMatrix = new PhasorMatrix(n, n2);
        Phasor[][] phasorArray = phasorMatrix.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                phasorArray[j][k] = Phasor.copy(this.matrix[nArray[j]][nArray2[k]]);
            }
        }
        return phasorMatrix;
    }

    public int[] getIndexReference() {
        return this.index;
    }

    public int[] getIndexPointer() {
        return this.index;
    }

    public int[] getIndexCopy() {
        int[] nArray = new int[this.nrow];
        for (int j = 0; j < this.nrow; ++j) {
            nArray[j] = this.index[j];
        }
        return nArray;
    }

    public double getSwap() {
        return this.dswap;
    }

    public static PhasorMatrix copy(PhasorMatrix phasorMatrix) {
        int n;
        if (phasorMatrix == null) {
            return null;
        }
        int n2 = phasorMatrix.getNrow();
        int n3 = phasorMatrix.getNcol();
        Phasor[][] phasorArray = phasorMatrix.getArrayReference();
        PhasorMatrix phasorMatrix2 = new PhasorMatrix(n2, n3);
        phasorMatrix2.nrow = n2;
        phasorMatrix2.ncol = n3;
        Phasor[][] phasorArray2 = phasorMatrix2.getArrayReference();
        for (n = 0; n < n2; ++n) {
            for (int j = 0; j < n3; ++j) {
                phasorArray2[n][j] = Phasor.copy(phasorArray[n][j]);
            }
        }
        for (n = 0; n < n2; ++n) {
            phasorMatrix2.index[n] = phasorMatrix.index[n];
        }
        return phasorMatrix2;
    }

    public PhasorMatrix copy() {
        int n;
        if (this == null) {
            return null;
        }
        int n2 = this.nrow;
        int n3 = this.ncol;
        PhasorMatrix phasorMatrix = new PhasorMatrix(n2, n3);
        Phasor[][] phasorArray = phasorMatrix.getArrayReference();
        phasorMatrix.nrow = n2;
        phasorMatrix.ncol = n3;
        for (n = 0; n < n2; ++n) {
            for (int j = 0; j < n3; ++j) {
                phasorArray[n][j] = Phasor.copy(this.matrix[n][j]);
            }
        }
        for (n = 0; n < n2; ++n) {
            phasorMatrix.index[n] = this.index[n];
        }
        return phasorMatrix;
    }

    public Object clone() {
        int n;
        if (this == null) {
            return null;
        }
        int n2 = this.nrow;
        int n3 = this.ncol;
        PhasorMatrix phasorMatrix = new PhasorMatrix(n2, n3);
        Phasor[][] phasorArray = phasorMatrix.getArrayReference();
        phasorMatrix.nrow = n2;
        phasorMatrix.ncol = n3;
        for (n = 0; n < n2; ++n) {
            for (int j = 0; j < n3; ++j) {
                phasorArray[n][j] = Phasor.copy(this.matrix[n][j]);
            }
        }
        for (n = 0; n < n2; ++n) {
            phasorMatrix.index[n] = this.index[n];
        }
        return phasorMatrix;
    }

    public static PhasorMatrix toPhasorRowMatrix(Phasor[] phasorArray) {
        int n = phasorArray.length;
        PhasorMatrix phasorMatrix = new PhasorMatrix(1, n);
        for (int j = 0; j < n; ++j) {
            phasorMatrix.matrix[0][j] = phasorArray[j].copy();
        }
        return phasorMatrix;
    }

    public static PhasorMatrix toPhasorRowMatrix(Complex[] complexArray) {
        int n = complexArray.length;
        PhasorMatrix phasorMatrix = new PhasorMatrix(1, n);
        for (int j = 0; j < n; ++j) {
            phasorMatrix.matrix[0][j] = Phasor.toPhasor(complexArray[j]).copy();
        }
        return phasorMatrix;
    }

    public static PhasorMatrix toPhasorRowMatrix(double[] dArray) {
        int n = dArray.length;
        PhasorMatrix phasorMatrix = new PhasorMatrix(1, n);
        for (int j = 0; j < n; ++j) {
            phasorMatrix.matrix[0][j] = new Phasor(dArray[j], 0.0);
        }
        return phasorMatrix;
    }

    public static PhasorMatrix toPhasorColumnMatrix(Phasor[] phasorArray) {
        int n = phasorArray.length;
        PhasorMatrix phasorMatrix = new PhasorMatrix(n, 1);
        for (int j = 0; j < n; ++j) {
            phasorMatrix.matrix[j][0] = phasorArray[j].copy();
        }
        return phasorMatrix;
    }

    public static PhasorMatrix toPhasorColumnMatrix(Complex[] complexArray) {
        int n = complexArray.length;
        PhasorMatrix phasorMatrix = new PhasorMatrix(n, 1);
        for (int j = 0; j < n; ++j) {
            phasorMatrix.matrix[j][0] = Phasor.toPhasor(complexArray[j]).copy();
        }
        return phasorMatrix;
    }

    public static PhasorMatrix toPhasorColumnMatrix(double[] dArray) {
        int n = dArray.length;
        PhasorMatrix phasorMatrix = new PhasorMatrix(n, 1);
        for (int j = 0; j < n; ++j) {
            phasorMatrix.matrix[j][0] = new Phasor(dArray[j], 0.0);
        }
        return phasorMatrix;
    }

    public static PhasorMatrix toPhasorMatrix(ComplexMatrix complexMatrix) {
        PhasorMatrix phasorMatrix = new PhasorMatrix(complexMatrix.getNrow(), complexMatrix.getNcol());
        phasorMatrix.index = complexMatrix.getIndexCopy();
        phasorMatrix.dswap = complexMatrix.getSwap();
        for (int j = 0; j < phasorMatrix.nrow; ++j) {
            int n = 0;
            while (n < phasorMatrix.ncol) {
                phasorMatrix.matrix[j][n] = Phasor.toPhasor(complexMatrix.getElementCopy(j, n));
                ++j;
            }
        }
        return phasorMatrix;
    }

    public static PhasorMatrix toPhasorMatrix(Complex[][] complexArray) {
        ComplexMatrix complexMatrix = new ComplexMatrix(complexArray);
        PhasorMatrix phasorMatrix = new PhasorMatrix(complexMatrix.getNrow(), complexMatrix.getNcol());
        for (int j = 0; j < phasorMatrix.nrow; ++j) {
            int n = 0;
            while (n < phasorMatrix.ncol) {
                phasorMatrix.matrix[j][n] = Phasor.toPhasor(complexMatrix.getElementCopy(j, n));
                ++j;
            }
        }
        return phasorMatrix;
    }

    public static PhasorMatrix toPhasorMatrix(Matrix matrix) {
        int n = matrix.getNrow();
        int n2 = matrix.getNcol();
        PhasorMatrix phasorMatrix = new PhasorMatrix(n, n2);
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                phasorMatrix.matrix[j][k].reset(matrix.getElementCopy(j, k), 0.0);
            }
        }
        return phasorMatrix;
    }

    public static PhasorMatrix toPhasorMatrix(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int j = 1; j < n; ++j) {
            if (dArray[j].length == n2) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        PhasorMatrix phasorMatrix = new PhasorMatrix(n, n2);
        for (int j = 0; j < phasorMatrix.nrow; ++j) {
            for (int k = 0; k < phasorMatrix.ncol; ++k) {
                phasorMatrix.matrix[j][k].reset(dArray[j][k], 0.0);
            }
        }
        return phasorMatrix;
    }

    public ComplexMatrix toComplexMatrix() {
        int n = this.getNrow();
        int n2 = this.getNcol();
        ComplexMatrix complexMatrix = new ComplexMatrix(n, n2);
        for (int j = 0; j < n; ++j) {
            int n3 = 0;
            while (n3 < n2) {
                complexMatrix.setElement(j, n3, this.matrix[j][n3].toRectangular());
                ++j;
            }
        }
        return complexMatrix;
    }

    public static ComplexMatrix toComplexMatrix(PhasorMatrix phasorMatrix) {
        int n = phasorMatrix.getNrow();
        int n2 = phasorMatrix.getNcol();
        ComplexMatrix complexMatrix = new ComplexMatrix(n, n2);
        for (int j = 0; j < n; ++j) {
            int n3 = 0;
            while (n3 < n2) {
                complexMatrix.setElement(j, n3, phasorMatrix.matrix[j][n3].toRectangular());
                ++j;
            }
        }
        return complexMatrix;
    }

    public PhasorMatrix plus(PhasorMatrix phasorMatrix) {
        if (this.nrow != phasorMatrix.nrow || this.ncol != phasorMatrix.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = phasorMatrix.nrow;
        int n2 = phasorMatrix.ncol;
        PhasorMatrix phasorMatrix2 = new PhasorMatrix(n, n2);
        Phasor[][] phasorArray = phasorMatrix2.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                phasorArray[j][k] = this.matrix[j][k].plus(phasorMatrix.matrix[j][k]);
            }
        }
        return phasorMatrix2;
    }

    public PhasorMatrix plus(Phasor[][] phasorArray) {
        int n = phasorArray.length;
        int n2 = phasorArray[0].length;
        if (this.nrow != n || this.ncol != n2) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        PhasorMatrix phasorMatrix = new PhasorMatrix(n, n2);
        Phasor[][] phasorArray2 = phasorMatrix.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                phasorArray2[j][k] = this.matrix[j][k].plus(phasorArray[j][k]);
            }
        }
        return phasorMatrix;
    }

    public PhasorMatrix plus(ComplexMatrix complexMatrix) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(complexMatrix);
        return this.plus(phasorMatrix);
    }

    public PhasorMatrix plus(Complex[][] complexArray) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(complexArray);
        return this.plus(phasorMatrix);
    }

    public PhasorMatrix plus(Matrix matrix) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(matrix);
        return this.plus(phasorMatrix);
    }

    public PhasorMatrix plus(double[][] dArray) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(dArray);
        return this.plus(phasorMatrix);
    }

    public void plusEquals(PhasorMatrix phasorMatrix) {
        if (this.nrow != phasorMatrix.nrow || this.ncol != phasorMatrix.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = phasorMatrix.nrow;
        int n2 = phasorMatrix.ncol;
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                this.matrix[j][k].plusEquals(phasorMatrix.matrix[j][k]);
            }
        }
    }

    public void plusEquals(Phasor[][] phasorArray) {
        PhasorMatrix phasorMatrix = new PhasorMatrix(phasorArray);
        this.plusEquals(phasorMatrix);
    }

    public void plusEquals(ComplexMatrix complexMatrix) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(complexMatrix);
        this.plusEquals(phasorMatrix);
    }

    public void plusEquals(Complex[][] complexArray) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(complexArray);
        this.plusEquals(phasorMatrix);
    }

    public void plusEquals(Matrix matrix) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(matrix);
        this.plusEquals(phasorMatrix);
    }

    public void plusEquals(double[][] dArray) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(dArray);
        this.plusEquals(phasorMatrix);
    }

    public PhasorMatrix minus(PhasorMatrix phasorMatrix) {
        if (this.nrow != phasorMatrix.nrow || this.ncol != phasorMatrix.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = this.nrow;
        int n2 = this.ncol;
        PhasorMatrix phasorMatrix2 = new PhasorMatrix(n, n2);
        Phasor[][] phasorArray = phasorMatrix2.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                phasorArray[j][k] = this.matrix[j][k].minus(phasorMatrix.matrix[j][k]);
            }
        }
        return phasorMatrix2;
    }

    public PhasorMatrix minus(Phasor[][] phasorArray) {
        int n = phasorArray.length;
        int n2 = phasorArray[0].length;
        if (this.nrow != n || this.ncol != n2) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        PhasorMatrix phasorMatrix = new PhasorMatrix(n, n2);
        Phasor[][] phasorArray2 = phasorMatrix.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                phasorArray2[j][k] = this.matrix[j][k].minus(phasorArray[j][k]);
            }
        }
        return phasorMatrix;
    }

    public PhasorMatrix minus(ComplexMatrix complexMatrix) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(complexMatrix);
        return this.minus(phasorMatrix);
    }

    public PhasorMatrix minus(Complex[][] complexArray) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(complexArray);
        return this.minus(phasorMatrix);
    }

    public PhasorMatrix minus(Matrix matrix) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(matrix);
        return this.minus(phasorMatrix);
    }

    public PhasorMatrix minus(double[][] dArray) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(dArray);
        return this.minus(phasorMatrix);
    }

    public void minusEquals(PhasorMatrix phasorMatrix) {
        if (this.nrow != phasorMatrix.nrow || this.ncol != phasorMatrix.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = phasorMatrix.nrow;
        int n2 = phasorMatrix.ncol;
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                this.matrix[j][k].minusEquals(phasorMatrix.matrix[j][k]);
            }
        }
    }

    public void minusEquals(Phasor[][] phasorArray) {
        PhasorMatrix phasorMatrix = new PhasorMatrix(phasorArray);
        this.minusEquals(phasorMatrix);
    }

    public void minusEquals(ComplexMatrix complexMatrix) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(complexMatrix);
        this.minusEquals(phasorMatrix);
    }

    public void minusEquals(Complex[][] complexArray) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(complexArray);
        this.minusEquals(phasorMatrix);
    }

    public void minusEquals(Matrix matrix) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(matrix);
        this.minusEquals(phasorMatrix);
    }

    public void minusEquals(double[][] dArray) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(dArray);
        this.minusEquals(phasorMatrix);
    }

    public PhasorMatrix times(PhasorMatrix phasorMatrix) {
        if (this.ncol != phasorMatrix.nrow) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        PhasorMatrix phasorMatrix2 = new PhasorMatrix(this.nrow, phasorMatrix.ncol);
        Phasor[][] phasorArray = phasorMatrix2.getArrayReference();
        Phasor phasor = new Phasor();
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < phasorMatrix.ncol; ++k) {
                phasor = Phasor.zero();
                for (int i2 = 0; i2 < this.ncol; ++i2) {
                    phasor.plusEquals(this.matrix[j][i2].times(phasorMatrix.matrix[i2][k]));
                }
                phasorArray[j][k] = Phasor.copy(phasor);
            }
        }
        return phasorMatrix2;
    }

    public PhasorMatrix times(Phasor[][] phasorArray) {
        int n = phasorArray.length;
        int n2 = phasorArray[0].length;
        if (this.ncol != n) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        PhasorMatrix phasorMatrix = new PhasorMatrix(this.nrow, n2);
        Phasor[][] phasorArray2 = phasorMatrix.getArrayReference();
        Phasor phasor = new Phasor();
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < n2; ++k) {
                phasor = Phasor.zero();
                for (int i2 = 0; i2 < this.ncol; ++i2) {
                    phasor.plusEquals(this.matrix[j][i2].times(phasorArray[i2][k]));
                }
                phasorArray2[j][k] = Phasor.copy(phasor);
            }
        }
        return phasorMatrix;
    }

    public PhasorMatrix times(ComplexMatrix complexMatrix) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(complexMatrix);
        return this.times(phasorMatrix);
    }

    public PhasorMatrix times(Complex[][] complexArray) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(complexArray);
        return this.times(phasorMatrix);
    }

    public PhasorMatrix times(Matrix matrix) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(matrix);
        return this.times(phasorMatrix);
    }

    public PhasorMatrix times(double[][] dArray) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(dArray);
        return this.times(phasorMatrix);
    }

    public PhasorMatrix times(Phasor phasor) {
        PhasorMatrix phasorMatrix = new PhasorMatrix(this.nrow, this.ncol);
        Phasor[][] phasorArray = phasorMatrix.getArrayReference();
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < this.ncol; ++k) {
                phasorArray[j][k] = this.matrix[j][k].times(phasor);
            }
        }
        return phasorMatrix;
    }

    public PhasorMatrix times(double d) {
        PhasorMatrix phasorMatrix = new PhasorMatrix(this.nrow, this.ncol);
        Phasor[][] phasorArray = phasorMatrix.getArrayReference();
        Phasor phasor = new Phasor(d, 0.0);
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < this.ncol; ++k) {
                phasorArray[j][k] = this.matrix[j][k].times(phasor);
            }
        }
        return phasorMatrix;
    }

    public void timesEquals(PhasorMatrix phasorMatrix) {
        if (this.ncol != phasorMatrix.nrow) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        Phasor phasor = new Phasor();
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < phasorMatrix.ncol; ++k) {
                phasor = Phasor.zero();
                for (int i2 = 0; i2 < this.ncol; ++i2) {
                    phasor.plusEquals(this.matrix[j][i2].times(phasorMatrix.matrix[i2][k]));
                }
                this.matrix[j][k] = Phasor.copy(phasor);
            }
        }
    }

    public void timesEquals(Phasor[][] phasorArray) {
        PhasorMatrix phasorMatrix = new PhasorMatrix(phasorArray);
        this.timesEquals(phasorMatrix);
    }

    public void timesEquals(ComplexMatrix complexMatrix) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(complexMatrix);
        this.timesEquals(phasorMatrix);
    }

    public void timesEquals(Complex[][] complexArray) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(complexArray);
        this.timesEquals(phasorMatrix);
    }

    public void timesEquals(Matrix matrix) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(matrix);
        this.timesEquals(phasorMatrix);
    }

    public void timesEquals(double[][] dArray) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(dArray);
        this.timesEquals(phasorMatrix);
    }

    public void timesEquals(Phasor phasor) {
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < this.ncol; ++k) {
                this.matrix[j][k].timesEquals(phasor);
            }
        }
    }

    public void timesEquals(Complex complex) {
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < this.ncol; ++k) {
                this.matrix[j][k].timesEquals(complex);
            }
        }
    }

    public void timesEquals(double d) {
        Phasor phasor = new Phasor(d, 0.0);
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < this.ncol; ++k) {
                this.matrix[j][k].timesEquals(phasor);
            }
        }
    }

    public void timesEquals(int n) {
        Phasor phasor = new Phasor(n, 0.0);
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < this.ncol; ++k) {
                this.matrix[j][k].timesEquals(phasor);
            }
        }
    }

    public PhasorMatrix over(PhasorMatrix phasorMatrix) {
        if (this.nrow != phasorMatrix.nrow || this.ncol != phasorMatrix.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        return this.times(phasorMatrix.inverse());
    }

    public PhasorMatrix over(Phasor[][] phasorArray) {
        int n = phasorArray.length;
        int n2 = phasorArray[0].length;
        if (this.nrow != n || this.ncol != n2) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        PhasorMatrix phasorMatrix = new PhasorMatrix(phasorArray);
        return this.times(phasorMatrix.inverse());
    }

    public PhasorMatrix over(ComplexMatrix complexMatrix) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(complexMatrix);
        return this.over(phasorMatrix);
    }

    public PhasorMatrix over(Complex[][] complexArray) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(complexArray);
        return this.over(phasorMatrix);
    }

    public PhasorMatrix over(Matrix matrix) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(matrix);
        return this.over(phasorMatrix);
    }

    public PhasorMatrix over(double[][] dArray) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(dArray);
        return this.over(phasorMatrix);
    }

    public void overEquals(PhasorMatrix phasorMatrix) {
        if (this.nrow != phasorMatrix.nrow || this.ncol != phasorMatrix.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        PhasorMatrix phasorMatrix2 = new PhasorMatrix(phasorMatrix);
        this.timesEquals(phasorMatrix2.inverse());
    }

    public void overEquals(Phasor[][] phasorArray) {
        PhasorMatrix phasorMatrix = new PhasorMatrix(phasorArray);
        this.overEquals(phasorMatrix);
    }

    public void overEquals(ComplexMatrix complexMatrix) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(complexMatrix);
        this.overEquals(phasorMatrix);
    }

    public void overEquals(Complex[][] complexArray) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(complexArray);
        this.overEquals(phasorMatrix);
    }

    public void overEquals(Matrix matrix) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(matrix);
        this.overEquals(phasorMatrix);
    }

    public void overEquals(double[][] dArray) {
        PhasorMatrix phasorMatrix = PhasorMatrix.toPhasorMatrix(dArray);
        this.overEquals(phasorMatrix);
    }

    public PhasorMatrix inverse() {
        int n = this.nrow;
        if (n != this.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Phasor[] phasorArray = new Phasor[n];
        Phasor[] phasorArray2 = new Phasor[n];
        PhasorMatrix phasorMatrix = new PhasorMatrix(n, n);
        Phasor[][] phasorArray3 = phasorMatrix.getArrayReference();
        PhasorMatrix phasorMatrix2 = this.luDecomp();
        for (int j = 0; j < n; ++j) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                phasorArray[n2] = Phasor.zero();
            }
            phasorArray[j] = Phasor.plusOne();
            phasorArray2 = phasorMatrix2.luBackSub(phasorArray);
            for (n2 = 0; n2 < n; ++n2) {
                phasorArray3[n2][j] = Phasor.copy(phasorArray2[n2]);
            }
        }
        return phasorMatrix;
    }

    public PhasorMatrix transpose() {
        PhasorMatrix phasorMatrix = new PhasorMatrix(this.ncol, this.nrow);
        Phasor[][] phasorArray = phasorMatrix.getArrayReference();
        for (int j = 0; j < this.ncol; ++j) {
            for (int k = 0; k < this.nrow; ++k) {
                phasorArray[j][k] = Phasor.copy(this.matrix[k][j]);
            }
        }
        return phasorMatrix;
    }

    public PhasorMatrix conjugate() {
        PhasorMatrix phasorMatrix = PhasorMatrix.copy(this);
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < this.ncol; ++k) {
                phasorMatrix.matrix[j][k] = this.matrix[j][k].conjugate();
            }
        }
        return phasorMatrix;
    }

    public PhasorMatrix adjoin() {
        PhasorMatrix phasorMatrix = PhasorMatrix.copy(this);
        phasorMatrix = phasorMatrix.transpose();
        phasorMatrix = phasorMatrix.conjugate();
        return phasorMatrix;
    }

    public PhasorMatrix opposite() {
        PhasorMatrix phasorMatrix = PhasorMatrix.copy(this);
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < this.ncol; ++k) {
                phasorMatrix.matrix[j][k] = this.matrix[j][k].times(Phasor.minusOne());
            }
        }
        return phasorMatrix;
    }

    public Phasor trace() {
        Phasor phasor = new Phasor(0.0, 0.0);
        for (int j = 0; j < Math.min(this.ncol, this.ncol); ++j) {
            phasor.plusEquals(this.matrix[j][j]);
        }
        return phasor;
    }

    public Phasor determinant() {
        int n = this.nrow;
        if (n != this.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Phasor phasor = new Phasor();
        PhasorMatrix phasorMatrix = this.luDecomp();
        phasor.reset(phasorMatrix.dswap, 0.0);
        for (int j = 0; j < n; ++j) {
            phasor.timesEquals(phasorMatrix.matrix[j][j]);
        }
        return phasor;
    }

    public Phasor logDeterminant() {
        int n = this.nrow;
        if (n != this.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Phasor phasor = new Phasor();
        PhasorMatrix phasorMatrix = this.luDecomp();
        phasor.reset(phasorMatrix.dswap, 0.0);
        phasor = Phasor.log(phasor);
        for (int j = 0; j < n; ++j) {
            phasor.plusEquals(Phasor.log(phasorMatrix.matrix[j][j]));
        }
        return phasor;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < this.ncol; ++k) {
                d = Fmath.hypot(d, this.matrix[j][k].abs());
            }
        }
        return d;
    }

    public double oneNorm() {
        double d = 0.0;
        double d2 = 0.0;
        for (int j = 0; j < this.nrow; ++j) {
            d2 = 0.0;
            for (int k = 0; k < this.ncol; ++k) {
                d2 += this.matrix[j][k].abs();
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public double infinityNorm() {
        double d = 0.0;
        double d2 = 0.0;
        for (int j = 0; j < this.nrow; ++j) {
            d2 = 0.0;
            for (int k = 0; k < this.ncol; ++k) {
                d2 += this.matrix[j][k].abs();
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public PhasorMatrix luDecomp() {
        int n;
        int n2;
        if (this.nrow != this.ncol) {
            throw new IllegalArgumentException("A matrix is not square");
        }
        int n3 = this.nrow;
        int n4 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray = new double[n3];
        Phasor phasor = new Phasor();
        Phasor phasor2 = new Phasor();
        PhasorMatrix phasorMatrix = PhasorMatrix.copy(this);
        Phasor[][] phasorArray = phasorMatrix.getArrayReference();
        phasorMatrix.dswap = 1.0;
        for (n2 = 0; n2 < n3; ++n2) {
            d3 = 0.0;
            for (n = 0; n < n3; ++n) {
                double d4;
                d2 = phasorArray[n2][n].abs();
                if (!(d4 > d3)) continue;
                d3 = d2;
            }
            if (d3 == 0.0) {
                throw new ArithmeticException("Singular matrix");
            }
            dArray[n2] = 1.0 / d3;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n5;
            for (n = 0; n < n2; ++n) {
                phasor = Phasor.copy(phasorArray[n][n2]);
                for (n5 = 0; n5 < n; ++n5) {
                    phasor.minusEquals(phasorArray[n][n5].times(phasorArray[n5][n2]));
                }
                phasorArray[n][n2] = Phasor.copy(phasor);
            }
            d3 = 0.0;
            for (n = n2; n < n3; ++n) {
                double d5;
                phasor = Phasor.copy(phasorArray[n][n2]);
                for (n5 = 0; n5 < n2; ++n5) {
                    phasor.minusEquals(phasorArray[n][n5].times(phasorArray[n5][n2]));
                }
                phasorArray[n][n2] = Phasor.copy(phasor);
                d = dArray[n] * phasor.abs();
                if (!(d5 >= d3)) continue;
                d3 = d;
                n4 = n;
            }
            if (n2 != n4) {
                for (n = 0; n < n3; ++n) {
                    phasor2 = Phasor.copy(phasorArray[n4][n]);
                    phasorArray[n4][n] = Phasor.copy(phasorArray[n2][n]);
                    phasorArray[n2][n] = Phasor.copy(phasor2);
                }
                phasorMatrix.dswap = -phasorMatrix.dswap;
                dArray[n4] = dArray[n2];
            }
            phasorMatrix.index[n2] = n4;
            if (phasorArray[n2][n2].isZero()) {
                phasorArray[n2][n2].reset(1.0E-30, 0.0);
            }
            if (n2 == n3 - 1) continue;
            phasor2 = phasorArray[n2][n2].inverse();
            for (n = n2 + 1; n < n3; ++n) {
                phasorArray[n][n2].timesEquals(phasor2);
            }
        }
        return phasorMatrix;
    }

    public Phasor[] luBackSub(Phasor[] phasorArray) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = phasorArray.length;
        if (n5 != this.ncol) {
            throw new IllegalArgumentException("vector length is not equal to matrix dimension");
        }
        if (this.ncol != this.nrow) {
            throw new IllegalArgumentException("matrix is not square");
        }
        Phasor phasor = new Phasor();
        Phasor[] phasorArray2 = new Phasor[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            phasorArray2[n2] = Phasor.copy(phasorArray[n2]);
        }
        for (n2 = 0; n2 < n5; ++n2) {
            n4 = this.index[n2];
            phasor = Phasor.copy(phasorArray2[n4]);
            phasorArray2[n4] = Phasor.copy(phasorArray2[n2]);
            if (n3 == 0) {
                for (n = n3; n <= n2 - 1; ++n) {
                    phasor.minusEquals(this.matrix[n2][n].times(phasorArray2[n]));
                }
            } else if (phasor.isZero()) {
                n3 = n2;
            }
            phasorArray2[n2] = Phasor.copy(phasor);
        }
        for (n2 = n5 - 1; n2 >= 0; --n2) {
            phasor = Phasor.copy(phasorArray2[n2]);
            for (n = n2 + 1; n < n5; ++n) {
                phasor.minusEquals(this.matrix[n2][n].times(phasorArray2[n]));
            }
            phasorArray2[n2] = phasor.over(this.matrix[n2][n2]);
        }
        return phasorArray2;
    }

    public Phasor[] solveLinearSet(Phasor[] phasorArray) {
        PhasorMatrix phasorMatrix = this.luDecomp();
        return phasorMatrix.luBackSub(phasorArray);
    }
}

