/*
 * Decompiled with CFR 0.152.
 */
package flanagan.circuits;

import flanagan.circuits.Phasor;
import flanagan.complex.Complex;
import flanagan.complex.ComplexMatrix;
import flanagan.math.Fmath;
import flanagan.plot.PlotGraph;

public class TransmissionLine {
    protected String title = "Transmission Line";
    protected double distributedResistance = 0.0;
    protected double distributedConductance = 0.0;
    protected double distributedCapacitance = 0.0;
    protected double distributedInductance = 0.0;
    protected Complex distributedImpedance = null;
    protected Complex distributedAdmittance = null;
    protected Complex loadImpedance = Complex.plusInfinity();
    protected double lineLength = -1.0;
    protected double segmentLength = -1.0;
    protected double frequency = 0.0;
    protected double omega = 0.0;
    protected Complex inputVoltage = null;
    protected Complex inputCurrent = null;
    protected Complex outputVoltage = null;
    protected Complex outputCurrent = null;
    protected double idealWavelength = 0.0;
    protected double generalWavelength = 0.0;
    protected double lowLossWavelength = 0.0;
    protected double idealPhaseVelocity = 0.0;
    protected double generalPhaseVelocity = 0.0;
    protected double lowLossPhaseVelocity = 0.0;
    protected double idealGroupVelocity = 0.0;
    protected double generalGroupVelocity = 0.0;
    protected double lowLossGroupVelocity = 0.0;
    protected double delta = 0.001;
    protected double idealAttenuationConstant = 0.0;
    protected double generalAttenuationConstant = 0.0;
    protected double lowLossAttenuationConstant = 0.0;
    protected double idealPhaseConstant = 0.0;
    protected double generalPhaseConstant = 0.0;
    protected double lowLossPhaseConstant = 0.0;
    protected Complex idealPropagationConstant = null;
    protected Complex generalPropagationConstant = null;
    protected Complex lowLossPropagationConstant = null;
    protected Complex idealCharacteristicImpedance = null;
    protected double idealRealCharacteristicImpedance = 0.0;
    protected Complex generalCharacteristicImpedance = null;
    protected Complex lowLossCharacteristicImpedance = null;
    protected Complex idealInputImpedance = null;
    protected Complex generalInputImpedance = null;
    protected Complex lowLossInputImpedance = null;
    protected Complex idealShortedLineImpedance = null;
    protected Complex generalShortedLineImpedance = null;
    protected Complex lowLossShortedLineImpedance = null;
    protected Complex idealOpenLineImpedance = null;
    protected Complex generalOpenLineImpedance = null;
    protected Complex lowLossOpenLineImpedance = null;
    protected Complex idealQuarterWaveLineImpedance = null;
    protected Complex generalQuarterWaveLineImpedance = null;
    protected Complex lowLossQuarterWaveLineImpedance = null;
    protected Complex idealHalfWaveLineImpedance = null;
    protected Complex generalHalfWaveLineImpedance = null;
    protected Complex lowLossHalfWaveLineImpedance = null;
    protected Complex idealRefectionCoefficient = null;
    protected Complex generalRefectionCoefficient = null;
    protected Complex lowLossRefectionCoefficient = null;
    protected double idealStandingWaveRatio = 0.0;
    protected double generalStandingWaveRatio = 0.0;
    protected double lowLossStandingWaveRatio = 0.0;
    protected ComplexMatrix idealABCDmatrix = null;
    protected ComplexMatrix generalABCDmatrix = null;
    protected ComplexMatrix lowLossABCDmatrix = null;
    protected int numberOfPoints = 1000;

    public TransmissionLine() {
    }

    public TransmissionLine(String string) {
        this.title = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setFrequency(double d) {
        this.frequency = d;
        this.omega = this.frequency * 2.0 * Math.PI;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public double getRadialFrequency() {
        return this.omega;
    }

    public void setLoadImpedance(double d) {
        this.loadImpedance = new Complex(d, 0.0);
    }

    public void setLoadImpedance(Complex complex) {
        this.loadImpedance = complex;
    }

    public Complex getLoadImpedance() {
        return this.loadImpedance;
    }

    public void setLineLength(double d) {
        this.lineLength = d;
    }

    public double getLineLength() {
        return this.lineLength;
    }

    public void setSegmentLength(double d) {
        this.segmentLength = d;
    }

    public void setOutputVoltage(Phasor phasor) {
        this.outputVoltage = Phasor.toRectangular(phasor);
    }

    public void setOutputVoltage(Complex complex) {
        this.outputVoltage = complex;
    }

    public void setOutputVoltage(double d, double d2) {
        this.outputVoltage = new Complex();
        this.outputVoltage.polar(d, d2);
    }

    public void setOutputCurrent(Phasor phasor) {
        this.outputCurrent = Phasor.toRectangular(phasor);
    }

    public void setOutputCurrent(Complex complex) {
        this.outputCurrent = complex;
    }

    public void setOutputCurrent(double d, double d2) {
        this.outputCurrent = new Complex();
        this.outputCurrent.polar(d, d2);
    }

    public void setDistributedResistance(double d) {
        this.distributedResistance = d;
    }

    public void setDistributedInductance(double d) {
        this.distributedInductance = d;
    }

    public void setDistributedCapacitance(double d) {
        this.distributedCapacitance = d;
    }

    public void setDistributedConductance(double d) {
        this.distributedConductance = d;
    }

    public double getDistributedResistance() {
        return this.distributedResistance;
    }

    public double getDistributedInductance() {
        return this.distributedInductance;
    }

    public double getDistributedCapacitance() {
        return this.distributedCapacitance;
    }

    public double getDistributedConductance() {
        return this.distributedConductance;
    }

    public Complex getDistributedImpedance() {
        this.distributedImpedance = new Complex(this.distributedResistance, this.distributedInductance * this.omega);
        return this.distributedImpedance;
    }

    public Complex getDistributedAdmittance() {
        this.distributedAdmittance = new Complex(this.distributedConductance, this.distributedCapacitance * this.omega);
        return this.distributedAdmittance;
    }

    public double getWavelength() {
        this.generalWavelength = this.getPhaseVelocity() / this.frequency;
        return this.generalWavelength;
    }

    public double getIdealWavelength() {
        this.idealWavelength = this.getIdealPhaseVelocity() / this.frequency;
        return this.idealWavelength;
    }

    public double getLowLossWavelength() {
        this.lowLossWavelength = this.getLowLossPhaseVelocity() / this.frequency;
        return this.lowLossWavelength;
    }

    public double getPhaseVelocity() {
        this.generalPhaseVelocity = this.omega / this.getPhaseConstant();
        return this.generalPhaseVelocity;
    }

    public double getIdealPhaseVelocity() {
        this.idealPhaseVelocity = this.omega / this.getIdealPhaseConstant();
        return this.idealPhaseVelocity;
    }

    public double getLowLossPhaseVelocity() {
        this.lowLossPhaseVelocity = this.omega / this.getLowLossPhaseConstant();
        return this.lowLossPhaseVelocity;
    }

    public double getGroupVelocity() {
        if (this.distributedResistance == 0.0 && this.distributedConductance == 0.0) {
            this.generalPhaseVelocity = 1.0 / Math.sqrt(this.distributedInductance * this.distributedCapacitance);
        } else {
            double d = this.omega;
            this.omega = d * (1.0 - this.delta);
            double d2 = this.getPhaseConstant();
            this.omega = d * (1.0 + this.delta);
            double d3 = this.getPhaseConstant();
            this.omega = d;
            this.generalPhaseVelocity = 2.0 * this.omega * this.delta / (d3 - d2);
        }
        return this.generalGroupVelocity;
    }

    public void setDelta(double d) {
        this.delta = d;
    }

    public double getIdealGroupVelocity() {
        this.idealGroupVelocity = 1.0 / Math.sqrt(this.distributedInductance * this.distributedCapacitance);
        return this.idealGroupVelocity;
    }

    public double getLowLossGroupVelocity() {
        double d = this.omega * this.omega;
        double d2 = Math.sqrt(this.distributedInductance * this.distributedCapacitance);
        double d3 = this.distributedResistance * this.distributedConductance / (4.0 * d * this.distributedInductance * this.distributedCapacitance);
        double d4 = this.distributedConductance * this.distributedConductance / (8.0 * d * this.distributedCapacitance * this.distributedCapacitance);
        double d5 = this.distributedResistance * this.distributedResistance / (8.0 * d * this.distributedInductance * this.distributedInductance);
        this.lowLossPhaseConstant = 1.0 / (d2 * (1.0 + d3 - d4 - d5));
        return this.lowLossGroupVelocity;
    }

    public double getAttenuationConstant() {
        this.generalAttenuationConstant = this.distributedResistance == 0.0 && this.distributedConductance == 0.0 ? 0.0 : Complex.sqrt(this.getDistributedImpedance().times(this.getDistributedAdmittance())).getReal();
        return this.generalAttenuationConstant;
    }

    public double getLowLossAttenuationConstant() {
        double d = Math.sqrt(this.distributedInductance / this.distributedCapacitance);
        double d2 = this.distributedResistance / (2.0 * d);
        double d3 = this.distributedConductance * d / 2.0;
        this.lowLossAttenuationConstant = d2 + d3;
        return this.lowLossAttenuationConstant;
    }

    public double getIdealAttenuationConstant() {
        this.idealAttenuationConstant = 0.0;
        return this.idealAttenuationConstant;
    }

    public double getPhaseConstant() {
        this.generalPhaseConstant = this.distributedResistance == 0.0 && this.distributedConductance == 0.0 ? this.omega * Math.sqrt(this.distributedInductance * this.distributedCapacitance) : Complex.sqrt(this.getDistributedImpedance().times(this.getDistributedAdmittance())).getImag();
        return this.generalPhaseConstant;
    }

    public double getLowLossPhaseConstant() {
        double d = this.omega * this.omega;
        double d2 = this.omega * Math.sqrt(this.distributedInductance * this.distributedCapacitance);
        double d3 = this.distributedResistance * this.distributedConductance / (4.0 * d * this.distributedInductance * this.distributedCapacitance);
        double d4 = this.distributedConductance * this.distributedConductance / (8.0 * d * this.distributedCapacitance * this.distributedCapacitance);
        double d5 = this.distributedResistance * this.distributedResistance / (8.0 * d * this.distributedInductance * this.distributedInductance);
        this.lowLossPhaseConstant = d2 * (1.0 - d3 + d4 + d5);
        return this.lowLossPhaseConstant;
    }

    public double getIdealPhaseConstant() {
        this.idealPhaseConstant = this.omega * Math.sqrt(this.distributedInductance * this.distributedCapacitance);
        return this.idealPhaseConstant;
    }

    public Complex getPropagationConstant() {
        this.generalPropagationConstant = this.distributedResistance == 0.0 && this.distributedConductance == 0.0 ? new Complex(0.0, this.omega * Math.sqrt(this.distributedInductance * this.distributedCapacitance)) : Complex.sqrt(this.getDistributedImpedance().times(this.getDistributedAdmittance()));
        return this.generalPropagationConstant;
    }

    public Complex getLowLossPropagationConstant() {
        this.lowLossPropagationConstant = new Complex(this.getLowLossAttenuationConstant(), this.getLowLossPhaseConstant());
        return this.lowLossPropagationConstant;
    }

    public Complex getIdealPropagationConstant() {
        this.idealPropagationConstant = new Complex(0.0, this.omega * Math.sqrt(this.distributedInductance * this.distributedCapacitance));
        return this.idealPropagationConstant;
    }

    public Complex getCharacteristicImpedance() {
        this.generalCharacteristicImpedance = Complex.sqrt(this.getDistributedImpedance().over(this.getDistributedAdmittance()));
        return this.generalCharacteristicImpedance;
    }

    public Complex getLowLossCharacteristicImpedance() {
        double d = this.omega * this.omega;
        double d2 = Math.sqrt(this.distributedInductance / this.distributedCapacitance);
        double d3 = this.distributedResistance * this.distributedResistance / (8.0 * d * this.distributedInductance * this.distributedInductance);
        double d4 = this.distributedConductance * this.distributedConductance / (8.0 * d * this.distributedCapacitance * this.distributedCapacitance);
        double d5 = this.distributedResistance * this.distributedConductance / (4.0 * d * this.distributedInductance * this.distributedCapacitance);
        double d6 = this.distributedConductance / (2.0 * this.omega * this.distributedCapacitance);
        double d7 = this.distributedResistance / (2.0 * this.omega * this.distributedInductance);
        this.lowLossCharacteristicImpedance = new Complex(d2 * (1.0 + d3 - d4 + d5), d2 * (d6 - d7));
        return this.lowLossCharacteristicImpedance;
    }

    public Complex getIdealCharacteristicImpedance() {
        this.idealRealCharacteristicImpedance = Math.sqrt(this.distributedInductance / this.distributedCapacitance);
        this.idealCharacteristicImpedance = new Complex(this.idealRealCharacteristicImpedance, 0.0);
        return this.idealCharacteristicImpedance;
    }

    public double getIdealCharacteristicImpedanceAsReal() {
        this.idealRealCharacteristicImpedance = Math.sqrt(this.distributedInductance / this.distributedCapacitance);
        this.idealCharacteristicImpedance = new Complex(this.idealRealCharacteristicImpedance, 0.0);
        return this.idealRealCharacteristicImpedance;
    }

    public Complex getInputImpedance() {
        Complex complex = this.getPropagationConstant();
        Complex complex2 = this.getCharacteristicImpedance();
        Complex complex3 = Complex.cosh(complex.times(this.lineLength));
        Complex complex4 = Complex.sinh(complex.times(this.lineLength));
        Complex complex5 = complex3.times(this.loadImpedance);
        Complex complex6 = complex4.times(complex2);
        Complex complex7 = complex3.times(complex2);
        Complex complex8 = complex4.times(this.loadImpedance);
        Complex complex9 = complex5.plus(complex6).over(complex7.plus(complex8));
        this.generalInputImpedance = complex2.times(complex9);
        return this.generalInputImpedance;
    }

    public Complex getLowLossInputImpedance() {
        Complex complex = this.getLowLossPropagationConstant();
        Complex complex2 = this.getLowLossCharacteristicImpedance();
        Complex complex3 = Complex.cosh(complex.times(this.lineLength));
        Complex complex4 = Complex.sinh(complex.times(this.lineLength));
        Complex complex5 = complex3.times(this.loadImpedance);
        Complex complex6 = complex4.times(complex2);
        Complex complex7 = complex3.times(complex2);
        Complex complex8 = complex4.times(this.loadImpedance);
        Complex complex9 = complex5.plus(complex6).over(complex7.plus(complex8));
        this.lowLossInputImpedance = complex2.times(complex9);
        return this.lowLossInputImpedance;
    }

    public Complex getIdealInputImpedance() {
        double d = this.getIdealPhaseConstant();
        double d2 = this.getIdealCharacteristicImpedanceAsReal();
        double d3 = Math.cos(d * this.lineLength);
        double d4 = Math.sin(d * this.lineLength);
        Complex complex = new Complex(0.0, d4 * d2).plus(this.loadImpedance.times(d3));
        Complex complex2 = new Complex(d3 * d2, 0.0).plus(Complex.plusJay().times(this.loadImpedance.times(d4)));
        Complex complex3 = complex.over(complex2);
        this.idealInputImpedance = complex3.times(d2);
        return this.idealInputImpedance;
    }

    public Complex getShortedLineImpedance() {
        if (this.lineLength == -1.0) {
            throw new IllegalArgumentException("No line length as been entered");
        }
        this.generalShortedLineImpedance = this.getCharacteristicImpedance().times(Complex.tanh(this.getPropagationConstant().times(this.lineLength)));
        return this.generalShortedLineImpedance;
    }

    public Complex getLowLossShortedLineImpedance() {
        if (this.lineLength == -1.0) {
            throw new IllegalArgumentException("No line length as been entered");
        }
        double d = this.getLowLossAttenuationConstant() * this.lineLength;
        double d2 = Math.cos(this.getLowLossPhaseConstant() * this.lineLength);
        double d3 = Math.sin(this.getLowLossPhaseConstant() * this.lineLength);
        Complex complex = new Complex(d * d2, d3);
        Complex complex2 = new Complex(d2, d * d3);
        this.lowLossShortedLineImpedance = complex.over(complex2);
        return this.lowLossShortedLineImpedance;
    }

    public Complex getIdealShortedLineImpedance() {
        if (this.lineLength == -1.0) {
            throw new IllegalArgumentException("No line length as been entered");
        }
        this.idealShortedLineImpedance = new Complex(0.0, this.getIdealCharacteristicImpedanceAsReal() * Math.tan(this.getIdealPhaseConstant() * this.lineLength));
        return this.idealShortedLineImpedance;
    }

    public Complex getOpenLineImpedance() {
        if (this.lineLength == -1.0) {
            throw new IllegalArgumentException("No line length as been entered");
        }
        this.generalShortedLineImpedance = this.getCharacteristicImpedance().times(Complex.coth(this.getPropagationConstant().times(this.lineLength)));
        return this.generalShortedLineImpedance;
    }

    public Complex getLowLossOpenLineImpedance() {
        if (this.lineLength == -1.0) {
            throw new IllegalArgumentException("No line length as been entered");
        }
        double d = this.getLowLossAttenuationConstant() * this.lineLength;
        double d2 = Math.cos(this.getLowLossPhaseConstant() * this.lineLength);
        double d3 = Math.sin(this.getLowLossPhaseConstant() * this.lineLength);
        Complex complex = new Complex(d2, d * d3);
        Complex complex2 = new Complex(d * d2, d3);
        this.lowLossShortedLineImpedance = complex.over(complex2);
        return this.lowLossShortedLineImpedance;
    }

    public Complex getIdealOpenLineImpedance() {
        if (this.lineLength == -1.0) {
            throw new IllegalArgumentException("No line length as been entered");
        }
        this.idealShortedLineImpedance = new Complex(0.0, -this.getIdealCharacteristicImpedanceAsReal() * Fmath.cot(this.getIdealPhaseConstant() * this.lineLength));
        return this.idealShortedLineImpedance;
    }

    public Complex getQuarterWaveLineImpedance() {
        Complex complex = new Complex(this.getAttenuationConstant(), 0.0);
        Complex complex2 = this.getCharacteristicImpedance();
        Complex complex3 = Complex.sinh(complex.times(this.lineLength));
        Complex complex4 = Complex.cosh(complex.times(this.lineLength));
        Complex complex5 = complex3.times(this.loadImpedance);
        Complex complex6 = complex4.times(complex2);
        Complex complex7 = complex3.times(complex2);
        Complex complex8 = complex4.times(this.loadImpedance);
        Complex complex9 = complex5.plus(complex6).over(complex7.plus(complex8));
        this.generalQuarterWaveLineImpedance = complex2.times(complex9);
        return this.generalQuarterWaveLineImpedance;
    }

    public Complex getLowLossQuarterWaveLineImpedance() {
        Complex complex = new Complex(this.getLowLossAttenuationConstant(), 0.0);
        Complex complex2 = this.getLowLossCharacteristicImpedance();
        Complex complex3 = complex.times(this.lineLength);
        Complex complex4 = complex2.plus(this.loadImpedance.times(complex3));
        Complex complex5 = this.loadImpedance.plus(complex2.times(complex3));
        Complex complex6 = complex4.over(complex5);
        this.lowLossQuarterWaveLineImpedance = complex2.times(complex6);
        return this.lowLossQuarterWaveLineImpedance;
    }

    public Complex getIdealQuarterWaveLineImpedance() {
        Complex complex = new Complex(Fmath.square(this.getIdealCharacteristicImpedanceAsReal()), 0.0);
        this.idealQuarterWaveLineImpedance = complex.over(this.loadImpedance);
        return this.idealQuarterWaveLineImpedance;
    }

    public Complex getHalfWaveLineImpedance() {
        Complex complex = new Complex(this.getAttenuationConstant(), 0.0);
        Complex complex2 = this.getCharacteristicImpedance();
        Complex complex3 = Complex.cosh(complex.times(this.lineLength));
        Complex complex4 = Complex.sinh(complex.times(this.lineLength));
        Complex complex5 = complex3.times(this.loadImpedance);
        Complex complex6 = complex4.times(complex2);
        Complex complex7 = complex3.times(complex2);
        Complex complex8 = complex4.times(this.loadImpedance);
        Complex complex9 = complex5.plus(complex6).over(complex7.plus(complex8));
        this.generalHalfWaveLineImpedance = complex2.times(complex9);
        return this.generalHalfWaveLineImpedance;
    }

    public Complex getLowLossHalfWaveLineImpedance() {
        Complex complex = new Complex(this.getLowLossAttenuationConstant(), 0.0);
        Complex complex2 = this.getLowLossCharacteristicImpedance();
        Complex complex3 = complex.times(this.lineLength);
        Complex complex4 = this.loadImpedance.plus(complex2.times(complex3));
        Complex complex5 = complex2.plus(this.loadImpedance.times(complex3));
        Complex complex6 = complex4.over(complex5);
        this.lowLossHalfWaveLineImpedance = complex2.times(complex6);
        return this.lowLossHalfWaveLineImpedance;
    }

    public Complex getIdealHalfWaveLineImpedance() {
        this.idealHalfWaveLineImpedance = this.loadImpedance;
        return this.idealHalfWaveLineImpedance;
    }

    public Complex getRefectionCoefficient() {
        Complex complex = this.loadImpedance.minus(this.getCharacteristicImpedance());
        Complex complex2 = this.loadImpedance.plus(this.getCharacteristicImpedance());
        this.generalRefectionCoefficient = complex.over(complex2);
        return this.generalRefectionCoefficient;
    }

    public Complex getLowLossRefectionCoefficient() {
        Complex complex = this.loadImpedance.minus(this.getLowLossCharacteristicImpedance());
        Complex complex2 = this.loadImpedance.plus(this.getLowLossCharacteristicImpedance());
        this.lowLossRefectionCoefficient = complex.over(complex2);
        return this.lowLossRefectionCoefficient;
    }

    public Complex getIdealRefectionCoefficient() {
        Complex complex = this.loadImpedance.minus(this.getIdealCharacteristicImpedance());
        Complex complex2 = this.loadImpedance.plus(this.getIdealCharacteristicImpedance());
        this.idealRefectionCoefficient = complex.over(complex2);
        return this.idealRefectionCoefficient;
    }

    public double getStandingWaveRatio() {
        double d = this.getRefectionCoefficient().abs();
        this.generalStandingWaveRatio = (1.0 + d) / (1.0 - d);
        return this.generalStandingWaveRatio;
    }

    public double getLowLossStandingWaveRatio() {
        double d = this.getLowLossRefectionCoefficient().abs();
        this.lowLossStandingWaveRatio = (1.0 + d) / (1.0 - d);
        return this.lowLossStandingWaveRatio;
    }

    public double getIdealStandingWaveRatio() {
        double d = this.getIdealRefectionCoefficient().abs();
        this.idealStandingWaveRatio = (1.0 + d) / (1.0 - d);
        return this.idealStandingWaveRatio;
    }

    public ComplexMatrix getABCDmatrix() {
        if (this.segmentLength == -1.0) {
            throw new IllegalArgumentException("No distance along the line as been entered");
        }
        if (this.distributedResistance == 0.0 && this.distributedConductance == 0.0) {
            this.generalABCDmatrix = this.getIdealABCDmatrix();
        } else {
            this.generalABCDmatrix = new ComplexMatrix(2, 2);
            Complex complex = this.getPropagationConstant().times(this.segmentLength);
            Complex complex2 = this.getCharacteristicImpedance();
            this.generalABCDmatrix.setElement(0, 0, Complex.cosh(complex));
            this.generalABCDmatrix.setElement(0, 1, Complex.sinh(complex).times(complex2));
            this.generalABCDmatrix.setElement(1, 0, Complex.sinh(complex).over(complex2));
            this.generalABCDmatrix.setElement(1, 1, Complex.cosh(complex));
        }
        return this.generalABCDmatrix;
    }

    public ComplexMatrix getIdealABCDmatrix() {
        if (this.segmentLength == -1.0) {
            throw new IllegalArgumentException("No distance along the line as been entered");
        }
        this.idealABCDmatrix = new ComplexMatrix(2, 2);
        double d = this.getIdealPhaseConstant() * this.segmentLength;
        double d2 = this.getIdealCharacteristicImpedanceAsReal();
        this.idealABCDmatrix.setElement(0, 0, new Complex(Math.cos(d), 0.0));
        this.idealABCDmatrix.setElement(0, 1, new Complex(0.0, Math.sin(d) * d2));
        this.idealABCDmatrix.setElement(1, 0, new Complex(0.0, Math.sin(d) / d2));
        this.idealABCDmatrix.setElement(1, 1, new Complex(Math.cos(d), 0.0));
        return this.idealABCDmatrix;
    }

    public ComplexMatrix getLowLossABCDmatrix() {
        if (this.segmentLength == -1.0) {
            throw new IllegalArgumentException("No distance along the line as been entered");
        }
        this.lowLossABCDmatrix = new ComplexMatrix(2, 2);
        Complex complex = this.getLowLossPropagationConstant().times(this.segmentLength);
        Complex complex2 = this.getLowLossCharacteristicImpedance();
        this.lowLossABCDmatrix.setElement(0, 0, Complex.cosh(complex));
        this.lowLossABCDmatrix.setElement(0, 1, Complex.sinh(complex).times(complex2));
        this.lowLossABCDmatrix.setElement(1, 0, Complex.sinh(complex).over(complex2));
        this.lowLossABCDmatrix.setElement(1, 1, Complex.cosh(complex));
        return this.lowLossABCDmatrix;
    }

    public Complex[] voltageAndCurrentAsComplex(double d) {
        this.segmentLength = d;
        return this.voltageAndCurrentAsComplex();
    }

    public Complex[] voltageAndCurrentAsComplex() {
        Complex[] complexArray = new Complex[]{this.outputVoltage, this.outputCurrent};
        ComplexMatrix complexMatrix = this.getABCDmatrix();
        Complex[] complexArray2 = complexMatrix.solveLinearSet(complexArray);
        this.inputVoltage = complexArray2[0];
        this.inputCurrent = complexArray2[1];
        return complexArray2;
    }

    public Phasor[] voltageAndCurrentAsPhasor(double d) {
        this.segmentLength = d;
        Complex[] complexArray = new Complex[]{this.outputVoltage, this.outputCurrent};
        ComplexMatrix complexMatrix = this.getABCDmatrix();
        Complex[] complexArray2 = complexMatrix.solveLinearSet(complexArray);
        this.inputVoltage = complexArray2[0];
        this.inputCurrent = complexArray2[1];
        Phasor[] phasorArray = new Phasor[]{Phasor.toPhasor(this.inputVoltage), Phasor.toPhasor(this.inputCurrent)};
        return phasorArray;
    }

    public Phasor[] voltageAndCurrentAsPhasor() {
        Complex[] complexArray = new Complex[]{this.outputVoltage, this.outputCurrent};
        ComplexMatrix complexMatrix = this.getABCDmatrix();
        Complex[] complexArray2 = complexMatrix.solveLinearSet(complexArray);
        this.inputVoltage = complexArray2[0];
        this.inputCurrent = complexArray2[1];
        Phasor[] phasorArray = new Phasor[]{Phasor.toPhasor(this.inputVoltage), Phasor.toPhasor(this.inputCurrent)};
        return phasorArray;
    }

    public double[] voltageAndCurrentAsReal() {
        Complex[] complexArray = new Complex[]{this.outputVoltage, this.outputCurrent};
        ComplexMatrix complexMatrix = this.getABCDmatrix();
        Complex[] complexArray2 = complexMatrix.solveLinearSet(complexArray);
        double[] dArray = new double[]{complexArray2[0].abs() * Math.cos(complexArray2[0].arg()), complexArray2[1].abs() * Math.cos(complexArray2[1].arg())};
        return dArray;
    }

    public double[] voltageAndCurrentAsReal(double d) {
        this.segmentLength = d;
        return this.voltageAndCurrentAsReal();
    }

    public double[] voltageAndCurrentAsMagnitudeAndPhase() {
        Complex[] complexArray = new Complex[]{this.outputVoltage, this.outputCurrent};
        ComplexMatrix complexMatrix = this.getABCDmatrix();
        Complex[] complexArray2 = complexMatrix.solveLinearSet(complexArray);
        double[] dArray = new double[]{complexArray2[0].abs(), complexArray2[0].arg(), complexArray2[1].abs(), complexArray2[1].arg()};
        return dArray;
    }

    public double[] voltageAndCurrentAsAsMagnitudeAndPhase(double d) {
        this.segmentLength = d;
        return this.voltageAndCurrentAsMagnitudeAndPhase();
    }

    public void plotVandI() {
        Object[] objectArray;
        int n;
        double[][] dArray = PlotGraph.data(4, this.numberOfPoints);
        double d = this.segmentLength / (double)(this.numberOfPoints - 1);
        dArray[0][0] = 0.0;
        dArray[2][0] = 0.0;
        for (n = 1; n < this.numberOfPoints; ++n) {
            dArray[0][n] = dArray[0][n - 1] + d;
            dArray[2][n] = dArray[2][n - 1] + d;
        }
        for (n = 0; n < this.numberOfPoints; ++n) {
            objectArray = this.voltageAndCurrentAsReal(dArray[0][n]);
            dArray[1][n] = objectArray[0];
            dArray[3][n] = objectArray[1];
        }
        dArray[4][0] = 0.0;
        dArray[6][0] = 0.0;
        dArray[4][1] = dArray[0][this.numberOfPoints / 2];
        dArray[6][1] = dArray[0][this.numberOfPoints / 2];
        dArray[4][2] = dArray[0][this.numberOfPoints - 1];
        dArray[6][2] = dArray[0][this.numberOfPoints - 1];
        dArray[5][0] = dArray[1][0];
        dArray[7][0] = dArray[3][0];
        dArray[5][1] = dArray[1][this.numberOfPoints / 2];
        dArray[7][1] = dArray[3][this.numberOfPoints / 2];
        dArray[5][2] = dArray[1][this.numberOfPoints - 1];
        dArray[7][2] = dArray[3][this.numberOfPoints - 1];
        PlotGraph plotGraph = new PlotGraph(dArray);
        objectArray = new int[]{3, 3, 0, 0};
        plotGraph.setLine((int[])objectArray);
        int[] nArray = new int[]{0, 0, 1, 2};
        plotGraph.setPoint(nArray);
        plotGraph.setXaxisLegend("distance / metres");
        plotGraph.setYaxisLegend("Voltage / V and Current / A");
        plotGraph.plot();
    }

    public TransmissionLine copy() {
        if (this == null) {
            return null;
        }
        TransmissionLine transmissionLine = new TransmissionLine();
        transmissionLine.title = this.title;
        transmissionLine.distributedResistance = this.distributedResistance;
        transmissionLine.distributedConductance = this.distributedConductance;
        transmissionLine.distributedCapacitance = this.distributedCapacitance;
        transmissionLine.distributedInductance = this.distributedInductance;
        transmissionLine.distributedImpedance = this.distributedImpedance.copy();
        transmissionLine.distributedAdmittance = this.distributedAdmittance.copy();
        transmissionLine.loadImpedance = this.loadImpedance.copy();
        transmissionLine.lineLength = this.lineLength;
        transmissionLine.segmentLength = this.segmentLength;
        transmissionLine.frequency = this.frequency;
        transmissionLine.segmentLength = this.segmentLength;
        transmissionLine.omega = this.omega;
        transmissionLine.inputVoltage = this.inputVoltage.copy();
        transmissionLine.inputCurrent = this.inputCurrent.copy();
        transmissionLine.outputVoltage = this.outputVoltage.copy();
        transmissionLine.outputCurrent = this.outputCurrent.copy();
        transmissionLine.idealWavelength = this.idealWavelength;
        transmissionLine.generalWavelength = this.generalWavelength;
        transmissionLine.lowLossWavelength = this.lowLossWavelength;
        transmissionLine.idealPhaseVelocity = this.idealPhaseVelocity;
        transmissionLine.generalPhaseVelocity = this.generalPhaseVelocity;
        transmissionLine.lowLossPhaseVelocity = this.lowLossPhaseVelocity;
        transmissionLine.idealGroupVelocity = this.idealGroupVelocity;
        transmissionLine.generalGroupVelocity = this.generalGroupVelocity;
        transmissionLine.lowLossGroupVelocity = this.lowLossGroupVelocity;
        transmissionLine.delta = this.delta;
        transmissionLine.idealAttenuationConstant = this.idealAttenuationConstant;
        transmissionLine.generalAttenuationConstant = this.generalAttenuationConstant;
        transmissionLine.lowLossAttenuationConstant = this.lowLossAttenuationConstant;
        transmissionLine.idealPhaseConstant = this.idealPhaseConstant;
        transmissionLine.generalPhaseConstant = this.generalPhaseConstant;
        transmissionLine.lowLossPhaseConstant = this.lowLossPhaseConstant;
        transmissionLine.idealPropagationConstant = this.idealPropagationConstant.copy();
        transmissionLine.loadImpedance = this.loadImpedance.copy();
        transmissionLine.loadImpedance = this.loadImpedance.copy();
        transmissionLine.loadImpedance = this.loadImpedance.copy();
        transmissionLine.generalPropagationConstant = this.generalPropagationConstant.copy();
        transmissionLine.lowLossPropagationConstant = this.lowLossPropagationConstant.copy();
        transmissionLine.idealCharacteristicImpedance = this.idealCharacteristicImpedance.copy();
        transmissionLine.idealRealCharacteristicImpedance = this.idealRealCharacteristicImpedance;
        transmissionLine.generalCharacteristicImpedance = this.generalCharacteristicImpedance.copy();
        transmissionLine.lowLossCharacteristicImpedance = this.lowLossCharacteristicImpedance.copy();
        transmissionLine.idealInputImpedance = this.idealInputImpedance.copy();
        transmissionLine.generalInputImpedance = this.generalInputImpedance.copy();
        transmissionLine.lowLossInputImpedance = this.lowLossInputImpedance.copy();
        transmissionLine.idealShortedLineImpedance = this.idealShortedLineImpedance.copy();
        transmissionLine.generalShortedLineImpedance = this.generalShortedLineImpedance.copy();
        transmissionLine.lowLossShortedLineImpedance = this.lowLossShortedLineImpedance.copy();
        transmissionLine.idealOpenLineImpedance = this.idealOpenLineImpedance.copy();
        transmissionLine.generalOpenLineImpedance = this.generalOpenLineImpedance.copy();
        transmissionLine.lowLossOpenLineImpedance = this.lowLossOpenLineImpedance.copy();
        transmissionLine.idealQuarterWaveLineImpedance = this.idealQuarterWaveLineImpedance.copy();
        transmissionLine.generalQuarterWaveLineImpedance = this.generalQuarterWaveLineImpedance.copy();
        transmissionLine.lowLossQuarterWaveLineImpedance = this.lowLossQuarterWaveLineImpedance.copy();
        transmissionLine.idealHalfWaveLineImpedance = this.idealHalfWaveLineImpedance.copy();
        transmissionLine.generalHalfWaveLineImpedance = this.generalHalfWaveLineImpedance.copy();
        transmissionLine.lowLossHalfWaveLineImpedance = this.lowLossHalfWaveLineImpedance.copy();
        transmissionLine.idealRefectionCoefficient = this.idealRefectionCoefficient.copy();
        transmissionLine.generalRefectionCoefficient = this.generalRefectionCoefficient.copy();
        transmissionLine.lowLossRefectionCoefficient = this.lowLossRefectionCoefficient.copy();
        transmissionLine.idealStandingWaveRatio = this.idealStandingWaveRatio;
        transmissionLine.generalStandingWaveRatio = this.generalStandingWaveRatio;
        transmissionLine.lowLossStandingWaveRatio = this.lowLossStandingWaveRatio;
        transmissionLine.idealABCDmatrix = this.idealABCDmatrix.copy();
        transmissionLine.generalABCDmatrix = this.generalABCDmatrix.copy();
        transmissionLine.lowLossABCDmatrix = this.lowLossABCDmatrix.copy();
        transmissionLine.numberOfPoints = this.numberOfPoints;
        return transmissionLine;
    }

    public Object clone() {
        TransmissionLine transmissionLine = null;
        if (this != null) {
            TransmissionLine transmissionLine2 = new TransmissionLine();
            transmissionLine2.title = this.title;
            transmissionLine2.distributedResistance = this.distributedResistance;
            transmissionLine2.distributedConductance = this.distributedConductance;
            transmissionLine2.distributedCapacitance = this.distributedCapacitance;
            transmissionLine2.distributedInductance = this.distributedInductance;
            transmissionLine2.distributedImpedance = this.distributedImpedance.copy();
            transmissionLine2.distributedAdmittance = this.distributedAdmittance.copy();
            transmissionLine2.loadImpedance = this.loadImpedance.copy();
            transmissionLine2.lineLength = this.lineLength;
            transmissionLine2.segmentLength = this.segmentLength;
            transmissionLine2.frequency = this.frequency;
            transmissionLine2.segmentLength = this.segmentLength;
            transmissionLine2.omega = this.omega;
            transmissionLine2.inputVoltage = this.inputVoltage.copy();
            transmissionLine2.inputCurrent = this.inputCurrent.copy();
            transmissionLine2.outputVoltage = this.outputVoltage.copy();
            transmissionLine2.outputCurrent = this.outputCurrent.copy();
            transmissionLine2.idealWavelength = this.idealWavelength;
            transmissionLine2.generalWavelength = this.generalWavelength;
            transmissionLine2.lowLossWavelength = this.lowLossWavelength;
            transmissionLine2.idealPhaseVelocity = this.idealPhaseVelocity;
            transmissionLine2.generalPhaseVelocity = this.generalPhaseVelocity;
            transmissionLine2.lowLossPhaseVelocity = this.lowLossPhaseVelocity;
            transmissionLine2.idealGroupVelocity = this.idealGroupVelocity;
            transmissionLine2.generalGroupVelocity = this.generalGroupVelocity;
            transmissionLine2.lowLossGroupVelocity = this.lowLossGroupVelocity;
            transmissionLine2.delta = this.delta;
            transmissionLine2.idealAttenuationConstant = this.idealAttenuationConstant;
            transmissionLine2.generalAttenuationConstant = this.generalAttenuationConstant;
            transmissionLine2.lowLossAttenuationConstant = this.lowLossAttenuationConstant;
            transmissionLine2.idealPhaseConstant = this.idealPhaseConstant;
            transmissionLine2.generalPhaseConstant = this.generalPhaseConstant;
            transmissionLine2.lowLossPhaseConstant = this.lowLossPhaseConstant;
            transmissionLine2.idealPropagationConstant = this.idealPropagationConstant.copy();
            transmissionLine2.loadImpedance = this.loadImpedance.copy();
            transmissionLine2.loadImpedance = this.loadImpedance.copy();
            transmissionLine2.loadImpedance = this.loadImpedance.copy();
            transmissionLine2.generalPropagationConstant = this.generalPropagationConstant.copy();
            transmissionLine2.lowLossPropagationConstant = this.lowLossPropagationConstant.copy();
            transmissionLine2.idealCharacteristicImpedance = this.idealCharacteristicImpedance.copy();
            transmissionLine2.idealRealCharacteristicImpedance = this.idealRealCharacteristicImpedance;
            transmissionLine2.generalCharacteristicImpedance = this.generalCharacteristicImpedance.copy();
            transmissionLine2.lowLossCharacteristicImpedance = this.lowLossCharacteristicImpedance.copy();
            transmissionLine2.idealInputImpedance = this.idealInputImpedance.copy();
            transmissionLine2.generalInputImpedance = this.generalInputImpedance.copy();
            transmissionLine2.lowLossInputImpedance = this.lowLossInputImpedance.copy();
            transmissionLine2.idealShortedLineImpedance = this.idealShortedLineImpedance.copy();
            transmissionLine2.generalShortedLineImpedance = this.generalShortedLineImpedance.copy();
            transmissionLine2.lowLossShortedLineImpedance = this.lowLossShortedLineImpedance.copy();
            transmissionLine2.idealOpenLineImpedance = this.idealOpenLineImpedance.copy();
            transmissionLine2.generalOpenLineImpedance = this.generalOpenLineImpedance.copy();
            transmissionLine2.lowLossOpenLineImpedance = this.lowLossOpenLineImpedance.copy();
            transmissionLine2.idealQuarterWaveLineImpedance = this.idealQuarterWaveLineImpedance.copy();
            transmissionLine2.generalQuarterWaveLineImpedance = this.generalQuarterWaveLineImpedance.copy();
            transmissionLine2.lowLossQuarterWaveLineImpedance = this.lowLossQuarterWaveLineImpedance.copy();
            transmissionLine2.idealHalfWaveLineImpedance = this.idealHalfWaveLineImpedance.copy();
            transmissionLine2.generalHalfWaveLineImpedance = this.generalHalfWaveLineImpedance.copy();
            transmissionLine2.lowLossHalfWaveLineImpedance = this.lowLossHalfWaveLineImpedance.copy();
            transmissionLine2.idealRefectionCoefficient = this.idealRefectionCoefficient.copy();
            transmissionLine2.generalRefectionCoefficient = this.generalRefectionCoefficient.copy();
            transmissionLine2.lowLossRefectionCoefficient = this.lowLossRefectionCoefficient.copy();
            transmissionLine2.idealStandingWaveRatio = this.idealStandingWaveRatio;
            transmissionLine2.generalStandingWaveRatio = this.generalStandingWaveRatio;
            transmissionLine2.lowLossStandingWaveRatio = this.lowLossStandingWaveRatio;
            transmissionLine2.idealABCDmatrix = this.idealABCDmatrix.copy();
            transmissionLine2.generalABCDmatrix = this.generalABCDmatrix.copy();
            transmissionLine2.lowLossABCDmatrix = this.lowLossABCDmatrix.copy();
            transmissionLine2.numberOfPoints = this.numberOfPoints;
            transmissionLine = transmissionLine2;
        }
        return transmissionLine;
    }
}

