/*
 * Decompiled with CFR 0.152.
 */
package flanagan.circuits;

import flanagan.circuits.Impedance;
import flanagan.circuits.TransmissionLine;

public class TwoWireLine
extends TransmissionLine {
    private double wireRadius = -1.0;
    private double wireSeparation = -1.0;
    private boolean distancesSet = false;
    private double relativePermittivity = 1.0;
    private double relativePermeability = 1.0;

    public void setWireRadius(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("The wire radius, " + d + ", must be greater than zero");
        }
        if (this.wireSeparation != -1.0 && this.wireSeparation <= 2.0 * d) {
            throw new IllegalArgumentException("The wire separation distance, " + this.wireSeparation + ", must be greater than the sum of the two wire radii, " + 2.0 * d);
        }
        this.wireRadius = d;
        if (this.wireSeparation != -1.0) {
            this.distancesSet = true;
        }
        if (this.distancesSet) {
            this.calculateDistributedCapacitanceAndInductance();
        }
    }

    public void setWireSeparation(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("The wire separation, " + d + ", must be greater than zero");
        }
        if (this.wireRadius != -1.0 && d <= 2.0 * this.wireRadius) {
            throw new IllegalArgumentException("The wire separation distance, " + d + ", must be greater than the sum of the two wire radii, " + 2.0 * this.wireRadius);
        }
        this.wireSeparation = d;
        if (this.wireRadius != -1.0) {
            this.distancesSet = true;
        }
        if (this.distancesSet) {
            this.calculateDistributedCapacitanceAndInductance();
        }
    }

    public void setRelativePermittivity(double d) {
        this.relativePermittivity = d;
        if (this.distancesSet) {
            this.calculateDistributedCapacitanceAndInductance();
        }
    }

    public void setRelativePermeability(double d) {
        this.relativePermeability = d;
        if (this.distancesSet) {
            this.calculateDistributedCapacitanceAndInductance();
        }
    }

    private void calculateDistributedCapacitanceAndInductance() {
        this.distributedCapacitance = Impedance.parallelWiresCapacitance(1.0, this.wireRadius, this.wireSeparation, this.relativePermittivity);
        this.distributedInductance = Impedance.parallelWiresInductance(1.0, this.wireRadius, this.wireSeparation, this.relativePermeability);
    }

    @Override
    public TwoWireLine copy() {
        if (this == null) {
            return null;
        }
        TwoWireLine twoWireLine = new TwoWireLine();
        twoWireLine.wireRadius = this.wireRadius;
        twoWireLine.wireSeparation = this.wireSeparation;
        twoWireLine.distancesSet = this.distancesSet;
        twoWireLine.relativePermittivity = this.relativePermittivity;
        twoWireLine.relativePermeability = this.relativePermeability;
        twoWireLine.title = this.title;
        twoWireLine.distributedResistance = this.distributedResistance;
        twoWireLine.distributedConductance = this.distributedConductance;
        twoWireLine.distributedCapacitance = this.distributedCapacitance;
        twoWireLine.distributedInductance = this.distributedInductance;
        twoWireLine.distributedImpedance = this.distributedImpedance.copy();
        twoWireLine.distributedAdmittance = this.distributedAdmittance.copy();
        twoWireLine.loadImpedance = this.loadImpedance.copy();
        twoWireLine.lineLength = this.lineLength;
        twoWireLine.segmentLength = this.segmentLength;
        twoWireLine.frequency = this.frequency;
        twoWireLine.segmentLength = this.segmentLength;
        twoWireLine.omega = this.omega;
        twoWireLine.inputVoltage = this.inputVoltage.copy();
        twoWireLine.inputCurrent = this.inputCurrent.copy();
        twoWireLine.outputVoltage = this.outputVoltage.copy();
        twoWireLine.outputCurrent = this.outputCurrent.copy();
        twoWireLine.idealWavelength = this.idealWavelength;
        twoWireLine.generalWavelength = this.generalWavelength;
        twoWireLine.lowLossWavelength = this.lowLossWavelength;
        twoWireLine.idealPhaseVelocity = this.idealPhaseVelocity;
        twoWireLine.generalPhaseVelocity = this.generalPhaseVelocity;
        twoWireLine.lowLossPhaseVelocity = this.lowLossPhaseVelocity;
        twoWireLine.idealGroupVelocity = this.idealGroupVelocity;
        twoWireLine.generalGroupVelocity = this.generalGroupVelocity;
        twoWireLine.lowLossGroupVelocity = this.lowLossGroupVelocity;
        twoWireLine.delta = this.delta;
        twoWireLine.idealAttenuationConstant = this.idealAttenuationConstant;
        twoWireLine.generalAttenuationConstant = this.generalAttenuationConstant;
        twoWireLine.lowLossAttenuationConstant = this.lowLossAttenuationConstant;
        twoWireLine.idealPhaseConstant = this.idealPhaseConstant;
        twoWireLine.generalPhaseConstant = this.generalPhaseConstant;
        twoWireLine.lowLossPhaseConstant = this.lowLossPhaseConstant;
        twoWireLine.idealPropagationConstant = this.idealPropagationConstant.copy();
        twoWireLine.loadImpedance = this.loadImpedance.copy();
        twoWireLine.loadImpedance = this.loadImpedance.copy();
        twoWireLine.loadImpedance = this.loadImpedance.copy();
        twoWireLine.generalPropagationConstant = this.generalPropagationConstant.copy();
        twoWireLine.lowLossPropagationConstant = this.lowLossPropagationConstant.copy();
        twoWireLine.idealCharacteristicImpedance = this.idealCharacteristicImpedance.copy();
        twoWireLine.idealRealCharacteristicImpedance = this.idealRealCharacteristicImpedance;
        twoWireLine.generalCharacteristicImpedance = this.generalCharacteristicImpedance.copy();
        twoWireLine.lowLossCharacteristicImpedance = this.lowLossCharacteristicImpedance.copy();
        twoWireLine.idealInputImpedance = this.idealInputImpedance.copy();
        twoWireLine.generalInputImpedance = this.generalInputImpedance.copy();
        twoWireLine.lowLossInputImpedance = this.lowLossInputImpedance.copy();
        twoWireLine.idealShortedLineImpedance = this.idealShortedLineImpedance.copy();
        twoWireLine.generalShortedLineImpedance = this.generalShortedLineImpedance.copy();
        twoWireLine.lowLossShortedLineImpedance = this.lowLossShortedLineImpedance.copy();
        twoWireLine.idealOpenLineImpedance = this.idealOpenLineImpedance.copy();
        twoWireLine.generalOpenLineImpedance = this.generalOpenLineImpedance.copy();
        twoWireLine.lowLossOpenLineImpedance = this.lowLossOpenLineImpedance.copy();
        twoWireLine.idealQuarterWaveLineImpedance = this.idealQuarterWaveLineImpedance.copy();
        twoWireLine.generalQuarterWaveLineImpedance = this.generalQuarterWaveLineImpedance.copy();
        twoWireLine.lowLossQuarterWaveLineImpedance = this.lowLossQuarterWaveLineImpedance.copy();
        twoWireLine.idealHalfWaveLineImpedance = this.idealHalfWaveLineImpedance.copy();
        twoWireLine.generalHalfWaveLineImpedance = this.generalHalfWaveLineImpedance.copy();
        twoWireLine.lowLossHalfWaveLineImpedance = this.lowLossHalfWaveLineImpedance.copy();
        twoWireLine.idealRefectionCoefficient = this.idealRefectionCoefficient.copy();
        twoWireLine.generalRefectionCoefficient = this.generalRefectionCoefficient.copy();
        twoWireLine.lowLossRefectionCoefficient = this.lowLossRefectionCoefficient.copy();
        twoWireLine.idealStandingWaveRatio = this.idealStandingWaveRatio;
        twoWireLine.generalStandingWaveRatio = this.generalStandingWaveRatio;
        twoWireLine.lowLossStandingWaveRatio = this.lowLossStandingWaveRatio;
        twoWireLine.idealABCDmatrix = this.idealABCDmatrix.copy();
        twoWireLine.generalABCDmatrix = this.generalABCDmatrix.copy();
        twoWireLine.lowLossABCDmatrix = this.lowLossABCDmatrix.copy();
        twoWireLine.numberOfPoints = this.numberOfPoints;
        return twoWireLine;
    }

    @Override
    public Object clone() {
        TwoWireLine twoWireLine = null;
        if (this != null) {
            TwoWireLine twoWireLine2 = new TwoWireLine();
            twoWireLine2.wireRadius = this.wireRadius;
            twoWireLine2.wireSeparation = this.wireSeparation;
            twoWireLine2.distancesSet = this.distancesSet;
            twoWireLine2.relativePermittivity = this.relativePermittivity;
            twoWireLine2.relativePermeability = this.relativePermeability;
            twoWireLine2.title = this.title;
            twoWireLine2.distributedResistance = this.distributedResistance;
            twoWireLine2.distributedConductance = this.distributedConductance;
            twoWireLine2.distributedCapacitance = this.distributedCapacitance;
            twoWireLine2.distributedInductance = this.distributedInductance;
            twoWireLine2.distributedImpedance = this.distributedImpedance.copy();
            twoWireLine2.distributedAdmittance = this.distributedAdmittance.copy();
            twoWireLine2.loadImpedance = this.loadImpedance.copy();
            twoWireLine2.lineLength = this.lineLength;
            twoWireLine2.segmentLength = this.segmentLength;
            twoWireLine2.frequency = this.frequency;
            twoWireLine2.segmentLength = this.segmentLength;
            twoWireLine2.omega = this.omega;
            twoWireLine2.inputVoltage = this.inputVoltage.copy();
            twoWireLine2.inputCurrent = this.inputCurrent.copy();
            twoWireLine2.outputVoltage = this.outputVoltage.copy();
            twoWireLine2.outputCurrent = this.outputCurrent.copy();
            twoWireLine2.idealWavelength = this.idealWavelength;
            twoWireLine2.generalWavelength = this.generalWavelength;
            twoWireLine2.lowLossWavelength = this.lowLossWavelength;
            twoWireLine2.idealPhaseVelocity = this.idealPhaseVelocity;
            twoWireLine2.generalPhaseVelocity = this.generalPhaseVelocity;
            twoWireLine2.lowLossPhaseVelocity = this.lowLossPhaseVelocity;
            twoWireLine2.idealGroupVelocity = this.idealGroupVelocity;
            twoWireLine2.generalGroupVelocity = this.generalGroupVelocity;
            twoWireLine2.lowLossGroupVelocity = this.lowLossGroupVelocity;
            twoWireLine2.delta = this.delta;
            twoWireLine2.idealAttenuationConstant = this.idealAttenuationConstant;
            twoWireLine2.generalAttenuationConstant = this.generalAttenuationConstant;
            twoWireLine2.lowLossAttenuationConstant = this.lowLossAttenuationConstant;
            twoWireLine2.idealPhaseConstant = this.idealPhaseConstant;
            twoWireLine2.generalPhaseConstant = this.generalPhaseConstant;
            twoWireLine2.lowLossPhaseConstant = this.lowLossPhaseConstant;
            twoWireLine2.idealPropagationConstant = this.idealPropagationConstant.copy();
            twoWireLine2.loadImpedance = this.loadImpedance.copy();
            twoWireLine2.loadImpedance = this.loadImpedance.copy();
            twoWireLine2.loadImpedance = this.loadImpedance.copy();
            twoWireLine2.generalPropagationConstant = this.generalPropagationConstant.copy();
            twoWireLine2.lowLossPropagationConstant = this.lowLossPropagationConstant.copy();
            twoWireLine2.idealCharacteristicImpedance = this.idealCharacteristicImpedance.copy();
            twoWireLine2.idealRealCharacteristicImpedance = this.idealRealCharacteristicImpedance;
            twoWireLine2.generalCharacteristicImpedance = this.generalCharacteristicImpedance.copy();
            twoWireLine2.lowLossCharacteristicImpedance = this.lowLossCharacteristicImpedance.copy();
            twoWireLine2.idealInputImpedance = this.idealInputImpedance.copy();
            twoWireLine2.generalInputImpedance = this.generalInputImpedance.copy();
            twoWireLine2.lowLossInputImpedance = this.lowLossInputImpedance.copy();
            twoWireLine2.idealShortedLineImpedance = this.idealShortedLineImpedance.copy();
            twoWireLine2.generalShortedLineImpedance = this.generalShortedLineImpedance.copy();
            twoWireLine2.lowLossShortedLineImpedance = this.lowLossShortedLineImpedance.copy();
            twoWireLine2.idealOpenLineImpedance = this.idealOpenLineImpedance.copy();
            twoWireLine2.generalOpenLineImpedance = this.generalOpenLineImpedance.copy();
            twoWireLine2.lowLossOpenLineImpedance = this.lowLossOpenLineImpedance.copy();
            twoWireLine2.idealQuarterWaveLineImpedance = this.idealQuarterWaveLineImpedance.copy();
            twoWireLine2.generalQuarterWaveLineImpedance = this.generalQuarterWaveLineImpedance.copy();
            twoWireLine2.lowLossQuarterWaveLineImpedance = this.lowLossQuarterWaveLineImpedance.copy();
            twoWireLine2.idealHalfWaveLineImpedance = this.idealHalfWaveLineImpedance.copy();
            twoWireLine2.generalHalfWaveLineImpedance = this.generalHalfWaveLineImpedance.copy();
            twoWireLine2.lowLossHalfWaveLineImpedance = this.lowLossHalfWaveLineImpedance.copy();
            twoWireLine2.idealRefectionCoefficient = this.idealRefectionCoefficient.copy();
            twoWireLine2.generalRefectionCoefficient = this.generalRefectionCoefficient.copy();
            twoWireLine2.lowLossRefectionCoefficient = this.lowLossRefectionCoefficient.copy();
            twoWireLine2.idealStandingWaveRatio = this.idealStandingWaveRatio;
            twoWireLine2.generalStandingWaveRatio = this.generalStandingWaveRatio;
            twoWireLine2.lowLossStandingWaveRatio = this.lowLossStandingWaveRatio;
            twoWireLine2.idealABCDmatrix = this.idealABCDmatrix.copy();
            twoWireLine2.generalABCDmatrix = this.generalABCDmatrix.copy();
            twoWireLine2.lowLossABCDmatrix = this.lowLossABCDmatrix.copy();
            twoWireLine2.numberOfPoints = this.numberOfPoints;
            twoWireLine = twoWireLine2;
        }
        return twoWireLine;
    }
}

