/*
 * Decompiled with CFR 0.152.
 */
package flanagan.complex;

import flanagan.analysis.ErrorProp;
import flanagan.math.Fmath;
import flanagan.math.PsRandom;

public class ComplexErrorProp {
    private ErrorProp eReal = new ErrorProp();
    private ErrorProp eImag = new ErrorProp();
    private double corrCoeff = 0.0;
    private static int monteCarloLength = 10000;

    public ComplexErrorProp() {
        this.eReal.reset(0.0, 0.0);
        this.eImag.reset(0.0, 0.0);
        this.corrCoeff = 0.0;
    }

    public ComplexErrorProp(ErrorProp errorProp, ErrorProp errorProp2) {
        this.eReal = errorProp.copy();
        this.eImag = errorProp2.copy();
        this.corrCoeff = 0.0;
    }

    public ComplexErrorProp(ErrorProp errorProp, ErrorProp errorProp2, double d) {
        this.eReal = errorProp.copy();
        this.eImag = errorProp2.copy();
        this.corrCoeff = d;
    }

    public ComplexErrorProp(double d, double d2, double d3, double d4) {
        this.eReal.reset(d, d2);
        this.eImag.reset(d3, d4);
        this.corrCoeff = 0.0;
    }

    public ComplexErrorProp(double d, double d2, double d3, double d4, double d5) {
        this.eReal.reset(d, d2);
        this.eImag.reset(d3, d4);
        this.corrCoeff = d5;
    }

    public void reset(ErrorProp errorProp, ErrorProp errorProp2) {
        this.eReal = errorProp.copy();
        this.eImag = errorProp2.copy();
        this.corrCoeff = 0.0;
    }

    public void reset(ErrorProp errorProp, ErrorProp errorProp2, double d) {
        this.eReal = errorProp.copy();
        this.eImag = errorProp2.copy();
        this.corrCoeff = d;
    }

    public void reset(double d, double d2, double d3, double d4) {
        this.eReal.setValue(d);
        this.eReal.setError(d2);
        this.eImag.setValue(d3);
        this.eImag.setError(d4);
        this.corrCoeff = 0.0;
    }

    public void reset(double d, double d2, double d3, double d4, double d5) {
        this.eReal.setValue(d);
        this.eReal.setError(d2);
        this.eImag.setValue(d3);
        this.eImag.setError(d4);
        this.corrCoeff = d5;
    }

    public void polar(ErrorProp errorProp, ErrorProp errorProp2) {
        this.polar(errorProp, errorProp2, 0.0);
    }

    public void polar(ErrorProp errorProp, ErrorProp errorProp2, double d) {
        ErrorProp errorProp3 = new ErrorProp();
        this.eReal = errorProp3 = errorProp.times(ErrorProp.cos(errorProp2), d);
        this.eImag = errorProp3 = errorProp.times(ErrorProp.sin(errorProp2), d);
        PsRandom psRandom = new PsRandom();
        double[][] dArray = psRandom.correlatedGaussianArrays(errorProp.getValue(), errorProp2.getValue(), errorProp.getError(), errorProp2.getError(), d, monteCarloLength);
        double[] dArray2 = new double[monteCarloLength];
        double[] dArray3 = new double[monteCarloLength];
        for (int j = 0; j < monteCarloLength; ++j) {
            dArray2[j] = dArray[0][j] * Math.cos(dArray[1][j]);
            dArray3[j] = dArray[0][j] * Math.sin(dArray[1][j]);
        }
        this.corrCoeff = ComplexErrorProp.calcRho(dArray2, dArray3);
    }

    public static double calcRho(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new IllegalArgumentException("length of x and y must be the same");
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int j = 0; j < n; ++j) {
            d += dArray[j];
            d2 += dArray2[j];
        }
        d /= (double)n;
        d2 /= (double)n;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int j = 0; j < n; ++j) {
            d3 += Fmath.square(dArray[j] - d);
            d4 += Fmath.square(dArray2[j] - d2);
            d5 += (dArray[j] - d) * (dArray2[j] - d2);
        }
        d3 = Math.sqrt(d3 / (double)(n - 1));
        d4 = Math.sqrt(d4 / (double)(n - 1));
        return (d5 /= (double)(n - 1)) / (d3 * d4);
    }

    public void polar(double d, double d2, double d3, double d4) {
        ErrorProp errorProp = new ErrorProp(d, d2);
        ErrorProp errorProp2 = new ErrorProp(d3, d4);
        this.polar(errorProp, errorProp2, 0.0);
    }

    public void polar(double d, double d2, double d3, double d4, double d5) {
        ErrorProp errorProp = new ErrorProp(d, d2);
        ErrorProp errorProp2 = new ErrorProp(d3, d4);
        this.polar(errorProp, errorProp2, d5);
    }

    public void setReal(ErrorProp errorProp) {
        this.eReal = errorProp.copy();
    }

    public void setReal(double d, double d2) {
        this.eReal.setValue(d);
        this.eReal.setError(d2);
    }

    public void setImag(ErrorProp errorProp) {
        this.eImag = errorProp.copy();
    }

    public void setImag(double d, double d2) {
        this.eImag.setValue(d);
        this.eImag.setError(d2);
    }

    public void setDouble(double d) {
        this.eReal.reset(d, 0.0);
        this.eImag.reset(0.0, 0.0);
    }

    public void setCorrCoeff(double d) {
        this.corrCoeff = d;
    }

    public static void setMonteCarloLength(int n) {
        monteCarloLength = n;
    }

    public ErrorProp getReal() {
        return this.eReal.copy();
    }

    public double getRealValue() {
        return this.eReal.getValue();
    }

    public double getRealError() {
        return this.eReal.getError();
    }

    public ErrorProp getImag() {
        return this.eImag.copy();
    }

    public double getImagValue() {
        return this.eImag.getValue();
    }

    public double getImagError() {
        return this.eImag.getError();
    }

    public double getCorrCoeff() {
        return this.corrCoeff;
    }

    public static int getMonteCarloLength() {
        return monteCarloLength;
    }

    public static ComplexErrorProp copy(ComplexErrorProp complexErrorProp) {
        if (complexErrorProp == null) {
            return null;
        }
        ComplexErrorProp complexErrorProp2 = new ComplexErrorProp();
        complexErrorProp2.eReal = complexErrorProp.eReal.copy();
        complexErrorProp2.eImag = complexErrorProp.eImag.copy();
        return complexErrorProp2;
    }

    public ComplexErrorProp copy() {
        if (this == null) {
            return null;
        }
        ComplexErrorProp complexErrorProp = new ComplexErrorProp();
        complexErrorProp.eReal = this.eReal.copy();
        complexErrorProp.eImag = this.eImag.copy();
        return complexErrorProp;
    }

    public Object clone() {
        if (this == null) {
            return null;
        }
        ComplexErrorProp complexErrorProp = new ComplexErrorProp();
        complexErrorProp.eReal = this.eReal.copy();
        complexErrorProp.eImag = this.eImag.copy();
        return complexErrorProp;
    }

    public static ComplexErrorProp plus(ComplexErrorProp complexErrorProp, ComplexErrorProp complexErrorProp2) {
        ComplexErrorProp complexErrorProp3 = new ComplexErrorProp();
        complexErrorProp3.eReal = complexErrorProp.eReal.plus(complexErrorProp2.eReal);
        complexErrorProp3.eImag = complexErrorProp.eImag.plus(complexErrorProp2.eImag);
        return complexErrorProp3;
    }

    public ComplexErrorProp plus(ComplexErrorProp complexErrorProp) {
        ComplexErrorProp complexErrorProp2 = new ComplexErrorProp();
        complexErrorProp2.eReal = this.eReal.plus(complexErrorProp.eReal);
        complexErrorProp2.eImag = this.eImag.plus(complexErrorProp.eImag);
        return complexErrorProp2;
    }

    public static ComplexErrorProp minus(ComplexErrorProp complexErrorProp, ComplexErrorProp complexErrorProp2) {
        ComplexErrorProp complexErrorProp3 = new ComplexErrorProp();
        complexErrorProp3.eReal = complexErrorProp.eReal.minus(complexErrorProp2.eReal);
        complexErrorProp3.eImag = complexErrorProp.eImag.minus(complexErrorProp2.eImag);
        return complexErrorProp3;
    }

    public ComplexErrorProp minus(ComplexErrorProp complexErrorProp) {
        ComplexErrorProp complexErrorProp2 = new ComplexErrorProp();
        complexErrorProp2.eReal = this.eReal.minus(complexErrorProp.eReal);
        complexErrorProp2.eImag = this.eImag.minus(complexErrorProp.eImag);
        return complexErrorProp2;
    }

    public static ComplexErrorProp times(ComplexErrorProp complexErrorProp, ComplexErrorProp complexErrorProp2) {
        ComplexErrorProp complexErrorProp3 = new ComplexErrorProp();
        complexErrorProp3.eReal = complexErrorProp.eReal.times(complexErrorProp2.eReal).minus(complexErrorProp.eImag.times(complexErrorProp2.eImag));
        complexErrorProp3.eImag = complexErrorProp.eReal.times(complexErrorProp2.eImag).plus(complexErrorProp.eImag.times(complexErrorProp2.eReal));
        return complexErrorProp3;
    }

    public ComplexErrorProp times(ComplexErrorProp complexErrorProp) {
        ComplexErrorProp complexErrorProp2 = new ComplexErrorProp();
        complexErrorProp2.eReal = this.eReal.times(complexErrorProp.eReal).minus(this.eImag.times(complexErrorProp.eImag));
        complexErrorProp2.eImag = this.eReal.times(complexErrorProp.eImag).plus(this.eImag.times(complexErrorProp.eReal));
        return complexErrorProp2;
    }

    public void timesEquals(ComplexErrorProp complexErrorProp) {
        ComplexErrorProp complexErrorProp2 = new ComplexErrorProp();
        complexErrorProp2.eReal = complexErrorProp.eReal.times(this.eReal).minus(complexErrorProp.eImag.times(this.eImag));
        complexErrorProp2.eImag = complexErrorProp.eReal.times(this.eImag).plus(complexErrorProp.eImag.times(this.eReal));
        this.eReal = complexErrorProp2.eReal.copy();
        this.eImag = complexErrorProp2.eImag.copy();
    }

    public static ComplexErrorProp over(ComplexErrorProp complexErrorProp, ComplexErrorProp complexErrorProp2) {
        int n;
        ComplexErrorProp complexErrorProp3 = new ComplexErrorProp();
        PsRandom psRandom = new PsRandom();
        double[] dArray = psRandom.gaussianArray(complexErrorProp.eReal.getValue(), complexErrorProp.eReal.getError(), monteCarloLength);
        double[] dArray2 = psRandom.gaussianArray(complexErrorProp.eImag.getValue(), complexErrorProp.eImag.getError(), monteCarloLength);
        double[] dArray3 = psRandom.gaussianArray(complexErrorProp2.eReal.getValue(), complexErrorProp2.eReal.getError(), monteCarloLength);
        double[] dArray4 = psRandom.gaussianArray(complexErrorProp2.eImag.getValue(), complexErrorProp2.eImag.getError(), monteCarloLength);
        double[] dArray5 = new double[monteCarloLength];
        double[] dArray6 = new double[monteCarloLength];
        double[] dArray7 = new double[monteCarloLength];
        double[] dArray8 = new double[monteCarloLength];
        for (int j = 0; j < monteCarloLength; ++j) {
            if (Math.abs(dArray3[j]) >= Math.abs(dArray4[j])) {
                dArray5[j] = dArray4[j] / dArray3[j];
                dArray6[j] = dArray3[j] + dArray4[j] * dArray5[j];
                dArray7[j] = (dArray[j] + dArray2[j] * dArray5[j]) / dArray6[j];
                dArray8[j] = (dArray2[j] - dArray[j] * dArray5[j]) / dArray6[j];
                continue;
            }
            dArray5[j] = dArray3[j] / dArray4[j];
            dArray6[j] = dArray3[j] * dArray5[j] + dArray4[j];
            dArray7[j] = (dArray[j] * dArray5[j] + dArray2[j]) / dArray6[j];
            dArray8[j] = (dArray2[j] * dArray5[j] - dArray[j]) / dArray6[j];
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n = 0; n < monteCarloLength; ++n) {
            d += dArray7[n];
            d2 += dArray8[n];
        }
        d /= (double)monteCarloLength;
        d2 /= (double)monteCarloLength;
        for (n = 0; n < monteCarloLength; ++n) {
            d3 += Fmath.square(d - dArray7[n]);
            d4 += Fmath.square(d2 - dArray8[n]);
        }
        d3 = Math.sqrt(d3 / (double)(monteCarloLength - 1));
        d4 = Math.sqrt(d4 / (double)(monteCarloLength - 1));
        complexErrorProp3.eReal.setError(d3);
        complexErrorProp3.eImag.setError(d4);
        double d5 = 0.0;
        double d6 = 0.0;
        if (Math.abs(complexErrorProp2.eReal.getValue()) >= Math.abs(complexErrorProp2.eImag.getValue())) {
            d6 = complexErrorProp2.eImag.getValue() / complexErrorProp2.eReal.getValue();
            d5 = complexErrorProp2.eReal.getValue() + complexErrorProp2.eImag.getValue() * d6;
            complexErrorProp3.eReal.setValue((complexErrorProp.eReal.getValue() + complexErrorProp.eImag.getValue() * d6) / d5);
            complexErrorProp3.eImag.setValue((complexErrorProp.eImag.getValue() - complexErrorProp.eReal.getValue() * d6) / d5);
        } else {
            d6 = complexErrorProp2.eReal.getValue() / complexErrorProp2.eImag.getValue();
            d5 = complexErrorProp2.eReal.getValue() * d6 + complexErrorProp2.eImag.getValue();
            complexErrorProp3.eReal.setValue((complexErrorProp.eReal.getValue() * d6 + complexErrorProp.eImag.getValue()) / d5);
            complexErrorProp3.eImag.setValue((complexErrorProp.eImag.getValue() * d6 - complexErrorProp.eReal.getValue()) / d5);
        }
        return complexErrorProp3;
    }

    public ComplexErrorProp over(ComplexErrorProp complexErrorProp) {
        int n;
        ComplexErrorProp complexErrorProp2 = new ComplexErrorProp();
        PsRandom psRandom = new PsRandom();
        double[] dArray = psRandom.gaussianArray(this.eReal.getValue(), this.eReal.getError(), monteCarloLength);
        double[] dArray2 = psRandom.gaussianArray(this.eImag.getValue(), this.eImag.getError(), monteCarloLength);
        double[] dArray3 = psRandom.gaussianArray(complexErrorProp.eReal.getValue(), complexErrorProp.eReal.getError(), monteCarloLength);
        double[] dArray4 = psRandom.gaussianArray(complexErrorProp.eImag.getValue(), complexErrorProp.eImag.getError(), monteCarloLength);
        double[] dArray5 = new double[monteCarloLength];
        double[] dArray6 = new double[monteCarloLength];
        double[] dArray7 = new double[monteCarloLength];
        double[] dArray8 = new double[monteCarloLength];
        for (int j = 0; j < monteCarloLength; ++j) {
            if (Math.abs(dArray3[j]) >= Math.abs(dArray4[j])) {
                dArray5[j] = dArray4[j] / dArray3[j];
                dArray6[j] = dArray3[j] + dArray4[j] * dArray5[j];
                dArray7[j] = (dArray[j] + dArray2[j] * dArray5[j]) / dArray6[j];
                dArray8[j] = (dArray2[j] - dArray[j] * dArray5[j]) / dArray6[j];
                continue;
            }
            dArray5[j] = dArray3[j] / dArray4[j];
            dArray6[j] = dArray3[j] * dArray5[j] + dArray4[j];
            dArray7[j] = (dArray[j] * dArray5[j] + dArray2[j]) / dArray6[j];
            dArray8[j] = (dArray2[j] * dArray5[j] - dArray[j]) / dArray6[j];
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n = 0; n < monteCarloLength; ++n) {
            d += dArray7[n];
            d2 += dArray8[n];
        }
        d /= (double)monteCarloLength;
        d2 /= (double)monteCarloLength;
        for (n = 0; n < monteCarloLength; ++n) {
            d3 += Fmath.square(d - dArray7[n]);
            d4 += Fmath.square(d2 - dArray8[n]);
        }
        d3 = Math.sqrt(d3 / (double)(monteCarloLength - 1));
        d4 = Math.sqrt(d4 / (double)(monteCarloLength - 1));
        complexErrorProp2.eReal.setError(d3);
        complexErrorProp2.eImag.setError(d4);
        double d5 = 0.0;
        double d6 = 0.0;
        if (Math.abs(complexErrorProp.eReal.getValue()) >= Math.abs(complexErrorProp.eImag.getValue())) {
            d6 = complexErrorProp.eImag.getValue() / complexErrorProp.eReal.getValue();
            d5 = complexErrorProp.eReal.getValue() + complexErrorProp.eImag.getValue() * d6;
            complexErrorProp2.eReal.setValue((this.eReal.getValue() + this.eImag.getValue() * d6) / d5);
            complexErrorProp2.eImag.setValue((this.eImag.getValue() - this.eReal.getValue() * d6) / d5);
        } else {
            d6 = complexErrorProp.eReal.getValue() / complexErrorProp.eImag.getValue();
            d5 = complexErrorProp.eReal.getValue() * d6 + complexErrorProp.eImag.getValue();
            complexErrorProp2.eReal.setValue((this.eReal.getValue() * d6 + this.eImag.getValue()) / d5);
            complexErrorProp2.eImag.setValue((this.eImag.getValue() * d6 - this.eReal.getValue()) / d5);
        }
        return complexErrorProp2;
    }

    public static ComplexErrorProp exp(ComplexErrorProp complexErrorProp) {
        ComplexErrorProp complexErrorProp2 = new ComplexErrorProp();
        ErrorProp errorProp = ErrorProp.exp(complexErrorProp.eReal);
        complexErrorProp2.eReal = errorProp.times(ErrorProp.cos(complexErrorProp.eImag), complexErrorProp.corrCoeff);
        complexErrorProp2.eImag = errorProp.times(ErrorProp.sin(complexErrorProp.eImag), complexErrorProp.corrCoeff);
        return complexErrorProp2;
    }

    public ComplexErrorProp exp() {
        ComplexErrorProp complexErrorProp = new ComplexErrorProp();
        ErrorProp errorProp = ErrorProp.exp(this.eReal);
        complexErrorProp.eReal = errorProp.times(ErrorProp.cos(this.eImag), this.corrCoeff);
        complexErrorProp.eImag = errorProp.times(ErrorProp.sin(this.eImag), this.corrCoeff);
        return complexErrorProp;
    }

    public static ErrorProp abs(ComplexErrorProp complexErrorProp) {
        ErrorProp errorProp = new ErrorProp();
        double d = complexErrorProp.eReal.getValue();
        double d2 = complexErrorProp.eImag.getValue();
        double d3 = Math.abs(d);
        double d4 = Math.abs(d2);
        double d5 = 0.0;
        double d6 = 0.0;
        if (d3 == 0.0) {
            d6 = d4;
        } else {
            if (d4 == 0.0) {
                d6 = d3;
            }
            if (d3 >= d4) {
                d5 = d2 / d;
                d6 = d3 * Math.sqrt(1.0 + d5 * d5);
            } else {
                d5 = d / d2;
                d6 = d4 * Math.sqrt(1.0 + d5 * d5);
            }
        }
        errorProp.setValue(d6);
        double d7 = complexErrorProp.eReal.getError();
        double d8 = complexErrorProp.eImag.getError();
        d6 = ComplexErrorProp.hypotWithRho(2.0 * d7 * d, 2.0 * d8 * d2, complexErrorProp.corrCoeff);
        errorProp.setError(d6);
        return errorProp;
    }

    public ErrorProp abs() {
        ErrorProp errorProp = new ErrorProp();
        double d = this.eReal.getValue();
        double d2 = this.eImag.getValue();
        double d3 = Math.abs(d);
        double d4 = Math.abs(d2);
        double d5 = 0.0;
        double d6 = 0.0;
        if (d3 == 0.0) {
            d6 = d4;
        } else {
            if (d4 == 0.0) {
                d6 = d3;
            }
            if (d3 >= d4) {
                d5 = d2 / d;
                d6 = d3 * Math.sqrt(1.0 + d5 * d5);
            } else {
                d5 = d / d2;
                d6 = d4 * Math.sqrt(1.0 + d5 * d5);
            }
        }
        errorProp.setValue(d6);
        double d7 = this.eReal.getError();
        double d8 = this.eImag.getError();
        d6 = ComplexErrorProp.hypotWithRho(2.0 * d7 * d, 2.0 * d8 * d2, this.corrCoeff);
        errorProp.setError(d6);
        return errorProp;
    }

    public static ErrorProp arg(ComplexErrorProp complexErrorProp) {
        ErrorProp errorProp = new ErrorProp();
        errorProp = ErrorProp.atan2(complexErrorProp.eReal, complexErrorProp.eImag, complexErrorProp.corrCoeff);
        return errorProp;
    }

    public ErrorProp arg(double d) {
        ErrorProp errorProp = new ErrorProp();
        errorProp = ErrorProp.atan2(this.eReal, this.eImag, this.corrCoeff);
        return errorProp;
    }

    public static double hypotWithRho(double d, double d2, double d3) {
        double d4 = Math.abs(d);
        double d5 = Math.abs(d2);
        double d6 = 0.0;
        double d7 = 0.0;
        if (d4 == 0.0) {
            d6 = d5;
        } else if (d5 == 0.0) {
            d6 = d4;
        } else if (d4 >= d5) {
            d7 = d5 / d4;
            d6 = d4 * Math.sqrt(1.0 + d7 * d7 + 2.0 * d3 * d7);
        } else {
            d7 = d4 / d5;
            d6 = d5 * Math.sqrt(1.0 + d7 * d7 + 2.0 * d3 * d7);
        }
        return d6;
    }

    public static ComplexErrorProp truncate(ComplexErrorProp complexErrorProp, int n) {
        if (n < 0) {
            return complexErrorProp;
        }
        double d = complexErrorProp.eReal.getValue();
        double d2 = complexErrorProp.eReal.getError();
        double d3 = complexErrorProp.eImag.getValue();
        double d4 = complexErrorProp.eImag.getError();
        ComplexErrorProp complexErrorProp2 = new ComplexErrorProp();
        d = Fmath.truncate(d, n);
        d2 = Fmath.truncate(d2, n);
        d3 = Fmath.truncate(d3, n);
        d4 = Fmath.truncate(d4, n);
        complexErrorProp2.reset(d, d2, d3, d4);
        return complexErrorProp2;
    }

    public ComplexErrorProp truncate(int n) {
        if (n < 0) {
            return this;
        }
        double d = this.eReal.getValue();
        double d2 = this.eReal.getError();
        double d3 = this.eImag.getValue();
        double d4 = this.eImag.getError();
        ComplexErrorProp complexErrorProp = new ComplexErrorProp();
        d = Fmath.truncate(d, n);
        d2 = Fmath.truncate(d2, n);
        d3 = Fmath.truncate(d3, n);
        d4 = Fmath.truncate(d4, n);
        complexErrorProp.reset(d, d2, d3, d4);
        return complexErrorProp;
    }

    public String toString() {
        return "Real part: " + this.eReal.getValue() + ", error = " + this.eReal.getError() + "; Imaginary part: " + this.eImag.getValue() + ", error = " + this.eImag.getError();
    }

    public static String toString(ComplexErrorProp complexErrorProp) {
        return "Real part: " + complexErrorProp.eReal.getValue() + ", error = " + complexErrorProp.eReal.getError() + "; Imaginary part: " + complexErrorProp.eImag.getValue() + ", error = " + complexErrorProp.eImag.getError();
    }

    public void println(String string) {
        System.out.println(string + " " + this.toString());
    }

    public void println() {
        System.out.println(" " + this.toString());
    }

    public void print(String string) {
        System.out.print(string + " " + this.toString());
    }

    public void print() {
        System.out.print(" " + this.toString());
    }
}

