/*
 * Decompiled with CFR 0.152.
 */
package flanagan.complex;

import flanagan.complex.Complex;
import flanagan.math.Fmath;
import flanagan.math.Matrix;

public class ComplexMatrix {
    private int nrow = 0;
    private int ncol = 0;
    private Complex[][] matrix = null;
    private int[] index = null;
    private double dswap = 1.0;
    private static final double TINY = 1.0E-30;

    public ComplexMatrix(int n, int n2) {
        this.nrow = n;
        this.ncol = n2;
        this.matrix = Complex.twoDarray(n, n2);
        this.index = new int[n];
        for (int j = 0; j < n; ++j) {
            this.index[j] = j;
        }
        this.dswap = 1.0;
    }

    public ComplexMatrix(int n, int n2, Complex complex) {
        this.nrow = n;
        this.ncol = n2;
        this.matrix = Complex.twoDarray(n, n2, complex);
        this.index = new int[n];
        for (int j = 0; j < n; ++j) {
            this.index[j] = j;
        }
        this.dswap = 1.0;
    }

    public ComplexMatrix(Complex[][] complexArray) {
        int n;
        this.nrow = complexArray.length;
        this.ncol = complexArray[0].length;
        this.matrix = Complex.twoDarray(this.nrow, this.ncol);
        for (n = 0; n < this.nrow; ++n) {
            if (complexArray[n].length != this.ncol) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            for (int j = 0; j < this.ncol; ++j) {
                this.matrix[n][j] = Complex.copy(complexArray[n][j]);
            }
        }
        this.index = new int[this.nrow];
        for (n = 0; n < this.nrow; ++n) {
            this.index[n] = n;
        }
        this.dswap = 1.0;
    }

    public ComplexMatrix(double[][] dArray) {
        int n;
        this.nrow = dArray.length;
        this.ncol = dArray[0].length;
        for (n = 0; n < this.nrow; ++n) {
            if (dArray[n].length == this.ncol) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        this.matrix = Complex.twoDarray(this.nrow, this.ncol);
        for (n = 0; n < this.nrow; ++n) {
            for (int j = 0; j < this.ncol; ++j) {
                this.matrix[n][j] = new Complex(dArray[n][j], 0.0);
            }
        }
        this.index = new int[this.nrow];
        for (n = 0; n < this.nrow; ++n) {
            this.index[n] = n;
        }
        this.dswap = 1.0;
    }

    public ComplexMatrix(ComplexMatrix complexMatrix) {
        this.nrow = complexMatrix.nrow;
        this.ncol = complexMatrix.ncol;
        this.matrix = complexMatrix.copy().matrix;
        this.index = complexMatrix.index;
        this.dswap = complexMatrix.dswap;
    }

    public ComplexMatrix(Matrix matrix) {
        this.nrow = matrix.getNrow();
        this.ncol = matrix.getNcol();
        double[][] dArray = matrix.getArrayCopy();
        this.matrix = Complex.twoDarray(this.nrow, this.ncol);
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < this.ncol; ++k) {
                this.matrix[j][k] = new Complex(dArray[j][k], 0.0);
            }
        }
        this.index = matrix.getIndexCopy();
        this.dswap = matrix.getSwap();
    }

    public void setTwoDarray(Complex[][] complexArray) {
        if (this.nrow != complexArray.length) {
            throw new IllegalArgumentException("row length of this ComplexMatrix differs from that of the 2D array argument");
        }
        if (this.ncol != complexArray[0].length) {
            throw new IllegalArgumentException("column length of this ComplexMatrix differs from that of the 2D array argument");
        }
        for (int j = 0; j < this.nrow; ++j) {
            if (complexArray[j].length != this.ncol) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            for (int k = 0; k < this.ncol; ++k) {
                this.matrix[j][k] = Complex.copy(complexArray[j][k]);
            }
        }
    }

    public void setTwoDarray(double[][] dArray) {
        if (this.nrow != dArray.length) {
            throw new IllegalArgumentException("row length of this ComplexMatrix differs from that of the 2D array argument");
        }
        if (this.ncol != dArray[0].length) {
            throw new IllegalArgumentException("column length of this ComplexMatrix differs from that of the 2D array argument");
        }
        for (int j = 0; j < this.nrow; ++j) {
            if (dArray[j].length != this.ncol) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            for (int k = 0; k < this.ncol; ++k) {
                this.matrix[j][k] = new Complex(dArray[j][k]);
            }
        }
    }

    public void setElement(int n, int n2, Complex complex) {
        this.matrix[n][n2] = Complex.copy(complex);
    }

    public void setElement(int n, int n2, double d, double d2) {
        this.matrix[n][n2].reset(d, d2);
    }

    public void setSubMatrix(int n, int n2, int n3, int n4, Complex[][] complexArray) {
        this.setSubMatrix(n, n2, complexArray);
    }

    public void setSubMatrix(int n, int n2, Complex[][] complexArray) {
        int n3 = complexArray.length;
        int n4 = complexArray[0].length;
        if (n + n3 - 1 >= this.nrow) {
            throw new IllegalArgumentException("Sub-matrix position is outside the row bounds of this Matrix");
        }
        if (n2 + n4 - 1 >= this.ncol) {
            throw new IllegalArgumentException("Sub-matrix position is outside the column bounds of this Matrix");
        }
        int n5 = 0;
        int n6 = 0;
        for (int j = 0; j < n3; ++j) {
            n6 = 0;
            for (int k = 0; k < n4; ++k) {
                this.matrix[n + j][n2 + k] = Complex.copy(complexArray[n5][n6]);
                ++n6;
            }
            ++n5;
        }
    }

    public void setSubMatrix(int[] nArray, int[] nArray2, Complex[][] complexArray) {
        int n = nArray.length;
        int n2 = nArray2.length;
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                this.matrix[nArray[j]][nArray2[k]] = Complex.copy(complexArray[j][k]);
            }
        }
    }

    public static ComplexMatrix identityMatrix(int n) {
        ComplexMatrix complexMatrix = new ComplexMatrix(n, n);
        for (int j = 0; j < n; ++j) {
            complexMatrix.matrix[j][j] = Complex.plusOne();
        }
        return complexMatrix;
    }

    public static ComplexMatrix scalarMatrix(int n, Complex complex) {
        ComplexMatrix complexMatrix = new ComplexMatrix(n, n);
        Complex[][] complexArray = complexMatrix.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = j; k < n; ++k) {
                if (j != k) continue;
                complexArray[j][k] = Complex.copy(complex);
            }
        }
        return complexMatrix;
    }

    public static ComplexMatrix diagonalMatrix(int n, Complex[] complexArray) {
        if (complexArray.length != n) {
            throw new IllegalArgumentException("matrix dimension differs from diagonal array length");
        }
        ComplexMatrix complexMatrix = new ComplexMatrix(n, n);
        Complex[][] complexArray2 = complexMatrix.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = j; k < n; ++k) {
                if (j != k) continue;
                complexArray2[j][k] = Complex.copy(complexArray[j]);
            }
        }
        return complexMatrix;
    }

    public static ComplexMatrix columnMatrix(Complex[] complexArray) {
        int n = complexArray.length;
        ComplexMatrix complexMatrix = new ComplexMatrix(n, 1);
        for (int j = 0; j < n; ++j) {
            complexMatrix.matrix[j][0] = complexArray[j];
        }
        return complexMatrix;
    }

    public static ComplexMatrix rowMatrix(Complex[] complexArray) {
        int n = complexArray.length;
        ComplexMatrix complexMatrix = new ComplexMatrix(1, n);
        for (int j = 0; j < n; ++j) {
            complexMatrix.matrix[0][j] = complexArray[j];
        }
        return complexMatrix;
    }

    public static ComplexMatrix toComplexColumnMatrix(Complex[] complexArray) {
        int n = complexArray.length;
        ComplexMatrix complexMatrix = new ComplexMatrix(n, 1);
        for (int j = 0; j < n; ++j) {
            complexMatrix.matrix[j][0] = complexArray[j].copy();
        }
        return complexMatrix;
    }

    public static ComplexMatrix toComplexColumnMatrix(double[] dArray) {
        int n = dArray.length;
        ComplexMatrix complexMatrix = new ComplexMatrix(n, 1);
        for (int j = 0; j < n; ++j) {
            complexMatrix.matrix[j][0].reset(dArray[j], 0.0);
        }
        return complexMatrix;
    }

    public static ComplexMatrix toComplexRowMatrix(Complex[] complexArray) {
        int n = complexArray.length;
        ComplexMatrix complexMatrix = new ComplexMatrix(1, n);
        for (int j = 0; j < n; ++j) {
            complexMatrix.matrix[0][j] = complexArray[j].copy();
        }
        return complexMatrix;
    }

    public static ComplexMatrix toComplexRowMatrix(double[] dArray) {
        int n = dArray.length;
        ComplexMatrix complexMatrix = new ComplexMatrix(1, n);
        for (int j = 0; j < n; ++j) {
            complexMatrix.matrix[0][j].reset(dArray[j], 0.0);
        }
        return complexMatrix;
    }

    public static ComplexMatrix toComplexMatrix(Matrix matrix) {
        int n = matrix.getNrow();
        int n2 = matrix.getNcol();
        ComplexMatrix complexMatrix = new ComplexMatrix(n, n2);
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                complexMatrix.matrix[j][k].reset(matrix.getElementCopy(j, k), 0.0);
            }
        }
        return complexMatrix;
    }

    public static ComplexMatrix toComplexMatrix(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int j = 1; j < n; ++j) {
            if (dArray[j].length == n2) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        ComplexMatrix complexMatrix = new ComplexMatrix(n, n2);
        for (int j = 0; j < complexMatrix.nrow; ++j) {
            for (int k = 0; k < complexMatrix.ncol; ++k) {
                complexMatrix.matrix[j][k].reset(dArray[j][k], 0.0);
            }
        }
        return complexMatrix;
    }

    public int getNrow() {
        return this.nrow;
    }

    public int getNcol() {
        return this.ncol;
    }

    public Complex[][] getArrayReference() {
        return this.matrix;
    }

    public Complex[][] getArray() {
        return this.matrix;
    }

    public Complex[][] getArrayPointer() {
        return this.matrix;
    }

    public Complex[][] getArrayCopy() {
        Complex[][] complexArray = new Complex[this.nrow][this.ncol];
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < this.ncol; ++k) {
                complexArray[j][k] = Complex.copy(this.matrix[j][k]);
            }
        }
        return complexArray;
    }

    public Complex getElementReference(int n, int n2) {
        return this.matrix[n][n2];
    }

    public Complex getElementPointer(int n, int n2) {
        return this.matrix[n][n2];
    }

    public Complex getElementCopy(int n, int n2) {
        return Complex.copy(this.matrix[n][n2]);
    }

    public ComplexMatrix getSubMatrix(int n, int n2, int n3, int n4) {
        if (n > n3) {
            throw new IllegalArgumentException("row indices inverted");
        }
        if (n2 > n4) {
            throw new IllegalArgumentException("column indices inverted");
        }
        if (n3 >= this.nrow) {
            throw new IllegalArgumentException("Sub-matrix position is outside the row bounds of this Matrix");
        }
        if (n4 >= this.ncol) {
            throw new IllegalArgumentException("Sub-matrix position is outside the column bounds of this Matrix" + n + " " + n4);
        }
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        ComplexMatrix complexMatrix = new ComplexMatrix(n5, n6);
        Complex[][] complexArray = complexMatrix.getArrayReference();
        for (int j = 0; j < n5; ++j) {
            for (int k = 0; k < n6; ++k) {
                complexArray[j][k] = Complex.copy(this.matrix[n + j][n2 + k]);
            }
        }
        return complexMatrix;
    }

    public ComplexMatrix getSubMatrix(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = nArray2.length;
        ComplexMatrix complexMatrix = new ComplexMatrix(n, n2);
        Complex[][] complexArray = complexMatrix.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                complexArray[j][k] = Complex.copy(this.matrix[nArray[j]][nArray2[k]]);
            }
        }
        return complexMatrix;
    }

    public int[] getIndexReference() {
        return this.index;
    }

    public int[] getIndexPointer() {
        return this.index;
    }

    public int[] getIndexCopy() {
        int[] nArray = new int[this.nrow];
        for (int j = 0; j < this.nrow; ++j) {
            nArray[j] = this.index[j];
        }
        return nArray;
    }

    public double getSwap() {
        return this.dswap;
    }

    public static ComplexMatrix copy(ComplexMatrix complexMatrix) {
        int n;
        if (complexMatrix == null) {
            return null;
        }
        int n2 = complexMatrix.getNrow();
        int n3 = complexMatrix.getNcol();
        Complex[][] complexArray = complexMatrix.getArrayReference();
        ComplexMatrix complexMatrix2 = new ComplexMatrix(n2, n3);
        complexMatrix2.nrow = n2;
        complexMatrix2.ncol = n3;
        Complex[][] complexArray2 = complexMatrix2.getArrayReference();
        for (n = 0; n < n2; ++n) {
            for (int j = 0; j < n3; ++j) {
                complexArray2[n][j] = Complex.copy(complexArray[n][j]);
            }
        }
        for (n = 0; n < n2; ++n) {
            complexMatrix2.index[n] = complexMatrix.index[n];
        }
        return complexMatrix2;
    }

    public ComplexMatrix copy() {
        int n;
        if (this == null) {
            return null;
        }
        int n2 = this.nrow;
        int n3 = this.ncol;
        ComplexMatrix complexMatrix = new ComplexMatrix(n2, n3);
        Complex[][] complexArray = complexMatrix.getArrayReference();
        complexMatrix.nrow = n2;
        complexMatrix.ncol = n3;
        for (n = 0; n < n2; ++n) {
            for (int j = 0; j < n3; ++j) {
                complexArray[n][j] = Complex.copy(this.matrix[n][j]);
            }
        }
        for (n = 0; n < n2; ++n) {
            complexMatrix.index[n] = this.index[n];
        }
        return complexMatrix;
    }

    public Object clone() {
        int n;
        if (this == null) {
            return null;
        }
        int n2 = this.nrow;
        int n3 = this.ncol;
        ComplexMatrix complexMatrix = new ComplexMatrix(n2, n3);
        Complex[][] complexArray = complexMatrix.getArrayReference();
        complexMatrix.nrow = n2;
        complexMatrix.ncol = n3;
        for (n = 0; n < n2; ++n) {
            for (int j = 0; j < n3; ++j) {
                complexArray[n][j] = Complex.copy(this.matrix[n][j]);
            }
        }
        for (n = 0; n < n2; ++n) {
            complexMatrix.index[n] = this.index[n];
        }
        return complexMatrix;
    }

    public ComplexMatrix plus(ComplexMatrix complexMatrix) {
        if (this.nrow != complexMatrix.nrow || this.ncol != complexMatrix.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = complexMatrix.nrow;
        int n2 = complexMatrix.ncol;
        ComplexMatrix complexMatrix2 = new ComplexMatrix(n, n2);
        Complex[][] complexArray = complexMatrix2.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                complexArray[j][k] = this.matrix[j][k].plus(complexMatrix.matrix[j][k]);
            }
        }
        return complexMatrix2;
    }

    public ComplexMatrix plus(Complex[][] complexArray) {
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        if (this.nrow != n || this.ncol != n2) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix complexMatrix = new ComplexMatrix(n, n2);
        Complex[][] complexArray2 = complexMatrix.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                complexArray2[j][k] = this.matrix[j][k].plus(complexArray[j][k]);
            }
        }
        return complexMatrix;
    }

    public ComplexMatrix plus(Matrix matrix) {
        int n = matrix.getNrow();
        int n2 = matrix.getNcol();
        if (this.nrow != n || this.ncol != n2) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix complexMatrix = new ComplexMatrix(n, n2);
        Complex[][] complexArray = complexMatrix.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                complexArray[j][k] = this.matrix[j][k].plus(matrix.getElement(j, k));
            }
        }
        return complexMatrix;
    }

    public ComplexMatrix plus(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        if (this.nrow != n || this.ncol != n2) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix complexMatrix = new ComplexMatrix(n, n2);
        Complex[][] complexArray = complexMatrix.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                complexArray[j][k] = this.matrix[j][k].plus(dArray[j][k]);
            }
        }
        return complexMatrix;
    }

    public static ComplexMatrix plus(ComplexMatrix complexMatrix, ComplexMatrix complexMatrix2) {
        if (complexMatrix.nrow != complexMatrix2.nrow || complexMatrix.ncol != complexMatrix2.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = complexMatrix.nrow;
        int n2 = complexMatrix.ncol;
        ComplexMatrix complexMatrix3 = new ComplexMatrix(n, n2);
        Complex[][] complexArray = complexMatrix3.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                complexArray[j][k] = complexMatrix.matrix[j][k].plus(complexMatrix2.matrix[j][k]);
            }
        }
        return complexMatrix3;
    }

    public void plusEquals(ComplexMatrix complexMatrix) {
        if (this.nrow != complexMatrix.nrow || this.ncol != complexMatrix.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = complexMatrix.nrow;
        int n2 = complexMatrix.ncol;
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                this.matrix[j][k].plusEquals(complexMatrix.matrix[j][k]);
            }
        }
    }

    public ComplexMatrix minus(ComplexMatrix complexMatrix) {
        if (this.nrow != complexMatrix.nrow || this.ncol != complexMatrix.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = this.nrow;
        int n2 = this.ncol;
        ComplexMatrix complexMatrix2 = new ComplexMatrix(n, n2);
        Complex[][] complexArray = complexMatrix2.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                complexArray[j][k] = this.matrix[j][k].minus(complexMatrix.matrix[j][k]);
            }
        }
        return complexMatrix2;
    }

    public ComplexMatrix minus(Complex[][] complexArray) {
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        if (this.nrow != n || this.ncol != n2) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix complexMatrix = new ComplexMatrix(n, n2);
        Complex[][] complexArray2 = complexMatrix.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                complexArray2[j][k] = this.matrix[j][k].minus(complexArray[j][k]);
            }
        }
        return complexMatrix;
    }

    public ComplexMatrix minus(Matrix matrix) {
        int n = matrix.getNrow();
        int n2 = matrix.getNcol();
        if (this.nrow != n || this.ncol != n2) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix complexMatrix = new ComplexMatrix(n, n2);
        Complex[][] complexArray = complexMatrix.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                complexArray[j][k] = this.matrix[j][k].minus(matrix.getElement(j, k));
            }
        }
        return complexMatrix;
    }

    public ComplexMatrix minus(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        if (this.nrow != n || this.ncol != n2) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix complexMatrix = new ComplexMatrix(n, n2);
        Complex[][] complexArray = complexMatrix.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                complexArray[j][k] = this.matrix[j][k].minus(dArray[j][k]);
            }
        }
        return complexMatrix;
    }

    public static ComplexMatrix minus(ComplexMatrix complexMatrix, ComplexMatrix complexMatrix2) {
        if (complexMatrix.nrow != complexMatrix2.nrow || complexMatrix.ncol != complexMatrix2.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = complexMatrix.nrow;
        int n2 = complexMatrix.ncol;
        ComplexMatrix complexMatrix3 = new ComplexMatrix(n, n2);
        Complex[][] complexArray = complexMatrix3.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                complexArray[j][k] = complexMatrix.matrix[j][k].minus(complexMatrix2.matrix[j][k]);
            }
        }
        return complexMatrix3;
    }

    public void minusEquals(ComplexMatrix complexMatrix) {
        if (this.nrow != complexMatrix.nrow || this.ncol != complexMatrix.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = complexMatrix.nrow;
        int n2 = complexMatrix.ncol;
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                this.matrix[j][k].minusEquals(complexMatrix.matrix[j][k]);
            }
        }
    }

    public ComplexMatrix times(ComplexMatrix complexMatrix) {
        if (this.ncol != complexMatrix.nrow) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        ComplexMatrix complexMatrix2 = new ComplexMatrix(this.nrow, complexMatrix.ncol);
        Complex[][] complexArray = complexMatrix2.getArrayReference();
        Complex complex = new Complex();
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < complexMatrix.ncol; ++k) {
                complex = Complex.zero();
                for (int i2 = 0; i2 < this.ncol; ++i2) {
                    complex.plusEquals(this.matrix[j][i2].times(complexMatrix.matrix[i2][k]));
                }
                complexArray[j][k] = Complex.copy(complex);
            }
        }
        return complexMatrix2;
    }

    public ComplexMatrix times(Complex[][] complexArray) {
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        if (this.ncol != n) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        ComplexMatrix complexMatrix = new ComplexMatrix(this.nrow, n2);
        Complex[][] complexArray2 = complexMatrix.getArrayReference();
        Complex complex = new Complex();
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < n2; ++k) {
                complex = Complex.zero();
                for (int i2 = 0; i2 < this.ncol; ++i2) {
                    complex.plusEquals(this.matrix[j][i2].times(complexArray[i2][k]));
                }
                complexArray2[j][k] = Complex.copy(complex);
            }
        }
        return complexMatrix;
    }

    public ComplexMatrix times(Matrix matrix) {
        int n = matrix.getNrow();
        int n2 = matrix.getNcol();
        if (this.ncol != n) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        ComplexMatrix complexMatrix = new ComplexMatrix(this.nrow, n2);
        Complex[][] complexArray = complexMatrix.getArrayReference();
        Complex complex = new Complex();
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < n2; ++k) {
                complex = Complex.zero();
                for (int i2 = 0; i2 < this.ncol; ++i2) {
                    complex.plusEquals(this.matrix[j][i2].times(matrix.getElement(i2, k)));
                }
                complexArray[j][k] = Complex.copy(complex);
            }
        }
        return complexMatrix;
    }

    public ComplexMatrix times(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        if (this.ncol != n) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        ComplexMatrix complexMatrix = new ComplexMatrix(this.nrow, n2);
        Complex[][] complexArray = complexMatrix.getArrayReference();
        Complex complex = new Complex();
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < n2; ++k) {
                complex = Complex.zero();
                for (int i2 = 0; i2 < this.ncol; ++i2) {
                    complex.plusEquals(this.matrix[j][i2].times(dArray[i2][k]));
                }
                complexArray[j][k] = Complex.copy(complex);
            }
        }
        return complexMatrix;
    }

    public ComplexMatrix times(Complex complex) {
        ComplexMatrix complexMatrix = new ComplexMatrix(this.nrow, this.ncol);
        Complex[][] complexArray = complexMatrix.getArrayReference();
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < this.ncol; ++k) {
                complexArray[j][k] = this.matrix[j][k].times(complex);
            }
        }
        return complexMatrix;
    }

    public ComplexMatrix times(double d) {
        ComplexMatrix complexMatrix = new ComplexMatrix(this.nrow, this.ncol);
        Complex[][] complexArray = complexMatrix.getArrayReference();
        Complex complex = new Complex(d, 0.0);
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < this.ncol; ++k) {
                complexArray[j][k] = this.matrix[j][k].times(complex);
            }
        }
        return complexMatrix;
    }

    public static ComplexMatrix times(ComplexMatrix complexMatrix, ComplexMatrix complexMatrix2) {
        if (complexMatrix.ncol != complexMatrix2.nrow) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        ComplexMatrix complexMatrix3 = new ComplexMatrix(complexMatrix.nrow, complexMatrix2.ncol);
        Complex[][] complexArray = complexMatrix3.getArrayReference();
        Complex complex = new Complex();
        for (int j = 0; j < complexMatrix.nrow; ++j) {
            for (int k = 0; k < complexMatrix2.ncol; ++k) {
                complex = Complex.zero();
                for (int i2 = 0; i2 < complexMatrix.ncol; ++i2) {
                    complex.plusEquals(complexMatrix.matrix[j][i2].times(complexMatrix2.matrix[i2][k]));
                }
                complexArray[j][k] = Complex.copy(complex);
            }
        }
        return complexMatrix3;
    }

    public static ComplexMatrix times(ComplexMatrix complexMatrix, Complex complex) {
        ComplexMatrix complexMatrix2 = new ComplexMatrix(complexMatrix.nrow, complexMatrix.ncol);
        Complex[][] complexArray = complexMatrix2.getArrayReference();
        for (int j = 0; j < complexMatrix.nrow; ++j) {
            for (int k = 0; k < complexMatrix.ncol; ++k) {
                complexArray[j][k] = complexMatrix.matrix[j][k].times(complex);
            }
        }
        return complexMatrix2;
    }

    public static ComplexMatrix times(ComplexMatrix complexMatrix, double d) {
        ComplexMatrix complexMatrix2 = new ComplexMatrix(complexMatrix.nrow, complexMatrix.ncol);
        Complex[][] complexArray = complexMatrix2.getArrayReference();
        Complex complex = new Complex(d, 0.0);
        for (int j = 0; j < complexMatrix.nrow; ++j) {
            for (int k = 0; k < complexMatrix.ncol; ++k) {
                complexArray[j][k] = complexMatrix.matrix[j][k].times(complex);
            }
        }
        return complexMatrix2;
    }

    public void timesEquals(ComplexMatrix complexMatrix) {
        int n;
        int n2;
        if (this.ncol != complexMatrix.nrow) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        ComplexMatrix complexMatrix2 = new ComplexMatrix(this.nrow, complexMatrix.ncol);
        Complex[][] complexArray = complexMatrix2.getArrayReference();
        Complex complex = new Complex();
        for (n2 = 0; n2 < this.nrow; ++n2) {
            for (n = 0; n < complexMatrix.ncol; ++n) {
                complex = Complex.zero();
                for (int j = 0; j < this.ncol; ++j) {
                    complex.plusEquals(this.matrix[n2][j].times(complexMatrix.matrix[j][n]));
                }
                complexArray[n2][n] = Complex.copy(complex);
            }
        }
        this.nrow = complexMatrix2.nrow;
        this.ncol = complexMatrix2.ncol;
        for (n2 = 0; n2 < this.nrow; ++n2) {
            for (n = 0; n < this.ncol; ++n) {
                this.matrix[n2][n] = complexMatrix2.matrix[n2][n];
            }
        }
    }

    public void timesEquals(Complex complex) {
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < this.ncol; ++k) {
                this.matrix[j][k].timesEquals(complex);
            }
        }
    }

    public void timesEquals(double d) {
        Complex complex = new Complex(d, 0.0);
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < this.ncol; ++k) {
                this.matrix[j][k].timesEquals(complex);
            }
        }
    }

    public ComplexMatrix over(ComplexMatrix complexMatrix) {
        if (this.nrow != complexMatrix.nrow || this.ncol != complexMatrix.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        return this.times(complexMatrix.inverse());
    }

    public ComplexMatrix over(Complex[][] complexArray) {
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        if (this.nrow != n || this.ncol != n2) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix complexMatrix = new ComplexMatrix(complexArray);
        return this.times(complexMatrix.inverse());
    }

    public ComplexMatrix over(Matrix matrix) {
        ComplexMatrix complexMatrix = ComplexMatrix.toComplexMatrix(matrix);
        return this.over(complexMatrix);
    }

    public ComplexMatrix over(double[][] dArray) {
        ComplexMatrix complexMatrix = ComplexMatrix.toComplexMatrix(dArray);
        return this.over(complexMatrix);
    }

    public ComplexMatrix over(ComplexMatrix complexMatrix, ComplexMatrix complexMatrix2) {
        if (complexMatrix.nrow != complexMatrix2.nrow || complexMatrix.ncol != complexMatrix2.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        return complexMatrix.times(complexMatrix2.inverse());
    }

    public void overEquals(ComplexMatrix complexMatrix) {
        if (this.nrow != complexMatrix.nrow || this.ncol != complexMatrix.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        ComplexMatrix complexMatrix2 = new ComplexMatrix(complexMatrix);
        this.timesEquals(complexMatrix2.inverse());
    }

    public ComplexMatrix inverse() {
        int n = this.nrow;
        if (n != this.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        ComplexMatrix complexMatrix = new ComplexMatrix(n, n);
        if (n == 1) {
            Complex[][] complexArray = this.getArrayCopy();
            if (complexArray[0][0].isZero()) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            complexArray[0][0] = Complex.plusOne().over(complexArray[0][0]);
            complexMatrix = new ComplexMatrix(complexArray);
        } else if (n == 2) {
            Complex[][] complexArray = this.getArrayCopy();
            Complex complex = complexArray[0][0].times(complexArray[1][1]).minus(complexArray[0][1].times(complexArray[1][0]));
            if (complex.isZero()) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            Complex[][] complexArray2 = Complex.twoDarray(2, 2);
            complexArray2[0][0] = complexArray[1][1].over(complex);
            complexArray2[1][1] = complexArray[0][0].over(complex);
            complexArray2[1][0] = complexArray[1][0].negate().over(complex);
            complexArray2[0][1] = complexArray[0][1].negate().over(complex);
            complexMatrix = new ComplexMatrix(complexArray2);
        } else {
            Complex[] complexArray = new Complex[n];
            Complex[] complexArray3 = new Complex[n];
            Complex[][] complexArray4 = complexMatrix.getArrayReference();
            ComplexMatrix complexMatrix2 = this.luDecomp();
            for (int j = 0; j < n; ++j) {
                int n2;
                for (n2 = 0; n2 < n; ++n2) {
                    complexArray[n2] = Complex.zero();
                }
                complexArray[j] = Complex.plusOne();
                complexArray3 = complexMatrix2.luBackSub(complexArray);
                for (n2 = 0; n2 < n; ++n2) {
                    complexArray4[n2][j] = Complex.copy(complexArray3[n2]);
                }
            }
        }
        return complexMatrix;
    }

    public static ComplexMatrix inverse(ComplexMatrix complexMatrix) {
        int n = complexMatrix.nrow;
        if (n != complexMatrix.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        ComplexMatrix complexMatrix2 = new ComplexMatrix(n, n);
        if (n == 1) {
            Complex[][] complexArray = complexMatrix.getArrayCopy();
            if (complexArray[0][0].isZero()) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            complexArray[0][0] = Complex.plusOne().over(complexArray[0][0]);
            complexMatrix2 = new ComplexMatrix(complexArray);
        } else if (n == 2) {
            Complex[][] complexArray = complexMatrix.getArrayCopy();
            Complex complex = complexArray[0][0].times(complexArray[1][1]).minus(complexArray[0][1].times(complexArray[1][0]));
            if (complex.isZero()) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            Complex[][] complexArray2 = Complex.twoDarray(2, 2);
            complexArray2[0][0] = complexArray[1][1].over(complex);
            complexArray2[1][1] = complexArray[0][0].over(complex);
            complexArray2[1][0] = complexArray[1][0].negate().over(complex);
            complexArray2[0][1] = complexArray[0][1].negate().over(complex);
            complexMatrix2 = new ComplexMatrix(complexArray2);
        } else {
            Complex[] complexArray = new Complex[n];
            Complex[] complexArray3 = new Complex[n];
            Complex[][] complexArray4 = complexMatrix2.getArrayReference();
            ComplexMatrix complexMatrix3 = complexMatrix.luDecomp();
            for (int j = 0; j < n; ++j) {
                int n2;
                for (n2 = 0; n2 < n; ++n2) {
                    complexArray[n2] = Complex.zero();
                }
                complexArray[j] = Complex.plusOne();
                complexArray3 = complexMatrix3.luBackSub(complexArray);
                for (n2 = 0; n2 < n; ++n2) {
                    complexArray4[n2][j] = Complex.copy(complexArray3[n2]);
                }
            }
        }
        return complexMatrix2;
    }

    public ComplexMatrix transpose() {
        ComplexMatrix complexMatrix = new ComplexMatrix(this.ncol, this.nrow);
        Complex[][] complexArray = complexMatrix.getArrayReference();
        for (int j = 0; j < this.ncol; ++j) {
            for (int k = 0; k < this.nrow; ++k) {
                complexArray[j][k] = Complex.copy(this.matrix[k][j]);
            }
        }
        return complexMatrix;
    }

    public static ComplexMatrix transpose(ComplexMatrix complexMatrix) {
        ComplexMatrix complexMatrix2 = new ComplexMatrix(complexMatrix.ncol, complexMatrix.nrow);
        Complex[][] complexArray = complexMatrix2.getArrayReference();
        for (int j = 0; j < complexMatrix.ncol; ++j) {
            for (int k = 0; k < complexMatrix.nrow; ++k) {
                complexArray[j][k] = Complex.copy(complexMatrix.matrix[k][j]);
            }
        }
        return complexMatrix2;
    }

    public ComplexMatrix conjugate() {
        ComplexMatrix complexMatrix = ComplexMatrix.copy(this);
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < this.ncol; ++k) {
                complexMatrix.matrix[j][k] = this.matrix[j][k].conjugate();
            }
        }
        return complexMatrix;
    }

    public static ComplexMatrix conjugate(ComplexMatrix complexMatrix) {
        ComplexMatrix complexMatrix2 = ComplexMatrix.copy(complexMatrix);
        for (int j = 0; j < complexMatrix.nrow; ++j) {
            for (int k = 0; k < complexMatrix.ncol; ++k) {
                complexMatrix2.matrix[j][k] = complexMatrix.matrix[j][k].conjugate();
            }
        }
        return complexMatrix2;
    }

    public ComplexMatrix adjoin() {
        ComplexMatrix complexMatrix = ComplexMatrix.copy(this);
        complexMatrix = complexMatrix.transpose();
        complexMatrix = complexMatrix.conjugate();
        return complexMatrix;
    }

    public ComplexMatrix adjoin(ComplexMatrix complexMatrix) {
        ComplexMatrix complexMatrix2 = ComplexMatrix.copy(complexMatrix);
        complexMatrix2 = complexMatrix2.transpose();
        complexMatrix2 = complexMatrix2.conjugate();
        return complexMatrix2;
    }

    public ComplexMatrix opposite() {
        ComplexMatrix complexMatrix = ComplexMatrix.copy(this);
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < this.ncol; ++k) {
                complexMatrix.matrix[j][k] = this.matrix[j][k].times(Complex.minusOne());
            }
        }
        return complexMatrix;
    }

    public static ComplexMatrix opposite(ComplexMatrix complexMatrix) {
        ComplexMatrix complexMatrix2 = ComplexMatrix.copy(complexMatrix);
        for (int j = 0; j < complexMatrix.nrow; ++j) {
            for (int k = 0; k < complexMatrix.ncol; ++k) {
                complexMatrix2.matrix[j][k] = complexMatrix.matrix[j][k].times(Complex.minusOne());
            }
        }
        return complexMatrix2;
    }

    public Complex trace() {
        Complex complex = new Complex(0.0, 0.0);
        for (int j = 0; j < Math.min(this.ncol, this.ncol); ++j) {
            complex.plusEquals(this.matrix[j][j]);
        }
        return complex;
    }

    public static Complex trace(ComplexMatrix complexMatrix) {
        Complex complex = new Complex(0.0, 0.0);
        for (int j = 0; j < Math.min(complexMatrix.ncol, complexMatrix.ncol); ++j) {
            complex.plusEquals(complexMatrix.matrix[j][j]);
        }
        return complex;
    }

    public Complex determinant() {
        int n = this.nrow;
        if (n != this.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Complex complex = new Complex();
        ComplexMatrix complexMatrix = this.luDecomp();
        complex.reset(complexMatrix.dswap, 0.0);
        for (int j = 0; j < n; ++j) {
            complex.timesEquals(complexMatrix.matrix[j][j]);
        }
        return complex;
    }

    public static Complex determinant(ComplexMatrix complexMatrix) {
        int n = complexMatrix.nrow;
        if (n != complexMatrix.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Complex complex = new Complex();
        ComplexMatrix complexMatrix2 = complexMatrix.luDecomp();
        complex.reset(complexMatrix2.dswap, 0.0);
        for (int j = 0; j < n; ++j) {
            complex.timesEquals(complexMatrix2.matrix[j][j]);
        }
        return complex;
    }

    public Complex logDeterminant() {
        int n = this.nrow;
        if (n != this.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Complex complex = new Complex();
        ComplexMatrix complexMatrix = this.luDecomp();
        complex.reset(complexMatrix.dswap, 0.0);
        complex = Complex.log(complex);
        for (int j = 0; j < n; ++j) {
            complex.plusEquals(Complex.log(complexMatrix.matrix[j][j]));
        }
        return complex;
    }

    public static Complex logDeterminant(ComplexMatrix complexMatrix) {
        int n = complexMatrix.nrow;
        if (n != complexMatrix.ncol) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Complex complex = new Complex();
        ComplexMatrix complexMatrix2 = complexMatrix.luDecomp();
        complex.reset(complexMatrix2.dswap, 0.0);
        complex = Complex.log(complex);
        for (int j = 0; j < n; ++j) {
            complex.plusEquals(Complex.log(complexMatrix2.matrix[j][j]));
        }
        return complex;
    }

    public ComplexMatrix cofactor() {
        Complex[][] complexArray = Complex.twoDarray(this.nrow, this.ncol);
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < this.ncol; ++k) {
                complexArray[j][k] = this.cofactor(j, k);
            }
        }
        return new ComplexMatrix(complexArray);
    }

    public Complex cofactor(int n, int n2) {
        int n3;
        if (n < 0 || n >= this.nrow) {
            throw new IllegalArgumentException("The entered row index, " + n + " must lie between 0 and " + (this.nrow - 1) + " inclusive");
        }
        if (n2 < 0 || n2 >= this.ncol) {
            throw new IllegalArgumentException("The entered column index, " + n2 + " must lie between 0 and " + (this.ncol - 1) + " inclusive");
        }
        int[] nArray = new int[this.nrow - 1];
        int[] nArray2 = new int[this.ncol - 1];
        int n4 = 0;
        for (n3 = 0; n3 < this.nrow; ++n3) {
            if (n3 == n) continue;
            nArray[n4] = n3;
            ++n4;
        }
        n4 = 0;
        for (n3 = 0; n3 < this.ncol; ++n3) {
            if (n3 == n2) continue;
            nArray2[n4] = n3;
            ++n4;
        }
        ComplexMatrix complexMatrix = this.getSubMatrix(nArray, nArray2);
        Complex complex = complexMatrix.determinant();
        return complex.times(Math.pow(-1.0, n + n2));
    }

    public ComplexMatrix reducedRowEchelonForm() {
        int n;
        int n2;
        int n3;
        int n4;
        Complex[][] complexArray = Complex.twoDarray(this.nrow, this.ncol);
        for (n4 = 0; n4 < this.nrow; ++n4) {
            for (n3 = 0; n3 < this.ncol; ++n3) {
                complexArray[n4][n3] = this.matrix[n4][n3];
            }
        }
        n4 = 0;
        n3 = 0;
        boolean bl = true;
        while (bl) {
            n2 = n3;
            n = 1;
            while (n != 0 && complexArray[n2][n4].equals(Complex.zero())) {
                if (++n2 != this.nrow) continue;
                n2 = n3;
                if (++n4 != this.ncol) continue;
                n = 0;
            }
            if (n != 0) {
                int n5;
                Complex[] complexArray2 = complexArray[n3];
                complexArray[n3] = complexArray[n2];
                complexArray[n2] = complexArray2;
                Complex complex = complexArray[n3][n4];
                for (n5 = 0; n5 < this.ncol; ++n5) {
                    complexArray[n3][n5] = complexArray[n3][n5].over(complex);
                }
                for (n5 = 0; n5 < this.nrow; ++n5) {
                    if (n5 == n3) continue;
                    complex = complexArray[n5][n4];
                    for (int j = 0; j < this.ncol; ++j) {
                        complexArray[n5][j] = complexArray[n5][j].minus(complex.times(complexArray[n3][j]));
                    }
                }
                if (++n4 >= this.ncol) {
                    bl = false;
                }
            }
            if (++n3 < this.nrow && n != 0) continue;
            bl = false;
        }
        for (n2 = 0; n2 < this.nrow; ++n2) {
            for (n = 0; n < this.ncol; ++n) {
                if (complexArray[n2][n].getReal() == -0.0) {
                    complexArray[n2][n].reset(0.0, complexArray[n2][n].getImag());
                }
                if (complexArray[n2][n].getImag() != -0.0) continue;
                complexArray[n2][n].reset(complexArray[n2][n].getReal(), 0.0);
            }
        }
        return new ComplexMatrix(complexArray);
    }

    public double frobeniusNorm() {
        double d = 0.0;
        for (int j = 0; j < this.nrow; ++j) {
            for (int k = 0; k < this.ncol; ++k) {
                d = Fmath.hypot(d, Complex.abs(this.matrix[j][k]));
            }
        }
        return d;
    }

    public double oneNorm() {
        double d = 0.0;
        double d2 = 0.0;
        for (int j = 0; j < this.nrow; ++j) {
            d2 = 0.0;
            for (int k = 0; k < this.ncol; ++k) {
                d2 += Complex.abs(this.matrix[j][k]);
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public double infinityNorm() {
        double d = 0.0;
        double d2 = 0.0;
        for (int j = 0; j < this.nrow; ++j) {
            d2 = 0.0;
            for (int k = 0; k < this.ncol; ++k) {
                d2 += Complex.abs(this.matrix[j][k]);
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public ComplexMatrix luDecomp() {
        int n;
        int n2;
        if (this.nrow != this.ncol) {
            throw new IllegalArgumentException("A matrix is not square");
        }
        int n3 = this.nrow;
        int n4 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray = new double[n3];
        Complex complex = new Complex();
        Complex complex2 = new Complex();
        ComplexMatrix complexMatrix = ComplexMatrix.copy(this);
        Complex[][] complexArray = complexMatrix.getArrayReference();
        complexMatrix.dswap = 1.0;
        for (n2 = 0; n2 < n3; ++n2) {
            d3 = 0.0;
            for (n = 0; n < n3; ++n) {
                double d4;
                d2 = Complex.abs(complexArray[n2][n]);
                if (!(d4 > d3)) continue;
                d3 = d2;
            }
            if (d3 == 0.0) {
                throw new ArithmeticException("Singular matrix");
            }
            dArray[n2] = 1.0 / d3;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n5;
            for (n = 0; n < n2; ++n) {
                complex = Complex.copy(complexArray[n][n2]);
                for (n5 = 0; n5 < n; ++n5) {
                    complex.minusEquals(complexArray[n][n5].times(complexArray[n5][n2]));
                }
                complexArray[n][n2] = Complex.copy(complex);
            }
            d3 = 0.0;
            for (n = n2; n < n3; ++n) {
                double d5;
                complex = Complex.copy(complexArray[n][n2]);
                for (n5 = 0; n5 < n2; ++n5) {
                    complex.minusEquals(complexArray[n][n5].times(complexArray[n5][n2]));
                }
                complexArray[n][n2] = Complex.copy(complex);
                d = dArray[n] * Complex.abs(complex);
                if (!(d5 >= d3)) continue;
                d3 = d;
                n4 = n;
            }
            if (n2 != n4) {
                for (n = 0; n < n3; ++n) {
                    complex2 = Complex.copy(complexArray[n4][n]);
                    complexArray[n4][n] = Complex.copy(complexArray[n2][n]);
                    complexArray[n2][n] = Complex.copy(complex2);
                }
                complexMatrix.dswap = -complexMatrix.dswap;
                dArray[n4] = dArray[n2];
            }
            complexMatrix.index[n2] = n4;
            if (complexArray[n2][n2].isZero()) {
                complexArray[n2][n2].reset(1.0E-30, 1.0E-30);
            }
            if (n2 == n3 - 1) continue;
            complex2 = Complex.over(1.0, complexArray[n2][n2]);
            for (n = n2 + 1; n < n3; ++n) {
                complexArray[n][n2].timesEquals(complex2);
            }
        }
        return complexMatrix;
    }

    public Complex[] luBackSub(Complex[] complexArray) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = complexArray.length;
        if (n5 != this.ncol) {
            throw new IllegalArgumentException("vector length is not equal to matrix dimension");
        }
        if (this.ncol != this.nrow) {
            throw new IllegalArgumentException("matrix is not square");
        }
        Complex complex = new Complex();
        Complex[] complexArray2 = new Complex[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            complexArray2[n2] = Complex.copy(complexArray[n2]);
        }
        for (n2 = 0; n2 < n5; ++n2) {
            n4 = this.index[n2];
            complex = Complex.copy(complexArray2[n4]);
            complexArray2[n4] = Complex.copy(complexArray2[n2]);
            if (n3 == 0) {
                for (n = n3; n <= n2 - 1; ++n) {
                    complex.minusEquals(this.matrix[n2][n].times(complexArray2[n]));
                }
            } else if (complex.isZero()) {
                n3 = n2;
            }
            complexArray2[n2] = Complex.copy(complex);
        }
        for (n2 = n5 - 1; n2 >= 0; --n2) {
            complex = Complex.copy(complexArray2[n2]);
            for (n = n2 + 1; n < n5; ++n) {
                complex.minusEquals(this.matrix[n2][n].times(complexArray2[n]));
            }
            complexArray2[n2] = complex.over(this.matrix[n2][n2]);
        }
        return complexArray2;
    }

    public Complex[] solveLinearSet(Complex[] complexArray) {
        ComplexMatrix complexMatrix = this.luDecomp();
        return complexMatrix.luBackSub(complexArray);
    }
}

