/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;
import flanagan.math.Conv;
import flanagan.math.Fmath;

public class AtoD
extends BlackBox {
    private int nBits = 0;
    private long maximumDecimal = 0L;
    private double vRef = 0.0;
    private int[] vBinary = null;
    private boolean trueAtoD = true;
    private boolean range = true;
    private double voltageOutput = 0.0;
    private String binaryOutput = "";
    private long decimalOutput = 0L;
    private double sqnr = 0.0;
    private double input = 0.0;
    private double inputC = 0.0;
    private double shift = 0.0;
    private long decimalShift = 0L;
    private boolean decCalcDone = false;
    private boolean binCalcDone = false;
    private boolean inputSet = false;
    private boolean firstCopy = true;

    public AtoD(int n, double d) {
        super("AtoD");
        if (n > 63) {
            throw new IllegalArgumentException("This program cannot accomadate an ADC simulation with a number of bits greater than 63");
        }
        this.nBits = n;
        this.maximumDecimal = (long)Math.pow(2.0, this.nBits) - 1L;
        this.vRef = d;
        this.vBinary = new int[n + 1];
        this.trueAtoD = true;
        super.setSnumer(new ComplexPoly(1.0));
        super.setSdenom(new ComplexPoly(1.0));
        super.setZtransformMethod(1);
    }

    public AtoD() {
        super("AtoD");
        this.fixedName = "AtoD";
        this.sNumerDeg = 0;
        this.sDenomDeg = 0;
        super.setSnumer(new ComplexPoly(1.0));
        super.setSdenom(new ComplexPoly(1.0));
        this.ztransMethod = 1;
        super.setZtransformMethod(1);
    }

    public void setRangeOption(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("argument must be either 0 or 1");
        }
        if (n == 0) {
            this.range = true;
        }
        if (n == 1) {
            this.range = false;
            this.shift = this.vRef / 2.0;
            this.decimalShift = this.maximumDecimal / 2L;
        }
        if (this.inputSet) {
            this.checkInput();
        }
        this.decCalcDone = false;
    }

    public String getRange() {
        String string = null;
        if (this.trueAtoD) {
            string = this.range ? "0 to " + this.vRef : "-" + this.vRef / 2.0 + " to " + this.vRef / 2.0;
        } else {
            System.out.println("Class AtoD; method getRange()");
            System.out.println("No range option set - this instance of AtoD is an 'ADC marker' only");
            System.out.println("getRangeOption has returned 'ADC marker only'");
            string = "ADC marker only";
        }
        return string;
    }

    public boolean getTrueAtoDoption() {
        if (this.trueAtoD) {
            System.out.println("This instance of AtoD is a true simulation of an ADC");
            System.out.println("getTrueAtoDoption has returned 'true'");
        } else {
            System.out.println("This instance of AtoD is not a true simulation of an ADC");
            System.out.println("It is simple an 'A to D marker'");
            System.out.println("getTrueAtoDoption has returned 'false'");
        }
        return this.trueAtoD;
    }

    public double getVref() {
        if (!this.trueAtoD) {
            System.out.println("No reference voltage set - this instance of AtoD is an 'ADC marker' only");
            System.out.println("getVref has returned 0.0 V");
        }
        return this.vRef;
    }

    public void setInput(double d) {
        this.input = d;
        this.checkInput();
        this.inputSet = true;
    }

    public void checkInput() {
        this.inputC = this.input;
        if (this.trueAtoD) {
            if (this.range) {
                if (this.input < 0.0) {
                    System.out.println("lower limit of the ADC range exceeded");
                    System.out.println("input voltage set to zero");
                    this.inputC = 0.0;
                }
                if (this.input > this.vRef) {
                    System.out.println("upper limit of the ADC range exceeded");
                    System.out.println("input voltage set to " + this.vRef);
                    this.inputC = this.vRef;
                }
            } else {
                if (this.input < -this.vRef) {
                    System.out.println("lower limit of the ADC range exceeded");
                    System.out.println("input voltage set to " + -this.vRef / 2.0);
                    this.inputC = -this.vRef / 2.0;
                }
                if (this.input > this.vRef) {
                    System.out.println("upper limit of the ADC range exceeded");
                    System.out.println("input voltage set to " + this.vRef / 2.0);
                    this.inputC = this.vRef / 2.0;
                }
            }
        }
        this.inputC += this.shift;
        this.decCalcDone = false;
        this.binCalcDone = false;
    }

    public long getMaximumDecimal() {
        if (!this.trueAtoD) {
            System.out.println("This instance of AtoD is not a true simulation of an ADC");
            System.out.println("It is simple an 'A to D marker'");
            System.out.println("getTrueAtoDoption has returned 0");
        }
        return this.maximumDecimal;
    }

    public double maximumQuantizationError() {
        double d = 0.0;
        if (this.trueAtoD) {
            d = this.vRef / (double)this.maximumDecimal;
        } else {
            System.out.println("This instance of AtoD is not a true simulation of an ADC");
            System.out.println("It is simple an 'A to D marker'");
            System.out.println("getMaxQuantizationError returns zero");
        }
        return d;
    }

    public void calcOutput() {
        if (this.trueAtoD) {
            this.decimalOutput = (long)Math.floor(this.inputC / this.vRef * (double)this.maximumDecimal) - this.decimalShift;
            this.voltageOutput = this.vRef * (double)this.decimalOutput / (double)this.maximumDecimal;
            this.sqnr = 20.0 * Fmath.log10(Math.abs((this.inputC - this.shift) / (this.inputC - this.shift - this.voltageOutput)));
        } else {
            this.voltageOutput = this.input;
            this.sqnr = Double.POSITIVE_INFINITY;
        }
        this.sNumer.resetCoeff(0, new Complex(this.voltageOutput / this.input, 0.0));
        this.decCalcDone = true;
    }

    public double getSQNR() {
        if (!this.decCalcDone) {
            this.calcOutput();
        }
        if (!this.trueAtoD) {
            System.out.println("This instance of AtoD is not a true simulation of an ADC");
            System.out.println("It is simple an 'A to D marker'");
            System.out.println("getSQNR returned INFINITY");
        }
        return this.sqnr;
    }

    public double voltageOutput() {
        if (!this.decCalcDone) {
            this.calcOutput();
        }
        return this.voltageOutput;
    }

    public long decimalOutput() {
        if (!this.decCalcDone) {
            this.calcOutput();
        }
        if (!this.trueAtoD) {
            System.out.println("No formal A to D conversion performed - this instance of AtoD is an 'ADC marker' only");
            System.out.println("decimalOutput has returned 0");
        }
        return this.decimalOutput;
    }

    public static int[] decimalToBinary(long l, int n) {
        int n2;
        long l2;
        long l3 = 1L;
        if (l < 0L) {
            l3 = -1L;
            l *= l3;
        }
        if ((long)n < (l2 = (long)Math.ceil(Math.log(l) / Math.log(2.0)))) {
            boolean bl = true;
            n2 = 2;
            while (bl) {
                if (!(Math.pow(2.0, n2) > (double)l2)) continue;
                n = n2;
                bl = false;
            }
        }
        int[] nArray = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = 0;
        }
        n2 = 1;
        int n3 = 0;
        while (n2 != 0) {
            nArray[n3] = (int)(l % 2L);
            ++n3;
            if ((l /= 2L) != 0L) continue;
            n2 = 0;
        }
        if (l3 == -1L) {
            nArray = AtoD.negateBinary(nArray);
        }
        return nArray;
    }

    public static int[] negateBinary(int[] nArray) {
        int n;
        int n2;
        int n3 = n2 = nArray.length;
        if (nArray[n2 - 1] == 1) {
            n3 += n3;
        }
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        for (n = 0; n < n3; ++n) {
            nArray3[n] = 0;
            nArray2[n] = 1;
        }
        nArray3[0] = 1;
        for (n = 0; n < n2; ++n) {
            if (nArray[n] != 1) continue;
            nArray2[n] = 0;
        }
        nArray2 = AtoD.addBinary(nArray2, nArray3);
        return nArray2;
    }

    public static int[] addBinary(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = nArray2.length;
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            n3 = n2;
            n4 = n;
        }
        int[] nArray3 = new int[n3];
        int n5 = 0;
        int n6 = 0;
        block6: for (int j = 0; j < n4; ++j) {
            n6 = nArray[j] + nArray2[j] + n5;
            switch (n6) {
                case 0: {
                    nArray3[j] = 0;
                    n5 = 0;
                    continue block6;
                }
                case 1: {
                    nArray3[j] = 1;
                    n5 = 0;
                    continue block6;
                }
                case 2: {
                    nArray3[j] = 0;
                    n5 = 1;
                    continue block6;
                }
                case 3: {
                    nArray3[j] = 1;
                    n5 = 1;
                }
            }
        }
        return nArray3;
    }

    public String binaryOutput() {
        if (!this.decCalcDone) {
            this.calcOutput();
        }
        if (this.trueAtoD) {
            int n = this.nBits + 1;
            long l = this.decimalOutput + this.decimalShift;
            this.vBinary = AtoD.decimalToBinary(l, n);
            if (this.shift > 0.0) {
                int[] nArray = AtoD.decimalToBinary(this.decimalShift, n);
                nArray = AtoD.negateBinary(nArray);
                this.vBinary = AtoD.addBinary(this.vBinary, nArray);
            }
            this.binaryOutput = "";
            for (int j = n - 1; j >= 0; --j) {
                this.binaryOutput = this.binaryOutput + this.vBinary[j];
            }
        } else {
            System.out.println("No formal A to D conversion performed - this instance of AtoD is an 'ADC marker' only");
            System.out.println("binaryOutput has returned 'null'");
        }
        this.binCalcDone = true;
        return this.binaryOutput;
    }

    public int[] binaryArray() {
        if (this.trueAtoD) {
            if (!this.binCalcDone) {
                this.binaryOutput();
            }
        } else {
            System.out.println("No formal A to D conversion performed - this instance of AtoD is an 'ADC marker' only");
            System.out.println("binaryOutput has returned 'null'");
        }
        return this.vBinary;
    }

    public double quantizationError() {
        if (!this.decCalcDone) {
            this.calcOutput();
        }
        double d = 0.0;
        if (this.trueAtoD) {
            d = this.inputC - this.voltageOutput;
        } else {
            System.out.println("This instance of AtoD is not a true simulation of an ADC");
            System.out.println("It is simple an 'A to D marker'");
            System.out.println("getQuantizationError returns zero");
        }
        return d;
    }

    public double clippingError() {
        return this.inputC - this.input;
    }

    @Override
    public AtoD copy() {
        if (this == null) {
            return null;
        }
        AtoD atoD = new AtoD();
        this.copyBBvariables(atoD);
        atoD.nBits = this.nBits;
        atoD.maximumDecimal = this.maximumDecimal;
        atoD.vRef = this.vRef;
        atoD.vBinary = Conv.copy(this.vBinary);
        atoD.trueAtoD = this.trueAtoD;
        atoD.range = this.range;
        atoD.voltageOutput = this.voltageOutput;
        atoD.binaryOutput = this.binaryOutput;
        atoD.decimalOutput = this.decimalOutput;
        atoD.sqnr = this.sqnr;
        atoD.input = this.input;
        atoD.inputC = this.inputC;
        atoD.shift = this.shift;
        atoD.decimalShift = this.decimalShift;
        atoD.decCalcDone = this.decCalcDone;
        atoD.binCalcDone = this.binCalcDone;
        atoD.inputSet = this.inputSet;
        return atoD;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

