/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexMatrix;
import flanagan.complex.ComplexPoly;
import flanagan.interpolation.CubicSpline;
import flanagan.io.Db;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.plot.PlotGraph;
import flanagan.plot.PlotPoleZero;

public class BlackBox {
    protected int sampLen = 0;
    protected double[] inputT = null;
    protected double[] outputT = null;
    protected double[] time = null;
    protected double forgetFactor = 1.0;
    protected double deltaT = 0.0;
    protected double sampFreq = 0.0;
    protected Complex inputS = new Complex();
    protected Complex outputS = new Complex();
    protected Complex sValue = new Complex();
    protected Complex zValue = new Complex();
    protected ComplexPoly sNumer = new ComplexPoly(1.0);
    protected ComplexPoly sDenom = new ComplexPoly(1.0);
    protected ComplexPoly zNumer = new ComplexPoly(1.0);
    protected ComplexPoly zDenom = new ComplexPoly(1.0);
    protected boolean sNumerSet = false;
    protected boolean sDenomSet = false;
    protected Complex sNumerScaleFactor = Complex.plusOne();
    protected Complex sDenomScaleFactor = Complex.plusOne();
    protected Complex sNumerWorkingFactor = Complex.plusOne();
    protected Complex sDenomWorkingFactor = Complex.plusOne();
    protected Complex[] sPoles = null;
    protected Complex[] sZeros = null;
    protected Complex[] zPoles = null;
    protected Complex[] zZeros = null;
    protected int sNumerDeg = 0;
    protected int sDenomDeg = 0;
    protected int zNumerDeg = 0;
    protected int zDenomDeg = 0;
    protected double deadTime = 0.0;
    protected int orderPade = 2;
    protected ComplexPoly sNumerPade = new ComplexPoly(1.0);
    protected ComplexPoly sDenomPade = new ComplexPoly(1.0);
    protected Complex[] sPolesPade = null;
    protected Complex[] sZerosPade = null;
    protected int sNumerDegPade = 0;
    protected int sDenomDegPade = 0;
    protected boolean maptozero = true;
    protected boolean padeAdded = false;
    protected double integrationSum = 0.0;
    protected int integMethod = 1;
    protected int ztransMethod = 0;
    protected String name = "BlackBox";
    protected String fixedName = "BlackBox";
    protected int nPlotPoints = 400;
    protected String[] subclassName = new String[]{"BlackBox", "OpenLoop", "ClosedLoop", "Prop", "PropDeriv", "PropInt", "PropIntDeriv", "FirstOrder", "SecondOrder", "Compensator", "LowPassPassive", "HighPassPassive", "Transducer", "DelayLine", "ZeroOrderHold", "AtoD", "DtoA"};
    protected int nSubclasses = this.subclassName.length;
    protected int subclassIndex = 0;

    public BlackBox() {
    }

    public BlackBox(String string) {
        this.name = string;
        this.fixedName = string;
        this.setSubclassIndex();
    }

    protected void setSubclassIndex() {
        boolean bl = true;
        int n = 0;
        while (bl) {
            if (this.fixedName.equals(this.subclassName[n])) {
                this.subclassIndex = n;
                bl = false;
                continue;
            }
            if (++n < this.nSubclasses) continue;
            System.out.println("Subclass name, " + this.fixedName + ", not recognised as a recorded subclass within this library");
            System.out.println("Subclass, " + this.fixedName + ", handled as BlackBox");
            this.subclassIndex = n;
            bl = false;
        }
    }

    public void setSnumer(double[] dArray) {
        this.sNumerDeg = dArray.length - 1;
        this.sNumer = new ComplexPoly(dArray);
        this.sNumerSet = true;
        this.calcPolesZerosS();
        this.addDeadTimeExtras();
    }

    protected void addDeadTimeExtras() {
        this.sNumerDegPade = this.sNumerDeg;
        this.sNumerPade = this.sNumer.copy();
        this.sDenomDegPade = this.sDenomDeg;
        this.sDenomPade = this.sDenom.copy();
        if (this.deadTime == 0.0) {
            this.transferPolesZeros();
        } else {
            this.pade();
        }
    }

    public void setSnumer(Complex[] complexArray) {
        this.sNumerDeg = complexArray.length - 1;
        this.sNumer = new ComplexPoly(complexArray);
        this.sNumerSet = true;
        this.calcPolesZerosS();
        this.addDeadTimeExtras();
    }

    public void setSnumer(ComplexPoly complexPoly) {
        this.sNumerDeg = complexPoly.getDeg();
        this.sNumer = ComplexPoly.copy(complexPoly);
        this.sNumerSet = true;
        this.calcPolesZerosS();
        this.addDeadTimeExtras();
    }

    public void setSdenom(double[] dArray) {
        this.sDenomDeg = dArray.length - 1;
        this.sDenom = new ComplexPoly(dArray);
        this.sDenomSet = true;
        this.calcPolesZerosS();
        this.addDeadTimeExtras();
    }

    public void setSdenom(Complex[] complexArray) {
        this.sDenomDeg = complexArray.length - 1;
        this.sDenom = new ComplexPoly(complexArray);
        this.sDenomSet = true;
        this.calcPolesZerosS();
        this.addDeadTimeExtras();
    }

    public void setSdenom(ComplexPoly complexPoly) {
        this.sDenomDeg = complexPoly.getDeg();
        this.sDenom = complexPoly.copy();
        this.sDenomSet = true;
        this.calcPolesZerosS();
        this.addDeadTimeExtras();
    }

    public static Complex scaleFactor(ComplexPoly complexPoly, Complex[] complexArray) {
        int n;
        int n2 = complexArray.length;
        Complex complex = new Complex(0.0, 0.0);
        for (n = 0; n < n2; ++n) {
            complex = complex.plus(complexArray[n]);
        }
        complex = complex.over(n2);
        n = 1;
        int n3 = 0;
        while (n != 0) {
            if (complex.isEqual(complexArray[n3])) {
                if (complex.isEqual(Complex.zero())) {
                    for (int j = 0; j < n2; ++j) {
                        complex = complex.plus(complexArray[j].abs());
                    }
                    if (complex.isEqual(Complex.zero())) {
                        complex = Complex.plusOne();
                    }
                } else {
                    complex = complex.times(1.5);
                }
                n3 = 0;
                continue;
            }
            if (++n3 <= n2 - 1) continue;
            n = 0;
        }
        Complex complex2 = new Complex(1.0, 0.0);
        for (int j = 0; j < n2; ++j) {
            complex2 = complex2.times(complex.minus(complexArray[j]));
        }
        Complex complex3 = complexPoly.evaluate(complex);
        return complex3.over(complex2);
    }

    public Complex getSnumerScaleFactor() {
        if (this.sNumerScaleFactor == null) {
            this.calcPolesZerosS();
        }
        return this.sNumerScaleFactor;
    }

    public Complex getSdenomScaleFactor() {
        if (this.sDenomScaleFactor == null) {
            this.calcPolesZerosS();
        }
        return this.sDenomScaleFactor;
    }

    public void setDeadTime(double d) {
        this.deadTime = d;
        this.pade();
    }

    public void setDeadTime(double d, int n) {
        this.deadTime = d;
        if (n > 5) {
            n = 4;
            System.out.println("BlackBox does not support Pade approximations above an order of 4");
            System.out.println("The order has been set to 4");
        }
        if (n < 1) {
            n = 1;
            System.out.println("Pade approximation order was less than 1");
            System.out.println("The order has been set to 1");
        }
        this.orderPade = n;
        this.pade();
    }

    public void setPadeOrder(int n) {
        if (n > 5) {
            n = 4;
            System.out.println("BlackBox does not support Pade approximations above an order of 4");
            System.out.println("The order has been set to 4");
        }
        if (n < 1) {
            n = 2;
            System.out.println("Pade approximation order was less than 1");
            System.out.println("The order has been set to 2");
        }
        this.orderPade = n;
        this.pade();
    }

    public double getDeadTime() {
        return this.deadTime;
    }

    public int getPadeOrder() {
        return this.orderPade;
    }

    protected void pade() {
        ComplexPoly complexPoly = null;
        ComplexPoly complexPoly2 = null;
        Complex[] complexArray = null;
        Complex[] complexArray2 = null;
        switch (this.orderPade) {
            case 1: {
                this.sNumerDegPade = this.sNumerDeg + 1;
                this.sDenomDegPade = this.sDenomDeg + 1;
                this.sNumerPade = new ComplexPoly(this.sNumerDegPade);
                this.sDenomPade = new ComplexPoly(this.sDenomDegPade);
                complexPoly = new ComplexPoly(1.0, -this.deadTime / 2.0);
                complexPoly2 = new ComplexPoly(1.0, this.deadTime / 2.0);
                this.sNumerPade = this.sNumer.times(complexPoly);
                this.sDenomPade = this.sDenom.times(complexPoly2);
                complexArray = Complex.oneDarray(1);
                complexArray[0].reset(2.0 / this.deadTime, 0.0);
                complexArray2 = Complex.oneDarray(1);
                complexArray2[0].reset(-2.0 / this.deadTime, 0.0);
                break;
            }
            case 2: {
                this.sNumerDegPade = this.sNumerDeg + 2;
                this.sDenomDegPade = this.sDenomDeg + 2;
                this.sNumerPade = new ComplexPoly(this.sNumerDegPade);
                this.sDenomPade = new ComplexPoly(this.sDenomDegPade);
                complexPoly = new ComplexPoly(1.0, -this.deadTime / 2.0, Math.pow(this.deadTime, 2.0) / 12.0);
                complexPoly2 = new ComplexPoly(1.0, this.deadTime / 2.0, Math.pow(this.deadTime, 2.0) / 12.0);
                this.sNumerPade = this.sNumer.times(complexPoly);
                this.sDenomPade = this.sDenom.times(complexPoly2);
                complexArray = complexPoly.rootsNoMessages();
                complexArray2 = complexPoly2.rootsNoMessages();
                break;
            }
            case 3: {
                this.sNumerDegPade = this.sNumerDeg + 3;
                this.sDenomDegPade = this.sDenomDeg + 3;
                this.sNumerPade = new ComplexPoly(this.sNumerDegPade);
                this.sDenomPade = new ComplexPoly(this.sDenomDegPade);
                double[] dArray = new double[]{1.0, -this.deadTime / 2.0, Math.pow(this.deadTime, 2.0) / 10.0, -Math.pow(this.deadTime, 3.0) / 120.0};
                complexPoly = new ComplexPoly(dArray);
                this.sNumerPade = this.sNumer.times(complexPoly);
                complexArray = complexPoly.rootsNoMessages();
                double[] dArray2 = new double[]{1.0, this.deadTime / 2.0, Math.pow(this.deadTime, 2.0) / 10.0, Math.pow(this.deadTime, 3.0) / 120.0};
                complexPoly2 = new ComplexPoly(dArray2);
                this.sDenomPade = this.sDenom.times(complexPoly2);
                complexArray2 = complexPoly2.rootsNoMessages();
                break;
            }
            case 4: {
                this.sNumerDegPade = this.sNumerDeg + 4;
                this.sDenomDegPade = this.sDenomDeg + 4;
                this.sNumerPade = new ComplexPoly(this.sNumerDegPade);
                this.sDenomPade = new ComplexPoly(this.sDenomDegPade);
                double[] dArray = new double[]{1.0, -this.deadTime / 2.0, 3.0 * Math.pow(this.deadTime, 2.0) / 28.0, -Math.pow(this.deadTime, 3.0) / 84.0, Math.pow(this.deadTime, 4.0) / 1680.0};
                complexPoly = new ComplexPoly(dArray);
                this.sNumerPade = this.sNumer.times(complexPoly);
                complexArray = complexPoly.rootsNoMessages();
                double[] dArray3 = new double[]{1.0, this.deadTime / 2.0, 3.0 * Math.pow(this.deadTime, 2.0) / 28.0, Math.pow(this.deadTime, 3.0) / 84.0, Math.pow(this.deadTime, 4.0) / 1680.0};
                complexPoly2 = new ComplexPoly(dArray3);
                this.sDenomPade = this.sDenom.times(complexPoly2);
                complexArray2 = complexPoly2.rootsNoMessages();
                break;
            }
            default: {
                this.orderPade = 2;
                this.sNumerDegPade = this.sNumerDeg + 2;
                this.sDenomDegPade = this.sDenomDeg + 2;
                this.sNumerPade = new ComplexPoly(this.sNumerDegPade);
                this.sDenomPade = new ComplexPoly(this.sDenomDegPade);
                complexPoly = new ComplexPoly(1.0, -this.deadTime / 2.0, Math.pow(this.deadTime, 2.0) / 12.0);
                complexPoly2 = new ComplexPoly(1.0, this.deadTime / 2.0, Math.pow(this.deadTime, 2.0) / 12.0);
                this.sNumerPade = this.sNumer.times(complexPoly);
                this.sDenomPade = this.sDenom.times(complexPoly2);
                complexArray = complexPoly.rootsNoMessages();
                complexArray2 = complexPoly2.rootsNoMessages();
            }
        }
        if (this.sNumerPade != null && this.sNumerDegPade > 0) {
            int n;
            this.sZerosPade = Complex.oneDarray(this.sNumerDegPade);
            for (n = 0; n < this.sNumerDeg; ++n) {
                this.sZerosPade[n] = this.sZeros[n].copy();
            }
            for (n = 0; n < this.orderPade; ++n) {
                this.sZerosPade[n + this.sNumerDeg] = complexArray[n].copy();
            }
        }
        if (this.sDenomPade != null && this.sDenomDegPade > 0) {
            int n;
            this.sPolesPade = Complex.oneDarray(this.sDenomDegPade);
            for (n = 0; n < this.sDenomDeg; ++n) {
                this.sPolesPade[n] = this.sPoles[n].copy();
            }
            for (n = 0; n < this.orderPade; ++n) {
                this.sPolesPade[n + this.sDenomDeg] = complexArray2[n].copy();
            }
        }
        this.zeroPoleCancellation();
        this.padeAdded = true;
    }

    protected void transferPolesZeros() {
        int n;
        this.sNumerDegPade = this.sNumerDeg;
        this.sNumerPade = this.sNumer.copy();
        if (this.sNumerDeg > 0 && this.sZeros != null) {
            this.sZerosPade = Complex.oneDarray(this.sNumerDeg);
            for (n = 0; n < this.sNumerDeg; ++n) {
                this.sZerosPade[n] = this.sZeros[n].copy();
            }
        }
        this.sDenomDegPade = this.sDenomDeg;
        this.sDenomPade = this.sDenom.copy();
        if (this.sDenomDeg > 0 && this.sPoles != null) {
            this.sPolesPade = Complex.oneDarray(this.sDenomDeg);
            for (n = 0; n < this.sDenomDeg; ++n) {
                this.sPolesPade[n] = this.sPoles[n].copy();
            }
        }
        this.zeroPoleCancellation();
        this.padeAdded = true;
    }

    public int orderPade() {
        return this.orderPade;
    }

    protected boolean deadTimeWarning(String string) {
        boolean bl = false;
        if (this.deadTime > this.deltaT) {
            System.out.println(this.name + "." + string + ": The dead time is greater than the sampling period");
            System.out.println("Dead time:       " + this.deadTime);
            System.out.println("Sampling period: " + this.deltaT);
            System.out.println("!!! The results of this program may not be physically meaningful !!!");
            bl = true;
        }
        return bl;
    }

    public void zTransform(double d) {
        this.mapstozAdHoc(d);
    }

    public void zTransform() {
        this.mapstozAdHoc();
    }

    public void mapstozAdHoc(double d) {
        this.deltaT = d;
        this.mapstozAdHoc();
    }

    public void mapstozAdHoc() {
        int n;
        int n2;
        this.deadTimeWarning("mapstozAdHoc");
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.zDenomDeg = this.sDenomDegPade;
        ComplexPoly complexPoly = new ComplexPoly(1);
        this.zDenom = new ComplexPoly(this.zDenomDeg);
        if (this.zDenomDeg > 0) {
            this.zPoles = Complex.oneDarray(this.zDenomDeg);
            for (n2 = 0; n2 < this.zDenomDeg; ++n2) {
                this.zPoles[n2] = Complex.exp(this.sPolesPade[n2].times(this.deltaT));
            }
            this.zDenom = ComplexPoly.rootsToPoly(this.zPoles);
        }
        if ((n2 = this.sDenomDegPade) + this.sNumerDegPade > this.sDenomDegPade) {
            n2 = this.sDenomDegPade - this.sNumerDegPade;
        }
        this.zNumerDeg = this.sNumerDegPade + n2;
        this.zNumer = new ComplexPoly(this.zNumerDeg);
        this.zZeros = Complex.oneDarray(this.zNumerDeg);
        if (this.zNumerDeg > 0) {
            for (n = 0; n < this.sNumerDegPade; ++n) {
                this.zZeros[n] = Complex.exp(this.sZerosPade[n].times(this.deltaT));
            }
            if (n2 > 0) {
                if (this.maptozero) {
                    for (n = this.sNumerDegPade; n < this.zNumerDeg; ++n) {
                        this.zZeros[n] = Complex.zero();
                    }
                } else {
                    for (n = this.sNumerDegPade; n < this.zNumerDeg; ++n) {
                        this.zZeros[n] = Complex.minusOne();
                    }
                }
            }
            this.zNumer = ComplexPoly.rootsToPoly(this.zZeros);
        }
        this.sValue = Complex.zero();
        this.zValue = Complex.plusOne();
        n = 1;
        while (n != 0) {
            int n3;
            n = 0;
            if (this.sDenomDegPade > 0) {
                for (n3 = 0; n3 < this.sDenomDegPade; ++n3) {
                    if (!this.sPolesPade[n3].truncate(3).equals(this.sValue.truncate(3))) continue;
                    n = 1;
                }
            }
            if (n == 0 && this.sNumerDegPade > 0) {
                for (n3 = 0; n3 < this.sDenomDegPade; ++n3) {
                    if (!this.sZerosPade[n3].truncate(3).equals(this.sValue.truncate(3))) continue;
                    n = 1;
                }
            }
            if (n == 0 && this.zDenomDeg > 0) {
                for (n3 = 0; n3 < this.zDenomDeg; ++n3) {
                    if (!this.zPoles[n3].truncate(3).equals(this.zValue.truncate(3))) continue;
                    n = 1;
                }
            }
            if (n == 0 && this.zNumerDeg > 0) {
                for (n3 = 0; n3 < this.zDenomDeg; ++n3) {
                    if (!this.zZeros[n3].truncate(3).equals(this.zValue.truncate(3))) continue;
                    n = 1;
                }
            }
            if (n == 0) continue;
            this.sValue = this.sValue.plus(Complex.plusJay()).truncate(3);
            this.zValue = Complex.exp(this.sValue.times(this.deltaT).truncate(3));
        }
        Complex complex = this.evalTransFunctS(this.sValue);
        Complex complex2 = this.evalTransFunctZ(this.zValue);
        Complex complex3 = complex.over(complex2);
        ComplexPoly complexPoly2 = new ComplexPoly(complex3);
        this.zNumer = this.zNumer.times(complexPoly2);
    }

    public void setMaptozero(boolean bl) {
        this.maptozero = bl;
    }

    public void setZnumer(double[] dArray) {
        this.zNumerDeg = dArray.length - 1;
        this.zNumer = new ComplexPoly(dArray);
        this.zZeros = this.zNumer.rootsNoMessages();
    }

    public void setZnumer(Complex[] complexArray) {
        this.zNumerDeg = complexArray.length - 1;
        this.zNumer = new ComplexPoly(complexArray);
        this.zZeros = this.zNumer.rootsNoMessages();
    }

    public void setZnumer(ComplexPoly complexPoly) {
        this.zNumerDeg = complexPoly.getDeg();
        this.zNumer = ComplexPoly.copy(complexPoly);
        this.zZeros = this.zNumer.rootsNoMessages();
    }

    public void setZdenom(double[] dArray) {
        this.zDenomDeg = dArray.length - 1;
        this.zDenom = new ComplexPoly(dArray);
        this.zPoles = this.zDenom.rootsNoMessages();
    }

    public void setZdenom(Complex[] complexArray) {
        this.zDenomDeg = complexArray.length - 1;
        this.zDenom = new ComplexPoly(complexArray);
        this.zPoles = this.zDenom.rootsNoMessages();
    }

    public void setZdenom(ComplexPoly complexPoly) {
        this.zDenomDeg = complexPoly.getDeg();
        this.zDenom = ComplexPoly.copy(complexPoly);
        this.zPoles = this.zDenom.rootsNoMessages();
    }

    public void setDeltaT(double d) {
        if (this.deltaT == 0.0) {
            this.deltaT = d;
            this.sampFreq = 1.0 / this.deltaT;
            this.deadTimeWarning("setDeltaT");
        } else {
            String string = "BlackBox setDeltaT: Do you wish to replace the deltaT value, " + this.deltaT + " with " + d;
            if (Db.yesNo(string)) {
                this.deltaT = d;
                this.sampFreq = 1.0 / this.deltaT;
                this.deadTimeWarning("setDeltaT");
                if (this.time != null) {
                    int n = this.sampLen;
                    this.sampLen = (int)Math.round(this.time[this.sampLen - 1] / this.deltaT);
                    double[] dArray = Conv.copy(this.time);
                    double[] dArray2 = Conv.copy(this.inputT);
                    this.time = new double[this.sampLen];
                    this.inputT = new double[this.sampLen];
                    CubicSpline cubicSpline = new CubicSpline(dArray, dArray2);
                    this.time[0] = dArray[0];
                    this.inputT[0] = dArray2[0];
                    for (int j = 1; j < this.sampLen - 1; ++j) {
                        double d2 = this.deltaT;
                        this.time[j - 1] = d2;
                        this.time[j] = d2;
                        this.inputT[j] = cubicSpline.interpolate(this.time[j]);
                    }
                    this.time[this.sampLen - 1] = dArray[n];
                    this.inputT[this.sampLen - 1] = dArray2[n];
                }
            }
        }
    }

    public void setForgetFactor(double d) {
        this.forgetFactor = d;
    }

    public void setSampFreq(double d) {
        this.sampFreq = d;
        this.setDeltaT(1.0 / d);
    }

    public void setS(Complex complex) {
        this.sValue = Complex.copy(complex);
    }

    public void setS(double d, double d2) {
        this.sValue.reset(d, d2);
    }

    public void setS(double d) {
        this.sValue.reset(0.0, d);
    }

    public void setZ(Complex complex) {
        this.zValue = Complex.copy(complex);
    }

    public void setZ(double d, double d2) {
        this.zValue.reset(d, d2);
    }

    public void setZtransformMethod(int n) {
        if (n < 0 || n > 1) {
            System.out.println("z transform method option number " + n + " not recognised");
            System.out.println("z tr methodansform option number set in BlackBox to the default value of 0 (s -> z ad hoc mapping)");
            this.integMethod = 0;
        } else {
            this.ztransMethod = n;
        }
    }

    public void setIntegrateOption(int n) {
        if (n < 0 || n > 2) {
            System.out.println("integration method option number " + n + " not recognised");
            System.out.println("integration method option number set in BlackBox to the default value of 0 (trapezium rule)");
            this.integMethod = 0;
        } else {
            this.integMethod = n;
        }
    }

    public void setIntegrateOption(String string) {
        if (string.equals("trapezium") || string.equals("Trapezium") || string.equals("tutin") || string.equals("Tutin")) {
            this.integMethod = 0;
        } else if (string.equals("backward") || string.equals("Backward") || string.equals("back") || string.equals("Back")) {
            this.integMethod = 1;
        } else if (string.equals("foreward") || string.equals("Foreward") || string.equals("fore") || string.equals("Fore")) {
            this.integMethod = 2;
        } else {
            System.out.println("integration method option  " + string + " not recognised");
            System.out.println("integration method option number set in PID to the default value of 0 (trapezium rule)");
            this.integMethod = 0;
        }
    }

    public void setSampleLength(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Entered sample length must be greater than zero");
        }
        if (n == 1) {
            n = 2;
        }
        if (this.sampLen == 0) {
            this.sampLen = n;
            this.time = new double[n];
            this.inputT = new double[n];
            this.outputT = new double[n];
        } else {
            String string = "BlackBox setSampleLength: Do you wish to replace the sample length, " + this.sampLen + " with " + n;
            if (Db.yesNo(string)) {
                int n2 = this.sampLen;
                this.sampLen = n;
                if (this.time != null) {
                    this.deltaT = this.time[n2 - 1] / (double)(n - 1);
                    double[] dArray = Conv.copy(this.time);
                    double[] dArray2 = Conv.copy(this.inputT);
                    this.time = new double[this.sampLen];
                    this.inputT = new double[this.sampLen];
                    CubicSpline cubicSpline = new CubicSpline(dArray, dArray2);
                    this.time[0] = dArray[0];
                    this.inputT[0] = dArray2[0];
                    for (int j = 1; j < this.sampLen - 1; ++j) {
                        double d = this.deltaT;
                        this.time[j - 1] = d;
                        this.time[j] = d;
                        this.inputT[j] = cubicSpline.interpolate(this.time[j]);
                    }
                    this.time[this.sampLen - 1] = dArray[n2];
                    this.inputT[this.sampLen - 1] = dArray2[n2];
                }
            }
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setInputT(double d, double d2) {
        if (this.deltaT == 0.0) {
            this.time = new double[2];
            this.time[0] = 0.0;
            this.time[1] = d;
            this.inputT = new double[2];
            this.inputT[0] = d2;
            this.inputT[1] = d2;
            this.outputT = new double[2];
            this.sampLen = 2;
        } else {
            double d3 = this.deltaT;
            this.sampLen = (int)Math.round(d / d3);
            this.deltaT = d / (double)this.sampLen;
            if (!Fmath.isEqualWithinLimits(this.deltaT, d3, d3 * 0.001)) {
                System.out.println("BlackBox setInputT method; deltaT has been reset from " + d3 + " to " + this.deltaT);
            }
            this.sampFreq = 1.0 / this.deltaT;
            this.time = new double[this.sampLen];
            this.time[this.sampLen - 1] = d;
            this.inputT = new double[this.sampLen];
            this.inputT[this.sampLen - 1] = d2;
            this.outputT = new double[this.sampLen];
            for (int j = this.sampLen - 2; j > 0; --j) {
                this.time[j] = this.time[j + 1] - this.deltaT;
                this.inputT[j] = d2;
            }
            this.time[0] = 0.0;
            this.inputT[0] = d2;
        }
    }

    public void setInputT(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new IllegalArgumentException("time and input arrays are of different lengths: " + n + ", " + dArray2.length);
        }
        if (n == 1) {
            this.setInputT(dArray[0], dArray2[0]);
        } else {
            this.sampLen = n;
            this.time = dArray;
            this.inputT = dArray2;
            this.outputT = new double[this.sampLen];
            this.deltaT = dArray[this.sampLen] / (double)(this.sampLen - 1);
            this.sampFreq = 1.0 / this.deltaT;
        }
    }

    public void setInputS(Complex complex) {
        this.inputS = complex;
    }

    public void resetZero() {
        for (int j = 0; j < this.sampLen - 1; ++j) {
            this.outputT[j] = 0.0;
            this.inputT[j] = 0.0;
            this.time[j] = 0.0;
        }
        this.outputS = Complex.zero();
        this.inputS = Complex.zero();
        this.deltaT = 0.0;
        this.sampLen = 0;
    }

    protected void calcPolesZerosS() {
        this.sNumer = ComplexPoly.reducePoly(this.sNumer);
        this.sNumerDeg = this.sNumer.getDeg();
        this.sNumerPade = ComplexPoly.reducePoly(this.sNumerPade);
        this.sNumerDegPade = this.sNumerPade.getDeg();
        this.sDenom = ComplexPoly.reducePoly(this.sDenom);
        this.sDenomDeg = this.sDenom.getDeg();
        this.sDenomPade = ComplexPoly.reducePoly(this.sDenomPade);
        this.sDenomDegPade = this.sDenomPade.getDeg();
        if (this.sNumer != null) {
            if (this.sNumer.getDeg() > 0) {
                this.sZeros = this.sNumer.rootsNoMessages();
            }
            this.sNumerScaleFactor = this.sZeros != null ? BlackBox.scaleFactor(this.sNumer, this.sZeros) : this.sNumer.coeffCopy(0);
        }
        if (this.sDenom != null) {
            if (this.sDenom.getDeg() > 0) {
                this.sPoles = this.sDenom.rootsNoMessages();
            }
            this.sDenomScaleFactor = this.sPoles != null ? BlackBox.scaleFactor(this.sDenom, this.sPoles) : this.sDenom.coeffCopy(0);
        }
        if (this.sNumerPade != null && this.sNumerPade.getDeg() > 0) {
            this.sZerosPade = this.sNumerPade.rootsNoMessages();
        }
        if (this.sDenomPade != null && this.sDenomPade.getDeg() > 0) {
            this.sPolesPade = this.sDenomPade.rootsNoMessages();
        }
    }

    protected void zeroPoleCancellation() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        if (this.sNumerDegPade == 0 || this.sDenomDegPade == 0) {
            bl2 = false;
        }
        if (this.sZerosPade == null || this.sPolesPade == null) {
            bl2 = false;
        }
        if (bl2) {
            n5 = this.sPolesPade.length;
            n4 = this.sZerosPade.length;
            block0: for (n3 = n4 - 1; n3 >= 0; --n3) {
                bl3 = false;
                for (n2 = n5 - 1; n2 >= 0; --n2) {
                    if (this.sZerosPade[n3].isEqual(this.sPolesPade[n2])) {
                        if (n2 < this.sDenomDegPade - 2) {
                            for (n = n2; n < this.sDenomDegPade; ++n) {
                                this.sPolesPade[n] = this.sPolesPade[n + 1].copy();
                            }
                        }
                        --this.sDenomDegPade;
                        if (n3 < this.sNumerDegPade - 2) {
                            for (n = n3; n < this.sNumerDegPade; ++n) {
                                this.sZerosPade[n] = this.sZerosPade[n + 1].copy();
                            }
                        }
                        --this.sNumerDegPade;
                        --n3;
                        bl = true;
                        bl3 = true;
                    }
                    if (bl3) continue block0;
                }
            }
        }
        if (bl) {
            if (this.sNumerDegPade == 0) {
                this.sNumerPade = new ComplexPoly(1.0);
                this.sZerosPade = null;
            } else {
                Complex[] complexArray = Complex.oneDarray(this.sNumerDegPade);
                for (n4 = 0; n4 < this.sNumerDegPade; ++n4) {
                    complexArray[n4] = this.sZerosPade[n4].copy();
                }
                this.sZerosPade = complexArray;
                this.sNumerPade = ComplexPoly.rootsToPoly(this.sZerosPade);
            }
            if (this.sDenomDegPade == 0) {
                this.sDenomPade = new ComplexPoly(1.0);
                this.sPolesPade = null;
            } else {
                Complex[] complexArray = Complex.oneDarray(this.sDenomDegPade);
                for (n4 = 0; n4 < this.sDenomDegPade; ++n4) {
                    complexArray[n4] = this.sPolesPade[n4].copy();
                }
                this.sPolesPade = complexArray;
                this.sDenomPade = ComplexPoly.rootsToPoly(this.sPolesPade);
            }
        }
        bl = false;
        bl2 = true;
        bl3 = true;
        if (this.sNumerDeg == 0 || this.sDenomDeg == 0) {
            bl2 = false;
        }
        if (this.sZeros == null || this.sPoles == null) {
            bl2 = false;
        }
        if (bl2) {
            n5 = this.sPoles.length;
            n4 = this.sZeros.length;
            block6: for (n3 = n4 - 1; n3 >= 0; --n3) {
                bl3 = false;
                for (n2 = n5 - 1; n2 >= 0; --n2) {
                    if (this.sZeros[n3].isEqual(this.sPoles[n2])) {
                        if (n2 < this.sDenomDegPade - 2) {
                            for (n = n2 + 1; n < this.sDenomDeg; ++n) {
                                this.sPoles[n - 1] = this.sPoles[n].copy();
                            }
                        }
                        --this.sDenomDeg;
                        if (n2 < this.sNumerDegPade - 2) {
                            for (n = n3 + 1; n < this.sNumerDeg; ++n) {
                                this.sZeros[n - 1] = this.sZeros[n].copy();
                            }
                        }
                        --this.sNumerDeg;
                        bl = true;
                        bl3 = true;
                        --n3;
                    }
                    if (bl3) continue block6;
                }
            }
        }
        if (bl) {
            if (this.sNumerDeg == 0) {
                this.sNumer = new ComplexPoly(1.0);
                this.sZeros = null;
            } else {
                Complex[] complexArray = Complex.oneDarray(this.sNumerDeg);
                for (n4 = 0; n4 < this.sNumerDeg; ++n4) {
                    complexArray[n4] = this.sZeros[n4].copy();
                }
                this.sZeros = complexArray;
                this.sNumer = ComplexPoly.rootsToPoly(this.sZeros);
            }
            if (this.sDenomDeg == 0) {
                this.sDenom = new ComplexPoly(1.0);
                this.sPoles = null;
            } else {
                Complex[] complexArray = Complex.oneDarray(this.sDenomDeg);
                for (n4 = 0; n4 < this.sDenomDeg; ++n4) {
                    complexArray[n4] = this.sPoles[n4].copy();
                }
                this.sPoles = complexArray;
                this.sDenom = ComplexPoly.rootsToPoly(this.sPoles);
            }
        }
    }

    public double getSeadyStateValue() {
        Complex complex = this.sNumer.evaluate(Complex.zero());
        Complex complex2 = this.sDenom.evaluate(Complex.zero());
        Complex complex3 = complex.over(complex2);
        double d = complex3.getReal();
        double d2 = complex3.getImag();
        if (Math.abs(d2) > Math.abs(d) * 0.01) {
            System.out.println("method getSteadyStateValue: The imaginary part, " + d2 + ", is greater than 1 per cent of the the real part, " + d);
            System.out.println("Magnitude has  been returned");
        }
        return complex3.abs();
    }

    public double getSeadyStateValue(double d) {
        Complex complex = this.sNumer.evaluate(Complex.zero());
        Complex complex2 = this.sDenom.evaluate(Complex.zero());
        Complex complex3 = complex.over(complex2);
        double d2 = complex3.getReal();
        double d3 = complex3.getImag();
        if (Math.abs(d3) > Math.abs(d2) * 0.01) {
            System.out.println("method getSteadyStateValue: The imaginary part, " + d3 + ", is greater than 1 per cent of the the real part, " + d2);
            System.out.println("Magnitude has  been returned");
        }
        return d * complex3.abs();
    }

    public Complex evalTransFunctS() {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        Complex complex = this.sNumer.evaluate(this.sValue);
        Complex complex2 = this.sDenom.evaluate(this.sValue);
        Complex complex3 = Complex.plusOne();
        if (this.deadTime != 0.0) {
            complex3 = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return complex.over(complex2).times(complex3);
    }

    public Complex evalTransFunctS(Complex complex) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.sValue = Complex.copy(complex);
        Complex complex2 = this.sNumer.evaluate(complex);
        Complex complex3 = this.sDenom.evaluate(complex);
        Complex complex4 = Complex.plusOne();
        if (this.deadTime != 0.0) {
            complex4 = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return complex2.over(complex3).times(complex4);
    }

    public Complex evalTransFunctS(double d) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.sValue.reset(0.0, Math.PI * 2 * d);
        Complex complex = this.sNumer.evaluate(this.sValue);
        Complex complex2 = this.sDenom.evaluate(this.sValue);
        Complex complex3 = Complex.plusOne();
        if (this.deadTime != 0.0) {
            complex3 = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return complex.over(complex2).times(complex3);
    }

    public double evalMagTransFunctS() {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        Complex complex = this.sNumer.evaluate(this.sValue);
        Complex complex2 = this.sDenom.evaluate(this.sValue);
        Complex complex3 = Complex.plusOne();
        if (this.deadTime != 0.0) {
            complex3 = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return complex.over(complex2).times(complex3).abs();
    }

    public double evalMagTransFunctS(Complex complex) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.sValue = Complex.copy(complex);
        Complex complex2 = this.sNumer.evaluate(complex);
        Complex complex3 = this.sDenom.evaluate(complex);
        Complex complex4 = Complex.plusOne();
        if (this.deadTime != 0.0) {
            complex4 = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return complex2.over(complex3).times(complex4).abs();
    }

    public double evalMagTransFunctS(double d) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.sValue.reset(0.0, Math.PI * 2 * d);
        Complex complex = this.sNumer.evaluate(this.sValue);
        Complex complex2 = this.sDenom.evaluate(this.sValue);
        Complex complex3 = Complex.plusOne();
        if (this.deadTime != 0.0) {
            complex3 = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return complex.over(complex2).times(complex3).abs();
    }

    public double evalPhaseTransFunctS() {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        Complex complex = this.sNumer.evaluate(this.sValue);
        Complex complex2 = this.sDenom.evaluate(this.sValue);
        Complex complex3 = Complex.plusOne();
        if (this.deadTime != 0.0) {
            complex3 = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return complex.over(complex2).times(complex3).arg();
    }

    public double evalPhaseTransFunctS(Complex complex) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.sValue = Complex.copy(complex);
        Complex complex2 = this.sNumer.evaluate(complex);
        Complex complex3 = this.sDenom.evaluate(complex);
        Complex complex4 = Complex.plusOne();
        if (this.deadTime != 0.0) {
            complex4 = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return complex2.over(complex3).times(complex4).arg();
    }

    public double evalPhaseTransFunctS(double d) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.sValue.reset(0.0, Math.PI * 2 * d);
        Complex complex = this.sNumer.evaluate(this.sValue);
        Complex complex2 = this.sDenom.evaluate(this.sValue);
        Complex complex3 = Complex.plusOne();
        if (this.deadTime != 0.0) {
            complex3 = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return complex.over(complex2).times(complex3).arg();
    }

    public Complex evalTransFunctZ() {
        Complex complex = this.zNumer.evaluate(this.zValue);
        Complex complex2 = this.zDenom.evaluate(this.zValue);
        return complex.over(complex2);
    }

    public Complex evalTransFunctZ(Complex complex) {
        this.zValue = Complex.copy(complex);
        Complex complex2 = this.zNumer.evaluate(complex);
        Complex complex3 = this.zDenom.evaluate(complex);
        return complex2.over(complex3);
    }

    public double evalMagTransFunctZ() {
        Complex complex = this.zNumer.evaluate(this.zValue);
        Complex complex2 = this.zDenom.evaluate(this.zValue);
        return complex.over(complex2).abs();
    }

    public double evalMagTransFunctZ(Complex complex) {
        this.zValue = Complex.copy(complex);
        Complex complex2 = this.zNumer.evaluate(complex);
        Complex complex3 = this.zDenom.evaluate(complex);
        return complex2.over(complex3).abs();
    }

    public double evalPhaseTransFunctZ() {
        Complex complex = this.zNumer.evaluate(this.zValue);
        Complex complex2 = this.zDenom.evaluate(this.zValue);
        return complex.over(complex2).arg();
    }

    public double evalPhaseTransFunctZ(Complex complex) {
        this.zValue = Complex.copy(complex);
        Complex complex2 = this.zNumer.evaluate(complex);
        Complex complex3 = this.zDenom.evaluate(complex);
        return complex2.over(complex3).arg();
    }

    public int getIntegMethod() {
        return this.integMethod;
    }

    public int getZtransformMethod() {
        return this.ztransMethod;
    }

    public int getSampleLength() {
        return this.sampLen;
    }

    public double getForgetFactor() {
        return this.forgetFactor;
    }

    public double getCurrentTime() {
        return this.time[this.sampLen - 1];
    }

    public double[] getTime() {
        return this.time;
    }

    public double getCurrentInputT() {
        return this.inputT[this.sampLen - 1];
    }

    public double[] getInputT() {
        return this.inputT;
    }

    public Complex getInputS() {
        return this.inputS;
    }

    public double getDeltaT() {
        return this.deltaT;
    }

    public double getSampFreq() {
        return this.sampFreq;
    }

    public Complex getS() {
        return this.sValue;
    }

    public Complex getZ() {
        return this.zValue;
    }

    public int getSnumerDeg() {
        return this.sNumerDeg;
    }

    public int getSnumerPadeDeg() {
        return this.sNumerDegPade;
    }

    public int getSdenomDeg() {
        return this.sDenomDeg;
    }

    public int getSdenomPadeDeg() {
        return this.sDenomDegPade;
    }

    public ComplexPoly getSnumer() {
        return this.sNumer.times(this.sNumerWorkingFactor);
    }

    public ComplexPoly getSnumerPade() {
        return this.sNumerPade.times(this.sNumerWorkingFactor);
    }

    public ComplexPoly getSdenom() {
        return this.sDenom.times(this.sDenomWorkingFactor);
    }

    public ComplexPoly getSdenomPade() {
        return this.sDenomPade.times(this.sDenomWorkingFactor);
    }

    public int getZnumerDeg() {
        return this.zNumerDeg;
    }

    public int getZdenomDeg() {
        return this.zDenomDeg;
    }

    public ComplexPoly getZnumer() {
        return this.zNumer;
    }

    public ComplexPoly getZdenom() {
        return this.zDenom;
    }

    public Complex[] getZerosS() {
        if (this.sZeros == null) {
            this.calcPolesZerosS();
        }
        if (this.sZeros == null) {
            System.out.println("Method BlackBox.getZerosS:");
            System.out.println("There are either no s-domain zeros for this transfer function");
            System.out.println("or the s-domain numerator polynomial has not been set");
            System.out.println("null returned");
            return null;
        }
        return this.sZeros;
    }

    public Complex[] getZerosPadeS() {
        if (this.sZeros == null) {
            this.calcPolesZerosS();
        }
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        if (this.sZerosPade == null) {
            System.out.println("Method BlackBox.getZerosPadeS:");
            System.out.println("There are either no s-domain zeros for this transfer function");
            System.out.println("or the s-domain numerator polynomial has not been set");
            System.out.println("null returned");
            return null;
        }
        return this.sZerosPade;
    }

    public Complex[] getPolesS() {
        if (this.sPoles == null) {
            this.calcPolesZerosS();
        }
        if (this.sPoles == null) {
            System.out.println("Method BlackBox.getPolesS:");
            System.out.println("There are either no s-domain poles for this transfer function");
            System.out.println("or the s-domain denominator polynomial has not been set");
            System.out.println("null returned");
            return null;
        }
        return this.sPoles;
    }

    public Complex[] getPolesPadeS() {
        if (this.sPoles == null) {
            this.calcPolesZerosS();
        }
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        if (this.sPolesPade == null) {
            System.out.println("Method BlackBox.getPolesPadeS:");
            System.out.println("There are either no s-domain poles for this transfer function");
            System.out.println("or the s-domain denominator polynomial has not been set");
            System.out.println("null returned");
            return null;
        }
        return this.sPolesPade;
    }

    public Complex[] getZerosZ() {
        if (this.zZeros == null) {
            System.out.println("Method BlackBox.getZerosZ:");
            System.out.println("There are either no z-domain zeros for this transfer function");
            System.out.println("or the z-domain numerator polynomial has not been set");
            System.out.println("null returned");
            return null;
        }
        return this.zZeros;
    }

    public Complex[] getPolesZ() {
        if (this.zPoles == null) {
            System.out.println("Method BlackBox.getPolesZ:");
            System.out.println("There are either no z-domain poles for this transfer function");
            System.out.println("or the z-domain denominator polynomial has not been set");
            System.out.println("null returned");
            return null;
        }
        return this.zPoles;
    }

    public boolean getMaptozero() {
        return this.maptozero;
    }

    public String getName() {
        return this.name;
    }

    public void plotPoleZeroS() {
        if (this.sNumer == null) {
            throw new IllegalArgumentException("s domain numerator has not been set");
        }
        if (this.sDenom == null) {
            throw new IllegalArgumentException("s domain denominator has not been set");
        }
        PlotPoleZero plotPoleZero = new PlotPoleZero(this.sNumer, this.sDenom);
        plotPoleZero.setS();
        plotPoleZero.pzPlot(this.name);
    }

    public void plotPoleZeroPadeS() {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        if (this.sNumerPade == null) {
            throw new IllegalArgumentException("s domain numerator has not been set");
        }
        if (this.sDenomPade == null) {
            throw new IllegalArgumentException("s domain denominator has not been set");
        }
        PlotPoleZero plotPoleZero = new PlotPoleZero(this.sNumerPade, this.sDenomPade);
        plotPoleZero.setS();
        plotPoleZero.pzPlot(this.name);
    }

    public void plotPoleZeroZ() {
        PlotPoleZero plotPoleZero = new PlotPoleZero(this.zNumer, this.zDenom);
        if (this.zNumer == null) {
            throw new IllegalArgumentException("z domain numerator has not been set");
        }
        if (this.zDenom == null) {
            throw new IllegalArgumentException("z domain denominator has not been set");
        }
        plotPoleZero.setZ();
        plotPoleZero.pzPlot(this.name);
    }

    public void plotBode(double d, double d2) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        int n = 100;
        double[][] dArray = new double[2][n];
        double[] dArray2 = new double[n + 1];
        double d3 = Fmath.log10(Math.PI * 2 * d);
        double d4 = Fmath.log10(Math.PI * 2 * d2);
        double d5 = (d4 - d3) / ((double)n - 1.0);
        double d6 = d;
        dArray2[0] = d3;
        for (int j = 0; j < n; ++j) {
            d6 = Math.pow(10.0, dArray2[j]);
            dArray[0][j] = dArray2[j];
            dArray[1][j] = 20.0 * Fmath.log10(this.evalMagTransFunctS(d6 / (Math.PI * 2)));
            dArray2[j + 1] = dArray2[j] + d5;
        }
        PlotGraph plotGraph = new PlotGraph(dArray);
        plotGraph.setGraphTitle("Bode Plot = magnitude versus log10[radial frequency]");
        plotGraph.setGraphTitle2(this.name);
        plotGraph.setXaxisLegend("Log10[radial frequency]");
        plotGraph.setYaxisLegend("Magnitude[Transfer Function]");
        plotGraph.setYaxisUnitsName("dB");
        plotGraph.setPoint(0);
        plotGraph.setLine(3);
        plotGraph.plot();
        for (int j = 0; j < n; ++j) {
            d6 = Math.pow(10.0, dArray2[j]);
            dArray[0][j] = dArray2[j];
            dArray[1][j] = this.evalPhaseTransFunctS(d6) * 180.0 / Math.PI;
        }
        PlotGraph plotGraph2 = new PlotGraph(dArray);
        plotGraph2.setGraphTitle("Bode Plot = phase versus log10[radial frequency]");
        plotGraph2.setGraphTitle2(this.name);
        plotGraph2.setXaxisLegend("Log10[radial frequency]");
        plotGraph2.setYaxisLegend("Phase[Transfer Function]");
        plotGraph2.setYaxisUnitsName("degrees");
        plotGraph2.setPoint(0);
        plotGraph.setLine(3);
        plotGraph2.plot();
    }

    public double getCurrentOutputT(double d, double d2) {
        this.setInputT(d, d2);
        return this.getCurrentOutputT();
    }

    public double getCurrentOutputT() {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        ComplexPoly complexPoly = this.sNumerPade.times(new Complex(this.inputT[this.sampLen - 1], 0.0));
        Complex[] complexArray = new Complex[]{Complex.zero(), Complex.plusOne()};
        ComplexPoly complexPoly2 = new ComplexPoly(complexArray);
        ComplexPoly complexPoly3 = this.sDenomPade.times(complexPoly2);
        Complex[][] complexArray2 = BlackBox.inverseTransform(complexPoly, complexPoly3, this.sNumerWorkingFactor, this.sDenomScaleFactor);
        Complex complex = Complex.zero();
        for (int j = 0; j < complexArray2[0].length; ++j) {
            complex.plusEquals(BlackBox.timeTerm(this.time[this.sampLen - 1], complexArray2[0][j], complexArray2[1][j], complexArray2[2][j]));
        }
        double d = complex.getReal();
        double d2 = complex.getImag();
        boolean bl = true;
        if (d2 == 0.0) {
            bl = false;
        }
        if (bl) {
            double d3 = Math.max(Math.abs(d), Math.abs(d2));
            if (Math.abs((d - d2) / d3) > 1.0E-5) {
                bl = false;
            } else {
                System.out.println("output in Blackbox.getCurrentOutputT() has a significant imaginary part");
                System.out.println("time = " + this.time[this.sampLen - 1] + "    real = " + d + "   imag = " + d2);
                System.out.println("Output equated to the real part");
            }
        }
        this.outputT[this.sampLen - 1] = d;
        return this.outputT[this.sampLen - 1];
    }

    public double[] getOutputT() {
        return this.outputT;
    }

    public Complex getOutputS() {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        Complex complex = this.sNumer.evaluate(this.sValue);
        Complex complex2 = this.sDenom.evaluate(this.sValue);
        this.outputS = complex.over(complex2).times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    public Complex getOutputS(Complex complex, Complex complex2) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.inputS = complex2;
        this.sValue = complex;
        Complex complex3 = this.sNumer.evaluate(this.sValue);
        Complex complex4 = this.sDenom.evaluate(this.sValue);
        this.outputS = complex3.over(complex4).times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    public void setNplotPoints(int n) {
        this.nPlotPoints = n;
    }

    public int getNplotPoints() {
        return this.nPlotPoints;
    }

    public void impulseInput(double d, double d2) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        ComplexPoly complexPoly = new ComplexPoly(0);
        complexPoly.resetCoeff(0, Complex.plusOne().times(d));
        ComplexPoly complexPoly2 = this.sNumerPade.times(complexPoly);
        ComplexPoly complexPoly3 = this.sDenomPade.copy();
        String string = "Impulse Input Transient:   Impulse magnitude = " + d;
        String string2 = this.getName();
        BlackBox.transientResponse(this.nPlotPoints, d2, this.deadTime, complexPoly2, complexPoly3, string, string2, this.sNumerWorkingFactor, this.sDenomScaleFactor);
    }

    public void impulseInput(double d) {
        this.impulseInput(1.0, d);
    }

    public void stepInput(double d, double d2) {
        Complex complex = this.sNumerPade.coeffCopy(0);
        Complex complex2 = this.sDenomPade.coeffCopy(0);
        boolean bl = false;
        if (Complex.isReal(complex) && Complex.isReal(complex2)) {
            bl = true;
        }
        if (this.sNumerDeg == 0 && this.sDenomDeg == 0 && bl) {
            int n;
            int n2 = 51;
            double d3 = d2 / (double)(n2 - 2);
            double[][] dArray = new double[2][n2];
            dArray[0][0] = 0.0;
            dArray[0][1] = 0.0;
            for (int j = 2; j < n2; ++j) {
                dArray[0][j] = dArray[0][j - 1] + d3;
            }
            double d4 = complex.getReal() * d / complex2.getReal();
            dArray[1][0] = 0.0;
            for (n = 1; n < n2; ++n) {
                dArray[1][n] = d4;
            }
            if (this.deadTime != 0.0) {
                n = 0;
                while (n < n2) {
                    double[] dArray2 = dArray[0];
                    int n3 = n++;
                    dArray2[n3] = dArray2[n3] + this.deadTime;
                }
            }
            PlotGraph plotGraph = new PlotGraph(dArray);
            plotGraph.setGraphTitle("Step Input Transient:   Step magnitude = " + d);
            plotGraph.setGraphTitle2(this.getName());
            plotGraph.setXaxisLegend("Time");
            plotGraph.setXaxisUnitsName("s");
            plotGraph.setYaxisLegend("Output");
            plotGraph.setPoint(0);
            plotGraph.setLine(3);
            plotGraph.plot();
        } else {
            if (!this.padeAdded) {
                this.transferPolesZeros();
            }
            ComplexPoly complexPoly = this.sNumer.times(d);
            Complex[] complexArray = new Complex[]{Complex.zero(), Complex.plusOne()};
            ComplexPoly complexPoly2 = new ComplexPoly(complexArray);
            ComplexPoly complexPoly3 = this.sDenom.times(complexPoly2);
            String string = "Step Input Transient:   Step magnitude = " + d;
            String string2 = this.getName();
            BlackBox.transientResponse(this.nPlotPoints, d2, this.deadTime, complexPoly, complexPoly3, string, string2, this.sNumerWorkingFactor, this.sDenomScaleFactor);
        }
    }

    public void stepInput(double d) {
        this.stepInput(1.0, d);
    }

    public void rampInput(double d, int n, double d2) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        ComplexPoly complexPoly = this.sNumer.times(d * (double)Fmath.factorial(n));
        Complex[] complexArray = Complex.oneDarray(n + 1);
        for (int j = 0; j < n; ++j) {
            complexArray[j] = Complex.zero();
        }
        complexArray[n] = Complex.plusOne();
        ComplexPoly complexPoly2 = new ComplexPoly(complexArray);
        ComplexPoly complexPoly3 = this.sDenom.times(complexPoly2);
        String string = "";
        string = d != 1.0 ? (n != 1 ? string + "nth order ramp (at^n) input transient:   a = " + d + "    n = " + n : string + "First order ramp (at) input transient:   a = " + d) : (n != 1 ? string + "Unit ramp (t) input transient" : string + "nth order ramp (t^n) input transient:   n = " + n);
        String string2 = this.getName();
        BlackBox.transientResponse(this.nPlotPoints, d2, this.deadTime, complexPoly, complexPoly3, string, string2, this.sNumerWorkingFactor, this.sDenomScaleFactor);
    }

    public void rampInput(int n, double d) {
        double d2 = 1.0;
        this.rampInput(d2, n, d);
    }

    public void rampInput(double d, double d2) {
        int n = 1;
        this.rampInput(d, n, d2);
    }

    public void rampInput(double d) {
        double d2 = 1.0;
        int n = 1;
        this.rampInput(d2, n, d);
    }

    public static void transientResponse(int n, double d, double d2, ComplexPoly complexPoly, ComplexPoly complexPoly2, String string, String string2) {
        Complex[] complexArray = complexPoly2.rootsNoMessages();
        Complex complex = BlackBox.scaleFactor(complexPoly2, complexArray);
        Complex complex2 = Complex.plusOne();
        BlackBox.transientResponse(n, d, d2, complexPoly, complexPoly2, string, string2, complex2, complex);
    }

    public static void transientResponse(int n, double d, double d2, ComplexPoly complexPoly, ComplexPoly complexPoly2, String string, String string2, Complex complex, Complex complex2) {
        int n2;
        Complex[][] complexArray = BlackBox.inverseTransform(complexPoly, complexPoly2, complex, complex2);
        int n3 = complexPoly2.getDeg();
        double d3 = d / (double)(n - 1);
        double[][] dArray = new double[2][n];
        double d4 = 0.0;
        Complex complex3 = new Complex();
        double d5 = 0.0;
        double d6 = 0.0;
        boolean bl = true;
        dArray[0][0] = 0.0;
        for (n2 = 1; n2 < n; ++n2) {
            dArray[0][n2] = dArray[0][n2 - 1] + d3;
        }
        n2 = 0;
        while (n2 < n) {
            bl = true;
            complex3 = Complex.zero();
            for (int j = 0; j < n3; ++j) {
                complex3.plusEquals(BlackBox.timeTerm(dArray[0][n2], complexArray[0][j], complexArray[1][j], complexArray[2][j]));
            }
            d5 = complex3.getReal();
            d6 = complex3.getImag();
            if (d6 == 0.0) {
                bl = false;
            }
            if (bl) {
                d4 = Math.max(Math.abs(d5), Math.abs(d6));
                if (Math.abs((d5 - d6) / d4) > 1.0E-5) {
                    bl = false;
                } else {
                    System.out.println("output in Blackbox.stepInput has a significant imaginary part");
                    System.out.println("time = " + dArray[0][n2] + "    real = " + d5 + "   imag = " + d6);
                    System.out.println("Output equated to the real part");
                }
            }
            dArray[1][n2] = d5;
            double[] dArray2 = dArray[0];
            int n4 = n2++;
            dArray2[n4] = dArray2[n4] + d2;
        }
        PlotGraph plotGraph = new PlotGraph(dArray);
        plotGraph.setGraphTitle(string);
        plotGraph.setGraphTitle2(string2);
        plotGraph.setXaxisLegend("Time");
        plotGraph.setXaxisUnitsName("s");
        plotGraph.setYaxisLegend("Output");
        plotGraph.setPoint(0);
        plotGraph.setLine(3);
        plotGraph.setNoYoffset(true);
        if (d2 < dArray[0][n - 1] - dArray[0][0]) {
            plotGraph.setNoXoffset(true);
        }
        plotGraph.setXlowFac(0.0);
        plotGraph.setYlowFac(0.0);
        plotGraph.plot();
    }

    public static Complex timeTerm(double d, Complex complex, Complex complex2, Complex complex3) {
        Complex complex4 = new Complex();
        int n = (int)complex3.getReal() - 1;
        complex4 = complex.times(Math.pow(d, n));
        complex4 = complex4.over(Fmath.factorial(n));
        complex4 = complex4.times(Complex.exp(complex2.times(d)));
        return complex4;
    }

    public static double timeTerm(double d, double d2, double d3, int n) {
        int n2 = n - 1;
        double d4 = d2 * Math.pow(d, n2);
        d4 /= (double)Fmath.factorial(n2);
        return d4 *= Math.exp(d3 * d);
    }

    public static double timeTerm(double d, double d2, double d3, double d4) {
        double d5 = d4 - 1.0;
        double d6 = d2 * Math.pow(d, d5);
        d6 /= Fmath.factorial(d5);
        return d6 *= Math.exp(d3 * d);
    }

    public static double[][] inverseTransformToReal(ComplexPoly complexPoly, ComplexPoly complexPoly2) {
        Complex[][] complexArray = BlackBox.inverseTransform(complexPoly, complexPoly2);
        int n = complexArray[0].length;
        double[][] dArray = new double[3][n];
        for (int j = 0; j < n; ++j) {
            dArray[0][j] = complexArray[0][j].getReal();
            if (Math.abs((dArray[0][j] - complexArray[0][j].getImag()) / dArray[0][j]) > 1.0E-5) {
                System.out.println("BlackBox inverseTransformToReal coefficient A[" + j + "] has a significant imaginary part: " + complexArray[0][j]);
                System.out.println("A equated to the real part");
                System.out.println("inverseTransform method may be more appropriate");
            }
            dArray[1][j] = complexArray[1][j].getReal();
            if (Math.abs((dArray[1][j] - complexArray[1][j].getImag()) / dArray[1][j]) > 1.0E-5) {
                System.out.println("BlackBox inverseTransformToReal coefficient a[" + j + "] has a significant imaginary part: " + complexArray[1][j]);
                System.out.println("a equated to the real part");
                System.out.println("inverseTransform method may be more appropriate");
            }
            dArray[2][j] = complexArray[2][j].getReal();
        }
        return dArray;
    }

    public static Complex[][] inverseTransform(ComplexPoly complexPoly, ComplexPoly complexPoly2) {
        Complex[] complexArray = complexPoly2.rootsNoMessages();
        Complex complex = BlackBox.scaleFactor(complexPoly2, complexArray);
        Complex complex2 = Complex.plusOne();
        return BlackBox.inverseTransform(complexPoly, complexPoly2, complex2, complex);
    }

    public static Complex[][] inverseTransform(ComplexPoly complexPoly, ComplexPoly complexPoly2, Complex complex, Complex complex2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = complexPoly2.getDeg();
        int n9 = complexPoly.getDeg();
        if (n9 >= n8) {
            throw new IllegalArgumentException("The degree of the numerator is equal to or greater than the degree of the denominator");
        }
        Complex[][] complexArray = Complex.twoDarray(3, n8);
        if (n8 == 1 && n9 == 0) {
            Complex complex3 = complexPoly.coeffCopy(0);
            Complex complex4 = complexPoly2.coeffCopy(0);
            Complex complex5 = complexPoly2.coeffCopy(1);
            complexArray[0][0] = complex3.over(complex5);
            complexArray[1][0] = Complex.minusOne().times(complex4.over(complex5));
            complexArray[2][0] = new Complex(1.0, 0.0);
            return complexArray;
        }
        int n10 = n8;
        int n11 = 0;
        Complex[] complexArray2 = complexPoly2.rootsNoMessages();
        int[] nArray = new int[n8];
        boolean[] blArray = new boolean[n8];
        int[] nArray2 = new int[n8];
        int[] nArray3 = new int[n8];
        boolean[] blArray2 = new boolean[n8];
        double d = 0.01;
        int[] nArray4 = new int[n8];
        int n12 = 0;
        Complex complex6 = new Complex();
        int n13 = 0;
        for (n7 = 0; n7 < n8; ++n7) {
            blArray[n7] = false;
        }
        for (n7 = 0; n7 < n8; ++n7) {
            blArray2[n7] = true;
        }
        for (n7 = 0; n7 < n8; ++n7) {
            int n14;
            if (!blArray[n7]) {
                n12 = 1;
                nArray[n7] = 1;
                nArray3[n7] = 1;
                nArray2[n7] = n7;
                nArray4[n7] = 1;
                complex6 = complexArray2[n7];
                for (n14 = n7 + 1; n14 < n8; ++n14) {
                    if (blArray[n14]) continue;
                    if (complexArray2[n7].isEqualWithinLimits(complexArray2[n14], d)) {
                        nArray2[n14] = n7;
                        nArray[n14] = ++n12;
                        blArray[n14] = true;
                        blArray[n7] = true;
                        blArray2[n14] = false;
                        blArray2[n7] = false;
                        n13 = n14;
                        --n10;
                        complex6 = complex6.plus(complexArray2[n14]);
                        continue;
                    }
                    nArray2[n14] = n14;
                    nArray[n14] = 1;
                }
            }
            if (!blArray[n7]) continue;
            --n10;
            ++n11;
            blArray2[n13] = true;
            complex6 = complex6.over(n12);
            for (n14 = 0; n14 < n8; ++n14) {
                if (!blArray[n14] || nArray2[n14] != n7) continue;
                complexArray2[n14] = complex6;
                nArray3[n7] = n12;
                nArray4[n14] = n12;
            }
        }
        Complex complex7 = Complex.zero();
        Complex complex8 = Complex.zero();
        for (int j = 0; j < n8; ++j) {
            complex7 = complex7.plus(complexArray2[j]);
            complex8 = complex8.plus(complexArray2[j].abs());
        }
        complex7 = complex7.over(n8);
        complex8 = complex8.over(n8);
        Complex complex9 = complex7;
        if (complex9.isZero()) {
            complex9 = complex8;
        }
        if (complex9.isZero()) {
            complex9 = Complex.plusOne();
        }
        Complex[] complexArray3 = Complex.oneDarray(n8);
        boolean[] blArray3 = new boolean[n8];
        for (int j = 0; j < n8; ++j) {
            blArray3[j] = false;
        }
        Complex[] complexArray4 = null;
        Complex complex10 = new Complex(1.7, 0.0);
        for (n6 = 0; n6 < n8; ++n6) {
            complexArray3[n6] = complexArray2[n6].copy();
        }
        n6 = 0;
        if (n11 > 0) {
            for (n5 = 0; n5 < n8; ++n5) {
                if (nArray4[n5] <= 1 || blArray3[n5]) continue;
                n6 = nArray4[n5];
                complexArray4 = Complex.oneDarray(nArray4[n5]);
                n4 = nArray4[n5] / 2;
                if (Fmath.isEven(nArray4[n5])) {
                    for (n3 = 0; n3 < n4; ++n3) {
                        complexArray4[n4 + n3] = complex10.times(n3 + 1);
                        complexArray4[n4 - 1 - n3] = complexArray4[n4 + n3].times(-1.0);
                    }
                } else {
                    complexArray4[n4] = Complex.zero();
                    for (n3 = 0; n3 < n4; ++n3) {
                        complexArray4[n4 + 1 + n3] = complex10.times(n3 + 1);
                        complexArray4[n4 - 1 - n3] = complexArray4[n4 + n3].times(-1.0);
                    }
                }
                n3 = 0;
                for (n2 = 0; n2 < n8; ++n2) {
                    if (blArray3[n2] || nArray4[n2] != n6) continue;
                    Complex complex11 = complexArray2[n2];
                    if (complex11.isZero()) {
                        complex11 = complex9;
                    }
                    complexArray3[n2] = complexArray4[n3].times(complex11);
                    blArray3[n2] = true;
                    ++n3;
                }
            }
        }
        n5 = 1;
        n4 = 0;
        n3 = 0;
        while (n5 != 0) {
            n2 = n4 + 1;
            boolean bl = true;
            while (bl) {
                if (complexArray3[n4].isEqualWithinLimits(complexArray3[n2], d)) {
                    complexArray3[n4] = complexArray3[n4].plus(complex9.times(n3));
                    n4 = 0;
                    bl = false;
                    if (++n3 > 1000000) {
                        throw new IllegalArgumentException("a non repeating set of substitution values could not be foumd");
                    }
                } else {
                    ++n2;
                }
                if (n2 < n8) continue;
                bl = false;
            }
            if (++n4 < n8 - 1) continue;
            n5 = 0;
        }
        Complex[][] complexArray5 = Complex.twoDarray(n8, n8);
        Complex[] complexArray6 = Complex.oneDarray(n8);
        for (n = 0; n < n8; ++n) {
            complexArray6[n] = n9 > 0 ? complexPoly.evaluate(complexArray3[n]) : complexPoly.coeffCopy(0);
        }
        for (n = 0; n < n8; ++n) {
            for (int j = 0; j < n8; ++j) {
                Complex complex12 = Complex.plusOne();
                int n15 = 0;
                for (int k = 0; k < n8; ++k) {
                    if (!blArray2[k]) continue;
                    if (j != k) {
                        if (nArray[k] == 1) {
                            complex12 = complex12.times(complexArray3[n].minus(complexArray2[k]));
                            continue;
                        }
                        complex12 = complex12.times(Complex.pow(complexArray3[n].minus(complexArray2[k]), nArray[k]));
                        continue;
                    }
                    if (nArray[j] >= nArray3[j]) continue;
                    n15 = nArray3[j] - nArray[j];
                    if (n15 == 1) {
                        complex12 = complex12.times(complexArray3[n].minus(complexArray2[k]));
                        continue;
                    }
                    if (n15 == 0) continue;
                    complex12 = complex12.times(Complex.pow(complexArray3[n].minus(complexArray2[k]), n15));
                }
                complexArray5[n][j] = complex12;
            }
        }
        ComplexMatrix complexMatrix = new ComplexMatrix(complexArray5);
        Complex[] complexArray7 = complexMatrix.solveLinearSet(complexArray6);
        for (int j = 0; j < n8; ++j) {
            complexArray[0][j] = complexArray7[j].times(complex).over(complex2);
            complexArray[1][j] = complexArray2[j];
            complexArray[2][j].reset(nArray[j], 0.0);
        }
        return complexArray;
    }

    public BlackBox copy() {
        if (this == null) {
            return null;
        }
        BlackBox blackBox = new BlackBox();
        this.copyBBvariables(blackBox);
        return blackBox;
    }

    public void copyBBvariables(BlackBox blackBox) {
        blackBox.sampLen = this.sampLen;
        blackBox.inputT = Conv.copy(this.inputT);
        blackBox.outputT = Conv.copy(this.outputT);
        blackBox.time = Conv.copy(this.time);
        blackBox.forgetFactor = this.forgetFactor;
        blackBox.deltaT = this.deltaT;
        blackBox.sampFreq = this.sampFreq;
        blackBox.inputS = this.inputS.copy();
        blackBox.outputS = this.outputS.copy();
        blackBox.sValue = this.sValue.copy();
        blackBox.zValue = this.zValue.copy();
        blackBox.sNumer = this.sNumer.copy();
        blackBox.sDenom = this.sDenom.copy();
        blackBox.zNumer = this.zNumer.copy();
        blackBox.zDenom = this.zDenom.copy();
        blackBox.sNumerSet = this.sNumerSet;
        blackBox.sDenomSet = this.sDenomSet;
        blackBox.sNumerScaleFactor = this.sNumerScaleFactor;
        blackBox.sDenomScaleFactor = this.sDenomScaleFactor;
        blackBox.sPoles = Complex.copy(this.sPoles);
        blackBox.sZeros = Complex.copy(this.sZeros);
        blackBox.zPoles = Complex.copy(this.zPoles);
        blackBox.zZeros = Complex.copy(this.zZeros);
        blackBox.sNumerDeg = this.sNumerDeg;
        blackBox.sDenomDeg = this.sDenomDeg;
        blackBox.zNumerDeg = this.zNumerDeg;
        blackBox.zDenomDeg = this.zDenomDeg;
        blackBox.deadTime = this.deadTime;
        blackBox.orderPade = this.orderPade;
        blackBox.sNumerPade = this.sNumerPade.copy();
        blackBox.sDenomPade = this.sDenomPade.copy();
        blackBox.sPolesPade = Complex.copy(this.sPolesPade);
        blackBox.sZerosPade = Complex.copy(this.sZerosPade);
        blackBox.sNumerDegPade = this.sNumerDegPade;
        blackBox.sDenomDegPade = this.sDenomDegPade;
        blackBox.maptozero = this.maptozero;
        blackBox.padeAdded = this.padeAdded;
        blackBox.integrationSum = this.integrationSum;
        blackBox.integMethod = this.integMethod;
        blackBox.ztransMethod = this.ztransMethod;
        blackBox.name = this.name;
        blackBox.fixedName = this.fixedName;
        blackBox.nPlotPoints = this.nPlotPoints;
    }

    public Object clone() {
        return this.copy();
    }
}

