/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;
import flanagan.control.OpenLoop;
import java.util.ArrayList;
import java.util.Vector;

public class ClosedLoop
extends BlackBox {
    private OpenLoop forwardPath = new OpenLoop();
    private OpenLoop closedPath = new OpenLoop();
    private ArrayList<BlackBox> feedbackPath = new ArrayList();
    private int nFeedbackBoxes = 0;
    private boolean checkNoMix = true;
    private boolean checkConsolidate = false;
    private double deadTimeSum = 0.0;

    public ClosedLoop() {
        super("ClosedLoop");
    }

    public void addBoxToForwardPath(BlackBox blackBox) {
        this.forwardPath.addBoxToPath(blackBox);
    }

    public void addBoxToFeedbackPath(BlackBox blackBox) {
        this.feedbackPath.add(blackBox);
        ++this.nFeedbackBoxes;
    }

    public void consolidate() {
        this.closedPath = this.forwardPath.copy();
        for (int j = 0; j < this.nFeedbackBoxes; ++j) {
            this.closedPath.addBoxToPath(this.feedbackPath.get(j));
        }
        this.forwardPath.consolidate();
        if (!this.forwardPath.getCheckNoMix()) {
            this.checkNoMix = false;
        }
        this.closedPath.consolidate();
        if (!this.closedPath.getCheckNoMix()) {
            this.checkNoMix = false;
        }
        ComplexPoly complexPoly = this.forwardPath.getSnumer();
        ComplexPoly complexPoly2 = this.forwardPath.getSdenom();
        ComplexPoly complexPoly3 = this.closedPath.getSnumer();
        ComplexPoly complexPoly4 = this.closedPath.getSdenom();
        if (complexPoly2.isEqual(complexPoly4)) {
            super.setSnumer(complexPoly.copy());
            super.setSdenom(complexPoly3.plus(complexPoly2).copy());
        } else {
            super.setSnumer(complexPoly.times(complexPoly4));
            super.setSdenom(complexPoly3.times(complexPoly2).plus(complexPoly4.times(complexPoly2)));
        }
        this.checkConsolidate = true;
        this.deadTimeSum = this.closedPath.getDeadTime();
        this.deadTime = 0.0;
        this.checkConsolidate = true;
    }

    public int getNumberOfBoxesInForwardPath() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.forwardPath.getNumberOfBoxes();
    }

    public int getNumberOfBoxesInClosedLoop() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.closedPath.getNumberOfBoxes();
    }

    public ArrayList<Object> getForwardPathSegmentsArrayList() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.forwardPath.getSegmentsArrayList();
    }

    public Vector<Object> getForwardPathSegmentsVector() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.forwardPath.getSegmentsVector();
    }

    public ArrayList<Object> getClosedLoopSegmentsArrayList() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.closedPath.getSegmentsArrayList();
    }

    public Vector<Object> getClosedLoopSegmentsVector() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.closedPath.getSegmentsVector();
    }

    public int getNumberOfSegmentsInForwardPath() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.forwardPath.getNumberOfSegments();
    }

    public int getNumberOfSegmentsInClosedLoop() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.closedPath.getNumberOfSegments();
    }

    public String getNamesOfBoxesInForwardPath() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.forwardPath.getNamesOfBoxes();
    }

    public String getNamesOfBoxesInClosedLoop() {
        if (!this.checkConsolidate) {
            this.consolidate();
        }
        return this.closedPath.getNamesOfBoxes();
    }

    public void removeAllBoxes() {
        this.forwardPath.removeAllBoxes();
        this.closedPath.removeAllBoxes();
        this.feedbackPath.clear();
        this.checkNoMix = true;
        this.checkConsolidate = false;
        this.nFeedbackBoxes = 0;
    }

    @Override
    public double getDeadTime() {
        return this.deadTimeSum;
    }

    @Override
    public ClosedLoop copy() {
        if (this == null) {
            return null;
        }
        ClosedLoop closedLoop = new ClosedLoop();
        this.copyBBvariables(closedLoop);
        closedLoop.nFeedbackBoxes = this.nFeedbackBoxes;
        closedLoop.checkNoMix = this.checkNoMix;
        closedLoop.checkConsolidate = this.checkConsolidate;
        closedLoop.forwardPath = this.forwardPath.copy();
        closedLoop.closedPath = this.closedPath.copy();
        closedLoop.feedbackPath = new ArrayList();
        if (this.feedbackPath.size() != 0) {
            for (int j = 0; j < this.feedbackPath.size(); ++j) {
                closedLoop.feedbackPath.add(this.feedbackPath.get(j).copy());
            }
        }
        return closedLoop;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

