/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;

public class Compensator
extends BlackBox {
    private double kConst = 1.0;
    private double aConst = 1.0;
    private double bConst = 1.0;

    public Compensator() {
        super("Compensator");
        this.sZeros = Complex.oneDarray(1);
        this.sPoles = Complex.oneDarray(1);
        super.setSnumer(new ComplexPoly(1.0, 1.0));
        super.setSdenom(new ComplexPoly(1.0, 1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public Compensator(double d, double d2, double d3) {
        super("Compensator");
        this.aConst = d2;
        this.bConst = d3;
        this.kConst = d;
        this.sZeros = Complex.oneDarray(1);
        this.sPoles = Complex.oneDarray(1);
        super.setSnumer(new ComplexPoly(this.aConst * this.kConst, this.kConst));
        super.setSdenom(new ComplexPoly(this.bConst, 1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public void setCoeff(double d, double d2, double d3) {
        this.aConst = d2;
        this.bConst = d3;
        this.kConst = d;
        Complex[] complexArray = Complex.oneDarray(2);
        complexArray[0].reset(this.aConst * this.kConst, 0.0);
        complexArray[1].reset(this.kConst, 0.0);
        this.sNumer.resetPoly(complexArray);
        Complex[] complexArray2 = Complex.oneDarray(2);
        complexArray2[0].reset(this.bConst, 0.0);
        complexArray2[1].reset(1.0, 0.0);
        this.sDenom.resetPoly(complexArray2);
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setK(double d) {
        this.kConst = d;
        if (this.sNumerDeg != 1 || this.sDenomDeg != 1) {
            Complex[] complexArray = Complex.oneDarray(2);
            complexArray[0].reset(this.aConst * this.kConst, 0.0);
            complexArray[1].reset(this.kConst, 0.0);
            this.sNumer.resetPoly(complexArray);
            Complex[] complexArray2 = Complex.oneDarray(2);
            complexArray2[0].reset(this.bConst, 0.0);
            complexArray2[1].reset(1.0, 0.0);
            this.sDenom.resetPoly(complexArray2);
        } else {
            Complex complex = new Complex(this.aConst * this.kConst, 0.0);
            this.sNumer.resetCoeff(0, complex);
            complex = new Complex(this.kConst, 0.0);
            this.sNumer.resetCoeff(1, complex);
        }
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setA(double d) {
        this.aConst = d;
        if (this.sNumerDeg != 1 || this.sDenomDeg != 1) {
            Complex[] complexArray = Complex.oneDarray(2);
            complexArray[0].reset(this.aConst * this.kConst, 0.0);
            complexArray[1].reset(this.kConst, 0.0);
            this.sNumer.resetPoly(complexArray);
            Complex[] complexArray2 = Complex.oneDarray(2);
            complexArray2[0].reset(this.bConst, 0.0);
            complexArray2[1].reset(1.0, 0.0);
            this.sDenom.resetPoly(complexArray2);
        } else {
            Complex complex = new Complex(this.aConst * this.kConst, 0.0);
            this.sNumer.resetCoeff(0, complex);
        }
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setB(double d) {
        this.bConst = d;
        if (this.sNumerDeg != 1 || this.sDenomDeg != 1) {
            Complex[] complexArray = Complex.oneDarray(2);
            complexArray[0].reset(this.aConst * this.kConst, 0.0);
            complexArray[1].reset(this.kConst, 0.0);
            this.sNumer.resetPoly(complexArray);
            Complex[] complexArray2 = Complex.oneDarray(2);
            complexArray2[0].reset(this.bConst, 0.0);
            complexArray2[1].reset(1.0, 0.0);
            this.sDenom.resetPoly(complexArray2);
        } else {
            Complex complex = new Complex(this.bConst, 0.0);
            this.sDenom.resetCoeff(0, complex);
        }
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public double getA() {
        return this.aConst;
    }

    public double getB() {
        return this.bConst;
    }

    public double getK() {
        return this.kConst;
    }

    @Override
    public void calcPolesZerosS() {
        this.sZeros[0].setReal(-this.aConst);
        this.sPoles[0].setReal(-this.bConst);
        this.sNumerScaleFactor = BlackBox.scaleFactor(this.sNumer, this.sZeros);
        this.sDenomScaleFactor = BlackBox.scaleFactor(this.sDenom, this.sPoles);
    }

    @Override
    public Compensator copy() {
        if (this == null) {
            return null;
        }
        Compensator compensator = new Compensator();
        this.copyBBvariables(compensator);
        compensator.kConst = this.kConst;
        compensator.aConst = this.aConst;
        compensator.bConst = this.bConst;
        return compensator;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

