/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;
import flanagan.plot.PlotGraph;

public class FirstOrder
extends BlackBox {
    private double aConst = 1.0;
    private double bConst = 1.0;
    private double cConst = 1.0;

    public FirstOrder() {
        super("FirstOrder");
        this.sPoles = Complex.oneDarray(1);
        super.setSnumer(new ComplexPoly(1.0));
        super.setSdenom(new ComplexPoly(1.0, 1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public FirstOrder(double d, double d2, double d3) {
        super("FirstOrder");
        this.aConst = d;
        this.bConst = d2;
        this.cConst = d3;
        this.sPoles = Complex.oneDarray(1);
        super.setSnumer(new ComplexPoly(this.cConst));
        super.setSdenom(new ComplexPoly(this.bConst, this.aConst));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public void setCoeff(double d, double d2, double d3) {
        this.aConst = d;
        this.bConst = d2;
        this.cConst = d3;
        Complex[] complexArray = Complex.oneDarray(1);
        complexArray[0].reset(this.cConst, 0.0);
        this.sNumer.resetPoly(complexArray);
        Complex[] complexArray2 = Complex.oneDarray(2);
        complexArray2[0].reset(this.bConst, 0.0);
        complexArray2[1].reset(this.aConst, 0.0);
        this.sDenom.resetPoly(complexArray2);
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setA(double d) {
        this.aConst = d;
        Complex complex = new Complex(this.aConst, 0.0);
        this.sDenom.resetCoeff(1, complex);
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setB(double d) {
        this.bConst = d;
        Complex complex = new Complex(this.bConst, 0.0);
        this.sDenom.resetCoeff(0, complex);
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setC(double d) {
        this.cConst = d;
        Complex complex = new Complex(this.cConst, 0.0);
        this.sNumer.resetCoeff(0, complex);
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public double getA() {
        return this.aConst;
    }

    public double getB() {
        return this.bConst;
    }

    public double getC() {
        return this.cConst;
    }

    public double getTimeConstant() {
        return this.aConst / this.bConst;
    }

    @Override
    protected void calcPolesZerosS() {
        this.sPoles = Complex.oneDarray(1);
        this.sPoles[0].setReal(-this.bConst / this.aConst);
        if (this.sNumerSet) {
            this.sNumerScaleFactor = this.sNumer.coeffCopy(0);
        }
        if (this.sDenomSet) {
            this.sDenomScaleFactor = BlackBox.scaleFactor(this.sDenom, this.sPoles);
        }
    }

    @Override
    public void stepInput(double d, double d2) {
        if (this.bConst / this.aConst == 0.0) {
            int n;
            int n2 = 51;
            double d3 = d2 / (double)(n2 - 2);
            double[][] dArray = new double[2][n2];
            dArray[0][0] = 0.0;
            dArray[0][1] = 0.0;
            for (int j = 2; j < n2; ++j) {
                dArray[0][j] = dArray[0][j - 1] + d3;
            }
            double d4 = this.cConst * d / this.bConst;
            dArray[1][0] = 0.0;
            for (n = 1; n < n2; ++n) {
                dArray[1][n] = d4;
            }
            if (this.deadTime != 0.0) {
                n = 0;
                while (n < n2) {
                    double[] dArray2 = dArray[0];
                    int n3 = n++;
                    dArray2[n3] = dArray2[n3] + this.deadTime;
                }
            }
            PlotGraph plotGraph = new PlotGraph(dArray);
            plotGraph.setGraphTitle("Step Input Transient:   Step magnitude = " + d);
            plotGraph.setGraphTitle2(this.getName());
            plotGraph.setXaxisLegend("Time");
            plotGraph.setXaxisUnitsName("s");
            plotGraph.setYaxisLegend("Output");
            plotGraph.setPoint(0);
            plotGraph.setLine(3);
            plotGraph.plot();
        } else {
            super.stepInput(d, d2);
        }
    }

    @Override
    public void zTransform() {
        if (this.deltaT == 0.0) {
            System.out.println("z-transform attempted in FirstOrder with a zero sampling period");
        }
        super.deadTimeWarning("zTransform");
        if (this.ztransMethod == 0) {
            this.mapstozAdHoc();
        } else {
            Complex[] complexArray = null;
            Complex[] complexArray2 = null;
            switch (this.integMethod) {
                case 0: {
                    complexArray = Complex.oneDarray(2);
                    complexArray[0].reset(this.deltaT * this.cConst, 0.0);
                    complexArray[1].reset(this.deltaT * this.cConst, 0.0);
                    this.zNumer = new ComplexPoly(1);
                    this.zNumer.resetPoly(complexArray);
                    this.zNumerDeg = 1;
                    complexArray2 = Complex.oneDarray(2);
                    complexArray2[0].reset(this.bConst * this.deltaT - 2.0 * this.aConst, 0.0);
                    complexArray2[1].reset(this.bConst * this.deltaT + 2.0 * this.aConst, 0.0);
                    this.zDenom = new ComplexPoly(1);
                    this.zDenom.resetPoly(complexArray2);
                    this.zDenomDeg = 1;
                    this.zZeros = Complex.oneDarray(1);
                    this.zZeros[0].reset(-1.0, 0.0);
                    this.zPoles = Complex.oneDarray(1);
                    this.zPoles[0].reset((2.0 * this.aConst - this.deltaT * this.bConst) / (2.0 * this.aConst + this.deltaT * this.bConst), 0.0);
                    break;
                }
                case 1: {
                    complexArray = Complex.oneDarray(2);
                    complexArray[0].reset(0.0, 0.0);
                    complexArray[1].reset(this.cConst * this.deltaT, 0.0);
                    this.zNumer = new ComplexPoly(1);
                    this.zNumer.resetPoly(complexArray);
                    this.zNumerDeg = 1;
                    complexArray2 = Complex.oneDarray(2);
                    complexArray2[0].reset(this.bConst * this.deltaT + this.aConst, 0.0);
                    complexArray2[1].reset(this.aConst, 0.0);
                    this.zDenom = new ComplexPoly(1);
                    this.zDenom.resetPoly(complexArray2);
                    this.zDenomDeg = 1;
                    this.zZeros = Complex.oneDarray(1);
                    this.zZeros[0].reset(0.0, 0.0);
                    this.zPoles = Complex.oneDarray(1);
                    this.zPoles[0].reset(this.aConst / (this.deltaT * this.bConst + this.aConst), 0.0);
                    break;
                }
                case 2: {
                    complexArray = Complex.oneDarray(1);
                    complexArray[0].reset(this.cConst * this.deltaT, 0.0);
                    this.zNumer = new ComplexPoly(0);
                    this.zNumer.resetPoly(complexArray);
                    this.zNumerDeg = 0;
                    complexArray2 = Complex.oneDarray(2);
                    complexArray2[0].reset(-this.aConst, 0.0);
                    complexArray2[1].reset(this.bConst * this.deltaT - this.aConst, 0.0);
                    this.zDenom = new ComplexPoly(1);
                    this.zDenom.resetPoly(complexArray2);
                    this.zDenomDeg = 1;
                    this.zPoles = Complex.oneDarray(1);
                    this.zPoles[0].reset(this.aConst / (this.deltaT * this.bConst - this.aConst), 0.0);
                    break;
                }
                default: {
                    System.out.println("Integration method option in FirstOrder must be 0,1 or 2");
                    System.out.println("It was set at " + this.integMethod);
                    System.out.println("z-transform not performed");
                }
            }
        }
    }

    @Override
    public void zTransform(double d) {
        super.setDeltaT(d);
        this.zTransform();
    }

    @Override
    public Complex getOutputS(Complex complex, Complex complex2) {
        this.sValue = complex;
        this.inputS = complex2;
        return this.getOutputS();
    }

    @Override
    public Complex getOutputS() {
        Complex complex = Complex.plusOne();
        complex = complex.times(this.cConst);
        Complex complex2 = new Complex();
        complex2 = this.sValue.times(this.aConst);
        complex2 = complex2.plus(this.bConst);
        Complex complex3 = new Complex();
        complex3 = complex.over(complex2);
        this.outputS = complex3.times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    public double calcOutputT(double d, double d2) {
        super.setInputT(d, d2);
        return this.calcOutputT();
    }

    public double calcOutputT() {
        super.deadTimeWarning("calcOutputT()");
        return super.getCurrentOutputT();
    }

    public Complex[] getSzeros() {
        System.out.println("This standard first order process (class FirstOrder) has no s-domain zeros");
        return null;
    }

    @Override
    public FirstOrder copy() {
        if (this == null) {
            return null;
        }
        FirstOrder firstOrder = new FirstOrder();
        this.copyBBvariables(firstOrder);
        firstOrder.aConst = this.aConst;
        firstOrder.bConst = this.bConst;
        firstOrder.cConst = this.cConst;
        return firstOrder;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

