/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;

public class HighPassPassive
extends BlackBox {
    private double resistance = 0.0;
    private double capacitance = 0.0;
    private double timeConstant = 0.0;
    private boolean setR = false;
    private boolean setC = false;

    public HighPassPassive() {
        super("PassiveHighPass");
        this.sZeros = Complex.oneDarray(1);
        this.sPoles = Complex.oneDarray(1);
        super.setSnumer(new ComplexPoly(0.0, 1.0));
        super.setSdenom(new ComplexPoly(1.0, 1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
        this.timeConstant = 1.0;
    }

    public void setResistance(double d) {
        this.resistance = d;
        this.timeConstant = d * this.capacitance;
        this.calcPolesZerosS();
        this.sNumer = ComplexPoly.rootsToPoly(this.sZeros);
        for (int j = 0; j <= this.sNumerDeg; ++j) {
            this.sNumer.resetCoeff(j, this.sNumer.coeffCopy(j).times(Math.pow(this.timeConstant, j)));
        }
        this.sDenom = ComplexPoly.rootsToPoly(this.sPoles);
        super.addDeadTimeExtras();
        this.setR = true;
    }

    public void setCapacitance(double d) {
        this.capacitance = d;
        this.timeConstant = d * this.resistance;
        this.calcPolesZerosS();
        this.sNumer = ComplexPoly.rootsToPoly(this.sZeros);
        for (int j = 0; j <= this.sNumerDeg; ++j) {
            this.sNumer.resetCoeff(j, this.sNumer.coeffCopy(j).times(Math.pow(this.timeConstant, j)));
        }
        this.sDenom = ComplexPoly.rootsToPoly(this.sPoles);
        super.addDeadTimeExtras();
        this.setC = true;
    }

    public void setTimeConstant(double d) {
        this.timeConstant = d;
        this.calcPolesZerosS();
        this.sNumer = ComplexPoly.rootsToPoly(this.sZeros);
        for (int j = 0; j <= this.sNumerDeg; ++j) {
            this.sNumer.resetCoeff(j, this.sNumer.coeffCopy(j).times(Math.pow(this.timeConstant, j)));
        }
        this.sDenom = ComplexPoly.rootsToPoly(this.sPoles);
        super.addDeadTimeExtras();
    }

    public double getResistance() {
        if (this.setR) {
            return this.resistance;
        }
        System.out.println("Class; HighPassPassive, method: getResistance");
        System.out.println("No resistance has been entered; zero returned");
        return 0.0;
    }

    public double getCapacitance() {
        if (this.setC) {
            return this.capacitance;
        }
        System.out.println("Class; HighPassPassive, method: getCapacitance");
        System.out.println("No capacitance has been entered; zero returned");
        return 0.0;
    }

    public double getTimeConstant() {
        return this.timeConstant;
    }

    @Override
    protected void calcPolesZerosS() {
        this.sZeros[0].setReal(0.0);
        this.sPoles[0].setReal(-this.timeConstant);
        this.sNumerScaleFactor = BlackBox.scaleFactor(this.sNumer, this.sZeros);
        this.sDenomScaleFactor = BlackBox.scaleFactor(this.sDenom, this.sPoles);
    }

    @Override
    public HighPassPassive copy() {
        if (this == null) {
            return null;
        }
        HighPassPassive highPassPassive = new HighPassPassive();
        this.copyBBvariables(highPassPassive);
        highPassPassive.resistance = this.resistance;
        highPassPassive.capacitance = this.capacitance;
        highPassPassive.timeConstant = this.timeConstant;
        highPassPassive.setR = this.setR;
        highPassPassive.setC = this.setC;
        return highPassPassive;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

