/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;
import flanagan.plot.PlotGraph;

public class Prop
extends BlackBox {
    private double kp = 1.0;

    public Prop() {
        super("Prop");
        super.setSnumer(new ComplexPoly(1.0));
        super.setSdenom(new ComplexPoly(1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
        this.sNumerScaleFactor = Complex.plusOne();
        this.sDenomScaleFactor = Complex.plusOne();
    }

    public Prop(double d) {
        super("Prop");
        this.kp = d;
        super.setSnumer(new ComplexPoly(this.kp));
        super.setSdenom(new ComplexPoly(1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
        this.sNumerScaleFactor = new Complex(d, 0.0);
        this.sDenomScaleFactor = Complex.plusOne();
    }

    public void setKp(double d) {
        this.kp = d;
        Complex complex = new Complex(this.kp, 0.0);
        this.sNumer.resetCoeff(0, complex);
        super.addDeadTimeExtras();
        this.sNumerScaleFactor = new Complex(d, 0.0);
    }

    public double getKp() {
        return this.kp;
    }

    @Override
    public void zTransform() {
        this.zNumerDeg = 0;
        this.zDenomDeg = 0;
        this.zNumer = new ComplexPoly(this.kp);
        this.zDenom = new ComplexPoly(1.0);
    }

    @Override
    public void zTransform(double d) {
        super.setDeltaT(d);
        this.zTransform();
    }

    @Override
    public void stepInput(double d, double d2) {
        int n;
        int n2 = 51;
        double d3 = d2 / (double)(n2 - 2);
        double[][] dArray = new double[2][n2];
        dArray[0][0] = 0.0;
        dArray[0][1] = 0.0;
        for (int j = 2; j < n2; ++j) {
            dArray[0][j] = dArray[0][j - 1] + d3;
        }
        double d4 = this.kp * d;
        dArray[1][0] = 0.0;
        for (n = 1; n < n2; ++n) {
            dArray[1][n] = d4;
        }
        if (this.deadTime != 0.0) {
            n = 0;
            while (n < n2) {
                double[] dArray2 = dArray[0];
                int n3 = n++;
                dArray2[n3] = dArray2[n3] + this.deadTime;
            }
        }
        PlotGraph plotGraph = new PlotGraph(dArray);
        plotGraph.setGraphTitle("Step Input Transient:   Step magnitude = " + d);
        plotGraph.setGraphTitle2(this.getName());
        plotGraph.setXaxisLegend("Time");
        plotGraph.setXaxisUnitsName("s");
        plotGraph.setYaxisLegend("Output");
        plotGraph.setPoint(0);
        plotGraph.setLine(3);
        plotGraph.plot();
    }

    @Override
    public void stepInput(double d) {
        this.stepInput(1.0, d);
    }

    @Override
    public void rampInput(double d, int n, double d2) {
        if (n == 0) {
            this.stepInput(d, d2);
        } else {
            int n2;
            int n3 = 50;
            double d3 = d2 / (double)(n3 - 1);
            double[][] dArray = new double[2][n3];
            double d4 = 0.0;
            dArray[0][0] = 0.0;
            dArray[1][0] = 0.0;
            for (n2 = 1; n2 < n3; ++n2) {
                dArray[0][n2] = dArray[0][n2 - 1] + d3;
                dArray[1][n2] = d * Math.pow(dArray[0][n2], n) * this.kp;
            }
            if (this.deadTime != 0.0) {
                n2 = 0;
                while (n2 < n3) {
                    double[] dArray2 = dArray[0];
                    int n4 = n2++;
                    dArray2[n4] = dArray2[n4] + this.deadTime;
                }
            }
            PlotGraph plotGraph = new PlotGraph(dArray);
            plotGraph.setGraphTitle("Ramp (a.t^n) Input Transient:   ramp gradient (a) = " + d + " ramp order (n) = " + n);
            plotGraph.setGraphTitle2(this.getName());
            plotGraph.setXaxisLegend("Time");
            plotGraph.setXaxisUnitsName("s");
            plotGraph.setYaxisLegend("Output");
            plotGraph.setPoint(0);
            plotGraph.plot();
        }
    }

    @Override
    public void rampInput(int n, double d) {
        double d2 = 1.0;
        this.rampInput(d2, n, d);
    }

    @Override
    public void rampInput(double d, double d2) {
        int n = 1;
        this.rampInput(d, n, d2);
    }

    @Override
    public void rampInput(double d) {
        double d2 = 1.0;
        int n = 1;
        this.rampInput(d2, n, d);
    }

    @Override
    public Complex getOutputS(Complex complex, Complex complex2) {
        this.sValue = complex;
        this.inputS = complex2;
        this.outputS = this.inputS.times(this.kp);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    @Override
    public Complex getOutputS() {
        this.outputS = this.inputS.times(this.kp);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    public void calcOutputT(double d, double d2) {
        super.setInputT(d, d2);
        this.calcOutputT();
    }

    public void calcOutputT() {
        this.outputT[this.sampLen - 1] = this.kp * this.inputT[this.sampLen - 1];
    }

    @Override
    public Complex[] getZerosS() {
        System.out.println("Proportional gain controller has no s-domain zeros");
        return null;
    }

    @Override
    public Complex[] getPolesS() {
        System.out.println("Proportional gain controller has no s-domain poles");
        return null;
    }

    @Override
    public Prop copy() {
        if (this == null) {
            return null;
        }
        Prop prop = new Prop();
        this.copyBBvariables(prop);
        prop.kp = this.kp;
        return prop;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

