/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;
import flanagan.plot.PlotGraph;

public class PropInt
extends BlackBox {
    private double kp = 1.0;
    private double ti = Double.POSITIVE_INFINITY;
    private double ki = 0.0;

    public PropInt() {
        super("PropInt");
        super.setSnumer(new ComplexPoly(0.0, 1.0));
        super.setSdenom(new ComplexPoly(0.0, 1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public PropInt(double d, double d2) {
        super("PropInt");
        this.kp = d;
        this.ki = d2;
        this.ti = this.kp / d2;
        super.setSnumer(new ComplexPoly(new Complex(d2, 0.0), new Complex(d, 0.0)));
        super.setSdenom(new ComplexPoly(0.0, 1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public void setKp(double d) {
        this.kp = d;
        if (this.sNumerDeg != 1) {
            super.setSnumer(new ComplexPoly(new Complex(this.ki, 0.0), new Complex(d, 0.0)));
            super.setSdenom(new ComplexPoly(0.0, 1.0));
        } else {
            this.sNumer.resetCoeff(1, new Complex(d, 0.0));
            super.calcPolesZerosS();
        }
        super.addDeadTimeExtras();
    }

    public void setKi(double d) {
        this.ki = d;
        this.ti = this.kp / d;
        if (this.sNumerDeg != 1) {
            super.setSnumer(new ComplexPoly(new Complex(d, 0.0), new Complex(this.kp, 0.0)));
            super.setSdenom(new ComplexPoly(0.0, 1.0));
        } else {
            this.sNumer.resetCoeff(0, new Complex(d, 0.0));
            super.calcPolesZerosS();
        }
        super.addDeadTimeExtras();
    }

    public void setTi(double d) {
        this.ti = d;
        this.ki = this.kp / d;
        if (this.sNumerDeg != 1) {
            super.setSnumer(new ComplexPoly(new Complex(this.ki, 0.0), new Complex(this.kp, 0.0)));
            super.setSdenom(new ComplexPoly(0.0, 1.0));
        } else {
            this.sNumer.resetCoeff(0, new Complex(this.ki, 0.0));
            super.calcPolesZerosS();
        }
        super.addDeadTimeExtras();
    }

    public double getKp() {
        return this.kp;
    }

    public double getKi() {
        return this.ki;
    }

    public double getTi() {
        return this.ti;
    }

    @Override
    public void zTransform() {
        super.deadTimeWarning("zTransform");
        if (this.deltaT == 0.0) {
            System.out.println("z-transform attempted in PropInt with a zero sampling period");
        }
        if (this.ztransMethod == 0) {
            this.mapstozAdHoc();
        } else {
            this.zDenom = new ComplexPoly(1);
            Complex[] complexArray = Complex.oneDarray(2);
            complexArray[0].reset(-1.0, 0.0);
            complexArray[1].reset(1.0, 0.0);
            this.zDenom.resetPoly(complexArray);
            Complex[] complexArray2 = Complex.oneDarray(1);
            complexArray2[0].reset(1.0, 0.0);
            this.zNumer = new ComplexPoly(1);
            Complex[] complexArray3 = Complex.oneDarray(1);
            double d = this.ki * this.deltaT;
            switch (this.integMethod) {
                case 0: {
                    complexArray[0].reset(d / 2.0 - this.kp, 0.0);
                    complexArray[1].reset(d / 2.0 + this.kp, 0.0);
                    this.zNumer.resetPoly(complexArray);
                    complexArray3[0].reset((this.kp - d / 2.0) / (this.kp + d / 2.0), 0.0);
                    break;
                }
                case 1: {
                    complexArray[0].reset(-this.kp, 0.0);
                    complexArray[1].reset(d + this.kp, 0.0);
                    this.zNumer.resetPoly(complexArray);
                    complexArray3[0].reset(this.kp / (this.kp + d), 0.0);
                    break;
                }
                case 2: {
                    complexArray[0].reset(this.kp - d, 0.0);
                    complexArray[1].reset(this.kp, 0.0);
                    this.zNumer.resetPoly(complexArray);
                    complexArray3[0].reset((this.kp - d) / this.kp, 0.0);
                    break;
                }
                default: {
                    System.out.println("Integration method option in PropInt must be 0,1 or 2");
                    System.out.println("It was set at " + this.integMethod);
                    System.out.println("z-transform not performed");
                }
            }
        }
    }

    @Override
    public void zTransform(double d) {
        super.setDeltaT(d);
        this.zTransform();
    }

    @Override
    public void stepInput(double d, double d2) {
        int n = 50;
        double d3 = d2 / (double)(n - 1);
        double[][] dArray = new double[2][n];
        double d4 = 0.0;
        dArray[0][0] = 0.0;
        for (int j = 1; j < n; ++j) {
            dArray[0][j] = dArray[0][j - 1] + d3;
        }
        double d5 = this.kp * d;
        int n2 = 0;
        while (n2 < n) {
            dArray[1][n2] = d5 + (d4 += this.ki * d3 * d);
            double[] dArray2 = dArray[0];
            int n3 = n2++;
            dArray2[n3] = dArray2[n3] + this.deadTime;
        }
        PlotGraph plotGraph = new PlotGraph(dArray);
        plotGraph.setGraphTitle("Step Input Transient:   Step magnitude = " + d);
        plotGraph.setGraphTitle2(this.getName());
        plotGraph.setXaxisLegend("Time");
        plotGraph.setXaxisUnitsName("s");
        plotGraph.setYaxisLegend("Output");
        plotGraph.setPoint(0);
        plotGraph.plot();
    }

    @Override
    public void stepInput(double d) {
        this.stepInput(1.0, d);
    }

    @Override
    public void rampInput(double d, int n, double d2) {
        int n2;
        int n3 = 50;
        double d3 = d2 / (double)(n3 - 1);
        double[][] dArray = new double[2][n3];
        double d4 = 0.0;
        dArray[0][0] = 0.0;
        dArray[1][0] = 0.0;
        for (n2 = 1; n2 < n3; ++n2) {
            dArray[0][n2] = dArray[0][n2 - 1] + d3;
            dArray[1][n2] = this.kp * d * Math.pow(dArray[0][n2], n) + (d4 += d * (Math.pow(dArray[0][n2], n + 1) - Math.pow(dArray[0][n2 - 1], n + 1)) / (double)(n + 1));
        }
        n2 = 0;
        while (n2 < n3) {
            double[] dArray2 = dArray[0];
            int n4 = n2++;
            dArray2[n4] = dArray2[n4] + this.deadTime;
        }
        PlotGraph plotGraph = new PlotGraph(dArray);
        plotGraph.setGraphTitle("Ramp (a.t^n) Input Transient:   ramp gradient (a) = " + d + " ramp order (n) = " + n);
        plotGraph.setGraphTitle2(this.getName());
        plotGraph.setXaxisLegend("Time");
        plotGraph.setXaxisUnitsName("s");
        plotGraph.setYaxisLegend("Output");
        plotGraph.setPoint(0);
        plotGraph.plot();
    }

    @Override
    public void rampInput(int n, double d) {
        double d2 = 1.0;
        this.rampInput(d2, n, d);
    }

    @Override
    public void rampInput(double d, double d2) {
        int n = 1;
        this.rampInput(d, n, d2);
    }

    @Override
    public void rampInput(double d) {
        double d2 = 1.0;
        int n = 1;
        this.rampInput(d2, n, d);
    }

    @Override
    public Complex getOutputS(Complex complex, Complex complex2) {
        this.sValue = complex;
        this.inputS = complex2;
        Complex complex3 = this.sValue.times(this.kp);
        complex3 = complex3.plus(this.ki);
        complex3 = complex3.over(this.sValue);
        this.outputS = complex3.times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    @Override
    public Complex getOutputS() {
        Complex complex = this.sValue.times(this.kp);
        complex = complex.plus(this.ki);
        complex = complex.over(this.sValue);
        this.outputS = complex.times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    public void calcOutputT(double d, double d2) {
        super.setInputT(d, d2);
        this.calcOutputT();
    }

    public void calcOutputT() {
        super.deadTimeWarning("calcOutputT()");
        this.outputT[this.sampLen - 1] = this.kp * this.inputT[this.sampLen - 1];
        if (this.forgetFactor == 1.0) {
            switch (this.integMethod) {
                case 0: {
                    this.integrationSum += (this.inputT[this.sampLen - 1] + this.inputT[this.sampLen - 2]) * this.deltaT / 2.0;
                    break;
                }
                case 1: {
                    this.integrationSum += this.inputT[this.sampLen - 1] * this.deltaT;
                    break;
                }
                case 2: {
                    this.integrationSum += this.inputT[this.sampLen - 2] * this.deltaT;
                    break;
                }
                default: {
                    System.out.println("Integration method option in PropInt must be 0,1 or 2");
                    System.out.println("It was set at " + this.integMethod);
                    System.out.println("getOutput not performed");
                    break;
                }
            }
        } else {
            switch (this.integMethod) {
                case 0: {
                    this.integrationSum = 0.0;
                    for (int j = 1; j < this.sampLen; ++j) {
                        this.integrationSum += Math.pow(this.forgetFactor, this.sampLen - 1 - j) * (this.inputT[j - 1] + this.inputT[j]) * this.deltaT / 2.0;
                    }
                    break;
                }
                case 1: {
                    this.integrationSum = 0.0;
                    for (int j = 1; j < this.sampLen; ++j) {
                        this.integrationSum += Math.pow(this.forgetFactor, this.sampLen - 1 - j) * this.inputT[j] * this.deltaT;
                    }
                    break;
                }
                case 2: {
                    this.integrationSum = 0.0;
                    for (int j = 1; j < this.sampLen; ++j) {
                        this.integrationSum += Math.pow(this.forgetFactor, this.sampLen - 1 - j) * this.inputT[j - 1] * this.deltaT;
                    }
                    break;
                }
                default: {
                    System.out.println("Integration method option in PropInt must be 0,1 or 2");
                    System.out.println("It was set at " + this.integMethod);
                    System.out.println("getOutput not performed");
                }
            }
        }
        int n = this.sampLen - 1;
        this.outputT[n] = this.outputT[n] + this.ki * this.integrationSum;
    }

    @Override
    public PropInt copy() {
        if (this == null) {
            return null;
        }
        PropInt propInt = new PropInt();
        this.copyBBvariables(propInt);
        propInt.kp = this.kp;
        propInt.ti = this.ti;
        propInt.ki = this.ki;
        return propInt;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

