/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;
import flanagan.plot.PlotGraph;

public class PropIntDeriv
extends BlackBox {
    private double kp = 1.0;
    private double ti = Double.POSITIVE_INFINITY;
    private double ki = 0.0;
    private double td = 0.0;
    private double kd = 0.0;

    public PropIntDeriv() {
        super("PropIntDeriv");
        super.setSnumer(new ComplexPoly(0.0, 1.0, 0.0));
        super.setSdenom(new ComplexPoly(0.0, 1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public PropIntDeriv(double d, double d2, double d3) {
        super("PropIntDeriv");
        this.kp = d;
        this.ki = d2;
        this.ti = this.kp / d2;
        this.kd = d3;
        this.td = this.kp / d3;
        super.setSnumer(new ComplexPoly(d, d2, d3));
        super.setSdenom(new ComplexPoly(0.0, 1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public void setKp(double d) {
        this.kp = d;
        if (this.sNumerDeg != 2) {
            super.setSnumer(new ComplexPoly(this.ki, this.kp, this.kd));
            super.setSdenom(new ComplexPoly(0.0, 1.0));
        } else {
            this.sNumer.resetCoeff(1, new Complex(d, 0.0));
            this.calcPolesZerosS();
        }
        super.addDeadTimeExtras();
    }

    public void setKi(double d) {
        this.ki = d;
        this.ti = this.kp / d;
        if (this.sNumerDeg != 2 || this.sDenomDeg != 1) {
            super.setSnumer(new ComplexPoly(this.ki, this.kp, this.kd));
            super.setSdenom(new ComplexPoly(0.0, 1.0));
        } else {
            this.sNumer.resetCoeff(0, new Complex(d, 0.0));
            this.calcPolesZerosS();
        }
        super.addDeadTimeExtras();
    }

    public void setTi(double d) {
        this.ti = d;
        this.ki = this.kp / d;
        if (this.sNumerDeg != 2 || this.sDenomDeg != 1) {
            super.setSnumer(new ComplexPoly(this.ki, this.kp, this.kd));
            super.setSdenom(new ComplexPoly(0.0, 1.0));
        } else {
            this.sNumer.resetCoeff(0, new Complex(this.ki, 0.0));
            this.calcPolesZerosS();
        }
        super.addDeadTimeExtras();
    }

    public void setKd(double d) {
        this.kd = d;
        this.td = d / this.kp;
        if (this.sNumerDeg != 2 || this.sDenomDeg != 1) {
            super.setSnumer(new ComplexPoly(this.ki, this.kp, this.kd));
            super.setSdenom(new ComplexPoly(0.0, 1.0));
        } else {
            this.sNumer.resetCoeff(2, new Complex(d, 0.0));
            this.calcPolesZerosS();
        }
        super.addDeadTimeExtras();
    }

    public void setTd(double d) {
        this.td = d;
        this.kd = this.kp * d;
        if (this.sNumerDeg != 2 || this.sDenomDeg != 1) {
            super.setSnumer(new ComplexPoly(this.ki, this.kp, this.kd));
            super.setSdenom(new ComplexPoly(0.0, 1.0));
        } else {
            this.sNumer.resetCoeff(2, new Complex(this.kd, 0.0));
            this.calcPolesZerosS();
        }
        super.addDeadTimeExtras();
    }

    public double getKp() {
        return this.kp;
    }

    public double getKi() {
        return this.ki;
    }

    public double getTi() {
        return this.ti;
    }

    public double getKd() {
        return this.kd;
    }

    public double getTd() {
        return this.td;
    }

    @Override
    public void zTransform() {
        if (this.deltaT == 0.0) {
            System.out.println("z-transform attempted in PropIntDeriv with a zero sampling period");
        }
        super.deadTimeWarning("zTransform");
        if (this.ztransMethod == 0) {
            this.mapstozAdHoc();
        } else {
            double d = this.ki * this.deltaT;
            double d2 = this.kd / this.deltaT;
            Complex[] complexArray = Complex.oneDarray(3);
            complexArray[0].reset(0.0, 0.0);
            complexArray[1].reset(-1.0, 0.0);
            complexArray[2].reset(1.0, 0.0);
            this.zDenom.resetPoly(complexArray);
            switch (this.integMethod) {
                case 0: {
                    complexArray[0].reset(d2, 0.0);
                    complexArray[1].reset(d / 2.0 - 2.0 * d2 - this.kp, 0.0);
                    complexArray[2].reset(this.kp + d / 2.0 + d2, 0.0);
                    this.zNumer.resetPoly(complexArray);
                    break;
                }
                case 1: {
                    complexArray[0].reset(d2, 0.0);
                    complexArray[1].reset(-2.0 * d2 - this.kp, 0.0);
                    complexArray[2].reset(this.kp + d + d2, 0.0);
                    this.zNumer.resetPoly(complexArray);
                    break;
                }
                case 2: {
                    complexArray[0].reset(d2, 0.0);
                    complexArray[1].reset(d - 2.0 * d2 - this.kp, 0.0);
                    complexArray[2].reset(this.kp + d2, 0.0);
                    this.zNumer.resetPoly(complexArray);
                    break;
                }
                default: {
                    System.out.println("Integration method option in PropIntDeriv must be 0,1 or 2");
                    System.out.println("It was set at " + this.integMethod);
                    System.out.println("z-transform not performed");
                }
            }
        }
        this.zZeros = this.zNumer.roots();
        this.zPoles = this.zDenom.roots();
    }

    @Override
    public void zTransform(double d) {
        super.setDeltaT(d);
        this.zTransform();
    }

    public void calcPolesZerosZ() {
        if (this.deltaT == 0.0) {
            System.out.println("z-pole and z-zero calculation attempted in PropIntDeriv.calcPolesZerosZ( with a zero sampling period");
        }
        this.zTransform();
        this.zPoles[0].reset(0.0, 0.0);
        this.zPoles[1].reset(1.0, 0.0);
        this.zZeros = this.zNumer.roots();
    }

    public void calcPolesZerosZ(double d) {
        this.deltaT = d;
        this.calcPolesZerosZ();
    }

    @Override
    public void stepInput(double d, double d2) {
        int n;
        int n2 = 50;
        double d3 = d2 / (double)(n2 - 1);
        double[][] dArray = new double[2][n2];
        double d4 = 0.0;
        dArray[0][0] = 0.0;
        for (int j = 1; j < n2; ++j) {
            dArray[0][j] = dArray[0][j - 1] + d3;
        }
        double d5 = this.kp * d;
        for (n = 0; n < n2; ++n) {
            dArray[1][n] = d5 + (d4 += this.ki * d3 * d);
        }
        if (this.deadTime != 0.0) {
            n = 0;
            while (n < n2) {
                double[] dArray2 = dArray[0];
                int n3 = n++;
                dArray2[n3] = dArray2[n3] + this.deadTime;
            }
        }
        PlotGraph plotGraph = new PlotGraph(dArray);
        plotGraph.setGraphTitle("Step Input Transient:   Step magnitude = " + d);
        plotGraph.setGraphTitle2(this.getName());
        plotGraph.setXaxisLegend("Time");
        plotGraph.setXaxisUnitsName("s");
        plotGraph.setYaxisLegend("Output");
        plotGraph.setPoint(0);
        plotGraph.plot();
    }

    @Override
    public void stepInput(double d) {
        this.stepInput(1.0, d);
    }

    @Override
    public void rampInput(double d, int n, double d2) {
        if (n == 0) {
            this.stepInput(d, d2);
        } else {
            int n2;
            int n3 = 50;
            double d3 = d2 / (double)(n3 - 1);
            double[][] dArray = new double[2][n3];
            double d4 = 0.0;
            dArray[0][0] = 0.0;
            dArray[1][0] = 0.0;
            for (n2 = 1; n2 < n3; ++n2) {
                dArray[0][n2] = dArray[0][n2 - 1] + d3;
                dArray[1][n2] = this.kp * d * Math.pow(dArray[0][n2], n) + (d4 += this.ki * d * (Math.pow(dArray[0][n2], n + 1) - Math.pow(dArray[0][n2 - 1], n + 1)) / (double)(n + 1));
            }
            if (this.deadTime != 0.0) {
                n2 = 0;
                while (n2 < n3) {
                    double[] dArray2 = dArray[0];
                    int n4 = n2++;
                    dArray2[n4] = dArray2[n4] + this.deadTime;
                }
            }
            PlotGraph plotGraph = new PlotGraph(dArray);
            plotGraph.setGraphTitle("Ramp (a.t^n) Input Transient:   ramp gradient (a) = " + d + " ramp order (n) = " + n);
            plotGraph.setGraphTitle2(this.getName());
            plotGraph.setXaxisLegend("Time");
            plotGraph.setXaxisUnitsName("s");
            plotGraph.setYaxisLegend("Output");
            plotGraph.setPoint(0);
            plotGraph.plot();
        }
    }

    @Override
    public void rampInput(int n, double d) {
        double d2 = 1.0;
        this.rampInput(d2, n, d);
    }

    @Override
    public void rampInput(double d, double d2) {
        int n = 1;
        this.rampInput(d, n, d2);
    }

    @Override
    public void rampInput(double d) {
        double d2 = 1.0;
        int n = 1;
        this.rampInput(d2, n, d);
    }

    @Override
    public Complex getOutputS(Complex complex, Complex complex2) {
        this.sValue = complex;
        this.inputS = complex2;
        Complex complex3 = Complex.plusOne();
        Complex complex4 = Complex.plusOne();
        Complex complex5 = Complex.plusOne();
        complex3 = complex3.times(this.kp);
        complex4 = complex4.times(this.ki);
        complex4 = complex4.over(this.sValue);
        complex5 = complex5.times(this.kd);
        complex5 = complex5.times(this.sValue);
        Complex complex6 = complex3.plus(complex4.plus(complex5));
        this.outputS = complex6.times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    @Override
    public Complex getOutputS() {
        Complex complex = Complex.plusOne();
        Complex complex2 = Complex.plusOne();
        Complex complex3 = Complex.plusOne();
        complex = complex.times(this.kp);
        complex2 = complex2.times(this.ki);
        complex2 = complex2.over(this.sValue);
        complex3 = complex3.times(this.kd);
        complex3 = complex3.times(this.sValue);
        Complex complex4 = complex.plus(complex2.plus(complex3));
        this.outputS = complex4.times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    public void calcOutputT(double d, double d2) {
        super.setInputT(d, d2);
        this.calcOutputT();
    }

    public void calcOutputT() {
        super.deadTimeWarning("zTransform");
        this.outputT[this.sampLen - 1] = this.kp * this.inputT[this.sampLen - 1];
        if (this.forgetFactor == 1.0) {
            switch (this.integMethod) {
                case 0: {
                    this.integrationSum += (this.inputT[this.sampLen - 1] + this.inputT[this.sampLen - 2]) * this.deltaT / 2.0;
                    break;
                }
                case 1: {
                    this.integrationSum += this.inputT[this.sampLen - 1] * this.deltaT;
                    break;
                }
                case 2: {
                    this.integrationSum += this.inputT[this.sampLen - 2] * this.deltaT;
                    break;
                }
                default: {
                    System.out.println("Integration method option in PropInt must be 0,1 or 2");
                    System.out.println("It was set at " + this.integMethod);
                    System.out.println("getOutput not performed");
                    break;
                }
            }
        } else {
            switch (this.integMethod) {
                case 0: {
                    this.integrationSum = 0.0;
                    for (int j = 1; j < this.sampLen; ++j) {
                        this.integrationSum += Math.pow(this.forgetFactor, this.sampLen - 1 - j) * (this.inputT[j - 1] + this.inputT[j]) * this.deltaT / 2.0;
                    }
                    break;
                }
                case 1: {
                    this.integrationSum = 0.0;
                    for (int j = 1; j < this.sampLen; ++j) {
                        this.integrationSum += Math.pow(this.forgetFactor, this.sampLen - 1 - j) * this.inputT[j] * this.deltaT;
                    }
                    break;
                }
                case 2: {
                    this.integrationSum = 0.0;
                    for (int j = 1; j < this.sampLen; ++j) {
                        this.integrationSum += Math.pow(this.forgetFactor, this.sampLen - 1 - j) * this.inputT[j - 1] * this.deltaT;
                    }
                    break;
                }
                default: {
                    System.out.println("Integration method option in PropInt must be 0,1 or 2");
                    System.out.println("It was set at " + this.integMethod);
                    System.out.println("getOutput not performed");
                }
            }
        }
        int n = this.sampLen - 1;
        this.outputT[n] = this.outputT[n] + this.ki * this.integrationSum;
        int n2 = this.sampLen - 1;
        this.outputT[n2] = this.outputT[n2] + this.kd * (this.inputT[this.sampLen - 1] - this.inputT[this.sampLen - 2]) / this.deltaT;
    }

    @Override
    public PropIntDeriv copy() {
        if (this == null) {
            return null;
        }
        PropIntDeriv propIntDeriv = new PropIntDeriv();
        this.copyBBvariables(propIntDeriv);
        propIntDeriv.kp = this.kp;
        propIntDeriv.ti = this.ti;
        propIntDeriv.td = this.td;
        propIntDeriv.kd = this.kd;
        return propIntDeriv;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

