/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;

public class ZeroOrderHold
extends BlackBox {
    public ZeroOrderHold(double d, int n) {
        super("ZeroOrderHold");
        this.sPoles = Complex.oneDarray(1);
        super.setDeltaT(d);
        super.setPadeOrder(n);
        this.setNumDen(d);
    }

    public ZeroOrderHold(double d) {
        super("ZeroOrderHold");
        this.sPoles = Complex.oneDarray(1);
        super.setDeltaT(d);
        this.setNumDen(d);
    }

    private ZeroOrderHold() {
        super("ZeroOrderHold");
    }

    public void setNumDen(double d) {
        this.sDenom = new ComplexPoly(0.0, 1.0);
        this.sPoles[0].reset(0.0, 0.0);
        this.sNumer = new ComplexPoly(1.0);
        this.deadTime = d;
        super.pade();
        this.deadTime = 0.0;
        this.sNumerPade = this.sNumerPade.plus(this.sDenomPade);
        this.sZerosPade = this.sNumerPade.rootsNoMessages();
        this.sNumer = this.sNumerPade;
        this.sDenom = this.sDenomPade;
        this.sPoles = this.sPolesPade;
        this.sZeros = this.sZerosPade;
        this.sNumerDegPade = this.sNumerPade.getDeg();
        this.sDenomDegPade = this.sDenomPade.getDeg();
        this.sNumerDeg = this.sNumerDegPade;
        this.sDenomDeg = this.sDenomDegPade;
        this.sNumerScaleFactor = this.sNumerDeg == 0 ? this.sNumer.coeffCopy(0) : BlackBox.scaleFactor(this.sNumerPade, this.sZerosPade);
        this.sDenomScaleFactor = this.sDenomDeg == 0 ? this.sDenom.coeffCopy(0) : BlackBox.scaleFactor(this.sDenomPade, this.sPolesPade);
    }

    @Override
    public ZeroOrderHold copy() {
        if (this == null) {
            return null;
        }
        ZeroOrderHold zeroOrderHold = new ZeroOrderHold();
        this.copyBBvariables(zeroOrderHold);
        return zeroOrderHold;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

