/*
 * Decompiled with CFR 0.152.
 */
package flanagan.integration;

import flanagan.integration.DerivFunction;
import flanagan.integration.DerivnFunction;
import flanagan.interpolation.CubicSpline;
import flanagan.math.ArrayMaths;
import flanagan.math.DeepCopy;
import flanagan.plot.PlotGraph;
import java.util.ArrayList;

public class RungeKutta {
    private double x0 = Double.NaN;
    private double xn = Double.NaN;
    private double y0 = Double.NaN;
    private double[] yy0 = null;
    private int nODE = 0;
    private double step = Double.NaN;
    private double[][] retArray = null;
    private double relTol = 1.0E-5;
    private double absTol = 0.001;
    private int maxIter = -1;
    private int nIter = 0;
    private double[] xArray = null;
    private double[][] yArray = null;
    private int nPoints = 0;
    private ArrayList<Double> xValues = new ArrayList();
    private ArrayList<double[]> yValues = new ArrayList();
    private boolean initXset = false;
    private boolean finalXset = false;
    private boolean initYset = false;
    private boolean nPset = false;
    private boolean stepSizeSet = false;
    private boolean xArraySet = false;
    private boolean yArraySet = false;
    private boolean integrationDone = false;
    private String[] rkMethods = new String[]{"None", "Fourth Order Runge-Kutta", "Cash-Karp-Runge-Kutta", "Fehlberg-Runge-Kutta"};
    private int rkMethodNumber = 0;
    private static int nStepsMultiplier = 1000;
    private static double safetyFactor = 0.9;
    private static double incrementFactor = -0.2;
    private static double decrementFactor = -0.25;

    public void setInitialValueOfX(double d) {
        this.x0 = d;
        this.initXset = true;
    }

    public void setFinalValueOfX(double d) {
        this.xn = d;
        this.finalXset = true;
    }

    public void setInitialValueOfY(double d) {
        this.setInitialValuesOfY(d);
    }

    public void setInitialValueOfY(double[] dArray) {
        this.setInitialValuesOfY(dArray);
    }

    public void setInitialValuesOfY(double d) {
        this.y0 = d;
        this.yy0 = new double[1];
        this.yy0[0] = d;
        this.nODE = 1;
        this.initYset = true;
    }

    public void setInitialValuesOfY(double[] dArray) {
        this.yy0 = dArray;
        this.nODE = dArray.length;
        if (this.nODE == 1) {
            this.y0 = dArray[0];
        }
        this.initYset = true;
    }

    public void calcXarray() {
        double d = (this.xn - this.x0) / (double)(this.nPoints - 1);
        this.xArray = new double[this.nPoints];
        this.xArray[0] = this.x0;
        this.xValues.add(this.x0);
        this.xArray[this.nPoints - 1] = this.xn;
        for (int j = 1; j < this.nPoints - 1; ++j) {
            this.xArray[j] = this.xArray[j - 1] + d;
        }
        this.xArraySet = true;
    }

    public void initYarray() {
        this.yArray = new double[this.nODE][this.nPoints];
        for (int j = 0; j < this.nODE; ++j) {
            this.yArray[j][0] = this.yy0[j];
        }
        this.yValues.add(this.yy0);
        this.yArraySet = true;
    }

    public void setStepSize(double d) {
        this.step = d;
        this.stepSizeSet = true;
    }

    public void setToleranceScalingFactor(double d) {
        this.relTol = d;
    }

    public void setToleranceAdditionFactor(double d) {
        this.absTol = d;
    }

    public void setMaximumIterations(int n) {
        this.maxIter = n;
    }

    public int getNumberOfIterations() {
        return this.nIter;
    }

    public static void resetNstepsMultiplier(int n) {
        nStepsMultiplier = n;
    }

    public void enteredDataCheckS() {
        if (Double.isNaN(this.x0)) {
            throw new IllegalArgumentException("No initial x value has been entered");
        }
        if (Double.isNaN(this.xn)) {
            throw new IllegalArgumentException("No final x value has been entered");
        }
        if (Double.isNaN(this.y0)) {
            throw new IllegalArgumentException("No initial y value has been entered");
        }
        if (Double.isNaN(this.step)) {
            throw new IllegalArgumentException("No step size has been entered");
        }
    }

    public void enteredDataCheckM() {
        if (Double.isNaN(this.x0)) {
            throw new IllegalArgumentException("No initial x value has been entered");
        }
        if (Double.isNaN(this.xn)) {
            throw new IllegalArgumentException("No final x value has been entered");
        }
        if (this.yy0 == null) {
            throw new IllegalArgumentException("No initial y values have been entered");
        }
        if (Double.isNaN(this.step)) {
            throw new IllegalArgumentException("No step size has been entered");
        }
    }

    public double fourthOrder(DerivFunction derivFunction) {
        int n;
        this.enteredDataCheckS();
        this.rkMethodNumber = 1;
        this.xValues.add(this.x0);
        this.yValues.add(this.yy0);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = this.y0;
        double[] dArray = new double[this.nODE];
        double d7 = (this.xn - this.x0) / this.step;
        d7 = Math.ceil(d7);
        this.nIter = n = (int)d7;
        double d8 = (this.xn - this.x0) / d7;
        for (int j = 0; j < n; ++j) {
            d5 = this.x0 + (double)j * d8;
            d = d8 * derivFunction.deriv(d5, d6);
            d2 = d8 * derivFunction.deriv(d5 + d8 / 2.0, d6 + d / 2.0);
            d3 = d8 * derivFunction.deriv(d5 + d8 / 2.0, d6 + d2 / 2.0);
            d4 = d8 * derivFunction.deriv(d5 + d8, d6 + d3);
            this.xValues.add(d5 + d8);
            dArray[0] = d6 += d / 6.0 + d2 / 3.0 + d3 / 3.0 + d4 / 6.0;
            this.yValues.add(DeepCopy.copy(dArray));
        }
        this.integrationDone = true;
        return d6;
    }

    public double[][] fourthOrder(DerivFunction derivFunction, int n) {
        int n2;
        Object object;
        int n3;
        if (n < 2) {
            throw new IllegalArgumentException("The number of points, " + n + ", must be greater than 1");
        }
        this.enteredDataCheckS();
        this.nPoints = n;
        this.retArray = new double[this.nODE + 1][this.nPoints];
        this.nPset = true;
        this.calcXarray();
        this.initYarray();
        this.fourthOrder(derivFunction);
        int n4 = this.xValues.size();
        double[] dArray = new double[n4];
        double[][] dArray2 = new double[this.nODE][n4];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = this.xValues.get(n3);
            object = this.yValues.get(n3);
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray2[n2][n3] = object[n2];
            }
        }
        if (this.xArray[this.nPoints - 1] > dArray[n4 - 1]) {
            this.xArray[this.nPoints - 1] = dArray[n4 - 1];
        }
        for (n3 = 0; n3 < this.nPoints; ++n3) {
            this.retArray[0][n3] = this.xArray[n3];
        }
        for (n3 = 0; n3 < this.nODE; ++n3) {
            object = new CubicSpline(dArray, dArray2[n3]);
            for (n2 = 0; n2 < this.nPoints; ++n2) {
                this.retArray[n3 + 1][n2] = ((CubicSpline)object).interpolate(this.xArray[n2]);
            }
        }
        this.nPoints = 0;
        return this.retArray;
    }

    public double[][] fourthOrder(DerivFunction derivFunction, double[] dArray) {
        int n;
        Object object;
        int n2;
        int n3;
        this.enteredDataCheckS();
        this.rkMethodNumber = 1;
        this.nPoints = dArray.length;
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        arrayMaths = arrayMaths.sort();
        dArray = arrayMaths.array_as_double();
        if (dArray[0] < this.x0) {
            throw new IllegalArgumentException("Entered points must lie between the previously entered initial and final x values. They may include either or both of these values");
        }
        if (dArray[this.nPoints - 1] > this.xn) {
            throw new IllegalArgumentException("Entered points must lie between the previously entered initial and final x values. They may include either or both of these values");
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (dArray[0] != this.x0) {
            arrayList.add(this.x0);
        }
        for (n3 = 1; n3 < this.nPoints; ++n3) {
            arrayList.add(dArray[n3]);
        }
        if (dArray[this.nPoints - 1] != this.xn) {
            arrayList.add(this.xn);
        }
        this.nPoints = arrayList.size();
        this.xArray = new double[this.nPoints];
        for (n3 = 1; n3 < this.nPoints; ++n3) {
            this.xArray[n3] = (Double)arrayList.get(n3);
        }
        this.nPset = true;
        this.xValues.add(this.x0);
        this.xArraySet = true;
        this.retArray = new double[this.nODE + 1][this.nPoints];
        this.initYarray();
        this.fourthOrder(derivFunction);
        n3 = this.xValues.size();
        double[] dArray2 = new double[n3];
        double[][] dArray3 = new double[this.nODE][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[n2] = this.xValues.get(n2);
            object = this.yValues.get(n2);
            for (n = 0; n < this.nODE; ++n) {
                dArray3[n][n2] = object[n];
            }
        }
        if (this.xArray[this.nPoints - 1] > dArray2[n3 - 1]) {
            this.xArray[this.nPoints - 1] = dArray2[n3 - 1];
        }
        for (n2 = 0; n2 < this.nPoints; ++n2) {
            this.retArray[0][n2] = this.xArray[n2];
        }
        for (n2 = 0; n2 < this.nODE; ++n2) {
            object = new CubicSpline(dArray2, dArray3[n2]);
            for (n = 0; n < this.nPoints; ++n) {
                this.retArray[n2 + 1][n] = ((CubicSpline)object).interpolate(this.xArray[n]);
            }
        }
        this.nPoints = 0;
        return this.retArray;
    }

    public static double fourthOrder(DerivFunction derivFunction, double d, double d2, double d3, double d4) {
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d3);
        rungeKutta.setInitialValueOfY(d2);
        rungeKutta.setStepSize(d4);
        return rungeKutta.fourthOrder(derivFunction);
    }

    public static double[][] fourthOrder(DerivFunction derivFunction, int n, double d, double d2, double d3, double d4) {
        return RungeKutta.fourthOrder(derivFunction, d, d2, d3, d4, n);
    }

    public static double[][] fourthOrder(DerivFunction derivFunction, double d, double d2, double d3, double d4, int n) {
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d3);
        rungeKutta.setInitialValueOfY(d2);
        rungeKutta.setStepSize(d4);
        return rungeKutta.fourthOrder(derivFunction, n);
    }

    public static double[][] fourthOrder(DerivFunction derivFunction, double[] dArray, double d, double d2, double d3, double d4) {
        return RungeKutta.fourthOrder(derivFunction, d, d2, d3, d4, dArray);
    }

    public static double[][] fourthOrder(DerivFunction derivFunction, double d, double d2, double d3, double d4, double[] dArray) {
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d3);
        rungeKutta.setInitialValueOfY(d2);
        rungeKutta.setStepSize(d4);
        return rungeKutta.fourthOrder(derivFunction, dArray);
    }

    public double[] fourthOrder(DerivnFunction derivnFunction) {
        int n;
        int n2;
        this.enteredDataCheckM();
        this.rkMethodNumber = 1;
        double[] dArray = new double[this.nODE];
        double[] dArray2 = new double[this.nODE];
        double[] dArray3 = new double[this.nODE];
        double[] dArray4 = new double[this.nODE];
        double[] dArray5 = new double[this.nODE];
        double[] dArray6 = new double[this.nODE];
        double[] dArray7 = new double[this.nODE];
        double d = 0.0;
        double d2 = (this.xn - this.x0) / this.step;
        d2 = Math.rint(d2);
        this.nIter = n2 = (int)d2;
        double d3 = (this.xn - this.x0) / d2;
        this.xValues.add(this.x0);
        this.yValues.add(this.yy0);
        for (n = 0; n < this.nODE; ++n) {
            dArray5[n] = this.yy0[n];
        }
        for (n = 0; n < n2; ++n) {
            int n3;
            d = this.x0 + (double)n * d3;
            dArray7 = derivnFunction.derivn(d, dArray5);
            for (n3 = 0; n3 < this.nODE; ++n3) {
                dArray[n3] = d3 * dArray7[n3];
            }
            for (n3 = 0; n3 < this.nODE; ++n3) {
                dArray6[n3] = dArray5[n3] + dArray[n3] / 2.0;
            }
            dArray7 = derivnFunction.derivn(d + d3 / 2.0, dArray6);
            for (n3 = 0; n3 < this.nODE; ++n3) {
                dArray2[n3] = d3 * dArray7[n3];
            }
            for (n3 = 0; n3 < this.nODE; ++n3) {
                dArray6[n3] = dArray5[n3] + dArray2[n3] / 2.0;
            }
            dArray7 = derivnFunction.derivn(d + d3 / 2.0, dArray6);
            for (n3 = 0; n3 < this.nODE; ++n3) {
                dArray3[n3] = d3 * dArray7[n3];
            }
            for (n3 = 0; n3 < this.nODE; ++n3) {
                dArray6[n3] = dArray5[n3] + dArray3[n3];
            }
            dArray7 = derivnFunction.derivn(d + d3, dArray6);
            for (n3 = 0; n3 < this.nODE; ++n3) {
                dArray4[n3] = d3 * dArray7[n3];
            }
            for (n3 = 0; n3 < this.nODE; ++n3) {
                int n4 = n3;
                dArray5[n4] = dArray5[n4] + (dArray[n3] / 6.0 + dArray2[n3] / 3.0 + dArray3[n3] / 3.0 + dArray4[n3] / 6.0);
            }
            this.xValues.add(d + d3);
            this.yValues.add(DeepCopy.copy(dArray5));
        }
        this.integrationDone = true;
        return dArray5;
    }

    public double[][] fourthOrder(DerivnFunction derivnFunction, int n) {
        int n2;
        Object object;
        int n3;
        if (n < 2) {
            throw new IllegalArgumentException("The number of points, " + n + ", must be greater than 1");
        }
        this.enteredDataCheckM();
        this.rkMethodNumber = 1;
        this.nPoints = n;
        this.retArray = new double[this.nODE + 1][this.nPoints];
        this.nPset = true;
        this.calcXarray();
        this.initYarray();
        this.fourthOrder(derivnFunction);
        int n4 = this.xValues.size();
        double[] dArray = new double[n4];
        double[][] dArray2 = new double[this.nODE][n4];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = this.xValues.get(n3);
            object = this.yValues.get(n3);
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray2[n2][n3] = object[n2];
            }
        }
        if (this.xArray[this.nPoints - 1] > dArray[n4 - 1]) {
            this.xArray[this.nPoints - 1] = dArray[n4 - 1];
        }
        for (n3 = 0; n3 < this.nPoints; ++n3) {
            this.retArray[0][n3] = this.xArray[n3];
        }
        for (n3 = 0; n3 < this.nODE; ++n3) {
            object = new CubicSpline(dArray, dArray2[n3]);
            for (n2 = 0; n2 < this.nPoints; ++n2) {
                this.retArray[n3 + 1][n2] = ((CubicSpline)object).interpolate(this.xArray[n2]);
            }
        }
        this.nPoints = 0;
        return this.retArray;
    }

    public double[][] fourthOrder(DerivnFunction derivnFunction, double[] dArray) {
        int n;
        Object object;
        int n2;
        int n3;
        this.enteredDataCheckM();
        this.rkMethodNumber = 1;
        this.nPoints = dArray.length;
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        arrayMaths = arrayMaths.sort();
        dArray = arrayMaths.array_as_double();
        if (dArray[0] < this.x0) {
            throw new IllegalArgumentException("Entered points must lie between the previously entered initial and final x values. They may include either or both of these values");
        }
        if (dArray[this.nPoints - 1] > this.xn) {
            throw new IllegalArgumentException("Entered points must lie between the previously entered initial and final x values. They may include either or both of these values");
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (dArray[0] != this.x0) {
            arrayList.add(this.x0);
        }
        for (n3 = 1; n3 < this.nPoints; ++n3) {
            arrayList.add(dArray[n3]);
        }
        if (dArray[this.nPoints - 1] != this.xn) {
            arrayList.add(this.xn);
        }
        this.nPoints = arrayList.size();
        this.xArray = new double[this.nPoints];
        for (n3 = 1; n3 < this.nPoints; ++n3) {
            this.xArray[n3] = (Double)arrayList.get(n3);
        }
        this.nPset = true;
        this.xValues.add(this.x0);
        this.xArraySet = true;
        this.retArray = new double[this.nODE + 1][this.nPoints];
        this.initYarray();
        this.fourthOrder(derivnFunction);
        n3 = this.xValues.size();
        double[] dArray2 = new double[n3];
        double[][] dArray3 = new double[this.nODE][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[n2] = this.xValues.get(n2);
            object = this.yValues.get(n2);
            for (n = 0; n < this.nODE; ++n) {
                dArray3[n][n2] = object[n];
            }
        }
        if (this.xArray[this.nPoints - 1] > dArray2[n3 - 1]) {
            this.xArray[this.nPoints - 1] = dArray2[n3 - 1];
        }
        for (n2 = 0; n2 < this.nPoints; ++n2) {
            this.retArray[0][n2] = this.xArray[n2];
        }
        for (n2 = 0; n2 < this.nODE; ++n2) {
            object = new CubicSpline(dArray2, dArray3[n2]);
            for (n = 0; n < this.nPoints; ++n) {
                this.retArray[n2 + 1][n] = ((CubicSpline)object).interpolate(this.xArray[n]);
            }
        }
        this.nPoints = 0;
        return this.retArray;
    }

    public static double[] fourthOrder(DerivnFunction derivnFunction, double d, double[] dArray, double d2, double d3) {
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d2);
        rungeKutta.setInitialValuesOfY(dArray);
        rungeKutta.setStepSize(d3);
        return rungeKutta.fourthOrder(derivnFunction);
    }

    public static double[][] fourthOrder(DerivnFunction derivnFunction, int n, double d, double[] dArray, double d2, double d3) {
        return RungeKutta.fourthOrder(derivnFunction, d, dArray, d2, d3, n);
    }

    public static double[][] fourthOrder(DerivnFunction derivnFunction, double d, double[] dArray, double d2, double d3, int n) {
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d2);
        rungeKutta.setInitialValuesOfY(dArray);
        rungeKutta.setStepSize(d3);
        return rungeKutta.fourthOrder(derivnFunction, n);
    }

    public static double[][] fourthOrder(DerivnFunction derivnFunction, double[] dArray, double d, double[] dArray2, double d2, double d3) {
        return RungeKutta.fourthOrder(derivnFunction, d, dArray2, d2, d3, dArray);
    }

    public static double[][] fourthOrder(DerivnFunction derivnFunction, double d, double[] dArray, double d2, double d3, double[] dArray2) {
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d2);
        rungeKutta.setInitialValuesOfY(dArray);
        rungeKutta.setStepSize(d3);
        return rungeKutta.fourthOrder(derivnFunction, dArray2);
    }

    public double cashKarp(DerivFunction derivFunction) {
        this.enteredDataCheckS();
        this.rkMethodNumber = 2;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = this.y0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = this.x0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        int n = 0;
        double[] dArray = new double[1];
        if (this.maxIter == -1) {
            this.maxIter = (int)((double)nStepsMultiplier * (this.xn - this.x0) / this.step);
        }
        double d16 = this.step;
        this.xValues.add(this.x0);
        this.yValues.add(this.yy0);
        while (d12 < this.xn) {
            if (++n > this.maxIter) {
                throw new ArithmeticException("Maximum number of iterations exceeded");
            }
            d11 = derivFunction.deriv(d12, d7);
            d = d16 * d11;
            d10 = d7 + d / 5.0;
            d11 = derivFunction.deriv(d12 + d16 / 5.0, d10);
            d2 = d16 * d11;
            d10 = d7 + (3.0 * d + 9.0 * d2) / 40.0;
            d11 = derivFunction.deriv(d12 + 3.0 * d16 / 10.0, d10);
            d3 = d16 * d11;
            d10 = d7 + (3.0 * d - 9.0 * d2 + 12.0 * d3) / 10.0;
            d11 = derivFunction.deriv(d12 + 3.0 * d16 / 5.0, d10);
            d4 = d16 * d11;
            d10 = d7 - 11.0 * d / 54.0 + 5.0 * d2 / 2.0 - 70.0 * d3 / 27.0 + 35.0 * d4 / 27.0;
            d11 = derivFunction.deriv(d12 + d16, d10);
            d5 = d16 * d11;
            d10 = d7 + 1631.0 * d / 55296.0 + 175.0 * d2 / 512.0 + 575.0 * d3 / 13824.0 + 44275.0 * d4 / 110592.0 + 253.0 * d5 / 4096.0;
            d6 = d16 * (d11 = derivFunction.deriv(d12 + 7.0 * d16 / 8.0, d10));
            d9 = d7 + 37.0 * d / 378.0 + 250.0 * d3 / 621.0 + 125.0 * d4 / 594.0 + 512.0 * d6 / 1771.0;
            d13 = Math.abs(d9 - (d8 = d7 + 2825.0 * d / 27648.0 + 18575.0 * d3 / 48384.0 + 13525.0 * d4 / 55296.0 + 277.0 * d5 / 14336.0 + d6 / 4.0));
            d15 = d13 / (Math.abs(d8) * this.relTol + this.absTol);
            if (d15 <= 1.0) {
                d12 += d16;
                d14 = safetyFactor * Math.pow(d15, incrementFactor);
                if (d14 > 4.0) {
                    d16 *= 4.0;
                } else if (d14 > 1.0) {
                    d16 *= d14;
                }
                if (d12 + d16 > this.xn) {
                    d16 = this.xn - d12;
                }
                d7 = d8;
                this.xValues.add(d12);
                dArray[0] = d7;
                this.yValues.add(DeepCopy.copy(dArray));
                continue;
            }
            d14 = safetyFactor * Math.pow(d15, decrementFactor);
            if (d14 < 0.1) {
                d16 *= 0.1;
                continue;
            }
            d16 *= d14;
        }
        this.nIter = n;
        this.integrationDone = true;
        return d7;
    }

    public double[][] cashKarp(DerivFunction derivFunction, int n) {
        int n2;
        Object object;
        int n3;
        if (n < 2) {
            throw new IllegalArgumentException("The number of points, " + n + ", must be greater than 1");
        }
        this.enteredDataCheckS();
        this.nPoints = n;
        this.retArray = new double[this.nODE + 1][this.nPoints];
        this.nPset = true;
        this.calcXarray();
        this.initYarray();
        this.cashKarp(derivFunction);
        int n4 = this.xValues.size();
        double[] dArray = new double[n4];
        double[][] dArray2 = new double[this.nODE][n4];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = this.xValues.get(n3);
            object = this.yValues.get(n3);
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray2[n2][n3] = object[n2];
            }
        }
        if (this.xArray[this.nPoints - 1] > dArray[n4 - 1]) {
            this.xArray[this.nPoints - 1] = dArray[n4 - 1];
        }
        for (n3 = 0; n3 < this.nPoints; ++n3) {
            this.retArray[0][n3] = this.xArray[n3];
        }
        for (n3 = 0; n3 < this.nODE; ++n3) {
            object = new CubicSpline(dArray, dArray2[n3]);
            for (n2 = 0; n2 < this.nPoints; ++n2) {
                this.retArray[n3 + 1][n2] = ((CubicSpline)object).interpolate(this.xArray[n2]);
            }
        }
        this.nPoints = 0;
        return this.retArray;
    }

    public double[][] cashKarp(DerivFunction derivFunction, double[] dArray) {
        int n;
        Object object;
        int n2;
        int n3;
        this.enteredDataCheckS();
        this.nPoints = dArray.length;
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        arrayMaths = arrayMaths.sort();
        dArray = arrayMaths.array_as_double();
        if (dArray[0] < this.x0) {
            throw new IllegalArgumentException("Entered points must lie between the previously entered initial and final x values. They may include either or both of these values");
        }
        if (dArray[this.nPoints - 1] > this.xn) {
            throw new IllegalArgumentException("Entered points must lie between the previously entered initial and final x values. They may include either or both of these values");
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (dArray[0] != this.x0) {
            arrayList.add(this.x0);
        }
        for (n3 = 1; n3 < this.nPoints; ++n3) {
            arrayList.add(dArray[n3]);
        }
        if (dArray[this.nPoints - 1] != this.xn) {
            arrayList.add(this.xn);
        }
        this.nPoints = arrayList.size();
        this.xArray = new double[this.nPoints];
        for (n3 = 1; n3 < this.nPoints; ++n3) {
            this.xArray[n3] = (Double)arrayList.get(n3);
        }
        this.nPset = true;
        this.xValues.add(this.x0);
        this.xArraySet = true;
        this.retArray = new double[this.nODE + 1][this.nPoints];
        this.initYarray();
        this.cashKarp(derivFunction);
        n3 = this.xValues.size();
        double[] dArray2 = new double[n3];
        double[][] dArray3 = new double[this.nODE][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[n2] = this.xValues.get(n2);
            object = this.yValues.get(n2);
            for (n = 0; n < this.nODE; ++n) {
                dArray3[n][n2] = object[n];
            }
        }
        if (this.xArray[this.nPoints - 1] > dArray2[n3 - 1]) {
            this.xArray[this.nPoints - 1] = dArray2[n3 - 1];
        }
        for (n2 = 0; n2 < this.nPoints; ++n2) {
            this.retArray[0][n2] = this.xArray[n2];
        }
        for (n2 = 0; n2 < this.nODE; ++n2) {
            object = new CubicSpline(dArray2, dArray3[n2]);
            for (n = 0; n < this.nPoints; ++n) {
                this.retArray[n2 + 1][n] = ((CubicSpline)object).interpolate(this.xArray[n]);
            }
        }
        this.nPoints = 0;
        return this.retArray;
    }

    public static double cashKarp(DerivFunction derivFunction, double d, double d2, double d3, double d4, double d5, double d6, int n) {
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d3);
        rungeKutta.setInitialValueOfY(d2);
        rungeKutta.setStepSize(d4);
        rungeKutta.setToleranceScalingFactor(d6);
        rungeKutta.setToleranceAdditionFactor(d5);
        rungeKutta.setMaximumIterations(n);
        return rungeKutta.cashKarp(derivFunction);
    }

    public static double cashKarp(DerivFunction derivFunction, double d, double d2, double d3, double d4, double d5, double d6) {
        int n = (int)((double)nStepsMultiplier * (d3 - d) / d4);
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d3);
        rungeKutta.setInitialValueOfY(d2);
        rungeKutta.setStepSize(d4);
        rungeKutta.setToleranceScalingFactor(d6);
        rungeKutta.setToleranceAdditionFactor(d5);
        rungeKutta.setMaximumIterations(n);
        return rungeKutta.cashKarp(derivFunction);
    }

    public static double[][] cashKarp(DerivFunction derivFunction, int n, double d, double[] dArray, double d2, double d3, double d4, double d5, int n2) {
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d2);
        rungeKutta.setInitialValuesOfY(dArray);
        rungeKutta.setStepSize(d3);
        rungeKutta.setToleranceScalingFactor(d5);
        rungeKutta.setToleranceAdditionFactor(d4);
        rungeKutta.setMaximumIterations(n2);
        return rungeKutta.cashKarp(derivFunction, n);
    }

    public static double[][] cashKarp(DerivFunction derivFunction, int n, double d, double d2, double d3, double d4, double d5, double d6) {
        int n2 = (int)((double)nStepsMultiplier * (d3 - d) / d4);
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d3);
        rungeKutta.setInitialValueOfY(d2);
        rungeKutta.setStepSize(d4);
        rungeKutta.setToleranceScalingFactor(d6);
        rungeKutta.setToleranceAdditionFactor(d5);
        rungeKutta.setMaximumIterations(n2);
        return rungeKutta.cashKarp(derivFunction, n);
    }

    public static double[][] cashKarp(DerivFunction derivFunction, double[] dArray, double d, double d2, double d3, double d4, double d5, double d6, int n) {
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d3);
        rungeKutta.setInitialValueOfY(d2);
        rungeKutta.setStepSize(d4);
        rungeKutta.setToleranceScalingFactor(d6);
        rungeKutta.setToleranceAdditionFactor(d5);
        rungeKutta.setMaximumIterations(n);
        return rungeKutta.cashKarp(derivFunction, dArray);
    }

    public static double[][] cashKarp(DerivFunction derivFunction, double[] dArray, double d, double d2, double d3, double d4, double d5, double d6) {
        int n = (int)((double)nStepsMultiplier * (d3 - d) / d4);
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d3);
        rungeKutta.setInitialValueOfY(d2);
        rungeKutta.setStepSize(d4);
        rungeKutta.setToleranceScalingFactor(d6);
        rungeKutta.setToleranceAdditionFactor(d5);
        rungeKutta.setMaximumIterations(n);
        return rungeKutta.cashKarp(derivFunction, dArray);
    }

    public double[] cashKarp(DerivnFunction derivnFunction) {
        this.enteredDataCheckM();
        this.rkMethodNumber = 2;
        double[] dArray = new double[this.nODE];
        double[] dArray2 = new double[this.nODE];
        double[] dArray3 = new double[this.nODE];
        double[] dArray4 = new double[this.nODE];
        double[] dArray5 = new double[this.nODE];
        double[] dArray6 = new double[this.nODE];
        double[] dArray7 = new double[this.nODE];
        double[] dArray8 = new double[this.nODE];
        double[] dArray9 = new double[this.nODE];
        double[] dArray10 = new double[this.nODE];
        double[] dArray11 = new double[this.nODE];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 1.0;
        int n = 0;
        this.xValues.add(this.x0);
        this.yValues.add(this.yy0);
        for (int j = 0; j < this.nODE; ++j) {
            dArray7[j] = this.yy0[j];
        }
        double d5 = this.x0;
        if (this.maxIter == -1) {
            this.maxIter = (int)((double)nStepsMultiplier * (this.xn - this.x0) / this.step);
        }
        double d6 = this.step;
        while (d5 < this.xn) {
            int n2;
            if (++n > this.maxIter) {
                throw new ArithmeticException("Maximum number of iterations exceeded");
            }
            dArray11 = derivnFunction.derivn(d5, dArray7);
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray[n2] = d6 * dArray11[n2];
            }
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray10[n2] = dArray7[n2] + dArray[n2] / 5.0;
            }
            dArray11 = derivnFunction.derivn(d5 + d6 / 5.0, dArray10);
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray2[n2] = d6 * dArray11[n2];
            }
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray10[n2] = dArray7[n2] + (3.0 * dArray[n2] + 9.0 * dArray2[n2]) / 40.0;
            }
            dArray11 = derivnFunction.derivn(d5 + 3.0 * d6 / 10.0, dArray10);
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray3[n2] = d6 * dArray11[n2];
            }
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray10[n2] = dArray7[n2] + (3.0 * dArray[n2] - 9.0 * dArray2[n2] + 12.0 * dArray3[n2]) / 10.0;
            }
            dArray11 = derivnFunction.derivn(d5 + 3.0 * d6 / 5.0, dArray10);
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray4[n2] = d6 * dArray11[n2];
            }
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray10[n2] = dArray7[n2] - 11.0 * dArray[n2] / 54.0 + 5.0 * dArray2[n2] / 2.0 - 70.0 * dArray3[n2] / 27.0 + 35.0 * dArray4[n2] / 27.0;
            }
            dArray11 = derivnFunction.derivn(d5 + d6, dArray10);
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray5[n2] = d6 * dArray11[n2];
            }
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray10[n2] = dArray7[n2] + 1631.0 * dArray[n2] / 55296.0 + 175.0 * dArray2[n2] / 512.0 + 575.0 * dArray3[n2] / 13824.0 + 44275.0 * dArray4[n2] / 110592.0 + 253.0 * dArray5[n2] / 4096.0;
            }
            dArray11 = derivnFunction.derivn(d5 + 7.0 * d6 / 8.0, dArray10);
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray6[n2] = d6 * dArray11[n2];
            }
            d2 = 0.0;
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray9[n2] = dArray7[n2] + 2825.0 * dArray[n2] / 27648.0 + 18575.0 * dArray3[n2] / 48384.0 + 13525.0 * dArray4[n2] / 55296.0 + 277.0 * dArray5[n2] / 14336.0 + dArray6[n2] / 4.0;
                dArray8[n2] = dArray7[n2] + 37.0 * dArray[n2] / 378.0 + 250.0 * dArray3[n2] / 621.0 + 125.0 * dArray4[n2] / 594.0 + 512.0 * dArray6[n2] / 1771.0;
                d = Math.abs(dArray8[n2] - dArray9[n2]);
                d4 = Math.abs(dArray9[n2]) * this.relTol + this.absTol;
                d2 = Math.max(d2, d / d4);
            }
            if (d2 <= 1.0) {
                d5 += d6;
                d3 = safetyFactor * Math.pow(d2, incrementFactor);
                if (d3 > 4.0) {
                    d6 *= 4.0;
                } else if (d3 > 1.0) {
                    d6 *= d3;
                }
                if (d5 + d6 > this.xn) {
                    d6 = this.xn - d5;
                }
                dArray7 = DeepCopy.copy(dArray9);
                this.xValues.add(d5);
                this.yValues.add(DeepCopy.copy(dArray7));
                continue;
            }
            d3 = safetyFactor * Math.pow(d2, decrementFactor);
            if (d3 < 0.1) {
                d6 *= 0.1;
                continue;
            }
            d6 *= d3;
        }
        this.nIter = n;
        this.integrationDone = true;
        return dArray7;
    }

    public double[][] cashKarp(DerivnFunction derivnFunction, int n) {
        int n2;
        Object object;
        int n3;
        if (n < 2) {
            throw new IllegalArgumentException("The number of points, " + n + ", must be greater than 1");
        }
        this.enteredDataCheckM();
        this.nPoints = n;
        this.retArray = new double[this.nODE + 1][this.nPoints];
        this.nPset = true;
        this.calcXarray();
        this.initYarray();
        this.cashKarp(derivnFunction);
        int n4 = this.xValues.size();
        double[] dArray = new double[n4];
        double[][] dArray2 = new double[this.nODE][n4];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = this.xValues.get(n3);
            object = this.yValues.get(n3);
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray2[n2][n3] = object[n2];
            }
        }
        if (this.xArray[this.nPoints - 1] > dArray[n4 - 1]) {
            this.xArray[this.nPoints - 1] = dArray[n4 - 1];
        }
        for (n3 = 0; n3 < this.nPoints; ++n3) {
            this.retArray[0][n3] = this.xArray[n3];
        }
        for (n3 = 0; n3 < this.nODE; ++n3) {
            object = new CubicSpline(dArray, dArray2[n3]);
            for (n2 = 0; n2 < this.nPoints; ++n2) {
                this.retArray[n3 + 1][n2] = ((CubicSpline)object).interpolate(this.xArray[n2]);
            }
        }
        this.nPoints = 0;
        return this.retArray;
    }

    public double[][] cashKarp(DerivnFunction derivnFunction, double[] dArray) {
        int n;
        Object object;
        int n2;
        int n3;
        this.enteredDataCheckM();
        this.nPoints = dArray.length;
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        arrayMaths = arrayMaths.sort();
        dArray = arrayMaths.array_as_double();
        if (dArray[0] < this.x0) {
            throw new IllegalArgumentException("Entered points must lie between the previously entered initial and final x values. They may include either or both of these values");
        }
        if (dArray[this.nPoints - 1] > this.xn) {
            throw new IllegalArgumentException("Entered points must lie between the previously entered initial and final x values. They may include either or both of these values");
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (dArray[0] != this.x0) {
            arrayList.add(this.x0);
        }
        for (n3 = 1; n3 < this.nPoints; ++n3) {
            arrayList.add(dArray[n3]);
        }
        if (dArray[this.nPoints - 1] != this.xn) {
            arrayList.add(this.xn);
        }
        this.nPoints = arrayList.size();
        this.xArray = new double[this.nPoints];
        for (n3 = 1; n3 < this.nPoints; ++n3) {
            this.xArray[n3] = (Double)arrayList.get(n3);
        }
        this.nPset = true;
        this.xValues.add(this.x0);
        this.xArraySet = true;
        this.retArray = new double[this.nODE + 1][this.nPoints];
        this.initYarray();
        this.cashKarp(derivnFunction);
        n3 = this.xValues.size();
        double[] dArray2 = new double[n3];
        double[][] dArray3 = new double[this.nODE][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[n2] = this.xValues.get(n2);
            object = this.yValues.get(n2);
            for (n = 0; n < this.nODE; ++n) {
                dArray3[n][n2] = object[n];
            }
        }
        if (this.xArray[this.nPoints - 1] > dArray2[n3 - 1]) {
            this.xArray[this.nPoints - 1] = dArray2[n3 - 1];
        }
        for (n2 = 0; n2 < this.nPoints; ++n2) {
            this.retArray[0][n2] = this.xArray[n2];
        }
        for (n2 = 0; n2 < this.nODE; ++n2) {
            object = new CubicSpline(dArray2, dArray3[n2]);
            for (n = 0; n < this.nPoints; ++n) {
                this.retArray[n2 + 1][n] = ((CubicSpline)object).interpolate(this.xArray[n]);
            }
        }
        this.nPoints = 0;
        return this.retArray;
    }

    public static double[] cashKarp(DerivnFunction derivnFunction, double d, double[] dArray, double d2, double d3, double d4, double d5, int n) {
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d2);
        rungeKutta.setInitialValuesOfY(dArray);
        rungeKutta.setStepSize(d3);
        rungeKutta.setToleranceScalingFactor(d5);
        rungeKutta.setToleranceAdditionFactor(d4);
        rungeKutta.setMaximumIterations(n);
        return rungeKutta.cashKarp(derivnFunction);
    }

    public static double[] cashKarp(DerivnFunction derivnFunction, double d, double[] dArray, double d2, double d3, double d4, double d5) {
        double d6 = (d2 - d) / d3;
        int n = (int)d6 * nStepsMultiplier;
        return RungeKutta.cashKarp(derivnFunction, d, dArray, d2, d3, d4, d5, n);
    }

    public static double[][] cashKarp(DerivnFunction derivnFunction, int n, double d, double[] dArray, double d2, double d3, double d4, double d5, int n2) {
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d2);
        rungeKutta.setInitialValuesOfY(dArray);
        rungeKutta.setStepSize(d3);
        rungeKutta.setToleranceScalingFactor(d5);
        rungeKutta.setToleranceAdditionFactor(d4);
        rungeKutta.setMaximumIterations(n2);
        return rungeKutta.cashKarp(derivnFunction, n);
    }

    public static double[][] cashKarp(DerivnFunction derivnFunction, int n, double d, double[] dArray, double d2, double d3, double d4, double d5) {
        double d6 = (d2 - d) / d3;
        int n2 = (int)d6 * nStepsMultiplier;
        return RungeKutta.cashKarp(derivnFunction, n, d, dArray, d2, d3, d4, d5, n2);
    }

    public static double[][] cashKarp(DerivnFunction derivnFunction, double[] dArray, double d, double[] dArray2, double d2, double d3, double d4, double d5, int n) {
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d2);
        rungeKutta.setInitialValuesOfY(dArray2);
        rungeKutta.setStepSize(d3);
        rungeKutta.setToleranceScalingFactor(d5);
        rungeKutta.setToleranceAdditionFactor(d4);
        rungeKutta.setMaximumIterations(n);
        return rungeKutta.cashKarp(derivnFunction, dArray);
    }

    public static double[][] cashKarp(DerivnFunction derivnFunction, double[] dArray, double d, double[] dArray2, double d2, double d3, double d4, double d5) {
        double d6 = (d2 - d) / d3;
        int n = (int)d6 * nStepsMultiplier;
        return RungeKutta.cashKarp(derivnFunction, dArray, d, dArray2, d2, d3, d4, d5, n);
    }

    public double fehlberg(DerivFunction derivFunction) {
        this.enteredDataCheckS();
        this.rkMethodNumber = 3;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = this.x0;
        double d8 = this.y0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        int n = 0;
        double[] dArray = new double[1];
        if (this.maxIter == -1) {
            this.maxIter = (int)((double)nStepsMultiplier * (this.xn - this.x0) / this.step);
        }
        double d14 = this.step;
        this.xValues.add(this.x0);
        this.yValues.add(this.yy0);
        while (d7 < this.xn) {
            if (++n > this.maxIter) {
                throw new ArithmeticException("Maximum number of iterations exceeded");
            }
            d = d14 * derivFunction.deriv(d7, d8);
            d10 = d8 + 16.0 * d / 135.0 + 6656.0 * (d3 = d14 * derivFunction.deriv(d7 + 3.0 * d14 / 8.0, d8 + (3.0 * d + 9.0 * (d2 = d14 * derivFunction.deriv(d7 + d14 / 4.0, d8 + d / 4.0))) / 32.0)) / 12825.0 + 28561.0 * (d4 = d14 * derivFunction.deriv(d7 + 12.0 * d14 / 13.0, d8 + (1932.0 * d - 7200.0 * d2 + 7296.0 * d3) / 2197.0)) / 56430.0 - 9.0 * (d5 = d14 * derivFunction.deriv(d7 + d14, d8 + 439.0 * d / 216.0 - 8.0 * d2 + 3680.0 * d3 / 513.0 - 845.0 * d4 / 4104.0)) / 50.0 + 2.0 * (d6 = d14 * derivFunction.deriv(d7 + 0.5 * d14, d8 - 8.0 * d / 27.0 + 2.0 * d2 - 3544.0 * d3 / 2565.0 + 1859.0 * d4 / 4104.0 - 11.0 * d5 / 40.0)) / 55.0;
            d11 = Math.abs(d10 - (d9 = d8 + 25.0 * d / 216.0 + 1408.0 * d3 / 2565.0 + 2197.0 * d4 / 4104.0 - d5 / 5.0));
            d13 = d11 / (Math.abs(d9) * this.relTol + this.absTol);
            if (d13 <= 1.0) {
                d7 += d14;
                d12 = safetyFactor * Math.pow(d13, incrementFactor);
                if (d12 > 4.0) {
                    d14 *= 4.0;
                } else if (d12 < 1.0) {
                    d14 *= d12;
                }
                if (d7 + d14 > this.xn) {
                    d14 = this.xn - d7;
                }
                d8 = d9;
                this.xValues.add(d7);
                dArray[0] = d8;
                this.yValues.add(DeepCopy.copy(dArray));
                continue;
            }
            d12 = safetyFactor * Math.pow(d13, decrementFactor);
            if (d12 < 0.1) {
                d14 *= 0.1;
                continue;
            }
            d14 *= d12;
        }
        this.nIter = n;
        this.integrationDone = true;
        return d8;
    }

    public double[][] fehlberg(DerivFunction derivFunction, int n) {
        int n2;
        Object object;
        int n3;
        if (n < 2) {
            throw new IllegalArgumentException("The number of points, " + n + ", must be greater than 1");
        }
        this.enteredDataCheckS();
        this.nPoints = n;
        this.retArray = new double[this.nODE + 1][this.nPoints];
        this.nPset = true;
        this.calcXarray();
        this.initYarray();
        this.fehlberg(derivFunction);
        int n4 = this.xValues.size();
        double[] dArray = new double[n4];
        double[][] dArray2 = new double[this.nODE][n4];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = this.xValues.get(n3);
            object = this.yValues.get(n3);
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray2[n2][n3] = object[n2];
            }
        }
        if (this.xArray[this.nPoints - 1] > dArray[n4 - 1]) {
            this.xArray[this.nPoints - 1] = dArray[n4 - 1];
        }
        for (n3 = 0; n3 < this.nPoints; ++n3) {
            this.retArray[0][n3] = this.xArray[n3];
        }
        for (n3 = 0; n3 < this.nODE; ++n3) {
            object = new CubicSpline(dArray, dArray2[n3]);
            for (n2 = 0; n2 < this.nPoints; ++n2) {
                this.retArray[n3 + 1][n2] = ((CubicSpline)object).interpolate(this.xArray[n2]);
            }
        }
        this.nPoints = 0;
        return this.retArray;
    }

    public double[][] fehlberg(DerivFunction derivFunction, double[] dArray) {
        int n;
        Object object;
        int n2;
        int n3;
        this.enteredDataCheckS();
        this.nPoints = dArray.length;
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        arrayMaths = arrayMaths.sort();
        dArray = arrayMaths.array_as_double();
        if (dArray[0] < this.x0) {
            throw new IllegalArgumentException("Entered points must lie between the previously entered initial and final x values. They may include either or both of these values");
        }
        if (dArray[this.nPoints - 1] > this.xn) {
            throw new IllegalArgumentException("Entered points must lie between the previously entered initial and final x values. They may include either or both of these values");
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (dArray[0] != this.x0) {
            arrayList.add(this.x0);
        }
        for (n3 = 1; n3 < this.nPoints; ++n3) {
            arrayList.add(dArray[n3]);
        }
        if (dArray[this.nPoints - 1] != this.xn) {
            arrayList.add(this.xn);
        }
        this.nPoints = arrayList.size();
        this.xArray = new double[this.nPoints];
        for (n3 = 1; n3 < this.nPoints; ++n3) {
            this.xArray[n3] = (Double)arrayList.get(n3);
        }
        this.nPset = true;
        this.xValues.add(this.x0);
        this.xArraySet = true;
        this.retArray = new double[this.nODE + 1][this.nPoints];
        this.initYarray();
        this.fehlberg(derivFunction);
        n3 = this.xValues.size();
        double[] dArray2 = new double[n3];
        double[][] dArray3 = new double[this.nODE][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[n2] = this.xValues.get(n2);
            object = this.yValues.get(n2);
            for (n = 0; n < this.nODE; ++n) {
                dArray3[n][n2] = object[n];
            }
        }
        if (this.xArray[this.nPoints - 1] > dArray2[n3 - 1]) {
            this.xArray[this.nPoints - 1] = dArray2[n3 - 1];
        }
        for (n2 = 0; n2 < this.nPoints; ++n2) {
            this.retArray[0][n2] = this.xArray[n2];
        }
        for (n2 = 0; n2 < this.nODE; ++n2) {
            object = new CubicSpline(dArray2, dArray3[n2]);
            for (n = 0; n < this.nPoints; ++n) {
                this.retArray[n2 + 1][n] = ((CubicSpline)object).interpolate(this.xArray[n]);
            }
        }
        this.nPoints = 0;
        return this.retArray;
    }

    public static double fehlberg(DerivFunction derivFunction, double d, double d2, double d3, double d4, double d5, double d6, int n) {
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d3);
        rungeKutta.setInitialValueOfY(d2);
        rungeKutta.setStepSize(d4);
        rungeKutta.setToleranceScalingFactor(d6);
        rungeKutta.setToleranceAdditionFactor(d5);
        rungeKutta.setMaximumIterations(n);
        return rungeKutta.fehlberg(derivFunction);
    }

    public static double fehlberg(DerivFunction derivFunction, double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = (d3 - d) / d4;
        int n = (int)d7 * nStepsMultiplier;
        return RungeKutta.fehlberg(derivFunction, d, d2, d3, d4, d5, d6, n);
    }

    public static double[][] fehlberg(DerivFunction derivFunction, int n, double d, double[] dArray, double d2, double d3, double d4, double d5, int n2) {
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d2);
        rungeKutta.setInitialValuesOfY(dArray);
        rungeKutta.setStepSize(d3);
        rungeKutta.setToleranceScalingFactor(d5);
        rungeKutta.setToleranceAdditionFactor(d4);
        rungeKutta.setMaximumIterations(n2);
        return rungeKutta.fehlberg(derivFunction, n);
    }

    public static double[][] fehlberg(DerivFunction derivFunction, int n, double d, double d2, double d3, double d4, double d5, double d6) {
        int n2 = (int)((double)nStepsMultiplier * (d3 - d) / d4);
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d3);
        rungeKutta.setInitialValueOfY(d2);
        rungeKutta.setStepSize(d4);
        rungeKutta.setToleranceScalingFactor(d6);
        rungeKutta.setToleranceAdditionFactor(d5);
        rungeKutta.setMaximumIterations(n2);
        return rungeKutta.fehlberg(derivFunction, n);
    }

    public static double[][] fehlberg(DerivFunction derivFunction, double[] dArray, double d, double d2, double d3, double d4, double d5, double d6, int n) {
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d3);
        rungeKutta.setInitialValueOfY(d2);
        rungeKutta.setStepSize(d4);
        rungeKutta.setToleranceScalingFactor(d6);
        rungeKutta.setToleranceAdditionFactor(d5);
        rungeKutta.setMaximumIterations(n);
        return rungeKutta.fehlberg(derivFunction, dArray);
    }

    public static double[][] fehlberg(DerivFunction derivFunction, double[] dArray, double d, double d2, double d3, double d4, double d5, double d6) {
        int n = (int)((double)nStepsMultiplier * (d3 - d) / d4);
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d3);
        rungeKutta.setInitialValueOfY(d2);
        rungeKutta.setStepSize(d4);
        rungeKutta.setToleranceScalingFactor(d6);
        rungeKutta.setToleranceAdditionFactor(d5);
        rungeKutta.setMaximumIterations(n);
        return rungeKutta.fehlberg(derivFunction, dArray);
    }

    public double[] fehlberg(DerivnFunction derivnFunction) {
        this.enteredDataCheckM();
        this.rkMethodNumber = 3;
        double[] dArray = new double[this.nODE];
        double[] dArray2 = new double[this.nODE];
        double[] dArray3 = new double[this.nODE];
        double[] dArray4 = new double[this.nODE];
        double[] dArray5 = new double[this.nODE];
        double[] dArray6 = new double[this.nODE];
        double[] dArray7 = new double[this.nODE];
        double[] dArray8 = new double[this.nODE];
        double[] dArray9 = new double[this.nODE];
        double[] dArray10 = new double[this.nODE];
        double[] dArray11 = new double[this.nODE];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 1.0;
        int n = 0;
        this.xValues.add(this.x0);
        this.yValues.add(this.yy0);
        for (int j = 0; j < this.nODE; ++j) {
            dArray7[j] = this.yy0[j];
        }
        double d5 = this.x0;
        if (this.maxIter == -1) {
            this.maxIter = (int)((double)nStepsMultiplier * (this.xn - this.x0) / this.step);
        }
        double d6 = this.step;
        while (d5 < this.xn) {
            int n2;
            if (++n > this.maxIter) {
                throw new ArithmeticException("Maximum number of iterations exceeded");
            }
            dArray11 = derivnFunction.derivn(d5, dArray7);
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray[n2] = d6 * dArray11[n2];
            }
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray10[n2] = dArray7[n2] + dArray[n2] / 4.0;
            }
            dArray11 = derivnFunction.derivn(d5 + d6 / 4.0, dArray10);
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray2[n2] = d6 * dArray11[n2];
            }
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray10[n2] = dArray7[n2] + (3.0 * dArray[n2] + 9.0 * dArray2[n2]) / 32.0;
            }
            dArray11 = derivnFunction.derivn(d5 + 3.0 * d6 / 8.0, dArray10);
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray3[n2] = d6 * dArray11[n2];
            }
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray10[n2] = dArray7[n2] + (1932.0 * dArray[n2] - 7200.0 * dArray2[n2] + 7296.0 * dArray3[n2]) / 2197.0;
            }
            dArray11 = derivnFunction.derivn(d5 + 12.0 * d6 / 13.0, dArray10);
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray4[n2] = d6 * dArray11[n2];
            }
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray10[n2] = dArray7[n2] + 439.0 * dArray[n2] / 216.0 - 8.0 * dArray2[n2] + 3680.0 * dArray3[n2] / 513.0 - 845.0 * dArray4[n2] / 4104.0;
            }
            dArray11 = derivnFunction.derivn(d5 + d6, dArray10);
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray5[n2] = d6 * dArray11[n2];
            }
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray10[n2] = dArray7[n2] - 8.0 * dArray[n2] / 27.0 + 2.0 * dArray2[n2] - 3544.0 * dArray3[n2] / 2565.0 + 1859.0 * dArray4[n2] / 4104.0 - 11.0 * dArray5[n2] / 40.0;
            }
            dArray11 = derivnFunction.derivn(d5 + 0.5 * d6, dArray10);
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray6[n2] = d6 * dArray11[n2];
            }
            d2 = 0.0;
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray9[n2] = dArray7[n2] + 25.0 * dArray[n2] / 216.0 + 1408.0 * dArray3[n2] / 2565.0 + 2197.0 * dArray4[n2] / 4104.0 - dArray5[n2] / 5.0;
                dArray8[n2] = dArray7[n2] + 16.0 * dArray[n2] / 135.0 + 6656.0 * dArray3[n2] / 12825.0 + 28561.0 * dArray4[n2] / 56430.0 - 9.0 * dArray5[n2] / 50.0 + 2.0 * dArray6[n2] / 55.0;
                d = Math.abs(dArray8[n2] - dArray9[n2]);
                d4 = dArray9[n2] * this.relTol + this.absTol;
                d2 = Math.max(d2, d / d4);
            }
            if (d2 <= 1.0) {
                d5 += d6;
                d3 = safetyFactor * Math.pow(d2, incrementFactor);
                if (d3 > 4.0) {
                    d6 *= 4.0;
                } else if (d3 > 1.0) {
                    d6 *= d3;
                }
                if (d5 + d6 > this.xn) {
                    d6 = this.xn - d5;
                }
                dArray7 = DeepCopy.copy(dArray9);
                this.xValues.add(d5);
                this.yValues.add(DeepCopy.copy(dArray7));
                continue;
            }
            d3 = safetyFactor * Math.pow(d2, decrementFactor);
            if (d3 < 0.1) {
                d6 *= 0.1;
                continue;
            }
            d6 *= d3;
        }
        this.nIter = n;
        this.integrationDone = true;
        return dArray7;
    }

    public double[][] fehlberg(DerivnFunction derivnFunction, int n) {
        int n2;
        Object object;
        int n3;
        if (n < 2) {
            throw new IllegalArgumentException("The number of points, " + n + ", must be greater than 1");
        }
        this.enteredDataCheckM();
        this.nPoints = n;
        this.retArray = new double[this.nODE + 1][this.nPoints];
        this.nPset = true;
        this.calcXarray();
        this.initYarray();
        this.fehlberg(derivnFunction);
        int n4 = this.xValues.size();
        double[] dArray = new double[n4];
        double[][] dArray2 = new double[this.nODE][n4];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = this.xValues.get(n3);
            object = this.yValues.get(n3);
            for (n2 = 0; n2 < this.nODE; ++n2) {
                dArray2[n2][n3] = object[n2];
            }
        }
        if (this.xArray[this.nPoints - 1] > dArray[n4 - 1]) {
            this.xArray[this.nPoints - 1] = dArray[n4 - 1];
        }
        for (n3 = 0; n3 < this.nPoints; ++n3) {
            this.retArray[0][n3] = this.xArray[n3];
        }
        for (n3 = 0; n3 < this.nODE; ++n3) {
            object = new CubicSpline(dArray, dArray2[n3]);
            for (n2 = 0; n2 < this.nPoints; ++n2) {
                this.retArray[n3 + 1][n2] = ((CubicSpline)object).interpolate(this.xArray[n2]);
            }
        }
        this.nPoints = 0;
        return this.retArray;
    }

    public double[][] fehlberg(DerivnFunction derivnFunction, double[] dArray) {
        int n;
        Object object;
        int n2;
        int n3;
        this.enteredDataCheckM();
        this.rkMethodNumber = 3;
        this.nPoints = dArray.length;
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        arrayMaths = arrayMaths.sort();
        dArray = arrayMaths.array_as_double();
        if (dArray[0] < this.x0) {
            throw new IllegalArgumentException("Entered points must lie between the previously entered initial and final x values. They may include either or both of these values");
        }
        if (dArray[this.nPoints - 1] > this.xn) {
            throw new IllegalArgumentException("Entered points must lie between the previously entered initial and final x values. They may include either or both of these values");
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (dArray[0] != this.x0) {
            arrayList.add(this.x0);
        }
        for (n3 = 1; n3 < this.nPoints; ++n3) {
            arrayList.add(dArray[n3]);
        }
        if (dArray[this.nPoints - 1] != this.xn) {
            arrayList.add(this.xn);
        }
        this.nPoints = arrayList.size();
        this.xArray = new double[this.nPoints];
        for (n3 = 1; n3 < this.nPoints; ++n3) {
            this.xArray[n3] = (Double)arrayList.get(n3);
        }
        this.nPset = true;
        this.xValues.add(this.x0);
        this.xArraySet = true;
        this.retArray = new double[this.nODE + 1][this.nPoints];
        this.initYarray();
        this.fehlberg(derivnFunction);
        n3 = this.xValues.size();
        double[] dArray2 = new double[n3];
        double[][] dArray3 = new double[this.nODE][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[n2] = this.xValues.get(n2);
            object = this.yValues.get(n2);
            for (n = 0; n < this.nODE; ++n) {
                dArray3[n][n2] = object[n];
            }
        }
        if (this.xArray[this.nPoints - 1] > dArray2[n3 - 1]) {
            this.xArray[this.nPoints - 1] = dArray2[n3 - 1];
        }
        for (n2 = 0; n2 < this.nPoints; ++n2) {
            this.retArray[0][n2] = this.xArray[n2];
        }
        for (n2 = 0; n2 < this.nODE; ++n2) {
            object = new CubicSpline(dArray2, dArray3[n2]);
            for (n = 0; n < this.nPoints; ++n) {
                this.retArray[n2 + 1][n] = ((CubicSpline)object).interpolate(this.xArray[n]);
            }
        }
        this.nPoints = 0;
        return this.retArray;
    }

    public static double[] fehlberg(DerivnFunction derivnFunction, double d, double[] dArray, double d2, double d3, double d4, double d5, int n) {
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d2);
        rungeKutta.setInitialValuesOfY(dArray);
        rungeKutta.setStepSize(d3);
        rungeKutta.setToleranceScalingFactor(d5);
        rungeKutta.setToleranceAdditionFactor(d4);
        rungeKutta.setMaximumIterations(n);
        return rungeKutta.fehlberg(derivnFunction);
    }

    public static double[] fehlberg(DerivnFunction derivnFunction, double d, double[] dArray, double d2, double d3, double d4, double d5) {
        double d6 = (d2 - d) / d3;
        int n = (int)d6 * nStepsMultiplier;
        return RungeKutta.fehlberg(derivnFunction, d, dArray, d2, d3, d4, d5, n);
    }

    public static double[][] fehlberg(DerivnFunction derivnFunction, int n, double d, double[] dArray, double d2, double d3, double d4, double d5, int n2) {
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d2);
        rungeKutta.setInitialValuesOfY(dArray);
        rungeKutta.setStepSize(d3);
        rungeKutta.setToleranceScalingFactor(d5);
        rungeKutta.setToleranceAdditionFactor(d4);
        rungeKutta.setMaximumIterations(n2);
        return rungeKutta.fehlberg(derivnFunction, n);
    }

    public static double[][] fehlberg(DerivnFunction derivnFunction, int n, double d, double[] dArray, double d2, double d3, double d4, double d5) {
        double d6 = (d2 - d) / d3;
        int n2 = (int)d6 * nStepsMultiplier;
        return RungeKutta.fehlberg(derivnFunction, n, d, dArray, d2, d3, d4, d5, n2);
    }

    public static double[][] fehlberg(DerivnFunction derivnFunction, double[] dArray, double d, double[] dArray2, double d2, double d3, double d4, double d5, int n) {
        RungeKutta rungeKutta = new RungeKutta();
        rungeKutta.setInitialValueOfX(d);
        rungeKutta.setFinalValueOfX(d2);
        rungeKutta.setInitialValuesOfY(dArray2);
        rungeKutta.setStepSize(d3);
        rungeKutta.setToleranceScalingFactor(d5);
        rungeKutta.setToleranceAdditionFactor(d4);
        rungeKutta.setMaximumIterations(n);
        return rungeKutta.fehlberg(derivnFunction, dArray);
    }

    public static double[][] fehlberg(DerivnFunction derivnFunction, double[] dArray, double d, double[] dArray2, double d2, double d3, double d4, double d5) {
        double d6 = (d2 - d) / d3;
        int n = (int)d6 * nStepsMultiplier;
        return RungeKutta.fehlberg(derivnFunction, dArray, d, dArray2, d2, d3, d4, d5, n);
    }

    public void plot() {
        if (this.retArray == null) {
            throw new IllegalArgumentException("No multiple points output method has been called");
        }
        PlotGraph plotGraph = new PlotGraph(DeepCopy.copy(this.retArray));
        plotGraph.setXaxisLegend("x values");
        plotGraph.setYaxisLegend("y values");
        plotGraph.setGraphTitle(this.rkMethods[this.rkMethodNumber]);
        plotGraph.plot();
    }

    public void plotSteps() {
        if (!this.integrationDone) {
            throw new IllegalArgumentException("No non-static Runge-Kutta method has been called");
        }
        PlotGraph plotGraph = new PlotGraph(DeepCopy.copy(this.getAllValues()));
        plotGraph.setXaxisLegend("x step values");
        plotGraph.setYaxisLegend("y values");
        plotGraph.setGraphTitle("All steps plot: " + this.rkMethods[this.rkMethodNumber]);
        plotGraph.plot();
    }

    public double[] getXvalueArray() {
        int n = this.xValues.size();
        double[] dArray = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray[j] = this.xValues.get(j);
        }
        return dArray;
    }

    public double[][] getYvalueArray() {
        int n = this.yValues.size();
        double[][] dArray = new double[this.nODE][n];
        double[] dArray2 = new double[this.nODE];
        for (int j = 0; j < n; ++j) {
            dArray2 = this.yValues.get(j);
            for (int k = 0; k < this.nODE; ++k) {
                dArray[k][j] = dArray2[k];
            }
        }
        return dArray;
    }

    public double[][] getAllValues() {
        int n = this.xValues.size();
        double[][] dArray = new double[this.nODE + 1][n];
        for (int j = 0; j < n; ++j) {
            dArray[0][j] = this.xValues.get(j);
        }
        double[] dArray2 = new double[this.nODE];
        for (int j = 0; j < n; ++j) {
            dArray2 = this.yValues.get(j);
            for (int k = 0; k < this.nODE; ++k) {
                dArray[k + 1][j] = dArray2[k];
            }
        }
        return dArray;
    }
}

