/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.interpolation.BiCubicSpline;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import java.util.ArrayList;

public class BiCubicInterpolation {
    private int nPoints = 0;
    private int mPoints = 0;
    private double[] x1 = null;
    private double[] x2 = null;
    private double[][] y = null;
    private double[][] dydx1 = null;
    private double[][] dydx2 = null;
    private double[][] d2ydx1dx2 = null;
    private boolean derivCalculated = false;
    private BiCubicSpline bcs = null;
    private double incrX1 = 0.0;
    private double incrX2 = 0.0;
    private double xx1 = Double.NaN;
    private double xx2 = Double.NaN;
    private ArrayList<Object> coeff = new ArrayList();
    private double[][] weights = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-3.0, 0.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0}, {2.0, 0.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, -3.0, 0.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, 0.0, -1.0}, {0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0}, {-3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0}, {9.0, -9.0, 9.0, -9.0, 6.0, 3.0, -3.0, -6.0, 6.0, -6.0, -3.0, 3.0, 4.0, 2.0, 1.0, 2.0}, {-6.0, 6.0, -6.0, 6.0, -4.0, -2.0, 2.0, 4.0, -3.0, 3.0, 3.0, -3.0, -2.0, -1.0, -1.0, -2.0}, {2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0}, {-6.0, 6.0, -6.0, 6.0, -3.0, -3.0, 3.0, 3.0, -4.0, 4.0, 2.0, -2.0, -2.0, -2.0, -1.0, -1.0}, {4.0, -4.0, 4.0, -4.0, 2.0, 2.0, -2.0, -2.0, 2.0, -2.0, -2.0, 2.0, 1.0, 1.0, 1.0, 1.0}};
    private int[] x1indices = null;
    private int[] x2indices = null;
    private double[] xMin = new double[2];
    private double[] xMax = new double[2];
    private double interpolatedValue = Double.NaN;
    private double interpolatedDydx1 = Double.NaN;
    private double interpolatedDydx2 = Double.NaN;
    private double interpolatedD2ydx1dx2 = Double.NaN;
    private boolean numerDiffFlag = true;
    private static double delta = 0.001;
    private static double potentialRoundingError = 5.0E-15;
    private static boolean roundingCheck = false;

    public BiCubicInterpolation(double[] dArray, double[] dArray2, double[][] dArray3, int n) {
        if (n == 0) {
            this.numerDiffFlag = false;
        } else if (n == 1) {
            this.numerDiffFlag = true;
        } else {
            throw new IllegalArgumentException("The numerical differencing option, " + n + ", must be 0 or 1");
        }
        this.initialize(Conv.copy(dArray), Conv.copy(dArray2), Conv.copy(dArray3));
        this.calcDeriv();
        this.gridCoefficients();
    }

    public BiCubicInterpolation(double[] dArray, double[] dArray2, double[][] dArray3) {
        this.numerDiffFlag = true;
        this.initialize(Conv.copy(dArray), Conv.copy(dArray2), Conv.copy(dArray3));
        this.calcDeriv();
        this.gridCoefficients();
    }

    public BiCubicInterpolation(double[] dArray, double[] dArray2, double[][] dArray3, double[][] dArray4, double[][] dArray5, double[][] dArray6) {
        this.initialize(Conv.copy(dArray), Conv.copy(dArray2), Conv.copy(dArray3), Conv.copy(dArray4), Conv.copy(dArray5), Conv.copy(dArray6));
        this.gridCoefficients();
    }

    private void initialize(double[] dArray, double[] dArray2, double[][] dArray3) {
        this.initialize(dArray, dArray2, dArray3, null, null, null, false);
    }

    private void initialize(double[] dArray, double[] dArray2, double[][] dArray3, double[][] dArray4, double[][] dArray5, double[][] dArray6) {
        this.initialize(dArray, dArray2, dArray3, dArray4, dArray5, dArray6, true);
    }

    private void initialize(double[] dArray, double[] dArray2, double[][] dArray3, double[][] dArray4, double[][] dArray5, double[][] dArray6, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = dArray.length;
        int n6 = dArray2.length;
        if (n5 != dArray3.length) {
            throw new IllegalArgumentException("Arrays x1 and y-row are of different length " + n5 + " " + dArray3.length);
        }
        if (n6 != dArray3[0].length) {
            throw new IllegalArgumentException("Arrays x2 and y-column are of different length " + n6 + " " + dArray3[0].length);
        }
        if (n5 < 2 || n6 < 2) {
            throw new IllegalArgumentException("The data matrix must have a minimum size of 2 X 2");
        }
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        arrayMaths = arrayMaths.sort();
        this.x1indices = arrayMaths.originalIndices();
        dArray = arrayMaths.array();
        double[][] dArray7 = new double[n5][n6];
        double[][] dArray8 = null;
        double[][] dArray9 = null;
        double[][] dArray10 = null;
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                dArray7[n4][n3] = dArray3[this.x1indices[n4]][n3];
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                dArray3[n4][n3] = dArray7[n4][n3];
            }
        }
        if (bl) {
            dArray8 = new double[n5][n6];
            dArray9 = new double[n5][n6];
            dArray10 = new double[n5][n6];
            for (n4 = 0; n4 < n5; ++n4) {
                for (n3 = 0; n3 < n6; ++n3) {
                    dArray8[n4][n3] = dArray4[this.x1indices[n4]][n3];
                    dArray9[n4][n3] = dArray5[this.x1indices[n4]][n3];
                    dArray10[n4][n3] = dArray6[this.x1indices[n4]][n3];
                }
            }
            for (n4 = 0; n4 < n5; ++n4) {
                for (n3 = 0; n3 < n6; ++n3) {
                    dArray4[n4][n3] = dArray8[n4][n3];
                    dArray5[n4][n3] = dArray9[n4][n3];
                    dArray6[n4][n3] = dArray10[n4][n3];
                }
            }
        }
        arrayMaths = new ArrayMaths(dArray2);
        arrayMaths = arrayMaths.sort();
        this.x2indices = arrayMaths.originalIndices();
        double[] dArray11 = arrayMaths.array();
        for (n3 = 0; n3 < n6; ++n3) {
            dArray2[n3] = dArray11[n6 - 1 - n3];
        }
        for (n3 = 0; n3 < n6; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                dArray7[n2][n3] = dArray3[n2][this.x2indices[n3]];
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n6; ++n2) {
                dArray3[n3][n2] = dArray7[n3][n6 - 1 - n2];
            }
        }
        if (bl) {
            for (n3 = 0; n3 < n6; ++n3) {
                for (n2 = 0; n2 < n5; ++n2) {
                    dArray8[n2][n3] = dArray4[n2][this.x2indices[n3]];
                    dArray9[n2][n3] = dArray5[n2][this.x2indices[n3]];
                    dArray10[n2][n3] = dArray6[n2][this.x2indices[n3]];
                }
            }
            for (n3 = 0; n3 < n5; ++n3) {
                for (n2 = 0; n2 < n6; ++n2) {
                    dArray4[n3][n2] = dArray8[n3][n6 - 1 - n2];
                    dArray5[n3][n2] = dArray9[n3][n6 - 1 - n2];
                    dArray6[n3][n2] = dArray10[n3][n6 - 1 - n2];
                }
            }
        }
        for (n3 = 1; n3 < n5; ++n3) {
            if (dArray[n3] != dArray[n3 - 1]) continue;
            System.out.println("x1[" + this.x1indices[n3] + "] and x1[" + this.x1indices[n3 + 1] + "] are identical, " + dArray[n3]);
            System.out.println("The y values have been averaged and one point has been deleted");
            for (n2 = n3; n2 < n5 - 1; ++n2) {
                dArray[n2] = dArray[n2 + 1];
                this.x1indices[n2] = this.x1indices[n2 + 1];
            }
            for (n2 = 0; n2 < n6; ++n2) {
                dArray3[n3 - 1][n2] = (dArray3[n3 - 1][n2] + dArray3[n3][n2]) / 2.0;
                for (n = n3; n < n5 - 1; ++n) {
                    dArray3[n][n2] = dArray3[n + 1][n2];
                }
                if (!bl) continue;
                dArray4[n3 - 1][n2] = (dArray4[n3 - 1][n2] + dArray4[n3][n2]) / 2.0;
                dArray5[n3 - 1][n2] = (dArray5[n3 - 1][n2] + dArray5[n3][n2]) / 2.0;
                dArray6[n3 - 1][n2] = (dArray6[n3 - 1][n2] + dArray6[n3][n2]) / 2.0;
                for (n = n3; n < n5 - 1; ++n) {
                    dArray4[n][n2] = dArray4[n + 1][n2];
                    dArray5[n][n2] = dArray5[n + 1][n2];
                    dArray6[n][n2] = dArray6[n + 1][n2];
                }
            }
            --n5;
        }
        for (n3 = 1; n3 < n6; ++n3) {
            if (dArray2[n3] != dArray2[n3 - 1]) continue;
            System.out.println("x2[" + this.x2indices[n3] + "] and x2[" + this.x2indices[n3] + "] are identical, " + dArray2[n3]);
            System.out.println("The y values have been averaged and one point has been deleted");
            for (n2 = n3; n2 < n6 - 1; ++n2) {
                dArray2[n2] = dArray2[n2 + 1];
                this.x2indices[n2] = this.x2indices[n2 + 1];
            }
            for (n2 = 0; n2 < n5; ++n2) {
                dArray3[n2][n3 - 1] = (dArray3[n2][n3 - 1] + dArray3[n2][n3]) / 2.0;
                for (n = n3; n < n6 - 1; ++n) {
                    dArray3[n2][n] = dArray3[n2][n + 1];
                }
                if (!bl) continue;
                dArray4[n2][n3 - 1] = (dArray4[n2][n3 - 1] + dArray4[n2][n3]) / 2.0;
                dArray5[n2][n3 - 1] = (dArray5[n2][n3 - 1] + dArray5[n2][n3]) / 2.0;
                dArray6[n2][n3 - 1] = (dArray6[n2][n3 - 1] + dArray6[n2][n3]) / 2.0;
                for (n = n3; n < n5 - 1; ++n) {
                    dArray4[n2][n] = dArray4[n2][n + 1];
                    dArray5[n2][n] = dArray5[n2][n + 1];
                    dArray6[n2][n] = dArray6[n2][n + 1];
                }
            }
            --n6;
        }
        this.nPoints = n5;
        this.mPoints = n6;
        this.x1 = new double[this.nPoints];
        this.x2 = new double[this.mPoints];
        this.y = new double[this.nPoints][this.mPoints];
        this.dydx1 = new double[this.nPoints][this.mPoints];
        this.dydx2 = new double[this.nPoints][this.mPoints];
        this.d2ydx1dx2 = new double[this.nPoints][this.mPoints];
        for (n3 = 0; n3 < this.nPoints; ++n3) {
            this.x1[n3] = dArray[n3];
        }
        for (n3 = 0; n3 < this.mPoints; ++n3) {
            this.x2[n3] = dArray2[n3];
        }
        for (n3 = 0; n3 < this.nPoints; ++n3) {
            for (n2 = 0; n2 < this.mPoints; ++n2) {
                this.y[n3][n2] = dArray3[n3][n2];
            }
            if (!bl) continue;
            for (n2 = 0; n2 < this.mPoints; ++n2) {
                this.dydx1[n3][n2] = dArray4[n3][n2];
                this.dydx2[n3][n2] = dArray5[n3][n2];
                this.d2ydx1dx2[n3][n2] = dArray6[n3][n2];
            }
        }
        if (bl) {
            this.derivCalculated = true;
        }
        this.xMin[0] = Fmath.minimum(this.x1);
        this.xMax[0] = Fmath.maximum(this.x1);
        this.xMin[1] = Fmath.minimum(this.x2);
        this.xMax[1] = Fmath.maximum(this.x2);
        if (!bl && this.numerDiffFlag) {
            double d;
            double d2 = this.xMax[0] - this.xMin[0];
            double d3 = this.xMax[1] - this.xMin[1];
            double d4 = d2 / (double)this.nPoints;
            double d5 = d3 / (double)this.mPoints;
            double d6 = d = this.x1[1] - this.x1[0];
            for (int j = 2; j < this.nPoints; ++j) {
                d = this.x1[j] - this.x1[j - 1];
                if (!(d < d6)) continue;
                d6 = d;
            }
            double d7 = d = this.x2[1] - this.x2[0];
            for (int j = 2; j < this.mPoints; ++j) {
                d = this.x2[j] - this.x2[j - 1];
                if (!(d < d7)) continue;
                d7 = d;
            }
            this.incrX1 = d2 * delta;
            double d8 = d6;
            if (d6 < d4 / 10.0) {
                d8 = d4 / 10.0;
            }
            if (this.incrX1 > d4) {
                this.incrX1 = d8;
            }
            this.incrX2 = d3 * delta;
            d8 = d7;
            if (d7 < d5 / 10.0) {
                d8 = d5 / 10.0;
            }
            if (this.incrX2 > d5) {
                this.incrX2 = d8;
            }
        }
    }

    private void calcDeriv() {
        if (this.numerDiffFlag) {
            int n;
            this.bcs = new BiCubicSpline(this.x1, this.x2, this.y);
            double d = 0.0;
            double d2 = 0.0;
            double[] dArray = new double[this.nPoints];
            double[] dArray2 = new double[this.nPoints];
            double[] dArray3 = new double[this.mPoints];
            double[] dArray4 = new double[this.mPoints];
            for (n = 0; n < this.nPoints; ++n) {
                dArray[n] = this.x1[n] + this.incrX1;
                if (dArray[n] > this.x1[this.nPoints - 1]) {
                    dArray[n] = this.x1[this.nPoints - 1];
                }
                dArray2[n] = this.x1[n] - this.incrX1;
                if (!(dArray2[n] < this.x1[0])) continue;
                dArray2[n] = this.x1[0];
            }
            for (n = 0; n < this.mPoints; ++n) {
                dArray3[n] = this.x2[n] + this.incrX2;
                if (dArray3[n] > this.x2[0]) {
                    dArray3[n] = this.x2[0];
                }
                dArray4[n] = this.x2[n] - this.incrX2;
                if (!(dArray4[n] < this.x2[this.mPoints - 1])) continue;
                dArray4[n] = this.x2[this.mPoints - 1];
            }
            for (n = 0; n < this.nPoints; ++n) {
                for (int j = 0; j < this.mPoints; ++j) {
                    this.dydx1[n][j] = (this.bcs.interpolate(dArray[n], this.x2[j]) - this.bcs.interpolate(dArray2[n], this.x2[j])) / (dArray[n] - dArray2[n]);
                    this.dydx2[n][j] = (this.bcs.interpolate(this.x1[n], dArray3[j]) - this.bcs.interpolate(this.x1[n], dArray4[j])) / (dArray3[j] - dArray4[j]);
                    this.d2ydx1dx2[n][j] = (this.bcs.interpolate(dArray[n], dArray3[j]) - this.bcs.interpolate(dArray[n], dArray4[j]) - this.bcs.interpolate(dArray2[n], dArray3[j]) + this.bcs.interpolate(dArray2[n], dArray4[j])) / ((dArray[n] - dArray2[n]) * (dArray3[j] - dArray4[j]));
                }
            }
        } else {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (int j = 0; j < this.nPoints; ++j) {
                n = j + 1;
                if (n >= this.nPoints) {
                    n = this.nPoints - 1;
                }
                if ((n2 = j - 1) < 0) {
                    n2 = 0;
                }
                for (int k = 0; k < this.mPoints; ++k) {
                    n3 = k + 1;
                    if (n3 >= this.mPoints) {
                        n3 = this.mPoints - 1;
                    }
                    if ((n4 = k - 1) < 0) {
                        n4 = 0;
                    }
                    this.dydx1[j][k] = (this.y[n][k] - this.y[n2][k]) / (this.x1[n] - this.x1[n2]);
                    this.dydx2[j][k] = (this.y[j][n3] - this.y[j][n4]) / (this.x2[n3] - this.x2[n4]);
                    this.d2ydx1dx2[j][k] = (this.y[n][n3] - this.y[n][n4] - this.y[n2][n3] + this.y[n2][n4]) / ((this.x1[n] - this.x1[n2]) * (this.x2[n3] - this.x2[n4]));
                }
            }
        }
        this.derivCalculated = true;
    }

    private void gridCoefficients() {
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        double[] dArray3 = new double[4];
        double[] dArray4 = new double[4];
        double[] dArray5 = new double[16];
        double[] dArray6 = new double[16];
        double d = 0.0;
        double d2 = 0.0;
        for (int j = 0; j < this.nPoints - 1; ++j) {
            d = this.x1[j + 1] - this.x1[j];
            for (int k = 0; k < this.mPoints - 1; ++k) {
                int n;
                int n2;
                double[][] dArray7 = new double[4][4];
                d2 = this.x2[k] - this.x2[k + 1];
                this.coeff.add(new Double(d));
                this.coeff.add(new Double(this.x1[j]));
                this.coeff.add(new Double(d2));
                this.coeff.add(new Double(this.x2[k + 1]));
                dArray[0] = this.y[j][k + 1];
                dArray2[0] = this.dydx1[j][k + 1];
                dArray3[0] = this.dydx2[j][k + 1];
                dArray4[0] = this.d2ydx1dx2[j][k + 1];
                dArray[1] = this.y[j + 1][k + 1];
                dArray2[1] = this.dydx1[j + 1][k + 1];
                dArray3[1] = this.dydx2[j + 1][k + 1];
                dArray4[1] = this.d2ydx1dx2[j + 1][k + 1];
                dArray[2] = this.y[j + 1][k];
                dArray2[2] = this.dydx1[j + 1][k];
                dArray3[2] = this.dydx2[j + 1][k];
                dArray4[2] = this.d2ydx1dx2[j + 1][k];
                dArray[3] = this.y[j][k];
                dArray2[3] = this.dydx1[j][k];
                dArray3[3] = this.dydx2[j][k];
                dArray4[3] = this.d2ydx1dx2[j][k];
                for (int i2 = 0; i2 < 4; ++i2) {
                    dArray6[i2] = dArray[i2];
                    dArray6[i2 + 4] = dArray2[i2] * d;
                    dArray6[i2 + 8] = dArray3[i2] * d2;
                    dArray6[i2 + 12] = dArray4[i2] * d * d2;
                }
                double d3 = 0.0;
                for (n2 = 0; n2 < 16; ++n2) {
                    for (n = 0; n < 16; ++n) {
                        d3 += this.weights[n2][n] * dArray6[n];
                    }
                    dArray5[n2] = d3;
                    d3 = 0.0;
                }
                n2 = 0;
                for (n = 0; n < 4; ++n) {
                    for (int i3 = 0; i3 < 4; ++i3) {
                        dArray7[n][i3] = dArray5[n2++];
                    }
                }
                this.coeff.add(dArray7);
            }
        }
    }

    public double interpolate(double d, double d2) {
        int n;
        int n2;
        if (d < this.x1[0]) {
            if (d >= this.x1[0] - potentialRoundingError) {
                d = this.x1[0];
            } else {
                throw new IllegalArgumentException(d + " is outside the limits, " + this.x1[0] + " - " + this.x1[this.nPoints - 1]);
            }
        }
        if (d2 < this.x2[this.mPoints - 1]) {
            if (d2 > this.x2[this.mPoints - 1] - potentialRoundingError) {
                d2 = this.x2[this.mPoints - 1];
            } else {
                throw new IllegalArgumentException(d2 + " is outside the limits, " + this.x2[this.mPoints - 1] + " - " + this.x2[0]);
            }
        }
        if (d > this.x1[this.nPoints - 1]) {
            if (d <= this.x1[this.nPoints - 1] + potentialRoundingError) {
                d = this.x1[this.nPoints - 1];
            } else {
                throw new IllegalArgumentException(d + " is outside the limits, " + this.x1[0] + " - " + this.x1[this.nPoints - 1]);
            }
        }
        if (d2 > this.x2[0]) {
            if (d2 <= this.x2[0] + potentialRoundingError) {
                d2 = this.x2[0];
            } else {
                throw new IllegalArgumentException(d2 + " is outside the limits, " + this.x2[this.nPoints - 1] + " - " + this.x2[0]);
            }
        }
        this.xx1 = d;
        this.xx2 = d2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        boolean bl = true;
        while (bl) {
            if (d < this.x1[n5]) {
                n3 = n5 - 1;
                bl = false;
                continue;
            }
            if (++n5 < this.nPoints) continue;
            n3 = this.nPoints - 2;
            bl = false;
        }
        n5 = 0;
        bl = true;
        while (bl) {
            if (d2 >= this.x2[n5 + 1] && d2 <= this.x2[n5]) {
                n4 = n5;
                bl = false;
                continue;
            }
            ++n5;
        }
        int n6 = n3 * (this.mPoints - 1) + n4;
        double d3 = (Double)this.coeff.get(5 * n6);
        double d4 = (Double)this.coeff.get(5 * n6 + 1);
        double d5 = (Double)this.coeff.get(5 * n6 + 2);
        double d6 = (Double)this.coeff.get(5 * n6 + 3);
        double[][] dArray = (double[][])this.coeff.get(5 * n6 + 4);
        double d7 = (d - d4) / d3;
        double d8 = (d2 - d6) / d5;
        this.interpolatedValue = 0.0;
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 4; ++n) {
                this.interpolatedValue += dArray[n2][n] * Math.pow(d7, n2) * Math.pow(d8, n);
            }
        }
        this.interpolatedDydx1 = 0.0;
        for (n2 = 1; n2 < 4; ++n2) {
            for (n = 0; n < 4; ++n) {
                this.interpolatedDydx1 += (double)n2 * dArray[n2][n] * Math.pow(d7, n2 - 1) * Math.pow(d8, n);
            }
        }
        this.interpolatedDydx2 = 0.0;
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 1; n < 4; ++n) {
                this.interpolatedDydx2 += (double)n * dArray[n2][n] * Math.pow(d7, n2) * Math.pow(d8, n - 1);
            }
        }
        this.interpolatedD2ydx1dx2 = 0.0;
        for (n2 = 1; n2 < 4; ++n2) {
            for (n = 1; n < 4; ++n) {
                this.interpolatedD2ydx1dx2 += (double)(n2 * n) * dArray[n2][n] * Math.pow(d7, n2 - 1) * Math.pow(d8, n - 1);
            }
        }
        return this.interpolatedValue;
    }

    public double[] getInterpolatedValues() {
        double[] dArray = new double[]{this.interpolatedValue, this.interpolatedDydx1, this.interpolatedDydx2, this.interpolatedD2ydx1dx2, this.xx1, this.xx2};
        return dArray;
    }

    public double[][] getGridDydx1() {
        double[][] dArray = new double[this.nPoints][this.mPoints];
        for (int j = 0; j < this.nPoints; ++j) {
            for (int k = 0; k < this.mPoints; ++k) {
                dArray[this.x1indices[j]][this.x2indices[k]] = this.dydx1[j][k];
            }
        }
        return dArray;
    }

    public double[][] getGridDydx2() {
        double[][] dArray = new double[this.nPoints][this.mPoints];
        for (int j = 0; j < this.nPoints; ++j) {
            for (int k = 0; k < this.mPoints; ++k) {
                dArray[this.x1indices[j]][this.x2indices[k]] = this.dydx2[j][k];
            }
        }
        return dArray;
    }

    public double[][] getGridD2ydx1dx2() {
        double[][] dArray = new double[this.nPoints][this.mPoints];
        for (int j = 0; j < this.nPoints; ++j) {
            for (int k = 0; k < this.mPoints; ++k) {
                dArray[this.x1indices[j]][this.x2indices[k]] = this.d2ydx1dx2[j][k];
            }
        }
        return dArray;
    }

    public static void resetDelta(double d) {
        delta = d;
    }

    public static void noRoundingErrorCheck() {
        roundingCheck = false;
        potentialRoundingError = 0.0;
    }

    public static void potentialRoundingError(double d) {
        potentialRoundingError = d;
    }

    public double[] getXmin() {
        return this.xMin;
    }

    public double[] getXmax() {
        return this.xMax;
    }

    public double[] getLimits() {
        double[] dArray = new double[]{this.xMin[0], this.xMax[0], this.xMin[1], this.xMax[1]};
        return dArray;
    }

    public void displayLimits() {
        System.out.println(" ");
        for (int j = 0; j < 2; ++j) {
            System.out.println("The limits to the x array " + j + " are " + this.xMin[j] + " and " + this.xMax[j]);
        }
        System.out.println(" ");
    }
}

