/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

public class CubicSplineShort {
    private int nPoints = 0;
    private double[] y = null;
    private double[] x = null;
    private double[] d2ydx2 = null;
    private boolean derivCalculated = false;

    public CubicSplineShort(double[] dArray, double[] dArray2) {
        this.nPoints = dArray.length;
        this.x = new double[this.nPoints];
        this.y = new double[this.nPoints];
        this.d2ydx2 = new double[this.nPoints];
        for (int j = 0; j < this.nPoints; ++j) {
            this.x[j] = dArray[j];
            this.y[j] = dArray2[j];
        }
        this.calcDeriv();
    }

    public CubicSplineShort(int n) {
        this.nPoints = n;
        this.x = new double[n];
        this.y = new double[n];
        this.d2ydx2 = new double[n];
    }

    public void resetData(double[] dArray, double[] dArray2) {
        for (int j = 0; j < this.nPoints; ++j) {
            this.x[j] = dArray[j];
            this.y[j] = dArray2[j];
        }
        this.calcDeriv();
    }

    public static CubicSplineShort zero(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("A minimum of three data points is needed");
        }
        CubicSplineShort cubicSplineShort = new CubicSplineShort(n);
        return cubicSplineShort;
    }

    public static CubicSplineShort[] oneDarray(int n, int n2) {
        CubicSplineShort[] cubicSplineShortArray = new CubicSplineShort[n];
        for (int j = 0; j < n; ++j) {
            cubicSplineShortArray[j] = CubicSplineShort.zero(n2);
        }
        return cubicSplineShortArray;
    }

    public void calcDeriv() {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray = new double[this.nPoints];
        dArray[0] = 0.0;
        this.d2ydx2[0] = 0.0;
        for (n = 1; n <= this.nPoints - 2; ++n) {
            d3 = (this.x[n] - this.x[n - 1]) / (this.x[n + 1] - this.x[n - 1]);
            d = d3 * this.d2ydx2[n - 1] + 2.0;
            this.d2ydx2[n] = (d3 - 1.0) / d;
            dArray[n] = (this.y[n + 1] - this.y[n]) / (this.x[n + 1] - this.x[n]) - (this.y[n] - this.y[n - 1]) / (this.x[n] - this.x[n - 1]);
            dArray[n] = (6.0 * dArray[n] / (this.x[n + 1] - this.x[n - 1]) - d3 * dArray[n - 1]) / d;
        }
        d4 = 0.0;
        d2 = 0.0;
        this.d2ydx2[this.nPoints - 1] = (d4 - d2 * dArray[this.nPoints - 2]) / (d2 * this.d2ydx2[this.nPoints - 2] + 1.0);
        for (n = this.nPoints - 2; n >= 0; --n) {
            this.d2ydx2[n] = this.d2ydx2[n] * this.d2ydx2[n + 1] + dArray[n];
        }
        this.derivCalculated = true;
    }

    public double interpolate(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = this.nPoints - 1;
        while (n3 - n2 > 1) {
            n = n3 + n2 >> 1;
            if (this.x[n] > d) {
                n3 = n;
                continue;
            }
            n2 = n;
        }
        d2 = this.x[n3] - this.x[n2];
        if (d2 == 0.0) {
            throw new IllegalArgumentException("Two values of x are identical: point " + n2 + " (" + this.x[n2] + ") and point " + n3 + " (" + this.x[n3] + ")");
        }
        d4 = (this.x[n3] - d) / d2;
        d3 = (d - this.x[n2]) / d2;
        d5 = d4 * this.y[n2] + d3 * this.y[n3] + ((d4 * d4 * d4 - d4) * this.d2ydx2[n2] + (d3 * d3 * d3 - d3) * this.d2ydx2[n3]) * (d2 * d2) / 6.0;
        return d5;
    }
}

