/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.math.Conv;
import flanagan.math.Fmath;

public class LinearInterpolation {
    private int nPoints = 0;
    private int nPointsOriginal = 0;
    private double[] y = null;
    private double[] x = null;
    private double yy = Double.NaN;
    private double dydx = Double.NaN;
    private int[] newAndOldIndices;
    private double xMin = Double.NaN;
    private double xMax = Double.NaN;
    private double range = Double.NaN;
    private boolean checkPoints = false;
    private static boolean supress = false;
    private static boolean averageIdenticalAbscissae = false;
    private static double potentialRoundingError = 5.0E-15;
    private static boolean roundingCheck = true;

    public LinearInterpolation(double[] dArray, double[] dArray2) {
        this.nPointsOriginal = this.nPoints = dArray.length;
        if (this.nPoints != dArray2.length) {
            throw new IllegalArgumentException("Arrays x and y are of different length " + this.nPoints + " " + dArray2.length);
        }
        if (this.nPoints < 3) {
            throw new IllegalArgumentException("A minimum of three data points is needed");
        }
        this.x = new double[this.nPoints];
        this.y = new double[this.nPoints];
        for (int j = 0; j < this.nPoints; ++j) {
            this.x[j] = dArray[j];
            this.y[j] = dArray2[j];
        }
        this.orderPoints();
        this.checkForIdenticalPoints();
    }

    public static void noRoundingErrorCheck() {
        roundingCheck = false;
    }

    public static void potentialRoundingError(double d) {
        potentialRoundingError = d;
    }

    public static void averageIdenticalAbscissae() {
        averageIdenticalAbscissae = true;
    }

    public void orderPoints() {
        double[] dArray = new double[this.nPoints];
        this.newAndOldIndices = new int[this.nPoints];
        Fmath.selectionSort(this.x, dArray, this.newAndOldIndices);
        Fmath.selectionSort(this.x, this.y, this.x, this.y);
        this.xMin = Fmath.minimum(this.x);
        this.xMax = Fmath.maximum(this.x);
        this.range = this.xMax - this.xMin;
    }

    public double getXmax() {
        return this.xMax;
    }

    public double getXmin() {
        return this.xMin;
    }

    public double[] getLimits() {
        double[] dArray = new double[]{this.xMin, this.xMax};
        return dArray;
    }

    public void displayLimits() {
        System.out.println("\nThe limits of the abscissae (x-values) are " + this.xMin + " and " + this.xMax + "\n");
    }

    public void checkForIdenticalPoints() {
        int n = this.nPoints;
        boolean bl = true;
        int n2 = 0;
        while (bl) {
            boolean bl2 = true;
            int n3 = n2 + 1;
            while (bl2) {
                if (this.x[n2] == this.x[n3]) {
                    int n4;
                    double[] dArray;
                    if (this.y[n2] == this.y[n3]) {
                        if (!supress) {
                            System.out.print("LinearInterpolation: Two identical points, " + this.x[n2] + ", " + this.y[n2]);
                            System.out.println(", in data array at indices " + this.newAndOldIndices[n2] + " and " + this.newAndOldIndices[n3] + ", latter point removed");
                        }
                        double[] dArray2 = new double[this.nPoints - 1];
                        dArray = new double[this.nPoints - 1];
                        int[] nArray = new int[this.nPoints - 1];
                        for (n4 = 0; n4 < n3; ++n4) {
                            dArray2[n4] = this.x[n4];
                            dArray[n4] = this.y[n4];
                            nArray[n4] = this.newAndOldIndices[n4];
                        }
                        for (n4 = n3; n4 < this.nPoints - 1; ++n4) {
                            dArray2[n4] = this.x[n4 + 1];
                            dArray[n4] = this.y[n4 + 1];
                            nArray[n4] = this.newAndOldIndices[n4 + 1];
                        }
                        --this.nPoints;
                        this.x = Conv.copy(dArray2);
                        this.y = Conv.copy(dArray);
                        this.newAndOldIndices = Conv.copy(nArray);
                    } else if (averageIdenticalAbscissae) {
                        if (!supress) {
                            System.out.print("LinearInterpolation: Two identical points on the absicca (x-axis) with different ordinate (y-axis) values, " + this.x[n2] + ": " + this.y[n2] + ", " + this.y[n3]);
                            System.out.println(", average of the ordinates taken");
                        }
                        this.y[n2] = (this.y[n2] + this.y[n3]) / 2.0;
                        double[] dArray3 = new double[this.nPoints - 1];
                        dArray = new double[this.nPoints - 1];
                        int[] nArray = new int[this.nPoints - 1];
                        for (n4 = 0; n4 < n3; ++n4) {
                            dArray3[n4] = this.x[n4];
                            dArray[n4] = this.y[n4];
                            nArray[n4] = this.newAndOldIndices[n4];
                        }
                        for (n4 = n3; n4 < this.nPoints - 1; ++n4) {
                            dArray3[n4] = this.x[n4 + 1];
                            dArray[n4] = this.y[n4 + 1];
                            nArray[n4] = this.newAndOldIndices[n4 + 1];
                        }
                        --this.nPoints;
                        this.x = Conv.copy(dArray3);
                        this.y = Conv.copy(dArray);
                        this.newAndOldIndices = Conv.copy(nArray);
                    } else {
                        double d = this.range * 5.0E-4;
                        if (!supress) {
                            System.out.print("LinearInterpolation: Two identical points on the absicca (x-axis) with different ordinate (y-axis) values, " + this.x[n2] + ": " + this.y[n2] + ", " + this.y[n3]);
                        }
                        boolean bl3 = false;
                        if (n2 == 0) {
                            if (this.x[2] - this.x[1] <= d) {
                                d = (this.x[2] - this.x[1]) / 2.0;
                            }
                            bl3 = this.y[0] > this.y[1] ? (this.y[1] > this.y[2] ? this.stay(n2, n3, d) : this.swap(n2, n3, d)) : (this.y[2] <= this.y[1] ? this.swap(n2, n3, d) : this.stay(n2, n3, d));
                        }
                        if (n3 == this.nPoints - 1) {
                            if (this.x[n - 2] - this.x[n - 3] <= d) {
                                d = (this.x[n - 2] - this.x[n - 3]) / 2.0;
                            }
                            bl3 = this.y[n2] <= this.y[n3] ? (this.y[n2 - 1] <= this.y[n2] ? this.stay(n2, n3, d) : this.swap(n2, n3, d)) : (this.y[n2 - 1] <= this.y[n2] ? this.swap(n2, n3, d) : this.stay(n2, n3, d));
                        }
                        if (n2 != 0 && n3 != this.nPoints - 1) {
                            if (this.x[n2] - this.x[n2 - 1] <= d) {
                                d = (this.x[n2] - this.x[n2 - 1]) / 2.0;
                            }
                            if (this.x[n3 + 1] - this.x[n3] <= d) {
                                d = (this.x[n3 + 1] - this.x[n3]) / 2.0;
                            }
                            if (this.y[n2] > this.y[n2 - 1]) {
                                if (this.y[n3] > this.y[n2]) {
                                    bl3 = this.y[n3] > this.y[n3 + 1] ? (this.y[n2 - 1] <= this.y[n3 + 1] ? this.stay(n2, n3, d) : this.swap(n2, n3, d)) : this.stay(n2, n3, d);
                                } else if (this.y[n3 + 1] > this.y[n3]) {
                                    if (this.y[n3 + 1] > this.y[n2 - 1] && this.y[n3 + 1] > this.y[n2 - 1]) {
                                        bl3 = this.stay(n2, n3, d);
                                    }
                                } else {
                                    bl3 = this.swap(n2, n3, d);
                                }
                            } else if (this.y[n3] > this.y[n2]) {
                                if (this.y[n3 + 1] > this.y[n3]) {
                                    bl3 = this.stay(n2, n3, d);
                                }
                            } else {
                                bl3 = this.y[n3 + 1] > this.y[n2 - 1] ? this.stay(n2, n3, d) : this.swap(n2, n3, d);
                            }
                        }
                        if (!bl3) {
                            bl3 = this.stay(n2, n3, d);
                        }
                        if (!supress) {
                            System.out.println(", the two abscissae have been separated by a distance " + d);
                        }
                        ++n3;
                    }
                    if (this.nPoints - 1 == n2) {
                        bl2 = false;
                    }
                } else {
                    ++n3;
                }
                if (n3 < this.nPoints) continue;
                bl2 = false;
            }
            if (++n2 < this.nPoints - 1) continue;
            bl = false;
        }
        if (this.nPoints < 3) {
            throw new IllegalArgumentException("Removal of duplicate points has reduced the number of points to less than the required minimum of three data points");
        }
        this.checkPoints = true;
    }

    private boolean swap(int n, int n2, double d) {
        int n3 = n;
        this.x[n3] = this.x[n3] + d;
        int n4 = n2;
        this.x[n4] = this.x[n4] - d;
        double d2 = this.x[n];
        this.x[n] = this.x[n2];
        this.x[n2] = d2;
        d2 = this.y[n];
        this.y[n] = this.y[n2];
        this.y[n2] = d2;
        return true;
    }

    private boolean stay(int n, int n2, double d) {
        int n3 = n;
        this.x[n3] = this.x[n3] - d;
        int n4 = n2;
        this.x[n4] = this.x[n4] + d;
        return true;
    }

    public static void supress() {
        supress = true;
    }

    public static void unsupress() {
        supress = false;
    }

    public double interpolate(double d) {
        int n;
        if (d < this.x[0]) {
            if (roundingCheck && Math.abs(this.x[0] - d) <= Math.pow(10.0, Math.floor(Math.log10(Math.abs(this.x[0])))) * potentialRoundingError) {
                d = this.x[0];
            } else {
                throw new IllegalArgumentException("x (" + d + ") is outside the range of data points (" + this.x[0] + " to " + this.x[this.nPoints - 1] + ")");
            }
        }
        if (d > this.x[this.nPoints - 1]) {
            if (roundingCheck && Math.abs(d - this.x[this.nPoints - 1]) <= Math.pow(10.0, Math.floor(Math.log10(Math.abs(this.x[this.nPoints - 1])))) * potentialRoundingError) {
                d = this.x[this.nPoints - 1];
            } else {
                throw new IllegalArgumentException("x (" + d + ") is outside the range of data points (" + this.x[0] + " to " + this.x[this.nPoints - 1] + ")");
            }
        }
        boolean bl = true;
        for (n = 0; n < this.nPoints; ++n) {
            if (d == this.x[n]) {
                this.yy = this.y[n];
                bl = false;
            }
            if (!bl) break;
        }
        if (bl) {
            for (n = 1; n < this.nPoints; ++n) {
                if (d < this.x[n]) {
                    this.yy = this.y[n] - (this.y[n] - this.y[n - 1]) * (this.x[n] - d) / (this.x[n] - this.x[n - 1]);
                    bl = false;
                }
                if (!bl) break;
            }
        }
        return this.yy;
    }
}

