/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.interpolation.BiCubicSpline;
import flanagan.interpolation.CubicSpline;
import flanagan.interpolation.QuadriCubicSpline;
import flanagan.interpolation.TriCubicSpline;
import flanagan.math.Fmath;
import java.lang.reflect.Array;

public class PolyCubicSpline {
    private int nDimensions = 0;
    private Object fOfX = null;
    private Object internalDeriv = null;
    private Object xArrays = null;
    private Object method = null;
    private double[][] xArray = null;
    private double[] csArray = null;
    private PolyCubicSpline[] pcs = null;
    private int dimOne = 0;
    private double yValue = 0.0;
    private double[] xMin = null;
    private double[] xMax = null;
    private boolean calculationDone = false;
    private boolean averageIdenticalAbscissae = false;
    private static double potentialRoundingError = 5.0E-15;
    private static boolean roundingCheck = true;

    public PolyCubicSpline(Object object, Object object2) {
        Object object3;
        this.fOfX = Fmath.copyObject(object2);
        this.xArrays = Fmath.copyObject(object);
        Object object4 = Fmath.copyObject(object2);
        this.nDimensions = 1;
        while (!((object4 = Array.get(object4, 0)) instanceof Double)) {
            ++this.nDimensions;
        }
        if (this.xArrays instanceof double[] && this.nDimensions == 1) {
            object3 = new double[][]{(double[])this.xArrays};
            this.xArrays = object3;
        } else if (!(this.xArrays instanceof double[][])) {
            throw new IllegalArgumentException("xArrays should be a two dimensional array of doubles");
        }
        this.xArray = (double[][])this.xArrays;
        this.limits();
        switch (this.nDimensions) {
            case 0: {
                throw new IllegalArgumentException("data array must have at least one dimension");
            }
            case 1: {
                object3 = new CubicSpline(this.xArray[0], (double[])this.fOfX);
                if (this.averageIdenticalAbscissae) {
                    CubicSpline.averageIdenticalAbscissae();
                }
                this.internalDeriv = object3.getDeriv();
                this.method = object3;
                this.calculationDone = true;
                break;
            }
            case 2: {
                BiCubicSpline biCubicSpline = new BiCubicSpline(this.xArray[0], this.xArray[1], (double[][])this.fOfX);
                if (this.averageIdenticalAbscissae) {
                    biCubicSpline.averageIdenticalAbscissae();
                }
                this.internalDeriv = biCubicSpline.getDeriv();
                this.method = biCubicSpline;
                this.calculationDone = true;
                break;
            }
            case 3: {
                TriCubicSpline triCubicSpline = new TriCubicSpline(this.xArray[0], this.xArray[1], this.xArray[2], (double[][][])this.fOfX);
                if (this.averageIdenticalAbscissae) {
                    triCubicSpline.averageIdenticalAbscissae();
                }
                this.internalDeriv = triCubicSpline.getDeriv();
                this.method = triCubicSpline;
                this.calculationDone = true;
                break;
            }
            case 4: {
                QuadriCubicSpline quadriCubicSpline = new QuadriCubicSpline(this.xArray[0], this.xArray[1], this.xArray[2], this.xArray[3], (double[][][][])this.fOfX);
                if (this.averageIdenticalAbscissae) {
                    quadriCubicSpline.averageIdenticalAbscissae();
                }
                this.internalDeriv = quadriCubicSpline.getDeriv();
                this.method = quadriCubicSpline;
                this.calculationDone = true;
                break;
            }
            default: {
                Object object5 = object2;
                this.dimOne = Array.getLength(object5);
                this.csArray = new double[this.dimOne];
                double[][] dArrayArray = new double[this.nDimensions - 1][];
                for (int j = 0; j < this.nDimensions - 1; ++j) {
                    dArrayArray[j] = this.xArray[j + 1];
                }
                Object[] objectArray = new Object[this.dimOne];
                if (this.calculationDone) {
                    objectArray = (Object[])this.internalDeriv;
                }
                this.pcs = new PolyCubicSpline[this.dimOne];
                for (int j = 0; j < this.dimOne; ++j) {
                    Object object6 = Array.get(object5, j);
                    this.pcs[j] = new PolyCubicSpline(dArrayArray, object6);
                    if (this.averageIdenticalAbscissae) {
                        this.pcs[j].averageIdenticalAbscissae();
                    }
                    if (this.calculationDone) {
                        this.pcs[j].setDeriv(objectArray[j]);
                    }
                    if (this.calculationDone) continue;
                    objectArray[j] = this.pcs[j].getDeriv();
                }
                this.internalDeriv = objectArray;
                this.calculationDone = true;
            }
        }
    }

    public static void noRoundingErrorCheck() {
        roundingCheck = false;
        QuadriCubicSpline.noRoundingErrorCheck();
        TriCubicSpline.noRoundingErrorCheck();
        BiCubicSpline.noRoundingErrorCheck();
        CubicSpline.noRoundingErrorCheck();
    }

    public static void potentialRoundingError(double d) {
        potentialRoundingError = d;
        QuadriCubicSpline.potentialRoundingError(d);
        TriCubicSpline.potentialRoundingError(d);
        BiCubicSpline.potentialRoundingError(d);
        CubicSpline.potentialRoundingError(d);
    }

    private void limits() {
        this.xMin = new double[this.nDimensions];
        this.xMax = new double[this.nDimensions];
        for (int j = 0; j < this.nDimensions; ++j) {
            this.xMin[j] = Fmath.minimum(this.xArray[j]);
            this.xMax[j] = Fmath.maximum(this.xArray[j]);
        }
    }

    public double[] getXmin() {
        return this.xMin;
    }

    public double[] getXmax() {
        return this.xMax;
    }

    public int getNumberOfDimensions() {
        return this.nDimensions;
    }

    public double[] getLimits() {
        double[] dArray = new double[2 * this.nDimensions];
        int n = 0;
        for (int j = 0; j < this.nDimensions; ++j) {
            dArray[n] = this.xMin[j];
            dArray[++n] = this.xMax[j];
            ++n;
        }
        return dArray;
    }

    public void displayLimits() {
        System.out.println(" ");
        for (int j = 0; j < this.nDimensions; ++j) {
            System.out.println("The limits to the x array " + j + " are " + this.xMin[j] + " and " + this.xMax[j]);
        }
        System.out.println(" ");
    }

    public void averageIdenticalAbscissae() {
        this.averageIdenticalAbscissae = true;
    }

    public double interpolate(double[] dArray) {
        int n = dArray.length;
        if (n != this.nDimensions) {
            throw new IllegalArgumentException("Number of unknown value coordinates, " + n + ", does not equal the number of tabulated data dimensions, " + this.nDimensions);
        }
        switch (this.nDimensions) {
            case 0: {
                throw new IllegalArgumentException("data array must have at least one dimension");
            }
            case 1: {
                this.yValue = ((CubicSpline)this.method).interpolate(dArray[0]);
                break;
            }
            case 2: {
                this.yValue = ((BiCubicSpline)this.method).interpolate(dArray[0], dArray[1]);
                break;
            }
            case 3: {
                this.yValue = ((TriCubicSpline)this.method).interpolate(dArray[0], dArray[1], dArray[2]);
                break;
            }
            case 4: {
                this.yValue = ((QuadriCubicSpline)this.method).interpolate(dArray[0], dArray[1], dArray[2], dArray[3]);
                break;
            }
            default: {
                int n2;
                double[] dArray2 = new double[this.nDimensions - 1];
                for (n2 = 0; n2 < this.nDimensions - 1; ++n2) {
                    dArray2[n2] = dArray[n2 + 1];
                }
                for (n2 = 0; n2 < this.dimOne; ++n2) {
                    this.csArray[n2] = this.pcs[n2].interpolate(dArray2);
                }
                CubicSpline cubicSpline = new CubicSpline(this.xArray[0], this.csArray);
                this.yValue = cubicSpline.interpolate(dArray[0]);
            }
        }
        return this.yValue;
    }

    public void setDeriv(Object object) {
        this.internalDeriv = object;
    }

    public Object getDeriv() {
        return this.internalDeriv;
    }
}

