/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.interpolation.BiCubicSpline;
import flanagan.interpolation.CubicSpline;
import flanagan.interpolation.TriCubicSpline;
import flanagan.math.Fmath;

public class QuadriCubicSpline {
    private int nPoints = 0;
    private int mPoints = 0;
    private int lPoints = 0;
    private int kPoints = 0;
    private double[][][][] y = null;
    private double[] x1 = null;
    private double[] x2 = null;
    private double[] x3 = null;
    private double[] x4 = null;
    private double[] xMin = new double[4];
    private double[] xMax = new double[4];
    private TriCubicSpline[] tcsn = null;
    private CubicSpline csm = null;
    private double[][][][] d2ydx2inner = null;
    private boolean derivCalculated = false;
    private boolean averageIdenticalAbscissae = false;
    private static double potentialRoundingError = 5.0E-15;
    private static boolean roundingCheck = true;

    public QuadriCubicSpline(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[][][][] dArray5) {
        int n;
        int n2;
        int n3;
        int n4;
        this.nPoints = dArray.length;
        this.mPoints = dArray2.length;
        this.lPoints = dArray3.length;
        this.kPoints = dArray4.length;
        if (this.nPoints != dArray5.length) {
            throw new IllegalArgumentException("Arrays x1 and y-row are of different length " + this.nPoints + " " + dArray5.length);
        }
        if (this.mPoints != dArray5[0].length) {
            throw new IllegalArgumentException("Arrays x2 and y-column are of different length " + this.mPoints + " " + dArray5[0].length);
        }
        if (this.lPoints != dArray5[0][0].length) {
            throw new IllegalArgumentException("Arrays x3 and y-column are of different length " + this.mPoints + " " + dArray5[0][0].length);
        }
        if (this.kPoints != dArray5[0][0][0].length) {
            throw new IllegalArgumentException("Arrays x4 and y-column are of different length " + this.kPoints + " " + dArray5[0][0][0].length);
        }
        if (this.nPoints < 3 || this.mPoints < 3 || this.lPoints < 3 || this.kPoints < 3) {
            throw new IllegalArgumentException("The tabulated 4D array must have a minimum size of 3 X 3 X 3 X 3");
        }
        this.csm = new CubicSpline(this.nPoints);
        this.tcsn = TriCubicSpline.oneDarray(this.nPoints, this.mPoints, this.lPoints, this.kPoints);
        this.x1 = new double[this.nPoints];
        this.x2 = new double[this.mPoints];
        this.x3 = new double[this.lPoints];
        this.x4 = new double[this.kPoints];
        this.y = new double[this.nPoints][this.mPoints][this.lPoints][this.kPoints];
        this.d2ydx2inner = new double[this.nPoints][this.mPoints][this.lPoints][this.kPoints];
        for (n4 = 0; n4 < this.nPoints; ++n4) {
            this.x1[n4] = dArray[n4];
        }
        this.xMin[0] = Fmath.minimum(this.x1);
        this.xMax[0] = Fmath.maximum(this.x1);
        for (n4 = 0; n4 < this.mPoints; ++n4) {
            this.x2[n4] = dArray2[n4];
        }
        this.xMin[1] = Fmath.minimum(this.x2);
        this.xMax[1] = Fmath.maximum(this.x2);
        for (n4 = 0; n4 < this.lPoints; ++n4) {
            this.x3[n4] = dArray3[n4];
        }
        this.xMin[2] = Fmath.minimum(this.x3);
        this.xMax[2] = Fmath.maximum(this.x3);
        for (n4 = 0; n4 < this.kPoints; ++n4) {
            this.x4[n4] = dArray4[n4];
        }
        this.xMin[3] = Fmath.minimum(this.x4);
        this.xMax[3] = Fmath.maximum(this.x4);
        for (n4 = 0; n4 < this.nPoints; ++n4) {
            for (n3 = 0; n3 < this.mPoints; ++n3) {
                for (n2 = 0; n2 < this.lPoints; ++n2) {
                    for (n = 0; n < this.kPoints; ++n) {
                        this.y[n4][n3][n2][n] = dArray5[n4][n3][n2][n];
                    }
                }
            }
        }
        double[][][] dArray6 = new double[this.mPoints][this.lPoints][this.kPoints];
        for (n3 = 0; n3 < this.nPoints; ++n3) {
            for (n2 = 0; n2 < this.mPoints; ++n2) {
                for (n = 0; n < this.lPoints; ++n) {
                    for (int j = 0; j < this.kPoints; ++j) {
                        dArray6[n2][n][j] = dArray5[n3][n2][n][j];
                    }
                }
            }
            this.tcsn[n3].resetData(dArray2, dArray3, dArray4, dArray6);
            this.d2ydx2inner[n3] = this.tcsn[n3].getDeriv();
        }
        double[] dArray7 = new double[this.nPoints];
        this.derivCalculated = true;
    }

    public static void noRoundingErrorCheck() {
        roundingCheck = false;
        TriCubicSpline.noRoundingErrorCheck();
        BiCubicSpline.noRoundingErrorCheck();
        CubicSpline.noRoundingErrorCheck();
    }

    public static void potentialRoundingError(double d) {
        potentialRoundingError = d;
        TriCubicSpline.potentialRoundingError(d);
        BiCubicSpline.potentialRoundingError(d);
        CubicSpline.potentialRoundingError(d);
    }

    public void averageIdenticalAbscissae() {
        this.averageIdenticalAbscissae = true;
        for (int j = 0; j < this.tcsn.length; ++j) {
            this.tcsn[j].averageIdenticalAbscissae();
        }
        QuadriCubicSpline quadriCubicSpline = this;
        quadriCubicSpline.csm.averageIdenticalAbscissae();
    }

    public double[] getXmin() {
        return this.xMin;
    }

    public double[] getXmax() {
        return this.xMax;
    }

    public double[] getLimits() {
        double[] dArray = new double[]{this.xMin[0], this.xMax[0], this.xMin[1], this.xMax[1], this.xMin[2], this.xMax[2], this.xMin[3], this.xMax[3]};
        return dArray;
    }

    public void displayLimits() {
        System.out.println(" ");
        for (int j = 0; j < 2; ++j) {
            System.out.println("The limits to the x array " + j + " are " + this.xMin[j] + " and " + this.xMax[j]);
        }
        System.out.println(" ");
    }

    public double interpolate(double d, double d2, double d3, double d4) {
        double[] dArray = new double[this.nPoints];
        for (int j = 0; j < this.nPoints; ++j) {
            dArray[j] = this.tcsn[j].interpolate(d2, d3, d4);
        }
        this.csm.resetData(this.x1, dArray);
        return this.csm.interpolate(d);
    }

    public double[][][][] getDeriv() {
        return this.d2ydx2inner;
    }

    public void setDeriv(double[][][][] dArray) {
        this.d2ydx2inner = dArray;
        this.derivCalculated = true;
    }
}

