/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.interpolation.BiCubicSpline;
import flanagan.interpolation.CubicSpline;
import flanagan.math.Fmath;

public class TriCubicSpline {
    private int nPoints = 0;
    private int mPoints = 0;
    private int lPoints = 0;
    private double[][][] y = null;
    private double[] x1 = null;
    private double[] x2 = null;
    private double[] x3 = null;
    private double[] xMin = new double[3];
    private double[] xMax = new double[3];
    private BiCubicSpline[] bcsn = null;
    private CubicSpline csm = null;
    private double[][][] d2ydx2inner = null;
    private boolean derivCalculated = false;
    private boolean averageIdenticalAbscissae = false;
    private static double potentialRoundingError = 5.0E-15;
    private static boolean roundingCheck = true;

    public TriCubicSpline(double[] dArray, double[] dArray2, double[] dArray3, double[][][] dArray4) {
        int n;
        int n2;
        int n3;
        this.nPoints = dArray.length;
        this.mPoints = dArray2.length;
        this.lPoints = dArray3.length;
        if (this.nPoints != dArray4.length) {
            throw new IllegalArgumentException("Arrays x1 and y-row are of different length " + this.nPoints + " " + dArray4.length);
        }
        if (this.mPoints != dArray4[0].length) {
            throw new IllegalArgumentException("Arrays x2 and y-column are of different length " + this.mPoints + " " + dArray4[0].length);
        }
        if (this.lPoints != dArray4[0][0].length) {
            throw new IllegalArgumentException("Arrays x3 and y-column are of different length " + this.mPoints + " " + dArray4[0][0].length);
        }
        if (this.nPoints < 3 || this.mPoints < 3 || this.lPoints < 3) {
            throw new IllegalArgumentException("The tabulated 3D array must have a minimum size of 3 X 3 X 3");
        }
        this.csm = new CubicSpline(this.nPoints);
        this.bcsn = BiCubicSpline.oneDarray(this.nPoints, this.mPoints, this.lPoints);
        this.x1 = new double[this.nPoints];
        this.x2 = new double[this.mPoints];
        this.x3 = new double[this.lPoints];
        this.y = new double[this.nPoints][this.mPoints][this.lPoints];
        this.d2ydx2inner = new double[this.nPoints][this.mPoints][this.lPoints];
        for (n3 = 0; n3 < this.nPoints; ++n3) {
            this.x1[n3] = dArray[n3];
        }
        this.xMin[0] = Fmath.minimum(this.x1);
        this.xMax[0] = Fmath.maximum(this.x1);
        for (n3 = 0; n3 < this.mPoints; ++n3) {
            this.x2[n3] = dArray2[n3];
        }
        this.xMin[1] = Fmath.minimum(this.x2);
        this.xMax[1] = Fmath.maximum(this.x2);
        for (n3 = 0; n3 < this.lPoints; ++n3) {
            this.x3[n3] = dArray3[n3];
        }
        this.xMin[2] = Fmath.minimum(this.x3);
        this.xMax[2] = Fmath.maximum(this.x3);
        for (n3 = 0; n3 < this.nPoints; ++n3) {
            for (n2 = 0; n2 < this.mPoints; ++n2) {
                for (n = 0; n < this.lPoints; ++n) {
                    this.y[n3][n2][n] = dArray4[n3][n2][n];
                }
            }
        }
        double[][] dArray5 = new double[this.mPoints][this.lPoints];
        for (n2 = 0; n2 < this.nPoints; ++n2) {
            for (n = 0; n < this.mPoints; ++n) {
                for (int j = 0; j < this.lPoints; ++j) {
                    dArray5[n][j] = dArray4[n2][n][j];
                }
            }
            this.bcsn[n2].resetData(dArray2, dArray3, dArray5);
            this.d2ydx2inner[n2] = this.bcsn[n2].getDeriv();
        }
        this.derivCalculated = true;
    }

    public TriCubicSpline(int n, int n2, int n3) {
        this.nPoints = n;
        this.mPoints = n2;
        this.lPoints = n3;
        if (this.nPoints < 3 || this.mPoints < 3 || this.lPoints < 3) {
            throw new IllegalArgumentException("The data matrix must have a minimum size of 3 X 3 X 3");
        }
        this.csm = new CubicSpline(this.nPoints);
        this.bcsn = BiCubicSpline.oneDarray(this.nPoints, this.mPoints, this.lPoints);
        this.x1 = new double[this.nPoints];
        this.x2 = new double[this.mPoints];
        this.x3 = new double[this.lPoints];
        this.y = new double[this.nPoints][this.mPoints][this.lPoints];
        this.d2ydx2inner = new double[this.nPoints][this.mPoints][this.lPoints];
    }

    public static void noRoundingErrorCheck() {
        roundingCheck = false;
        BiCubicSpline.noRoundingErrorCheck();
        CubicSpline.noRoundingErrorCheck();
    }

    public static void potentialRoundingError(double d) {
        potentialRoundingError = d;
        BiCubicSpline.potentialRoundingError(d);
        CubicSpline.potentialRoundingError(d);
    }

    public void averageIdenticalAbscissae() {
        this.averageIdenticalAbscissae = true;
        for (int j = 0; j < this.bcsn.length; ++j) {
            this.bcsn[j].averageIdenticalAbscissae();
        }
        TriCubicSpline triCubicSpline = this;
        triCubicSpline.csm.averageIdenticalAbscissae();
    }

    public static TriCubicSpline zero(int n, int n2, int n3) {
        if (n < 3 || n2 < 3 || n3 < 3) {
            throw new IllegalArgumentException("A minimum of three x three x three data points is needed");
        }
        TriCubicSpline triCubicSpline = new TriCubicSpline(n, n2, n3);
        return triCubicSpline;
    }

    public static TriCubicSpline[] oneDarray(int n, int n2, int n3, int n4) {
        if (n2 < 3 || n3 < 3 || n4 < 3) {
            throw new IllegalArgumentException("A minimum of three x three x three data points is needed");
        }
        TriCubicSpline[] triCubicSplineArray = new TriCubicSpline[n];
        for (int j = 0; j < n; ++j) {
            triCubicSplineArray[j] = TriCubicSpline.zero(n2, n3, n4);
        }
        return triCubicSplineArray;
    }

    public void resetData(double[] dArray, double[] dArray2, double[] dArray3, double[][][] dArray4) {
        int n;
        int n2;
        int n3;
        if (dArray.length != dArray4.length) {
            throw new IllegalArgumentException("Arrays x1 and y row are of different length");
        }
        if (dArray2.length != dArray4[0].length) {
            throw new IllegalArgumentException("Arrays x2 and y column are of different length");
        }
        if (dArray3.length != dArray4[0][0].length) {
            throw new IllegalArgumentException("Arrays x3 and y column are of different length");
        }
        if (this.nPoints != dArray.length) {
            throw new IllegalArgumentException("Original array length not matched by new array length");
        }
        if (this.mPoints != dArray2.length) {
            throw new IllegalArgumentException("Original array length not matched by new array length");
        }
        if (this.lPoints != dArray3.length) {
            throw new IllegalArgumentException("Original array length not matched by new array length");
        }
        for (n3 = 0; n3 < this.nPoints; ++n3) {
            this.x1[n3] = dArray[n3];
        }
        this.xMin[0] = Fmath.minimum(this.x1);
        this.xMax[0] = Fmath.maximum(this.x1);
        for (n3 = 0; n3 < this.mPoints; ++n3) {
            this.x2[n3] = dArray2[n3];
        }
        this.xMin[1] = Fmath.minimum(this.x2);
        this.xMax[1] = Fmath.maximum(this.x2);
        for (n3 = 0; n3 < this.lPoints; ++n3) {
            this.x3[n3] = dArray3[n3];
        }
        this.xMin[2] = Fmath.minimum(this.x3);
        this.xMax[2] = Fmath.maximum(this.x3);
        for (n3 = 0; n3 < this.nPoints; ++n3) {
            for (n2 = 0; n2 < this.mPoints; ++n2) {
                for (n = 0; n < this.lPoints; ++n) {
                    this.y[n3][n2][n] = dArray4[n3][n2][n];
                }
            }
        }
        this.csm = new CubicSpline(this.nPoints);
        this.bcsn = BiCubicSpline.oneDarray(this.nPoints, this.mPoints, this.lPoints);
        double[][] dArray5 = new double[this.mPoints][this.lPoints];
        for (n2 = 0; n2 < this.nPoints; ++n2) {
            for (n = 0; n < this.mPoints; ++n) {
                for (int j = 0; j < this.lPoints; ++j) {
                    dArray5[n][j] = dArray4[n2][n][j];
                }
            }
            this.bcsn[n2].resetData(dArray2, dArray3, dArray5);
            this.d2ydx2inner[n2] = this.bcsn[n2].getDeriv();
        }
        this.derivCalculated = true;
    }

    public double[] getXmin() {
        return this.xMin;
    }

    public double[] getXmax() {
        return this.xMax;
    }

    public double[] getLimits() {
        double[] dArray = new double[]{this.xMin[0], this.xMax[0], this.xMin[1], this.xMax[1], this.xMin[2], this.xMax[2]};
        return dArray;
    }

    public void displayLimits() {
        System.out.println(" ");
        for (int j = 0; j < 3; ++j) {
            System.out.println("The limits to the x array " + j + " are " + this.xMin[j] + " and " + this.xMax[j]);
        }
        System.out.println(" ");
    }

    public double interpolate(double d, double d2, double d3) {
        double[] dArray = new double[this.nPoints];
        for (int j = 0; j < this.nPoints; ++j) {
            dArray[j] = this.bcsn[j].interpolate(d2, d3);
        }
        this.csm.resetData(this.x1, dArray);
        return this.csm.interpolate(d);
    }

    public double[][][] getDeriv() {
        return this.d2ydx2inner;
    }

    public void setDeriv(double[][][] dArray) {
        this.d2ydx2inner = dArray;
        this.derivCalculated = true;
    }
}

