/*
 * Decompiled with CFR 0.152.
 */
package flanagan.io;

import flanagan.analysis.ErrorProp;
import flanagan.circuits.Phasor;
import flanagan.complex.Complex;
import flanagan.complex.ComplexErrorProp;
import flanagan.math.Fmath;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class DialogueBox {
    private static boolean inputTypeInfo = false;
    private static String[] numbersS = new String[]{"nill", "nought", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen", "twenty"};
    private static int[] numbersI = new int[]{0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    private static int nNumbers = numbersI.length;

    public static void setTypeInfoOption(int n) {
        switch (n) {
            case 1: {
                inputTypeInfo = true;
                break;
            }
            case 2: {
                inputTypeInfo = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Option " + n + " not recognised");
            }
        }
    }

    public static final synchronized double readDoubleT(String string, String string2) {
        String string3 = "";
        double d = 0.0;
        boolean bl = false;
        System.out.flush();
        String string4 = "";
        if (inputTypeInfo) {
            string4 = "Input type: Decimal number\n\n";
        }
        while (!bl) {
            string3 = JOptionPane.showInputDialog(null, string4 + string2, string, 3);
            if (string3 == null) continue;
            try {
                d = Double.parseDouble(string3.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return d;
    }

    public static final synchronized double readDouble(String string, String string2) {
        return DialogueBox.readDoubleT(string, string2);
    }

    public static final synchronized double readDouble(String string) {
        String string2 = "";
        double d = 0.0;
        boolean bl = false;
        System.out.flush();
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: decimal number\n\n";
        }
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string);
            if (string2 == null) continue;
            try {
                d = Double.parseDouble(string2.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return d;
    }

    public static final synchronized double readDouble(String string, double d) {
        String string2 = "";
        double d2 = 0.0;
        boolean bl = false;
        System.out.flush();
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: decimal number\n\n";
        }
        string = string + "\n";
        String string4 = d + "";
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string + " [default value = " + d + "] ", (Object)string4);
            if (string2 == null) continue;
            if (string2.equals("")) {
                d2 = d;
                bl = true;
                string2 = null;
                continue;
            }
            try {
                d2 = Double.parseDouble(string2.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return d2;
    }

    public static final synchronized double readDouble() {
        String string = "";
        String string2 = "Input type: decimal number";
        double d = 0.0;
        boolean bl = false;
        System.out.flush();
        while (!bl) {
            string = JOptionPane.showInputDialog(string2);
            if (string == null) continue;
            try {
                d = Double.parseDouble(string.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return d;
    }

    public static final synchronized double[] readDoubleArray(String string) {
        int n;
        String string2 = "";
        double[] dArray = null;
        boolean bl = false;
        System.out.flush();
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: double[], each element separated by a comma\n";
        }
        string = string + "\n";
        String string4 = " ";
        int n2 = 0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string, (Object)string4);
            if (string2 == null) continue;
            if (string2.equals("")) {
                string2 = null;
                continue;
            }
            n = -1;
            String string5 = null;
            boolean bl2 = true;
            while (bl2) {
                n = string2.indexOf(44);
                if (n == -1) {
                    string5 = string2.trim();
                    bl2 = false;
                    bl = true;
                } else {
                    string5 = string2.substring(0, n).trim();
                    string2 = string2.substring(n + 1);
                }
                try {
                    arrayList.add(Double.valueOf(string5));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        n2 = arrayList.size();
        dArray = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = (Double)arrayList.get(n);
        }
        return dArray;
    }

    public static final synchronized Complex readComplex(String string) {
        String string2 = "";
        Complex complex = new Complex();
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: Complex (x + jy)\n";
        }
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string);
            if (string2 == null) continue;
            try {
                complex = Complex.parseComplex(string2);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return complex;
    }

    public static final synchronized Complex readComplex(String string, Complex complex) {
        String string2 = "";
        Complex complex2 = new Complex();
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: Complex (x + jy)\n";
        }
        String string4 = complex + "";
        string = string + "\n";
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string + " [default value = " + complex + "] ", (Object)string4);
            if (string2 == null) continue;
            if (string2.equals("")) {
                complex2 = complex;
                bl = true;
                string2 = null;
                continue;
            }
            try {
                complex2 = Complex.parseComplex(string2);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return complex2;
    }

    public static final synchronized Complex readComplex(String string, String string2) {
        String string3 = "";
        Complex complex = new Complex();
        boolean bl = false;
        String string4 = "";
        if (inputTypeInfo) {
            string4 = "Input type: Complex (x + jy)\n";
        }
        String string5 = string2;
        string = string + "\n";
        System.out.flush();
        while (!bl) {
            string3 = JOptionPane.showInputDialog(string4 + string + " [default value = " + string2 + "] ", (Object)string5);
            if (string3 == null) continue;
            if (string3.equals("")) {
                complex = Complex.parseComplex(string2);
                bl = true;
                string3 = null;
                continue;
            }
            try {
                complex = Complex.parseComplex(string3);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return complex;
    }

    public static final synchronized Complex readComplex() {
        String string = "";
        String string2 = "Input type: Complex (x + jy)";
        Complex complex = new Complex();
        boolean bl = false;
        System.out.flush();
        while (!bl) {
            string = JOptionPane.showInputDialog(string2);
            if (string == null) continue;
            try {
                complex = Complex.parseComplex(string.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return complex;
    }

    public static final synchronized Phasor readPhasor(String string) {
        String string2 = "";
        Phasor phasor = new Phasor();
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: Phasor ('mag'<'phase'deg or 'mag'<'phase'rad)\n";
        }
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string);
            if (string2 == null) continue;
            try {
                phasor = Phasor.parsePhasor(string2);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return phasor;
    }

    public static final synchronized Phasor readPhasor(String string, Phasor phasor) {
        String string2 = "";
        Phasor phasor2 = new Phasor();
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: Phasor ('mag'<'phase'deg or 'mag'<'phase'rad)\n";
        }
        String string4 = phasor + "";
        string = string + "\n";
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string + " [default value = " + phasor + "] ", (Object)string4);
            if (string2 == null) continue;
            if (string2.equals("")) {
                phasor2 = phasor;
                bl = true;
                string2 = null;
                continue;
            }
            try {
                phasor2 = Phasor.parsePhasor(string2);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return phasor2;
    }

    public static final synchronized Phasor readPhasor(String string, String string2) {
        String string3 = "";
        Phasor phasor = new Phasor();
        boolean bl = false;
        String string4 = "";
        if (inputTypeInfo) {
            string4 = "Input type: Phasor ('mag'<'phase'deg or 'mag'<'phase'rad)\n";
        }
        String string5 = string2;
        string = string + "\n";
        System.out.flush();
        while (!bl) {
            string3 = JOptionPane.showInputDialog(string4 + string + " [default value = " + string2 + "] ", (Object)string5);
            if (string3 == null) continue;
            if (string3.equals("")) {
                phasor = Phasor.parsePhasor(string2);
                bl = true;
                string3 = null;
                continue;
            }
            try {
                phasor = Phasor.parsePhasor(string3);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return phasor;
    }

    public static final synchronized Phasor readPhasor() {
        String string = "";
        String string2 = "Input type: Phasor ('mag'<'phase'deg or 'mag'<'phase'rad)";
        Phasor phasor = new Phasor();
        boolean bl = false;
        System.out.flush();
        while (!bl) {
            string = JOptionPane.showInputDialog(string2);
            if (string == null) continue;
            try {
                phasor = Phasor.parsePhasor(string.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return phasor;
    }

    public static final synchronized float readFloat(String string) {
        String string2 = "";
        float f = 0.0f;
        boolean bl = false;
        System.out.flush();
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: float\n";
        }
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string);
            if (string2 == null) continue;
            try {
                f = Float.parseFloat(string2.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return f;
    }

    public static final synchronized float readFloat(String string, float f) {
        String string2 = "";
        float f2 = 0.0f;
        boolean bl = false;
        System.out.flush();
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: float\n";
        }
        string = string + "\n";
        String string4 = f + "";
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string + " [default value = " + f + "] ", (Object)string4);
            if (string2 == null) continue;
            if (string2.equals("")) {
                f2 = f;
                bl = true;
                string2 = null;
                continue;
            }
            try {
                f2 = Float.parseFloat(string2.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return f2;
    }

    public static final synchronized float readFloat() {
        String string = "";
        String string2 = "Input type: float";
        float f = 0.0f;
        boolean bl = false;
        System.out.flush();
        while (!bl) {
            string = JOptionPane.showInputDialog(string2);
            if (string == null) continue;
            try {
                f = Float.parseFloat(string.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return f;
    }

    public static final synchronized int readIntT(String string, String string2) {
        String string3 = "";
        int n = 0;
        boolean bl = false;
        System.out.flush();
        String string4 = "";
        if (inputTypeInfo) {
            string4 = "Input type: integer number\n\n";
        }
        while (!bl) {
            string3 = JOptionPane.showInputDialog(null, string4 + string2, string, 3);
            if (string3 == null) continue;
            try {
                n = Integer.parseInt(string3.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                n = DialogueBox.convertToInt(string3);
                if (n == -1000) continue;
                bl = true;
            }
        }
        return n;
    }

    public static final synchronized int readInt(String string, String string2) {
        return DialogueBox.readIntT(string, string2);
    }

    private static int convertToInt(String string) {
        int n = -1000;
        for (int j = 0; j < nNumbers; ++j) {
            if (!string.trim().equalsIgnoreCase(numbersS[j])) continue;
            n = numbersI[j];
            break;
        }
        return n;
    }

    public static final synchronized int readInt(String string) {
        String string2 = "";
        int n = 0;
        boolean bl = false;
        System.out.flush();
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: integer number\n\n";
        }
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string);
            if (string2 == null) continue;
            try {
                n = Integer.parseInt(string2.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                n = DialogueBox.convertToInt(string2);
                if (n == -1000) continue;
                bl = true;
            }
        }
        return n;
    }

    public static final synchronized int readInt(String string, int n) {
        String string2 = "";
        int n2 = 0;
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: integer number\n\n";
        }
        string = string + "\n";
        String string4 = n + "";
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string + " [default value = " + n + "] ", (Object)string4);
            if (string2 == null) continue;
            if (string2.equals("")) {
                n2 = n;
                bl = true;
                string2 = null;
                continue;
            }
            try {
                n2 = Integer.parseInt(string2.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                n2 = DialogueBox.convertToInt(string2);
                if (n2 == -1000) continue;
                bl = true;
            }
        }
        return n2;
    }

    public static final synchronized int readInt() {
        String string = "";
        String string2 = "Input type: integer number\n\n";
        int n = 0;
        boolean bl = false;
        System.out.flush();
        while (!bl) {
            string = JOptionPane.showInputDialog(string2);
            if (string == null) continue;
            try {
                n = Integer.parseInt(string.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                n = DialogueBox.convertToInt(string);
                if (n == -1000) continue;
                bl = true;
            }
        }
        return n;
    }

    public static final synchronized long readLong(String string) {
        String string2 = "";
        long l = 0L;
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: long\n";
        }
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string);
            if (string2 == null) continue;
            try {
                l = Long.parseLong(string2.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return l;
    }

    public static final synchronized long readLong(String string, long l) {
        String string2 = "";
        long l2 = 0L;
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: long\n";
        }
        string = string + "\n";
        String string4 = l + "";
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string + " [default value = " + l + "] ", (Object)string4);
            if (string2 == null) continue;
            if (string2.equals("")) {
                l2 = l;
                bl = true;
                string2 = null;
                continue;
            }
            try {
                l2 = Long.parseLong(string2.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return l2;
    }

    public static final synchronized long readLong() {
        String string = "";
        String string2 = "Input type: long";
        long l = 0L;
        boolean bl = false;
        System.out.flush();
        while (!bl) {
            string = JOptionPane.showInputDialog(string2);
            if (string == null) continue;
            try {
                l = Long.parseLong(string.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return l;
    }

    public static final synchronized long readShort(String string) {
        String string2 = "";
        long l = 0L;
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: short\n";
        }
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string);
            if (string2 == null) continue;
            try {
                l = Short.parseShort(string2.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return l;
    }

    public static final synchronized short readShort(String string, short s) {
        String string2 = "";
        short s2 = 0;
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: short\n";
        }
        string = string + "\n";
        String string4 = s + "";
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string + " [default value = " + s + "] ", (Object)string4);
            if (string2 == null) continue;
            if (string2.equals("")) {
                s2 = s;
                bl = true;
                string2 = null;
                continue;
            }
            try {
                s2 = Short.parseShort(string2.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return s2;
    }

    public static final synchronized short readShort() {
        String string = "";
        String string2 = "Input type: short";
        short s = 0;
        boolean bl = false;
        System.out.flush();
        while (!bl) {
            string = JOptionPane.showInputDialog(string2);
            if (string == null) continue;
            try {
                s = Short.parseShort(string.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return s;
    }

    public static final synchronized long readByte(String string) {
        String string2 = "";
        long l = 0L;
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: short\n";
        }
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string);
            if (string2 == null) continue;
            try {
                l = Byte.parseByte(string2.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return l;
    }

    public static final synchronized byte readByte(String string, byte by) {
        String string2 = "";
        byte by2 = 0;
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: byte\n";
        }
        string = string + "\n";
        String string4 = by + "";
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string + " [default value = " + by + "] ", (Object)string4);
            if (string2 == null) continue;
            if (string2.equals("")) {
                by2 = by;
                bl = true;
                string2 = null;
                continue;
            }
            try {
                by2 = Byte.parseByte(string2.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return by2;
    }

    public static final synchronized byte readByte() {
        String string = "";
        String string2 = "Input type: byte";
        byte by = 0;
        boolean bl = false;
        System.out.flush();
        while (!bl) {
            string = JOptionPane.showInputDialog(string2);
            if (string == null) continue;
            try {
                by = Byte.parseByte(string.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return by;
    }

    public static final synchronized char readChar(String string) {
        String string2 = "";
        char c = ' ';
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: char\n";
        }
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string);
            if (string2 == null || string2.equals("")) continue;
            c = string2.charAt(0);
            bl = true;
        }
        return c;
    }

    public static final synchronized char readChar(String string, char c) {
        String string2 = "";
        char c2 = ' ';
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: char\n";
        }
        string = string + "\n";
        String string4 = c + "";
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string + " [default value = " + c + "] ", (Object)string4);
            if (string2 == null) continue;
            if (string2.equals("")) {
                c2 = c;
                bl = true;
                string2 = null;
                continue;
            }
            c2 = string2.charAt(0);
            bl = true;
        }
        return c2;
    }

    public static final synchronized char readChar() {
        String string = "";
        String string2 = "Input type: char";
        char c = ' ';
        boolean bl = false;
        System.out.flush();
        while (!bl) {
            string = JOptionPane.showInputDialog(string2);
            if (string == null || string.equals("")) continue;
            c = string.charAt(0);
            bl = true;
        }
        return c;
    }

    public static final synchronized String readLineT(String string, String string2) {
        String string3 = "";
        boolean bl = false;
        String string4 = "";
        if (inputTypeInfo) {
            string4 = "Input type: a line of text\n\n";
        }
        while (!bl) {
            string3 = JOptionPane.showInputDialog(null, string4 + string2, string, 3);
            if (string3 == null || string3.equals("")) continue;
            bl = true;
        }
        return string3;
    }

    public static final synchronized String readLine(String string) {
        String string2 = "";
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: a line of text\n\n";
        }
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string);
            if (string2 == null || string2.equals("")) continue;
            bl = true;
        }
        return string2;
    }

    public static final synchronized String readLine(String string, String string2) {
        String string3 = "";
        boolean bl = false;
        String string4 = "";
        if (inputTypeInfo) {
            string4 = "Input type: a line of text\n\n";
        }
        string = string + "\n";
        String string5 = string2 + "";
        System.out.flush();
        while (!bl) {
            string3 = JOptionPane.showInputDialog(string4 + string + " [default value = " + string2 + "] ", (Object)string5);
            if (string3 == null) continue;
            if (string3.equals("")) {
                string3 = string2;
                bl = true;
                continue;
            }
            bl = true;
        }
        return string3;
    }

    public static final synchronized String readLine() {
        String string = "";
        String string2 = "Input type: a line of text\n\n";
        boolean bl = false;
        System.out.flush();
        while (!bl) {
            string = JOptionPane.showInputDialog(string2);
            if (string == null || string.equals("")) continue;
            bl = true;
        }
        return string;
    }

    public static final synchronized boolean readBoolean(String string, boolean bl) {
        String string2 = "";
        boolean bl2 = false;
        boolean bl3 = false;
        System.out.flush();
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input boolean\n";
        }
        string = string + "\n";
        String string4 = bl + "";
        while (!bl3) {
            string2 = JOptionPane.showInputDialog(string3 + string + " [default value = " + bl + "] ", (Object)string4);
            if (string2 == null) continue;
            if (string2.equals("")) {
                bl2 = bl;
                bl3 = true;
                string2 = null;
                continue;
            }
            if (string2.equals("true") || string2.trim().equals("TRUE")) {
                bl2 = true;
                bl3 = true;
                continue;
            }
            if (!string2.equals("false") && !string2.trim().equals("FALSE")) continue;
            bl2 = false;
            bl3 = true;
        }
        return bl2;
    }

    public static final synchronized boolean readBoolean(String string) {
        String string2 = "";
        boolean bl = false;
        boolean bl2 = false;
        System.out.flush();
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input boolean\n";
        }
        while (!bl2) {
            string2 = JOptionPane.showInputDialog(string3 + string);
            if (string2 == null) continue;
            if (string2.equals("true") || string2.trim().equals("TRUE")) {
                bl = true;
                bl2 = true;
                continue;
            }
            if (!string2.equals("false") && !string2.trim().equals("FALSE")) continue;
            bl = false;
            bl2 = true;
        }
        return bl;
    }

    public static final synchronized boolean readBoolean() {
        String string = "";
        String string2 = "Input type: boolean";
        boolean bl = false;
        boolean bl2 = false;
        System.out.flush();
        while (!bl2) {
            string = JOptionPane.showInputDialog(string2);
            if (string == null) continue;
            if (string.equals("true") || string.trim().equals("TRUE")) {
                bl = true;
                bl2 = true;
                continue;
            }
            if (!string.equals("false") && !string.trim().equals("FALSE")) continue;
            bl = false;
            bl2 = true;
        }
        return bl;
    }

    public static final synchronized BigDecimal readBigDecimal(String string) {
        String string2 = "";
        BigDecimal bigDecimal = null;
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: BigDecimal\n";
        }
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string);
            if (string2 == null) continue;
            try {
                bigDecimal = new BigDecimal(string2);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bigDecimal;
    }

    public static final synchronized BigDecimal readBigDecimal(String string, BigDecimal bigDecimal) {
        String string2 = "";
        BigDecimal bigDecimal2 = null;
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: BigDecimal\n";
        }
        String string4 = bigDecimal.toString() + "";
        string = string + "\n";
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string + " [default value = " + bigDecimal + "] ", (Object)string4);
            if (string2 == null) continue;
            if (string2.equals("")) {
                bigDecimal2 = bigDecimal;
                bl = true;
                string2 = null;
                continue;
            }
            try {
                bigDecimal2 = new BigDecimal(string2);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bigDecimal2;
    }

    public static final synchronized BigDecimal readBigDecimal(String string, String string2) {
        String string3 = "";
        BigDecimal bigDecimal = null;
        boolean bl = false;
        String string4 = "";
        if (inputTypeInfo) {
            string4 = "Input type: BigDecimal\n";
        }
        String string5 = string2;
        string = string + "\n";
        System.out.flush();
        while (!bl) {
            string3 = JOptionPane.showInputDialog(string4 + string + " [default value = " + string2 + "] ", (Object)string5);
            if (string3 == null) continue;
            if (string3.equals("")) {
                bigDecimal = new BigDecimal(string2);
                bl = true;
                string3 = null;
                continue;
            }
            try {
                bigDecimal = new BigDecimal(string3);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bigDecimal;
    }

    public static final synchronized BigDecimal readBigDecimal(String string, double d) {
        String string2 = "";
        BigDecimal bigDecimal = null;
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: BigDecimal\n";
        }
        Double d2 = new Double(d);
        String string4 = d2.toString();
        string = string + "\n";
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string + " [default value = " + d + "] ", (Object)string4);
            if (string2 == null) continue;
            if (string2.equals("")) {
                bigDecimal = new BigDecimal(string4);
                bl = true;
                string2 = null;
                continue;
            }
            try {
                bigDecimal = new BigDecimal(string2);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bigDecimal;
    }

    public static final synchronized BigDecimal readBigDecimal(String string, float f) {
        String string2 = "";
        BigDecimal bigDecimal = null;
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: BigDecimal\n";
        }
        Float f2 = new Float(f);
        String string4 = f2.toString();
        string = string + "\n";
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string + " [default value = " + f + "] ", (Object)string4);
            if (string2 == null) continue;
            if (string2.equals("")) {
                bigDecimal = new BigDecimal(string4);
                bl = true;
                string2 = null;
                continue;
            }
            try {
                bigDecimal = new BigDecimal(string2);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bigDecimal;
    }

    public static final synchronized BigDecimal readBigDecimal(String string, long l) {
        String string2 = "";
        BigDecimal bigDecimal = null;
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: BigDecimal\n";
        }
        Long l2 = new Long(l);
        String string4 = l2.toString();
        string = string + "\n";
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string + " [default value = " + l + "] ", (Object)string4);
            if (string2 == null) continue;
            if (string2.equals("")) {
                bigDecimal = new BigDecimal(string4);
                bl = true;
                string2 = null;
                continue;
            }
            try {
                bigDecimal = new BigDecimal(string2);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bigDecimal;
    }

    public static final synchronized BigDecimal readBigDecimal(String string, int n) {
        String string2 = "";
        BigDecimal bigDecimal = null;
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: BigDecimal\n";
        }
        Integer n2 = new Integer(n);
        String string4 = n2.toString();
        string = string + "\n";
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string + " [default value = " + n + "] ", (Object)string4);
            if (string2 == null) continue;
            if (string2.equals("")) {
                bigDecimal = new BigDecimal(string4);
                bl = true;
                string2 = null;
                continue;
            }
            try {
                bigDecimal = new BigDecimal(string2);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bigDecimal;
    }

    public static final synchronized BigDecimal readBigDecimal() {
        String string = "";
        String string2 = "Input type: BigDecimal";
        BigDecimal bigDecimal = null;
        boolean bl = false;
        System.out.flush();
        while (!bl) {
            string = JOptionPane.showInputDialog(string2);
            if (string == null) continue;
            try {
                bigDecimal = new BigDecimal(string.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bigDecimal;
    }

    public static final synchronized BigInteger readBigInteger(String string) {
        String string2 = "";
        BigInteger bigInteger = null;
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: BigInteger\n";
        }
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string);
            if (string2 == null) continue;
            try {
                bigInteger = new BigInteger(string2);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bigInteger;
    }

    public static final synchronized BigInteger readBigInteger(String string, BigInteger bigInteger) {
        String string2 = "";
        BigInteger bigInteger2 = null;
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: BigInteger\n";
        }
        String string4 = bigInteger.toString() + "";
        string = string + "\n";
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string + " [default value = " + bigInteger + "] ", (Object)string4);
            if (string2 == null) continue;
            if (string2.equals("")) {
                bigInteger2 = bigInteger;
                bl = true;
                string2 = null;
                continue;
            }
            try {
                bigInteger2 = new BigInteger(string2);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bigInteger2;
    }

    public static final synchronized BigInteger readBigInteger(String string, String string2) {
        String string3 = "";
        BigInteger bigInteger = null;
        boolean bl = false;
        String string4 = "";
        if (inputTypeInfo) {
            string4 = "Input type: BigInteger\n";
        }
        String string5 = string2;
        string = string + "\n";
        System.out.flush();
        while (!bl) {
            string3 = JOptionPane.showInputDialog(string4 + string + " [default value = " + string2 + "] ", (Object)string5);
            if (string3 == null) continue;
            if (string3.equals("")) {
                bigInteger = new BigInteger(string2);
                bl = true;
                string3 = null;
                continue;
            }
            try {
                bigInteger = new BigInteger(string3);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bigInteger;
    }

    public static final synchronized BigInteger readBigInteger(String string, long l) {
        String string2 = "";
        BigInteger bigInteger = null;
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: BigInteger\n";
        }
        Long l2 = new Long(l);
        String string4 = l2.toString();
        string = string + "\n";
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string + " [default value = " + l + "] ", (Object)string4);
            if (string2 == null) continue;
            if (string2.equals("")) {
                bigInteger = new BigInteger(string4);
                bl = true;
                string2 = null;
                continue;
            }
            try {
                bigInteger = new BigInteger(string2);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bigInteger;
    }

    public static final synchronized BigInteger readBigInteger(String string, int n) {
        String string2 = "";
        BigInteger bigInteger = null;
        boolean bl = false;
        String string3 = "";
        if (inputTypeInfo) {
            string3 = "Input type: BigInteger\n";
        }
        Integer n2 = new Integer(n);
        String string4 = n2.toString();
        string = string + "\n";
        System.out.flush();
        while (!bl) {
            string2 = JOptionPane.showInputDialog(string3 + string + " [default value = " + n + "] ", (Object)string4);
            if (string2 == null) continue;
            if (string2.equals("")) {
                bigInteger = new BigInteger(string4);
                bl = true;
                string2 = null;
                continue;
            }
            try {
                bigInteger = new BigInteger(string2);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bigInteger;
    }

    public static final synchronized BigInteger readBigInteger() {
        String string = "";
        String string2 = "Input type: BigInteger";
        BigInteger bigInteger = null;
        boolean bl = false;
        System.out.flush();
        while (!bl) {
            string = JOptionPane.showInputDialog(string2);
            if (string == null) continue;
            try {
                bigInteger = new BigInteger(string.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bigInteger;
    }

    public static final synchronized boolean yesNo(String string, String string2) {
        int n = JOptionPane.showConfirmDialog(null, string2, string, 0, 3);
        boolean bl = false;
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    public static final synchronized boolean yesNo(String string) {
        int n = JOptionPane.showConfirmDialog(null, string, "DialogueBox Class Yes or No Box", 0, 3);
        boolean bl = false;
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    public static final synchronized boolean noYes(String string, String string2) {
        Object[] objectArray = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(null, string2, string, 0, 3, null, objectArray, objectArray[1]);
        boolean bl = false;
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    public static final synchronized boolean noYes(String string) {
        Object[] objectArray = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(null, string, "DialogueBox Class Yes or No Box", 0, 3, null, objectArray, objectArray[1]);
        boolean bl = false;
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    public static final synchronized void show(String string, String string2, double d) {
        JOptionPane.showMessageDialog(null, string2 + " " + d, string, 1);
    }

    public static final synchronized void show(String string, double d) {
        JOptionPane.showMessageDialog(null, string + " " + d, "DialogueBox.show (double)", 1);
    }

    public static final synchronized void show(double d) {
        JOptionPane.showMessageDialog(null, " " + d, "DialogueBox.show (double)", 1);
    }

    public static final synchronized void show(String string, double d, int n) {
        JOptionPane.showMessageDialog(null, string + " " + Fmath.truncate(d, n), "DialogueBox.show (double)", 1);
    }

    public static final synchronized void show(String string, String string2, double d, int n) {
        JOptionPane.showMessageDialog(null, string2 + " " + Fmath.truncate(d, n), string, 1);
    }

    public static final synchronized void show(double d, int n) {
        JOptionPane.showMessageDialog(null, " " + Fmath.truncate(d, n), "DialogueBox.show (double)", 1);
    }

    public static final synchronized void show(String string, Double d) {
        JOptionPane.showMessageDialog(null, string + " " + d, "DialogueBox.show (Double)", 1);
    }

    public static final synchronized void show(Double d) {
        JOptionPane.showMessageDialog(null, " " + d, "DialogueBox.show (Double)", 1);
    }

    public static final synchronized void show(String string, float f) {
        JOptionPane.showMessageDialog(null, string + " " + f, "DialogueBox.show (float)", 1);
    }

    public static final synchronized void show(float f) {
        JOptionPane.showMessageDialog(null, " " + f, "DialogueBox.show (float)", 1);
    }

    public static final synchronized void show(String string, float f, int n) {
        JOptionPane.showMessageDialog(null, string + " " + Fmath.truncate(f, n), "DialogueBox.show (float)", 1);
    }

    public static final synchronized void show(float f, int n) {
        JOptionPane.showMessageDialog(null, " " + Fmath.truncate(f, n), "DialogueBox.show (float)", 1);
    }

    public static final synchronized void show(String string, Float f) {
        JOptionPane.showMessageDialog(null, string + " " + f.floatValue(), "DialogueBox.show (float)", 1);
    }

    public static final synchronized void show(Float f) {
        JOptionPane.showMessageDialog(null, " " + f.floatValue(), "DialogueBox.show (float)", 1);
    }

    public static final synchronized void show(String string, BigDecimal bigDecimal) {
        JOptionPane.showMessageDialog(null, string + " " + bigDecimal.toString(), "DialogueBox.show (BigDecimal)", 1);
    }

    public static final synchronized void show(BigDecimal bigDecimal) {
        JOptionPane.showMessageDialog(null, " " + bigDecimal.toString(), "DialogueBox.show (BigDecimal)", 1);
    }

    public static final synchronized void show(String string, BigInteger bigInteger) {
        JOptionPane.showMessageDialog(null, string + " " + bigInteger.toString(), "DialogueBox.show (BigInteger)", 1);
    }

    public static final synchronized void show(BigInteger bigInteger) {
        JOptionPane.showMessageDialog(null, " " + bigInteger.toString(), "DialogueBox.show (BigInteger)", 1);
    }

    public static final synchronized void show(String string, int n) {
        JOptionPane.showMessageDialog(null, string + " " + n, "DialogueBox.show (int)", 1);
    }

    public static final synchronized void show(int n) {
        JOptionPane.showMessageDialog(null, " " + n, "DialogueBox.show (int)", 1);
    }

    public static final synchronized void show(String string, Integer n) {
        JOptionPane.showMessageDialog(null, string + " " + n, "DialogueBox.show (int)", 1);
    }

    public static final synchronized void show(Integer n) {
        JOptionPane.showMessageDialog(null, " " + n, "DialogueBox.show (int)", 1);
    }

    public static final synchronized void show(String string, long l) {
        JOptionPane.showMessageDialog(null, string + " " + l, "DialogueBox.show (long)", 1);
    }

    public static final synchronized void show(long l) {
        JOptionPane.showMessageDialog(null, " " + l, "DialogueBox.show (long)", 1);
    }

    public static final synchronized void show(String string, Long l) {
        JOptionPane.showMessageDialog(null, string + " " + l, "DialogueBox.show (long)", 1);
    }

    public static final synchronized void show(Long l) {
        JOptionPane.showMessageDialog(null, " " + l, "DialogueBox.show (long)", 1);
    }

    public static final synchronized void show(String string, short s) {
        JOptionPane.showMessageDialog(null, string + " " + s, "DialogueBox.show (short)", 1);
    }

    public static final synchronized void show(short s) {
        JOptionPane.showMessageDialog(null, " " + s, "DialogueBox.show (short)", 1);
    }

    public static final synchronized void show(String string, Short s) {
        JOptionPane.showMessageDialog(null, string + " " + s, "DialogueBox.show (short)", 1);
    }

    public static final synchronized void show(Short s) {
        JOptionPane.showMessageDialog(null, " " + s, "DialogueBox.show (short)", 1);
    }

    public static final synchronized void show(String string, byte by) {
        JOptionPane.showMessageDialog(null, string + " " + by, "DialogueBox.show (byte)", 1);
    }

    public static final synchronized void show(byte by) {
        JOptionPane.showMessageDialog(null, " " + by, "DialogueBox.show (byte)", 1);
    }

    public static final synchronized void show(String string, Byte by) {
        JOptionPane.showMessageDialog(null, string + " " + by, "DialogueBox.show (byte)", 1);
    }

    public static final synchronized void show(Byte by) {
        JOptionPane.showMessageDialog(null, " " + by, "DialogueBox.show (byte)", 1);
    }

    public static final synchronized void show(String string, Complex complex) {
        JOptionPane.showMessageDialog(null, string + " " + complex, "DialogueBox.show (Complex)", 1);
    }

    public static final synchronized void show(Complex complex) {
        JOptionPane.showMessageDialog(null, " " + complex, "DialogueBox.show (Complex)", 1);
    }

    public static final synchronized void show(String string, Complex complex, int n) {
        JOptionPane.showMessageDialog(null, string + " " + Complex.truncate(complex, n), "DialogueBox.show (Complex)", 1);
    }

    public static final synchronized void show(Complex complex, int n) {
        JOptionPane.showMessageDialog(null, " " + Complex.truncate(complex, n), "DialogueBox.show (Complex)", 1);
    }

    public static final synchronized void show(String string, Phasor phasor) {
        JOptionPane.showMessageDialog(null, string + " " + phasor, "DialogueBox.show (Phasor)", 1);
    }

    public static final synchronized void show(Phasor phasor) {
        JOptionPane.showMessageDialog(null, " " + phasor, "DialogueBox.show (Phasor)", 1);
    }

    public static final synchronized void show(String string, Phasor phasor, int n) {
        JOptionPane.showMessageDialog(null, string + " " + Phasor.truncate(phasor, n), "DialogueBox.show (Phasor)", 1);
    }

    public static final synchronized void show(Phasor phasor, int n) {
        JOptionPane.showMessageDialog(null, " " + Phasor.truncate(phasor, n), "DialogueBox.show (Phasor)", 1);
    }

    public static final synchronized void show(String string, ErrorProp errorProp) {
        JOptionPane.showMessageDialog(null, string + " " + errorProp, "DialogueBox.show (ErrorProp)", 1);
    }

    public static final synchronized void show(ErrorProp errorProp) {
        JOptionPane.showMessageDialog(null, " " + errorProp, "DialogueBox.show (ErrorProp)", 1);
    }

    public static final synchronized void show(String string, ErrorProp errorProp, int n) {
        JOptionPane.showMessageDialog(null, string + " " + ErrorProp.truncate(errorProp, n), "DialogueBox.show (ErrorProp)", 1);
    }

    public static final synchronized void show(ErrorProp errorProp, int n) {
        JOptionPane.showMessageDialog(null, " " + ErrorProp.truncate(errorProp, n), "DialogueBox.show (ErrorProp)", 1);
    }

    public static final synchronized void show(String string, ComplexErrorProp complexErrorProp) {
        JOptionPane.showMessageDialog(null, string + " " + complexErrorProp, "DialogueBox.show (ComplexErrorProp)", 1);
    }

    public static final synchronized void show(ComplexErrorProp complexErrorProp) {
        JOptionPane.showMessageDialog(null, " " + complexErrorProp, "DialogueBox.show (ComplexErrorProp)", 1);
    }

    public static final synchronized void show(String string, ComplexErrorProp complexErrorProp, int n) {
        JOptionPane.showMessageDialog(null, string + " " + ComplexErrorProp.truncate(complexErrorProp, n), "DialogueBox.show (ComplexErrorProp)", 1);
    }

    public static final synchronized void show(ComplexErrorProp complexErrorProp, int n) {
        JOptionPane.showMessageDialog(null, " " + ComplexErrorProp.truncate(complexErrorProp, n), "DialogueBox.show (ComplexErrorProp)", 1);
    }

    public static final synchronized void show(String string, boolean bl) {
        JOptionPane.showMessageDialog(null, string + " " + bl, "DialogueBox.show (boolean)", 1);
    }

    public static final synchronized void show(boolean bl) {
        JOptionPane.showMessageDialog(null, " " + bl, "DialogueBox.show (boolean)", 1);
    }

    public static final synchronized void show(String string, Boolean bl) {
        JOptionPane.showMessageDialog(null, string + " " + bl, "DialogueBox.show (boolean)", 1);
    }

    public static final synchronized void show(Boolean bl) {
        JOptionPane.showMessageDialog(null, " " + bl, "DialogueBox.show (boolean)", 1);
    }

    public static final synchronized void show(String string, char c) {
        JOptionPane.showMessageDialog(null, string + " " + c, "DialogueBox.show (char)", 1);
    }

    public static final synchronized void show(char c) {
        JOptionPane.showMessageDialog(null, " " + c, "DialogueBox.show (char)", 1);
    }

    public static final synchronized void show(String string, Character c) {
        JOptionPane.showMessageDialog(null, string + " " + c.charValue(), "DialogueBox.show (char)", 1);
    }

    public static final synchronized void show(Character c) {
        JOptionPane.showMessageDialog(null, " " + c.charValue(), "DialogueBox.show (char)", 1);
    }

    public static final synchronized void show(String string, String string2, String string3) {
        JOptionPane.showMessageDialog(null, string2 + " " + string3, string, 1);
    }

    public static final synchronized void show(String string, String string2) {
        JOptionPane.showMessageDialog(null, string + " " + string2, "DialogueBox.show (String)", 1);
    }

    public static final synchronized void showT(String string, String string2, String string3) {
        JOptionPane.showMessageDialog(null, string2 + " " + string3, string, 1);
    }

    public static final synchronized void show(String string) {
        JOptionPane.showMessageDialog(null, string, "DialogueBox.show (message only)", 1);
    }

    public static final synchronized int optionBox(String string, String[] stringArray, String[] stringArray2, int n) {
        int n2 = stringArray2.length;
        if (n2 != stringArray.length) {
            throw new IllegalArgumentException("There must be the same number of boxTitles and comments");
        }
        Object[] objectArray = new Object[n2];
        for (int j = 0; j < n2; ++j) {
            objectArray[j] = "(" + (j + 1) + ") " + stringArray2[j];
        }
        String string2 = "1. " + stringArray[0] + "\n";
        for (int j = 1; j < n2; ++j) {
            string2 = string2 + (j + 1) + ". " + stringArray[j] + "\n";
        }
        return 1 + JOptionPane.showOptionDialog(null, string2, string, 1, 3, null, objectArray, objectArray[n - 1]);
    }

    public static final synchronized int optionBox(String string, String string2, String[] stringArray, int n) {
        int n2 = stringArray.length;
        Object[] objectArray = new Object[n2];
        for (int j = 0; j < n2; ++j) {
            objectArray[j] = "(" + (j + 1) + ") " + stringArray[j];
        }
        return 1 + JOptionPane.showOptionDialog(null, string2, string, 1, 3, null, objectArray, objectArray[n - 1]);
    }

    public static final synchronized void endProgram() {
        int n = JOptionPane.showConfirmDialog(null, "Do you wish to end the program", "End Program", 0, 3);
        if (n == 0) {
            System.exit(0);
        } else {
            JOptionPane.showMessageDialog(null, "Now you must press the appropriate escape key/s, e.g. Ctrl C, to exit this program");
        }
    }
}

