/*
 * Decompiled with CFR 0.152.
 */
package flanagan.io;

import flanagan.interpolation.CubicSpline;
import flanagan.io.Db;
import flanagan.io.FileChooser;
import flanagan.io.FileInput;
import flanagan.io.FileOutput;
import flanagan.math.Fmath;
import flanagan.plot.PlotGraph;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.PixelGrabber;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.JFrame;

public class DigiGraph
extends Canvas
implements MouseListener {
    private Image pic = null;
    private String imagePath = null;
    private String imageName = null;
    private String extension = null;
    private String outputFile = null;
    private FileOutput fout = null;
    private int trunc = 16;
    private String path = "C:";
    private int windowWidth = 0;
    private int windowHeight = 0;
    private int closeChoice = 1;
    private int xPos = 0;
    private int yPos = 0;
    private int button = 0;
    private int sumX = 0;
    private int sumY = 0;
    private int iSum = 0;
    private boolean mouseEntered = false;
    private double lowYvalue = 0.0;
    private double lowYaxisXpixel = 0.0;
    private double lowYaxisYpixel = 0.0;
    private double highYvalue = 0.0;
    private double highYaxisXpixel = 0.0;
    private double highYaxisYpixel = 0.0;
    private double lowXvalue = 0.0;
    private double lowXaxisXpixel = 0.0;
    private double lowXaxisYpixel = 0.0;
    private double highXvalue = 0.0;
    private double highXaxisXpixel = 0.0;
    private double highXaxisYpixel = 0.0;
    private ArrayList<Integer> xAndYvalues = new ArrayList();
    private int iCounter = 0;
    private double angleXaxis = 0.0;
    private double angleYaxis = 0.0;
    private double angleMean = 0.0;
    private double angleTolerance = 0.0;
    private boolean rotationDone = false;
    private double[] xPosPixel = null;
    private double[] yPosPixel = null;
    private double[] xPositions = null;
    private double[] yPositions = null;
    private int nData = 0;
    private int nInterpPoints = 0;
    private boolean interpOpt = false;
    private double[] xInterp = null;
    private double[] yInterp = null;
    private boolean plotOpt = true;
    private boolean noIdentical = true;
    private int imageFormat = 0;
    private boolean digitizationDone = false;
    private boolean noYlow = true;
    private boolean noXlow = true;
    private boolean noYhigh = true;
    private boolean noXhigh = true;
    private boolean resize = false;
    private JFrame window = new JFrame("Michael T Flanagan's digitizing program - DigiGraph");

    public DigiGraph() {
        this.setWindowSize();
        this.selectImage();
        this.setImage();
        this.outputFileChoice();
        this.addMouseListener(this);
    }

    public DigiGraph(String string) {
        this.setWindowSize();
        this.path = string;
        this.selectImage();
        this.setImage();
        this.outputFileChoice();
        this.addMouseListener(this);
    }

    private void setWindowSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.windowWidth = dimension.width - 30;
        this.windowHeight = dimension.height - 40;
    }

    private void selectImage() {
        Object object;
        String string = null;
        try {
            object = InetAddress.getLocalHost();
            string = ((InetAddress)object).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Cannot detect local host : " + unknownHostException);
        }
        if (string.equals("name")) {
            this.path = "C:\\DigiGraphDirectory";
        }
        object = new FileChooser(this.path);
        this.imageName = ((FileChooser)object).selectFile();
        if (!((FileInput)object).fileFound()) {
            System.out.println("Class DigiGraph: No successful selection of an image file occurred");
            System.exit(0);
        }
        this.imagePath = ((FileInput)object).getPathName();
        int n = this.imagePath.lastIndexOf(46);
        this.extension = this.imagePath.substring(n + 1);
        if (this.extension.equalsIgnoreCase("gif")) {
            this.imageFormat = 1;
        }
        if (this.extension.equalsIgnoreCase("jpg")) {
            this.imageFormat = 2;
        }
        if (this.extension.equalsIgnoreCase("jpeg")) {
            this.imageFormat = 2;
        }
        if (this.extension.equalsIgnoreCase("jpe")) {
            this.imageFormat = 2;
        }
        if (this.extension.equalsIgnoreCase("jfif")) {
            this.imageFormat = 2;
        }
        if (this.extension.equalsIgnoreCase("png")) {
            this.imageFormat = 3;
        }
    }

    private void setImage() {
        this.pic = Toolkit.getDefaultToolkit().getImage(this.imagePath);
    }

    private void outputFileChoice() {
        int n = this.imagePath.lastIndexOf(46);
        this.outputFile = this.imagePath.substring(0, n) + "_digitized.txt";
        this.outputFile = Db.readLine("Enter output file name ", this.outputFile);
        this.fout = new FileOutput(this.outputFile);
        this.trunc = Db.readInt("Enter number of decimal places required in output data ", this.trunc);
    }

    public void setTruncation(int n) {
        this.trunc = n;
    }

    public void setRotationTolerance(double d) {
        this.angleTolerance = d;
    }

    public void noPlot() {
        this.plotOpt = false;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public void setWindowHeight(int n) {
        this.windowHeight = n;
    }

    public void setWindowWidth(int n) {
        this.windowWidth = n;
    }

    public void setCloseChoice(int n) {
        this.closeChoice = n;
    }

    public void keepIdenticalPoints() {
        this.noIdentical = false;
    }

    @Override
    public void paint(Graphics graphics) {
        this.graph(graphics);
    }

    public void digitize() {
        this.window.setSize(this.windowWidth, this.windowHeight);
        this.window.getContentPane().setBackground(Color.white);
        if (this.closeChoice == 1) {
            this.window.setDefaultCloseOperation(3);
        } else {
            this.window.setDefaultCloseOperation(1);
        }
        this.window.getContentPane().add("Center", this);
        this.window.pack();
        this.window.setResizable(true);
        this.window.toFront();
        this.window.setVisible(true);
    }

    public void digitise() {
        this.digitize();
    }

    private void graph(Graphics graphics) {
        int n;
        graphics.drawImage(this.pic, 10, 30, this);
        if (!this.resize) {
            graphics.drawString("RIGHT click anywhere on the screen", 5, 10);
            n = this.pic.getWidth(null);
            int n2 = this.pic.getHeight(null);
            System.out.println(n + " xxx " + n2);
            graphics.drawString("  ", 5, 10);
            double d = (double)(this.windowHeight - 30) / (double)n2;
            if ((int)((double)n * d) > this.windowWidth - 10) {
                d = (double)(this.windowWidth - 10) / (double)n;
            }
            n2 = (int)((double)(n2 - 30) * d * 0.95);
            n = (int)((double)(n - 10) * d + 0.95);
            this.pic = this.pic.getScaledInstance(n, n2, 1);
            graphics.drawImage(this.pic, 10, 30, this);
            this.resize = true;
        }
        n = 1;
        if (this.xPos == 0 && this.yPos == 0) {
            n = 0;
        }
        if (n != 0) {
            this.cursorDoneSign(graphics, this.xPos, this.yPos);
        }
        if (!this.digitizationDone) {
            switch (this.iCounter) {
                case 0: {
                    graphics.drawString("RIGHT click on lower Y-axis calibration point", 5, 10);
                    break;
                }
                case 1: {
                    if (this.noYlow) {
                        this.lowYvalue = Db.readDouble("Enter lower Y-axis calibration value");
                        this.noYlow = false;
                    }
                    graphics.drawString("RIGHT click on higher Y-axis calibration point", 5, 10);
                    break;
                }
                case 2: {
                    if (this.noYhigh) {
                        this.highYvalue = Db.readDouble("Enter higher Y-axis calibration value");
                        this.noYhigh = false;
                    }
                    graphics.drawString("RIGHT click on lower X-axis calibration point", 5, 10);
                    break;
                }
                case 3: {
                    if (this.noXlow) {
                        this.lowXvalue = Db.readDouble("Enter lower X-axis calibration value");
                        this.noXlow = false;
                    }
                    graphics.drawString("RIGHT click on higher X-axis calibration point", 5, 10);
                    break;
                }
                case 4: {
                    if (this.noXhigh) {
                        this.highXvalue = Db.readDouble("Enter higher X-axis calibration value");
                        this.noXhigh = false;
                    }
                    graphics.drawString("LEFT click on points to be digitized [right click when finished digitizing]", 5, 10);
                    break;
                }
                default: {
                    graphics.drawString("LEFT click on points to be digitized [right click when finished digitizing]", 5, 10);
                    break;
                }
            }
        } else {
            graphics.drawString("You may now close this window", 5, 10);
        }
    }

    private void cursorDoneSign(Graphics graphics, int n, int n2) {
        graphics.drawLine(n - 5, n2, n + 5, n2);
        graphics.drawLine(n, n2 - 5, n, n2 + 5);
        graphics.fillOval(n - 3, n2 - 3, 7, 7);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.digitizationDone) {
            switch (this.iCounter) {
                case 0: {
                    this.xPos = mouseEvent.getX();
                    this.yPos = mouseEvent.getY();
                    this.button = mouseEvent.getButton();
                    if (this.button == 1) {
                        this.sumX += this.xPos;
                        this.sumY += this.yPos;
                        ++this.iSum;
                        break;
                    }
                    if (this.button != 3) break;
                    this.sumX += this.xPos;
                    this.sumY += this.yPos;
                    ++this.iSum;
                    this.lowYaxisXpixel = (double)this.sumX / (double)this.iSum;
                    this.lowYaxisYpixel = (double)this.windowHeight - (double)this.sumY / (double)this.iSum;
                    ++this.iCounter;
                    this.sumX = 0;
                    this.sumY = 0;
                    this.iSum = 0;
                    break;
                }
                case 1: {
                    this.xPos = mouseEvent.getX();
                    this.yPos = mouseEvent.getY();
                    this.button = mouseEvent.getButton();
                    if (this.button == 1) {
                        this.sumX += this.xPos;
                        this.sumY += this.yPos;
                        ++this.iSum;
                        break;
                    }
                    if (this.button != 3) break;
                    this.sumX += this.xPos;
                    this.sumY += this.yPos;
                    ++this.iSum;
                    this.highYaxisXpixel = (double)this.sumX / (double)this.iSum;
                    this.highYaxisYpixel = (double)this.windowHeight - (double)this.sumY / (double)this.iSum;
                    ++this.iCounter;
                    this.sumX = 0;
                    this.sumY = 0;
                    this.iSum = 0;
                    break;
                }
                case 2: {
                    this.xPos = mouseEvent.getX();
                    this.yPos = mouseEvent.getY();
                    this.button = mouseEvent.getButton();
                    if (this.button == 1) {
                        this.sumX += this.xPos;
                        this.sumY += this.yPos;
                        ++this.iSum;
                        break;
                    }
                    if (this.button != 3) break;
                    this.sumX += this.xPos;
                    this.sumY += this.yPos;
                    ++this.iSum;
                    this.lowXaxisXpixel = (double)this.sumX / (double)this.iSum;
                    this.lowXaxisYpixel = (double)this.windowHeight - (double)this.sumY / (double)this.iSum;
                    ++this.iCounter;
                    this.sumX = 0;
                    this.sumY = 0;
                    this.iSum = 0;
                    break;
                }
                case 3: {
                    this.xPos = mouseEvent.getX();
                    this.yPos = mouseEvent.getY();
                    this.button = mouseEvent.getButton();
                    PixelGrabber pixelGrabber = new PixelGrabber(this.pic, this.xPos, this.yPos, 1, 1, false);
                    if (this.button == 1) {
                        this.sumX += this.xPos;
                        this.sumY += this.yPos;
                        ++this.iSum;
                        break;
                    }
                    if (this.button != 3) break;
                    this.sumX += this.xPos;
                    this.sumY += this.yPos;
                    ++this.iSum;
                    this.highXaxisXpixel = (double)this.sumX / (double)this.iSum;
                    this.highXaxisYpixel = (double)this.windowHeight - (double)this.sumY / (double)this.iSum;
                    ++this.iCounter;
                    this.sumX = 0;
                    this.sumY = 0;
                    this.iSum = 0;
                    break;
                }
                default: {
                    this.xPos = mouseEvent.getX();
                    this.yPos = mouseEvent.getY();
                    this.button = mouseEvent.getButton();
                    if (this.button == 1) {
                        this.xAndYvalues.add(new Integer(this.xPos));
                        this.xAndYvalues.add(new Integer(this.yPos));
                    }
                    if (this.button != 3 || this.xAndYvalues.size() / 2 == 0) break;
                    this.outputData();
                    this.digitizationDone = true;
                }
            }
        }
        this.repaint();
    }

    private void outputData() {
        int n;
        int n2;
        int n3;
        this.nData = this.xAndYvalues.size() / 2;
        System.out.println("nData " + this.nData);
        this.xPositions = new double[this.nData];
        this.yPositions = new double[this.nData];
        this.xPosPixel = new double[this.nData];
        this.yPosPixel = new double[this.nData];
        int n4 = 0;
        for (n3 = 0; n3 < this.nData; ++n3) {
            n2 = this.xAndYvalues.get(n4);
            n = this.xAndYvalues.get(++n4);
            ++n4;
            this.xPosPixel[n3] = n2;
            this.yPosPixel[n3] = (double)this.windowHeight - (double)n;
        }
        this.checkForRotation();
        for (n3 = 0; n3 < this.nData; ++n3) {
            this.xPositions[n3] = this.lowXvalue + (this.xPosPixel[n3] - this.lowXaxisXpixel) * (this.highXvalue - this.lowXvalue) / (this.highXaxisXpixel - this.lowXaxisXpixel);
            this.yPositions[n3] = this.lowYvalue + (this.yPosPixel[n3] - this.lowYaxisYpixel) * (this.highYvalue - this.lowYvalue) / (this.highYaxisYpixel - this.lowYaxisYpixel);
        }
        if (this.noIdentical) {
            this.checkForIdenticalPoints();
        }
        String string = "Do you wish to increase number of data points\n";
        n2 = Db.noYes(string = string + "using cubic spline interpolation?") ? 1 : 0;
        if (n2 != 0) {
            this.nInterpPoints = Db.readInt("Enter number of interpolation points", 200);
            this.interpolation();
            this.interpOpt = true;
        } else if (this.plotOpt) {
            this.plotDigitisedPoints();
        }
        this.fout.println("Digitization output for DigiGraph class (M. T. Flanagan Java Library)");
        this.fout.println();
        this.fout.dateAndTimeln();
        this.fout.println();
        this.fout.println("Image used in the digitization:                 " + this.imageName);
        this.fout.println("Location of the image used in the digitization: " + this.imagePath);
        this.fout.println();
        this.fout.println("X-axis skew angle    " + Fmath.truncate(this.angleXaxis, 4) + " degrees");
        this.fout.println("Y-axis skew angle    " + Fmath.truncate(this.angleYaxis, 4) + " degrees");
        this.fout.println("Axes mean skew angle " + Fmath.truncate(this.angleMean, 4) + " degrees");
        if (this.rotationDone) {
            this.fout.println("Axes and all points rotated to bring axes to normal position");
        } else {
            this.fout.println("No rotation of axes or points performed");
        }
        this.fout.println();
        this.fout.println("Number of digitized points: " + this.nData);
        this.fout.println();
        this.fout.printtab("X-value");
        this.fout.println("Y-value");
        for (n = 0; n < this.nData; ++n) {
            this.fout.printtab(Fmath.truncate(this.xPositions[n], this.trunc));
            this.fout.println(Fmath.truncate(this.yPositions[n], this.trunc));
        }
        this.fout.println();
        if (this.interpOpt) {
            this.fout.println();
            this.fout.println("Interpolated data (cubic spline)");
            this.fout.println();
            this.fout.println("Number of interpolated points: " + this.nInterpPoints);
            this.fout.println();
            this.fout.printtab("X-value");
            this.fout.println("Y-value");
            for (n = 0; n < this.nInterpPoints; ++n) {
                this.fout.printtab(Fmath.truncate(this.xInterp[n], this.trunc));
                this.fout.println(Fmath.truncate(this.yInterp[n], this.trunc));
            }
        }
        this.fout.close();
    }

    private void checkForRotation() {
        double d = (this.highYaxisXpixel - this.lowYaxisXpixel) / (this.highYaxisYpixel - this.lowYaxisYpixel);
        this.angleYaxis = Math.toDegrees(Math.atan(d));
        d = (this.lowXaxisYpixel - this.highXaxisYpixel) / (this.highXaxisXpixel - this.lowXaxisXpixel);
        this.angleXaxis = Math.toDegrees(Math.atan(d));
        this.angleMean = (this.angleXaxis + this.angleYaxis) / 2.0;
        double d2 = Math.abs(this.angleMean);
        if (d2 != 0.0 && d2 > this.angleTolerance) {
            this.performRotation();
        }
    }

    private void performRotation() {
        double d = (this.highXaxisYpixel - this.lowXaxisYpixel) / (this.highXaxisXpixel - this.lowXaxisXpixel);
        double d2 = this.highXaxisYpixel - d * this.highXaxisXpixel;
        double d3 = (this.highYaxisYpixel - this.lowYaxisYpixel) / (this.highYaxisXpixel - this.lowYaxisXpixel);
        double d4 = this.highYaxisYpixel - d3 * this.highYaxisXpixel;
        double d5 = (d2 - d4) / (d3 - d);
        double d6 = d3 * d5 + d4;
        double d7 = Math.toRadians(this.angleMean);
        double d8 = Math.cos(-d7);
        double d9 = Math.sin(-d7);
        double d10 = (this.highXaxisXpixel - d5) * d8 + (this.highXaxisYpixel - d6) * d9 + d5;
        double d11 = -(this.highXaxisXpixel - d5) * d9 + (this.highXaxisYpixel - d6) * d8 + d6;
        double d12 = (this.lowXaxisXpixel - d5) * d8 + (this.lowXaxisYpixel - d6) * d9 + d5;
        double d13 = -(this.lowXaxisXpixel - d5) * d9 + (this.lowXaxisYpixel - d6) * d8 + d6;
        double d14 = (this.highYaxisXpixel - d5) * d8 + (this.highYaxisYpixel - d6) * d9 + d5;
        double d15 = -(this.highYaxisXpixel - d5) * d9 + (this.highYaxisYpixel - d6) * d8 + d6;
        double d16 = -(this.lowYaxisXpixel - d5) * d8 + (this.lowYaxisYpixel - d6) * d9 + d5;
        double d17 = (this.lowYaxisXpixel - d5) * d9 + (this.lowYaxisYpixel - d6) * d8 + d6;
        this.highXaxisXpixel = d10;
        this.highXaxisYpixel = d11;
        this.lowXaxisXpixel = d12;
        this.lowXaxisYpixel = d13;
        this.highYaxisXpixel = d14;
        this.highYaxisYpixel = d15;
        this.lowYaxisXpixel = d16;
        this.lowYaxisYpixel = d17;
        for (int j = 0; j < this.nData; ++j) {
            double d18 = (this.xPosPixel[j] - d5) * d8 + (this.yPosPixel[j] - d6) * d9 + d5;
            double d19 = -(this.xPosPixel[j] - d5) * d9 + (this.yPosPixel[j] - d6) * d8 + d6;
            this.xPosPixel[j] = d18;
            this.yPosPixel[j] = d19;
        }
        this.rotationDone = true;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseEntered = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseEntered = false;
        this.repaint();
    }

    private void interpolation() {
        int n;
        this.xInterp = new double[this.nInterpPoints];
        this.yInterp = new double[this.nInterpPoints];
        double d = (this.xPositions[this.nData - 1] - this.xPositions[0]) / (double)(this.nInterpPoints - 1);
        this.xInterp[0] = this.xPositions[0];
        for (int j = 1; j < this.nInterpPoints - 1; ++j) {
            this.xInterp[j] = this.xInterp[j - 1] + d;
        }
        this.xInterp[this.nInterpPoints - 1] = this.xPositions[this.nData - 1];
        CubicSpline cubicSpline = new CubicSpline(this.xPositions, this.yPositions);
        for (n = 0; n < this.nInterpPoints; ++n) {
            this.yInterp[n] = cubicSpline.interpolate(this.xInterp[n]);
        }
        if (this.plotOpt) {
            n = Math.max(this.nInterpPoints, this.nData);
            double[][] dArray = PlotGraph.data(2, n);
            dArray[0] = this.xPositions;
            dArray[1] = this.yPositions;
            dArray[2] = this.xInterp;
            dArray[3] = this.yInterp;
            PlotGraph plotGraph = new PlotGraph(dArray);
            plotGraph.setGraphTitle("Cubic Spline Interpolation of Digitised Points");
            plotGraph.setGraphTitle2(this.imagePath);
            plotGraph.setXaxisLegend("x");
            plotGraph.setYaxisLegend("y");
            int[] nArray = new int[]{0, 3};
            plotGraph.setLine(nArray);
            int[] nArray2 = new int[]{4, 0};
            plotGraph.setPoint(nArray2);
            plotGraph.plot();
        }
    }

    public void checkForIdenticalPoints() {
        int n;
        int n2 = this.nData;
        boolean bl = true;
        int n3 = 0;
        while (bl) {
            boolean bl2 = true;
            int n4 = n3 + 1;
            while (bl2) {
                System.out.println("ii " + n3 + "  jj  " + n4);
                if (this.xPositions[n3] == this.xPositions[n4] && this.yPositions[n3] == this.yPositions[n4]) {
                    System.out.print("Class DigiGraph: two identical points, " + this.xPositions[n3] + ", " + this.yPositions[n3]);
                    System.out.println(", in data array at indices " + n3 + " and " + n4 + ", one point removed");
                    for (n = n4; n < n2; ++n) {
                        this.xPositions[n - 1] = this.xPositions[n];
                        this.yPositions[n - 1] = this.yPositions[n];
                    }
                    if (--n2 - 1 != n3) continue;
                    bl2 = false;
                    continue;
                }
                if (++n4 < n2) continue;
                bl2 = false;
            }
            if (++n3 < n2 - 1) continue;
            bl = false;
        }
        if (n2 != this.nData) {
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            for (n = 0; n < n2; ++n) {
                dArray[n] = this.xPositions[n];
                dArray2[n] = this.yPositions[n];
            }
            this.xPositions = dArray;
            this.yPositions = dArray2;
            this.nData = n2;
        }
    }

    private void plotDigitisedPoints() {
        double[][] dArray = PlotGraph.data(1, this.nData);
        dArray[0] = this.xPositions;
        dArray[1] = this.yPositions;
        PlotGraph plotGraph = new PlotGraph(dArray);
        plotGraph.setGraphTitle("Plot of the Digitised Points");
        plotGraph.setGraphTitle2(this.imagePath);
        plotGraph.setXaxisLegend("x");
        plotGraph.setYaxisLegend("y");
        int[] nArray = new int[]{0};
        plotGraph.setLine(nArray);
        int[] nArray2 = new int[]{4};
        plotGraph.setPoint(nArray2);
        plotGraph.plot();
    }
}

