/*
 * Decompiled with CFR 0.152.
 */
package flanagan.io;

import flanagan.circuits.Phasor;
import flanagan.complex.Complex;
import flanagan.io.FileOutput;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;

public class FileInput {
    protected String fileName = " ";
    protected String stemName = " ";
    protected String extension = " ";
    protected String pathName = " ";
    protected String dirPath = " ";
    protected String fullLine = " ";
    protected String fullLineT = " ";
    protected BufferedReader input = null;
    protected boolean testFullLine = false;
    protected boolean testFullLineT = false;
    protected boolean eof = false;
    protected boolean fileFound = true;
    protected boolean inputType = false;
    protected boolean charType = false;
    protected boolean space = true;
    protected boolean supressMessage = false;
    protected boolean wordMethod = false;
    protected String holdingWord = "HoldingWordMLPYGV";

    public FileInput() {
    }

    public FileInput(String string) {
        int n;
        this.pathName = string;
        this.fileName = string;
        int n2 = string.indexOf("//");
        int n3 = string.indexOf("\\");
        if (n2 != -1 || n3 != -1) {
            File file = new File(this.pathName);
            this.fileName = file.getName();
            this.dirPath = file.getParentFile().toString();
        }
        if ((n = this.fileName.indexOf(46)) == -1) {
            this.stemName = this.fileName;
        } else {
            this.stemName = this.fileName.substring(0, n);
            this.extension = this.fileName.substring(n);
        }
        try {
            this.input = new BufferedReader(new FileReader(this.pathName));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.fileFound = false;
        }
    }

    public FileInput(String string, int n) {
        int n2;
        this.pathName = string;
        this.fileName = string;
        int n3 = string.indexOf("//");
        int n4 = string.indexOf("\\");
        if (n3 != -1 || n4 != -1) {
            File file = new File(this.pathName);
            this.fileName = file.getName();
            this.dirPath = file.getParentFile().toString();
        }
        if ((n2 = this.fileName.indexOf(46)) == -1) {
            this.stemName = this.fileName;
        } else {
            this.stemName = this.fileName.substring(0, n2);
            this.extension = this.fileName.substring(n2);
        }
        try {
            this.input = new BufferedReader(new FileReader(this.pathName));
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (n == 1) {
                System.out.println(fileNotFoundException);
            }
            this.fileFound = false;
        }
    }

    public String getPathName() {
        return this.pathName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getStemName() {
        return this.stemName;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public void removeSpaceAsDelimiter() {
        this.space = false;
    }

    public void restoreSpaceAsDelimiter() {
        this.space = true;
    }

    public final synchronized void copy(String string) {
        FileOutput fileOutput = new FileOutput(string);
        int n = this.numberOfLines();
        for (int j = 0; j < n; ++j) {
            String string2 = this.readLine();
            fileOutput.println(string2);
        }
        fileOutput.close();
    }

    public final synchronized double readDouble() {
        this.inputType = true;
        String string = "";
        double d = 0.0;
        if (!this.testFullLineT) {
            this.enterLine();
        }
        string = this.nextWord();
        if (!this.eof) {
            d = Double.parseDouble(string.trim());
        }
        return d;
    }

    public final synchronized float readFloat() {
        this.inputType = true;
        String string = "";
        float f = 0.0f;
        if (!this.testFullLineT) {
            this.enterLine();
        }
        string = this.nextWord();
        if (!this.eof) {
            f = Float.parseFloat(string.trim());
        }
        return f;
    }

    public final synchronized BigDecimal readBigDecimal() {
        this.inputType = true;
        String string = "";
        BigDecimal bigDecimal = null;
        if (!this.testFullLineT) {
            this.enterLine();
        }
        string = this.nextWord();
        if (!this.eof) {
            bigDecimal = new BigDecimal(string.trim());
        }
        return bigDecimal;
    }

    public final synchronized int readInt() {
        this.inputType = true;
        String string = "";
        int n = 0;
        if (!this.testFullLineT) {
            this.enterLine();
        }
        string = this.nextWord();
        if (!this.eof) {
            n = Integer.parseInt(string.trim());
        }
        return n;
    }

    public final synchronized long readLong() {
        this.inputType = true;
        String string = "";
        long l = 0L;
        if (!this.testFullLineT) {
            this.enterLine();
        }
        string = this.nextWord();
        if (!this.eof) {
            l = Long.parseLong(string.trim());
        }
        return l;
    }

    public final synchronized BigInteger readBigInteger() {
        this.inputType = true;
        String string = "";
        BigInteger bigInteger = null;
        if (!this.testFullLineT) {
            this.enterLine();
        }
        string = this.nextWord();
        if (!this.eof) {
            bigInteger = new BigInteger(string.trim());
        }
        return bigInteger;
    }

    public final synchronized short readShort() {
        this.inputType = true;
        String string = "";
        short s = 0;
        if (!this.testFullLineT) {
            this.enterLine();
        }
        string = this.nextWord();
        if (!this.eof) {
            s = Short.parseShort(string.trim());
        }
        return s;
    }

    public final synchronized byte readByte() {
        this.inputType = true;
        String string = "";
        byte by = 0;
        if (!this.testFullLineT) {
            this.enterLine();
        }
        string = this.nextWord();
        if (!this.eof) {
            by = Byte.parseByte(string.trim());
        }
        return by;
    }

    public final synchronized Complex readComplex() {
        this.inputType = true;
        String string = "";
        Complex complex = null;
        if (!this.testFullLineT) {
            this.enterLine();
        }
        string = this.nextWord();
        if (!this.eof) {
            complex = Complex.parseComplex(string.trim());
        }
        return complex;
    }

    public final synchronized Phasor readPhasor() {
        this.inputType = true;
        String string = "";
        Phasor phasor = null;
        if (!this.testFullLineT) {
            this.enterLine();
        }
        string = this.nextWord();
        if (!this.eof) {
            phasor = Phasor.parsePhasor(string.trim());
        }
        return phasor;
    }

    public final synchronized boolean readBoolean() {
        boolean bl = true;
        String string = this.readWord();
        if (string.equals("false") || string.equals("FALSE")) {
            bl = false;
        } else if (string.equals("true") || string.equals("TRUE")) {
            bl = true;
        } else {
            throw new IllegalArgumentException("attempted input neither true nor false");
        }
        return bl;
    }

    public final synchronized String readWord() {
        this.inputType = true;
        this.wordMethod = true;
        String string = "";
        if (!this.testFullLineT) {
            this.enterLine();
        }
        if (this.fullLine.equals("")) {
            string = " ";
        } else {
            string = this.nextWord();
            if (string.equals("")) {
                string = " ";
            }
            if (string.trim().equals(this.holdingWord)) {
                string = " ";
            }
        }
        return string;
    }

    public final synchronized String readWordSaceOnly() {
        this.inputType = false;
        String string = "";
        if (!this.testFullLineT) {
            this.enterLine();
        }
        if (this.fullLine.equals("")) {
            string = "";
        } else {
            string = this.nextWord();
            if (string.equals("")) {
                string = " ";
            }
        }
        return string;
    }

    public final synchronized String readLine() {
        this.inputType = false;
        return this.readLineL();
    }

    protected final synchronized String readLineL() {
        String string = "";
        try {
            string = this.input.readLine();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        if (string == null) {
            if (!this.supressMessage) {
                System.out.println("Attempt to read beyond the end of the file");
            }
            this.eof = true;
            string = "";
        }
        return string;
    }

    public final synchronized char readChar() {
        this.inputType = true;
        this.charType = true;
        String string = "";
        char c = ' ';
        if (!this.testFullLine) {
            this.enterLine();
        }
        if ((string = this.nextWord()).length() != 1) {
            throw new IllegalArgumentException("attempt to read more than one character into type char");
        }
        if (!this.eof) {
            c = string.charAt(0);
        }
        return c;
    }

    public final synchronized void close() {
        if (this.fileFound) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
    }

    public boolean eol() {
        boolean bl = false;
        if (!this.testFullLineT) {
            bl = true;
        }
        return bl;
    }

    public boolean eof() {
        return this.eof;
    }

    public boolean fileFound() {
        return this.fileFound;
    }

    protected final synchronized void enterLine() {
        int n = 0;
        this.fullLine = this.readLineL();
        if (this.wordMethod) {
            this.checkWordSpaces();
        }
        this.fullLineT = this.fullLine;
        if (!this.fullLine.equals("")) {
            for (n = this.fullLineT.length() - 1; this.fullLineT.charAt(n) == ' ' && n >= 0; --n) {
                this.fullLineT = this.fullLineT.substring(0, n);
            }
        }
    }

    public void checkWordSpaces() {
        int n = this.fullLine.length();
        if (this.wordMethod) {
            int n2;
            boolean bl = false;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (n2 = 0; n2 < n; ++n2) {
                bl = false;
                if (this.fullLine.charAt(n2) == '\t') {
                    bl = true;
                }
                if (this.fullLine.charAt(n2) == ',') {
                    bl = true;
                }
                if (this.fullLine.charAt(n2) == ':') {
                    bl = true;
                }
                if (this.fullLine.charAt(n2) == ';') {
                    bl = true;
                }
                if (!bl) continue;
                arrayList.add(new Integer(n2));
            }
            n2 = arrayList.size();
            if (n2 > 0) {
                int n3;
                boolean bl2 = true;
                boolean bl3 = true;
                boolean bl4 = false;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                while (bl2) {
                    bl3 = true;
                    bl4 = false;
                    n5 = (Integer)arrayList.get(n4);
                    if (n5 == 0) {
                        bl4 = true;
                    } else if (n5 == n - 1) {
                        bl4 = true;
                        bl2 = false;
                    } else if (n4 == n2 - 1) {
                        bl3 = true;
                        for (n3 = n5 + 1; n3 < n; ++n3) {
                            if (this.fullLine.charAt(n3) != ' ') {
                                bl3 = false;
                            }
                            if (!bl3) break;
                        }
                        if (bl3) {
                            bl4 = true;
                        }
                        bl2 = false;
                    } else {
                        n6 = (Integer)arrayList.get(n4 + 1);
                        bl3 = true;
                        for (n3 = n5 + 1; n3 < n6; ++n3) {
                            if (this.fullLine.charAt(n3) != ' ') {
                                bl3 = false;
                            }
                            if (!bl3) break;
                        }
                        if (bl3) {
                            bl4 = true;
                        }
                        ++n4;
                    }
                    if (bl4) {
                        arrayList2.add(new Integer(n5 + 1));
                    }
                    if (n4 < n2) continue;
                    bl2 = false;
                }
                n3 = arrayList2.size();
                if (n3 > 0) {
                    for (int j = n3 - 1; j >= 0; --j) {
                        int n7 = (Integer)arrayList2.get(j);
                        if (n7 >= n - 1) {
                            this.fullLine = this.fullLine + this.holdingWord;
                            continue;
                        }
                        if (n7 == 1) {
                            this.fullLine = this.holdingWord + this.fullLine;
                            continue;
                        }
                        String string = this.fullLine.substring(0, n7);
                        String string2 = this.fullLine.substring(n7);
                        this.fullLine = string + this.holdingWord + string2;
                    }
                }
            }
        }
    }

    protected final synchronized String nextWord() {
        this.testFullLine = true;
        this.testFullLineT = true;
        String string = "";
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        boolean bl = true;
        int n7 = this.fullLine.length();
        boolean bl2 = true;
        boolean bl3 = false;
        int n8 = this.fullLine.length();
        while (bl2) {
            if (this.fullLine.charAt(--n8) == ' ') {
                bl3 = true;
            }
            if (this.fullLine.charAt(n8) == '\t') {
                bl3 = true;
            }
            if (this.inputType) {
                if (this.fullLine.charAt(n8) == ',') {
                    bl3 = true;
                }
                if (this.fullLine.charAt(n8) == ':') {
                    bl3 = true;
                }
                if (this.fullLine.charAt(n8) == ';') {
                    bl3 = true;
                }
            }
            if (bl3) {
                this.fullLine = this.fullLine.substring(0, n8);
            } else {
                bl2 = false;
            }
            bl3 = false;
        }
        bl2 = true;
        bl3 = false;
        while (bl2) {
            if (this.fullLine.charAt(0) == ' ') {
                bl3 = true;
            }
            if (this.fullLine.charAt(0) == '\t') {
                bl3 = true;
            }
            if (this.inputType) {
                if (this.fullLine.charAt(0) == ',') {
                    bl3 = true;
                }
                if (this.fullLine.charAt(0) == ':') {
                    bl3 = true;
                }
                if (this.fullLine.charAt(0) == ';') {
                    bl3 = true;
                }
            }
            if (bl3) {
                this.fullLine = this.fullLine.substring(1);
            } else {
                bl2 = false;
            }
            bl3 = false;
        }
        int n9 = this.fullLine.length() + 10;
        if (this.space) {
            n = this.fullLine.indexOf(32);
        }
        n2 = this.fullLine.indexOf(9);
        int n10 = n9;
        int n11 = n9;
        int n12 = n9;
        if (this.space) {
            n10 = n == -1 && n2 == -1 ? n9 : (n == -1 ? n2 : (n2 == -1 ? n : Math.min(n, n2)));
        } else if (n2 != -1) {
            n10 = n2;
        }
        if (this.inputType) {
            n4 = this.fullLine.indexOf(44);
            n5 = this.fullLine.indexOf(58);
            n6 = this.fullLine.indexOf(59);
            n11 = n4 == -1 && n5 == -1 ? n9 : (n4 == -1 ? n5 : (n5 == -1 ? n4 : Math.min(n4, n5)));
            n12 = n6 == -1 ? n9 : n6;
            n11 = Math.min(n11, n12);
            n10 = Math.min(n10, n11);
        }
        if (n10 == n9) {
            string = this.fullLine;
            this.fullLine = "";
            this.testFullLine = false;
        } else {
            string = this.fullLine.substring(0, n10);
            if (n10 + 1 > this.fullLine.length()) {
                this.fullLine = "";
                this.testFullLine = false;
            } else {
                this.fullLine = this.fullLine.substring(n10 + 1);
                if (this.fullLine.length() == 0) {
                    this.testFullLine = false;
                }
            }
        }
        if (this.testFullLineT) {
            if (!this.testFullLine) {
                this.testFullLineT = false;
                this.fullLineT = "";
            } else if (n10 + 1 > this.fullLineT.length()) {
                this.fullLineT = "";
                this.testFullLineT = false;
            }
        }
        return string;
    }

    protected final synchronized char nextCharInString() {
        this.testFullLine = true;
        char c = ' ';
        boolean bl = true;
        c = this.fullLine.charAt(0);
        this.fullLine = this.fullLine.substring(1);
        if (this.fullLine.length() == 0) {
            this.testFullLine = false;
        }
        if (this.testFullLineT) {
            this.fullLineT = this.fullLineT.substring(1);
            if (this.fullLineT.length() == 0) {
                this.testFullLineT = false;
            }
        }
        return c;
    }

    public void setSupressMessageToTrue() {
        this.supressMessage = true;
    }

    public void setSupressMessageToFalse() {
        this.supressMessage = false;
    }

    public final synchronized int numberOfLines() {
        FileInput fileInput = new FileInput(this.pathName);
        fileInput.setSupressMessageToTrue();
        boolean bl = true;
        int n = 0;
        while (bl) {
            String string = fileInput.readLineL();
            if (fileInput.eof) {
                bl = false;
                continue;
            }
            if (n == Integer.MAX_VALUE) {
                System.out.println("Class FileInput; method numberOfLines; The number of lines is greater than the maximum integer value, 2147483647");
                System.out.println("-1 returned");
                n = -1;
                continue;
            }
            ++n;
        }
        fileInput.close();
        return n;
    }

    public boolean deleteFile() {
        return FileInput.deleteFile(this.pathName);
    }

    public static boolean deleteFile(String string) {
        boolean bl;
        String[] stringArray;
        boolean bl2 = true;
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("Method deleteFile: no file or directory of the name " + string + " found");
            bl2 = false;
        }
        if (!file.canWrite()) {
            System.out.println("Method deleteFile: " + string + " is write protected and cannot be deleted");
            bl2 = false;
        }
        if (file.isDirectory() && (stringArray = file.list()).length > 0) {
            System.out.println("Method deleteFile: " + string + " is a directory which is not empty; no action was taken");
            bl2 = false;
        }
        if (!(bl = file.delete())) {
            System.out.println("Method deleteFile: deletion of the file " + string + " failed");
        }
        return bl2;
    }

    public int renameFile(String string) {
        return FileInput.renameFile(this.pathName, string);
    }

    public static int renameFile(String string, String string2) {
        boolean bl = true;
        int n = 0;
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("file " + string + " does not exist");
            return 1;
        }
        File file2 = new File(string2);
        if (file2.exists() && !(bl = FileInput.deleteFile(string2))) {
            System.out.println("Class FileInput: method renameFile failed to delete the file " + string2);
            return 2;
        }
        bl = file.renameTo(file2);
        if (!bl) {
            System.out.println("Class FileInput: method renameFile failed to rename the file " + string + " to " + string2);
            return 3;
        }
        return n;
    }
}

