/*
 * Decompiled with CFR 0.152.
 */
package flanagan.io;

import flanagan.io.FileInput;
import flanagan.io.FileTypeFilter;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class MultipleFilesChooser {
    private String[] fileNames = null;
    private String[] pathNames = null;
    private String[] dirNames = null;
    private String[] stemNames = null;
    private FileInput[] fileObjects = null;
    private int nFiles = 0;
    private String path = null;
    private String extn = null;

    public MultipleFilesChooser() {
        this.path = System.getProperty("user.dir");
    }

    public MultipleFilesChooser(String string) {
        this.path = string;
    }

    public FileInput[] selectFiles() {
        return this.selectFiles("Select File");
    }

    public FileInput[] selectFiles(String string) {
        File[] fileArray;
        JFileChooser jFileChooser = new JFileChooser(this.path);
        jFileChooser.setMultiSelectionEnabled(true);
        if (this.extn != null) {
            fileArray = new FileTypeFilter();
            fileArray.addExtension(this.extn);
            fileArray.setDescription(this.extn + " files");
            jFileChooser.setFileFilter((FileFilter)fileArray);
        } else {
            jFileChooser.setAcceptAllFileFilterUsed(true);
        }
        jFileChooser.setDialogTitle(string);
        jFileChooser.showOpenDialog(null);
        fileArray = jFileChooser.getSelectedFiles();
        this.nFiles = fileArray.length;
        this.fileObjects = new FileInput[this.nFiles];
        this.fileNames = new String[this.nFiles];
        this.stemNames = new String[this.nFiles];
        this.pathNames = new String[this.nFiles];
        this.dirNames = new String[this.nFiles];
        for (int j = 0; j < this.nFiles; ++j) {
            this.fileNames[j] = fileArray[j].getName();
            this.pathNames[j] = fileArray[j].toString();
            this.dirNames[j] = fileArray[j].getParentFile().toString();
            this.fileObjects[j] = new FileInput(this.pathNames[j]);
            int n = this.fileNames[j].indexOf(46);
            this.stemNames[j] = n == -1 ? this.fileNames[j] : this.fileNames[j].substring(0, n);
        }
        return this.fileObjects;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getPath() {
        return this.path;
    }

    public void setExtension(String string) {
        this.extn = string;
    }

    public void setAllExtensions() {
        this.extn = null;
    }

    public String getExtension() {
        return this.extn;
    }

    public int getNumberOfFiles() {
        return this.nFiles;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getStemNames() {
        return this.stemNames;
    }

    public String[] getPathNames() {
        return this.pathNames;
    }

    public String[] getDirPaths() {
        return this.dirNames;
    }

    public final synchronized void close() {
        for (int j = 0; j < this.nFiles; ++j) {
            this.fileObjects[j].close();
        }
    }

    public static final synchronized void endProgram() {
        int n = JOptionPane.showConfirmDialog(null, "Do you wish to end the program", "End Program", 0, 3);
        if (n == 0) {
            System.exit(0);
        } else {
            JOptionPane.showMessageDialog(null, "Now you must press the appropriate escape key/s, e.g. Ctrl C, to exit this program");
        }
    }
}

