/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.analysis.Stat;
import flanagan.circuits.Phasor;
import flanagan.circuits.PhasorMatrix;
import flanagan.complex.Complex;
import flanagan.complex.ComplexMatrix;
import flanagan.io.PrintToScreen;
import flanagan.math.Conv;
import flanagan.math.DeepCopy;
import flanagan.math.Fmath;
import flanagan.math.Matrix;
import flanagan.math.PsRandom;
import flanagan.plot.PlotGraph;
import flanagan.util.Strings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ArrayMaths {
    protected ArrayList<Object> array = null;
    protected int length = 0;
    protected int type = -1;
    protected int[] originalTypes = null;
    protected String[] typeName = new String[]{"double", "Double", "float", "Float", "long", "Long", "int", "Integer", "short", "Short", "byte", "Byte", "BigDecimal", "BigInteger", "Complex", "Phasor", "char", "Character", "String"};
    protected ArrayList<Object> summ = new ArrayList(1);
    protected ArrayList<Object> productt = new ArrayList(1);
    protected int[] sortedIndices = null;
    protected ArrayList<Object> minmax = new ArrayList(2);
    protected int maxIndex = -1;
    protected int minIndex = -1;
    protected boolean sumDone = false;
    protected boolean productDone = false;
    protected boolean sumlongToDouble = false;
    protected boolean productlongToDouble = false;
    protected boolean suppressMessages = false;
    public String[] words = null;
    public String[] sortedWords = null;
    protected char[][] wordChar = null;
    protected char[][] holdWordChar = null;
    protected int[] wordOrder = null;
    protected int[] holdWordOrder = null;
    protected int nWords = 0;
    protected int nLength = 0;
    protected static final Map<Object, Object> integers = new HashMap<Object, Object>();

    protected ArrayMaths() {
        this.array = new ArrayList();
    }

    public ArrayMaths(double[] dArray) {
        int n;
        this.length = dArray.length;
        this.array = new ArrayList(this.length);
        this.type = 0;
        for (n = 0; n < this.length; ++n) {
            this.array.add(new Double(dArray[n]));
        }
        this.originalTypes = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.originalTypes[n] = this.type;
        }
        this.originalTypes = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.originalTypes[n] = this.type;
        }
        this.sortedIndices = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.sortedIndices[n] = n;
        }
        this.minmax();
    }

    public ArrayMaths(Double[] doubleArray) {
        int n;
        this.length = doubleArray.length;
        this.array = new ArrayList(this.length);
        this.type = 1;
        for (n = 0; n < this.length; ++n) {
            this.array.add(doubleArray[n]);
        }
        this.originalTypes = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.originalTypes[n] = this.type;
        }
        this.sortedIndices = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.sortedIndices[n] = n;
        }
        this.minmax();
    }

    public ArrayMaths(long[] lArray) {
        int n;
        this.length = lArray.length;
        this.array = new ArrayList(this.length);
        this.type = 4;
        for (n = 0; n < this.length; ++n) {
            this.array.add(new Long(lArray[n]));
        }
        this.originalTypes = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.originalTypes[n] = this.type;
        }
        this.sortedIndices = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.sortedIndices[n] = n;
        }
        this.minmax();
    }

    public ArrayMaths(Long[] longArray) {
        int n;
        this.length = longArray.length;
        this.array = new ArrayList(this.length);
        this.type = 5;
        for (n = 0; n < this.length; ++n) {
            this.array.add(longArray[n]);
        }
        this.originalTypes = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.originalTypes[n] = this.type;
        }
        this.sortedIndices = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.sortedIndices[n] = n;
        }
        this.minmax();
    }

    public ArrayMaths(float[] fArray) {
        int n;
        this.length = fArray.length;
        this.array = new ArrayList(this.length);
        this.type = 2;
        for (n = 0; n < this.length; ++n) {
            this.array.add(new Float(fArray[n]));
        }
        this.originalTypes = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.originalTypes[n] = this.type;
        }
        this.sortedIndices = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.sortedIndices[n] = n;
        }
        this.minmax();
    }

    public ArrayMaths(Float[] floatArray) {
        int n;
        this.length = floatArray.length;
        this.array = new ArrayList(this.length);
        this.type = 3;
        for (n = 0; n < this.length; ++n) {
            this.array.add(floatArray[n]);
        }
        this.originalTypes = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.originalTypes[n] = this.type;
        }
        this.sortedIndices = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.sortedIndices[n] = n;
        }
        this.minmax();
    }

    public ArrayMaths(int[] nArray) {
        int n;
        this.length = nArray.length;
        this.array = new ArrayList(this.length);
        this.type = 6;
        for (n = 0; n < this.length; ++n) {
            this.array.add(new Integer(nArray[n]));
        }
        this.originalTypes = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.originalTypes[n] = this.type;
        }
        this.sortedIndices = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.sortedIndices[n] = n;
        }
        this.minmax();
    }

    public ArrayMaths(Integer[] integerArray) {
        int n;
        this.length = integerArray.length;
        this.array = new ArrayList(this.length);
        this.type = 7;
        for (n = 0; n < this.length; ++n) {
            this.array.add(integerArray[n]);
        }
        this.originalTypes = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.originalTypes[n] = this.type;
        }
        this.sortedIndices = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.sortedIndices[n] = n;
        }
        this.minmax();
    }

    public ArrayMaths(short[] sArray) {
        int n;
        this.length = sArray.length;
        this.array = new ArrayList(this.length);
        this.type = 8;
        for (n = 0; n < this.length; ++n) {
            this.array.add(new Short(sArray[n]));
        }
        this.originalTypes = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.originalTypes[n] = this.type;
        }
        this.sortedIndices = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.sortedIndices[n] = n;
        }
        this.minmax();
    }

    public ArrayMaths(Short[] shortArray) {
        int n;
        this.length = shortArray.length;
        this.array = new ArrayList(this.length);
        this.type = 9;
        for (n = 0; n < this.length; ++n) {
            this.array.add(shortArray[n]);
        }
        this.originalTypes = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.originalTypes[n] = this.type;
        }
        this.sortedIndices = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.sortedIndices[n] = n;
        }
        this.minmax();
    }

    public ArrayMaths(byte[] byArray) {
        int n;
        this.length = byArray.length;
        this.array = new ArrayList(this.length);
        this.type = 10;
        for (n = 0; n < this.length; ++n) {
            this.array.add(new Byte(byArray[n]));
        }
        this.originalTypes = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.originalTypes[n] = this.type;
        }
        this.sortedIndices = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.sortedIndices[n] = n;
        }
        this.minmax();
    }

    public ArrayMaths(Byte[] byteArray) {
        int n;
        this.length = byteArray.length;
        this.array = new ArrayList(this.length);
        this.type = 11;
        for (n = 0; n < this.length; ++n) {
            this.array.add(byteArray[n]);
        }
        this.originalTypes = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.originalTypes[n] = this.type;
        }
        this.sortedIndices = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.sortedIndices[n] = n;
        }
        this.minmax();
    }

    public ArrayMaths(BigDecimal[] bigDecimalArray) {
        int n;
        this.length = bigDecimalArray.length;
        this.array = new ArrayList(this.length);
        this.type = 12;
        for (n = 0; n < this.length; ++n) {
            this.array.add(bigDecimalArray[n]);
        }
        this.originalTypes = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.originalTypes[n] = this.type;
        }
        this.sortedIndices = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.sortedIndices[n] = n;
        }
        this.minmax();
    }

    public ArrayMaths(BigInteger[] bigIntegerArray) {
        int n;
        this.length = bigIntegerArray.length;
        this.array = new ArrayList(this.length);
        this.type = 13;
        for (n = 0; n < this.length; ++n) {
            this.array.add(bigIntegerArray[n]);
        }
        this.originalTypes = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.originalTypes[n] = this.type;
        }
        this.sortedIndices = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.sortedIndices[n] = n;
        }
        this.minmax();
    }

    public ArrayMaths(Complex[] complexArray) {
        int n;
        this.length = complexArray.length;
        this.array = new ArrayList(this.length);
        this.type = 14;
        for (n = 0; n < this.length; ++n) {
            this.array.add(complexArray[n]);
        }
        this.originalTypes = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.originalTypes[n] = this.type;
        }
        this.sortedIndices = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.sortedIndices[n] = n;
        }
    }

    public ArrayMaths(Phasor[] phasorArray) {
        int n;
        this.length = phasorArray.length;
        this.array = new ArrayList(this.length);
        this.type = 15;
        for (n = 0; n < this.length; ++n) {
            this.array.add(phasorArray[n]);
        }
        this.originalTypes = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.originalTypes[n] = this.type;
        }
        this.sortedIndices = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.sortedIndices[n] = n;
        }
    }

    public ArrayMaths(char[] cArray) {
        int n;
        this.length = cArray.length;
        this.array = new ArrayList(this.length);
        this.type = 16;
        for (n = 0; n < this.length; ++n) {
            this.array.add(new Character(cArray[n]));
        }
        this.originalTypes = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.originalTypes[n] = this.type;
        }
        this.sortedIndices = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.sortedIndices[n] = n;
        }
        this.minmax();
    }

    public ArrayMaths(Character[] characterArray) {
        int n;
        this.length = characterArray.length;
        this.array = new ArrayList(this.length);
        this.type = 17;
        for (n = 0; n < this.length; ++n) {
            this.array.add(characterArray[n]);
        }
        this.originalTypes = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.originalTypes[n] = this.type;
        }
        this.sortedIndices = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.sortedIndices[n] = n;
        }
        this.minmax();
    }

    public ArrayMaths(String[] stringArray) {
        int n;
        this.length = stringArray.length;
        this.array = new ArrayList(this.length);
        this.type = 18;
        for (n = 0; n < this.length; ++n) {
            this.array.add(stringArray[n]);
        }
        this.originalTypes = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.originalTypes[n] = this.type;
        }
        this.sortedIndices = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.sortedIndices[n] = n;
        }
    }

    public ArrayMaths(Object[] objectArray) {
        this.length = objectArray.length;
        this.originalTypes = new int[this.length];
        ArrayList<Object> arrayList = new ArrayList<Object>(this.length);
        for (int j = 0; j < this.length; ++j) {
            arrayList.add(objectArray[j]);
        }
        ArrayMaths arrayMaths = new ArrayMaths(arrayList);
        this.array = arrayMaths.getArray_as_ArrayList();
        this.minmax = arrayMaths.minmax;
        this.minIndex = arrayMaths.minIndex;
        this.maxIndex = arrayMaths.maxIndex;
        this.originalTypes = arrayMaths.originalTypes;
        this.sortedIndices = new int[this.length];
        for (int j = 0; j < this.length; ++j) {
            this.sortedIndices[j] = j;
        }
    }

    public ArrayMaths(Stat stat) {
        int n;
        this.array = stat.getArray_as_ArrayList();
        this.length = this.array.size();
        this.type = stat.typeIndex();
        this.originalTypes = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.originalTypes[n] = this.type;
        }
        this.sortedIndices = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            this.sortedIndices[n] = n;
        }
        this.minmax();
    }

    public ArrayMaths(Vector<Object> vector) {
        int n;
        int n2;
        this.length = vector.size();
        this.originalTypes = new int[this.length];
        this.array = new ArrayList(this.length);
        this.sortedIndices = new int[this.length];
        for (n2 = 0; n2 < this.length; ++n2) {
            this.sortedIndices[n2] = n2;
        }
        for (n2 = 0; n2 < this.length; ++n2) {
            this.originalTypes[n2] = -1;
            if (vector.elementAt(n2) instanceof Double) {
                this.originalTypes[n2] = 1;
            }
            if (vector.elementAt(n2) instanceof Float) {
                this.originalTypes[n2] = 3;
            }
            if (vector.elementAt(n2) instanceof Long) {
                this.originalTypes[n2] = 5;
            }
            if (vector.elementAt(n2) instanceof Integer) {
                this.originalTypes[n2] = 7;
            }
            if (vector.elementAt(n2) instanceof Short) {
                this.originalTypes[n2] = 9;
            }
            if (vector.elementAt(n2) instanceof Byte) {
                this.originalTypes[n2] = 11;
            }
            if (vector.elementAt(n2) instanceof BigDecimal) {
                this.originalTypes[n2] = 12;
            }
            if (vector.elementAt(n2) instanceof BigInteger) {
                this.originalTypes[n2] = 13;
            }
            if (vector.elementAt(n2) instanceof Complex) {
                this.originalTypes[n2] = 14;
            }
            if (vector.elementAt(n2) instanceof Phasor) {
                this.originalTypes[n2] = 15;
            }
            if (vector.elementAt(n2) instanceof Character) {
                this.originalTypes[n2] = 17;
            }
            if (vector.elementAt(n2) instanceof String) {
                this.originalTypes[n2] = 18;
            }
            if (this.originalTypes[n2] != -1) continue;
            throw new IllegalArgumentException("Object at " + n2 + " not recognised as one allowed by this class");
        }
        n2 = -1;
        for (n = 0; n < this.length; ++n) {
            if (this.originalTypes[n] != 18) continue;
            n2 = 0;
        }
        for (n = 0; n < this.length; ++n) {
            if (this.originalTypes[n] != 14) continue;
            n2 = 1;
        }
        if (n2 == -1) {
            for (n = 0; n < this.length; ++n) {
                if (this.originalTypes[n] != 15) continue;
                n2 = 2;
            }
        }
        if (n2 == -1) {
            for (n = 0; n < this.length; ++n) {
                if (this.originalTypes[n] != 12) continue;
                n2 = 3;
            }
        }
        if (n2 == -1) {
            for (n = 0; n < this.length; ++n) {
                if (this.originalTypes[n] != 13) continue;
                n2 = 4;
            }
        }
        if (n2 == 4) {
            for (n = 0; n < this.length; ++n) {
                if (this.originalTypes[n] > 3) continue;
                n2 = 3;
            }
        }
        if (n2 == -1) {
            for (n = 0; n < this.length; ++n) {
                if (this.originalTypes[n] > 3) continue;
                n2 = 5;
            }
        }
        if (n2 == -1) {
            for (n = 0; n < this.length; ++n) {
                if (this.originalTypes[n] <= 3 || this.originalTypes[n] >= 12) continue;
                n2 = 6;
            }
        }
        if (n2 == -1) {
            for (n = 0; n < this.length; ++n) {
                if (this.originalTypes[n] != 17) continue;
                n2 = 7;
            }
        }
        if (n2 == -1) {
            throw new IllegalArgumentException("It should not be possible to reach this exception - main Object type not identified");
        }
        switch (n2) {
            case 0: {
                this.type = 18;
                block106: for (n = 0; n < this.length; ++n) {
                    switch (this.originalTypes[n]) {
                        case 1: {
                            Double d = (Double)vector.elementAt(n);
                            this.array.add(d.toString());
                            continue block106;
                        }
                        case 3: {
                            Float f = (Float)vector.elementAt(n);
                            this.array.add(f.toString());
                            continue block106;
                        }
                        case 5: {
                            Long l = (Long)vector.elementAt(n);
                            this.array.add(l.toString());
                            continue block106;
                        }
                        case 7: {
                            Integer n3 = (Integer)vector.elementAt(n);
                            this.array.add(n3.toString());
                            continue block106;
                        }
                        case 9: {
                            Short s = (Short)vector.elementAt(n);
                            this.array.add(s.toString());
                            continue block106;
                        }
                        case 11: {
                            Byte by = (Byte)vector.elementAt(n);
                            this.array.add(by.toString());
                            continue block106;
                        }
                        case 12: {
                            BigDecimal bigDecimal = (BigDecimal)vector.elementAt(n);
                            this.array.add(bigDecimal.toString());
                            continue block106;
                        }
                        case 13: {
                            BigInteger bigInteger = (BigInteger)vector.elementAt(n);
                            this.array.add(bigInteger.toString());
                            continue block106;
                        }
                        case 14: {
                            Complex complex = (Complex)vector.elementAt(n);
                            this.array.add(complex.toString());
                            continue block106;
                        }
                        case 15: {
                            Phasor phasor = (Phasor)vector.elementAt(n);
                            this.array.add(phasor.toString());
                            continue block106;
                        }
                        case 17: {
                            Character c = (Character)vector.elementAt(n);
                            this.array.add(c.toString());
                            continue block106;
                        }
                        case 18: {
                            String string = (String)vector.elementAt(n);
                            this.array.add(string);
                            continue block106;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                }
                break;
            }
            case 1: {
                this.type = 14;
                block107: for (n = 0; n < this.length; ++n) {
                    switch (this.originalTypes[n]) {
                        case 1: {
                            Double d = (Double)vector.elementAt(n);
                            this.array.add(new Complex(d));
                            continue block107;
                        }
                        case 3: {
                            Float f = (Float)vector.elementAt(n);
                            this.array.add(new Complex(f.doubleValue()));
                            continue block107;
                        }
                        case 5: {
                            Long l = (Long)vector.elementAt(n);
                            this.array.add(new Complex(l.doubleValue()));
                            continue block107;
                        }
                        case 7: {
                            Integer n4 = (Integer)vector.elementAt(n);
                            this.array.add(new Complex(n4.doubleValue()));
                            continue block107;
                        }
                        case 9: {
                            Short s = (Short)vector.elementAt(n);
                            this.array.add(new Complex(s.doubleValue()));
                            continue block107;
                        }
                        case 11: {
                            Byte by = (Byte)vector.elementAt(n);
                            this.array.add(new Complex(by.doubleValue()));
                            continue block107;
                        }
                        case 12: {
                            BigDecimal bigDecimal = (BigDecimal)vector.elementAt(n);
                            this.array.add(new Complex(bigDecimal.doubleValue()));
                            continue block107;
                        }
                        case 13: {
                            BigInteger bigInteger = (BigInteger)vector.elementAt(n);
                            this.array.add(new Complex(bigInteger.doubleValue()));
                            continue block107;
                        }
                        case 14: {
                            Complex complex = (Complex)vector.elementAt(n);
                            this.array.add(complex);
                            continue block107;
                        }
                        case 15: {
                            Phasor phasor = (Phasor)vector.elementAt(n);
                            this.array.add(Conv.convert_Phasor_to_Complex(phasor));
                            continue block107;
                        }
                        case 17: {
                            Character c = (Character)vector.elementAt(n);
                            this.array.add(new Complex(c.charValue()));
                            continue block107;
                        }
                        case 18: {
                            String string = (String)vector.elementAt(n);
                            this.array.add(new Complex(Double.parseDouble(string)));
                            continue block107;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                }
                break;
            }
            case 2: {
                this.type = 15;
                block108: for (n = 0; n < this.length; ++n) {
                    switch (this.originalTypes[n]) {
                        case 1: {
                            Double d = (Double)vector.elementAt(n);
                            this.array.add(new Phasor(d));
                            continue block108;
                        }
                        case 3: {
                            Float f = (Float)vector.elementAt(n);
                            this.array.add(new Phasor(f.doubleValue()));
                            continue block108;
                        }
                        case 5: {
                            Long l = (Long)vector.elementAt(n);
                            this.array.add(new Phasor(l.doubleValue()));
                            continue block108;
                        }
                        case 7: {
                            Integer n5 = (Integer)vector.elementAt(n);
                            this.array.add(new Phasor(n5.doubleValue()));
                            continue block108;
                        }
                        case 9: {
                            Short s = (Short)vector.elementAt(n);
                            this.array.add(new Phasor(s.doubleValue()));
                            continue block108;
                        }
                        case 11: {
                            Byte by = (Byte)vector.elementAt(n);
                            this.array.add(new Phasor(by.doubleValue()));
                            continue block108;
                        }
                        case 12: {
                            BigDecimal bigDecimal = (BigDecimal)vector.elementAt(n);
                            this.array.add(new Phasor(bigDecimal.doubleValue()));
                            continue block108;
                        }
                        case 13: {
                            BigInteger bigInteger = (BigInteger)vector.elementAt(n);
                            this.array.add(new Phasor(bigInteger.doubleValue()));
                            continue block108;
                        }
                        case 14: {
                            Complex complex = (Complex)vector.elementAt(n);
                            this.array.add(Conv.convert_Complex_to_Phasor(complex));
                            continue block108;
                        }
                        case 15: {
                            Phasor phasor = (Phasor)vector.elementAt(n);
                            this.array.add(phasor);
                            continue block108;
                        }
                        case 17: {
                            Character c = (Character)vector.elementAt(n);
                            this.array.add(new Phasor(c.charValue()));
                            continue block108;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                }
                break;
            }
            case 3: {
                this.type = 12;
                block109: for (n = 0; n < this.length; ++n) {
                    switch (this.originalTypes[n]) {
                        case 1: {
                            Double d = (Double)vector.elementAt(n);
                            this.array.add(Conv.convert_Double_to_BigDecimal(d));
                            continue block109;
                        }
                        case 3: {
                            Float f = (Float)vector.elementAt(n);
                            this.array.add(Conv.convert_Float_to_BigDecimal(f));
                            continue block109;
                        }
                        case 5: {
                            Long l = (Long)vector.elementAt(n);
                            this.array.add(Conv.convert_Long_to_BigDecimal(l));
                            continue block109;
                        }
                        case 7: {
                            Integer n6 = (Integer)vector.elementAt(n);
                            this.array.add(Conv.convert_Integer_to_BigDecimal(n6));
                            continue block109;
                        }
                        case 9: {
                            Short s = (Short)vector.elementAt(n);
                            this.array.add(Conv.convert_Short_to_BigDecimal(s));
                            continue block109;
                        }
                        case 11: {
                            Byte by = (Byte)vector.elementAt(n);
                            this.array.add(Conv.convert_Byte_to_BigDecimal(by));
                            continue block109;
                        }
                        case 12: {
                            BigDecimal bigDecimal = (BigDecimal)vector.elementAt(n);
                            this.array.add(bigDecimal);
                            continue block109;
                        }
                        case 13: {
                            BigInteger bigInteger = (BigInteger)vector.elementAt(n);
                            this.array.add(Conv.convert_BigInteger_to_BigDecimal(bigInteger));
                            continue block109;
                        }
                        case 17: {
                            Character c = (Character)vector.elementAt(n);
                            this.array.add(new BigDecimal(c.toString()));
                            continue block109;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                }
                break;
            }
            case 4: {
                this.type = 13;
                block110: for (n = 0; n < this.length; ++n) {
                    switch (this.originalTypes[n]) {
                        case 1: {
                            Double d = (Double)vector.elementAt(n);
                            this.array.add(Conv.convert_Double_to_BigInteger(d));
                            continue block110;
                        }
                        case 3: {
                            Float f = (Float)vector.elementAt(n);
                            this.array.add(Conv.convert_Float_to_BigInteger(f));
                            continue block110;
                        }
                        case 5: {
                            Long l = (Long)vector.elementAt(n);
                            this.array.add(Conv.convert_Long_to_BigInteger(l));
                            continue block110;
                        }
                        case 7: {
                            Integer n7 = (Integer)vector.elementAt(n);
                            this.array.add(Conv.convert_Integer_to_BigInteger(n7));
                            continue block110;
                        }
                        case 9: {
                            Short s = (Short)vector.elementAt(n);
                            this.array.add(Conv.convert_Short_to_BigInteger(s));
                            continue block110;
                        }
                        case 11: {
                            Byte by = (Byte)vector.elementAt(n);
                            this.array.add(Conv.convert_Byte_to_BigInteger(by));
                            continue block110;
                        }
                        case 12: {
                            BigDecimal bigDecimal = (BigDecimal)vector.elementAt(n);
                            this.array.add(Conv.convert_BigDecimal_to_BigInteger(bigDecimal));
                            continue block110;
                        }
                        case 13: {
                            BigInteger bigInteger = (BigInteger)vector.elementAt(n);
                            this.array.add(bigInteger);
                            continue block110;
                        }
                        case 17: {
                            Character c = (Character)vector.elementAt(n);
                            this.array.add(new BigInteger(c.toString()));
                            continue block110;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                }
                break;
            }
            case 5: {
                this.type = 1;
                block111: for (n = 0; n < this.length; ++n) {
                    switch (this.originalTypes[n]) {
                        case 1: {
                            Double d = (Double)vector.elementAt(n);
                            this.array.add(d);
                            continue block111;
                        }
                        case 3: {
                            Float f = (Float)vector.elementAt(n);
                            this.array.add(Conv.convert_Float_to_Double(f));
                            continue block111;
                        }
                        case 5: {
                            Long l = (Long)vector.elementAt(n);
                            this.array.add(Conv.convert_Long_to_Double(l));
                            continue block111;
                        }
                        case 7: {
                            Integer n8 = (Integer)vector.elementAt(n);
                            this.array.add(Conv.convert_Integer_to_Double(n8));
                            continue block111;
                        }
                        case 9: {
                            Short s = (Short)vector.elementAt(n);
                            this.array.add(Conv.convert_Short_to_Double(s));
                            continue block111;
                        }
                        case 11: {
                            Byte by = (Byte)vector.elementAt(n);
                            this.array.add(Conv.convert_Byte_to_Double(by));
                            continue block111;
                        }
                        case 17: {
                            Character c = (Character)vector.elementAt(n);
                            this.array.add(new Double(Double.parseDouble(c.toString())));
                            continue block111;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                }
                break;
            }
            case 6: {
                this.type = 7;
                block112: for (n = 0; n < this.length; ++n) {
                    switch (this.originalTypes[n]) {
                        case 5: {
                            Long l = (Long)vector.elementAt(n);
                            this.array.add(l);
                            continue block112;
                        }
                        case 7: {
                            Integer n9 = (Integer)vector.elementAt(n);
                            this.array.add(Conv.convert_Integer_to_Long(n9));
                            continue block112;
                        }
                        case 9: {
                            Short s = (Short)vector.elementAt(n);
                            this.array.add(Conv.convert_Short_to_Long(s));
                            continue block112;
                        }
                        case 11: {
                            Byte by = (Byte)vector.elementAt(n);
                            this.array.add(Conv.convert_Byte_to_Long(by));
                            continue block112;
                        }
                        case 17: {
                            Character c = (Character)vector.elementAt(n);
                            this.array.add(new Long(c.charValue()));
                            continue block112;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                }
                break;
            }
            case 7: {
                this.type = 7;
                block113: for (n = 0; n < this.length; ++n) {
                    switch (this.originalTypes[n]) {
                        case 17: {
                            Character c = (Character)vector.elementAt(n);
                            this.array.add(c);
                            continue block113;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Dominant array data type not identified by this method");
            }
        }
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                this.minmax();
            }
        }
    }

    public ArrayMaths(ArrayList<Object> arrayList) {
        int n;
        int n2;
        this.length = arrayList.size();
        this.originalTypes = new int[this.length];
        this.array = new ArrayList(this.length);
        this.sortedIndices = new int[this.length];
        for (n2 = 0; n2 < this.length; ++n2) {
            this.sortedIndices[n2] = n2;
        }
        for (n2 = 0; n2 < this.length; ++n2) {
            this.originalTypes[n2] = -1;
            if (arrayList.get(n2) instanceof Double) {
                this.originalTypes[n2] = 1;
            }
            if (arrayList.get(n2) instanceof Float) {
                this.originalTypes[n2] = 3;
            }
            if (arrayList.get(n2) instanceof Long) {
                this.originalTypes[n2] = 5;
            }
            if (arrayList.get(n2) instanceof Integer) {
                this.originalTypes[n2] = 7;
            }
            if (arrayList.get(n2) instanceof Short) {
                this.originalTypes[n2] = 9;
            }
            if (arrayList.get(n2) instanceof Byte) {
                this.originalTypes[n2] = 11;
            }
            if (arrayList.get(n2) instanceof BigDecimal) {
                this.originalTypes[n2] = 12;
            }
            if (arrayList.get(n2) instanceof BigInteger) {
                this.originalTypes[n2] = 13;
            }
            if (arrayList.get(n2) instanceof Complex) {
                this.originalTypes[n2] = 14;
            }
            if (arrayList.get(n2) instanceof Phasor) {
                this.originalTypes[n2] = 15;
            }
            if (arrayList.get(n2) instanceof Character) {
                this.originalTypes[n2] = 17;
            }
            if (arrayList.get(n2) instanceof String) {
                this.originalTypes[n2] = 18;
            }
            if (this.originalTypes[n2] != -1) continue;
            throw new IllegalArgumentException("Object at " + n2 + " not recognised as one allowed by this class");
        }
        n2 = -1;
        for (n = 0; n < this.length; ++n) {
            if (this.originalTypes[n] != 18) continue;
            n2 = 0;
        }
        for (n = 0; n < this.length; ++n) {
            if (this.originalTypes[n] != 14) continue;
            n2 = 1;
        }
        if (n2 == -1) {
            for (n = 0; n < this.length; ++n) {
                if (this.originalTypes[n] != 15) continue;
                n2 = 2;
            }
        }
        if (n2 == -1) {
            for (n = 0; n < this.length; ++n) {
                if (this.originalTypes[n] != 12) continue;
                n2 = 3;
            }
        }
        if (n2 == -1) {
            for (n = 0; n < this.length; ++n) {
                if (this.originalTypes[n] != 13) continue;
                n2 = 4;
            }
        }
        if (n2 == 4) {
            for (n = 0; n < this.length; ++n) {
                if (this.originalTypes[n] > 3) continue;
                n2 = 3;
            }
        }
        if (n2 == -1) {
            for (n = 0; n < this.length; ++n) {
                if (this.originalTypes[n] > 3) continue;
                n2 = 5;
            }
        }
        if (n2 == -1) {
            for (n = 0; n < this.length; ++n) {
                if (this.originalTypes[n] <= 3 || this.originalTypes[n] >= 12) continue;
                n2 = 6;
            }
        }
        if (n2 == -1) {
            for (n = 0; n < this.length; ++n) {
                if (this.originalTypes[n] != 17) continue;
                n2 = 7;
            }
        }
        if (n2 == -1) {
            throw new IllegalArgumentException("It should not be possible to reach this exception - main Object type not identified");
        }
        switch (n2) {
            case 0: {
                this.type = 18;
                block106: for (n = 0; n < this.length; ++n) {
                    switch (this.originalTypes[n]) {
                        case 1: {
                            Double d = (Double)arrayList.get(n);
                            this.array.add(d.toString());
                            continue block106;
                        }
                        case 3: {
                            Float f = (Float)arrayList.get(n);
                            this.array.add(f.toString());
                            continue block106;
                        }
                        case 5: {
                            Long l = (Long)arrayList.get(n);
                            this.array.add(l.toString());
                            continue block106;
                        }
                        case 7: {
                            Integer n3 = (Integer)arrayList.get(n);
                            this.array.add(n3.toString());
                            continue block106;
                        }
                        case 9: {
                            Short s = (Short)arrayList.get(n);
                            this.array.add(s.toString());
                            continue block106;
                        }
                        case 11: {
                            Byte by = (Byte)arrayList.get(n);
                            this.array.add(by.toString());
                            continue block106;
                        }
                        case 12: {
                            BigDecimal bigDecimal = (BigDecimal)arrayList.get(n);
                            this.array.add(bigDecimal.toString());
                            continue block106;
                        }
                        case 13: {
                            BigInteger bigInteger = (BigInteger)arrayList.get(n);
                            this.array.add(bigInteger.toString());
                            continue block106;
                        }
                        case 14: {
                            Complex complex = (Complex)arrayList.get(n);
                            this.array.add(complex.toString());
                            continue block106;
                        }
                        case 15: {
                            Phasor phasor = (Phasor)arrayList.get(n);
                            this.array.add(phasor.toString());
                            continue block106;
                        }
                        case 17: {
                            Character c = (Character)arrayList.get(n);
                            this.array.add(c.toString());
                            continue block106;
                        }
                        case 18: {
                            String string = (String)arrayList.get(n);
                            this.array.add(string);
                            continue block106;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                }
                break;
            }
            case 1: {
                this.type = 14;
                block107: for (n = 0; n < this.length; ++n) {
                    switch (this.originalTypes[n]) {
                        case 1: {
                            Double d = (Double)arrayList.get(n);
                            this.array.add(new Complex(d));
                            continue block107;
                        }
                        case 3: {
                            Float f = (Float)arrayList.get(n);
                            this.array.add(new Complex(f.doubleValue()));
                            continue block107;
                        }
                        case 5: {
                            Long l = (Long)arrayList.get(n);
                            this.array.add(new Complex(l.doubleValue()));
                            continue block107;
                        }
                        case 7: {
                            Integer n4 = (Integer)arrayList.get(n);
                            this.array.add(new Complex(n4.doubleValue()));
                            continue block107;
                        }
                        case 9: {
                            Short s = (Short)arrayList.get(n);
                            this.array.add(new Complex(s.doubleValue()));
                            continue block107;
                        }
                        case 11: {
                            Byte by = (Byte)arrayList.get(n);
                            this.array.add(new Complex(by.doubleValue()));
                            continue block107;
                        }
                        case 12: {
                            BigDecimal bigDecimal = (BigDecimal)arrayList.get(n);
                            this.array.add(new Complex(bigDecimal.doubleValue()));
                            continue block107;
                        }
                        case 13: {
                            BigInteger bigInteger = (BigInteger)arrayList.get(n);
                            this.array.add(new Complex(bigInteger.doubleValue()));
                            continue block107;
                        }
                        case 14: {
                            Complex complex = (Complex)arrayList.get(n);
                            this.array.add(complex);
                            continue block107;
                        }
                        case 15: {
                            Phasor phasor = (Phasor)arrayList.get(n);
                            this.array.add(Conv.convert_Phasor_to_Complex(phasor));
                            continue block107;
                        }
                        case 17: {
                            Character c = (Character)arrayList.get(n);
                            this.array.add(new Complex(c.charValue()));
                            continue block107;
                        }
                        case 18: {
                            String string = (String)arrayList.get(n);
                            this.array.add(new Complex(Double.parseDouble(string)));
                            continue block107;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                }
                break;
            }
            case 2: {
                this.type = 15;
                block108: for (n = 0; n < this.length; ++n) {
                    switch (this.originalTypes[n]) {
                        case 1: {
                            Double d = (Double)arrayList.get(n);
                            this.array.add(new Phasor(d));
                            continue block108;
                        }
                        case 3: {
                            Float f = (Float)arrayList.get(n);
                            this.array.add(new Phasor(f.doubleValue()));
                            continue block108;
                        }
                        case 5: {
                            Long l = (Long)arrayList.get(n);
                            this.array.add(new Phasor(l.doubleValue()));
                            continue block108;
                        }
                        case 7: {
                            Integer n5 = (Integer)arrayList.get(n);
                            this.array.add(new Phasor(n5.doubleValue()));
                            continue block108;
                        }
                        case 9: {
                            Short s = (Short)arrayList.get(n);
                            this.array.add(new Phasor(s.doubleValue()));
                            continue block108;
                        }
                        case 11: {
                            Byte by = (Byte)arrayList.get(n);
                            this.array.add(new Phasor(by.doubleValue()));
                            continue block108;
                        }
                        case 12: {
                            BigDecimal bigDecimal = (BigDecimal)arrayList.get(n);
                            this.array.add(new Phasor(bigDecimal.doubleValue()));
                            continue block108;
                        }
                        case 13: {
                            BigInteger bigInteger = (BigInteger)arrayList.get(n);
                            this.array.add(new Phasor(bigInteger.doubleValue()));
                            continue block108;
                        }
                        case 14: {
                            Complex complex = (Complex)arrayList.get(n);
                            this.array.add(Conv.convert_Complex_to_Phasor(complex));
                            continue block108;
                        }
                        case 15: {
                            Phasor phasor = (Phasor)arrayList.get(n);
                            this.array.add(phasor);
                            continue block108;
                        }
                        case 17: {
                            Character c = (Character)arrayList.get(n);
                            this.array.add(new Phasor(c.charValue()));
                            continue block108;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                }
                break;
            }
            case 3: {
                this.type = 12;
                block109: for (n = 0; n < this.length; ++n) {
                    switch (this.originalTypes[n]) {
                        case 1: {
                            Double d = (Double)arrayList.get(n);
                            this.array.add(Conv.convert_Double_to_BigDecimal(d));
                            continue block109;
                        }
                        case 3: {
                            Float f = (Float)arrayList.get(n);
                            this.array.add(Conv.convert_Float_to_BigDecimal(f));
                            continue block109;
                        }
                        case 5: {
                            Long l = (Long)arrayList.get(n);
                            this.array.add(Conv.convert_Long_to_BigDecimal(l));
                            continue block109;
                        }
                        case 7: {
                            Integer n6 = (Integer)arrayList.get(n);
                            this.array.add(Conv.convert_Integer_to_BigDecimal(n6));
                            continue block109;
                        }
                        case 9: {
                            Short s = (Short)arrayList.get(n);
                            this.array.add(Conv.convert_Short_to_BigDecimal(s));
                            continue block109;
                        }
                        case 11: {
                            Byte by = (Byte)arrayList.get(n);
                            this.array.add(Conv.convert_Byte_to_BigDecimal(by));
                            continue block109;
                        }
                        case 12: {
                            BigDecimal bigDecimal = (BigDecimal)arrayList.get(n);
                            this.array.add(bigDecimal);
                            continue block109;
                        }
                        case 13: {
                            BigInteger bigInteger = (BigInteger)arrayList.get(n);
                            this.array.add(Conv.convert_BigInteger_to_BigDecimal(bigInteger));
                            continue block109;
                        }
                        case 17: {
                            Character c = (Character)arrayList.get(n);
                            this.array.add(new BigDecimal(c.toString()));
                            continue block109;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                }
                break;
            }
            case 4: {
                this.type = 13;
                block110: for (n = 0; n < this.length; ++n) {
                    switch (this.originalTypes[n]) {
                        case 1: {
                            Double d = (Double)arrayList.get(n);
                            this.array.add(Conv.convert_Double_to_BigInteger(d));
                            continue block110;
                        }
                        case 3: {
                            Float f = (Float)arrayList.get(n);
                            this.array.add(Conv.convert_Float_to_BigInteger(f));
                            continue block110;
                        }
                        case 5: {
                            Long l = (Long)arrayList.get(n);
                            this.array.add(Conv.convert_Long_to_BigInteger(l));
                            continue block110;
                        }
                        case 7: {
                            Integer n7 = (Integer)arrayList.get(n);
                            this.array.add(Conv.convert_Integer_to_BigInteger(n7));
                            continue block110;
                        }
                        case 9: {
                            Short s = (Short)arrayList.get(n);
                            this.array.add(Conv.convert_Short_to_BigInteger(s));
                            continue block110;
                        }
                        case 11: {
                            Byte by = (Byte)arrayList.get(n);
                            this.array.add(Conv.convert_Byte_to_BigInteger(by));
                            continue block110;
                        }
                        case 12: {
                            BigDecimal bigDecimal = (BigDecimal)arrayList.get(n);
                            this.array.add(Conv.convert_BigDecimal_to_BigInteger(bigDecimal));
                            continue block110;
                        }
                        case 13: {
                            BigInteger bigInteger = (BigInteger)arrayList.get(n);
                            this.array.add(bigInteger);
                            continue block110;
                        }
                        case 17: {
                            Character c = (Character)arrayList.get(n);
                            this.array.add(new BigInteger(c.toString()));
                            continue block110;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                }
                break;
            }
            case 5: {
                this.type = 1;
                block111: for (n = 0; n < this.length; ++n) {
                    switch (this.originalTypes[n]) {
                        case 1: {
                            Double d = (Double)arrayList.get(n);
                            this.array.add(d);
                            continue block111;
                        }
                        case 3: {
                            Float f = (Float)arrayList.get(n);
                            this.array.add(Conv.convert_Float_to_Double(f));
                            continue block111;
                        }
                        case 5: {
                            Long l = (Long)arrayList.get(n);
                            this.array.add(Conv.convert_Long_to_Double(l));
                            continue block111;
                        }
                        case 7: {
                            Integer n8 = (Integer)arrayList.get(n);
                            this.array.add(Conv.convert_Integer_to_Double(n8));
                            continue block111;
                        }
                        case 9: {
                            Short s = (Short)arrayList.get(n);
                            this.array.add(Conv.convert_Short_to_Double(s));
                            continue block111;
                        }
                        case 11: {
                            Byte by = (Byte)arrayList.get(n);
                            this.array.add(Conv.convert_Byte_to_Double(by));
                            continue block111;
                        }
                        case 17: {
                            Character c = (Character)arrayList.get(n);
                            this.array.add(new Double(Double.parseDouble(c.toString())));
                            continue block111;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                }
                break;
            }
            case 6: {
                this.type = 7;
                block112: for (n = 0; n < this.length; ++n) {
                    switch (this.originalTypes[n]) {
                        case 5: {
                            Long l = (Long)arrayList.get(n);
                            this.array.add(l);
                            continue block112;
                        }
                        case 7: {
                            Integer n9 = (Integer)arrayList.get(n);
                            this.array.add(Conv.convert_Integer_to_Long(n9));
                            continue block112;
                        }
                        case 9: {
                            Short s = (Short)arrayList.get(n);
                            this.array.add(Conv.convert_Short_to_Long(s));
                            continue block112;
                        }
                        case 11: {
                            Byte by = (Byte)arrayList.get(n);
                            this.array.add(Conv.convert_Byte_to_Long(by));
                            continue block112;
                        }
                        case 17: {
                            Character c = (Character)arrayList.get(n);
                            this.array.add(new Long(c.charValue()));
                            continue block112;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                }
                break;
            }
            case 7: {
                this.type = 7;
                block113: for (n = 0; n < this.length; ++n) {
                    switch (this.originalTypes[n]) {
                        case 17: {
                            Character c = (Character)arrayList.get(n);
                            this.array.add(c);
                            continue block113;
                        }
                        default: {
                            throw new IllegalArgumentException("Data type not identified by this method");
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Dominant array data type not identified by this method");
            }
        }
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                this.minmax();
            }
        }
    }

    public int length() {
        return this.length;
    }

    public void resetSortedIndices(int[] nArray) {
        int n = nArray.length;
        if (n != this.length) {
            throw new IllegalArgumentException("array mismatch in resetSortedIndices: " + n + "   " + this.length);
        }
        this.sortedIndices = DeepCopy.copy(nArray);
    }

    public int typeIndex() {
        return this.type;
    }

    public String arrayType() {
        return this.typeName[this.type] + "[]";
    }

    public String[] originalArrayTypes() {
        String[] stringArray = new String[this.length];
        for (int j = 0; j < this.length; ++j) {
            stringArray[j] = this.typeName[this.originalTypes[j]];
        }
        return stringArray;
    }

    public ArrayMaths copy() {
        Object object;
        int n;
        Phasor[] phasorArray;
        Complex[] complexArray;
        int n2;
        int n3;
        long l;
        double d;
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.length = this.length;
        arrayMaths.maxIndex = this.maxIndex;
        arrayMaths.minIndex = this.minIndex;
        arrayMaths.sumDone = this.sumDone;
        arrayMaths.productDone = this.productDone;
        arrayMaths.sumlongToDouble = this.sumlongToDouble;
        arrayMaths.productlongToDouble = this.productlongToDouble;
        arrayMaths.type = this.type;
        arrayMaths.originalTypes = (int[])(this.originalTypes == null ? null : Conv.copy(this.originalTypes));
        arrayMaths.sortedIndices = (int[])(this.sortedIndices == null ? null : Conv.copy(this.sortedIndices));
        arrayMaths.suppressMessages = this.suppressMessages;
        arrayMaths.minmax = new ArrayList();
        if (this.minmax.size() != 0) {
            switch (this.type) {
                case 0: 
                case 1: {
                    d = (Double)this.minmax.get(0);
                    arrayMaths.minmax.add(new Double(d));
                    d = (Double)this.minmax.get(1);
                    arrayMaths.minmax.add(new Double(d));
                    break;
                }
                case 4: 
                case 5: {
                    l = (Long)this.minmax.get(0);
                    arrayMaths.minmax.add(new Double(l));
                    l = (Long)this.minmax.get(1);
                    arrayMaths.minmax.add(new Long(l));
                    break;
                }
                case 2: 
                case 3: {
                    float f = ((Float)this.minmax.get(0)).floatValue();
                    arrayMaths.minmax.add(new Double(f));
                    f = ((Float)this.minmax.get(1)).floatValue();
                    arrayMaths.minmax.add(new Double(f));
                    break;
                }
                case 6: 
                case 7: {
                    int n4 = (Integer)this.minmax.get(0);
                    arrayMaths.minmax.add(new Integer(n4));
                    n4 = ((Double)this.minmax.get(1)).intValue();
                    arrayMaths.minmax.add(new Integer(n4));
                    break;
                }
                case 8: 
                case 9: {
                    n3 = ((Short)this.minmax.get(0)).shortValue();
                    arrayMaths.minmax.add(new Short((short)n3));
                    n3 = ((Double)this.minmax.get(1)).shortValue();
                    arrayMaths.minmax.add(new Short((short)n3));
                    break;
                }
                case 10: 
                case 11: {
                    n2 = ((Byte)this.minmax.get(0)).byteValue();
                    arrayMaths.minmax.add(new Byte((byte)n2));
                    n3 = ((Byte)this.minmax.get(1)).byteValue();
                    arrayMaths.minmax.add(new Byte((byte)n2));
                    break;
                }
                case 12: {
                    complexArray = (Complex[])this.minmax.get(0);
                    arrayMaths.minmax.add(complexArray);
                    complexArray = (BigDecimal)this.minmax.get(1);
                    arrayMaths.minmax.add(complexArray);
                    complexArray = null;
                    break;
                }
                case 13: {
                    phasorArray = (Phasor[])this.minmax.get(0);
                    arrayMaths.minmax.add(phasorArray);
                    phasorArray = (BigInteger)this.minmax.get(1);
                    arrayMaths.minmax.add(phasorArray);
                    phasorArray = null;
                    break;
                }
                case 16: 
                case 17: {
                    n = (Integer)this.minmax.get(0);
                    arrayMaths.minmax.add(new Integer(n));
                    n = ((Double)this.minmax.get(1)).intValue();
                    arrayMaths.minmax.add(new Integer(n));
                }
            }
        }
        arrayMaths.summ = new ArrayList();
        if (this.summ.size() != 0) {
            switch (this.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 18: {
                    d = (Double)this.summ.get(0);
                    arrayMaths.summ.add(new Double(d));
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 16: 
                case 17: {
                    if (this.sumlongToDouble) {
                        double d2 = (Double)this.summ.get(0);
                        arrayMaths.summ.add(new Double(d2));
                        break;
                    }
                    l = (Long)this.summ.get(0);
                    arrayMaths.summ.add(new Long(l));
                    break;
                }
                case 12: {
                    BigDecimal bigDecimal = (BigDecimal)this.summ.get(0);
                    arrayMaths.summ.add(bigDecimal);
                    break;
                }
                case 13: {
                    object = (BigInteger)this.summ.get(0);
                    arrayMaths.summ.add(object);
                    break;
                }
                case 14: {
                    Complex complex = (Complex)this.summ.get(0);
                    arrayMaths.summ.add(complex);
                    break;
                }
                case 15: {
                    Phasor phasor = (Phasor)this.summ.get(0);
                    arrayMaths.summ.add(phasor);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Data type not identified by this method");
                }
            }
        }
        arrayMaths.productt = new ArrayList();
        if (this.productt.size() != 0) {
            switch (this.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 18: {
                    d = (Double)this.productt.get(0);
                    arrayMaths.productt.add(new Double(d));
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 16: 
                case 17: {
                    if (this.sumlongToDouble) {
                        double d3 = (Double)this.productt.get(0);
                        arrayMaths.productt.add(new Double(d3));
                        break;
                    }
                    long l2 = (Long)this.productt.get(0);
                    arrayMaths.productt.add(new Long(l2));
                    break;
                }
                case 12: {
                    BigDecimal bigDecimal = (BigDecimal)this.productt.get(0);
                    arrayMaths.productt.add(bigDecimal);
                    break;
                }
                case 13: {
                    object = (BigInteger)this.productt.get(0);
                    arrayMaths.productt.add(object);
                    break;
                }
                case 14: {
                    Complex complex = (Complex)this.productt.get(0);
                    arrayMaths.productt.add(complex);
                    break;
                }
                case 15: {
                    Phasor phasor = (Phasor)this.productt.get(0);
                    arrayMaths.productt.add(phasor);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Data type not identified by this method");
                }
            }
        }
        switch (this.type) {
            case 0: 
            case 1: {
                double[] dArray = Conv.copy(this.getArray_as_double());
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(dArray[j]));
                }
                break;
            }
            case 2: 
            case 3: {
                float[] fArray = Conv.copy(this.getArray_as_float());
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Float(fArray[j]));
                }
                break;
            }
            case 4: 
            case 5: {
                long[] lArray = Conv.copy(this.getArray_as_long());
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Long(lArray[j]));
                }
                break;
            }
            case 6: 
            case 7: {
                object = Conv.copy(this.getArray_as_int());
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Integer((int)object[j]));
                }
                break;
            }
            case 8: 
            case 9: {
                short[] sArray = Conv.copy(this.getArray_as_short());
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Short(sArray[j]));
                }
                break;
            }
            case 10: 
            case 11: {
                byte[] byArray = Conv.copy(this.getArray_as_byte());
                for (n3 = 0; n3 < this.length; ++n3) {
                    arrayMaths.array.add(new Byte(byArray[n3]));
                }
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = Conv.copy(this.getArray_as_BigDecimal());
                for (n2 = 0; n2 < this.length; ++n2) {
                    arrayMaths.array.add(bigDecimalArray[n2]);
                }
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = Conv.copy(this.getArray_as_BigInteger());
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigIntegerArray[j]);
                }
                break;
            }
            case 14: {
                complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].copy());
                }
                break;
            }
            case 15: {
                phasorArray = this.getArray_as_Phasor();
                for (n = 0; n < this.length; ++n) {
                    arrayMaths.array.add(phasorArray[n].copy());
                }
                break;
            }
            case 16: 
            case 17: {
                char[] cArray = Conv.copy(this.getArray_as_char());
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Character(cArray[j]));
                }
                break;
            }
            case 18: {
                String[] stringArray = Conv.copy(this.getArray_as_String());
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(stringArray[j]);
                }
                break;
            }
        }
        return arrayMaths;
    }

    public void suppressMessages() {
        this.suppressMessages = true;
    }

    public void restoreMessages() {
        this.suppressMessages = false;
    }

    public static void suppressMessagesTotal() {
        Conv.suppressMessagesAM();
    }

    public static void restoreMessagesTotal() {
        Conv.restoreMessagesAM();
    }

    public double[] array() {
        return this.getArray_as_double();
    }

    public double[] array_as_double() {
        return this.getArray_as_double();
    }

    public double[] getArray_as_double() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        double[] dArray = new double[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = 0; j < this.length; ++j) {
                    dArray[j] = (Double)this.array.get(j);
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = 0; j < this.length; ++j) {
                    dArray[j] = Conv.convert_Float_to_double((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = 0; j < this.length; ++j) {
                    dArray[j] = Conv.convert_Long_to_double((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = 0; j < this.length; ++j) {
                    dArray[j] = Conv.convert_Integer_to_double((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = 0; j < this.length; ++j) {
                    dArray[j] = Conv.convert_Short_to_double((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = 0; j < this.length; ++j) {
                    dArray[j] = Conv.convert_Byte_to_double((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    dArray[j] = Conv.convert_BigDecimal_to_double((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    dArray[j] = Conv.convert_BigInteger_to_double((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    dArray[j] = Double.valueOf((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = 0; j < this.length; ++j) {
                    dArray[j] = Conv.convert_int_to_double(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to double is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return dArray;
    }

    public Double[] array_as_Double() {
        return this.getArray_as_Double();
    }

    public Double[] getArray_as_Double() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Double[] doubleArray = new Double[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = 0; j < this.length; ++j) {
                    doubleArray[j] = (Double)this.array.get(j);
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = 0; j < this.length; ++j) {
                    doubleArray[j] = Conv.convert_Float_to_Double((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = 0; j < this.length; ++j) {
                    doubleArray[j] = Conv.convert_Long_to_Double((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = 0; j < this.length; ++j) {
                    doubleArray[j] = Conv.convert_Integer_to_Double((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = 0; j < this.length; ++j) {
                    doubleArray[j] = Conv.convert_Short_to_Double((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = 0; j < this.length; ++j) {
                    doubleArray[j] = Conv.convert_Byte_to_Double((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    doubleArray[j] = Conv.convert_BigDecimal_to_Double((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    doubleArray[j] = Conv.convert_BigInteger_to_Double((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    doubleArray[j] = new Double((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = 0; j < this.length; ++j) {
                    doubleArray[j] = Conv.convert_int_to_Double(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Double is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return doubleArray;
    }

    public Float[] array_as_Float() {
        return this.getArray_as_Float();
    }

    public Float[] getArray_as_Float() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Float[] floatArray = new Float[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = 0; j < this.length; ++j) {
                    floatArray[j] = Conv.convert_Double_to_Float((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = 0; j < this.length; ++j) {
                    floatArray[j] = (Float)this.array.get(j);
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = 0; j < this.length; ++j) {
                    floatArray[j] = Conv.convert_Long_to_Float((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = 0; j < this.length; ++j) {
                    floatArray[j] = Conv.convert_Integer_to_Float((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = 0; j < this.length; ++j) {
                    floatArray[j] = Conv.convert_Short_to_Float((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = 0; j < this.length; ++j) {
                    floatArray[j] = Conv.convert_Byte_to_Float((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    floatArray[j] = Conv.convert_BigDecimal_to_Float((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    floatArray[j] = Conv.convert_BigInteger_to_Float((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    floatArray[j] = new Float((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = 0; j < this.length; ++j) {
                    floatArray[j] = Conv.convert_int_to_Float(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Float is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return floatArray;
    }

    public float[] array_as_float() {
        return this.getArray_as_float();
    }

    public float[] getArray_as_float() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        float[] fArray = new float[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = 0; j < this.length; ++j) {
                    fArray[j] = Conv.convert_Double_to_float((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = 0; j < this.length; ++j) {
                    fArray[j] = ((Float)this.array.get(j)).floatValue();
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = 0; j < this.length; ++j) {
                    fArray[j] = Conv.convert_Long_to_float((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = 0; j < this.length; ++j) {
                    fArray[j] = Conv.convert_Integer_to_float((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = 0; j < this.length; ++j) {
                    fArray[j] = Conv.convert_Short_to_float((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = 0; j < this.length; ++j) {
                    fArray[j] = Conv.convert_Byte_to_float((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    fArray[j] = Conv.convert_BigDecimal_to_float((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    fArray[j] = Conv.convert_BigInteger_to_float((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    fArray[j] = new Float((String)this.array.get(j)).floatValue();
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = 0; j < this.length; ++j) {
                    fArray[j] = Conv.convert_int_to_float(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to float is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return fArray;
    }

    public long[] array_as_long() {
        return this.getArray_as_long();
    }

    public long[] getArray_as_long() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        long[] lArray = new long[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = 0; j < this.length; ++j) {
                    lArray[j] = Conv.convert_Double_to_long((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = 0; j < this.length; ++j) {
                    lArray[j] = Conv.convert_Float_to_long((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = 0; j < this.length; ++j) {
                    lArray[j] = (Long)this.array.get(j);
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = 0; j < this.length; ++j) {
                    lArray[j] = Conv.convert_Integer_to_long((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = 0; j < this.length; ++j) {
                    lArray[j] = Conv.convert_Short_to_long((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = 0; j < this.length; ++j) {
                    lArray[j] = Conv.convert_Byte_to_long((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    lArray[j] = Conv.convert_BigDecimal_to_long((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    lArray[j] = Conv.convert_BigInteger_to_long((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    lArray[j] = new Long((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = 0; j < this.length; ++j) {
                    lArray[j] = Conv.convert_int_to_long(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to long is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return lArray;
    }

    public Long[] array_as_Long() {
        return this.getArray_as_Long();
    }

    public Long[] getArray_as_Long() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Long[] longArray = new Long[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = 0; j < this.length; ++j) {
                    longArray[j] = Conv.convert_Double_to_Long((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = 0; j < this.length; ++j) {
                    longArray[j] = Conv.convert_Float_to_Long((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = 0; j < this.length; ++j) {
                    longArray[j] = (Long)this.array.get(j);
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = 0; j < this.length; ++j) {
                    longArray[j] = Conv.convert_Integer_to_Long((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = 0; j < this.length; ++j) {
                    longArray[j] = Conv.convert_Short_to_Long((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = 0; j < this.length; ++j) {
                    longArray[j] = Conv.convert_Byte_to_Long((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    longArray[j] = Conv.convert_BigDecimal_to_Long((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    longArray[j] = Conv.convert_BigInteger_to_Long((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    longArray[j] = new Long((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = 0; j < this.length; ++j) {
                    longArray[j] = Conv.convert_int_to_Long(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Long is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return longArray;
    }

    public Integer[] array_as_Integer() {
        return this.getArray_as_Integer();
    }

    public Integer[] getArray_as_Integer() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Integer[] integerArray = new Integer[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = 0; j < this.length; ++j) {
                    integerArray[j] = Conv.convert_Double_to_Integer((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = 0; j < this.length; ++j) {
                    integerArray[j] = Conv.convert_Float_to_Integer((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = 0; j < this.length; ++j) {
                    integerArray[j] = Conv.convert_Long_to_Integer((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = 0; j < this.length; ++j) {
                    integerArray[j] = (Integer)this.array.get(j);
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = 0; j < this.length; ++j) {
                    integerArray[j] = Conv.convert_Short_to_Integer((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = 0; j < this.length; ++j) {
                    integerArray[j] = Conv.convert_Byte_to_Integer((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    integerArray[j] = Conv.convert_BigDecimal_to_Integer((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    integerArray[j] = Conv.convert_BigInteger_to_Integer((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    integerArray[j] = new Integer((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = 0; j < this.length; ++j) {
                    integerArray[j] = new Integer(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Integer is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return integerArray;
    }

    public int[] array_as_int() {
        return this.getArray_as_int();
    }

    public int[] getArray_as_int() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] nArray = new int[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = 0; j < this.length; ++j) {
                    nArray[j] = Conv.convert_Double_to_int((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = 0; j < this.length; ++j) {
                    nArray[j] = Conv.convert_Float_to_int((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = 0; j < this.length; ++j) {
                    nArray[j] = Conv.convert_Long_to_int((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = 0; j < this.length; ++j) {
                    nArray[j] = (Integer)this.array.get(j);
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = 0; j < this.length; ++j) {
                    nArray[j] = Conv.convert_Short_to_int((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = 0; j < this.length; ++j) {
                    nArray[j] = Conv.convert_Byte_to_int((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    nArray[j] = Conv.convert_BigDecimal_to_int((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    nArray[j] = Conv.convert_BigInteger_to_int((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    nArray[j] = new Integer((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = 0; j < this.length; ++j) {
                    nArray[j] = ((Character)this.array.get(j)).charValue();
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to int is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return nArray;
    }

    public short[] array_as_short() {
        return this.getArray_as_short();
    }

    public short[] getArray_as_short() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        short[] sArray = new short[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = 0; j < this.length; ++j) {
                    sArray[j] = Conv.convert_Double_to_short((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = 0; j < this.length; ++j) {
                    sArray[j] = Conv.convert_Float_to_short((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = 0; j < this.length; ++j) {
                    sArray[j] = Conv.convert_Long_to_short((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = 0; j < this.length; ++j) {
                    sArray[j] = Conv.convert_Integer_to_short((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = 0; j < this.length; ++j) {
                    sArray[j] = (Short)this.array.get(j);
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = 0; j < this.length; ++j) {
                    sArray[j] = Conv.convert_Byte_to_short((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    sArray[j] = Conv.convert_BigDecimal_to_short((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    sArray[j] = Conv.convert_BigInteger_to_short((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    sArray[j] = new Short((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = 0; j < this.length; ++j) {
                    sArray[j] = Conv.convert_int_to_short(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to short is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return sArray;
    }

    public Short[] array_as_Short() {
        return this.getArray_as_Short();
    }

    public Short[] getArray_as_Short() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Short[] shortArray = new Short[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = 0; j < this.length; ++j) {
                    shortArray[j] = Conv.convert_Double_to_Short((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = 0; j < this.length; ++j) {
                    shortArray[j] = Conv.convert_Float_to_Short((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = 0; j < this.length; ++j) {
                    shortArray[j] = Conv.convert_Long_to_Short((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = 0; j < this.length; ++j) {
                    shortArray[j] = Conv.convert_Integer_to_Short((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = 0; j < this.length; ++j) {
                    shortArray[j] = (Short)this.array.get(j);
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = 0; j < this.length; ++j) {
                    shortArray[j] = Conv.convert_Byte_to_Short((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    shortArray[j] = Conv.convert_BigDecimal_to_Short((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    shortArray[j] = Conv.convert_BigInteger_to_Short((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    shortArray[j] = new Short((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = 0; j < this.length; ++j) {
                    shortArray[j] = Conv.convert_int_to_Short(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Short is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return shortArray;
    }

    public byte[] array_as_byte() {
        return this.getArray_as_byte();
    }

    public byte[] getArray_as_byte() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        byte[] byArray = new byte[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = 0; j < this.length; ++j) {
                    byArray[j] = Conv.convert_Double_to_byte((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = 0; j < this.length; ++j) {
                    byArray[j] = Conv.convert_Float_to_byte((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = 0; j < this.length; ++j) {
                    byArray[j] = Conv.convert_Long_to_byte((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = 0; j < this.length; ++j) {
                    byArray[j] = Conv.convert_Integer_to_byte((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = 0; j < this.length; ++j) {
                    byArray[j] = Conv.convert_Short_to_byte((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = 0; j < this.length; ++j) {
                    byArray[j] = (Byte)this.array.get(j);
                }
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    byArray[j] = Conv.convert_BigDecimal_to_byte((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    byArray[j] = Conv.convert_BigInteger_to_byte((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    byArray[j] = new Byte((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = 0; j < this.length; ++j) {
                    byArray[j] = Conv.convert_int_to_byte(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to byte is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return byArray;
    }

    public Byte[] array_as_Byte() {
        return this.getArray_as_Byte();
    }

    public Byte[] getArray_as_Byte() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Byte[] byteArray = new Byte[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = 0; j < this.length; ++j) {
                    byteArray[j] = Conv.convert_Double_to_Byte((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = 0; j < this.length; ++j) {
                    byteArray[j] = Conv.convert_Float_to_Byte((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = 0; j < this.length; ++j) {
                    byteArray[j] = Conv.convert_Long_to_Byte((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = 0; j < this.length; ++j) {
                    byteArray[j] = Conv.convert_Integer_to_Byte((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = 0; j < this.length; ++j) {
                    byteArray[j] = Conv.convert_Short_to_Byte((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = 0; j < this.length; ++j) {
                    byteArray[j] = (Byte)this.array.get(j);
                }
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    byteArray[j] = Conv.convert_BigDecimal_to_Byte((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    byteArray[j] = Conv.convert_BigInteger_to_Byte((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    byteArray[j] = new Byte((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = 0; j < this.length; ++j) {
                    byteArray[j] = Conv.convert_int_to_Byte(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Byte is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return byteArray;
    }

    public BigDecimal[] array_as_BigDecimal() {
        return this.getArray_as_BigDecimal();
    }

    public BigDecimal[] getArray_as_BigDecimal() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        BigDecimal[] bigDecimalArray = new BigDecimal[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = 0; j < this.length; ++j) {
                    bigDecimalArray[j] = Conv.convert_Double_to_BigDecimal((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = 0; j < this.length; ++j) {
                    bigDecimalArray[j] = Conv.convert_Float_to_BigDecimal((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = 0; j < this.length; ++j) {
                    bigDecimalArray[j] = Conv.convert_Long_to_BigDecimal((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = 0; j < this.length; ++j) {
                    bigDecimalArray[j] = Conv.convert_Integer_to_BigDecimal((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = 0; j < this.length; ++j) {
                    bigDecimalArray[j] = Conv.convert_Short_to_BigDecimal((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = 0; j < this.length; ++j) {
                    bigDecimalArray[j] = Conv.convert_Byte_to_BigDecimal((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    bigDecimalArray[j] = (BigDecimal)this.array.get(j);
                }
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    bigDecimalArray[j] = Conv.convert_BigInteger_to_BigDecimal((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    bigDecimalArray[j] = new BigDecimal((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = 0; j < this.length; ++j) {
                    bigDecimalArray[j] = Conv.convert_int_to_BigDecimal(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to BigDecimal is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return bigDecimalArray;
    }

    public BigInteger[] array_as_BigInteger() {
        return this.getArray_as_BigInteger();
    }

    public BigInteger[] getArray_as_BigInteger() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        BigInteger[] bigIntegerArray = new BigInteger[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = 0; j < this.length; ++j) {
                    bigIntegerArray[j] = Conv.convert_Double_to_BigInteger((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = 0; j < this.length; ++j) {
                    bigIntegerArray[j] = Conv.convert_Float_to_BigInteger((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = 0; j < this.length; ++j) {
                    bigIntegerArray[j] = Conv.convert_Long_to_BigInteger((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = 0; j < this.length; ++j) {
                    bigIntegerArray[j] = Conv.convert_Integer_to_BigInteger((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = 0; j < this.length; ++j) {
                    bigIntegerArray[j] = Conv.convert_Short_to_BigInteger((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = 0; j < this.length; ++j) {
                    bigIntegerArray[j] = Conv.convert_Byte_to_BigInteger((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    bigIntegerArray[j] = Conv.convert_BigDecimal_to_BigInteger((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    bigIntegerArray[j] = (BigInteger)this.array.get(j);
                }
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    bigIntegerArray[j] = new BigInteger((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = 0; j < this.length; ++j) {
                    bigIntegerArray[j] = Conv.convert_int_to_BigInteger(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to BigInteger is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return bigIntegerArray;
    }

    public Complex[] array_as_Complex() {
        return this.getArray_as_Complex();
    }

    public Complex[] getArray_as_Complex() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Complex[] complexArray = Complex.oneDarray(this.length);
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = 0; j < this.length; ++j) {
                    complexArray[j] = new Complex((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = 0; j < this.length; ++j) {
                    complexArray[j] = new Complex(((Float)this.array.get(j)).doubleValue());
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = 0; j < this.length; ++j) {
                    complexArray[j] = new Complex(Conv.convert_Long_to_double((Long)this.array.get(j)));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = 0; j < this.length; ++j) {
                    complexArray[j] = new Complex(Conv.convert_Integer_to_double((Integer)this.array.get(j)));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = 0; j < this.length; ++j) {
                    complexArray[j] = new Complex(Conv.convert_Short_to_double((Short)this.array.get(j)));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = 0; j < this.length; ++j) {
                    complexArray[j] = new Complex(Conv.convert_Byte_to_double((Byte)this.array.get(j)));
                }
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    complexArray[j] = new Complex(Conv.convert_BigDecimal_to_double((BigDecimal)this.array.get(j)));
                }
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    complexArray[j] = new Complex(Conv.convert_BigInteger_to_double((BigInteger)this.array.get(j)));
                }
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    complexArray[j] = (Complex)this.array.get(j);
                }
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    complexArray[j] = Conv.convert_Phasor_to_Complex((Phasor)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    String string = (String)this.array.get(j);
                    complexArray[j] = string.indexOf(105) != -1 || string.indexOf(106) != -1 ? Complex.valueOf(string) : new Complex(Double.valueOf(string));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = 0; j < this.length; ++j) {
                    complexArray[j] = new Complex(Conv.convert_int_to_double(((Character)this.array.get(j)).charValue()));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return complexArray;
    }

    public Phasor[] array_as_Phasor() {
        return this.getArray_as_Phasor();
    }

    public Phasor[] getArray_as_Phasor() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Phasor[] phasorArray = Phasor.oneDarray(this.length);
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = 0; j < this.length; ++j) {
                    phasorArray[j] = new Phasor((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = 0; j < this.length; ++j) {
                    phasorArray[j] = new Phasor(((Float)this.array.get(j)).doubleValue());
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = 0; j < this.length; ++j) {
                    phasorArray[j] = new Phasor(Conv.convert_Long_to_double((Long)this.array.get(j)));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = 0; j < this.length; ++j) {
                    phasorArray[j] = new Phasor(Conv.convert_Integer_to_double((Integer)this.array.get(j)));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = 0; j < this.length; ++j) {
                    phasorArray[j] = new Phasor(Conv.convert_Short_to_double((Short)this.array.get(j)));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = 0; j < this.length; ++j) {
                    phasorArray[j] = new Phasor(Conv.convert_Byte_to_double((Byte)this.array.get(j)));
                }
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    phasorArray[j] = new Phasor(Conv.convert_BigDecimal_to_double((BigDecimal)this.array.get(j)));
                }
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    phasorArray[j] = new Phasor(Conv.convert_BigInteger_to_double((BigInteger)this.array.get(j)));
                }
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    phasorArray[j] = Conv.convert_Complex_to_Phasor((Complex)this.array.get(j));
                }
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    phasorArray[j] = (Phasor)this.array.get(j);
                }
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    String string = ((String)this.array.get(j)).trim();
                    phasorArray[j] = string.indexOf(60) != -1 || string.indexOf(76) != -1 ? Phasor.valueOf(string) : new Phasor(Double.valueOf(string));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = 0; j < this.length; ++j) {
                    phasorArray[j] = new Phasor(Conv.convert_int_to_double(((Character)this.array.get(j)).charValue()));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return phasorArray;
    }

    public Character[] array_as_Character() {
        return this.getArray_as_Character();
    }

    public Character[] getArray_as_Character() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Character[] characterArray = new Character[this.length];
        switch (this.type) {
            case 6: 
            case 7: {
                for (int j = 0; j < this.length; ++j) {
                    characterArray[j] = new Character((char)((Integer)this.array.get(j)).intValue());
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = 0; j < this.length; ++j) {
                    characterArray[j] = (Character)this.array.get(j);
                }
                break;
            }
            case 18: {
                int n;
                boolean bl = true;
                String[] stringArray = new String[this.length];
                for (n = 0; n < this.length; ++n) {
                    stringArray[n] = ((String)this.array.get(n)).trim();
                    if (stringArray[n].length() <= 1) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    for (n = 0; n < this.length; ++n) {
                        characterArray[n] = new Character(stringArray[n].charAt(0));
                    }
                    break;
                }
                throw new IllegalArgumentException("The String array elements are too long to be converted to Character");
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to char is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return characterArray;
    }

    public char[] array_as_char() {
        return this.getArray_as_char();
    }

    public char[] getArray_as_char() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        char[] cArray = new char[this.length];
        switch (this.type) {
            case 6: 
            case 7: {
                for (int j = 0; j < this.length; ++j) {
                    cArray[j] = (char)((Integer)this.array.get(j)).intValue();
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = 0; j < this.length; ++j) {
                    cArray[j] = ((Character)this.array.get(j)).charValue();
                }
                break;
            }
            case 18: {
                int n;
                boolean bl = true;
                String[] stringArray = new String[this.length];
                for (n = 0; n < this.length; ++n) {
                    stringArray[n] = ((String)this.array.get(n)).trim();
                    if (stringArray[n].length() <= 1) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    for (n = 0; n < this.length; ++n) {
                        cArray[n] = stringArray[n].charAt(0);
                    }
                    break;
                }
                throw new IllegalArgumentException("The String array elements are too long to be converted to char");
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to char is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return cArray;
    }

    public String[] array_as_String() {
        return this.getArray_as_String();
    }

    public String[] getArray_as_String() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        String[] stringArray = new String[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = 0; j < this.length; ++j) {
                    stringArray[j] = ((Double)this.array.get(j)).toString();
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = 0; j < this.length; ++j) {
                    stringArray[j] = ((Float)this.array.get(j)).toString();
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = 0; j < this.length; ++j) {
                    stringArray[j] = ((Long)this.array.get(j)).toString();
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = 0; j < this.length; ++j) {
                    stringArray[j] = ((Integer)this.array.get(j)).toString();
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = 0; j < this.length; ++j) {
                    stringArray[j] = ((Short)this.array.get(j)).toString();
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = 0; j < this.length; ++j) {
                    stringArray[j] = ((Byte)this.array.get(j)).toString();
                }
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    stringArray[j] = ((BigDecimal)this.array.get(j)).toString();
                }
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    stringArray[j] = ((BigInteger)this.array.get(j)).toString();
                }
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    stringArray[j] = ((Complex)this.array.get(j)).toString();
                }
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    stringArray[j] = ((Phasor)this.array.get(j)).toString();
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = 0; j < this.length; ++j) {
                    stringArray[j] = ((Character)this.array.get(j)).toString();
                }
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    stringArray[j] = (String)this.array.get(j);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return stringArray;
    }

    public Object[] array_as_Object() {
        return this.getArray_as_Object();
    }

    public Object[] getArray_as_Object() {
        Object[] objectArray = new Object[this.length];
        for (int j = 0; j < this.length; ++j) {
            objectArray[j] = this.array.get(j);
        }
        return objectArray;
    }

    public Vector array_as_Vector() {
        return this.getArray_as_Vector();
    }

    public Vector<Object> getArray_as_Vector() {
        Vector<Object> vector = new Vector<Object>(this.length);
        for (int j = 0; j < this.length; ++j) {
            vector.addElement(this.array.get(j));
        }
        return vector;
    }

    public ArrayList array_as_ArrayList() {
        return this.getArray_as_ArrayList();
    }

    public ArrayList<Object> getArray_as_ArrayList() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.length);
        for (int j = 0; j < this.length; ++j) {
            arrayList.add(this.array.get(j));
        }
        return arrayList;
    }

    public Matrix array_as_Matrix_rowMatrix() {
        return this.getArray_as_Matrix_rowMatrix();
    }

    public Matrix getArray_as_Matrix_rowMatrix() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Matrix matrix = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                double[] dArray = this.getArray_as_double();
                matrix = Matrix.rowMatrix(dArray);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex array cannot be converted to Matrix.rowMatrix - use method getArray_as_Complex_rowMatrix");
            }
            case 15: {
                throw new IllegalArgumentException("Phasor array cannot be converted to Matrix.rowMatrix - use method getArray_as_Phasor_rowMatrix");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return matrix;
    }

    public Matrix array_as_Matrix_columnMatrix() {
        return this.getArray_as_Matrix_columnMatrix();
    }

    public Matrix getArray_as_Matrix_columnMatrix() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Matrix matrix = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                double[] dArray = this.getArray_as_double();
                matrix = Matrix.columnMatrix(dArray);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex array cannot be converted to Matrix.columnMatrix - use method getArray_as_Complex_columnMatrix");
            }
            case 15: {
                throw new IllegalArgumentException("Phasor array cannot be converted to Matrix.columnMatrix - use method getArray_as_Phasor_columnMatrix");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return matrix;
    }

    public ComplexMatrix array_as_Complex_rowMatrix() {
        return this.getArray_as_Complex_rowMatrix();
    }

    public ComplexMatrix getArray_as_Complex_rowMatrix() {
        Complex[] complexArray = this.getArray_as_Complex();
        ComplexMatrix complexMatrix = ComplexMatrix.rowMatrix(complexArray);
        return complexMatrix;
    }

    public ComplexMatrix array_as_Complex_columnMatrix() {
        return this.getArray_as_Complex_columnMatrix();
    }

    public ComplexMatrix getArray_as_Complex_columnMatrix() {
        Complex[] complexArray = this.getArray_as_Complex();
        ComplexMatrix complexMatrix = ComplexMatrix.columnMatrix(complexArray);
        return complexMatrix;
    }

    public PhasorMatrix array_as_Phasor_rowMatrix() {
        return this.getArray_as_Phasor_rowMatrix();
    }

    public PhasorMatrix getArray_as_Phasor_rowMatrix() {
        Phasor[] phasorArray = this.getArray_as_Phasor();
        PhasorMatrix phasorMatrix = PhasorMatrix.rowMatrix(phasorArray);
        return phasorMatrix;
    }

    public PhasorMatrix array_as_Phasor_columnMatrix() {
        return this.getArray_as_Phasor_columnMatrix();
    }

    public PhasorMatrix getArray_as_Phasor_columnMatrix() {
        Phasor[] phasorArray = this.getArray_as_Phasor();
        PhasorMatrix phasorMatrix = PhasorMatrix.columnMatrix(phasorArray);
        return phasorMatrix;
    }

    public double[] array_as_modulus_of_Complex() {
        Complex[] complexArray = this.getArray_as_Complex();
        double[] dArray = new double[this.length];
        for (int j = 0; j < this.length; ++j) {
            dArray[j] = complexArray[j].abs();
        }
        return dArray;
    }

    public double[] array_as_real_part_of_Complex() {
        return this.getArray_as_real_part_of_Complex();
    }

    public double[] getArray_as_real_part_of_Complex() {
        Complex[] complexArray = this.getArray_as_Complex();
        double[] dArray = new double[this.length];
        for (int j = 0; j < this.length; ++j) {
            dArray[j] = complexArray[j].getReal();
        }
        return dArray;
    }

    public double[] array_as_imaginary_part_of_Complex() {
        return this.getArray_as_imaginay_part_of_Complex();
    }

    public double[] getArray_as_imaginay_part_of_Complex() {
        Complex[] complexArray = this.getArray_as_Complex();
        double[] dArray = new double[this.length];
        for (int j = 0; j < this.length; ++j) {
            dArray[j] = complexArray[j].getImag();
        }
        return dArray;
    }

    public double[] array_as_magnitude_of_Phasor() {
        return this.getArray_as_magnitude_of_Phasor();
    }

    public double[] getArray_as_magnitude_of_Phasor() {
        Phasor[] phasorArray = this.getArray_as_Phasor();
        double[] dArray = new double[this.length];
        for (int j = 0; j < this.length; ++j) {
            dArray[j] = phasorArray[j].getMagnitude();
        }
        return dArray;
    }

    public double[] array_as_degrees_phase_of_Phasor() {
        return this.getArray_as_degrees_phase_of_Phasor();
    }

    public double[] getArray_as_degrees_phase_of_Phasor() {
        Phasor[] phasorArray = this.getArray_as_Phasor();
        double[] dArray = new double[this.length];
        for (int j = 0; j < this.length; ++j) {
            dArray[j] = phasorArray[j].getPhaseInDegrees();
        }
        return dArray;
    }

    public double[] array_as_radians_phase_of_Phasor() {
        return this.getArray_as_radians_phase_of_Phasor();
    }

    public double[] getArray_as_radians_phase_of_Phasor() {
        Phasor[] phasorArray = this.getArray_as_Phasor();
        double[] dArray = new double[this.length];
        for (int j = 0; j < this.length; ++j) {
            dArray[j] = phasorArray[j].getPhaseInRadians();
        }
        return dArray;
    }

    public double[] subarray_as_double(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        double[] dArray = new double[n2 - n + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = n; j <= n2; ++j) {
                    dArray[j - n] = (Double)this.array.get(j);
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = n; j <= n2; ++j) {
                    dArray[j - n] = Conv.convert_Float_to_double((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = n; j <= n2; ++j) {
                    dArray[j - n] = Conv.convert_Long_to_double((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = n; j <= n2; ++j) {
                    dArray[j - n] = Conv.convert_Integer_to_double((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = n; j <= n2; ++j) {
                    dArray[j - n] = Conv.convert_Short_to_double((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = n; j <= n2; ++j) {
                    dArray[j - n] = Conv.convert_Byte_to_double((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = n; j <= n2; ++j) {
                    dArray[j - n] = Conv.convert_BigDecimal_to_double((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = n; j <= n2; ++j) {
                    dArray[j - n] = Conv.convert_BigInteger_to_double((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = n; j <= n2; ++j) {
                    dArray[j - n] = Double.valueOf((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = n; j <= n2; ++j) {
                    dArray[j - n] = Conv.convert_int_to_double(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to double is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return dArray;
    }

    public Double[] subarray_as_Double(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Double[] doubleArray = new Double[n2 - n + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = n; j <= n2; ++j) {
                    doubleArray[j - n] = (Double)this.array.get(j);
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = n; j <= n2; ++j) {
                    doubleArray[j - n] = Conv.convert_Float_to_Double((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = n; j <= n2; ++j) {
                    doubleArray[j - n] = Conv.convert_Long_to_Double((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = n; j <= n2; ++j) {
                    doubleArray[j - n] = Conv.convert_Integer_to_Double((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = n; j <= n2; ++j) {
                    doubleArray[j - n] = Conv.convert_Short_to_Double((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = n; j <= n2; ++j) {
                    doubleArray[j - n] = Conv.convert_Byte_to_Double((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = n; j <= n2; ++j) {
                    doubleArray[j - n] = Conv.convert_BigDecimal_to_Double((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = n; j <= n2; ++j) {
                    doubleArray[j - n] = Conv.convert_BigInteger_to_Double((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = n; j <= n2; ++j) {
                    doubleArray[j - n] = new Double((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = n; j <= n2; ++j) {
                    doubleArray[j - n] = Conv.convert_int_to_Double(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Double is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return doubleArray;
    }

    public Float[] subarray_as_Float(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Float[] floatArray = new Float[n2 - n + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = n; j <= n2; ++j) {
                    floatArray[j - n] = Conv.convert_Double_to_Float((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = n; j <= n2; ++j) {
                    floatArray[j - n] = (Float)this.array.get(j);
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = n; j <= n2; ++j) {
                    floatArray[j - n] = Conv.convert_Long_to_Float((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = n; j <= n2; ++j) {
                    floatArray[j - n] = Conv.convert_Integer_to_Float((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = n; j <= n2; ++j) {
                    floatArray[j - n] = Conv.convert_Short_to_Float((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = n; j <= n2; ++j) {
                    floatArray[j - n] = Conv.convert_Byte_to_Float((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = n; j <= n2; ++j) {
                    floatArray[j - n] = Conv.convert_BigDecimal_to_Float((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = n; j <= n2; ++j) {
                    floatArray[j - n] = Conv.convert_BigInteger_to_Float((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = n; j <= n2; ++j) {
                    floatArray[j - n] = new Float((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = n; j <= n2; ++j) {
                    floatArray[j - n] = Conv.convert_int_to_Float(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Float is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return floatArray;
    }

    public float[] subarray_as_float(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        float[] fArray = new float[n2 - n + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = n; j <= n2; ++j) {
                    fArray[j - n] = Conv.convert_Double_to_float((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = n; j <= n2; ++j) {
                    fArray[j - n] = ((Float)this.array.get(j)).floatValue();
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = n; j <= n2; ++j) {
                    fArray[j - n] = Conv.convert_Long_to_float((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = n; j <= n2; ++j) {
                    fArray[j - n] = Conv.convert_Integer_to_float((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = n; j <= n2; ++j) {
                    fArray[j - n] = Conv.convert_Short_to_float((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = n; j <= n2; ++j) {
                    fArray[j - n] = Conv.convert_Byte_to_float((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = n; j <= n2; ++j) {
                    fArray[j - n] = Conv.convert_BigDecimal_to_float((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = n; j <= n2; ++j) {
                    fArray[j - n] = Conv.convert_BigInteger_to_float((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = n; j <= n2; ++j) {
                    fArray[j - n] = new Float((String)this.array.get(j)).floatValue();
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = n; j <= n2; ++j) {
                    fArray[j - n] = Conv.convert_int_to_float(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to float is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return fArray;
    }

    public long[] subarray_as_long(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        long[] lArray = new long[n2 - n + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = n; j <= n2; ++j) {
                    lArray[j - n] = Conv.convert_Double_to_long((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = n; j <= n2; ++j) {
                    lArray[j - n] = Conv.convert_Float_to_long((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = n; j <= n2; ++j) {
                    lArray[j - n] = (Long)this.array.get(j);
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = n; j <= n2; ++j) {
                    lArray[j - n] = Conv.convert_Integer_to_long((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = n; j <= n2; ++j) {
                    lArray[j - n] = Conv.convert_Short_to_long((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = n; j <= n2; ++j) {
                    lArray[j - n] = Conv.convert_Byte_to_long((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = n; j <= n2; ++j) {
                    lArray[j - n] = Conv.convert_BigDecimal_to_long((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = n; j <= n2; ++j) {
                    lArray[j - n] = Conv.convert_BigInteger_to_long((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = n; j <= n2; ++j) {
                    lArray[j - n] = new Long((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = n; j <= n2; ++j) {
                    lArray[j - n] = Conv.convert_int_to_long(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to long is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return lArray;
    }

    public Long[] subarray_as_Long(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Long[] longArray = new Long[n2 - n + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = n; j <= n2; ++j) {
                    longArray[j - n] = Conv.convert_Double_to_Long((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = n; j <= n2; ++j) {
                    longArray[j - n] = Conv.convert_Float_to_Long((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = n; j <= n2; ++j) {
                    longArray[j - n] = (Long)this.array.get(j);
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = n; j <= n2; ++j) {
                    longArray[j - n] = Conv.convert_Integer_to_Long((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = n; j <= n2; ++j) {
                    longArray[j - n] = Conv.convert_Short_to_Long((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = n; j <= n2; ++j) {
                    longArray[j - n] = Conv.convert_Byte_to_Long((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = n; j <= n2; ++j) {
                    longArray[j - n] = Conv.convert_BigDecimal_to_Long((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = n; j <= n2; ++j) {
                    longArray[j - n] = Conv.convert_BigInteger_to_Long((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = n; j <= n2; ++j) {
                    longArray[j - n] = new Long((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = n; j <= n2; ++j) {
                    longArray[j - n] = Conv.convert_int_to_Long(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Long is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return longArray;
    }

    public Integer[] subarray_as_Integer(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Integer[] integerArray = new Integer[n2 - n + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = n; j <= n2; ++j) {
                    integerArray[j - n] = Conv.convert_Double_to_Integer((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = n; j <= n2; ++j) {
                    integerArray[j - n] = Conv.convert_Float_to_Integer((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = n; j <= n2; ++j) {
                    integerArray[j - n] = Conv.convert_Long_to_Integer((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = n; j <= n2; ++j) {
                    integerArray[j - n] = (Integer)this.array.get(j);
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = n; j <= n2; ++j) {
                    integerArray[j - n] = Conv.convert_Short_to_Integer((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = n; j <= n2; ++j) {
                    integerArray[j - n] = Conv.convert_Byte_to_Integer((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = n; j <= n2; ++j) {
                    integerArray[j - n] = Conv.convert_BigDecimal_to_Integer((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = n; j <= n2; ++j) {
                    integerArray[j - n] = Conv.convert_BigInteger_to_Integer((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = n; j <= n2; ++j) {
                    integerArray[j - n] = new Integer((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = n; j <= n2; ++j) {
                    integerArray[j - n] = new Integer(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Integer is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return integerArray;
    }

    public int[] subarray_as_int(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] nArray = new int[n2 - n + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = n; j <= n2; ++j) {
                    nArray[j - n] = Conv.convert_Double_to_int((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = n; j <= n2; ++j) {
                    nArray[j - n] = Conv.convert_Float_to_int((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = n; j <= n2; ++j) {
                    nArray[j - n] = Conv.convert_Long_to_int((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = n; j <= n2; ++j) {
                    nArray[j - n] = (Integer)this.array.get(j);
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = n; j <= n2; ++j) {
                    nArray[j - n] = Conv.convert_Short_to_int((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = n; j <= n2; ++j) {
                    nArray[j - n] = Conv.convert_Byte_to_int((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = n; j <= n2; ++j) {
                    nArray[j - n] = Conv.convert_BigDecimal_to_int((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = n; j <= n2; ++j) {
                    nArray[j - n] = Conv.convert_BigInteger_to_int((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = n; j <= n2; ++j) {
                    nArray[j - n] = new Integer((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = n; j <= n2; ++j) {
                    nArray[j - n] = ((Character)this.array.get(j)).charValue();
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to int is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return nArray;
    }

    public short[] subarray_as_short(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        short[] sArray = new short[n2 - n + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = n; j <= n2; ++j) {
                    sArray[j - n] = Conv.convert_Double_to_short((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = n; j <= n2; ++j) {
                    sArray[j - n] = Conv.convert_Float_to_short((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = n; j <= n2; ++j) {
                    sArray[j - n] = Conv.convert_Long_to_short((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = n; j <= n2; ++j) {
                    sArray[j - n] = Conv.convert_Integer_to_short((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = n; j <= n2; ++j) {
                    sArray[j - n] = (Short)this.array.get(j);
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = n; j <= n2; ++j) {
                    sArray[j - n] = Conv.convert_Byte_to_short((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = n; j <= n2; ++j) {
                    sArray[j - n] = Conv.convert_BigDecimal_to_short((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = n; j <= n2; ++j) {
                    sArray[j - n] = Conv.convert_BigInteger_to_short((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = n; j <= n2; ++j) {
                    sArray[j - n] = new Short((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = n; j <= n2; ++j) {
                    sArray[j - n] = Conv.convert_int_to_short(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to short is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return sArray;
    }

    public Short[] subarray_as_Short(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Short[] shortArray = new Short[n2 - n + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = n; j <= n2; ++j) {
                    shortArray[j - n] = Conv.convert_Double_to_Short((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = n; j <= n2; ++j) {
                    shortArray[j - n] = Conv.convert_Float_to_Short((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = n; j <= n2; ++j) {
                    shortArray[j - n] = Conv.convert_Long_to_Short((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = n; j <= n2; ++j) {
                    shortArray[j - n] = Conv.convert_Integer_to_Short((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = n; j <= n2; ++j) {
                    shortArray[j - n] = (Short)this.array.get(j);
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = n; j <= n2; ++j) {
                    shortArray[j - n] = Conv.convert_Byte_to_Short((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = n; j <= n2; ++j) {
                    shortArray[j - n] = Conv.convert_BigDecimal_to_Short((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = n; j <= n2; ++j) {
                    shortArray[j - n] = Conv.convert_BigInteger_to_Short((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = n; j <= n2; ++j) {
                    shortArray[j - n] = new Short((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = n; j <= n2; ++j) {
                    shortArray[j - n] = Conv.convert_int_to_Short(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Short is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return shortArray;
    }

    public byte[] subarray_as_byte(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        byte[] byArray = new byte[n2 - n + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = n; j <= n2; ++j) {
                    byArray[j - n] = Conv.convert_Double_to_byte((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = n; j <= n2; ++j) {
                    byArray[j - n] = Conv.convert_Float_to_byte((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = n; j <= n2; ++j) {
                    byArray[j - n] = Conv.convert_Long_to_byte((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = n; j <= n2; ++j) {
                    byArray[j - n] = Conv.convert_Integer_to_byte((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = n; j <= n2; ++j) {
                    byArray[j - n] = Conv.convert_Short_to_byte((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = n; j <= n2; ++j) {
                    byArray[j - n] = (Byte)this.array.get(j);
                }
                break;
            }
            case 12: {
                for (int j = n; j <= n2; ++j) {
                    byArray[j - n] = Conv.convert_BigDecimal_to_byte((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = n; j <= n2; ++j) {
                    byArray[j - n] = Conv.convert_BigInteger_to_byte((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = n; j <= n2; ++j) {
                    byArray[j - n] = new Byte((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = n; j <= n2; ++j) {
                    byArray[j - n] = Conv.convert_int_to_byte(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to byte is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return byArray;
    }

    public Byte[] subarray_as_Byte(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Byte[] byteArray = new Byte[n2 - n + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = n; j <= n2; ++j) {
                    byteArray[j - n] = Conv.convert_Double_to_Byte((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = n; j <= n2; ++j) {
                    byteArray[j - n] = Conv.convert_Float_to_Byte((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = n; j <= n2; ++j) {
                    byteArray[j - n] = Conv.convert_Long_to_Byte((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = n; j <= n2; ++j) {
                    byteArray[j - n] = Conv.convert_Integer_to_Byte((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = n; j <= n2; ++j) {
                    byteArray[j - n] = Conv.convert_Short_to_Byte((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = n; j <= n2; ++j) {
                    byteArray[j - n] = (Byte)this.array.get(j);
                }
                break;
            }
            case 12: {
                for (int j = n; j <= n2; ++j) {
                    byteArray[j - n] = Conv.convert_BigDecimal_to_Byte((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = n; j <= n2; ++j) {
                    byteArray[j - n] = Conv.convert_BigInteger_to_Byte((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = n; j <= n2; ++j) {
                    byteArray[j - n] = new Byte((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = n; j <= n2; ++j) {
                    byteArray[j - n] = Conv.convert_int_to_Byte(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to Byte is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return byteArray;
    }

    public BigDecimal[] subarray_as_BigDecimal(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        BigDecimal[] bigDecimalArray = new BigDecimal[n2 - n + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = n; j <= n2; ++j) {
                    bigDecimalArray[j - n] = Conv.convert_Double_to_BigDecimal((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = n; j <= n2; ++j) {
                    bigDecimalArray[j - n] = Conv.convert_Float_to_BigDecimal((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = n; j <= n2; ++j) {
                    bigDecimalArray[j - n] = Conv.convert_Long_to_BigDecimal((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = n; j <= n2; ++j) {
                    bigDecimalArray[j - n] = Conv.convert_Integer_to_BigDecimal((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = n; j <= n2; ++j) {
                    bigDecimalArray[j - n] = Conv.convert_Short_to_BigDecimal((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = n; j <= n2; ++j) {
                    bigDecimalArray[j - n] = Conv.convert_Byte_to_BigDecimal((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = n; j <= n2; ++j) {
                    bigDecimalArray[j - n] = (BigDecimal)this.array.get(j);
                }
                break;
            }
            case 13: {
                for (int j = n; j <= n2; ++j) {
                    bigDecimalArray[j - n] = Conv.convert_BigInteger_to_BigDecimal((BigInteger)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = n; j <= n2; ++j) {
                    bigDecimalArray[j - n] = new BigDecimal((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = n; j <= n2; ++j) {
                    bigDecimalArray[j - n] = Conv.convert_int_to_BigDecimal(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to BigDecimal is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return bigDecimalArray;
    }

    public BigInteger[] subarray_as_BigInteger(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        BigInteger[] bigIntegerArray = new BigInteger[n2 - n + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = n; j <= n2; ++j) {
                    bigIntegerArray[j - n] = Conv.convert_Double_to_BigInteger((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = n; j <= n2; ++j) {
                    bigIntegerArray[j - n] = Conv.convert_Float_to_BigInteger((Float)this.array.get(j));
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = n; j <= n2; ++j) {
                    bigIntegerArray[j - n] = Conv.convert_Long_to_BigInteger((Long)this.array.get(j));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = n; j <= n2; ++j) {
                    bigIntegerArray[j - n] = Conv.convert_Integer_to_BigInteger((Integer)this.array.get(j));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = n; j <= n2; ++j) {
                    bigIntegerArray[j - n] = Conv.convert_Short_to_BigInteger((Short)this.array.get(j));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = n; j <= n2; ++j) {
                    bigIntegerArray[j - n] = Conv.convert_Byte_to_BigInteger((Byte)this.array.get(j));
                }
                break;
            }
            case 12: {
                for (int j = n; j <= n2; ++j) {
                    bigIntegerArray[j - n] = Conv.convert_BigDecimal_to_BigInteger((BigDecimal)this.array.get(j));
                }
                break;
            }
            case 13: {
                for (int j = n; j <= n2; ++j) {
                    bigIntegerArray[j - n] = (BigInteger)this.array.get(j);
                }
                break;
            }
            case 18: {
                for (int j = n; j <= n2; ++j) {
                    bigIntegerArray[j - n] = new BigInteger((String)this.array.get(j));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = n; j <= n2; ++j) {
                    bigIntegerArray[j - n] = Conv.convert_int_to_BigInteger(((Character)this.array.get(j)).charValue());
                }
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to BigInteger is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return bigIntegerArray;
    }

    public Complex[] subarray_as_Complex(int n, int n2) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Complex[] complexArray = Complex.oneDarray(this.length);
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = n; j <= n2; ++j) {
                    complexArray[j - n] = new Complex((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = n; j <= n2; ++j) {
                    complexArray[j - n] = new Complex(((Float)this.array.get(j)).doubleValue());
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = n; j <= n2; ++j) {
                    complexArray[j - n] = new Complex(Conv.convert_Long_to_double((Long)this.array.get(j)));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = n; j <= n2; ++j) {
                    complexArray[j - n] = new Complex(Conv.convert_Integer_to_double((Integer)this.array.get(j)));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = n; j <= n2; ++j) {
                    complexArray[j - n] = new Complex(Conv.convert_Short_to_double((Short)this.array.get(j)));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = n; j <= n2; ++j) {
                    complexArray[j - n] = new Complex(Conv.convert_Byte_to_double((Byte)this.array.get(j)));
                }
                break;
            }
            case 12: {
                for (int j = n; j <= n2; ++j) {
                    complexArray[j - n] = new Complex(Conv.convert_BigDecimal_to_double((BigDecimal)this.array.get(j)));
                }
                break;
            }
            case 13: {
                for (int j = n; j <= n2; ++j) {
                    complexArray[j - n] = new Complex(Conv.convert_BigInteger_to_double((BigInteger)this.array.get(j)));
                }
                break;
            }
            case 14: {
                for (int j = n; j <= n2; ++j) {
                    complexArray[j - n] = (Complex)this.array.get(j);
                }
                break;
            }
            case 15: {
                for (int j = n; j <= n2; ++j) {
                    complexArray[j - n] = Conv.convert_Phasor_to_Complex((Phasor)this.array.get(j));
                }
                break;
            }
            case 18: {
                for (int j = n; j <= n2; ++j) {
                    String string = (String)this.array.get(j);
                    complexArray[j - n] = string.indexOf(105) != -1 || string.indexOf(106) != -1 ? Complex.valueOf(string) : new Complex(Double.valueOf(string));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = n; j <= n2; ++j) {
                    complexArray[j - n] = new Complex(Conv.convert_int_to_double(((Character)this.array.get(j)).charValue()));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return complexArray;
    }

    public Phasor[] subarray_as_Phasor(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Phasor[] phasorArray = Phasor.oneDarray(this.length);
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = n; j <= n2; ++j) {
                    phasorArray[j - n] = new Phasor((Double)this.array.get(j));
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = n; j <= n2; ++j) {
                    phasorArray[j - n] = new Phasor(((Float)this.array.get(j)).doubleValue());
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = n; j <= n2; ++j) {
                    phasorArray[j - n] = new Phasor(Conv.convert_Long_to_double((Long)this.array.get(j)));
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = n; j <= n2; ++j) {
                    phasorArray[j - n] = new Phasor(Conv.convert_Integer_to_double((Integer)this.array.get(j)));
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = n; j <= n2; ++j) {
                    phasorArray[j - n] = new Phasor(Conv.convert_Short_to_double((Short)this.array.get(j)));
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = n; j <= n2; ++j) {
                    phasorArray[j - n] = new Phasor(Conv.convert_Byte_to_double((Byte)this.array.get(j)));
                }
                break;
            }
            case 12: {
                for (int j = n; j <= n2; ++j) {
                    phasorArray[j - n] = new Phasor(Conv.convert_BigDecimal_to_double((BigDecimal)this.array.get(j)));
                }
                break;
            }
            case 13: {
                for (int j = n; j <= n2; ++j) {
                    phasorArray[j - n] = new Phasor(Conv.convert_BigInteger_to_double((BigInteger)this.array.get(j)));
                }
                break;
            }
            case 14: {
                for (int j = n; j <= n2; ++j) {
                    phasorArray[j - n] = Conv.convert_Complex_to_Phasor((Complex)this.array.get(j));
                }
                break;
            }
            case 15: {
                for (int j = n; j <= n2; ++j) {
                    phasorArray[j - n] = (Phasor)this.array.get(j);
                }
                break;
            }
            case 18: {
                for (int j = n; j <= n2; ++j) {
                    String string = ((String)this.array.get(j)).trim();
                    phasorArray[j - n] = string.indexOf(60) != -1 || string.indexOf(76) != -1 ? Phasor.valueOf(string) : new Phasor(Double.valueOf(string));
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = n; j <= n2; ++j) {
                    phasorArray[j - n] = new Phasor(Conv.convert_int_to_double(((Character)this.array.get(j)).charValue()));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return phasorArray;
    }

    public Character[] subarray_as_Character(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Character[] characterArray = new Character[n2 - n + 1];
        switch (this.type) {
            case 6: 
            case 7: {
                for (int j = n; j <= n2; ++j) {
                    characterArray[j - n] = new Character((char)((Integer)this.array.get(j)).intValue());
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = n; j <= n2; ++j) {
                    characterArray[j - n] = (Character)this.array.get(j);
                }
                break;
            }
            case 18: {
                int n3;
                boolean bl = true;
                String[] stringArray = new String[n2 - n + 1];
                for (n3 = n; n3 <= n2; ++n3) {
                    stringArray[n3 - n] = ((String)this.array.get(n3)).trim();
                    if (stringArray[n3 - n].length() <= 1) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    for (n3 = n; n3 <= n2; ++n3) {
                        characterArray[n3 - n] = new Character(stringArray[n3 - n].charAt(0));
                    }
                    break;
                }
                throw new IllegalArgumentException("The String array elements are too long to be converted to Character");
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to char is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return characterArray;
    }

    public char[] subarray_as_char(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        char[] cArray = new char[n2 - n + 1];
        switch (this.type) {
            case 6: 
            case 7: {
                for (int j = n; j <= n2; ++j) {
                    cArray[j - n] = (char)((Integer)this.array.get(j)).intValue();
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = n; j <= n2; ++j) {
                    cArray[j - n] = ((Character)this.array.get(j)).charValue();
                }
                break;
            }
            case 18: {
                int n3;
                boolean bl = true;
                String[] stringArray = new String[n2 - n + 1];
                for (n3 = n; n3 <= n2; ++n3) {
                    stringArray[n3 - n] = ((String)this.array.get(n3)).trim();
                    if (stringArray[n3 - n].length() <= 1) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    for (n3 = n; n3 <= n2; ++n3) {
                        cArray[n3 - n] = stringArray[n3 - n].charAt(0);
                    }
                    break;
                }
                throw new IllegalArgumentException("The String array elements are too long to be converted to char");
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a conversion to char is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return cArray;
    }

    public String[] subarray_as_String(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        String[] stringArray = new String[n2 - n + 1];
        switch (this.type) {
            case 0: 
            case 1: {
                for (int j = n; j <= n2; ++j) {
                    stringArray[j - n] = ((Double)this.array.get(j)).toString();
                }
                break;
            }
            case 2: 
            case 3: {
                for (int j = n; j <= n2; ++j) {
                    stringArray[j - n] = ((Float)this.array.get(j)).toString();
                }
                break;
            }
            case 4: 
            case 5: {
                for (int j = n; j <= n2; ++j) {
                    stringArray[j - n] = ((Long)this.array.get(j)).toString();
                }
                break;
            }
            case 6: 
            case 7: {
                for (int j = n; j <= n2; ++j) {
                    stringArray[j - n] = ((Integer)this.array.get(j)).toString();
                }
                break;
            }
            case 8: 
            case 9: {
                for (int j = n; j <= n2; ++j) {
                    stringArray[j - n] = ((Short)this.array.get(j)).toString();
                }
                break;
            }
            case 10: 
            case 11: {
                for (int j = n; j <= n2; ++j) {
                    stringArray[j - n] = ((Byte)this.array.get(j)).toString();
                }
                break;
            }
            case 12: {
                for (int j = n; j <= n2; ++j) {
                    stringArray[j - n] = ((BigDecimal)this.array.get(j)).toString();
                }
                break;
            }
            case 13: {
                for (int j = n; j <= n2; ++j) {
                    stringArray[j - n] = ((BigInteger)this.array.get(j)).toString();
                }
                break;
            }
            case 14: {
                for (int j = n; j <= n2; ++j) {
                    stringArray[j - n] = ((Complex)this.array.get(j)).toString();
                }
                break;
            }
            case 15: {
                for (int j = n; j <= n2; ++j) {
                    stringArray[j - n] = ((Phasor)this.array.get(j)).toString();
                }
                break;
            }
            case 16: 
            case 17: {
                for (int j = n; j <= n2; ++j) {
                    stringArray[j - n] = ((Character)this.array.get(j)).toString();
                }
                break;
            }
            case 18: {
                for (int j = n; j <= n2; ++j) {
                    stringArray[j - n] = (String)this.array.get(j);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return stringArray;
    }

    public Object[] subarray_as_Object(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        Object[] objectArray = new Object[n2 - n + 1];
        for (int j = n; j <= n2; ++j) {
            objectArray[j - n] = this.array.get(j);
        }
        return objectArray;
    }

    public Vector<Object> subarray_as_Vector(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        Vector<Object> vector = new Vector<Object>(n2 - n + 1);
        for (int j = n; j <= n2; ++j) {
            vector.addElement(this.array.get(j));
        }
        return vector;
    }

    public ArrayList<Object> subarray_as_ArrayList(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n2 - n + 1);
        for (int j = n; j <= n2; ++j) {
            arrayList.add(this.array.get(j));
        }
        return arrayList;
    }

    public Matrix subarray_as_Matrix_rowMatrix(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Matrix matrix = null;
        double[] dArray = new double[n2 - n + 1];
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                double[] dArray2 = this.getArray_as_double();
                for (int j = n; j <= n2; ++j) {
                    dArray[j - n] = dArray2[j];
                }
                matrix = Matrix.rowMatrix(dArray);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex array cannot be converted to Matrix.rowMatrix - use method subarray_as_Complex_rowMatrix");
            }
            case 15: {
                throw new IllegalArgumentException("Phasor array cannot be converted to Matrix.rowMatrix - use method subarray_as_Phasor_rowMatrix");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return matrix;
    }

    public Matrix subarray_as_Matrix_columnMatrix(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Matrix matrix = null;
        double[] dArray = new double[n2 - n + 1];
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                double[] dArray2 = this.getArray_as_double();
                for (int j = n; j <= n2; ++j) {
                    dArray[j - n] = dArray2[j];
                }
                matrix = Matrix.columnMatrix(dArray);
                break;
            }
            case 14: {
                throw new IllegalArgumentException("Complex array cannot be converted to Matrix.columnMatrix - use method subarray_as_Complex_columnMatrix");
            }
            case 15: {
                throw new IllegalArgumentException("Phasor array cannot be converted to Matrix.columnMatrix - use method subarray_as_Phasor_columnMatrix");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return matrix;
    }

    public ComplexMatrix subarray_as_Complex_rowMatrix(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        Complex[] complexArray = this.getArray_as_Complex();
        Complex[] complexArray2 = new Complex[n2 - n + 1];
        for (int j = n; j <= n2; ++j) {
            complexArray2[j - n] = complexArray[j];
        }
        ComplexMatrix complexMatrix = ComplexMatrix.rowMatrix(complexArray2);
        return complexMatrix;
    }

    public ComplexMatrix subarray_as_Complex_columnMatrix(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        Complex[] complexArray = this.getArray_as_Complex();
        Complex[] complexArray2 = new Complex[n2 - n + 1];
        for (int j = n; j <= n2; ++j) {
            complexArray2[j - n] = complexArray[j];
        }
        ComplexMatrix complexMatrix = ComplexMatrix.columnMatrix(complexArray2);
        return complexMatrix;
    }

    public PhasorMatrix subarray_as_Phasor_rowMatrix(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        Phasor[] phasorArray = this.getArray_as_Phasor();
        Phasor[] phasorArray2 = new Phasor[n2 - n + 1];
        for (int j = n; j <= n2; ++j) {
            phasorArray2[j - n] = phasorArray[j];
        }
        PhasorMatrix phasorMatrix = PhasorMatrix.rowMatrix(phasorArray2);
        return phasorMatrix;
    }

    public PhasorMatrix subarray_as_Phasor_columnMatrix(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        Phasor[] phasorArray = this.getArray_as_Phasor();
        Phasor[] phasorArray2 = new Phasor[n2 - n + 1];
        for (int j = n; j <= n2; ++j) {
            phasorArray2[j - n] = phasorArray[j];
        }
        PhasorMatrix phasorMatrix = PhasorMatrix.columnMatrix(phasorArray2);
        return phasorMatrix;
    }

    public double[] subarray_as_modulus_of_Complex(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        Complex[] complexArray = this.getArray_as_Complex();
        double[] dArray = new double[n2 - n + 1];
        for (int j = n; j <= n2; ++j) {
            dArray[j - n] = complexArray[j].abs();
        }
        return dArray;
    }

    public double[] subarray_as_real_part_of_Complex(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        Complex[] complexArray = this.getArray_as_Complex();
        double[] dArray = new double[n2 - n + 1];
        for (int j = n; j <= n2; ++j) {
            dArray[j - n] = complexArray[j].getReal();
        }
        return dArray;
    }

    public double[] subarray_as_imaginay_part_of_Complex(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        Complex[] complexArray = this.getArray_as_Complex();
        double[] dArray = new double[n2 - n + 1];
        for (int j = n; j <= n2; ++j) {
            dArray[j - n] = complexArray[j].getImag();
        }
        return dArray;
    }

    public double[] subarray_as_magnitude_of_Phasor(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        Phasor[] phasorArray = this.getArray_as_Phasor();
        double[] dArray = new double[n2 - n + 1];
        for (int j = n; j <= n2; ++j) {
            dArray[j - n] = phasorArray[j].getMagnitude();
        }
        return dArray;
    }

    public double[] subarray_as_degrees_phase_of_Phasor(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        Phasor[] phasorArray = this.getArray_as_Phasor();
        double[] dArray = new double[n2 - n + 1];
        for (int j = n; j <= n2; ++j) {
            dArray[j - n] = phasorArray[j].getPhaseInDegrees();
        }
        return dArray;
    }

    public double[] subarray_as_radians_phase_of_Phasor(int n, int n2) {
        if (n2 >= this.length) {
            throw new IllegalArgumentException("end, " + n2 + ", is greater than the highest index, " + (this.length - 1));
        }
        Phasor[] phasorArray = this.getArray_as_Phasor();
        double[] dArray = new double[n2 - n + 1];
        for (int j = n; j <= n2; ++j) {
            dArray[j - n] = phasorArray[j].getPhaseInRadians();
        }
        return dArray;
    }

    protected void minmax() {
        int[] nArray = new int[2];
        ArrayMaths.findMinMax(this.getArray_as_Object(), this.minmax, nArray, this.typeName, this.type);
        this.maxIndex = nArray[0];
        this.minIndex = nArray[1];
    }

    protected static void findMinMax(Object[] objectArray, ArrayList<Object> arrayList, int[] nArray, String[] stringArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = objectArray.length;
        switch (n) {
            case 0: 
            case 1: {
                double[] dArray = new double[n4];
                for (int j = 0; j < n4; ++j) {
                    dArray[j] = (Double)objectArray[j];
                }
                double d = dArray[0];
                double d2 = dArray[0];
                n2 = 0;
                n3 = 0;
                for (int j = 1; j < n4; ++j) {
                    if (dArray[j] > d) {
                        d = dArray[j];
                        n2 = j;
                    }
                    if (!(dArray[j] < d2)) continue;
                    d2 = dArray[j];
                    n3 = j;
                }
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                break;
            }
            case 4: 
            case 5: {
                long[] lArray = new long[n4];
                for (int j = 0; j < n4; ++j) {
                    lArray[j] = (Long)objectArray[j];
                }
                long l = lArray[0];
                long l2 = lArray[0];
                n2 = 0;
                n3 = 0;
                for (int j = 1; j < n4; ++j) {
                    if (lArray[j] > l) {
                        l = lArray[j];
                        n2 = j;
                    }
                    if (lArray[j] >= l2) continue;
                    l2 = lArray[j];
                    n3 = j;
                }
                arrayList.add(new Long(l));
                arrayList.add(new Long(l2));
                break;
            }
            case 2: 
            case 3: {
                float[] fArray = new float[n4];
                for (int j = 0; j < n4; ++j) {
                    fArray[j] = ((Float)objectArray[j]).floatValue();
                }
                float f = fArray[0];
                float f2 = fArray[0];
                n2 = 0;
                n3 = 0;
                for (int j = 1; j < n4; ++j) {
                    if (fArray[j] > f) {
                        f = fArray[j];
                        n2 = j;
                    }
                    if (!(fArray[j] < f2)) continue;
                    f2 = fArray[j];
                    n3 = j;
                }
                arrayList.add(new Float(f));
                arrayList.add(new Float(f2));
                break;
            }
            case 6: 
            case 7: {
                int n5;
                int[] nArray2 = new int[n4];
                for (n5 = 0; n5 < n4; ++n5) {
                    nArray2[n5] = (Integer)objectArray[n5];
                }
                n5 = nArray2[0];
                int n6 = nArray2[0];
                n2 = 0;
                n3 = 0;
                for (int j = 1; j < n4; ++j) {
                    if (nArray2[j] > n5) {
                        n5 = nArray2[j];
                        n2 = j;
                    }
                    if (nArray2[j] >= n6) continue;
                    n6 = nArray2[j];
                    n3 = j;
                }
                arrayList.add(new Integer(n5));
                arrayList.add(new Integer(n6));
                break;
            }
            case 8: 
            case 9: {
                int n7;
                short[] sArray = new short[n4];
                for (n7 = 0; n7 < n4; ++n7) {
                    sArray[n7] = (Short)objectArray[n7];
                }
                n7 = sArray[0];
                short s = sArray[0];
                n2 = 0;
                n3 = 0;
                for (int j = 1; j < n4; ++j) {
                    if (sArray[j] > n7) {
                        n7 = sArray[j];
                        n2 = j;
                    }
                    if (sArray[j] >= s) continue;
                    s = sArray[j];
                    n3 = j;
                }
                arrayList.add(new Short((short)n7));
                arrayList.add(new Short(s));
                break;
            }
            case 10: 
            case 11: {
                int n8;
                byte[] byArray = new byte[n4];
                for (n8 = 0; n8 < n4; ++n8) {
                    byArray[n8] = (Byte)objectArray[n8];
                }
                n8 = byArray[0];
                byte by = byArray[0];
                n2 = 0;
                n3 = 0;
                for (int j = 1; j < n4; ++j) {
                    if (byArray[j] > n8) {
                        n8 = byArray[j];
                        n2 = j;
                    }
                    if (byArray[j] >= by) continue;
                    by = byArray[j];
                    n3 = j;
                }
                arrayList.add(new Byte((byte)n8));
                arrayList.add(new Byte(by));
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = new BigDecimal[n4];
                for (int j = 0; j < n4; ++j) {
                    bigDecimalArray[j] = (BigDecimal)objectArray[j];
                }
                BigDecimal bigDecimal = bigDecimalArray[0];
                BigDecimal bigDecimal2 = bigDecimalArray[0];
                n2 = 0;
                n3 = 0;
                for (int j = 1; j < n4; ++j) {
                    if (bigDecimalArray[j].compareTo(bigDecimal) == 1) {
                        bigDecimal = bigDecimalArray[j];
                        n2 = j;
                    }
                    if (bigDecimalArray[j].compareTo(bigDecimal2) != -1) continue;
                    bigDecimal2 = bigDecimalArray[j];
                    n3 = j;
                }
                arrayList.add(bigDecimal);
                arrayList.add(bigDecimal2);
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = new BigInteger[n4];
                for (int j = 0; j < n4; ++j) {
                    bigIntegerArray[j] = (BigInteger)objectArray[j];
                }
                BigInteger bigInteger = bigIntegerArray[0];
                BigInteger bigInteger2 = bigIntegerArray[0];
                n2 = 0;
                n3 = 0;
                for (int j = 1; j < n4; ++j) {
                    if (bigIntegerArray[j].compareTo(bigInteger) == 1) {
                        bigInteger = bigIntegerArray[j];
                        n2 = j;
                    }
                    if (bigIntegerArray[j].compareTo(bigInteger2) != -1) continue;
                    bigInteger2 = bigIntegerArray[j];
                    n3 = j;
                }
                arrayList.add(bigInteger);
                arrayList.add(bigInteger2);
                break;
            }
            case 16: 
            case 17: {
                int n9;
                int[] nArray3 = new int[n4];
                for (n9 = 0; n9 < n4; ++n9) {
                    nArray3[n9] = ((Character)objectArray[n9]).charValue();
                }
                n9 = nArray3[0];
                int n10 = nArray3[0];
                n2 = 0;
                n3 = 0;
                for (int j = 1; j < n4; ++j) {
                    if (nArray3[j] > n9) {
                        n9 = nArray3[j];
                        n2 = j;
                    }
                    if (nArray3[j] >= n10) continue;
                    n10 = nArray3[j];
                    n3 = j;
                }
                arrayList.add(new Character((char)n9));
                arrayList.add(new Character((char)n10));
                break;
            }
            case 14: 
            case 15: 
            case 18: {
                System.out.println("ArrayMaths:  getMaximum_... or getMinimum_... (findMinMax): the " + stringArray[n] + " is not a numerical type for which a maximum or a minimum is meaningful/supported");
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        nArray[0] = n2;
        nArray[1] = n3;
    }

    public double maximum() {
        return this.getMaximum_as_double();
    }

    public double maximum_as_double() {
        return this.getMaximum_as_double();
    }

    public double getMaximum() {
        return this.getMaximum_as_double();
    }

    public double getMaximum_as_double() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        double d = 0.0;
        switch (this.type) {
            case 0: 
            case 1: {
                d = (Double)this.minmax.get(0);
                break;
            }
            case 2: 
            case 3: {
                d = Conv.convert_Float_to_double((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                d = Conv.convert_Long_to_double((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                d = Conv.convert_Integer_to_double((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                d = Conv.convert_Short_to_double((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                d = Conv.convert_Byte_to_double((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                d = Conv.convert_BigDecimal_to_double((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                d = Conv.convert_BigInteger_to_double((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return d;
    }

    public Double maximum_as_Double() {
        return this.getMaximum_as_Double();
    }

    public Double getMaximum_as_Double() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Double d = new Double(0.0);
        switch (this.type) {
            case 0: 
            case 1: {
                d = (Double)this.minmax.get(0);
                break;
            }
            case 2: 
            case 3: {
                d = Conv.convert_Float_to_Double((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                d = Conv.convert_Long_to_Double((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                d = Conv.convert_Integer_to_Double((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                d = Conv.convert_Short_to_Double((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                d = Conv.convert_Byte_to_Double((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                d = Conv.convert_BigDecimal_to_Double((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                d = Conv.convert_BigInteger_to_Double((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return d;
    }

    public Float maximum_as_Float() {
        return this.getMaximum_as_Float();
    }

    public Float getMaximum_as_Float() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Float f = new Float(0.0);
        switch (this.type) {
            case 0: 
            case 1: {
                f = Conv.convert_Double_to_Float((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                f = (Float)this.minmax.get(0);
                break;
            }
            case 4: 
            case 5: {
                f = Conv.convert_Long_to_Float((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                f = Conv.convert_Integer_to_Float((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                f = Conv.convert_Short_to_Float((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                f = Conv.convert_Byte_to_Float((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                f = Conv.convert_BigDecimal_to_Float((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                f = Conv.convert_BigInteger_to_Float((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return f;
    }

    public float maximum_as_float() {
        return this.getMaximum_as_float();
    }

    public float getMaximum_as_float() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        float f = 0.0f;
        switch (this.type) {
            case 0: 
            case 1: {
                f = Conv.convert_Double_to_float((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                f = ((Float)this.minmax.get(0)).floatValue();
                break;
            }
            case 4: 
            case 5: {
                f = Conv.convert_Long_to_float((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                f = Conv.convert_Integer_to_float((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                f = Conv.convert_Short_to_float((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                f = Conv.convert_Byte_to_float((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                f = Conv.convert_BigDecimal_to_float((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                f = Conv.convert_BigInteger_to_float((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return f;
    }

    public long maximum_as_long() {
        return this.getMaximum_as_long();
    }

    public long getMaximum_as_long() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        long l = 0L;
        switch (this.type) {
            case 0: 
            case 1: {
                l = Conv.convert_Double_to_long((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                l = Conv.convert_Float_to_long((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                l = (Long)this.minmax.get(0);
                break;
            }
            case 6: 
            case 7: {
                l = Conv.convert_Integer_to_long((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                l = Conv.convert_Short_to_long((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                l = Conv.convert_Byte_to_long((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                l = Conv.convert_BigDecimal_to_long((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                l = Conv.convert_BigInteger_to_long((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return l;
    }

    public Long maximum_as_Long() {
        return this.getMaximum_as_Long();
    }

    public Long getMaximum_as_Long() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Long l = new Long(0L);
        switch (this.type) {
            case 0: 
            case 1: {
                l = Conv.convert_Double_to_Long((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                l = Conv.convert_Float_to_Long((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                l = (Long)this.minmax.get(0);
                break;
            }
            case 6: 
            case 7: {
                l = Conv.convert_Integer_to_Long((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                l = Conv.convert_Short_to_Long((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                l = Conv.convert_Byte_to_Long((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                l = Conv.convert_BigDecimal_to_Long((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                l = Conv.convert_BigInteger_to_Long((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return l;
    }

    public int maximum_as_int() {
        return this.getMaximum_as_int();
    }

    public int getMaximum_as_int() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = 0;
        switch (this.type) {
            case 0: 
            case 1: {
                n = Conv.convert_Double_to_int((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                n = Conv.convert_Float_to_int((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                n = Conv.convert_Long_to_int((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                n = (Integer)this.minmax.get(0);
                break;
            }
            case 8: 
            case 9: {
                n = Conv.convert_Short_to_int((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                n = Conv.convert_Byte_to_int((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                n = Conv.convert_BigDecimal_to_int((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                n = Conv.convert_BigInteger_to_int((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return n;
    }

    public Integer maximum_as_Integer() {
        return this.getMaximum_as_Integer();
    }

    public Integer getMaximum_as_Integer() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Integer n = new Integer(0);
        switch (this.type) {
            case 0: 
            case 1: {
                n = Conv.convert_Double_to_Integer((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                n = Conv.convert_Float_to_Integer((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                n = Conv.convert_Long_to_Integer((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                n = (Integer)this.minmax.get(0);
                break;
            }
            case 8: 
            case 9: {
                n = Conv.convert_Short_to_Integer((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                n = Conv.convert_Byte_to_Integer((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                n = Conv.convert_BigDecimal_to_Integer((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                n = Conv.convert_BigInteger_to_Integer((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return n;
    }

    public short maximum_as_short() {
        return this.getMaximum_as_short();
    }

    public short getMaximum_as_short() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        short s = 0;
        switch (this.type) {
            case 0: 
            case 1: {
                s = Conv.convert_Double_to_short((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                s = Conv.convert_Float_to_short((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                s = Conv.convert_Long_to_short((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                s = Conv.convert_Integer_to_short((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                s = (Short)this.minmax.get(0);
                break;
            }
            case 10: 
            case 11: {
                s = Conv.convert_Byte_to_short((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                s = Conv.convert_BigDecimal_to_short((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                s = Conv.convert_BigInteger_to_short((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return s;
    }

    public Short maximum_as_Short() {
        return this.getMaximum_as_Short();
    }

    public Short getMaximum_as_Short() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Short s = new Short(0);
        switch (this.type) {
            case 0: 
            case 1: {
                s = Conv.convert_Double_to_Short((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                s = Conv.convert_Float_to_Short((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                s = Conv.convert_Long_to_Short((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                s = Conv.convert_Integer_to_Short((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                s = (Short)this.minmax.get(0);
                break;
            }
            case 10: 
            case 11: {
                s = Conv.convert_Byte_to_Short((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                s = Conv.convert_BigDecimal_to_Short((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                s = Conv.convert_BigInteger_to_Short((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return s;
    }

    public byte maximum_as_byte() {
        return this.getMaximum_as_byte();
    }

    public byte getMaximum_as_byte() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        byte by = 0;
        switch (this.type) {
            case 0: 
            case 1: {
                by = Conv.convert_Double_to_byte((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                by = Conv.convert_Float_to_byte((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                by = Conv.convert_Long_to_byte((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                by = Conv.convert_Integer_to_byte((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                by = Conv.convert_Short_to_byte((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                by = (Byte)this.minmax.get(0);
                break;
            }
            case 12: {
                by = Conv.convert_BigDecimal_to_byte((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                by = Conv.convert_BigInteger_to_byte((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return by;
    }

    public Byte maximum_as_Byte() {
        return this.getMaximum_as_Byte();
    }

    public Byte getMaximum_as_Byte() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Byte by = new Byte(0);
        switch (this.type) {
            case 0: 
            case 1: {
                by = Conv.convert_Double_to_Byte((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                by = Conv.convert_Float_to_Byte((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                by = Conv.convert_Long_to_Byte((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                by = Conv.convert_Integer_to_Byte((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                by = Conv.convert_Short_to_Byte((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                by = (Byte)this.minmax.get(0);
                break;
            }
            case 12: {
                by = Conv.convert_BigDecimal_to_Byte((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                by = Conv.convert_BigInteger_to_Byte((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return by;
    }

    public BigDecimal maximum_as_BigDecimal() {
        return this.getMaximum_as_BigDecimal();
    }

    public BigDecimal getMaximum_as_BigDecimal() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        BigDecimal bigDecimal = new BigDecimal(0.0);
        switch (this.type) {
            case 0: 
            case 1: {
                bigDecimal = Conv.convert_Double_to_BigDecimal((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                bigDecimal = Conv.convert_Float_to_BigDecimal((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                bigDecimal = Conv.convert_Long_to_BigDecimal((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                bigDecimal = Conv.convert_Integer_to_BigDecimal((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                bigDecimal = Conv.convert_Short_to_BigDecimal((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                bigDecimal = Conv.convert_Byte_to_BigDecimal((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                bigDecimal = (BigDecimal)this.minmax.get(0);
                break;
            }
            case 13: {
                bigDecimal = Conv.convert_BigInteger_to_BigDecimal((BigInteger)this.minmax.get(0));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return bigDecimal;
    }

    public BigInteger maximum_as_BigInteger() {
        return this.getMaximum_as_BigInteger();
    }

    public BigInteger getMaximum_as_BigInteger() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        BigInteger bigInteger = new BigInteger("0");
        switch (this.type) {
            case 0: 
            case 1: {
                bigInteger = Conv.convert_Double_to_BigInteger((Double)this.minmax.get(0));
                break;
            }
            case 2: 
            case 3: {
                bigInteger = Conv.convert_Float_to_BigInteger((Float)this.minmax.get(0));
                break;
            }
            case 4: 
            case 5: {
                bigInteger = Conv.convert_Long_to_BigInteger((Long)this.minmax.get(0));
                break;
            }
            case 6: 
            case 7: {
                bigInteger = Conv.convert_Integer_to_BigInteger((Integer)this.minmax.get(0));
                break;
            }
            case 8: 
            case 9: {
                bigInteger = Conv.convert_Short_to_BigInteger((Short)this.minmax.get(0));
                break;
            }
            case 10: 
            case 11: {
                bigInteger = Conv.convert_Byte_to_BigInteger((Byte)this.minmax.get(0));
                break;
            }
            case 12: {
                bigInteger = Conv.convert_BigDecimal_to_BigInteger((BigDecimal)this.minmax.get(0));
                break;
            }
            case 13: {
                bigInteger = (BigInteger)this.minmax.get(0);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return bigInteger;
    }

    public char maximum_as_char() {
        return this.getMaximum_as_char();
    }

    public char getMaximum_as_char() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        char c = '\u0000';
        switch (this.type) {
            case 6: 
            case 7: {
                c = (char)((Integer)this.minmax.get(1)).intValue();
                break;
            }
            case 16: 
            case 17: {
                c = ((Character)this.minmax.get(1)).charValue();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a char type maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return c;
    }

    public Character maximum_as_Character() {
        return this.getMaximum_as_Character();
    }

    public Character getMaximum_as_Character() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Character c = new Character('\u0000');
        switch (this.type) {
            case 6: 
            case 7: {
                c = new Character((char)((Integer)this.minmax.get(1)).intValue());
                break;
            }
            case 16: 
            case 17: {
                c = (Character)this.minmax.get(1);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a Character type maximum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return c;
    }

    public double minimum() {
        return this.getMinimum_as_double();
    }

    public double minimum_as_double() {
        return this.getMinimum_as_double();
    }

    public double getMinimum() {
        return this.getMinimum_as_double();
    }

    public double getMinimum_as_double() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        double d = 0.0;
        switch (this.type) {
            case 0: 
            case 1: {
                d = (Double)this.minmax.get(1);
                break;
            }
            case 2: 
            case 3: {
                d = Conv.convert_Float_to_double((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                d = Conv.convert_Long_to_double((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                d = Conv.convert_Integer_to_double((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                d = Conv.convert_Short_to_double((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                d = Conv.convert_Byte_to_double((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                d = Conv.convert_BigDecimal_to_double((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                d = Conv.convert_BigInteger_to_double((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return d;
    }

    public Double minimum_as_Double() {
        return this.getMinimum_as_Double();
    }

    public Double getMinimum_as_Double() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Double d = new Double(0.0);
        switch (this.type) {
            case 0: 
            case 1: {
                d = (Double)this.minmax.get(1);
                break;
            }
            case 2: 
            case 3: {
                d = Conv.convert_Float_to_Double((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                d = Conv.convert_Long_to_Double((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                d = Conv.convert_Integer_to_Double((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                d = Conv.convert_Short_to_Double((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                d = Conv.convert_Byte_to_Double((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                d = Conv.convert_BigDecimal_to_Double((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                d = Conv.convert_BigInteger_to_Double((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return d;
    }

    public Float minimum_as_Float() {
        return this.getMinimum_as_Float();
    }

    public Float getMinimum_as_Float() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Float f = new Float(0.0);
        switch (this.type) {
            case 0: 
            case 1: {
                f = Conv.convert_Double_to_Float((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                f = (Float)this.minmax.get(1);
                break;
            }
            case 4: 
            case 5: {
                f = Conv.convert_Long_to_Float((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                f = Conv.convert_Integer_to_Float((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                f = Conv.convert_Short_to_Float((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                f = Conv.convert_Byte_to_Float((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                f = Conv.convert_BigDecimal_to_Float((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                f = Conv.convert_BigInteger_to_Float((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return f;
    }

    public float minimum_as_float() {
        return this.getMinimum_as_float();
    }

    public float getMinimum_as_float() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        float f = 0.0f;
        switch (this.type) {
            case 0: 
            case 1: {
                f = Conv.convert_Double_to_float((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                f = ((Float)this.minmax.get(1)).floatValue();
                break;
            }
            case 4: 
            case 5: {
                f = Conv.convert_Long_to_float((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                f = Conv.convert_Integer_to_float((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                f = Conv.convert_Short_to_float((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                f = Conv.convert_Byte_to_float((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                f = Conv.convert_BigDecimal_to_float((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                f = Conv.convert_BigInteger_to_float((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return f;
    }

    public long minimum_as_long() {
        return this.getMinimum_as_long();
    }

    public long getMinimum_as_long() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        long l = 0L;
        switch (this.type) {
            case 0: 
            case 1: {
                l = Conv.convert_Double_to_long((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                l = Conv.convert_Float_to_long((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                l = (Long)this.minmax.get(1);
                break;
            }
            case 6: 
            case 7: {
                l = Conv.convert_Integer_to_long((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                l = Conv.convert_Short_to_long((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                l = Conv.convert_Byte_to_long((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                l = Conv.convert_BigDecimal_to_long((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                l = Conv.convert_BigInteger_to_long((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return l;
    }

    public Long minimum_as_Long() {
        return this.getMinimum_as_Long();
    }

    public Long getMinimum_as_Long() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Long l = new Long(0L);
        switch (this.type) {
            case 0: 
            case 1: {
                l = Conv.convert_Double_to_Long((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                l = Conv.convert_Float_to_Long((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                l = (Long)this.minmax.get(1);
                break;
            }
            case 6: 
            case 7: {
                l = Conv.convert_Integer_to_Long((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                l = Conv.convert_Short_to_Long((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                l = Conv.convert_Byte_to_Long((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                l = Conv.convert_BigDecimal_to_Long((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                l = Conv.convert_BigInteger_to_Long((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return l;
    }

    public int minimum_as_int() {
        return this.getMinimum_as_int();
    }

    public int getMinimum_as_int() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = 0;
        switch (this.type) {
            case 0: 
            case 1: {
                n = Conv.convert_Double_to_int((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                n = Conv.convert_Float_to_int((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                n = Conv.convert_Long_to_int((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                n = (Integer)this.minmax.get(1);
                break;
            }
            case 8: 
            case 9: {
                n = Conv.convert_Short_to_int((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                n = Conv.convert_Byte_to_int((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                n = Conv.convert_BigDecimal_to_int((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                n = Conv.convert_BigInteger_to_int((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return n;
    }

    public Integer minimum_as_Integer() {
        return this.getMinimum_as_Integer();
    }

    public Integer getMinimum_as_Integer() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Integer n = new Integer(0);
        switch (this.type) {
            case 0: 
            case 1: {
                n = Conv.convert_Double_to_Integer((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                n = Conv.convert_Float_to_Integer((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                n = Conv.convert_Long_to_Integer((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                n = (Integer)this.minmax.get(1);
                break;
            }
            case 8: 
            case 9: {
                n = Conv.convert_Short_to_Integer((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                n = Conv.convert_Byte_to_Integer((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                n = Conv.convert_BigDecimal_to_Integer((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                n = Conv.convert_BigInteger_to_Integer((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return n;
    }

    public short minimum_as_short() {
        return this.getMinimum_as_short();
    }

    public short getMinimum_as_short() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        short s = 0;
        switch (this.type) {
            case 0: 
            case 1: {
                s = Conv.convert_Double_to_short((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                s = Conv.convert_Float_to_short((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                s = Conv.convert_Long_to_short((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                s = Conv.convert_Integer_to_short((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                s = (Short)this.minmax.get(1);
                break;
            }
            case 10: 
            case 11: {
                s = Conv.convert_Byte_to_short((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                s = Conv.convert_BigDecimal_to_short((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                s = Conv.convert_BigInteger_to_short((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return s;
    }

    public Short minimum_as_Short() {
        return this.getMinimum_as_Short();
    }

    public Short getMinimum_as_Short() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Short s = new Short(0);
        switch (this.type) {
            case 0: 
            case 1: {
                s = Conv.convert_Double_to_Short((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                s = Conv.convert_Float_to_Short((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                s = Conv.convert_Long_to_Short((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                s = Conv.convert_Integer_to_Short((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                s = (Short)this.minmax.get(1);
                break;
            }
            case 10: 
            case 11: {
                s = Conv.convert_Byte_to_Short((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                s = Conv.convert_BigDecimal_to_Short((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                s = Conv.convert_BigInteger_to_Short((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return s;
    }

    public byte minimum_as_byte() {
        return this.getMinimum_as_byte();
    }

    public byte getMinimum_as_byte() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        byte by = 0;
        switch (this.type) {
            case 0: 
            case 1: {
                by = Conv.convert_Double_to_byte((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                by = Conv.convert_Float_to_byte((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                by = Conv.convert_Long_to_byte((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                by = Conv.convert_Integer_to_byte((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                by = Conv.convert_Short_to_byte((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                by = (Byte)this.minmax.get(1);
                break;
            }
            case 12: {
                by = Conv.convert_BigDecimal_to_byte((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                by = Conv.convert_BigInteger_to_byte((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return by;
    }

    public Byte minimum_as_Byte() {
        return this.getMinimum_as_Byte();
    }

    public Byte getMinimum_as_Byte() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Byte by = new Byte(0);
        switch (this.type) {
            case 0: 
            case 1: {
                by = Conv.convert_Double_to_Byte((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                by = Conv.convert_Float_to_Byte((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                by = Conv.convert_Long_to_Byte((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                by = Conv.convert_Integer_to_Byte((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                by = Conv.convert_Short_to_Byte((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                by = (Byte)this.minmax.get(1);
                break;
            }
            case 12: {
                by = Conv.convert_BigDecimal_to_Byte((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                by = Conv.convert_BigInteger_to_Byte((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return by;
    }

    public BigDecimal minimum_as_BigDecimal() {
        return this.getMinimum_as_BigDecimal();
    }

    public BigDecimal getMinimum_as_BigDecimal() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        BigDecimal bigDecimal = new BigDecimal(0.0);
        switch (this.type) {
            case 0: 
            case 1: {
                bigDecimal = Conv.convert_Double_to_BigDecimal((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                bigDecimal = Conv.convert_Float_to_BigDecimal((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                bigDecimal = Conv.convert_Long_to_BigDecimal((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                bigDecimal = Conv.convert_Integer_to_BigDecimal((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                bigDecimal = Conv.convert_Short_to_BigDecimal((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                bigDecimal = Conv.convert_Byte_to_BigDecimal((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                bigDecimal = (BigDecimal)this.minmax.get(1);
                break;
            }
            case 13: {
                bigDecimal = Conv.convert_BigInteger_to_BigDecimal((BigInteger)this.minmax.get(1));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return bigDecimal;
    }

    public BigInteger minimum_as_BigInteger() {
        return this.getMinimum_as_BigInteger();
    }

    public BigInteger getMinimum_as_BigInteger() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        BigInteger bigInteger = new BigInteger("0");
        switch (this.type) {
            case 0: 
            case 1: {
                bigInteger = Conv.convert_Double_to_BigInteger((Double)this.minmax.get(1));
                break;
            }
            case 2: 
            case 3: {
                bigInteger = Conv.convert_Float_to_BigInteger((Float)this.minmax.get(1));
                break;
            }
            case 4: 
            case 5: {
                bigInteger = Conv.convert_Long_to_BigInteger((Long)this.minmax.get(1));
                break;
            }
            case 6: 
            case 7: {
                bigInteger = Conv.convert_Integer_to_BigInteger((Integer)this.minmax.get(1));
                break;
            }
            case 8: 
            case 9: {
                bigInteger = Conv.convert_Short_to_BigInteger((Short)this.minmax.get(1));
                break;
            }
            case 10: 
            case 11: {
                bigInteger = Conv.convert_Byte_to_BigInteger((Byte)this.minmax.get(1));
                break;
            }
            case 12: {
                bigInteger = Conv.convert_BigDecimal_to_BigInteger((BigDecimal)this.minmax.get(1));
                break;
            }
            case 13: {
                bigInteger = (BigInteger)this.minmax.get(1);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return bigInteger;
    }

    public char minimum_as_char() {
        return this.getMinimum_as_char();
    }

    public char getMinimum_as_char() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        char c = '\u0000';
        switch (this.type) {
            case 6: 
            case 7: {
                c = (char)((Integer)this.minmax.get(1)).intValue();
                break;
            }
            case 16: 
            case 17: {
                c = ((Character)this.minmax.get(1)).charValue();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a char type minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return c;
    }

    public Character minimum_as_Character() {
        return this.getMinimum_as_Character();
    }

    public Character getMinimum_as_Character() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        Character c = new Character('\u0000');
        switch (this.type) {
            case 6: 
            case 7: {
                c = new Character((char)((Integer)this.minmax.get(1)).intValue());
                break;
            }
            case 16: 
            case 17: {
                c = (Character)this.minmax.get(1);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a Character type minimum is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return c;
    }

    public int maximumIndex() {
        return this.maxIndex;
    }

    public int getMaximumIndex() {
        return this.maxIndex;
    }

    public int minimumIndex() {
        return this.minIndex;
    }

    public int getMinimumIndex() {
        return this.minIndex;
    }

    public boolean isInteger() {
        boolean bl = false;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                double[] dArray = this.getArray_as_double();
                bl = Fmath.isInteger(dArray);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: {
                bl = true;
                break;
            }
            case 12: {
                Number[] numberArray = this.getArray_as_BigDecimal();
                bl = Fmath.isInteger(numberArray);
                break;
            }
            case 14: 
            case 15: {
                bl = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        return bl;
    }

    public ArrayMaths plus(double d) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        String string = Double.toString(d);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] + d));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.add(new BigDecimal(d));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = this.type;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigDecimal bigDecimal = new BigDecimal(bigInteger).add(new BigDecimal(string));
                    arrayMaths.array.add(bigDecimal);
                    bigInteger = null;
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).plus(d));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).plus(new Complex(d)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((String)this.array.get(j) + string);
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a double or float cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a double or float cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(Double d) {
        return this.plus((double)d);
    }

    public ArrayMaths plus(double[] dArray) {
        Object[] objectArray;
        if (this.length != dArray.length) {
            throw new IllegalArgumentException("The length of the argument array, " + dArray.length + ", and the length of this instance internal array, " + this.length + ", must be equal");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] + dArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.add(new BigDecimal(dArray[j]));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = this.type;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigDecimal bigDecimal = new BigDecimal(bigInteger).add(new BigDecimal(dArray[j]));
                    arrayMaths.array.add(bigDecimal);
                    bigInteger = null;
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).plus(dArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).plus(new Phasor(dArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((String)this.array.get(j) + Double.toString(dArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a double or float cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a double or float cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(Double[] doubleArray) {
        int n = doubleArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        double[] dArray = new double[this.length];
        for (int j = 0; j < this.length; ++j) {
            dArray[j] = doubleArray[j];
        }
        return this.plus(dArray);
    }

    public ArrayMaths plus(float f) {
        double d = f;
        return this.plus(d);
    }

    public ArrayMaths plus(Float f) {
        return this.plus(f.floatValue());
    }

    public ArrayMaths plus(float[] fArray) {
        if (this.length != fArray.length) {
            throw new IllegalArgumentException("The length of the argument array, " + fArray.length + ", and the length of this instance internal array, " + this.length + ", must be equal");
        }
        double[] dArray = new double[this.length];
        for (int j = 0; j < this.length; ++j) {
            dArray[j] = fArray[j];
        }
        return this.plus(dArray);
    }

    public ArrayMaths plus(Float[] floatArray) {
        int n = floatArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        double[] dArray = new double[this.length];
        for (int j = 0; j < this.length; ++j) {
            dArray[j] = floatArray[j].doubleValue();
        }
        return this.plus(dArray);
    }

    public ArrayMaths plus(long l) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] + (double)l));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                long l2 = this.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                if (Long.MAX_VALUE - l2 >= l) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Long(lArray[j] + l));
                    }
                    arrayMaths.type = 4;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)lArray[j] + (double)l));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.add(new BigDecimal((double)l));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.add(new BigInteger(Long.toString(l)));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).plus(l));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).plus(new Phasor(l)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((String)this.array.get(j) + Long.toString(l));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a long cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a long cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(Long l) {
        long l2 = l;
        return this.plus(l2);
    }

    public ArrayMaths plus(long[] lArray) {
        Object[] objectArray;
        int n = lArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] + (double)lArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                long l = this.getMaximum_as_long();
                ArrayMaths arrayMaths2 = new ArrayMaths(lArray);
                long l2 = arrayMaths2.getMaximum_as_long();
                long[] lArray2 = this.getArray_as_long();
                if (Long.MAX_VALUE - l >= l2) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Long(lArray2[j] + lArray[j]));
                    }
                    arrayMaths.type = 4;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)lArray2[j] + (double)lArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.add(new BigDecimal((double)lArray[j]));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.add(new BigInteger(Long.toString(lArray[j])));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).plus(lArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).plus(new Phasor(lArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((String)this.array.get(j) + Long.toString(lArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a long cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a long cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(Long[] longArray) {
        int n = longArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        long[] lArray = new long[this.length];
        for (int j = 0; j < this.length; ++j) {
            lArray[j] = longArray[j];
        }
        return this.plus(lArray);
    }

    public ArrayMaths plus(int n) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] + (double)n));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: {
                long l = this.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                if (Long.MAX_VALUE - l >= (long)n) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Long(lArray[j] + (long)n));
                    }
                    arrayMaths.type = 4;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)lArray[j] + (double)n));
                }
                arrayMaths.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                int n2 = this.getMaximum_as_int();
                int[] nArray = this.getArray_as_int();
                if (Integer.MAX_VALUE - n2 >= n) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Integer(nArray[j] + n));
                    }
                    arrayMaths.type = 6;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)nArray[j] + (double)n));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.add(new BigDecimal((double)n));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.add(new BigInteger(Integer.toString(n)));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).plus(n));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).plus(new Phasor(n)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((String)this.array.get(j) + Integer.toString(n));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("an int cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("an int cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(Integer n) {
        int n2 = n;
        return this.plus(n2);
    }

    public ArrayMaths plus(int[] nArray) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] + (double)nArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: {
                long l = this.getMaximum_as_long();
                ArrayMaths arrayMaths2 = new ArrayMaths(nArray);
                long l2 = arrayMaths2.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                if (Long.MAX_VALUE - l >= l2) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Long(lArray[j] + (long)nArray[j]));
                    }
                    arrayMaths.type = 4;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)lArray[j] + (double)nArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                int n = this.getMaximum_as_int();
                ArrayMaths arrayMaths3 = new ArrayMaths(nArray);
                int n2 = arrayMaths3.getMaximum_as_int();
                int[] nArray2 = this.getArray_as_int();
                if (Integer.MAX_VALUE - n >= n2) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Integer(nArray2[j] + nArray[j]));
                    }
                    arrayMaths.type = 6;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)nArray2[j] + (double)nArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.add(new BigDecimal((double)nArray[j]));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.add(new BigInteger(Integer.toString(nArray[j])));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).plus(nArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).plus(new Phasor(nArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((String)this.array.get(j) + Integer.toString(nArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("an int cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("an int cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(Integer[] integerArray) {
        int n = integerArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        int[] nArray = new int[this.length];
        for (int j = 0; j < this.length; ++j) {
            nArray[j] = integerArray[j];
        }
        return this.plus(nArray);
    }

    public ArrayMaths plus(short s) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] + (double)s));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: {
                long l = this.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                if (Long.MAX_VALUE - l >= (long)s) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Long(lArray[j] + (long)s));
                    }
                    arrayMaths.type = 4;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)lArray[j] + (double)s));
                }
                arrayMaths.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                short s2 = this.getMaximum_as_short();
                short[] sArray = this.getArray_as_short();
                if (Integer.MAX_VALUE - s2 >= s) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Integer(sArray[j] + s));
                    }
                    arrayMaths.type = 6;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)sArray[j] + (double)s));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.add(new BigDecimal((double)s));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.add(new BigInteger(Integer.toString(s)));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).plus(s));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).plus(new Phasor(s)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((String)this.array.get(j) + Integer.toString(s));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a short cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a short cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(Short s) {
        short s2 = s;
        return this.plus(s2);
    }

    public ArrayMaths plus(short[] sArray) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] + (double)sArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: {
                long l = this.getMaximum_as_long();
                ArrayMaths arrayMaths2 = new ArrayMaths(sArray);
                long l2 = arrayMaths2.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                if (Long.MAX_VALUE - l >= l2) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Long(lArray[j] + (long)sArray[j]));
                    }
                    arrayMaths.type = 4;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)lArray[j] + (double)sArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                short s = this.getMaximum_as_short();
                ArrayMaths arrayMaths3 = new ArrayMaths(sArray);
                short s2 = arrayMaths3.getMaximum_as_short();
                short[] sArray2 = this.getArray_as_short();
                if (Integer.MAX_VALUE - s >= s2) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Integer(sArray2[j] + sArray[j]));
                    }
                    arrayMaths.type = 6;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)sArray2[j] + (double)sArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.add(new BigDecimal((double)sArray[j]));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.add(new BigInteger(Integer.toString(sArray[j])));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).plus(sArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).plus(new Phasor(sArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((String)this.array.get(j) + Integer.toString(sArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a short cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a short cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(Short[] shortArray) {
        int n = shortArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        short[] sArray = new short[this.length];
        for (int j = 0; j < this.length; ++j) {
            sArray[j] = shortArray[j];
        }
        return this.plus(sArray);
    }

    public ArrayMaths plus(BigDecimal bigDecimal) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = this.getArray_as_BigDecimal();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(objectArray[j].add(bigDecimal));
                }
                arrayMaths.type = 12;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].plus(bigDecimal.doubleValue()));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].plus(new Phasor(bigDecimal.doubleValue())));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((String)this.array.get(j) + bigDecimal.toString());
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigDecimal cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigDecimal cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(byte by) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] + (double)by));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: {
                long l = this.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                if (Long.MAX_VALUE - l >= (long)by) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Long(lArray[j] + (long)by));
                    }
                    arrayMaths.type = 4;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)lArray[j] + (double)by));
                }
                arrayMaths.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                byte by2 = this.getMaximum_as_byte();
                byte[] byArray = this.getArray_as_byte();
                if (Integer.MAX_VALUE - by2 >= by) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Integer(byArray[j] + by));
                    }
                    arrayMaths.type = 6;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)byArray[j] + (double)by));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.add(new BigDecimal((double)by));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.add(new BigInteger(Integer.toString(by)));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).plus(by));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).plus(new Phasor(by)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((String)this.array.get(j) + Integer.toString(by));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a byte cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a byte cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(Byte by) {
        byte by2 = by;
        return this.plus(by2);
    }

    public ArrayMaths plus(byte[] byArray) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] + (double)byArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: {
                long l = this.getMaximum_as_long();
                ArrayMaths arrayMaths2 = new ArrayMaths(byArray);
                long l2 = arrayMaths2.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                if (Long.MAX_VALUE - l >= l2) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Long(lArray[j] + (long)byArray[j]));
                    }
                    arrayMaths.type = 4;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)lArray[j] + (double)byArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                byte by = this.getMaximum_as_byte();
                ArrayMaths arrayMaths3 = new ArrayMaths(byArray);
                byte by2 = arrayMaths3.getMaximum_as_byte();
                byte[] byArray2 = this.getArray_as_byte();
                if (Integer.MAX_VALUE - by >= by2) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Integer(byArray2[j] + byArray[j]));
                    }
                    arrayMaths.type = 6;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)byArray2[j] + (double)byArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.add(new BigDecimal((double)byArray[j]));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.add(new BigInteger(Integer.toString(byArray[j])));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).plus(byArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).plus(new Phasor(byArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((String)this.array.get(j) + Integer.toString(byArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a byte cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a byte cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(Byte[] byteArray) {
        int n = byteArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        byte[] byArray = new byte[this.length];
        for (int j = 0; j < this.length; ++j) {
            byArray[j] = byteArray[j];
        }
        return this.plus(byArray);
    }

    public ArrayMaths plus(BigDecimal[] bigDecimalArray) {
        Object[] objectArray;
        int n = bigDecimalArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = this.getArray_as_BigDecimal();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(objectArray[j].add(bigDecimalArray[j]));
                }
                Conv.restoreMessages();
                arrayMaths.type = 12;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].plus(bigDecimalArray[j].doubleValue()));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].plus(new Phasor(bigDecimalArray[j].doubleValue())));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((String)this.array.get(j) + bigDecimalArray[j].toString());
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigDecimal cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigDecimal cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(BigInteger bigInteger) {
        Object object;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                object = Conv.convert_BigInteger_to_BigDecimal(bigInteger);
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigDecimalArray[j].add((BigDecimal)object));
                }
                arrayMaths.type = 12;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigIntegerArray[j].add(bigInteger));
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].plus(Conv.convert_BigInteger_to_double(bigInteger)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].plus(new Phasor(Conv.convert_BigInteger_to_double(bigInteger))));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((String)this.array.get(j) + bigInteger.toString());
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigInteger cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigInteger cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        object = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])object, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)object[0];
        arrayMaths.minIndex = (int)object[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(BigInteger[] bigIntegerArray) {
        Object[] objectArray;
        int n = bigIntegerArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                objectArray = this.getArray_as_BigDecimal();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(objectArray[j].add(Conv.convert_BigInteger_to_BigDecimal(bigIntegerArray[j])));
                }
                arrayMaths.type = 12;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                BigInteger[] bigIntegerArray2 = this.getArray_as_BigInteger();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigIntegerArray2[j].add(bigIntegerArray[j]));
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].plus(Conv.convert_BigInteger_to_double(bigIntegerArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].plus(new Phasor(Conv.convert_BigInteger_to_double(bigIntegerArray[j]))));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((String)this.array.get(j) + bigIntegerArray[j].toString());
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigInteger cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigInteger cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(Complex complex) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].plus(complex));
                }
                arrayMaths.type = 14;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].plus(Conv.convert_Complex_to_Phasor(complex)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((String)this.array.get(j) + complex.toString());
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Complex cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Complex cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(Complex[] complexArray) {
        int n = complexArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                Complex[] complexArray2 = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray2[j].plus(complexArray[j]));
                }
                arrayMaths.type = 14;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].plus(Conv.convert_Complex_to_Phasor(complexArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((String)this.array.get(j) + complexArray[j].toString());
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Complex cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Complex cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(Phasor phasor) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].plus(phasor));
                }
                arrayMaths.type = 15;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].plus(Conv.convert_Phasor_to_Complex(phasor)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((String)this.array.get(j) + phasor.toString());
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Phasor cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Phasor cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(Phasor[] phasorArray) {
        int n = phasorArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                Phasor[] phasorArray2 = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray2[j].plus(phasorArray[j]));
                }
                arrayMaths.type = 15;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].plus(Conv.convert_Phasor_to_Complex(phasorArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((String)this.array.get(j) + phasorArray[j].toString());
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Phasor cannot be added to a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Phasor cannot be added to a Character");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(String string) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                String[] stringArray = this.getArray_as_String();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(stringArray[j] + string);
                }
                arrayMaths.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(String[] stringArray) {
        int n = stringArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                String[] stringArray2 = this.getArray_as_String();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(stringArray2[j] + stringArray[j]);
                }
                arrayMaths.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(char c) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = this.getArray_as_String();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(objectArray[j] + c);
                }
                arrayMaths.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(char[] cArray) {
        Object[] objectArray;
        int n = cArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = this.getArray_as_String();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(objectArray[j] + cArray[j]);
                }
                arrayMaths.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(Character c) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = this.getArray_as_String();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(objectArray[j] + c);
                }
                arrayMaths.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(Character[] characterArray) {
        Object[] objectArray;
        int n = characterArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = this.getArray_as_String();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(objectArray[j] + characterArray[j]);
                }
                arrayMaths.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        return arrayMaths;
    }

    public ArrayMaths plus(Vector<Object> vector) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        ArrayMaths arrayMaths2 = new ArrayMaths(vector);
        switch (arrayMaths2.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = arrayMaths2.getArray_as_double();
                arrayMaths = this.plus((double[])objectArray);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                long[] lArray = arrayMaths2.getArray_as_long();
                arrayMaths = this.plus(lArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = arrayMaths2.getArray_as_BigDecimal();
                arrayMaths = this.plus(bigDecimalArray);
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = arrayMaths2.getArray_as_BigInteger();
                arrayMaths = this.plus(bigIntegerArray);
                break;
            }
            case 14: {
                Complex[] complexArray = arrayMaths2.getArray_as_Complex();
                arrayMaths = this.plus(complexArray);
                break;
            }
            case 15: {
                Phasor[] phasorArray = arrayMaths2.getArray_as_Phasor();
                arrayMaths = this.plus(phasorArray);
                break;
            }
            case 16: 
            case 17: {
                Character[] characterArray = arrayMaths2.getArray_as_Character();
                arrayMaths = this.plus(characterArray);
                break;
            }
            case 18: {
                String[] stringArray = arrayMaths2.getArray_as_String();
                arrayMaths = this.plus(stringArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(ArrayList<Object> arrayList) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        ArrayMaths arrayMaths2 = new ArrayMaths(arrayList);
        switch (arrayMaths2.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = arrayMaths2.getArray_as_double();
                arrayMaths = this.plus((double[])objectArray);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                long[] lArray = arrayMaths2.getArray_as_long();
                arrayMaths = this.plus(lArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = arrayMaths2.getArray_as_BigDecimal();
                arrayMaths = this.plus(bigDecimalArray);
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = arrayMaths2.getArray_as_BigInteger();
                arrayMaths = this.plus(bigIntegerArray);
                break;
            }
            case 14: {
                Complex[] complexArray = arrayMaths2.getArray_as_Complex();
                arrayMaths = this.plus(complexArray);
                break;
            }
            case 15: {
                Phasor[] phasorArray = arrayMaths2.getArray_as_Phasor();
                arrayMaths = this.plus(phasorArray);
                break;
            }
            case 16: 
            case 17: {
                Character[] characterArray = arrayMaths2.getArray_as_Character();
                arrayMaths = this.plus(characterArray);
                break;
            }
            case 18: {
                String[] stringArray = arrayMaths2.getArray_as_String();
                arrayMaths = this.plus(stringArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths plus(ArrayMaths arrayMaths) {
        ArrayList<Object> arrayList = arrayMaths.getArray_as_ArrayList();
        return this.plus(arrayList);
    }

    public ArrayMaths plus(Stat stat) {
        ArrayList<Object> arrayList = stat.getArray_as_ArrayList();
        return this.plus(arrayList);
    }

    public ArrayMaths minus(double d) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] - d));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.subtract(new BigDecimal(d));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = this.type;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigDecimal bigDecimal = new BigDecimal(bigInteger).subtract(new BigDecimal(d));
                    arrayMaths.array.add(bigDecimal);
                    bigInteger = null;
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).minus(d));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).minus(new Complex(d)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a double or float cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a double or float cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a double or float cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths minus(Double d) {
        return this.minus((double)d);
    }

    public ArrayMaths minus(double[] dArray) {
        Object[] objectArray;
        if (this.length != dArray.length) {
            throw new IllegalArgumentException("The length of the argument array, " + dArray.length + ", and the length of this instance internal array, " + this.length + ", must be equal");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] - dArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.subtract(new BigDecimal(dArray[j]));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = this.type;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigDecimal bigDecimal = new BigDecimal(bigInteger).subtract(new BigDecimal(dArray[j]));
                    arrayMaths.array.add(bigDecimal);
                    bigInteger = null;
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).minus(dArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).minus(new Phasor(dArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a double or float cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a double or float cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a double or float cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths minus(Double[] doubleArray) {
        int n = doubleArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        double[] dArray = new double[this.length];
        for (int j = 0; j < this.length; ++j) {
            dArray[j] = doubleArray[j];
        }
        return this.minus(dArray);
    }

    public ArrayMaths minus(float f) {
        double d = f;
        return this.minus(d);
    }

    public ArrayMaths minus(Float f) {
        return this.minus(f.floatValue());
    }

    public ArrayMaths minus(float[] fArray) {
        if (this.length != fArray.length) {
            throw new IllegalArgumentException("The length of the argument array, " + fArray.length + ", and the length of this instance internal array, " + this.length + ", must be equal");
        }
        double[] dArray = new double[this.length];
        for (int j = 0; j < this.length; ++j) {
            dArray[j] = fArray[j];
        }
        return this.minus(dArray);
    }

    public ArrayMaths minus(Float[] floatArray) {
        int n = floatArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        double[] dArray = new double[this.length];
        for (int j = 0; j < this.length; ++j) {
            dArray[j] = floatArray[j].doubleValue();
        }
        return this.minus(dArray);
    }

    public ArrayMaths minus(long l) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] - (double)l));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                long l2 = this.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                if (Long.MAX_VALUE - l2 >= l) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Long(lArray[j] - l));
                    }
                    arrayMaths.type = 4;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)lArray[j] - (double)l));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.subtract(new BigDecimal((double)l));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.subtract(new BigInteger(Long.toString(l)));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).minus(l));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).minus(new Phasor(l)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a long cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a long cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a long cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths minus(Long l) {
        long l2 = l;
        return this.minus(l2);
    }

    public ArrayMaths minus(long[] lArray) {
        Object[] objectArray;
        int n = lArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] - (double)lArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                long l = this.getMaximum_as_long();
                ArrayMaths arrayMaths2 = new ArrayMaths(lArray);
                long l2 = arrayMaths2.getMaximum_as_long();
                long[] lArray2 = this.getArray_as_long();
                if (Long.MAX_VALUE - l >= l2) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Long(lArray2[j] - lArray[j]));
                    }
                    arrayMaths.type = 4;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)lArray2[j] - (double)lArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.subtract(new BigDecimal((double)lArray[j]));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.subtract(new BigInteger(Long.toString(lArray[j])));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).minus(lArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).minus(new Phasor(lArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a long cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a long cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a long cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths minus(Long[] longArray) {
        int n = longArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        long[] lArray = new long[this.length];
        for (int j = 0; j < this.length; ++j) {
            lArray[j] = longArray[j];
        }
        return this.minus(lArray);
    }

    public ArrayMaths minus(int n) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] - (double)n));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: {
                long l = this.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                if (Long.MAX_VALUE - l >= (long)n) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Long(lArray[j] - (long)n));
                    }
                    arrayMaths.type = 4;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)lArray[j] - (double)n));
                }
                arrayMaths.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                int n2 = this.getMaximum_as_int();
                int[] nArray = this.getArray_as_int();
                if (Integer.MAX_VALUE - n2 >= n) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Integer(nArray[j] - n));
                    }
                    arrayMaths.type = 6;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)nArray[j] - (double)n));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.subtract(new BigDecimal((double)n));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.subtract(new BigInteger(Integer.toString(n)));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).minus(n));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).minus(new Phasor(n)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("an int cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("an int cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("an int cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths minus(Integer n) {
        int n2 = n;
        return this.minus(n2);
    }

    public ArrayMaths minus(int[] nArray) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] - (double)nArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: {
                long l = this.getMaximum_as_long();
                ArrayMaths arrayMaths2 = new ArrayMaths(nArray);
                long l2 = arrayMaths2.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                if (Long.MAX_VALUE - l >= l2) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Long(lArray[j] - (long)nArray[j]));
                    }
                    arrayMaths.type = 4;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)lArray[j] - (double)nArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                int n = this.getMaximum_as_int();
                ArrayMaths arrayMaths3 = new ArrayMaths(nArray);
                int n2 = arrayMaths3.getMaximum_as_int();
                int[] nArray2 = this.getArray_as_int();
                if (Integer.MAX_VALUE - n >= n2) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Integer(nArray2[j] - nArray[j]));
                    }
                    arrayMaths.type = 6;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)nArray2[j] - (double)nArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.subtract(new BigDecimal((double)nArray[j]));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.subtract(new BigInteger(Integer.toString(nArray[j])));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).minus(nArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).minus(new Phasor(nArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("an int cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("an int cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("an int cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths minus(Integer[] integerArray) {
        int n = integerArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        int[] nArray = new int[this.length];
        for (int j = 0; j < this.length; ++j) {
            nArray[j] = integerArray[j];
        }
        return this.minus(nArray);
    }

    public ArrayMaths minus(short s) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] - (double)s));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: {
                long l = this.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                if (Long.MAX_VALUE - l >= (long)s) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Long(lArray[j] - (long)s));
                    }
                    arrayMaths.type = 4;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)lArray[j] - (double)s));
                }
                arrayMaths.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                short s2 = this.getMaximum_as_short();
                short[] sArray = this.getArray_as_short();
                if (Integer.MAX_VALUE - s2 >= s) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Integer(sArray[j] - s));
                    }
                    arrayMaths.type = 6;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)sArray[j] - (double)s));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.subtract(new BigDecimal((double)s));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.subtract(new BigInteger(Integer.toString(s)));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).minus(s));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).minus(new Phasor(s)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a short cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a short cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a short cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths minus(Short s) {
        short s2 = s;
        return this.minus(s2);
    }

    public ArrayMaths minus(short[] sArray) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] - (double)sArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: {
                long l = this.getMaximum_as_long();
                ArrayMaths arrayMaths2 = new ArrayMaths(sArray);
                long l2 = arrayMaths2.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                if (Long.MAX_VALUE - l >= l2) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Long(lArray[j] - (long)sArray[j]));
                    }
                    arrayMaths.type = 4;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)lArray[j] - (double)sArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                short s = this.getMaximum_as_short();
                ArrayMaths arrayMaths3 = new ArrayMaths(sArray);
                short s2 = arrayMaths3.getMaximum_as_short();
                short[] sArray2 = this.getArray_as_short();
                if (Integer.MAX_VALUE - s >= s2) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Integer(sArray2[j] - sArray[j]));
                    }
                    arrayMaths.type = 6;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)sArray2[j] - (double)sArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.subtract(new BigDecimal((double)sArray[j]));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.subtract(new BigInteger(Integer.toString(sArray[j])));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).minus(sArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).minus(new Phasor(sArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a long cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a long cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a short cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths minus(Short[] shortArray) {
        int n = shortArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        short[] sArray = new short[this.length];
        for (int j = 0; j < this.length; ++j) {
            sArray[j] = shortArray[j];
        }
        return this.minus(sArray);
    }

    public ArrayMaths minus(BigDecimal bigDecimal) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = this.getArray_as_BigDecimal();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(objectArray[j].subtract(bigDecimal));
                }
                arrayMaths.type = 12;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].minus(bigDecimal.doubleValue()));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].minus(new Phasor(bigDecimal.doubleValue())));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigDecimal cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigDecimal cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a BigDecimal cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths minus(byte by) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] - (double)by));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: {
                long l = this.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                if (Long.MAX_VALUE - l >= (long)by) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Long(lArray[j] - (long)by));
                    }
                    arrayMaths.type = 4;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)lArray[j] - (double)by));
                }
                arrayMaths.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                byte by2 = this.getMaximum_as_byte();
                byte[] byArray = this.getArray_as_byte();
                if (Integer.MAX_VALUE - by2 >= by) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Integer(byArray[j] - by));
                    }
                    arrayMaths.type = 6;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)byArray[j] - (double)by));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.subtract(new BigDecimal((double)by));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.subtract(new BigInteger(Integer.toString(by)));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).minus(by));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).minus(new Phasor(by)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a byte cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a byte cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a byte cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths minus(Byte by) {
        byte by2 = by;
        return this.minus(by2);
    }

    public ArrayMaths minus(byte[] byArray) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] - (double)byArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: {
                long l = this.getMaximum_as_long();
                ArrayMaths arrayMaths2 = new ArrayMaths(byArray);
                long l2 = arrayMaths2.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                if (Long.MAX_VALUE - l >= l2) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Long(lArray[j] - (long)byArray[j]));
                    }
                    arrayMaths.type = 4;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)lArray[j] - (double)byArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                byte by = this.getMaximum_as_byte();
                ArrayMaths arrayMaths3 = new ArrayMaths(byArray);
                byte by2 = arrayMaths3.getMaximum_as_byte();
                byte[] byArray2 = this.getArray_as_byte();
                if (Integer.MAX_VALUE - by >= by2) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Integer(byArray2[j] - byArray[j]));
                    }
                    arrayMaths.type = 6;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)byArray2[j] - (double)byArray[j]));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.subtract(new BigDecimal((double)byArray[j]));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.subtract(new BigInteger(Integer.toString(byArray[j])));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).minus(byArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).minus(new Phasor(byArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a byte cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a byte cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a byte cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths minus(Byte[] byteArray) {
        int n = byteArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        byte[] byArray = new byte[this.length];
        for (int j = 0; j < this.length; ++j) {
            byArray[j] = byteArray[j];
        }
        return this.minus(byArray);
    }

    public ArrayMaths minus(BigDecimal[] bigDecimalArray) {
        Object[] objectArray;
        int n = bigDecimalArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = this.getArray_as_BigDecimal();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(objectArray[j].add(bigDecimalArray[j]));
                }
                Conv.restoreMessages();
                arrayMaths.type = 12;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].minus(bigDecimalArray[j].doubleValue()));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].minus(new Phasor(bigDecimalArray[j].doubleValue())));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigDecimal cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigDecimal cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a BigDecimalcannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths minus(BigInteger bigInteger) {
        Object object;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                object = Conv.convert_BigInteger_to_BigDecimal(bigInteger);
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigDecimalArray[j].add((BigDecimal)object));
                }
                arrayMaths.type = 12;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigIntegerArray[j].subtract(bigInteger));
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].minus(Conv.convert_BigInteger_to_double(bigInteger)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].minus(new Phasor(Conv.convert_BigInteger_to_double(bigInteger))));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigInteger cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigInteger cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a BigInteger cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        object = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])object, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)object[0];
        arrayMaths.minIndex = (int)object[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths minus(BigInteger[] bigIntegerArray) {
        Object[] objectArray;
        int n = bigIntegerArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                objectArray = this.getArray_as_BigDecimal();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(objectArray[j].add(Conv.convert_BigInteger_to_BigDecimal(bigIntegerArray[j])));
                }
                arrayMaths.type = 12;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                BigInteger[] bigIntegerArray2 = this.getArray_as_BigInteger();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigIntegerArray2[j].add(bigIntegerArray[j]));
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].minus(Conv.convert_BigInteger_to_double(bigIntegerArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].minus(new Phasor(Conv.convert_BigInteger_to_double(bigIntegerArray[j]))));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigInteger cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigInteger cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a BigInteger cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths minus(Complex complex) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].minus(complex));
                }
                arrayMaths.type = 14;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].minus(Conv.convert_Complex_to_Phasor(complex)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Complex cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Complex cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a Complex cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths minus(Complex[] complexArray) {
        int n = complexArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                Complex[] complexArray2 = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray2[j].minus(complexArray[j]));
                }
                arrayMaths.type = 14;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].minus(Conv.convert_Complex_to_Phasor(complexArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Complex cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Complex cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a Complex cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths minus(Phasor phasor) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].minus(phasor));
                }
                arrayMaths.type = 15;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].minus(Conv.convert_Phasor_to_Complex(phasor)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Phasor cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Phasor cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a Phasor cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths minus(Phasor[] phasorArray) {
        int n = phasorArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                Phasor[] phasorArray2 = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray2[j].minus(phasorArray[j]));
                }
                arrayMaths.type = 15;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].minus(Conv.convert_Phasor_to_Complex(phasorArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Phasor cannot be subtracted from a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Phasor cannot be subtracted from a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a Phasor cannot be subtracted from a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths minus(Vector<Object> vector) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        ArrayMaths arrayMaths2 = new ArrayMaths(vector);
        switch (arrayMaths2.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = arrayMaths2.getArray_as_double();
                arrayMaths = this.minus((double[])objectArray);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                long[] lArray = arrayMaths2.getArray_as_long();
                arrayMaths = this.minus(lArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = arrayMaths2.getArray_as_BigDecimal();
                arrayMaths = this.minus(bigDecimalArray);
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = arrayMaths2.getArray_as_BigInteger();
                arrayMaths = this.minus(bigIntegerArray);
                break;
            }
            case 14: {
                Complex[] complexArray = arrayMaths2.getArray_as_Complex();
                arrayMaths = this.minus(complexArray);
                break;
            }
            case 15: {
                Phasor[] phasorArray = arrayMaths2.getArray_as_Phasor();
                arrayMaths = this.minus(phasorArray);
                break;
            }
            case 16: {
                throw new IllegalArgumentException("ArrayList/char subtraction not allowed");
            }
            case 17: {
                throw new IllegalArgumentException("ArrayList/Character subtraction not allowed");
            }
            case 18: {
                throw new IllegalArgumentException("ArrayList/String subtraction not allowed");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths minus(ArrayList<Object> arrayList) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        ArrayMaths arrayMaths2 = new ArrayMaths(arrayList);
        switch (arrayMaths2.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = arrayMaths2.getArray_as_double();
                arrayMaths = this.minus((double[])objectArray);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                long[] lArray = arrayMaths2.getArray_as_long();
                arrayMaths = this.minus(lArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = arrayMaths2.getArray_as_BigDecimal();
                arrayMaths = this.minus(bigDecimalArray);
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = arrayMaths2.getArray_as_BigInteger();
                arrayMaths = this.minus(bigIntegerArray);
                break;
            }
            case 14: {
                Complex[] complexArray = arrayMaths2.getArray_as_Complex();
                arrayMaths = this.minus(complexArray);
                break;
            }
            case 15: {
                Phasor[] phasorArray = arrayMaths2.getArray_as_Phasor();
                arrayMaths = this.minus(phasorArray);
                break;
            }
            case 16: {
                throw new IllegalArgumentException("ArrayList/char subtraction not allowed");
            }
            case 17: {
                throw new IllegalArgumentException("ArrayList/Character subtraction not allowed");
            }
            case 18: {
                throw new IllegalArgumentException("ArrayList/String subtraction not allowed");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths minus(ArrayMaths arrayMaths) {
        ArrayList<Object> arrayList = arrayMaths.getArray_as_ArrayList();
        return this.minus(arrayList);
    }

    public ArrayMaths minus(Stat stat) {
        ArrayList<Object> arrayList = stat.getArray_as_ArrayList();
        return this.minus(arrayList);
    }

    public ArrayMaths times(double d) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] * d));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.multiply(new BigDecimal(d));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = this.type;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigDecimal bigDecimal = new BigDecimal(bigInteger).multiply(new BigDecimal(d));
                    arrayMaths.array.add(bigDecimal);
                    bigInteger = null;
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).times(d));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).times(new Complex(d)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a double or float cannot be multiplied by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a double or float cannot be multiplied by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a double or float cannot be multiplied by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths times(Double d) {
        return this.times((double)d);
    }

    public ArrayMaths times(float f) {
        double d = f;
        return this.times(d);
    }

    public ArrayMaths times(Float f) {
        return this.times(f.floatValue());
    }

    public ArrayMaths times(long l) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] * (double)l));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                long l2 = this.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                if (Long.MAX_VALUE - l2 >= l) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Long(lArray[j] * l));
                    }
                    arrayMaths.type = 4;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)lArray[j] * (double)l));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.multiply(new BigDecimal((double)l));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.multiply(new BigInteger(Long.toString(l)));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).times(l));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).times(new Phasor(l)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a long cannot be multiplied by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a long cannot be multiplied by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a long cannot be multiplied by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths times(Long l) {
        long l2 = l;
        return this.times(l2);
    }

    public ArrayMaths times(int n) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] * (double)n));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: {
                long l = this.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                if (Long.MAX_VALUE - l >= (long)n) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Long(lArray[j] * (long)n));
                    }
                    arrayMaths.type = 4;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)lArray[j] * (double)n));
                }
                arrayMaths.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                int n2 = this.getMaximum_as_int();
                int[] nArray = this.getArray_as_int();
                if (Integer.MAX_VALUE - n2 >= n) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Integer(nArray[j] * n));
                    }
                    arrayMaths.type = 6;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)nArray[j] * (double)n));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.multiply(new BigDecimal((double)n));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.multiply(new BigInteger(Integer.toString(n)));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).times(n));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).times(new Phasor(n)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("an int cannot be multiplied by a char");
            }
            case 17: {
                throw new IllegalArgumentException("an int cannot be multiplied by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("an int cannot be multiplied by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths times(Integer n) {
        int n2 = n;
        return this.times(n2);
    }

    public ArrayMaths times(short s) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] * (double)s));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: {
                long l = this.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                if (Long.MAX_VALUE - l >= (long)s) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Long(lArray[j] * (long)s));
                    }
                    arrayMaths.type = 4;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)lArray[j] * (double)s));
                }
                arrayMaths.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                short s2 = this.getMaximum_as_short();
                short[] sArray = this.getArray_as_short();
                if (Integer.MAX_VALUE - s2 >= s) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Integer(sArray[j] * s));
                    }
                    arrayMaths.type = 6;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)sArray[j] * (double)s));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.multiply(new BigDecimal((double)s));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.multiply(new BigInteger(Integer.toString(s)));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).times(s));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).times(new Phasor(s)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a short cannot be multiplied by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a short cannot be multiplied by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a short cannot be multiplied by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths times(Short s) {
        short s2 = s;
        return this.times(s2);
    }

    public ArrayMaths times(BigDecimal bigDecimal) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = this.getArray_as_BigDecimal();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(objectArray[j].multiply(bigDecimal));
                }
                arrayMaths.type = 12;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].times(bigDecimal.doubleValue()));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].times(new Phasor(bigDecimal.doubleValue())));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigDecimal cannot be multiplied by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigDecimal cannot be multiplied by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a BigDecimal cannot be multiplied by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths times(byte by) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] * (double)by));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: {
                long l = this.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                if (Long.MAX_VALUE - l >= (long)by) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Long(lArray[j] * (long)by));
                    }
                    arrayMaths.type = 4;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)lArray[j] * (double)by));
                }
                arrayMaths.type = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                byte by2 = this.getMaximum_as_byte();
                byte[] byArray = this.getArray_as_byte();
                if (Integer.MAX_VALUE - by2 >= by) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Integer(byArray[j] * by));
                    }
                    arrayMaths.type = 6;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)byArray[j] * (double)by));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.multiply(new BigDecimal((double)by));
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.multiply(new BigInteger(Integer.toString(by)));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).times(by));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).times(new Phasor(by)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a byte cannot be multiplied by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a byte cannot be multiplied by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a byte cannot be multiplied by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths times(Byte by) {
        byte by2 = by;
        return this.times(by2);
    }

    public ArrayMaths times(BigInteger bigInteger) {
        Object object;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                object = Conv.convert_BigInteger_to_BigDecimal(bigInteger);
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigDecimalArray[j].add((BigDecimal)object));
                }
                arrayMaths.type = 12;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigIntegerArray[j].multiply(bigInteger));
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].times(Conv.convert_BigInteger_to_double(bigInteger)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].times(new Phasor(Conv.convert_BigInteger_to_double(bigInteger))));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigInteger cannot be multiplied by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigInteger cannot be multiplied by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a BigInteger cannot be multiplied by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        object = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])object, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)object[0];
        arrayMaths.minIndex = (int)object[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths times(Complex complex) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].times(complex));
                }
                arrayMaths.type = 14;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].times(Conv.convert_Complex_to_Phasor(complex)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Complex cannot be multiplied by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Complex cannot be multiplied by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a Complex cannot be multiplied by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths times(Phasor phasor) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].times(phasor));
                }
                arrayMaths.type = 15;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].times(Conv.convert_Phasor_to_Complex(phasor)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Phasor cannot be multiplied by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Phasor cannot be multiplied by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a Phasor cannot be multiplied by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths over(double d) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] / d));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.divide(new BigDecimal(d), 4);
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = this.type;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigDecimal bigDecimal = new BigDecimal(bigInteger).divide(new BigDecimal(d), 4);
                    arrayMaths.array.add(bigDecimal);
                    bigInteger = null;
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).over(d));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).over(new Complex(d)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a double or float cannot be divided by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a double or float cannot be divided by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a double or float cannot be divided by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths over(Double d) {
        return this.over((double)d);
    }

    public ArrayMaths over(float f) {
        double d = f;
        return this.over(d);
    }

    public ArrayMaths over(Float f) {
        return this.over(f.floatValue());
    }

    public ArrayMaths over(long l) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] / (double)l));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                long l2 = this.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                if (Long.MAX_VALUE - l2 >= l) {
                    for (int j = 0; j < this.length; ++j) {
                        arrayMaths.array.add(new Long(lArray[j] / l));
                    }
                    arrayMaths.type = 4;
                    break;
                }
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)lArray[j] / (double)l));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.divide(new BigDecimal((double)l), 4);
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.divide(new BigInteger(Long.toString(l)));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).over(l));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).over(new Phasor(l)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a long cannot be divided by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a long cannot be divided by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a long cannot be divided by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths over(Long l) {
        long l2 = l;
        return this.over(l2);
    }

    public ArrayMaths over(int n) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] / (double)n));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: {
                long l = this.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Long(lArray[j] / (long)n));
                }
                arrayMaths.type = 4;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                int n2 = this.getMaximum_as_int();
                int[] nArray = this.getArray_as_int();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Integer(nArray[j] / n));
                }
                arrayMaths.type = 6;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.divide(new BigDecimal((double)n), 4);
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.divide(new BigInteger(Integer.toString(n)));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).over(n));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).over(new Phasor(n)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("an int cannot be divided by a char");
            }
            case 17: {
                throw new IllegalArgumentException("an int cannot be divided by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("an int cannot be divided by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths over(Integer n) {
        int n2 = n;
        return this.over(n2);
    }

    public ArrayMaths over(short s) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] / (double)s));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: {
                long l = this.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Long(lArray[j] / (long)s));
                }
                arrayMaths.type = 4;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                short s2 = this.getMaximum_as_short();
                short[] sArray = this.getArray_as_short();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Integer(sArray[j] / s));
                }
                arrayMaths.type = 6;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.divide(new BigDecimal((double)s), 4);
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.divide(new BigInteger(Integer.toString(s)));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).over(s));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).over(new Phasor(s)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a short cannot be divided by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a short cannot be divided by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a short cannot be divided by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths over(Short s) {
        short s2 = s;
        return this.over(s2);
    }

    public ArrayMaths over(BigDecimal bigDecimal) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = this.getArray_as_BigDecimal();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(objectArray[j].divide(bigDecimal, 4));
                }
                arrayMaths.type = 12;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].over(bigDecimal.doubleValue()));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].over(new Phasor(bigDecimal.doubleValue())));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigDecimal cannot be divided by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigDecimal cannot be divided by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a BigDecimal cannot be divided by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths over(byte by) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] / (double)by));
                }
                arrayMaths.type = 0;
                break;
            }
            case 4: {
                long l = this.getMaximum_as_long();
                long[] lArray = this.getArray_as_long();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Long(lArray[j] / (long)by));
                }
                arrayMaths.type = 4;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                byte by2 = this.getMaximum_as_byte();
                byte[] byArray = this.getArray_as_byte();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double((double)byArray[j] / (double)by));
                }
                arrayMaths.type = 0;
                break;
            }
            case 12: {
                for (int j = 0; j < this.length; ++j) {
                    BigDecimal bigDecimal = (BigDecimal)this.array.get(j);
                    bigDecimal = bigDecimal.divide(new BigDecimal((double)by), 4);
                    arrayMaths.array.add(bigDecimal);
                    bigDecimal = null;
                }
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                for (int j = 0; j < this.length; ++j) {
                    BigInteger bigInteger = (BigInteger)this.array.get(j);
                    BigInteger bigInteger2 = bigInteger.divide(new BigInteger(Integer.toString(by)));
                    arrayMaths.array.add(bigInteger2);
                    bigInteger = null;
                    bigInteger2 = null;
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Complex)this.array.get(j)).over(by));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(((Phasor)this.array.get(j)).over(new Phasor(by)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a byte cannot be divided by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a byte cannot be divided by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a byte cannot be divided by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths over(Byte by) {
        byte by2 = by;
        return this.over(by2);
    }

    public ArrayMaths over(BigInteger bigInteger) {
        Object object;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                object = Conv.convert_BigInteger_to_BigDecimal(bigInteger);
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigDecimalArray[j].add((BigDecimal)object));
                }
                arrayMaths.type = 12;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigIntegerArray[j].divide(bigInteger));
                }
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].over(Conv.convert_BigInteger_to_double(bigInteger)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].over(new Phasor(Conv.convert_BigInteger_to_double(bigInteger))));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a BigInteger cannot be divided by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a BigInteger cannot be divided by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a BigInteger cannot be divided by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        object = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])object, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)object[0];
        arrayMaths.minIndex = (int)object[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths over(Complex complex) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].over(complex));
                }
                arrayMaths.type = 14;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].over(Conv.convert_Complex_to_Phasor(complex)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Complex cannot be divided by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Complex cannot be divided by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a Complex cannot be divided by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths over(Phasor phasor) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].over(phasor));
                }
                arrayMaths.type = 15;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].over(Conv.convert_Phasor_to_Complex(phasor)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: {
                throw new IllegalArgumentException("a Phasor cannot be divided by a char");
            }
            case 17: {
                throw new IllegalArgumentException("a Phasor cannot be divided by a Character");
            }
            case 18: {
                throw new IllegalArgumentException("a Phasor cannot be divided by a String");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths truncate(int n) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(Fmath.truncate(objectArray[j], n)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 2: 
            case 3: {
                float[] fArray = this.getArray_as_float();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Float(Fmath.truncate(fArray[j], n)));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 4: 
            case 5: {
                long[] lArray = this.getArray_as_long();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Long(lArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 6: 
            case 7: {
                int[] nArray = this.getArray_as_int();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Long(nArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 8: 
            case 9: {
                short[] sArray = this.getArray_as_short();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Short(sArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 10: 
            case 11: {
                byte[] byArray = this.getArray_as_byte();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Byte(byArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigDecimalArray[j].setScale(n, 4));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigIntegerArray[j]);
                }
                arrayMaths.type = this.type;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Complex.truncate(complexArray[j], n));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Phasor.truncate(phasorArray[j], n));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: 
            case 17: {
                char[] cArray = this.getArray_as_char();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Character(cArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                String[] stringArray = this.getArray_as_String();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(stringArray[j]);
                }
                arrayMaths.type = this.type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths floor() {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(Math.floor(objectArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 2: 
            case 3: {
                float[] fArray = this.getArray_as_float();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Float(Math.floor(fArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 4: 
            case 5: {
                long[] lArray = this.getArray_as_long();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Long(lArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 6: 
            case 7: {
                int[] nArray = this.getArray_as_int();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Long(nArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 8: 
            case 9: {
                short[] sArray = this.getArray_as_short();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Short(sArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 10: 
            case 11: {
                byte[] byArray = this.getArray_as_byte();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Byte(byArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigDecimalArray[j].setScale(0, 1));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigIntegerArray[j]);
                }
                arrayMaths.type = this.type;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Complex(Math.floor(complexArray[j].getReal()), Math.floor(complexArray[j].getImag())));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Phasor(Math.floor(phasorArray[j].getMagnitude()), Math.floor(phasorArray[j].getPhaseInDegrees())));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: 
            case 17: {
                char[] cArray = this.getArray_as_char();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Character(cArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                String[] stringArray = this.getArray_as_String();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(stringArray[j]);
                }
                arrayMaths.type = this.type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths ceil() {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(Math.ceil(objectArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 2: 
            case 3: {
                float[] fArray = this.getArray_as_float();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Float(Math.ceil(fArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 4: 
            case 5: {
                long[] lArray = this.getArray_as_long();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Long(lArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 6: 
            case 7: {
                int[] nArray = this.getArray_as_int();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Long(nArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 8: 
            case 9: {
                short[] sArray = this.getArray_as_short();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Short(sArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 10: 
            case 11: {
                byte[] byArray = this.getArray_as_byte();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Byte(byArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigDecimalArray[j].setScale(0, 0));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigIntegerArray[j]);
                }
                arrayMaths.type = this.type;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Complex(Math.ceil(complexArray[j].getReal()), Math.ceil(complexArray[j].getImag())));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Phasor(Math.ceil(phasorArray[j].getMagnitude()), Math.ceil(phasorArray[j].getPhaseInDegrees())));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: 
            case 17: {
                char[] cArray = this.getArray_as_char();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Character(cArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                String[] stringArray = this.getArray_as_String();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(stringArray[j]);
                }
                arrayMaths.type = this.type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths rint() {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(Math.rint(objectArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 2: 
            case 3: {
                float[] fArray = this.getArray_as_float();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Float(Math.rint(fArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 4: 
            case 5: {
                long[] lArray = this.getArray_as_long();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Long(lArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 6: 
            case 7: {
                int[] nArray = this.getArray_as_int();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Long(nArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 8: 
            case 9: {
                short[] sArray = this.getArray_as_short();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Short(sArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 10: 
            case 11: {
                byte[] byArray = this.getArray_as_byte();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Byte(byArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigDecimalArray[j].setScale(0, 6));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigIntegerArray[j]);
                }
                arrayMaths.type = this.type;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Complex(Math.rint(complexArray[j].getReal()), Math.rint(complexArray[j].getImag())));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Phasor(Math.rint(phasorArray[j].getMagnitude()), Math.rint(phasorArray[j].getPhaseInDegrees())));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 16: 
            case 17: {
                char[] cArray = this.getArray_as_char();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Character(cArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                String[] stringArray = this.getArray_as_String();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(stringArray[j]);
                }
                arrayMaths.type = this.type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths reverse() {
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        arrayMaths.type = this.type;
        arrayMaths.sortedIndices = new int[this.length];
        for (int j = 0; j < this.length; ++j) {
            arrayMaths.array.add(this.array.get(this.length - j - 1));
            arrayMaths.sortedIndices[j] = this.length - j - 1;
        }
        if (this.type != 18) {
            int[] nArray = new int[2];
            ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, nArray, arrayMaths.typeName, arrayMaths.type);
            arrayMaths.maxIndex = nArray[0];
            arrayMaths.minIndex = nArray[1];
        }
        return arrayMaths;
    }

    public ArrayMaths log() {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(Math.log(objectArray[j])));
                }
                arrayMaths.type = 1;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Complex.log(complexArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Phasor.log(phasorArray[j]));
                }
                arrayMaths.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths log2() {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(Fmath.log2(objectArray[j])));
                }
                arrayMaths.type = 1;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Complex.log(complexArray[j].over(Math.log(2.0))));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Phasor.log(phasorArray[j].over(Math.log(2.0))));
                }
                arrayMaths.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths log10() {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(Math.log10(objectArray[j])));
                }
                arrayMaths.type = 1;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Complex.log(complexArray[j].over(Math.log(10.0))));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Phasor.log(phasorArray[j].over(Math.log(10.0))));
                }
                arrayMaths.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths antilog10() {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(Math.pow(10.0, objectArray[j])));
                }
                arrayMaths.type = 1;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Complex.pow(10.0, complexArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Conv.convert_Complex_to_Phasor(Complex.pow(10.0, complexArray[j])));
                }
                arrayMaths.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths xLog2x() {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] * Fmath.log2(objectArray[j])));
                }
                arrayMaths.type = 1;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].times(Complex.log(complexArray[j].over(Math.log(2.0)))));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].times(Phasor.log(phasorArray[j].over(Math.log(2.0)))));
                }
                arrayMaths.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths xLogEx() {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] * Math.log(objectArray[j])));
                }
                arrayMaths.type = 1;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].times(Complex.log(complexArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].times(Phasor.log(phasorArray[j])));
                }
                arrayMaths.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths xLog10x() {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(objectArray[j] * Math.log10(objectArray[j])));
                }
                arrayMaths.type = 1;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].times(Complex.log(complexArray[j].over(Math.log(10.0)))));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].times(Phasor.log(phasorArray[j].over(Math.log(10.0)))));
                }
                arrayMaths.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths minusxLog2x() {
        ArrayMaths arrayMaths = this.xLog2x();
        return arrayMaths.negate();
    }

    public ArrayMaths minusxLogEx() {
        ArrayMaths arrayMaths = this.xLogEx();
        return arrayMaths.negate();
    }

    public ArrayMaths minusxLog10x() {
        ArrayMaths arrayMaths = this.xLog10x();
        return arrayMaths.negate();
    }

    public ArrayMaths sqrt() {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(Math.sqrt(objectArray[j])));
                }
                arrayMaths.type = 1;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Complex.sqrt(complexArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Phasor.sqrt(phasorArray[j]));
                }
                arrayMaths.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths oneOverSqrt() {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(1.0 / Math.sqrt(objectArray[j])));
                }
                arrayMaths.type = 1;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Complex.sqrt(complexArray[j]).inverse());
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Phasor.sqrt(phasorArray[j]).inverse());
                }
                arrayMaths.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths abs() {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(Math.abs(objectArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 2: 
            case 3: {
                float[] fArray = this.getArray_as_float();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Float(Math.abs(fArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 4: 
            case 5: {
                long[] lArray = this.getArray_as_long();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Long(Math.abs(lArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 6: 
            case 7: {
                int[] nArray = this.getArray_as_int();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Integer(Math.abs(nArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 8: 
            case 9: {
                int[] nArray = this.getArray_as_int();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Short((short)Math.abs(nArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 10: 
            case 11: {
                int[] nArray = this.getArray_as_int();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Byte((byte)Math.abs(nArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigDecimalArray[j].abs());
                }
                arrayMaths.type = this.type;
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigIntegerArray[j].abs());
                }
                arrayMaths.type = this.type;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Complex.abs(complexArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].abs());
                }
                arrayMaths.type = 15;
                break;
            }
            case 16: 
            case 17: {
                int[] nArray = this.getArray_as_int();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Integer(Math.abs(nArray[j])));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 18: {
                double[] dArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(Math.abs(dArray[j])));
                }
                arrayMaths.type = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths exp() {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(Math.exp(objectArray[j])));
                }
                arrayMaths.type = 1;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Complex.exp(complexArray[j]));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Phasor.exp(phasorArray[j]));
                }
                arrayMaths.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths invert() {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(1.0 / objectArray[j]));
                }
                arrayMaths.type = 1;
                break;
            }
            case 12: 
            case 13: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(BigDecimal.ONE.divide(bigDecimalArray[j], 4));
                }
                arrayMaths.type = 12;
                bigDecimalArray = null;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Complex.plusOne().over(complexArray[j]));
                }
                arrayMaths.type = 14;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Phasor.plusOne().over(phasorArray[j]));
                }
                arrayMaths.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths pow(int n) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(Math.pow(objectArray[j], n)));
                }
                arrayMaths.type = 1;
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                BigDecimal bigDecimal = BigDecimal.ONE;
                for (int j = 0; j < this.length; ++j) {
                    for (int k = 0; k < n; ++k) {
                        bigDecimal = bigDecimal.multiply(bigDecimalArray[j]);
                    }
                    arrayMaths.array.add(bigDecimal);
                }
                bigDecimalArray = null;
                bigDecimal = null;
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigIntegerArray[j].pow(n));
                }
                arrayMaths.type = 13;
                bigIntegerArray = null;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Complex.pow(complexArray[j], n));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Phasor.pow(phasorArray[j], n));
                }
                arrayMaths.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths pow(double d) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(Math.pow(objectArray[j], d)));
                }
                arrayMaths.type = 1;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Complex.pow(complexArray[j], d));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Phasor.pow(phasorArray[j], d));
                }
                arrayMaths.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths pow(float f) {
        double d = f;
        return this.pow(d);
    }

    public ArrayMaths pow(long l) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(Math.pow(objectArray[j], l)));
                }
                arrayMaths.type = 1;
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                BigDecimal bigDecimal = BigDecimal.ONE;
                for (int j = 0; j < this.length; ++j) {
                    long l2 = 0L;
                    while (l2 < l) {
                        bigDecimal = bigDecimal.multiply(bigDecimalArray[j]);
                    }
                    arrayMaths.array.add(bigDecimal);
                }
                bigDecimalArray = null;
                bigDecimal = null;
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
                BigInteger bigInteger = BigInteger.ONE;
                for (int j = 0; j < this.length; ++j) {
                    long l3 = 0L;
                    while (l3 < l) {
                        bigInteger = bigInteger.multiply(bigIntegerArray[j]);
                    }
                    arrayMaths.array.add(bigInteger);
                }
                bigIntegerArray = null;
                bigInteger = null;
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Complex.pow(complexArray[j], l));
                }
                arrayMaths.type = this.type;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(Phasor.pow(phasorArray[j], l));
                }
                arrayMaths.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths pow(short s) {
        short s2 = s;
        return this.pow((int)s2);
    }

    public ArrayMaths pow(byte by) {
        byte by2 = by;
        return this.pow((int)by2);
    }

    public ArrayMaths pow(Number number) {
        boolean bl = integers.containsKey(number.getClass());
        if (bl) {
            if (number instanceof Long) {
                return this.pow(number.longValue());
            }
            if (number instanceof BigInteger) {
                return this.pow(number.doubleValue());
            }
            return this.pow(number.intValue());
        }
        return this.pow(number.doubleValue());
    }

    public ArrayMaths negate() {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        switch (this.type) {
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = this.getArray_as_double();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Double(-objectArray[j]));
                }
                arrayMaths.type = 1;
                break;
            }
            case 2: 
            case 3: {
                float[] fArray = this.getArray_as_float();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Float(-fArray[j]));
                }
                arrayMaths.type = 3;
                break;
            }
            case 4: 
            case 5: {
                long[] lArray = this.getArray_as_long();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Long(-lArray[j]));
                }
                arrayMaths.type = 5;
                break;
            }
            case 6: 
            case 7: {
                int[] nArray = this.getArray_as_int();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Integer(-nArray[j]));
                }
                arrayMaths.type = 7;
                break;
            }
            case 8: 
            case 9: {
                short[] sArray = this.getArray_as_short();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Short(-sArray[j]));
                }
                arrayMaths.type = 9;
                break;
            }
            case 10: 
            case 11: {
                byte[] byArray = this.getArray_as_byte();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(new Byte(-byArray[j]));
                }
                arrayMaths.type = 11;
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigDecimalArray[j].negate());
                }
                arrayMaths.type = 12;
                bigDecimalArray = null;
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(bigIntegerArray[j].negate());
                }
                arrayMaths.type = 13;
                bigIntegerArray = null;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(complexArray[j].negate());
                }
                arrayMaths.type = 14;
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(phasorArray[j].negate());
                }
                arrayMaths.type = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    protected void calcSum() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                double[] dArray = this.getArray_as_double();
                double d = 0.0;
                for (int j = 0; j < this.length; ++j) {
                    d += dArray[j];
                }
                this.summ.add(new Double(d));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                long[] lArray = this.getArray_as_long();
                long l = 0L;
                boolean bl = false;
                for (int j = 0; j < this.length; ++j) {
                    if (Long.MAX_VALUE - l < lArray[j]) {
                        bl = true;
                    }
                    l += lArray[j];
                }
                if (bl) {
                    double[] dArray = this.getArray_as_double();
                    double d = 0.0;
                    for (int j = 0; j < this.length; ++j) {
                        d += dArray[j];
                    }
                    this.summ.add(new Double(d));
                    this.sumlongToDouble = true;
                    break;
                }
                this.summ.add(new Long(l));
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                BigDecimal bigDecimal = new BigDecimal(0.0);
                for (int j = 0; j < this.length; ++j) {
                    bigDecimal.add(bigDecimalArray[j]);
                }
                this.summ.add(bigDecimal);
                bigDecimalArray = null;
                bigDecimal = null;
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
                BigInteger bigInteger = BigInteger.ZERO;
                for (int j = 0; j < this.length; ++j) {
                    bigInteger.add(bigIntegerArray[j]);
                }
                this.summ.add(bigInteger);
                bigIntegerArray = null;
                bigInteger = null;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                Complex complex = Complex.zero();
                for (int j = 0; j < this.length; ++j) {
                    complex.plus(complexArray[j]);
                }
                this.summ.add(complex);
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                Phasor phasor = Phasor.zero();
                for (int j = 0; j < this.length; ++j) {
                    phasor.plus(phasorArray[j]);
                }
                this.summ.add(phasor);
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        this.sumDone = true;
        Conv.restoreMessages();
    }

    public double sum() {
        return this.getSum_as_double();
    }

    public double sum_as_double() {
        return this.getSum_as_double();
    }

    public double getSum() {
        return this.getSum_as_double();
    }

    public double getSum_as_double() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        double d = 0.0;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                d = (Double)this.summ.get(0);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    d = (Double)this.summ.get(0);
                    break;
                }
                d = Conv.convert_Long_to_double((Long)this.summ.get(0));
                break;
            }
            case 12: {
                d = Conv.convert_BigDecimal_to_double((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                d = Conv.convert_BigInteger_to_double((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as double is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return d;
    }

    public Double sum_as_Double() {
        return this.getSum_as_Double();
    }

    public Double getSum_as_Double() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        Double d = new Double(0.0);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                d = (Double)this.summ.get(0);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    d = (Double)this.summ.get(0);
                    break;
                }
                d = Conv.convert_Long_to_Double((Long)this.summ.get(0));
                break;
            }
            case 12: {
                d = Conv.convert_BigDecimal_to_Double((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                d = Conv.convert_BigInteger_to_Double((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as Double is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return d;
    }

    public float sum_as_float() {
        return this.getSum_as_float();
    }

    public float getSum_as_float() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        float f = 0.0f;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                f = Conv.convert_Double_to_float((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    f = Conv.convert_Double_to_float((Double)this.summ.get(0));
                    break;
                }
                f = Conv.convert_Long_to_float((Long)this.summ.get(0));
                break;
            }
            case 12: {
                f = Conv.convert_BigDecimal_to_float((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                f = Conv.convert_BigInteger_to_float((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as float is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return f;
    }

    public Float sum_as_Float() {
        return this.getSum_as_Float();
    }

    public Float getSum_as_Float() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        Float f = new Float(0.0f);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                f = Conv.convert_Double_to_Float((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    f = Conv.convert_Double_to_Float((Double)this.summ.get(0));
                    break;
                }
                f = Conv.convert_Long_to_Float((Long)this.summ.get(0));
                break;
            }
            case 12: {
                f = Conv.convert_BigDecimal_to_Float((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                f = Conv.convert_BigInteger_to_Float((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as Float is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return f;
    }

    public long sum_as_long() {
        return this.getSum_as_long();
    }

    public long getSum_as_long() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        long l = 0L;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                l = Conv.convert_Double_to_long((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    l = Conv.convert_Double_to_long((Double)this.summ.get(0));
                    break;
                }
                l = (Long)this.summ.get(0);
                break;
            }
            case 12: {
                l = Conv.convert_BigDecimal_to_long((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                l = Conv.convert_BigInteger_to_long((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as long is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return l;
    }

    public Long sum_as_Long() {
        return this.getSum_as_Long();
    }

    public Long getSum_as_Long() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        Long l = new Long(0L);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                l = Conv.convert_Double_to_Long((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    l = Conv.convert_Double_to_Long((Double)this.summ.get(0));
                    break;
                }
                l = (Long)this.summ.get(0);
                break;
            }
            case 12: {
                l = Conv.convert_BigDecimal_to_Long((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                l = Conv.convert_BigInteger_to_Long((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as Long is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return l;
    }

    public int sum_as_int() {
        return this.getSum_as_int();
    }

    public int getSum_as_int() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        int n = 0;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                n = Conv.convert_Double_to_int((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    n = Conv.convert_Double_to_int((Double)this.summ.get(0));
                    break;
                }
                n = Conv.convert_Long_to_int((Long)this.summ.get(0));
                break;
            }
            case 12: {
                n = Conv.convert_BigDecimal_to_int((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                n = Conv.convert_BigInteger_to_int((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as int is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return n;
    }

    public Integer sum_as_Integer() {
        return this.getSum_as_Integer();
    }

    public Integer getSum_as_Integer() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        Integer n = new Integer(0);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                n = Conv.convert_Double_to_Integer((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    n = Conv.convert_Double_to_Integer((Double)this.summ.get(0));
                    break;
                }
                n = Conv.convert_Long_to_Integer((Long)this.summ.get(0));
                break;
            }
            case 12: {
                n = Conv.convert_BigDecimal_to_Integer((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                n = Conv.convert_BigInteger_to_Integer((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as Integer is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return n;
    }

    public short sum_as_short() {
        return this.getSum_as_short();
    }

    public short getSum_as_short() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        short s = 0;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                s = Conv.convert_Double_to_short((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    s = Conv.convert_Double_to_short((Double)this.summ.get(0));
                    break;
                }
                s = Conv.convert_Long_to_short((Long)this.summ.get(0));
                break;
            }
            case 12: {
                s = Conv.convert_BigDecimal_to_short((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                s = Conv.convert_BigInteger_to_short((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as short is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return s;
    }

    public Short sum_as_Short() {
        return this.getSum_as_Short();
    }

    public Short getSum_as_Short() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        Short s = new Short(0);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                s = Conv.convert_Double_to_Short((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    s = Conv.convert_Double_to_Short((Double)this.summ.get(0));
                    break;
                }
                s = Conv.convert_Long_to_Short((Long)this.summ.get(0));
                break;
            }
            case 12: {
                s = Conv.convert_BigDecimal_to_Short((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                s = Conv.convert_BigInteger_to_Short((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as Short is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return s;
    }

    public byte sum_as_byte() {
        return this.getSum_as_byte();
    }

    public byte getSum_as_byte() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        byte by = 0;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                by = Conv.convert_Double_to_byte((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    by = Conv.convert_Double_to_byte((Double)this.summ.get(0));
                    break;
                }
                by = Conv.convert_Long_to_byte((Long)this.summ.get(0));
                break;
            }
            case 12: {
                by = Conv.convert_BigDecimal_to_byte((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                by = Conv.convert_BigInteger_to_byte((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as byte is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return by;
    }

    public Byte sum_as_Byte() {
        return this.getSum_as_Byte();
    }

    public Byte getSum_as_Byte() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        Byte by = new Byte(0);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                by = Conv.convert_Double_to_Byte((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    by = Conv.convert_Double_to_Byte((Double)this.summ.get(0));
                    break;
                }
                by = Conv.convert_Long_to_Byte((Long)this.summ.get(0));
                break;
            }
            case 12: {
                by = Conv.convert_BigDecimal_to_Byte((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                by = Conv.convert_BigInteger_to_Byte((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as Byte is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return by;
    }

    public BigDecimal sum_as_BigDecimal() {
        return this.getSum_as_BigDecimal();
    }

    public BigDecimal getSum_as_BigDecimal() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        BigDecimal bigDecimal = new BigDecimal(0.0);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                bigDecimal = Conv.convert_Double_to_BigDecimal((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    bigDecimal = Conv.convert_Double_to_BigDecimal((Double)this.summ.get(0));
                    break;
                }
                bigDecimal = Conv.convert_Long_to_BigDecimal((Long)this.summ.get(0));
                break;
            }
            case 12: {
                bigDecimal = (BigDecimal)this.summ.get(0);
                break;
            }
            case 13: {
                bigDecimal = Conv.convert_BigInteger_to_BigDecimal((BigInteger)this.summ.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as BigDecimal is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return bigDecimal;
    }

    public BigInteger sum_as_BigInteger() {
        return this.getSum_as_BigInteger();
    }

    public BigInteger getSum_as_BigInteger() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        BigInteger bigInteger = BigInteger.ZERO;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                bigInteger = Conv.convert_Double_to_BigInteger((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    bigInteger = Conv.convert_Double_to_BigInteger((Double)this.summ.get(0));
                    break;
                }
                bigInteger = Conv.convert_Long_to_BigInteger((Long)this.summ.get(0));
                break;
            }
            case 12: {
                bigInteger = Conv.convert_BigDecimal_to_BigInteger((BigDecimal)this.summ.get(0));
                break;
            }
            case 13: {
                bigInteger = (BigInteger)this.summ.get(0);
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as BigInteger is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return bigInteger;
    }

    public Complex sum_as_Complex() {
        return this.getSum_as_Complex();
    }

    public Complex getSum_as_Complex() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        Complex complex = Complex.zero();
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                complex = new Complex((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    complex = new Complex((Double)this.summ.get(0));
                    break;
                }
                complex = new Complex(((Long)this.summ.get(0)).doubleValue());
                break;
            }
            case 12: {
                complex = new Complex(((BigDecimal)this.summ.get(0)).doubleValue());
                break;
            }
            case 13: {
                complex = new Complex(((BigInteger)this.summ.get(0)).doubleValue());
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as Complex is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return complex;
    }

    public Phasor sum_as_Phasor() {
        return this.getSum_as_Phasor();
    }

    public Phasor getSum_as_Phasor() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        Phasor phasor = Phasor.zero();
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                phasor = new Phasor((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    phasor = new Phasor((Double)this.summ.get(0));
                    break;
                }
                phasor = new Phasor(((Long)this.summ.get(0)).doubleValue());
                break;
            }
            case 12: {
                phasor = new Phasor(((BigDecimal)this.summ.get(0)).doubleValue());
                break;
            }
            case 13: {
                phasor = new Phasor(((BigInteger)this.summ.get(0)).doubleValue());
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as Phasor is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return phasor;
    }

    public String sum_as_String() {
        return this.getSum_as_String();
    }

    public String getSum_as_String() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.sumDone) {
            this.calcSum();
        }
        String string = " ";
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                string = Double.toString((Double)this.summ.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.sumlongToDouble) {
                    string = Double.toString((Double)this.summ.get(0));
                    break;
                }
                string = Double.toString(((Long)this.summ.get(0)).doubleValue());
                break;
            }
            case 12: {
                string = ((BigDecimal)this.summ.get(0)).toString();
                break;
            }
            case 13: {
                string = ((BigInteger)this.summ.get(0)).toString();
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a sum as String is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return string;
    }

    protected void calcProduct() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                double[] dArray = this.getArray_as_double();
                double d = 1.0;
                for (int j = 0; j < this.length; ++j) {
                    d *= dArray[j];
                }
                this.productt.add(new Double(d));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                long[] lArray = this.getArray_as_long();
                long l = 1L;
                boolean bl = false;
                for (int j = 0; j < this.length; ++j) {
                    if (Long.MAX_VALUE / l < lArray[j]) {
                        bl = true;
                    }
                    l += lArray[j];
                }
                if (bl) {
                    double[] dArray = this.getArray_as_double();
                    double d = 1.0;
                    for (int j = 0; j < this.length; ++j) {
                        d *= dArray[j];
                    }
                    this.productt.add(new Double(d));
                    this.sumlongToDouble = true;
                    break;
                }
                this.productt.add(new Long(l));
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                BigDecimal bigDecimal = new BigDecimal(1.0);
                for (int j = 0; j < this.length; ++j) {
                    bigDecimal.multiply(bigDecimalArray[j]);
                }
                this.productt.add(bigDecimal);
                bigDecimalArray = null;
                bigDecimal = null;
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
                BigInteger bigInteger = BigInteger.ONE;
                for (int j = 0; j < this.length; ++j) {
                    bigInteger.multiply(bigIntegerArray[j]);
                }
                this.productt.add(bigInteger);
                bigIntegerArray = null;
                bigInteger = null;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                Complex complex = Complex.plusOne();
                for (int j = 0; j < this.length; ++j) {
                    complex.times(complexArray[j]);
                }
                this.productt.add(complex);
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                Phasor phasor = Phasor.plusOne();
                for (int j = 0; j < this.length; ++j) {
                    phasor.times(phasorArray[j]);
                }
                this.productt.add(phasor);
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        this.productDone = true;
        Conv.restoreMessages();
    }

    public double product() {
        return this.getProduct_as_double();
    }

    public double product_as_double() {
        return this.getProduct_as_double();
    }

    public double getProduct() {
        return this.getProduct_as_double();
    }

    public double getProduct_as_double() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        double d = 0.0;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                d = (Double)this.productt.get(0);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    d = (Double)this.productt.get(0);
                    break;
                }
                d = Conv.convert_Long_to_double((Long)this.productt.get(0));
                break;
            }
            case 12: {
                d = Conv.convert_BigDecimal_to_double((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                d = Conv.convert_BigInteger_to_double((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas double is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return d;
    }

    public Double product_as_Double() {
        return this.getProduct_as_Double();
    }

    public Double getProduct_as_Double() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        Double d = new Double(0.0);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                d = (Double)this.productt.get(0);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    d = (Double)this.productt.get(0);
                    break;
                }
                d = Conv.convert_Long_to_Double((Long)this.productt.get(0));
                break;
            }
            case 12: {
                d = Conv.convert_BigDecimal_to_Double((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                d = Conv.convert_BigInteger_to_Double((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas Double is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return d;
    }

    public float product_as_float() {
        return this.getProduct_as_float();
    }

    public float getProduct_as_float() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        float f = 0.0f;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                f = Conv.convert_Double_to_float((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    f = Conv.convert_Double_to_float((Double)this.productt.get(0));
                    break;
                }
                f = Conv.convert_Long_to_float((Long)this.productt.get(0));
                break;
            }
            case 12: {
                f = Conv.convert_BigDecimal_to_float((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                f = Conv.convert_BigInteger_to_float((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas float is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return f;
    }

    public Float product_as_Float() {
        return this.getProduct_as_Float();
    }

    public Float getProduct_as_Float() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        Float f = new Float(0.0f);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                f = Conv.convert_Double_to_Float((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    f = Conv.convert_Double_to_Float((Double)this.productt.get(0));
                    break;
                }
                f = Conv.convert_Long_to_Float((Long)this.productt.get(0));
                break;
            }
            case 12: {
                f = Conv.convert_BigDecimal_to_Float((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                f = Conv.convert_BigInteger_to_Float((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas Float is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return f;
    }

    public long product_as_long() {
        return this.getProduct_as_long();
    }

    public long getProduct_as_long() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        long l = 0L;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                l = Conv.convert_Double_to_long((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    l = Conv.convert_Double_to_long((Double)this.productt.get(0));
                    break;
                }
                l = (Long)this.productt.get(0);
                break;
            }
            case 12: {
                l = Conv.convert_BigDecimal_to_long((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                l = Conv.convert_BigInteger_to_long((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas long is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return l;
    }

    public Long product_as_Long() {
        return this.getProduct_as_Long();
    }

    public Long getProduct_as_Long() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        Long l = new Long(0L);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                l = Conv.convert_Double_to_Long((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    l = Conv.convert_Double_to_Long((Double)this.productt.get(0));
                    break;
                }
                l = (Long)this.productt.get(0);
                break;
            }
            case 12: {
                l = Conv.convert_BigDecimal_to_Long((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                l = Conv.convert_BigInteger_to_Long((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas Long is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return l;
    }

    public int product_as_int() {
        return this.getProduct_as_int();
    }

    public int getProduct_as_int() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        int n = 0;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                n = Conv.convert_Double_to_int((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    n = Conv.convert_Double_to_int((Double)this.productt.get(0));
                    break;
                }
                n = Conv.convert_Long_to_int((Long)this.productt.get(0));
                break;
            }
            case 12: {
                n = Conv.convert_BigDecimal_to_int((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                n = Conv.convert_BigInteger_to_int((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas int is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return n;
    }

    public Integer product_as_Integer() {
        return this.getProduct_as_Integer();
    }

    public Integer getProduct_as_Integer() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        Integer n = new Integer(0);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                n = Conv.convert_Double_to_Integer((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    n = Conv.convert_Double_to_Integer((Double)this.productt.get(0));
                    break;
                }
                n = Conv.convert_Long_to_Integer((Long)this.productt.get(0));
                break;
            }
            case 12: {
                n = Conv.convert_BigDecimal_to_Integer((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                n = Conv.convert_BigInteger_to_Integer((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas Integer is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return n;
    }

    public short product_as_short() {
        return this.getProduct_as_short();
    }

    public short getProduct_as_short() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        short s = 0;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                s = Conv.convert_Double_to_short((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    s = Conv.convert_Double_to_short((Double)this.productt.get(0));
                    break;
                }
                s = Conv.convert_Long_to_short((Long)this.productt.get(0));
                break;
            }
            case 12: {
                s = Conv.convert_BigDecimal_to_short((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                s = Conv.convert_BigInteger_to_short((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas short is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return s;
    }

    public Short product_as_Short() {
        return this.getProduct_as_Short();
    }

    public Short getProduct_as_Short() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        Short s = new Short(0);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                s = Conv.convert_Double_to_Short((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    s = Conv.convert_Double_to_Short((Double)this.productt.get(0));
                    break;
                }
                s = Conv.convert_Long_to_Short((Long)this.productt.get(0));
                break;
            }
            case 12: {
                s = Conv.convert_BigDecimal_to_Short((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                s = Conv.convert_BigInteger_to_Short((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas Short is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return s;
    }

    public byte product_as_byte() {
        return this.getProduct_as_byte();
    }

    public byte getProduct_as_byte() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        byte by = 0;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                by = Conv.convert_Double_to_byte((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    by = Conv.convert_Double_to_byte((Double)this.productt.get(0));
                    break;
                }
                by = Conv.convert_Long_to_byte((Long)this.productt.get(0));
                break;
            }
            case 12: {
                by = Conv.convert_BigDecimal_to_byte((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                by = Conv.convert_BigInteger_to_byte((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas byte is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return by;
    }

    public Byte product_as_Byte() {
        return this.getProduct_as_Byte();
    }

    public Byte getProduct_as_Byte() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        Byte by = new Byte(0);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                by = Conv.convert_Double_to_Byte((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    by = Conv.convert_Double_to_Byte((Double)this.productt.get(0));
                    break;
                }
                by = Conv.convert_Long_to_Byte((Long)this.productt.get(0));
                break;
            }
            case 12: {
                by = Conv.convert_BigDecimal_to_Byte((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                by = Conv.convert_BigInteger_to_Byte((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas Byte is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return by;
    }

    public BigDecimal product_as_BigDecimal() {
        return this.getProduct_as_BigDecimal();
    }

    public BigDecimal getProduct_as_BigDecimal() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        BigDecimal bigDecimal = new BigDecimal(0.0);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                bigDecimal = Conv.convert_Double_to_BigDecimal((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    bigDecimal = Conv.convert_Double_to_BigDecimal((Double)this.productt.get(0));
                    break;
                }
                bigDecimal = Conv.convert_Long_to_BigDecimal((Long)this.productt.get(0));
                break;
            }
            case 12: {
                bigDecimal = (BigDecimal)this.productt.get(0);
                break;
            }
            case 13: {
                bigDecimal = Conv.convert_BigInteger_to_BigDecimal((BigInteger)this.productt.get(0));
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas BigDecimal is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return bigDecimal;
    }

    public BigInteger product_as_BigInteger() {
        return this.getProduct_as_BigInteger();
    }

    public BigInteger getProduct_as_BigInteger() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        BigInteger bigInteger = BigInteger.ZERO;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                bigInteger = Conv.convert_Double_to_BigInteger((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    bigInteger = Conv.convert_Double_to_BigInteger((Double)this.productt.get(0));
                    break;
                }
                bigInteger = Conv.convert_Long_to_BigInteger((Long)this.productt.get(0));
                break;
            }
            case 12: {
                bigInteger = Conv.convert_BigDecimal_to_BigInteger((BigDecimal)this.productt.get(0));
                break;
            }
            case 13: {
                bigInteger = (BigInteger)this.productt.get(0);
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas BigInteger is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return bigInteger;
    }

    public Complex product_as_Complex() {
        return this.getProduct_as_Complex();
    }

    public Complex getProduct_as_Complex() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        Complex complex = Complex.zero();
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                complex = new Complex((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    complex = new Complex((Double)this.productt.get(0));
                    break;
                }
                complex = new Complex(((Long)this.productt.get(0)).doubleValue());
                break;
            }
            case 12: {
                complex = new Complex(((BigDecimal)this.productt.get(0)).doubleValue());
                break;
            }
            case 13: {
                complex = new Complex(((BigInteger)this.productt.get(0)).doubleValue());
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas Complex is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return complex;
    }

    public Phasor product_as_Phasor() {
        return this.getProduct_as_Phasor();
    }

    public Phasor getProduct_as_Phasor() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        Phasor phasor = Phasor.zero();
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                phasor = new Phasor((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    phasor = new Phasor((Double)this.productt.get(0));
                    break;
                }
                phasor = new Phasor(((Long)this.productt.get(0)).doubleValue());
                break;
            }
            case 12: {
                phasor = new Phasor(((BigDecimal)this.productt.get(0)).doubleValue());
                break;
            }
            case 13: {
                phasor = new Phasor(((BigInteger)this.productt.get(0)).doubleValue());
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas Phasor is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return phasor;
    }

    public String product_as_String() {
        return this.getProduct_as_String();
    }

    public String getProduct_as_String() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        if (!this.productDone) {
            this.calcProduct();
        }
        String string = " ";
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 18: {
                string = Double.toString((Double)this.productt.get(0));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                if (this.productlongToDouble) {
                    string = Double.toString((Double)this.productt.get(0));
                    break;
                }
                string = Double.toString(((Long)this.productt.get(0)).doubleValue());
                break;
            }
            case 12: {
                string = ((BigDecimal)this.productt.get(0)).toString();
                break;
            }
            case 13: {
                string = ((BigInteger)this.productt.get(0)).toString();
                break;
            }
            case 14: 
            case 15: {
                throw new IllegalArgumentException("The " + this.typeName[this.type] + " is not a numerical type for which a productas String is meaningful/supported");
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return string;
    }

    public ArrayMaths randomize() {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        arrayMaths.type = this.type;
        PsRandom psRandom = new PsRandom();
        arrayMaths.sortedIndices = psRandom.uniqueIntegerArray(this.length - 1);
        switch (this.type) {
            case 0: 
            case 1: {
                int n;
                for (n = 0; n < this.length; ++n) {
                    arrayMaths.array.add((Double)this.array.get(arrayMaths.sortedIndices[n]));
                }
                break;
            }
            case 2: 
            case 3: {
                int n;
                for (n = 0; n < this.length; ++n) {
                    arrayMaths.array.add((Float)this.array.get(arrayMaths.sortedIndices[n]));
                }
                break;
            }
            case 4: 
            case 5: {
                int n;
                for (n = 0; n < this.length; ++n) {
                    arrayMaths.array.add((Long)this.array.get(arrayMaths.sortedIndices[n]));
                }
                break;
            }
            case 6: 
            case 7: {
                int n;
                for (n = 0; n < this.length; ++n) {
                    arrayMaths.array.add((Integer)this.array.get(arrayMaths.sortedIndices[n]));
                }
                break;
            }
            case 8: 
            case 9: {
                int n;
                for (n = 0; n < this.length; ++n) {
                    arrayMaths.array.add((Short)this.array.get(arrayMaths.sortedIndices[n]));
                }
                break;
            }
            case 10: 
            case 11: {
                int n;
                for (n = 0; n < this.length; ++n) {
                    arrayMaths.array.add((Byte)this.array.get(arrayMaths.sortedIndices[n]));
                }
                break;
            }
            case 12: {
                int n;
                for (n = 0; n < this.length; ++n) {
                    arrayMaths.array.add((BigDecimal)this.array.get(arrayMaths.sortedIndices[n]));
                }
                break;
            }
            case 13: {
                int n;
                for (n = 0; n < this.length; ++n) {
                    arrayMaths.array.add((BigInteger)this.array.get(arrayMaths.sortedIndices[n]));
                }
                break;
            }
            case 14: {
                int n;
                for (n = 0; n < this.length; ++n) {
                    arrayMaths.array.add((Complex)this.array.get(arrayMaths.sortedIndices[n]));
                }
                break;
            }
            case 15: {
                int n;
                for (n = 0; n < this.length; ++n) {
                    arrayMaths.array.add((Phasor)this.array.get(arrayMaths.sortedIndices[n]));
                }
                break;
            }
            case 16: 
            case 17: {
                int n;
                for (n = 0; n < this.length; ++n) {
                    arrayMaths.array.add((Character)this.array.get(arrayMaths.sortedIndices[n]));
                }
                break;
            }
            case 18: {
                int n;
                for (n = 0; n < this.length; ++n) {
                    arrayMaths.array.add((String)this.array.get(arrayMaths.sortedIndices[n]));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] nArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, nArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = nArray[0];
        arrayMaths.minIndex = nArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths randomise() {
        return this.randomize();
    }

    public void ascendingSortEquals() {
        this.sortEquals();
    }

    public void sortEquals() {
        ArrayMaths arrayMaths = this.sort();
        this.array = arrayMaths.array;
        this.sortedIndices = arrayMaths.sortedIndices;
        this.maxIndex = arrayMaths.maxIndex;
        this.minIndex = arrayMaths.minIndex;
    }

    public ArrayMaths ascendingSort() {
        return this.sort();
    }

    public ArrayMaths sort() {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        arrayMaths.type = this.type;
        arrayMaths.sortedIndices = new int[this.length];
        switch (this.type) {
            case 0: 
            case 1: {
                objectArray = this.getArray_as_double();
                arrayMaths.sortedIndices = this.sortWithIndices((double[])objectArray);
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((Double)this.array.get(arrayMaths.sortedIndices[j]));
                }
                break;
            }
            case 2: 
            case 3: {
                double[] dArray = this.getArray_as_double();
                arrayMaths.sortedIndices = this.sortWithIndices(dArray);
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((Float)this.array.get(arrayMaths.sortedIndices[j]));
                }
                break;
            }
            case 4: 
            case 5: {
                long[] lArray = this.getArray_as_long();
                arrayMaths.sortedIndices = this.sortWithIndices(lArray);
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((Long)this.array.get(arrayMaths.sortedIndices[j]));
                }
                break;
            }
            case 6: 
            case 7: {
                long[] lArray = this.getArray_as_long();
                arrayMaths.sortedIndices = this.sortWithIndices(lArray);
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((Integer)this.array.get(arrayMaths.sortedIndices[j]));
                }
                break;
            }
            case 8: 
            case 9: {
                long[] lArray = this.getArray_as_long();
                arrayMaths.sortedIndices = this.sortWithIndices(lArray);
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((Short)this.array.get(arrayMaths.sortedIndices[j]));
                }
                break;
            }
            case 10: 
            case 11: {
                long[] lArray = this.getArray_as_long();
                arrayMaths.sortedIndices = this.sortWithIndices(lArray);
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((Byte)this.array.get(arrayMaths.sortedIndices[j]));
                }
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                arrayMaths.sortedIndices = this.sortWithIndices(bigDecimalArray);
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((BigDecimal)this.array.get(arrayMaths.sortedIndices[j]));
                }
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
                arrayMaths.sortedIndices = this.sortWithIndices(bigIntegerArray);
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((BigInteger)this.array.get(arrayMaths.sortedIndices[j]));
                }
                break;
            }
            case 14: {
                ArrayMaths arrayMaths2 = this.abs();
                double[] dArray = arrayMaths2.getArray_as_double();
                arrayMaths.sortedIndices = this.sortWithIndices(dArray);
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((Complex)this.array.get(arrayMaths.sortedIndices[j]));
                }
                break;
            }
            case 15: {
                ArrayMaths arrayMaths3 = this.abs();
                double[] dArray = arrayMaths3.getArray_as_double();
                arrayMaths.sortedIndices = this.sortWithIndices(dArray);
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((Phasor)this.array.get(arrayMaths.sortedIndices[j]));
                }
                break;
            }
            case 16: 
            case 17: {
                long[] lArray = this.getArray_as_long();
                arrayMaths.sortedIndices = this.sortWithIndices(lArray);
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add((Character)this.array.get(arrayMaths.sortedIndices[j]));
                }
                break;
            }
            case 18: {
                String[] stringArray = this.getArray_as_String();
                String[] stringArray2 = Conv.copy(stringArray);
                for (int j = 0; j < this.length; ++j) {
                    stringArray[j] = Strings.removeAccents(stringArray[j]);
                }
                ArrayList<Object> arrayList = this.alphabeticSort(stringArray);
                String[] stringArray3 = (String[])arrayList.get(0);
                arrayMaths.sortedIndices = (int[])arrayList.get(1);
                for (int j = 0; j < this.length; ++j) {
                    arrayMaths.array.add(stringArray2[arrayMaths.sortedIndices[j]]);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        if (this.type != 18) {
            objectArray = new int[2];
            ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
            arrayMaths.maxIndex = (int)objectArray[0];
            arrayMaths.minIndex = (int)objectArray[1];
        }
        Conv.restoreMessages();
        return arrayMaths;
    }

    public void descendingSortEquals() {
        ArrayMaths arrayMaths = this.descendingSort();
        this.array = arrayMaths.array;
        this.sortedIndices = arrayMaths.sortedIndices;
        this.maxIndex = arrayMaths.maxIndex;
        this.minIndex = arrayMaths.minIndex;
    }

    public ArrayMaths descendingSort() {
        int n;
        Object object;
        ArrayMaths arrayMaths = null;
        boolean bl = false;
        if (this.array.get(0) instanceof Double) {
            object = new double[this.array.size()];
            for (n = 0; n < this.array.size(); ++n) {
                object[n] = (Double)this.array.get(n);
            }
            arrayMaths = new ArrayMaths((double[])object);
            bl = true;
        }
        if (this.array.get(0) instanceof Float) {
            object = new float[this.array.size()];
            for (n = 0; n < this.array.size(); ++n) {
                object[n] = ((Float)this.array.get(n)).floatValue();
            }
            arrayMaths = new ArrayMaths((float[])object);
            bl = true;
        }
        if (this.array.get(0) instanceof Long) {
            object = new long[this.array.size()];
            for (n = 0; n < this.array.size(); ++n) {
                object[n] = ((Long)this.array.get(n)).longValue();
            }
            arrayMaths = new ArrayMaths((long[])object);
            bl = true;
        }
        if (this.array.get(0) instanceof Integer) {
            object = new int[this.array.size()];
            for (n = 0; n < this.array.size(); ++n) {
                object[n] = ((Integer)this.array.get(n)).intValue();
            }
            arrayMaths = new ArrayMaths((int[])object);
            bl = true;
        }
        if (this.array.get(0) instanceof Character) {
            object = new char[this.array.size()];
            for (n = 0; n < this.array.size(); ++n) {
                object[n] = ((Character)this.array.get(n)).charValue();
            }
            arrayMaths = new ArrayMaths((char[])object);
            bl = true;
        }
        if (this.array.get(0) instanceof String) {
            object = new String[this.array.size()];
            for (n = 0; n < this.array.size(); ++n) {
                object[n] = (double)((String)this.array.get(n));
            }
            arrayMaths = new ArrayMaths((String[])object);
            bl = true;
        }
        if (this.array.get(0) instanceof Short) {
            object = new short[this.array.size()];
            for (n = 0; n < this.array.size(); ++n) {
                object[n] = ((Short)this.array.get(n)).shortValue();
            }
            arrayMaths = new ArrayMaths((short[])object);
            bl = true;
        }
        if (this.array.get(0) instanceof BigDecimal) {
            object = new BigDecimal[this.array.size()];
            for (n = 0; n < this.array.size(); ++n) {
                object[n] = (double)((BigDecimal)this.array.get(n));
            }
            arrayMaths = new ArrayMaths((BigDecimal[])object);
            bl = true;
        }
        if (this.array.get(0) instanceof BigInteger) {
            object = new BigInteger[this.array.size()];
            for (n = 0; n < this.array.size(); ++n) {
                object[n] = (double)((BigInteger)this.array.get(n));
            }
            arrayMaths = new ArrayMaths((BigInteger[])object);
            bl = true;
        }
        if (this.array.get(0) instanceof Complex) {
            object = new Complex[this.array.size()];
            for (n = 0; n < this.array.size(); ++n) {
                object[n] = (Complex)this.array.get(n);
            }
            arrayMaths = new ArrayMaths((Complex[])object);
            bl = true;
        }
        if (this.array.get(0) instanceof Phasor) {
            object = new Phasor[this.array.size()];
            for (n = 0; n < this.array.size(); ++n) {
                object[n] = (Phasor)this.array.get(n);
            }
            arrayMaths = new ArrayMaths((Phasor[])object);
            bl = true;
        }
        if (!bl) {
            arrayMaths = new ArrayMaths(this.array);
        }
        object = arrayMaths.sort();
        int[] nArray = ((ArrayMaths)object).originalIndices();
        int[] nArray2 = DeepCopy.copy(nArray);
        int n2 = nArray.length;
        for (int j = 0; j < n2; ++j) {
            nArray[j] = nArray2[n2 - j - 1];
        }
        ArrayMaths arrayMaths2 = ((ArrayMaths)object).reverse();
        arrayMaths2.resetSortedIndices(nArray);
        return arrayMaths2;
    }

    public ArrayList<Object> alphabeticSort(String[] stringArray) {
        return this.alphabeticAtoZsort(stringArray);
    }

    public ArrayList<Object> alphabeticAtoZsort(String[] stringArray) {
        int n;
        this.nWords = stringArray.length;
        this.words = new String[this.nWords];
        this.sortedWords = new String[this.nWords];
        for (n = 0; n < this.nWords; ++n) {
            this.words[n] = stringArray[n];
            this.sortedWords[n] = this.words[n];
        }
        this.alphabeticSortIndices(this.words);
        for (n = 0; n < this.nWords; ++n) {
            this.sortedWords[n] = this.words[this.wordOrder[n]];
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.sortedWords);
        arrayList.add(this.wordOrder);
        return arrayList;
    }

    public ArrayList<Object> alphabeticZtoASort(String[] stringArray) {
        int n;
        this.nWords = stringArray.length;
        this.words = new String[this.nWords];
        this.sortedWords = new String[this.nWords];
        int[] nArray = new int[this.nWords];
        for (n = 0; n < this.nWords; ++n) {
            this.words[n] = stringArray[n];
            this.sortedWords[n] = this.words[n];
        }
        this.alphabeticSortIndices(this.words);
        for (n = 0; n < this.nWords; ++n) {
            this.sortedWords[this.nWords - n - 1] = this.words[this.wordOrder[n]];
            nArray[n] = this.wordOrder[this.nWords - n - 1];
        }
        this.wordOrder = (int[])nArray.clone();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.sortedWords);
        arrayList.add(this.wordOrder);
        return arrayList;
    }

    public void alphabeticSortIndices(String[] stringArray) {
        int n;
        String[] stringArray2 = new String[this.nWords];
        this.nLength = 0;
        int n2 = 0;
        for (n = 0; n < this.nWords; ++n) {
            n2 = stringArray[n].length();
            if (n2 > this.nLength) {
                this.nLength = n2;
            }
            stringArray2[n] = stringArray[n].toLowerCase();
        }
        this.wordChar = new char[this.nWords][this.nLength];
        this.holdWordChar = new char[this.nWords][this.nLength];
        for (n = 0; n < this.nWords; ++n) {
            int n3;
            char[] cArray = stringArray2[n].toCharArray();
            for (n3 = 0; n3 < stringArray2[n].length(); ++n3) {
                this.wordChar[n][n3] = cArray[n3];
                this.holdWordChar[n][n3] = cArray[n3];
            }
            for (n3 = stringArray2[n].length(); n3 < this.nLength; ++n3) {
                this.wordChar[n][n3] = 32;
                this.holdWordChar[n][n3] = 32;
            }
        }
        this.wordOrder = new int[this.nWords];
        this.holdWordOrder = new int[this.nWords];
        for (n = 0; n < this.nWords; ++n) {
            this.wordOrder[n] = n;
            this.holdWordOrder[n] = n;
        }
        if (this.nWords > 1) {
            this.indexSort(0, 0, this.nWords - 1);
        }
    }

    public void indexSort(int n, int n2, int n3) {
        int n4;
        int n5 = n3 - n2 + 1;
        char[] cArray = new char[n5];
        int[] nArray = new int[n5];
        for (int j = 0; j < n5; ++j) {
            cArray[j] = this.wordChar[j + n2][n];
            nArray[j] = this.wordOrder[j + n2];
        }
        int[] nArray2 = this.sortByColumnInitial(cArray);
        int[] nArray3 = new int[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            nArray3[n4] = nArray[nArray2[n4]];
        }
        for (n4 = 0; n4 < n5; ++n4) {
            this.holdWordOrder[n4 + n2] = nArray3[n4];
            this.holdWordChar[n4 + n2] = this.wordChar[nArray2[n4] + n2];
        }
        for (n4 = 0; n4 < this.nWords; ++n4) {
            this.wordChar[n4] = this.holdWordChar[n4];
            this.wordOrder[n4] = this.holdWordOrder[n4];
        }
        ArrayList<Integer> arrayList = null;
        if (n < this.nLength - 1) {
            int n6;
            int n7;
            int[] nArray4 = new int[n5 + 1];
            nArray4[0] = n7 = 1;
            int n8 = 1;
            for (n6 = n2 + 1; n6 <= n3; ++n6) {
                nArray4[n8] = this.wordChar[n6][n] == this.wordChar[n6 - 1][n] ? n7 : (n7 = -n7);
                ++n8;
            }
            arrayList = new ArrayList<Integer>();
            n8 = n2;
            arrayList.add(new Integer(n8));
            for (n6 = 1; n6 <= n5; ++n6) {
                ++n8;
                if (nArray4[n6] == nArray4[n6 - 1]) continue;
                arrayList.add(new Integer(n8 - 1));
                arrayList.add(new Integer(n8));
            }
            arrayList.add(new Integer(n3));
            n6 = arrayList.size();
            for (int j = 0; j < n6; j += 2) {
                int n9 = (Integer)arrayList.get(j);
                int n10 = (Integer)arrayList.get(j + 1);
                if (n10 - n9 + 1 <= 1) continue;
                this.indexSort(n + 1, n9, n10);
            }
        }
    }

    public int[] sortByColumnInitial(char[] cArray) {
        int n = cArray.length;
        int[] nArray = new int[n];
        for (int j = 0; j < n; ++j) {
            nArray[j] = cArray[j];
        }
        ArrayMaths arrayMaths = new ArrayMaths(nArray);
        ArrayMaths arrayMaths2 = arrayMaths.sort();
        int[] nArray2 = arrayMaths2.array_as_int();
        int[] nArray3 = arrayMaths2.originalIndices();
        return nArray3;
    }

    public void sortEquals(int[] nArray) {
        ArrayMaths arrayMaths = this.sort(nArray);
        this.array = arrayMaths.array;
        this.sortedIndices = arrayMaths.sortedIndices;
        this.maxIndex = arrayMaths.maxIndex;
        this.minIndex = arrayMaths.minIndex;
    }

    public ArrayMaths sort(int[] nArray) {
        int n = nArray.length;
        if (this.length != n) {
            throw new IllegalArgumentException("The argument array [length = " + n + "], must be of the same length as this instance array [length = " + this.length + "]");
        }
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = this.length;
        arrayMaths.type = this.type;
        arrayMaths.sortedIndices = nArray;
        switch (this.type) {
            case 0: 
            case 1: {
                int n2;
                for (n2 = 0; n2 < this.length; ++n2) {
                    arrayMaths.array.add((Double)this.array.get(arrayMaths.sortedIndices[n2]));
                }
                break;
            }
            case 2: 
            case 3: {
                int n2;
                for (n2 = 0; n2 < this.length; ++n2) {
                    arrayMaths.array.add((Float)this.array.get(arrayMaths.sortedIndices[n2]));
                }
                break;
            }
            case 4: 
            case 5: {
                int n2;
                for (n2 = 0; n2 < this.length; ++n2) {
                    arrayMaths.array.add((Long)this.array.get(arrayMaths.sortedIndices[n2]));
                }
                break;
            }
            case 6: 
            case 7: {
                int n2;
                for (n2 = 0; n2 < this.length; ++n2) {
                    arrayMaths.array.add((Integer)this.array.get(arrayMaths.sortedIndices[n2]));
                }
                break;
            }
            case 8: 
            case 9: {
                int n2;
                for (n2 = 0; n2 < this.length; ++n2) {
                    arrayMaths.array.add((Short)this.array.get(arrayMaths.sortedIndices[n2]));
                }
                break;
            }
            case 10: 
            case 11: {
                int n2;
                for (n2 = 0; n2 < this.length; ++n2) {
                    arrayMaths.array.add((Byte)this.array.get(arrayMaths.sortedIndices[n2]));
                }
                break;
            }
            case 12: {
                int n2;
                for (n2 = 0; n2 < this.length; ++n2) {
                    arrayMaths.array.add((BigDecimal)this.array.get(arrayMaths.sortedIndices[n2]));
                }
                break;
            }
            case 13: {
                int n2;
                for (n2 = 0; n2 < this.length; ++n2) {
                    arrayMaths.array.add((BigInteger)this.array.get(arrayMaths.sortedIndices[n2]));
                }
                break;
            }
            case 14: {
                int n2;
                for (n2 = 0; n2 < this.length; ++n2) {
                    arrayMaths.array.add((Complex)this.array.get(arrayMaths.sortedIndices[n2]));
                }
                break;
            }
            case 15: {
                int n2;
                for (n2 = 0; n2 < this.length; ++n2) {
                    arrayMaths.array.add((Phasor)this.array.get(arrayMaths.sortedIndices[n2]));
                }
                break;
            }
            case 16: 
            case 17: {
                int n2;
                for (n2 = 0; n2 < this.length; ++n2) {
                    arrayMaths.array.add((Character)this.array.get(arrayMaths.sortedIndices[n2]));
                }
                break;
            }
            case 18: {
                int n2;
                for (n2 = 0; n2 < this.length; ++n2) {
                    arrayMaths.array.add((String)this.array.get(arrayMaths.sortedIndices[n2]));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        int[] nArray2 = new int[2];
        if (this.type != 18) {
            ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, nArray2, arrayMaths.typeName, arrayMaths.type);
        }
        arrayMaths.maxIndex = nArray2[0];
        arrayMaths.minIndex = nArray2[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    protected int[] sortWithIndices(double[] dArray) {
        int n;
        int n2 = 0;
        int n3 = -1;
        double d = 0.0;
        int n4 = 0;
        double[] dArray2 = new double[this.length];
        int[] nArray = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            dArray2[n] = dArray[n];
            nArray[n] = n;
        }
        while (n3 != this.length - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < this.length; ++n) {
                if (!(dArray2[n] < dArray2[n2])) continue;
                n2 = n;
            }
            d = dArray2[n2];
            dArray2[n2] = dArray2[++n3];
            dArray2[n3] = d;
            n4 = nArray[n2];
            nArray[n2] = nArray[n3];
            nArray[n3] = n4;
        }
        return nArray;
    }

    protected int[] sortWithIndices(long[] lArray) {
        int n;
        int n2 = 0;
        int n3 = -1;
        long l = 0L;
        int n4 = 0;
        long[] lArray2 = new long[this.length];
        int[] nArray = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            lArray2[n] = lArray[n];
            nArray[n] = n;
        }
        while (n3 != this.length - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < this.length; ++n) {
                if (lArray2[n] >= lArray2[n2]) continue;
                n2 = n;
            }
            l = lArray2[n2];
            lArray2[n2] = lArray2[++n3];
            lArray2[n3] = l;
            n4 = nArray[n2];
            nArray[n2] = nArray[n3];
            nArray[n3] = n4;
        }
        return nArray;
    }

    protected int[] sortWithIndices(BigDecimal[] bigDecimalArray) {
        int n;
        int n2 = 0;
        int n3 = -1;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        int n4 = 0;
        BigDecimal[] bigDecimalArray2 = new BigDecimal[this.length];
        int[] nArray = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            bigDecimalArray2[n] = bigDecimalArray[n];
            nArray[n] = n;
        }
        while (n3 != this.length - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < this.length; ++n) {
                if (bigDecimalArray2[n].compareTo(bigDecimalArray2[n2]) != -1) continue;
                n2 = n;
            }
            bigDecimal = bigDecimalArray2[n2];
            bigDecimalArray2[n2] = bigDecimalArray2[++n3];
            bigDecimalArray2[n3] = bigDecimal;
            n4 = nArray[n2];
            nArray[n2] = nArray[n3];
            nArray[n3] = n4;
        }
        bigDecimal = null;
        return nArray;
    }

    protected int[] sortWithIndices(BigInteger[] bigIntegerArray) {
        int n;
        int n2 = 0;
        int n3 = -1;
        BigInteger bigInteger = BigInteger.ZERO;
        int n4 = 0;
        BigInteger[] bigIntegerArray2 = new BigInteger[this.length];
        int[] nArray = new int[this.length];
        for (n = 0; n < this.length; ++n) {
            bigIntegerArray2[n] = bigIntegerArray[n];
            nArray[n] = n;
        }
        while (n3 != this.length - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < this.length; ++n) {
                if (bigIntegerArray2[n].compareTo(bigIntegerArray2[n2]) != -1) continue;
                n2 = n;
            }
            bigInteger = bigIntegerArray2[n2];
            bigIntegerArray2[n2] = bigIntegerArray2[++n3];
            bigIntegerArray2[n3] = bigInteger;
            n4 = nArray[n2];
            nArray[n2] = nArray[n3];
            nArray[n3] = n4;
        }
        bigInteger = null;
        return nArray;
    }

    public int[] originalIndices() {
        if (this.sortedIndices == null) {
            System.out.println("method: originalIndices: array has not been sorted: null returned");
        }
        return this.sortedIndices;
    }

    public ArrayMaths concatenate(double[] dArray) {
        Object[] objectArray;
        int n = dArray.length;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = dArray.length + this.length;
        ArrayMaths arrayMaths2 = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                int n2;
                objectArray = this.getArray_as_double();
                double[] dArray2 = new double[arrayMaths.length];
                for (n2 = 0; n2 < this.length; ++n2) {
                    dArray2[n2] = objectArray[n2];
                }
                for (n2 = 0; n2 < n; ++n2) {
                    dArray2[n2 + this.length] = dArray[n2];
                }
                for (n2 = 0; n2 < arrayMaths.length; ++n2) {
                    arrayMaths.array.add(new Double(dArray2[n2]));
                }
                arrayMaths.type = 1;
                break;
            }
            case 12: 
            case 13: {
                int n3;
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                arrayMaths2 = new ArrayMaths(dArray);
                BigDecimal[] bigDecimalArray2 = arrayMaths2.getArray_as_BigDecimal();
                BigDecimal[] bigDecimalArray3 = new BigDecimal[arrayMaths.length];
                for (n3 = 0; n3 < this.length; ++n3) {
                    bigDecimalArray3[n3] = bigDecimalArray[n3];
                }
                for (n3 = 0; n3 < n; ++n3) {
                    bigDecimalArray3[n3 + this.length] = bigDecimalArray2[n3];
                }
                for (n3 = 0; n3 < arrayMaths.length; ++n3) {
                    arrayMaths.array.add(bigDecimalArray3[n3]);
                }
                bigDecimalArray = null;
                bigDecimalArray2 = null;
                bigDecimalArray3 = null;
                arrayMaths.type = 12;
                break;
            }
            case 14: {
                int n4;
                Complex[] complexArray = this.getArray_as_Complex();
                arrayMaths2 = new ArrayMaths(dArray);
                Complex[] complexArray2 = arrayMaths2.getArray_as_Complex();
                Complex[] complexArray3 = new Complex[arrayMaths.length];
                for (n4 = 0; n4 < this.length; ++n4) {
                    complexArray3[n4] = complexArray[n4];
                }
                for (n4 = 0; n4 < n; ++n4) {
                    complexArray3[n4 + this.length] = complexArray2[n4];
                }
                for (n4 = 0; n4 < arrayMaths.length; ++n4) {
                    arrayMaths.array.add(complexArray3[n4]);
                }
                arrayMaths.type = 14;
                break;
            }
            case 15: {
                int n5;
                Phasor[] phasorArray = this.getArray_as_Phasor();
                arrayMaths2 = new ArrayMaths(dArray);
                Phasor[] phasorArray2 = arrayMaths2.getArray_as_Phasor();
                Phasor[] phasorArray3 = new Phasor[arrayMaths.length];
                for (n5 = 0; n5 < this.length; ++n5) {
                    phasorArray3[n5] = phasorArray[n5];
                }
                for (n5 = 0; n5 < n; ++n5) {
                    phasorArray3[n5 + this.length] = phasorArray2[n5];
                }
                for (n5 = 0; n5 < arrayMaths.length; ++n5) {
                    arrayMaths.array.add(phasorArray3[n5]);
                }
                arrayMaths.type = 15;
                break;
            }
            case 18: {
                int n6;
                String[] stringArray = this.getArray_as_String();
                arrayMaths2 = new ArrayMaths(dArray);
                String[] stringArray2 = arrayMaths2.getArray_as_String();
                String[] stringArray3 = new String[arrayMaths.length];
                for (n6 = 0; n6 < this.length; ++n6) {
                    stringArray3[n6] = stringArray[n6];
                }
                for (n6 = 0; n6 < n; ++n6) {
                    stringArray3[n6 + this.length] = stringArray2[n6];
                }
                for (n6 = 0; n6 < arrayMaths.length; ++n6) {
                    arrayMaths.array.add(stringArray3[n6]);
                }
                arrayMaths.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths concatenate(Double[] doubleArray) {
        double[] dArray = new double[doubleArray.length];
        for (int j = 0; j < doubleArray.length; ++j) {
            dArray[j] = doubleArray[j];
        }
        return this.concatenate(dArray);
    }

    public ArrayMaths concatenate(float[] fArray) {
        Object[] objectArray;
        int n = fArray.length;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = fArray.length + this.length;
        ArrayMaths arrayMaths2 = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int n2;
                objectArray = this.getArray_as_double();
                double[] dArray = new double[arrayMaths.length];
                for (n2 = 0; n2 < this.length; ++n2) {
                    dArray[n2] = objectArray[n2];
                }
                for (n2 = 0; n2 < n; ++n2) {
                    dArray[n2 + this.length] = fArray[n2];
                }
                for (n2 = 0; n2 < arrayMaths.length; ++n2) {
                    arrayMaths.array.add(new Double(dArray[n2]));
                }
                arrayMaths.type = 1;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                int n3;
                float[] fArray2 = this.getArray_as_float();
                float[] fArray3 = new float[arrayMaths.length];
                for (n3 = 0; n3 < this.length; ++n3) {
                    fArray3[n3] = fArray2[n3];
                }
                for (n3 = 0; n3 < n; ++n3) {
                    fArray3[n3 + this.length] = fArray[n3];
                }
                for (n3 = 0; n3 < arrayMaths.length; ++n3) {
                    arrayMaths.array.add(new Float(fArray3[n3]));
                }
                arrayMaths.type = 3;
                break;
            }
            case 12: 
            case 13: {
                int n4;
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                arrayMaths2 = new ArrayMaths(fArray);
                BigDecimal[] bigDecimalArray2 = arrayMaths2.getArray_as_BigDecimal();
                BigDecimal[] bigDecimalArray3 = new BigDecimal[arrayMaths.length];
                for (n4 = 0; n4 < this.length; ++n4) {
                    bigDecimalArray3[n4] = bigDecimalArray[n4];
                }
                for (n4 = 0; n4 < n; ++n4) {
                    bigDecimalArray3[n4 + this.length] = bigDecimalArray2[n4];
                }
                for (n4 = 0; n4 < arrayMaths.length; ++n4) {
                    arrayMaths.array.add(bigDecimalArray3[n4]);
                }
                bigDecimalArray = null;
                bigDecimalArray2 = null;
                bigDecimalArray3 = null;
                arrayMaths.type = 12;
                break;
            }
            case 14: {
                int n5;
                Complex[] complexArray = this.getArray_as_Complex();
                arrayMaths2 = new ArrayMaths(fArray);
                Complex[] complexArray2 = arrayMaths2.getArray_as_Complex();
                Complex[] complexArray3 = new Complex[arrayMaths.length];
                for (n5 = 0; n5 < this.length; ++n5) {
                    complexArray3[n5] = complexArray[n5];
                }
                for (n5 = 0; n5 < n; ++n5) {
                    complexArray3[n5 + this.length] = complexArray2[n5];
                }
                for (n5 = 0; n5 < arrayMaths.length; ++n5) {
                    arrayMaths.array.add(complexArray3[n5]);
                }
                arrayMaths.type = 14;
                break;
            }
            case 15: {
                int n6;
                Phasor[] phasorArray = this.getArray_as_Phasor();
                arrayMaths2 = new ArrayMaths(fArray);
                Phasor[] phasorArray2 = arrayMaths2.getArray_as_Phasor();
                Phasor[] phasorArray3 = new Phasor[arrayMaths.length];
                for (n6 = 0; n6 < this.length; ++n6) {
                    phasorArray3[n6] = phasorArray[n6];
                }
                for (n6 = 0; n6 < n; ++n6) {
                    phasorArray3[n6 + this.length] = phasorArray2[n6];
                }
                for (n6 = 0; n6 < arrayMaths.length; ++n6) {
                    arrayMaths.array.add(phasorArray3[n6]);
                }
                arrayMaths.type = 15;
                break;
            }
            case 18: {
                int n7;
                String[] stringArray = this.getArray_as_String();
                arrayMaths2 = new ArrayMaths(fArray);
                String[] stringArray2 = arrayMaths2.getArray_as_String();
                String[] stringArray3 = new String[arrayMaths.length];
                for (n7 = 0; n7 < this.length; ++n7) {
                    stringArray3[n7] = stringArray[n7];
                }
                for (n7 = 0; n7 < n; ++n7) {
                    stringArray3[n7 + this.length] = stringArray2[n7];
                }
                for (n7 = 0; n7 < arrayMaths.length; ++n7) {
                    arrayMaths.array.add(stringArray3[n7]);
                }
                arrayMaths.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths concatenate(Float[] floatArray) {
        float[] fArray = new float[floatArray.length];
        for (int j = 0; j < floatArray.length; ++j) {
            fArray[j] = floatArray[j].floatValue();
        }
        return this.concatenate(fArray);
    }

    public ArrayMaths concatenate(long[] lArray) {
        Object[] objectArray;
        int n = lArray.length;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = lArray.length + this.length;
        ArrayMaths arrayMaths2 = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int n2;
                objectArray = this.getArray_as_double();
                double[] dArray = new double[arrayMaths.length];
                for (n2 = 0; n2 < this.length; ++n2) {
                    dArray[n2] = objectArray[n2];
                }
                for (n2 = 0; n2 < n; ++n2) {
                    dArray[n2 + this.length] = lArray[n2];
                }
                for (n2 = 0; n2 < arrayMaths.length; ++n2) {
                    arrayMaths.array.add(new Double(dArray[n2]));
                }
                arrayMaths.type = 1;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                int n3;
                long[] lArray2 = this.getArray_as_long();
                long[] lArray3 = new long[arrayMaths.length];
                for (n3 = 0; n3 < this.length; ++n3) {
                    lArray3[n3] = lArray2[n3];
                }
                for (n3 = 0; n3 < n; ++n3) {
                    lArray3[n3 + this.length] = lArray[n3];
                }
                for (n3 = 0; n3 < arrayMaths.length; ++n3) {
                    arrayMaths.array.add(new Long(lArray3[n3]));
                }
                arrayMaths.type = 3;
                break;
            }
            case 12: {
                int n4;
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                arrayMaths2 = new ArrayMaths(lArray);
                BigDecimal[] bigDecimalArray2 = arrayMaths2.getArray_as_BigDecimal();
                BigDecimal[] bigDecimalArray3 = new BigDecimal[arrayMaths.length];
                for (n4 = 0; n4 < this.length; ++n4) {
                    bigDecimalArray3[n4] = bigDecimalArray[n4];
                }
                for (n4 = 0; n4 < n; ++n4) {
                    bigDecimalArray3[n4 + this.length] = bigDecimalArray2[n4];
                }
                for (n4 = 0; n4 < arrayMaths.length; ++n4) {
                    arrayMaths.array.add(bigDecimalArray3[n4]);
                }
                bigDecimalArray = null;
                bigDecimalArray2 = null;
                bigDecimalArray3 = null;
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                int n5;
                BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
                arrayMaths2 = new ArrayMaths(lArray);
                BigInteger[] bigIntegerArray2 = arrayMaths2.getArray_as_BigInteger();
                BigInteger[] bigIntegerArray3 = new BigInteger[arrayMaths.length];
                for (n5 = 0; n5 < this.length; ++n5) {
                    bigIntegerArray3[n5] = bigIntegerArray[n5];
                }
                for (n5 = 0; n5 < n; ++n5) {
                    bigIntegerArray3[n5 + this.length] = bigIntegerArray2[n5];
                }
                for (n5 = 0; n5 < arrayMaths.length; ++n5) {
                    arrayMaths.array.add(bigIntegerArray3[n5]);
                }
                bigIntegerArray = null;
                bigIntegerArray2 = null;
                bigIntegerArray3 = null;
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                int n6;
                Complex[] complexArray = this.getArray_as_Complex();
                arrayMaths2 = new ArrayMaths(lArray);
                Complex[] complexArray2 = arrayMaths2.getArray_as_Complex();
                Complex[] complexArray3 = new Complex[arrayMaths.length];
                for (n6 = 0; n6 < this.length; ++n6) {
                    complexArray3[n6] = complexArray[n6];
                }
                for (n6 = 0; n6 < n; ++n6) {
                    complexArray3[n6 + this.length] = complexArray2[n6];
                }
                for (n6 = 0; n6 < arrayMaths.length; ++n6) {
                    arrayMaths.array.add(complexArray3[n6]);
                }
                arrayMaths.type = 14;
                break;
            }
            case 15: {
                int n7;
                Phasor[] phasorArray = this.getArray_as_Phasor();
                arrayMaths2 = new ArrayMaths(lArray);
                Phasor[] phasorArray2 = arrayMaths2.getArray_as_Phasor();
                Phasor[] phasorArray3 = new Phasor[arrayMaths.length];
                for (n7 = 0; n7 < this.length; ++n7) {
                    phasorArray3[n7] = phasorArray[n7];
                }
                for (n7 = 0; n7 < n; ++n7) {
                    phasorArray3[n7 + this.length] = phasorArray2[n7];
                }
                for (n7 = 0; n7 < arrayMaths.length; ++n7) {
                    arrayMaths.array.add(phasorArray3[n7]);
                }
                arrayMaths.type = 15;
                break;
            }
            case 18: {
                int n8;
                String[] stringArray = this.getArray_as_String();
                arrayMaths2 = new ArrayMaths(lArray);
                String[] stringArray2 = arrayMaths2.getArray_as_String();
                String[] stringArray3 = new String[arrayMaths.length];
                for (n8 = 0; n8 < this.length; ++n8) {
                    stringArray3[n8] = stringArray[n8];
                }
                for (n8 = 0; n8 < n; ++n8) {
                    stringArray3[n8 + this.length] = stringArray2[n8];
                }
                for (n8 = 0; n8 < arrayMaths.length; ++n8) {
                    arrayMaths.array.add(stringArray3[n8]);
                }
                arrayMaths.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths concatenate(Long[] longArray) {
        long[] lArray = new long[longArray.length];
        for (int j = 0; j < longArray.length; ++j) {
            lArray[j] = longArray[j];
        }
        return this.concatenate(lArray);
    }

    public ArrayMaths concatenate(int[] nArray) {
        long[] lArray = new long[nArray.length];
        for (int j = 0; j < nArray.length; ++j) {
            lArray[j] = nArray[j];
        }
        return this.concatenate(lArray);
    }

    public ArrayMaths concatenate(Integer[] integerArray) {
        int[] nArray = new int[integerArray.length];
        for (int j = 0; j < integerArray.length; ++j) {
            nArray[j] = integerArray[j];
        }
        return this.concatenate(nArray);
    }

    public ArrayMaths concatenate(short[] sArray) {
        long[] lArray = new long[sArray.length];
        for (int j = 0; j < sArray.length; ++j) {
            lArray[j] = sArray[j];
        }
        return this.concatenate(lArray);
    }

    public ArrayMaths concatenate(Short[] shortArray) {
        short[] sArray = new short[shortArray.length];
        for (int j = 0; j < shortArray.length; ++j) {
            sArray[j] = shortArray[j];
        }
        return this.concatenate(sArray);
    }

    public ArrayMaths concatenate(byte[] byArray) {
        long[] lArray = new long[byArray.length];
        for (int j = 0; j < byArray.length; ++j) {
            lArray[j] = byArray[j];
        }
        return this.concatenate(lArray);
    }

    public ArrayMaths concatenate(Byte[] byteArray) {
        byte[] byArray = new byte[byteArray.length];
        for (int j = 0; j < byteArray.length; ++j) {
            byArray[j] = byteArray[j];
        }
        return this.concatenate(byArray);
    }

    public ArrayMaths concatenate(BigDecimal[] bigDecimalArray) {
        Object[] objectArray;
        int n = bigDecimalArray.length;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = bigDecimalArray.length + this.length;
        ArrayMaths arrayMaths2 = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                int n2;
                objectArray = this.getArray_as_BigDecimal();
                arrayMaths2 = new ArrayMaths(bigDecimalArray);
                BigDecimal[] bigDecimalArray2 = arrayMaths2.getArray_as_BigDecimal();
                BigDecimal[] bigDecimalArray3 = new BigDecimal[arrayMaths.length];
                for (n2 = 0; n2 < this.length; ++n2) {
                    bigDecimalArray3[n2] = objectArray[n2];
                }
                for (n2 = 0; n2 < n; ++n2) {
                    bigDecimalArray3[n2 + this.length] = bigDecimalArray2[n2];
                }
                for (n2 = 0; n2 < arrayMaths.length; ++n2) {
                    arrayMaths.array.add(bigDecimalArray3[n2]);
                }
                objectArray = null;
                bigDecimalArray2 = null;
                bigDecimalArray3 = null;
                arrayMaths.type = 12;
                break;
            }
            case 14: {
                int n3;
                Complex[] complexArray = this.getArray_as_Complex();
                arrayMaths2 = new ArrayMaths(bigDecimalArray);
                Complex[] complexArray2 = arrayMaths2.getArray_as_Complex();
                Complex[] complexArray3 = new Complex[arrayMaths.length];
                for (n3 = 0; n3 < this.length; ++n3) {
                    complexArray3[n3] = complexArray[n3];
                }
                for (n3 = 0; n3 < n; ++n3) {
                    complexArray3[n3 + this.length] = complexArray2[n3];
                }
                for (n3 = 0; n3 < arrayMaths.length; ++n3) {
                    arrayMaths.array.add(complexArray3[n3]);
                }
                arrayMaths.type = 14;
                break;
            }
            case 15: {
                int n4;
                Phasor[] phasorArray = this.getArray_as_Phasor();
                arrayMaths2 = new ArrayMaths(bigDecimalArray);
                Phasor[] phasorArray2 = arrayMaths2.getArray_as_Phasor();
                Phasor[] phasorArray3 = new Phasor[arrayMaths.length];
                for (n4 = 0; n4 < this.length; ++n4) {
                    phasorArray3[n4] = phasorArray[n4];
                }
                for (n4 = 0; n4 < n; ++n4) {
                    phasorArray3[n4 + this.length] = phasorArray2[n4];
                }
                for (n4 = 0; n4 < arrayMaths.length; ++n4) {
                    arrayMaths.array.add(phasorArray3[n4]);
                }
                arrayMaths.type = 15;
                break;
            }
            case 18: {
                int n5;
                String[] stringArray = this.getArray_as_String();
                arrayMaths2 = new ArrayMaths(bigDecimalArray);
                String[] stringArray2 = arrayMaths2.getArray_as_String();
                String[] stringArray3 = new String[arrayMaths.length];
                for (n5 = 0; n5 < this.length; ++n5) {
                    stringArray3[n5] = stringArray[n5];
                }
                for (n5 = 0; n5 < n; ++n5) {
                    stringArray3[n5 + this.length] = stringArray2[n5];
                }
                for (n5 = 0; n5 < arrayMaths.length; ++n5) {
                    arrayMaths.array.add(stringArray3[n5]);
                }
                arrayMaths.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths concatenate(BigInteger[] bigIntegerArray) {
        Object[] objectArray;
        int n = bigIntegerArray.length;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = bigIntegerArray.length + this.length;
        ArrayMaths arrayMaths2 = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                int n2;
                objectArray = this.getArray_as_BigDecimal();
                arrayMaths2 = new ArrayMaths(bigIntegerArray);
                BigDecimal[] bigDecimalArray = arrayMaths2.getArray_as_BigDecimal();
                BigDecimal[] bigDecimalArray2 = new BigDecimal[arrayMaths.length];
                for (n2 = 0; n2 < this.length; ++n2) {
                    bigDecimalArray2[n2] = objectArray[n2];
                }
                for (n2 = 0; n2 < n; ++n2) {
                    bigDecimalArray2[n2 + this.length] = bigDecimalArray[n2];
                }
                for (n2 = 0; n2 < arrayMaths.length; ++n2) {
                    arrayMaths.array.add(bigDecimalArray2[n2]);
                }
                objectArray = null;
                bigDecimalArray = null;
                bigDecimalArray2 = null;
                arrayMaths.type = 12;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: {
                int n3;
                BigInteger[] bigIntegerArray2 = this.getArray_as_BigInteger();
                arrayMaths2 = new ArrayMaths(bigIntegerArray);
                BigInteger[] bigIntegerArray3 = arrayMaths2.getArray_as_BigInteger();
                BigInteger[] bigIntegerArray4 = new BigInteger[arrayMaths.length];
                for (n3 = 0; n3 < this.length; ++n3) {
                    bigIntegerArray4[n3] = bigIntegerArray2[n3];
                }
                for (n3 = 0; n3 < n; ++n3) {
                    bigIntegerArray4[n3 + this.length] = bigIntegerArray3[n3];
                }
                for (n3 = 0; n3 < arrayMaths.length; ++n3) {
                    arrayMaths.array.add(bigIntegerArray4[n3]);
                }
                bigIntegerArray2 = null;
                bigIntegerArray3 = null;
                bigIntegerArray4 = null;
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                int n4;
                Complex[] complexArray = this.getArray_as_Complex();
                arrayMaths2 = new ArrayMaths(bigIntegerArray);
                Complex[] complexArray2 = arrayMaths2.getArray_as_Complex();
                Complex[] complexArray3 = new Complex[arrayMaths.length];
                for (n4 = 0; n4 < this.length; ++n4) {
                    complexArray3[n4] = complexArray[n4];
                }
                for (n4 = 0; n4 < n; ++n4) {
                    complexArray3[n4 + this.length] = complexArray2[n4];
                }
                for (n4 = 0; n4 < arrayMaths.length; ++n4) {
                    arrayMaths.array.add(complexArray3[n4]);
                }
                arrayMaths.type = 14;
                break;
            }
            case 15: {
                int n5;
                Phasor[] phasorArray = this.getArray_as_Phasor();
                arrayMaths2 = new ArrayMaths(bigIntegerArray);
                Phasor[] phasorArray2 = arrayMaths2.getArray_as_Phasor();
                Phasor[] phasorArray3 = new Phasor[arrayMaths.length];
                for (n5 = 0; n5 < this.length; ++n5) {
                    phasorArray3[n5] = phasorArray[n5];
                }
                for (n5 = 0; n5 < n; ++n5) {
                    phasorArray3[n5 + this.length] = phasorArray2[n5];
                }
                for (n5 = 0; n5 < arrayMaths.length; ++n5) {
                    arrayMaths.array.add(phasorArray3[n5]);
                }
                arrayMaths.type = 15;
                break;
            }
            case 18: {
                int n6;
                String[] stringArray = this.getArray_as_String();
                arrayMaths2 = new ArrayMaths(bigIntegerArray);
                String[] stringArray2 = arrayMaths2.getArray_as_String();
                String[] stringArray3 = new String[arrayMaths.length];
                for (n6 = 0; n6 < this.length; ++n6) {
                    stringArray3[n6] = stringArray[n6];
                }
                for (n6 = 0; n6 < n; ++n6) {
                    stringArray3[n6 + this.length] = stringArray2[n6];
                }
                for (n6 = 0; n6 < arrayMaths.length; ++n6) {
                    arrayMaths.array.add(stringArray3[n6]);
                }
                arrayMaths.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths concatenate(Complex[] complexArray) {
        int n = complexArray.length;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = complexArray.length + this.length;
        ArrayMaths arrayMaths2 = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                int n2;
                Complex[] complexArray2 = this.getArray_as_Complex();
                arrayMaths2 = new ArrayMaths(complexArray);
                Complex[] complexArray3 = arrayMaths2.getArray_as_Complex();
                Complex[] complexArray4 = new Complex[arrayMaths.length];
                for (n2 = 0; n2 < this.length; ++n2) {
                    complexArray4[n2] = complexArray2[n2];
                }
                for (n2 = 0; n2 < n; ++n2) {
                    complexArray4[n2 + this.length] = complexArray3[n2];
                }
                for (n2 = 0; n2 < arrayMaths.length; ++n2) {
                    arrayMaths.array.add(complexArray4[n2]);
                }
                arrayMaths.type = 14;
                break;
            }
            case 18: {
                int n3;
                String[] stringArray = this.getArray_as_String();
                arrayMaths2 = new ArrayMaths(complexArray);
                String[] stringArray2 = arrayMaths2.getArray_as_String();
                String[] stringArray3 = new String[arrayMaths.length];
                for (n3 = 0; n3 < this.length; ++n3) {
                    stringArray3[n3] = stringArray[n3];
                }
                for (n3 = 0; n3 < n; ++n3) {
                    stringArray3[n3 + this.length] = stringArray2[n3];
                }
                for (n3 = 0; n3 < arrayMaths.length; ++n3) {
                    arrayMaths.array.add(stringArray3[n3]);
                }
                arrayMaths.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths concatenate(Phasor[] phasorArray) {
        int n = phasorArray.length;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = phasorArray.length + this.length;
        ArrayMaths arrayMaths2 = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                int n2;
                Phasor[] phasorArray2 = this.getArray_as_Phasor();
                arrayMaths2 = new ArrayMaths(phasorArray);
                Phasor[] phasorArray3 = arrayMaths2.getArray_as_Phasor();
                Phasor[] phasorArray4 = new Phasor[arrayMaths.length];
                for (n2 = 0; n2 < this.length; ++n2) {
                    phasorArray4[n2] = phasorArray2[n2];
                }
                for (n2 = 0; n2 < n; ++n2) {
                    phasorArray4[n2 + this.length] = phasorArray3[n2];
                }
                for (n2 = 0; n2 < arrayMaths.length; ++n2) {
                    arrayMaths.array.add(phasorArray4[n2]);
                }
                arrayMaths.type = 15;
                break;
            }
            case 18: {
                int n3;
                String[] stringArray = this.getArray_as_String();
                arrayMaths2 = new ArrayMaths(phasorArray);
                String[] stringArray2 = arrayMaths2.getArray_as_String();
                String[] stringArray3 = new String[arrayMaths.length];
                for (n3 = 0; n3 < this.length; ++n3) {
                    stringArray3[n3] = stringArray[n3];
                }
                for (n3 = 0; n3 < n; ++n3) {
                    stringArray3[n3 + this.length] = stringArray2[n3];
                }
                for (n3 = 0; n3 < arrayMaths.length; ++n3) {
                    arrayMaths.array.add(stringArray3[n3]);
                }
                arrayMaths.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths concatenate(String[] stringArray) {
        int n = stringArray.length;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = stringArray.length + this.length;
        ArrayMaths arrayMaths2 = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                int n2;
                String[] stringArray2 = this.getArray_as_String();
                arrayMaths2 = new ArrayMaths(stringArray);
                String[] stringArray3 = arrayMaths2.getArray_as_String();
                String[] stringArray4 = new String[arrayMaths.length];
                for (n2 = 0; n2 < this.length; ++n2) {
                    stringArray4[n2] = stringArray2[n2];
                }
                for (n2 = 0; n2 < n; ++n2) {
                    stringArray4[n2 + this.length] = stringArray3[n2];
                }
                for (n2 = 0; n2 < arrayMaths.length; ++n2) {
                    arrayMaths.array.add(stringArray4[n2]);
                }
                arrayMaths.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths concatenate(char[] cArray) {
        Object[] objectArray;
        int n = cArray.length;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        ArrayMaths arrayMaths = new ArrayMaths();
        arrayMaths.array = new ArrayList();
        arrayMaths.length = cArray.length + this.length;
        ArrayMaths arrayMaths2 = null;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int n2;
                objectArray = this.getArray_as_double();
                double[] dArray = new double[arrayMaths.length];
                for (n2 = 0; n2 < this.length; ++n2) {
                    dArray[n2] = objectArray[n2];
                }
                for (n2 = 0; n2 < n; ++n2) {
                    dArray[n2 + this.length] = cArray[n2];
                }
                for (n2 = 0; n2 < arrayMaths.length; ++n2) {
                    arrayMaths.array.add(new Double(dArray[n2]));
                }
                arrayMaths.type = 1;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                int n3;
                long[] lArray = this.getArray_as_long();
                long[] lArray2 = new long[arrayMaths.length];
                for (n3 = 0; n3 < this.length; ++n3) {
                    lArray2[n3] = lArray[n3];
                }
                for (n3 = 0; n3 < n; ++n3) {
                    lArray2[n3 + this.length] = cArray[n3];
                }
                for (n3 = 0; n3 < arrayMaths.length; ++n3) {
                    arrayMaths.array.add(new Long(lArray2[n3]));
                }
                arrayMaths.type = 3;
                break;
            }
            case 12: {
                int n4;
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                arrayMaths2 = new ArrayMaths(cArray);
                BigDecimal[] bigDecimalArray2 = arrayMaths2.getArray_as_BigDecimal();
                BigDecimal[] bigDecimalArray3 = new BigDecimal[arrayMaths.length];
                for (n4 = 0; n4 < this.length; ++n4) {
                    bigDecimalArray3[n4] = bigDecimalArray[n4];
                }
                for (n4 = 0; n4 < n; ++n4) {
                    bigDecimalArray3[n4 + this.length] = bigDecimalArray2[n4];
                }
                for (n4 = 0; n4 < arrayMaths.length; ++n4) {
                    arrayMaths.array.add(bigDecimalArray3[n4]);
                }
                bigDecimalArray = null;
                bigDecimalArray2 = null;
                bigDecimalArray3 = null;
                arrayMaths.type = 12;
                break;
            }
            case 13: {
                int n5;
                BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
                arrayMaths2 = new ArrayMaths(cArray);
                BigInteger[] bigIntegerArray2 = arrayMaths2.getArray_as_BigInteger();
                BigInteger[] bigIntegerArray3 = new BigInteger[arrayMaths.length];
                for (n5 = 0; n5 < this.length; ++n5) {
                    bigIntegerArray3[n5] = bigIntegerArray[n5];
                }
                for (n5 = 0; n5 < n; ++n5) {
                    bigIntegerArray3[n5 + this.length] = bigIntegerArray2[n5];
                }
                for (n5 = 0; n5 < arrayMaths.length; ++n5) {
                    arrayMaths.array.add(bigIntegerArray3[n5]);
                }
                bigIntegerArray = null;
                bigIntegerArray2 = null;
                bigIntegerArray3 = null;
                arrayMaths.type = 13;
                break;
            }
            case 14: {
                int n6;
                Complex[] complexArray = this.getArray_as_Complex();
                arrayMaths2 = new ArrayMaths(cArray);
                Complex[] complexArray2 = arrayMaths2.getArray_as_Complex();
                Complex[] complexArray3 = new Complex[arrayMaths.length];
                for (n6 = 0; n6 < this.length; ++n6) {
                    complexArray3[n6] = complexArray[n6];
                }
                for (n6 = 0; n6 < n; ++n6) {
                    complexArray3[n6 + this.length] = complexArray2[n6];
                }
                for (n6 = 0; n6 < arrayMaths.length; ++n6) {
                    arrayMaths.array.add(complexArray3[n6]);
                }
                arrayMaths.type = 14;
                break;
            }
            case 15: {
                int n7;
                Phasor[] phasorArray = this.getArray_as_Phasor();
                arrayMaths2 = new ArrayMaths(cArray);
                Phasor[] phasorArray2 = arrayMaths2.getArray_as_Phasor();
                Phasor[] phasorArray3 = new Phasor[arrayMaths.length];
                for (n7 = 0; n7 < this.length; ++n7) {
                    phasorArray3[n7] = phasorArray[n7];
                }
                for (n7 = 0; n7 < n; ++n7) {
                    phasorArray3[n7 + this.length] = phasorArray2[n7];
                }
                for (n7 = 0; n7 < arrayMaths.length; ++n7) {
                    arrayMaths.array.add(phasorArray3[n7]);
                }
                arrayMaths.type = 15;
                break;
            }
            case 16: 
            case 17: {
                int n8;
                char[] cArray2 = this.getArray_as_char();
                char[] cArray3 = new char[arrayMaths.length];
                for (n8 = 0; n8 < this.length; ++n8) {
                    cArray3[n8] = cArray2[n8];
                }
                for (n8 = 0; n8 < n; ++n8) {
                    cArray3[n8 + this.length] = cArray[n8];
                }
                for (n8 = 0; n8 < arrayMaths.length; ++n8) {
                    arrayMaths.array.add(new Character(cArray3[n8]));
                }
                arrayMaths.type = 1;
                break;
            }
            case 18: {
                int n9;
                String[] stringArray = this.getArray_as_String();
                arrayMaths2 = new ArrayMaths(cArray);
                String[] stringArray2 = arrayMaths2.getArray_as_String();
                String[] stringArray3 = new String[arrayMaths.length];
                for (n9 = 0; n9 < this.length; ++n9) {
                    stringArray3[n9] = stringArray[n9];
                }
                for (n9 = 0; n9 < n; ++n9) {
                    stringArray3[n9 + this.length] = stringArray2[n9];
                }
                for (n9 = 0; n9 < arrayMaths.length; ++n9) {
                    arrayMaths.array.add(stringArray3[n9]);
                }
                arrayMaths.type = 18;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public ArrayMaths concatenate(Character[] characterArray) {
        char[] cArray = new char[characterArray.length];
        for (int j = 0; j < characterArray.length; ++j) {
            cArray[j] = characterArray[j].charValue();
        }
        return this.concatenate(cArray);
    }

    public ArrayMaths concatenate(ArrayMaths arrayMaths) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = arrayMaths.type;
        ArrayMaths arrayMaths2 = new ArrayMaths();
        switch (arrayMaths.type) {
            case 0: 
            case 1: {
                objectArray = arrayMaths.getArray_as_double();
                arrayMaths2 = this.concatenate((double[])objectArray);
                break;
            }
            case 2: 
            case 3: {
                float[] fArray = arrayMaths.getArray_as_float();
                arrayMaths2 = this.concatenate(fArray);
                break;
            }
            case 4: 
            case 5: {
                long[] lArray = arrayMaths.getArray_as_long();
                arrayMaths2 = this.concatenate(lArray);
                break;
            }
            case 6: 
            case 7: {
                int[] nArray = arrayMaths.getArray_as_int();
                arrayMaths2 = this.concatenate(nArray);
                break;
            }
            case 8: 
            case 9: {
                short[] sArray = arrayMaths.getArray_as_short();
                arrayMaths2 = this.concatenate(sArray);
                break;
            }
            case 10: 
            case 11: {
                byte[] byArray = arrayMaths.getArray_as_byte();
                arrayMaths2 = this.concatenate(byArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = arrayMaths.getArray_as_BigDecimal();
                arrayMaths2 = this.concatenate(bigDecimalArray);
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
                arrayMaths2 = this.concatenate(bigIntegerArray);
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                arrayMaths2 = this.concatenate(complexArray);
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                arrayMaths2 = this.concatenate(phasorArray);
                break;
            }
            case 16: 
            case 17: {
                char[] cArray = this.getArray_as_char();
                arrayMaths2 = this.concatenate(cArray);
                break;
            }
            case 18: {
                String[] stringArray = this.getArray_as_String();
                arrayMaths2 = this.concatenate(stringArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths2.getArray_as_Object(), arrayMaths2.minmax, (int[])objectArray, arrayMaths2.typeName, arrayMaths2.type);
        arrayMaths2.maxIndex = (int)objectArray[0];
        arrayMaths2.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths2;
    }

    public ArrayMaths concatenate(Stat stat) {
        Object[] objectArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = stat.type;
        ArrayMaths arrayMaths = new ArrayMaths();
        switch (stat.type) {
            case 0: 
            case 1: {
                objectArray = stat.getArray_as_double();
                arrayMaths = this.concatenate((double[])objectArray);
                break;
            }
            case 2: 
            case 3: {
                float[] fArray = stat.getArray_as_float();
                arrayMaths = this.concatenate(fArray);
                break;
            }
            case 4: 
            case 5: {
                long[] lArray = stat.getArray_as_long();
                arrayMaths = this.concatenate(lArray);
                break;
            }
            case 6: 
            case 7: {
                int[] nArray = stat.getArray_as_int();
                arrayMaths = this.concatenate(nArray);
                break;
            }
            case 8: 
            case 9: {
                short[] sArray = stat.getArray_as_short();
                arrayMaths = this.concatenate(sArray);
                break;
            }
            case 10: 
            case 11: {
                byte[] byArray = stat.getArray_as_byte();
                arrayMaths = this.concatenate(byArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = stat.getArray_as_BigDecimal();
                arrayMaths = this.concatenate(bigDecimalArray);
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
                arrayMaths = this.concatenate(bigIntegerArray);
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                arrayMaths = this.concatenate(complexArray);
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                arrayMaths = this.concatenate(phasorArray);
                break;
            }
            case 16: 
            case 17: {
                char[] cArray = this.getArray_as_char();
                arrayMaths = this.concatenate(cArray);
                break;
            }
            case 18: {
                String[] stringArray = this.getArray_as_String();
                arrayMaths = this.concatenate(stringArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
        objectArray = new int[2];
        ArrayMaths.findMinMax(arrayMaths.getArray_as_Object(), arrayMaths.minmax, (int[])objectArray, arrayMaths.typeName, arrayMaths.type);
        arrayMaths.maxIndex = (int)objectArray[0];
        arrayMaths.minIndex = (int)objectArray[1];
        Conv.restoreMessages();
        return arrayMaths;
    }

    public int indexOf(double d) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = -1;
        if (this.type == 0 || this.type == 1) {
            double[] dArray = this.getArray_as_double();
            boolean bl = true;
            int n2 = 0;
            while (bl) {
                if (dArray[n2] == d) {
                    n = n2;
                    bl = false;
                    continue;
                }
                if (++n2 < dArray.length) continue;
                bl = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare double or Double with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return n;
    }

    public int indexOf(Double d) {
        double d2 = d;
        return this.indexOf(d2);
    }

    public int indexOf(float f) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = -1;
        if (this.type == 2 || this.type == 3) {
            float[] fArray = this.getArray_as_float();
            boolean bl = true;
            int n2 = 0;
            while (bl) {
                if (fArray[n2] == f) {
                    n = n2;
                    bl = false;
                    continue;
                }
                if (++n2 < fArray.length) continue;
                bl = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare float or Float with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return n;
    }

    public int indexOf(Float f) {
        float f2 = f.floatValue();
        return this.indexOf(f2);
    }

    public int indexOf(long l) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = -1;
        if (this.type == 4 || this.type == 5) {
            long[] lArray = this.getArray_as_long();
            boolean bl = true;
            int n2 = 0;
            while (bl) {
                if (lArray[n2] == l) {
                    n = n2;
                    bl = false;
                    continue;
                }
                if (++n2 < lArray.length) continue;
                bl = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare long or Long with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return n;
    }

    public int indexOf(Long l) {
        long l2 = l;
        return this.indexOf(l2);
    }

    public int indexOf(int n) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n2 = -1;
        if (this.type == 6 || this.type == 7) {
            int[] nArray = this.getArray_as_int();
            boolean bl = true;
            int n3 = 0;
            while (bl) {
                if (nArray[n3] == n) {
                    n2 = n3;
                    bl = false;
                    continue;
                }
                if (++n3 < nArray.length) continue;
                bl = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare int or Integer with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return n2;
    }

    public int indexOf(Integer n) {
        int n2 = n;
        return this.indexOf(n2);
    }

    public int indexOf(short s) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = -1;
        if (this.type == 8 || this.type == 9) {
            short[] sArray = this.getArray_as_short();
            boolean bl = true;
            int n2 = 0;
            while (bl) {
                if (sArray[n2] == s) {
                    n = n2;
                    bl = false;
                    continue;
                }
                if (++n2 < sArray.length) continue;
                bl = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare short or Short with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return n;
    }

    public int indexOf(Short s) {
        short s2 = s;
        return this.indexOf(s2);
    }

    public int indexOf(byte by) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = -1;
        if (this.type == 10 || this.type == 11) {
            byte[] byArray = this.getArray_as_byte();
            boolean bl = true;
            int n2 = 0;
            while (bl) {
                if (byArray[n2] == by) {
                    n = n2;
                    bl = false;
                    continue;
                }
                if (++n2 < byArray.length) continue;
                bl = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare byte or Byte with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return n;
    }

    public int indexOf(Byte by) {
        byte by2 = by;
        return this.indexOf(by2);
    }

    public int indexOf(char c) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = -1;
        if (this.type == 16 || this.type == 17) {
            char[] cArray = this.getArray_as_char();
            boolean bl = true;
            int n2 = 0;
            while (bl) {
                if (cArray[n2] == c) {
                    n = n2;
                    bl = false;
                    continue;
                }
                if (++n2 < cArray.length) continue;
                bl = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare char or Character with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return n;
    }

    public int indexOf(Character c) {
        char c2 = c.charValue();
        return this.indexOf(c2);
    }

    public int indexOf(String string) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = -1;
        if (this.type == 18) {
            String[] stringArray = this.getArray_as_String();
            boolean bl = true;
            int n2 = 0;
            while (bl) {
                if (stringArray[n2].equals(string)) {
                    n = n2;
                    bl = false;
                    continue;
                }
                if (++n2 < stringArray.length) continue;
                bl = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare String with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return n;
    }

    public int indexOf(Complex complex) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = -1;
        if (this.type == 14) {
            Complex[] complexArray = this.getArray_as_Complex();
            boolean bl = true;
            int n2 = 0;
            while (bl) {
                if (complexArray[n2].equals(complex)) {
                    n = n2;
                    bl = false;
                    continue;
                }
                if (++n2 < complexArray.length) continue;
                bl = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare Complex with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return n;
    }

    public int indexOf(Phasor phasor) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = -1;
        if (this.type == 15) {
            Phasor[] phasorArray = this.getArray_as_Phasor();
            boolean bl = true;
            int n2 = 0;
            while (bl) {
                if (phasorArray[n2].equals(phasor)) {
                    n = n2;
                    bl = false;
                    continue;
                }
                if (++n2 < phasorArray.length) continue;
                bl = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare Phasor with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return n;
    }

    public int indexOf(BigDecimal bigDecimal) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = -1;
        if (this.type == 12) {
            BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
            boolean bl = true;
            int n2 = 0;
            while (bl) {
                if (bigDecimalArray[n2].compareTo(bigDecimal) == 0) {
                    n = n2;
                    bl = false;
                    continue;
                }
                if (++n2 < bigDecimalArray.length) continue;
                bl = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare BigDecimal with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return n;
    }

    public int indexOf(BigInteger bigInteger) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = -1;
        if (this.type == 13) {
            BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
            boolean bl = true;
            int n2 = 0;
            while (bl) {
                if (bigIntegerArray[n2].compareTo(bigInteger) == 0) {
                    n = n2;
                    bl = false;
                    continue;
                }
                if (++n2 < bigIntegerArray.length) continue;
                bl = false;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare BigInteger with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return n;
    }

    public int[] indicesOf(double d) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] nArray = null;
        int n = 0;
        if (this.type == 0 || this.type == 1) {
            int n2;
            double[] dArray = this.getArray_as_double();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n2 = 0; n2 < this.length; ++n2) {
                if (dArray[n2] != d) continue;
                ++n;
                arrayList.add(new Integer(n2));
            }
            if (n != 0) {
                nArray = new int[n];
                for (n2 = 0; n2 < n; ++n2) {
                    nArray[n2] = (Integer)arrayList.get(n2);
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare double or Double with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return nArray;
    }

    public int[] indicesOf(Double d) {
        double d2 = d;
        return this.indicesOf(d2);
    }

    public int[] indicesOf(float f) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] nArray = null;
        int n = 0;
        if (this.type == 2 || this.type == 3) {
            int n2;
            float[] fArray = this.getArray_as_float();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n2 = 0; n2 < this.length; ++n2) {
                if (fArray[n2] != f) continue;
                ++n;
                arrayList.add(new Integer(n2));
            }
            if (n != 0) {
                nArray = new int[n];
                for (n2 = 0; n2 < n; ++n2) {
                    nArray[n2] = (Integer)arrayList.get(n2);
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare float or Float with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return nArray;
    }

    public int[] indicesOf(Float f) {
        float f2 = f.floatValue();
        return this.indicesOf(f2);
    }

    public int[] indicesOf(long l) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] nArray = null;
        int n = 0;
        if (this.type == 4 || this.type == 5) {
            int n2;
            long[] lArray = this.getArray_as_long();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n2 = 0; n2 < this.length; ++n2) {
                if (lArray[n2] != l) continue;
                ++n;
                arrayList.add(new Integer(n2));
            }
            if (n != 0) {
                nArray = new int[n];
                for (n2 = 0; n2 < n; ++n2) {
                    nArray[n2] = (Integer)arrayList.get(n2);
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare long or Long with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return nArray;
    }

    public int[] indicesOf(Long l) {
        long l2 = l;
        return this.indicesOf(l2);
    }

    public int[] indicesOf(int n) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] nArray = null;
        int n2 = 0;
        if (this.type == 6 || this.type == 7) {
            int n3;
            int[] nArray2 = this.getArray_as_int();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n3 = 0; n3 < this.length; ++n3) {
                if (nArray2[n3] != n) continue;
                ++n2;
                arrayList.add(new Integer(n3));
            }
            if (n2 != 0) {
                nArray = new int[n2];
                for (n3 = 0; n3 < n2; ++n3) {
                    nArray[n3] = (Integer)arrayList.get(n3);
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare int or Integer with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return nArray;
    }

    public int[] indicesOf(Integer n) {
        int n2 = n;
        return this.indicesOf(n2);
    }

    public int[] indicesOf(short s) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] nArray = null;
        int n = 0;
        if (this.type == 8 || this.type == 9) {
            int n2;
            short[] sArray = this.getArray_as_short();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n2 = 0; n2 < this.length; ++n2) {
                if (sArray[n2] != s) continue;
                ++n;
                arrayList.add(new Integer(n2));
            }
            if (n != 0) {
                nArray = new int[n];
                for (n2 = 0; n2 < n; ++n2) {
                    nArray[n2] = (Integer)arrayList.get(n2);
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare short or Short with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return nArray;
    }

    public int[] indicesOf(Short s) {
        short s2 = s;
        return this.indicesOf(s2);
    }

    public int[] indicesOf(byte by) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] nArray = null;
        int n = 0;
        if (this.type == 10 || this.type == 11) {
            int n2;
            byte[] byArray = this.getArray_as_byte();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n2 = 0; n2 < this.length; ++n2) {
                if (byArray[n2] != by) continue;
                ++n;
                arrayList.add(new Integer(n2));
            }
            if (n != 0) {
                nArray = new int[n];
                for (n2 = 0; n2 < n; ++n2) {
                    nArray[n2] = (Integer)arrayList.get(n2);
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare byte or Byte with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return nArray;
    }

    public int[] indicesOf(Byte by) {
        byte by2 = by;
        return this.indicesOf(by2);
    }

    public int[] indicesOf(char c) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] nArray = null;
        int n = 0;
        if (this.type == 16 || this.type == 17) {
            int n2;
            char[] cArray = this.getArray_as_char();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n2 = 0; n2 < this.length; ++n2) {
                if (cArray[n2] != c) continue;
                ++n;
                arrayList.add(new Integer(n2));
            }
            if (n != 0) {
                nArray = new int[n];
                for (n2 = 0; n2 < n; ++n2) {
                    nArray[n2] = (Integer)arrayList.get(n2);
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare char or Character with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return nArray;
    }

    public int[] indicesOf(Character c) {
        char c2 = c.charValue();
        return this.indicesOf(c2);
    }

    public int[] indicesOf(String string) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] nArray = null;
        int n = 0;
        if (this.type == 18) {
            int n2;
            String[] stringArray = this.getArray_as_String();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n2 = 0; n2 < this.length; ++n2) {
                if (!stringArray[n2].equals(string)) continue;
                ++n;
                arrayList.add(new Integer(n2));
            }
            if (n != 0) {
                nArray = new int[n];
                for (n2 = 0; n2 < n; ++n2) {
                    nArray[n2] = (Integer)arrayList.get(n2);
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare String with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return nArray;
    }

    public int[] indicesOf(Complex complex) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] nArray = null;
        int n = 0;
        if (this.type == 14) {
            int n2;
            Complex[] complexArray = this.getArray_as_Complex();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n2 = 0; n2 < this.length; ++n2) {
                if (!complexArray[n2].equals(complex)) continue;
                ++n;
                arrayList.add(new Integer(n2));
            }
            if (n != 0) {
                nArray = new int[n];
                for (n2 = 0; n2 < n; ++n2) {
                    nArray[n2] = (Integer)arrayList.get(n2);
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare Complex with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return nArray;
    }

    public int[] indicesOf(Phasor phasor) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] nArray = null;
        int n = 0;
        if (this.type == 15) {
            int n2;
            Phasor[] phasorArray = this.getArray_as_Phasor();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n2 = 0; n2 < this.length; ++n2) {
                if (!phasorArray[n2].equals(phasor)) continue;
                ++n;
                arrayList.add(new Integer(n2));
            }
            if (n != 0) {
                nArray = new int[n];
                for (n2 = 0; n2 < n; ++n2) {
                    nArray[n2] = (Integer)arrayList.get(n2);
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare Phasor with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return nArray;
    }

    public int[] indicesOf(BigDecimal bigDecimal) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] nArray = null;
        int n = 0;
        if (this.type == 12) {
            int n2;
            BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n2 = 0; n2 < this.length; ++n2) {
                if (bigDecimalArray[n2].compareTo(bigDecimal) != 0) continue;
                ++n;
                arrayList.add(new Integer(n2));
            }
            if (n != 0) {
                nArray = new int[n];
                for (n2 = 0; n2 < n; ++n2) {
                    nArray[n2] = (Integer)arrayList.get(n2);
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare BigDecimal with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return nArray;
    }

    public int[] indicesOf(BigInteger bigInteger) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int[] nArray = null;
        int n = 0;
        if (this.type == 13) {
            int n2;
            BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n2 = 0; n2 < this.length; ++n2) {
                if (bigIntegerArray[n2].compareTo(bigInteger) != 0) continue;
                ++n;
                arrayList.add(new Integer(n2));
            }
            if (n != 0) {
                nArray = new int[n];
                for (n2 = 0; n2 < n; ++n2) {
                    nArray[n2] = (Integer)arrayList.get(n2);
                }
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare BigInteger with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return nArray;
    }

    public int nearestIndex(double d) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = 0;
        if (this.type == 0 || this.type == 1) {
            double[] dArray = this.getArray_as_double();
            double d2 = Math.abs(dArray[0] - d);
            double d3 = dArray[0];
            for (int j = 1; j < dArray.length; ++j) {
                if (!(Math.abs(dArray[j] - d) < d2)) continue;
                d2 = Math.abs(dArray[j] - d);
                n = j;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare double or Double with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return n;
    }

    public int nearestIndex(Double d) {
        double d2 = d;
        return this.nearestIndex(d2);
    }

    public int nearestIndex(float f) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = 0;
        if (this.type == 2 || this.type == 3) {
            float[] fArray = this.getArray_as_float();
            float f2 = Math.abs(fArray[0] - f);
            float f3 = fArray[0];
            for (int j = 1; j < fArray.length; ++j) {
                if (!(Math.abs(fArray[j] - f) < f2)) continue;
                f2 = Math.abs(fArray[j] - f);
                n = j;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare float or Float with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return n;
    }

    public int nearestIndex(Float f) {
        float f2 = f.floatValue();
        return this.nearestIndex(f2);
    }

    public int nearestIndex(long l) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = 0;
        if (this.type == 4 || this.type == 5) {
            long[] lArray = this.getArray_as_long();
            long l2 = Math.abs(lArray[0] - l);
            long l3 = lArray[0];
            for (int j = 1; j < lArray.length; ++j) {
                if (Math.abs(lArray[j] - l) >= l2) continue;
                l2 = Math.abs(lArray[j] - l);
                n = j;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare long or Long with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return n;
    }

    public int nearestIndex(Long l) {
        long l2 = l;
        return this.nearestIndex(l2);
    }

    public int nearestIndex(int n) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n2 = 0;
        if (this.type == 6 || this.type == 7) {
            int[] nArray = this.getArray_as_int();
            int n3 = Math.abs(nArray[0] - n);
            int n4 = nArray[0];
            for (int j = 1; j < nArray.length; ++j) {
                if (Math.abs(nArray[j] - n) >= n3) continue;
                n3 = Math.abs(nArray[j] - n);
                n2 = j;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare int or Integer with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return n2;
    }

    public int nearestIndex(Integer n) {
        int n2 = n;
        return this.nearestIndex(n2);
    }

    public int nearestIndex(short s) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = 0;
        if (this.type == 8 || this.type == 9) {
            short[] sArray = this.getArray_as_short();
            short s2 = (short)Math.abs(sArray[0] - s);
            short s3 = sArray[0];
            for (int j = 1; j < sArray.length; ++j) {
                if (Math.abs(sArray[j] - s) >= s2) continue;
                s2 = (short)Math.abs(sArray[j] - s);
                n = j;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare short or Short with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return n;
    }

    public int nearestIndex(Short s) {
        short s2 = s;
        return this.nearestIndex(s2);
    }

    public int nearestIndex(byte by) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = 0;
        if (this.type == 10 || this.type == 11) {
            byte[] byArray = this.getArray_as_byte();
            byte by2 = (byte)Math.abs(byArray[0] - by);
            byte by3 = byArray[0];
            for (int j = 1; j < byArray.length; ++j) {
                if (Math.abs(byArray[j] - by) >= by2) continue;
                by2 = (byte)Math.abs(byArray[j] - by);
                n = j;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare byte or Byte with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return n;
    }

    public int nearestIndex(Byte by) {
        byte by2 = by;
        return this.nearestIndex(by2);
    }

    public int nearestIndex(char c) {
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = 0;
        if (this.type == 16 || this.type == 17) {
            int[] nArray = this.getArray_as_int();
            int n2 = Math.abs(nArray[0] - c);
            int n3 = nArray[0];
            for (int j = 1; j < nArray.length; ++j) {
                if (Math.abs(nArray[j] - c) >= n2) continue;
                n2 = Math.abs(nArray[j] - c);
                n = j;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare char or Character with " + this.typeName[this.type]);
        }
        Conv.restoreMessages();
        return n;
    }

    public int nearestIndex(Character c) {
        char c2 = c.charValue();
        return this.nearestIndex(c2);
    }

    public int nearestIndex(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal3;
        BigDecimal[] bigDecimalArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = 0;
        if (this.type == 12) {
            bigDecimalArray = this.getArray_as_BigDecimal();
            bigDecimal3 = bigDecimalArray[0].subtract(bigDecimal).abs();
            bigDecimal2 = bigDecimalArray[0];
            for (int j = 1; j < bigDecimalArray.length; ++j) {
                if (bigDecimalArray[j].subtract(bigDecimal).abs().compareTo(bigDecimal3) != -1) continue;
                bigDecimal3 = bigDecimalArray[j].subtract(bigDecimal).abs();
                n = j;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare BigDecimal with " + this.typeName[this.type]);
        }
        bigDecimalArray = null;
        bigDecimal3 = null;
        bigDecimal2 = null;
        Conv.restoreMessages();
        return n;
    }

    public int nearestIndex(BigInteger bigInteger) {
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger[] bigIntegerArray;
        if (this.suppressMessages) {
            Conv.suppressMessages();
        }
        int n = 0;
        if (this.type == 12) {
            bigIntegerArray = this.getArray_as_BigInteger();
            bigInteger3 = bigIntegerArray[0].subtract(bigInteger).abs();
            bigInteger2 = bigIntegerArray[0];
            for (int j = 1; j < bigIntegerArray.length; ++j) {
                if (bigIntegerArray[j].subtract(bigInteger).abs().compareTo(bigInteger3) != -1) continue;
                bigInteger3 = bigIntegerArray[j].subtract(bigInteger).abs();
                n = j;
            }
        } else {
            throw new IllegalArgumentException("Only comparisons between the same data types are supported - you are attempting to compare BigInteger with " + this.typeName[this.type]);
        }
        bigIntegerArray = null;
        bigInteger3 = null;
        bigInteger2 = null;
        Conv.restoreMessages();
        return n;
    }

    public double nearestValue(double d) {
        int n = this.nearestIndex(d);
        double d2 = (Double)this.array.get(n);
        return d2;
    }

    public Double nearestValue(Double d) {
        int n = this.nearestIndex(d);
        Double d2 = (Double)this.array.get(n);
        return d2;
    }

    public float nearestValue(float f) {
        int n = this.nearestIndex(f);
        float f2 = ((Float)this.array.get(n)).floatValue();
        return f2;
    }

    public Float nearestValue(Float f) {
        int n = this.nearestIndex(f);
        Float f2 = (Float)this.array.get(n);
        return f2;
    }

    public long nearestValue(long l) {
        int n = this.nearestIndex(l);
        long l2 = (Long)this.array.get(n);
        return l2;
    }

    public Long nearestValue(Long l) {
        int n = this.nearestIndex(l);
        Long l2 = (Long)this.array.get(n);
        return l2;
    }

    public int nearestValue(int n) {
        int n2 = this.nearestIndex(n);
        int n3 = (Integer)this.array.get(n2);
        return n3;
    }

    public Integer nearestValue(Integer n) {
        int n2 = this.nearestIndex(n);
        Integer n3 = (Integer)this.array.get(n2);
        return n3;
    }

    public short nearestValue(short s) {
        int n = this.nearestIndex(s);
        short s2 = (Short)this.array.get(n);
        return s2;
    }

    public Short nearestValue(Short s) {
        int n = this.nearestIndex(s);
        Short s2 = (Short)this.array.get(n);
        return s2;
    }

    public byte nearestValue(byte by) {
        int n = this.nearestIndex(by);
        byte by2 = (Byte)this.array.get(n);
        return by2;
    }

    public Byte nearestValue(Byte by) {
        int n = this.nearestIndex(by);
        Byte by2 = (Byte)this.array.get(n);
        return by2;
    }

    public char nearestValue(char c) {
        int n = this.nearestIndex(c);
        char c2 = ((Character)this.array.get(n)).charValue();
        return c2;
    }

    public Character nearestValue(Character c) {
        int n = this.nearestIndex(c);
        Character c2 = (Character)this.array.get(n);
        return c2;
    }

    public BigDecimal nearestValue(BigDecimal bigDecimal) {
        int n = this.nearestIndex(bigDecimal);
        BigDecimal bigDecimal2 = (BigDecimal)this.array.get(n);
        return bigDecimal2;
    }

    public BigInteger nearestValue(BigInteger bigInteger) {
        int n = this.nearestIndex(bigInteger);
        BigInteger bigInteger2 = (BigInteger)this.array.get(n);
        return bigInteger2;
    }

    public double maximumDifference() {
        return this.getMaximumDifference_as_double();
    }

    public double maximumDifference_as_double() {
        return this.getMaximumDifference_as_double();
    }

    public double getMaximumDifference() {
        return this.getMaximumDifference_as_double();
    }

    public double getMaximumDifference_as_double() {
        double d = 0.0;
        if (this.type != 0 && this.type != 1) {
            throw new IllegalArgumentException("Maximum difference may only be returned as the same type as the type of the internal array - you are trying to return as double or Double the difference for a " + this.typeName[this.type] + "[] array");
        }
        double d2 = this.getMaximum_as_double();
        double d3 = this.getMinimum_as_double();
        d = d2 - d3;
        return d;
    }

    public Double maximumDifference_as_Double() {
        return this.getMaximumDifference_as_Double();
    }

    public Double getMaximumDifference_as_Double() {
        return new Double(this.getMaximumDifference_as_double());
    }

    public float maximumDifference_as_float() {
        return this.getMaximumDifference_as_float();
    }

    public float getMaximumDifference_as_float() {
        float f = 0.0f;
        if (this.type != 2 && this.type != 3) {
            throw new IllegalArgumentException("Maximum difference may only be returned as the same type as the type of the internal array - you are trying to return as float or Float the difference for a " + this.typeName[this.type] + "[] array");
        }
        float f2 = this.getMaximum_as_float();
        float f3 = this.getMinimum_as_float();
        f = f2 - f3;
        return f;
    }

    public Float maximumDifference_as_Float() {
        return this.getMaximumDifference_as_Float();
    }

    public Float getMaximumDifference_as_Float() {
        return new Float(this.getMaximumDifference_as_float());
    }

    public long maximumDifference_as_long() {
        return this.getMaximumDifference_as_long();
    }

    public long getMaximumDifference_as_long() {
        long l = 0L;
        if (this.type != 4 && this.type != 5) {
            throw new IllegalArgumentException("Maximum difference may only be returned as the same type as the type of the internal array - you are trying to return as long or Long the difference for a " + this.typeName[this.type] + "[] array");
        }
        long l2 = this.getMaximum_as_long();
        long l3 = this.getMinimum_as_long();
        l = l2 - l3;
        return l;
    }

    public Long maximumDifference_as_Long() {
        return this.getMaximumDifference_as_Long();
    }

    public Long getMaximumDifference_as_Long() {
        return new Long(this.getMaximumDifference_as_long());
    }

    public int maximumDifference_as_int() {
        return this.getMaximumDifference_as_int();
    }

    public int getMaximumDifference_as_int() {
        int n = 0;
        if (this.type != 6 && this.type != 7) {
            throw new IllegalArgumentException("Maximum difference may only be returned as the same type as the type of the internal array - you are trying to return as int or Integer the difference for a " + this.typeName[this.type] + "[] array");
        }
        int n2 = this.getMaximum_as_int();
        int n3 = this.getMinimum_as_int();
        n = n2 - n3;
        return n;
    }

    public Integer maximumDifference_as_Integer() {
        return this.getMaximumDifference_as_Integer();
    }

    public Integer getMaximumDifference_as_Integer() {
        return new Integer(this.getMaximumDifference_as_int());
    }

    public short maximumDifference_as_short() {
        return this.getMaximumDifference_as_short();
    }

    public short getMaximumDifference_as_short() {
        short s = 0;
        if (this.type != 8 && this.type != 9) {
            throw new IllegalArgumentException("Maximum difference may only be returned as the same type as the type of the internal array - you are trying to return as short or Short the difference for a " + this.typeName[this.type] + "[] array");
        }
        short s2 = this.getMaximum_as_short();
        short s3 = this.getMinimum_as_short();
        s = (short)(s2 - s3);
        return s;
    }

    public Short maximumDifference_as_Short() {
        return this.getMaximumDifference_as_Short();
    }

    public Short getMaximumDifference_as_Short() {
        return new Short(this.getMaximumDifference_as_short());
    }

    public byte maximumDifference_as_byte() {
        return this.getMaximumDifference_as_byte();
    }

    public byte getMaximumDifference_as_byte() {
        byte by = 0;
        if (this.type != 10 && this.type != 11) {
            throw new IllegalArgumentException("Maximum difference may only be returned as the same type as the type of the internal array - you are trying to return as byte or Byte the difference for a " + this.typeName[this.type] + "[] array");
        }
        byte by2 = this.getMaximum_as_byte();
        byte by3 = this.getMinimum_as_byte();
        by = (byte)(by2 - by3);
        return by;
    }

    public Byte maximumDifference_as_Byte() {
        return this.getMaximumDifference_as_Byte();
    }

    public Byte getMaximumDifference_as_Byte() {
        return new Byte(this.getMaximumDifference_as_byte());
    }

    public BigDecimal maximumDifference_as_BigDecimal() {
        return this.getMaximumDifference_as_BigDecimal();
    }

    public BigDecimal getMaximumDifference_as_BigDecimal() {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        if (this.type != 12) {
            throw new IllegalArgumentException("Maximum difference may only be returned as the same type as the type of the internal array - you are trying to return as BigDecimal the difference for a " + this.typeName[this.type] + "[] array");
        }
        BigDecimal bigDecimal2 = this.getMaximum_as_BigDecimal();
        BigDecimal bigDecimal3 = this.getMinimum_as_BigDecimal();
        bigDecimal = bigDecimal2.subtract(bigDecimal3);
        bigDecimal2 = null;
        bigDecimal3 = null;
        return bigDecimal;
    }

    public BigInteger maximumDifference_as_BigInteger() {
        return this.getMaximumDifference_as_BigInteger();
    }

    public BigInteger getMaximumDifference_as_BigInteger() {
        BigInteger bigInteger = BigInteger.ZERO;
        if (this.type != 13) {
            throw new IllegalArgumentException("Maximum difference may only be returned as the same type as the type of the internal array - you are trying to return as BigInteger the difference for a " + this.typeName[this.type] + "[] array");
        }
        BigInteger bigInteger2 = this.getMaximum_as_BigInteger();
        BigInteger bigInteger3 = this.getMinimum_as_BigInteger();
        bigInteger = bigInteger2.subtract(bigInteger3);
        bigInteger2 = null;
        bigInteger3 = null;
        return bigInteger;
    }

    public double minimumDifference() {
        return this.getMinimumDifference_as_double();
    }

    public double minimumDifference_as_double() {
        return this.getMinimumDifference_as_double();
    }

    public double getMinimumDifference() {
        return this.getMinimumDifference_as_double();
    }

    public double getMinimumDifference_as_double() {
        double d = 0.0;
        if (this.type == 0 || this.type == 1) {
            ArrayMaths arrayMaths = this.sort();
            double[] dArray = arrayMaths.getArray_as_double();
            double d2 = d = dArray[1] - dArray[0];
            for (int j = 1; j < this.length - 1; ++j) {
                d = dArray[j + 1] - dArray[j];
                if (!(d < d2)) continue;
                d2 = d;
            }
        } else {
            throw new IllegalArgumentException("Minimum difference may only be returned as the same type as the type of the internal array - you are trying to return as double or Double the difference for a " + this.typeName[this.type] + "[] array");
        }
        return d;
    }

    public Double minimumDifference_as_Double() {
        return this.getMinimumDifference_as_Double();
    }

    public Double getMinimumDifference_as_Double() {
        return new Double(this.getMinimumDifference_as_double());
    }

    public float minimumDifference_as_float() {
        return this.getMinimumDifference_as_float();
    }

    public float getMinimumDifference_as_float() {
        float f = 0.0f;
        if (this.type == 2 || this.type == 3) {
            ArrayMaths arrayMaths = this.sort();
            float[] fArray = arrayMaths.getArray_as_float();
            float f2 = f = fArray[1] - fArray[0];
            for (int j = 1; j < this.length - 1; ++j) {
                f = fArray[j + 1] - fArray[j];
                if (!(f < f2)) continue;
                f2 = f;
            }
        } else {
            throw new IllegalArgumentException("Minimum difference may only be returned as the same type as the type of the internal array - you are trying to return as float or Float the difference for a " + this.typeName[this.type] + "[] array");
        }
        return f;
    }

    public Float minimumDifference_as_Float() {
        return this.getMinimumDifference_as_Float();
    }

    public Float getMinimumDifference_as_Float() {
        return new Float(this.getMinimumDifference_as_float());
    }

    public long minimumDifference_as_long() {
        return this.getMinimumDifference_as_long();
    }

    public long getMinimumDifference_as_long() {
        long l = 0L;
        if (this.type == 4 || this.type == 5) {
            ArrayMaths arrayMaths = this.sort();
            long[] lArray = arrayMaths.getArray_as_long();
            long l2 = l = lArray[1] - lArray[0];
            for (int j = 1; j < this.length - 1; ++j) {
                l = lArray[j + 1] - lArray[j];
                if (l >= l2) continue;
                l2 = l;
            }
        } else {
            throw new IllegalArgumentException("Minimum difference may only be returned as the same type as the type of the internal array - you are trying to return as long or Long the difference for a " + this.typeName[this.type] + "[] array");
        }
        return l;
    }

    public Long minimumDifference_as_Long() {
        return this.getMinimumDifference_as_Long();
    }

    public Long getMinimumDifference_as_Long() {
        return new Long(this.getMinimumDifference_as_long());
    }

    public int minimumDifference_as_int() {
        return this.getMinimumDifference_as_int();
    }

    public int getMinimumDifference_as_int() {
        int n = 0;
        if (this.type == 6 || this.type == 7) {
            ArrayMaths arrayMaths = this.sort();
            int[] nArray = arrayMaths.getArray_as_int();
            int n2 = n = nArray[1] - nArray[0];
            for (int j = 1; j < this.length - 1; ++j) {
                n = nArray[j + 1] - nArray[j];
                if (n >= n2) continue;
                n2 = n;
            }
        } else {
            throw new IllegalArgumentException("Minimum difference may only be returned as the same type as the type of the internal array - you are trying to return as int or Integer the difference for a " + this.typeName[this.type] + "[] array");
        }
        return n;
    }

    public Integer minimumDifference_as_Integer() {
        return this.getMinimumDifference_as_Integer();
    }

    public Integer getMinimumDifference_as_Integer() {
        return new Integer(this.getMinimumDifference_as_int());
    }

    public short minimumDifference_as_short() {
        return this.getMinimumDifference_as_short();
    }

    public short getMinimumDifference_as_short() {
        short s = 0;
        if (this.type == 8 || this.type == 9) {
            ArrayMaths arrayMaths = this.sort();
            short[] sArray = arrayMaths.getArray_as_short();
            short s2 = s = (short)(sArray[1] - sArray[0]);
            for (int j = 1; j < this.length - 1; ++j) {
                s = (short)(sArray[j + 1] - sArray[j]);
                if (s >= s2) continue;
                s2 = s;
            }
        } else {
            throw new IllegalArgumentException("Minimum difference may only be returned as the same type as the type of the internal array - you are trying to return as short or Short the difference for a " + this.typeName[this.type] + "[] array");
        }
        return s;
    }

    public Short minimumDifference_as_Short() {
        return this.getMinimumDifference_as_Short();
    }

    public Short getMinimumDifference_as_Short() {
        return new Short(this.getMinimumDifference_as_short());
    }

    public byte minimumDifference_as_byte() {
        return this.getMinimumDifference_as_byte();
    }

    public byte getMinimumDifference_as_byte() {
        byte by = 0;
        if (this.type == 10 || this.type == 11) {
            ArrayMaths arrayMaths = this.sort();
            byte[] byArray = arrayMaths.getArray_as_byte();
            byte by2 = by = (byte)(byArray[1] - byArray[0]);
            for (int j = 1; j < this.length - 1; ++j) {
                by = (byte)(byArray[j + 1] - byArray[j]);
                if (by >= by2) continue;
                by2 = by;
            }
        } else {
            throw new IllegalArgumentException("Minimum difference may only be returned as the same type as the type of the internal array - you are trying to return as byte or Byte the difference for a " + this.typeName[this.type] + "[] array");
        }
        return by;
    }

    public Byte minimumDifference_as_Byte() {
        return this.getMinimumDifference_as_Byte();
    }

    public Byte getMinimumDifference_as_Byte() {
        return new Byte(this.getMinimumDifference_as_byte());
    }

    public BigDecimal minimumDifference_as_BigDecimal() {
        return this.getMinimumDifference_as_BigDecimal();
    }

    public BigDecimal getMinimumDifference_as_BigDecimal() {
        BigDecimal bigDecimal;
        BigDecimal[] bigDecimalArray;
        BigDecimal bigDecimal2 = BigDecimal.ZERO;
        if (this.type == 12) {
            ArrayMaths arrayMaths = this.sort();
            bigDecimalArray = arrayMaths.getArray_as_BigDecimal();
            bigDecimal = bigDecimal2 = bigDecimalArray[1].subtract(bigDecimalArray[0]);
            for (int j = 1; j < this.length - 1; ++j) {
                bigDecimal2 = bigDecimalArray[j + 1].subtract(bigDecimalArray[j]);
                if (bigDecimal2.compareTo(bigDecimal) != -1) continue;
                bigDecimal = bigDecimal2;
            }
        } else {
            throw new IllegalArgumentException("Minimum difference may only be returned as the same type as the type of the internal array - you are trying to return as BigDecimal the difference for a " + this.typeName[this.type] + "[] array");
        }
        bigDecimalArray = null;
        bigDecimal = null;
        return bigDecimal2;
    }

    public BigInteger minimumDifference_as_BigInteger() {
        return this.getMinimumDifference_as_BigInteger();
    }

    public BigInteger getMinimumDifference_as_BigInteger() {
        BigInteger bigInteger;
        BigInteger[] bigIntegerArray;
        BigInteger bigInteger2 = BigInteger.ZERO;
        if (this.type == 12) {
            ArrayMaths arrayMaths = this.sort();
            bigIntegerArray = arrayMaths.getArray_as_BigInteger();
            bigInteger = bigInteger2 = bigIntegerArray[1].subtract(bigIntegerArray[0]);
            for (int j = 1; j < this.length - 1; ++j) {
                bigInteger2 = bigIntegerArray[j + 1].subtract(bigIntegerArray[j]);
                if (bigInteger2.compareTo(bigInteger) != -1) continue;
                bigInteger = bigInteger2;
            }
        } else {
            throw new IllegalArgumentException("Minimum difference may only be returned as the same type as the type of the internal array - you are trying to return as BigInteger the difference for a " + this.typeName[this.type] + "[] array");
        }
        bigIntegerArray = null;
        bigInteger = null;
        return bigInteger2;
    }

    public void print() {
        switch (this.type) {
            case 0: 
            case 1: {
                Double[] doubleArray = this.getArray_as_Double();
                PrintToScreen.print(doubleArray);
                break;
            }
            case 2: 
            case 3: {
                Float[] floatArray = this.getArray_as_Float();
                PrintToScreen.print(floatArray);
                break;
            }
            case 4: 
            case 5: {
                Long[] longArray = this.getArray_as_Long();
                PrintToScreen.print(longArray);
                break;
            }
            case 6: 
            case 7: {
                Integer[] integerArray = this.getArray_as_Integer();
                PrintToScreen.print(integerArray);
                break;
            }
            case 8: 
            case 9: {
                Short[] shortArray = this.getArray_as_Short();
                PrintToScreen.print(shortArray);
                break;
            }
            case 10: 
            case 11: {
                Byte[] byteArray = this.getArray_as_Byte();
                PrintToScreen.print(byteArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                PrintToScreen.print(bigDecimalArray);
                bigDecimalArray = null;
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
                PrintToScreen.print(bigIntegerArray);
                bigIntegerArray = null;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                PrintToScreen.print(complexArray);
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                PrintToScreen.print(phasorArray);
                break;
            }
            case 16: 
            case 17: {
                Character[] characterArray = this.getArray_as_Character();
                PrintToScreen.print(characterArray);
                break;
            }
            case 18: {
                String[] stringArray = this.getArray_as_String();
                PrintToScreen.print(stringArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
    }

    public void println() {
        switch (this.type) {
            case 0: 
            case 1: {
                Double[] doubleArray = this.getArray_as_Double();
                PrintToScreen.println(doubleArray);
                break;
            }
            case 2: 
            case 3: {
                Float[] floatArray = this.getArray_as_Float();
                PrintToScreen.println(floatArray);
                break;
            }
            case 4: 
            case 5: {
                Long[] longArray = this.getArray_as_Long();
                PrintToScreen.println(longArray);
                break;
            }
            case 6: 
            case 7: {
                Integer[] integerArray = this.getArray_as_Integer();
                PrintToScreen.println(integerArray);
                break;
            }
            case 8: 
            case 9: {
                Short[] shortArray = this.getArray_as_Short();
                PrintToScreen.println(shortArray);
                break;
            }
            case 10: 
            case 11: {
                Byte[] byteArray = this.getArray_as_Byte();
                PrintToScreen.println(byteArray);
                break;
            }
            case 12: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                PrintToScreen.println(bigDecimalArray);
                bigDecimalArray = null;
                break;
            }
            case 13: {
                BigInteger[] bigIntegerArray = this.getArray_as_BigInteger();
                PrintToScreen.println(bigIntegerArray);
                bigIntegerArray = null;
                break;
            }
            case 14: {
                Complex[] complexArray = this.getArray_as_Complex();
                PrintToScreen.println(complexArray);
                break;
            }
            case 15: {
                Phasor[] phasorArray = this.getArray_as_Phasor();
                PrintToScreen.println(phasorArray);
                break;
            }
            case 16: 
            case 17: {
                Character[] characterArray = this.getArray_as_Character();
                PrintToScreen.println(characterArray);
                break;
            }
            case 18: {
                String[] stringArray = this.getArray_as_String();
                PrintToScreen.println(stringArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type not identified by this method");
            }
        }
    }

    public void convertToHighest() {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                Double[] doubleArray = this.getArray_as_Double();
                this.array.clear();
                for (int j = 0; j < this.length; ++j) {
                    this.array.add(doubleArray[j]);
                }
                this.type = 1;
                break;
            }
            case 12: 
            case 13: {
                BigDecimal[] bigDecimalArray = this.getArray_as_BigDecimal();
                this.array.clear();
                for (int j = 0; j < this.length; ++j) {
                    this.array.add(bigDecimalArray[j]);
                }
                this.type = 12;
                bigDecimalArray = null;
                break;
            }
            case 14: 
            case 15: {
                Complex[] complexArray = this.getArray_as_Complex();
                this.array.clear();
                for (int j = 0; j < this.length; ++j) {
                    this.array.add(complexArray[j]);
                }
                this.type = 14;
            }
        }
    }

    public void plot(int n) {
        if (n > 2) {
            throw new IllegalArgumentException("Argument n, " + n + ", must be less than 3");
        }
        double[] dArray = new double[this.length];
        for (int j = 0; j < this.length; ++j) {
            dArray[j] = j;
        }
        double[] dArray2 = this.getArray_as_double();
        PlotGraph plotGraph = new PlotGraph(dArray, dArray2);
        plotGraph.setGraphTitle("ArrayMaths plot method");
        plotGraph.setXaxisLegend("Array element index");
        plotGraph.setYaxisLegend("Array element value");
        plotGraph.setPoint(1);
        switch (n) {
            case 0: {
                plotGraph.setLine(0);
                plotGraph.setGraphTitle2("Points only - no line");
                break;
            }
            case 1: {
                plotGraph.setLine(3);
                plotGraph.setGraphTitle2("Points joined by straight lines");
                break;
            }
            case 2: {
                plotGraph.setLine(1);
                plotGraph.setGraphTitle2("Points joined by cubic spline interpolated line");
                break;
            }
            default: {
                throw new IllegalArgumentException("Should not be possible to get here!!!");
            }
        }
        plotGraph.plot();
    }

    static {
        integers.put(Integer.class, BigDecimal.valueOf(Integer.MAX_VALUE));
        integers.put(Long.class, BigDecimal.valueOf(Long.MAX_VALUE));
        integers.put(Byte.class, BigDecimal.valueOf(127L));
        integers.put(Short.class, BigDecimal.valueOf(32767L));
        integers.put(BigInteger.class, BigDecimal.valueOf(-1L));
    }
}

