/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.analysis.ErrorProp;
import flanagan.circuits.Phasor;
import flanagan.complex.Complex;
import flanagan.complex.ComplexErrorProp;
import flanagan.complex.ComplexPoly;
import flanagan.io.DialogueBox;
import flanagan.math.Fmath;
import flanagan.math.Polynomial;
import flanagan.math.TimeAndDate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Conv {
    private static double max_float_as_double = 3.4028234663852886E38;
    private static double max_long_as_double = 9.223372036854776E18;
    private static double max_long_as_float = 9.223372036854776E18;
    private static double max_int_as_double = 2.147483647E9;
    private static double max_int_as_float = 2.147483648E9;
    private static double max_int_as_long = 2.147483647E9;
    private static double max_short_as_double = 32767.0;
    private static double max_short_as_long = 32767.0;
    private static double max_short_as_float = 32767.0;
    private static double max_short_as_int = 32767.0;
    private static double max_byte_as_double = 127.0;
    private static double max_byte_as_float = 127.0;
    private static double max_byte_as_long = 127.0;
    private static double max_byte_as_int = 127.0;
    private static double max_byte_as_short = 127.0;
    private static boolean suppressMessage = false;
    private static boolean suppressMessageAM = false;

    public static void suppressMessages() {
        suppressMessage = true;
    }

    public static void restoreMessages() {
        if (!suppressMessageAM) {
            suppressMessage = false;
        }
    }

    public static void suppressMessagesAM() {
        suppressMessageAM = true;
    }

    public static void restoreMessagesAM() {
        suppressMessageAM = false;
    }

    public static double[] ArrayList_to_doubles(ArrayList arrayList) {
        return Conv.convert_ArrayList_to_doubles(arrayList);
    }

    public static double[] convert_ArrayList_to_doubles(ArrayList arrayList) {
        double[] dArray = null;
        if (arrayList != null) {
            int n = arrayList.size();
            dArray = new double[n];
            for (int j = 0; j < n; ++j) {
                Object e = arrayList.get(j);
                if (e instanceof Double) {
                    dArray[j] = (Double)e;
                    continue;
                }
                if (e instanceof Float) {
                    dArray[j] = ((Float)e).floatValue();
                    continue;
                }
                if (e instanceof Long) {
                    dArray[j] = ((Long)e).longValue();
                    continue;
                }
                if (e instanceof Integer) {
                    dArray[j] = ((Integer)e).intValue();
                    continue;
                }
                if (e instanceof Short) {
                    dArray[j] = ((Short)e).shortValue();
                    continue;
                }
                if (e instanceof Byte) {
                    dArray[j] = ((Byte)e).byteValue();
                    continue;
                }
                if (e instanceof BigDecimal) {
                    dArray[j] = ((BigDecimal)e).doubleValue();
                    continue;
                }
                if (e instanceof BigInteger) {
                    dArray[j] = ((BigInteger)e).doubleValue();
                    continue;
                }
                throw new IllegalArgumentException("Element " + j + " is not convertible to double");
            }
        }
        return dArray;
    }

    public static long[] ArrayList_to_longs(ArrayList arrayList) {
        return Conv.convert_ArrayList_to_longs(arrayList);
    }

    public static long[] convert_ArrayList_to_longs(ArrayList arrayList) {
        long[] lArray = null;
        if (arrayList != null) {
            int n = arrayList.size();
            lArray = new long[n];
            for (int j = 0; j < n; ++j) {
                Object e = arrayList.get(j);
                if (e instanceof Double) {
                    lArray[j] = (long)((Double)e).doubleValue();
                    continue;
                }
                if (e instanceof Float) {
                    lArray[j] = (long)((Float)e).floatValue();
                    continue;
                }
                if (e instanceof Long) {
                    lArray[j] = (Long)e;
                    continue;
                }
                if (e instanceof Integer) {
                    lArray[j] = ((Integer)e).intValue();
                    continue;
                }
                if (e instanceof Short) {
                    lArray[j] = ((Short)e).shortValue();
                    continue;
                }
                if (e instanceof Byte) {
                    lArray[j] = ((Byte)e).byteValue();
                    continue;
                }
                if (e instanceof BigDecimal) {
                    lArray[j] = ((BigDecimal)e).longValue();
                    continue;
                }
                if (e instanceof BigInteger) {
                    lArray[j] = ((BigInteger)e).longValue();
                    continue;
                }
                throw new IllegalArgumentException("Element " + j + " is not convertible to double");
            }
        }
        return lArray;
    }

    public static int[] ArrayList_to_ints(ArrayList arrayList) {
        return Conv.convert_ArrayList_to_ints(arrayList);
    }

    public static int[] convert_ArrayList_to_ints(ArrayList arrayList) {
        int[] nArray = null;
        if (arrayList != null) {
            int n = arrayList.size();
            nArray = new int[n];
            for (int j = 0; j < n; ++j) {
                Object e = arrayList.get(j);
                if (e instanceof Double) {
                    nArray[j] = (int)((Double)e).doubleValue();
                    continue;
                }
                if (e instanceof Float) {
                    nArray[j] = (int)((Float)e).floatValue();
                    continue;
                }
                if (e instanceof Long) {
                    nArray[j] = (int)((Long)e).longValue();
                    continue;
                }
                if (e instanceof Integer) {
                    nArray[j] = (Integer)e;
                    continue;
                }
                if (e instanceof Short) {
                    nArray[j] = ((Short)e).shortValue();
                    continue;
                }
                if (e instanceof Byte) {
                    nArray[j] = ((Byte)e).byteValue();
                    continue;
                }
                if (e instanceof BigDecimal) {
                    nArray[j] = ((BigDecimal)e).intValue();
                    continue;
                }
                if (e instanceof BigInteger) {
                    nArray[j] = ((BigInteger)e).intValue();
                    continue;
                }
                throw new IllegalArgumentException("Element " + j + " is not convertible to double");
            }
        }
        return nArray;
    }

    public static Double convert_double_to_Double(double d) {
        return new Double(d);
    }

    public static double convert_Double_to_double(Double d) {
        return d;
    }

    public static float convert_double_to_float(double d) {
        if (d > max_float_as_double) {
            throw new IllegalArgumentException("double is too large to be recast as float");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_double_to_float: possible loss of precision");
        }
        return new Double(d).floatValue();
    }

    public static Float convert_double_to_Float(double d) {
        if (d > max_float_as_double) {
            throw new IllegalArgumentException("double is too large to be recast as float");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_double_to_Float: possible loss of precision");
        }
        return new Float(new Double(d).floatValue());
    }

    public static float convert_Double_to_float(Double d) {
        double d2 = d;
        if (d2 > max_float_as_double) {
            throw new IllegalArgumentException("Double is too large to be recast as float");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_Double_to_float: possible loss of precision");
        }
        return d.floatValue();
    }

    public static Float convert_Double_to_Float(Double d) {
        double d2 = d;
        if (d2 > max_float_as_double) {
            throw new IllegalArgumentException("Double is too large to be recast as Float");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_Double_to_Float: possible loss of precision");
        }
        return new Float(d2);
    }

    public static long convert_double_to_long(double d) {
        if (d > max_long_as_double) {
            throw new IllegalArgumentException("double is too large to be recast as long");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new Double(d).longValue();
    }

    public static Long convert_double_to_Long(double d) {
        if (d > max_long_as_double) {
            throw new IllegalArgumentException("double is too large to be recast as long");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new Long(new Double(d).longValue());
    }

    public static long convert_Double_to_long(Double d) {
        double d2 = d;
        if (d2 > max_long_as_double) {
            throw new IllegalArgumentException("Double is too large to be recast as long");
        }
        if (!Fmath.isInteger(d2)) {
            throw new IllegalArgumentException("Double is not, arithmetically, an integer");
        }
        return d.longValue();
    }

    public static Long convert_Double_to_Long(Double d) {
        double d2 = d;
        if (d2 > max_long_as_double) {
            throw new IllegalArgumentException("Double is too large to be recast as Long");
        }
        if (!Fmath.isInteger(d2)) {
            throw new IllegalArgumentException("Double is not, arithmetically, an integer");
        }
        return new Long(d.longValue());
    }

    public static int convert_double_to_int(double d) {
        if (d > max_int_as_double) {
            throw new IllegalArgumentException("double is too large to be recast as int");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new Double(d).intValue();
    }

    public static Integer convert_double_to_Integer(double d) {
        if (d > max_int_as_double) {
            throw new IllegalArgumentException("double is too large to be recast as int");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new Integer(new Double(d).intValue());
    }

    public static int convert_Double_to_int(Double d) {
        double d2 = d;
        if (d2 > max_int_as_double) {
            throw new IllegalArgumentException("Double is too large to be recast as int");
        }
        if (!Fmath.isInteger(d2)) {
            throw new IllegalArgumentException("Double is not, arithmetically, an integer");
        }
        return d.intValue();
    }

    public static Integer convert_Double_to_Integer(Double d) {
        double d2 = d;
        if (d2 > max_int_as_double) {
            throw new IllegalArgumentException("Double is too large to be recast as Integer");
        }
        if (!Fmath.isInteger(d2)) {
            throw new IllegalArgumentException("Double is not, arithmetically, an integer");
        }
        return new Integer(d.intValue());
    }

    public static short convert_double_to_short(double d) {
        if (d > max_short_as_double) {
            throw new IllegalArgumentException("double is too large to be recast as short");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new Double(d).shortValue();
    }

    public static Short convert_double_to_Short(double d) {
        if (d > max_short_as_double) {
            throw new IllegalArgumentException("double is too large to be recast as short");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new Short(new Double(d).shortValue());
    }

    public static short convert_Double_to_short(Double d) {
        double d2 = d;
        if (d2 > max_short_as_double) {
            throw new IllegalArgumentException("Double is too large to be recast as short");
        }
        if (!Fmath.isInteger(d2)) {
            throw new IllegalArgumentException("Double is not, arithmetically, an integer");
        }
        return d.shortValue();
    }

    public static Short convert_Double_to_Short(Double d) {
        double d2 = d;
        if (d2 > max_short_as_double) {
            throw new IllegalArgumentException("Double is too large to be recast as Short");
        }
        if (!Fmath.isInteger(d2)) {
            throw new IllegalArgumentException("Double is not, arithmetically, an integer");
        }
        return new Short(d.shortValue());
    }

    public static byte convert_double_to_byte(double d) {
        if (d > max_byte_as_double) {
            throw new IllegalArgumentException("double is too large to be recast as byte");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new Double(d).byteValue();
    }

    public static Byte convert_double_to_Byte(double d) {
        if (d > max_byte_as_double) {
            throw new IllegalArgumentException("double is too large to be recast as byte");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new Byte(new Double(d).byteValue());
    }

    public static byte convert_Double_to_byte(Double d) {
        double d2 = d;
        if (d2 > max_byte_as_double) {
            throw new IllegalArgumentException("Double is too large to be recast as byte");
        }
        if (!Fmath.isInteger(d2)) {
            throw new IllegalArgumentException("Double is not, arithmetically, an integer");
        }
        return d.byteValue();
    }

    public static Byte convert_Double_to_Byte(Double d) {
        double d2 = d;
        if (d2 > max_byte_as_double) {
            throw new IllegalArgumentException("Double is too large to be recast as Byte");
        }
        if (!Fmath.isInteger(d2)) {
            throw new IllegalArgumentException("Double is not, arithmetically, an integer");
        }
        return new Byte(d.byteValue());
    }

    public static BigDecimal convert_double_to_BigDecimal(double d) {
        return new BigDecimal(d);
    }

    public static BigDecimal convert_Double_to_BigDecimal(Double d) {
        return new BigDecimal(d);
    }

    public static BigInteger convert_double_to_BigInteger(double d) {
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new BigInteger(Double.toString(d));
    }

    public static BigInteger convert_Double_to_BigInteger(Double d) {
        double d2 = d;
        if (!Fmath.isInteger(d2)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new BigInteger(Double.toString(d2).trim());
    }

    public static String convert_double_to_String(double d) {
        return Double.toString(d).trim();
    }

    public static String convert_Double_to_String(Double d) {
        return Double.toString(d).trim();
    }

    public static Float convert_float_to_Float(float f) {
        return new Float(f);
    }

    public static float convert_Float_to_float(Float f) {
        return f.floatValue();
    }

    public static double convert_float_to_double(float f) {
        return new Float(f).doubleValue();
    }

    public static Double convert_float_to_Double(float f) {
        return new Double(new Float(f).doubleValue());
    }

    public static double convert_Float_to_double(Float f) {
        return f.doubleValue();
    }

    public static Double convert_Float_to_Double(Float f) {
        return new Double(f.doubleValue());
    }

    public static long convert_float_to_long(float f) {
        if ((double)f > max_long_as_float) {
            throw new IllegalArgumentException("float is too large to be recast as long");
        }
        if (!Fmath.isInteger(f)) {
            throw new IllegalArgumentException("float is not, arithmetically, an integer");
        }
        return new Float(f).longValue();
    }

    public static Long convert_float_to_Long(float f) {
        if ((double)f > max_long_as_float) {
            throw new IllegalArgumentException("float is too large to be recast as long");
        }
        if (!Fmath.isInteger(f)) {
            throw new IllegalArgumentException("float is not, arithmetically, an integer");
        }
        return new Long(new Float(f).longValue());
    }

    public static long convert_Float_to_long(Float f) {
        float f2 = f.floatValue();
        if ((double)f2 > max_long_as_float) {
            throw new IllegalArgumentException("Float is too large to be recast as long");
        }
        if (!Fmath.isInteger(f2)) {
            throw new IllegalArgumentException("Float is not, arithmetically, an integer");
        }
        return f.longValue();
    }

    public static Long convert_Float_to_Long(Float f) {
        float f2 = f.floatValue();
        if ((double)f2 > max_long_as_float) {
            throw new IllegalArgumentException("Float is too large to be recast as Long");
        }
        if (!Fmath.isInteger(f2)) {
            throw new IllegalArgumentException("Float is not, arithmetically, an integer");
        }
        return new Long(f.longValue());
    }

    public static int convert_float_to_int(float f) {
        if ((double)f > max_int_as_float) {
            throw new IllegalArgumentException("double is too large to be recast as int");
        }
        if (!Fmath.isInteger(f)) {
            throw new IllegalArgumentException("double is not, arithmetically, an integer");
        }
        return new Float(f).intValue();
    }

    public static Integer convert_float_to_Integer(float f) {
        if ((double)f > max_int_as_float) {
            throw new IllegalArgumentException("float is too large to be recast as int");
        }
        if (!Fmath.isInteger(f)) {
            throw new IllegalArgumentException("float is not, arithmetically, an integer");
        }
        return new Integer(new Float(f).intValue());
    }

    public static int convert_Float_to_int(Float f) {
        float f2 = f.floatValue();
        if ((double)f2 > max_int_as_float) {
            throw new IllegalArgumentException("Float is too large to be recast as int");
        }
        if (!Fmath.isInteger(f2)) {
            throw new IllegalArgumentException("Float is not, arithmetically, an integer");
        }
        return f.intValue();
    }

    public static Integer convert_Float_to_Integer(Float f) {
        float f2 = f.floatValue();
        if ((double)f2 > max_int_as_float) {
            throw new IllegalArgumentException("Float is too large to be recast as Integer");
        }
        if (!Fmath.isInteger(f2)) {
            throw new IllegalArgumentException("Float is not, arithmetically, an integer");
        }
        return new Integer(f.intValue());
    }

    public static short convert_float_to_short(float f) {
        if ((double)f > max_short_as_float) {
            throw new IllegalArgumentException("float is too large to be recast as short");
        }
        if (!Fmath.isInteger(f)) {
            throw new IllegalArgumentException("float is not, arithmetically, an integer");
        }
        return new Float(f).shortValue();
    }

    public static Short convert_float_to_Short(float f) {
        if ((double)f > max_short_as_float) {
            throw new IllegalArgumentException("float is too large to be recast as short");
        }
        if (!Fmath.isInteger(f)) {
            throw new IllegalArgumentException("float is not, arithmetically, an integer");
        }
        return new Short(new Float(f).shortValue());
    }

    public static short convert_Float_to_short(Float f) {
        float f2 = f.floatValue();
        if ((double)f2 > max_short_as_float) {
            throw new IllegalArgumentException("Float is too large to be recast as short");
        }
        if (!Fmath.isInteger(f2)) {
            throw new IllegalArgumentException("Float is not, arithmetically, an integer");
        }
        return f.shortValue();
    }

    public static Short convert_Float_to_Short(Float f) {
        float f2 = f.floatValue();
        if ((double)f2 > max_short_as_float) {
            throw new IllegalArgumentException("Float is too large to be recast as Short");
        }
        if (!Fmath.isInteger(f2)) {
            throw new IllegalArgumentException("Float is not, arithmetically, an integer");
        }
        return new Short(f.shortValue());
    }

    public static byte convert_float_to_byte(float f) {
        if ((double)f > max_byte_as_float) {
            throw new IllegalArgumentException("float is too large to be recast as byte");
        }
        if (!Fmath.isInteger(f)) {
            throw new IllegalArgumentException("float is not, arithmetically, an integer");
        }
        return new Float(f).byteValue();
    }

    public static Byte convert_float_to_Byte(float f) {
        if ((double)f > max_byte_as_float) {
            throw new IllegalArgumentException("float is too large to be recast as byte");
        }
        if (!Fmath.isInteger(f)) {
            throw new IllegalArgumentException("float is not, arithmetically, an integer");
        }
        return new Byte(new Float(f).byteValue());
    }

    public static byte convert_Float_to_byte(Float f) {
        float f2 = f.floatValue();
        if ((double)f2 > max_byte_as_float) {
            throw new IllegalArgumentException("Float is too large to be recast as byte");
        }
        if (!Fmath.isInteger(f2)) {
            throw new IllegalArgumentException("Float is not, arithmetically, an integer");
        }
        return f.byteValue();
    }

    public static Byte convert_Float_to_Byte(Float f) {
        float f2 = f.floatValue();
        if ((double)f2 > max_byte_as_float) {
            throw new IllegalArgumentException("Float is too large to be recast as Byte");
        }
        if (!Fmath.isInteger(f2)) {
            throw new IllegalArgumentException("Float is not, arithmetically, an integer");
        }
        return new Byte(f.byteValue());
    }

    public static BigDecimal convert_float_to_BigDecimal(float f) {
        return new BigDecimal(f);
    }

    public static BigDecimal convert_Float_to_BigDecimal(Float f) {
        return new BigDecimal(f.doubleValue());
    }

    public static BigInteger convert_double_to_BigInteger(float f) {
        if (!Fmath.isInteger(f)) {
            throw new IllegalArgumentException("float is not, arithmetically, an integer");
        }
        return new BigInteger(Float.toString(f).trim());
    }

    public static BigInteger convert_Float_to_BigInteger(Float f) {
        double d = f.doubleValue();
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("Float is not, arithmetically, an integer");
        }
        return new BigInteger(Double.toString(d).trim());
    }

    public static String convert_float_to_String(float f) {
        return Float.toString(f).trim();
    }

    public static String convert_Float_to_String(Float f) {
        return Float.toString(f.floatValue()).trim();
    }

    public static Long convert_long_to_Long(long l) {
        return new Long(l);
    }

    public static long convert_Long_to_long(Long l) {
        return l;
    }

    public static double convert_long_to_double(long l) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_long_to_double: possible loss of precision");
        }
        return new Long(l).doubleValue();
    }

    public static Double convert_long_to_Double(long l) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_long_to_Double: possible loss of precision");
        }
        return new Double(new Long(l).doubleValue());
    }

    public static double convert_Long_to_double(Long l) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_Long_to_double: possible loss of precision");
        }
        return l.doubleValue();
    }

    public static Double convert_Long_to_Double(Long l) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_Long_to_Double: possible loss of precision");
        }
        return new Double(l.doubleValue());
    }

    public static float convert_long_to_float(long l) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_long_to_float: possible loss of precision");
        }
        return new Long(l).floatValue();
    }

    public static Float convert_long_to_Float(long l) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_long_to_Float: possible loss of precision");
        }
        return new Float(new Long(l).floatValue());
    }

    public static float convert_Long_to_float(Long l) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_Long_to_float: possible loss of precision");
        }
        return l.floatValue();
    }

    public static Float convert_Long_to_Float(Long l) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_Long_to_Float: possible loss of precision");
        }
        return new Float(l.floatValue());
    }

    public static int convert_long_to_int(long l) {
        if ((double)l > max_int_as_long) {
            throw new IllegalArgumentException("long is too large to be recast as int");
        }
        return new Float(l).intValue();
    }

    public static Integer convert_long_to_Integer(long l) {
        if ((double)l > max_int_as_long) {
            throw new IllegalArgumentException("long is too large to be recast as Integer");
        }
        return new Integer(new Long(l).intValue());
    }

    public static int convert_Long_to_int(Long l) {
        long l2 = l;
        if ((double)l2 > max_int_as_long) {
            throw new IllegalArgumentException("Long is too large to be recast as int");
        }
        return l.intValue();
    }

    public static Integer convert_Long_to_Integer(Long l) {
        long l2 = l;
        if ((double)l2 > max_int_as_long) {
            throw new IllegalArgumentException("Long is too large to be recast as Integer");
        }
        return new Integer(l.intValue());
    }

    public static short convert_long_to_short(long l) {
        if ((double)l > max_short_as_long) {
            throw new IllegalArgumentException("long is too large to be recast as short");
        }
        return new Long(l).shortValue();
    }

    public static Short convert_long_to_Short(long l) {
        if ((double)l > max_short_as_long) {
            throw new IllegalArgumentException("long is too large to be recast as Short");
        }
        return new Short(new Long(l).shortValue());
    }

    public static short convert_Long_to_short(Long l) {
        long l2 = l;
        if ((double)l2 > max_short_as_long) {
            throw new IllegalArgumentException("Long is too large to be recast as short");
        }
        return l.shortValue();
    }

    public static Short convert_Long_to_Short(Long l) {
        long l2 = l;
        if ((double)l2 > max_short_as_long) {
            throw new IllegalArgumentException("Long is too large to be recast as Short");
        }
        return new Short(l.shortValue());
    }

    public static byte convert_long_to_byte(long l) {
        if ((double)l > max_byte_as_long) {
            throw new IllegalArgumentException("long is too large to be recast as byte");
        }
        return new Long(l).byteValue();
    }

    public static Byte convert_long_to_Byte(long l) {
        if ((double)l > max_byte_as_long) {
            throw new IllegalArgumentException("long is too large to be recast as Byte");
        }
        return new Byte(new Long(l).byteValue());
    }

    public static byte convert_Long_to_byte(Long l) {
        long l2 = l;
        if ((double)l2 > max_byte_as_long) {
            throw new IllegalArgumentException("Long is too large to be recast as byte");
        }
        return l.byteValue();
    }

    public static Byte convert_Long_to_Byte(Long l) {
        long l2 = l;
        if ((double)l2 > max_byte_as_long) {
            throw new IllegalArgumentException("Long is too large to be recast as Byte");
        }
        return new Byte(l.byteValue());
    }

    public static BigDecimal convert_long_to_BigDecimal(long l) {
        return new BigDecimal(new Long(l).toString());
    }

    public static BigDecimal convert_Long_to_BigDecimal(Long l) {
        return new BigDecimal(l.toString().trim());
    }

    public static BigInteger convert_long_to_BigInteger(long l) {
        return new BigInteger(Long.toString(l).trim());
    }

    public static BigInteger convert_Long_to_BigInteger(Long l) {
        double d = l.doubleValue();
        return new BigInteger(l.toString().trim());
    }

    public static String convert_long_to_String(long l) {
        return Long.toString(l).trim();
    }

    public static String convert_Long_to_String(Long l) {
        return Long.toString(l).trim();
    }

    public static Integer convert_int_to_Integer(int n) {
        return new Integer(n);
    }

    public static int convert_Integer_to_int(Integer n) {
        return n;
    }

    public static double convert_int_to_double(int n) {
        return new Integer(n).doubleValue();
    }

    public static Double convert_int_to_Double(int n) {
        return new Double(new Integer(n).doubleValue());
    }

    public static double convert_Integer_to_double(Integer n) {
        return n.doubleValue();
    }

    public static Double convert_Integer_to_Double(Integer n) {
        return new Double(n.doubleValue());
    }

    public static float convert_int_to_float(int n) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_int_to_float: possible loss of precision");
        }
        return new Integer(n).floatValue();
    }

    public static Float convert_int_to_Float(int n) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_int_to_Float: possible loss of precision");
        }
        return new Float(new Integer(n).floatValue());
    }

    public static float convert_Integer_to_float(Integer n) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_Integer_to_float: possible loss of precision");
        }
        return n.floatValue();
    }

    public static Float convert_Integer_to_Float(Integer n) {
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_Integer_to_Float: possible loss of precision");
        }
        return new Float(n.floatValue());
    }

    public static long convert_int_to_long(int n) {
        return new Integer(n).longValue();
    }

    public static Long convert_int_to_Long(int n) {
        return new Long(new Integer(n).longValue());
    }

    public static long convert_Integer_to_long(Integer n) {
        return n.longValue();
    }

    public static Long convert_Integer_to_Long(Integer n) {
        return new Long(n.longValue());
    }

    public static short convert_int_to_short(int n) {
        if ((double)n > max_short_as_int) {
            throw new IllegalArgumentException("int is too large to be recast as short");
        }
        return new Integer(n).shortValue();
    }

    public static Short convert_int_to_Short(int n) {
        if ((double)n > max_short_as_int) {
            throw new IllegalArgumentException("int is too large to be recast as Short");
        }
        return new Short(new Integer(n).shortValue());
    }

    public static short convert_Integer_to_short(Integer n) {
        int n2 = n;
        if ((double)n2 > max_short_as_int) {
            throw new IllegalArgumentException("Integer is too large to be recast as short");
        }
        return n.shortValue();
    }

    public static Short convert_Integer_to_Short(Integer n) {
        int n2 = n;
        if ((double)n2 > max_short_as_int) {
            throw new IllegalArgumentException("Integer is too large to be recast as Short");
        }
        return new Short(n.shortValue());
    }

    public static byte convert_int_to_byte(int n) {
        if ((double)n > max_byte_as_int) {
            throw new IllegalArgumentException("int is too large to be recast as byte");
        }
        return new Integer(n).byteValue();
    }

    public static Byte convert_int_to_Byte(int n) {
        if ((double)n > max_byte_as_int) {
            throw new IllegalArgumentException("int is too large to be recast as Byte");
        }
        return new Byte(new Integer(n).byteValue());
    }

    public static byte convert_Integer_to_byte(Integer n) {
        int n2 = n;
        if ((double)n2 > max_byte_as_int) {
            throw new IllegalArgumentException("Integer is too large to be recast as byte");
        }
        return n.byteValue();
    }

    public static Byte convert_Integer_to_Byte(Integer n) {
        int n2 = n;
        if ((double)n2 > max_byte_as_int) {
            throw new IllegalArgumentException("Integer is too large to be recast as Byte");
        }
        return new Byte(n.byteValue());
    }

    public static BigDecimal convert_int_to_BigDecimal(int n) {
        return new BigDecimal(new Integer(n).toString());
    }

    public static BigDecimal convert_Integer_to_BigDecimal(Integer n) {
        return new BigDecimal(n.toString().trim());
    }

    public static BigInteger convert_int_to_BigInteger(int n) {
        return new BigInteger(Long.toString(n).trim());
    }

    public static BigInteger convert_Integer_to_BigInteger(Integer n) {
        return new BigInteger(n.toString().trim());
    }

    public static String convert_int_to_String(int n) {
        return Integer.toString(n).trim();
    }

    public static String convert_Integer_to_String(Integer n) {
        return Integer.toString(n).trim();
    }

    public static char convert_int_to_char(int n) {
        return (char)n;
    }

    public static Short convert_short_to_Short(short s) {
        return new Short(s);
    }

    public static short convert_Short_to_short(Short s) {
        return s;
    }

    public static double convert_short_to_double(short s) {
        return new Short(s).doubleValue();
    }

    public static Double convert_short_to_Double(short s) {
        return new Double(new Short(s).doubleValue());
    }

    public static double convert_Short_to_double(Short s) {
        return s.doubleValue();
    }

    public static Double convert_Short_to_Double(Short s) {
        return new Double(s.doubleValue());
    }

    public static float convert_short_to_float(short s) {
        return new Short(s).floatValue();
    }

    public static Float convert_short_to_Float(short s) {
        return new Float(new Short(s).floatValue());
    }

    public static float convert_Short_to_float(Short s) {
        return s.floatValue();
    }

    public static Float convert_Short_to_Float(Short s) {
        return new Float(s.floatValue());
    }

    public static long convert_short_to_long(short s) {
        return new Short(s).longValue();
    }

    public static Long convert_short_to_Long(short s) {
        return new Long(new Short(s).longValue());
    }

    public static long convert_Short_to_long(Short s) {
        return s.longValue();
    }

    public static Long convert_Short_to_Long(Short s) {
        return new Long(s.longValue());
    }

    public static int convert_short_to_int(short s) {
        return new Short(s).intValue();
    }

    public static Integer convert_short_to_Integer(short s) {
        return new Integer(new Short(s).intValue());
    }

    public static int convert_Short_to_int(Short s) {
        return s.intValue();
    }

    public static Integer convert_Short_to_Integer(Short s) {
        return new Integer(s.intValue());
    }

    public static byte convert_short_to_byte(short s) {
        if ((double)s > max_byte_as_short) {
            throw new IllegalArgumentException("short is too large to be recast as byte");
        }
        return new Short(s).byteValue();
    }

    public static Byte convert_short_to_Byte(short s) {
        if ((double)s > max_byte_as_short) {
            throw new IllegalArgumentException("short is too large to be recast as Byte");
        }
        return new Byte(new Short(s).byteValue());
    }

    public static byte convert_Short_to_byte(Short s) {
        short s2 = s;
        if ((double)s2 > max_byte_as_short) {
            throw new IllegalArgumentException("Short is too large to be recast as byte");
        }
        return s.byteValue();
    }

    public static Byte convert_Short_to_Byte(Short s) {
        short s2 = s;
        if ((double)s2 > max_byte_as_short) {
            throw new IllegalArgumentException("Short is too large to be recast as Byte");
        }
        return new Byte(s.byteValue());
    }

    public static BigDecimal convert_short_to_BigDecimal(short s) {
        return new BigDecimal(new Short(s).toString().trim());
    }

    public static BigDecimal convert_Short_to_BigDecimal(Short s) {
        return new BigDecimal(s.toString().trim());
    }

    public static BigInteger convert_short_to_BigInteger(short s) {
        return new BigInteger(Short.toString(s).trim());
    }

    public static BigInteger convert_Short_to_BigInteger(Short s) {
        return new BigInteger(s.toString().trim());
    }

    public static String convert_short_to_String(short s) {
        return Short.toString(s).trim();
    }

    public static String convert_Short_to_String(Short s) {
        return Short.toString(s).trim();
    }

    public static Byte convert_byte_to_Byte(byte by) {
        return new Byte(by);
    }

    public static byte convert_Byte_to_byte(Byte by) {
        return by;
    }

    public static double convert_byte_to_double(byte by) {
        return new Byte(by).doubleValue();
    }

    public static Double convert_byte_to_Double(byte by) {
        return new Double(new Byte(by).doubleValue());
    }

    public static double convert_Byte_to_double(Byte by) {
        return by.doubleValue();
    }

    public static Double convert_Byte_to_Double(Byte by) {
        return new Double(by.doubleValue());
    }

    public static float convert_byte_to_float(byte by) {
        return new Byte(by).floatValue();
    }

    public static Float convert_byte_to_Float(byte by) {
        return new Float(new Byte(by).floatValue());
    }

    public static float convert_Byte_to_float(Byte by) {
        return by.floatValue();
    }

    public static Float convert_Byte_to_Float(Byte by) {
        return new Float(by.floatValue());
    }

    public static long convert_byte_to_long(byte by) {
        return new Byte(by).longValue();
    }

    public static Long convert_byte_to_Long(byte by) {
        return new Long(new Byte(by).longValue());
    }

    public static long convert_Byte_to_long(Byte by) {
        return by.longValue();
    }

    public static Long convert_Byte_to_Long(Byte by) {
        return new Long(by.longValue());
    }

    public static int convert_byte_to_int(byte by) {
        return new Byte(by).intValue();
    }

    public static Integer convert_byte_to_Integer(byte by) {
        return new Integer(new Byte(by).intValue());
    }

    public static int convert_Byte_to_int(Byte by) {
        return by.intValue();
    }

    public static Integer convert_Byte_to_Integer(Byte by) {
        return new Integer(by.intValue());
    }

    public static short convert_byte_to_short(byte by) {
        return new Byte(by).shortValue();
    }

    public static Short convert_byte_to_Short(byte by) {
        return new Short(new Byte(by).shortValue());
    }

    public static short convert_Byte_to_short(Byte by) {
        return by.shortValue();
    }

    public static Short convert_Byte_to_Short(Byte by) {
        return new Short(by.shortValue());
    }

    public static BigDecimal convert_byte_to_BigDecimal(byte by) {
        return new BigDecimal(new Byte(by).toString().trim());
    }

    public static BigDecimal convert_Byte_to_BigDecimal(Byte by) {
        return new BigDecimal(by.toString().trim());
    }

    public static BigInteger convert_byte_to_BigInteger(byte by) {
        return new BigInteger(Byte.toString(by).trim());
    }

    public static BigInteger convert_Byte_to_BigInteger(Byte by) {
        return new BigInteger(by.toString().trim());
    }

    public static String convert_byte_to_String(byte by) {
        return Byte.toString(by).trim();
    }

    public static String convert_Byte_to_String(Byte by) {
        return Byte.toString(by).trim();
    }

    public static double convert_BigDecimal_to_double(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as double");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_BigDecimal_to_double: possible loss of precision");
        }
        return d;
    }

    public static Double convert_BigDecimal_to_Double(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as double");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_BigDecimal_to_double: possible loss of precision");
        }
        return new Double(d);
    }

    public static float convert_BigDecimal_to_float(BigDecimal bigDecimal) {
        float f = bigDecimal.floatValue();
        if (Fmath.isInfinity(f)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as float");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_BigDecimal_to_float: possible loss of precision");
        }
        return f;
    }

    public static Float convert_BigDecimal_to_Float(BigDecimal bigDecimal) {
        float f = bigDecimal.floatValue();
        if (Fmath.isInfinity(f)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as float");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_BigDecimal_to_float: possible loss of precision");
        }
        return new Float(f);
    }

    public static long convert_BigDecimal_to_long(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as long");
        }
        if (d > max_long_as_double) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as long");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("BigDecimal is not, arithmetically, an integer");
        }
        return bigDecimal.longValue();
    }

    public static Long convert_BigDecimal_to_Long(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as Long");
        }
        if (d > max_long_as_double) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as Long");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("BigDecimal is not, arithmetically, an integer");
        }
        return new Long(bigDecimal.longValue());
    }

    public static int convert_BigDecimal_to_int(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as int");
        }
        if (d > max_int_as_double) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as int");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("BigDecimal is not, arithmetically, an integer");
        }
        return bigDecimal.intValue();
    }

    public static Integer convert_BigDecimal_to_Integer(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as Integer");
        }
        if (d > max_int_as_double) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as Integer");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("BigDecimal is not, arithmetically, an integer");
        }
        return new Integer(bigDecimal.intValue());
    }

    public static short convert_BigDecimal_to_short(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as short");
        }
        if (d > max_short_as_double) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as short");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("BigDecimal is not, arithmetically, an integer");
        }
        return bigDecimal.shortValue();
    }

    public static Short convert_BigDecimal_to_Short(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as Short");
        }
        if (d > max_short_as_double) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as Short");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("BigDecimal is not, arithmetically, an integer");
        }
        return new Short(bigDecimal.shortValue());
    }

    public static byte convert_BigDecimal_to_byte(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as byte");
        }
        if (d > max_byte_as_double) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as byte");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("BigDecimal is not, arithmetically, an integer");
        }
        return bigDecimal.byteValue();
    }

    public static Byte convert_BigDecimal_to_Byte(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as Byte");
        }
        if (d > max_byte_as_double) {
            throw new IllegalArgumentException("BigDecimal is too large to be recast as Byte");
        }
        if (!Fmath.isInteger(d)) {
            throw new IllegalArgumentException("BigDecimal is not, arithmetically, an integer");
        }
        return new Byte(bigDecimal.byteValue());
    }

    public static BigInteger convert_BigDecimal_to_BigInteger(BigDecimal bigDecimal) {
        String string = bigDecimal.toString().trim();
        int n = string.indexOf(46);
        int n2 = string.indexOf(69);
        String string2 = null;
        if (n == -1) {
            return bigDecimal.toBigInteger();
        }
        string2 = n2 == -1 ? string.substring(n + 1) : string.substring(n + 1, n2);
        int n3 = string2.length();
        boolean bl = true;
        boolean bl2 = true;
        int n4 = 0;
        while (bl) {
            if (string2.charAt(n4) != '0') {
                bl = false;
                bl2 = false;
                continue;
            }
            if (++n4 != n3) continue;
            bl = false;
        }
        if (bl2) {
            return bigDecimal.toBigInteger();
        }
        throw new IllegalArgumentException("BigDecimal is not, arithmetically, an integer");
    }

    public static String convert_BigDecimal_to_String(BigDecimal bigDecimal) {
        return bigDecimal.toEngineeringString().trim();
    }

    public static double convert_BigInteger_to_double(BigInteger bigInteger) {
        double d = bigInteger.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as double");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_BigInteger_to_double: possible loss of precision");
        }
        return d;
    }

    public static Double convert_BigInteger_to_Double(BigInteger bigInteger) {
        double d = bigInteger.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as double");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_BigInteger_to_double: possible loss of precision");
        }
        return new Double(d);
    }

    public static float convert_BigInteger_to_float(BigInteger bigInteger) {
        float f = bigInteger.floatValue();
        if (Fmath.isInfinity(f)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as float");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_BigInteger_to_float: possible loss of precision");
        }
        return f;
    }

    public static Float convert_BigInteger_to_Float(BigInteger bigInteger) {
        float f = bigInteger.floatValue();
        if (Fmath.isInfinity(f)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as float");
        }
        if (!suppressMessage) {
            System.out.println("Class Conv: method convert_BigInteger_to_float: possible loss of precision");
        }
        return new Float(f);
    }

    public static long convert_BigInteger_to_long(BigInteger bigInteger) {
        double d = bigInteger.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as long");
        }
        if (d > max_long_as_double) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as long");
        }
        return bigInteger.longValue();
    }

    public static Long convert_BigInteger_to_Long(BigInteger bigInteger) {
        double d = bigInteger.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as Long");
        }
        if (d > max_long_as_double) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as Long");
        }
        return new Long(bigInteger.longValue());
    }

    public static int convert_BigInteger_to_int(BigInteger bigInteger) {
        double d = bigInteger.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as int");
        }
        if (d > max_int_as_double) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as int");
        }
        return bigInteger.intValue();
    }

    public static Integer convert_BigInteger_to_Integer(BigInteger bigInteger) {
        double d = bigInteger.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as Integer");
        }
        if (d > max_int_as_double) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as Integer");
        }
        return new Integer(bigInteger.intValue());
    }

    public static short convert_BigInteger_to_short(BigInteger bigInteger) {
        double d = bigInteger.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as short");
        }
        if (d > max_short_as_double) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as short");
        }
        return bigInteger.shortValue();
    }

    public static Short convert_BigInteger_to_Short(BigInteger bigInteger) {
        double d = bigInteger.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as Short");
        }
        if (d > max_short_as_double) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as Short");
        }
        return new Short(bigInteger.shortValue());
    }

    public static byte convert_BigInteger_to_byte(BigInteger bigInteger) {
        double d = bigInteger.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as byte");
        }
        if (d > max_byte_as_double) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as byte");
        }
        return bigInteger.byteValue();
    }

    public static Byte convert_BigInteger_to_Byte(BigInteger bigInteger) {
        double d = bigInteger.doubleValue();
        if (Fmath.isInfinity(d)) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as Byte");
        }
        if (d > max_byte_as_double) {
            throw new IllegalArgumentException("BigInteger is too large to be recast as Byte");
        }
        return new Byte(bigInteger.byteValue());
    }

    public static BigDecimal convert_BigInteger_to_BigDecimal(BigInteger bigInteger) {
        return new BigDecimal(bigInteger);
    }

    public static String convert_BigInteger_to_String(BigInteger bigInteger) {
        return bigInteger.toString().trim();
    }

    public static Phasor convert_Complex_to_Phasor(Complex complex) {
        double d = complex.abs();
        double d2 = complex.argDeg();
        return new Phasor(d, d2);
    }

    public static String convert_Complex_to_String(Complex complex) {
        return complex.toString().trim();
    }

    public static Complex convert_Phasor_to_Complex(Phasor phasor) {
        return phasor.toComplex();
    }

    public static String convert_Phasor_to_String(Phasor phasor) {
        return phasor.toString().trim();
    }

    public static double convert_char_to_double(char c) {
        char c2 = c;
        return Conv.convert_int_to_double(c2);
    }

    public static Double convert_char_to_Double(char c) {
        char c2 = c;
        return Conv.convert_int_to_Double(c2);
    }

    public static double convert_Character_to_double(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return Conv.convert_int_to_double(n);
    }

    public static Double convert_Character_to_Double(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return Conv.convert_int_to_Double(n);
    }

    public static float convert_char_to_float(char c) {
        char c2 = c;
        return Conv.convert_int_to_float(c2);
    }

    public static Float convert_char_to_Float(char c) {
        char c2 = c;
        return Conv.convert_int_to_Float(c2);
    }

    public static float convert_Character_to_float(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return Conv.convert_int_to_float(n);
    }

    public static Float convert_Character_to_Float(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return Conv.convert_int_to_Float(n);
    }

    public static long convert_char_to_long(char c) {
        char c2 = c;
        return Conv.convert_int_to_long(c2);
    }

    public static Long convert_char_to_Long(char c) {
        char c2 = c;
        return Conv.convert_int_to_Long(c2);
    }

    public static long convert_Character_to_long(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return Conv.convert_int_to_long(n);
    }

    public static Long convert_Character_to_Long(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return Conv.convert_int_to_Long(n);
    }

    public static int convert_char_to_int(char c) {
        return c;
    }

    public static Integer convert_char_to_Integer(char c) {
        return new Integer(c);
    }

    public static int convert_Character_to_int(Character c) {
        return Character.getNumericValue(c.charValue());
    }

    public static Integer convert_Character_to_Integer(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return new Integer(n);
    }

    public static short convert_char_to_short(char c) {
        char c2 = c;
        return Conv.convert_int_to_short(c2);
    }

    public static Short convert_char_to_Short(char c) {
        char c2 = c;
        return Conv.convert_int_to_Short(c2);
    }

    public static short convert_Character_to_short(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return Conv.convert_int_to_short(n);
    }

    public static Short convert_Character_to_Short(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return Conv.convert_int_to_Short(n);
    }

    public static byte convert_char_to_byte(char c) {
        char c2 = c;
        return Conv.convert_int_to_byte(c2);
    }

    public static Byte convert_char_to_Byte(char c) {
        char c2 = c;
        return Conv.convert_int_to_Byte(c2);
    }

    public static byte convert_Character_to_byte(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return Conv.convert_int_to_byte(n);
    }

    public static Byte convert_Character_to_Byte(Character c) {
        int n = Character.getNumericValue(c.charValue());
        return Conv.convert_int_to_Byte(n);
    }

    public static String convert_char_to_String(char c) {
        return Character.toString(c).trim();
    }

    public static String convert_Character_to_String(Character c) {
        return c.toString().trim();
    }

    public static Character convert_char_to_Character(char c) {
        return new Character(c);
    }

    public static char convert_Character_to_char(Character c) {
        return c.charValue();
    }

    public static BigDecimal convert_char_to_BigDecimal(char c) {
        return new BigDecimal(Conv.convert_char_to_String(c).trim());
    }

    public static BigDecimal convert_Character_to_BigDecimal(Character c) {
        return new BigDecimal(Conv.convert_Character_to_String(c).trim());
    }

    public static BigInteger convert_char_to_BigInteger(char c) {
        return new BigInteger(Conv.convert_char_to_String(c).trim());
    }

    public static BigInteger convert_Character_to_BigInteger(Character c) {
        return new BigInteger(Conv.convert_char_to_String(c.charValue()).trim());
    }

    public static double convert_String_to_double(String string) {
        return Double.parseDouble(string.trim());
    }

    public static Double convert_String_to_Double(String string) {
        return Double.valueOf(string.trim());
    }

    public static float convert_String_to_float(String string) {
        return Float.parseFloat(string.trim());
    }

    public static Float convert_String_to_Float(String string) {
        return Float.valueOf(string.trim());
    }

    public static long convert_String_to_long(String string) {
        return Long.parseLong(string.trim());
    }

    public static Long convert_String_to_Long(String string) {
        return Long.valueOf(string.trim());
    }

    public static int convert_String_to_int(String string) {
        return Integer.parseInt(string.trim());
    }

    public static Integer convert_String_to_Integer(String string) {
        return Integer.valueOf(string.trim());
    }

    public static short convert_String_to_short(String string) {
        return Short.parseShort(string.trim());
    }

    public static Short convert_String_to_Short(String string) {
        return Short.valueOf(string.trim());
    }

    public static byte convert_String_to_byte(String string) {
        return Byte.parseByte(string.trim());
    }

    public static Byte convert_String_to_Byte(String string) {
        return Byte.valueOf(string.trim());
    }

    public static BigDecimal convert_String_to_BigDecimal(String string) {
        return new BigDecimal(string.trim());
    }

    public static BigInteger convert_String_to_BigInteger(String string) {
        return new BigInteger(string.trim());
    }

    public static String toTitleCase(String string) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = "";
        int n2 = stringTokenizer.countTokens();
        String[] stringArray = new String[n2];
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = stringTokenizer.nextToken();
            nArray2[n] = stringArray[n].length();
            nArray[n] = string.indexOf(stringArray[n]);
            nArray3[n] = nArray[n] + nArray2[n];
            stringArray[n] = stringArray[n].substring(0, 1).toUpperCase() + stringArray[n].substring(1).toLowerCase();
        }
        for (n = 1; n < n2; ++n) {
            nArray4[n - 1] = nArray[n] - nArray3[n - 1];
        }
        nArray4[n2 - 1] = string.length() - nArray3[n2 - 1] - 1;
        if (nArray[0] > 0) {
            for (n = 0; n < nArray[0]; ++n) {
                string2 = string2 + " ";
            }
        }
        for (n = 0; n < n2; ++n) {
            string2 = string2 + stringArray[n];
            for (int j = 0; j < nArray4[n]; ++j) {
                string2 = string2 + " ";
            }
        }
        return string2;
    }

    public static double[] copy(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = dArray[j];
        }
        return dArray2;
    }

    public static float[] copy(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        int n = fArray.length;
        float[] fArray2 = new float[n];
        for (int j = 0; j < n; ++j) {
            fArray2[j] = fArray[j];
        }
        return fArray2;
    }

    public static int[] copy(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        int[] nArray2 = new int[n];
        for (int j = 0; j < n; ++j) {
            nArray2[j] = nArray[j];
        }
        return nArray2;
    }

    public static long[] copy(long[] lArray) {
        if (lArray == null) {
            return null;
        }
        int n = lArray.length;
        long[] lArray2 = new long[n];
        for (int j = 0; j < n; ++j) {
            lArray2[j] = lArray[j];
        }
        return lArray2;
    }

    public static double[][] copy(double[][] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        double[][] dArrayArray = new double[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = dArray[j].length;
            dArrayArray[j] = new double[n2];
            for (int k = 0; k < n2; ++k) {
                dArrayArray[j][k] = dArray[j][k];
            }
        }
        return dArrayArray;
    }

    public static float[][] copy(float[][] fArray) {
        if (fArray == null) {
            return null;
        }
        int n = fArray.length;
        float[][] fArrayArray = new float[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = fArray[j].length;
            fArrayArray[j] = new float[n2];
            for (int k = 0; k < n2; ++k) {
                fArrayArray[j][k] = fArray[j][k];
            }
        }
        return fArrayArray;
    }

    public static int[][] copy(int[][] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        int[][] nArrayArray = new int[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = nArray[j].length;
            nArrayArray[j] = new int[n2];
            for (int k = 0; k < n2; ++k) {
                nArrayArray[j][k] = nArray[j][k];
            }
        }
        return nArrayArray;
    }

    public static long[][] copy(long[][] lArray) {
        if (lArray == null) {
            return null;
        }
        int n = lArray.length;
        long[][] lArrayArray = new long[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = lArray[j].length;
            lArrayArray[j] = new long[n2];
            for (int k = 0; k < n2; ++k) {
                lArrayArray[j][k] = lArray[j][k];
            }
        }
        return lArrayArray;
    }

    public static double[][][] copy(double[][][] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        double[][][] dArrayArray = new double[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = dArray[j].length;
            dArrayArray[j] = new double[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = dArray[j][k].length;
                dArrayArray[j][k] = new double[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    dArrayArray[j][k][i2] = dArray[j][k][i2];
                }
            }
        }
        return dArrayArray;
    }

    public static float[][][] copy(float[][][] fArray) {
        if (fArray == null) {
            return null;
        }
        int n = fArray.length;
        float[][][] fArrayArray = new float[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = fArray[j].length;
            fArrayArray[j] = new float[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = fArray[j][k].length;
                fArrayArray[j][k] = new float[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    fArrayArray[j][k][i2] = fArray[j][k][i2];
                }
            }
        }
        return fArrayArray;
    }

    public static int[][][] copy(int[][][] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        int[][][] nArrayArray = new int[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = nArray[j].length;
            nArrayArray[j] = new int[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = nArray[j][k].length;
                nArrayArray[j][k] = new int[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    nArrayArray[j][k][i2] = nArray[j][k][i2];
                }
            }
        }
        return nArrayArray;
    }

    public static long[][][] copy(long[][][] lArray) {
        if (lArray == null) {
            return null;
        }
        int n = lArray.length;
        long[][][] lArrayArray = new long[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = lArray[j].length;
            lArrayArray[j] = new long[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = lArray[j][k].length;
                lArrayArray[j][k] = new long[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    lArrayArray[j][k][i2] = lArray[j][k][i2];
                }
            }
        }
        return lArrayArray;
    }

    public static double[][][][] copy(double[][][][] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        double[][][][] dArrayArray = new double[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = dArray[j].length;
            dArrayArray[j] = new double[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = dArray[j][k].length;
                dArrayArray[j][k] = new double[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = dArray[j][k][i2].length;
                    dArrayArray[j][k][i2] = new double[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        dArrayArray[j][k][i2][i3] = dArray[j][k][i2][i3];
                    }
                }
            }
        }
        return dArrayArray;
    }

    public static float[][][][] copy(float[][][][] fArray) {
        if (fArray == null) {
            return null;
        }
        int n = fArray.length;
        float[][][][] fArrayArray = new float[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = fArray[j].length;
            fArrayArray[j] = new float[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = fArray[j][k].length;
                fArrayArray[j][k] = new float[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = fArray[j][k][i2].length;
                    fArrayArray[j][k][i2] = new float[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        fArrayArray[j][k][i2][i3] = fArray[j][k][i2][i3];
                    }
                }
            }
        }
        return fArrayArray;
    }

    public static int[][][][] copy(int[][][][] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        int[][][][] nArrayArray = new int[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = nArray[j].length;
            nArrayArray[j] = new int[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = nArray[j][k].length;
                nArrayArray[j][k] = new int[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = nArray[j][k][i2].length;
                    nArrayArray[j][k][i2] = new int[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        nArrayArray[j][k][i2][i3] = nArray[j][k][i2][i3];
                    }
                }
            }
        }
        return nArrayArray;
    }

    public static long[][][][] copy(long[][][][] lArray) {
        if (lArray == null) {
            return null;
        }
        int n = lArray.length;
        long[][][][] lArrayArray = new long[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = lArray[j].length;
            lArrayArray[j] = new long[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = lArray[j][k].length;
                lArrayArray[j][k] = new long[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = lArray[j][k][i2].length;
                    lArrayArray[j][k][i2] = new long[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        lArrayArray[j][k][i2][i3] = lArray[j][k][i2][i3];
                    }
                }
            }
        }
        return lArrayArray;
    }

    public static String[] copy(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int j = 0; j < n; ++j) {
            stringArray2[j] = stringArray[j];
        }
        return stringArray2;
    }

    public static String[][] copy(String[][] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        String[][] stringArray2 = new String[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = stringArray[j].length;
            stringArray2[j] = new String[n2];
            for (int k = 0; k < n2; ++k) {
                stringArray2[j][k] = stringArray[j][k];
            }
        }
        return stringArray2;
    }

    public static String[][][] copy(String[][][] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        String[][][] stringArray2 = new String[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = stringArray[j].length;
            stringArray2[j] = new String[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = stringArray[j][k].length;
                stringArray2[j][k] = new String[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    stringArray2[j][k][i2] = stringArray[j][k][i2];
                }
            }
        }
        return stringArray2;
    }

    public static String[][][][] copy(String[][][][] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        String[][][][] stringArray2 = new String[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = stringArray[j].length;
            stringArray2[j] = new String[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = stringArray[j][k].length;
                stringArray2[j][k] = new String[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = stringArray[j][k][i2].length;
                    stringArray2[j][k][i2] = new String[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        stringArray2[j][k][i2][i3] = stringArray[j][k][i2][i3];
                    }
                }
            }
        }
        return stringArray2;
    }

    public static boolean[] copy(boolean[] blArray) {
        if (blArray == null) {
            return null;
        }
        int n = blArray.length;
        boolean[] blArray2 = new boolean[n];
        for (int j = 0; j < n; ++j) {
            blArray2[j] = blArray[j];
        }
        return blArray2;
    }

    public static boolean[][] copy(boolean[][] blArray) {
        if (blArray == null) {
            return null;
        }
        int n = blArray.length;
        boolean[][] blArrayArray = new boolean[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = blArray[j].length;
            blArrayArray[j] = new boolean[n2];
            for (int k = 0; k < n2; ++k) {
                blArrayArray[j][k] = blArray[j][k];
            }
        }
        return blArrayArray;
    }

    public static boolean[][][] copy(boolean[][][] blArray) {
        if (blArray == null) {
            return null;
        }
        int n = blArray.length;
        boolean[][][] blArrayArray = new boolean[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = blArray[j].length;
            blArrayArray[j] = new boolean[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = blArray[j][k].length;
                blArrayArray[j][k] = new boolean[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    blArrayArray[j][k][i2] = blArray[j][k][i2];
                }
            }
        }
        return blArrayArray;
    }

    public static boolean[][][][] copy(boolean[][][][] blArray) {
        if (blArray == null) {
            return null;
        }
        int n = blArray.length;
        boolean[][][][] blArrayArray = new boolean[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = blArray[j].length;
            blArrayArray[j] = new boolean[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = blArray[j][k].length;
                blArrayArray[j][k] = new boolean[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = blArray[j][k][i2].length;
                    blArrayArray[j][k][i2] = new boolean[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        blArrayArray[j][k][i2][i3] = blArray[j][k][i2][i3];
                    }
                }
            }
        }
        return blArrayArray;
    }

    public static char[] copy(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        int n = cArray.length;
        char[] cArray2 = new char[n];
        for (int j = 0; j < n; ++j) {
            cArray2[j] = cArray[j];
        }
        return cArray2;
    }

    public static char[][] copy(char[][] cArray) {
        if (cArray == null) {
            return null;
        }
        int n = cArray.length;
        char[][] cArrayArray = new char[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = cArray[j].length;
            cArrayArray[j] = new char[n2];
            for (int k = 0; k < n2; ++k) {
                cArrayArray[j][k] = cArray[j][k];
            }
        }
        return cArrayArray;
    }

    public static char[][][] copy(char[][][] cArray) {
        if (cArray == null) {
            return null;
        }
        int n = cArray.length;
        char[][][] cArrayArray = new char[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = cArray[j].length;
            cArrayArray[j] = new char[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = cArray[j][k].length;
                cArrayArray[j][k] = new char[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    cArrayArray[j][k][i2] = cArray[j][k][i2];
                }
            }
        }
        return cArrayArray;
    }

    public static char[][][][] copy(char[][][][] cArray) {
        if (cArray == null) {
            return null;
        }
        int n = cArray.length;
        char[][][][] cArrayArray = new char[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = cArray[j].length;
            cArrayArray[j] = new char[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = cArray[j][k].length;
                cArrayArray[j][k] = new char[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = cArray[j][k][i2].length;
                    cArrayArray[j][k][i2] = new char[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        cArrayArray[j][k][i2][i3] = cArray[j][k][i2][i3];
                    }
                }
            }
        }
        return cArrayArray;
    }

    public static Character[] copy(Character[] characterArray) {
        if (characterArray == null) {
            return null;
        }
        int n = characterArray.length;
        Character[] characterArray2 = new Character[n];
        for (int j = 0; j < n; ++j) {
            characterArray2[j] = characterArray[j];
        }
        return characterArray2;
    }

    public static Character[][] copy(Character[][] characterArray) {
        if (characterArray == null) {
            return null;
        }
        int n = characterArray.length;
        Character[][] characterArray2 = new Character[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = characterArray[j].length;
            characterArray2[j] = new Character[n2];
            for (int k = 0; k < n2; ++k) {
                characterArray2[j][k] = characterArray[j][k];
            }
        }
        return characterArray2;
    }

    public static Character[][][] copy(Character[][][] characterArray) {
        if (characterArray == null) {
            return null;
        }
        int n = characterArray.length;
        Character[][][] characterArray2 = new Character[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = characterArray[j].length;
            characterArray2[j] = new Character[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = characterArray[j][k].length;
                characterArray2[j][k] = new Character[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    characterArray2[j][k][i2] = characterArray[j][k][i2];
                }
            }
        }
        return characterArray2;
    }

    public static Character[][][][] copy(Character[][][][] characterArray) {
        if (characterArray == null) {
            return null;
        }
        int n = characterArray.length;
        Character[][][][] characterArray2 = new Character[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = characterArray[j].length;
            characterArray2[j] = new Character[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = characterArray[j][k].length;
                characterArray2[j][k] = new Character[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = characterArray[j][k][i2].length;
                    characterArray2[j][k][i2] = new Character[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        characterArray2[j][k][i2][i3] = characterArray[j][k][i2][i3];
                    }
                }
            }
        }
        return characterArray2;
    }

    public static Complex[] copy(Complex[] complexArray) {
        if (complexArray == null) {
            return null;
        }
        int n = complexArray.length;
        Complex[] complexArray2 = new Complex[n];
        for (int j = 0; j < n; ++j) {
            complexArray2[j] = complexArray[j].copy();
        }
        return complexArray2;
    }

    public static Complex[][] copy(Complex[][] complexArray) {
        if (complexArray == null) {
            return null;
        }
        int n = complexArray.length;
        Complex[][] complexArray2 = new Complex[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = complexArray[j].length;
            complexArray2[j] = new Complex[n2];
            for (int k = 0; k < n2; ++k) {
                complexArray2[j][k] = complexArray[j][k].copy();
            }
        }
        return complexArray2;
    }

    public static Complex[][][] copy(Complex[][][] complexArray) {
        if (complexArray == null) {
            return null;
        }
        int n = complexArray.length;
        Complex[][][] complexArray2 = new Complex[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = complexArray[j].length;
            complexArray2[j] = new Complex[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = complexArray[j][k].length;
                complexArray2[j][k] = new Complex[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    complexArray2[j][k][i2] = complexArray[j][k][i2].copy();
                }
            }
        }
        return complexArray2;
    }

    public static Complex[][][][] copy(Complex[][][][] complexArray) {
        if (complexArray == null) {
            return null;
        }
        int n = complexArray.length;
        Complex[][][][] complexArray2 = new Complex[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = complexArray[j].length;
            complexArray2[j] = new Complex[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = complexArray[j][k].length;
                complexArray2[j][k] = new Complex[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = complexArray[j][k][i2].length;
                    complexArray2[j][k][i2] = new Complex[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        complexArray2[j][k][i2][i3] = complexArray[j][k][i2][i3].copy();
                    }
                }
            }
        }
        return complexArray2;
    }

    public static ComplexPoly[] copy(ComplexPoly[] complexPolyArray) {
        if (complexPolyArray == null) {
            return null;
        }
        int n = complexPolyArray.length;
        ComplexPoly[] complexPolyArray2 = new ComplexPoly[n];
        for (int j = 0; j < n; ++j) {
            complexPolyArray2[j] = complexPolyArray[j].copy();
        }
        return complexPolyArray2;
    }

    public static ComplexPoly[][] copy(ComplexPoly[][] complexPolyArray) {
        if (complexPolyArray == null) {
            return null;
        }
        int n = complexPolyArray.length;
        ComplexPoly[][] complexPolyArray2 = new ComplexPoly[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = complexPolyArray[j].length;
            complexPolyArray2[j] = new ComplexPoly[n2];
            for (int k = 0; k < n2; ++k) {
                complexPolyArray2[j][k] = complexPolyArray[j][k].copy();
            }
        }
        return complexPolyArray2;
    }

    public static ComplexPoly[][][] copy(ComplexPoly[][][] complexPolyArray) {
        if (complexPolyArray == null) {
            return null;
        }
        int n = complexPolyArray.length;
        ComplexPoly[][][] complexPolyArray2 = new ComplexPoly[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = complexPolyArray[j].length;
            complexPolyArray2[j] = new ComplexPoly[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = complexPolyArray[j][k].length;
                complexPolyArray2[j][k] = new ComplexPoly[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    complexPolyArray2[j][k][i2] = complexPolyArray[j][k][i2].copy();
                }
            }
        }
        return complexPolyArray2;
    }

    public static ComplexPoly[][][][] copy(ComplexPoly[][][][] complexPolyArray) {
        if (complexPolyArray == null) {
            return null;
        }
        int n = complexPolyArray.length;
        ComplexPoly[][][][] complexPolyArray2 = new ComplexPoly[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = complexPolyArray[j].length;
            complexPolyArray2[j] = new ComplexPoly[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = complexPolyArray[j][k].length;
                complexPolyArray2[j][k] = new ComplexPoly[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = complexPolyArray[j][k][i2].length;
                    complexPolyArray2[j][k][i2] = new ComplexPoly[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        complexPolyArray2[j][k][i2][i3] = complexPolyArray[j][k][i2][i3].copy();
                    }
                }
            }
        }
        return complexPolyArray2;
    }

    public static Polynomial[] copy(Polynomial[] polynomialArray) {
        if (polynomialArray == null) {
            return null;
        }
        int n = polynomialArray.length;
        Polynomial[] polynomialArray2 = new Polynomial[n];
        for (int j = 0; j < n; ++j) {
            polynomialArray2[j] = polynomialArray[j].copy();
        }
        return polynomialArray2;
    }

    public static Polynomial[][] copy(Polynomial[][] polynomialArray) {
        if (polynomialArray == null) {
            return null;
        }
        int n = polynomialArray.length;
        Polynomial[][] polynomialArray2 = new Polynomial[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = polynomialArray[j].length;
            polynomialArray2[j] = new Polynomial[n2];
            for (int k = 0; k < n2; ++k) {
                polynomialArray2[j][k] = polynomialArray[j][k].copy();
            }
        }
        return polynomialArray2;
    }

    public static Polynomial[][][] copy(Polynomial[][][] polynomialArray) {
        if (polynomialArray == null) {
            return null;
        }
        int n = polynomialArray.length;
        Polynomial[][][] polynomialArray2 = new Polynomial[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = polynomialArray[j].length;
            polynomialArray2[j] = new Polynomial[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = polynomialArray[j][k].length;
                polynomialArray2[j][k] = new Polynomial[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    polynomialArray2[j][k][i2] = polynomialArray[j][k][i2].copy();
                }
            }
        }
        return polynomialArray2;
    }

    public static Polynomial[][][][] copy(Polynomial[][][][] polynomialArray) {
        if (polynomialArray == null) {
            return null;
        }
        int n = polynomialArray.length;
        Polynomial[][][][] polynomialArray2 = new Polynomial[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = polynomialArray[j].length;
            polynomialArray2[j] = new Polynomial[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = polynomialArray[j][k].length;
                polynomialArray2[j][k] = new Polynomial[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = polynomialArray[j][k][i2].length;
                    polynomialArray2[j][k][i2] = new Polynomial[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        polynomialArray2[j][k][i2][i3] = polynomialArray[j][k][i2][i3].copy();
                    }
                }
            }
        }
        return polynomialArray2;
    }

    public static BigDecimal[] copy(BigDecimal[] bigDecimalArray) {
        if (bigDecimalArray == null) {
            return null;
        }
        int n = bigDecimalArray.length;
        BigDecimal[] bigDecimalArray2 = new BigDecimal[n];
        for (int j = 0; j < n; ++j) {
            bigDecimalArray2[j] = bigDecimalArray[j];
        }
        return bigDecimalArray2;
    }

    public static BigDecimal[][] copy(BigDecimal[][] bigDecimalArray) {
        if (bigDecimalArray == null) {
            return null;
        }
        int n = bigDecimalArray.length;
        BigDecimal[][] bigDecimalArray2 = new BigDecimal[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = bigDecimalArray[j].length;
            bigDecimalArray2[j] = new BigDecimal[n2];
            for (int k = 0; k < n2; ++k) {
                bigDecimalArray2[j][k] = bigDecimalArray[j][k];
            }
        }
        return bigDecimalArray2;
    }

    public static BigDecimal[][][] copy(BigDecimal[][][] bigDecimalArray) {
        if (bigDecimalArray == null) {
            return null;
        }
        int n = bigDecimalArray.length;
        BigDecimal[][][] bigDecimalArray2 = new BigDecimal[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = bigDecimalArray[j].length;
            bigDecimalArray2[j] = new BigDecimal[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = bigDecimalArray[j][k].length;
                bigDecimalArray2[j][k] = new BigDecimal[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    bigDecimalArray2[j][k][i2] = bigDecimalArray[j][k][i2];
                }
            }
        }
        return bigDecimalArray2;
    }

    public static BigDecimal[][][][] copy(BigDecimal[][][][] bigDecimalArray) {
        if (bigDecimalArray == null) {
            return null;
        }
        int n = bigDecimalArray.length;
        BigDecimal[][][][] bigDecimalArray2 = new BigDecimal[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = bigDecimalArray[j].length;
            bigDecimalArray2[j] = new BigDecimal[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = bigDecimalArray[j][k].length;
                bigDecimalArray2[j][k] = new BigDecimal[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = bigDecimalArray[j][k][i2].length;
                    bigDecimalArray2[j][k][i2] = new BigDecimal[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        bigDecimalArray2[j][k][i2][i3] = bigDecimalArray[j][k][i2][i3];
                    }
                }
            }
        }
        return bigDecimalArray2;
    }

    public static BigInteger[] copy(BigInteger[] bigIntegerArray) {
        if (bigIntegerArray == null) {
            return null;
        }
        int n = bigIntegerArray.length;
        BigInteger[] bigIntegerArray2 = new BigInteger[n];
        for (int j = 0; j < n; ++j) {
            bigIntegerArray2[j] = bigIntegerArray[j];
        }
        return bigIntegerArray2;
    }

    public static BigInteger[][] copy(BigInteger[][] bigIntegerArray) {
        if (bigIntegerArray == null) {
            return null;
        }
        int n = bigIntegerArray.length;
        BigInteger[][] bigIntegerArray2 = new BigInteger[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = bigIntegerArray[j].length;
            bigIntegerArray2[j] = new BigInteger[n2];
            for (int k = 0; k < n2; ++k) {
                bigIntegerArray2[j][k] = bigIntegerArray[j][k];
            }
        }
        return bigIntegerArray2;
    }

    public static BigInteger[][][] copy(BigInteger[][][] bigIntegerArray) {
        if (bigIntegerArray == null) {
            return null;
        }
        int n = bigIntegerArray.length;
        BigInteger[][][] bigIntegerArray2 = new BigInteger[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = bigIntegerArray[j].length;
            bigIntegerArray2[j] = new BigInteger[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = bigIntegerArray[j][k].length;
                bigIntegerArray2[j][k] = new BigInteger[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    bigIntegerArray2[j][k][i2] = bigIntegerArray[j][k][i2];
                }
            }
        }
        return bigIntegerArray2;
    }

    public static BigInteger[][][][] copy(BigInteger[][][][] bigIntegerArray) {
        if (bigIntegerArray == null) {
            return null;
        }
        int n = bigIntegerArray.length;
        BigInteger[][][][] bigIntegerArray2 = new BigInteger[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = bigIntegerArray[j].length;
            bigIntegerArray2[j] = new BigInteger[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = bigIntegerArray[j][k].length;
                bigIntegerArray2[j][k] = new BigInteger[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = bigIntegerArray[j][k][i2].length;
                    bigIntegerArray2[j][k][i2] = new BigInteger[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        bigIntegerArray2[j][k][i2][i3] = bigIntegerArray[j][k][i2][i3];
                    }
                }
            }
        }
        return bigIntegerArray2;
    }

    public static ErrorProp[] copy(ErrorProp[] errorPropArray) {
        if (errorPropArray == null) {
            return null;
        }
        int n = errorPropArray.length;
        ErrorProp[] errorPropArray2 = new ErrorProp[n];
        for (int j = 0; j < n; ++j) {
            errorPropArray2[j] = errorPropArray[j].copy();
        }
        return errorPropArray2;
    }

    public static ErrorProp[][] copy(ErrorProp[][] errorPropArray) {
        if (errorPropArray == null) {
            return null;
        }
        int n = errorPropArray.length;
        ErrorProp[][] errorPropArray2 = new ErrorProp[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = errorPropArray[j].length;
            errorPropArray2[j] = new ErrorProp[n2];
            for (int k = 0; k < n2; ++k) {
                errorPropArray2[j][k] = errorPropArray[j][k].copy();
            }
        }
        return errorPropArray2;
    }

    public static ErrorProp[][][] copy(ErrorProp[][][] errorPropArray) {
        if (errorPropArray == null) {
            return null;
        }
        int n = errorPropArray.length;
        ErrorProp[][][] errorPropArray2 = new ErrorProp[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = errorPropArray[j].length;
            errorPropArray2[j] = new ErrorProp[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = errorPropArray[j][k].length;
                errorPropArray2[j][k] = new ErrorProp[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    errorPropArray2[j][k][i2] = errorPropArray[j][k][i2].copy();
                }
            }
        }
        return errorPropArray2;
    }

    public static ErrorProp[][][][] copy(ErrorProp[][][][] errorPropArray) {
        if (errorPropArray == null) {
            return null;
        }
        int n = errorPropArray.length;
        ErrorProp[][][][] errorPropArray2 = new ErrorProp[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = errorPropArray[j].length;
            errorPropArray2[j] = new ErrorProp[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = errorPropArray[j][k].length;
                errorPropArray2[j][k] = new ErrorProp[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = errorPropArray[j][k][i2].length;
                    errorPropArray2[j][k][i2] = new ErrorProp[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        errorPropArray2[j][k][i2][i3] = errorPropArray[j][k][i2][i3].copy();
                    }
                }
            }
        }
        return errorPropArray2;
    }

    public static ComplexErrorProp[] copy(ComplexErrorProp[] complexErrorPropArray) {
        if (complexErrorPropArray == null) {
            return null;
        }
        int n = complexErrorPropArray.length;
        ComplexErrorProp[] complexErrorPropArray2 = new ComplexErrorProp[n];
        for (int j = 0; j < n; ++j) {
            complexErrorPropArray2[j] = complexErrorPropArray[j].copy();
        }
        return complexErrorPropArray2;
    }

    public static ComplexErrorProp[][] copy(ComplexErrorProp[][] complexErrorPropArray) {
        if (complexErrorPropArray == null) {
            return null;
        }
        int n = complexErrorPropArray.length;
        ComplexErrorProp[][] complexErrorPropArray2 = new ComplexErrorProp[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = complexErrorPropArray[j].length;
            complexErrorPropArray2[j] = new ComplexErrorProp[n2];
            for (int k = 0; k < n2; ++k) {
                complexErrorPropArray2[j][k] = complexErrorPropArray[j][k].copy();
            }
        }
        return complexErrorPropArray2;
    }

    public static ComplexErrorProp[][][] copy(ComplexErrorProp[][][] complexErrorPropArray) {
        if (complexErrorPropArray == null) {
            return null;
        }
        int n = complexErrorPropArray.length;
        ComplexErrorProp[][][] complexErrorPropArray2 = new ComplexErrorProp[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = complexErrorPropArray[j].length;
            complexErrorPropArray2[j] = new ComplexErrorProp[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = complexErrorPropArray[j][k].length;
                complexErrorPropArray2[j][k] = new ComplexErrorProp[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    complexErrorPropArray2[j][k][i2] = complexErrorPropArray[j][k][i2].copy();
                }
            }
        }
        return complexErrorPropArray2;
    }

    public static ComplexErrorProp[][][][] copy(ComplexErrorProp[][][][] complexErrorPropArray) {
        if (complexErrorPropArray == null) {
            return null;
        }
        int n = complexErrorPropArray.length;
        ComplexErrorProp[][][][] complexErrorPropArray2 = new ComplexErrorProp[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = complexErrorPropArray[j].length;
            complexErrorPropArray2[j] = new ComplexErrorProp[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = complexErrorPropArray[j][k].length;
                complexErrorPropArray2[j][k] = new ComplexErrorProp[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = complexErrorPropArray[j][k][i2].length;
                    complexErrorPropArray2[j][k][i2] = new ComplexErrorProp[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        complexErrorPropArray2[j][k][i2][i3] = complexErrorPropArray[j][k][i2][i3].copy();
                    }
                }
            }
        }
        return complexErrorPropArray2;
    }

    public static Phasor[] copy(Phasor[] phasorArray) {
        if (phasorArray == null) {
            return null;
        }
        int n = phasorArray.length;
        Phasor[] phasorArray2 = new Phasor[n];
        for (int j = 0; j < n; ++j) {
            phasorArray2[j] = phasorArray[j].copy();
        }
        return phasorArray2;
    }

    public static Phasor[][] copy(Phasor[][] phasorArray) {
        if (phasorArray == null) {
            return null;
        }
        int n = phasorArray.length;
        Phasor[][] phasorArray2 = new Phasor[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = phasorArray[j].length;
            phasorArray2[j] = new Phasor[n2];
            for (int k = 0; k < n2; ++k) {
                phasorArray2[j][k] = phasorArray[j][k].copy();
            }
        }
        return phasorArray2;
    }

    public static Phasor[][][] copy(Phasor[][][] phasorArray) {
        if (phasorArray == null) {
            return null;
        }
        int n = phasorArray.length;
        Phasor[][][] phasorArray2 = new Phasor[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = phasorArray[j].length;
            phasorArray2[j] = new Phasor[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = phasorArray[j][k].length;
                phasorArray2[j][k] = new Phasor[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    phasorArray2[j][k][i2] = phasorArray[j][k][i2].copy();
                }
            }
        }
        return phasorArray2;
    }

    public static Phasor[][][][] copy(Phasor[][][][] phasorArray) {
        if (phasorArray == null) {
            return null;
        }
        int n = phasorArray.length;
        Phasor[][][][] phasorArray2 = new Phasor[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = phasorArray[j].length;
            phasorArray2[j] = new Phasor[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = phasorArray[j][k].length;
                phasorArray2[j][k] = new Phasor[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = phasorArray[j][k][i2].length;
                    phasorArray2[j][k][i2] = new Phasor[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        phasorArray2[j][k][i2][i3] = phasorArray[j][k][i2][i3].copy();
                    }
                }
            }
        }
        return phasorArray2;
    }

    public static short[] copy(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        int n = sArray.length;
        short[] sArray2 = new short[n];
        for (int j = 0; j < n; ++j) {
            sArray2[j] = sArray[j];
        }
        return sArray2;
    }

    public static short[][] copy(short[][] sArray) {
        if (sArray == null) {
            return null;
        }
        int n = sArray.length;
        short[][] sArrayArray = new short[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = sArray[j].length;
            sArrayArray[j] = new short[n2];
            for (int k = 0; k < n2; ++k) {
                sArrayArray[j][k] = sArray[j][k];
            }
        }
        return sArrayArray;
    }

    public static short[][][] copy(short[][][] sArray) {
        if (sArray == null) {
            return null;
        }
        int n = sArray.length;
        short[][][] sArrayArray = new short[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = sArray[j].length;
            sArrayArray[j] = new short[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = sArray[j][k].length;
                sArrayArray[j][k] = new short[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    sArrayArray[j][k][i2] = sArray[j][k][i2];
                }
            }
        }
        return sArrayArray;
    }

    public static short[][][][] copy(short[][][][] sArray) {
        if (sArray == null) {
            return null;
        }
        int n = sArray.length;
        short[][][][] sArrayArray = new short[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = sArray[j].length;
            sArrayArray[j] = new short[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = sArray[j][k].length;
                sArrayArray[j][k] = new short[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = sArray[j][k][i2].length;
                    sArrayArray[j][k][i2] = new short[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        sArrayArray[j][k][i2][i3] = sArray[j][k][i2][i3];
                    }
                }
            }
        }
        return sArrayArray;
    }

    public static byte[] copy(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        for (int j = 0; j < n; ++j) {
            byArray2[j] = byArray[j];
        }
        return byArray2;
    }

    public static byte[][] copy(byte[][] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        byte[][] byArrayArray = new byte[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = byArray[j].length;
            byArrayArray[j] = new byte[n2];
            for (int k = 0; k < n2; ++k) {
                byArrayArray[j][k] = byArray[j][k];
            }
        }
        return byArrayArray;
    }

    public static byte[][][] copy(byte[][][] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        byte[][][] byArrayArray = new byte[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = byArray[j].length;
            byArrayArray[j] = new byte[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = byArray[j][k].length;
                byArrayArray[j][k] = new byte[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    byArrayArray[j][k][i2] = byArray[j][k][i2];
                }
            }
        }
        return byArrayArray;
    }

    public static byte[][][][] copy(byte[][][][] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        byte[][][][] byArrayArray = new byte[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = byArray[j].length;
            byArrayArray[j] = new byte[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = byArray[j][k].length;
                byArrayArray[j][k] = new byte[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = byArray[j][k][i2].length;
                    byArrayArray[j][k][i2] = new byte[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        byArrayArray[j][k][i2][i3] = byArray[j][k][i2][i3];
                    }
                }
            }
        }
        return byArrayArray;
    }

    public static Double[] copy(Double[] doubleArray) {
        if (doubleArray == null) {
            return null;
        }
        int n = doubleArray.length;
        Double[] doubleArray2 = new Double[n];
        for (int j = 0; j < n; ++j) {
            doubleArray2[j] = doubleArray[j];
        }
        return doubleArray2;
    }

    public static Double[][] copy(Double[][] doubleArray) {
        if (doubleArray == null) {
            return null;
        }
        int n = doubleArray.length;
        Double[][] doubleArray2 = new Double[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = doubleArray[j].length;
            doubleArray2[j] = new Double[n2];
            for (int k = 0; k < n2; ++k) {
                doubleArray2[j][k] = doubleArray[j][k];
            }
        }
        return doubleArray2;
    }

    public static Double[][][] copy(Double[][][] doubleArray) {
        if (doubleArray == null) {
            return null;
        }
        int n = doubleArray.length;
        Double[][][] doubleArray2 = new Double[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = doubleArray[j].length;
            doubleArray2[j] = new Double[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = doubleArray[j][k].length;
                doubleArray2[j][k] = new Double[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    doubleArray2[j][k][i2] = doubleArray[j][k][i2];
                }
            }
        }
        return doubleArray2;
    }

    public static Double[][][][] copy(Double[][][][] doubleArray) {
        if (doubleArray == null) {
            return null;
        }
        int n = doubleArray.length;
        Double[][][][] doubleArray2 = new Double[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = doubleArray[j].length;
            doubleArray2[j] = new Double[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = doubleArray[j][k].length;
                doubleArray2[j][k] = new Double[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = doubleArray[j][k][i2].length;
                    doubleArray2[j][k][i2] = new Double[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        doubleArray2[j][k][i2][i3] = doubleArray[j][k][i2][i3];
                    }
                }
            }
        }
        return doubleArray2;
    }

    public static Float[] copy(Float[] floatArray) {
        if (floatArray == null) {
            return null;
        }
        int n = floatArray.length;
        Float[] floatArray2 = new Float[n];
        for (int j = 0; j < n; ++j) {
            floatArray2[j] = floatArray[j];
        }
        return floatArray2;
    }

    public static Float[][] copy(Float[][] floatArray) {
        if (floatArray == null) {
            return null;
        }
        int n = floatArray.length;
        Float[][] floatArray2 = new Float[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = floatArray[j].length;
            floatArray2[j] = new Float[n2];
            for (int k = 0; k < n2; ++k) {
                floatArray2[j][k] = floatArray[j][k];
            }
        }
        return floatArray2;
    }

    public static Float[][][] copy(Float[][][] floatArray) {
        if (floatArray == null) {
            return null;
        }
        int n = floatArray.length;
        Float[][][] floatArray2 = new Float[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = floatArray[j].length;
            floatArray2[j] = new Float[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = floatArray[j][k].length;
                floatArray2[j][k] = new Float[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    floatArray2[j][k][i2] = floatArray[j][k][i2];
                }
            }
        }
        return floatArray2;
    }

    public static Float[][][][] copy(Float[][][][] floatArray) {
        if (floatArray == null) {
            return null;
        }
        int n = floatArray.length;
        Float[][][][] floatArray2 = new Float[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = floatArray[j].length;
            floatArray2[j] = new Float[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = floatArray[j][k].length;
                floatArray2[j][k] = new Float[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = floatArray[j][k][i2].length;
                    floatArray2[j][k][i2] = new Float[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        floatArray2[j][k][i2][i3] = floatArray[j][k][i2][i3];
                    }
                }
            }
        }
        return floatArray2;
    }

    public static Long[] copy(Long[] longArray) {
        if (longArray == null) {
            return null;
        }
        int n = longArray.length;
        Long[] longArray2 = new Long[n];
        for (int j = 0; j < n; ++j) {
            longArray2[j] = longArray[j];
        }
        return longArray2;
    }

    public static Long[][] copy(Long[][] longArray) {
        if (longArray == null) {
            return null;
        }
        int n = longArray.length;
        Long[][] longArray2 = new Long[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = longArray[j].length;
            longArray2[j] = new Long[n2];
            for (int k = 0; k < n2; ++k) {
                longArray2[j][k] = longArray[j][k];
            }
        }
        return longArray2;
    }

    public static Long[][][] copy(Long[][][] longArray) {
        if (longArray == null) {
            return null;
        }
        int n = longArray.length;
        Long[][][] longArray2 = new Long[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = longArray[j].length;
            longArray2[j] = new Long[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = longArray[j][k].length;
                longArray2[j][k] = new Long[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    longArray2[j][k][i2] = longArray[j][k][i2];
                }
            }
        }
        return longArray2;
    }

    public static Long[][][][] copy(Long[][][][] longArray) {
        if (longArray == null) {
            return null;
        }
        int n = longArray.length;
        Long[][][][] longArray2 = new Long[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = longArray[j].length;
            longArray2[j] = new Long[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = longArray[j][k].length;
                longArray2[j][k] = new Long[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = longArray[j][k][i2].length;
                    longArray2[j][k][i2] = new Long[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        longArray2[j][k][i2][i3] = longArray[j][k][i2][i3];
                    }
                }
            }
        }
        return longArray2;
    }

    public static Integer[] copy(Integer[] integerArray) {
        if (integerArray == null) {
            return null;
        }
        int n = integerArray.length;
        Integer[] integerArray2 = new Integer[n];
        for (int j = 0; j < n; ++j) {
            integerArray2[j] = integerArray[j];
        }
        return integerArray2;
    }

    public static Integer[][] copy(Integer[][] integerArray) {
        if (integerArray == null) {
            return null;
        }
        int n = integerArray.length;
        Integer[][] integerArray2 = new Integer[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = integerArray[j].length;
            integerArray2[j] = new Integer[n2];
            for (int k = 0; k < n2; ++k) {
                integerArray2[j][k] = integerArray[j][k];
            }
        }
        return integerArray2;
    }

    public static Integer[][][] copy(Integer[][][] integerArray) {
        if (integerArray == null) {
            return null;
        }
        int n = integerArray.length;
        Integer[][][] integerArray2 = new Integer[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = integerArray[j].length;
            integerArray2[j] = new Integer[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = integerArray[j][k].length;
                integerArray2[j][k] = new Integer[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    integerArray2[j][k][i2] = integerArray[j][k][i2];
                }
            }
        }
        return integerArray2;
    }

    public static Integer[][][][] copy(Integer[][][][] integerArray) {
        if (integerArray == null) {
            return null;
        }
        int n = integerArray.length;
        Integer[][][][] integerArray2 = new Integer[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = integerArray[j].length;
            integerArray2[j] = new Integer[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = integerArray[j][k].length;
                integerArray2[j][k] = new Integer[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = integerArray[j][k][i2].length;
                    integerArray2[j][k][i2] = new Integer[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        integerArray2[j][k][i2][i3] = integerArray[j][k][i2][i3];
                    }
                }
            }
        }
        return integerArray2;
    }

    public static Short[] copy(Short[] shortArray) {
        if (shortArray == null) {
            return null;
        }
        int n = shortArray.length;
        Short[] shortArray2 = new Short[n];
        for (int j = 0; j < n; ++j) {
            shortArray2[j] = shortArray[j];
        }
        return shortArray2;
    }

    public static Short[][] copy(Short[][] shortArray) {
        if (shortArray == null) {
            return null;
        }
        int n = shortArray.length;
        Short[][] shortArray2 = new Short[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = shortArray[j].length;
            shortArray2[j] = new Short[n2];
            for (int k = 0; k < n2; ++k) {
                shortArray2[j][k] = shortArray[j][k];
            }
        }
        return shortArray2;
    }

    public static Short[][][] copy(Short[][][] shortArray) {
        if (shortArray == null) {
            return null;
        }
        int n = shortArray.length;
        Short[][][] shortArray2 = new Short[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = shortArray[j].length;
            shortArray2[j] = new Short[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = shortArray[j][k].length;
                shortArray2[j][k] = new Short[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    shortArray2[j][k][i2] = shortArray[j][k][i2];
                }
            }
        }
        return shortArray2;
    }

    public static Short[][][][] copy(Short[][][][] shortArray) {
        if (shortArray == null) {
            return null;
        }
        int n = shortArray.length;
        Short[][][][] shortArray2 = new Short[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = shortArray[j].length;
            shortArray2[j] = new Short[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = shortArray[j][k].length;
                shortArray2[j][k] = new Short[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = shortArray[j][k][i2].length;
                    shortArray2[j][k][i2] = new Short[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        shortArray2[j][k][i2][i3] = shortArray[j][k][i2][i3];
                    }
                }
            }
        }
        return shortArray2;
    }

    public static Byte[] copy(Byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        int n = byteArray.length;
        Byte[] byteArray2 = new Byte[n];
        for (int j = 0; j < n; ++j) {
            byteArray2[j] = byteArray[j];
        }
        return byteArray2;
    }

    public static Byte[][] copy(Byte[][] byteArray) {
        if (byteArray == null) {
            return null;
        }
        int n = byteArray.length;
        Byte[][] byteArray2 = new Byte[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = byteArray[j].length;
            byteArray2[j] = new Byte[n2];
            for (int k = 0; k < n2; ++k) {
                byteArray2[j][k] = byteArray[j][k];
            }
        }
        return byteArray2;
    }

    public static Byte[][][] copy(Byte[][][] byteArray) {
        if (byteArray == null) {
            return null;
        }
        int n = byteArray.length;
        Byte[][][] byteArray2 = new Byte[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = byteArray[j].length;
            byteArray2[j] = new Byte[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = byteArray[j][k].length;
                byteArray2[j][k] = new Byte[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    byteArray2[j][k][i2] = byteArray[j][k][i2];
                }
            }
        }
        return byteArray2;
    }

    public static Byte[][][][] copy(Byte[][][][] byteArray) {
        if (byteArray == null) {
            return null;
        }
        int n = byteArray.length;
        Byte[][][][] byteArray2 = new Byte[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = byteArray[j].length;
            byteArray2[j] = new Byte[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = byteArray[j][k].length;
                byteArray2[j][k] = new Byte[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = byteArray[j][k][i2].length;
                    byteArray2[j][k][i2] = new Byte[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        byteArray2[j][k][i2][i3] = byteArray[j][k][i2][i3];
                    }
                }
            }
        }
        return byteArray2;
    }

    public static Object copy(Object object) {
        if (object == null) {
            return null;
        }
        return Conv.copyObject(object);
    }

    public static Object copyObject(Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            object2 = objectInputStream.readObject();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return object2;
    }

    public static double radToDeg(double d) {
        return d * 180.0 / Math.PI;
    }

    public static double degToRad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double frequencyToRadialFrequency(double d) {
        return Math.PI * 2 * d;
    }

    public static double radialFrequencyToFrequency(double d) {
        return d / (Math.PI * 2);
    }

    public static double evToNm(double d) {
        return 2.99792458E17 / (-d * -1.60217646263E-19 / 6.6260687652E-34);
    }

    public static double nmToEv(double d) {
        return 2.99792458E8 / (-d * 1.0E-9) * 6.6260687652E-34 / -1.60217646263E-19;
    }

    public static double molarToPercentWeightByVol(double d, double d2) {
        return d * d2 / 10.0;
    }

    public static double percentWeightByVolToMolar(double d, double d2) {
        return d * 10.0 / d2;
    }

    public static double celsiusToKelvin(double d) {
        return d - -273.15;
    }

    public static double kelvinToCelsius(double d) {
        return d + -273.15;
    }

    public static double celsiusToFahren(double d) {
        return d * 1.8 + 32.0;
    }

    public static double fahrenToCelsius(double d) {
        return (d - 32.0) * 5.0 / 9.0;
    }

    public static double calorieToJoule(double d) {
        return d * 4.1868;
    }

    public static double jouleToCalorie(double d) {
        return d * 0.23884;
    }

    public static double gramToOunce(double d) {
        return d / 28.3459;
    }

    public static double ounceToGram(double d) {
        return d * 28.3459;
    }

    public static double kgToPound(double d) {
        return d / 0.4536;
    }

    public static double poundToKg(double d) {
        return d * 0.4536;
    }

    public static double kgToTon(double d) {
        return d / 1016.05;
    }

    public static double tonToKg(double d) {
        return d * 1016.05;
    }

    public static double millimetreToInch(double d) {
        return d / 25.4;
    }

    public static double inchToMillimetre(double d) {
        return d * 25.4;
    }

    public static double footToMetre(double d) {
        return d * 0.3048;
    }

    public static double metreToFoot(double d) {
        return d / 0.3048;
    }

    public static double yardToMetre(double d) {
        return d * 0.9144;
    }

    public static double metreToYard(double d) {
        return d / 0.9144;
    }

    public static double mileToKm(double d) {
        return d * 1.6093;
    }

    public static double kmToMile(double d) {
        return d / 1.6093;
    }

    public static double gallonToLitre(double d) {
        return d * 4.546;
    }

    public static double litreToGallon(double d) {
        return d / 4.546;
    }

    public static double quartToLitre(double d) {
        return d * 1.137;
    }

    public static double litreToQuart(double d) {
        return d / 1.137;
    }

    public static double pintToLitre(double d) {
        return d * 0.568;
    }

    public static double litreToPint(double d) {
        return d / 0.568;
    }

    public static double gallonPerMileToLitrePerKm(double d) {
        return d * 2.825;
    }

    public static double litrePerKmToGallonPerMile(double d) {
        return d / 2.825;
    }

    public static double milePerGallonToKmPerLitre(double d) {
        return d * 0.354;
    }

    public static double kmPerLitreToMilePerGallon(double d) {
        return d / 0.354;
    }

    public static double fluidOunceUKtoUS(double d) {
        return d * 0.961;
    }

    public static double fluidOunceUStoUK(double d) {
        return d * 1.041;
    }

    public static double pintUKtoUS(double d) {
        return d * 1.201;
    }

    public static double pintUStoUK(double d) {
        return d * 0.833;
    }

    public static double quartUKtoUS(double d) {
        return d * 1.201;
    }

    public static double quartUStoUK(double d) {
        return d * 0.833;
    }

    public static double gallonUKtoUS(double d) {
        return d * 1.201;
    }

    public static double gallonUStoUK(double d) {
        return d * 0.833;
    }

    public static double pintUKtoCupUS(double d) {
        return d / 0.417;
    }

    public static double cupUStoPintUK(double d) {
        return d * 0.417;
    }

    public static double calcBMImetric(double d, double d2) {
        return d2 / (d * d);
    }

    public static double calcBMIimperial(double d, double d2) {
        d = Fmath.footToMetre(d);
        d2 = Fmath.poundToKg(d2);
        return d2 / (d * d);
    }

    public static double calcWeightFromBMImetric(double d, double d2) {
        return d * d2 * d2;
    }

    public static double calcWeightFromBMIimperial(double d, double d2) {
        d2 = Fmath.footToMetre(d2);
        double d3 = d * d2 * d2;
        d3 = Fmath.kgToPound(d3);
        return d3;
    }

    public static long dateToJavaMilliSecondsUK(int n, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        TimeAndDate timeAndDate = new TimeAndDate();
        long l = timeAndDate.dateToJavaMilliSecondsUK(n, n2, n3, string, n4, n5, n6, n7);
        return l;
    }

    public static String decToHex() {
        long l = DialogueBox.readLong("Enter integer decimal number");
        String string = Conv.decToHex(l);
        DialogueBox.show(string);
        return string;
    }

    public static String decToHex(long l) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        String string = "";
        boolean bl = true;
        while (bl) {
            long l2 = l % 16L;
            string = cArray[(int)l2] + string;
            if ((l /= 16L) >= 16L) continue;
            string = cArray[(int)l] + string;
            bl = false;
        }
        return string;
    }

    public static String decToHex(int n) {
        return Conv.decToHex((long)n);
    }

    public static String decToBin() {
        long l = DialogueBox.readLong("Enter integer decimal number");
        String string = Conv.decToBin(l);
        DialogueBox.show(string);
        return string;
    }

    public static String decToBin(long l) {
        String string = "";
        boolean bl = true;
        while (bl) {
            long l2 = l % 2L;
            string = l2 + string;
            if ((l /= 2L) != 0L) continue;
            bl = false;
        }
        return string;
    }

    public static String decToBin(int n) {
        return Conv.decToBin(n);
    }

    public static long binToDec() {
        String string = DialogueBox.readLine("Enter binary number");
        long l = Conv.binToDec(string);
        DialogueBox.show(l);
        return l;
    }

    public static long binToDec(String string) {
        int n = string.length();
        long l = 0L;
        for (int j = 0; j < n; ++j) {
            if (string.charAt(n - j - 1) != '1') continue;
            l = (long)((double)l + Math.pow(2.0, j));
        }
        return l;
    }

    public static String binToHex() {
        String string = DialogueBox.readLine("Enter binary number");
        String string2 = Conv.binToHex(string);
        DialogueBox.show(string2);
        return string2;
    }

    public static String binToHex(String string) {
        long l = Conv.binToDec(string);
        String string2 = Conv.decToHex(l);
        return string2;
    }

    public static String hexToBin() {
        String string = DialogueBox.readLine("Enter integer hexadecimal number");
        String string2 = Conv.hexToBin(string);
        DialogueBox.show(string2);
        return string2;
    }

    public static String hexToBin(String string) {
        long l = Conv.hexToDec(string);
        return Conv.decToBin(l);
    }

    public static long hexToDec() {
        String string = DialogueBox.readLine("Enter integer hexadecimal number");
        long l = Conv.hexToDec(string, true);
        DialogueBox.show(l);
        return l;
    }

    public static long hexToDec(String string) {
        return Conv.hexToDec(string, false);
    }

    public static long hexToDec(String string, boolean bl) {
        int n = string.length();
        long l = 0L;
        for (int j = 0; j < n; ++j) {
            int n2 = string.charAt(n - j - 1);
            if (n2 <= 56) {
                if (n2 < 48) {
                    if (bl) {
                        DialogueBox.show(string + " is not an integer hexadecimal number\nMethod hexToDec aborted");
                    }
                    System.out.println(string + " is not an integer hexadecimal number\nMethod hexToDec aborted");
                    System.exit(0);
                } else {
                    n2 -= 48;
                }
            } else if (n2 > 64 && n2 < 71) {
                n2 -= 55;
            } else {
                if (bl) {
                    DialogueBox.show(string + " is not an integer hexadecimal number\nMethod hexToDec aborted");
                }
                System.out.println(string + " is not an integer hexadecimal number\nMethod hexToDec aborted");
                System.exit(0);
            }
            l = (long)((double)l + (double)n2 * Math.pow(16.0, j));
        }
        return l;
    }
}

