/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class Fmath {
    public static final double N_AVAGADRO = 6.0221419947E23;
    public static final double K_BOLTZMANN = 1.380650324E-23;
    public static final double H_PLANCK = 6.6260687652E-34;
    public static final double H_PLANCK_RED = 1.0545715972483913E-34;
    public static final double C_LIGHT = 2.99792458E8;
    public static final double R_GAS = 8.31447215;
    public static final double F_FARADAY = 96485.341539;
    public static final double T_ABS = -273.15;
    public static final double Q_ELECTRON = -1.60217646263E-19;
    public static final double M_ELECTRON = 9.1093818872E-31;
    public static final double M_PROTON = 1.6726215813E-27;
    public static final double M_NEUTRON = 1.6749271613E-27;
    public static final double EPSILON_0 = 8.854187817E-12;
    public static final double MU_0 = 1.2566370614359173E-6;
    public static final double ETA_0 = 376.73031346177066;
    public static final double EULER_CONSTANT_GAMMA = 0.5772156649015627;
    public static final double PI = Math.PI;
    public static final double E = Math.E;
    private static final Map<Object, Object> integers = new HashMap<Object, Object>();

    public static double log10(double d) {
        return Math.log(d) / Math.log(10.0);
    }

    public static float log10(float f) {
        return (float)(Math.log(f) / Math.log(10.0));
    }

    public static double antilog10(double d) {
        return Math.pow(10.0, d);
    }

    public static float antilog10(float f) {
        return (float)Math.pow(10.0, f);
    }

    public static double log(double d) {
        return Math.log(d);
    }

    public static float log(float f) {
        return (float)Math.log(f);
    }

    public static double antilog(double d) {
        return Math.exp(d);
    }

    public static float antilog(float f) {
        return (float)Math.exp(f);
    }

    public static double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public static float log2(float f) {
        return (float)(Math.log(f) / Math.log(2.0));
    }

    public static double antilog2(double d) {
        return Math.pow(2.0, d);
    }

    public static float antilog2(float f) {
        return (float)Math.pow(2.0, f);
    }

    public static double log10(double d, double d2) {
        return Math.log(d) / Math.log(d2);
    }

    public static double log10(double d, int n) {
        return Math.log(d) / Math.log(n);
    }

    public static float log10(float f, float f2) {
        return (float)(Math.log(f) / Math.log(f2));
    }

    public static float log10(float f, int n) {
        return (float)(Math.log(f) / Math.log(n));
    }

    public static double logit(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("the argument, p = " + d + ", must be greater or equal to zero and less than or equal to unity");
        }
        if (d > 1.0) {
            throw new IllegalArgumentException("the argument, p = " + d + ", must be greater or equal to zero and less than or equal to unity");
        }
        return Math.log(d / (1.0 - d));
    }

    public static float logit(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("the argument, p = " + f + ", must be greater or equal to zero and less than or equal to unity");
        }
        if (f > 1.0f) {
            throw new IllegalArgumentException("the argument, p = " + f + ", must be greater or equal to zero and less than or equal to unity");
        }
        return (float)Math.log(f / (1.0f - f));
    }

    public static double logit10(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("the argument, p = " + d + ", must be greater or equal to zero and less than or equal to unity");
        }
        if (d > 1.0) {
            throw new IllegalArgumentException("the argument, p = " + d + ", must be greater or equal to zero and less than or equal to unity");
        }
        return Math.log10(d / (1.0 - d));
    }

    public static float logit10(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("the argument, p = " + f + ", must be greater or equal to zero and less than or equal to unity");
        }
        if (f > 1.0f) {
            throw new IllegalArgumentException("the argument, p = " + f + ", must be greater or equal to zero and less than or equal to unity");
        }
        return (float)Math.log10((double)f / (1.0 - (double)f));
    }

    public static double antilogit(double d) {
        double d2 = Math.exp(d);
        return d2 / (1.0 + d2);
    }

    public static float antilogit(float f) {
        float f2 = (float)Math.exp(f);
        return f2 / (1.0f + f2);
    }

    public static double antilogit10(double d) {
        double d2 = Math.pow(10.0, d);
        return d2 / (1.0 + d2);
    }

    public static float antilogit10(float f) {
        float f2 = (float)Math.pow(10.0, f);
        return f2 / (1.0f + f2);
    }

    public static double square(double d) {
        return d * d;
    }

    public static float square(float f) {
        return f * f;
    }

    public static BigDecimal square(BigDecimal bigDecimal) {
        return bigDecimal.multiply(bigDecimal);
    }

    public static int square(int n) {
        return n * n;
    }

    public static long square(long l) {
        return l * l;
    }

    public static BigInteger square(BigInteger bigInteger) {
        return bigInteger.multiply(bigInteger);
    }

    public static int factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n must be a positive integer");
        }
        if (n > 12) {
            throw new IllegalArgumentException("n must less than 13 to avoid integer overflow\nTry long or double argument");
        }
        int n2 = 1;
        for (int j = 2; j <= n; ++j) {
            n2 *= j;
        }
        return n2;
    }

    public static long factorial(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("n must be a positive integer");
        }
        if (l > 20L) {
            throw new IllegalArgumentException("n must less than 21 to avoid long integer overflow\nTry double argument");
        }
        long l2 = 1L;
        for (long j = 2L; j <= l; ++j) {
            l2 *= j;
        }
        return l2;
    }

    public static BigInteger factorial(BigInteger bigInteger) {
        BigInteger bigInteger2;
        if (bigInteger.compareTo(BigInteger.ZERO) == -1) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        BigInteger bigInteger3 = bigInteger2 = BigInteger.ONE;
        BigInteger bigInteger4 = new BigInteger("2");
        while (bigInteger4.compareTo(bigInteger) != 1) {
            bigInteger3 = bigInteger3.multiply(bigInteger4);
            bigInteger4 = bigInteger4.add(bigInteger2);
        }
        bigInteger2 = null;
        bigInteger4 = null;
        return bigInteger3;
    }

    public static double factorial(double d) {
        if (d < 0.0 || d - Math.floor(d) != 0.0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double d2 = 1.0;
        for (double d3 = 2.0; d3 <= d; d3 += 1.0) {
            d2 *= d3;
        }
        return d2;
    }

    public static BigDecimal factorial(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2;
        if (bigDecimal.compareTo(BigDecimal.ZERO) == -1 || !Fmath.isInteger(bigDecimal)) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        BigDecimal bigDecimal3 = bigDecimal2 = BigDecimal.ONE;
        BigDecimal bigDecimal4 = new BigDecimal(2.0);
        while (bigDecimal4.compareTo(bigDecimal) != 1) {
            bigDecimal3 = bigDecimal3.multiply(bigDecimal4);
            bigDecimal4 = bigDecimal4.add(bigDecimal2);
        }
        bigDecimal2 = null;
        bigDecimal4 = null;
        return bigDecimal3;
    }

    public static double logFactorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double d = 0.0;
        for (int j = 2; j <= n; ++j) {
            d += Math.log(j);
        }
        return d;
    }

    public static double logFactorial(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double d = 0.0;
        for (long j = 2L; j <= l; ++j) {
            d += Math.log(j);
        }
        return d;
    }

    public static double logFactorial(double d) {
        if (d < 0.0 || d - Math.floor(d) != 0.0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double d2 = 0.0;
        for (double d3 = 2.0; d3 <= d; d3 += 1.0) {
            d2 += Math.log(d3);
        }
        return d2;
    }

    public static double sign(double d) {
        if (d < 0.0) {
            return -1.0;
        }
        return 1.0;
    }

    public static float sign(float f) {
        if (f < 0.0f) {
            return -1.0f;
        }
        return 1.0f;
    }

    public static int sign(int n) {
        if (n < 0) {
            return -1;
        }
        return 1;
    }

    public static long sign(long l) {
        if (l < 0L) {
            return -1L;
        }
        return 1L;
    }

    public static double hypot(double d, double d2) {
        double d3 = Math.abs(d);
        double d4 = Math.abs(d2);
        double d5 = 0.0;
        double d6 = 0.0;
        if (d3 == 0.0) {
            d5 = d4;
        } else if (d4 == 0.0) {
            d5 = d3;
        } else if (d3 >= d4) {
            d6 = d4 / d3;
            d5 = d3 * Math.sqrt(1.0 + d6 * d6);
        } else {
            d6 = d3 / d4;
            d5 = d4 * Math.sqrt(1.0 + d6 * d6);
        }
        return d5;
    }

    public static float hypot(float f, float f2) {
        return (float)Fmath.hypot((double)f, (double)f2);
    }

    public static double angle(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Fmath.cos(d, d2, d3, d4, d5, d6);
        return Math.acos(d7);
    }

    public static double angle(double d, double d2, double d3) {
        double d4 = Fmath.cos(d, d2, d3);
        return Math.acos(d4);
    }

    public static double sin(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Fmath.angle(d, d2, d3, d4, d5, d6);
        return Math.sin(d7);
    }

    public static double sin(double d, double d2, double d3) {
        double d4 = Fmath.angle(d, d2, d3);
        return Math.sin(d4);
    }

    public static double sin(double d) {
        return Math.sin(d);
    }

    public static double asin(double d) {
        if (d < -1.0 && d > 1.0) {
            throw new IllegalArgumentException("Fmath.asin argument (" + d + ") must be >= -1.0 and <= 1.0");
        }
        return Math.asin(d);
    }

    public static double cos(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Fmath.hypot(d - d5, d2 - d6);
        double d8 = Fmath.hypot(d3 - d5, d4 - d6);
        double d9 = Fmath.hypot(d - d3, d2 - d4);
        return Fmath.cos(d7, d8, d9);
    }

    public static double cos(double d, double d2, double d3) {
        return 0.5 * (d / d2 + d2 / d - d3 / d * (d3 / d2));
    }

    public static double cos(double d) {
        return Math.cos(d);
    }

    public static double acos(double d) {
        if (d < -1.0 || d > 1.0) {
            throw new IllegalArgumentException("Fmath.acos argument (" + d + ") must be >= -1.0 and <= 1.0");
        }
        return Math.acos(d);
    }

    public static double tan(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Fmath.angle(d, d2, d3, d4, d5, d6);
        return Math.tan(d7);
    }

    public static double tan(double d, double d2, double d3) {
        double d4 = Fmath.angle(d, d2, d3);
        return Math.tan(d4);
    }

    public static double tan(double d) {
        return Math.tan(d);
    }

    public static double atan(double d) {
        return Math.atan(d);
    }

    public static double atan2(double d, double d2) {
        return Math.atan2(d, d2);
    }

    public static double cot(double d) {
        return 1.0 / Math.tan(d);
    }

    public static double acot(double d) {
        return Math.atan(1.0 / d);
    }

    public static double acot2(double d, double d2) {
        return Math.atan2(d2, d);
    }

    public static double sec(double d) {
        return 1.0 / Math.cos(d);
    }

    public static double asec(double d) {
        if (d < 1.0 && d > -1.0) {
            throw new IllegalArgumentException("asec argument (" + d + ") must be >= 1 or <= -1");
        }
        return Math.acos(1.0 / d);
    }

    public static double csc(double d) {
        return 1.0 / Math.sin(d);
    }

    public static double acsc(double d) {
        if (d < 1.0 && d > -1.0) {
            throw new IllegalArgumentException("acsc argument (" + d + ") must be >= 1 or <= -1");
        }
        return Math.asin(1.0 / d);
    }

    public static double exsec(double d) {
        return 1.0 / Math.cos(d) - 1.0;
    }

    public static double aexsec(double d) {
        if (d < 0.0 && d > -2.0) {
            throw new IllegalArgumentException("aexsec argument (" + d + ") must be >= 0.0 and <= -2");
        }
        return Math.asin(1.0 / (1.0 + d));
    }

    public static double vers(double d) {
        return 1.0 - Math.cos(d);
    }

    public static double avers(double d) {
        if (d < 0.0 && d > 2.0) {
            throw new IllegalArgumentException("avers argument (" + d + ") must be <= 2 and >= 0");
        }
        return Math.acos(1.0 - d);
    }

    public static double covers(double d) {
        return 1.0 - Math.sin(d);
    }

    public static double acovers(double d) {
        if (d < 0.0 && d > 2.0) {
            throw new IllegalArgumentException("acovers argument (" + d + ") must be <= 2 and >= 0");
        }
        return Math.asin(1.0 - d);
    }

    public static double hav(double d) {
        return 0.5 * Fmath.vers(d);
    }

    public static double ahav(double d) {
        if (d < 0.0 && d > 1.0) {
            throw new IllegalArgumentException("ahav argument (" + d + ") must be >= 0 and <= 1");
        }
        return Fmath.acos(1.0 - 2.0 * d);
    }

    public static double sinc(double d) {
        if (Math.abs(d) < 1.0E-40) {
            return 1.0;
        }
        return Math.sin(d) / d;
    }

    public static double nsinc(double d) {
        if (Math.abs(d) < 1.0E-40) {
            return 1.0;
        }
        return Math.sin(Math.PI * d) / (Math.PI * d);
    }

    public static double sinh(double d) {
        return 0.5 * (Math.exp(d) - Math.exp(-d));
    }

    public static double asinh(double d) {
        double d2 = 1.0;
        if (d < 0.0) {
            d2 = -1.0;
            d = -d;
        }
        return d2 * Math.log(d + Math.sqrt(d * d + 1.0));
    }

    public static double cosh(double d) {
        return 0.5 * (Math.exp(d) + Math.exp(-d));
    }

    public static double acosh(double d) {
        if (d < 1.0) {
            throw new IllegalArgumentException("acosh real number argument (" + d + ") must be >= 1");
        }
        return Math.log(d + Math.sqrt(d * d - 1.0));
    }

    public static double tanh(double d) {
        return Fmath.sinh(d) / Fmath.cosh(d);
    }

    public static double atanh(double d) {
        double d2 = 1.0;
        if (d < 0.0) {
            d2 = -1.0;
            d = -d;
        }
        if (d > 1.0) {
            throw new IllegalArgumentException("atanh real number argument (" + d2 * d + ") must be >= -1 and <= 1");
        }
        return 0.5 * d2 * (Math.log(1.0 + d) - Math.log(1.0 - d));
    }

    public static double coth(double d) {
        return 1.0 / Fmath.tanh(d);
    }

    public static double acoth(double d) {
        double d2 = 1.0;
        if (d < 0.0) {
            d2 = -1.0;
            d = -d;
        }
        if (d < 1.0) {
            throw new IllegalArgumentException("acoth real number argument (" + d2 * d + ") must be <= -1 or >= 1");
        }
        return 0.5 * d2 * (Math.log(1.0 + d) - Math.log(d - 1.0));
    }

    public static double sech(double d) {
        return 1.0 / Fmath.cosh(d);
    }

    public static double asech(double d) {
        if (d > 1.0 || d < 0.0) {
            throw new IllegalArgumentException("asech real number argument (" + d + ") must be >= 0 and <= 1");
        }
        return 0.5 * Math.log(1.0 / d + Math.sqrt(1.0 / (d * d) - 1.0));
    }

    public static double csch(double d) {
        return 1.0 / Fmath.sinh(d);
    }

    public static double acsch(double d) {
        double d2 = 1.0;
        if (d < 0.0) {
            d2 = -1.0;
            d = -d;
        }
        return 0.5 * d2 * Math.log(1.0 / d + Math.sqrt(1.0 / (d * d) + 1.0));
    }

    public static int checkPrecision(double d) {
        boolean bl = true;
        int n = 0;
        if (Fmath.isNaN(d)) {
            bl = false;
        }
        if (Fmath.isPlusInfinity(d)) {
            bl = false;
        }
        if (Fmath.isMinusInfinity(d)) {
            bl = false;
        }
        while (bl) {
            if (d == Fmath.truncate(d, n)) {
                bl = false;
                continue;
            }
            if (++n <= 20) continue;
            bl = false;
        }
        return n;
    }

    public static int checkPrecision(float f) {
        return Fmath.checkPrecision((double)f);
    }

    public static double truncate(double d, int n) {
        double d2 = d;
        if (!(Fmath.isNaN(d) || Fmath.isPlusInfinity(d) || Fmath.isMinusInfinity(d) || d == 0.0)) {
            String string = new Double(d).toString().trim();
            d2 = Double.parseDouble(Fmath.truncateProcedure(string, n));
        }
        return d2;
    }

    public static float truncate(float f, int n) {
        float f2 = f;
        if (!(Fmath.isNaN(f) || Fmath.isPlusInfinity(f) || Fmath.isMinusInfinity(f) || (double)f == 0.0)) {
            String string = new Float(f).toString().trim();
            f2 = Float.parseFloat(Fmath.truncateProcedure(string, n));
        }
        return f2;
    }

    private static String truncateProcedure(String string, int n) {
        String string2 = string;
        String string3 = string;
        String string4 = " ";
        String string5 = "+";
        int n2 = string.indexOf(69);
        int n3 = string.indexOf(46);
        int n4 = string.indexOf(45);
        if (n4 != -1 && n4 == 0) {
            string3 = string3.substring(1);
            string5 = "-";
            --n3;
            --n2;
        }
        if (n2 > -1) {
            string4 = string3.substring(n2);
            string3 = string3.substring(0, n2);
        }
        String string6 = null;
        String string7 = "0";
        String string8 = null;
        String string9 = null;
        double d = 0.0;
        if (n3 > -1) {
            string6 = string3.substring(0, n3);
            string7 = string3.substring(n3 + 1);
            int n5 = string7.length();
            if (n < n5) {
                string8 = string7.substring(n);
                string9 = string8.substring(0, 1) + ".";
                string9 = string8.length() > 1 ? string9 + string8.substring(1) : string9 + "0";
                d = Math.round(Double.parseDouble(string9));
                if (n > 0) {
                    if (d >= 5.0) {
                        int n6;
                        int[] nArray = new int[n + 1];
                        nArray[0] = 0;
                        for (n6 = 0; n6 < n; ++n6) {
                            nArray[n6 + 1] = Integer.parseInt(string7.substring(n6, n6 + 1));
                        }
                        n6 = 1;
                        int n7 = n;
                        while (n6 != 0) {
                            int n8 = n7;
                            nArray[n8] = nArray[n8] + 1;
                            if (n7 > 0) {
                                if (nArray[n7] < 10) {
                                    n6 = 0;
                                    continue;
                                }
                                nArray[n7] = 0;
                                --n7;
                                continue;
                            }
                            n6 = 0;
                        }
                        int n9 = Integer.parseInt(string6);
                        string6 = new Integer(n9 += nArray[0]).toString();
                        string9 = "";
                        for (int j = 1; j <= n; ++j) {
                            string9 = string9 + new Integer(nArray[j]).toString();
                        }
                        string7 = string9;
                    } else {
                        string7 = string7.substring(0, n);
                    }
                } else {
                    if (d >= 5.0) {
                        int n10 = Integer.parseInt(string6);
                        string6 = new Integer(++n10).toString();
                    }
                    string7 = "0";
                }
            }
            string2 = string5 + string6.trim() + "." + string7.trim() + string4;
        }
        return string2.trim();
    }

    public static boolean isFinite(double d) {
        boolean bl = true;
        if (d != d) {
            bl = false;
        } else if (d == Double.POSITIVE_INFINITY) {
            bl = false;
        } else if (d == Double.NEGATIVE_INFINITY) {
            bl = false;
        }
        return bl;
    }

    public static boolean isFinite(float f) {
        boolean bl = true;
        if (f != f) {
            bl = false;
        } else if ((double)f == Double.POSITIVE_INFINITY) {
            bl = false;
        } else if ((double)f == Double.NEGATIVE_INFINITY) {
            bl = false;
        }
        return bl;
    }

    public static boolean isInfinity(double d) {
        boolean bl = false;
        if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            bl = true;
        }
        return bl;
    }

    public static boolean isInfinity(float f) {
        boolean bl = false;
        if (f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY) {
            bl = true;
        }
        return bl;
    }

    public static boolean isPlusInfinity(double d) {
        boolean bl = false;
        if (d == Double.POSITIVE_INFINITY) {
            bl = true;
        }
        return bl;
    }

    public static boolean isPlusInfinity(float f) {
        boolean bl = false;
        if (f == Float.POSITIVE_INFINITY) {
            bl = true;
        }
        return bl;
    }

    public static boolean isMinusInfinity(double d) {
        boolean bl = false;
        if (d == Double.NEGATIVE_INFINITY) {
            bl = true;
        }
        return bl;
    }

    public static boolean isMinusInfinity(float f) {
        boolean bl = false;
        if (f == Float.NEGATIVE_INFINITY) {
            bl = true;
        }
        return bl;
    }

    public static boolean isNaN(double d) {
        boolean bl = false;
        if (d != d) {
            bl = true;
        }
        return bl;
    }

    public static boolean isNaN(float f) {
        boolean bl = false;
        if (f != f) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqual(double d, double d2) {
        boolean bl = false;
        if (Fmath.isNaN(d)) {
            if (Fmath.isNaN(d2)) {
                bl = true;
            }
        } else if (Fmath.isPlusInfinity(d)) {
            if (Fmath.isPlusInfinity(d2)) {
                bl = true;
            }
        } else if (Fmath.isMinusInfinity(d)) {
            if (Fmath.isMinusInfinity(d2)) {
                bl = true;
            }
        } else if (d == d2) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqual(float f, float f2) {
        boolean bl = false;
        if (Fmath.isNaN(f)) {
            if (Fmath.isNaN(f2)) {
                bl = true;
            }
        } else if (Fmath.isPlusInfinity(f)) {
            if (Fmath.isPlusInfinity(f2)) {
                bl = true;
            }
        } else if (Fmath.isMinusInfinity(f)) {
            if (Fmath.isMinusInfinity(f2)) {
                bl = true;
            }
        } else if (f == f2) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqual(int n, int n2) {
        boolean bl = false;
        if (n == n2) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqual(char c, char c2) {
        boolean bl = false;
        if (c == c2) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqual(String string, String string2) {
        boolean bl = false;
        if (string.equals(string2)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqualWithinLimits(double d, double d2, double d3) {
        boolean bl = false;
        if (Math.abs(d - d2) <= Math.abs(d3)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqualWithinLimits(float f, float f2, float f3) {
        boolean bl = false;
        if (Math.abs(f - f2) <= Math.abs(f3)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqualWithinLimits(long l, long l2, long l3) {
        boolean bl = false;
        if (Math.abs(l - l2) <= Math.abs(l3)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqualWithinLimits(int n, int n2, int n3) {
        boolean bl = false;
        if (Math.abs(n - n2) <= Math.abs(n3)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqualWithinLimits(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3) {
        boolean bl = false;
        if (bigDecimal.subtract(bigDecimal2).abs().compareTo(bigDecimal3.abs()) <= 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqualWithinLimits(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        boolean bl = false;
        if (bigInteger.subtract(bigInteger2).abs().compareTo(bigInteger3.abs()) <= 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqualWithinPerCent(double d, double d2, double d3) {
        boolean bl = false;
        double d4 = Math.abs((d + d2) * d3 / 200.0);
        if (Math.abs(d - d2) <= d4) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqualWithinPerCent(float f, float f2, float f3) {
        boolean bl = false;
        double d = Math.abs((f + f2) * f3 / 200.0f);
        if ((double)Math.abs(f - f2) <= d) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqualWithinPerCent(long l, long l2, double d) {
        boolean bl = false;
        double d2 = Math.abs((double)(l + l2) * d / 200.0);
        if ((double)Math.abs(l - l2) <= d2) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqualWithinPerCent(long l, long l2, long l3) {
        boolean bl = false;
        double d = Math.abs((double)(l + l2) * (double)l3 / 200.0);
        if ((double)Math.abs(l - l2) <= d) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqualWithinPerCent(int n, int n2, double d) {
        boolean bl = false;
        double d2 = Math.abs((double)(n + n2) * d / 200.0);
        if ((double)Math.abs(n - n2) <= d2) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqualWithinPerCent(int n, int n2, int n3) {
        boolean bl = false;
        double d = Math.abs((double)(n + n2) * (double)n3 / 200.0);
        if ((double)Math.abs(n - n2) <= d) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEqualWithinPerCent(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3) {
        boolean bl = false;
        BigDecimal bigDecimal4 = bigDecimal.add(bigDecimal2).multiply(bigDecimal3).multiply(new BigDecimal("0.005"));
        if (bigDecimal.subtract(bigDecimal2).abs().compareTo(bigDecimal4.abs()) <= 0) {
            bl = true;
        }
        bigDecimal4 = null;
        return bl;
    }

    public static boolean isEqualWithinPerCent(BigInteger bigInteger, BigInteger bigInteger2, BigDecimal bigDecimal) {
        boolean bl = false;
        BigDecimal bigDecimal2 = new BigDecimal(bigInteger);
        BigDecimal bigDecimal3 = new BigDecimal(bigInteger2);
        BigDecimal bigDecimal4 = bigDecimal2.add(bigDecimal3).multiply(bigDecimal).multiply(new BigDecimal("0.005"));
        if (bigDecimal2.subtract(bigDecimal3).abs().compareTo(bigDecimal4.abs()) <= 0) {
            bl = true;
        }
        bigDecimal4 = null;
        bigDecimal2 = null;
        bigDecimal3 = null;
        return bl;
    }

    public static boolean isEqualWithinPerCent(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        boolean bl = false;
        BigDecimal bigDecimal = new BigDecimal(bigInteger);
        BigDecimal bigDecimal2 = new BigDecimal(bigInteger2);
        BigDecimal bigDecimal3 = new BigDecimal(bigInteger3);
        BigDecimal bigDecimal4 = bigDecimal.add(bigDecimal2).multiply(bigDecimal3).multiply(new BigDecimal("0.005"));
        if (bigDecimal.subtract(bigDecimal2).abs().compareTo(bigDecimal4.abs()) <= 0) {
            bl = true;
        }
        bigDecimal4 = null;
        bigDecimal = null;
        bigDecimal2 = null;
        bigDecimal3 = null;
        return bl;
    }

    public static int compare(double d, double d2) {
        Double d3 = new Double(d);
        Double d4 = new Double(d2);
        return d3.compareTo(d4);
    }

    public static int compare(int n, int n2) {
        Integer n3 = new Integer(n);
        Integer n4 = new Integer(n2);
        return n3.compareTo(n4);
    }

    public static int compare(long l, long l2) {
        Long l3 = new Long(l);
        Long l4 = new Long(l2);
        return l3.compareTo(l4);
    }

    public static int compare(float f, float f2) {
        Float f3 = new Float(f);
        Float f4 = new Float(f2);
        return f3.compareTo(f4);
    }

    public static int compare(byte by, byte by2) {
        Byte by3 = new Byte(by);
        Byte by4 = new Byte(by2);
        return by3.compareTo(by4);
    }

    public static int compare(short s, short s2) {
        Short s3 = new Short(s);
        Short s4 = new Short(s2);
        return s3.compareTo(s4);
    }

    public static boolean compare(double[] dArray, double[] dArray2) {
        boolean bl = true;
        int n = dArray.length;
        int n2 = dArray2.length;
        if (n != n2) {
            bl = false;
        } else {
            for (int j = 0; j < n; ++j) {
                if (dArray[j] == dArray2[j]) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static boolean compare(float[] fArray, float[] fArray2) {
        boolean bl = true;
        int n = fArray.length;
        int n2 = fArray2.length;
        if (n != n2) {
            bl = false;
        } else {
            for (int j = 0; j < n; ++j) {
                if (fArray[j] == fArray2[j]) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static boolean compare(int[] nArray, int[] nArray2) {
        boolean bl = true;
        int n = nArray.length;
        int n2 = nArray2.length;
        if (n != n2) {
            bl = false;
        } else {
            for (int j = 0; j < n; ++j) {
                if (nArray[j] == nArray2[j]) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static boolean compare(long[] lArray, long[] lArray2) {
        boolean bl = true;
        int n = lArray.length;
        int n2 = lArray2.length;
        if (n != n2) {
            bl = false;
        } else {
            for (int j = 0; j < n; ++j) {
                if (lArray[j] == lArray2[j]) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static boolean isInteger(double d) {
        boolean bl = false;
        double d2 = Math.floor(d);
        if (d - d2 == 0.0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isInteger(double[] dArray) {
        boolean bl = true;
        boolean bl2 = true;
        int n = 0;
        while (bl2) {
            double d = Math.floor(dArray[n]);
            if (dArray[n] - d != 0.0) {
                bl = false;
                bl2 = false;
                continue;
            }
            if (++n != dArray.length) continue;
            bl2 = false;
        }
        return bl;
    }

    public static boolean isInteger(float f) {
        boolean bl = false;
        float f2 = (float)Math.floor(f);
        if (f - f2 == 0.0f) {
            bl = true;
        }
        return bl;
    }

    public static boolean isInteger(float[] fArray) {
        boolean bl = true;
        boolean bl2 = true;
        int n = 0;
        while (bl2) {
            float f = (float)Math.floor(fArray[n]);
            if ((double)(fArray[n] - f) != 0.0) {
                bl = false;
                bl2 = false;
                continue;
            }
            if (++n != fArray.length) continue;
            bl2 = false;
        }
        return bl;
    }

    public static boolean isInteger(Number number) {
        boolean bl = integers.containsKey(number.getClass());
        if (!bl) {
            double d;
            if (number instanceof Double) {
                d = number.doubleValue();
                bl = Fmath.isInteger(d);
            }
            if (number instanceof Float) {
                float f = number.floatValue();
                bl = Fmath.isInteger(f);
            }
            if (number instanceof BigDecimal) {
                d = number.doubleValue();
                bl = Fmath.isInteger(d);
            }
        }
        return bl;
    }

    public static boolean isInteger(Number[] numberArray) {
        boolean bl = true;
        for (int j = 0; j < numberArray.length; ++j) {
            float f;
            double d;
            boolean bl2 = integers.containsKey(numberArray[j].getClass());
            if (bl2) continue;
            if (numberArray[j] instanceof Double && !(bl2 = Fmath.isInteger(d = numberArray[j].doubleValue()))) {
                bl = false;
            }
            if (numberArray[j] instanceof Float && !(bl2 = Fmath.isInteger(f = numberArray[j].floatValue()))) {
                bl = false;
            }
            if (!(numberArray[j] instanceof BigDecimal) || (bl2 = Fmath.isInteger(d = numberArray[j].doubleValue()))) continue;
            bl = false;
        }
        return bl;
    }

    public static boolean isEven(int n) {
        boolean bl = false;
        if ((double)(n % 2) == 0.0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEven(float f) {
        double d = Math.floor(f);
        if ((double)f - d != 0.0) {
            throw new IllegalArgumentException("the argument is not an integer");
        }
        boolean bl = false;
        d = Math.floor(f / 2.0f);
        if ((double)(f / 2.0f) - d == 0.0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEven(double d) {
        double d2 = Math.floor(d);
        if (d - d2 != 0.0) {
            throw new IllegalArgumentException("the argument is not an integer");
        }
        boolean bl = false;
        d2 = Math.floor(d / 2.0);
        if (d / 2.0 - d2 == 0.0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isOdd(int n) {
        boolean bl = true;
        if ((double)(n % 2) == 0.0) {
            bl = false;
        }
        return bl;
    }

    public static boolean isOdd(float f) {
        double d = Math.floor(f);
        if ((double)f - d != 0.0) {
            throw new IllegalArgumentException("the argument is not an integer");
        }
        boolean bl = true;
        d = Math.floor(f / 2.0f);
        if ((double)(f / 2.0f) - d == 0.0) {
            bl = false;
        }
        return bl;
    }

    public static boolean isOdd(double d) {
        double d2 = Math.floor(d);
        if (d - d2 != 0.0) {
            throw new IllegalArgumentException("the argument is not an integer");
        }
        boolean bl = true;
        d2 = Math.floor(d / 2.0);
        if (d / 2.0 - d2 == 0.0) {
            bl = false;
        }
        return bl;
    }

    public static boolean leapYear(int n) {
        boolean bl = false;
        bl = n % 4 != 0 ? false : (n % 400 == 0 ? true : n % 100 != 0);
        return bl;
    }

    public static long dateToJavaMilliS(int n, int n2, int n3, int n4, int n5, int n6) {
        long[] lArray = new long[]{0L, 31L, 28L, 31L, 30L, 31L, 30L, 31L, 31L, 30L, 31L, 30L, 31L};
        long l = 0L;
        long l2 = 0L;
        for (int j = n - 1; j >= 1970; --j) {
            l2 += 365L;
            if (!Fmath.leapYear(j)) continue;
            ++l2;
        }
        l2 *= 86400000L;
        long l3 = 0L;
        for (int j = n2 - 1; j > 0; --j) {
            l3 += lArray[j];
            if (!Fmath.leapYear(n)) continue;
            ++l3;
        }
        l = l2 + (l3 *= 86400000L) + (long)n3 * 24L * 60L * 60L * 1000L + (long)n4 * 60L * 60L * 1000L + (long)n5 * 60L * 1000L + (long)n6 * 1000L;
        return l;
    }

    public static double maximum(double[] dArray) {
        int n = dArray.length;
        double d = dArray[0];
        for (int j = 1; j < n; ++j) {
            if (!(dArray[j] > d)) continue;
            d = dArray[j];
        }
        return d;
    }

    public static float maximum(float[] fArray) {
        int n = fArray.length;
        float f = fArray[0];
        for (int j = 1; j < n; ++j) {
            if (!(fArray[j] > f)) continue;
            f = fArray[j];
        }
        return f;
    }

    public static int maximum(int[] nArray) {
        int n = nArray.length;
        int n2 = nArray[0];
        for (int j = 1; j < n; ++j) {
            if (nArray[j] <= n2) continue;
            n2 = nArray[j];
        }
        return n2;
    }

    public static long maximum(long[] lArray) {
        long l = lArray.length;
        long l2 = lArray[0];
        int n = 1;
        while ((long)n < l) {
            if (lArray[n] > l2) {
                l2 = lArray[n];
            }
            ++n;
        }
        return l2;
    }

    public static double minimum(double[] dArray) {
        int n = dArray.length;
        double d = dArray[0];
        for (int j = 1; j < n; ++j) {
            if (!(dArray[j] < d)) continue;
            d = dArray[j];
        }
        return d;
    }

    public static float minimum(float[] fArray) {
        int n = fArray.length;
        float f = fArray[0];
        for (int j = 1; j < n; ++j) {
            if (!(fArray[j] < f)) continue;
            f = fArray[j];
        }
        return f;
    }

    public static int minimum(int[] nArray) {
        int n = nArray.length;
        int n2 = nArray[0];
        for (int j = 1; j < n; ++j) {
            if (nArray[j] >= n2) continue;
            n2 = nArray[j];
        }
        return n2;
    }

    public static long minimum(long[] lArray) {
        long l = lArray.length;
        long l2 = lArray[0];
        int n = 1;
        while ((long)n < l) {
            if (lArray[n] < l2) {
                l2 = lArray[n];
            }
            ++n;
        }
        return l2;
    }

    public static double maximumDifference(double[] dArray) {
        return Fmath.maximum(dArray) - Fmath.minimum(dArray);
    }

    public static float maximumDifference(float[] fArray) {
        return Fmath.maximum(fArray) - Fmath.minimum(fArray);
    }

    public static long maximumDifference(long[] lArray) {
        return Fmath.maximum(lArray) - Fmath.minimum(lArray);
    }

    public static int maximumDifference(int[] nArray) {
        return Fmath.maximum(nArray) - Fmath.minimum(nArray);
    }

    public static double minimumDifference(double[] dArray) {
        double d;
        double[] dArray2 = Fmath.selectionSort(dArray);
        double d2 = dArray.length;
        double d3 = d = dArray2[1] - dArray2[0];
        int n = 1;
        while ((double)n < d2 - 1.0) {
            d = dArray2[n + 1] - dArray2[n];
            if (d < d3) {
                d3 = d;
            }
            ++n;
        }
        return d3;
    }

    public static float minimumDifference(float[] fArray) {
        float f;
        float[] fArray2 = Fmath.selectionSort(fArray);
        float f2 = fArray.length;
        float f3 = f = fArray2[1] - fArray2[0];
        int n = 1;
        while ((float)n < f2 - 1.0f) {
            f = fArray2[n + 1] - fArray2[n];
            if (f < f3) {
                f3 = f;
            }
            ++n;
        }
        return f3;
    }

    public static long minimumDifference(long[] lArray) {
        long l;
        long[] lArray2 = Fmath.selectionSort(lArray);
        long l2 = lArray.length;
        long l3 = l = lArray2[1] - lArray2[0];
        int n = 1;
        while ((long)n < l2 - 1L) {
            l = lArray2[n + 1] - lArray2[n];
            if (l < l3) {
                l3 = l;
            }
            ++n;
        }
        return l3;
    }

    public static int minimumDifference(int[] nArray) {
        int n;
        int[] nArray2 = Fmath.selectionSort(nArray);
        int n2 = nArray.length;
        int n3 = n = nArray2[1] - nArray2[0];
        for (int j = 1; j < n2 - 1; ++j) {
            n = nArray2[j + 1] - nArray2[j];
            if (n >= n3) continue;
            n3 = n;
        }
        return n3;
    }

    public static double[] reverseArray(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = dArray[n - 1 - j];
        }
        return dArray2;
    }

    public static float[] reverseArray(float[] fArray) {
        int n = fArray.length;
        float[] fArray2 = new float[n];
        for (int j = 0; j < n; ++j) {
            fArray2[j] = fArray[n - 1 - j];
        }
        return fArray2;
    }

    public static int[] reverseArray(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        for (int j = 0; j < n; ++j) {
            nArray2[j] = nArray[n - 1 - j];
        }
        return nArray2;
    }

    public static long[] reverseArray(long[] lArray) {
        int n = lArray.length;
        long[] lArray2 = new long[n];
        for (int j = 0; j < n; ++j) {
            lArray2[j] = lArray[n - 1 - j];
        }
        return lArray2;
    }

    public static char[] reverseArray(char[] cArray) {
        int n = cArray.length;
        char[] cArray2 = new char[n];
        for (int j = 0; j < n; ++j) {
            cArray2[j] = cArray[n - 1 - j];
        }
        return cArray2;
    }

    public static double[] arrayAbs(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = Math.abs(dArray[j]);
        }
        return dArray2;
    }

    public static float[] arrayAbs(float[] fArray) {
        int n = fArray.length;
        float[] fArray2 = new float[n];
        for (int j = 0; j < n; ++j) {
            fArray2[j] = Math.abs(fArray[j]);
        }
        return fArray2;
    }

    public static long[] arrayAbs(long[] lArray) {
        int n = lArray.length;
        long[] lArray2 = new long[n];
        for (int j = 0; j < n; ++j) {
            lArray2[j] = Math.abs(lArray[j]);
        }
        return lArray2;
    }

    public static int[] arrayAbs(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        for (int j = 0; j < n; ++j) {
            nArray2[j] = Math.abs(nArray[j]);
        }
        return nArray2;
    }

    public static double[] arrayMultByConstant(double[] dArray, double d) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = dArray[j] * d;
        }
        return dArray2;
    }

    public static double[] arrayMultByConstant(int[] nArray, double d) {
        int n = nArray.length;
        double[] dArray = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray[j] = (double)nArray[j] * d;
        }
        return dArray;
    }

    public static double[] arrayMultByConstant(double[] dArray, int n) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        for (int j = 0; j < n2; ++j) {
            dArray2[j] = dArray[j] * (double)n;
        }
        return dArray2;
    }

    public static double[] arrayMultByConstant(int[] nArray, int n) {
        int n2 = nArray.length;
        double[] dArray = new double[n2];
        for (int j = 0; j < n2; ++j) {
            dArray[j] = nArray[j] * n;
        }
        return dArray;
    }

    public static double[] log10Elements(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = Math.log10(dArray[j]);
        }
        return dArray2;
    }

    public static float[] log10Elements(float[] fArray) {
        int n = fArray.length;
        float[] fArray2 = new float[n];
        for (int j = 0; j < n; ++j) {
            fArray2[j] = (float)Math.log10(fArray[j]);
        }
        return fArray2;
    }

    public static double[] lnElements(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = Math.log10(dArray[j]);
        }
        return dArray2;
    }

    public static float[] lnElements(float[] fArray) {
        int n = fArray.length;
        float[] fArray2 = new float[n];
        for (int j = 0; j < n; ++j) {
            fArray2[j] = (float)Math.log10(fArray[j]);
        }
        return fArray2;
    }

    public static double[] squareRootElements(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = Math.sqrt(dArray[j]);
        }
        return dArray2;
    }

    public static float[] squareRootElements(float[] fArray) {
        int n = fArray.length;
        float[] fArray2 = new float[n];
        for (int j = 0; j < n; ++j) {
            fArray2[j] = (float)Math.sqrt(fArray[j]);
        }
        return fArray2;
    }

    public static double[] raiseElementsToPower(double[] dArray, double d) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = Math.pow(dArray[j], d);
        }
        return dArray2;
    }

    public static double[] raiseElementsToPower(double[] dArray, int n) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        for (int j = 0; j < n2; ++j) {
            dArray2[j] = Math.pow(dArray[j], n);
        }
        return dArray2;
    }

    public static float[] raiseElementsToPower(float[] fArray, float f) {
        int n = fArray.length;
        float[] fArray2 = new float[n];
        for (int j = 0; j < n; ++j) {
            fArray2[j] = (float)Math.pow(fArray[j], f);
        }
        return fArray2;
    }

    public static float[] raiseElementsToPower(float[] fArray, int n) {
        int n2 = fArray.length;
        float[] fArray2 = new float[n2];
        for (int j = 0; j < n2; ++j) {
            fArray2[j] = (float)Math.pow(fArray[j], n);
        }
        return fArray2;
    }

    public static double[] invertElements(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = 1.0 / dArray[j];
        }
        return dArray2;
    }

    public static float[] invertElements(float[] fArray) {
        int n = fArray.length;
        float[] fArray2 = new float[n];
        for (int j = 0; j < n; ++j) {
            fArray2[j] = 1.0f / fArray[j];
        }
        return fArray2;
    }

    public static int[] indicesOf(double[] dArray, double d) {
        int n;
        int[] nArray = null;
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < dArray.length; ++n) {
            if (dArray[n] != d) continue;
            ++n2;
            arrayList.add(new Integer(n));
        }
        if (n2 != 0) {
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = (Integer)arrayList.get(n);
            }
        }
        return nArray;
    }

    public static int[] indicesOf(float[] fArray, float f) {
        int n;
        int[] nArray = null;
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < fArray.length; ++n) {
            if (fArray[n] != f) continue;
            ++n2;
            arrayList.add(new Integer(n));
        }
        if (n2 != 0) {
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = (Integer)arrayList.get(n);
            }
        }
        return nArray;
    }

    public static int[] indicesOf(long[] lArray, long l) {
        int n;
        int[] nArray = null;
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < lArray.length; ++n) {
            if (lArray[n] != l) continue;
            ++n2;
            arrayList.add(new Integer(n));
        }
        if (n2 != 0) {
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = (Integer)arrayList.get(n);
            }
        }
        return nArray;
    }

    public static int[] indicesOf(int[] nArray, int n) {
        int n2;
        int[] nArray2 = null;
        int n3 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] != n) continue;
            ++n3;
            arrayList.add(new Integer(n2));
        }
        if (n3 != 0) {
            nArray2 = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray2[n2] = (Integer)arrayList.get(n2);
            }
        }
        return nArray2;
    }

    public static int[] indicesOf(short[] sArray, short s) {
        int n;
        int[] nArray = null;
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < sArray.length; ++n) {
            if (sArray[n] != s) continue;
            ++n2;
            arrayList.add(new Integer(n));
        }
        if (n2 != 0) {
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = (Integer)arrayList.get(n);
            }
        }
        return nArray;
    }

    public static int[] indicesOf(byte[] byArray, byte by) {
        int n;
        int[] nArray = null;
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] != by) continue;
            ++n2;
            arrayList.add(new Integer(n));
        }
        if (n2 != 0) {
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = (Integer)arrayList.get(n);
            }
        }
        return nArray;
    }

    public static int[] indicesOf(char[] cArray, char c) {
        int n;
        int[] nArray = null;
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] != c) continue;
            ++n2;
            arrayList.add(new Integer(n));
        }
        if (n2 != 0) {
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = (Integer)arrayList.get(n);
            }
        }
        return nArray;
    }

    public static int[] indicesOf(String[] stringArray, String string) {
        int n;
        int[] nArray = null;
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals(string)) continue;
            ++n2;
            arrayList.add(new Integer(n));
        }
        if (n2 != 0) {
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = (Integer)arrayList.get(n);
            }
        }
        return nArray;
    }

    public static int[] indicesOf(Object[] objectArray, Object object) {
        int n;
        int[] nArray = null;
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < objectArray.length; ++n) {
            if (!objectArray[n].equals(object)) continue;
            ++n2;
            arrayList.add(new Integer(n));
        }
        if (n2 != 0) {
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = (Integer)arrayList.get(n);
            }
        }
        return nArray;
    }

    public static int indexOf(double[] dArray, double d) {
        int n = -1;
        boolean bl = true;
        int n2 = 0;
        while (bl) {
            if (dArray[n2] == d) {
                n = n2;
                bl = false;
                continue;
            }
            if (++n2 < dArray.length) continue;
            bl = false;
        }
        return n;
    }

    public static int indexOf(float[] fArray, float f) {
        int n = -1;
        boolean bl = true;
        int n2 = 0;
        while (bl) {
            if (fArray[n2] == f) {
                n = n2;
                bl = false;
                continue;
            }
            if (++n2 < fArray.length) continue;
            bl = false;
        }
        return n;
    }

    public static int indexOf(long[] lArray, long l) {
        int n = -1;
        boolean bl = true;
        int n2 = 0;
        while (bl) {
            if (lArray[n2] == l) {
                n = n2;
                bl = false;
                continue;
            }
            if (++n2 < lArray.length) continue;
            bl = false;
        }
        return n;
    }

    public static int indexOf(int[] nArray, int n) {
        int n2 = -1;
        boolean bl = true;
        int n3 = 0;
        while (bl) {
            if (nArray[n3] == n) {
                n2 = n3;
                bl = false;
                continue;
            }
            if (++n3 < nArray.length) continue;
            bl = false;
        }
        return n2;
    }

    public static int indexOf(byte[] byArray, byte by) {
        int n = -1;
        boolean bl = true;
        int n2 = 0;
        while (bl) {
            if (byArray[n2] == by) {
                n = n2;
                bl = false;
                continue;
            }
            if (++n2 < byArray.length) continue;
            bl = false;
        }
        return n;
    }

    public static int indexOf(short[] sArray, short s) {
        int n = -1;
        boolean bl = true;
        int n2 = 0;
        while (bl) {
            if (sArray[n2] == s) {
                n = n2;
                bl = false;
                continue;
            }
            if (++n2 < sArray.length) continue;
            bl = false;
        }
        return n;
    }

    public static int indexOf(char[] cArray, char c) {
        int n = -1;
        boolean bl = true;
        int n2 = 0;
        while (bl) {
            if (cArray[n2] == c) {
                n = n2;
                bl = false;
                continue;
            }
            if (++n2 < cArray.length) continue;
            bl = false;
        }
        return n;
    }

    public static int indexOf(String[] stringArray, String string) {
        int n = -1;
        boolean bl = true;
        int n2 = 0;
        while (bl) {
            if (stringArray[n2].equals(string)) {
                n = n2;
                bl = false;
                continue;
            }
            if (++n2 < stringArray.length) continue;
            bl = false;
        }
        return n;
    }

    public static int indexOf(Object[] objectArray, Object object) {
        int n = -1;
        boolean bl = true;
        int n2 = 0;
        while (bl) {
            if (objectArray[n2].equals(object)) {
                n = n2;
                bl = false;
                continue;
            }
            if (++n2 < objectArray.length) continue;
            bl = false;
        }
        return n;
    }

    public static double nearestElementValue(double[] dArray, double d) {
        double d2 = Math.abs(dArray[0] - d);
        double d3 = dArray[0];
        for (int j = 1; j < dArray.length; ++j) {
            if (!(Math.abs(dArray[j] - d) < d2)) continue;
            d2 = Math.abs(dArray[j] - d);
            d3 = dArray[j];
        }
        return d3;
    }

    public static int nearestElementIndex(double[] dArray, double d) {
        double d2 = Math.abs(dArray[0] - d);
        int n = 0;
        for (int j = 1; j < dArray.length; ++j) {
            if (!(Math.abs(dArray[j] - d) < d2)) continue;
            d2 = Math.abs(dArray[j] - d);
            n = j;
        }
        return n;
    }

    public static double nearestLowerElementValue(double[] dArray, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        boolean bl = true;
        double d5 = dArray[0];
        while (bl) {
            if (dArray[n] < d5) {
                d5 = dArray[n];
            }
            if (d - dArray[n] >= 0.0) {
                d2 = d - dArray[n];
                d4 = dArray[n];
                bl = false;
                continue;
            }
            if (++n <= dArray.length - 1) continue;
            d4 = d5;
            d2 = d5 - d;
            bl = false;
        }
        for (int j = 0; j < dArray.length; ++j) {
            d3 = d - dArray[j];
            if (!(d3 >= 0.0) || !(d3 < d2)) continue;
            d2 = d3;
            d4 = dArray[j];
        }
        return d4;
    }

    public static int nearestLowerElementIndex(double[] dArray, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        double d4 = dArray[0];
        int n3 = 0;
        while (bl) {
            if (dArray[n2] < d4) {
                d4 = dArray[n2];
                n3 = n2;
            }
            if (d - dArray[n2] >= 0.0) {
                d2 = d - dArray[n2];
                n = n2;
                bl = false;
                continue;
            }
            if (++n2 <= dArray.length - 1) continue;
            n = n3;
            d2 = d4 - d;
            bl = false;
        }
        for (int j = 0; j < dArray.length; ++j) {
            d3 = d - dArray[j];
            if (!(d3 >= 0.0) || !(d3 < d2)) continue;
            d2 = d3;
            n = j;
        }
        return n;
    }

    public static double nearestHigherElementValue(double[] dArray, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        boolean bl = true;
        double d5 = dArray[0];
        while (bl) {
            if (dArray[n] > d5) {
                d5 = dArray[n];
            }
            if (dArray[n] - d >= 0.0) {
                d2 = d - dArray[n];
                d4 = dArray[n];
                bl = false;
                continue;
            }
            if (++n <= dArray.length - 1) continue;
            d4 = d5;
            d2 = d - d5;
            bl = false;
        }
        for (int j = 0; j < dArray.length; ++j) {
            d3 = dArray[j] - d;
            if (!(d3 >= 0.0) || !(d3 < d2)) continue;
            d2 = d3;
            d4 = dArray[j];
        }
        return d4;
    }

    public static int nearestHigherElementIndex(double[] dArray, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        double d4 = dArray[0];
        int n3 = 0;
        while (bl) {
            if (dArray[n2] > d4) {
                d4 = dArray[n2];
                n3 = n2;
            }
            if (dArray[n2] - d >= 0.0) {
                d2 = d - dArray[n2];
                n = n2;
                bl = false;
                continue;
            }
            if (++n2 <= dArray.length - 1) continue;
            n = n3;
            d2 = d - d4;
            bl = false;
        }
        for (int j = 0; j < dArray.length; ++j) {
            d3 = dArray[j] - d;
            if (!(d3 >= 0.0) || !(d3 < d2)) continue;
            d2 = d3;
            n = j;
        }
        return n;
    }

    public static int nearestElementValue(int[] nArray, int n) {
        int n2 = Math.abs(nArray[0] - n);
        int n3 = nArray[0];
        for (int j = 1; j < nArray.length; ++j) {
            if (Math.abs(nArray[j] - n) >= n2) continue;
            n2 = Math.abs(nArray[j] - n);
            n3 = nArray[j];
        }
        return n3;
    }

    public static int nearestElementIndex(int[] nArray, int n) {
        int n2 = Math.abs(nArray[0] - n);
        int n3 = 0;
        for (int j = 1; j < nArray.length; ++j) {
            if (Math.abs(nArray[j] - n) >= n2) continue;
            n2 = Math.abs(nArray[j] - n);
            n3 = j;
        }
        return n3;
    }

    public static int nearestLowerElementValue(int[] nArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = true;
        int n6 = nArray[0];
        while (bl) {
            if (nArray[n5] < n6) {
                n6 = nArray[n5];
            }
            if (n - nArray[n5] >= 0) {
                n2 = n - nArray[n5];
                n4 = nArray[n5];
                bl = false;
                continue;
            }
            if (++n5 <= nArray.length - 1) continue;
            n4 = n6;
            n2 = n6 - n;
            bl = false;
        }
        for (int j = 0; j < nArray.length; ++j) {
            n3 = n - nArray[j];
            if (n3 < 0 || n3 >= n2) continue;
            n2 = n3;
            n4 = nArray[j];
        }
        return n4;
    }

    public static int nearestLowerElementIndex(int[] nArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = true;
        int n6 = nArray[0];
        int n7 = 0;
        while (bl) {
            if (nArray[n5] < n6) {
                n6 = nArray[n5];
                n7 = n5;
            }
            if (n - nArray[n5] >= 0) {
                n2 = n - nArray[n5];
                n4 = n5;
                bl = false;
                continue;
            }
            if (++n5 <= nArray.length - 1) continue;
            n4 = n7;
            n2 = n6 - n;
            bl = false;
        }
        for (int j = 0; j < nArray.length; ++j) {
            n3 = n - nArray[j];
            if (n3 < 0 || n3 >= n2) continue;
            n2 = n3;
            n4 = j;
        }
        return n4;
    }

    public static int nearestHigherElementValue(int[] nArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = true;
        int n6 = nArray[0];
        while (bl) {
            if (nArray[n5] > n6) {
                n6 = nArray[n5];
            }
            if (nArray[n5] - n >= 0) {
                n2 = n - nArray[n5];
                n4 = nArray[n5];
                bl = false;
                continue;
            }
            if (++n5 <= nArray.length - 1) continue;
            n4 = n6;
            n2 = n - n6;
            bl = false;
        }
        for (int j = 0; j < nArray.length; ++j) {
            n3 = nArray[j] - n;
            if (n3 < 0 || n3 >= n2) continue;
            n2 = n3;
            n4 = nArray[j];
        }
        return n4;
    }

    public static int nearestHigherElementIndex(int[] nArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = true;
        int n6 = nArray[0];
        int n7 = 0;
        while (bl) {
            if (nArray[n5] > n6) {
                n6 = nArray[n5];
                n7 = n5;
            }
            if (nArray[n5] - n >= 0) {
                n2 = n - nArray[n5];
                n4 = n5;
                bl = false;
                continue;
            }
            if (++n5 <= nArray.length - 1) continue;
            n4 = n7;
            n2 = n - n6;
            bl = false;
        }
        for (int j = 0; j < nArray.length; ++j) {
            n3 = nArray[j] - n;
            if (n3 < 0 || n3 >= n2) continue;
            n2 = n3;
            n4 = j;
        }
        return n4;
    }

    public static double arraySum(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        return d;
    }

    public static float arraySum(float[] fArray) {
        float f = 0.0f;
        for (float f2 : fArray) {
            f += f2;
        }
        return f;
    }

    public static int arraySum(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            n += n2;
        }
        return n;
    }

    public static long arraySum(long[] lArray) {
        long l = 0L;
        for (long l2 : lArray) {
            l += l2;
        }
        return l;
    }

    public static long arrayPositiveElementsSum(long[] lArray) {
        long l = 0L;
        for (long l2 : lArray) {
            if (l2 <= 0L) continue;
            l += l2;
        }
        return l;
    }

    public static double arrayProduct(double[] dArray) {
        double d = 1.0;
        for (double d2 : dArray) {
            d *= d2;
        }
        return d;
    }

    public static float arrayProduct(float[] fArray) {
        float f = 1.0f;
        for (float f2 : fArray) {
            f *= f2;
        }
        return f;
    }

    public static int arrayProduct(int[] nArray) {
        int n = 1;
        for (int n2 : nArray) {
            n *= n2;
        }
        return n;
    }

    public static long arrayProduct(long[] lArray) {
        long l = 1L;
        for (long l2 : lArray) {
            l *= l2;
        }
        return l;
    }

    public static double[] concatenate(double[] dArray, double[] dArray2) {
        int n;
        int n2 = dArray.length;
        int n3 = dArray2.length;
        int n4 = n2 + n3;
        double[] dArray3 = new double[n4];
        for (n = 0; n < n2; ++n) {
            dArray3[n] = dArray[n];
        }
        for (n = 0; n < n3; ++n) {
            dArray3[n + n2] = dArray2[n];
        }
        return dArray3;
    }

    public static float[] concatenate(float[] fArray, float[] fArray2) {
        int n;
        int n2 = fArray.length;
        int n3 = fArray2.length;
        int n4 = n2 + n3;
        float[] fArray3 = new float[n4];
        for (n = 0; n < n2; ++n) {
            fArray3[n] = fArray[n];
        }
        for (n = 0; n < n3; ++n) {
            fArray3[n + n2] = fArray2[n];
        }
        return fArray3;
    }

    public static int[] concatenate(int[] nArray, int[] nArray2) {
        int n;
        int n2 = nArray.length;
        int n3 = nArray2.length;
        int n4 = n2 + n3;
        int[] nArray3 = new int[n4];
        for (n = 0; n < n2; ++n) {
            nArray3[n] = nArray[n];
        }
        for (n = 0; n < n3; ++n) {
            nArray3[n + n2] = nArray2[n];
        }
        return nArray3;
    }

    public static long[] concatenate(long[] lArray, long[] lArray2) {
        int n;
        int n2 = lArray.length;
        int n3 = lArray2.length;
        int n4 = n2 + n3;
        long[] lArray3 = new long[n4];
        for (n = 0; n < n2; ++n) {
            lArray3[n] = lArray[n];
        }
        for (n = 0; n < n3; ++n) {
            lArray3[n + n2] = lArray2[n];
        }
        return lArray3;
    }

    public static short[] concatenate(short[] sArray, short[] sArray2) {
        int n;
        int n2 = sArray.length;
        int n3 = sArray2.length;
        int n4 = n2 + n3;
        short[] sArray3 = new short[n4];
        for (n = 0; n < n2; ++n) {
            sArray3[n] = sArray[n];
        }
        for (n = 0; n < n3; ++n) {
            sArray3[n + n2] = sArray2[n];
        }
        return sArray3;
    }

    public static byte[] concatenate(byte[] byArray, byte[] byArray2) {
        int n;
        int n2 = byArray.length;
        int n3 = byArray2.length;
        int n4 = n2 + n3;
        byte[] byArray3 = new byte[n4];
        for (n = 0; n < n2; ++n) {
            byArray3[n] = byArray[n];
        }
        for (n = 0; n < n3; ++n) {
            byArray3[n + n2] = byArray2[n];
        }
        return byArray3;
    }

    public static char[] concatenate(char[] cArray, char[] cArray2) {
        int n;
        int n2 = cArray.length;
        int n3 = cArray2.length;
        int n4 = n2 + n3;
        char[] cArray3 = new char[n4];
        for (n = 0; n < n2; ++n) {
            cArray3[n] = cArray[n];
        }
        for (n = 0; n < n3; ++n) {
            cArray3[n + n2] = cArray2[n];
        }
        return cArray3;
    }

    public static String[] concatenate(String[] stringArray, String[] stringArray2) {
        int n;
        int n2 = stringArray.length;
        int n3 = stringArray2.length;
        int n4 = n2 + n3;
        String[] stringArray3 = new String[n4];
        for (n = 0; n < n2; ++n) {
            stringArray3[n] = stringArray[n];
        }
        for (n = 0; n < n3; ++n) {
            stringArray3[n + n2] = stringArray2[n];
        }
        return stringArray3;
    }

    public static Object[] concatenate(Object[] objectArray, Object[] objectArray2) {
        int n;
        int n2 = objectArray.length;
        int n3 = objectArray2.length;
        int n4 = n2 + n3;
        Object[] objectArray3 = new Object[n4];
        for (n = 0; n < n2; ++n) {
            objectArray3[n] = objectArray[n];
        }
        for (n = 0; n < n3; ++n) {
            objectArray3[n + n2] = objectArray2[n];
        }
        return objectArray3;
    }

    public static double[] floatTOdouble(float[] fArray) {
        int n = fArray.length;
        double[] dArray = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray[j] = fArray[j];
        }
        return dArray;
    }

    public static double[] intTOdouble(int[] nArray) {
        int n = nArray.length;
        double[] dArray = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray[j] = nArray[j];
        }
        return dArray;
    }

    public static float[] intTOfloat(int[] nArray) {
        int n = nArray.length;
        float[] fArray = new float[n];
        for (int j = 0; j < n; ++j) {
            fArray[j] = nArray[j];
        }
        return fArray;
    }

    public static long[] intTOlong(int[] nArray) {
        int n = nArray.length;
        long[] lArray = new long[n];
        for (int j = 0; j < n; ++j) {
            lArray[j] = nArray[j];
        }
        return lArray;
    }

    public static double[] longTOdouble(long[] lArray) {
        int n = lArray.length;
        double[] dArray = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray[j] = lArray[j];
        }
        return dArray;
    }

    public static float[] longTOfloat(long[] lArray) {
        int n = lArray.length;
        float[] fArray = new float[n];
        for (int j = 0; j < n; ++j) {
            fArray[j] = lArray[j];
        }
        return fArray;
    }

    public static double[] shortTOdouble(short[] sArray) {
        int n = sArray.length;
        double[] dArray = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray[j] = sArray[j];
        }
        return dArray;
    }

    public static float[] shortTOfloat(short[] sArray) {
        int n = sArray.length;
        float[] fArray = new float[n];
        for (int j = 0; j < n; ++j) {
            fArray[j] = sArray[j];
        }
        return fArray;
    }

    public static long[] shortTOlong(short[] sArray) {
        int n = sArray.length;
        long[] lArray = new long[n];
        for (int j = 0; j < n; ++j) {
            lArray[j] = sArray[j];
        }
        return lArray;
    }

    public static int[] shortTOint(short[] sArray) {
        int n = sArray.length;
        int[] nArray = new int[n];
        for (int j = 0; j < n; ++j) {
            nArray[j] = sArray[j];
        }
        return nArray;
    }

    public static double[] byteTOdouble(byte[] byArray) {
        int n = byArray.length;
        double[] dArray = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray[j] = byArray[j];
        }
        return dArray;
    }

    public static float[] byteTOfloat(byte[] byArray) {
        int n = byArray.length;
        float[] fArray = new float[n];
        for (int j = 0; j < n; ++j) {
            fArray[j] = byArray[j];
        }
        return fArray;
    }

    public static long[] byteTOlong(byte[] byArray) {
        int n = byArray.length;
        long[] lArray = new long[n];
        for (int j = 0; j < n; ++j) {
            lArray[j] = byArray[j];
        }
        return lArray;
    }

    public static int[] byteTOint(byte[] byArray) {
        int n = byArray.length;
        int[] nArray = new int[n];
        for (int j = 0; j < n; ++j) {
            nArray[j] = byArray[j];
        }
        return nArray;
    }

    public static short[] byteTOshort(byte[] byArray) {
        int n = byArray.length;
        short[] sArray = new short[n];
        for (int j = 0; j < n; ++j) {
            sArray[j] = byArray[j];
        }
        return sArray;
    }

    public static int[] doubleTOint(double[] dArray) {
        int n = dArray.length;
        int[] nArray = new int[n];
        for (int j = 0; j < n; ++j) {
            nArray[j] = (int)dArray[j];
        }
        return nArray;
    }

    public static void print(double[] dArray) {
        for (int j = 0; j < dArray.length; ++j) {
            System.out.print(dArray[j] + "   ");
        }
        System.out.println();
    }

    public static void println(double[] dArray) {
        for (int j = 0; j < dArray.length; ++j) {
            System.out.println(dArray[j] + "   ");
        }
    }

    public static void print(float[] fArray) {
        for (int j = 0; j < fArray.length; ++j) {
            System.out.print(fArray[j] + "   ");
        }
        System.out.println();
    }

    public static void println(float[] fArray) {
        for (int j = 0; j < fArray.length; ++j) {
            System.out.println(fArray[j] + "   ");
        }
    }

    public static void print(int[] nArray) {
        for (int j = 0; j < nArray.length; ++j) {
            System.out.print(nArray[j] + "   ");
        }
        System.out.println();
    }

    public static void println(int[] nArray) {
        for (int j = 0; j < nArray.length; ++j) {
            System.out.println(nArray[j] + "   ");
        }
    }

    public static void print(long[] lArray) {
        for (int j = 0; j < lArray.length; ++j) {
            System.out.print(lArray[j] + "   ");
        }
        System.out.println();
    }

    public static void println(long[] lArray) {
        for (int j = 0; j < lArray.length; ++j) {
            System.out.println(lArray[j] + "   ");
        }
    }

    public static void print(char[] cArray) {
        for (int j = 0; j < cArray.length; ++j) {
            System.out.print(cArray[j] + "   ");
        }
        System.out.println();
    }

    public static void println(char[] cArray) {
        for (int j = 0; j < cArray.length; ++j) {
            System.out.println(cArray[j] + "   ");
        }
    }

    public static void print(String[] stringArray) {
        for (int j = 0; j < stringArray.length; ++j) {
            System.out.print(stringArray[j] + "   ");
        }
        System.out.println();
    }

    public static void println(String[] stringArray) {
        for (int j = 0; j < stringArray.length; ++j) {
            System.out.println(stringArray[j] + "   ");
        }
    }

    public static void print(short[] sArray) {
        for (int j = 0; j < sArray.length; ++j) {
            System.out.print(sArray[j] + "   ");
        }
        System.out.println();
    }

    public static void println(short[] sArray) {
        for (int j = 0; j < sArray.length; ++j) {
            System.out.println(sArray[j] + "   ");
        }
    }

    public static void print(byte[] byArray) {
        for (int j = 0; j < byArray.length; ++j) {
            System.out.print(byArray[j] + "   ");
        }
        System.out.println();
    }

    public static void println(byte[] byArray) {
        for (int j = 0; j < byArray.length; ++j) {
            System.out.println(byArray[j] + "   ");
        }
    }

    public static void print(double[][] dArray) {
        for (int j = 0; j < dArray.length; ++j) {
            Fmath.print(dArray[j]);
        }
    }

    public static Vector<Object> selectSortVector(double[] dArray) {
        ArrayList<Object> arrayList = Fmath.selectSortArrayList(dArray);
        Vector<Object> vector = null;
        if (arrayList != null) {
            int n = arrayList.size();
            vector = new Vector<Object>(n);
            for (int j = 0; j < n; ++j) {
                vector.addElement(arrayList.get(j));
            }
        }
        return vector;
    }

    public static ArrayList<Object> selectSortArrayList(double[] dArray) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = dArray.length;
        double d = 0.0;
        int n5 = 0;
        double[] dArray2 = new double[n4];
        int[] nArray = new int[n4];
        for (n = 0; n < n4; ++n) {
            dArray2[n] = dArray[n];
            nArray[n] = n;
        }
        while (n3 != n4 - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < n4; ++n) {
                if (!(dArray2[n] < dArray2[n2])) continue;
                n2 = n;
            }
            d = dArray2[n2];
            dArray2[n2] = dArray2[++n3];
            dArray2[n3] = d;
            n5 = nArray[n2];
            nArray[n2] = nArray[n3];
            nArray[n3] = n5;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(dArray);
        arrayList.add(dArray2);
        arrayList.add(nArray);
        return arrayList;
    }

    public static double[] selectionSort(double[] dArray) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = dArray.length;
        double d = 0.0;
        double[] dArray2 = new double[n4];
        for (n = 0; n < n4; ++n) {
            dArray2[n] = dArray[n];
        }
        while (n3 != n4 - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < n4; ++n) {
                if (!(dArray2[n] < dArray2[n2])) continue;
                n2 = n;
            }
            d = dArray2[n2];
            dArray2[n2] = dArray2[++n3];
            dArray2[n3] = d;
        }
        return dArray2;
    }

    public static float[] selectionSort(float[] fArray) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = fArray.length;
        float f = 0.0f;
        float[] fArray2 = new float[n4];
        for (n = 0; n < n4; ++n) {
            fArray2[n] = fArray[n];
        }
        while (n3 != n4 - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < n4; ++n) {
                if (!(fArray2[n] < fArray2[n2])) continue;
                n2 = n;
            }
            f = fArray2[n2];
            fArray2[n2] = fArray2[++n3];
            fArray2[n3] = f;
        }
        return fArray2;
    }

    public static int[] selectionSort(int[] nArray) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = nArray.length;
        int n5 = 0;
        int[] nArray2 = new int[n4];
        for (n = 0; n < n4; ++n) {
            nArray2[n] = nArray[n];
        }
        while (n3 != n4 - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < n4; ++n) {
                if (nArray2[n] >= nArray2[n2]) continue;
                n2 = n;
            }
            n5 = nArray2[n2];
            nArray2[n2] = nArray2[++n3];
            nArray2[n3] = n5;
        }
        return nArray2;
    }

    public static long[] selectionSort(long[] lArray) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = lArray.length;
        long l = 0L;
        long[] lArray2 = new long[n4];
        for (n = 0; n < n4; ++n) {
            lArray2[n] = lArray[n];
        }
        while (n3 != n4 - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < n4; ++n) {
                if (lArray2[n] >= lArray2[n2]) continue;
                n2 = n;
            }
            l = lArray2[n2];
            lArray2[n2] = lArray2[++n3];
            lArray2[n3] = l;
        }
        return lArray2;
    }

    public static void selectionSort(double[] dArray, double[] dArray2, int[] nArray) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = dArray.length;
        double d = 0.0;
        int n5 = 0;
        for (n = 0; n < n4; ++n) {
            dArray2[n] = dArray[n];
            nArray[n] = n;
        }
        while (n3 != n4 - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < n4; ++n) {
                if (!(dArray2[n] < dArray2[n2])) continue;
                n2 = n;
            }
            d = dArray2[n2];
            dArray2[n2] = dArray2[++n3];
            dArray2[n3] = d;
            n5 = nArray[n2];
            nArray[n2] = nArray[n3];
            nArray[n3] = n5;
        }
    }

    public static void selectionSort(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = dArray.length;
        int n5 = dArray2.length;
        if (n4 != n5) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n4 + ") and the second argument array, bb, (length = " + n5 + ") should be the same length");
        }
        int n6 = dArray3.length;
        if (n6 < n4) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + n6 + ") should be at least as long as the first argument array, aa, (length = " + n4 + ")");
        }
        int n7 = dArray4.length;
        if (n7 < n5) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + n7 + ") should be at least as long as the second argument array, bb, (length = " + n5 + ")");
        }
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < n4; ++n) {
            dArray3[n] = dArray[n];
            dArray4[n] = dArray2[n];
        }
        while (n3 != n4 - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < n4; ++n) {
                if (!(dArray3[n] < dArray3[n2])) continue;
                n2 = n;
            }
            d = dArray3[n2];
            dArray3[n2] = dArray3[++n3];
            dArray3[n3] = d;
            d2 = dArray4[n2];
            dArray4[n2] = dArray4[n3];
            dArray4[n3] = d2;
        }
    }

    public static void selectionSort(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = fArray.length;
        int n5 = fArray2.length;
        if (n4 != n5) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n4 + ") and the second argument array, bb, (length = " + n5 + ") should be the same length");
        }
        int n6 = fArray3.length;
        if (n6 < n4) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + n6 + ") should be at least as long as the first argument array, aa, (length = " + n4 + ")");
        }
        int n7 = fArray4.length;
        if (n7 < n5) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + n7 + ") should be at least as long as the second argument array, bb, (length = " + n5 + ")");
        }
        float f = 0.0f;
        float f2 = 0.0f;
        for (n = 0; n < n4; ++n) {
            fArray3[n] = fArray[n];
            fArray4[n] = fArray2[n];
        }
        while (n3 != n4 - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < n4; ++n) {
                if (!(fArray3[n] < fArray3[n2])) continue;
                n2 = n;
            }
            f = fArray3[n2];
            fArray3[n2] = fArray3[++n3];
            fArray3[n3] = f;
            f2 = fArray4[n2];
            fArray4[n2] = fArray4[n3];
            fArray4[n3] = f2;
        }
    }

    public static void selectionSort(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = lArray.length;
        int n5 = lArray2.length;
        if (n4 != n5) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n4 + ") and the second argument array, bb, (length = " + n5 + ") should be the same length");
        }
        int n6 = lArray3.length;
        if (n6 < n4) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + n6 + ") should be at least as long as the first argument array, aa, (length = " + n4 + ")");
        }
        int n7 = lArray4.length;
        if (n7 < n5) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + n7 + ") should be at least as long as the second argument array, bb, (length = " + n5 + ")");
        }
        long l = 0L;
        long l2 = 0L;
        for (n = 0; n < n4; ++n) {
            lArray3[n] = lArray[n];
            lArray4[n] = lArray2[n];
        }
        while (n3 != n4 - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < n4; ++n) {
                if (lArray3[n] >= lArray3[n2]) continue;
                n2 = n;
            }
            l = lArray3[n2];
            lArray3[n2] = lArray3[++n3];
            lArray3[n3] = l;
            l2 = lArray4[n2];
            lArray4[n2] = lArray4[n3];
            lArray4[n3] = l2;
        }
    }

    public static void selectionSort(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = nArray.length;
        int n5 = nArray2.length;
        if (n4 != n5) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n4 + ") and the second argument array, bb, (length = " + n5 + ") should be the same length");
        }
        int n6 = nArray3.length;
        if (n6 < n4) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + n6 + ") should be at least as long as the first argument array, aa, (length = " + n4 + ")");
        }
        int n7 = nArray4.length;
        if (n7 < n5) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + n7 + ") should be at least as long as the second argument array, bb, (length = " + n5 + ")");
        }
        int n8 = 0;
        int n9 = 0;
        for (n = 0; n < n4; ++n) {
            nArray3[n] = nArray[n];
            nArray4[n] = nArray2[n];
        }
        while (n3 != n4 - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < n4; ++n) {
                if (nArray3[n] >= nArray3[n2]) continue;
                n2 = n;
            }
            n8 = nArray3[n2];
            nArray3[n2] = nArray3[++n3];
            nArray3[n3] = n8;
            n9 = nArray4[n2];
            nArray4[n2] = nArray4[n3];
            nArray4[n3] = n9;
        }
    }

    public static void selectionSort(double[] dArray, long[] lArray, double[] dArray2, long[] lArray2) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = dArray.length;
        int n5 = lArray.length;
        if (n4 != n5) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n4 + ") and the second argument array, bb, (length = " + n5 + ") should be the same length");
        }
        int n6 = dArray2.length;
        if (n6 < n4) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + n6 + ") should be at least as long as the first argument array, aa, (length = " + n4 + ")");
        }
        int n7 = lArray2.length;
        if (n7 < n5) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + n7 + ") should be at least as long as the second argument array, bb, (length = " + n5 + ")");
        }
        double d = 0.0;
        long l = 0L;
        for (n = 0; n < n4; ++n) {
            dArray2[n] = dArray[n];
            lArray2[n] = lArray[n];
        }
        while (n3 != n4 - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < n4; ++n) {
                if (!(dArray2[n] < dArray2[n2])) continue;
                n2 = n;
            }
            d = dArray2[n2];
            dArray2[n2] = dArray2[++n3];
            dArray2[n3] = d;
            l = lArray2[n2];
            lArray2[n2] = lArray2[n3];
            lArray2[n3] = l;
        }
    }

    public static void selectionSort(long[] lArray, double[] dArray, long[] lArray2, double[] dArray2) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = lArray.length;
        int n5 = dArray.length;
        if (n4 != n5) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n4 + ") and the second argument array, bb, (length = " + n5 + ") should be the same length");
        }
        int n6 = lArray2.length;
        if (n6 < n4) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + n6 + ") should be at least as long as the first argument array, aa, (length = " + n4 + ")");
        }
        int n7 = dArray2.length;
        if (n7 < n5) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + n7 + ") should be at least as long as the second argument array, bb, (length = " + n5 + ")");
        }
        long l = 0L;
        double d = 0.0;
        for (n = 0; n < n4; ++n) {
            lArray2[n] = lArray[n];
            dArray2[n] = dArray[n];
        }
        while (n3 != n4 - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < n4; ++n) {
                if (lArray2[n] >= lArray2[n2]) continue;
                n2 = n;
            }
            l = lArray2[n2];
            lArray2[n2] = lArray2[++n3];
            lArray2[n3] = l;
            d = dArray2[n2];
            dArray2[n2] = dArray2[n3];
            dArray2[n3] = d;
        }
    }

    public static void selectionSort(double[] dArray, int[] nArray, double[] dArray2, int[] nArray2) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = dArray.length;
        int n5 = nArray.length;
        if (n4 != n5) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n4 + ") and the second argument array, bb, (length = " + n5 + ") should be the same length");
        }
        int n6 = dArray2.length;
        if (n6 < n4) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + n6 + ") should be at least as long as the first argument array, aa, (length = " + n4 + ")");
        }
        int n7 = nArray2.length;
        if (n7 < n5) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + n7 + ") should be at least as long as the second argument array, bb, (length = " + n5 + ")");
        }
        double d = 0.0;
        int n8 = 0;
        for (n = 0; n < n4; ++n) {
            dArray2[n] = dArray[n];
            nArray2[n] = nArray[n];
        }
        while (n3 != n4 - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < n4; ++n) {
                if (!(dArray2[n] < dArray2[n2])) continue;
                n2 = n;
            }
            d = dArray2[n2];
            dArray2[n2] = dArray2[++n3];
            dArray2[n3] = d;
            n8 = nArray2[n2];
            nArray2[n2] = nArray2[n3];
            nArray2[n3] = n8;
        }
    }

    public static void selectionSort(int[] nArray, double[] dArray, int[] nArray2, double[] dArray2) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = nArray.length;
        int n5 = dArray.length;
        if (n4 != n5) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n4 + ") and the second argument array, bb, (length = " + n5 + ") should be the same length");
        }
        int n6 = nArray2.length;
        if (n6 < n4) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + n6 + ") should be at least as long as the first argument array, aa, (length = " + n4 + ")");
        }
        int n7 = dArray2.length;
        if (n7 < n5) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + n7 + ") should be at least as long as the second argument array, bb, (length = " + n5 + ")");
        }
        int n8 = 0;
        double d = 0.0;
        for (n = 0; n < n4; ++n) {
            nArray2[n] = nArray[n];
            dArray2[n] = dArray[n];
        }
        while (n3 != n4 - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < n4; ++n) {
                if (nArray2[n] >= nArray2[n2]) continue;
                n2 = n;
            }
            n8 = nArray2[n2];
            nArray2[n2] = nArray2[++n3];
            nArray2[n3] = n8;
            d = dArray2[n2];
            dArray2[n2] = dArray2[n3];
            dArray2[n3] = d;
        }
    }

    public static void selectionSort(long[] lArray, int[] nArray, long[] lArray2, int[] nArray2) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = lArray.length;
        int n5 = nArray.length;
        if (n4 != n5) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n4 + ") and the second argument array, bb, (length = " + n5 + ") should be the same length");
        }
        int n6 = lArray2.length;
        if (n6 < n4) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + n6 + ") should be at least as long as the first argument array, aa, (length = " + n4 + ")");
        }
        int n7 = nArray2.length;
        if (n7 < n5) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + n7 + ") should be at least as long as the second argument array, bb, (length = " + n5 + ")");
        }
        long l = 0L;
        int n8 = 0;
        for (n = 0; n < n4; ++n) {
            lArray2[n] = lArray[n];
            nArray2[n] = nArray[n];
        }
        while (n3 != n4 - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < n4; ++n) {
                if (lArray2[n] >= lArray2[n2]) continue;
                n2 = n;
            }
            l = lArray2[n2];
            lArray2[n2] = lArray2[++n3];
            lArray2[n3] = l;
            n8 = nArray2[n2];
            nArray2[n2] = nArray2[n3];
            nArray2[n3] = n8;
        }
    }

    public static void selectionSort(int[] nArray, long[] lArray, int[] nArray2, long[] lArray2) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = nArray.length;
        int n5 = lArray.length;
        if (n4 != n5) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n4 + ") and the second argument array, bb, (length = " + n5 + ") should be the same length");
        }
        int n6 = nArray2.length;
        if (n6 < n4) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + n6 + ") should be at least as long as the first argument array, aa, (length = " + n4 + ")");
        }
        int n7 = lArray2.length;
        if (n7 < n5) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + n7 + ") should be at least as long as the second argument array, bb, (length = " + n5 + ")");
        }
        int n8 = 0;
        long l = 0L;
        for (n = 0; n < n4; ++n) {
            nArray2[n] = nArray[n];
            lArray2[n] = lArray[n];
        }
        while (n3 != n4 - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < n4; ++n) {
                if (nArray2[n] >= nArray2[n2]) continue;
                n2 = n;
            }
            n8 = nArray2[n2];
            nArray2[n2] = nArray2[++n3];
            nArray2[n3] = n8;
            l = lArray2[n2];
            lArray2[n2] = lArray2[n3];
            lArray2[n3] = l;
        }
    }

    public static void selectSort(double[] dArray, double[] dArray2, int[] nArray) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = dArray2.length;
        int n5 = dArray.length;
        if (n4 < n5) {
            throw new IllegalArgumentException("The second argument array, bb, (length = " + n4 + ") should be at least as long as the first argument array, aa, (length = " + n5 + ")");
        }
        int n6 = nArray.length;
        if (n4 < n5) {
            throw new IllegalArgumentException("The third argument array, indices, (length = " + n6 + ") should be at least as long as the first argument array, aa, (length = " + n5 + ")");
        }
        double d = 0.0;
        int n7 = 0;
        for (n = 0; n < n5; ++n) {
            dArray2[n] = dArray[n];
            nArray[n] = n;
        }
        while (n3 != n5 - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < n5; ++n) {
                if (!(dArray2[n] < dArray2[n2])) continue;
                n2 = n;
            }
            d = dArray2[n2];
            dArray2[n2] = dArray2[++n3];
            dArray2[n3] = d;
            n7 = nArray[n2];
            nArray[n2] = nArray[n3];
            nArray[n3] = n7;
        }
    }

    public static double[] copy(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = dArray[j];
        }
        return dArray2;
    }

    public static float[] copy(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        int n = fArray.length;
        float[] fArray2 = new float[n];
        for (int j = 0; j < n; ++j) {
            fArray2[j] = fArray[j];
        }
        return fArray2;
    }

    public static int[] copy(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        int[] nArray2 = new int[n];
        for (int j = 0; j < n; ++j) {
            nArray2[j] = nArray[j];
        }
        return nArray2;
    }

    public static long[] copy(long[] lArray) {
        if (lArray == null) {
            return null;
        }
        int n = lArray.length;
        long[] lArray2 = new long[n];
        for (int j = 0; j < n; ++j) {
            lArray2[j] = lArray[j];
        }
        return lArray2;
    }

    public static double[][] copy(double[][] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        double[][] dArrayArray = new double[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = dArray[j].length;
            dArrayArray[j] = new double[n2];
            for (int k = 0; k < n2; ++k) {
                dArrayArray[j][k] = dArray[j][k];
            }
        }
        return dArrayArray;
    }

    public static float[][] copy(float[][] fArray) {
        if (fArray == null) {
            return null;
        }
        int n = fArray.length;
        float[][] fArrayArray = new float[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = fArray[j].length;
            fArrayArray[j] = new float[n2];
            for (int k = 0; k < n2; ++k) {
                fArrayArray[j][k] = fArray[j][k];
            }
        }
        return fArrayArray;
    }

    public static int[][] copy(int[][] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        int[][] nArrayArray = new int[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = nArray[j].length;
            nArrayArray[j] = new int[n2];
            for (int k = 0; k < n2; ++k) {
                nArrayArray[j][k] = nArray[j][k];
            }
        }
        return nArrayArray;
    }

    public static long[][] copy(long[][] lArray) {
        if (lArray == null) {
            return null;
        }
        int n = lArray.length;
        long[][] lArrayArray = new long[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = lArray[j].length;
            lArrayArray[j] = new long[n2];
            for (int k = 0; k < n2; ++k) {
                lArrayArray[j][k] = lArray[j][k];
            }
        }
        return lArrayArray;
    }

    public static double[][][] copy(double[][][] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        double[][][] dArrayArray = new double[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = dArray[j].length;
            dArrayArray[j] = new double[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = dArray[j][k].length;
                dArrayArray[j][k] = new double[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    dArrayArray[j][k][i2] = dArray[j][k][i2];
                }
            }
        }
        return dArrayArray;
    }

    public static float[][][] copy(float[][][] fArray) {
        if (fArray == null) {
            return null;
        }
        int n = fArray.length;
        float[][][] fArrayArray = new float[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = fArray[j].length;
            fArrayArray[j] = new float[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = fArray[j][k].length;
                fArrayArray[j][k] = new float[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    fArrayArray[j][k][i2] = fArray[j][k][i2];
                }
            }
        }
        return fArrayArray;
    }

    public static int[][][] copy(int[][][] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        int[][][] nArrayArray = new int[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = nArray[j].length;
            nArrayArray[j] = new int[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = nArray[j][k].length;
                nArrayArray[j][k] = new int[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    nArrayArray[j][k][i2] = nArray[j][k][i2];
                }
            }
        }
        return nArrayArray;
    }

    public static long[][][] copy(long[][][] lArray) {
        if (lArray == null) {
            return null;
        }
        int n = lArray.length;
        long[][][] lArrayArray = new long[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = lArray[j].length;
            lArrayArray[j] = new long[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = lArray[j][k].length;
                lArrayArray[j][k] = new long[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    lArrayArray[j][k][i2] = lArray[j][k][i2];
                }
            }
        }
        return lArrayArray;
    }

    public static double[][][][] copy(double[][][][] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        double[][][][] dArrayArray = new double[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = dArray[j].length;
            dArrayArray[j] = new double[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = dArray[j][k].length;
                dArrayArray[j][k] = new double[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = dArray[j][k][i2].length;
                    dArrayArray[j][k][i2] = new double[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        dArrayArray[j][k][i2][i3] = dArray[j][k][i2][i3];
                    }
                }
            }
        }
        return dArrayArray;
    }

    public static float[][][][] copy(float[][][][] fArray) {
        if (fArray == null) {
            return null;
        }
        int n = fArray.length;
        float[][][][] fArrayArray = new float[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = fArray[j].length;
            fArrayArray[j] = new float[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = fArray[j][k].length;
                fArrayArray[j][k] = new float[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = fArray[j][k][i2].length;
                    fArrayArray[j][k][i2] = new float[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        fArrayArray[j][k][i2][i3] = fArray[j][k][i2][i3];
                    }
                }
            }
        }
        return fArrayArray;
    }

    public static int[][][][] copy(int[][][][] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        int[][][][] nArrayArray = new int[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = nArray[j].length;
            nArrayArray[j] = new int[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = nArray[j][k].length;
                nArrayArray[j][k] = new int[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = nArray[j][k][i2].length;
                    nArrayArray[j][k][i2] = new int[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        nArrayArray[j][k][i2][i3] = nArray[j][k][i2][i3];
                    }
                }
            }
        }
        return nArrayArray;
    }

    public static long[][][][] copy(long[][][][] lArray) {
        if (lArray == null) {
            return null;
        }
        int n = lArray.length;
        long[][][][] lArrayArray = new long[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = lArray[j].length;
            lArrayArray[j] = new long[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = lArray[j][k].length;
                lArrayArray[j][k] = new long[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = lArray[j][k][i2].length;
                    lArrayArray[j][k][i2] = new long[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        lArrayArray[j][k][i2][i3] = lArray[j][k][i2][i3];
                    }
                }
            }
        }
        return lArrayArray;
    }

    public static String[] copy(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int j = 0; j < n; ++j) {
            stringArray2[j] = stringArray[j];
        }
        return stringArray2;
    }

    public static String[][] copy(String[][] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        String[][] stringArray2 = new String[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = stringArray[j].length;
            stringArray2[j] = new String[n2];
            for (int k = 0; k < n2; ++k) {
                stringArray2[j][k] = stringArray[j][k];
            }
        }
        return stringArray2;
    }

    public static String[][][] copy(String[][][] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        String[][][] stringArray2 = new String[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = stringArray[j].length;
            stringArray2[j] = new String[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = stringArray[j][k].length;
                stringArray2[j][k] = new String[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    stringArray2[j][k][i2] = stringArray[j][k][i2];
                }
            }
        }
        return stringArray2;
    }

    public static String[][][][] copy(String[][][][] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        String[][][][] stringArray2 = new String[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = stringArray[j].length;
            stringArray2[j] = new String[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = stringArray[j][k].length;
                stringArray2[j][k] = new String[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = stringArray[j][k][i2].length;
                    stringArray2[j][k][i2] = new String[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        stringArray2[j][k][i2][i3] = stringArray[j][k][i2][i3];
                    }
                }
            }
        }
        return stringArray2;
    }

    public static boolean[] copy(boolean[] blArray) {
        if (blArray == null) {
            return null;
        }
        int n = blArray.length;
        boolean[] blArray2 = new boolean[n];
        for (int j = 0; j < n; ++j) {
            blArray2[j] = blArray[j];
        }
        return blArray2;
    }

    public static boolean[][] copy(boolean[][] blArray) {
        if (blArray == null) {
            return null;
        }
        int n = blArray.length;
        boolean[][] blArrayArray = new boolean[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = blArray[j].length;
            blArrayArray[j] = new boolean[n2];
            for (int k = 0; k < n2; ++k) {
                blArrayArray[j][k] = blArray[j][k];
            }
        }
        return blArrayArray;
    }

    public static boolean[][][] copy(boolean[][][] blArray) {
        if (blArray == null) {
            return null;
        }
        int n = blArray.length;
        boolean[][][] blArrayArray = new boolean[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = blArray[j].length;
            blArrayArray[j] = new boolean[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = blArray[j][k].length;
                blArrayArray[j][k] = new boolean[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    blArrayArray[j][k][i2] = blArray[j][k][i2];
                }
            }
        }
        return blArrayArray;
    }

    public static boolean[][][][] copy(boolean[][][][] blArray) {
        if (blArray == null) {
            return null;
        }
        int n = blArray.length;
        boolean[][][][] blArrayArray = new boolean[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = blArray[j].length;
            blArrayArray[j] = new boolean[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = blArray[j][k].length;
                blArrayArray[j][k] = new boolean[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = blArray[j][k][i2].length;
                    blArrayArray[j][k][i2] = new boolean[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        blArrayArray[j][k][i2][i3] = blArray[j][k][i2][i3];
                    }
                }
            }
        }
        return blArrayArray;
    }

    public static char[] copy(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        int n = cArray.length;
        char[] cArray2 = new char[n];
        for (int j = 0; j < n; ++j) {
            cArray2[j] = cArray[j];
        }
        return cArray2;
    }

    public static char[][] copy(char[][] cArray) {
        if (cArray == null) {
            return null;
        }
        int n = cArray.length;
        char[][] cArrayArray = new char[n][];
        for (int j = 0; j < n; ++j) {
            int n2 = cArray[j].length;
            cArrayArray[j] = new char[n2];
            for (int k = 0; k < n2; ++k) {
                cArrayArray[j][k] = cArray[j][k];
            }
        }
        return cArrayArray;
    }

    public static char[][][] copy(char[][][] cArray) {
        if (cArray == null) {
            return null;
        }
        int n = cArray.length;
        char[][][] cArrayArray = new char[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = cArray[j].length;
            cArrayArray[j] = new char[n2][];
            for (int k = 0; k < n2; ++k) {
                int n3 = cArray[j][k].length;
                cArrayArray[j][k] = new char[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    cArrayArray[j][k][i2] = cArray[j][k][i2];
                }
            }
        }
        return cArrayArray;
    }

    public static char[][][][] copy(char[][][][] cArray) {
        if (cArray == null) {
            return null;
        }
        int n = cArray.length;
        char[][][][] cArrayArray = new char[n][][][];
        for (int j = 0; j < n; ++j) {
            int n2 = cArray[j].length;
            cArrayArray[j] = new char[n2][][];
            for (int k = 0; k < n2; ++k) {
                int n3 = cArray[j][k].length;
                cArrayArray[j][k] = new char[n3][];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = cArray[j][k][i2].length;
                    cArrayArray[j][k][i2] = new char[n4];
                    for (int i3 = 0; i3 < n4; ++i3) {
                        cArrayArray[j][k][i2][i3] = cArray[j][k][i2][i3];
                    }
                }
            }
        }
        return cArrayArray;
    }

    public static Object copy(Object object) {
        if (object == null) {
            return null;
        }
        return Fmath.copyObject(object);
    }

    public static Object copyObject(Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            object2 = objectInputStream.readObject();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return object2;
    }

    public static double radToDeg(double d) {
        return d * 180.0 / Math.PI;
    }

    public static double degToRad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double frequencyToRadialFrequency(double d) {
        return Math.PI * 2 * d;
    }

    public static double radialFrequencyToFrequency(double d) {
        return d / (Math.PI * 2);
    }

    public static double evToNm(double d) {
        return 2.99792458E17 / (-d * -1.60217646263E-19 / 6.6260687652E-34);
    }

    public static double nmToEv(double d) {
        return 2.99792458E8 / (-d * 1.0E-9) * 6.6260687652E-34 / -1.60217646263E-19;
    }

    public static double molarToPercentWeightByVol(double d, double d2) {
        return d * d2 / 10.0;
    }

    public static double percentWeightByVolToMolar(double d, double d2) {
        return d * 10.0 / d2;
    }

    public static double celsiusToKelvin(double d) {
        return d - -273.15;
    }

    public static double kelvinToCelsius(double d) {
        return d + -273.15;
    }

    public static double celsiusToFahren(double d) {
        return d * 1.8 + 32.0;
    }

    public static double fahrenToCelsius(double d) {
        return (d - 32.0) * 5.0 / 9.0;
    }

    public static double calorieToJoule(double d) {
        return d * 4.1868;
    }

    public static double jouleToCalorie(double d) {
        return d * 0.23884;
    }

    public static double gramToOunce(double d) {
        return d / 28.3459;
    }

    public static double ounceToGram(double d) {
        return d * 28.3459;
    }

    public static double kgToPound(double d) {
        return d / 0.4536;
    }

    public static double poundToKg(double d) {
        return d * 0.4536;
    }

    public static double kgToTon(double d) {
        return d / 1016.05;
    }

    public static double tonToKg(double d) {
        return d * 1016.05;
    }

    public static double millimetreToInch(double d) {
        return d / 25.4;
    }

    public static double inchToMillimetre(double d) {
        return d * 25.4;
    }

    public static double footToMetre(double d) {
        return d * 0.3048;
    }

    public static double metreToFoot(double d) {
        return d / 0.3048;
    }

    public static double yardToMetre(double d) {
        return d * 0.9144;
    }

    public static double metreToYard(double d) {
        return d / 0.9144;
    }

    public static double mileToKm(double d) {
        return d * 1.6093;
    }

    public static double kmToMile(double d) {
        return d / 1.6093;
    }

    public static double gallonToLitre(double d) {
        return d * 4.546;
    }

    public static double litreToGallon(double d) {
        return d / 4.546;
    }

    public static double quartToLitre(double d) {
        return d * 1.137;
    }

    public static double litreToQuart(double d) {
        return d / 1.137;
    }

    public static double pintToLitre(double d) {
        return d * 0.568;
    }

    public static double litreToPint(double d) {
        return d / 0.568;
    }

    public static double gallonPerMileToLitrePerKm(double d) {
        return d * 2.825;
    }

    public static double litrePerKmToGallonPerMile(double d) {
        return d / 2.825;
    }

    public static double milePerGallonToKmPerLitre(double d) {
        return d * 0.354;
    }

    public static double kmPerLitreToMilePerGallon(double d) {
        return d / 0.354;
    }

    public static double fluidOunceUKtoUS(double d) {
        return d * 0.961;
    }

    public static double fluidOunceUStoUK(double d) {
        return d * 1.041;
    }

    public static double pintUKtoUS(double d) {
        return d * 1.201;
    }

    public static double pintUStoUK(double d) {
        return d * 0.833;
    }

    public static double quartUKtoUS(double d) {
        return d * 1.201;
    }

    public static double quartUStoUK(double d) {
        return d * 0.833;
    }

    public static double gallonUKtoUS(double d) {
        return d * 1.201;
    }

    public static double gallonUStoUK(double d) {
        return d * 0.833;
    }

    public static double pintUKtoCupUS(double d) {
        return d / 0.417;
    }

    public static double cupUStoPintUK(double d) {
        return d * 0.417;
    }

    public static double calcBMImetric(double d, double d2) {
        return d2 / (d * d);
    }

    public static double calcBMIimperial(double d, double d2) {
        d = Fmath.footToMetre(d);
        d2 = Fmath.poundToKg(d2);
        return d2 / (d * d);
    }

    public static double calcWeightFromBMImetric(double d, double d2) {
        return d * d2 * d2;
    }

    public static double calcWeightFromBMIimperial(double d, double d2) {
        d2 = Fmath.footToMetre(d2);
        double d3 = d * d2 * d2;
        d3 = Fmath.kgToPound(d3);
        return d3;
    }

    static {
        integers.put(Integer.class, BigDecimal.valueOf(Integer.MAX_VALUE));
        integers.put(Long.class, BigDecimal.valueOf(Long.MAX_VALUE));
        integers.put(Byte.class, BigDecimal.valueOf(127L));
        integers.put(Short.class, BigDecimal.valueOf(32767L));
        integers.put(BigInteger.class, BigDecimal.valueOf(-1L));
    }
}

