/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.complex.Complex;
import flanagan.io.FileInput;
import flanagan.io.FileOutput;
import flanagan.math.Fmath;
import flanagan.plot.PlotGraph;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.JFrame;

public class FourierTransform
extends Canvas
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Complex[] complexData = null;
    private Complex[] complexCorr = null;
    private boolean complexDataSet = false;
    private int originalDataLength = 0;
    private int fftDataLength = 0;
    private boolean dataAltered = false;
    private double[] fftData = null;
    private double[] fftCorr = null;
    private double[] fftResp = null;
    private boolean fftDataSet = false;
    private double[] fftDataWindow = null;
    private double[] fftCorrWindow = null;
    private int windowOption = 0;
    private String[] windowNames = new String[]{"no windowing applied", "Rectangular (square, box-car)", "Bartlett (triangular)", "Welch", "Hann (Hanning)", "Hamming", "Kaiser", "Gaussian"};
    private String windowName = this.windowNames[0];
    private double kaiserAlpha = 2.0;
    private double gaussianAlpha = 2.5;
    private double[] weights = null;
    private boolean windowSet = false;
    private boolean windowApplied = false;
    private double sumOfSquaredWeights = 0.0;
    private Complex[] transformedDataComplex = null;
    private double[] transformedDataFft = null;
    private boolean fftDone = false;
    private double[][] powerSpectrumEstimate = null;
    private boolean powSpecDone = false;
    private int psdNumberOfPoints = 0;
    private int segmentNumber = 1;
    private int segmentLength = 0;
    private boolean overlap = false;
    private boolean segNumSet = false;
    private boolean segLenSet = false;
    private double deltaT = 1.0;
    private boolean deltaTset = false;
    private double[][] correlationArray = null;
    private boolean correlateDone = false;
    private int numberOfWarnings = 9;
    private boolean[] warning = new boolean[this.numberOfWarnings];
    private int plotLineOption = 0;
    private int plotPointOption = 0;
    private double[][] timeFrequency = null;
    private boolean shortTimeDone = false;
    private int numShortFreq = 0;
    private int numShortTimes = 0;
    private String shortTitle = " ";

    public FourierTransform() {
        for (int j = 0; j < this.numberOfWarnings; ++j) {
            this.warning[j] = false;
        }
    }

    public FourierTransform(double[] dArray) {
        int n;
        int n2;
        this.originalDataLength = dArray.length;
        this.fftDataLength = FourierTransform.nextPowerOfTwo(this.originalDataLength);
        this.complexData = Complex.oneDarray(this.fftDataLength);
        for (n2 = 0; n2 < this.originalDataLength; ++n2) {
            this.complexData[n2].setReal(dArray[n2]);
            this.complexData[n2].setImag(0.0);
        }
        for (n2 = this.originalDataLength; n2 < this.fftDataLength; ++n2) {
            this.complexData[n2].reset(0.0, 0.0);
        }
        this.complexDataSet = true;
        this.fftData = new double[2 * this.fftDataLength];
        n2 = 0;
        for (n = 0; n < this.fftDataLength; ++n) {
            this.fftData[n2] = this.complexData[n].getReal();
            this.fftData[++n2] = 0.0;
            ++n2;
        }
        this.fftDataSet = true;
        this.fftDataWindow = new double[2 * this.fftDataLength];
        this.weights = new double[this.fftDataLength];
        this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
        this.transformedDataFft = new double[2 * this.fftDataLength];
        this.transformedDataComplex = Complex.oneDarray(this.fftDataLength);
        this.segmentLength = this.fftDataLength;
        for (n = 0; n < this.numberOfWarnings; ++n) {
            this.warning[n] = false;
        }
    }

    public FourierTransform(Complex[] complexArray) {
        int n;
        int n2;
        this.originalDataLength = complexArray.length;
        this.fftDataLength = FourierTransform.nextPowerOfTwo(this.originalDataLength);
        this.complexData = Complex.oneDarray(this.fftDataLength);
        for (n2 = 0; n2 < this.originalDataLength; ++n2) {
            this.complexData[n2] = complexArray[n2].copy();
        }
        for (n2 = this.originalDataLength; n2 < this.fftDataLength; ++n2) {
            this.complexData[n2].reset(0.0, 0.0);
        }
        this.complexDataSet = true;
        this.fftData = new double[2 * this.fftDataLength];
        n2 = 0;
        for (n = 0; n < this.fftDataLength; ++n) {
            this.fftData[n2] = this.complexData[n].getReal();
            this.fftData[++n2] = this.complexData[n].getImag();
            ++n2;
        }
        this.fftDataSet = true;
        this.fftDataWindow = new double[2 * this.fftDataLength];
        this.weights = new double[this.fftDataLength];
        this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
        this.transformedDataFft = new double[2 * this.fftDataLength];
        this.transformedDataComplex = Complex.oneDarray(this.fftDataLength);
        this.segmentLength = this.fftDataLength;
        for (n = 0; n < this.numberOfWarnings; ++n) {
            this.warning[n] = false;
        }
    }

    public void setData(double[] dArray) {
        int n;
        this.originalDataLength = dArray.length;
        this.fftDataLength = FourierTransform.nextPowerOfTwo(this.originalDataLength);
        this.complexData = Complex.oneDarray(this.fftDataLength);
        for (n = 0; n < this.originalDataLength; ++n) {
            this.complexData[n].setReal(dArray[n]);
            this.complexData[n].setImag(0.0);
        }
        for (n = this.originalDataLength; n < this.fftDataLength; ++n) {
            this.complexData[n].reset(0.0, 0.0);
        }
        this.complexDataSet = true;
        this.fftData = new double[2 * this.fftDataLength];
        n = 0;
        for (int j = 0; j < this.fftDataLength; ++j) {
            this.fftData[n] = this.complexData[j].getReal();
            this.fftData[++n] = 0.0;
            ++n;
        }
        this.fftDataSet = true;
        this.fftDataWindow = new double[2 * this.fftDataLength];
        this.weights = new double[this.fftDataLength];
        this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
        this.transformedDataFft = new double[2 * this.fftDataLength];
        this.transformedDataComplex = Complex.oneDarray(this.fftDataLength);
        if (this.segNumSet) {
            this.setSegmentNumber(this.segmentNumber);
        } else if (this.segLenSet) {
            this.setSegmentLength(this.segmentLength);
        } else {
            this.segmentLength = this.fftDataLength;
        }
    }

    public void setData(Complex[] complexArray) {
        int n;
        this.originalDataLength = complexArray.length;
        this.fftDataLength = FourierTransform.nextPowerOfTwo(this.originalDataLength);
        this.complexData = Complex.oneDarray(this.fftDataLength);
        for (n = 0; n < this.originalDataLength; ++n) {
            this.complexData[n] = complexArray[n].copy();
        }
        for (n = this.originalDataLength; n < this.fftDataLength; ++n) {
            this.complexData[n].reset(0.0, 0.0);
        }
        this.complexDataSet = true;
        this.fftData = new double[2 * this.fftDataLength];
        n = 0;
        for (int j = 0; j < this.fftDataLength; ++j) {
            this.fftData[n] = this.complexData[j].getReal();
            this.fftData[++n] = this.complexData[j].getImag();
            ++n;
        }
        this.fftDataSet = true;
        this.fftDataWindow = new double[2 * this.fftDataLength];
        this.weights = new double[this.fftDataLength];
        this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
        this.transformedDataFft = new double[2 * this.fftDataLength];
        this.transformedDataComplex = Complex.oneDarray(this.fftDataLength);
        if (this.segNumSet) {
            this.setSegmentNumber(this.segmentNumber);
        } else if (this.segLenSet) {
            this.setSegmentLength(this.segmentLength);
        } else {
            this.segmentLength = this.fftDataLength;
        }
    }

    public void setFftData(double[] dArray) {
        int n;
        if (dArray.length % 2 != 0) {
            throw new IllegalArgumentException("data length must be an even number");
        }
        this.originalDataLength = dArray.length / 2;
        this.fftDataLength = FourierTransform.nextPowerOfTwo(this.originalDataLength);
        this.fftData = new double[2 * this.fftDataLength];
        for (n = 0; n < 2 * this.originalDataLength; ++n) {
            this.fftData[n] = dArray[n];
        }
        for (n = 2 * this.originalDataLength; n < 2 * this.fftDataLength; ++n) {
            this.fftData[n] = 0.0;
        }
        this.fftDataSet = true;
        this.complexData = Complex.oneDarray(this.fftDataLength);
        n = -1;
        for (int j = 0; j < this.fftDataLength; ++j) {
            this.complexData[j].setReal(this.fftData[++n]);
            this.complexData[j].setImag(this.fftData[++n]);
        }
        this.complexDataSet = true;
        this.fftDataWindow = new double[2 * this.fftDataLength];
        this.weights = new double[this.fftDataLength];
        this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
        this.transformedDataFft = new double[2 * this.fftDataLength];
        this.transformedDataComplex = Complex.oneDarray(this.fftDataLength);
        if (this.segNumSet) {
            this.setSegmentNumber(this.segmentNumber);
        } else if (this.segLenSet) {
            this.setSegmentLength(this.segmentLength);
        } else {
            this.segmentLength = this.fftDataLength;
        }
    }

    public Complex[] getComplexInputData() {
        if (!this.complexDataSet) {
            System.out.println("complex data set not entered or calculated - null returned");
        }
        return this.complexData;
    }

    public double[] getAlternateInputData() {
        if (!this.fftDataSet) {
            System.out.println("fft data set not entered or calculted - null returned");
        }
        return this.fftData;
    }

    public double[] getAlternateWindowedInputData() {
        if (!this.fftDataSet) {
            System.out.println("fft data set not entered or calculted - null returned");
        }
        if (!this.fftDataSet) {
            System.out.println("fft data set not entered or calculted - null returned");
        }
        if (!this.windowApplied) {
            System.out.println("fft data set has not been multiplied by windowing weights");
        }
        return this.fftDataWindow;
    }

    public int getOriginalDataLength() {
        return this.originalDataLength;
    }

    public int getUsedDataLength() {
        return this.fftDataLength;
    }

    public void setDeltaT(double d) {
        this.deltaT = d;
        this.deltaTset = true;
    }

    public double getDeltaT() {
        double d = 0.0;
        if (this.deltaTset) {
            d = this.deltaT;
        } else {
            System.out.println("detaT has not been set - zero returned");
        }
        return d;
    }

    public void setRectangular() {
        this.windowOption = 1;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setBartlett() {
        this.windowOption = 2;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setWelch() {
        this.windowOption = 3;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setHann() {
        this.windowOption = 4;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setHamming() {
        this.windowOption = 5;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setKaiser(double d) {
        this.kaiserAlpha = d;
        this.windowOption = 6;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setKaiser() {
        this.windowOption = 6;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setGaussian(double d) {
        if (d < 2.0) {
            d = 2.0;
            System.out.println("setGaussian; alpha must be greater than or equal to 2 - alpha has been reset to 2");
        }
        this.gaussianAlpha = d;
        this.windowOption = 7;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setGaussian() {
        this.windowOption = 7;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void removeWindow() {
        this.windowOption = 0;
        this.windowSet = false;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = false;
        }
    }

    private double windowData(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray.length;
        int n2 = n / 2 - 1;
        int n3 = 0;
        double d = 0.0;
        switch (this.windowOption) {
            case 0: 
            case 1: {
                for (int j = 0; j <= n2; ++j) {
                    dArray3[j] = 1.0;
                    dArray2[n3] = dArray[n3++];
                    dArray2[n3] = dArray[n3++];
                }
                d = n2 + 1;
                break;
            }
            case 2: {
                for (int j = 0; j <= n2; ++j) {
                    dArray3[j] = 1.0 - (double)Math.abs((j - n2 / 2) / n2 / 2);
                    d += dArray3[j] * dArray3[j];
                    dArray2[n3] = dArray[n3++] * dArray3[j];
                    dArray2[n3] = dArray[n3++] * dArray3[j];
                }
                break;
            }
            case 3: {
                for (int j = 0; j <= n2; ++j) {
                    dArray3[j] = 1.0 - (double)Fmath.square((j - n2 / 2) / n2 / 2);
                    d += dArray3[j] * dArray3[j];
                    dArray2[n3] = dArray[n3++] * dArray3[j];
                    dArray2[n3] = dArray[n3++] * dArray3[j];
                }
                break;
            }
            case 4: {
                for (int j = 0; j <= n2; ++j) {
                    dArray3[j] = (1.0 - Math.cos(2.0 * (double)j * Math.PI / (double)n2)) / 2.0;
                    d += dArray3[j] * dArray3[j];
                    dArray2[n3] = dArray[n3++] * dArray3[j];
                    dArray2[n3] = dArray[n3++] * dArray3[j];
                }
                break;
            }
            case 5: {
                for (int j = 0; j <= n2; ++j) {
                    dArray3[j] = 0.54 + 0.46 * Math.cos(2.0 * (double)j * Math.PI / (double)n2);
                    d += dArray3[j] * dArray3[j];
                    dArray2[n3] = dArray[n3++] * dArray3[j];
                    dArray2[n3] = dArray[n3++] * dArray3[j];
                }
                break;
            }
            case 6: {
                double d2 = FourierTransform.modBesselIo(Math.PI * this.kaiserAlpha);
                double d3 = 0.0;
                for (int j = 0; j <= n2; ++j) {
                    d3 = FourierTransform.modBesselIo(Math.PI * this.kaiserAlpha * Math.sqrt(1.0 - Fmath.square(2.0 * (double)j / (double)n2 - 1.0)));
                    dArray3[j] = d3 / d2;
                    d += dArray3[j] * dArray3[j];
                    dArray2[n3] = dArray[n3++] * dArray3[j];
                    dArray2[n3] = dArray[n3++] * dArray3[j];
                }
                break;
            }
            case 7: {
                for (int j = 0; j <= n2; ++j) {
                    dArray3[j] = Math.exp(-0.5 * Fmath.square(this.gaussianAlpha * (double)(2 * j - n2) / (double)n2));
                    d += dArray3[j] * dArray3[j];
                    dArray2[n3] = dArray[n3++] * dArray3[j];
                    dArray2[n3] = dArray[n3++] * dArray3[j];
                }
                break;
            }
        }
        return d;
    }

    public static double modBesselIo(double d) {
        double d2;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        d3 = Math.abs(d);
        if (d2 < 3.75) {
            d4 = d / 3.75;
            d4 *= d4;
            d5 = 1.0 + d4 * (3.5156229 + d4 * (3.08989424 + d4 * (1.2067492 + d4 * (0.2659732 + d4 * (0.0360768 + d4 * 0.0045813)))));
        } else {
            d5 = Math.exp(d3) / Math.sqrt(d3) * (0.39894228 + d4 * (0.01328592 + d4 * (0.00225319 + d4 * (-0.00157565 + d4 * (0.00916281 + d4 * (-0.02057706 + d4 * (0.02635537 + d4 * (-0.01647633 + d4 * 0.00392377))))))));
        }
        return d5;
    }

    public String getWindowOption() {
        String string = " ";
        switch (this.windowOption) {
            case 0: {
                string = "No windowing applied";
                break;
            }
            case 1: {
                string = "Rectangular";
                break;
            }
            case 2: {
                string = "Bartlett";
                break;
            }
            case 3: {
                string = "Welch";
                break;
            }
            case 4: {
                string = "Hann";
                break;
            }
            case 5: {
                string = "Hamming";
                break;
            }
            case 6: {
                string = "Kaiser";
                break;
            }
            case 7: {
                string = "Gaussian";
            }
        }
        return string;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void setSegmentNumber(int n) {
        this.segmentNumber = n;
        this.segNumSet = true;
        if (this.segLenSet) {
            this.segLenSet = false;
        }
    }

    public void setSegmentLength(int n) {
        this.segmentLength = n;
        this.segLenSet = true;
        if (this.segNumSet) {
            this.segNumSet = false;
        }
    }

    private void checkSegmentDetails() {
        int n;
        if (!this.fftDataSet) {
            throw new IllegalArgumentException("No fft data has been entered or calculated");
        }
        if (this.fftDataLength < 2) {
            throw new IllegalArgumentException("More than one point, MANY MORE, are needed");
        }
        if (this.fftDataLength % 2 != 0) {
            System.out.println("Number of data points must be an even number");
            System.out.println("last point deleted");
            --this.fftDataLength;
            this.dataAltered = true;
            this.warning[0] = true;
        }
        if (this.segNumSet && !this.overlap) {
            if (this.fftDataLength % this.segmentNumber == 0) {
                n = this.fftDataLength / this.segmentNumber;
                if (FourierTransform.checkPowerOfTwo(n)) {
                    this.segmentLength = n;
                    this.segLenSet = true;
                } else {
                    System.out.println("segment length is not an integer power of two");
                    System.out.println("segment length reset to total data length, i.e. no segmentation");
                    this.warning[1] = true;
                    this.segmentNumber = 1;
                    this.segmentLength = this.fftDataLength;
                    this.segLenSet = true;
                }
            } else {
                System.out.println("total data length divided by the number of segments is not an integer");
                System.out.println("segment length reset to total data length, i.e. no segmentation");
                this.warning[2] = true;
                this.segmentNumber = 1;
                this.segmentLength = this.fftDataLength;
                this.segLenSet = true;
            }
        }
        if (this.segLenSet && !this.overlap) {
            if (this.fftDataLength % this.segmentLength == 0) {
                if (FourierTransform.checkPowerOfTwo(this.segmentLength)) {
                    this.segmentNumber = this.fftDataLength / this.segmentLength;
                    this.segNumSet = true;
                } else {
                    System.out.println("segment length is not an integer power of two");
                    System.out.println("segment length reset to total data length, i.e. no segmentation");
                    this.warning[1] = true;
                    this.segmentNumber = 1;
                    this.segmentLength = this.fftDataLength;
                    this.segNumSet = true;
                }
            } else {
                System.out.println("total data length divided by the segment length is not an integer");
                System.out.println("segment length reset to total data length, i.e. no segmentation");
                this.warning[3] = true;
                this.segmentNumber = 1;
                this.segmentLength = this.fftDataLength;
                this.segNumSet = true;
            }
        }
        if (this.segNumSet && this.overlap) {
            if (this.fftDataLength % (this.segmentNumber + 1) == 0) {
                n = 2 * this.fftDataLength / (this.segmentNumber + 1);
                if (FourierTransform.checkPowerOfTwo(n)) {
                    this.segmentLength = n;
                    this.segLenSet = true;
                } else {
                    System.out.println("segment length is not an integer power of two");
                    System.out.println("segment length reset to total data length, i.e. no segmentation");
                    this.warning[1] = true;
                    this.segmentNumber = 1;
                    this.segmentLength = this.fftDataLength;
                    this.segLenSet = true;
                    this.overlap = false;
                }
            } else {
                System.out.println("total data length divided by the number of segments plus one is not an integer");
                System.out.println("segment length reset to total data length, i.e. no segmentation");
                this.warning[4] = true;
                this.segmentNumber = 1;
                this.segmentLength = this.fftDataLength;
                this.segLenSet = true;
                this.overlap = false;
            }
        }
        if (this.segLenSet && this.overlap) {
            if (2 * this.fftDataLength % this.segmentLength == 0) {
                if (FourierTransform.checkPowerOfTwo(this.segmentLength)) {
                    this.segmentNumber = 2 * this.fftDataLength / this.segmentLength - 1;
                    this.segNumSet = true;
                } else {
                    System.out.println("segment length is not an integer power of two");
                    System.out.println("segment length reset to total data length, i.e. no segmentation");
                    this.warning[1] = true;
                    this.segmentNumber = 1;
                    this.segmentLength = this.fftDataLength;
                    this.segNumSet = true;
                    this.overlap = false;
                }
            } else {
                System.out.println("twice the total data length divided by the segment length is not an integer");
                System.out.println("segment length reset to total data length, i.e. no segmentation");
                this.warning[5] = true;
                this.segmentNumber = 1;
                this.segmentLength = this.fftDataLength;
                this.segNumSet = true;
                this.overlap = false;
            }
        }
        if (!this.segNumSet && !this.segLenSet) {
            this.segmentNumber = 1;
            this.segNumSet = true;
            this.overlap = false;
        }
        if (this.overlap && this.segmentNumber < 2) {
            System.out.println("Overlap is not possible with less than two segments.");
            System.out.println("Overlap option has been reset to 'no overlap' i.e. to false.");
            this.overlap = false;
            this.segmentNumber = 1;
            this.segNumSet = true;
            this.warning[6] = true;
        }
        n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.segmentNumber == 1 && !FourierTransform.checkPowerOfTwo(this.fftDataLength)) {
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            int n5 = 0;
            int n6 = 2;
            while (bl) {
                n5 = this.fftDataLength / n6;
                if (FourierTransform.checkPowerOfTwo(n5) && this.fftDataLength % n6 == 0) {
                    bl = false;
                    n = n5;
                    n2 = n6;
                    continue;
                }
                if (n5 < 2) {
                    bl2 = false;
                    bl = false;
                    continue;
                }
                ++n6;
            }
            bl = true;
            n6 = 2;
            while (bl) {
                n5 = 2 * (this.fftDataLength / (n6 + 1));
                if (FourierTransform.checkPowerOfTwo(n5) && this.fftDataLength % (n6 + 1) == 0) {
                    bl = false;
                    n3 = n5;
                    n4 = n6;
                    continue;
                }
                if (n5 < 2) {
                    bl3 = false;
                    bl = false;
                    continue;
                }
                ++n6;
            }
            boolean bl4 = true;
            int n7 = 0;
            int n8 = 0;
            boolean bl5 = false;
            if (bl2) {
                if (bl3) {
                    if (n3 > n) {
                        n7 = n3;
                        n8 = n4;
                        bl5 = true;
                    } else {
                        n7 = n;
                        n8 = n2;
                        bl5 = false;
                    }
                } else {
                    n7 = n;
                    n8 = n2;
                    bl5 = false;
                }
            } else if (bl3) {
                n7 = n3;
                n8 = n4;
                bl5 = true;
            } else {
                bl4 = false;
            }
            if (bl4 && this.originalDataLength - n7 <= this.fftDataLength - this.originalDataLength) {
                System.out.println("Data length is not an integer power of two");
                System.out.println("Data cannot be transformed as a single segment");
                System.out.print("The data has been split into " + n8 + " segments of length " + n7);
                if (bl5) {
                    System.out.println(" with 50% overlap");
                } else {
                    System.out.println(" with no overlap");
                }
                this.segmentLength = n7;
                this.segmentNumber = n8;
                this.overlap = bl5;
                this.warning[7] = true;
            } else {
                System.out.println("Data length is not an integer power of two");
                if (this.dataAltered) {
                    System.out.println("Deleted point has been restored and the data has been padded with zeros to give a power of two length");
                    this.warning[0] = false;
                } else {
                    System.out.println("Data has been padded with zeros to give a power of two length");
                }
                this.fftDataLength = this.fftDataLength;
                this.warning[8] = true;
            }
        }
    }

    private void printWarnings(FileOutput fileOutput) {
        if (this.warning[0]) {
            fileOutput.println("WARNING!");
            fileOutput.println("Number of data points must be an even number");
            fileOutput.println("The last point was deleted");
            fileOutput.println();
        }
        if (this.warning[1]) {
            fileOutput.println("WARNING!");
            fileOutput.println("Segment length was not an integer power of two");
            fileOutput.println("Segment length was reset to total data length, i.e. no segmentation");
            fileOutput.println();
        }
        if (this.warning[2]) {
            fileOutput.println("WARNING!");
            fileOutput.println("Total data length divided by the number of segments was not an integer");
            fileOutput.println("Segment length was reset to total data length, i.e. no segmentation");
            fileOutput.println();
        }
        if (this.warning[3]) {
            fileOutput.println("WARNING!");
            fileOutput.println("Total data length divided by the segment length was not an integer");
            fileOutput.println("Segment length was reset to total data length, i.e. no segmentation");
            fileOutput.println();
        }
        if (this.warning[4]) {
            fileOutput.println("WARNING!");
            fileOutput.println("Total data length divided by the number of segments plus one was not an integer");
            fileOutput.println("Segment length was reset to total data length, i.e. no segmentation");
            fileOutput.println();
        }
        if (this.warning[5]) {
            fileOutput.println("WARNING!");
            fileOutput.println("Twice the total data length divided by the segment length was not an integer");
            fileOutput.println("Segment length was reset to total data length, i.e. no segmentation");
            fileOutput.println();
        }
        if (this.warning[6]) {
            fileOutput.println("WARNING!");
            fileOutput.println("Overlap is not possible with less than two segments");
            fileOutput.println("Overlap option has been reset to 'no overlap' i.e. to false");
            fileOutput.println();
        }
        if (this.warning[7]) {
            fileOutput.println("WARNING!");
            fileOutput.println("Data length was not an integer power of two");
            fileOutput.println("The data could not be transformed as a single segment");
            fileOutput.print("The data has been split into " + this.segmentNumber + " segment/s of length " + this.segmentLength);
            if (this.overlap) {
                fileOutput.println(" with 50% overlap");
            } else {
                fileOutput.println(" with no overlap");
            }
            fileOutput.println();
        }
        if (this.warning[8]) {
            fileOutput.println("WARNING!");
            fileOutput.println("Data length was not an integer power of two");
            fileOutput.println("Data has been padded with " + (this.fftDataLength - this.originalDataLength) + " zeros to give an integer power of two length");
            fileOutput.println();
        }
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public int getSegmentLength() {
        return this.segmentLength;
    }

    public void setOverlapOption(boolean bl) {
        boolean bl2 = this.overlap;
        this.overlap = bl;
        if (bl2 != this.overlap && this.fftDataSet) {
            this.setSegmentNumber(this.segmentNumber);
        }
    }

    public boolean getOverlapOption() {
        return this.overlap;
    }

    public static int calcDataLength(boolean bl, int n, int n2) {
        if (bl) {
            return (n2 + 1) * n / 2;
        }
        return n2 * n;
    }

    public void transform() {
        int n;
        int n2 = 1;
        if (!this.fftDataSet) {
            throw new IllegalArgumentException("No data has been entered for the Fast Fourier Transform");
        }
        if (this.originalDataLength != this.fftDataLength) {
            System.out.println("Fast Fourier Transform data length ," + this.originalDataLength + ", is not an integer power of two");
            System.out.println("WARNING!!! Data has been padded with zeros to fill to nearest integer power of two length " + this.fftDataLength);
        }
        double[] dArray = new double[this.fftDataLength * 2];
        for (n = 0; n < this.fftDataLength * 2; ++n) {
            dArray[n] = this.fftDataWindow[n];
        }
        this.basicFft(dArray, this.fftDataLength, n2);
        for (n = 0; n < this.fftDataLength * 2; ++n) {
            this.transformedDataFft[n] = dArray[n];
        }
        for (n = 0; n < this.fftDataLength; ++n) {
            this.transformedDataComplex[n].reset(this.transformedDataFft[2 * n], this.transformedDataFft[2 * n + 1]);
        }
    }

    public void inverse() {
        int n;
        int n2 = -1;
        if (!this.fftDataSet) {
            throw new IllegalArgumentException("No data has been entered for the inverse Fast Fourier Transform");
        }
        if (this.originalDataLength != this.fftDataLength) {
            System.out.println("Fast Fourier Transform data length ," + this.originalDataLength + ", is not an integer power of two");
            System.out.println("WARNING!!! Data has been padded with zeros to fill to nearest integer power of two length " + this.fftDataLength);
        }
        double[] dArray = new double[this.fftDataLength * 2];
        for (n = 0; n < this.fftDataLength * 2; ++n) {
            dArray[n] = this.fftDataWindow[n];
        }
        this.basicFft(dArray, this.fftDataLength, n2);
        for (n = 0; n < this.fftDataLength * 2; ++n) {
            this.transformedDataFft[n] = dArray[n] / (double)this.fftDataLength;
        }
        for (n = 0; n < this.fftDataLength; ++n) {
            this.transformedDataComplex[n].reset(this.transformedDataFft[2 * n], this.transformedDataFft[2 * n + 1]);
        }
    }

    public void basicFft(double[] dArray, int n, int n2) {
        int n3;
        int n4;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = n << 1;
        int n9 = 1;
        int n10 = 0;
        for (n4 = 1; n4 < n8; n4 += 2) {
            n10 = n9 - 1;
            if (n9 > n4) {
                n3 = n4 - 1;
                d = dArray[n10];
                dArray[n10] = dArray[n3];
                dArray[n3] = d;
                d = dArray[n10 + 1];
                dArray[n10 + 1] = dArray[n3 + 1];
                dArray[n3 + 1] = d;
            }
            for (n6 = n8 >> 1; n6 >= 2 && n9 > n6; n9 -= n6, n6 >>= 1) {
            }
            n9 += n6;
        }
        n7 = 2;
        while (n8 > n7) {
            n5 = n7 << 1;
            d5 = (double)n2 * (6.28318530717959 / (double)n7);
            d2 = Math.sin(0.5 * d5);
            d7 = -2.0 * d2 * d2;
            d8 = Math.sin(d5);
            d6 = 1.0;
            d9 = 0.0;
            n6 = 1;
            while (n6 < n7) {
                for (n4 = n6; n4 <= n8; n4 += n5) {
                    n3 = n4 - 1;
                    n10 = n3 + n7;
                    d3 = d6 * dArray[n10] - d9 * dArray[n10 + 1];
                    d4 = d6 * dArray[n10 + 1] + d9 * dArray[n10];
                    dArray[n10] = dArray[n3] - d3;
                    dArray[n10 + 1] = dArray[n3 + 1] - d4;
                    int n11 = n3;
                    dArray[n11] = dArray[n11] + d3;
                    int n12 = n3 + 1;
                    dArray[n12] = dArray[n12] + d4;
                }
                d2 = d6;
                d6 = d2 * d7 - d9 * d8 + d6;
                d9 = d9 * d7 + d2 * d8 + d9;
                n6 = (int)((long)n6 + 2L);
            }
            n7 = n5;
        }
    }

    public Complex[] getTransformedDataAsComplex() {
        return this.transformedDataComplex;
    }

    public double[] getTransformedDataAsAlternate() {
        return this.transformedDataFft;
    }

    public double[][] powerSpectrum() {
        this.checkSegmentDetails();
        this.psdNumberOfPoints = this.segmentLength / 2;
        this.powerSpectrumEstimate = new double[2][this.psdNumberOfPoints];
        if (!this.overlap && this.segmentNumber < 2) {
            int n;
            int n2 = 1;
            if (!this.fftDataSet) {
                throw new IllegalArgumentException("No data has been entered for the Fast Fourier Transform");
            }
            if (!FourierTransform.checkPowerOfTwo(this.fftDataLength)) {
                throw new IllegalArgumentException("Fast Fourier Transform data length ," + this.fftDataLength + ", is not an integer power of two");
            }
            double[] dArray = new double[this.fftDataLength * 2];
            for (n = 0; n < this.fftDataLength * 2; ++n) {
                dArray[n] = this.fftDataWindow[n];
            }
            this.basicFft(dArray, this.fftDataLength, n2);
            for (n = 0; n < this.fftDataLength * 2; ++n) {
                this.transformedDataFft[n] = dArray[n];
            }
            for (n = 0; n < this.fftDataLength; ++n) {
                this.transformedDataComplex[n].reset(this.transformedDataFft[2 * n], this.transformedDataFft[2 * n + 1]);
            }
            this.powerSpectrumEstimate[1][0] = Fmath.square(dArray[0]) + Fmath.square(dArray[1]);
            for (n = 1; n < this.psdNumberOfPoints; ++n) {
                this.powerSpectrumEstimate[1][n] = Fmath.square(dArray[2 * n]) + Fmath.square(dArray[2 * n + 1]) + Fmath.square(dArray[2 * this.segmentLength - 2 * n]) + Fmath.square(dArray[2 * this.segmentLength - 2 * n + 1]);
            }
            for (n = 0; n < this.psdNumberOfPoints; ++n) {
                this.powerSpectrumEstimate[1][n] = 2.0 * this.powerSpectrumEstimate[1][n] / ((double)this.fftDataLength * this.sumOfSquaredWeights);
            }
            for (n = 0; n < this.psdNumberOfPoints; ++n) {
                this.powerSpectrumEstimate[0][n] = (double)n / ((double)this.segmentLength * this.deltaT);
            }
        } else {
            this.powerSpectrumEstimate = this.powerSpectrumSeg();
        }
        this.powSpecDone = true;
        return this.powerSpectrumEstimate;
    }

    public double[][] powerSpectrum(String string) {
        if (!FourierTransform.checkPowerOfTwo(this.segmentLength)) {
            throw new IllegalArgumentException("Fast Fourier Transform segment length ," + this.segmentLength + ", is not an integer power of two");
        }
        FileInput fileInput = new FileInput(string);
        this.psdNumberOfPoints = this.segmentLength / 2;
        this.powerSpectrumEstimate = new double[2][this.psdNumberOfPoints];
        this.fftDataLength = FourierTransform.calcDataLength(this.overlap, this.segmentLength, this.segmentNumber);
        if (!this.overlap && this.segmentNumber < 2) {
            int n;
            int n2;
            this.fftData = new double[2 * this.fftDataLength];
            int n3 = -1;
            for (n2 = 0; n2 < this.segmentLength; ++n2) {
                this.fftData[++n3] = fileInput.readDouble();
                this.fftData[++n3] = fileInput.readDouble();
            }
            this.complexData = Complex.oneDarray(this.fftDataLength);
            n3 = -1;
            for (n2 = 0; n2 < this.fftDataLength; ++n2) {
                this.complexData[n2].setReal(this.fftData[++n3]);
                this.complexData[n2].setImag(this.fftData[++n3]);
            }
            this.fftDataWindow = new double[2 * this.fftDataLength];
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            n2 = 1;
            double[] dArray = new double[this.fftDataLength * 2];
            for (n = 0; n < this.fftDataLength * 2; ++n) {
                dArray[n] = this.fftDataWindow[n];
            }
            this.basicFft(dArray, this.fftDataLength, n2);
            for (n = 0; n < this.fftDataLength * 2; ++n) {
                this.transformedDataFft[n] = dArray[n];
            }
            for (n = 0; n < this.fftDataLength; ++n) {
                this.transformedDataComplex[n].reset(this.transformedDataFft[2 * n], this.transformedDataFft[2 * n + 1]);
            }
            this.powerSpectrumEstimate[1][0] = Fmath.square(dArray[0]) + Fmath.square(dArray[1]);
            for (n = 1; n < this.psdNumberOfPoints; ++n) {
                this.powerSpectrumEstimate[1][n] = Fmath.square(dArray[2 * n]) + Fmath.square(dArray[2 * n + 1]) + Fmath.square(dArray[2 * this.segmentLength - 2 * n]) + Fmath.square(dArray[2 * this.segmentLength - 2 * n + 1]);
            }
            for (n = 0; n < this.psdNumberOfPoints; ++n) {
                this.powerSpectrumEstimate[1][n] = 2.0 * this.powerSpectrumEstimate[1][n] / ((double)this.fftDataLength * this.sumOfSquaredWeights);
            }
            for (n = 0; n < this.psdNumberOfPoints; ++n) {
                this.powerSpectrumEstimate[0][n] = (double)n / ((double)this.segmentLength * this.deltaT);
            }
        } else {
            this.powerSpectrumEstimate = this.powerSpectrumSeg(fileInput);
        }
        this.powSpecDone = true;
        return this.powerSpectrumEstimate;
    }

    private double[][] powerSpectrumSeg() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = this.segmentLength;
        if (this.overlap) {
            n4 /= 2;
        }
        double[] dArray = new double[2 * this.segmentLength];
        this.psdNumberOfPoints = this.segmentLength / 2;
        double[] dArray2 = new double[this.psdNumberOfPoints];
        double[][] dArray3 = new double[2][this.psdNumberOfPoints];
        for (n2 = 0; n2 < this.psdNumberOfPoints; ++n2) {
            dArray3[1][n2] = 0.0;
        }
        n2 = 1;
        for (n = 1; n <= this.segmentNumber; ++n) {
            int n5;
            for (n5 = 0; n5 < 2 * this.segmentLength; ++n5) {
                dArray[n5] = this.fftData[n3 + n5];
            }
            if (n == 1) {
                this.sumOfSquaredWeights = this.windowData(dArray, dArray, this.weights);
            } else {
                n5 = 0;
                for (int j = 0; j < this.segmentLength; ++j) {
                    dArray[n5] = dArray[n5] * this.weights[j];
                    dArray[++n5] = dArray[n5] * this.weights[j];
                    ++n5;
                }
            }
            this.basicFft(dArray, this.segmentLength, n2);
            dArray2[0] = Fmath.square(dArray[0]) + Fmath.square(dArray[1]);
            for (n5 = 1; n5 < this.psdNumberOfPoints; ++n5) {
                dArray2[n5] = Fmath.square(dArray[2 * n5]) + Fmath.square(dArray[2 * n5 + 1]) + Fmath.square(dArray[2 * this.segmentLength - 2 * n5]) + Fmath.square(dArray[2 * this.segmentLength - 2 * n5 + 1]);
            }
            for (n5 = 0; n5 < this.psdNumberOfPoints; ++n5) {
                dArray2[n5] = 2.0 * dArray2[n5] / ((double)this.segmentLength * this.sumOfSquaredWeights);
            }
            for (n5 = 0; n5 < this.psdNumberOfPoints; ++n5) {
                double[] dArray4 = dArray3[1];
                int n6 = n5;
                dArray4[n6] = dArray4[n6] + dArray2[n5];
            }
            n3 += n4;
        }
        n = 0;
        while (n < this.psdNumberOfPoints) {
            double[] dArray5 = dArray3[1];
            int n7 = n++;
            dArray5[n7] = dArray5[n7] / (double)this.segmentNumber;
        }
        for (n = 0; n < this.psdNumberOfPoints; ++n) {
            dArray3[0][n] = (double)n / ((double)this.segmentLength * this.deltaT);
        }
        return dArray3;
    }

    private double[][] powerSpectrumSeg(FileInput fileInput) {
        int n;
        int n2;
        int n3;
        int n4;
        double[] dArray = new double[2 * this.segmentLength];
        this.weights = new double[this.segmentLength];
        double[] dArray2 = new double[2 * this.segmentLength];
        this.psdNumberOfPoints = this.segmentLength / 2;
        double[] dArray3 = new double[this.psdNumberOfPoints];
        double[][] dArray4 = new double[2][this.psdNumberOfPoints];
        for (n4 = 0; n4 < this.psdNumberOfPoints; ++n4) {
            dArray4[1][n4] = 0.0;
        }
        n4 = 1;
        this.sumOfSquaredWeights = this.windowData(dArray2, dArray2, this.weights);
        if (this.overlap) {
            for (n3 = 0; n3 < this.segmentLength; ++n3) {
                dArray[n3] = fileInput.readDouble();
            }
            for (n3 = 1; n3 <= this.segmentNumber; ++n3) {
                for (n2 = 0; n2 < this.segmentLength; ++n2) {
                    dArray[n2 + this.segmentLength] = fileInput.readDouble();
                }
                n2 = -1;
                for (n = 0; n < this.segmentLength; ++n) {
                    dArray[++n2] = dArray[n2] * this.weights[n];
                    dArray[++n2] = dArray[n2] * this.weights[n];
                }
                this.basicFft(dArray, this.segmentLength, n4);
                dArray3[0] = Fmath.square(dArray[0]) + Fmath.square(dArray[1]);
                for (n = 1; n < this.psdNumberOfPoints; ++n) {
                    dArray3[n] = Fmath.square(dArray[2 * n]) + Fmath.square(dArray[2 * n + 1]) + Fmath.square(dArray[2 * this.segmentLength - 2 * n]) + Fmath.square(dArray[2 * this.segmentLength - 2 * n + 1]);
                }
                for (n = 0; n < this.psdNumberOfPoints; ++n) {
                    dArray3[n] = 2.0 * dArray3[n] / ((double)this.segmentLength * this.sumOfSquaredWeights);
                }
                for (n = 0; n < this.psdNumberOfPoints; ++n) {
                    double[] dArray5 = dArray4[1];
                    int n5 = n;
                    dArray5[n5] = dArray5[n5] + dArray3[n];
                }
                for (n = 0; n < this.segmentLength; ++n) {
                    dArray[n] = dArray[n + this.segmentLength];
                }
            }
        } else {
            for (n3 = 1; n3 <= this.segmentNumber; ++n3) {
                for (n2 = 0; n2 < 2 * this.segmentLength; ++n2) {
                    dArray[n2] = fileInput.readDouble();
                }
                n2 = -1;
                for (n = 0; n < this.segmentLength; ++n) {
                    dArray[++n2] = dArray[n2] * this.weights[n];
                    dArray[++n2] = dArray[n2] * this.weights[n];
                }
                this.basicFft(dArray, this.segmentLength, n4);
                dArray3[0] = Fmath.square(dArray[0]) + Fmath.square(dArray[1]);
                for (n = 1; n < this.psdNumberOfPoints; ++n) {
                    dArray3[n] = Fmath.square(dArray[2 * n]) + Fmath.square(dArray[2 * n + 1]) + Fmath.square(dArray[2 * this.segmentLength - 2 * n]) + Fmath.square(dArray[2 * this.segmentLength - 2 * n + 1]);
                }
                for (n = 1; n < this.psdNumberOfPoints; ++n) {
                    dArray3[n] = 2.0 * dArray3[n] / ((double)this.segmentLength * this.sumOfSquaredWeights);
                }
                for (n = 0; n < this.psdNumberOfPoints; ++n) {
                    double[] dArray6 = dArray4[1];
                    int n6 = n;
                    dArray6[n6] = dArray6[n6] + dArray3[n];
                }
            }
        }
        n3 = 0;
        while (n3 < this.psdNumberOfPoints) {
            double[] dArray7 = dArray4[1];
            int n7 = n3++;
            dArray7[n7] = dArray7[n7] / (double)this.segmentNumber;
        }
        for (n3 = 0; n3 < this.psdNumberOfPoints; ++n3) {
            dArray4[0][n3] = (double)n3 / ((double)this.segmentLength * this.deltaT);
        }
        return dArray4;
    }

    public double[][] getpowerSpectrumEstimate() {
        if (!this.powSpecDone) {
            System.out.println("getpowerSpectrumEstimate - powerSpectrum has not been called - null returned");
        }
        return this.powerSpectrumEstimate;
    }

    public int getNumberOfPsdPoints() {
        return this.psdNumberOfPoints;
    }

    public void printPowerSpectrum() {
        String string = "FourierTransformPSD.txt";
        this.printPowerSpectrum(string);
    }

    public void printPowerSpectrum(String string) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        FileOutput fileOutput = new FileOutput(string);
        fileOutput.println("Power Spectrum Density Estimate Output File from FourierTransform");
        fileOutput.dateAndTimeln(string);
        String string2 = "Window: " + this.windowNames[this.windowOption];
        if (this.windowOption == 6) {
            string2 = string2 + ", alpha = " + this.kaiserAlpha;
        }
        if (this.windowOption == 7) {
            string2 = string2 + ", alpha = " + this.gaussianAlpha;
        }
        fileOutput.println(string2);
        fileOutput.printtab("Number of segments = ");
        fileOutput.println(this.segmentNumber);
        fileOutput.printtab("Segment length = ");
        fileOutput.println(this.segmentLength);
        if (this.segmentNumber > 1) {
            if (this.overlap) {
                fileOutput.printtab("Segments overlap by 50%");
            } else {
                fileOutput.printtab("Segments do not overlap");
            }
        }
        fileOutput.println();
        this.printWarnings(fileOutput);
        fileOutput.printtab("Frequency");
        fileOutput.println("Mean Square");
        fileOutput.printtab("(cycles per");
        fileOutput.println("Amplitude");
        if (this.deltaTset) {
            fileOutput.printtab("unit time)");
        } else {
            fileOutput.printtab("gridpoint)");
        }
        fileOutput.println(" ");
        int n = this.powerSpectrumEstimate[0].length;
        for (int j = 0; j < n; ++j) {
            fileOutput.printtab(Fmath.truncate(this.powerSpectrumEstimate[0][j], 4));
            fileOutput.println(Fmath.truncate(this.powerSpectrumEstimate[1][j], 4));
        }
        fileOutput.close();
    }

    public void plotPowerSpectrum(int n) {
        String string = "Estimation of Power Spectrum Density";
        this.plotPowerSpectrum(n, this.powerSpectrumEstimate[0].length - 1, string);
    }

    public void plotPowerSpectrum(int n, String string) {
        this.plotPowerSpectrum(n, this.powerSpectrumEstimate[0].length - 1, string);
    }

    public void plotPowerSpectrum(int n, int n2) {
        String string = "Estimation of Power Spectrum Density";
        this.plotPowerSpectrum(n, n2, string);
    }

    public void plotPowerSpectrum(int n, int n2, String string) {
        if (!this.powSpecDone) {
            System.out.println("plotPowerSpectrum - powerSpectrum has not been called - no plot displayed");
        } else {
            int n3 = this.powerSpectrumEstimate[0].length - 1;
            if (n < 0 || n >= n3) {
                n = 0;
            }
            if (n2 < 0 || n2 > n3) {
                n2 = n3;
            }
            this.plotPowerSpectrumLinear(n, n2, string);
        }
    }

    public void plotPowerSpectrum(double d) {
        String string = "Estimation of Power Spectrum Density";
        this.plotPowerSpectrum(d, string);
    }

    public void plotPowerSpectrum(double d, String string) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        double d2 = this.powerSpectrumEstimate[1][this.powerSpectrumEstimate[0].length - 1];
        this.plotPowerSpectrum(d, d2, string);
    }

    public void plotPowerSpectrum(double d, double d2) {
        if (!this.powSpecDone) {
            System.out.println("plotPowerSpectrum - powerSpectrum has not been called - no plot displayed");
        } else {
            String string = "Estimation of Power Spectrum Density";
            this.plotPowerSpectrum(d, d2, string);
        }
    }

    public void plotPowerSpectrum(double d, double d2, String string) {
        if (!this.powSpecDone) {
            System.out.println("plotPowerSpectrum - powerSpectrum has not been called - no plot displayed");
        } else {
            int n = 0;
            int n2 = 0;
            if (!this.deltaTset) {
                System.out.println("plotPowerSpectrum - deltaT has not been set");
                System.out.println("full spectrum plotted");
            } else {
                int n3 = 0;
                int n4 = this.powerSpectrumEstimate[0].length - 1;
                boolean bl = true;
                if (d == -1.0) {
                    n = 1;
                } else {
                    while (bl) {
                        if (this.powerSpectrumEstimate[0][n3] > d) {
                            n = n3 - 1;
                            if (n < 0) {
                                n = 0;
                            }
                            bl = false;
                            continue;
                        }
                        if (++n3 < n4) continue;
                        n = 0;
                        System.out.println("plotPowerSpectrum - lowFreq out of range -  reset to zero");
                        bl = false;
                    }
                }
                bl = true;
                n3 = 0;
                while (bl) {
                    if (this.powerSpectrumEstimate[0][n3] > d2) {
                        n2 = n3 - 1;
                        if (n2 < 0) {
                            System.out.println("plotPowerSpectrum - highFreq out of range -  reset to highest value");
                            n2 = n4;
                        }
                        bl = false;
                        continue;
                    }
                    if (++n3 < n4) continue;
                    n2 = n4;
                    System.out.println("plotPowerSpectrum - highFreq out of range -  reset to highest value");
                    bl = false;
                }
                this.plotPowerSpectrumLinear(n, n2, string);
            }
        }
    }

    public void plotPowerSpectrum() {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        String string = "Estimation of Power Spectrum Density";
        this.plotPowerSpectrumLinear(0, this.powerSpectrumEstimate[0].length - 1, string);
    }

    public void plotPowerSpectrum(String string) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        this.plotPowerSpectrumLinear(0, this.powerSpectrumEstimate[0].length - 1, string);
    }

    private void plotPowerSpectrumLinear(int n, int n2, String string) {
        int n3 = this.powerSpectrumEstimate[0].length;
        int n4 = n2 - n + 1;
        double[][] dArray = new double[2][n4];
        for (int j = 0; j < n4; ++j) {
            dArray[0][j] = this.powerSpectrumEstimate[0][j + n];
            dArray[1][j] = this.powerSpectrumEstimate[1][j + n];
        }
        String string2 = "Mean Square Amplitude";
        this.plotPowerDisplay(dArray, n, n2, string, string2);
    }

    public void plotPowerLog(int n) {
        String string = "Estimation of Power Spectrum Density";
        this.plotPowerLog(n, this.powerSpectrumEstimate[0].length - 1, string);
    }

    public void plotPowerLog(int n, String string) {
        this.plotPowerLog(n, this.powerSpectrumEstimate[0].length - 1, string);
    }

    public void plotPowerLog(int n, int n2) {
        String string = "Estimation of Power Spectrum Density";
        this.plotPowerLog(n, n2, string);
    }

    public void plotPowerLog(int n, int n2, String string) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        int n3 = this.powerSpectrumEstimate[0].length - 1;
        if (n < 0 || n >= n3) {
            n = 0;
        }
        if (n2 < 0 || n2 > n3) {
            n2 = n3;
        }
        this.plotPowerSpectrumLog(n, n2, string);
    }

    public void plotPowerLog(double d) {
        String string = "Estimation of Power Spectrum Density";
        this.plotPowerLog(d, string);
    }

    public void plotPowerLog(double d, String string) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        double d2 = this.powerSpectrumEstimate[1][this.powerSpectrumEstimate[0].length - 1];
        this.plotPowerLog(d, d2, string);
    }

    public void plotPowerLog(double d, double d2) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        String string = "Estimation of Power Spectrum Density";
        this.plotPowerLog(d, d2, string);
    }

    public void plotPowerLog(double d, double d2, String string) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        int n = 0;
        int n2 = 0;
        if (!this.deltaTset) {
            System.out.println("plotPowerLog - deltaT has not been set");
            System.out.println("full spectrum plotted");
        } else {
            int n3 = 0;
            int n4 = this.powerSpectrumEstimate[0].length - 1;
            boolean bl = true;
            if (d == -1.0) {
                n = 1;
            } else {
                while (bl) {
                    if (this.powerSpectrumEstimate[0][n3] > d) {
                        n = n3 - 1;
                        if (n < 0) {
                            n = 0;
                        }
                        bl = false;
                        continue;
                    }
                    if (++n3 < n4) continue;
                    n = 0;
                    System.out.println("plotPowerLog - lowFreq out of range -  reset to zero");
                    bl = false;
                }
            }
            bl = true;
            n3 = 0;
            while (bl) {
                if (this.powerSpectrumEstimate[0][n3] > d2) {
                    n2 = n3 - 1;
                    if (n2 < 0) {
                        System.out.println("plotPowerLog - highFreq out of range -  reset to highest value");
                        n2 = n4;
                    }
                    bl = false;
                    continue;
                }
                if (++n3 < n4) continue;
                n2 = n4;
                System.out.println("plotPowerSpectrum - highFreq out of range -  reset to highest value");
                bl = false;
            }
            this.plotPowerSpectrumLog(n, n2, string);
        }
    }

    public void plotPowerLog() {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        String string = "Estimation of Power Spectrum Density";
        this.plotPowerSpectrumLog(0, this.powerSpectrumEstimate[0].length - 1, string);
    }

    public void plotPowerLog(String string) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        this.plotPowerSpectrumLog(0, this.powerSpectrumEstimate[0].length - 1, string);
    }

    private void plotPowerSpectrumLog(int n, int n2, String string) {
        int n3;
        int n4;
        int n5 = this.powerSpectrumEstimate[0].length;
        int n6 = n2 - n + 1;
        double[][] dArray = new double[2][n6];
        for (n4 = 0; n4 < n6; ++n4) {
            dArray[0][n4] = this.powerSpectrumEstimate[0][n4 + n];
            dArray[1][n4] = this.powerSpectrumEstimate[1][n4 + n];
        }
        n4 = 1;
        int n7 = 0;
        double d = 0.0;
        while (n4 != 0) {
            if (dArray[1][n7] > 0.0) {
                d = dArray[1][n7];
                n4 = 0;
                continue;
            }
            if (++n7 < n6) continue;
            n4 = 0;
            System.out.println("plotPowerSpectrumLog:  no non-zero amplitudes");
            System.exit(0);
        }
        for (n3 = n7 + 1; n3 < n6; ++n3) {
            if (!(dArray[1][n3] < d)) continue;
            d = dArray[1][n3];
        }
        for (n3 = 0; n3 < n6; ++n3) {
            if (!(dArray[1][n3] <= 0.0)) continue;
            dArray[1][n3] = d;
        }
        for (n3 = 0; n3 < n6; ++n3) {
            dArray[1][n3] = Fmath.log10(dArray[1][n3]);
        }
        String string2 = "Log10(Mean Square Amplitude)";
        this.plotPowerDisplay(dArray, n, n2, string, string2);
    }

    private void plotPowerDisplay(double[][] dArray, int n, int n2, String string, String string2) {
        PlotGraph plotGraph = new PlotGraph(dArray);
        string = string + "  [plot between points " + n + " and " + n2 + "]";
        plotGraph.setGraphTitle(string);
        String string3 = "Window: " + this.windowNames[this.windowOption];
        if (this.windowOption == 6) {
            string3 = string3 + " - alpha = " + this.kaiserAlpha;
        }
        if (this.windowOption == 7) {
            string3 = string3 + " - alpha = " + this.gaussianAlpha;
        }
        string3 = string3 + ", " + this.segmentNumber + " segment/s of length " + this.segmentLength;
        if (this.segmentNumber > 1) {
            string3 = this.overlap ? string3 + ", segments overlap by 50%" : string3 + ", segments do not overlap";
        }
        plotGraph.setGraphTitle2(string3);
        plotGraph.setXaxisLegend("Frequency");
        if (this.deltaTset) {
            plotGraph.setXaxisUnitsName("cycles per unit time");
        } else {
            plotGraph.setXaxisUnitsName("cycles per grid point");
        }
        plotGraph.setYaxisLegend(string2);
        switch (this.plotLineOption) {
            case 0: {
                plotGraph.setLine(3);
                break;
            }
            case 1: {
                plotGraph.setLine(1);
                break;
            }
            case 2: {
                plotGraph.setLine(2);
                break;
            }
            default: {
                plotGraph.setLine(3);
            }
        }
        switch (this.plotPointOption) {
            case 0: {
                plotGraph.setPoint(0);
                break;
            }
            case 1: {
                plotGraph.setPoint(4);
                break;
            }
            default: {
                plotGraph.setPoint(0);
            }
        }
        plotGraph.plot();
    }

    public void setPlotLineOption(int n) {
        this.plotLineOption = n;
    }

    public int getPlotLineOption() {
        return this.plotLineOption;
    }

    public void setPlotPointOption(int n) {
        this.plotPointOption = n;
    }

    public int getPlotPointOption() {
        return this.plotPointOption;
    }

    public double[][] correlate(double[] dArray) {
        int n;
        int n2 = dArray.length;
        if (!this.fftDataSet) {
            throw new IllegalArgumentException("No data has been previously entered");
        }
        if (n2 != this.originalDataLength) {
            throw new IllegalArgumentException("The two data sets to be correlated are of different length");
        }
        if (!FourierTransform.checkPowerOfTwo(n2)) {
            throw new IllegalArgumentException("The length of the correlation data sets is not equal to an integer power of two");
        }
        this.complexCorr = Complex.oneDarray(n2);
        for (n = 0; n < n2; ++n) {
            this.complexCorr[n].setReal(dArray[n]);
            this.complexCorr[n].setImag(0.0);
        }
        this.fftCorr = new double[2 * n2];
        n = -1;
        for (int j = 0; j < n2; ++j) {
            this.fftCorr[++n] = dArray[j];
            this.fftCorr[++n] = 0.0;
        }
        return this.correlation(n2);
    }

    public double[][] correlate(double[] dArray, double[] dArray2) {
        int n;
        int n2;
        int n3 = dArray.length;
        int n4 = dArray2.length;
        if (n3 != n4) {
            throw new IllegalArgumentException("The two data sets to be correlated are of different length");
        }
        if (!FourierTransform.checkPowerOfTwo(n3)) {
            throw new IllegalArgumentException("The length of the correlation data sets is not equal to an integer power of two");
        }
        this.fftDataLength = n3;
        this.complexData = Complex.oneDarray(this.fftDataLength);
        for (n2 = 0; n2 < this.fftDataLength; ++n2) {
            this.complexData[n2].setReal(dArray[n2]);
            this.complexData[n2].setImag(0.0);
        }
        this.fftData = new double[2 * this.fftDataLength];
        n2 = 0;
        for (n = 0; n < this.fftDataLength; ++n) {
            this.fftData[n2] = dArray[n];
            this.fftData[++n2] = 0.0;
            ++n2;
        }
        this.fftDataSet = true;
        this.fftDataWindow = new double[2 * this.fftDataLength];
        this.weights = new double[this.fftDataLength];
        this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
        this.transformedDataFft = new double[2 * this.fftDataLength];
        this.transformedDataComplex = Complex.oneDarray(this.fftDataLength);
        this.complexCorr = Complex.oneDarray(n3);
        for (n = 0; n < n3; ++n) {
            this.complexCorr[n].setReal(dArray2[n]);
            this.complexCorr[n].setImag(0.0);
        }
        this.fftCorr = new double[2 * n3];
        n2 = -1;
        for (n = 0; n < n3; ++n) {
            this.fftCorr[++n2] = dArray2[n];
            this.fftCorr[++n2] = 0.0;
        }
        return this.correlation(n3);
    }

    private double[][] correlation(int n) {
        int n2;
        int n3;
        this.fftDataWindow = new double[2 * n];
        this.fftCorrWindow = new double[2 * n];
        this.weights = new double[n];
        this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
        this.windowData(this.fftCorr, this.fftCorrWindow, this.weights);
        int n4 = 1;
        double[] dArray = new double[2 * n];
        for (int j = 0; j < n * 2; ++j) {
            dArray[j] = this.fftDataWindow[j];
        }
        this.basicFft(dArray, n, n4);
        n4 = 1;
        double[] dArray2 = new double[2 * n];
        for (int j = 0; j < n * 2; ++j) {
            dArray2[j] = this.fftCorrWindow[j];
        }
        this.basicFft(dArray2, n, n4);
        double[] dArray3 = new double[2 * n];
        int n5 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            dArray3[n5] = (dArray[n5] * dArray2[n5] + dArray[n5 + 1] * dArray2[n5 + 1]) / (double)n;
            dArray3[n5 + 1] = (-dArray[n5] * dArray2[n5 + 1] + dArray[n5 + 1] * dArray2[n5]) / (double)n;
            n5 += 2;
        }
        n4 = -1;
        this.basicFft(dArray3, n, n4);
        for (n3 = 0; n3 < 2 * n; ++n3) {
            this.transformedDataFft[n3] = dArray3[n3];
        }
        this.correlationArray = new double[2][n];
        n5 = 0;
        n3 = n;
        for (n2 = n / 2 + 1; n2 < n; ++n2) {
            this.correlationArray[1][n5] = dArray3[n3] / (double)n;
            ++n5;
            n3 += 2;
        }
        n3 = 0;
        for (n2 = 0; n2 < n / 2; ++n2) {
            this.correlationArray[1][n5] = dArray3[n3] / (double)n;
            ++n5;
            n3 += 2;
        }
        this.correlationArray[0][0] = -((double)(n / 2)) * this.deltaT;
        for (n2 = 1; n2 < n; ++n2) {
            this.correlationArray[0][n2] = this.correlationArray[0][n2 - 1] + this.deltaT;
        }
        this.correlateDone = true;
        return this.correlationArray;
    }

    public double[][] getCorrelation() {
        if (!this.correlateDone) {
            System.out.println("getCorrelation - correlation has not been called - no correlation returned");
        }
        return this.correlationArray;
    }

    public void printCorrelation() {
        String string = "Correlation.txt";
        this.printCorrelation(string);
    }

    public void printCorrelation(String string) {
        if (!this.correlateDone) {
            System.out.println("printCorrelation - correlate has not been called - no file printed");
        } else {
            FileOutput fileOutput = new FileOutput(string);
            fileOutput.println("Correlation Output File from FourierTransform");
            fileOutput.dateAndTimeln(string);
            String string2 = "Window: " + this.windowNames[this.windowOption];
            if (this.windowOption == 6) {
                string2 = string2 + ", alpha = " + this.kaiserAlpha;
            }
            if (this.windowOption == 7) {
                string2 = string2 + ", alpha = " + this.gaussianAlpha;
            }
            fileOutput.println(string2);
            fileOutput.printtab("Data length = ");
            fileOutput.println(this.fftDataLength);
            fileOutput.println();
            fileOutput.printtab("Time lag");
            fileOutput.println("Correlation");
            if (this.deltaTset) {
                fileOutput.printtab("/unit time");
            } else {
                fileOutput.printtab("/grid interval)");
            }
            fileOutput.println("Coefficient");
            int n = this.correlationArray[0].length;
            for (int j = 0; j < n; ++j) {
                fileOutput.printtab(Fmath.truncate(this.correlationArray[0][j], 4));
                fileOutput.println(Fmath.truncate(this.correlationArray[1][j], 4));
            }
            fileOutput.close();
        }
    }

    public void plotCorrelation() {
        if (!this.correlateDone) {
            System.out.println("plotCorrelation - correlation has not been called - no plot displayed");
        } else {
            String string = "Correlation Plot";
            this.plotCorrelation(string);
        }
    }

    public void plotCorrelation(String string) {
        if (!this.correlateDone) {
            System.out.println("plotCorrelation - correlate has not been called - no plot displayed");
        } else {
            PlotGraph plotGraph = new PlotGraph(this.correlationArray);
            plotGraph.setGraphTitle(string);
            String string2 = "Window: " + this.windowNames[this.windowOption];
            if (this.windowOption == 6) {
                string2 = string2 + " - alpha = " + this.kaiserAlpha;
            }
            if (this.windowOption == 7) {
                string2 = string2 + " - alpha = " + this.gaussianAlpha;
            }
            plotGraph.setGraphTitle2(string2);
            plotGraph.setXaxisLegend("Correlation Lag");
            if (this.deltaTset) {
                plotGraph.setXaxisUnitsName("unit time");
            } else {
                plotGraph.setXaxisUnitsName("grid interval");
            }
            plotGraph.setYaxisLegend("Correlation coefficient");
            switch (this.plotLineOption) {
                case 0: {
                    plotGraph.setLine(3);
                    break;
                }
                case 1: {
                    plotGraph.setLine(1);
                    break;
                }
                case 2: {
                    plotGraph.setLine(2);
                    break;
                }
                default: {
                    plotGraph.setLine(3);
                }
            }
            switch (this.plotPointOption) {
                case 0: {
                    plotGraph.setPoint(0);
                    break;
                }
                case 1: {
                    plotGraph.setPoint(4);
                    break;
                }
                default: {
                    plotGraph.setPoint(0);
                }
            }
            plotGraph.plot();
        }
    }

    public double[][] shortTime(double d) {
        int n = (int)Math.round(d / this.deltaT);
        if (!FourierTransform.checkPowerOfTwo(n)) {
            int n2 = FourierTransform.lastPowerOfTwo(n);
            int n3 = FourierTransform.nextPowerOfTwo(n);
            if (n - n2 <= n3 - n) {
                n = n2;
                if (n2 == 0) {
                    n = n3;
                }
            } else {
                n = n3;
            }
            System.out.println("Method - shortTime");
            System.out.println("Window length, provided as time, " + d + ", did not convert to an integer power of two data points");
            System.out.println("A value of " + (double)(n - 1) * this.deltaT + " was substituted");
        }
        return this.shortTime(n);
    }

    public double[][] shortTime(int n) {
        int n2;
        if (!FourierTransform.checkPowerOfTwo(n)) {
            throw new IllegalArgumentException("Moving window data length ," + n + ", is not an integer power of two");
        }
        if (!this.fftDataSet) {
            throw new IllegalArgumentException("No data has been entered for the Fast Fourier Transform");
        }
        if (n > this.originalDataLength) {
            throw new IllegalArgumentException("The window length, " + n + ", is greater than the data length, " + this.originalDataLength + ".");
        }
        if (this.windowOption == 0) {
            this.setGaussian();
        }
        this.numShortTimes = this.originalDataLength - n + 1;
        this.numShortFreq = n / 2;
        this.timeFrequency = new double[this.numShortFreq + 1][this.numShortTimes + 1];
        this.timeFrequency[0][0] = 0.0;
        this.timeFrequency[0][1] = (double)(n - 1) * this.deltaT / 2.0;
        for (n2 = 2; n2 <= this.numShortTimes; ++n2) {
            this.timeFrequency[0][n2] = this.timeFrequency[0][n2 - 1] + this.deltaT;
        }
        for (n2 = 0; n2 < this.numShortFreq; ++n2) {
            this.timeFrequency[n2 + 1][0] = (double)n2 / ((double)n * this.deltaT);
        }
        this.segmentLength = n;
        n2 = 0;
        double[] dArray = new double[2 * n];
        double[] dArray2 = new double[this.numShortFreq];
        int n3 = 1;
        for (int j = 1; j <= this.numShortTimes; ++j) {
            int n4;
            for (n4 = 0; n4 < 2 * n; ++n4) {
                dArray[n4] = this.fftData[n2 + n4];
            }
            if (j == 1) {
                this.sumOfSquaredWeights = this.windowData(dArray, dArray, this.weights);
            } else {
                n4 = 0;
                for (int k = 0; k < this.segmentLength; ++k) {
                    dArray[n4] = dArray[n4] * this.weights[k];
                    dArray[++n4] = dArray[n4] * this.weights[k];
                    ++n4;
                }
            }
            this.basicFft(dArray, n, n3);
            dArray2[0] = Fmath.square(dArray[0]) + Fmath.square(dArray[1]);
            for (n4 = 1; n4 < this.numShortFreq; ++n4) {
                dArray2[n4] = Fmath.square(dArray[2 * n4]) + Fmath.square(dArray[2 * n4 + 1]) + Fmath.square(dArray[2 * n - 2 * n4]) + Fmath.square(dArray[2 * n - 2 * n4 + 1]);
            }
            for (n4 = 0; n4 < this.numShortFreq; ++n4) {
                this.timeFrequency[n4 + 1][j] = 2.0 * dArray2[n4] / ((double)n * this.sumOfSquaredWeights);
            }
            n2 += 2;
        }
        this.shortTimeDone = true;
        return this.timeFrequency;
    }

    public double[][] getTimeFrequencyMatrix() {
        if (!this.shortTimeDone) {
            throw new IllegalArgumentException("No short time Fourier transform has been performed");
        }
        return this.timeFrequency;
    }

    public int getShortTimeNumberOfTimes() {
        if (!this.shortTimeDone) {
            throw new IllegalArgumentException("No short time Fourier transform has been performed");
        }
        return this.numShortTimes;
    }

    public int getShortTimeNumberOfFrequencies() {
        if (!this.shortTimeDone) {
            throw new IllegalArgumentException("No short time Fourier transform has been performed");
        }
        return this.numShortFreq;
    }

    public int getShortTimeWindowLength() {
        if (!this.shortTimeDone) {
            throw new IllegalArgumentException("No short time Fourier transform has been performed");
        }
        return this.segmentLength;
    }

    public void printShortTime() {
        String string = "ShortTime.txt";
        this.printShortTime(string);
    }

    public void printShortTime(String string) {
        if (!this.shortTimeDone) {
            System.out.println("printShortTime- shortTime has not been called - no file printed");
        } else {
            FileOutput fileOutput = new FileOutput(string);
            fileOutput.println("Short Time Fourier Transform Output File from FourierTransform");
            fileOutput.dateAndTimeln(string);
            String string2 = "Window: " + this.windowNames[this.windowOption];
            if (this.windowOption == 6) {
                string2 = string2 + ", alpha = " + this.kaiserAlpha;
            }
            if (this.windowOption == 7) {
                string2 = string2 + ", alpha = " + this.gaussianAlpha;
            }
            fileOutput.println(string2);
            fileOutput.printtab("Data length = ");
            fileOutput.println(this.originalDataLength);
            fileOutput.printtab("Delta T = ");
            fileOutput.println(this.deltaT);
            fileOutput.printtab("Window length (points) = ");
            fileOutput.println(this.segmentLength);
            fileOutput.printtab("Window length (time units) = ");
            fileOutput.println((double)(this.segmentLength - 1) * this.deltaT);
            fileOutput.printtab("Number of frequency points = ");
            fileOutput.println(this.numShortFreq);
            fileOutput.printtab("Number of time points = ");
            fileOutput.println(this.numShortTimes);
            boolean bl = false;
            int n = this.numShortTimes;
            int n2 = 100;
            int n3 = this.numShortTimes / n2;
            int n4 = this.numShortTimes % n2;
            if (this.numShortTimes > 127) {
                bl = true;
                if (n4 > 0) {
                    n = n2;
                    n4 = this.numShortTimes - ++n3 * (n - 1);
                } else {
                    n = n2;
                    n4 = n3;
                }
                if (n4 != n3) {
                    fileOutput.println("In the output below, each of the first " + (n - 2) + " magnitude points, along the time axis, is the average of " + n3 + " calculated points");
                    fileOutput.println("The last point is the average of " + n4 + " calculated points");
                } else {
                    fileOutput.println("In the output below, each magnitude point is the average of " + n3 + " calculated points");
                }
                fileOutput.println("The data, without averaging, may be accessed using the method getTimeFrequencyMatrix()");
            }
            fileOutput.println();
            fileOutput.println("first row = times");
            fileOutput.println("first column = frequencies");
            fileOutput.println("all other cells = mean square amplitudes at the corresponding time and frequency");
            if (bl) {
                double d = 0.0;
                int n5 = 1;
                int n6 = n3;
                for (int j = 0; j <= this.numShortFreq; ++j) {
                    fileOutput.printtab(Fmath.truncate(this.timeFrequency[j][0], 4));
                    n5 = 1;
                    for (int k = 1; k <= n; ++k) {
                        n6 = n3;
                        if (k == n) {
                            n6 = n4;
                        }
                        d = 0.0;
                        for (int i2 = n5; i2 <= n5 + n6 - 1; ++i2) {
                            d += this.timeFrequency[j][i2];
                        }
                        fileOutput.printtab(Fmath.truncate(d /= (double)n6, 4));
                        n5 += n6;
                    }
                    fileOutput.println();
                }
            } else {
                for (int j = 0; j <= this.numShortFreq; ++j) {
                    for (int k = 0; k <= n; ++k) {
                        fileOutput.printtab(Fmath.truncate(this.timeFrequency[j][k], 4));
                    }
                    fileOutput.println();
                }
            }
            fileOutput.close();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        this.graph(graphics);
    }

    public void plotShortTime(String string) {
        this.shortTitle = string;
        this.plotShortTime();
    }

    public void plotShortTime() {
        JFrame jFrame = new JFrame("Michael T Flanagan's plotting program - FourierTransform.plotShortTime");
        this.setSize(800, 600);
        jFrame.getContentPane().setBackground(Color.white);
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add("Center", this);
        jFrame.pack();
        jFrame.setResizable(true);
        jFrame.toFront();
        jFrame.setVisible(true);
    }

    public void graph(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        double d;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15 = 512;
        int n16 = 256;
        int n17 = 100;
        int n18 = 100;
        int n19 = 18;
        Color[] colorArray = new Color[n19 + 1];
        colorArray[18] = Color.black;
        colorArray[17] = Color.darkGray;
        colorArray[16] = Color.gray;
        colorArray[15] = Color.lightGray;
        colorArray[14] = Color.red.darker();
        colorArray[13] = Color.red;
        colorArray[12] = Color.magenta.darker();
        colorArray[11] = Color.magenta;
        colorArray[10] = Color.pink;
        colorArray[9] = Color.pink.darker();
        colorArray[8] = Color.orange.darker();
        colorArray[7] = Color.orange;
        colorArray[6] = Color.yellow;
        colorArray[5] = Color.green;
        colorArray[4] = Color.green.darker();
        colorArray[3] = Color.cyan;
        colorArray[2] = Color.cyan.darker();
        colorArray[1] = Color.blue;
        colorArray[0] = Color.blue.darker();
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        boolean bl = true;
        if (this.numShortTimes <= n15) {
            n20 = n15 / this.numShortTimes;
            n15 = n20 * this.numShortTimes;
            n21 = this.numShortTimes;
        } else {
            bl = false;
            n20 = 1;
            n21 = this.numShortTimes;
            n22 = this.numShortTimes / n15;
            n23 = this.numShortTimes % n15;
            if (n23 > 0) {
                n21 = this.numShortTimes / ++n22 + 1;
                n23 = this.numShortTimes - n22 * (n21 - 1);
            } else {
                n21 = this.numShortTimes / n22;
                n23 = n22;
            }
            n15 = n21;
        }
        int n24 = 0;
        int n25 = 0;
        int n26 = 0;
        int n27 = 0;
        boolean bl2 = true;
        if (this.numShortFreq <= n16) {
            n24 = n16 / this.numShortFreq;
            n16 = n24 * this.numShortFreq;
            n25 = this.numShortFreq;
        } else {
            bl2 = false;
            n24 = 1;
            n25 = this.numShortFreq;
            n26 = this.numShortFreq / n16;
            n27 = this.numShortFreq % n16;
            if (n27 > 0) {
                n25 = this.numShortFreq / ++n26 + 1;
                n27 = this.numShortFreq - n26 * (n25 - 1);
            } else {
                n25 = this.numShortFreq / n26;
                n27 = n26;
            }
            n16 = n25;
        }
        int n28 = n17 + n16;
        int n29 = n18 + n15;
        double[][] dArray = new double[n25][n21];
        int[][] nArray = new int[n25][n21];
        double[] dArray2 = new double[n21];
        int[] nArray2 = new int[n21];
        double[] dArray3 = new double[n25];
        int[] nArray3 = new int[n25];
        double[][] dArray4 = new double[this.numShortFreq][n21];
        if (bl) {
            for (n14 = 0; n14 <= this.numShortFreq; ++n14) {
                for (n13 = 1; n13 <= this.numShortTimes; ++n13) {
                    if (n14 == 0) {
                        dArray2[n13 - 1] = this.timeFrequency[0][n13];
                        continue;
                    }
                    dArray4[n14 - 1][n13 - 1] = this.timeFrequency[n14][n13];
                }
            }
        } else {
            double d2 = 0.0;
            int n30 = 1;
            int n31 = n22;
            for (n12 = 0; n12 <= this.numShortFreq; ++n12) {
                n30 = 1;
                for (n11 = 1; n11 <= n21; ++n11) {
                    n31 = n22;
                    if (n11 == n21) {
                        n31 = n23;
                    }
                    d2 = 0.0;
                    for (n10 = n30; n10 <= n30 + n31 - 1; ++n10) {
                        d2 += this.timeFrequency[n12][n10];
                    }
                    if (n12 == 0) {
                        dArray2[n11 - 1] = d2 / (double)n31;
                    } else {
                        dArray4[n12 - 1][n11 - 1] = d2 / (double)n31;
                    }
                    n30 += n31;
                }
            }
        }
        if (bl2) {
            for (n14 = 0; n14 < this.numShortFreq; ++n14) {
                dArray3[n14] = this.timeFrequency[n14 + 1][0];
                for (n13 = 0; n13 < n21; ++n13) {
                    dArray[n14][n13] = dArray4[n14][n13];
                }
            }
        } else {
            double d3 = 0.0;
            double d4 = 0.0;
            n12 = 0;
            n11 = n26;
            for (n10 = 0; n10 < n21; ++n10) {
                n12 = 0;
                for (int j = 0; j < n25; ++j) {
                    n11 = n26;
                    if (j == n25 - 1) {
                        n11 = n27;
                    }
                    d3 = 0.0;
                    d4 = 0.0;
                    for (int k = n12; k <= n12 + n11 - 1; ++k) {
                        d3 += dArray4[k][n10];
                        d4 += this.timeFrequency[k + 1][0];
                    }
                    dArray[j][n10] = d3;
                    dArray3[j] = d4 / (double)n11;
                    n12 += n11;
                }
            }
        }
        double d5 = d = dArray[0][0];
        for (n12 = 0; n12 < n25; ++n12) {
            for (n11 = 0; n11 < n21; ++n11) {
                if (dArray[n12][n11] > d) {
                    d = dArray[n12][n11];
                }
                if (!(dArray[n12][n11] < d5)) continue;
                d5 = dArray[n12][n11];
            }
        }
        double d6 = 0.0;
        if (d5 > 0.1 * d) {
            d6 = 0.99 * d5;
        }
        double d7 = (1.01 * d - 0.99 * d5) / (double)n19;
        double[] dArray5 = new double[n19];
        dArray5[0] = d6 + d7;
        for (n9 = 1; n9 < n19; ++n9) {
            dArray5[n9] = dArray5[n9 - 1] + d7;
        }
        n9 = 1;
        for (n8 = 0; n8 < n25; ++n8) {
            for (n7 = 0; n7 < n21; ++n7) {
                n9 = 1;
                n6 = 0;
                while (n9 != 0) {
                    if (dArray[n8][n7] <= dArray5[n6]) {
                        nArray[n8][n7] = n6;
                        n9 = 0;
                        continue;
                    }
                    ++n6;
                }
            }
        }
        n8 = 0;
        n7 = 0;
        n6 = 0;
        int n32 = 0;
        int n33 = n18;
        int n34 = n17;
        for (n5 = 0; n5 < n25; ++n5) {
            for (n4 = 0; n4 < n21; ++n4) {
                n6 = 0;
                for (int j = 0; j < n24; ++j) {
                    n32 = 0;
                    for (int k = 0; k < n20; ++k) {
                        graphics.setColor(colorArray[nArray[n5][n4]]);
                        n33 = n18 + (n7 + n32);
                        n34 = n28 - (n8 + n6);
                        graphics.drawLine(n33, n34, n33, n34);
                        ++n32;
                    }
                    ++n6;
                }
                n7 += n32;
            }
            n8 += n6;
            n7 = 0;
        }
        graphics.setColor(colorArray[n19]);
        graphics.drawLine(n18, n28, n18, n17);
        graphics.drawLine(n29, n28, n29, n17);
        graphics.drawLine(n18, n28, n29, n28);
        graphics.drawLine(n18, n17, n29, n17);
        n5 = n16 / 4;
        n4 = this.numShortFreq / 4;
        double d8 = (double)n5 * (dArray3[1] - dArray3[0]) / (double)(n24 * n4);
        String[] stringArray = new String[5];
        int n35 = 0;
        stringArray[0] = "0  ";
        for (n3 = 1; n3 < 5; ++n3) {
            stringArray[n3] = (n35 += n4) + "  ";
        }
        n33 = n18;
        n34 = n28;
        n3 = 6 * (stringArray[4].length() + 1);
        for (n2 = 0; n2 < 5; ++n2) {
            graphics.drawLine(n33 - 5, n34, n33, n34);
            graphics.drawString(stringArray[n2], n33 - n3, n34 + 4);
            n34 -= n5;
        }
        n2 = n15 / 8;
        int n36 = this.numShortTimes / 8;
        double d9 = (double)n2 * (dArray2[1] - dArray2[0]) / (double)(n20 * n36);
        String[] stringArray2 = new String[9];
        int n37 = 0;
        stringArray2[0] = "0 ";
        for (n = 1; n < 9; ++n) {
            stringArray2[n] = (n37 += n36) + " ";
        }
        n33 = n18;
        n34 = n28;
        for (n = 0; n < 9; ++n) {
            graphics.drawLine(n33, n34, n33, n34 + 5);
            graphics.drawString(stringArray2[n], n33 - 4, n34 + 20);
            n33 += n2;
        }
        graphics.drawString("Short Time Fourier Transfer Time-Frequency Plot", n18 - 80, n17 - 80);
        graphics.drawString(this.shortTitle, n18 - 80, n17 - 60);
        String string = "Frequency / (" + Fmath.truncate(d8, 3) + " cycles per time unit)";
        graphics.drawString(string, n18 - 60, n17 - 20);
        String string2 = "Time / (" + Fmath.truncate(d9, 3) + " time units)";
        graphics.drawString(string2, n18, n28 + 40);
        String string3 = "Total time = " + Fmath.truncate((double)n15 * (dArray2[1] - dArray2[0]) / (double)n20, 3) + " time units";
        graphics.drawString(string3, n18, n28 + 80);
        String string4 = "Frequecy range = 0 to " + Fmath.truncate((double)n16 * (dArray3[1] - dArray3[0]) / (double)n24, 3) + " cycles per time unit";
        graphics.drawString(string4, n18, n28 + 100);
        graphics.drawString("Widow length = " + Fmath.truncate((double)(this.segmentLength - 1) * this.deltaT, 3) + " time units", n18, n28 + 120);
        String string5 = "Window filter = " + this.windowNames[this.windowOption];
        if (this.windowOption == 6) {
            string5 = string5 + ", alpha = " + this.kaiserAlpha;
        }
        if (this.windowOption == 7) {
            string5 = string5 + ", alpha = " + this.gaussianAlpha;
        }
        graphics.drawString(string5, n18, n28 + 140);
        n34 = n28 + 100;
        n33 = n29 + 40;
        double d10 = Fmath.truncate(d6, 3);
        for (int j = 0; j < n19; ++j) {
            double d11 = Fmath.truncate(dArray5[j], 3);
            graphics.setColor(colorArray[n19]);
            graphics.drawString(d10 + " - " + d11, n33 + 25, n34);
            d10 = d11;
            graphics.setColor(colorArray[j]);
            for (int k = 0; k < 20; ++k) {
                graphics.drawLine(n33, --n34, n33 + 20, n34);
            }
        }
        graphics.setColor(Color.black);
        graphics.drawString("Mean square", n33 + 25, n34 - 25);
        graphics.drawString("amplitudes ", n33 + 25, n34 - 10);
    }

    public static int lastPowerOfTwo(int n) {
        boolean bl = true;
        while (bl) {
            if (FourierTransform.checkPowerOfTwo(n)) {
                bl = false;
                continue;
            }
            --n;
        }
        return n;
    }

    public static int nextPowerOfTwo(int n) {
        boolean bl = true;
        while (bl) {
            if (FourierTransform.checkPowerOfTwo(n)) {
                bl = false;
                continue;
            }
            ++n;
        }
        return n;
    }

    public static boolean checkPowerOfTwo(int n) {
        boolean bl = true;
        int n2 = n;
        while (bl && n2 > 1) {
            if (n2 % 2 != 0) {
                bl = false;
                continue;
            }
            n2 /= 2;
        }
        return bl;
    }

    public static int checkIntegerTimesPowerOfTwo(int n) {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        int n2 = n;
        int n3 = 1;
        int n4 = 0;
        while (bl) {
            bl2 = FourierTransform.checkPowerOfTwo(n2);
            if (bl2) {
                bl4 = true;
                bl = false;
                continue;
            }
            bl3 = true;
            while (bl3) {
                if ((n2 /= ++n3) < 1) {
                    bl3 = false;
                    bl2 = false;
                    bl = false;
                    bl4 = false;
                    continue;
                }
                if (n2 % 2 != 0) continue;
                bl3 = false;
            }
        }
        if (bl4) {
            n4 = n3;
        }
        return n4;
    }

    public static long getSerialVersionUID() {
        return 1L;
    }
}

