/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.analysis.Regression;
import flanagan.analysis.Stat;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Vector;

public class Matrix {
    private int numberOfRows = 0;
    private int numberOfColumns = 0;
    private double[][] matrix = null;
    private String[][] matrixS = null;
    private int entryType = -1;
    private boolean numericalCheck = true;
    private double[][] hessenberg = null;
    private boolean hessenbergDone = false;
    private int[] permutationIndex = null;
    private double rowSwapIndex = 1.0;
    private double[] eigenValues = null;
    private double[][] eigenVector = null;
    private double[] sortedEigenValues = null;
    private double[][] sortedEigenVector = null;
    private int numberOfRotations = 0;
    private int[] eigenIndices = null;
    private int maximumJacobiIterations = 100;
    private boolean eigenDone = false;
    private boolean matrixCheck = true;
    private boolean suppressErrorMessage = false;
    private double tiny = 1.0E-100;

    public Matrix(int n, int n2) {
        this.numberOfRows = n;
        this.numberOfColumns = n2;
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        this.matrixS = new String[this.numberOfRows][this.numberOfColumns];
        this.permutationIndex = new int[this.numberOfRows];
        this.entryType = 0;
        for (int j = 0; j < this.numberOfRows; ++j) {
            this.permutationIndex[j] = j;
            for (int k = 0; k < this.numberOfColumns; ++k) {
                this.matrixS[j][k] = "0.0";
            }
        }
        this.eigenDone = false;
        this.hessenbergDone = false;
    }

    public Matrix(int n, int n2, double d) {
        this.numberOfRows = n;
        this.numberOfColumns = n2;
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        this.matrixS = new String[this.numberOfRows][this.numberOfColumns];
        this.permutationIndex = new int[this.numberOfRows];
        this.entryType = 0;
        for (int j = 0; j < this.numberOfRows; ++j) {
            this.permutationIndex[j] = j;
            for (int k = 0; k < this.numberOfColumns; ++k) {
                this.matrix[j][k] = d;
                this.matrixS[j][k] = Conv.convert_double_to_String(d);
            }
        }
        this.eigenDone = false;
        this.hessenbergDone = false;
    }

    public Matrix(double[][] dArray) {
        this.numberOfRows = dArray.length;
        this.numberOfColumns = dArray[0].length;
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        this.matrixS = new String[this.numberOfRows][this.numberOfColumns];
        this.permutationIndex = new int[this.numberOfRows];
        this.entryType = 0;
        for (int j = 0; j < this.numberOfRows; ++j) {
            this.permutationIndex[j] = j;
            for (int k = 0; k < this.numberOfColumns; ++k) {
                this.matrix[j][k] = dArray[j][k];
                this.matrixS[j][k] = Conv.convert_double_to_String(dArray[j][k]);
            }
        }
        this.eigenDone = false;
        this.hessenbergDone = false;
    }

    public Matrix(float[][] fArray) {
        int n;
        this.numberOfRows = fArray.length;
        this.numberOfColumns = fArray[0].length;
        for (n = 1; n < this.numberOfRows; ++n) {
            if (fArray[n].length == this.numberOfColumns) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        this.matrixS = new String[this.numberOfRows][this.numberOfColumns];
        this.permutationIndex = new int[this.numberOfRows];
        this.entryType = 1;
        for (n = 0; n < this.numberOfRows; ++n) {
            this.permutationIndex[n] = n;
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.matrix[n][j] = fArray[n][j];
                this.matrixS[n][j] = Conv.convert_float_to_String(fArray[n][j]);
            }
        }
        this.eigenDone = false;
        this.hessenbergDone = false;
    }

    public Matrix(long[][] lArray) {
        int n;
        this.numberOfRows = lArray.length;
        this.numberOfColumns = lArray[0].length;
        for (n = 1; n < this.numberOfRows; ++n) {
            if (lArray[n].length == this.numberOfColumns) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        this.matrixS = new String[this.numberOfRows][this.numberOfColumns];
        this.permutationIndex = new int[this.numberOfRows];
        this.entryType = 2;
        for (n = 0; n < this.numberOfRows; ++n) {
            this.permutationIndex[n] = n;
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.matrix[n][j] = lArray[n][j];
                this.matrixS[n][j] = Conv.convert_long_to_String(lArray[n][j]);
            }
        }
        this.eigenDone = false;
        this.hessenbergDone = false;
    }

    public Matrix(int[][] nArray) {
        int n;
        this.numberOfRows = nArray.length;
        this.numberOfColumns = nArray[0].length;
        for (n = 1; n < this.numberOfRows; ++n) {
            if (nArray[n].length == this.numberOfColumns) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        this.matrixS = new String[this.numberOfRows][this.numberOfColumns];
        this.permutationIndex = new int[this.numberOfRows];
        this.entryType = 3;
        for (n = 0; n < this.numberOfRows; ++n) {
            this.permutationIndex[n] = n;
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.matrix[n][j] = nArray[n][j];
                this.matrixS[n][j] = Conv.convert_long_to_String(nArray[n][j]);
            }
        }
        this.eigenDone = false;
        this.hessenbergDone = false;
    }

    public Matrix(char[][] cArray) {
        int n;
        this.numberOfRows = cArray.length;
        this.numberOfColumns = cArray[0].length;
        for (n = 1; n < this.numberOfRows; ++n) {
            if (cArray[n].length == this.numberOfColumns) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        this.matrixS = new String[this.numberOfRows][this.numberOfColumns];
        this.permutationIndex = new int[this.numberOfRows];
        this.entryType = 3;
        for (n = 0; n < this.numberOfRows; ++n) {
            this.permutationIndex[n] = n;
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.matrix[n][j] = Conv.convert_char_to_double(cArray[n][j]);
                this.matrixS[n][j] = Conv.convert_char_to_String(cArray[n][j]);
            }
        }
        this.eigenDone = false;
        this.hessenbergDone = false;
    }

    public Matrix(String[][] stringArray) {
        int n;
        int n2;
        this.numberOfRows = stringArray.length;
        this.numberOfColumns = stringArray[0].length;
        for (n2 = 1; n2 < this.numberOfRows; ++n2) {
            if (stringArray[n2].length == this.numberOfColumns) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        this.matrixS = new String[this.numberOfRows][this.numberOfColumns];
        this.permutationIndex = new int[this.numberOfRows];
        this.entryType = 3;
        this.numericalCheck = false;
        for (n2 = 0; n2 < this.numberOfRows; ++n2) {
            this.permutationIndex[n2] = n2;
            for (n = 0; n < this.numberOfColumns; ++n) {
                this.matrixS[n2][n] = stringArray[n2][n];
            }
        }
        for (n2 = 0; n2 < this.numberOfRows; ++n2) {
            for (n = 0; n < this.numberOfColumns; ++n) {
                try {
                    this.matrix[n2][n] = Conv.convert_String_to_double(stringArray[n2][n]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println(numberFormatException);
                    System.out.println("The entered String array does not contain numerical values - none of the numerical methods in this class are available.");
                    this.numericalCheck = false;
                    break;
                }
            }
            if (!this.numericalCheck) break;
        }
        this.eigenDone = false;
        this.hessenbergDone = false;
    }

    public Matrix(ArrayMaths[] arrayMathsArray) {
        int n;
        this.numberOfRows = arrayMathsArray.length;
        this.numberOfColumns = arrayMathsArray[0].length();
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        this.matrixS = new String[this.numberOfRows][this.numberOfColumns];
        for (n = 0; n < this.numberOfRows; ++n) {
            double[] dArray = arrayMathsArray[n].copy().array();
            if (dArray.length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            String[] stringArray = arrayMathsArray[n].copy().array_as_String();
            this.matrix[n] = dArray;
            this.matrixS[n] = stringArray;
        }
        this.permutationIndex = new int[this.numberOfRows];
        for (n = 0; n < this.numberOfRows; ++n) {
            this.permutationIndex[n] = n;
        }
        this.eigenDone = false;
        this.hessenbergDone = false;
    }

    public Matrix(ArrayList<Object>[] arrayListArray) {
        int n;
        this.numberOfRows = arrayListArray.length;
        ArrayMaths[] arrayMathsArray = new ArrayMaths[this.numberOfRows];
        for (n = 0; n < this.numberOfRows; ++n) {
            arrayMathsArray[n] = new ArrayMaths(arrayListArray[n]);
        }
        this.numberOfColumns = arrayMathsArray[0].length();
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        this.matrixS = new String[this.numberOfRows][this.numberOfColumns];
        for (n = 0; n < this.numberOfRows; ++n) {
            double[] dArray = arrayMathsArray[n].copy().array();
            if (dArray.length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            this.matrix[n] = dArray;
        }
        this.permutationIndex = new int[this.numberOfRows];
        for (n = 0; n < this.numberOfRows; ++n) {
            this.permutationIndex[n] = n;
        }
        this.eigenDone = false;
        this.hessenbergDone = false;
    }

    public Matrix(Vector<Object>[] vectorArray) {
        int n;
        this.numberOfRows = vectorArray.length;
        ArrayMaths[] arrayMathsArray = new ArrayMaths[this.numberOfRows];
        for (n = 0; n < this.numberOfRows; ++n) {
            arrayMathsArray[n] = new ArrayMaths(vectorArray[n]);
        }
        this.numberOfColumns = arrayMathsArray[0].length();
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        this.matrixS = new String[this.numberOfRows][this.numberOfColumns];
        for (n = 0; n < this.numberOfRows; ++n) {
            double[] dArray = arrayMathsArray[n].copy().array();
            if (dArray.length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            this.matrix[n] = dArray;
        }
        this.permutationIndex = new int[this.numberOfRows];
        for (n = 0; n < this.numberOfRows; ++n) {
            this.permutationIndex[n] = n;
        }
        this.eigenDone = false;
        this.hessenbergDone = false;
    }

    public Matrix(BigDecimal[][] bigDecimalArray) {
        int n;
        this.numberOfRows = bigDecimalArray.length;
        this.numberOfColumns = bigDecimalArray[0].length;
        for (n = 1; n < this.numberOfRows; ++n) {
            if (bigDecimalArray[n].length == this.numberOfColumns) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        this.matrixS = new String[this.numberOfRows][this.numberOfColumns];
        this.permutationIndex = new int[this.numberOfRows];
        this.entryType = 4;
        for (n = 0; n < this.numberOfRows; ++n) {
            this.permutationIndex[n] = n;
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.matrix[n][j] = bigDecimalArray[n][j].doubleValue();
                this.matrixS[n][j] = Conv.convert_BigDecimal_to_String(bigDecimalArray[n][j]);
            }
        }
        this.eigenDone = false;
        this.hessenbergDone = false;
    }

    public Matrix(BigInteger[][] bigIntegerArray) {
        int n;
        this.numberOfRows = bigIntegerArray.length;
        this.numberOfColumns = bigIntegerArray[0].length;
        for (n = 1; n < this.numberOfRows; ++n) {
            if (bigIntegerArray[n].length == this.numberOfColumns) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        this.matrixS = new String[this.numberOfRows][this.numberOfColumns];
        this.entryType = 5;
        this.permutationIndex = new int[this.numberOfRows];
        for (n = 0; n < this.numberOfRows; ++n) {
            this.permutationIndex[n] = n;
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.matrix[n][j] = bigIntegerArray[n][j].doubleValue();
                this.matrixS[n][j] = Conv.convert_BigInteger_to_String(bigIntegerArray[n][j]);
            }
        }
        this.eigenDone = false;
        this.hessenbergDone = false;
    }

    public Matrix(Matrix matrix) {
        this.numberOfRows = matrix.numberOfRows;
        this.numberOfColumns = matrix.numberOfColumns;
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        this.matrixS = new String[this.numberOfRows][this.numberOfColumns];
        this.entryType = matrix.getEntryType();
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                this.matrix[j][k] = matrix.matrix[j][k];
                this.matrixS[j][k] = matrix.matrixS[j][k];
            }
        }
        this.permutationIndex = Conv.copy(matrix.permutationIndex);
        this.rowSwapIndex = matrix.rowSwapIndex;
        this.eigenDone = false;
        this.hessenbergDone = false;
    }

    private int getEntryType() {
        return this.entryType;
    }

    public void resetLUzero(double d) {
        this.tiny = d;
    }

    public void setTwoDarray(double[][] dArray) {
        if (this.numberOfRows != dArray.length) {
            throw new IllegalArgumentException("row length of this Matrix differs from that of the 2D array argument");
        }
        if (this.numberOfColumns != dArray[0].length) {
            throw new IllegalArgumentException("column length of this Matrix differs from that of the 2D array argument");
        }
        for (int j = 0; j < this.numberOfRows; ++j) {
            if (dArray[j].length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            for (int k = 0; k < this.numberOfColumns; ++k) {
                this.matrix[j][k] = dArray[j][k];
            }
        }
        this.eigenDone = false;
        this.hessenbergDone = false;
    }

    public void setElement(int n, int n2, double d) {
        this.matrix[n][n2] = d;
        this.eigenDone = false;
        this.hessenbergDone = false;
    }

    public void setSubMatrix(int n, int n2, double[][] dArray) {
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        if (n + n3 - 1 >= this.numberOfRows) {
            throw new IllegalArgumentException("Sub-matrix position is outside the row bounds of this Matrix");
        }
        if (n2 + n4 - 1 >= this.numberOfColumns) {
            throw new IllegalArgumentException("Sub-matrix position is outside the column bounds of this Matrix");
        }
        int n5 = 0;
        int n6 = 0;
        for (int j = 0; j < n3; ++j) {
            n6 = 0;
            for (int k = 0; k < n4; ++k) {
                this.matrix[n + j][n2 + k] = dArray[n5][n6];
                ++n6;
            }
            ++n5;
        }
        this.eigenDone = false;
        this.hessenbergDone = false;
    }

    public void setSubMatrix(int n, int n2, int n3, int n4, double[][] dArray) {
        this.setSubMatrix(n, n2, dArray);
        this.eigenDone = false;
        this.hessenbergDone = false;
    }

    public void setSubMatrix(int[] nArray, int[] nArray2, double[][] dArray) {
        int n = nArray.length;
        int n2 = nArray2.length;
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                this.matrix[nArray[j]][nArray2[k]] = dArray[j][k];
            }
        }
        this.eigenDone = false;
        this.hessenbergDone = false;
    }

    public boolean getMatrixCheck() {
        return this.matrixCheck;
    }

    public static Matrix identityMatrix(int n) {
        Matrix matrix = new Matrix(n, n);
        for (int j = 0; j < n; ++j) {
            matrix.matrix[j][j] = 1.0;
        }
        return matrix;
    }

    public static Matrix unitMatrix(int n) {
        Matrix matrix = new Matrix(n, n);
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n; ++k) {
                matrix.matrix[j][k] = 1.0;
            }
        }
        return matrix;
    }

    public static Matrix unitMatrix(int n, int n2) {
        Matrix matrix = new Matrix(n, n2);
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                matrix.matrix[j][k] = 1.0;
            }
        }
        return matrix;
    }

    public static Matrix scalarMatrix(int n, double d) {
        Matrix matrix = new Matrix(n, n);
        double[][] dArray = matrix.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = j; k < n; ++k) {
                if (j != k) continue;
                dArray[j][k] = d;
            }
        }
        return matrix;
    }

    public static Matrix scalarMatrix(int n, int n2, double d) {
        Matrix matrix = new Matrix(n, n2);
        double[][] dArray = matrix.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = j; k < n2; ++k) {
                if (j != k) continue;
                dArray[j][k] = d;
            }
        }
        return matrix;
    }

    public static Matrix diagonalMatrix(int n, double[] dArray) {
        if (dArray.length != n) {
            throw new IllegalArgumentException("matrix dimension differs from diagonal array length");
        }
        Matrix matrix = new Matrix(n, n);
        double[][] dArray2 = matrix.getArrayReference();
        for (int j = 0; j < n; ++j) {
            dArray2[j][j] = dArray[j];
        }
        return matrix;
    }

    public static Matrix diagonalMatrix(int n, int n2, double[] dArray) {
        if (dArray.length != n) {
            throw new IllegalArgumentException("matrix dimension differs from diagonal array length");
        }
        Matrix matrix = new Matrix(n, n2);
        double[][] dArray2 = matrix.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = j; k < n2; ++k) {
                if (j != k) continue;
                dArray2[j][k] = dArray[j];
            }
        }
        return matrix;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public int getNrow() {
        return this.numberOfRows;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public int getNcol() {
        return this.numberOfColumns;
    }

    public double[][] getArrayReference() {
        return this.matrix;
    }

    public double[][] getArrayPointer() {
        return this.matrix;
    }

    public double[][] getArrayCopy() {
        double[][] dArray = new double[this.numberOfRows][this.numberOfColumns];
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                dArray[j][k] = this.matrix[j][k];
            }
        }
        return dArray;
    }

    public double[] getRowCopy(int n) {
        if (n >= this.numberOfRows) {
            throw new IllegalArgumentException("Row index, " + n + ", must be less than the number of rows, " + this.numberOfRows);
        }
        if (n < 0) {
            throw new IllegalArgumentException("Row index, " + n + ", must be zero or positive");
        }
        return Conv.copy(this.matrix[n]);
    }

    public double[] getColumnCopy(int n) {
        if (n >= this.numberOfColumns) {
            throw new IllegalArgumentException("Column index, " + n + ", must be less than the number of columns, " + this.numberOfColumns);
        }
        if (n < 0) {
            throw new IllegalArgumentException("column index, " + n + ", must be zero or positive");
        }
        double[] dArray = new double[this.numberOfRows];
        for (int j = 0; j < this.numberOfRows; ++j) {
            dArray[j] = this.matrix[j][n];
        }
        return dArray;
    }

    public double getElement(int n, int n2) {
        return this.matrix[n][n2];
    }

    public double getElementCopy(int n, int n2) {
        return this.matrix[n][n2];
    }

    public double getElementPointer(int n, int n2) {
        return this.matrix[n][n2];
    }

    public Matrix getSubMatrix(int n, int n2, int n3, int n4) {
        if (n > n3) {
            throw new IllegalArgumentException("row indices inverted");
        }
        if (n2 > n4) {
            throw new IllegalArgumentException("column indices inverted");
        }
        if (n3 >= this.numberOfRows) {
            throw new IllegalArgumentException("Sub-matrix position is outside the row bounds of this Matrix");
        }
        if (n4 >= this.numberOfColumns) {
            throw new IllegalArgumentException("Sub-matrix position is outside the column bounds of this Matrix" + n + " " + n4);
        }
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        Matrix matrix = new Matrix(n5, n6);
        double[][] dArray = matrix.getArrayReference();
        for (int j = 0; j < n5; ++j) {
            for (int k = 0; k < n6; ++k) {
                dArray[j][k] = this.matrix[n + j][n2 + k];
            }
        }
        return matrix;
    }

    public Matrix getSubMatrix(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = nArray2.length;
        Matrix matrix = new Matrix(n, n2);
        double[][] dArray = matrix.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                dArray[j][k] = this.matrix[nArray[j]][nArray2[k]];
            }
        }
        return matrix;
    }

    public int[] getIndexReference() {
        return this.permutationIndex;
    }

    public int[] getIndexPointer() {
        return this.permutationIndex;
    }

    public int[] getIndexCopy() {
        int[] nArray = new int[this.numberOfRows];
        for (int j = 0; j < this.numberOfRows; ++j) {
            nArray[j] = this.permutationIndex[j];
        }
        return nArray;
    }

    public double getSwap() {
        return this.rowSwapIndex;
    }

    public static Matrix copy(Matrix matrix) {
        int n;
        if (matrix == null) {
            return null;
        }
        int n2 = matrix.getNumberOfRows();
        int n3 = matrix.getNumberOfColumns();
        double[][] dArray = matrix.getArrayReference();
        Matrix matrix2 = new Matrix(n2, n3);
        matrix2.numberOfRows = n2;
        matrix2.numberOfColumns = n3;
        double[][] dArray2 = matrix2.getArrayReference();
        for (n = 0; n < n2; ++n) {
            for (int j = 0; j < n3; ++j) {
                dArray2[n][j] = dArray[n][j];
            }
        }
        for (n = 0; n < n2; ++n) {
            matrix2.permutationIndex[n] = matrix.permutationIndex[n];
        }
        return matrix2;
    }

    public Matrix copy() {
        int n;
        if (this == null) {
            return null;
        }
        int n2 = this.numberOfRows;
        int n3 = this.numberOfColumns;
        Matrix matrix = new Matrix(n2, n3);
        double[][] dArray = matrix.getArrayReference();
        matrix.numberOfRows = n2;
        matrix.numberOfColumns = n3;
        for (n = 0; n < n2; ++n) {
            for (int j = 0; j < n3; ++j) {
                dArray[n][j] = this.matrix[n][j];
            }
        }
        for (n = 0; n < n2; ++n) {
            matrix.permutationIndex[n] = this.permutationIndex[n];
        }
        return matrix;
    }

    public Object clone() {
        int n;
        if (this == null) {
            return null;
        }
        int n2 = this.numberOfRows;
        int n3 = this.numberOfColumns;
        Matrix matrix = new Matrix(n2, n3);
        double[][] dArray = matrix.getArrayReference();
        matrix.numberOfRows = n2;
        matrix.numberOfColumns = n3;
        for (n = 0; n < n2; ++n) {
            for (int j = 0; j < n3; ++j) {
                dArray[n][j] = this.matrix[n][j];
            }
        }
        for (n = 0; n < n2; ++n) {
            matrix.permutationIndex[n] = this.permutationIndex[n];
        }
        return matrix;
    }

    public static Matrix columnMatrix(double[] dArray) {
        int n = dArray.length;
        Matrix matrix = new Matrix(n, 1);
        for (int j = 0; j < n; ++j) {
            matrix.matrix[j][0] = dArray[j];
        }
        return matrix;
    }

    public static Matrix rowMatrix(double[] dArray) {
        int n = dArray.length;
        Matrix matrix = new Matrix(1, n);
        for (int j = 0; j < n; ++j) {
            matrix.matrix[0][j] = dArray[j];
        }
        return matrix;
    }

    public Matrix plus(Matrix matrix) {
        if (this.numberOfRows != matrix.numberOfRows || this.numberOfColumns != matrix.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = matrix.numberOfRows;
        int n2 = matrix.numberOfColumns;
        Matrix matrix2 = new Matrix(n, n2);
        double[][] dArray = matrix2.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                dArray[j][k] = this.matrix[j][k] + matrix.matrix[j][k];
            }
        }
        return matrix2;
    }

    public Matrix plus(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        if (this.numberOfRows != n || this.numberOfColumns != n2) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        Matrix matrix = new Matrix(n, n2);
        double[][] dArray2 = matrix.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                dArray2[j][k] = this.matrix[j][k] + dArray[j][k];
            }
        }
        return matrix;
    }

    public static Matrix plus(Matrix matrix, Matrix matrix2) {
        if (matrix.numberOfRows != matrix2.numberOfRows || matrix.numberOfColumns != matrix2.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = matrix.numberOfRows;
        int n2 = matrix.numberOfColumns;
        Matrix matrix3 = new Matrix(n, n2);
        double[][] dArray = matrix3.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                dArray[j][k] = matrix.matrix[j][k] + matrix2.matrix[j][k];
            }
        }
        return matrix3;
    }

    public void plusEquals(Matrix matrix) {
        if (this.numberOfRows != matrix.numberOfRows || this.numberOfColumns != matrix.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = matrix.numberOfRows;
        int n2 = matrix.numberOfColumns;
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                double[] dArray = this.matrix[j];
                int n3 = k;
                dArray[n3] = dArray[n3] + matrix.matrix[j][k];
            }
        }
    }

    public Matrix minus(Matrix matrix) {
        if (this.numberOfRows != matrix.numberOfRows || this.numberOfColumns != matrix.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = this.numberOfRows;
        int n2 = this.numberOfColumns;
        Matrix matrix2 = new Matrix(n, n2);
        double[][] dArray = matrix2.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                dArray[j][k] = this.matrix[j][k] - matrix.matrix[j][k];
            }
        }
        return matrix2;
    }

    public Matrix minus(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        if (this.numberOfRows != n || this.numberOfColumns != n2) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        Matrix matrix = new Matrix(n, n2);
        double[][] dArray2 = matrix.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                dArray2[j][k] = this.matrix[j][k] - dArray[j][k];
            }
        }
        return matrix;
    }

    public static Matrix minus(Matrix matrix, Matrix matrix2) {
        if (matrix.numberOfRows != matrix2.numberOfRows || matrix.numberOfColumns != matrix2.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = matrix.numberOfRows;
        int n2 = matrix.numberOfColumns;
        Matrix matrix3 = new Matrix(n, n2);
        double[][] dArray = matrix3.getArrayReference();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                dArray[j][k] = matrix.matrix[j][k] - matrix2.matrix[j][k];
            }
        }
        return matrix3;
    }

    public void minusEquals(Matrix matrix) {
        if (this.numberOfRows != matrix.numberOfRows || this.numberOfColumns != matrix.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = matrix.numberOfRows;
        int n2 = matrix.numberOfColumns;
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                double[] dArray = this.matrix[j];
                int n3 = k;
                dArray[n3] = dArray[n3] - matrix.matrix[j][k];
            }
        }
    }

    public Matrix times(Matrix matrix) {
        if (this.numberOfColumns != matrix.numberOfRows) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        Matrix matrix2 = new Matrix(this.numberOfRows, matrix.numberOfColumns);
        double[][] dArray = matrix2.getArrayReference();
        double d = 0.0;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < matrix.numberOfColumns; ++k) {
                d = 0.0;
                for (int i2 = 0; i2 < this.numberOfColumns; ++i2) {
                    d += this.matrix[j][i2] * matrix.matrix[i2][k];
                }
                dArray[j][k] = d;
            }
        }
        return matrix2;
    }

    public Matrix times(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        if (this.numberOfColumns != n) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        Matrix matrix = new Matrix(this.numberOfRows, n2);
        double[][] dArray2 = matrix.getArrayReference();
        double d = 0.0;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < n2; ++k) {
                d = 0.0;
                for (int i2 = 0; i2 < this.numberOfColumns; ++i2) {
                    d += this.matrix[j][i2] * dArray[i2][k];
                }
                dArray2[j][k] = d;
            }
        }
        return matrix;
    }

    public Matrix times(double d) {
        Matrix matrix = new Matrix(this.numberOfRows, this.numberOfColumns);
        double[][] dArray = matrix.getArrayReference();
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                dArray[j][k] = this.matrix[j][k] * d;
            }
        }
        return matrix;
    }

    public static Matrix times(Matrix matrix, Matrix matrix2) {
        if (matrix.numberOfColumns != matrix2.numberOfRows) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        Matrix matrix3 = new Matrix(matrix.numberOfRows, matrix2.numberOfColumns);
        double[][] dArray = matrix3.getArrayReference();
        double d = 0.0;
        for (int j = 0; j < matrix.numberOfRows; ++j) {
            for (int k = 0; k < matrix2.numberOfColumns; ++k) {
                d = 0.0;
                for (int i2 = 0; i2 < matrix.numberOfColumns; ++i2) {
                    d += matrix.matrix[j][i2] * matrix2.matrix[i2][k];
                }
                dArray[j][k] = d;
            }
        }
        return matrix3;
    }

    public static Matrix times(Matrix matrix, double[][] dArray) {
        if (matrix.numberOfColumns != dArray.length) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        Matrix matrix2 = new Matrix(matrix.numberOfRows, dArray[0].length);
        Matrix matrix3 = new Matrix(dArray);
        double[][] dArray2 = matrix2.getArrayReference();
        double d = 0.0;
        for (int j = 0; j < matrix.numberOfRows; ++j) {
            for (int k = 0; k < matrix3.numberOfColumns; ++k) {
                d = 0.0;
                for (int i2 = 0; i2 < matrix.numberOfColumns; ++i2) {
                    d += matrix.matrix[j][i2] * matrix3.matrix[i2][k];
                }
                dArray2[j][k] = d;
            }
        }
        return matrix2;
    }

    public static Matrix times(Matrix matrix, double d) {
        Matrix matrix2 = new Matrix(matrix.numberOfRows, matrix.numberOfColumns);
        double[][] dArray = matrix2.getArrayReference();
        for (int j = 0; j < matrix.numberOfRows; ++j) {
            for (int k = 0; k < matrix.numberOfColumns; ++k) {
                dArray[j][k] = matrix.matrix[j][k] * d;
            }
        }
        return matrix2;
    }

    public void timesEquals(Matrix matrix) {
        int n;
        int n2;
        if (this.numberOfColumns != matrix.numberOfRows) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        Matrix matrix2 = new Matrix(this.numberOfRows, matrix.numberOfColumns);
        double[][] dArray = matrix2.getArrayReference();
        double d = 0.0;
        for (n2 = 0; n2 < this.numberOfRows; ++n2) {
            for (n = 0; n < matrix.numberOfColumns; ++n) {
                d = 0.0;
                for (int j = 0; j < this.numberOfColumns; ++j) {
                    d += this.matrix[n2][j] * matrix.matrix[j][n];
                }
                dArray[n2][n] = d;
            }
        }
        this.numberOfRows = matrix2.numberOfRows;
        this.numberOfColumns = matrix2.numberOfColumns;
        for (n2 = 0; n2 < this.numberOfRows; ++n2) {
            for (n = 0; n < this.numberOfColumns; ++n) {
                this.matrix[n2][n] = matrix2.matrix[n2][n];
            }
        }
    }

    public void timesEquals(double d) {
        for (int j = 0; j < this.numberOfRows; ++j) {
            int n = 0;
            while (n < this.numberOfColumns) {
                double[] dArray = this.matrix[j];
                int n2 = n++;
                dArray[n2] = dArray[n2] * d;
            }
        }
    }

    public Matrix over(Matrix matrix) {
        if (this.numberOfRows != matrix.numberOfRows || this.numberOfColumns != matrix.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        return this.times(matrix.inverse());
    }

    public Matrix over(Matrix matrix, Matrix matrix2) {
        if (matrix.numberOfRows != matrix2.numberOfRows || matrix.numberOfColumns != matrix2.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        return matrix.times(matrix2.inverse());
    }

    public Matrix over(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        if (this.numberOfRows != n || this.numberOfColumns != n2) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        Matrix matrix = new Matrix(dArray);
        return this.times(matrix.inverse());
    }

    public Matrix over(Matrix matrix, double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        if (matrix.numberOfRows != n || matrix.numberOfColumns != n2) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        Matrix matrix2 = new Matrix(dArray);
        return matrix.times(matrix2.inverse());
    }

    public Matrix over(double[][] dArray, Matrix matrix) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        if (matrix.numberOfRows != n || matrix.numberOfColumns != n2) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        Matrix matrix2 = new Matrix(dArray);
        return matrix2.times(matrix.inverse());
    }

    public Matrix over(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        if (dArray2.length != n || dArray2[0].length != n2) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        Matrix matrix = new Matrix(dArray);
        Matrix matrix2 = new Matrix(dArray2);
        return matrix.times(matrix2.inverse());
    }

    public void overEquals(Matrix matrix) {
        if (this.numberOfRows != matrix.numberOfRows || this.numberOfColumns != matrix.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        Matrix matrix2 = new Matrix(matrix);
        this.timesEquals(matrix2.inverse());
    }

    public void overEquals(double[][] dArray) {
        Matrix matrix = new Matrix(dArray);
        this.overEquals(matrix);
    }

    public Matrix inverse() {
        int n = this.numberOfRows;
        if (n != this.numberOfColumns) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Matrix matrix = new Matrix(n, n);
        if (n == 1) {
            double[][] dArray = this.getArrayCopy();
            if (dArray[0][0] == 0.0) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            dArray[0][0] = 1.0 / dArray[0][0];
            matrix = new Matrix(dArray);
        } else if (n == 2) {
            double[][] dArray = this.getArrayCopy();
            double d = dArray[0][0] * dArray[1][1] - dArray[0][1] * dArray[1][0];
            if (d == 0.0) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            double[][] dArray2 = new double[2][2];
            dArray2[0][0] = dArray[1][1] / d;
            dArray2[1][1] = dArray[0][0] / d;
            dArray2[1][0] = -dArray[1][0] / d;
            dArray2[0][1] = -dArray[0][1] / d;
            matrix = new Matrix(dArray2);
        } else {
            double[] dArray = new double[n];
            double[] dArray3 = new double[n];
            double[][] dArray4 = matrix.getArrayReference();
            Matrix matrix2 = this.luDecomp();
            for (int j = 0; j < n; ++j) {
                int n2;
                for (n2 = 0; n2 < n; ++n2) {
                    dArray[n2] = 0.0;
                }
                dArray[j] = 1.0;
                dArray3 = matrix2.luBackSub(dArray);
                for (n2 = 0; n2 < n; ++n2) {
                    dArray4[n2][j] = dArray3[n2];
                }
            }
        }
        return matrix;
    }

    public static Matrix inverse(Matrix matrix) {
        int n = matrix.numberOfRows;
        if (n != matrix.numberOfColumns) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Matrix matrix2 = new Matrix(n, n);
        if (n == 1) {
            double[][] dArray = matrix.getArrayCopy();
            if (dArray[0][0] == 0.0) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            dArray[0][0] = 1.0 / dArray[0][0];
            matrix2 = new Matrix(dArray);
        } else if (n == 2) {
            double[][] dArray = matrix.getArrayCopy();
            double d = dArray[0][0] * dArray[1][1] - dArray[0][1] * dArray[1][0];
            if (d == 0.0) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            double[][] dArray2 = new double[2][2];
            dArray2[0][0] = dArray[1][1] / d;
            dArray2[1][1] = dArray[0][0] / d;
            dArray2[1][0] = -dArray[1][0] / d;
            dArray2[0][1] = -dArray[0][1] / d;
            matrix2 = new Matrix(dArray2);
        } else {
            double[] dArray = new double[n];
            double[] dArray3 = new double[n];
            double[][] dArray4 = matrix2.getArrayReference();
            Matrix matrix3 = matrix.luDecomp();
            for (int j = 0; j < n; ++j) {
                int n2;
                for (n2 = 0; n2 < n; ++n2) {
                    dArray[n2] = 0.0;
                }
                dArray[j] = 1.0;
                dArray3 = matrix3.luBackSub(dArray);
                for (n2 = 0; n2 < n; ++n2) {
                    dArray4[n2][j] = dArray3[n2];
                }
            }
        }
        return matrix2;
    }

    public Matrix transpose() {
        Matrix matrix = new Matrix(this.numberOfColumns, this.numberOfRows);
        double[][] dArray = matrix.getArrayReference();
        for (int j = 0; j < this.numberOfColumns; ++j) {
            for (int k = 0; k < this.numberOfRows; ++k) {
                dArray[j][k] = this.matrix[k][j];
            }
        }
        return matrix;
    }

    public static Matrix transpose(Matrix matrix) {
        Matrix matrix2 = new Matrix(matrix.numberOfColumns, matrix.numberOfRows);
        double[][] dArray = matrix2.getArrayReference();
        for (int j = 0; j < matrix.numberOfColumns; ++j) {
            for (int k = 0; k < matrix.numberOfRows; ++k) {
                dArray[j][k] = matrix.matrix[k][j];
            }
        }
        return matrix2;
    }

    public Matrix opposite() {
        Matrix matrix = Matrix.copy(this);
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                matrix.matrix[j][k] = -this.matrix[j][k];
            }
        }
        return matrix;
    }

    public static Matrix opposite(Matrix matrix) {
        Matrix matrix2 = Matrix.copy(matrix);
        for (int j = 0; j < matrix.numberOfRows; ++j) {
            for (int k = 0; k < matrix.numberOfColumns; ++k) {
                matrix2.matrix[j][k] = -matrix.matrix[j][k];
            }
        }
        return matrix2;
    }

    public double trace() {
        double d = 0.0;
        for (int j = 0; j < Math.min(this.numberOfColumns, this.numberOfColumns); ++j) {
            d += this.matrix[j][j];
        }
        return d;
    }

    public static double trace(Matrix matrix) {
        double d = 0.0;
        for (int j = 0; j < Math.min(matrix.numberOfColumns, matrix.numberOfColumns); ++j) {
            d += matrix.matrix[j][j];
        }
        return d;
    }

    public double determinant() {
        int n = this.numberOfRows;
        if (n != this.numberOfColumns) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        double d = 0.0;
        if (n == 2) {
            d = this.matrix[0][0] * this.matrix[1][1] - this.matrix[0][1] * this.matrix[1][0];
        } else {
            Matrix matrix = this.luDecomp();
            d = matrix.rowSwapIndex;
            for (int j = 0; j < n; ++j) {
                d *= matrix.matrix[j][j];
            }
        }
        return d;
    }

    public static double determinant(Matrix matrix) {
        int n = matrix.numberOfRows;
        if (n != matrix.numberOfColumns) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        double d = 0.0;
        if (n == 2) {
            double[][] dArray = matrix.getArrayCopy();
            d = dArray[0][0] * dArray[1][1] - dArray[0][1] * dArray[1][0];
        } else {
            Matrix matrix2 = matrix.luDecomp();
            d = matrix2.rowSwapIndex;
            for (int j = 0; j < n; ++j) {
                d *= matrix2.matrix[j][j];
            }
        }
        return d;
    }

    public static double determinant(double[][] dArray) {
        int n = dArray.length;
        for (int j = 0; j < n; ++j) {
            if (n == dArray[j].length) continue;
            throw new IllegalArgumentException("Matrix is not square");
        }
        double d = 0.0;
        if (n == 2) {
            d = dArray[0][0] * dArray[1][1] - dArray[0][1] * dArray[1][0];
        } else {
            Matrix matrix = new Matrix(dArray);
            Matrix matrix2 = matrix.luDecomp();
            d = matrix2.rowSwapIndex;
            for (int j = 0; j < n; ++j) {
                d *= matrix2.matrix[j][j];
            }
        }
        return d;
    }

    public double logDeterminant() {
        int n = this.numberOfRows;
        if (n != this.numberOfColumns) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        double d = 0.0;
        Matrix matrix = this.luDecomp();
        d = matrix.rowSwapIndex;
        d = Math.log(d);
        for (int j = 0; j < n; ++j) {
            d += Math.log(matrix.matrix[j][j]);
        }
        return d;
    }

    public static double logDeterminant(Matrix matrix) {
        int n = matrix.numberOfRows;
        if (n != matrix.numberOfColumns) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        double d = 0.0;
        Matrix matrix2 = matrix.luDecomp();
        d = matrix2.rowSwapIndex;
        d = Math.log(d);
        for (int j = 0; j < n; ++j) {
            d += Math.log(matrix2.matrix[j][j]);
        }
        return d;
    }

    public static double logDeterminant(double[][] dArray) {
        int n = dArray.length;
        for (int j = 0; j < n; ++j) {
            if (n == dArray[j].length) continue;
            throw new IllegalArgumentException("Matrix is not square");
        }
        Matrix matrix = new Matrix(dArray);
        return matrix.logDeterminant();
    }

    public Matrix cofactor() {
        double[][] dArray = new double[this.numberOfRows][this.numberOfColumns];
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                dArray[j][k] = this.cofactor(j, k);
            }
        }
        return new Matrix(dArray);
    }

    public double cofactor(int n, int n2) {
        int n3;
        if (n < 0 || n >= this.numberOfRows) {
            throw new IllegalArgumentException("The entered row index, " + n + " must lie between 0 and " + (this.numberOfRows - 1) + " inclusive");
        }
        if (n2 < 0 || n2 >= this.numberOfColumns) {
            throw new IllegalArgumentException("The entered column index, " + n2 + " must lie between 0 and " + (this.numberOfColumns - 1) + " inclusive");
        }
        int[] nArray = new int[this.numberOfRows - 1];
        int[] nArray2 = new int[this.numberOfColumns - 1];
        int n4 = 0;
        for (n3 = 0; n3 < this.numberOfRows; ++n3) {
            if (n3 == n) continue;
            nArray[n4] = n3;
            ++n4;
        }
        n4 = 0;
        for (n3 = 0; n3 < this.numberOfColumns; ++n3) {
            if (n3 == n2) continue;
            nArray2[n4] = n3;
            ++n4;
        }
        Matrix matrix = this.getSubMatrix(nArray, nArray2);
        double d = matrix.determinant();
        return d * Math.pow(-1.0, n + n2);
    }

    public Matrix reducedRowEchelonForm() {
        int n;
        int n2;
        int n3;
        int n4;
        double[][] dArray = new double[this.numberOfRows][this.numberOfColumns];
        for (n4 = 0; n4 < this.numberOfRows; ++n4) {
            for (n3 = 0; n3 < this.numberOfColumns; ++n3) {
                dArray[n4][n3] = this.matrix[n4][n3];
            }
        }
        n4 = 0;
        n3 = 0;
        boolean bl = true;
        while (bl) {
            n2 = n3;
            n = 1;
            while (n != 0 && dArray[n2][n4] == 0.0) {
                if (++n2 != this.numberOfRows) continue;
                n2 = n3;
                if (++n4 != this.numberOfColumns) continue;
                n = 0;
            }
            if (n != 0) {
                double[] dArray2 = dArray[n3];
                dArray[n3] = dArray[n2];
                dArray[n2] = dArray2;
                double d = dArray[n3][n4];
                int n5 = 0;
                while (n5 < this.numberOfColumns) {
                    double[] dArray3 = dArray[n3];
                    int n6 = n5++;
                    dArray3[n6] = dArray3[n6] / d;
                }
                for (n5 = 0; n5 < this.numberOfRows; ++n5) {
                    if (n5 == n3) continue;
                    d = dArray[n5][n4];
                    for (int j = 0; j < this.numberOfColumns; ++j) {
                        double[] dArray4 = dArray[n5];
                        int n7 = j;
                        dArray4[n7] = dArray4[n7] - d * dArray[n3][j];
                    }
                }
                if (++n4 >= this.numberOfColumns) {
                    bl = false;
                }
            }
            if (++n3 < this.numberOfRows && n != 0) continue;
            bl = false;
        }
        for (n2 = 0; n2 < this.numberOfRows; ++n2) {
            for (n = 0; n < this.numberOfColumns; ++n) {
                if (dArray[n2][n] != -0.0) continue;
                dArray[n2][n] = 0.0;
            }
        }
        return new Matrix(dArray);
    }

    public double frobeniusNorm() {
        double d = 0.0;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                d = Matrix.hypot(d, Math.abs(this.matrix[j][k]));
            }
        }
        return d;
    }

    public double oneNorm() {
        double d = 0.0;
        double d2 = 0.0;
        for (int j = 0; j < this.numberOfRows; ++j) {
            d2 = 0.0;
            for (int k = 0; k < this.numberOfColumns; ++k) {
                d2 += Math.abs(this.matrix[j][k]);
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public double infinityNorm() {
        double d = 0.0;
        double d2 = 0.0;
        for (int j = 0; j < this.numberOfRows; ++j) {
            d2 = 0.0;
            for (int k = 0; k < this.numberOfColumns; ++k) {
                d2 += Math.abs(this.matrix[j][k]);
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public double sum() {
        double d = 0.0;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                d += this.matrix[j][k];
            }
        }
        return d;
    }

    public double[] rowSums() {
        double[] dArray = new double[this.numberOfRows];
        for (int j = 0; j < this.numberOfRows; ++j) {
            dArray[j] = 0.0;
            for (int k = 0; k < this.numberOfColumns; ++k) {
                int n = j;
                dArray[n] = dArray[n] + this.matrix[j][k];
            }
        }
        return dArray;
    }

    public double[] columnSums() {
        double[] dArray = new double[this.numberOfColumns];
        for (int j = 0; j < this.numberOfColumns; ++j) {
            dArray[j] = 0.0;
            for (int k = 0; k < this.numberOfRows; ++k) {
                int n = j;
                dArray[n] = dArray[n] + this.matrix[k][j];
            }
        }
        return dArray;
    }

    public double mean() {
        double d = 0.0;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                d += this.matrix[j][k];
            }
        }
        return d /= (double)(this.numberOfRows * this.numberOfColumns);
    }

    public double[] rowMeans() {
        double[] dArray = new double[this.numberOfRows];
        int n = 0;
        while (n < this.numberOfRows) {
            dArray[n] = 0.0;
            for (int j = 0; j < this.numberOfColumns; ++j) {
                int n2 = n;
                dArray[n2] = dArray[n2] + this.matrix[n][j];
            }
            int n3 = n++;
            dArray[n3] = dArray[n3] / (double)this.numberOfColumns;
        }
        return dArray;
    }

    public double[] columnMeans() {
        double[] dArray = new double[this.numberOfColumns];
        int n = 0;
        while (n < this.numberOfColumns) {
            dArray[n] = 0.0;
            for (int j = 0; j < this.numberOfRows; ++j) {
                int n2 = n;
                dArray[n2] = dArray[n2] + this.matrix[j][n];
            }
            int n3 = n++;
            dArray[n3] = dArray[n3] / (double)this.numberOfRows;
        }
        return dArray;
    }

    public Matrix subtractMean() {
        int n;
        int n2;
        Matrix matrix = new Matrix(this.numberOfRows, this.numberOfColumns);
        double d = 0.0;
        for (n2 = 0; n2 < this.numberOfRows; ++n2) {
            for (n = 0; n < this.numberOfColumns; ++n) {
                d += this.matrix[n2][n];
            }
        }
        d /= (double)(this.numberOfRows * this.numberOfColumns);
        for (n2 = 0; n2 < this.numberOfRows; ++n2) {
            for (n = 0; n < this.numberOfColumns; ++n) {
                matrix.matrix[n2][n] = this.matrix[n2][n] - d;
            }
        }
        return matrix;
    }

    public Matrix subtractRowMeans() {
        Matrix matrix = new Matrix(this.numberOfRows, this.numberOfColumns);
        for (int j = 0; j < this.numberOfRows; ++j) {
            int n;
            double d = 0.0;
            for (n = 0; n < this.numberOfColumns; ++n) {
                d += this.matrix[j][n];
            }
            d /= (double)this.numberOfColumns;
            for (n = 0; n < this.numberOfColumns; ++n) {
                matrix.matrix[j][n] = this.matrix[j][n] - d;
            }
        }
        return matrix;
    }

    public Matrix subtractColumnMeans() {
        Matrix matrix = new Matrix(this.numberOfRows, this.numberOfColumns);
        for (int j = 0; j < this.numberOfColumns; ++j) {
            int n;
            double d = 0.0;
            for (n = 0; n < this.numberOfRows; ++n) {
                d += this.matrix[n][j];
            }
            d /= (double)this.numberOfRows;
            for (n = 0; n < this.numberOfRows; ++n) {
                matrix.matrix[n][j] = this.matrix[n][j] - d;
            }
        }
        return matrix;
    }

    public double median() {
        Stat stat = new Stat(this.matrix[0]);
        for (int j = 1; j < this.numberOfRows; ++j) {
            stat.concatenate(this.matrix[j]);
        }
        return stat.median();
    }

    public double[] rowMedians() {
        double[] dArray = new double[this.numberOfRows];
        for (int j = 0; j < this.numberOfRows; ++j) {
            Stat stat = new Stat(this.matrix[j]);
            dArray[j] = stat.median();
        }
        return dArray;
    }

    public double[] columnMedians() {
        double[] dArray = new double[this.numberOfRows];
        for (int j = 0; j < this.numberOfColumns; ++j) {
            double[] dArray2 = new double[this.numberOfRows];
            for (int k = 0; k < this.numberOfRows; ++k) {
                dArray2[j] = this.matrix[k][j];
            }
            Stat stat = new Stat(dArray2);
            dArray[j] = stat.median();
        }
        return dArray;
    }

    public void setDenominatorToN() {
        Stat.setStaticDenominatorToN();
    }

    public double variance() {
        Stat stat = new Stat(this.matrix[0]);
        for (int j = 1; j < this.numberOfRows; ++j) {
            stat.concatenate(this.matrix[j]);
        }
        return stat.variance();
    }

    public double[] rowVariances() {
        double[] dArray = new double[this.numberOfRows];
        for (int j = 0; j < this.numberOfRows; ++j) {
            Stat stat = new Stat(this.matrix[j]);
            dArray[j] = stat.variance();
        }
        return dArray;
    }

    public double[] columnVariances() {
        double[] dArray = new double[this.numberOfColumns];
        for (int j = 0; j < this.numberOfColumns; ++j) {
            double[] dArray2 = new double[this.numberOfRows];
            for (int k = 0; k < this.numberOfRows; ++k) {
                dArray2[j] = this.matrix[k][j];
            }
            Stat stat = new Stat(dArray2);
            dArray[j] = stat.variance();
        }
        return dArray;
    }

    public double standardDeviation() {
        Stat stat = new Stat(this.matrix[0]);
        for (int j = 1; j < this.numberOfRows; ++j) {
            stat.concatenate(this.matrix[j]);
        }
        return stat.standardDeviation();
    }

    public double[] rowStandardDeviations() {
        double[] dArray = new double[this.numberOfRows];
        for (int j = 0; j < this.numberOfRows; ++j) {
            Stat stat = new Stat(this.matrix[j]);
            dArray[j] = stat.standardDeviation();
        }
        return dArray;
    }

    public double[] columnStandardDeviations() {
        double[] dArray = new double[this.numberOfColumns];
        for (int j = 0; j < this.numberOfColumns; ++j) {
            double[] dArray2 = new double[this.numberOfRows];
            for (int k = 0; k < this.numberOfRows; ++k) {
                dArray2[j] = this.matrix[k][j];
            }
            Stat stat = new Stat(dArray2);
            dArray[j] = stat.standardDeviation();
        }
        return dArray;
    }

    public double stanadardError() {
        Stat stat = new Stat(this.matrix[0]);
        for (int j = 1; j < this.numberOfRows; ++j) {
            stat.concatenate(this.matrix[j]);
        }
        return stat.standardError();
    }

    public double[] rowStandardErrors() {
        double[] dArray = new double[this.numberOfRows];
        for (int j = 0; j < this.numberOfRows; ++j) {
            Stat stat = new Stat(this.matrix[j]);
            dArray[j] = stat.standardError();
        }
        return dArray;
    }

    public double[] columnStandardErrors() {
        double[] dArray = new double[this.numberOfRows];
        for (int j = 0; j < this.numberOfColumns; ++j) {
            double[] dArray2 = new double[this.numberOfRows];
            for (int k = 0; k < this.numberOfRows; ++k) {
                dArray2[j] = this.matrix[k][j];
            }
            Stat stat = new Stat(dArray2);
            dArray[j] = stat.standardError();
        }
        return dArray;
    }

    public double[] maximumElement() {
        int n;
        double[] dArray = new double[3];
        double[] dArray2 = new double[this.numberOfRows];
        ArrayMaths arrayMaths = null;
        int[] nArray = new int[this.numberOfRows];
        for (n = 0; n < this.numberOfRows; ++n) {
            arrayMaths = new ArrayMaths(this.matrix[n]);
            dArray2[n] = arrayMaths.maximum();
            nArray[n] = arrayMaths.maximumIndex();
        }
        arrayMaths = new ArrayMaths(dArray2);
        dArray[0] = arrayMaths.maximum();
        n = arrayMaths.maximumIndex();
        dArray[1] = n;
        dArray[2] = nArray[n];
        return dArray;
    }

    public double[] rowMaxima() {
        double[] dArray = new double[this.numberOfRows];
        for (int j = 0; j < this.numberOfRows; ++j) {
            Stat stat = new Stat(this.matrix[j]);
            dArray[j] = stat.maximum();
        }
        return dArray;
    }

    public double[] columnMaxima() {
        double[] dArray = new double[this.numberOfRows];
        for (int j = 0; j < this.numberOfColumns; ++j) {
            double[] dArray2 = new double[this.numberOfRows];
            for (int k = 0; k < this.numberOfRows; ++k) {
                dArray2[j] = this.matrix[k][j];
            }
            Stat stat = new Stat(dArray2);
            dArray[j] = stat.maximum();
        }
        return dArray;
    }

    public double[] minimumElement() {
        int n;
        double[] dArray = new double[3];
        double[] dArray2 = new double[this.numberOfRows];
        ArrayMaths arrayMaths = null;
        int[] nArray = new int[this.numberOfRows];
        for (n = 0; n < this.numberOfRows; ++n) {
            arrayMaths = new ArrayMaths(this.matrix[n]);
            dArray2[n] = arrayMaths.minimum();
            nArray[n] = arrayMaths.minimumIndex();
        }
        arrayMaths = new ArrayMaths(dArray2);
        dArray[0] = arrayMaths.minimum();
        n = arrayMaths.minimumIndex();
        dArray[1] = n;
        dArray[2] = nArray[n];
        return dArray;
    }

    public double[] rowMinima() {
        double[] dArray = new double[this.numberOfRows];
        for (int j = 0; j < this.numberOfRows; ++j) {
            Stat stat = new Stat(this.matrix[j]);
            dArray[j] = stat.minimum();
        }
        return dArray;
    }

    public double[] columnMinima() {
        double[] dArray = new double[this.numberOfRows];
        for (int j = 0; j < this.numberOfColumns; ++j) {
            double[] dArray2 = new double[this.numberOfRows];
            for (int k = 0; k < this.numberOfRows; ++k) {
                dArray2[j] = this.matrix[k][j];
            }
            Stat stat = new Stat(dArray2);
            dArray[j] = stat.minimum();
        }
        return dArray;
    }

    public double range() {
        return this.maximumElement()[0] - this.minimumElement()[0];
    }

    public double[] rowRanges() {
        double[] dArray = new double[this.numberOfRows];
        for (int j = 0; j < this.numberOfRows; ++j) {
            Stat stat = new Stat(this.matrix[j]);
            dArray[j] = stat.maximum() - stat.minimum();
        }
        return dArray;
    }

    public double[] columnRanges() {
        double[] dArray = new double[this.numberOfRows];
        for (int j = 0; j < this.numberOfColumns; ++j) {
            double[] dArray2 = new double[this.numberOfRows];
            for (int k = 0; k < this.numberOfRows; ++k) {
                dArray2[j] = this.matrix[k][j];
            }
            Stat stat = new Stat(dArray2);
            dArray[j] = stat.maximum() - stat.minimum();
        }
        return dArray;
    }

    public int[] pivot() {
        double[] dArray = this.maximumElement();
        int n = (int)dArray[1];
        int n2 = (int)dArray[2];
        double[] dArray2 = this.minimumElement();
        int n3 = (int)dArray2[1];
        int n4 = (int)dArray2[2];
        if (Math.abs(dArray2[0]) > Math.abs(dArray[0])) {
            n = n3;
            n2 = n4;
        }
        int[] nArray = new int[]{n, n2};
        double[] dArray3 = this.matrix[0];
        this.matrix[0] = this.matrix[n];
        this.matrix[n] = dArray3;
        double d = 0.0;
        for (int j = 0; j < this.numberOfRows; ++j) {
            d = this.matrix[j][0];
            this.matrix[j][0] = this.matrix[j][n2];
            this.matrix[j][n2] = d;
        }
        return nArray;
    }

    public boolean isSquare() {
        boolean bl = false;
        if (this.numberOfRows == this.numberOfColumns) {
            bl = true;
        }
        return bl;
    }

    public boolean isSymmetric() {
        boolean bl = true;
        if (this.numberOfRows == this.numberOfColumns) {
            for (int j = 0; j < this.numberOfRows; ++j) {
                for (int k = j + 1; k < this.numberOfColumns; ++k) {
                    if (this.matrix[j][k] == this.matrix[k][j]) continue;
                    bl = false;
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isZero() {
        boolean bl = true;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                if (this.matrix[j][k] == 0.0) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean isUnit() {
        boolean bl = true;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                if (this.matrix[j][k] == 1.0) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean isDiagonal() {
        boolean bl = true;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                if (j == k || this.matrix[j][k] == 0.0) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean isUpperTriagonal() {
        boolean bl = true;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                if (k >= j || this.matrix[j][k] == 0.0) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean isLowerTriagonal() {
        boolean bl = true;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                if (j <= k || this.matrix[j][k] == 0.0) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean isTridiagonal() {
        boolean bl = true;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                if (j < k + 1 && this.matrix[j][k] != 0.0) {
                    bl = false;
                }
                if (k <= j + 1 || this.matrix[j][k] == 0.0) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean isUpperHessenberg() {
        boolean bl = true;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                if (k >= j + 1 || this.matrix[j][k] == 0.0) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean isLowerHessenberg() {
        boolean bl = true;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                if (j <= k + 1 || this.matrix[j][k] == 0.0) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean isIdentity() {
        boolean bl = true;
        if (this.numberOfRows == this.numberOfColumns) {
            for (int j = 0; j < this.numberOfRows; ++j) {
                if (this.matrix[j][j] != 1.0) {
                    bl = false;
                }
                for (int k = j + 1; k < this.numberOfColumns; ++k) {
                    if (this.matrix[j][k] != 0.0) {
                        bl = false;
                    }
                    if (this.matrix[k][j] == 0.0) continue;
                    bl = false;
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isNearlySymmetric(double d) {
        boolean bl = true;
        if (this.numberOfRows == this.numberOfColumns) {
            for (int j = 0; j < this.numberOfRows; ++j) {
                for (int k = j + 1; k < this.numberOfColumns; ++k) {
                    if (!(Math.abs(this.matrix[j][k] - this.matrix[k][j]) > Math.abs(d))) continue;
                    bl = false;
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isNearlyZero(double d) {
        boolean bl = true;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                if (!(Math.abs(this.matrix[j][k]) > Math.abs(d))) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean isNearlyUnit(double d) {
        boolean bl = true;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                if (!(Math.abs(this.matrix[j][k] - 1.0) > Math.abs(d))) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean isNearlyUpperTriagonal(double d) {
        boolean bl = true;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                if (k >= j || !(Math.abs(this.matrix[j][k]) > Math.abs(d))) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean isNearlyLowerTriagonal(double d) {
        boolean bl = true;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                if (j <= k || !(Math.abs(this.matrix[j][k]) > Math.abs(d))) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean isNearlyIdenty(double d) {
        boolean bl = true;
        if (this.numberOfRows == this.numberOfColumns) {
            for (int j = 0; j < this.numberOfRows; ++j) {
                if (Math.abs(this.matrix[j][j] - 1.0) > Math.abs(d)) {
                    bl = false;
                }
                for (int k = j + 1; k < this.numberOfColumns; ++k) {
                    if (Math.abs(this.matrix[j][k]) > Math.abs(d)) {
                        bl = false;
                    }
                    if (!(Math.abs(this.matrix[k][j]) > Math.abs(d))) continue;
                    bl = false;
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isTridiagonal(double d) {
        boolean bl = true;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                if (j < k + 1 && Math.abs(this.matrix[j][k]) > Math.abs(d)) {
                    bl = false;
                }
                if (k <= j + 1 || !(Math.abs(this.matrix[j][k]) > Math.abs(d))) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean isNearlyTridiagonal(double d) {
        boolean bl = true;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                if (j < k + 1 && Math.abs(this.matrix[j][k]) > Math.abs(d)) {
                    bl = false;
                }
                if (k <= j + 1 || !(Math.abs(this.matrix[j][k]) > Math.abs(d))) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean isNearlyUpperHessenberg(double d) {
        boolean bl = true;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                if (k >= j + 1 || !(Math.abs(this.matrix[j][k]) > Math.abs(d))) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean isNearlyLowerHessenberg(double d) {
        boolean bl = true;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                if (j <= k + 1 || !(Math.abs(this.matrix[j][k]) > Math.abs(d))) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean isSingular() {
        boolean bl = false;
        double d = this.determinant();
        if (d == 0.0) {
            bl = true;
        }
        return bl;
    }

    public boolean isNearlySingular(double d) {
        boolean bl = false;
        double d2 = this.determinant();
        if (Math.abs(d2) <= Math.abs(d)) {
            bl = true;
        }
        return bl;
    }

    public ArrayList<Integer> identicalRows() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        for (int j = 0; j < this.numberOfRows - 1; ++j) {
            for (int k = j + 1; k < this.numberOfRows; ++k) {
                int n2 = 0;
                for (int i2 = 0; i2 < this.numberOfColumns; ++i2) {
                    if (this.matrix[j][i2] != this.matrix[k][i2]) continue;
                    ++n2;
                }
                if (n2 != this.numberOfColumns) continue;
                ++n;
                arrayList.add(new Integer(j));
                arrayList.add(new Integer(k));
            }
        }
        arrayList.add(0, new Integer(n));
        return arrayList;
    }

    public ArrayList<Integer> identicalColumns() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        for (int j = 0; j < this.numberOfColumns; ++j) {
            for (int k = j + 1; k < this.numberOfColumns - 1; ++k) {
                int n2 = 0;
                for (int i2 = 0; i2 < this.numberOfRows; ++i2) {
                    if (this.matrix[i2][j] != this.matrix[i2][k]) continue;
                    ++n2;
                }
                if (n2 != this.numberOfRows) continue;
                ++n;
                arrayList.add(new Integer(j));
                arrayList.add(new Integer(k));
            }
        }
        arrayList.add(0, new Integer(n));
        return arrayList;
    }

    public ArrayList<Integer> zeroRows() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        for (int j = 0; j < this.numberOfRows; ++j) {
            int n2 = 0;
            for (int k = 0; k < this.numberOfColumns; ++k) {
                if (this.matrix[j][k] != 0.0) continue;
                ++n2;
            }
            if (n2 != this.numberOfColumns) continue;
            ++n;
            arrayList.add(new Integer(j));
        }
        arrayList.add(0, new Integer(n));
        return arrayList;
    }

    public ArrayList<Integer> zeroColumns() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        for (int j = 0; j < this.numberOfColumns; ++j) {
            int n2 = 0;
            for (int k = 0; k < this.numberOfRows; ++k) {
                if (this.matrix[k][j] != 0.0) continue;
                ++n2;
            }
            if (n2 != this.numberOfRows) continue;
            ++n;
            arrayList.add(new Integer(j));
        }
        arrayList.add(0, new Integer(n));
        return arrayList;
    }

    public Matrix luDecomp() {
        int n;
        int n2;
        if (this.numberOfRows != this.numberOfColumns) {
            throw new IllegalArgumentException("A matrix is not square");
        }
        int n3 = this.numberOfRows;
        int n4 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray = new double[n3];
        double d4 = 0.0;
        double d5 = 0.0;
        this.matrixCheck = true;
        Matrix matrix = Matrix.copy(this);
        double[][] dArray2 = matrix.getArrayReference();
        matrix.rowSwapIndex = 1.0;
        for (n2 = 0; n2 < n3; ++n2) {
            d3 = 0.0;
            for (n = 0; n < n3; ++n) {
                double d6;
                d2 = Math.abs(dArray2[n2][n]);
                if (!(d6 > d3)) continue;
                d3 = d2;
            }
            if (d3 == 0.0) {
                if (!this.suppressErrorMessage) {
                    System.out.println("Attempted LU Decomposition of a singular matrix in Matrix.luDecomp()");
                    System.out.println("NaN matrix returned and matrixCheck set to false");
                }
                this.matrixCheck = false;
                for (n = 0; n < n3; ++n) {
                    for (int j = 0; j < n3; ++j) {
                        dArray2[n][j] = Double.NaN;
                    }
                }
                return matrix;
            }
            dArray[n2] = 1.0 / d3;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n5;
            for (n = 0; n < n2; ++n) {
                d4 = dArray2[n][n2];
                for (n5 = 0; n5 < n; ++n5) {
                    d4 -= dArray2[n][n5] * dArray2[n5][n2];
                }
                dArray2[n][n2] = d4;
            }
            d3 = 0.0;
            for (n = n2; n < n3; ++n) {
                double d7;
                d4 = dArray2[n][n2];
                for (n5 = 0; n5 < n2; ++n5) {
                    d4 -= dArray2[n][n5] * dArray2[n5][n2];
                }
                dArray2[n][n2] = d4;
                d = dArray[n] * Math.abs(d4);
                if (!(d7 >= d3)) continue;
                d3 = d;
                n4 = n;
            }
            if (n2 != n4) {
                for (n = 0; n < n3; ++n) {
                    d5 = dArray2[n4][n];
                    dArray2[n4][n] = dArray2[n2][n];
                    dArray2[n2][n] = d5;
                }
                matrix.rowSwapIndex = -matrix.rowSwapIndex;
                dArray[n4] = dArray[n2];
            }
            matrix.permutationIndex[n2] = n4;
            if (dArray2[n2][n2] == 0.0) {
                dArray2[n2][n2] = this.tiny;
            }
            if (n2 == n3 - 1) continue;
            d5 = 1.0 / dArray2[n2][n2];
            for (n = n2 + 1; n < n3; ++n) {
                double[] dArray3 = dArray2[n];
                int n6 = n2;
                dArray3[n6] = dArray3[n6] * d5;
            }
        }
        return matrix;
    }

    public double[] luBackSub(double[] dArray) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = dArray.length;
        if (n5 != this.numberOfColumns) {
            throw new IllegalArgumentException("vector length is not equal to matrix dimension");
        }
        if (this.numberOfColumns != this.numberOfRows) {
            throw new IllegalArgumentException("matrix is not square");
        }
        double d = 0.0;
        double[] dArray2 = new double[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            dArray2[n2] = dArray[n2];
        }
        for (n2 = 0; n2 < n5; ++n2) {
            n4 = this.permutationIndex[n2];
            d = dArray2[n4];
            dArray2[n4] = dArray2[n2];
            if (n3 == 0) {
                for (n = n3; n <= n2 - 1; ++n) {
                    d -= this.matrix[n2][n] * dArray2[n];
                }
            } else if (d == 0.0) {
                n3 = n2;
            }
            dArray2[n2] = d;
        }
        for (n2 = n5 - 1; n2 >= 0; --n2) {
            d = dArray2[n2];
            for (n = n2 + 1; n < n5; ++n) {
                d -= this.matrix[n2][n] * dArray2[n];
            }
            dArray2[n2] = d / this.matrix[n2][n2];
        }
        return dArray2;
    }

    public double[] solveLinearSet(double[] dArray) {
        double[] dArray2 = null;
        if (this.numberOfRows == this.numberOfColumns) {
            Matrix matrix = this.luDecomp();
            dArray2 = matrix.luBackSub(dArray);
        } else if (this.numberOfRows > this.numberOfColumns) {
            int n = dArray.length;
            if (this.numberOfRows != n) {
                throw new IllegalArgumentException("Overdetermined equation solution - vector length is not equal to matrix column length");
            }
            Matrix matrix = this.transpose();
            double[][] dArray3 = matrix.getArrayCopy();
            Regression regression = new Regression(dArray3, dArray);
            regression.linearGeneral();
            dArray2 = regression.getCoeff();
        } else {
            throw new IllegalArgumentException("This class does not handle underdetermined equations");
        }
        return dArray2;
    }

    public void suppressErrorMessage() {
        this.suppressErrorMessage = true;
    }

    public void supressErrorMessage() {
        this.suppressErrorMessage = true;
    }

    public void hessenbergMatrix() {
        int n;
        int n2;
        this.hessenberg = this.getArrayCopy();
        double d = 0.0;
        int n3 = 0;
        double d2 = 0.0;
        for (n2 = 1; n2 < this.numberOfRows - 1; ++n2) {
            d = 0.0;
            n3 = n2;
            for (n = n2; n < this.numberOfRows; ++n) {
                if (!(Math.abs(this.hessenberg[n][n2 - 1]) > Math.abs(d))) continue;
                d = this.hessenberg[n][n2 - 1];
                n3 = n;
            }
            if (n3 == n2) continue;
            for (n = n2 - 1; n < this.numberOfRows; ++n) {
                d2 = this.hessenberg[n3][n];
                this.hessenberg[n3][n] = this.hessenberg[n2][n];
                this.hessenberg[n2][n] = d2;
            }
            for (n = 0; n < this.numberOfRows; ++n) {
                d2 = this.hessenberg[n][n3];
                this.hessenberg[n][n3] = this.hessenberg[n][n2];
                this.hessenberg[n][n2] = d2;
            }
            if (d == 0.0) continue;
            for (n = n2 + 1; n < this.numberOfRows; ++n) {
                int n4;
                d2 = this.hessenberg[n][n2 - 1];
                if (d2 == 0.0) continue;
                this.hessenberg[n][n2 - 1] = d2 /= d;
                for (n4 = n2; n4 < this.numberOfRows; ++n4) {
                    double[] dArray = this.hessenberg[n];
                    int n5 = n4;
                    dArray[n5] = dArray[n5] - d2 * this.hessenberg[n2][n4];
                }
                for (n4 = 0; n4 < this.numberOfRows; ++n4) {
                    double[] dArray = this.hessenberg[n4];
                    int n6 = n2;
                    dArray[n6] = dArray[n6] + d2 * this.hessenberg[n4][n];
                }
            }
        }
        for (n2 = 2; n2 < this.numberOfRows; ++n2) {
            for (n = 0; n < n2 - 1; ++n) {
                this.hessenberg[n2][n] = 0.0;
            }
        }
        this.hessenbergDone = true;
    }

    public double[][] getHessenbergMatrix() {
        if (!this.hessenbergDone) {
            this.hessenbergMatrix();
        }
        return this.hessenberg;
    }

    public double[] getEigenValues() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        return this.eigenValues;
    }

    public double[] getSortedEigenValues() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        return this.sortedEigenValues;
    }

    public double[][] getEigenVectorsAsColumns() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        return this.eigenVector;
    }

    public double[][] getEigenVector() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        return this.eigenVector;
    }

    public double[][] getEigenVectorsAsRows() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        double[][] dArray = new double[this.numberOfRows][this.numberOfRows];
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfRows; ++k) {
                dArray[j][k] = this.eigenVector[k][j];
            }
        }
        return dArray;
    }

    public double[][] getSortedEigenVectorsAsColumns() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        return this.sortedEigenVector;
    }

    public double[][] getSortedEigenVector() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        return this.sortedEigenVector;
    }

    public double[][] getSortedEigenVectorsAsRows() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        double[][] dArray = new double[this.numberOfRows][this.numberOfRows];
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfRows; ++k) {
                dArray[j][k] = this.sortedEigenVector[k][j];
            }
        }
        return dArray;
    }

    public int getNumberOfJacobiRotations() {
        return this.numberOfRotations;
    }

    private void symmetricEigen() {
        int n;
        int n2;
        if (!this.isSymmetric()) {
            throw new IllegalArgumentException("matrix is not symmetric");
        }
        double[][] dArray = this.getArrayCopy();
        this.eigenVector = new double[this.numberOfRows][this.numberOfRows];
        this.eigenValues = new double[this.numberOfRows];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double[] dArray2 = new double[this.numberOfRows];
        double[] dArray3 = new double[this.numberOfRows];
        for (n2 = 0; n2 < this.numberOfRows; ++n2) {
            for (n = 0; n < this.numberOfRows; ++n) {
                this.eigenVector[n2][n] = 0.0;
            }
            this.eigenVector[n2][n2] = 1.0;
        }
        for (n2 = 0; n2 < this.numberOfRows; ++n2) {
            dArray2[n2] = dArray[n2][n2];
            this.eigenValues[n2] = dArray[n2][n2];
            dArray3[n2] = 0.0;
        }
        this.numberOfRotations = 0;
        for (n2 = 1; n2 <= this.maximumJacobiIterations; ++n2) {
            int n3;
            d4 = 0.0;
            for (n = 0; n < this.numberOfRows - 1; ++n) {
                for (n3 = n + 1; n3 < this.numberOfRows; ++n3) {
                    d4 += Math.abs(dArray[n][n3]);
                }
            }
            if (d4 == 0.0) {
                this.eigenDone = true;
                this.eigenSort();
                return;
            }
            d = n2 < 4 ? 0.2 * d4 / (double)(this.numberOfRows * this.numberOfRows) : 0.0;
            for (n = 0; n < this.numberOfRows - 1; ++n) {
                for (n3 = n + 1; n3 < this.numberOfRows; ++n3) {
                    int n4;
                    d5 = 100.0 * Math.abs(dArray[n][n3]);
                    if (n2 > 4 && Math.abs(this.eigenValues[n]) + d5 == Math.abs(this.eigenValues[n]) && Math.abs(this.eigenValues[n3]) + d5 == Math.abs(this.eigenValues[n3])) {
                        dArray[n][n3] = 0.0;
                        continue;
                    }
                    if (!(Math.abs(dArray[n][n3]) > d)) continue;
                    d9 = this.eigenValues[n3] - this.eigenValues[n];
                    if (Math.abs(d9) + d5 == Math.abs(d9)) {
                        d8 = dArray[n][n3] / d9;
                    } else {
                        d2 = 0.5 * d9 / dArray[n][n3];
                        d8 = 1.0 / (Math.abs(d2) + Math.sqrt(1.0 + d2 * d2));
                        if (d2 < 0.0) {
                            d8 = -d8;
                        }
                    }
                    d7 = 1.0 / Math.sqrt(1.0 + d8 * d8);
                    d6 = d8 * d7;
                    d3 = d6 / (1.0 + d7);
                    d9 = d8 * dArray[n][n3];
                    int n5 = n;
                    dArray3[n5] = dArray3[n5] - d9;
                    int n6 = n3;
                    dArray3[n6] = dArray3[n6] + d9;
                    int n7 = n;
                    this.eigenValues[n7] = this.eigenValues[n7] - d9;
                    int n8 = n3;
                    this.eigenValues[n8] = this.eigenValues[n8] + d9;
                    dArray[n][n3] = 0.0;
                    for (n4 = 0; n4 <= n - 1; ++n4) {
                        this.rotation(dArray, d3, d6, n4, n, n4, n3);
                    }
                    for (n4 = n + 1; n4 <= n3 - 1; ++n4) {
                        this.rotation(dArray, d3, d6, n, n4, n4, n3);
                    }
                    for (n4 = n3 + 1; n4 < this.numberOfRows; ++n4) {
                        this.rotation(dArray, d3, d6, n, n4, n3, n4);
                    }
                    for (n4 = 0; n4 < this.numberOfRows; ++n4) {
                        this.rotation(this.eigenVector, d3, d6, n4, n, n4, n3);
                    }
                    ++this.numberOfRotations;
                }
            }
            for (n = 0; n < this.numberOfRows; ++n) {
                int n9 = n;
                dArray2[n9] = dArray2[n9] + dArray3[n];
                this.eigenValues[n] = dArray2[n];
                dArray3[n] = 0.0;
            }
        }
        System.out.println("Maximum iterations, " + this.maximumJacobiIterations + ", reached - values at this point returned");
        this.eigenDone = true;
        this.eigenSort();
    }

    private void rotation(double[][] dArray, double d, double d2, int n, int n2, int n3, int n4) {
        double d3 = dArray[n][n2];
        double d4 = dArray[n3][n4];
        dArray[n][n2] = d3 - d2 * (d4 + d3 * d);
        dArray[n3][n4] = d4 + d2 * (d3 - d4 * d);
    }

    private void eigenSort() {
        int n;
        int n2;
        int n3 = 0;
        this.sortedEigenValues = Conv.copy(this.eigenValues);
        this.sortedEigenVector = Conv.copy(this.eigenVector);
        this.eigenIndices = new int[this.numberOfRows];
        for (n2 = 0; n2 < this.numberOfRows - 1; ++n2) {
            double d = this.sortedEigenValues[n2];
            n3 = n2;
            for (n = n2 + 1; n < this.numberOfRows; ++n) {
                if (!(this.sortedEigenValues[n] >= d)) continue;
                d = this.sortedEigenValues[n];
                n3 = n;
            }
            if (n3 == n2) continue;
            this.sortedEigenValues[n3] = this.sortedEigenValues[n2];
            this.sortedEigenValues[n2] = d;
            for (n = 0; n < this.numberOfRows; ++n) {
                d = this.sortedEigenVector[n][n2];
                this.sortedEigenVector[n][n2] = this.sortedEigenVector[n][n3];
                this.sortedEigenVector[n][n3] = d;
            }
        }
        this.eigenIndices = new int[this.numberOfRows];
        for (n2 = 0; n2 < this.numberOfRows; ++n2) {
            n = 1;
            int n4 = 0;
            while (n != 0) {
                if (this.sortedEigenValues[n2] == this.eigenValues[n4]) {
                    this.eigenIndices[n2] = n4;
                    n = 0;
                    continue;
                }
                ++n4;
            }
        }
    }

    public int[] eigenValueIndices() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        return this.eigenIndices;
    }

    private static double hypot(double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = Math.abs(d);
        double d6 = Math.abs(d2);
        if (d5 == 0.0) {
            d3 = d6;
        } else if (d6 == 0.0) {
            d3 = d5;
        } else if (d5 <= d6) {
            d4 = d5 / d6;
            d3 = d6 * Math.sqrt(1.0 + d4 * d4);
        } else {
            d4 = d6 / d5;
            d3 = d5 * Math.sqrt(1.0 + d4 * d4);
        }
        return d3;
    }
}

