/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;

public class Polynomial {
    private int deg = 0;
    private int degwz = 0;
    private double[] coeff;
    private double[] coeffwz;
    private boolean suppressRootsErrorMessages = false;

    public Polynomial(int n) {
        this.deg = n;
        this.coeff = new double[n + 1];
    }

    public Polynomial(double[] dArray) {
        this.deg = dArray.length - 1;
        this.coeff = new double[this.deg + 1];
        for (int j = 0; j <= this.deg; ++j) {
            this.coeff[j] = dArray[j];
        }
    }

    public Polynomial(float[] fArray) {
        this.deg = fArray.length - 1;
        this.coeff = new double[this.deg + 1];
        for (int j = 0; j <= this.deg; ++j) {
            this.coeff[j] = fArray[j];
        }
    }

    public Polynomial(long[] lArray) {
        this.deg = lArray.length - 1;
        this.coeff = new double[this.deg + 1];
        for (int j = 0; j <= this.deg; ++j) {
            this.coeff[j] = lArray[j];
        }
    }

    public Polynomial(int[] nArray) {
        this.deg = nArray.length - 1;
        this.coeff = new double[this.deg + 1];
        for (int j = 0; j <= this.deg; ++j) {
            this.coeff[j] = nArray[j];
        }
    }

    public Polynomial(ArrayList<Object> arrayList) {
        this.deg = arrayList.size() - 1;
        this.coeff = new double[this.deg + 1];
        block10: for (int j = 0; j <= this.deg; ++j) {
            int n = this.getTypeCode(arrayList.get(j));
            switch (n) {
                case 1: {
                    this.coeff[j] = ((Byte)arrayList.get(j)).byteValue();
                    continue block10;
                }
                case 2: {
                    this.coeff[j] = ((Short)arrayList.get(j)).shortValue();
                    continue block10;
                }
                case 3: {
                    this.coeff[j] = ((Integer)arrayList.get(j)).intValue();
                    continue block10;
                }
                case 4: {
                    this.coeff[j] = ((Long)arrayList.get(j)).longValue();
                    continue block10;
                }
                case 5: {
                    this.coeff[j] = ((Float)arrayList.get(j)).floatValue();
                    continue block10;
                }
                case 6: {
                    this.coeff[j] = (Double)arrayList.get(j);
                    continue block10;
                }
                case 7: {
                    this.coeff[j] = ((BigInteger)arrayList.get(j)).doubleValue();
                    continue block10;
                }
                case 8: {
                    this.coeff[j] = ((BigDecimal)arrayList.get(j)).doubleValue();
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Type code, " + n + ", not recognised");
                }
            }
        }
    }

    private int getTypeCode(Object object) {
        int n = 0;
        if (object instanceof Byte) {
            n = 1;
        } else if (object instanceof Short) {
            n = 2;
        } else if (object instanceof Integer) {
            n = 3;
        } else if (object instanceof Long) {
            n = 4;
        } else if (object instanceof Float) {
            n = 5;
        } else if (object instanceof Double) {
            n = 6;
        } else if (object instanceof BigInteger) {
            n = 7;
        } else if (object instanceof BigDecimal) {
            n = 8;
        }
        return n;
    }

    public Polynomial(double d) {
        this.deg = 0;
        this.coeff = new double[1];
        this.coeff[0] = d;
    }

    public Polynomial(double d, double d2) {
        this.deg = 1;
        this.coeff = new double[2];
        this.coeff[0] = d;
        this.coeff[1] = d2;
    }

    public Polynomial(double d, double d2, double d3) {
        this.deg = 2;
        this.coeff = new double[3];
        this.coeff[0] = d;
        this.coeff[1] = d2;
        this.coeff[2] = d3;
    }

    public Polynomial(double d, double d2, double d3, double d4) {
        this.deg = 3;
        this.coeff = new double[4];
        this.coeff[0] = d;
        this.coeff[1] = d2;
        this.coeff[2] = d3;
        this.coeff[3] = d4;
    }

    public Polynomial reducePoly() {
        Polynomial polynomial = null;
        int n = this.deg;
        boolean bl = true;
        int n2 = this.deg;
        while (bl) {
            if (this.coeff[n2] == 0.0) {
                --n;
                if (--n2 >= 0) continue;
                bl = false;
                continue;
            }
            bl = false;
        }
        if (this.deg == n) {
            polynomial = this.copy();
        } else if (n >= 0) {
            polynomial = new Polynomial(n);
            for (int j = 0; j <= n; ++j) {
                polynomial.resetCoeff(j, this.coeff[j]);
            }
        }
        return polynomial;
    }

    public static Polynomial reducePoly(Polynomial polynomial) {
        Polynomial polynomial2 = null;
        if (polynomial2 != null) {
            int n;
            int n2 = n = polynomial.getDeg();
            boolean bl = true;
            int n3 = n2;
            while (bl) {
                if (polynomial.coeff[n3] == 0.0) {
                    --n2;
                    if (--n3 >= 0) continue;
                    bl = false;
                    continue;
                }
                bl = false;
            }
            if (n2 == n) {
                polynomial2 = polynomial.copy();
            } else if (n2 >= 0) {
                polynomial2 = new Polynomial(n2);
                for (int j = 0; j <= n2; ++j) {
                    polynomial2.resetCoeff(j, polynomial.coeff[j]);
                }
            }
        }
        return polynomial2;
    }

    public static Polynomial rootsToPoly(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        double[] dArray2 = new double[]{-dArray[0], 1.0};
        Polynomial polynomial = new Polynomial(dArray2);
        for (int j = 1; j < n; ++j) {
            dArray2[0] = -dArray[j];
            Polynomial polynomial2 = new Polynomial(dArray2);
            polynomial = polynomial.times(polynomial2);
        }
        return polynomial;
    }

    public void resetPoly(double[] dArray) {
        if (this.deg + 1 != dArray.length) {
            throw new IllegalArgumentException("array lengths do not match");
        }
        for (int j = 0; j < this.deg; ++j) {
            this.coeff[j] = dArray[j];
        }
    }

    public void resetPoly(ArrayList<Object> arrayList) {
        if (this.deg + 1 != arrayList.size()) {
            throw new IllegalArgumentException("array lengths do not match");
        }
        block10: for (int j = 0; j <= this.deg; ++j) {
            int n = this.getTypeCode(arrayList.get(j));
            switch (n) {
                case 1: {
                    this.coeff[j] = ((Byte)arrayList.get(j)).byteValue();
                    continue block10;
                }
                case 2: {
                    this.coeff[j] = ((Short)arrayList.get(j)).shortValue();
                    continue block10;
                }
                case 3: {
                    this.coeff[j] = ((Integer)arrayList.get(j)).intValue();
                    continue block10;
                }
                case 4: {
                    this.coeff[j] = ((Long)arrayList.get(j)).longValue();
                    continue block10;
                }
                case 5: {
                    this.coeff[j] = ((Float)arrayList.get(j)).floatValue();
                    continue block10;
                }
                case 6: {
                    this.coeff[j] = (Double)arrayList.get(j);
                    continue block10;
                }
                case 7: {
                    this.coeff[j] = ((BigInteger)arrayList.get(j)).doubleValue();
                    continue block10;
                }
                case 8: {
                    this.coeff[j] = ((BigDecimal)arrayList.get(j)).doubleValue();
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Type code, " + n + ", not recognised");
                }
            }
        }
    }

    public void resetCoeff(int n, double d) {
        this.coeff[n] = d;
    }

    public Polynomial copy() {
        if (this == null) {
            return null;
        }
        Polynomial polynomial = new Polynomial(this.deg);
        for (int j = 0; j <= this.deg; ++j) {
            polynomial.coeff[j] = this.coeff[j];
        }
        polynomial.deg = this.deg;
        polynomial.degwz = this.degwz;
        polynomial.coeffwz = Conv.copy(this.coeffwz);
        return polynomial;
    }

    public static Polynomial copy(Polynomial polynomial) {
        if (polynomial == null) {
            return null;
        }
        Polynomial polynomial2 = new Polynomial(polynomial.deg);
        for (int j = 0; j <= polynomial.deg; ++j) {
            polynomial2.coeff[j] = polynomial.coeff[j];
        }
        polynomial2.deg = polynomial.deg;
        polynomial2.degwz = polynomial.degwz;
        polynomial2.coeffwz = Conv.copy(polynomial.coeffwz);
        return polynomial2;
    }

    public Object clone() {
        return this.copy();
    }

    public double[] coefficientsCopy() {
        double[] dArray = new double[this.deg + 1];
        for (int j = 0; j <= this.deg; ++j) {
            dArray[j] = this.coeff[j];
        }
        return dArray;
    }

    public double[] coefficientsReference() {
        return this.coeff;
    }

    public double getCoefficient(int n) {
        return this.coeff[n];
    }

    public int getDeg() {
        return this.deg;
    }

    public String toString() {
        String string = "";
        string = string + this.coeff[0];
        if (this.deg > 0) {
            string = string + " + (" + this.coeff[1] + ").x";
        }
        for (int j = 2; j <= this.deg; ++j) {
            string = string + " + (" + this.coeff[j] + ").x^" + j;
        }
        return string;
    }

    public ComplexPoly toComplexPoly() {
        ComplexPoly complexPoly = new ComplexPoly(this);
        return complexPoly;
    }

    public void print() {
        System.out.print(this.toString());
    }

    public void println() {
        System.out.println(this.toString());
    }

    public void printToText(String string) {
        string = string + ".txt";
        FileOutput fileOutput = new FileOutput(string, 'n');
        fileOutput.println("Output File for a Polynomial");
        fileOutput.dateAndTimeln();
        fileOutput.println();
        fileOutput.print("Polynomial degree is ");
        fileOutput.println(this.deg);
        fileOutput.println();
        fileOutput.println("The coefficients are ");
        for (int j = 0; j <= this.deg; ++j) {
            fileOutput.println(this.coeff[j]);
        }
        fileOutput.println();
        fileOutput.println("End of file.");
        fileOutput.close();
    }

    public void printToText() {
        String string = "PolynomialOut";
        this.printToText(string);
    }

    public ArrayList<ComplexPoly> sTransform() {
        return Polynomial.sTransform(this.coeff);
    }

    public static ArrayList<ComplexPoly> sTransform(Polynomial polynomial) {
        return Polynomial.sTransform(polynomial.coefficientsCopy());
    }

    public static ArrayList<ComplexPoly> sTransform(double[] dArray) {
        int n;
        int n2 = dArray.length;
        ComplexPoly[] complexPolyArray = new ComplexPoly[n2];
        ComplexPoly[] complexPolyArray2 = new ComplexPoly[n2];
        ComplexPoly complexPoly = null;
        ComplexPoly complexPoly2 = new ComplexPoly(Complex.plusOne());
        for (n = 0; n < n2; ++n) {
            complexPolyArray[n] = new ComplexPoly(new Complex(dArray[n] * (double)Fmath.factorial(n), 0.0));
            complexPolyArray2[n] = new ComplexPoly(n + 1);
            complexPolyArray2[n].resetCoeff(n + 1, Complex.plusOne());
        }
        complexPoly2 = complexPolyArray2[n2 - 1];
        for (n = 0; n < n2 - 1; ++n) {
            complexPolyArray[n] = complexPolyArray[n].times(complexPolyArray2[n2 - n - 2]);
        }
        complexPoly = complexPolyArray[0];
        for (n = 1; n < n2; ++n) {
            complexPoly = complexPoly.plus(complexPolyArray[n]);
        }
        ArrayList<ComplexPoly> arrayList = new ArrayList<ComplexPoly>();
        arrayList.add(complexPoly);
        arrayList.add(complexPoly2);
        return arrayList;
    }

    public boolean equals(Polynomial polynomial) {
        return this.isEqual(polynomial);
    }

    public boolean isEqual(Polynomial polynomial) {
        int n;
        boolean bl = false;
        int n2 = this.getDeg();
        if (n2 == (n = polynomial.getDeg())) {
            boolean bl2 = true;
            int n3 = 0;
            while (bl2) {
                if (this.coeff[n3] != polynomial.getCoefficient(n3)) {
                    bl2 = false;
                    continue;
                }
                if (++n3 <= n) continue;
                bl2 = false;
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isEqual(Polynomial polynomial, Polynomial polynomial2) {
        int n;
        boolean bl = false;
        int n2 = polynomial.getDeg();
        if (n2 == (n = polynomial2.getDeg())) {
            boolean bl2 = true;
            int n3 = 0;
            while (bl2) {
                if (polynomial.getCoefficient(n3) != polynomial2.getCoefficient(n3)) {
                    bl2 = false;
                    continue;
                }
                if (++n3 <= n2) continue;
                bl2 = false;
                bl = true;
            }
        }
        return bl;
    }

    public Polynomial plus(Polynomial polynomial) {
        Polynomial polynomial2 = null;
        if (polynomial.deg <= this.deg) {
            int n;
            polynomial2 = new Polynomial(this.deg);
            for (n = polynomial.deg + 1; n <= this.deg; ++n) {
                polynomial2.coeff[n] = this.coeff[n];
            }
            for (n = 0; n <= polynomial.deg; ++n) {
                polynomial2.coeff[n] = this.coeff[n] + polynomial.coeff[n];
            }
        } else {
            int n;
            polynomial2 = new Polynomial(polynomial.deg);
            for (n = this.deg + 1; n <= polynomial.deg; ++n) {
                polynomial2.coeff[n] = polynomial.coeff[n];
            }
            for (n = 0; n <= this.deg; ++n) {
                polynomial2.coeff[n] = this.coeff[n] + polynomial.coeff[n];
            }
        }
        return polynomial2;
    }

    public static Polynomial plus(Polynomial polynomial, Polynomial polynomial2) {
        Polynomial polynomial3 = null;
        if (polynomial2.deg <= polynomial.deg) {
            int n;
            polynomial3 = new Polynomial(polynomial.deg);
            for (n = polynomial2.deg + 1; n <= polynomial.deg; ++n) {
                polynomial3.coeff[n] = polynomial.coeff[n];
            }
            for (n = 0; n <= polynomial2.deg; ++n) {
                polynomial3.coeff[n] = polynomial.coeff[n] + polynomial2.coeff[n];
            }
        } else {
            int n;
            polynomial3 = new Polynomial(polynomial2.deg);
            for (n = polynomial.deg + 1; n <= polynomial2.deg; ++n) {
                polynomial3.coeff[n] = polynomial2.coeff[n];
            }
            for (n = 0; n <= polynomial.deg; ++n) {
                polynomial3.coeff[n] = polynomial.coeff[n] + polynomial2.coeff[n];
            }
        }
        return polynomial3;
    }

    public Polynomial plus(double d) {
        Polynomial polynomial = new Polynomial(d);
        return this.plus(polynomial);
    }

    public static Polynomial plus(Polynomial polynomial, double d) {
        Polynomial polynomial2 = new Polynomial(d);
        return Polynomial.plus(polynomial, polynomial2);
    }

    public Polynomial plus(int n) {
        Polynomial polynomial = new Polynomial((double)n);
        return this.plus(polynomial);
    }

    public static Polynomial plus(Polynomial polynomial, int n) {
        Polynomial polynomial2 = new Polynomial((double)n);
        return Polynomial.plus(polynomial, polynomial2);
    }

    public Polynomial minus(Polynomial polynomial) {
        Polynomial polynomial2 = null;
        if (polynomial.deg <= this.deg) {
            int n;
            polynomial2 = new Polynomial(this.deg);
            for (n = polynomial.deg + 1; n <= this.deg; ++n) {
                polynomial2.coeff[n] = this.coeff[n];
            }
            for (n = 0; n <= polynomial.deg; ++n) {
                polynomial2.coeff[n] = this.coeff[n] - polynomial.coeff[n];
            }
        } else {
            int n;
            polynomial2 = new Polynomial(polynomial.deg);
            for (n = this.deg + 1; n <= polynomial.deg; ++n) {
                polynomial2.coeff[n] = -polynomial.coeff[n];
            }
            for (n = 0; n <= this.deg; ++n) {
                polynomial2.coeff[n] = this.coeff[n] - polynomial.coeff[n];
            }
        }
        return polynomial2;
    }

    public Polynomial minus(double d) {
        Polynomial polynomial = new Polynomial(d);
        return this.minus(polynomial);
    }

    public Polynomial minus(int n) {
        Polynomial polynomial = new Polynomial((double)n);
        return this.minus(polynomial);
    }

    public static Polynomial minus(Polynomial polynomial, Polynomial polynomial2) {
        Polynomial polynomial3 = null;
        if (polynomial2.deg <= polynomial.deg) {
            int n;
            polynomial3 = new Polynomial(polynomial.deg);
            for (n = polynomial2.deg + 1; n <= polynomial.deg; ++n) {
                polynomial3.coeff[n] = polynomial.coeff[n];
            }
            for (n = 0; n <= polynomial2.deg; ++n) {
                polynomial3.coeff[n] = polynomial.coeff[n] - polynomial2.coeff[n];
            }
        } else {
            int n;
            polynomial3 = new Polynomial(polynomial2.deg);
            for (n = polynomial.deg + 1; n <= polynomial2.deg; ++n) {
                polynomial3.coeff[n] = -polynomial2.coeff[n];
            }
            for (n = 0; n <= polynomial.deg; ++n) {
                polynomial3.coeff[n] = polynomial.coeff[n] - polynomial2.coeff[n];
            }
        }
        return polynomial3;
    }

    public static Polynomial minus(Polynomial polynomial, double d) {
        Polynomial polynomial2 = new Polynomial(d);
        return Polynomial.minus(polynomial, polynomial2);
    }

    public static Polynomial minus(Polynomial polynomial, int n) {
        Polynomial polynomial2 = new Polynomial((double)n);
        return Polynomial.minus(polynomial, polynomial2);
    }

    public Polynomial times(Polynomial polynomial) {
        int n = this.deg + polynomial.deg;
        Polynomial polynomial2 = new Polynomial(n);
        for (int j = 0; j <= this.deg; ++j) {
            for (int k = 0; k <= polynomial.deg; ++k) {
                int n2 = j + k;
                polynomial2.coeff[n2] = polynomial2.coeff[n2] + this.coeff[j] * polynomial.coeff[k];
            }
        }
        return polynomial2;
    }

    public static Polynomial times(Polynomial polynomial, Polynomial polynomial2) {
        int n = polynomial.deg + polynomial2.deg;
        Polynomial polynomial3 = new Polynomial(n);
        for (int j = 0; j <= polynomial.deg; ++j) {
            for (int k = 0; k <= polynomial2.deg; ++k) {
                int n2 = j + k;
                polynomial3.coeff[n2] = polynomial3.coeff[n2] + polynomial.coeff[j] * polynomial2.coeff[k];
            }
        }
        return polynomial3;
    }

    public Polynomial times(double d) {
        Polynomial polynomial = new Polynomial(this.deg);
        for (int j = 0; j <= this.deg; ++j) {
            polynomial.coeff[j] = this.coeff[j] * d;
        }
        return polynomial;
    }

    public static Polynomial times(Polynomial polynomial, double d) {
        Polynomial polynomial2 = new Polynomial(polynomial.deg);
        for (int j = 0; j <= polynomial.deg; ++j) {
            polynomial2.coeff[j] = polynomial.coeff[j] * d;
        }
        return polynomial2;
    }

    public Polynomial times(int n) {
        Polynomial polynomial = new Polynomial(this.deg);
        for (int j = 0; j <= this.deg; ++j) {
            polynomial.coeff[j] = this.coeff[j] * (double)n;
        }
        return polynomial;
    }

    public static Polynomial times(Polynomial polynomial, int n) {
        Polynomial polynomial2 = new Polynomial(polynomial.deg);
        for (int j = 0; j <= polynomial.deg; ++j) {
            polynomial2.coeff[j] = polynomial.coeff[j] * (double)n;
        }
        return polynomial2;
    }

    public Polynomial nthDerivative(int n) {
        Polynomial polynomial;
        if (n > this.deg) {
            polynomial = new Polynomial(0.0);
        } else {
            polynomial = new Polynomial(this.deg - n);
            double[] dArray = new double[this.deg - n + 1];
            int n2 = this.deg - n;
            for (int j = this.deg; j > n - 1; --j) {
                dArray[n2] = this.coeff[j];
                for (int k = 0; k < n; ++k) {
                    dArray[n2] = dArray[n2] * (double)(j - k);
                }
                --n2;
            }
            polynomial = new Polynomial(dArray);
        }
        return polynomial;
    }

    public double evaluate(double d) {
        double d2 = 0.0;
        if (this.deg == 0) {
            d2 = this.coeff[0];
        } else {
            d2 = this.coeff[this.deg];
            for (int j = this.deg - 1; j >= 0; --j) {
                d2 = d2 * d + this.coeff[j];
            }
        }
        return d2;
    }

    public double nthDerivEvaluate(int n, double d) {
        double d2 = 0.0;
        double[] dArray = new double[this.deg + 1];
        if (n == 0) {
            d2 = this.evaluate(d);
            System.out.println("n = 0 in Polynomial.nthDerivative");
            System.out.println("polynomial itself evaluated and returned");
        } else {
            Polynomial polynomial = this.nthDerivative(n);
            d2 = polynomial.evaluate(d);
        }
        return d2;
    }

    public Complex[] roots() {
        ComplexPoly complexPoly = new ComplexPoly(this);
        return complexPoly.roots();
    }

    public Complex[] rootsNoMessages() {
        ComplexPoly complexPoly = new ComplexPoly(this);
        return complexPoly.rootsNoMessages();
    }

    public Complex[] roots(boolean bl) {
        ComplexPoly complexPoly = new ComplexPoly(this);
        return complexPoly.roots(bl);
    }

    public Complex[] roots(double d) {
        ComplexPoly complexPoly = new ComplexPoly(this);
        return complexPoly.roots(new Complex(d, 0.0));
    }

    public Complex[] roots(Complex complex) {
        ComplexPoly complexPoly = new ComplexPoly(this);
        return complexPoly.roots(complex);
    }

    public Complex[] roots(boolean bl, double d) {
        ComplexPoly complexPoly = new ComplexPoly(this);
        return complexPoly.roots(new Complex(d, 0.0));
    }

    public static Complex[] quadratic(double d, double d2, double d3) {
        return ComplexPoly.quadratic(new Complex(d, 0.0), new Complex(d2, 0.0), new Complex(d3, 0.0));
    }

    public static Complex[] cubic(double d, double d2, double d3, double d4) {
        return ComplexPoly.cubic(new Complex(d, 0.0), new Complex(d2, 0.0), new Complex(d3, 0.0), new Complex(d4, 0.0));
    }

    public static Complex laguerre(double d, double[] dArray, int n) {
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        return ComplexPoly.laguerre(new Complex(d, 0.0), arrayMaths.array_as_Complex(), n);
    }

    public static Complex laguerre(Complex complex, double[] dArray, int n) {
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        return ComplexPoly.laguerre(complex, arrayMaths.array_as_Complex(), n);
    }

    public Complex[] laguerreAll() {
        ComplexPoly complexPoly = new ComplexPoly(this);
        return complexPoly.laguerreAll();
    }

    public Complex[] laguerreAll(double d) {
        ComplexPoly complexPoly = new ComplexPoly(this);
        return complexPoly.laguerreAll(new Complex(d, 0.0));
    }

    public Complex[] laguerreAll(Complex complex) {
        ComplexPoly complexPoly = new ComplexPoly(this);
        return complexPoly.laguerreAll(complex);
    }

    public Complex[] laguerreAll(boolean bl) {
        ComplexPoly complexPoly = new ComplexPoly(this);
        return complexPoly.laguerreAll(bl);
    }

    public Complex[] laguerreAll(boolean bl, double d) {
        ComplexPoly complexPoly = new ComplexPoly(this);
        return complexPoly.laguerreAll(bl, new Complex(d, 0.0));
    }

    public Complex[] laguerreAll(boolean bl, Complex complex) {
        ComplexPoly complexPoly = new ComplexPoly(this);
        return complexPoly.laguerreAll(bl, complex);
    }
}

