/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.analysis.Stat;
import flanagan.math.BetaFunct;
import flanagan.math.ChiSquareFunct;
import flanagan.math.Ffunct;
import flanagan.math.Fmath;
import flanagan.math.GammaFunct;
import flanagan.math.LogNormalThreeParFunct;
import flanagan.math.LogNormalTwoParFunct;
import flanagan.math.StudentTfunct;
import flanagan.roots.RealRoot;
import java.io.Serializable;
import java.util.Random;

public class PsRandom
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long seed;
    private long initialSeed;
    private int methodOptionDecimal = 1;
    private int methodOptionInteger = 1;
    private Random rr = null;
    private int methodOptionBinary = 1;
    private long ia = 16807L;
    private long im = Integer.MAX_VALUE;
    private double am = 1.0 / (double)this.im;
    private long iq = 127773L;
    private long ir = 2836L;
    private int ntab = 32;
    private long ndiv = 1L + (this.im - 1L) / (long)this.ntab;
    private double eps = 1.2E-7;
    private double rnmx = 1.0 - this.eps;
    private long iy = 0L;
    private long[] iv = new long[this.ntab];
    private int iset = 0;
    private double gset = 0.0;
    private long powTwo1 = 1L;
    private long powTwo2 = 2L;
    private long powTwo5 = 16L;
    private long powTwo18 = 131072L;
    private long mask = this.powTwo1 + this.powTwo2 + this.powTwo5;

    public PsRandom() {
        this.initialSeed = this.seed = System.currentTimeMillis();
        this.rr = new Random(this.seed);
    }

    public PsRandom(long l) {
        this.seed = l;
        this.initialSeed = l;
        this.rr = new Random(this.seed);
    }

    public void setSeed(long l) {
        this.seed = l;
        if (this.methodOptionDecimal == 1) {
            this.rr = new Random(this.seed);
        }
    }

    public long getInitialSeed() {
        return this.initialSeed;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setMethodDecimal(int n) {
        if (n < 1 || n > 2) {
            throw new IllegalArgumentException("Argument to PsRandom.setMethodDecimal must 1 or 2\nValue transferred was" + n);
        }
        this.methodOptionDecimal = n;
        if (n == 1) {
            this.rr = new Random(this.seed);
        }
    }

    public int getMethodDecimal() {
        return this.methodOptionDecimal;
    }

    public void setMethodInteger(int n) {
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("Argument to PsRandom.setMethodInteger must 1, 2 or 3\nValue transferred was" + n);
        }
        this.methodOptionInteger = n;
    }

    public int getMethodInteger() {
        return this.methodOptionInteger;
    }

    public void setMethodBinary(int n) {
        if (n < 1 || n > 2) {
            throw new IllegalArgumentException("Argument to PsRandom.setMethodBinary must 1 or 2\nValue transferred was" + n);
        }
        this.methodOptionBinary = n;
        if (n == 1) {
            this.rr = new Random(this.seed);
        }
    }

    public int getMethodBinary() {
        return this.methodOptionBinary;
    }

    public double nextDouble() {
        if (this.methodOptionDecimal == 1) {
            return this.rr.nextDouble();
        }
        return this.parkMiller();
    }

    public double nextDouble(double d) {
        return d * this.nextDouble();
    }

    public double nextDouble(double d, double d2) {
        return (d2 - d) * this.nextDouble() + d;
    }

    public double[] doubleArray(int n) {
        double[] dArray = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray[j] = this.nextDouble();
        }
        return dArray;
    }

    public double[] doubleArray(int n, double d) {
        double[] dArray = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray[j] = d * this.nextDouble();
        }
        return dArray;
    }

    public double[] doubleArray(int n, double d, double d2) {
        double[] dArray = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray[j] = (d2 - d) * this.nextDouble() + d;
        }
        return dArray;
    }

    public double parkMiller() {
        double d;
        int n = 0;
        long l = 0L;
        double d2 = 0.0;
        this.iy = 0L;
        if (this.seed <= 0L || this.iy != 0L) {
            this.seed = -this.seed < 1L ? 1L : -this.seed;
            for (int j = this.ntab + 7; j >= 0; --j) {
                l = this.seed / this.iq;
                this.seed = this.ia * (this.seed - l * this.iq) - this.ir * l;
                if (this.seed < 0L) {
                    this.seed += this.im;
                }
                if (j >= this.ntab) continue;
                this.iv[j] = this.seed;
            }
            this.iy = this.iv[0];
        }
        l = this.seed / this.iq;
        this.seed = this.ia * (this.seed - l * this.iq) - this.ir * l;
        if (this.seed < 0L) {
            this.seed += this.im;
        }
        n = (int)(this.iy / this.ndiv);
        this.iy = this.iv[n];
        this.iv[n] = this.seed;
        d2 = this.am * (double)this.iy;
        if (d > this.rnmx) {
            return this.rnmx;
        }
        return d2;
    }

    public int nextBit() {
        if (this.methodOptionBinary == 1) {
            return this.nextBitM1();
        }
        return this.nextBitM2();
    }

    public int[] bitArray(int n) {
        int[] nArray = new int[n];
        for (int j = 0; j < n; ++j) {
            nArray[j] = this.nextBit();
        }
        return nArray;
    }

    public int nextBitM1() {
        long l = (this.seed & this.powTwo18) >> 17 ^ (this.seed & this.powTwo5) >> 4 ^ (this.seed & this.powTwo2) >> 1 ^ this.seed & this.powTwo1;
        this.seed = this.seed << 1 | l;
        return (int)l;
    }

    public int nextBitM2() {
        int n = 0;
        if ((this.seed & this.powTwo18) <= 0L) {
            this.seed = (this.seed ^ this.mask) << 1 | this.powTwo1;
            n = 1;
        } else {
            this.seed <<= 1;
            n = 0;
        }
        return n;
    }

    public double nextGaussian(double d, double d2) {
        double d3 = 0.0;
        d3 = this.methodOptionDecimal == 1 ? this.rr.nextGaussian() : this.boxMullerParkMiller();
        d3 = d3 * d2 + d;
        return d3;
    }

    public double nextGaussian() {
        double d = 0.0;
        d = this.methodOptionDecimal == 1 ? this.rr.nextGaussian() : this.boxMullerParkMiller();
        return d;
    }

    public double nextNormal(double d, double d2) {
        return this.nextGaussian(d, d2);
    }

    public double nextNormal() {
        return this.nextGaussian();
    }

    public double[] gaussianArray(double d, double d2, int n) {
        int n2;
        double[] dArray = new double[n];
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = this.nextGaussian();
        }
        dArray = Stat.standardize(dArray);
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = dArray[n2] * d2 + d;
        }
        return dArray;
    }

    public double[] normalArray(double d, double d2, int n) {
        return this.gaussianArray(d, d2, n);
    }

    public double[][] correlatedGaussianArrays(double d, double d2, double d3, double d4, double d5, int n) {
        if (Math.abs(d5) > 1.0) {
            throw new IllegalArgumentException("The correlation coefficient, " + d5 + ", must lie between -1 and 1");
        }
        double[][] dArray = new double[2][n];
        double[] dArray2 = this.gaussianArray(0.0, 1.0, n);
        double[] dArray3 = this.gaussianArray(0.0, 1.0, n);
        double d6 = 0.0;
        double d7 = Math.sqrt(1.0 - d5 * d5);
        for (int j = 0; j < n; ++j) {
            dArray[0][j] = dArray2[j] * d3 + d;
            dArray[1][j] = (d5 * dArray2[j] + d7 * dArray3[j]) * d4 + d2;
        }
        return dArray;
    }

    public double[][] correlatedNormalArrays(double d, double d2, double d3, double d4, double d5, int n) {
        return this.correlatedGaussianArrays(d, d2, d3, d4, d5, n);
    }

    double boxMullerParkMiller() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.iset == 0) {
            while ((d2 = (d3 = 2.0 * this.parkMiller() - 1.0) * d3 + (d4 = 2.0 * this.parkMiller() - 1.0) * d4) >= 1.0 || d2 == 0.0) {
            }
            d = Math.sqrt(-2.0 * Math.log(d2) / d2);
            this.gset = d3 * d;
            this.iset = 1;
            return d4 * d;
        }
        this.iset = 0;
        return this.gset;
    }

    public double nextLogNormal(double d, double d2) {
        double d3 = 0.0;
        LogNormalTwoParFunct logNormalTwoParFunct = new LogNormalTwoParFunct();
        logNormalTwoParFunct.mu = d;
        logNormalTwoParFunct.sigma = d2;
        double d4 = 1.0E-10;
        double d5 = 0.0;
        double d6 = d2 * d2;
        double d7 = 5.0 * Math.sqrt((Math.exp(d6) - 1.0) * Math.exp(2.0 * d + d6));
        RealRoot realRoot = new RealRoot();
        realRoot.noLowerBoundExtension();
        realRoot.setTolerance(d4);
        realRoot.resetNaNexceptionToTrue();
        realRoot.supressLimitReachedMessage();
        realRoot.supressNaNmessage();
        boolean bl = true;
        int n = 0;
        int n2 = 10;
        while (bl) {
            logNormalTwoParFunct.cfd = this.nextDouble();
            d3 = realRoot.falsePosition(logNormalTwoParFunct, d5, d7);
            if (!Double.isNaN(d3)) {
                bl = false;
                continue;
            }
            if (n > n2) {
                System.out.println("class: PsRandom,  method: nextLogNormal");
                System.out.println(n2 + " successive attempts at calculating a random log-normal deviate failed for values of mu = " + d + ", sigma = " + d2);
                System.out.println("NaN returned");
                d3 = Double.NaN;
                bl = false;
                continue;
            }
            ++n;
        }
        return d3;
    }

    public double nextLogNormalTwoPar(double d, double d2) {
        return this.nextLogNormal(d, d2);
    }

    public double[] logNormalArray(double d, double d2, int n) {
        double[] dArray = new double[n];
        LogNormalTwoParFunct logNormalTwoParFunct = new LogNormalTwoParFunct();
        logNormalTwoParFunct.mu = d;
        logNormalTwoParFunct.sigma = d2;
        double d3 = 1.0E-10;
        double d4 = 0.0;
        double d5 = d2 * d2;
        double d6 = 5.0 * Math.sqrt((Math.exp(d5) - 1.0) * Math.exp(2.0 * d + d5));
        for (int j = 0; j < n; ++j) {
            RealRoot realRoot = new RealRoot();
            realRoot.noLowerBoundExtension();
            realRoot.setTolerance(d3);
            realRoot.resetNaNexceptionToTrue();
            realRoot.supressLimitReachedMessage();
            realRoot.supressNaNmessage();
            boolean bl = true;
            int n2 = 0;
            int n3 = 10;
            while (bl) {
                logNormalTwoParFunct.cfd = this.nextDouble();
                double d7 = realRoot.bisect(logNormalTwoParFunct, d4, d6);
                if (!Double.isNaN(d7)) {
                    bl = false;
                    dArray[j] = d7;
                    continue;
                }
                if (n2 > n3) {
                    System.out.println("class: PsRandom,  method: logNormalArray");
                    System.out.println(n3 + " successive attempts at calculating a random gamma deviate failed for values of mu = " + d + ", sigma = " + d2);
                    System.out.println("NaN returned");
                    dArray[j] = Double.NaN;
                    bl = false;
                    continue;
                }
                ++n2;
            }
        }
        return dArray;
    }

    public double[] logNormalTwoParArray(double d, double d2, int n) {
        return this.logNormalArray(d, d2, n);
    }

    public double nextLogNormalThreePar(double d, double d2, double d3) {
        double d4 = Double.NaN;
        LogNormalThreeParFunct logNormalThreeParFunct = new LogNormalThreeParFunct();
        logNormalThreeParFunct.alpha = d;
        logNormalThreeParFunct.beta = d2;
        logNormalThreeParFunct.gamma = d3;
        double d5 = 1.0E-10;
        double d6 = d;
        double d7 = d2 * d2;
        double d8 = 5.0 * Math.sqrt((Math.exp(d7) - 1.0) * Math.exp(2.0 * Math.log(d3) + d7));
        RealRoot realRoot = new RealRoot();
        realRoot.noLowerBoundExtension();
        realRoot.setTolerance(d5);
        realRoot.resetNaNexceptionToTrue();
        realRoot.supressLimitReachedMessage();
        realRoot.supressNaNmessage();
        boolean bl = true;
        int n = 0;
        int n2 = 10;
        while (bl) {
            logNormalThreeParFunct.cfd = this.nextDouble();
            d4 = realRoot.falsePosition(logNormalThreeParFunct, d6, d8);
            if (!Double.isNaN(d4)) {
                bl = false;
                continue;
            }
            if (n > n2) {
                System.out.println("class: PsRandom,  method: nextLogNormalThreePar");
                System.out.println(n2 + " successive attempts at calculating a random log-normal deviate failed for values of alpha = " + d + ", beta = " + d2 + ", gamma = " + d3);
                System.out.println("NaN returned");
                d4 = Double.NaN;
                bl = false;
                continue;
            }
            ++n;
        }
        return d4;
    }

    public double[] logNormalThreeParArray(double d, double d2, double d3, int n) {
        double[] dArray = new double[n];
        LogNormalThreeParFunct logNormalThreeParFunct = new LogNormalThreeParFunct();
        logNormalThreeParFunct.alpha = d;
        logNormalThreeParFunct.beta = d2;
        logNormalThreeParFunct.gamma = d3;
        double d4 = 1.0E-10;
        double d5 = d;
        double d6 = d2 * d2;
        double d7 = 5.0 * Math.sqrt((Math.exp(d6) - 1.0) * Math.exp(2.0 * Math.log(d3) + d6));
        for (int j = 0; j < n; ++j) {
            RealRoot realRoot = new RealRoot();
            realRoot.noLowerBoundExtension();
            realRoot.setTolerance(d4);
            realRoot.resetNaNexceptionToTrue();
            realRoot.supressLimitReachedMessage();
            realRoot.supressNaNmessage();
            boolean bl = true;
            int n2 = 0;
            int n3 = 10;
            while (bl) {
                logNormalThreeParFunct.cfd = this.nextDouble();
                double d8 = realRoot.falsePosition(logNormalThreeParFunct, d5, d7);
                if (!Double.isNaN(d8)) {
                    bl = false;
                    dArray[j] = d8;
                    continue;
                }
                if (n2 > n3) {
                    System.out.println("class: PsRandom,  method: logNormalThreeParArray");
                    System.out.println(n3 + " successive attempts at calculating a log-normal gamma deviate failed for values of alpha = " + d + ", beta = " + d2 + ", gamma = " + d3);
                    System.out.println("NaN returned");
                    dArray[j] = Double.NaN;
                    bl = false;
                    continue;
                }
                ++n2;
            }
        }
        return dArray;
    }

    public double nextLorentzian(double d, double d2) {
        double d3 = Math.tan((this.nextDouble() - 0.5) * Math.PI);
        d3 = d3 * d2 / 2.0 + d;
        return d3;
    }

    public double[] lorentzianArray(double d, double d2, int n) {
        double[] dArray = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray[j] = Math.tan((this.nextDouble() - 0.5) * Math.PI);
            dArray[j] = dArray[j] * d2 / 2.0 + d;
        }
        return dArray;
    }

    public double nextPoissonian(double d) {
        double d2 = 0.0;
        double d3 = -1.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        if (d < 12.0) {
            if (d != d3) {
                d3 = d;
                d4 = Math.exp(-d);
            }
            d5 = -1.0;
            d6 = 1.0;
            do {
                d5 += 1.0;
            } while ((d6 *= this.nextDouble()) > d4);
            d2 = d5;
        } else {
            if (d != d3) {
                d3 = d;
                d7 = Math.sqrt(2.0 * d);
                d8 = Math.log(d);
                d4 = d * d8 - Stat.logGamma(d + 1.0);
            }
            while (true) {
                if ((d5 = d7 * (d9 = Math.tan(Math.PI * this.nextDouble())) + d) < 0.0) {
                    continue;
                }
                d5 = Math.floor(d5);
                d6 = 0.9 * (1.0 + d9 * d9) * Math.exp(d5 * d8 - Stat.logGamma(d5 + 1.0) - d4);
                if (!(this.nextDouble() > d6)) break;
            }
            d2 = d5;
        }
        return d2;
    }

    public double[] poissonianArray(double d, int n) {
        double[] dArray = new double[n];
        double d2 = -1.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        if (d < 12.0) {
            for (int j = 0; j < n; ++j) {
                if (d != d2) {
                    d2 = d;
                    d3 = Math.exp(-d);
                }
                d4 = -1.0;
                d5 = 1.0;
                do {
                    d4 += 1.0;
                } while ((d5 *= this.nextDouble()) > d3);
                dArray[j] = d4;
            }
        } else {
            for (int j = 0; j < n; ++j) {
                if (d != d2) {
                    d2 = d;
                    d6 = Math.sqrt(2.0 * d);
                    d7 = Math.log(d);
                    d3 = d * d7 - Stat.logGamma(d + 1.0);
                }
                while (true) {
                    if ((d4 = d6 * (d8 = Math.tan(Math.PI * this.nextDouble())) + d) < 0.0) {
                        continue;
                    }
                    d4 = Math.floor(d4);
                    d5 = 0.9 * (1.0 + d8 * d8) * Math.exp(d4 * d7 - Stat.logGamma(d4 + 1.0) - d3);
                    if (!(this.nextDouble() > d5)) break;
                }
                dArray[j] = d4;
            }
        }
        return dArray;
    }

    public double nextBinomial(double d, int n) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("The probablity provided, " + d + ", must lie between 0 and 1)");
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = -1.0;
        double d8 = -1.0;
        double d9 = -1.0;
        int n2 = -1;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        d5 = d <= 0.5 ? d : 1.0 - d;
        d3 = (double)n * d5;
        if (n < 25) {
            d2 = 0.0;
            for (int j = 1; j <= n; ++j) {
                if (!(this.nextDouble() < d5)) continue;
                d2 += 1.0;
            }
        } else if (d3 < 1.0) {
            int n3;
            double d14 = Math.exp(-d3);
            d4 = 1.0;
            for (n3 = 0; n3 <= n && !((d4 *= this.nextDouble()) < d14); ++n3) {
            }
            d2 = n3 <= n ? n3 : n;
        } else {
            if (n != n2) {
                d10 = n;
                d11 = Stat.logGamma(d10 + 1.0);
                n2 = n;
            }
            if (d5 != d7) {
                d8 = 1.0 - d5;
                d6 = Math.log(d5);
                d9 = Math.log(d8);
                d7 = d5;
            }
            double d15 = Math.sqrt(2.0 * d3 * d8);
            while (true) {
                double d16;
                if ((d13 = d15 * (d12 = Math.tan(d16 = Math.PI * this.nextDouble())) + d3) < 0.0 || d13 >= d10 + 1.0) {
                    continue;
                }
                d13 = Math.floor(d13);
                d4 = 1.2 * d15 * (1.0 + d12 * d12) * Math.exp(d11 - Stat.logGamma(d13 + 1.0) - Stat.logGamma(d10 - d13 + 1.0) + d13 * d6 + (d10 - d13) * d9);
                if (!(this.nextDouble() > d4)) break;
            }
            d2 = d13;
        }
        if (d5 != d) {
            d2 = (double)n - d2;
        }
        return d2;
    }

    public double[] binomialArray(double d, int n, int n2) {
        if (n < n2) {
            throw new IllegalArgumentException("Number of deviates requested, " + n2 + ", must be less than the number of trials, " + n);
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("The probablity provided, " + d + ", must lie between 0 and 1)");
        }
        double[] dArray = new double[n2];
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = -1.0;
        double d8 = -1.0;
        double d9 = -1.0;
        int n3 = -1;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = d;
        for (int j = 0; j < n2; ++j) {
            double d15;
            int n4;
            d = d14;
            d5 = d <= 0.5 ? d : 1.0 - d;
            d3 = (double)n * d5;
            if (n < 25) {
                d2 = 0.0;
                for (n4 = 1; n4 <= n; ++n4) {
                    if (!(this.nextDouble() < d5)) continue;
                    d2 += 1.0;
                }
            } else if (d3 < 1.0) {
                d15 = Math.exp(-d3);
                d4 = 1.0;
                for (n4 = 0; n4 <= n && !((d4 *= this.nextDouble()) < d15); ++n4) {
                }
                d2 = n4 <= n ? n4 : n;
            } else {
                if (n != n3) {
                    d10 = n;
                    d11 = Stat.logGamma(d10 + 1.0);
                    n3 = n;
                }
                if (d5 != d7) {
                    d8 = 1.0 - d5;
                    d6 = Math.log(d5);
                    d9 = Math.log(d8);
                    d7 = d5;
                }
                d15 = Math.sqrt(2.0 * d3 * d8);
                while (true) {
                    double d16;
                    if ((d13 = d15 * (d12 = Math.tan(d16 = Math.PI * this.nextDouble())) + d3) < 0.0 || d13 >= d10 + 1.0) {
                        continue;
                    }
                    d13 = Math.floor(d13);
                    d4 = 1.2 * d15 * (1.0 + d12 * d12) * Math.exp(d11 - Stat.logGamma(d13 + 1.0) - Stat.logGamma(d10 - d13 + 1.0) + d13 * d6 + (d10 - d13) * d9);
                    if (!(this.nextDouble() > d4)) break;
                }
                d2 = d13;
            }
            if (d5 != d) {
                d2 = (double)n - d2;
            }
            dArray[j] = d2;
        }
        return dArray;
    }

    public double nextPareto(double d, double d2) {
        return Math.pow(1.0 - this.nextDouble(), -1.0 / d) * d2;
    }

    public double[] paretoArray(double d, double d2, int n) {
        double[] dArray = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray[j] = Math.pow(1.0 - this.nextDouble(), -1.0 / d) * d2;
        }
        return dArray;
    }

    public double nextExponential(double d, double d2) {
        return d - Math.log(1.0 - this.nextDouble()) * d2;
    }

    public double[] exponentialArray(double d, double d2, int n) {
        double[] dArray = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray[j] = d - Math.log(1.0 - this.nextDouble()) * d2;
        }
        return dArray;
    }

    public double nextRayleigh(double d) {
        return Math.sqrt(-2.0 * Math.log(1.0 - this.nextDouble())) * d;
    }

    public double[] rayleighArray(double d, int n) {
        double[] dArray = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray[j] = Math.sqrt(-2.0 * Math.log(1.0 - this.nextDouble())) * d;
        }
        return dArray;
    }

    public double nextMinimalGumbel(double d, double d2) {
        return Math.log(Math.log(1.0 / (1.0 - this.nextDouble()))) * d2 + d;
    }

    public double[] minimalGumbelArray(double d, double d2, int n) {
        double[] dArray = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray[j] = Math.log(Math.log(1.0 / (1.0 - this.nextDouble()))) * d2 + d;
        }
        return dArray;
    }

    public double nextMaximalGumbel(double d, double d2) {
        return d - Math.log(Math.log(1.0 / (1.0 - this.nextDouble()))) * d2;
    }

    public double[] maximalGumbelArray(double d, double d2, int n) {
        double[] dArray = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray[j] = d - Math.log(Math.log(1.0 / (1.0 - this.nextDouble()))) * d2;
        }
        return dArray;
    }

    public double nextFrechet(double d, double d2, double d3) {
        return Math.pow(1.0 / Math.log(1.0 / this.nextDouble()), 1.0 / d3) * d2 + d;
    }

    public double[] frechetArray(double d, double d2, double d3, int n) {
        double[] dArray = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray[j] = Math.pow(1.0 / Math.log(1.0 / this.nextDouble()), 1.0 / d3) * d2 + d;
        }
        return dArray;
    }

    public double nextWeibull(double d, double d2, double d3) {
        return Math.pow(-Math.log(1.0 - this.nextDouble()), 1.0 / d3) * d2 + d;
    }

    public double[] weibullArray(double d, double d2, double d3, int n) {
        double[] dArray = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray[j] = Math.pow(-Math.log(1.0 - this.nextDouble()), 1.0 / d3) * d2 + d;
        }
        return dArray;
    }

    public double nextLogistic(double d, double d2) {
        return 2.0 * d2 * Fmath.atanh(2.0 * this.nextDouble() - 1.0) + d;
    }

    public double[] logisticArray(double d, double d2, int n) {
        double[] dArray = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray[j] = 2.0 * d2 * Fmath.atanh(2.0 * this.nextDouble() - 1.0) + d;
        }
        return dArray;
    }

    public double nextStudentT(int n) {
        double d = 0.0;
        StudentTfunct studentTfunct = new StudentTfunct();
        studentTfunct.nu = n;
        double d2 = 0.0;
        double d3 = 100.0;
        if (n > 2) {
            d3 = n / (n - 2);
        }
        double d4 = d2 - 5.0 * d3;
        double d5 = d2 + 5.0 * d3;
        double d6 = 1.0E-10;
        RealRoot realRoot = new RealRoot();
        realRoot.setTolerance(d6);
        realRoot.resetNaNexceptionToTrue();
        realRoot.supressLimitReachedMessage();
        realRoot.supressNaNmessage();
        boolean bl = true;
        int n2 = 0;
        int n3 = 10;
        while (bl) {
            studentTfunct.cfd = this.nextDouble();
            d = realRoot.falsePosition(studentTfunct, d4, d5);
            if (!Double.isNaN(d)) {
                bl = false;
                continue;
            }
            if (n2 > n3) {
                System.out.println("class: PsRandom,  method: studentT");
                System.out.println(n3 + " successive attempts at calculating a random Student's T deviate failed for values of nu = " + n);
                System.out.println("NaN returned");
                d = Double.NaN;
                bl = false;
                continue;
            }
            ++n2;
        }
        return d;
    }

    public double[] studentTarray(int n, int n2) {
        double[] dArray = new double[n2];
        StudentTfunct studentTfunct = new StudentTfunct();
        studentTfunct.nu = n;
        double d = 0.0;
        double d2 = 100.0;
        if (n > 2) {
            d2 = n / (n - 2);
        }
        double d3 = 1.0E-10;
        double d4 = d - 5.0 * d2;
        double d5 = d + 5.0 * d2;
        for (int j = 0; j < n2; ++j) {
            RealRoot realRoot = new RealRoot();
            realRoot.setTolerance(d3);
            realRoot.resetNaNexceptionToTrue();
            realRoot.supressLimitReachedMessage();
            realRoot.supressNaNmessage();
            boolean bl = true;
            int n3 = 0;
            int n4 = 10;
            while (bl) {
                studentTfunct.cfd = this.nextDouble();
                double d6 = realRoot.falsePosition(studentTfunct, d4, d5);
                if (!Double.isNaN(d6)) {
                    bl = false;
                    dArray[j] = d6;
                    continue;
                }
                if (n3 > n4) {
                    System.out.println("class: PsRandom,  method: studentTarray");
                    System.out.println(n4 + " successive attempts at calculating a random gamma deviate failed for values of nu = " + n);
                    System.out.println("NaN returned");
                    dArray[j] = Double.NaN;
                    bl = false;
                    continue;
                }
                ++n3;
            }
        }
        return dArray;
    }

    public double nextBeta(double d, double d2) {
        return this.nextBeta(0.0, 1.0, d, d2);
    }

    public double nextBeta(double d, double d2, double d3, double d4) {
        double d5 = 0.0;
        BetaFunct betaFunct = new BetaFunct();
        betaFunct.alpha = d3;
        betaFunct.beta = d4;
        betaFunct.min = d;
        betaFunct.max = d2;
        double d6 = 1.0E-10;
        double d7 = d;
        double d8 = d2;
        RealRoot realRoot = new RealRoot();
        realRoot.noLowerBoundExtension();
        realRoot.noUpperBoundExtension();
        realRoot.setTolerance(d6);
        realRoot.resetNaNexceptionToTrue();
        realRoot.supressLimitReachedMessage();
        realRoot.supressNaNmessage();
        boolean bl = true;
        int n = 0;
        int n2 = 10;
        while (bl) {
            betaFunct.cfd = this.nextDouble();
            d5 = realRoot.falsePosition(betaFunct, d7, d8);
            if (!Double.isNaN(d5)) {
                bl = false;
                continue;
            }
            if (n > n2) {
                System.out.println("class: PsRandom,  method: nextBeta");
                System.out.println(n2 + " successive attempts at calculating a random beta deviate failed for values of min = " + d + ", max = " + d2 + ", alpha = " + d3 + ", beta = " + d4);
                System.out.println("NaN returned");
                d5 = Double.NaN;
                bl = false;
                continue;
            }
            ++n;
        }
        return d5;
    }

    public double[] betaArray(double d, double d2, int n) {
        return this.betaArray(0.0, 1.0, d, d2, n);
    }

    public double[] betaArray(double d, double d2, double d3, double d4, int n) {
        double[] dArray = new double[n];
        BetaFunct betaFunct = new BetaFunct();
        betaFunct.alpha = d3;
        betaFunct.beta = d4;
        betaFunct.min = d;
        betaFunct.max = d2;
        double d5 = 1.0E-10;
        double d6 = d;
        double d7 = d2;
        for (int j = 0; j < n; ++j) {
            RealRoot realRoot = new RealRoot();
            realRoot.noLowerBoundExtension();
            realRoot.noUpperBoundExtension();
            realRoot.setTolerance(d5);
            realRoot.resetNaNexceptionToTrue();
            realRoot.supressLimitReachedMessage();
            realRoot.supressNaNmessage();
            boolean bl = true;
            int n2 = 0;
            int n3 = 10;
            while (bl) {
                betaFunct.cfd = this.nextDouble();
                double d8 = realRoot.bisect(betaFunct, d6, d7);
                if (!Double.isNaN(d8)) {
                    bl = false;
                    dArray[j] = d8;
                    continue;
                }
                if (n2 > n3) {
                    System.out.println("class: PsRandom,  method: betaArray");
                    System.out.println(n3 + " successive attempts at calculating a random beta deviate failed for values of min = " + d + ", max = " + d2 + ", alpha = " + d3 + ", beta = " + d4);
                    System.out.println("NaN returned");
                    dArray[j] = Double.NaN;
                    bl = false;
                    continue;
                }
                ++n2;
            }
        }
        return dArray;
    }

    public double nextGamma(double d, double d2, double d3) {
        double d4 = 0.0;
        GammaFunct gammaFunct = new GammaFunct();
        gammaFunct.mu = d;
        gammaFunct.beta = d2;
        gammaFunct.gamma = d3;
        double d5 = Math.sqrt(d3) * d2;
        double d6 = 1.0E-10;
        double d7 = d + 5.0 * d5;
        double d8 = d;
        if (d7 <= d8) {
            d7 += d5;
        }
        RealRoot realRoot = new RealRoot();
        realRoot.noLowerBoundExtension();
        realRoot.setTolerance(d6);
        realRoot.resetNaNexceptionToTrue();
        realRoot.supressLimitReachedMessage();
        realRoot.supressNaNmessage();
        boolean bl = true;
        int n = 0;
        int n2 = 10;
        while (bl) {
            gammaFunct.cfd = this.nextDouble();
            d4 = realRoot.bisect(gammaFunct, d8, d7);
            if (!Double.isNaN(d4)) {
                bl = false;
                continue;
            }
            if (n > n2) {
                System.out.println("class: PsRandom,  method: nextGamma");
                System.out.println(n2 + " successive attempts at calculating a random gamma deviate failed for values of mu = " + d + ", beta = " + d2 + ", gamma = " + d3);
                System.out.println("NaN returned");
                d4 = Double.NaN;
                bl = false;
                continue;
            }
            ++n;
        }
        return d4;
    }

    public double[] gammaArray(double d, double d2, double d3, int n) {
        double[] dArray = new double[n];
        GammaFunct gammaFunct = new GammaFunct();
        gammaFunct.mu = d;
        gammaFunct.beta = d2;
        gammaFunct.gamma = d3;
        double d4 = Math.sqrt(d3) * d2;
        double d5 = 1.0E-10;
        double d6 = d + 5.0 * d4;
        double d7 = d;
        if (d6 <= d7) {
            d6 += d4;
        }
        for (int j = 0; j < n; ++j) {
            RealRoot realRoot = new RealRoot();
            realRoot.noLowerBoundExtension();
            realRoot.setTolerance(d5);
            realRoot.resetNaNexceptionToTrue();
            realRoot.supressLimitReachedMessage();
            realRoot.supressNaNmessage();
            boolean bl = true;
            int n2 = 0;
            int n3 = 10;
            while (bl) {
                gammaFunct.cfd = this.nextDouble();
                double d8 = realRoot.bisect(gammaFunct, d7, d6);
                if (!Double.isNaN(d8)) {
                    bl = false;
                    dArray[j] = d8;
                    continue;
                }
                if (n2 > n3) {
                    System.out.println("class: PsRandom,  method: gammaArray");
                    System.out.println(n3 + " successive attempts at calculating a random gamma deviate failed for values of mu = " + d + ", beta = " + d2 + ", gamma = " + d3);
                    System.out.println("NaN returned");
                    dArray[j] = Double.NaN;
                    bl = false;
                    continue;
                }
                ++n2;
            }
        }
        return dArray;
    }

    public double nextErlang(double d, int n) {
        return this.nextGamma(0.0, 1.0 / d, n);
    }

    public double[] erlangArray(double d, int n, int n2) {
        return this.gammaArray(0.0, 1.0 / d, n, n2);
    }

    public double[] chiSquareArray(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + n + ", must be greater than zero");
        }
        double[] dArray = new double[n2];
        ChiSquareFunct chiSquareFunct = new ChiSquareFunct();
        chiSquareFunct.nu = n;
        double d = 1.0E-10;
        double d2 = 0.0;
        double d3 = 5.0 * Math.sqrt(2 * n);
        for (int j = 0; j < n2; ++j) {
            RealRoot realRoot = new RealRoot();
            realRoot.noLowerBoundExtension();
            realRoot.setTolerance(d);
            realRoot.resetNaNexceptionToTrue();
            realRoot.supressLimitReachedMessage();
            realRoot.supressNaNmessage();
            boolean bl = true;
            int n3 = 0;
            int n4 = 10;
            while (bl) {
                chiSquareFunct.cfd = this.nextDouble();
                double d4 = realRoot.falsePosition(chiSquareFunct, d2, d3);
                if (!Double.isNaN(d4)) {
                    bl = false;
                    dArray[j] = d4;
                    continue;
                }
                if (n3 > n4) {
                    System.out.println("class: PsRandom,  method: chiSquareArray");
                    System.out.println(n4 + " successive attempts at calculating a random chi square deviate failed for values of nu = " + n);
                    System.out.println("NaN returned");
                    dArray[j] = Double.NaN;
                    bl = false;
                    continue;
                }
                ++n3;
            }
        }
        return dArray;
    }

    public double nextChiSquare(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + n + ", must be greater than zero");
        }
        double d = 0.0;
        ChiSquareFunct chiSquareFunct = new ChiSquareFunct();
        chiSquareFunct.nu = n;
        double d2 = 1.0E-10;
        double d3 = 0.0;
        double d4 = 5.0 * Math.sqrt(2 * n);
        RealRoot realRoot = new RealRoot();
        realRoot.noLowerBoundExtension();
        realRoot.setTolerance(d2);
        realRoot.resetNaNexceptionToTrue();
        realRoot.supressLimitReachedMessage();
        realRoot.supressNaNmessage();
        boolean bl = true;
        int n2 = 0;
        int n3 = 10;
        while (bl) {
            chiSquareFunct.cfd = this.nextDouble();
            d = realRoot.falsePosition(chiSquareFunct, d3, d4);
            if (!Double.isNaN(d)) {
                bl = false;
                continue;
            }
            if (n2 > n3) {
                System.out.println("class: PsRandom,  method: nextChiSqauare");
                System.out.println(n3 + " successive attempts at calculating a random Chi Square deviate failed for values of nu = " + n);
                System.out.println("NaN returned");
                d = Double.NaN;
                bl = false;
                continue;
            }
            ++n2;
        }
        return d;
    }

    public double nextF(int n, int n2) {
        double d = Double.NaN;
        Ffunct ffunct = new Ffunct();
        ffunct.nu1 = n;
        ffunct.nu2 = n2;
        double d2 = 1.0E-10;
        double d3 = 0.0;
        double d4 = 10.0;
        if (n2 > 4) {
            d4 = 5.0 * Math.sqrt(2 * n2 * n2 * (n + n2 - 2) / (n * (n2 - 2) * (n2 - 2) * (n2 - 4)));
        }
        RealRoot realRoot = new RealRoot();
        realRoot.noLowerBoundExtension();
        realRoot.setTolerance(d2);
        realRoot.resetNaNexceptionToTrue();
        realRoot.supressLimitReachedMessage();
        realRoot.supressNaNmessage();
        boolean bl = true;
        int n3 = 0;
        int n4 = 10;
        while (bl) {
            ffunct.cfd = this.nextDouble();
            d = realRoot.falsePosition(ffunct, d3, d4);
            if (!Double.isNaN(d)) {
                bl = false;
                continue;
            }
            if (n3 > n4) {
                System.out.println("class: PsRandom,  method: nextF");
                System.out.println(n4 + " successive attempts at calculating a random F-distribution deviate failed for values of nu1 = " + n + ", nu2 = " + n2);
                System.out.println("NaN returned");
                d = Double.NaN;
                bl = false;
                continue;
            }
            ++n3;
        }
        return d;
    }

    public double[] fArray(int n, int n2, int n3) {
        double[] dArray = new double[n3];
        Ffunct ffunct = new Ffunct();
        ffunct.nu1 = n;
        ffunct.nu2 = n2;
        double d = 1.0E-10;
        double d2 = 0.0;
        double d3 = 10.0;
        double d4 = n;
        double d5 = n2;
        if (n2 > 4) {
            d3 = 5.0 * Math.sqrt(2.0 * d5 * d5 * (d4 + d5 - 2.0) / (d4 * (d5 - 2.0) * (d5 - 2.0) * (d5 - 4.0)));
        }
        for (int j = 0; j < n3; ++j) {
            RealRoot realRoot = new RealRoot();
            realRoot.noLowerBoundExtension();
            realRoot.setTolerance(d);
            realRoot.resetNaNexceptionToTrue();
            realRoot.supressLimitReachedMessage();
            realRoot.supressNaNmessage();
            boolean bl = true;
            int n4 = 0;
            int n5 = 10;
            while (bl) {
                ffunct.cfd = this.nextDouble();
                double d6 = realRoot.falsePosition(ffunct, d2, d3);
                if (!Double.isNaN(d6)) {
                    bl = false;
                    dArray[j] = d6;
                    continue;
                }
                if (n4 > n5) {
                    System.out.println("class: PsRandom,  method: fArray");
                    System.out.println(n5 + " successive attempts at calculating a random f-distribution deviate failed for values of nu1 = " + n + ", nu2 = " + n2);
                    System.out.println("NaN returned");
                    dArray[j] = Double.NaN;
                    bl = false;
                    continue;
                }
                ++n4;
            }
        }
        return dArray;
    }

    public int nextInteger(int n, int n2) {
        int n3 = 0;
        switch (this.methodOptionInteger) {
            case 1: {
                n3 = this.rr.nextInt(++n2 - n) + n;
                break;
            }
            case 2: {
                n3 = (int)Math.round(this.nextDouble() * (double)(n2 - n)) + n;
                break;
            }
            case 3: {
                n3 = (int)Math.floor(this.nextDouble() * (double)(++n2 - n)) + n;
                break;
            }
            default: {
                throw new IllegalArgumentException("methodOptionInteger, " + this.methodOptionInteger + " is not recognised");
            }
        }
        return n3;
    }

    public int nextInteger(int n) {
        return this.nextInteger(0, n);
    }

    public int[] integerArray(int n, int n2) {
        int[] nArray = new int[n];
        for (int j = 0; j < n; ++j) {
            nArray[j] = this.nextInteger(n2);
        }
        return nArray;
    }

    public int[] integerArray(int n, int n2, int n3) {
        int[] nArray = new int[n];
        for (int j = 0; j < n; ++j) {
            nArray[j] = this.nextInteger(n3 - n2) + n2;
        }
        return nArray;
    }

    public int[] noRepeatIntegerArray(int n, int n2, int n3) {
        int[] nArray = new int[n];
        boolean bl = true;
        int n4 = -1;
        int n5 = 0;
        boolean bl2 = true;
        while (bl) {
            n4 = this.nextInteger(n3 - n2) + n2;
            if (n5 == 0) {
                nArray[0] = n4;
                n5 = 1;
            } else {
                bl2 = true;
                for (int j = 0; j < n5; ++j) {
                    if (nArray[j] != n4) continue;
                    bl2 = false;
                }
                if (bl2) {
                    nArray[n5] = n4;
                    ++n5;
                }
            }
            if (n5 != n) continue;
            bl = false;
        }
        return nArray;
    }

    public int[] uniqueIntegerArray(int n, int n2) {
        int n3 = n2 - n;
        int[] nArray = this.uniqueIntegerArray(n3);
        int n4 = 0;
        while (n4 < n3 + 1) {
            int n5 = n4++;
            nArray[n5] = nArray[n5] + n;
        }
        return nArray;
    }

    public int[] uniqueIntegerArray(int n) {
        int n2;
        int n3 = n + 1;
        int[] nArray = new int[n3];
        boolean bl = false;
        int n4 = 0;
        boolean[] blArray = new boolean[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            blArray[n2] = false;
        }
        while (!bl) {
            n2 = this.nextInteger(n);
            if (blArray[n2]) continue;
            nArray[n4] = n2;
            blArray[n2] = true;
            if (++n4 != n3) continue;
            bl = true;
        }
        return nArray;
    }

    public static long getSerialVersionUID() {
        return 1L;
    }
}

