/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.circuits.Phasor;
import flanagan.math.Point;

public class VectorMaths {
    Point point0 = null;
    Point point1 = null;
    int nDimensionsEntered = 0;

    public VectorMaths(double[] dArray) {
        this.setVector(dArray);
    }

    public VectorMaths(double[] dArray, double[] dArray2) {
        this.setVector(dArray, dArray2);
    }

    public VectorMaths(double d, double d2, double d3) {
        this.setVector(d, d2, d3);
    }

    public VectorMaths(double d, double d2) {
        this.setVector(d, d2);
    }

    public VectorMaths(double d) {
        this.setVector(d);
    }

    public VectorMaths(Point point) {
        this.setVector(point);
    }

    public VectorMaths(Point point, Point point2) {
        this.setVector(point, point2);
    }

    public void setVector(double[] dArray) {
        int n;
        this.nDimensionsEntered = dArray.length;
        if (this.nDimensionsEntered > 3) {
            throw new IllegalArgumentException("VectorMaths will not handle dimensional spaces greater than 3-dimensional");
        }
        double[] dArray2 = new double[3];
        for (n = 0; n < this.nDimensionsEntered; ++n) {
            dArray2[n] = dArray[n];
        }
        for (n = this.nDimensionsEntered; n < 3; ++n) {
            dArray2[n] = 0.0;
        }
        this.point1 = new Point(dArray2);
        double[] dArray3 = new double[3];
        this.point0 = new Point(dArray3);
    }

    public void setVector(double[] dArray, double[] dArray2) {
        int n;
        this.nDimensionsEntered = dArray.length;
        int n2 = dArray2.length;
        if (n2 != this.nDimensionsEntered) {
            throw new IllegalArgumentException("The two dimensions, " + this.nDimensionsEntered + " and " + n2 + ", should be equal");
        }
        if (this.nDimensionsEntered > 3) {
            throw new IllegalArgumentException("VectorMaths will not handle dimensional spaces greater than 3-dimensional");
        }
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        for (n = 0; n < this.nDimensionsEntered; ++n) {
            dArray3[n] = dArray[n];
            dArray4[n] = dArray2[n];
        }
        for (n = this.nDimensionsEntered; n < 3; ++n) {
            dArray3[n] = 0.0;
            dArray4[n] = 0.0;
        }
        this.point0 = new Point(dArray3);
        this.point1 = new Point(dArray4);
    }

    public void setVector(double d, double d2, double d3) {
        this.point1 = new Point(d, d2, d3);
        this.nDimensionsEntered = 3;
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        this.point0 = new Point(dArray);
    }

    public void setVector(double d, double d2) {
        this.point1 = new Point(d, d2, 0.0);
        this.nDimensionsEntered = 2;
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        this.point0 = new Point(dArray);
    }

    public void setVector(double d) {
        this.point1 = new Point(d, 0.0, 0.0);
        this.nDimensionsEntered = 1;
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        this.point0 = new Point(dArray);
    }

    public void setVector(Point point) {
        double[] dArray;
        int n = point.getPointDimensions();
        if (n > 3) {
            throw new IllegalArgumentException("VectorMaths will not handle dimensional spaces greater than 3-dimensional");
        }
        this.nDimensionsEntered = n;
        if (n == 3) {
            this.point1 = point;
        } else {
            int n2;
            dArray = point.getPointCoordinates();
            double[] dArray2 = new double[3];
            for (n2 = 0; n2 < n; ++n2) {
                dArray2[n2] = dArray[n2];
            }
            for (n2 = n; n2 < 3; ++n2) {
                dArray2[n2] = 0.0;
            }
            this.point1 = new Point(dArray2);
        }
        dArray = new double[3];
        for (int j = 0; j < 3; ++j) {
            dArray[j] = 0.0;
        }
        this.point0 = new Point(dArray);
    }

    public void setVector(Point point, Point point2) {
        this.nDimensionsEntered = point.getPointDimensions();
        int n = point2.getPointDimensions();
        if (n != this.nDimensionsEntered) {
            throw new IllegalArgumentException("The dimensions of the two points, " + this.nDimensionsEntered + " and " + n + ", should be equal");
        }
        if (this.nDimensionsEntered > 3) {
            throw new IllegalArgumentException("VectorMaths will not handle dimensional spaces greater than 3-dimensional");
        }
        if (n == 3) {
            this.point0 = point.copy();
            this.point1 = point2.copy();
        } else {
            int n2;
            double[] dArray = point.getPointCoordinates();
            double[] dArray2 = point2.getPointCoordinates();
            double[] dArray3 = new double[3];
            double[] dArray4 = new double[3];
            for (n2 = 0; n2 < n; ++n2) {
                dArray3[n2] = dArray[n2];
                dArray4[n2] = dArray2[n2];
            }
            for (n2 = n; n2 < 3; ++n2) {
                dArray3[n2] = 0.0;
                dArray4[n2] = 0.0;
            }
            this.point0 = new Point(dArray3);
            this.point1 = new Point(dArray4);
        }
    }

    public Point[] getVector() {
        Point[] pointArray = Point.oneDarray(2);
        pointArray[0] = this.point0;
        pointArray[1] = this.point1;
        return pointArray;
    }

    public Point getInitialPoint() {
        return this.point0;
    }

    public Point getFinalPoint() {
        return this.point1;
    }

    public int getDimensionsEntered() {
        return this.nDimensionsEntered;
    }

    public VectorMaths copy() {
        Point point = this.point0.copy();
        Point point2 = this.point1.copy();
        VectorMaths vectorMaths = new VectorMaths(point, point2);
        vectorMaths.nDimensionsEntered = this.nDimensionsEntered;
        return vectorMaths;
    }

    public boolean isEqual(VectorMaths vectorMaths) {
        boolean bl = true;
        Point point = vectorMaths.getInitialPoint();
        Point point2 = vectorMaths.getFinalPoint();
        if (!this.point0.isEqual(point)) {
            bl = false;
        } else if (!this.point1.isEqual(point2)) {
            bl = false;
        }
        return bl;
    }

    public static boolean isEqual(VectorMaths vectorMaths, VectorMaths vectorMaths2) {
        boolean bl = true;
        Point point = vectorMaths.getInitialPoint();
        Point point2 = vectorMaths.getFinalPoint();
        Point point3 = vectorMaths2.getInitialPoint();
        Point point4 = vectorMaths2.getFinalPoint();
        if (!point.isEqual(point3)) {
            bl = false;
        } else if (!point2.isEqual(point4)) {
            bl = false;
        }
        return bl;
    }

    public VectorMaths plus(VectorMaths vectorMaths) {
        double[] dArray = this.getInitialPoint().getPointCoordinates();
        double[] dArray2 = this.getFinalPoint().getPointCoordinates();
        double[] dArray3 = vectorMaths.getInitialPoint().getPointCoordinates();
        double[] dArray4 = vectorMaths.getFinalPoint().getPointCoordinates();
        int n = 3;
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray5[j] = dArray[j] + dArray3[j];
            dArray6[j] = dArray2[j] + dArray4[j];
        }
        return new VectorMaths(dArray5, dArray6);
    }

    public static VectorMaths plus(VectorMaths vectorMaths, VectorMaths vectorMaths2) {
        double[] dArray = vectorMaths.getInitialPoint().getPointCoordinates();
        double[] dArray2 = vectorMaths.getFinalPoint().getPointCoordinates();
        double[] dArray3 = vectorMaths2.getInitialPoint().getPointCoordinates();
        double[] dArray4 = vectorMaths2.getFinalPoint().getPointCoordinates();
        int n = 3;
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray5[j] = dArray[j] + dArray3[j];
            dArray6[j] = dArray2[j] + dArray4[j];
        }
        return new VectorMaths(dArray5, dArray6);
    }

    public void plusEquals(VectorMaths vectorMaths) {
        double[] dArray = this.getInitialPoint().getPointCoordinates();
        double[] dArray2 = this.getFinalPoint().getPointCoordinates();
        double[] dArray3 = vectorMaths.getInitialPoint().getPointCoordinates();
        double[] dArray4 = vectorMaths.getFinalPoint().getPointCoordinates();
        int n = 3;
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray5[j] = dArray[j] + dArray3[j];
            dArray6[j] = dArray2[j] + dArray4[j];
        }
        this.setVector(dArray5, dArray6);
    }

    public VectorMaths minus(VectorMaths vectorMaths) {
        double[] dArray = this.getInitialPoint().getPointCoordinates();
        double[] dArray2 = this.getFinalPoint().getPointCoordinates();
        double[] dArray3 = vectorMaths.getInitialPoint().getPointCoordinates();
        double[] dArray4 = vectorMaths.getFinalPoint().getPointCoordinates();
        int n = 3;
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray5[j] = dArray[j] - dArray3[j];
            dArray6[j] = dArray2[j] - dArray4[j];
        }
        return new VectorMaths(dArray5, dArray6);
    }

    public static VectorMaths minus(VectorMaths vectorMaths, VectorMaths vectorMaths2) {
        double[] dArray = vectorMaths.getInitialPoint().getPointCoordinates();
        double[] dArray2 = vectorMaths.getFinalPoint().getPointCoordinates();
        double[] dArray3 = vectorMaths2.getInitialPoint().getPointCoordinates();
        double[] dArray4 = vectorMaths2.getFinalPoint().getPointCoordinates();
        int n = 3;
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray5[j] = dArray[j] - dArray3[j];
            dArray6[j] = dArray2[j] - dArray4[j];
        }
        return new VectorMaths(dArray5, dArray6);
    }

    public void minusEquals(VectorMaths vectorMaths) {
        double[] dArray = this.getInitialPoint().getPointCoordinates();
        double[] dArray2 = this.getFinalPoint().getPointCoordinates();
        double[] dArray3 = vectorMaths.getInitialPoint().getPointCoordinates();
        double[] dArray4 = vectorMaths.getFinalPoint().getPointCoordinates();
        int n = 3;
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray5[j] = dArray[j] - dArray3[j];
            dArray6[j] = dArray2[j] - dArray4[j];
        }
        this.setVector(dArray5, dArray6);
    }

    public VectorMaths times(double d) {
        int n = 3;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = this.getInitialPoint().getPointCoordinates();
        double[] dArray4 = this.getInitialPoint().getPointCoordinates();
        for (int j = 0; j < n; ++j) {
            dArray[j] = dArray3[j] + d;
            dArray2[j] = dArray4[j] + d;
        }
        return new VectorMaths(dArray, dArray2);
    }

    public static VectorMaths times(VectorMaths vectorMaths, double d) {
        int n = 3;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = vectorMaths.getInitialPoint().getPointCoordinates();
        double[] dArray4 = vectorMaths.getInitialPoint().getPointCoordinates();
        for (int j = 0; j < n; ++j) {
            dArray[j] = dArray3[j] + d;
            dArray2[j] = dArray4[j] + d;
        }
        return new VectorMaths(dArray, dArray2);
    }

    public void timesEquals(double d) {
        int n = 3;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = this.getInitialPoint().getPointCoordinates();
        double[] dArray4 = this.getInitialPoint().getPointCoordinates();
        for (int j = 0; j < n; ++j) {
            dArray[j] = dArray3[j] + d;
            dArray2[j] = dArray4[j] + d;
        }
        this.setVector(dArray, dArray2);
    }

    public double dot(VectorMaths vectorMaths) {
        double[] dArray = this.getInitialPoint().getPointCoordinates();
        double[] dArray2 = this.getFinalPoint().getPointCoordinates();
        double[] dArray3 = vectorMaths.getInitialPoint().getPointCoordinates();
        double[] dArray4 = vectorMaths.getFinalPoint().getPointCoordinates();
        double d = 0.0;
        for (int j = 0; j < 3; ++j) {
            d += (dArray2[j] - dArray[j]) * (dArray4[j] - dArray3[j]);
        }
        return d;
    }

    public static double dot(VectorMaths vectorMaths, VectorMaths vectorMaths2) {
        double[] dArray = vectorMaths.getInitialPoint().getPointCoordinates();
        double[] dArray2 = vectorMaths.getFinalPoint().getPointCoordinates();
        double[] dArray3 = vectorMaths2.getInitialPoint().getPointCoordinates();
        double[] dArray4 = vectorMaths2.getFinalPoint().getPointCoordinates();
        double d = 0.0;
        for (int j = 0; j < 3; ++j) {
            d += (dArray2[j] - dArray[j]) * (dArray4[j] - dArray3[j]);
        }
        return d;
    }

    public VectorMaths cross(VectorMaths vectorMaths) {
        int n;
        double[] dArray = this.getInitialPoint().getPointCoordinates();
        double[] dArray2 = this.getFinalPoint().getPointCoordinates();
        double[] dArray3 = vectorMaths.getInitialPoint().getPointCoordinates();
        double[] dArray4 = vectorMaths.getFinalPoint().getPointCoordinates();
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        double[] dArray7 = new double[3];
        for (n = 0; n < 3; ++n) {
            dArray5[n] = dArray2[n] - dArray[n];
            dArray6[n] = dArray4[n] - dArray3[n];
        }
        for (n = 0; n < 3; ++n) {
            dArray7[0] = dArray5[1] * dArray6[2] - dArray5[2] * dArray6[1];
            dArray7[1] = dArray5[2] * dArray6[0] - dArray5[0] * dArray6[2];
            dArray7[2] = dArray5[0] * dArray6[1] - dArray5[1] * dArray6[0];
        }
        VectorMaths vectorMaths2 = new VectorMaths(dArray7);
        return vectorMaths2;
    }

    public static VectorMaths cross(VectorMaths vectorMaths, VectorMaths vectorMaths2) {
        int n;
        double[] dArray = vectorMaths.getInitialPoint().getPointCoordinates();
        double[] dArray2 = vectorMaths.getFinalPoint().getPointCoordinates();
        double[] dArray3 = vectorMaths2.getInitialPoint().getPointCoordinates();
        double[] dArray4 = vectorMaths2.getFinalPoint().getPointCoordinates();
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        double[] dArray7 = new double[3];
        for (n = 0; n < 3; ++n) {
            dArray5[n] = dArray2[n] - dArray[n];
            dArray6[n] = dArray4[n] - dArray3[n];
        }
        for (n = 0; n < 3; ++n) {
            dArray7[0] = dArray5[1] * dArray6[2] - dArray5[2] * dArray6[1];
            dArray7[1] = dArray5[2] * dArray6[0] - dArray5[0] * dArray6[2];
            dArray7[2] = dArray5[0] * dArray6[1] - dArray5[1] * dArray6[0];
        }
        VectorMaths vectorMaths3 = new VectorMaths(dArray7);
        return vectorMaths3;
    }

    public double length() {
        double[] dArray = this.getInitialPoint().getPointCoordinates();
        double[] dArray2 = this.getFinalPoint().getPointCoordinates();
        double d = 0.0;
        for (int j = 0; j < 3; ++j) {
            d += (dArray2[j] - dArray[j]) * (dArray2[j] - dArray[j]);
        }
        return Math.sqrt(d);
    }

    public double magnitude() {
        return this.length();
    }

    public double norm() {
        return this.length();
    }

    public double angleRadians(VectorMaths vectorMaths) {
        double d = this.norm();
        double d2 = vectorMaths.norm();
        double d3 = this.dot(vectorMaths);
        double d4 = d3 / (d * d2);
        return Math.acos(d4);
    }

    public double angleDegrees(VectorMaths vectorMaths) {
        return Math.toDegrees(this.angleRadians(vectorMaths));
    }

    public static double angleRadians(VectorMaths vectorMaths, VectorMaths vectorMaths2) {
        double d = vectorMaths.norm();
        double d2 = vectorMaths2.norm();
        double d3 = VectorMaths.dot(vectorMaths, vectorMaths2);
        double d4 = d3 / (d * d2);
        return Math.acos(d4);
    }

    public static double angleDegrees(VectorMaths vectorMaths, VectorMaths vectorMaths2) {
        return Math.toDegrees(VectorMaths.angleRadians(vectorMaths, vectorMaths2));
    }

    public Phasor toPhasor() {
        double[] dArray = this.point0.getPointCoordinates();
        double[] dArray2 = this.point1.getPointCoordinates();
        double d = 0.0;
        double d2 = 0.0;
        switch (this.nDimensionsEntered) {
            case 1: {
                d = Math.abs(dArray2[0] - dArray[0]);
                d2 = 0.0;
                break;
            }
            case 2: {
                d = Point.distance(this.point0, this.point1);
                d2 = Math.toDegrees(Math.atan2(dArray2[1] - dArray[1], dArray2[0] - dArray[0]));
                break;
            }
            default: {
                throw new IllegalArgumentException("Entered dimensions must be either 1 or 2");
            }
        }
        return new Phasor(d, d2);
    }
}

