/*
 * Decompiled with CFR 0.152.
 */
package flanagan.optics;

import flanagan.analysis.ErrorProp;
import flanagan.optics.PlanarWaveguide;
import flanagan.optics.RefractiveIndex;

public class PrismCoupler
extends PlanarWaveguide {
    private double[] thicknessesTE = null;
    private double[] anglesDegTE = null;
    private double[] anglesRadTE = null;
    private double[] errorsDegTE = null;
    private double[] errorsRadTE = null;
    private double[] modeNumbersTE = null;
    private double[] effectiveRefractiveIndicesTE = null;
    private double[] effectiveErrorsTE = null;
    private int numberOfTEmeasurementsPrism = 0;
    private boolean setMeasurementsTEprism = false;
    private boolean setTEerrors = false;
    private double[] thicknessesTM = null;
    private double[] anglesDegTM = null;
    private double[] anglesRadTM = null;
    private double[] errorsDegTM = null;
    private double[] errorsRadTM = null;
    private double[] modeNumbersTM = null;
    private double[] effectiveRefractiveIndicesTM = null;
    private double[] effectiveErrorsTM = null;
    private int numberOfTMmeasurementsPrism = 0;
    private boolean setMeasurementsTMprism = false;
    private boolean setTMerrors = false;
    private int numberOfMeasurementsPrism = 0;
    private boolean setMeasurementsPrism = false;
    private boolean setPrismRI = false;
    private double prismAngleAlphaDeg = 0.0;
    private double prismAngleAlphaRad = 0.0;
    private boolean setPrismAlpha = false;

    public void setPrismRefractiveIndex(double d) {
        this.prismRefractiveIndex = d;
        this.prismRefractiveIndex2 = d * d;
        this.setPrismRI = true;
        if (this.setMeasurementsPrism && this.setPrismAlpha) {
            this.calcEffectiveRefractiveIndices();
        }
    }

    public void setPrismAngleAlpha(double d) {
        this.prismAngleAlphaDeg = d;
        this.prismAngleAlphaRad = Math.toRadians(d);
        this.setPrismAlpha = true;
        if (this.setMeasurementsPrism && this.setPrismRI) {
            this.calcEffectiveRefractiveIndices();
        }
    }

    public void setPrismToWaveguideGap(double d) {
        this.prismToWaveguideGap = d;
        this.setPrismToWaveguideGap = true;
    }

    @Override
    public void enterTEmodeData(double d, double d2, double d3) {
        if (this.setMeasurementsTEprism) {
            int n;
            if (this.setErrorsTE) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n2 = this.numberOfTEmeasurementsPrism + 1;
            double[] dArray = new double[n2];
            for (n = 0; n < this.numberOfTEmeasurementsPrism; ++n) {
                dArray[n] = this.thicknessesTE[n];
            }
            dArray[this.numberOfTEmeasurementsPrism] = d;
            this.thicknessesTE = dArray;
            for (n = 0; n < this.numberOfTEmeasurementsPrism; ++n) {
                dArray[n] = this.anglesDegTE[n];
            }
            dArray[this.numberOfTEmeasurementsPrism] = d2;
            this.anglesDegTE = dArray;
            this.anglesRadTE = dArray;
            this.errorsDegTE = dArray;
            this.errorsRadTE = dArray;
            for (n = 0; n < n2; ++n) {
                this.anglesRadTE[n] = Math.toRadians(this.anglesDegTE[n]);
                this.errorsDegTE[n] = 0.0;
                this.errorsRadTE[n] = 0.0;
            }
            for (n = 0; n < this.numberOfTEmeasurementsPrism; ++n) {
                dArray[n] = this.modeNumbersTE[n];
            }
            dArray[this.numberOfTEmeasurementsPrism] = d3;
            this.numberOfTEmeasurementsPrism = n2;
        } else {
            this.thicknessesTE = new double[1];
            this.thicknessesTE[0] = d;
            this.anglesDegTE = new double[1];
            this.anglesDegTE[0] = d2;
            this.anglesRadTE = new double[1];
            this.anglesRadTE[0] = Math.toRadians(d2);
            this.errorsDegTE = new double[1];
            this.errorsDegTE[0] = 0.0;
            this.errorsRadTE = new double[1];
            this.errorsRadTE[0] = 0.0;
            this.modeNumbersTE = new double[1];
            this.modeNumbersTE[0] = d3;
            this.numberOfTEmeasurementsPrism = 1;
        }
        this.numberOfMeasurementsPrism = this.numberOfTEmeasurementsPrism + this.numberOfTMmeasurementsPrism;
        this.setMeasurementsTEprism = true;
        this.setMeasurementsPrism = true;
        if (this.setPrismAlpha && this.setPrismAlpha) {
            this.calcTEmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTMmodeData(double d, double d2, double d3) {
        if (this.setMeasurementsTMprism) {
            int n;
            if (this.setTMerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n2 = this.numberOfTMmeasurementsPrism + 1;
            double[] dArray = new double[n2];
            for (n = 0; n < this.numberOfTMmeasurementsPrism; ++n) {
                dArray[n] = this.thicknessesTM[n];
            }
            dArray[this.numberOfTMmeasurementsPrism] = d;
            this.thicknessesTM = dArray;
            for (n = 0; n < this.numberOfTMmeasurementsPrism; ++n) {
                dArray[n] = this.anglesDegTM[n];
            }
            dArray[this.numberOfTMmeasurementsPrism] = d2;
            this.anglesDegTM = dArray;
            this.anglesRadTM = dArray;
            this.errorsDegTM = dArray;
            this.errorsRadTM = dArray;
            for (n = 0; n < n2; ++n) {
                this.anglesRadTM[n] = Math.toRadians(this.anglesDegTM[n]);
                this.errorsDegTM[n] = 0.0;
                this.errorsRadTM[n] = 0.0;
            }
            for (n = 0; n < this.numberOfTMmeasurementsPrism; ++n) {
                dArray[n] = this.modeNumbersTM[n];
            }
            dArray[this.numberOfTMmeasurementsPrism] = d3;
            this.numberOfTMmeasurementsPrism = n2;
        } else {
            this.thicknessesTM = new double[1];
            this.thicknessesTM[0] = d;
            this.anglesDegTM = new double[1];
            this.anglesDegTM[0] = d2;
            this.anglesRadTM = new double[1];
            this.anglesRadTM[0] = Math.toRadians(d2);
            this.errorsDegTM = new double[1];
            this.errorsDegTM[0] = 0.0;
            this.errorsRadTM = new double[1];
            this.errorsRadTM[0] = 0.0;
            this.modeNumbersTM = new double[1];
            this.modeNumbersTM[0] = d3;
            this.numberOfTMmeasurementsPrism = 1;
        }
        this.numberOfMeasurementsPrism = this.numberOfTEmeasurementsPrism + this.numberOfTMmeasurementsPrism;
        this.setMeasurementsTMprism = true;
        this.setMeasurementsPrism = true;
        if (this.setPrismAlpha && this.setPrismRI) {
            this.calcTMmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTEmodeData(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray2.length;
        int n2 = dArray.length;
        if (n != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of coupling angles, " + n);
        }
        int n3 = dArray3.length;
        if (n3 != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of mode numbers, " + n3);
        }
        if (this.setMeasurementsTEprism) {
            int n4;
            if (this.setTEerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n5 = this.numberOfTEmeasurementsPrism + n2;
            double[] dArray4 = new double[n5];
            for (n4 = 0; n4 < this.numberOfTEmeasurementsPrism; ++n4) {
                dArray4[n4] = this.thicknessesTE[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray4[this.numberOfTEmeasurementsPrism + n4] = dArray[n4];
            }
            this.thicknessesTE = dArray4;
            for (n4 = 0; n4 < this.numberOfTEmeasurementsPrism; ++n4) {
                dArray4[n4] = this.anglesDegTE[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray4[this.numberOfTEmeasurementsPrism + n4] = dArray2[n4];
            }
            this.anglesDegTE = dArray4;
            this.anglesRadTE = dArray4;
            this.errorsDegTE = dArray4;
            this.errorsRadTE = dArray4;
            for (n4 = 0; n4 < n5; ++n4) {
                this.anglesRadTE[n4] = Math.toRadians(this.anglesDegTE[n4]);
                this.errorsDegTE[n4] = 0.0;
                this.errorsRadTE[n4] = 0.0;
            }
            for (n4 = 0; n4 < this.numberOfTEmeasurementsPrism; ++n4) {
                dArray4[n4] = this.modeNumbersTE[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray4[this.numberOfTEmeasurementsPrism + n4] = dArray3[n4];
            }
            this.numberOfTEmeasurementsPrism = n5;
        } else {
            this.numberOfTEmeasurementsPrism = n2;
            this.thicknessesTE = dArray;
            this.anglesDegTE = dArray2;
            this.anglesRadTE = new double[n2];
            this.errorsDegTE = new double[n2];
            this.errorsRadTE = new double[n2];
            for (int j = 0; j < n2; ++j) {
                this.anglesRadTE[j] = Math.toRadians(dArray2[j]);
                this.errorsDegTE[j] = 0.0;
                this.errorsRadTE[j] = 0.0;
            }
            this.modeNumbersTE = dArray3;
        }
        this.numberOfMeasurementsPrism = this.numberOfTEmeasurementsPrism + this.numberOfTMmeasurementsPrism;
        this.setMeasurementsTEprism = true;
        this.setMeasurementsPrism = true;
        if (this.setPrismAlpha && this.setPrismRI) {
            this.calcTEmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTMmodeData(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray2.length;
        int n2 = dArray.length;
        if (n != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of coupling angles, " + n);
        }
        int n3 = dArray3.length;
        if (n3 != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of mode numbers, " + n3);
        }
        if (this.setMeasurementsTMprism) {
            int n4;
            if (this.setTMerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n5 = this.numberOfTMmeasurementsPrism + n2;
            double[] dArray4 = new double[n5];
            for (n4 = 0; n4 < this.numberOfTMmeasurementsPrism; ++n4) {
                dArray4[n4] = this.thicknessesTM[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray4[this.numberOfTMmeasurementsPrism + n4] = dArray[n4];
            }
            this.thicknessesTM = dArray4;
            for (n4 = 0; n4 < this.numberOfTMmeasurementsPrism; ++n4) {
                dArray4[n4] = this.anglesDegTM[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray4[this.numberOfTMmeasurementsPrism + n4] = dArray2[n4];
            }
            this.anglesDegTM = dArray4;
            this.anglesRadTM = dArray4;
            this.errorsDegTM = dArray4;
            this.errorsRadTM = dArray4;
            for (n4 = 0; n4 < n5; ++n4) {
                this.anglesRadTM[n4] = Math.toRadians(this.anglesDegTM[n4]);
                this.errorsDegTM[n4] = 0.0;
                this.errorsRadTM[n4] = 0.0;
            }
            for (n4 = 0; n4 < this.numberOfTMmeasurementsPrism; ++n4) {
                dArray4[n4] = this.modeNumbersTM[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray4[this.numberOfTMmeasurementsPrism + n4] = dArray3[n4];
            }
            this.numberOfTMmeasurementsPrism = n5;
        } else {
            this.numberOfTMmeasurementsPrism = n2;
            this.thicknessesTM = dArray;
            this.anglesDegTM = dArray2;
            this.anglesRadTM = new double[n2];
            this.errorsDegTM = new double[n2];
            this.errorsRadTM = new double[n2];
            for (int j = 0; j < n2; ++j) {
                this.anglesRadTM[j] = Math.toRadians(dArray2[j]);
                this.errorsDegTM[j] = 0.0;
                this.errorsRadTM[j] = 0.0;
            }
            this.modeNumbersTM = dArray3;
        }
        this.numberOfMeasurementsPrism = this.numberOfTEmeasurementsPrism + this.numberOfTMmeasurementsPrism;
        this.setMeasurementsTMprism = true;
        this.setMeasurementsPrism = true;
        if (this.setPrismAlpha && this.setPrismRI) {
            this.calcTMmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTEmodeData(double d, double d2, double d3, double d4) {
        if (this.setMeasurementsTEprism) {
            int n;
            if (!this.setTEerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n2 = this.numberOfTEmeasurementsPrism + 1;
            double[] dArray = new double[n2];
            for (n = 0; n < this.numberOfTEmeasurementsPrism; ++n) {
                dArray[n] = this.thicknessesTE[n];
            }
            dArray[this.numberOfTEmeasurementsPrism] = d;
            this.thicknessesTE = dArray;
            for (n = 0; n < this.numberOfTEmeasurementsPrism; ++n) {
                dArray[n] = this.anglesDegTE[n];
            }
            dArray[this.numberOfTEmeasurementsPrism] = d2;
            this.anglesDegTE = dArray;
            for (n = 0; n < this.numberOfTEmeasurementsPrism; ++n) {
                dArray[n] = this.errorsDegTE[n];
            }
            dArray[this.numberOfTEmeasurementsPrism] = d3;
            this.errorsDegTE = dArray;
            this.anglesRadTE = dArray;
            this.errorsRadTE = dArray;
            for (n = 0; n < n2; ++n) {
                this.anglesRadTE[n] = Math.toRadians(this.anglesDegTE[n]);
                this.errorsRadTE[n] = Math.toRadians(this.errorsDegTE[n]);
            }
            for (n = 0; n < this.numberOfTEmeasurementsPrism; ++n) {
                dArray[n] = this.modeNumbersTE[n];
            }
            dArray[this.numberOfTEmeasurementsPrism] = d4;
            this.numberOfTEmeasurementsPrism = n2;
        } else {
            this.thicknessesTE = new double[1];
            this.thicknessesTE[0] = d;
            this.anglesDegTE = new double[1];
            this.anglesDegTE[0] = d2;
            this.anglesRadTE = new double[1];
            this.anglesRadTE[0] = Math.toRadians(d2);
            this.errorsDegTE = new double[1];
            this.errorsDegTE[0] = d3;
            this.errorsRadTE = new double[1];
            this.errorsRadTE[0] = Math.toRadians(d3);
            this.modeNumbersTE = new double[1];
            this.modeNumbersTE[0] = d4;
            this.numberOfTEmeasurementsPrism = 1;
        }
        this.numberOfMeasurementsPrism = this.numberOfTEmeasurementsPrism + this.numberOfTMmeasurementsPrism;
        this.setMeasurementsTEprism = true;
        this.setTEerrors = true;
        this.setMeasurementsPrism = true;
        if (this.setPrismAlpha && this.setPrismRI) {
            this.calcTEmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTMmodeData(double d, double d2, double d3, double d4) {
        if (this.setMeasurementsTMprism) {
            int n;
            if (!this.setTMerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n2 = this.numberOfTMmeasurementsPrism + 1;
            double[] dArray = new double[n2];
            for (n = 0; n < this.numberOfTMmeasurementsPrism; ++n) {
                dArray[n] = this.thicknessesTM[n];
            }
            dArray[this.numberOfTMmeasurementsPrism] = d;
            this.thicknessesTM = dArray;
            for (n = 0; n < this.numberOfTMmeasurementsPrism; ++n) {
                dArray[n] = this.anglesDegTM[n];
            }
            dArray[this.numberOfTMmeasurementsPrism] = d2;
            this.anglesDegTM = dArray;
            for (n = 0; n < this.numberOfTMmeasurementsPrism; ++n) {
                dArray[n] = this.errorsDegTM[n];
            }
            dArray[this.numberOfTMmeasurementsPrism] = d3;
            this.errorsDegTM = dArray;
            this.anglesRadTM = dArray;
            this.errorsRadTM = dArray;
            for (n = 0; n < n2; ++n) {
                this.anglesRadTM[n] = Math.toRadians(this.anglesDegTM[n]);
                this.errorsRadTM[n] = Math.toRadians(this.errorsDegTM[n]);
            }
            for (n = 0; n < this.numberOfTMmeasurementsPrism; ++n) {
                dArray[n] = this.modeNumbersTM[n];
            }
            dArray[this.numberOfTMmeasurementsPrism] = d4;
            this.numberOfTMmeasurementsPrism = n2;
        } else {
            this.thicknessesTM = new double[1];
            this.thicknessesTM[0] = d;
            this.anglesDegTM = new double[1];
            this.anglesDegTM[0] = d2;
            this.anglesRadTM = new double[1];
            this.anglesDegTM[0] = Math.toRadians(d2);
            this.errorsDegTM = new double[1];
            this.errorsDegTM[0] = d3;
            this.errorsRadTM = new double[1];
            this.errorsDegTM[0] = Math.toRadians(d3);
            this.modeNumbersTM = new double[1];
            this.modeNumbersTM[0] = d4;
            this.numberOfTMmeasurementsPrism = 1;
        }
        this.numberOfMeasurementsPrism = this.numberOfTEmeasurementsPrism + this.numberOfTMmeasurementsPrism;
        this.setMeasurementsTMprism = true;
        this.setTMerrors = true;
        this.setMeasurementsPrism = true;
        if (this.setPrismAlpha && this.setPrismRI) {
            this.calcTMmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTEmodeData(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n = dArray2.length;
        int n2 = dArray.length;
        if (n != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of coupling angles, " + n);
        }
        int n3 = dArray4.length;
        if (n3 != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of mode numbers, " + n3);
        }
        if (this.setMeasurementsTEprism) {
            int n4;
            if (!this.setTEerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n5 = this.numberOfTEmeasurementsPrism + n2;
            double[] dArray5 = new double[n5];
            for (n4 = 0; n4 < this.numberOfTEmeasurementsPrism; ++n4) {
                dArray5[n4] = this.thicknessesTE[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray5[this.numberOfTEmeasurementsPrism + n4] = dArray[n4];
            }
            this.thicknessesTE = dArray5;
            for (n4 = 0; n4 < this.numberOfTEmeasurementsPrism; ++n4) {
                dArray5[n4] = this.anglesDegTE[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray5[this.numberOfTEmeasurementsPrism + n4] = dArray2[n4];
            }
            this.anglesDegTE = dArray5;
            for (n4 = 0; n4 < this.numberOfTEmeasurementsPrism; ++n4) {
                dArray5[n4] = this.errorsDegTE[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray5[this.numberOfTEmeasurementsPrism + n4] = dArray3[n4];
            }
            this.errorsDegTE = dArray5;
            this.anglesRadTE = dArray5;
            this.errorsRadTE = dArray5;
            for (n4 = 0; n4 < n5; ++n4) {
                this.anglesRadTE[n4] = Math.toRadians(this.anglesDegTE[n4]);
                this.errorsRadTE[n4] = Math.toRadians(this.errorsDegTE[n4]);
            }
            for (n4 = 0; n4 < this.numberOfTEmeasurementsPrism; ++n4) {
                dArray5[n4] = this.modeNumbersTE[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray5[this.numberOfTEmeasurementsPrism + n4] = dArray4[n4];
            }
            this.numberOfTEmeasurementsPrism = n5;
        } else {
            this.numberOfTEmeasurementsPrism = n2;
            this.thicknessesTE = dArray;
            this.anglesDegTE = dArray2;
            this.anglesRadTE = new double[n2];
            this.errorsDegTE = dArray3;
            this.errorsRadTE = new double[n2];
            for (int j = 0; j < n2; ++j) {
                this.anglesRadTE[j] = Math.toRadians(dArray2[j]);
                this.errorsRadTE[j] = Math.toRadians(dArray3[j]);
            }
            this.modeNumbersTE = dArray4;
        }
        this.numberOfMeasurementsPrism = this.numberOfTEmeasurementsPrism + this.numberOfTMmeasurementsPrism;
        this.setMeasurementsTEprism = true;
        this.setTEerrors = true;
        this.setMeasurementsPrism = true;
        if (this.setPrismAlpha && this.setPrismRI) {
            this.calcTEmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void enterTMmodeData(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n = dArray2.length;
        int n2 = dArray.length;
        if (n != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of coupling angles, " + n);
        }
        int n3 = dArray4.length;
        if (n3 != n2) {
            throw new IllegalArgumentException("number of thicknesses, " + n2 + ", does not equal the number of mode numbers, " + n3);
        }
        if (this.setMeasurementsTMprism) {
            int n4;
            if (!this.setTMerrors) {
                throw new IllegalArgumentException("All Entered data must either all have associated errors entered or all have no associated errors entered");
            }
            int n5 = this.numberOfTMmeasurementsPrism + n2;
            double[] dArray5 = new double[n5];
            for (n4 = 0; n4 < this.numberOfTMmeasurementsPrism; ++n4) {
                dArray5[n4] = this.thicknessesTM[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray5[this.numberOfTMmeasurementsPrism + n4] = dArray[n4];
            }
            this.thicknessesTM = dArray5;
            for (n4 = 0; n4 < this.numberOfTMmeasurementsPrism; ++n4) {
                dArray5[n4] = this.anglesDegTM[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray5[this.numberOfTMmeasurementsPrism + n4] = dArray2[n4];
            }
            this.anglesDegTM = dArray5;
            for (n4 = 0; n4 < this.numberOfTMmeasurementsPrism; ++n4) {
                dArray5[n4] = this.errorsDegTM[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray5[this.numberOfTMmeasurementsPrism + n4] = dArray3[n4];
            }
            this.errorsDegTM = dArray5;
            this.anglesRadTM = dArray5;
            this.errorsRadTM = dArray5;
            for (n4 = 0; n4 < n5; ++n4) {
                this.anglesRadTM[n4] = Math.toRadians(this.anglesDegTM[n4]);
                this.errorsRadTM[n4] = Math.toRadians(this.errorsDegTM[n4]);
            }
            for (n4 = 0; n4 < this.numberOfTMmeasurementsPrism; ++n4) {
                dArray5[n4] = this.modeNumbersTM[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray5[this.numberOfTMmeasurementsPrism + n4] = dArray4[n4];
            }
            this.numberOfTMmeasurementsPrism = n5;
        } else {
            this.numberOfTMmeasurementsPrism = n2;
            this.thicknessesTM = dArray;
            this.anglesDegTM = dArray2;
            this.errorsDegTM = dArray3;
            this.anglesRadTM = new double[n2];
            this.errorsRadTM = new double[n2];
            for (int j = 0; j < n2; ++j) {
                this.anglesRadTM[j] = Math.toRadians(dArray2[j]);
                this.errorsRadTM[j] = Math.toRadians(dArray3[j]);
            }
            this.modeNumbersTM = dArray4;
        }
        this.numberOfMeasurementsPrism = this.numberOfTEmeasurementsPrism + this.numberOfTMmeasurementsPrism;
        this.setMeasurementsTMprism = true;
        this.setTMerrors = true;
        this.setMeasurementsPrism = true;
        if (this.setPrismAlpha && this.setPrismRI) {
            this.calcTMmodeEffectiveRefractiveIndices();
        }
    }

    @Override
    public void clearData() {
        this.numberOfTEmeasurementsPrism = 0;
        this.setMeasurementsTEprism = false;
        this.numberOfTMmeasurementsPrism = 0;
        this.setMeasurementsTMprism = false;
        this.numberOfMeasurements = 0;
        this.setMeasurements = false;
        this.setWeights = false;
        this.numberOfTEmeasurements = 0;
        this.setMeasurementsTE = false;
        this.numberOfTMmeasurements = 0;
        this.setMeasurementsTM = false;
    }

    public void calcEffectiveRefractiveIndices() {
        if (this.setMeasurementsTEprism) {
            this.calcTEmodeEffectiveRefractiveIndices();
        }
        if (this.setMeasurementsTMprism) {
            this.calcTMmodeEffectiveRefractiveIndices();
        }
    }

    public void calcTEmodeEffectiveRefractiveIndices() {
        this.effectiveRefractiveIndicesTE = new double[this.numberOfTEmeasurementsPrism];
        this.effectiveErrorsTE = new double[this.numberOfTEmeasurementsPrism];
        if (this.setTEerrors) {
            ErrorProp errorProp = new ErrorProp(this.prismAngleAlphaRad, 0.0);
            ErrorProp errorProp2 = new ErrorProp(this.prismRefractiveIndex, 0.0);
            ErrorProp errorProp3 = new ErrorProp(RefractiveIndex.air(this.wavelength), 0.0);
            ErrorProp errorProp4 = new ErrorProp();
            ErrorProp errorProp5 = new ErrorProp();
            for (int j = 0; j < this.numberOfTEmeasurementsPrism; ++j) {
                errorProp5.reset(this.anglesRadTE[j], this.errorsRadTE[j]);
                errorProp4 = errorProp5.over(errorProp2).times(errorProp3);
                errorProp4 = ErrorProp.asin(errorProp4);
                errorProp4 = errorProp.plus(errorProp4);
                errorProp4 = errorProp2.times(ErrorProp.sin(errorProp4));
                this.effectiveRefractiveIndicesTE[j] = errorProp4.getValue();
                this.effectiveErrorsTE[j] = errorProp4.getError();
            }
            super.enterTEmodeData(this.thicknessesTE, this.effectiveRefractiveIndicesTE, this.effectiveErrorsTE, this.modeNumbersTE);
        } else {
            for (int j = 0; j < this.numberOfTEmeasurementsPrism; ++j) {
                double d = this.prismAngleAlphaRad + Math.asin(RefractiveIndex.air(this.wavelength) * this.anglesRadTE[j] / this.prismRefractiveIndex);
                this.effectiveRefractiveIndicesTE[j] = this.prismRefractiveIndex * Math.sin(d);
            }
            super.enterTEmodeData(this.thicknessesTE, this.effectiveRefractiveIndicesTE, this.modeNumbersTE);
        }
    }

    public void calcTMmodeEffectiveRefractiveIndices() {
        this.effectiveRefractiveIndicesTM = new double[this.numberOfTMmeasurementsPrism];
        this.effectiveErrorsTM = new double[this.numberOfTMmeasurementsPrism];
        if (this.setTMerrors) {
            ErrorProp errorProp = new ErrorProp(this.prismAngleAlphaRad, 0.0);
            ErrorProp errorProp2 = new ErrorProp(this.prismRefractiveIndex, 0.0);
            ErrorProp errorProp3 = new ErrorProp(RefractiveIndex.air(this.wavelength), 0.0);
            ErrorProp errorProp4 = new ErrorProp();
            ErrorProp errorProp5 = new ErrorProp();
            for (int j = 0; j < this.numberOfTMmeasurementsPrism; ++j) {
                errorProp5.reset(this.anglesRadTM[j], this.errorsRadTM[j]);
                errorProp4 = errorProp5.over(errorProp2).times(errorProp3);
                errorProp4 = ErrorProp.asin(errorProp4);
                errorProp4 = errorProp.plus(errorProp4);
                errorProp4 = errorProp2.times(ErrorProp.sin(errorProp4));
                this.effectiveRefractiveIndicesTM[j] = errorProp4.getValue();
                this.effectiveErrorsTM[j] = errorProp4.getError();
            }
            super.enterTMmodeData(this.thicknessesTM, this.effectiveRefractiveIndicesTM, this.effectiveErrorsTM, this.modeNumbersTM);
        } else {
            for (int j = 0; j < this.numberOfTMmeasurementsPrism; ++j) {
                double d = this.prismAngleAlphaRad + Math.asin(RefractiveIndex.air(this.wavelength) * this.anglesRadTM[j] / this.prismRefractiveIndex);
                this.effectiveRefractiveIndicesTM[j] = this.prismRefractiveIndex * Math.sin(d);
            }
            super.enterTMmodeData(this.thicknessesTM, this.effectiveRefractiveIndicesTM, this.modeNumbersTM);
        }
    }
}

