/*
 * Decompiled with CFR 0.152.
 */
package flanagan.optics;

import flanagan.analysis.Regression;
import flanagan.analysis.RegressionFunction;
import flanagan.complex.Complex;
import flanagan.complex.ComplexMatrix;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.optics.RegressFunct;
import flanagan.plot.Plot;
import flanagan.plot.PlotGraph;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class Reflectivity {
    private int numberOfLayers = 0;
    private int numberOfInterfaces = 0;
    private Complex[][] refractiveIndices = null;
    private Complex[] meanRefractiveIndices = null;
    private boolean refractSet = false;
    private boolean[] refractLayerSet = null;
    private boolean meanRefractUsed = false;
    private Complex[][] relativeMagneticPermeabilities = null;
    private Complex[] meanRelativeMagneticPermeabilities = null;
    private boolean magneticSet = false;
    private boolean meanMagneticUsed = false;
    private double[][] absorptionCoefficients = null;
    private boolean absorbSet = false;
    private double[] thicknesses = null;
    private double[] distances = null;
    private boolean thickSet = false;
    private boolean[] thickLayerSet = null;
    private int numberOfWavelengths = 0;
    private double[] wavelengths = null;
    private double[] frequencies = null;
    private double[] omega = null;
    private int[] origWavelIndices = null;
    private boolean wavelSet = false;
    private boolean freqSet = false;
    private boolean wavelNumberSet = false;
    private double[] incidentAngleDeg = null;
    private double[] incidentAngleRad = null;
    private int[] incidentAngleIndices = null;
    private int numberOfIncidentAngles = 0;
    private boolean incidentAngleSet = false;
    private String mode = null;
    private double eVectorAngleDeg = 0.0;
    private double eVectorAngleRad = 0.0;
    private double teFraction = 0.0;
    private double tmFraction = 0.0;
    private boolean modeSet = false;
    private Complex[][][] koVector = null;
    private Complex[][][] kVector = null;
    private Complex[][][] kxVector = null;
    private Complex[][][] kzVector = null;
    private double[][] reflectivities = null;
    private double[][] transmissivities = null;
    private double[][] powerLosses = null;
    private Complex[][] reflectCoeffTE = null;
    private Complex[][] reflectCoeffTM = null;
    private Complex[][] transmitCoeffTE = null;
    private Complex[][] transmitCoeffTM = null;
    private double[][] reflectPhaseShiftRadTE = null;
    private double[][] reflectPhaseShiftRadTM = null;
    private double[][] transmitPhaseShiftRadTE = null;
    private double[][] transmitPhaseShiftRadTM = null;
    private double[][] reflectPhaseShiftDegTE = null;
    private double[][] reflectPhaseShiftDegTM = null;
    private double[][] transmitPhaseShiftDegTE = null;
    private double[][] transmitPhaseShiftDegTM = null;
    private double[][] evanescentFields = null;
    private double fieldDistance = Double.POSITIVE_INFINITY;
    private boolean fieldIntensityCalc = false;
    private double[][] penetrationDepths = null;
    private double[][] transmitAnglesRad = null;
    private double[][] transmitAnglesDeg = null;
    private boolean singleReflectCalculated = false;
    private boolean angularReflectCalculated = false;
    private boolean wavelengthReflectCalculated = false;
    private boolean wavelengthAndAngularReflectCalculated = false;
    private double mu0overEps0 = 141925.72909094833;
    private double impedance = Math.sqrt(this.mu0overEps0);
    private int wavelengthAxisOption = 1;
    private double[] experimentalData = null;
    private double[] experimentalWeights = null;
    private double[] calculatedData = null;
    private int numberOfDataPoints = 0;
    private boolean experimentalDataSet = false;
    private boolean weightingOption = false;
    private int numberOfEstimatedParameters = 0;
    private int[] thicknessEstimateIndices = null;
    private int[] refractIndexRealEstimateIndices = null;
    private int[] refractIndexImagEstimateIndices = null;
    private int[] absorptionCoeffEstimateIndices = null;
    private int[] magneticPermRealEstimateIndices = null;
    private int[] magneticPermImagEstimateIndices = null;
    private boolean refractIndexImagEstimateSet = false;
    private boolean absorptionCoeffEstimateSet = false;
    private int thicknessEstimateNumber = 0;
    private int refractIndexRealEstimateNumber = 0;
    private int refractIndexImagEstimateNumber = 0;
    private int absorptionCoeffEstimateNumber = 0;
    private int magneticPermRealEstimateNumber = 0;
    private int magneticPermImagEstimateNumber = 0;
    private double fieldScalingFactor = 0.0;
    public int regressionOption = 0;
    public int degreesOfFreedom = 0;

    public Reflectivity(int n) {
        int n2;
        this.numberOfLayers = n;
        this.numberOfInterfaces = n - 1;
        if (n < 2) {
            throw new IllegalArgumentException("There must be at least two layers, i.e. at least one interface");
        }
        this.meanRelativeMagneticPermeabilities = Complex.oneDarray(this.numberOfLayers, 1.0, 0.0);
        this.meanRefractiveIndices = Complex.oneDarray(this.numberOfLayers);
        this.refractLayerSet = new boolean[this.numberOfLayers];
        for (n2 = 0; n2 < this.numberOfLayers; ++n2) {
            this.refractLayerSet[n2] = false;
        }
        this.thicknesses = new double[this.numberOfLayers];
        this.thicknesses[0] = Double.NEGATIVE_INFINITY;
        this.thicknesses[this.numberOfLayers - 1] = Double.POSITIVE_INFINITY;
        this.thickLayerSet = new boolean[this.numberOfLayers];
        this.thickLayerSet[0] = true;
        for (n2 = 1; n2 < this.numberOfLayers - 2; ++n2) {
            this.thickLayerSet[n2] = false;
        }
        this.thickLayerSet[this.numberOfLayers - 1] = true;
        this.distances = new double[this.numberOfInterfaces];
    }

    public void setMode(String string) {
        if (string.equalsIgnoreCase("TE") || string.equalsIgnoreCase("transverse electric")) {
            this.mode = "TE";
            this.teFraction = 1.0;
            this.tmFraction = 0.0;
            this.eVectorAngleDeg = 0.0;
            this.eVectorAngleRad = 0.0;
        } else if (string.equalsIgnoreCase("TM") || string.equalsIgnoreCase("transverse magnetic")) {
            this.mode = "TM";
            this.teFraction = 0.0;
            this.tmFraction = 1.0;
            this.eVectorAngleDeg = 90.0;
            this.eVectorAngleRad = 1.5707963267948966;
        } else if (string.equalsIgnoreCase("unpolarised") || string.equalsIgnoreCase("unpolarized") || string.equalsIgnoreCase("none")) {
            this.mode = "unpolarised";
            this.teFraction = 0.5;
            this.tmFraction = 0.5;
            this.eVectorAngleDeg = 45.0;
            this.eVectorAngleRad = 0.7853981633974483;
        } else {
            throw new IllegalArgumentException("mode must be TE, TM or unpolarised; it cannot be " + string);
        }
        this.modeSet = true;
    }

    public void setMode(double d) {
        this.mode = "mixed";
        this.eVectorAngleDeg = d;
        this.eVectorAngleRad = Math.toRadians(d);
        this.teFraction = Math.sin(this.eVectorAngleRad);
        this.teFraction *= this.teFraction;
        this.tmFraction = 1.0 - this.teFraction;
        this.modeSet = true;
    }

    public double fractionInTEmode() {
        return this.teFraction;
    }

    public double fractionInTMmode() {
        return this.tmFraction;
    }

    public void setIncidentAngle(double d) {
        double[] dArray = new double[]{d};
        this.setIncidentAngle(dArray);
    }

    public void setIncidentAngle(double[] dArray) {
        this.numberOfIncidentAngles = dArray.length;
        this.incidentAngleIndices = new int[this.numberOfIncidentAngles];
        this.incidentAngleDeg = new double[this.numberOfIncidentAngles];
        Fmath.selectionSort(dArray, this.incidentAngleDeg, this.incidentAngleIndices);
        if (this.experimentalDataSet) {
            if (this.numberOfDataPoints != this.numberOfIncidentAngles) {
                throw new IllegalArgumentException("Number of experimental reflectivities " + this.numberOfDataPoints + " does not equal the number of incident angles " + this.numberOfIncidentAngles);
            }
            double[] dArray2 = Conv.copy(this.experimentalData);
            for (int j = 0; j < this.numberOfIncidentAngles; ++j) {
                this.experimentalData[j] = dArray2[this.incidentAngleIndices[j]];
            }
        }
        this.incidentAngleRad = new double[this.numberOfIncidentAngles];
        for (int j = 0; j < this.numberOfIncidentAngles; ++j) {
            this.incidentAngleRad[j] = Math.toRadians(this.incidentAngleDeg[j]);
        }
        this.incidentAngleSet = true;
    }

    public void setIncidentAngle(double d, double d2, int n) {
        this.numberOfIncidentAngles = n;
        double d3 = (d2 - d) / (double)(n - 1);
        double[] dArray = new double[n];
        dArray[0] = d;
        for (int j = 1; j < n - 1; ++j) {
            dArray[j] = dArray[j - 1] + d3;
        }
        dArray[n - 1] = d2;
        this.setIncidentAngle(dArray);
    }

    public double[] getIncidentAngles() {
        return this.incidentAngleDeg;
    }

    public void setThicknesses(double[] dArray) {
        int n;
        int n2 = dArray.length;
        if (n2 != this.numberOfLayers - 2) {
            throw new IllegalArgumentException("Number of thicknesses, " + n2 + ", does not match the number of layers minus the outer two semi-finite layers, " + (this.numberOfLayers - 2));
        }
        for (n = 1; n < this.numberOfLayers - 1; ++n) {
            this.thicknesses[n] = dArray[n - 1];
        }
        this.distances[0] = 0.0;
        for (n = 1; n < this.numberOfInterfaces; ++n) {
            this.distances[n] = this.distances[n - 1] + this.thicknesses[n];
        }
        for (n = 1; n < this.numberOfLayers - 2; ++n) {
            this.thickLayerSet[n] = true;
        }
        this.thickSet = true;
    }

    public void setThicknesses(double d, int n) {
        int n2;
        if (n < 1 || n > this.numberOfLayers) {
            throw new IllegalArgumentException("Layer number, " + n + ", must be in the range 1 to " + this.numberOfLayers);
        }
        this.thicknesses[n - 1] = d;
        this.distances[0] = 0.0;
        for (n2 = 1; n2 < this.numberOfInterfaces; ++n2) {
            this.distances[n2] = this.distances[n2 - 1] + this.thicknesses[n2];
        }
        this.thickLayerSet[n - 1] = true;
        n2 = 0;
        for (int j = 0; j < this.numberOfLayers - j; ++j) {
            if (!this.thickLayerSet[j]) continue;
            ++n2;
        }
        if (n2 == this.numberOfLayers) {
            this.thickSet = true;
        }
    }

    public double[] getThicknesses() {
        return this.thicknesses;
    }

    public void setWavelength(double[] dArray) {
        int n;
        int n2 = dArray.length;
        if (this.wavelNumberSet && n2 != this.numberOfWavelengths) {
            throw new IllegalArgumentException("The number of wavelengths entered, " + n2 + ", does not equal that previously set," + this.numberOfWavelengths);
        }
        this.numberOfWavelengths = n2;
        this.wavelengths = dArray;
        this.wavelSet = true;
        if (!this.refractSet) {
            this.refractiveIndices = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers);
        }
        if (!this.wavelNumberSet) {
            int n3;
            if (this.meanRefractUsed) {
                for (n = 0; n < this.numberOfLayers; ++n) {
                    for (n3 = 0; n3 < this.numberOfWavelengths; ++n3) {
                        this.refractiveIndices[n3][n] = this.meanRefractiveIndices[n];
                    }
                }
                for (n = 0; n < this.numberOfLayers; ++n) {
                    this.refractLayerSet[n] = true;
                }
                this.refractSet = true;
            }
            if (this.absorptionCoefficients != null) {
                for (n = 0; n < this.numberOfLayers; ++n) {
                    for (n3 = 0; n3 < this.numberOfWavelengths; ++n3) {
                        if (this.refractiveIndices[n][n3].getImag() != 0.0) continue;
                        this.refractiveIndices[n3][n].setImag(this.absorptionCoefficients[n3][n] * this.wavelengths[n3] / (Math.PI * 4));
                    }
                }
            } else {
                this.absorptionCoefficients = new double[this.numberOfWavelengths][this.numberOfLayers];
            }
            this.relativeMagneticPermeabilities = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers);
            if (this.meanMagneticUsed) {
                for (n = 0; n < this.numberOfLayers; ++n) {
                    for (n3 = 0; n3 < this.numberOfWavelengths; ++n3) {
                        this.relativeMagneticPermeabilities[n3][n] = this.meanRelativeMagneticPermeabilities[n];
                    }
                }
                this.magneticSet = true;
            } else {
                for (n = 0; n < this.numberOfLayers; ++n) {
                    for (n3 = 0; n3 < this.numberOfWavelengths; ++n3) {
                        this.relativeMagneticPermeabilities[n3][n] = Complex.plusOne();
                    }
                }
            }
        }
        if (!this.freqSet) {
            this.frequencies = new double[this.numberOfWavelengths];
            for (n = 0; n < this.numberOfWavelengths; ++n) {
                this.frequencies[this.numberOfWavelengths - 1 - n] = 2.99792458E8 / dArray[n];
            }
        }
        this.omega = new double[this.numberOfWavelengths];
        for (n = 0; n < this.numberOfWavelengths; ++n) {
            this.omega[n] = Math.PI * 2 * this.frequencies[n];
        }
        this.wavelNumberSet = true;
    }

    public void setFrequency(double[] dArray) {
        int n = dArray.length;
        if (this.wavelNumberSet && n != this.numberOfWavelengths) {
            throw new IllegalArgumentException("The number of frequencies entered, " + n + ", does not equal that previously set," + this.numberOfWavelengths);
        }
        this.frequencies = dArray;
        this.freqSet = true;
        this.wavelengthAxisOption = 2;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = 2.99792458E8 / this.frequencies[n - 1 - j];
        }
        this.setWavelength(dArray2);
    }

    public void setWavelength(double d, double d2, int n) {
        double d3 = (d2 - d) / (double)(n - 1);
        double[] dArray = new double[n];
        dArray[0] = d;
        for (int j = 1; j < n - 1; ++j) {
            dArray[j] = dArray[j - 1] + d3;
        }
        dArray[n - 1] = d2;
        this.setWavelength(dArray);
    }

    public void setFrequency(double d, double d2, int n) {
        double d3 = (d2 - d) / (double)(n - 1);
        double[] dArray = new double[n];
        dArray[0] = d;
        for (int j = 1; j < n - 1; ++j) {
            dArray[j] = dArray[j - 1] + d3;
        }
        dArray[n - 1] = d2;
        this.setFrequency(dArray);
    }

    public void setWavelength(double d) {
        double[] dArray = new double[]{d};
        this.setWavelength(dArray);
    }

    public void setFrequency(double d) {
        double[] dArray = new double[]{d};
        this.setFrequency(dArray);
    }

    public double[] getWavelengths() {
        return this.wavelengths;
    }

    public double[] getRadialFrequencies() {
        return this.omega;
    }

    private void sortWavelengths() {
        int n;
        this.origWavelIndices = new int[this.numberOfWavelengths];
        for (n = 0; n < this.numberOfWavelengths; ++n) {
            this.origWavelIndices[n] = n;
        }
        if (this.numberOfWavelengths > 1) {
            n = 1;
            boolean bl = false;
            int n2 = 1;
            while (n != 0) {
                if (this.wavelengths[n2] < this.wavelengths[n2 - 1]) {
                    n = 0;
                    bl = true;
                    continue;
                }
                if (++n2 < this.numberOfWavelengths) continue;
                n = 0;
            }
            if (bl) {
                int n3;
                int n4;
                ArrayList<Object> arrayList = Fmath.selectSortArrayList(this.wavelengths);
                this.wavelengths = (double[])arrayList.get(1);
                this.origWavelIndices = (int[])arrayList.get(2);
                Complex[][] complexArray = new Complex[this.numberOfWavelengths][this.numberOfLayers];
                for (n4 = 0; n4 < this.numberOfWavelengths; ++n4) {
                    for (n3 = 0; n3 < this.numberOfLayers; ++n3) {
                        complexArray[n4][n3] = this.refractiveIndices[this.origWavelIndices[n4]][n3];
                    }
                }
                this.refractiveIndices = Complex.copy(complexArray);
                for (n4 = 0; n4 < this.numberOfWavelengths; ++n4) {
                    for (n3 = 0; n3 < this.numberOfLayers; ++n3) {
                        complexArray[n4][n3] = this.relativeMagneticPermeabilities[this.origWavelIndices[n4]][n3];
                    }
                }
                this.relativeMagneticPermeabilities = Complex.copy(complexArray);
                double[][] dArray = new double[this.numberOfWavelengths][this.numberOfLayers];
                for (n3 = 0; n3 < this.numberOfWavelengths; ++n3) {
                    for (int j = 0; j < this.numberOfLayers; ++j) {
                        dArray[n3][j] = this.absorptionCoefficients[this.origWavelIndices[n3]][j];
                    }
                }
                this.absorptionCoefficients = dArray;
            }
        }
    }

    public void setRefractiveIndices(Complex[][] complexArray) {
        int n;
        int n2 = complexArray[0].length;
        if (n2 != this.numberOfLayers) {
            throw new IllegalArgumentException("Number of refractive indices layers, " + n2 + ", does not match the number of layers, " + this.numberOfLayers);
        }
        int n3 = complexArray.length;
        if (this.wavelSet && n3 != this.numberOfWavelengths) {
            throw new IllegalArgumentException("Number of refractive indices wavelength sets, " + n3 + ", does not match the number of wavelengths already set, " + this.numberOfWavelengths);
        }
        this.refractiveIndices = complexArray;
        for (n = 0; n < this.numberOfLayers; ++n) {
            this.refractLayerSet[n] = true;
        }
        this.refractSet = true;
        this.wavelNumberSet = true;
        for (n = 0; n < this.numberOfLayers; ++n) {
            Complex complex = Complex.zero();
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                complex.plusEquals(this.refractiveIndices[j][n]);
            }
            this.meanRefractiveIndices[n] = complex.over(this.numberOfWavelengths);
        }
        if (this.wavelSet && this.absorptionCoefficients != null) {
            for (n = 0; n < this.numberOfLayers; ++n) {
                for (int j = 0; j < this.numberOfWavelengths; ++j) {
                    if (this.refractiveIndices[j][n].getImag() != 0.0) continue;
                    this.refractiveIndices[j][n].setImag(this.absorptionCoefficients[j][n] * this.wavelengths[n] / (Math.PI * 4));
                }
            }
        }
        if (!this.absorbSet) {
            this.absorptionCoefficients = new double[this.numberOfWavelengths][this.numberOfLayers];
        }
        if (!this.magneticSet) {
            if (this.meanMagneticUsed) {
                for (n = 0; n < this.numberOfLayers; ++n) {
                    for (int j = 0; j < this.numberOfWavelengths; ++j) {
                        this.relativeMagneticPermeabilities[j][n] = this.meanRelativeMagneticPermeabilities[n];
                    }
                }
                this.magneticSet = true;
            } else {
                this.relativeMagneticPermeabilities = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers, 1.0, 0.0);
            }
        }
    }

    public void setRefractiveIndices(double[][] dArray) {
        int n = dArray[0].length;
        if (n != this.numberOfLayers) {
            throw new IllegalArgumentException("Number of refractive indices layers, " + n + ", does not match the number of layers, " + this.numberOfLayers);
        }
        int n2 = dArray.length;
        if (this.wavelSet && n2 != this.numberOfWavelengths) {
            throw new IllegalArgumentException("Number of refractive indices wavelength sets, " + n2 + ", does not match the number of wavelengths already set, " + this.numberOfWavelengths);
        }
        Complex[][] complexArray = Complex.twoDarray(n2, n);
        for (int j = 0; j < n2; ++j) {
            for (int k = 0; k < n; ++k) {
                complexArray[j][k].setReal(dArray[j][k]);
            }
        }
        this.setRefractiveIndices(complexArray);
    }

    public void setRefractiveIndices(Complex[] complexArray) {
        int n;
        int n2;
        int n3 = complexArray.length;
        if (n3 != this.numberOfLayers) {
            throw new IllegalArgumentException("Number of refrative indices layers, " + n3 + ", does not match the number of layers, " + this.numberOfLayers);
        }
        this.meanRefractiveIndices = complexArray;
        this.meanRefractUsed = true;
        if (this.wavelNumberSet) {
            for (n2 = 0; n2 < this.numberOfLayers; ++n2) {
                for (n = 0; n < this.numberOfWavelengths; ++n) {
                    this.refractiveIndices[n][n2] = this.meanRefractiveIndices[n2];
                }
            }
            for (n2 = 0; n2 < this.numberOfLayers; ++n2) {
                this.refractLayerSet[n2] = true;
            }
            this.refractSet = true;
        }
        if (this.absorptionCoefficients != null && this.wavelSet) {
            for (n2 = 0; n2 < this.numberOfLayers; ++n2) {
                for (n = 0; n < this.numberOfWavelengths; ++n) {
                    if (this.refractiveIndices[n][n2].getImag() != 0.0) continue;
                    this.refractiveIndices[n][n2].setImag(this.absorptionCoefficients[n][n2] * this.wavelengths[n] / (Math.PI * 4));
                }
            }
        }
        if (this.absorptionCoefficients == null) {
            this.absorptionCoefficients = new double[this.numberOfWavelengths][this.numberOfLayers];
        }
        if (!this.magneticSet) {
            if (!this.meanMagneticUsed) {
                if (this.wavelNumberSet) {
                    this.relativeMagneticPermeabilities = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers, 1.0, 0.0);
                }
            } else {
                this.relativeMagneticPermeabilities = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers);
                for (n2 = 0; n2 < this.numberOfLayers; ++n2) {
                    for (n = 0; n < this.numberOfWavelengths; ++n) {
                        this.relativeMagneticPermeabilities[n][n2] = this.meanRelativeMagneticPermeabilities[n2];
                    }
                }
                this.magneticSet = true;
            }
        }
    }

    public void setRefractiveIndices(double[] dArray) {
        int n = dArray.length;
        if (n != this.numberOfLayers) {
            throw new IllegalArgumentException("Number of refrative indices, " + n + ", does not match the number of layers, " + this.numberOfLayers);
        }
        Complex[] complexArray = Complex.oneDarray(n);
        for (int j = 0; j < n; ++j) {
            complexArray[j].setReal(dArray[j]);
        }
        this.setRefractiveIndices(complexArray);
    }

    public void setRefractiveIndices(Complex[] complexArray, int n) {
        int n2;
        int n3;
        if (n < 0 || n > this.numberOfLayers) {
            throw new IllegalArgumentException("Layer number, " + n + ", must be in the range 1 to " + this.numberOfLayers);
        }
        int n4 = complexArray.length;
        if (this.wavelNumberSet) {
            if (n4 != this.numberOfWavelengths) {
                throw new IllegalArgumentException("The number of refractive index wavelength values, " + n4 + ", does not match the number of wavelengths already entered, " + this.numberOfWavelengths);
            }
        } else {
            this.numberOfWavelengths = n4;
            this.wavelNumberSet = true;
            this.refractiveIndices = Complex.twoDarray(this.numberOfLayers, this.numberOfWavelengths);
            if (this.meanRefractUsed) {
                for (n3 = 0; n3 < this.numberOfLayers; ++n3) {
                    for (n2 = 0; n2 < this.numberOfWavelengths; ++n2) {
                        this.refractiveIndices[n2][n3] = this.meanRefractiveIndices[n3];
                    }
                }
                for (n3 = 0; n3 < this.numberOfLayers; ++n3) {
                    this.refractLayerSet[n3] = true;
                }
                this.refractSet = true;
            }
            this.relativeMagneticPermeabilities = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers, 1.0, 0.0);
            if (this.meanMagneticUsed) {
                for (n3 = 0; n3 < this.numberOfLayers; ++n3) {
                    for (n2 = 0; n2 < this.numberOfWavelengths; ++n2) {
                        this.relativeMagneticPermeabilities[n2][n3] = this.meanRelativeMagneticPermeabilities[n3];
                    }
                }
                this.magneticSet = true;
            }
        }
        this.refractiveIndices[--n] = complexArray;
        this.refractLayerSet[n] = true;
        n3 = 0;
        for (n2 = 0; n2 < this.numberOfLayers; ++n2) {
            if (!this.refractLayerSet[n2]) continue;
            ++n3;
        }
        if (n3 == this.numberOfLayers) {
            this.refractSet = true;
        }
        if (this.absorptionCoefficients != null) {
            for (n2 = 0; n2 < this.numberOfLayers; ++n2) {
                for (int j = 0; j < this.numberOfWavelengths; ++j) {
                    if (this.refractiveIndices[j][n2].getImag() != 0.0) continue;
                    this.refractiveIndices[j][n2].setImag(this.absorptionCoefficients[j][n2] * this.wavelengths[j] / (Math.PI * 4));
                }
            }
        }
        if (this.absorptionCoefficients == null) {
            this.absorptionCoefficients = new double[this.numberOfWavelengths][this.numberOfLayers];
        }
    }

    public void setRefractiveIndices(double[] dArray, int n) {
        if (n < 0 || n > this.numberOfLayers) {
            throw new IllegalArgumentException("Layer number, " + n + ", must be in the range 1 to " + this.numberOfLayers);
        }
        int n2 = dArray.length;
        if (this.wavelNumberSet && n2 != this.numberOfWavelengths) {
            throw new IllegalArgumentException("The number of refractive index wavelength values, " + n2 + ", does not match the number of wavelengths already entered, " + this.numberOfWavelengths);
        }
        Complex[] complexArray = Complex.oneDarray(n2);
        for (int j = 0; j < n2; ++j) {
            complexArray[j].setReal(dArray[j]);
        }
        this.setRefractiveIndices(complexArray, n);
    }

    public void setRefractiveIndices(Complex complex, int n) {
        if (this.wavelNumberSet) {
            Complex[] complexArray = Complex.oneDarray(this.numberOfWavelengths);
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                complexArray[j] = complex;
            }
            this.setRefractiveIndices(complexArray, n);
        } else {
            this.meanRefractiveIndices[n - 1] = complex;
            this.meanRefractUsed = true;
        }
    }

    public void setRefractiveIndices(double d, int n) {
        Complex complex = new Complex(d, 0.0);
        this.setRefractiveIndices(complex, n);
    }

    public Object getRefractiveIndices() {
        if (this.numberOfWavelengths == 1) {
            Complex[] complexArray = this.refractiveIndices[0];
            return complexArray;
        }
        return this.refractiveIndices;
    }

    public void setAbsorptionCoefficients(double[] dArray) {
        int n = dArray.length;
        if (n != this.numberOfLayers) {
            throw new IllegalArgumentException("Number of absorption coefficients sets, " + n + ", does not match the number of layers, " + this.numberOfLayers);
        }
        this.absorptionCoefficients = new double[1][n];
        this.absorptionCoefficients[0] = dArray;
        this.absorbSet = true;
        if (this.refractSet) {
            for (int j = 0; j < this.numberOfLayers; ++j) {
                if (this.refractiveIndices[0][j].getImag() != 0.0) continue;
                this.refractiveIndices[0][j].setImag(this.absorptionCoefficients[0][j] * this.wavelengths[0] / (Math.PI * 4));
            }
        }
    }

    public void setAbsorptionCoefficients(double[][] dArray) {
        int n = dArray[0].length;
        if (n != this.numberOfLayers) {
            throw new IllegalArgumentException("Number of absorption coefficients sets, " + n + ", does not match the number of layers, " + this.numberOfLayers);
        }
        int n2 = dArray.length;
        if (this.wavelNumberSet && n2 != this.numberOfWavelengths) {
            throw new IllegalArgumentException("Number of absorption coefficients wavelengths, " + n2 + ", does not match the number of wavelengths already entered, " + this.numberOfWavelengths);
        }
        this.absorptionCoefficients = dArray;
        this.absorbSet = true;
        if (this.refractSet && this.wavelSet) {
            for (int j = 0; j < this.numberOfLayers; ++j) {
                for (int k = 0; k < this.numberOfWavelengths; ++k) {
                    if (this.refractiveIndices[k][j].getImag() != 0.0) continue;
                    this.refractiveIndices[k][j].setImag(dArray[k][j] * this.wavelengths[k] / (Math.PI * 4));
                }
            }
        }
    }

    public void setAbsorptionCoefficients(double[] dArray, int n) {
        int n2 = dArray.length;
        if (this.wavelNumberSet) {
            if (n2 != this.numberOfWavelengths) {
                throw new IllegalArgumentException("Layer " + n + ": number of absorption coefficients wavelengths, " + n2 + ", does not match the number of wavelengths already entered, " + this.numberOfWavelengths);
            }
        } else {
            this.numberOfWavelengths = n2;
            this.refractiveIndices = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers);
            this.absorptionCoefficients = new double[this.numberOfWavelengths][this.numberOfLayers];
        }
        this.absorptionCoefficients[--n] = dArray;
        for (int j = 0; j < this.numberOfWavelengths; ++j) {
            if (this.refractiveIndices[j][n].getImag() != 0.0) continue;
            this.refractiveIndices[j][n].setImag(dArray[j] * this.wavelengths[j] / (Math.PI * 4));
        }
        this.absorbSet = true;
    }

    public void setAbsorptionCoefficients(double d, int n) {
        if (this.wavelNumberSet) {
            if (this.numberOfWavelengths != 1) {
                throw new IllegalArgumentException("Layer " + n + ": number of absorption coefficients wavelengths, " + 1 + ", does not match the number of wavelengths already entered, " + this.numberOfWavelengths);
            }
        } else {
            this.numberOfWavelengths = 1;
            this.refractiveIndices = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers);
            this.absorptionCoefficients = new double[this.numberOfWavelengths][this.numberOfLayers];
        }
        this.absorptionCoefficients[0][--n] = d;
        if (this.refractiveIndices[0][n].getImag() == 0.0) {
            this.refractiveIndices[0][n].setImag(d * this.wavelengths[0] / (Math.PI * 4));
        }
        this.absorbSet = true;
    }

    public Object getAbsorptionCoefficients() {
        double[][] dArray = this.absorptionCoefficients;
        for (int j = 0; j < this.numberOfLayers; ++j) {
            for (int k = 0; k < this.numberOfWavelengths; ++k) {
                dArray[j][k] = Math.PI * 4 * this.wavelengths[k] * this.refractiveIndices[j][k].getImag();
            }
        }
        if (this.numberOfWavelengths == 1) {
            double[] dArray2 = dArray[0];
            return dArray2;
        }
        return dArray;
    }

    public void setRelativeMagneticPermeabilities(Complex[][] complexArray) {
        int n = complexArray[0].length;
        if (n != this.numberOfLayers) {
            throw new IllegalArgumentException("Number of relative magnetic permeabilities, " + n + ", does not match the number of layers, " + this.numberOfLayers);
        }
        int n2 = complexArray.length;
        if (this.wavelNumberSet && n2 != this.numberOfWavelengths) {
            throw new IllegalArgumentException("Number of relative magnetic permeabilities associated wavelengths, " + n2 + ", does not match the number of wavelengths already entered, " + this.numberOfWavelengths);
        }
        this.relativeMagneticPermeabilities = complexArray;
        this.magneticSet = true;
        for (int j = 0; j < this.numberOfLayers; ++j) {
            Complex complex = Complex.zero();
            for (int k = 0; k < this.numberOfWavelengths; ++k) {
                complex.plusEquals(this.relativeMagneticPermeabilities[k][j]);
            }
            this.meanRelativeMagneticPermeabilities[j] = complex.over(this.numberOfWavelengths);
        }
    }

    public void relativeMagneticPermeabilities(double[][] dArray) {
        int n;
        int n2 = dArray[0].length;
        if (n2 != this.numberOfLayers) {
            throw new IllegalArgumentException("Number of relative magnetic permeabilities, " + n2 + ", does not match the number of layers, " + this.numberOfLayers);
        }
        int n3 = dArray.length;
        if (this.wavelNumberSet && n3 != this.numberOfWavelengths) {
            throw new IllegalArgumentException("Number of relative magnetic permeabilities associated wavelengths, " + n3 + ", does not match the number of wavelengths already entered, " + this.numberOfWavelengths);
        }
        this.relativeMagneticPermeabilities = Complex.twoDarray(n3, n2);
        for (n = 0; n < this.numberOfLayers; ++n) {
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                this.relativeMagneticPermeabilities[j][n].setReal(dArray[j][n]);
            }
        }
        this.magneticSet = true;
        for (n = 0; n < this.numberOfLayers; ++n) {
            Complex complex = Complex.zero();
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                complex.plusEquals(this.relativeMagneticPermeabilities[j][n]);
            }
            this.meanRelativeMagneticPermeabilities[n] = complex.over(this.numberOfWavelengths);
        }
    }

    public void setRelativeMagneticPermeabilities(Complex[] complexArray) {
        int n = complexArray.length;
        if (n != this.numberOfLayers) {
            throw new IllegalArgumentException("Number of relative magnetic permeabilities, " + n + ", does not match the number of layers, " + this.numberOfLayers);
        }
        this.meanRelativeMagneticPermeabilities = complexArray;
        this.meanMagneticUsed = true;
        if (this.wavelNumberSet) {
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                this.relativeMagneticPermeabilities[j] = Complex.copy(complexArray);
            }
        }
    }

    public void setRelativeMagneticPermeabilities(double[] dArray) {
        int n;
        int n2 = dArray.length;
        if (n2 != this.numberOfLayers) {
            throw new IllegalArgumentException("Number of relative magnetic permeabilities, " + n2 + ", does not match the number of layers, " + this.numberOfLayers);
        }
        for (n = 0; n < n2; ++n) {
            this.meanRelativeMagneticPermeabilities[n].setReal(dArray[n]);
        }
        this.meanMagneticUsed = true;
        if (this.wavelNumberSet) {
            for (n = 0; n < this.numberOfWavelengths; ++n) {
                this.relativeMagneticPermeabilities[n] = Complex.copy(this.meanRelativeMagneticPermeabilities);
            }
        }
    }

    public void setRelativeMagneticPermeabilities(Complex[] complexArray, int n) {
        int n2 = complexArray.length;
        if (this.wavelNumberSet && n2 != this.numberOfWavelengths) {
            throw new IllegalArgumentException("Layer " + n + ": number of relative magnetic permeabilities associated wavelengths, " + n2 + ", does not match the number of wavelengths already entered, " + this.numberOfWavelengths);
        }
        if (this.relativeMagneticPermeabilities == null) {
            this.relativeMagneticPermeabilities = Complex.twoDarray(n2, this.numberOfLayers);
        }
        this.relativeMagneticPermeabilities[n - 1] = complexArray;
        Complex complex = Complex.zero();
        for (int j = 0; j < n2; ++j) {
            complex.plusEquals(this.relativeMagneticPermeabilities[j][n - 1]);
        }
        this.meanRelativeMagneticPermeabilities[n - 1] = complex.over(n2);
    }

    public void setRelativeMagneticPermeabilities(double[] dArray, int n) {
        int n2 = dArray.length;
        if (this.wavelNumberSet && n2 != this.numberOfWavelengths) {
            throw new IllegalArgumentException("Layer " + n + ": number of relative magnetic permeabilities associated wavelengths, " + n2 + ", does not match the number of wavelengths already entered, " + this.numberOfWavelengths);
        }
        if (this.relativeMagneticPermeabilities == null) {
            this.relativeMagneticPermeabilities = Complex.twoDarray(n2, this.numberOfLayers);
        }
        for (int j = 0; j < n2; ++j) {
            this.relativeMagneticPermeabilities[j][n - 1].setReal(dArray[j]);
        }
        Complex complex = Complex.zero();
        for (int j = 0; j < n2; ++j) {
            complex.plusEquals(this.relativeMagneticPermeabilities[j][n - 1]);
        }
        this.meanRelativeMagneticPermeabilities[n - 1] = complex.over(n2);
    }

    public void setRelativeMagneticPermeabilities(Complex complex, int n) {
        this.meanRelativeMagneticPermeabilities[n - 1] = complex;
        this.meanMagneticUsed = true;
        if (this.relativeMagneticPermeabilities != null) {
            int n2 = this.relativeMagneticPermeabilities[0].length;
            for (int j = 0; j < n2; ++j) {
                this.relativeMagneticPermeabilities[j][n - 1] = complex;
            }
        }
    }

    public void setRelativeMagneticPermeabilities(double d, int n) {
        this.meanRelativeMagneticPermeabilities[n - 1].setReal(d);
        this.meanMagneticUsed = true;
        if (this.relativeMagneticPermeabilities != null) {
            int n2 = this.relativeMagneticPermeabilities[0].length;
            for (int j = 0; j < n2; ++j) {
                this.relativeMagneticPermeabilities[j][n - 1] = this.meanRelativeMagneticPermeabilities[n - 1];
            }
        }
    }

    public Object getRelativeMagneticPermeabilities() {
        if (this.numberOfWavelengths == 1) {
            Complex[] complexArray = this.relativeMagneticPermeabilities[0];
            return complexArray;
        }
        return this.relativeMagneticPermeabilities;
    }

    public Object getReflectivities() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.reflectivities[0];
        }
        if (this.angularReflectCalculated) {
            return this.reflectivities[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] dArray = new double[this.numberOfWavelengths];
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                dArray[j] = this.reflectivities[j][0];
            }
            return dArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.reflectivities;
        }
        return null;
    }

    public Object getTEreflectionCoefficients() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.reflectCoeffTE[0];
        }
        if (this.angularReflectCalculated) {
            return this.reflectCoeffTE[0];
        }
        if (this.wavelengthReflectCalculated) {
            Complex[] complexArray = Complex.oneDarray(this.numberOfWavelengths);
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                complexArray[j] = this.reflectCoeffTE[j][0];
            }
            return complexArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.reflectCoeffTE;
        }
        return null;
    }

    public Object getTMreflectionCoefficients() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.reflectCoeffTM[0];
        }
        if (this.angularReflectCalculated) {
            return this.reflectCoeffTM[0];
        }
        if (this.wavelengthReflectCalculated) {
            Complex[] complexArray = Complex.oneDarray(this.numberOfWavelengths);
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                complexArray[j] = this.reflectCoeffTM[j][0];
            }
            return complexArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.reflectCoeffTM;
        }
        return null;
    }

    public Object getTransmissivities() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.transmissivities[0];
        }
        if (this.angularReflectCalculated) {
            return this.transmissivities[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] dArray = new double[this.numberOfWavelengths];
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                dArray[j] = this.transmissivities[j][0];
            }
            return dArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.transmissivities;
        }
        return null;
    }

    public Object getPowerLoss() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.powerLosses[0];
        }
        if (this.angularReflectCalculated) {
            return this.powerLosses[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] dArray = new double[this.numberOfWavelengths];
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                dArray[j] = this.powerLosses[j][0];
            }
            return dArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.powerLosses;
        }
        return null;
    }

    public Object getTransmissionAnglesInRadians() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.transmitAnglesRad[0];
        }
        if (this.angularReflectCalculated) {
            return this.transmitAnglesRad[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] dArray = new double[this.numberOfWavelengths];
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                dArray[j] = this.transmitAnglesRad[j][0];
            }
            return dArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.transmitAnglesRad;
        }
        return null;
    }

    public Object getTransmissionAnglesInDegrees() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.transmitAnglesDeg[0];
        }
        if (this.angularReflectCalculated) {
            return this.transmitAnglesDeg[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] dArray = new double[this.numberOfWavelengths];
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                dArray[j] = this.transmitAnglesDeg[j][0];
            }
            return dArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.transmitAnglesDeg;
        }
        return null;
    }

    public Object getTEtransmissionCoefficients() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.transmitCoeffTE[0];
        }
        if (this.angularReflectCalculated) {
            return this.transmitCoeffTE[0];
        }
        if (this.wavelengthReflectCalculated) {
            Complex[] complexArray = Complex.oneDarray(this.numberOfWavelengths);
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                complexArray[j] = this.transmitCoeffTE[j][0];
            }
            return complexArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.transmitCoeffTE;
        }
        return null;
    }

    public Object getTMtransmissionCoefficients() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.transmitCoeffTM[0];
        }
        if (this.angularReflectCalculated) {
            return this.transmitCoeffTM[0];
        }
        if (this.wavelengthReflectCalculated) {
            Complex[] complexArray = Complex.oneDarray(this.numberOfWavelengths);
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                complexArray[j] = this.transmitCoeffTM[j][0];
            }
            return complexArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.transmitCoeffTM;
        }
        return null;
    }

    public Object getTEreflectionPhaseShiftDeg() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.reflectPhaseShiftDegTE[0];
        }
        if (this.angularReflectCalculated) {
            return this.reflectPhaseShiftDegTE[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] dArray = new double[this.numberOfWavelengths];
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                dArray[j] = this.reflectPhaseShiftDegTE[j][0];
            }
            return dArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.reflectPhaseShiftDegTE;
        }
        return null;
    }

    public Object getTEreflectionPhaseShiftRad() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.reflectPhaseShiftRadTE[0];
        }
        if (this.angularReflectCalculated) {
            return this.reflectPhaseShiftRadTE[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] dArray = new double[this.numberOfWavelengths];
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                dArray[j] = this.reflectPhaseShiftRadTE[j][0];
            }
            return dArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.reflectPhaseShiftRadTE;
        }
        return null;
    }

    public Object getTMreflectionPhaseShiftDeg() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.reflectPhaseShiftDegTM[0];
        }
        if (this.angularReflectCalculated) {
            return this.reflectPhaseShiftDegTM[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] dArray = new double[this.numberOfWavelengths];
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                dArray[j] = this.reflectPhaseShiftDegTM[j][0];
            }
            return dArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.reflectPhaseShiftDegTM;
        }
        return null;
    }

    public Object getTMreflectionPhaseShiftRad() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.reflectPhaseShiftRadTM[0];
        }
        if (this.angularReflectCalculated) {
            return this.reflectPhaseShiftRadTM[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] dArray = new double[this.numberOfWavelengths];
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                dArray[j] = this.reflectPhaseShiftRadTM[j][0];
            }
            return dArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.reflectPhaseShiftRadTM;
        }
        return null;
    }

    public Object getTEtransmissionPhaseShiftDeg() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.transmitPhaseShiftDegTE[0];
        }
        if (this.angularReflectCalculated) {
            return this.transmitPhaseShiftDegTE[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] dArray = new double[this.numberOfWavelengths];
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                dArray[j] = this.transmitPhaseShiftDegTE[j][0];
            }
            return dArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.transmitPhaseShiftDegTE;
        }
        return null;
    }

    public Object getTEtransmissionPhaseShiftRad() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.transmitPhaseShiftRadTE[0];
        }
        if (this.angularReflectCalculated) {
            return this.transmitPhaseShiftRadTE[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] dArray = new double[this.numberOfWavelengths];
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                dArray[j] = this.transmitPhaseShiftRadTE[j][0];
            }
            return dArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.transmitPhaseShiftRadTE;
        }
        return null;
    }

    public Object getTMtransmissionPhaseShiftDeg() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.transmitPhaseShiftDegTM[0];
        }
        if (this.angularReflectCalculated) {
            return this.transmitPhaseShiftDegTM[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] dArray = new double[this.numberOfWavelengths];
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                dArray[j] = this.transmitPhaseShiftDegTM[j][0];
            }
            return dArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.transmitPhaseShiftDegTM;
        }
        return null;
    }

    public Object getTMtransmissionPhaseShiftRad() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.transmitPhaseShiftRadTM[0];
        }
        if (this.angularReflectCalculated) {
            return this.transmitPhaseShiftRadTM[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] dArray = new double[this.numberOfWavelengths];
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                dArray[j] = this.transmitPhaseShiftRadTM[j][0];
            }
            return dArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.transmitPhaseShiftRadTM;
        }
        return null;
    }

    public Object getEvanescentFields(double d) {
        this.fieldDistance = d;
        return this.getEvanescentFields();
    }

    public Object getEvanescentFields() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.evanescentFields[0];
        }
        if (this.angularReflectCalculated) {
            return this.evanescentFields[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] dArray = new double[this.numberOfWavelengths];
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                dArray[j] = this.evanescentFields[j][0];
            }
            return dArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.evanescentFields;
        }
        return null;
    }

    public Object getPenetrationDepths() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.penetrationDepths[0];
        }
        if (this.angularReflectCalculated) {
            return this.penetrationDepths[0];
        }
        if (this.wavelengthReflectCalculated) {
            double[] dArray = new double[this.numberOfWavelengths];
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                dArray[j] = this.penetrationDepths[j][0];
            }
            return dArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.penetrationDepths;
        }
        return null;
    }

    public Object getKoVectors() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.koVector[0][0][0];
        }
        if (this.angularReflectCalculated) {
            return this.koVector[0][0][0];
        }
        if (this.wavelengthReflectCalculated) {
            Complex[] complexArray = Complex.oneDarray(this.numberOfWavelengths);
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                complexArray[j] = this.koVector[j][0][0];
            }
            return complexArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            Complex[] complexArray = Complex.oneDarray(this.numberOfWavelengths);
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                complexArray[j] = this.koVector[j][0][0];
            }
            return complexArray;
        }
        return null;
    }

    public Object getKzVectors() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.kzVector[0][0][0];
        }
        if (this.angularReflectCalculated) {
            Complex[] complexArray = Complex.oneDarray(this.numberOfIncidentAngles);
            for (int j = 0; j < this.numberOfIncidentAngles; ++j) {
                complexArray[j] = this.kzVector[0][j][0];
            }
            return complexArray;
        }
        if (this.wavelengthReflectCalculated) {
            Complex[] complexArray = Complex.oneDarray(this.numberOfWavelengths);
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                complexArray[j] = this.kzVector[j][0][0];
            }
            return complexArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            Complex[][] complexArray = Complex.twoDarray(this.numberOfWavelengths, this.numberOfIncidentAngles);
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                for (int k = 0; k < this.numberOfIncidentAngles; ++k) {
                    complexArray[j][k] = this.kzVector[j][k][0];
                }
            }
            return complexArray;
        }
        return null;
    }

    public Object getKvectors() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.kVector[0][0];
        }
        if (this.angularReflectCalculated) {
            return this.kVector[0];
        }
        if (this.wavelengthReflectCalculated) {
            Complex[][] complexArray = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers);
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                int n = 0;
                while (j < this.numberOfLayers) {
                    complexArray[j][n] = this.kVector[j][0][n];
                    ++j;
                }
            }
            return complexArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            Complex[][] complexArray = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers);
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                int n = 0;
                while (j < this.numberOfLayers) {
                    complexArray[j][n] = this.kVector[j][0][n];
                    ++j;
                }
            }
            return complexArray;
        }
        return null;
    }

    public Object getKxVectors() {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            return this.kxVector[0][0];
        }
        if (this.angularReflectCalculated) {
            return this.kxVector[0];
        }
        if (this.wavelengthReflectCalculated) {
            Complex[][] complexArray = Complex.twoDarray(this.numberOfWavelengths, this.numberOfLayers);
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                int n = 0;
                while (j < this.numberOfLayers) {
                    complexArray[j][n] = this.kxVector[j][0][n];
                    ++j;
                }
            }
            return complexArray;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            return this.kxVector;
        }
        return null;
    }

    public void resetPlotAxisAsFrequency() {
        this.wavelengthAxisOption = 2;
    }

    public void resetPlotAxisAsRadians() {
        this.wavelengthAxisOption = 3;
    }

    public void resetPlotAxisAsWavelength() {
        this.wavelengthAxisOption = 1;
    }

    public void plotReflectivities() {
        String string = "Polarisation mode: " + this.mode;
        this.plotReflectivities(string);
    }

    public void plotReflectivities(String string) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        String string2 = " Reflectivities";
        String string3 = "Reflectivity";
        String string4 = " ";
        this.plotSimulation(string, string2, string3, string4, this.reflectivities);
    }

    public void plotTransmissivities() {
        String string = "Polarisation mode: " + this.mode;
        this.plotTransmissivities(string);
    }

    public void plotTransmissivities(String string) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        String string2 = " Transmissivities";
        String string3 = "Transmissivity";
        String string4 = " ";
        this.plotSimulation(string, string2, string3, string4, this.transmissivities);
    }

    public void plotPowerLosses() {
        String string = "Polarisation mode: " + this.mode;
        this.plotPowerLosses(string);
    }

    public void plotPowerLosses(String string) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        String string2 = " Power Losses in decibels relative to an incident power of 1 mW";
        String string3 = "Power Losses";
        String string4 = "dBm";
        this.plotSimulation(string, string2, string3, string4, this.powerLosses);
    }

    public void plotTransmissionAngles() {
        String string = "Polarisation mode: " + this.mode;
        this.plotTransmissionAngles(string);
    }

    public void plotTransmissionAngles(String string) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        String string2 = " Transmission angles (degrees)";
        String string3 = "Transmission angle";
        String string4 = "degrees";
        this.plotSimulation(string, string2, string3, string4, this.transmitAnglesDeg);
    }

    public void plotAbsTEreflectionCoefficients() {
        String string = "Polarisation mode: " + this.mode;
        this.plotAbsTEreflectionCoefficients(string);
    }

    public void plotAbsTEreflectionCoefficients(String string) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.teFraction == 0.0) {
            System.out.println("No TE transmission coefficient plot displayed as no light in the TE mode");
        } else {
            double[][] dArray = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                for (int k = 0; k < this.numberOfIncidentAngles; ++k) {
                    dArray[j][k] = this.reflectCoeffTE[j][k].abs();
                }
            }
            String string2 = " Absolute values of the TE reflection coefficients";
            String string3 = "|TE Reflection Coefficient|";
            String string4 = " ";
            this.plotSimulation(string, string2, string3, string4, dArray);
        }
    }

    public void plotAbsTMreflectionCoefficients() {
        String string = "Polarisation mode: " + this.mode;
        this.plotAbsTMreflectionCoefficients(string);
    }

    public void plotAbsTMreflectionCoefficients(String string) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.tmFraction == 0.0) {
            System.out.println("No TM transmission coefficient plot displayed as no light in the TM mode");
        } else {
            double[][] dArray = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                for (int k = 0; k < this.numberOfIncidentAngles; ++k) {
                    dArray[j][k] = this.reflectCoeffTM[j][k].abs();
                }
            }
            String string2 = " Absolute values of the TM reflection coefficients";
            String string3 = "|TM Reflection Coefficient|";
            String string4 = " ";
            this.plotSimulation(string, string2, string3, string4, dArray);
        }
    }

    public void plotAbsTEtransmissionCoefficients() {
        String string = "Polarisation mode: " + this.mode;
        this.plotAbsTEtransmissionCoefficients(string);
    }

    public void plotAbsTEtransmissionCoefficients(String string) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.teFraction == 0.0) {
            System.out.println("No TE transmission coefficient plot displayed as no light in the TE mode");
        } else {
            double[][] dArray = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                for (int k = 0; k < this.numberOfIncidentAngles; ++k) {
                    dArray[j][k] = this.transmitCoeffTE[j][k].abs();
                }
            }
            String string2 = " Absolute values of the TE transmission coefficients";
            String string3 = "|TE Transmission Coefficient|";
            String string4 = " ";
            this.plotSimulation(string, string2, string3, string4, dArray);
        }
    }

    public void plotAbsTMtransmissionCoefficients() {
        String string = "Polarisation mode: " + this.mode;
        this.plotAbsTMtransmissionCoefficients(string);
    }

    public void plotAbsTMtransmissionCoefficients(String string) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.tmFraction == 0.0) {
            System.out.println("No TM transmission coefficient plot displayed as no light in the TM mode");
        } else {
            double[][] dArray = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                for (int k = 0; k < this.numberOfIncidentAngles; ++k) {
                    dArray[j][k] = this.transmitCoeffTM[j][k].abs();
                }
            }
            String string2 = " Absolute values of the TM transmission coefficients";
            String string3 = "|TM Transmission Coefficient|";
            String string4 = " ";
            this.plotSimulation(string, string2, string3, string4, dArray);
        }
    }

    public void plotEvanescentFields() {
        String string = "Polarisation mode: " + this.mode;
        this.plotEvanescentFields(string);
    }

    public void plotEvanescentFields(double d) {
        this.fieldDistance = this.fieldDistance;
        String string = "Polarisation mode: " + this.mode;
        this.plotEvanescentFields(string);
    }

    public void plotEvanescentFields(double d, String string) {
        this.fieldDistance = d;
        this.plotEvanescentFields(string);
    }

    public void plotEvanescentFields(String string) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        String string2 = " Integrated Evanescent Field Intensities to a depth of " + this.fieldDistance + " metres";
        String string3 = "Evanescent Field intensity";
        String string4 = " ";
        this.plotSimulation(string, string2, string3, string4, this.evanescentFields);
    }

    public void plotPenetrationDepths() {
        String string = "Polarisation mode: " + this.mode;
        this.plotPenetrationDepths(string);
    }

    public void plotPenetrationDepths(String string) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        String string2 = " Evanescent Field Penetration Depths";
        String string3 = "Penetration Depth";
        String string4 = "metres";
        this.plotSimulation(string, string2, string3, string4, this.penetrationDepths);
    }

    public void plotTEreflectionPhaseShiftDeg() {
        String string = "Polarisation mode: " + this.mode;
        this.plotTEreflectionPhaseShiftDeg(string);
    }

    public void plotTEreflectionPhaseShiftDeg(String string) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.teFraction == 0.0) {
            System.out.println("No TE phase shift plot displayed as no light in the TE mode");
        } else {
            String string2 = " Phase Shift on Reflection (TE mode)";
            String string3 = "Phase shift";
            String string4 = "degrees ";
            this.plotSimulation(string, string2, string3, string4, this.reflectPhaseShiftDegTE);
        }
    }

    public void plotTMreflectionPhaseShiftDeg() {
        String string = "Polarisation mode: " + this.mode;
        this.plotTMreflectionPhaseShiftDeg(string);
    }

    public void plotTMreflectionPhaseShiftDeg(String string) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.tmFraction == 0.0) {
            System.out.println("No TM phase shift plot displayed as no light in the TM mode");
        } else {
            String string2 = " Phase Shift on Reflection (TM mode)";
            String string3 = "Phase shift";
            String string4 = "degrees ";
            this.plotSimulation(string, string2, string3, string4, this.reflectPhaseShiftDegTM);
        }
    }

    public void plotTEreflectionPhaseShiftRad() {
        String string = "Polarisation mode: " + this.mode;
        this.plotTEreflectionPhaseShiftRad(string);
    }

    public void plotTEreflectionPhaseShiftRad(String string) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.teFraction == 0.0) {
            System.out.println("No TE phase shift plot displayed as no light in the TE mode");
        } else {
            String string2 = " Phase Shift on Reflection (TE mode)";
            String string3 = "Phase shift";
            String string4 = "radians ";
            this.plotSimulation(string, string2, string3, string4, this.reflectPhaseShiftRadTE);
        }
    }

    public void plotTMreflectionPhaseShiftRad() {
        String string = "Polarisation mode: " + this.mode;
        this.plotTMreflectionPhaseShiftRad(string);
    }

    public void plotTMreflectionPhaseShiftRad(String string) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.tmFraction == 0.0) {
            System.out.println("No TM phase shift plot displayed as no light in the TM mode");
        } else {
            String string2 = " Phase Shift on Reflection (TM mode)";
            String string3 = "Phase shift";
            String string4 = "radians ";
            this.plotSimulation(string, string2, string3, string4, this.reflectPhaseShiftRadTM);
        }
    }

    public void plotTEtransmissionPhaseShiftDeg() {
        String string = "Polarisation mode: " + this.mode;
        this.plotTEtransmissionPhaseShiftDeg(string);
    }

    public void plotTEtransmissionPhaseShiftDeg(String string) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.teFraction == 0.0) {
            System.out.println("No TE phase shift plot displayed as no light in the TE mode");
        } else {
            String string2 = " Phase Shift on Transmission (TE mode)";
            String string3 = "Phase shift";
            String string4 = "degrees ";
            this.plotSimulation(string, string2, string3, string4, this.transmitPhaseShiftDegTE);
        }
    }

    public void plotTMtransmissionPhaseShiftDeg() {
        String string = "Polarisation mode: " + this.mode;
        this.plotTMtransmissionPhaseShiftDeg(string);
    }

    public void plotTMtransmissionPhaseShiftDeg(String string) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.tmFraction == 0.0) {
            System.out.println("No TM phase shift plot displayed as no light in the TM mode");
        } else {
            String string2 = " Phase Shift on Transmission (TM mode)";
            String string3 = "Phase shift";
            String string4 = "degrees ";
            this.plotSimulation(string, string2, string3, string4, this.transmitPhaseShiftDegTM);
        }
    }

    public void plotTEtransmissionPhaseShiftRad() {
        String string = "Polarisation mode: " + this.mode;
        this.plotTEtransmissionPhaseShiftRad(string);
    }

    public void plotTEtransmissionPhaseShiftRad(String string) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.teFraction == 0.0) {
            System.out.println("No TE phase shift plot displayed as no light in the TE mode");
        } else {
            String string2 = " Phase Shift on Transmission (TE mode)";
            String string3 = "Phase shift";
            String string4 = "radians ";
            this.plotSimulation(string, string2, string3, string4, this.transmitPhaseShiftRadTE);
        }
    }

    public void plotTMtransmissionPhaseShiftRad() {
        String string = "Polarisation mode: " + this.mode;
        this.plotTMtransmissionPhaseShiftRad(string);
    }

    public void plotTMtransmissionPhaseShiftRad(String string) {
        this.checkWhichCalculation();
        if (this.singleReflectCalculated) {
            throw new IllegalArgumentException("Plot methods require more than one data point");
        }
        if (this.tmFraction == 0.0) {
            System.out.println("No TM phase shift plot displayed as no light in the TM mode");
        } else {
            String string2 = " Phase Shift on Transmission (TM mode)";
            String string3 = "Phase shift";
            String string4 = "radians ";
            this.plotSimulation(string, string2, string3, string4, this.transmitPhaseShiftRadTM);
        }
    }

    public void plotSimulation(String string, String string2, String string3, String string4, Object object) {
        Object object2;
        Object object3 = object;
        int n = 1;
        while (!((object3 = Array.get(object3, 0)) instanceof Double)) {
            ++n;
        }
        Object object4 = new double[n][];
        if (n == 1) {
            double[] dArray;
            object4[0] = dArray = (double[])object;
        } else {
            object4 = (double[][])object;
        }
        int n2 = ((double[][])object4).length;
        int[] nArray = null;
        double[][] dArray = null;
        String string5 = null;
        String string6 = null;
        if (this.angularReflectCalculated) {
            nArray = new int[]{1};
            dArray = new double[2][n2];
            dArray[0] = this.incidentAngleDeg;
            dArray[1] = object4[0];
            string5 = "Incident Angle";
            string6 = "degrees";
        }
        if (this.wavelengthReflectCalculated) {
            int n3;
            nArray = new int[]{1};
            dArray = new double[2][n2];
            dArray[0] = this.wavelengths;
            object2 = new double[this.numberOfWavelengths];
            for (n3 = 0; n3 < this.numberOfWavelengths; ++n3) {
                object2[n3] = object4[n3][0];
            }
            switch (this.wavelengthAxisOption) {
                case 1: {
                    dArray[0] = this.wavelengths;
                    dArray[1] = (double[])object2;
                    string5 = "Wavelength";
                    string6 = "metres";
                    break;
                }
                case 2: {
                    dArray[0] = this.frequencies;
                    for (n3 = 0; n3 < this.numberOfWavelengths; ++n3) {
                        dArray[1][this.numberOfWavelengths - 1 - n3] = (double)object2[n3];
                    }
                    string5 = "Frequency";
                    string6 = "Hz";
                    break;
                }
                case 3: {
                    dArray[0] = this.omega;
                    for (n3 = 0; n3 < this.numberOfWavelengths; ++n3) {
                        dArray[1][this.numberOfWavelengths - 1 - n3] = (double)object2[n3];
                    }
                    string5 = "Radial Frequency";
                    string6 = "radians";
                }
            }
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            nArray = new int[n];
            dArray = new double[2 * n][n2];
            for (int j = 0; j < n; ++j) {
                nArray[j] = j + 1;
                dArray[2 * j] = this.incidentAngleDeg;
                dArray[2 * j + 1] = object4[j];
            }
            string5 = "Incident Angle";
            string6 = "degrees";
        }
        object2 = new PlotGraph(dArray);
        ((Plot)object2).setGraphTitle("Class Reflectivity: Simulation Plot - " + string2);
        ((Plot)object2).setGraphTitle2(string);
        ((Plot)object2).setXaxisLegend(string5);
        ((Plot)object2).setYaxisLegend(string3);
        ((Plot)object2).setXaxisUnitsName(string6);
        if (!string4.equals(" ")) {
            ((Plot)object2).setYaxisUnitsName(string4);
        }
        ((Plot)object2).setLine(3);
        ((Plot)object2).setPoint(nArray);
        ((PlotGraph)object2).plot();
    }

    public void checkWhichCalculation() {
        boolean bl = false;
        if (this.singleReflectCalculated) {
            bl = true;
        }
        if (this.angularReflectCalculated) {
            bl = true;
        }
        if (this.wavelengthReflectCalculated) {
            bl = true;
        }
        if (this.wavelengthAndAngularReflectCalculated) {
            bl = true;
        }
        if (bl) {
            if (this.fieldDistance != Double.POSITIVE_INFINITY && !this.fieldIntensityCalc) {
                int n = this.numberOfLayers - 1;
                double d = 0.0;
                for (int j = 0; j < this.numberOfWavelengths; ++j) {
                    for (int k = 0; k < this.numberOfIncidentAngles; ++k) {
                        if (this.kxVector[j][k][n].getReal() != 0.0) continue;
                        double d2 = 1.0 / this.kxVector[j][k][n].getImag();
                        d += this.teFraction * Fmath.square(this.transmitCoeffTE[j][k].abs()) * (1.0 - Math.exp(-2.0 * this.fieldDistance / d2)) * d2 / 2.0;
                        double d3 = this.refractiveIndices[j][0].getReal() / this.refractiveIndices[j][k].getReal();
                        double d4 = Math.sqrt(this.relativeMagneticPermeabilities[j][n].getReal() / this.relativeMagneticPermeabilities[j][0].getReal());
                        d += this.teFraction * Fmath.square(this.transmitCoeffTM[j][k].abs()) * d4 * d3 * (1.0 - Math.exp(-2.0 * this.fieldDistance / d2)) * d2 / 2.0;
                    }
                }
                this.fieldIntensityCalc = true;
            }
        } else {
            if (this.numberOfIncidentAngles == 0) {
                throw new IllegalArgumentException("No incident angle/s has/have been entered");
            }
            if (this.numberOfWavelengths == 0) {
                throw new IllegalArgumentException("No wavelength/s has/have been entered");
            }
            if (this.numberOfWavelengths > 1) {
                this.sortWavelengths();
            }
            this.koVector = Complex.threeDarray(this.numberOfWavelengths, this.numberOfIncidentAngles, this.numberOfLayers);
            this.kzVector = Complex.threeDarray(this.numberOfWavelengths, this.numberOfIncidentAngles, this.numberOfLayers);
            this.kVector = Complex.threeDarray(this.numberOfWavelengths, this.numberOfIncidentAngles, this.numberOfLayers);
            this.kxVector = Complex.threeDarray(this.numberOfWavelengths, this.numberOfIncidentAngles, this.numberOfLayers);
            for (int j = 0; j < this.numberOfWavelengths; ++j) {
                for (int k = 0; k < this.numberOfIncidentAngles; ++k) {
                    for (int i2 = 0; i2 < this.numberOfLayers; ++i2) {
                        this.koVector[j][k][i2].reset(Math.PI * 2 / this.wavelengths[j], 0.0);
                        this.kVector[j][k][i2] = this.koVector[j][k][i2].times(this.refractiveIndices[j][i2]).times(Complex.sqrt(this.relativeMagneticPermeabilities[j][i2]));
                        this.kzVector[j][k][i2] = this.koVector[j][k][i2].times(this.refractiveIndices[j][0]).times(Complex.sqrt(this.relativeMagneticPermeabilities[j][0]));
                        this.kzVector[j][k][i2] = this.kzVector[j][k][i2].times(Math.sin(this.incidentAngleRad[k]));
                        this.kxVector[j][k][i2] = Complex.square(this.kVector[j][k][i2]).minus(Complex.square(this.kzVector[j][k][i2]));
                        this.kxVector[j][k][i2] = Complex.sqrt(this.kxVector[j][k][i2]);
                    }
                }
            }
            this.reflectivities = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.transmissivities = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.powerLosses = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.reflectCoeffTE = Complex.twoDarray(this.numberOfWavelengths, this.numberOfIncidentAngles);
            this.reflectCoeffTM = Complex.twoDarray(this.numberOfWavelengths, this.numberOfIncidentAngles);
            this.transmitCoeffTE = Complex.twoDarray(this.numberOfWavelengths, this.numberOfIncidentAngles);
            this.transmitCoeffTM = Complex.twoDarray(this.numberOfWavelengths, this.numberOfIncidentAngles);
            this.evanescentFields = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.penetrationDepths = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.transmitAnglesRad = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.transmitAnglesDeg = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.reflectPhaseShiftRadTE = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.reflectPhaseShiftRadTM = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.reflectPhaseShiftDegTE = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.reflectPhaseShiftDegTM = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.transmitPhaseShiftRadTE = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.transmitPhaseShiftRadTM = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.transmitPhaseShiftDegTE = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.transmitPhaseShiftDegTM = new double[this.numberOfWavelengths][this.numberOfIncidentAngles];
            this.scan();
        }
    }

    public void scan() {
        if (!this.wavelSet) {
            throw new IllegalArgumentException("No wavelength has been entered");
        }
        if (!this.refractSet) {
            throw new IllegalArgumentException("No, or not all, refractive indices have been entered");
        }
        if (!this.thickSet) {
            throw new IllegalArgumentException("No, or not all, layer thicknesses have been entered");
        }
        if (!this.incidentAngleSet) {
            throw new IllegalArgumentException("No incident angle has been entered");
        }
        if (!this.modeSet) {
            throw new IllegalArgumentException("No polaristaion mode (TE, TM, unpolarised or mixed[angle to be entered]) has been entered");
        }
        this.singleReflectCalculated = false;
        this.angularReflectCalculated = false;
        this.wavelengthReflectCalculated = false;
        this.wavelengthAndAngularReflectCalculated = false;
        for (int j = 0; j < this.numberOfWavelengths; ++j) {
            for (int k = 0; k < this.numberOfIncidentAngles; ++k) {
                this.calcReflectivity(j, k);
            }
        }
        if (this.numberOfWavelengths == 1) {
            if (this.numberOfIncidentAngles == 1) {
                this.singleReflectCalculated = true;
            } else {
                this.angularReflectCalculated = true;
            }
        } else if (this.numberOfIncidentAngles == 1) {
            this.wavelengthReflectCalculated = true;
        } else {
            this.wavelengthAndAngularReflectCalculated = true;
        }
    }

    public void calcReflectivity(int n, int n2) {
        double[] dArray = new double[6];
        if (this.teFraction > 0.0) {
            dArray = this.calcTEreflectivity(n, n2);
        }
        if (this.tmFraction > 0.0) {
            double[] dArray2 = this.calcTMreflectivity(n, n2);
            dArray[0] = this.teFraction * dArray[0] + this.tmFraction * dArray2[0];
            dArray[1] = this.teFraction * dArray[1] + this.tmFraction * dArray2[1];
            dArray[2] = this.teFraction * dArray[2] + this.tmFraction * dArray2[2];
            dArray[3] = this.teFraction * dArray[3] + this.tmFraction * dArray2[3];
            dArray[4] = this.teFraction * dArray[4] + this.tmFraction * dArray2[4];
            dArray[5] = this.teFraction * dArray[5] + this.tmFraction * dArray2[5];
        }
        this.reflectivities[n][n2] = dArray[0];
        this.transmissivities[n][n2] = dArray[1];
        this.transmitAnglesRad[n][n2] = dArray[2];
        this.transmitAnglesDeg[n][n2] = Math.toDegrees(dArray[2]);
        this.evanescentFields[n][n2] = dArray[3];
        this.penetrationDepths[n][n2] = dArray[4];
        this.powerLosses[n][n2] = dArray[5];
    }

    public double[] calcTEreflectivity(int n, int n2) {
        Object object;
        Complex complex = Complex.zero();
        Complex complex2 = Complex.zero();
        Complex complex3 = Complex.zero();
        Complex complex4 = Complex.zero();
        double d = 0.0;
        if (this.numberOfLayers == 2) {
            complex = this.relativeMagneticPermeabilities[n][1].times(this.kxVector[n][n2][0]);
            complex2 = this.relativeMagneticPermeabilities[n][0].times(this.kxVector[n][n2][1]);
            complex3 = complex.minus(complex2);
            complex4 = complex.plus(complex2);
            this.reflectCoeffTE[n][n2] = complex3.over(complex4);
            complex3 = complex.times(2.0);
            this.transmitCoeffTE[n][n2] = complex3.over(complex4);
        } else {
            ComplexMatrix complexMatrix = new ComplexMatrix(2, 2);
            Complex[][] complexArray = Complex.twoDarray(2, 2);
            Complex complex5 = this.kxVector[n][n2][1].over(this.kVector[n][n2][1]);
            Complex complex6 = this.refractiveIndices[n][1].over(this.impedance).over(Complex.sqrt(this.relativeMagneticPermeabilities[n][1]));
            complex6 = complex6.times(complex5);
            Complex complex7 = this.kxVector[n][n2][1].times(this.thicknesses[1]);
            complexArray[0][0] = Complex.cos(complex7);
            complexArray[1][1] = complexArray[0][0];
            complex = Complex.sin(complex7);
            complex = complex.times(Complex.minusJay());
            complexArray[0][1] = complex.over(complex6);
            complexArray[1][0] = complex.times(complex6);
            if (this.numberOfLayers > 3) {
                object = new ComplexMatrix(Complex.copy(complexArray));
                for (int j = 2; j < this.numberOfLayers - 1; ++j) {
                    complex5 = this.kxVector[n][n2][j].over(this.kVector[n][n2][j]);
                    complex6 = this.refractiveIndices[n][j].over(this.impedance).over(Complex.sqrt(this.relativeMagneticPermeabilities[n][j]));
                    complex6 = complex6.times(complex5);
                    complex7 = this.kxVector[n][n2][j].times(this.thicknesses[j]);
                    complexArray[0][0] = Complex.cos(complex7);
                    complexArray[1][1] = complexArray[0][0];
                    complex = Complex.sin(complex7);
                    complex = complex.times(Complex.minusJay());
                    complexArray[0][1] = complex.over(complex6);
                    complexArray[1][0] = complex.times(complex6);
                    complexMatrix.setTwoDarray(Complex.copy(complexArray));
                    object = ((ComplexMatrix)object).times(complexMatrix);
                    complexArray = ((ComplexMatrix)object).getArrayCopy();
                }
            }
            complex5 = this.kxVector[n][n2][0].over(this.kVector[n][n2][0]);
            object = this.refractiveIndices[n][0].over(this.impedance).over(Complex.sqrt(this.relativeMagneticPermeabilities[n][0]));
            object = ((Complex)object).times(complex5);
            complex5 = this.kxVector[n][n2][this.numberOfLayers - 1].over(this.kVector[n][n2][this.numberOfLayers - 1]);
            Complex complex8 = this.refractiveIndices[n][this.numberOfLayers - 1].over(this.impedance).over(Complex.sqrt(this.relativeMagneticPermeabilities[n][this.numberOfLayers - 1]));
            complex8 = complex8.times(complex5);
            complex = complexArray[0][0].plus(complexArray[0][1].times(complex8));
            complex = complex.times((Complex)object);
            complex2 = complexArray[1][0].plus(complexArray[1][1].times(complex8));
            complex3 = complex.minus(complex2);
            complex4 = complex.plus(complex2);
            this.reflectCoeffTE[n][n2] = complex3.over(complex4);
            this.reflectPhaseShiftRadTE[n][n2] = this.reflectCoeffTE[n][n2].arg();
            this.reflectPhaseShiftDegTE[n][n2] = Math.toDegrees(this.reflectPhaseShiftRadTE[n][n2]);
            complex3 = ((Complex)object).times(2.0);
            this.transmitCoeffTE[n][n2] = complex3.over(complex4);
            this.transmitPhaseShiftRadTE[n][n2] = this.transmitCoeffTE[n][n2].arg();
            this.transmitPhaseShiftDegTE[n][n2] = Math.toDegrees(this.transmitPhaseShiftRadTE[n][n2]);
        }
        double d2 = Fmath.square(this.reflectCoeffTE[n][n2].getReal()) + Fmath.square(this.reflectCoeffTE[n][n2].getImag());
        int n3 = this.numberOfLayers - 1;
        double d3 = Fmath.square(this.transmitCoeffTE[n][n2].getReal()) + Fmath.square(this.transmitCoeffTE[n][n2].getImag());
        complex2 = this.relativeMagneticPermeabilities[n][0].over(this.relativeMagneticPermeabilities[n][n3]).times(d3);
        complex3 = this.kxVector[n][n2][n3].conjugate().over(this.kxVector[n][n2][0]);
        object = complex2.times(complex3);
        double d4 = 0.0;
        double d5 = 1.5707963267948966;
        double d6 = 0.0;
        if (this.kxVector[n][n2][n3].getReal() == 0.0) {
            d = 1.0 / this.kxVector[n][n2][n3].getImag();
            d6 = Fmath.square(this.transmitCoeffTE[n][n2].abs()) * (1.0 - Math.exp(-2.0 * this.fieldDistance / d)) * d / 2.0;
            if (this.fieldDistance != Double.POSITIVE_INFINITY) {
                this.fieldIntensityCalc = true;
            }
        } else {
            d4 = ((Complex)object).getReal();
            d5 = Math.atan2(this.kzVector[n][n2][n3].getReal(), this.kxVector[n][n2][n3].getReal());
        }
        double d7 = 10.0 * Fmath.log10((1.0 - d4) * 0.001);
        double[] dArray = new double[]{d2, d4, d5, d6, d, d7};
        return dArray;
    }

    public double[] calcTMreflectivity(int n, int n2) {
        double d;
        Object object;
        Complex complex = Complex.zero();
        Complex complex2 = Complex.zero();
        Complex complex3 = Complex.zero();
        Complex complex4 = Complex.zero();
        double d2 = 0.0;
        if (this.numberOfLayers == 2) {
            complex = Complex.square(this.refractiveIndices[n][1]).times(this.kxVector[n][n2][0]);
            complex2 = Complex.square(this.refractiveIndices[n][0]).times(this.kxVector[n][n2][1]);
            complex3 = complex.minus(complex2);
            complex4 = complex.plus(complex2);
            this.reflectCoeffTM[n][n2] = complex3.over(complex4);
            complex3 = complex.times(2.0);
            this.transmitCoeffTM[n][n2] = complex3.over(complex4);
        } else {
            ComplexMatrix complexMatrix = new ComplexMatrix(2, 2);
            Complex[][] complexArray = Complex.twoDarray(2, 2);
            Complex complex5 = this.kxVector[n][n2][1].over(this.kVector[n][n2][1]);
            Complex complex6 = this.refractiveIndices[n][1].over(this.impedance).over(Complex.sqrt(this.relativeMagneticPermeabilities[n][1]));
            complex6 = complex6.over(complex5);
            Complex complex7 = this.kxVector[n][n2][1].times(this.thicknesses[1]);
            complexArray[0][0] = Complex.cos(complex7);
            complexArray[1][1] = complexArray[0][0];
            complex = Complex.sin(complex7);
            complex = complex.times(Complex.minusJay());
            complexArray[0][1] = complex.over(complex6);
            complexArray[1][0] = complex.times(complex6);
            if (this.numberOfLayers > 3) {
                object = new ComplexMatrix(Complex.copy(complexArray));
                for (int j = 2; j < this.numberOfLayers - 1; ++j) {
                    complex5 = this.kxVector[n][n2][j].over(this.kVector[n][n2][j]);
                    complex6 = this.refractiveIndices[n][j].over(this.impedance).over(Complex.sqrt(this.relativeMagneticPermeabilities[n][j]));
                    complex6 = complex6.over(complex5);
                    complex7 = this.kxVector[n][n2][j].times(this.thicknesses[j]);
                    complexArray[0][0] = Complex.cos(complex7);
                    complexArray[1][1] = complexArray[0][0];
                    complex = Complex.sin(complex7);
                    complex = complex.times(Complex.minusJay());
                    complexArray[0][1] = complex.over(complex6);
                    complexArray[1][0] = complex.times(complex6);
                    complexMatrix.setTwoDarray(Complex.copy(complexArray));
                    object = ((ComplexMatrix)object).times(complexMatrix);
                    complexArray = ((ComplexMatrix)object).getArrayReference();
                }
            }
            complex5 = this.kxVector[n][n2][0].over(this.kVector[n][n2][0]);
            object = this.refractiveIndices[n][0].over(this.impedance).over(Complex.sqrt(this.relativeMagneticPermeabilities[n][0]));
            object = ((Complex)object).over(complex5);
            complex5 = this.kxVector[n][n2][this.numberOfLayers - 1].over(this.kVector[n][n2][this.numberOfLayers - 1]);
            Complex complex8 = this.refractiveIndices[n][this.numberOfLayers - 1].over(this.impedance).over(Complex.sqrt(this.relativeMagneticPermeabilities[n][this.numberOfLayers - 1]));
            complex8 = complex8.over(complex5);
            complex = complexArray[0][0].plus(complexArray[0][1].times(complex8));
            complex = complex.times((Complex)object);
            complex2 = complexArray[1][0].plus(complexArray[1][1].times(complex8));
            complex3 = complex.minus(complex2);
            complex4 = complex.plus(complex2);
            this.reflectCoeffTM[n][n2] = complex3.over(complex4);
            this.reflectPhaseShiftRadTM[n][n2] = this.reflectCoeffTM[n][n2].arg();
            this.reflectPhaseShiftDegTM[n][n2] = Math.toDegrees(this.reflectPhaseShiftRadTM[n][n2]);
            complex3 = ((Complex)object).times(2.0);
            this.transmitCoeffTM[n][n2] = complex3.over(complex4);
            this.transmitPhaseShiftRadTM[n][n2] = this.transmitCoeffTM[n][n2].arg();
            this.transmitPhaseShiftDegTM[n][n2] = Math.toDegrees(this.transmitPhaseShiftRadTM[n][n2]);
        }
        double d3 = Fmath.square(this.reflectCoeffTM[n][n2].getReal()) + Fmath.square(this.reflectCoeffTM[n][n2].getImag());
        int n3 = this.numberOfLayers - 1;
        double d4 = Fmath.square(this.transmitCoeffTM[n][n2].getReal()) + Fmath.square(this.transmitCoeffTM[n][n2].getImag());
        complex2 = Complex.square(this.refractiveIndices[n][0].over(this.refractiveIndices[n][n3])).times(d4);
        complex3 = this.kxVector[n][n2][n3].conjugate().over(this.kxVector[n][n2][0]);
        object = complex2.times(complex3);
        double d5 = 0.0;
        double d6 = 1.5707963267948966;
        double d7 = 0.0;
        if (this.kxVector[n][n2][n3].getReal() == 0.0) {
            d2 = 1.0 / this.kxVector[n][n2][n3].getImag();
            d = this.refractiveIndices[n][0].getReal() / this.refractiveIndices[n][n3].getReal();
            double d8 = Math.sqrt(this.relativeMagneticPermeabilities[n][n3].getReal() / this.relativeMagneticPermeabilities[n][0].getReal());
            d7 = Fmath.square(this.transmitCoeffTM[n][n2].abs()) * d8 * d * (1.0 - Math.exp(-2.0 * this.fieldDistance / d2)) * d2 / 2.0;
            if (this.fieldDistance != Double.POSITIVE_INFINITY) {
                this.fieldIntensityCalc = true;
            }
        } else {
            d5 = ((Complex)object).getReal();
            d6 = Math.atan2(this.kzVector[n][n2][n3].getReal(), this.kxVector[n][n2][n3].getReal());
        }
        d = 10.0 * Fmath.log10((1.0 - d5) * 0.001);
        double[] dArray = new double[]{d3, d5, d6, d7, d2, d};
        return dArray;
    }

    public void setThicknessEstimatesIndices(int[] nArray) {
        this.thicknessEstimateIndices = nArray;
        this.thicknessEstimateNumber = nArray.length;
    }

    public void setRealRefractIndexEstimateIndices(int[] nArray) {
        this.refractIndexRealEstimateIndices = nArray;
        this.refractIndexRealEstimateNumber = nArray.length;
    }

    public void setImagRefractIndexEstimateIndices(int[] nArray) {
        this.refractIndexImagEstimateIndices = nArray;
        this.refractIndexImagEstimateNumber = nArray.length;
        this.refractIndexImagEstimateSet = true;
        if (this.absorptionCoeffEstimateSet) {
            int n;
            int n2;
            int[] nArray2 = new int[this.absorptionCoeffEstimateNumber];
            int n3 = 0;
            for (n2 = 0; n2 < this.numberOfLayers; ++n2) {
                boolean bl = false;
                for (n = 0; n < this.refractIndexImagEstimateNumber; ++n) {
                    if (n2 != this.refractIndexImagEstimateIndices[n]) continue;
                    bl = true;
                }
                n = 0;
                for (int j = 0; j < this.absorptionCoeffEstimateNumber; ++j) {
                    if (n2 != this.absorptionCoeffEstimateIndices[j]) continue;
                    n = 1;
                }
                if (bl || n == 0) continue;
                nArray2[n3] = n2;
                ++n3;
            }
            n2 = this.refractIndexImagEstimateNumber + n3;
            int[] nArray3 = new int[n2];
            for (n = 0; n < this.refractIndexImagEstimateNumber; ++n) {
                nArray3[n] = this.refractIndexImagEstimateIndices[n];
            }
            for (n = 0; n < this.absorptionCoeffEstimateNumber; ++n) {
                nArray3[this.refractIndexImagEstimateNumber + n] = this.absorptionCoeffEstimateIndices[n];
            }
            this.refractIndexImagEstimateIndices = Fmath.selectionSort(nArray3);
        }
    }

    public void setAbsorptionCoefficientEstimateIndices(int[] nArray) {
        this.absorptionCoeffEstimateIndices = nArray;
        this.absorptionCoeffEstimateNumber = nArray.length;
        this.absorptionCoeffEstimateSet = true;
        if (this.refractIndexImagEstimateSet) {
            int n;
            int n2;
            int[] nArray2 = new int[this.absorptionCoeffEstimateNumber];
            int n3 = 0;
            for (n2 = 0; n2 < this.numberOfLayers; ++n2) {
                boolean bl = false;
                for (n = 0; n < this.refractIndexImagEstimateNumber; ++n) {
                    if (n2 != this.refractIndexImagEstimateIndices[n]) continue;
                    bl = true;
                }
                n = 0;
                for (int j = 0; j < this.absorptionCoeffEstimateNumber; ++j) {
                    if (n2 != this.absorptionCoeffEstimateIndices[j]) continue;
                    n = 1;
                }
                if (bl || n == 0) continue;
                nArray2[n3] = n2;
                ++n3;
            }
            n2 = this.refractIndexImagEstimateNumber + n3;
            int[] nArray3 = new int[n2];
            for (n = 0; n < this.refractIndexImagEstimateNumber; ++n) {
                nArray3[n] = this.refractIndexImagEstimateIndices[n];
            }
            for (n = 0; n < this.absorptionCoeffEstimateNumber; ++n) {
                nArray3[this.refractIndexImagEstimateNumber + n] = this.absorptionCoeffEstimateIndices[n];
            }
            this.refractIndexImagEstimateIndices = Fmath.selectionSort(nArray3);
        } else {
            this.refractIndexImagEstimateIndices = this.absorptionCoeffEstimateIndices;
            this.refractIndexImagEstimateNumber = this.absorptionCoeffEstimateNumber;
        }
    }

    public void setRealRelativeMagneticPermeabilityEstimateIndices(int[] nArray) {
        this.magneticPermRealEstimateIndices = nArray;
        this.magneticPermRealEstimateNumber = nArray.length;
    }

    public void setImagRelativeMagneticPermeabilityEstimateIndices(int[] nArray) {
        this.magneticPermImagEstimateIndices = nArray;
        this.magneticPermImagEstimateNumber = nArray.length;
    }

    public void fitReflectivities(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = 1.0;
        }
        this.fitReflectivities(dArray, dArray2);
    }

    public void fitReflectivities(double[] dArray, double[] dArray2) {
        this.numberOfDataPoints = dArray.length;
        if (this.numberOfDataPoints != dArray2.length) {
            throw new IllegalArgumentException("Number of data points, " + this.numberOfDataPoints + " is not equal to the number of errors (weights), " + dArray2.length + ".");
        }
        if (this.incidentAngleSet) {
            if (this.numberOfDataPoints != this.numberOfIncidentAngles) {
                throw new IllegalArgumentException("Number of experimental reflectivities " + this.numberOfDataPoints + " does not equal the number of incident angles " + this.numberOfIncidentAngles);
            }
            double[] dArray3 = Conv.copy(dArray);
            double[] dArray4 = Conv.copy(dArray2);
            for (int j = 0; j < this.numberOfIncidentAngles; ++j) {
                this.experimentalData[j] = dArray3[this.incidentAngleIndices[j]];
                this.experimentalWeights[j] = dArray4[this.incidentAngleIndices[j]];
            }
        }
        this.regressionOption = 1;
        this.experimentalDataSet = true;
        this.nonLinearRegression();
    }

    public void fitAndPlotReflectivities(double[] dArray) {
        this.fitReflectivities(dArray);
        String string = " ";
        this.plotFit(string);
    }

    public void fitAndPlotReflectivities(double[] dArray, String string) {
        this.fitReflectivities(dArray);
        this.plotFit(string);
    }

    public void fitAndPlotReflectivities(double[] dArray, double[] dArray2) {
        this.fitReflectivities(dArray, dArray2);
        String string = " ";
        this.plotFit(string);
    }

    public void fitAndPlotReflectivities(double[] dArray, double[] dArray2, String string) {
        this.fitReflectivities(dArray, dArray2);
        this.plotFit(string);
    }

    public void fitTransmissivities(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = 1.0;
        }
        this.fitTransmissivities(dArray, dArray2);
    }

    public void fitTransmissivities(double[] dArray, double[] dArray2) {
        this.numberOfDataPoints = dArray.length;
        if (this.numberOfDataPoints != dArray2.length) {
            throw new IllegalArgumentException("Number of data points, " + this.numberOfDataPoints + " is not equal to the number of errors (weights), " + dArray2.length + ".");
        }
        if (this.incidentAngleSet) {
            if (this.numberOfDataPoints != this.numberOfIncidentAngles) {
                throw new IllegalArgumentException("Number of experimental transmissivities " + this.numberOfDataPoints + " does not equal the number of incident angles " + this.numberOfIncidentAngles);
            }
            double[] dArray3 = Conv.copy(dArray);
            double[] dArray4 = Conv.copy(dArray2);
            for (int j = 0; j < this.numberOfIncidentAngles; ++j) {
                this.experimentalData[j] = dArray3[this.incidentAngleIndices[j]];
                this.experimentalWeights[j] = dArray4[this.incidentAngleIndices[j]];
            }
        }
        this.regressionOption = 1;
        this.experimentalDataSet = true;
        this.nonLinearRegression();
    }

    public void fitAndPlotTransmissivities(double[] dArray) {
        this.fitTransmissivities(dArray);
        String string = " ";
        this.plotFit(string);
    }

    public void fitAndPlotTransmissivities(double[] dArray, String string) {
        this.fitTransmissivities(dArray);
        this.plotFit(string);
    }

    public void fitAndPlotTransmissivities(double[] dArray, double[] dArray2) {
        this.fitTransmissivities(dArray, dArray2);
        String string = " ";
        this.plotFit(string);
    }

    public void fitAndPlotTransmissivities(double[] dArray, double[] dArray2, String string) {
        this.fitTransmissivities(dArray, dArray2);
        this.plotFit(string);
    }

    public void fitEvanescentField(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = 1.0;
        }
        double d = Double.POSITIVE_INFINITY;
        this.fitEvanescentField(dArray, dArray2, d);
    }

    public void fitEvanescentField(double[] dArray, double[] dArray2) {
        double d = Double.POSITIVE_INFINITY;
        this.fitEvanescentField(dArray, dArray2, d);
    }

    public void fitEvanescentField(double[] dArray, double d) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = 1.0;
        }
        this.fitEvanescentField(dArray, dArray2, d);
    }

    public void fitEvanescentField(double[] dArray, double[] dArray2, double d) {
        this.numberOfDataPoints = dArray.length;
        if (this.numberOfDataPoints != dArray2.length) {
            throw new IllegalArgumentException("Number of data points, " + this.numberOfDataPoints + " is not equal to the number of errors (weights), " + dArray2.length + ".");
        }
        if (this.incidentAngleSet) {
            if (this.numberOfDataPoints != this.numberOfIncidentAngles) {
                throw new IllegalArgumentException("Number of experimental transmissivities " + this.numberOfDataPoints + " does not equal the number of incident angles " + this.numberOfIncidentAngles);
            }
            double[] dArray3 = Conv.copy(dArray);
            double[] dArray4 = Conv.copy(dArray2);
            for (int j = 0; j < this.numberOfIncidentAngles; ++j) {
                this.experimentalData[j] = dArray3[this.incidentAngleIndices[j]];
                this.experimentalWeights[j] = dArray4[this.incidentAngleIndices[j]];
            }
        }
        this.regressionOption = 3;
        this.fieldDistance = d;
        this.experimentalDataSet = true;
        this.nonLinearRegression();
    }

    public void nonLinearRegression() {
        int n;
        int n2;
        int n3 = 0;
        boolean bl = true;
        while (bl) {
            if (this.experimentalWeights[n3] != 1.0) {
                this.weightingOption = true;
                bl = false;
                continue;
            }
            if (++n3 < this.numberOfDataPoints) continue;
            bl = false;
        }
        Regression regression = null;
        regression = this.weightingOption ? new Regression(this.incidentAngleDeg, this.experimentalData, this.experimentalWeights) : new Regression(this.incidentAngleDeg, this.experimentalData);
        RegressFunct regressFunct = new RegressFunct();
        regressFunct.numberOfLayers = this.numberOfLayers;
        regressFunct.mode = this.mode;
        regressFunct.eVectorAngleDeg = this.eVectorAngleDeg;
        regressFunct.thicknesses = this.thicknesses;
        regressFunct.refractiveIndices = this.refractiveIndices;
        regressFunct.relativeMagneticPermeabilities = this.relativeMagneticPermeabilities;
        regressFunct.regressionOption = this.regressionOption;
        regressFunct.thicknessEstimateIndices = this.thicknessEstimateIndices;
        regressFunct.refractIndexRealEstimateIndices = this.refractIndexRealEstimateIndices;
        regressFunct.refractIndexImagEstimateIndices = this.refractIndexImagEstimateIndices;
        regressFunct.magneticPermRealEstimateIndices = this.magneticPermRealEstimateIndices;
        regressFunct.magneticPermImagEstimateIndices = this.magneticPermImagEstimateIndices;
        this.numberOfEstimatedParameters = this.thicknessEstimateNumber;
        this.numberOfEstimatedParameters += this.refractIndexRealEstimateNumber;
        this.numberOfEstimatedParameters += this.refractIndexImagEstimateNumber;
        this.numberOfEstimatedParameters += this.magneticPermRealEstimateNumber;
        this.numberOfEstimatedParameters += this.magneticPermImagEstimateNumber;
        if (this.regressionOption == 3) {
            ++this.numberOfEstimatedParameters;
        }
        this.degreesOfFreedom = this.numberOfDataPoints - this.numberOfEstimatedParameters;
        if (this.degreesOfFreedom < 1) {
            throw new IllegalArgumentException("Number of parameters to be estimated, " + this.numberOfEstimatedParameters + ", is greater than or equal to the number of data points, " + this.numberOfDataPoints + ".");
        }
        double[] dArray = new double[this.numberOfEstimatedParameters];
        double[] dArray2 = new double[this.numberOfEstimatedParameters];
        double[] dArray3 = new double[this.numberOfEstimatedParameters];
        int n4 = 0;
        for (n2 = 0; n2 < this.thicknessEstimateNumber; ++n2) {
            dArray2[n4] = this.thicknesses[this.thicknessEstimateIndices[n4]];
            dArray[n4] = dArray2[n4];
            dArray3[n4] = dArray2[n4] * 0.1;
            if (dArray3[n4] == 0.0) {
                dArray3[n4] = 1.0E-9;
            }
            ++n4;
        }
        for (n2 = 0; n2 < this.refractIndexRealEstimateNumber; ++n2) {
            dArray2[n4] = this.refractiveIndices[0][this.refractIndexRealEstimateIndices[n4]].getReal();
            dArray[n4] = dArray2[n4];
            dArray3[n4] = dArray2[n4] * 0.1;
            if (dArray3[n4] == 0.0) {
                dArray3[n4] = 0.1;
            }
            ++n4;
        }
        for (n2 = 0; n2 < this.refractIndexImagEstimateNumber; ++n2) {
            dArray2[n4] = this.refractiveIndices[0][this.refractIndexImagEstimateIndices[n4]].getImag();
            dArray[n4] = dArray2[n4];
            dArray3[n4] = dArray2[n4] * 0.1;
            if (dArray3[n4] == 0.0) {
                dArray3[n4] = 0.1;
            }
            ++n4;
        }
        for (n2 = 0; n2 < this.magneticPermRealEstimateNumber; ++n2) {
            dArray2[n4] = this.relativeMagneticPermeabilities[0][this.magneticPermRealEstimateIndices[n4]].getReal();
            dArray[n4] = dArray2[n4];
            dArray3[n4] = dArray2[n4] * 0.1;
            if (dArray3[n4] == 0.0) {
                dArray3[n4] = 0.1;
            }
            ++n4;
        }
        for (n2 = 0; n2 < this.magneticPermImagEstimateNumber; ++n2) {
            dArray2[n4] = this.relativeMagneticPermeabilities[0][this.magneticPermImagEstimateIndices[n4]].getImag();
            dArray[n4] = dArray2[n4];
            dArray3[n4] = dArray2[n4] * 0.1;
            if (dArray3[n4] == 0.0) {
                dArray3[n4] = 0.1;
            }
            ++n4;
        }
        if (this.regressionOption == 3) {
            double[] dArray4 = (double[])this.getEvanescentFields(this.fieldDistance);
            double d = 0.0;
            double d2 = 0.0;
            for (int j = 0; j < this.numberOfDataPoints; ++j) {
                if (dArray4[j] == 0.0) continue;
                d += dArray4[j];
                d2 += this.experimentalData[j];
            }
            if (d2 == 0.0) {
                throw new IllegalArgumentException("All entered field values are zero or sum to zero");
            }
            if (d == 0.0) {
                throw new IllegalArgumentException("All calculated field values are zero or sum to zero");
            }
            dArray2[n4] = d2 / d;
            dArray[n4] = dArray2[n4];
            dArray3[n4] = dArray2[n4] * 0.1;
            if (dArray3[n4] == 0.0) {
                dArray3[n4] = 0.1;
            }
            ++n4;
        }
        double d = 1.0E-6;
        int n5 = 1000;
        regression.simplex((RegressionFunction)regressFunct, dArray, dArray3, d, n5);
        double[] dArray5 = regression.getCoeff();
        n4 = 0;
        for (n = 0; n < this.thicknessEstimateNumber; ++n) {
            this.thicknesses[this.thicknessEstimateIndices[n4]] = dArray5[n4];
            ++n4;
        }
        for (n = 0; n < this.refractIndexRealEstimateNumber; ++n) {
            this.refractiveIndices[0][this.refractIndexRealEstimateIndices[n4]].setReal(dArray5[n4]);
            ++n4;
        }
        for (n = 0; n < this.refractIndexImagEstimateNumber; ++n) {
            this.refractiveIndices[0][this.refractIndexImagEstimateIndices[n4]].setImag(dArray5[n4]);
            ++n4;
        }
        for (n = 0; n < this.magneticPermRealEstimateNumber; ++n) {
            this.relativeMagneticPermeabilities[0][this.magneticPermRealEstimateIndices[n4]].setReal(dArray5[n4]);
            ++n4;
        }
        for (n = 0; n < this.magneticPermImagEstimateNumber; ++n) {
            this.relativeMagneticPermeabilities[0][this.magneticPermImagEstimateIndices[n4]].setImag(dArray5[n4]);
            ++n4;
        }
        if (this.regressionOption == 3) {
            this.fieldScalingFactor = dArray5[n4];
        }
        switch (this.regressionOption) {
            case 1: {
                this.calculatedData = (double[])this.getReflectivities();
                break;
            }
            case 2: {
                this.calculatedData = (double[])this.getTransmissivities();
                break;
            }
            case 3: {
                this.calculatedData = (double[])this.getEvanescentFields();
                n = 0;
                while (n < this.numberOfDataPoints) {
                    int n6 = n++;
                    this.calculatedData[n6] = this.calculatedData[n6] * this.fieldScalingFactor;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Regresion option " + this.regressionOption + " does not exist");
            }
        }
    }

    public double[] getCalculatedData() {
        return this.calculatedData;
    }

    public void plotFit(String string) {
        int n = 200;
        double[][] dArray = PlotGraph.data(n, 2);
        for (int j = 0; j < this.numberOfDataPoints; ++j) {
            dArray[0][j] = this.incidentAngleDeg[j];
            dArray[1][j] = this.experimentalData[j];
        }
        double d = (this.incidentAngleDeg[this.numberOfIncidentAngles - 1] - this.incidentAngleDeg[0]) / (double)(n - 1);
        dArray[2][0] = this.incidentAngleDeg[0];
        for (int j = 1; j < n - 1; ++j) {
            dArray[2][j] = dArray[2][j - 1] + d;
        }
        dArray[2][n - 1] = this.incidentAngleDeg[this.numberOfIncidentAngles - 1];
        Reflectivity reflectivity = new Reflectivity(this.numberOfLayers);
        if (this.mode.equals("mixed")) {
            reflectivity.setMode(this.eVectorAngleDeg);
        } else {
            reflectivity.setMode(this.mode);
        }
        reflectivity.setThicknesses(this.thicknesses);
        reflectivity.setRefractiveIndices(this.refractiveIndices);
        reflectivity.setRelativeMagneticPermeabilities(this.relativeMagneticPermeabilities);
        reflectivity.setIncidentAngle(dArray[2]);
        String string2 = null;
        String string3 = null;
        switch (this.regressionOption) {
            case 1: {
                dArray[3] = (double[])reflectivity.getReflectivities();
                string2 = "Plot of reflectivities versus incident angle";
                string3 = "Reflectivity";
                break;
            }
            case 2: {
                dArray[3] = (double[])reflectivity.getTransmissivities();
                string2 = "Plot of transmissivities versus incident angle";
                string3 = "Transmissivity";
                break;
            }
            case 3: {
                dArray[3] = (double[])reflectivity.getEvanescentFields();
                int n2 = 0;
                while (n2 < n) {
                    double[] dArray2 = dArray[3];
                    int n3 = n2++;
                    dArray2[n3] = dArray2[n3] * this.fieldScalingFactor;
                }
                string2 = "Plot of evanescent fields versus incident angle";
                string3 = "Evanescent Field";
                break;
            }
            default: {
                throw new IllegalArgumentException("Regresion option " + this.regressionOption + " does not exist");
            }
        }
        PlotGraph plotGraph = new PlotGraph(dArray);
        plotGraph.setGraphTitle("Reflectivity class: " + string2);
        plotGraph.setGraphTitle2(string);
        plotGraph.setXaxisLegend("Incident angle");
        plotGraph.setXaxisUnitsName("degrees");
        plotGraph.setYaxisLegend(string3);
        int[] nArray = new int[]{1, 0};
        plotGraph.setPoint(nArray);
        int[] nArray2 = new int[]{0, 3};
        plotGraph.setLine(nArray2);
        plotGraph.plot();
    }
}

