/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physchem;

import flanagan.math.Fmath;
import flanagan.math.Minimisation;
import flanagan.math.MinimisationFunction;
import flanagan.physchem.DonnanConcn;

class DonnanMinim
implements MinimisationFunction {
    public int numOfIons = 0;
    public double[] concnA = null;
    public double[] concnB = null;
    public double[] molesT = null;
    public double[] complex = null;
    public double[] excessConcnA = null;
    public double[] excessConcnB = null;
    public double[] excessComplex = null;
    public double[] assocConsts = null;
    public int[] indexK = null;
    public int nonZeroAssocK = 0;
    public double[] radii = null;
    public double[] charges = null;
    public double ionophoreConcn = 0.0;
    public double ionophoreRad = 0.0;
    public double volumeA = 0.0;
    public double volumeB = 0.0;
    public double interfacialArea = 0.0;
    public double epsilonA = 0.0;
    public double epsilonB = 0.0;
    public double epsilonSternA = 0.0;
    public double epsilonSternB = 0.0;
    public double temp = 298.15;
    public double[] partCoeff = null;
    public double[] partCoeffPot = null;
    public double diffPotentialA = 0.0;
    public double diffPotentialB = 0.0;
    public double sternPotential = 0.0;
    public double sternCap = 0.0;
    public double sternDeltaA = 0.0;
    public double sternDeltaB = 0.0;
    public double chargeValue = 0.0;
    public boolean chargeSame = true;
    public double interfacialChargeDensity = 0.0;
    public double interfacialCharge = 0.0;
    public boolean includeIc = true;
    private double[] start = null;
    private double[] step = null;
    private double[] param = null;

    public DonnanMinim(int n) {
        this.numOfIons = n;
        this.start = new double[this.numOfIons];
        this.step = new double[this.numOfIons];
        this.param = new double[this.numOfIons];
    }

    @Override
    public double function(double[] dArray) {
        double d = 0.0;
        this.ionConcns(dArray[0]);
        for (int j = 0; j < this.numOfIons; ++j) {
            d += (this.concnB[j] + this.complex[j]) * this.charges[j];
        }
        return d * d;
    }

    public void ionConcns(double d) {
        for (int j = 0; j < this.numOfIons; ++j) {
            this.partCoeffPot[j] = this.partCoeff[j] * Math.exp(-d * this.charges[j] * -1.60217646263E-19 / (1.380650324E-23 * this.temp));
        }
        if (!this.includeIc) {
            if (this.nonZeroAssocK < 2) {
                this.calcConcnsSingleK(d);
            } else {
                this.calcConcnsMultiK(d);
            }
        } else {
            this.calcConcnsMultiK(d);
        }
    }

    public void calcConcnsSingleK(double d) {
        for (int j = 0; j < this.numOfIons; ++j) {
            if (this.assocConsts[j] == 0.0 || this.ionophoreConcn == 0.0) {
                if (this.molesT[j] == 0.0) {
                    this.concnB[j] = 0.0;
                    this.concnA[j] = 0.0;
                    this.complex[j] = 0.0;
                    continue;
                }
                this.concnB[j] = this.molesT[j] / (this.volumeA * this.partCoeffPot[j] + this.volumeB);
                this.concnA[j] = this.concnB[j] * this.partCoeffPot[j];
                this.complex[j] = 0.0;
                continue;
            }
            double d2 = this.volumeB + this.volumeA * this.partCoeffPot[j] + this.volumeB * this.assocConsts[j] * this.ionophoreConcn - this.assocConsts[j] * this.molesT[j];
            double d3 = this.assocConsts[j] * (this.volumeB + this.volumeA * this.partCoeffPot[j]);
            double d4 = -this.molesT[j];
            double d5 = d2 * d2 - 4.0 * d3 * d4;
            if (d5 < 0.0) {
                System.out.println("Class: DonnanMinim\nMethod: ionConcns\nthe square root term (b2-4ac) of the quadratic = " + d5);
                System.out.println("this term was set to zero as the negative value MAY have arisen from rounding errors");
                d5 = 0.0;
            }
            double d6 = -0.5 * (d2 + Fmath.sign(d2) * Math.sqrt(d5));
            double d7 = d6 / d3;
            double d8 = d4 / d6;
            double d9 = this.molesT[j] / (this.volumeA * this.partCoeffPot[j] + this.volumeB);
            if (d7 >= 0.0 && d7 <= d9) {
                if (d8 < 0.0 || d8 > d9) {
                    this.concnB[j] = d7;
                    this.concnA[j] = this.concnB[j] * this.partCoeffPot[j];
                    this.complex[j] = this.assocConsts[j] * this.ionophoreConcn * this.concnB[j] / (1.0 + this.assocConsts[j] * this.concnB[j]);
                    continue;
                }
                System.out.println("Class: DonnanMinim\nMethod: ionConcns");
                System.out.println("error1: no physically meaningfull root");
                System.out.println("root1 = " + d7 + " root2 = " + d8 + " limit = " + d9);
                System.exit(0);
                continue;
            }
            if (d8 >= 0.0 && d8 <= d9) {
                if (d7 < 0.0 || d7 > d9) {
                    this.concnB[j] = d8;
                    this.concnA[j] = this.concnB[j] * this.partCoeffPot[j];
                    this.complex[j] = this.assocConsts[j] * this.ionophoreConcn * this.concnB[j] / (1.0 + this.assocConsts[j] * this.concnB[j]);
                    continue;
                }
                System.out.println("Class: DonnanMinim\nMethod: ionConcns");
                System.out.println("error2: no physically meaningfull root");
                System.out.println("root1 = " + d7 + " root2 = " + d8 + " limit = " + d9);
                System.exit(0);
                continue;
            }
            System.out.println("Class: DonnanMinim\nMethod: ionConcns");
            System.out.println("error3: no physically meaningfull root");
            System.out.println("root1 = " + d7 + " root2 = " + d8 + " limit = " + d9);
            System.exit(0);
        }
    }

    public void calcConcnsMultiK(double d) {
        for (int j = 0; j < this.numOfIons; ++j) {
            if (this.molesT[j] == 0.0) {
                this.concnB[j] = 0.0;
                this.concnA[j] = 0.0;
                this.complex[j] = 0.0;
                this.excessConcnA[j] = 0.0;
                this.excessConcnB[j] = 0.0;
                this.excessComplex[j] = 0.0;
            } else {
                this.concnB[j] = this.molesT[j] / (this.volumeA * this.partCoeffPot[j] + this.volumeB);
                this.concnA[j] = this.concnB[j] * this.partCoeffPot[j];
                this.complex[j] = 0.0;
                this.excessConcnA[j] = 0.0;
                this.excessConcnB[j] = 0.0;
                this.excessComplex[j] = 0.0;
            }
            this.start[j] = this.concnB[j];
            this.step[j] = 0.05 * this.start[j];
        }
        Minimisation minimisation = new Minimisation();
        DonnanConcn donnanConcn = new DonnanConcn();
        donnanConcn.numOfIons = this.numOfIons;
        donnanConcn.concnA = this.concnA;
        donnanConcn.concnB = this.concnB;
        donnanConcn.molesT = this.molesT;
        donnanConcn.complex = this.complex;
        donnanConcn.excessConcnA = this.excessConcnA;
        donnanConcn.excessConcnB = this.excessConcnB;
        donnanConcn.excessComplex = this.excessComplex;
        donnanConcn.assocConsts = this.assocConsts;
        donnanConcn.indexK = this.indexK;
        donnanConcn.nonZeroAssocK = this.nonZeroAssocK;
        donnanConcn.radii = this.radii;
        donnanConcn.charges = this.charges;
        donnanConcn.ionophoreConcn = this.ionophoreConcn;
        donnanConcn.ionophoreRad = this.ionophoreRad;
        donnanConcn.volumeA = this.volumeA;
        donnanConcn.volumeB = this.volumeB;
        donnanConcn.interfacialArea = this.interfacialArea;
        donnanConcn.epsilonA = this.epsilonA;
        donnanConcn.epsilonB = this.epsilonB;
        donnanConcn.epsilonSternA = this.epsilonSternA;
        donnanConcn.epsilonSternB = this.epsilonSternB;
        donnanConcn.temp = this.temp;
        donnanConcn.partCoeffPot = this.partCoeffPot;
        donnanConcn.sternCap = this.sternCap;
        donnanConcn.sternDeltaA = this.sternDeltaA;
        donnanConcn.sternDeltaB = this.sternDeltaB;
        donnanConcn.chargeValue = this.chargeValue;
        donnanConcn.chargeSame = this.chargeSame;
        donnanConcn.interfacialCharge = this.interfacialCharge;
        donnanConcn.interfacialChargeDensity = this.interfacialChargeDensity;
        donnanConcn.potential = d;
        donnanConcn.includeIc = this.includeIc;
        minimisation.nelderMead(donnanConcn, this.start, this.step, 1.0E-20, 10000);
        this.param = minimisation.getParamValues();
        for (int j = 0; j < this.numOfIons; ++j) {
            this.concnB[j] = this.param[j];
            this.concnA[j] = this.concnB[j] * this.partCoeffPot[j];
        }
        this.interfacialCharge = donnanConcn.interfacialCharge;
        this.interfacialChargeDensity = donnanConcn.interfacialChargeDensity;
    }
}

