/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physchem;

import flanagan.analysis.Regression;
import flanagan.analysis.RegressionFunction;
import flanagan.analysis.RegressionFunction3;
import flanagan.analysis.Stat;
import flanagan.interpolation.CubicInterpolation;
import flanagan.interpolation.CubicSpline;
import flanagan.interpolation.LinearInterpolation;
import flanagan.io.Db;
import flanagan.io.FileChooser;
import flanagan.io.FileInput;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.physchem.Amersham;
import flanagan.physchem.AmershamDual;
import flanagan.physchem.ImmunoChemistry;
import flanagan.plot.Plot;
import flanagan.plot.PlotGraph;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class ImmunoAssay
extends Regression {
    private double[] analyteConcns = null;
    private double[] log10AnalyteConcns = null;
    private double[] logeAnalyteConcns = null;
    private boolean analyteEntered = false;
    private int analyteConcnFlag = 0;
    private int nAnalyteConcns = 0;
    private double[] responses = null;
    private double[] log10Responses = null;
    private double[] logeResponses = null;
    private boolean responsesEntered = false;
    private int nResponses = 0;
    private int responsesFlag = 0;
    private boolean responsesPlot = true;
    private double responsesMax = 0.0;
    private double responsesMin = 0.0;
    private double responsesRange = 0.0;
    private int nWeights = 0;
    private double weightsMean = 0.0;
    private double weightsSD = 0.0;
    private int weightOption = 0;
    private boolean setDataOneDone = false;
    private double[] interpolationConcns = null;
    private double[] calculatedResponses = null;
    private String[] propagatedErrors = null;
    private int nInterp = 1000;
    private CubicSpline interp = null;
    private LinearInterpolation linterp = null;
    private CubicSpline errorp = null;
    private CubicSpline cs = null;
    private CubicInterpolation ci = null;
    private LinearInterpolation li = null;
    private String titleZero = null;
    private String titleOne = null;
    private String filename = "ImmunoAssayOutput.txt";
    private String dataFilename = null;
    private boolean dataRead = false;
    private double interpAnalyteStart = 0.0;
    private double interpAnalyteEnd = 0.0;
    private double interpResponseStart = 0.0;
    private double interpResponseEnd = 0.0;
    private int interpStartIndex = 0;
    private int interpEndIndex = 0;
    private boolean ambigCheck = false;
    private boolean curveDirection = true;
    private double workingResponseMin = 0.0;
    private double workingResponseMax = 0.0;
    private double minimumAerror = 0.0;
    private double maximumAerror = 0.0;
    private double meanAerror = 0.0;
    private double sdAerror = 0.0;
    private int nTurningPoints = 0;
    private int[] turnIndices = null;
    private int nWorking = 0;
    private int polyDegree = 0;
    private int bestPolyDegree = 0;
    private int polyNterms = 0;
    private String compFilename = "ImmunoAssayComparison.txt";
    private int resultFlag = -1;
    private double significance = 0.05;
    private double sampleResponse = 0.0;
    private double sampleConcn = 0.0;
    private double sampleError = 0.0;
    private int nPlot = 0;
    private int plotOptions = 0;
    private boolean supressPlot = false;
    private int nMethods = 15;
    private String[] methodNames = new String[this.nMethods];
    private int[] methodIndices = new int[this.nMethods];
    private int methodUsed = 8;
    private boolean sampleErrorFlag = true;
    private boolean amershamFlag1 = true;
    private double bottom = 0.0;
    private double top = 0.0;
    private boolean compWindow = false;
    private String[] outliers = null;
    private double residualsMean = 0.0;
    private double residualsSD = 0.0;
    private double confidenceLevel = 0.95;
    private double[] critSize = new double[]{3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 12.0, 14.0, 15.0, 16.0, 18.0, 20.0, 30.0, 40.0, 50.0, 60.0, 100.0, 120.0};
    private double[] critValuesOne = new double[]{1.15, 1.49, 1.75, 1.94, 2.1, 2.22, 2.32, 2.41, 2.55, 2.66, 2.71, 2.75, 2.82, 2.88, 3.1, 3.24, 3.34, 3.41, 3.6, 3.66};
    private double[] critValuesFive = new double[]{1.15, 1.46, 1.67, 1.82, 1.94, 2.03, 2.11, 2.18, 2.29, 2.37, 2.41, 2.44, 2.5, 2.56, 2.74, 2.87, 2.96, 3.03, 3.21, 3.27};
    private CubicSpline critValues = null;
    private double anscombeC = 0.0;
    private boolean outlierFlag = false;
    private boolean degSet = false;
    private boolean nTermsSet = false;
    private boolean fourBotTopSet = false;
    private boolean fiveBotTopSet = false;

    public ImmunoAssay() {
        this.titleZero = "Program ImmunoAssay";
        this.supressErrorMessages = true;
        this.trueErrors = false;
        this.methodList();
    }

    public ImmunoAssay(String string) {
        this.titleZero = "Program ImmunoAssay: " + string;
        this.supressErrorMessages = true;
        this.trueErrors = false;
        this.methodList();
    }

    public ImmunoAssay(double[] dArray, double[] dArray2) {
        this.titleZero = "Program ImmunoAssay";
        this.nAnalyteConcns = dArray.length;
        this.analyteConcns = Conv.copy(dArray);
        this.analyteConcnFlag = 0;
        this.analyteEntered = true;
        this.nResponses = dArray2.length;
        this.responses = Conv.copy(dArray2);
        this.responsesFlag = 0;
        this.responsesEntered = true;
        this.xErrorsEntered = false;
        this.yErrorsEntered = false;
        this.supressErrorMessages = true;
        this.trueErrors = false;
        this.methodList();
    }

    public ImmunoAssay(double[] dArray, double[] dArray2, double[] dArray3) {
        this.titleZero = "Program ImmunoAssay";
        this.nAnalyteConcns = dArray.length;
        this.analyteConcns = Conv.copy(dArray);
        this.analyteConcnFlag = 0;
        this.analyteEntered = true;
        this.nResponses = dArray2.length;
        this.responses = Conv.copy(dArray2);
        this.responsesFlag = 0;
        this.responsesEntered = true;
        this.nWeights = dArray3.length;
        this.yErrors = super.checkForZeroWeights(dArray3);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.xErrorsEntered = false;
        this.yErrorsEntered = true;
        this.supressErrorMessages = true;
        this.trueErrors = false;
        this.methodList();
    }

    public ImmunoAssay(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        this.titleZero = "Program ImmunoAssay";
        this.nAnalyteConcns = dArray.length;
        this.analyteConcns = Conv.copy(dArray);
        this.analyteConcnFlag = 0;
        this.analyteEntered = true;
        this.nResponses = dArray2.length;
        this.responses = Conv.copy(dArray2);
        this.responsesFlag = 0;
        this.responsesEntered = true;
        this.nWeights = dArray4.length;
        this.yErrors = dArray4;
        double[][] dArray5 = new double[1][this.nWeights];
        dArray5[0] = dArray3;
        this.xErrors = dArray5;
        super.jointZeroCheck(dArray5, dArray4);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.xErrorsEntered = true;
        this.yErrorsEntered = true;
        this.weightOpt = true;
        this.weightFlag = 1;
        this.supressErrorMessages = true;
        this.trueErrors = true;
        this.methodList();
    }

    public ImmunoAssay(double[] dArray, double[] dArray2, double[] dArray3, String string) {
        this.titleZero = "Program ImmunoAssay: " + string;
        this.nAnalyteConcns = dArray.length;
        this.analyteConcns = Conv.copy(dArray);
        this.analyteConcnFlag = 0;
        this.analyteEntered = true;
        this.nResponses = dArray2.length;
        this.responses = Conv.copy(dArray2);
        this.responsesFlag = 0;
        this.responsesEntered = true;
        this.nWeights = dArray3.length;
        this.yErrors = super.checkForZeroWeights(dArray3);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.xErrorsEntered = false;
        this.yErrorsEntered = true;
        this.supressErrorMessages = true;
        this.trueErrors = false;
        this.methodList();
    }

    public ImmunoAssay(double[] dArray, double[] dArray2, String string) {
        this.titleZero = "Program ImmunoAssay: " + string;
        this.nAnalyteConcns = dArray.length;
        this.analyteConcns = Conv.copy(dArray);
        this.analyteConcnFlag = 0;
        this.analyteEntered = true;
        this.nResponses = dArray2.length;
        this.responses = Conv.copy(dArray2);
        this.responsesFlag = 0;
        this.xErrorsEntered = false;
        this.yErrorsEntered = false;
        this.responsesEntered = true;
        this.supressErrorMessages = true;
        this.trueErrors = false;
        this.methodList();
    }

    public ImmunoAssay(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, String string) {
        this.titleZero = "Program ImmunoAssay: " + string;
        this.nAnalyteConcns = dArray.length;
        this.analyteConcns = Conv.copy(dArray);
        this.analyteEntered = true;
        this.analyteConcnFlag = 0;
        this.nResponses = dArray2.length;
        this.responses = Conv.copy(dArray2);
        this.responsesFlag = 0;
        this.responsesEntered = true;
        this.nWeights = dArray4.length;
        this.yErrors = dArray4;
        double[][] dArray5 = new double[1][this.nWeights];
        dArray5[0] = dArray3;
        this.xErrors = dArray5;
        super.jointZeroCheck(dArray5, dArray4);
        this.xErrorsEntered = true;
        this.yErrorsEntered = true;
        this.weightOpt = true;
        this.weightFlag = 1;
        this.supressErrorMessages = true;
        this.trueErrors = true;
        this.methodList();
    }

    private void methodList() {
        this.methodNames[0] = "CubicSpline";
        this.methodIndices[0] = 0;
        this.methodNames[1] = "Five parameter logistic function";
        this.methodIndices[1] = 13;
        this.methodNames[2] = "Five parameter logistic function (top and bottom fixed)";
        this.methodIndices[2] = 6;
        this.methodNames[3] = "Four parameter logistic function";
        this.methodIndices[3] = 5;
        this.methodNames[4] = "Four parameter logistic function (top and bottom fixed)";
        this.methodIndices[4] = 7;
        this.methodNames[5] = "Best fit polynomial";
        this.methodIndices[5] = 8;
        this.methodNames[6] = "Polynomial of user supplied degree ";
        this.methodIndices[6] = 9;
        this.methodNames[7] = "Non-integer polynomial";
        this.methodIndices[7] = 3;
        this.methodNames[8] = "Sigmoid threshold function";
        this.methodIndices[8] = 1;
        this.methodNames[9] = "Sips sigmoid function";
        this.methodIndices[9] = 10;
        this.methodNames[10] = "Shifted rectangular hyperbola";
        this.methodIndices[10] = 11;
        this.methodNames[11] = "Rectangular hyperbola";
        this.methodIndices[11] = 12;
        this.methodNames[12] = "Amersham equation";
        this.methodIndices[12] = 4;
        this.methodNames[13] = "Cubic interpolation";
        this.methodIndices[13] = 2;
        this.methodNames[14] = "Linear interpolation";
        this.methodIndices[14] = 14;
    }

    public void enterAnalyteConcns(double[] dArray) {
        this.setDataOneDone = false;
        this.nAnalyteConcns = dArray.length;
        this.analyteConcns = Conv.copy(dArray);
        this.analyteConcnFlag = 0;
        this.analyteEntered = true;
    }

    public void enterAnalyteConcnsAsLog10(double[] dArray) {
        this.setDataOneDone = false;
        this.nAnalyteConcns = dArray.length;
        this.log10AnalyteConcns = Conv.copy(dArray);
        this.analyteConcns = this.antiLog10(dArray);
        this.analyteConcnFlag = 1;
        this.analyteEntered = true;
    }

    public void enterAnalyteConcnsAsLogE(double[] dArray) {
        this.setDataOneDone = false;
        this.nAnalyteConcns = dArray.length;
        this.logeAnalyteConcns = Conv.copy(dArray);
        this.analyteConcns = this.antiLoge(dArray);
        this.analyteConcnFlag = 2;
        this.analyteEntered = true;
    }

    public void enterResponses(double[] dArray) {
        this.setDataOneDone = false;
        this.nResponses = dArray.length;
        this.responses = Conv.copy(dArray);
        this.responsesFlag = 0;
        this.responsesEntered = true;
    }

    public void enterResponsesAsLog10(double[] dArray) {
        this.setDataOneDone = false;
        this.nResponses = dArray.length;
        this.log10Responses = Conv.copy(dArray);
        this.responses = this.antiLog10(dArray);
        this.responsesFlag = 1;
        this.responsesEntered = true;
    }

    public void enterResponsesAsLogE(double[] dArray) {
        this.setDataOneDone = false;
        this.nResponses = dArray.length;
        this.logeResponses = Conv.copy(dArray);
        this.responses = this.antiLoge(dArray);
        this.responsesFlag = 2;
        this.responsesEntered = true;
    }

    public void enterWeights(double[] dArray) {
        this.setDataOneDone = false;
        this.nWeights = dArray.length;
        this.yErrors = super.checkForZeroWeights(dArray);
        this.yErrorsEntered = true;
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
    }

    public void enterWeightsAslog10(double[] dArray) {
        this.setDataOneDone = false;
        this.nWeights = dArray.length;
        this.yErrors = this.antiLog10(super.checkForZeroWeights(dArray));
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.yErrorsEntered = true;
    }

    public void enterWeightsAslogE(double[] dArray) {
        this.setDataOneDone = false;
        this.nWeights = dArray.length;
        this.yErrors = this.antiLoge(super.checkForZeroWeights(dArray));
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.yErrorsEntered = true;
    }

    public void enterMultiplicativeWeights(double[] dArray) {
        this.setDataOneDone = false;
        this.nWeights = dArray.length;
        this.yErrors = Conv.copy(super.checkForZeroWeights(dArray));
        for (int j = 0; j < this.nWeights; ++j) {
            this.yErrors[j] = 1.0 / Math.abs(this.yErrors[j]);
        }
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.yErrorsEntered = true;
    }

    public void enterMultiplicativeWeightsAsLog10(double[] dArray) {
        this.setDataOneDone = false;
        this.nWeights = dArray.length;
        this.yErrors = this.antiLog10(super.checkForZeroWeights(Conv.copy(dArray)));
        for (int j = 0; j < this.nWeights; ++j) {
            this.yErrors[j] = 1.0 / Math.abs(this.yErrors[j]);
        }
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.yErrorsEntered = true;
    }

    public void enterMultiplicativeWeightsAsLogE(double[] dArray) {
        this.setDataOneDone = false;
        this.nWeights = dArray.length;
        this.yErrors = this.antiLoge(super.checkForZeroWeights(Conv.copy(dArray)));
        for (int j = 0; j < this.nWeights; ++j) {
            this.yErrors[j] = 1.0 / Math.abs(this.yErrors[j]);
        }
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.yErrorsEntered = true;
    }

    public void setWeightsAsResponses() {
        this.yErrorsEntered = false;
        this.weightOption = 1;
        if (this.nResponses > 0) {
            this.yErrors = new double[this.nResponses];
            for (int j = 0; j < this.nResponses; ++j) {
                this.yErrors[j] = Math.abs(this.responses[j]);
                this.yErrorsEntered = true;
            }
            this.yErrors = super.checkForZeroWeights(this.yErrors);
            if (this.weightOpt) {
                this.weightFlag = 1;
            }
            this.yErrorsEntered = true;
        }
    }

    public void setWeightsAsSqrtResponses() {
        this.yErrorsEntered = false;
        this.weightOption = 2;
        if (this.nResponses > 0) {
            this.yErrors = new double[this.nResponses];
            for (int j = 0; j < this.nResponses; ++j) {
                this.yErrors[j] = Math.sqrt(Math.abs(this.responses[j]));
            }
            this.yErrors = super.checkForZeroWeights(this.yErrors);
            if (this.weightOpt) {
                this.weightFlag = 1;
            }
            this.yErrorsEntered = true;
        }
    }

    public void enterTitle(String string) {
        this.titleZero = string;
    }

    public void readFromFile() {
        this.setDataOneDone = false;
        FileChooser fileChooser = new FileChooser();
        this.dataFilename = fileChooser.selectFile();
        this.read(fileChooser);
    }

    public void readFromFile(String string) {
        this.setDataOneDone = false;
        this.dataFilename = string;
        FileInput fileInput = new FileInput(string);
        this.read(fileInput);
    }

    private int separatorPosition(String string) {
        int n = (string = string.trim()).indexOf(58);
        if (n == -1) {
            n = string.indexOf(59);
        }
        if (n == -1) {
            n = string.indexOf(44);
        }
        if (n == -1) {
            n = string.indexOf(9);
        }
        if (n == -1) {
            string.indexOf(32);
        }
        return n;
    }

    private void read(FileInput fileInput) {
        this.nAnalyteConcns = fileInput.numberOfLines() - 1;
        this.titleZero = fileInput.readLine();
        this.nResponses = this.nAnalyteConcns;
        this.analyteConcns = new double[this.nAnalyteConcns];
        this.responses = new double[this.nAnalyteConcns];
        this.yErrors = new double[this.nAnalyteConcns];
        int n = 0;
        String string = null;
        String string2 = null;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        for (int j = 0; j < this.nAnalyteConcns; ++j) {
            string = fileInput.readLine().trim();
            n3 = this.separatorPosition(string);
            if (n3 == -1) {
                throw new IllegalArgumentException("Input file line " + (j + 1) + ": analyte concentration and response value required for all data points");
            }
            string2 = string.substring(0, n3);
            this.analyteConcns[j] = Double.parseDouble(string2);
            n2 = (string = string.substring(n3 + 1).trim()).length();
            if (n2 < 1) {
                throw new IllegalArgumentException("Input file line " + (j + 1) + ": response value required for all data points");
            }
            n4 = this.separatorPosition(string);
            string2 = n4 == -1 ? string : string.substring(0, n4);
            this.responses[j] = Double.parseDouble(string2);
            if (n4 == -1 || (n2 = (string = string.substring(n4 + 1).trim()).length()) <= 0) continue;
            n5 = this.separatorPosition(string);
            string2 = n5 == -1 ? string.trim() : string.substring(0, n5).trim();
            this.yErrors[j] = Double.parseDouble(string2);
            if (this.yErrors[j] != 1.0) continue;
            ++n;
        }
        this.analyteConcnFlag = 0;
        this.analyteEntered = true;
        this.responsesEntered = true;
        if (n != this.nAnalyteConcns) {
            this.nWeights = this.nAnalyteConcns;
            this.yErrors = super.checkForZeroWeights(this.yErrors);
            if (this.weightOpt) {
                this.weightFlag = 1;
            }
            this.yErrorsEntered = true;
        }
        this.dataRead = true;
    }

    public double[] getAnalyteConcns() {
        return this.analyteConcns;
    }

    public double[] getResponses() {
        return this.responses;
    }

    public String getTitle() {
        return this.titleZero;
    }

    public void cubicSpline() {
        if (this.nAnalyteConcns < 3) {
            throw new IllegalArgumentException("Method cubicSpline requres at least 3 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 0;
        this.sampleErrorFlag = false;
        this.titleOne = "Cubic spline ";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        this.cs = new CubicSpline(this.analyteConcns, this.responses);
        for (int j = 0; j < this.nInterp; ++j) {
            this.calculatedResponses[j] = this.cs.interpolate(this.interpolationConcns[j]);
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void cubicInterpolation() {
        if (this.nAnalyteConcns < 2) {
            throw new IllegalArgumentException("Method cubicInterpolation requres at least 2 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 1;
        this.sampleErrorFlag = false;
        this.titleOne = "Cubic interpolation ";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        this.ci = new CubicInterpolation(this.analyteConcns, this.responses, 0);
        for (int j = 0; j < this.nInterp; ++j) {
            this.calculatedResponses[j] = this.ci.interpolate(this.interpolationConcns[j]);
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void linearInterpolation() {
        if (this.nAnalyteConcns < 2) {
            throw new IllegalArgumentException("Method cubicInterpolation requres at least 2 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 14;
        this.sampleErrorFlag = false;
        this.titleOne = "Linear interpolation ";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        this.li = new LinearInterpolation(this.analyteConcns, this.responses);
        for (int j = 0; j < this.nInterp; ++j) {
            this.calculatedResponses[j] = this.li.interpolate(this.interpolationConcns[j]);
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void polynomialFit(int n) {
        if (this.nAnalyteConcns < n + 2) {
            throw new IllegalArgumentException("Method polynomialFit(" + n + ") requres at least " + (n + 2) + " data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 2;
        this.sampleErrorFlag = true;
        this.degSet = true;
        this.polyDegree = n;
        this.titleOne = "Polynomial fitting: r = c[0] + c[1].a +  c[1].a^2 + ... + c[n].a^n; degree (n) = " + n;
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        super.polynomial(n);
        for (int j = 0; j < this.nInterp; ++j) {
            this.calculatedResponses[j] = 0.0;
            for (int k = 0; k <= n; ++k) {
                int n2 = j;
                this.calculatedResponses[n2] = this.calculatedResponses[n2] + this.best[k] * Math.pow(this.interpolationConcns[j], k);
            }
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public int bestPolynomialFit() {
        this.methodUsed = 3;
        this.sampleErrorFlag = true;
        this.titleOne = "Best polynomial fitting: r = c[0] + c[1].a +  c[1].a^2 + ... + c[n].a^n; best fit degree (n) = ";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        ArrayList<Object> arrayList = super.bestPolynomial();
        this.bestPolyDegree = (Integer)arrayList.get(0);
        this.titleOne = this.titleOne + " " + this.bestPolyDegree;
        for (int j = 0; j < this.nInterp; ++j) {
            this.calculatedResponses[j] = 0.0;
            for (int k = 0; k <= this.bestPolyDegree; ++k) {
                int n = j;
                this.calculatedResponses[n] = this.calculatedResponses[n] + this.best[k] * Math.pow(this.interpolationConcns[j], k);
            }
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
        return this.bestPolynomialDegree;
    }

    public void nonIntegerPolynomialFit(int n) {
        if (this.nAnalyteConcns < n + 1) {
            throw new IllegalArgumentException("Method nonIntegerPolynomial requres at least " + (n + 1) + " data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 4;
        this.polyNterms = n;
        this.nTermsSet = true;
        this.sampleErrorFlag = true;
        this.titleOne = "Non-integer polynomial fitting: r = c[0] + c[1].a^c[n] + c[2].a^c[n+1] + ... + c[n].a^c[2n-1]";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        super.nonIntegerPolynomial(n);
        for (int j = 0; j < this.nInterp; ++j) {
            this.calculatedResponses[j] = this.best[0];
            for (int k = 1; k < this.polyNterms; ++k) {
                int n2 = j;
                this.calculatedResponses[n2] = this.calculatedResponses[n2] + this.best[k] * Math.pow(this.interpolationConcns[j], this.best[n + k - 1]);
            }
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void nonIntegerPolynomialFit() {
        this.nonIntegerPolynomialFit(3);
    }

    public void sigmoidThresholdFit() {
        if (this.nAnalyteConcns < 4) {
            throw new IllegalArgumentException("Method sigmoidThresholdFit requres at least 4 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 5;
        this.sampleErrorFlag = true;
        this.titleOne = "Sigmoid threshold fitting: r = A/(1 + exp(-alpha(a - theta)))";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        super.sigmoidThreshold();
        for (int j = 0; j < this.nInterp; ++j) {
            this.calculatedResponses[j] = this.best[2] / (1.0 + Math.exp(-this.best[0] * (this.interpolationConcns[j] - this.best[1])));
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void sipsSigmoidFit() {
        if (this.nAnalyteConcns < 4) {
            throw new IllegalArgumentException("Method sipsSigmoidFit requres at least 4 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 6;
        this.sampleErrorFlag = true;
        this.titleOne = "Sips sigmoid fitting: r = Aa^n/(theta^n + a^n)";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        super.addConstraint(0, -1, 0.0);
        super.sigmoidHillSips();
        super.removeConstraints();
        for (int j = 0; j < this.nInterp; ++j) {
            this.calculatedResponses[j] = this.best[2] * Math.pow(this.interpolationConcns[j], this.best[1]) / (Math.pow(this.best[0], this.best[1]) + Math.pow(this.interpolationConcns[j], this.best[1]));
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void fourParameterLogisticFit() {
        if (this.nAnalyteConcns < 5) {
            throw new IllegalArgumentException("Method fourParameterLogisticFit requres at least 5 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 7;
        this.sampleErrorFlag = true;
        this.titleOne = "Four parameter logistic fitting: r = top + (bottom - top)/(1 + (a/C50)^HillSlope)";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        super.addConstraint(2, -1, 0.0);
        super.ec50();
        super.removeConstraints();
        for (int j = 0; j < this.nInterp; ++j) {
            this.calculatedResponses[j] = this.best[0] + (this.best[1] - this.best[0]) / (1.0 + Math.pow(this.interpolationConcns[j] / this.best[2], this.best[3]));
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void ec50Fit() {
        this.fourParameterLogisticFit();
    }

    public void fourParameterLogisticFit(double d, double d2) {
        if (this.nAnalyteConcns < 3) {
            throw new IllegalArgumentException("Method fourParameterLogisticFit requres at least 3 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.bottom = d;
        this.top = d2;
        this.methodUsed = 13;
        this.fourBotTopSet = true;
        this.sampleErrorFlag = true;
        this.titleOne = "Four parameter logistic fitting: r = top + (bottom - top)/(1 + (a/C50)^HillSlope) [top and bottom fixed]";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        super.addConstraint(0, -1, 0.0);
        super.ec50(d, d2);
        super.removeConstraints();
        for (int j = 0; j < this.nInterp; ++j) {
            this.calculatedResponses[j] = d2 + (d - d2) / (1.0 + Math.pow(this.interpolationConcns[j] / this.best[0], this.best[1]));
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void ec50Fit(double d, double d2) {
        this.fourParameterLogisticFit(d, d2);
    }

    public void fiveParameterLogisticFit() {
        if (this.nAnalyteConcns < 6) {
            throw new IllegalArgumentException("Method fiveParameterLogisticFit requres at least 6 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 8;
        this.sampleErrorFlag = true;
        this.titleOne = "Five parameter logistic fitting: r = top + (bottom - top)/((1 + (a/C50)^HillSlope)^asymm)";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        super.addConstraint(2, -1, 0.0);
        super.fiveParameterLogistic();
        super.removeConstraints();
        for (int j = 0; j < this.nInterp; ++j) {
            this.calculatedResponses[j] = this.best[0] + (this.best[1] - this.best[0]) / Math.pow(1.0 + Math.pow(this.interpolationConcns[j] / this.best[2], this.best[3]), this.best[4]);
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void fiveParameterLogisticFit(double d, double d2) {
        if (this.nAnalyteConcns < 5) {
            throw new IllegalArgumentException("Method fiveParameterLogisticFit requres at least 5 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 13;
        this.sampleErrorFlag = true;
        this.bottom = d;
        this.top = d2;
        this.fiveBotTopSet = true;
        this.titleOne = "Five parameter logistic fitting: r = top + (bottom - top)/((1 + (a/C50)^HillSlope)^asymm) [top and bottom fixed]";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        super.addConstraint(0, -1, 0.0);
        super.fiveParameterLogistic(d, d2);
        super.removeConstraints();
        for (int j = 0; j < this.nInterp; ++j) {
            this.calculatedResponses[j] = d2 + (d - d2) / Math.pow(1.0 + Math.pow(this.interpolationConcns[j] / this.best[0], this.best[1]), this.best[2]);
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void shiftedRectangularHyperbolaFit() {
        if (this.nAnalyteConcns < 4) {
            throw new IllegalArgumentException("Method shiftedRectangularHyperbolaFit requres at least 4 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 9;
        this.sampleErrorFlag = true;
        this.titleOne = "Rectangular hyperbola fitting: r = A.a/(theta + a) + alpha)";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        super.shiftedRectangularHyperbola();
        for (int j = 0; j < this.nInterp; ++j) {
            this.calculatedResponses[j] = this.best[2] * this.interpolationConcns[j] / (this.best[0] + this.interpolationConcns[j]) + this.best[1];
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void rectangularHyperbolaFit() {
        if (this.nAnalyteConcns < 3) {
            throw new IllegalArgumentException("Method rectangularHyperbolaFit requres at least 3 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 10;
        this.sampleErrorFlag = true;
        this.titleOne = "Rectangular hyperbola fitting: r = A.a/(theta + a))";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        super.rectangularHyperbola();
        for (int j = 0; j < this.nInterp; ++j) {
            this.calculatedResponses[j] = this.best[1] * this.interpolationConcns[j] / (this.best[0] + this.interpolationConcns[j]);
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void amershamFit() {
        this.methodUsed = 11;
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        this.isCompetitive();
        this.amershamFlag1 = true;
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        this.fitAmersham(dArray);
    }

    public void amershamFit(double[] dArray) {
        this.methodUsed = 11;
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        this.isCompetitive();
        this.amershamFlag1 = false;
        this.fitAmersham(dArray);
    }

    private void fitAmersham(double[] dArray) {
        int n;
        int n2;
        if (this.nAnalyteConcns < 6) {
            throw new IllegalArgumentException("Method amershamFit requres at least 6 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.sampleErrorFlag = true;
        this.titleOne = "Amersham equation fitting: r = S(2.P(1-N/L)/(K+P+L+a+[(K-P+L+a)^2+4KP]^0.5)+N/L)";
        double[] dArray2 = new double[5];
        double[] dArray3 = new double[5];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = this.responsesMax;
        if (this.amershamFlag1) {
            n2 = 0;
            for (n = 0; n < this.nAnalyteConcns; ++n) {
                if (this.responses[n] < this.responsesMax / 2.0) {
                    d2 = n != this.nAnalyteConcns - 1 ? (this.analyteConcns[n] + this.analyteConcns[n + 1]) / 2.0 : this.analyteConcns[n];
                    n2 = 1;
                }
                if (n2 != 0) break;
            }
            if (n2 == 0) {
                d2 = this.analyteConcns[this.nAnalyteConcns - 1];
            }
            d = d2 / 100.0;
            d3 = d2 / 1000.0;
            dArray2[0] = d;
            dArray2[1] = d2;
            dArray2[2] = d3;
            dArray2[3] = d4;
            dArray2[4] = d5;
            for (n = 0; n < 5; ++n) {
                dArray3[n] = 0.1 * dArray2[n];
            }
            dArray3[3] = d3 / 100.0;
        } else {
            dArray2[0] = dArray[0];
            dArray2[1] = dArray[1];
            dArray2[2] = dArray[2];
            dArray2[3] = dArray[3];
            dArray2[4] = dArray[4];
            for (n2 = 0; n2 < 5; ++n2) {
                dArray3[n2] = 0.1 * dArray2[n2];
            }
            if (dArray3[3] == 0.0) {
                dArray3[3] = dArray3[2] / 100.0;
            }
        }
        for (n2 = 0; n2 < 5; ++n2) {
            super.addConstraint(n2, -1, 0.0);
        }
        if (this.xErrorsEntered) {
            AmershamDual amershamDual = new AmershamDual();
            amershamDual.setYerrors(this.yErrors);
            amershamDual.setXerrors(this.xErrors);
            super.simplex((RegressionFunction3)amershamDual, dArray2, dArray3);
            super.removeConstraints();
            for (n = 0; n < this.nInterp; ++n) {
                double[] dArray4 = new double[]{this.interpolationConcns[n]};
                this.calculatedResponses[n] = amershamDual.function(this.best, dArray4, -1)[0];
            }
        } else {
            Amersham amersham = new Amersham();
            super.simplex((RegressionFunction)amersham, dArray2, dArray3);
            super.removeConstraints();
            for (n = 0; n < this.nInterp; ++n) {
                double[] dArray5 = new double[]{this.interpolationConcns[n]};
                this.calculatedResponses[n] = amersham.function(this.best, dArray5);
            }
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    private void isCompetitive() {
        int n = 0;
        for (int j = 1; j < this.nAnalyteConcns; ++j) {
            if (this.responses[j - 1] < this.responses[j]) {
                ++n;
            }
            if (n < this.nAnalyteConcns / 2) continue;
            if (this.responses[this.nAnalyteConcns - 1] >= this.responses[0]) {
                throw new IllegalArgumentException("The data appears incompatible with a competitive assay");
            }
            System.out.println("The data has been queried as that of a competitive assay but the fitting has not been aborted");
        }
    }

    public void selectEquation() {
        ArrayList<Object> arrayList = this.chooseEquation(0);
        int n = (Integer)arrayList.get(0);
        int n2 = (Integer)arrayList.get(1);
        double d = (Double)arrayList.get(2);
        double d2 = (Double)arrayList.get(3);
        switch (n) {
            case 1: {
                this.fiveParameterLogisticFit();
                break;
            }
            case 2: {
                this.fiveParameterLogisticFit(d, d2);
                break;
            }
            case 3: {
                this.fourParameterLogisticFit();
                break;
            }
            case 4: {
                this.fourParameterLogisticFit(d, d2);
                break;
            }
            case 5: {
                this.bestPolynomialFit();
                break;
            }
            case 6: {
                this.polynomialFit(n2);
                break;
            }
            case 7: {
                this.nonIntegerPolynomialFit(n2);
                break;
            }
            case 8: {
                this.sigmoidThresholdFit();
                break;
            }
            case 9: {
                this.sipsSigmoidFit();
                break;
            }
            case 10: {
                this.shiftedRectangularHyperbolaFit();
                break;
            }
            case 11: {
                this.rectangularHyperbolaFit();
                break;
            }
            case 12: {
                this.amershamFit();
                break;
            }
            case 13: {
                this.cubicSpline();
                break;
            }
            case 14: {
                this.linearInterpolation();
            }
        }
    }

    private ArrayList<Object> chooseEquation(int n) {
        Object[] objectArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = null;
        String[] stringArray = null;
        Object[] objectArray2 = null;
        switch (n) {
            case 0: {
                string = "Choose a fitting equation";
                stringArray = new String[15];
                break;
            }
            case 1: {
                string = "Choose the first equation of the comparison";
                stringArray = new String[13];
                break;
            }
            case 2: {
                string = "Choose the second equation of the comparison";
                stringArray = new String[13];
            }
        }
        stringArray[0] = "1.  Five paramater logistic equation";
        stringArray[1] = "2.  Five paramater logistic equation (top & bottom fixed)";
        stringArray[2] = "3.  Four paramater logistic equation";
        stringArray[3] = "4.  Four paramater logistic equation (top & bottom fixed)";
        stringArray[4] = "5.  Best fit polynomial";
        stringArray[5] = "6.  Polynomial of user supplied degree";
        stringArray[6] = "7.  Non-integer polynomial";
        stringArray[7] = "8.  Sigmoid threshold function";
        stringArray[8] = "9.  Sips sigmoid function";
        stringArray[9] = "10.  Shifted rectangular hyperbola";
        stringArray[10] = "11.  Rectangular hyperbola";
        stringArray[11] = "12.  Amersham mass action model";
        if (n == 0) {
            stringArray[12] = "13.  Cubic spline";
            stringArray[13] = "14.  Linear interpolation\n\n";
            stringArray[14] = "Click on the appropriate button below";
            objectArray2 = objectArray = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14"};
        } else {
            stringArray[12] = "\nClick on the appropriate button below";
            objectArray2 = objectArray = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
        }
        int n2 = 0;
        int n3 = 1 + JOptionPane.showOptionDialog(null, stringArray, string, 1, 3, null, objectArray2, objectArray2[n2]);
        arrayList.add(new Integer(n3));
        int n4 = 0;
        if (n3 == 6) {
            n4 = Db.readInt("enter polynomial degree");
        }
        if (n3 == 7) {
            n4 = Db.readInt("enter non-integer polynomial number of terms");
        }
        arrayList.add(new Integer(n4));
        double d = 0.0;
        double d2 = 0.0;
        if (n3 == 2) {
            d = Db.readDouble("Enter five parameter logistic fixed bottom value");
            d2 = Db.readDouble("Enter five parameter logistic fixed top value");
        }
        if (n3 == 4) {
            d = Db.readDouble("Enter four parameter logistic fixed bottom value");
            d2 = Db.readDouble("Enter four parameter logistic fixed top value");
        }
        arrayList.add(new Double(d));
        arrayList.add(new Double(d2));
        return arrayList;
    }

    private double[] log10(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        this.nPlot = this.nAnalyteConcns;
        for (int j = 0; j < n; ++j) {
            if (dArray[j] == 0.0) {
                dArray2[j] = Double.NaN;
                --this.nPlot;
                continue;
            }
            dArray2[j] = Math.log10(dArray[j]);
        }
        return dArray2;
    }

    private double[] loge(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        this.nPlot = 0;
        this.nPlot = this.nAnalyteConcns;
        for (int j = 0; j < n; ++j) {
            if (dArray[j] == 0.0) {
                dArray2[j] = Double.NaN;
                --this.nPlot;
                continue;
            }
            dArray2[j] = Math.log(dArray[j]);
        }
        return dArray2;
    }

    private double[] antiLog10(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = Math.pow(10.0, dArray[j]);
        }
        return dArray2;
    }

    private double[] antiLoge(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = Math.exp(dArray[j]);
        }
        return dArray2;
    }

    public void setData() {
        this.setDataOne();
    }

    private void setDataOne() {
        int n;
        int n2;
        int n3;
        if (!this.analyteEntered) {
            throw new IllegalArgumentException("No analyte concentrations have been entered");
        }
        if (!this.responsesEntered) {
            throw new IllegalArgumentException("No standard curve responses have been entered");
        }
        if (this.nAnalyteConcns != this.nResponses) {
            throw new IllegalArgumentException("The number of analyte concentrations entered, " + this.nAnalyteConcns + ", must equal the number of standard curve responses entered, " + this.nResponses);
        }
        if (this.yErrorsEntered) {
            if (this.nAnalyteConcns != this.nWeights) {
                throw new IllegalArgumentException("The number of analyte concentrations entered, " + this.nAnalyteConcns + ", must equal the number of standard curve weights entered, " + this.nWeights);
            }
        } else {
            this.weightOpt = false;
            this.weightFlag = 0;
            this.nWeights = this.nResponses;
            this.yErrors = new double[this.nWeights];
            for (int j = 0; j < this.nWeights; ++j) {
                this.yErrors[j] = 1.0;
            }
        }
        this.nData = this.nAnalyteConcns;
        this.nData0 = this.nAnalyteConcns;
        this.nXarrays = 1;
        this.nYarrays = 1;
        ArrayMaths arrayMaths = new ArrayMaths(this.analyteConcns);
        arrayMaths = arrayMaths.sort();
        int[] nArray = arrayMaths.originalIndices();
        double[] dArray = new double[this.nAnalyteConcns];
        dArray = Conv.copy(this.analyteConcns);
        for (n3 = 0; n3 < this.nAnalyteConcns; ++n3) {
            this.analyteConcns[n3] = dArray[nArray[n3]];
        }
        dArray = Conv.copy(this.responses);
        for (n3 = 0; n3 < this.nAnalyteConcns; ++n3) {
            this.responses[n3] = dArray[nArray[n3]];
        }
        if (this.yErrorsEntered) {
            dArray = Conv.copy(this.yErrors);
            for (n3 = 0; n3 < this.nAnalyteConcns; ++n3) {
                this.yErrors[n3] = dArray[nArray[n3]];
            }
        }
        if (this.xErrorsEntered) {
            dArray = Conv.copy(this.xErrors[0]);
            for (n3 = 0; n3 < this.nAnalyteConcns; ++n3) {
                this.xErrors[0][n3] = dArray[nArray[n3]];
            }
        }
        if (this.analyteConcnFlag == 1) {
            dArray = Conv.copy(this.log10AnalyteConcns);
            for (n3 = 0; n3 < this.nAnalyteConcns; ++n3) {
                this.log10AnalyteConcns[n3] = dArray[nArray[n3]];
            }
        }
        if (this.analyteConcnFlag == 2) {
            dArray = Conv.copy(this.logeAnalyteConcns);
            for (n3 = 0; n3 < this.nAnalyteConcns; ++n3) {
                this.logeAnalyteConcns[n3] = dArray[nArray[n3]];
            }
        }
        n3 = this.nAnalyteConcns;
        for (n2 = 0; n2 < this.nAnalyteConcns - 1; ++n2) {
            int n4;
            n = 1;
            int n5 = 0;
            ArrayList arrayList = new ArrayList();
            for (int j = n2 + 1; j < this.nAnalyteConcns; ++j) {
                if (this.analyteConcns[n2] != this.analyteConcns[j]) continue;
                ++n;
                n5 = n2;
            }
            if (n <= 1) continue;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (n4 = n5; n4 < n5 + n; ++n4) {
                d += this.responses[n4];
                if (this.yErrorsEntered) {
                    d2 += this.yErrors[n2] * this.yErrors[n2];
                }
                if (!this.xErrorsEntered) continue;
                d3 += this.xErrors[0][n2] * this.xErrors[0][n2];
            }
            this.responses[n5] = d / (double)n;
            if (this.yErrorsEntered) {
                this.yErrors[n5] = Math.sqrt(d2) / (double)n;
            }
            if (this.xErrorsEntered) {
                this.xErrors[0][n5] = Math.sqrt(d3) / (double)n;
            }
            for (n4 = n5 + 1; n4 < this.nAnalyteConcns - n + 1; ++n4) {
                this.analyteConcns[n4] = this.analyteConcns[n4 + n - 1];
                this.responses[n4] = this.responses[n4 + n - 1];
                if (this.yErrorsEntered) {
                    this.yErrors[n4] = this.yErrors[n4 + n - 1];
                }
                if (this.xErrorsEntered) {
                    this.xErrors[0][n4] = this.xErrors[0][n4 + n - 1];
                }
                if (this.analyteConcnFlag == 1) {
                    this.log10AnalyteConcns[n4] = this.log10AnalyteConcns[n4 + n - 1];
                }
                if (this.analyteConcnFlag != 2) continue;
                this.logeAnalyteConcns[n4] = this.logeAnalyteConcns[n4 + n - 1];
            }
            this.nAnalyteConcns = this.nAnalyteConcns - n + 1;
        }
        if (this.nAnalyteConcns < n3) {
            double[] dArray2 = this.analyteConcns;
            this.analyteConcns = new double[this.nAnalyteConcns];
            for (n = 0; n < this.nAnalyteConcns; ++n) {
                this.analyteConcns[n] = dArray2[n];
            }
            dArray2 = this.responses;
            this.responses = new double[this.nAnalyteConcns];
            for (n = 0; n < this.nAnalyteConcns; ++n) {
                this.responses[n] = dArray2[n];
            }
            dArray2 = this.yErrors;
            this.yErrors = new double[this.nAnalyteConcns];
            for (n = 0; n < this.nAnalyteConcns; ++n) {
                this.weight[n] = dArray2[n];
            }
            if (this.xErrorsEntered) {
                dArray2 = this.xErrors[0];
                this.xErrors = new double[1][this.nAnalyteConcns];
                for (n = 0; n < this.nAnalyteConcns; ++n) {
                    this.xErrors[0][n] = dArray2[n];
                }
            }
            if (this.analyteConcnFlag == 1) {
                dArray2 = this.log10AnalyteConcns;
                this.log10AnalyteConcns = new double[this.nAnalyteConcns];
                for (n = 0; n < this.nAnalyteConcns; ++n) {
                    this.log10AnalyteConcns[n] = dArray2[n];
                }
            }
            if (this.analyteConcnFlag == 2) {
                dArray2 = this.logeAnalyteConcns;
                this.logeAnalyteConcns = new double[this.nAnalyteConcns];
                for (n = 0; n < this.nAnalyteConcns; ++n) {
                    this.logeAnalyteConcns[n] = dArray2[n];
                }
            }
        }
        this.nPlot = this.nAnalyteConcns;
        switch (this.analyteConcnFlag) {
            case 0: {
                this.log10AnalyteConcns = this.log10(this.analyteConcns);
                this.logeAnalyteConcns = this.loge(this.analyteConcns);
                break;
            }
            case 1: {
                this.logeAnalyteConcns = this.loge(this.analyteConcns);
                break;
            }
            case 2: {
                this.log10AnalyteConcns = this.log10(this.analyteConcns);
            }
        }
        n2 = 0;
        this.responsesPlot = true;
        for (n = 0; n < this.nAnalyteConcns; ++n) {
            if (!(this.responses[n] <= 0.0)) continue;
            ++n2;
        }
        if (n2 == 1) {
            if (this.responses[0] <= 0.0) {
                --this.nPlot;
                this.responsesPlot = true;
            } else {
                this.responsesPlot = false;
            }
        } else if (n2 > 1) {
            this.responsesPlot = false;
        }
        if (this.responsesPlot) {
            switch (this.responsesFlag) {
                case 0: {
                    this.log10Responses = this.log10(this.responses);
                    this.logeResponses = this.loge(this.analyteConcns);
                    break;
                }
                case 1: {
                    this.logeResponses = this.loge(this.responses);
                    break;
                }
                case 2: {
                    this.log10Responses = this.log10(this.responses);
                }
            }
        }
        CubicSpline.supress();
        double[][] dArray3 = new double[1][this.nResponses];
        dArray3[0] = this.analyteConcns;
        if (this.xErrorsEntered) {
            super.setDefaultValues(dArray3, this.responses, this.xErrors, this.yErrors);
        } else {
            super.setDefaultValues(dArray3, this.responses, this.yErrors);
        }
        this.responsesMax = Fmath.maximum(this.responses);
        this.responsesMin = Fmath.minimum(this.responses);
        this.responsesRange = this.responsesMax - this.responsesMin;
        this.setInterpolationData();
        if (this.nAnalyteConcns <= 3) {
            this.anscombeC = this.critValuesFive[0];
        } else if (this.nAnalyteConcns >= 120) {
            this.anscombeC = this.critValuesFive[19];
        } else {
            this.critValues = this.confidenceLevel == 0.95 ? new CubicSpline(this.critSize, this.critValuesFive) : new CubicSpline(this.critSize, this.critValuesOne);
            this.anscombeC = this.critValues.interpolate(this.nAnalyteConcns);
        }
        this.setDataOneDone = true;
    }

    public void setNintyNineLevel() {
        this.confidenceLevel = 0.99;
    }

    public void setNintyFiveLevel() {
        this.confidenceLevel = 0.95;
    }

    private void setInterpolationData() {
        this.interpolationConcns = new double[this.nInterp];
        this.calculatedResponses = new double[this.nInterp];
        double d = (this.analyteConcns[this.nAnalyteConcns - 1] - this.analyteConcns[0]) / (double)(this.nInterp - 1);
        this.interpolationConcns[0] = this.analyteConcns[0];
        for (int j = 1; j < this.nInterp - 1; ++j) {
            this.interpolationConcns[j] = this.interpolationConcns[j - 1] + d;
        }
        this.interpolationConcns[this.nInterp - 1] = this.analyteConcns[this.nAnalyteConcns - 1];
    }

    public void resetPlotOption(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("The plot option, " + n + ", must be greater than or equal to 0 and less than 5");
        }
        this.plotOptions = n;
    }

    private void supressPlot() {
        this.supressPlot = true;
    }

    private void unsupressPlot() {
        this.supressPlot = false;
    }

    private int plott() {
        int n = 1;
        double[][] dArrayArray = new double[4][];
        Plot plot = null;
        switch (this.plotOptions) {
            case 0: {
                dArrayArray[0] = this.analyteConcns;
                dArrayArray[1] = this.responses;
                dArrayArray[2] = this.interpolationConcns;
                dArrayArray[3] = this.calculatedResponses;
                plot = new PlotGraph(dArrayArray);
                plot.setXaxisLegend("Analyte concentration (a)");
                plot.setYaxisLegend("Assay response (r) ");
                break;
            }
            case 1: {
                int n2 = this.nAnalyteConcns;
                int n3 = this.nInterp;
                if (n2 != this.nPlot) {
                    n2 = this.nPlot;
                    n3 = this.nInterp - 1;
                }
                dArrayArray[0] = new double[n2];
                dArrayArray[1] = new double[n2];
                dArrayArray[2] = new double[n3];
                dArrayArray[3] = new double[n3];
                if (n2 != this.nAnalyteConcns) {
                    int n4;
                    for (n4 = 1; n4 < this.nAnalyteConcns; ++n4) {
                        dArrayArray[0][n4 - 1] = this.log10AnalyteConcns[n4];
                        dArrayArray[1][n4 - 1] = this.responses[n4];
                    }
                    for (n4 = 1; n4 < this.nInterp; ++n4) {
                        dArrayArray[2][n4 - 1] = Math.log10(this.interpolationConcns[n4]);
                        dArrayArray[3][n4 - 1] = this.calculatedResponses[n4];
                    }
                } else {
                    dArrayArray[0] = this.log10AnalyteConcns;
                    dArrayArray[1] = this.responses;
                    dArrayArray[3] = this.calculatedResponses;
                    dArrayArray[2] = new double[this.nInterp];
                    for (int j = 0; j < this.nInterp; ++j) {
                        dArrayArray[2][j] = Math.log10(this.interpolationConcns[j]);
                    }
                }
                plot = new PlotGraph(dArrayArray);
                plot.setXaxisLegend("Log10[ Analyte concentration (a) ]");
                plot.setYaxisLegend("Assay response (r) ");
                break;
            }
            case 2: {
                int n2 = this.nAnalyteConcns;
                int n3 = this.nInterp;
                if (n2 != this.nPlot) {
                    n2 = this.nPlot;
                    n3 = this.nInterp - 1;
                }
                dArrayArray[0] = new double[n2];
                dArrayArray[1] = new double[n2];
                dArrayArray[2] = new double[n3];
                dArrayArray[3] = new double[n3];
                if (n2 != this.nAnalyteConcns) {
                    int n5;
                    for (n5 = 1; n5 < this.nAnalyteConcns; ++n5) {
                        dArrayArray[0][n5 - 1] = this.logeAnalyteConcns[n5];
                        dArrayArray[1][n5 - 1] = this.responses[n5];
                    }
                    for (n5 = 1; n5 < this.nInterp; ++n5) {
                        dArrayArray[2][n5 - 1] = Math.log(this.interpolationConcns[n5]);
                        dArrayArray[3][n5 - 1] = this.calculatedResponses[n5];
                    }
                } else {
                    dArrayArray[0] = this.logeAnalyteConcns;
                    dArrayArray[1] = this.responses;
                    dArrayArray[3] = this.calculatedResponses;
                    dArrayArray[2] = new double[this.nInterp];
                    for (int j = 0; j < this.nInterp; ++j) {
                        dArrayArray[2][j] = Math.log(this.interpolationConcns[j]);
                    }
                }
                plot = new PlotGraph(dArrayArray);
                plot.setXaxisLegend("Loge[ Analyte concentration (a) ]");
                plot.setYaxisLegend("Assay response (r) ");
                break;
            }
            case 3: {
                if (!this.responsesPlot) {
                    System.out.println("A log(concentration) v. log(responses) plot is not possible; zero or negative responses");
                    return -1;
                }
                int n2 = this.nAnalyteConcns;
                int n3 = this.nInterp;
                if (n2 != this.nPlot) {
                    n2 = this.nPlot;
                    n3 = this.nInterp - 1;
                }
                dArrayArray[0] = new double[n2];
                dArrayArray[1] = new double[n2];
                dArrayArray[2] = new double[n3];
                dArrayArray[3] = new double[n3];
                if (n2 != this.nAnalyteConcns) {
                    int n6;
                    for (n6 = 1; n6 < this.nAnalyteConcns; ++n6) {
                        dArrayArray[0][n6 - 1] = this.log10AnalyteConcns[n6];
                        dArrayArray[1][n6 - 1] = this.log10Responses[n6];
                    }
                    for (n6 = 1; n6 < this.nInterp; ++n6) {
                        dArrayArray[2][n6 - 1] = Math.log10(this.interpolationConcns[n6]);
                        dArrayArray[3][n6 - 1] = Math.log10(this.calculatedResponses[n6]);
                    }
                } else {
                    dArrayArray[0] = this.log10AnalyteConcns;
                    dArrayArray[1] = this.log10Responses;
                    dArrayArray[2] = new double[this.nInterp];
                    dArrayArray[3] = new double[this.nInterp];
                    for (int j = 0; j < this.nInterp; ++j) {
                        dArrayArray[2][j] = Math.log10(this.interpolationConcns[j]);
                        dArrayArray[3][j] = Math.log10(this.calculatedResponses[j]);
                    }
                }
                plot = new PlotGraph(dArrayArray);
                plot.setXaxisLegend("Log10[ Analyte concentration (a) ]");
                plot.setYaxisLegend("Log10[ Assay response (r) ]");
                break;
            }
            case 4: {
                if (!this.responsesPlot) {
                    System.out.println("A log(concentration) v. log(responses) plot is not possible; zero or negative responses");
                    return -1;
                }
                int n2 = this.nAnalyteConcns;
                int n3 = this.nInterp;
                if (n2 != this.nPlot) {
                    n2 = this.nPlot;
                    n3 = this.nInterp - 1;
                }
                dArrayArray[0] = new double[n2];
                dArrayArray[1] = new double[n2];
                dArrayArray[2] = new double[n3];
                dArrayArray[3] = new double[n3];
                if (n2 != this.nAnalyteConcns) {
                    int n7;
                    for (n7 = 1; n7 < this.nAnalyteConcns; ++n7) {
                        dArrayArray[0][n7 - 1] = this.logeAnalyteConcns[n7];
                        dArrayArray[1][n7 - 1] = this.logeResponses[n7];
                    }
                    for (n7 = 1; n7 < this.nInterp; ++n7) {
                        dArrayArray[2][n7 - 1] = Math.log(this.interpolationConcns[n7]);
                        dArrayArray[3][n7 - 1] = Math.log(this.calculatedResponses[n7]);
                    }
                } else {
                    dArrayArray[0] = this.logeAnalyteConcns;
                    dArrayArray[1] = this.logeResponses;
                    dArrayArray[2] = new double[this.nInterp];
                    dArrayArray[3] = new double[this.nInterp];
                    for (int j = 0; j < this.nInterp; ++j) {
                        dArrayArray[2][j] = Math.log(this.interpolationConcns[j]);
                        dArrayArray[3][j] = Math.log(this.calculatedResponses[j]);
                    }
                }
                plot = new PlotGraph(dArrayArray);
                plot.setXaxisLegend("Loge[ Analyte concentration (a) ]");
                plot.setYaxisLegend("Loge[ Assay response (r) ]");
            }
        }
        int[] nArray = new int[]{1, 0};
        plot.setPoint(nArray);
        int[] nArray2 = new int[]{0, 3};
        plot.setLine(nArray2);
        plot.setGraphTitle(this.titleZero);
        plot.setGraphTitle2(this.titleOne);
        ((PlotGraph)plot).plot();
        return n;
    }

    private void curveCheck(int n) {
        int n2;
        Object[] objectArray;
        int n3;
        int n4;
        this.interpStartIndex = 0;
        this.interpEndIndex = this.nInterp - 1;
        this.outlierFlag = false;
        this.outliers = new String[this.nAnalyteConcns];
        this.residualsMean = Stat.mean(this.residual);
        this.residualsSD = Stat.standardDeviation(this.residual);
        int n5 = 0;
        double d = Math.abs(this.residual[0]);
        for (n4 = 0; n4 < this.nAnalyteConcns; ++n4) {
            if (!(Math.abs(this.residual[n4]) > d)) continue;
            d = Math.abs(this.residual[n4]);
            n5 = n4;
        }
        for (n4 = 0; n4 < this.nAnalyteConcns; ++n4) {
            this.outliers[n4] = "   ";
            if (!(Math.abs(this.residual[n4] - this.residualsMean) > this.anscombeC * this.residualsSD)) continue;
            this.outliers[n4] = "possible outlier";
            if (n4 == n5) {
                int n6 = n4;
                this.outliers[n6] = this.outliers[n6] + " (***)";
            }
            this.outlierFlag = true;
        }
        n4 = 1;
        this.nTurningPoints = 0;
        boolean bl = false;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        double d2 = this.calculatedResponses[1] - this.calculatedResponses[0];
        if (d2 < 0.0) {
            n4 = -1;
        }
        if (d2 == 0.0) {
            bl = true;
        }
        for (n3 = 2; n3 < this.nInterp; ++n3) {
            if (n4 == 1) {
                if (this.calculatedResponses[n3] <= this.calculatedResponses[n3 - 1]) {
                    bl = true;
                }
            } else if (this.calculatedResponses[n3] >= this.calculatedResponses[n3 - 1]) {
                bl = true;
            }
            if (!bl) continue;
            ++this.nTurningPoints;
            arrayList.add(new Integer(n3));
            n4 = -n4;
            this.ambigCheck = true;
            bl = false;
        }
        if (this.nTurningPoints == 1) {
            this.turnIndices = new int[1];
            this.turnIndices[0] = (Integer)arrayList.get(0);
            if (this.turnIndices[0] <= this.nInterp / 2) {
                this.interpStartIndex = this.turnIndices[0];
            } else {
                this.interpEndIndex = this.turnIndices[0];
            }
            System.out.println(this.methodNames[n]);
            System.out.println("The fitted or interpolated standard curve is not monotonic");
            System.out.println("The useable analyte concentration range is " + this.interpolationConcns[this.interpStartIndex] + " to " + this.interpolationConcns[this.interpEndIndex]);
        }
        if (this.nTurningPoints > 1) {
            int n7;
            this.turnIndices = new int[this.nTurningPoints];
            for (n3 = 0; n3 < this.nTurningPoints; ++n3) {
                this.turnIndices[n3] = (Integer)arrayList.get(n3);
            }
            int[] nArray = new int[this.nTurningPoints + 1];
            objectArray = new int[this.nTurningPoints + 1];
            int[] nArray2 = new int[this.nTurningPoints + 1];
            nArray2[0] = this.turnIndices[0];
            nArray[0] = 0;
            objectArray[0] = this.turnIndices[0];
            for (n7 = 1; n7 < this.nTurningPoints; ++n7) {
                nArray2[n7] = this.turnIndices[n7] - this.turnIndices[n7 - 1];
                nArray[n7] = this.turnIndices[n7 - 1];
                objectArray[n7] = this.turnIndices[n7];
            }
            nArray2[this.nTurningPoints] = this.nInterp - 1 - this.turnIndices[this.nTurningPoints - 1];
            nArray[this.nTurningPoints] = this.turnIndices[this.nTurningPoints - 1];
            objectArray[this.nTurningPoints] = this.nInterp - 1;
            n7 = 0;
            for (int j = 0; j <= this.nTurningPoints; ++j) {
                for (n2 = 0; n2 <= this.nTurningPoints; ++n2) {
                    if (j == n2 || nArray2[j] < nArray2[n2]) continue;
                    ++n7;
                }
                if (n7 == this.nTurningPoints) {
                    this.interpStartIndex = nArray[j];
                    this.interpEndIndex = objectArray[j];
                } else {
                    n7 = 0;
                }
                if (n7 != 0) break;
            }
            System.out.println(this.methodNames[n]);
            System.out.println("The fitted or interpolated standard curve is not monotonic");
            System.out.println("The useable analyte concentration range is " + this.interpolationConcns[this.interpStartIndex] + " to " + this.interpolationConcns[this.interpEndIndex]);
        }
        this.interpAnalyteStart = this.interpolationConcns[this.interpStartIndex];
        this.interpAnalyteEnd = this.interpolationConcns[this.interpEndIndex];
        this.interpResponseStart = this.calculatedResponses[this.interpStartIndex];
        this.interpResponseEnd = this.calculatedResponses[this.interpEndIndex];
        this.nWorking = this.interpEndIndex - this.interpStartIndex + 1;
        double[] dArray = new double[this.nWorking];
        objectArray = new double[this.nWorking];
        for (int j = 0; j < this.nWorking; ++j) {
            dArray[j] = this.interpolationConcns[this.interpStartIndex + j];
            objectArray[j] = (int)this.calculatedResponses[this.interpStartIndex + j];
        }
        if (this.methodUsed == 14) {
            this.linterp = new LinearInterpolation((double[])objectArray, dArray);
        } else {
            this.interp = new CubicSpline((double[])objectArray, dArray);
        }
        this.curveDirection = true;
        if (this.interpResponseStart > this.interpResponseEnd) {
            this.curveDirection = false;
        }
        this.workingResponseMin = Fmath.minimum(this.calculatedResponses);
        if (this.curveDirection) {
            if (this.workingResponseMin < this.interpResponseStart) {
                this.workingResponseMin = this.interpResponseStart;
            }
        } else if (this.workingResponseMin < this.interpResponseEnd) {
            this.workingResponseMin = this.interpResponseEnd;
        }
        this.workingResponseMax = Fmath.maximum(this.calculatedResponses);
        if (this.curveDirection) {
            if (this.workingResponseMax > this.interpResponseEnd) {
                this.workingResponseMax = this.interpResponseEnd;
            }
        } else if (this.workingResponseMax > this.interpResponseStart) {
            this.workingResponseMax = this.interpResponseStart;
        }
        double[] dArray2 = new double[this.nWorking];
        double d3 = Math.sqrt(this.sumOfSquaresError / (double)(this.nAnalyteConcns - this.nParam));
        if (this.sampleErrorFlag) {
            int n8;
            double[] dArray3;
            int n9;
            int n10;
            if (!this.yErrorsEntered) {
                for (n2 = 0; n2 < this.nWorking; ++n2) {
                    dArray2[n2] = d3;
                }
            } else {
                Object object;
                int n11;
                n2 = 1;
                int n12 = 0;
                int n13 = this.nAnalyteConcns - 1;
                n10 = 0;
                if (this.ambigCheck) {
                    for (n9 = 0; n9 < this.nAnalyteConcns; ++n9) {
                        if (this.interpAnalyteStart >= this.analyteConcns[n9]) {
                            n12 = n9;
                            n10 = 1;
                        }
                        if (n10 != 0) break;
                    }
                    n10 = 0;
                    for (n9 = this.nAnalyteConcns - 1; n9 >= 0; --n9) {
                        if (this.interpAnalyteEnd <= this.analyteConcns[n9]) {
                            n13 = n9;
                            n10 = 1;
                        }
                        if (n10 != 0) break;
                    }
                }
                n9 = n13 - n12 + 1;
                dArray3 = new double[n9];
                for (int j = 0; j < n9; ++j) {
                    dArray3[j] = this.yErrors[j + n12];
                }
                n2 = ImmunoAssay.isMonotonic(dArray3) ? 1 : 0;
                if (n2 != 0) {
                    double d4;
                    double d5 = d4 = Math.abs(dArray3[1] - dArray3[0]);
                    for (n11 = 2; n11 < n9; ++n11) {
                        d4 = Math.abs(dArray3[n11] - dArray3[n11 - 1]);
                        if (!(d4 > d5)) continue;
                        d5 = d4;
                    }
                    if (d5 > 0.6 * Math.abs(Fmath.maximum(dArray3) - Fmath.minimum(dArray3))) {
                        n2 = 0;
                    }
                }
                double[] dArray4 = new double[this.nAnalyteConcns];
                double d6 = d3 / this.weightsMean;
                for (int j = 0; j < this.nAnalyteConcns; ++j) {
                    dArray4[j] = this.yErrors[j] * d6;
                }
                if (this.yErrorsEntered && n2 == 0) {
                    object = new LinearInterpolation(this.analyteConcns, dArray4);
                    for (n11 = 0; n11 < this.nWorking; ++n11) {
                        dArray2[n11] = Math.abs(((LinearInterpolation)object).interpolate(dArray[n11]));
                    }
                } else {
                    object = new CubicSpline(this.analyteConcns, dArray4);
                    for (n11 = 0; n11 < this.nWorking; ++n11) {
                        dArray2[n11] = Math.abs(((CubicSpline)object).interpolate(dArray[n11]));
                    }
                }
            }
            this.errorp = new CubicSpline((double[])objectArray, dArray2);
            this.propagatedErrors = new String[this.nAnalyteConcns];
            double d7 = 0.0;
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            for (n10 = 0; n10 < this.nAnalyteConcns; ++n10) {
                n9 = 0;
                if (this.curveDirection) {
                    if (this.responses[n10] < this.interpResponseStart || this.responses[n10] > this.interpResponseEnd) {
                        n9 = 1;
                    }
                } else if (this.responses[n10] > this.interpResponseStart || this.responses[n10] < this.interpResponseEnd) {
                    n9 = 1;
                }
                if (n9 != 0) {
                    this.propagatedErrors[n10] = "**";
                    continue;
                }
                arrayList2.add(new Double(this.responses[n10]));
                d7 = this.getSampleConcn(this.responses[n10]);
                d7 = this.getSampleConcnError();
                arrayList2.add(new Double(d7));
                d7 = Fmath.truncate(d7, this.prec);
                this.propagatedErrors[n10] = new Double(d7).toString();
            }
            n10 = arrayList2.size() / 2;
            double[] dArray5 = new double[n10];
            dArray3 = new double[n10];
            for (int j = 0; j < n10; ++j) {
                dArray5[j] = (Double)arrayList2.get(2 * j);
                dArray3[j] = (Double)arrayList2.get(2 * j + 1);
            }
            CubicSpline cubicSpline = new CubicSpline(dArray5, dArray3);
            double[] dArray6 = new double[1001];
            double[] dArray7 = new double[1001];
            dArray6[0] = dArray5[0];
            dArray6[1000] = dArray5[n10 - 1];
            double d8 = (dArray5[n10 - 1] - dArray5[0]) / 1000.0;
            for (n8 = 1; n8 < 1000; ++n8) {
                dArray6[n8] = dArray6[n8 - 1] + d8;
            }
            for (n8 = 0; n8 < 1001; ++n8) {
                dArray7[n8] = cubicSpline.interpolate(dArray6[n8]);
            }
            Stat stat = new Stat(dArray7);
            this.minimumAerror = stat.minimum();
            this.maximumAerror = stat.maximum();
            this.meanAerror = stat.mean();
            this.sdAerror = stat.standardDeviation();
        }
    }

    public double getSampleConcn(double d) {
        this.sampleResponse = d;
        double d2 = Double.NaN;
        boolean bl = false;
        if (this.curveDirection) {
            if (d < this.interpResponseStart || d > this.interpResponseEnd) {
                bl = true;
            }
        } else if (d > this.interpResponseStart || d < this.interpResponseEnd) {
            bl = true;
        }
        if (bl) {
            if (this.ambigCheck) {
                System.out.println("The sample response, " + d + ", is outside the useable part of the standard curve:");
            } else {
                System.out.println("The sample response, " + d + ", is outside the limits of the standard curve:");
            }
            System.out.println(this.interpResponseStart + " to " + this.interpResponseEnd);
            System.out.println("NaN returned");
            return d2;
        }
        d2 = this.methodUsed == 14 ? this.linterp.interpolate(d) : this.interp.interpolate(d);
        this.sampleConcn = d2;
        this.sampleError = Double.NaN;
        if (this.sampleErrorFlag) {
            double d3 = this.errorp.interpolate(d);
            double d4 = d - d3;
            if (d4 < this.workingResponseMin) {
                d4 = this.workingResponseMin;
            }
            double d5 = (d - d4) / d3;
            double d6 = this.interp.interpolate(d4);
            double d7 = d + d3;
            if (d7 > this.workingResponseMax) {
                d7 = this.workingResponseMax;
            }
            double d8 = this.interp.interpolate(d7);
            this.sampleError = Math.abs(d8 - d6) / (d5 += (d7 - d) / d3);
        }
        return d2;
    }

    public double getSampleConcnError() {
        if (this.methodUsed == 0) {
            System.out.println("ImmunoAssay method: getSampleConcnError()");
            System.out.println("A sample concentration error is not meaningful in the case of a cubic spline interpolation");
            System.out.println("NaN returned");
        }
        if (this.methodUsed == 1) {
            System.out.println("ImmunoAssay method: getSampleConcnError()");
            System.out.println("A sample concentration error is not meaningful in the case of a cubic interpolation");
            System.out.println("NaN returned");
        }
        if (this.methodUsed == 14) {
            System.out.println("ImmunoAssay method: getSampleConcnError()");
            System.out.println("A sample concentration error is not meaningful in the case of a linear interpolation");
            System.out.println("NaN returned");
        }
        return this.sampleError;
    }

    public void resetNfittedCurve(int n) {
        this.nInterp = n;
    }

    public double[] getFittedStandardCurveConcns() {
        return Conv.copy(this.interpolationConcns);
    }

    public double[] getFittedStandardCurveResponses() {
        return Conv.copy(this.calculatedResponses);
    }

    public double[] getWorkingConcentrationRange() {
        double[] dArray = new double[]{this.interpAnalyteStart, this.interpAnalyteEnd};
        return dArray;
    }

    public double[] getWorkingResponseRange() {
        double[] dArray = new double[]{this.interpResponseStart, this.interpResponseEnd};
        return dArray;
    }

    public double[] getModelParameterValues() {
        return Conv.copy(this.best);
    }

    public double[] getModelParameterErrors() {
        return Conv.copy(this.bestSd);
    }

    public int getNumberOfTurningPoints() {
        return this.nTurningPoints;
    }

    @Override
    public double getSumOfSquares() {
        return this.sumOfSquaresError;
    }

    public double getUnWeightedSumOfSquares() {
        return this.sumOfSquaresError;
    }

    public double getWeightedSumOfSquares() {
        return this.chiSquare;
    }

    public double[] getTurningPointConcns() {
        double[] dArray = null;
        if (this.nTurningPoints > 0) {
            dArray = new double[this.nTurningPoints];
            for (int j = 0; j < this.nTurningPoints; ++j) {
                dArray[j] = this.interpolationConcns[this.turnIndices[j]];
            }
        }
        return dArray;
    }

    public double[] getTurningPointResponses() {
        double[] dArray = null;
        if (this.nTurningPoints > 0) {
            dArray = new double[this.nTurningPoints];
            for (int j = 0; j < this.nTurningPoints; ++j) {
                dArray[j] = this.calculatedResponses[this.turnIndices[j]];
            }
        }
        return dArray;
    }

    @Override
    public void print() {
        this.print(this.filename);
    }

    @Override
    public void print(String string) {
        boolean bl = true;
        switch (this.methodUsed) {
            case 0: {
                System.out.println("There is no text file associated with the cubic spline interpolation method");
                bl = false;
                break;
            }
            case 1: {
                System.out.println("There is no text file associated with the cubic interpolation method");
                bl = false;
                break;
            }
            case 14: {
                System.out.println("There is no text file associated with the linear interpolation method");
                bl = false;
            }
        }
        if (bl) {
            int n = string.indexOf(".");
            if (n == -1) {
                string = string + ".txt";
            }
            this.filename = string;
            FileOutput fileOutput = new FileOutput(string);
            fileOutput.println(this.titleZero);
            if (this.dataRead) {
                fileOutput.println("Data input file name:   " + this.dataFilename);
            }
            fileOutput.dateAndTimeln(string);
            this.commonPrint(fileOutput);
            fileOutput.println();
            fileOutput.println("End of file");
            fileOutput.close();
        }
    }

    public void commonPrint(FileOutput fileOutput) {
        int n;
        int n2;
        fileOutput.println();
        fileOutput.println(this.titleOne);
        fileOutput.println("r = assay response;  a = analyte concentration");
        boolean bl = false;
        String[] stringArray = null;
        Object var4_4 = null;
        switch (this.methodUsed) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                stringArray = new String[this.polyDegree + 1];
                for (n2 = 0; n2 <= this.polyDegree; ++n2) {
                    stringArray[n2] = "c[" + n2 + "]";
                }
                bl = false;
                break;
            }
            case 3: {
                stringArray = new String[this.bestPolyDegree + 1];
                for (n2 = 0; n2 <= this.bestPolyDegree; ++n2) {
                    stringArray[n2] = "c[" + n2 + "]";
                }
                bl = false;
                break;
            }
            case 4: {
                fileOutput.println("n = " + (this.polyNterms - 1));
                stringArray = new String[2 * this.polyNterms - 1];
                for (n2 = 0; n2 < 2 * this.polyNterms - 1; ++n2) {
                    stringArray[n2] = "c[" + n2 + "]";
                }
                bl = true;
                break;
            }
            case 5: {
                stringArray = new String[]{"alpha", "theta", "A"};
                bl = true;
                break;
            }
            case 6: {
                stringArray = new String[]{"theta", "n", "A"};
                bl = true;
                break;
            }
            case 7: {
                stringArray = new String[]{"top", "bottom", "C50", "Hill Slope"};
                bl = true;
                break;
            }
            case 8: {
                stringArray = new String[]{"top", "bottom", "C50", "HillSlope", "Asymm"};
                bl = true;
                break;
            }
            case 9: {
                stringArray = new String[]{"theta", "alpha", "A"};
                bl = true;
                break;
            }
            case 10: {
                stringArray = new String[]{"theta", "A"};
                bl = true;
                break;
            }
            case 11: {
                stringArray = new String[]{"K", "L", "P", "N", "S"};
                bl = true;
                break;
            }
            case 12: {
                fileOutput.println("top =    " + this.top);
                fileOutput.println("bottom = " + this.bottom);
                stringArray = new String[]{"C50", "Hill Slope"};
                bl = true;
                break;
            }
            case 13: {
                fileOutput.println("top =    " + this.top);
                fileOutput.println("bottom = " + this.bottom);
                stringArray = new String[]{"C50", "HillSlope", "Asymm"};
                bl = true;
                break;
            }
            case 14: {
                break;
            }
            default: {
                throw new IllegalArgumentException("methodUsed " + this.methodUsed + " not recognised");
            }
        }
        if (bl) {
            fileOutput.println();
            fileOutput.println("Non-linear regression (Nelder and Mead simplex procedure)");
            if (!this.nlrStatus) {
                fileOutput.println("Convergence criterion was not satisfied");
                fileOutput.println("The following results are, or are derived from, the current estimates on exiting the regression method");
                fileOutput.println();
            }
            fileOutput.println("Estimated parameters");
            fileOutput.println("The statistics are obtained assuming that the model behaves as a linear model about the minimum.");
            fileOutput.println("The Hessian matrix is calculated as the numerically derived second derivatives of chi square with respect to all pairs of parameters.");
            if (this.zeroCheck) {
                fileOutput.println("The best estimate/s equal to zero were replaced by the step size in the numerical differentiation!!!");
            }
            fileOutput.println("Consequentlty treat the statistics with great caution.");
            if (!this.posVarFlag) {
                fileOutput.println("Covariance matrix contains at least one negative diagonal element");
                fileOutput.println(" - all variances are dubious");
                fileOutput.println(" - may not be at a minimum or the model may be so non-linear that the linear approximation in calculating the statisics is invalid");
            }
            if (!this.invertFlag) {
                fileOutput.println("Hessian matrix is singular");
                fileOutput.println(" - variances cannot be calculated");
                fileOutput.println(" - may not be at a minimum  or the model may be so non-linear that the linear approximation in calculating the statisics is invalid");
            }
        } else {
            fileOutput.println("Linear regression");
        }
        fileOutput.println();
        fileOutput.printtab(" ", this.field);
        if (this.invertFlag) {
            fileOutput.printtab("Best", this.field);
            fileOutput.printtab("Estimate of", this.field);
            fileOutput.printtab("Coefficient", this.field);
            fileOutput.printtab("t-value", this.field);
            fileOutput.println("p-value");
        } else {
            fileOutput.println("Best");
        }
        if (this.invertFlag) {
            fileOutput.printtab(" ", this.field);
            fileOutput.printtab("estimate", this.field);
            fileOutput.printtab("the error", this.field);
            fileOutput.printtab("of", this.field);
            fileOutput.printtab("t", this.field);
            fileOutput.println("P > |t|");
        } else {
            fileOutput.printtab(" ", this.field);
            fileOutput.println("estimate");
        }
        if (this.invertFlag) {
            fileOutput.printtab(" ", this.field);
            fileOutput.printtab(" ", this.field);
            fileOutput.printtab(" ", this.field);
            fileOutput.println("variation (%)");
        } else {
            fileOutput.println("   ");
        }
        for (n2 = 0; n2 < this.nParam; ++n2) {
            if (this.invertFlag) {
                fileOutput.printtab(stringArray[n2], this.field);
                fileOutput.printtab(Fmath.truncate(this.best[n2], this.prec), this.field);
                fileOutput.printtab(Fmath.truncate(this.bestSd[n2], this.prec), this.field);
                fileOutput.printtab(Fmath.truncate(Math.abs(this.bestSd[n2] * 100.0 / this.best[n2]), this.prec), this.field);
                fileOutput.printtab(Fmath.truncate(this.tValues[n2], this.prec), this.field);
                fileOutput.println(Fmath.truncate(this.pValues[n2], this.prec));
                continue;
            }
            fileOutput.printtab(stringArray[n2], this.field);
            fileOutput.println(Fmath.truncate(this.best[n2], this.prec));
        }
        fileOutput.println();
        if (bl) {
            fileOutput.printtab(" ", this.field);
            fileOutput.printtab("Best", this.field);
            fileOutput.printtab("Pre-minimum", this.field);
            fileOutput.printtab("Post-minimum", this.field);
            fileOutput.printtab("Initial", this.field);
            fileOutput.println("Fractional");
            fileOutput.printtab(" ", this.field);
            fileOutput.printtab("estimate", this.field);
            fileOutput.printtab("gradient", this.field);
            fileOutput.printtab("gradient", this.field);
            fileOutput.printtab("estimate", this.field);
            fileOutput.println("step");
            for (n2 = 0; n2 < this.nParam; ++n2) {
                fileOutput.printtab(stringArray[n2], this.field);
                fileOutput.printtab(Fmath.truncate(this.best[n2], this.prec), this.field);
                fileOutput.printtab(Fmath.truncate(this.grad[n2][0], this.prec), this.field);
                fileOutput.printtab(Fmath.truncate(this.grad[n2][1], this.prec), this.field);
                fileOutput.printtab(Fmath.truncate(this.startH[n2], this.prec), this.field);
                fileOutput.println(Fmath.truncate(this.stepH[n2], this.prec));
            }
            fileOutput.println();
        }
        n2 = 0;
        fileOutput.printtab("analyte", this.field);
        fileOutput.printtab("observed", this.field);
        fileOutput.printtab("calculated", this.field);
        fileOutput.printtab("weight", this.field);
        fileOutput.printtab("unweighted", this.field);
        fileOutput.printtab("weighted", this.field);
        fileOutput.printtab("estimated analyte", this.field);
        fileOutput.println("outliers");
        fileOutput.printtab("concn ", this.field);
        fileOutput.printtab("response", this.field);
        fileOutput.printtab("response", this.field);
        fileOutput.printtab("     ", this.field);
        fileOutput.printtab("residual", this.field);
        fileOutput.printtab("residual", this.field);
        fileOutput.printtab("concn error *", this.field);
        fileOutput.println("   ");
        for (n = 0; n < this.nAnalyteConcns; ++n) {
            fileOutput.printtab(Fmath.truncate(this.xData[0][n2], this.prec), this.field);
            fileOutput.printtab(Fmath.truncate(this.yData[n2], this.prec), this.field);
            fileOutput.printtab(Fmath.truncate(this.yCalc[n2], this.prec), this.field);
            fileOutput.printtab(Fmath.truncate(this.weight[n2], this.prec), this.field);
            fileOutput.printtab(Fmath.truncate(this.residual[n2], this.prec), this.field);
            fileOutput.printtab(Fmath.truncate(this.residualW[n2], this.prec), this.field);
            fileOutput.printtab(this.propagatedErrors[n2], this.field);
            fileOutput.println(this.outliers[n]);
            ++n2;
        }
        fileOutput.println();
        fileOutput.println("*  The estimated error in the estimated concentration on entering this response via getSampleConcn(response)");
        fileOutput.println("** Outside the working range");
        fileOutput.println("Mean of the unweighted residuals =               " + Fmath.truncate(this.residualsMean, this.prec));
        fileOutput.println("Standard deviation of the unweighted residuals = " + Fmath.truncate(this.residualsSD, this.prec));
        fileOutput.println("Outlier critical value at the " + this.confidenceLevel * 100.0 + " confidence level = " + Fmath.truncate(this.anscombeC * this.residualsSD + this.residualsMean, this.prec));
        if (this.outlierFlag) {
            fileOutput.println("*** the most extreme possible outlier");
        }
        fileOutput.println();
        fileOutput.println("Minimum estimated interpolated concentration error:                   " + Fmath.truncate(this.minimumAerror, this.prec));
        fileOutput.println("Maximum estimated interpolated concentration error:                   " + Fmath.truncate(this.maximumAerror, this.prec));
        fileOutput.println("Mean estimated interpolated concentration error:                      " + Fmath.truncate(this.meanAerror, this.prec));
        fileOutput.println("Standard deviation of the estimated interpolated concentration error: " + Fmath.truncate(this.sdAerror, this.prec));
        fileOutput.println();
        fileOutput.printtab("Degrees of freedom");
        fileOutput.println(this.degreesOfFreedom);
        fileOutput.printtab("Number of data points");
        fileOutput.println(this.nData);
        fileOutput.printtab("Number of estimated paramaters");
        fileOutput.println(this.nParam);
        fileOutput.printtab("Sum of squares of the unweighted residuals");
        fileOutput.println(Fmath.truncate(this.sumOfSquaresError, this.prec));
        if (this.weightOpt) {
            fileOutput.printtab("Chi Square");
            fileOutput.println(Fmath.truncate(this.chiSquare, this.prec));
            fileOutput.printtab("Reduced Chi Square");
            fileOutput.println(Fmath.truncate(this.reducedChiSquare, this.prec));
        }
        if (bl) {
            fileOutput.println("Correlation: analyte concentration and responses");
            fileOutput.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient (R)");
            fileOutput.println(Fmath.truncate(this.xyR, this.prec));
            if (Math.abs(this.xyR) <= 1.0) {
                fileOutput.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient Probability");
                fileOutput.println(Fmath.truncate(Stat.linearCorrCoeffProb(this.xyR, this.nData - 2), this.prec));
            }
            fileOutput.println(" ");
            fileOutput.println("Correlation: observed responses and calculated responses");
            fileOutput.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient");
            fileOutput.println(Fmath.truncate(this.yyR, this.prec));
            if (Math.abs(this.yyR) <= 1.0) {
                fileOutput.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient Probability");
                fileOutput.println(Fmath.truncate(Stat.linearCorrCoeffProb(this.yyR, this.nData - 2), this.prec));
            }
            fileOutput.println();
            fileOutput.printtab("Durbin-Watson d statistic");
            fileOutput.println(Fmath.truncate(super.getDurbinWatsonD(), this.prec));
            fileOutput.println();
            if (this.posVarFlag && this.invertFlag && this.chiSquare != 0.0) {
                fileOutput.println("Parameter - parameter correlation coefficients");
                fileOutput.printtab(" ", this.field);
                for (n = 0; n < this.nParam; ++n) {
                    fileOutput.printtab(stringArray[n], this.field);
                }
                fileOutput.println();
                fileOutput.println();
                for (n = 0; n < this.nParam; ++n) {
                    fileOutput.printtab(stringArray[n], this.field);
                    for (int j = 0; j < this.nParam; ++j) {
                        fileOutput.printtab(Fmath.truncate(this.corrCoeff[j][n], this.prec), this.field);
                    }
                    fileOutput.println();
                }
            }
            fileOutput.println();
            fileOutput.println("Coefficient of determination, R =                   " + Fmath.truncate(this.multR, this.prec));
            fileOutput.println("Adjusted Coefficient of determination, R' =         " + Fmath.truncate(this.adjustedR, this.prec));
            fileOutput.println("Coefficient of determination, F-ratio =             " + Fmath.truncate(this.multipleF, this.prec));
            fileOutput.println("Coefficient of determination, F-ratio probability = " + Fmath.truncate(this.multipleFprob, this.prec));
            fileOutput.println("Total (weighted) sum of squares  =                  " + Fmath.truncate(this.sumOfSquaresTotal, this.prec));
            fileOutput.println("Regression (weighted) sum of squares  =             " + Fmath.truncate(this.sumOfSquaresRegrn, this.prec));
            fileOutput.println("Error (weighted) sum of squares  =                  " + Fmath.truncate(this.chiSquare, this.prec));
            fileOutput.println();
            fileOutput.printtab("Number of iterations taken");
            fileOutput.println(this.nIter);
            fileOutput.printtab("Maximum number of iterations allowed");
            fileOutput.println(this.nMax);
            fileOutput.printtab("Number of restarts taken");
            fileOutput.println(this.kRestart);
            fileOutput.printtab("Maximum number of restarts allowed");
            fileOutput.println(this.konvge);
            fileOutput.printtab("Standard deviation of the simplex at the minimum");
            fileOutput.println(Fmath.truncate(this.simplexSd, this.prec));
            fileOutput.printtab("Convergence tolerance");
            fileOutput.println(this.fTol);
            switch (this.minTest) {
                case 0: {
                    fileOutput.println("simplex sd < the tolerance times the mean of the absolute values of the y values");
                    break;
                }
                case 1: {
                    fileOutput.println("simplex sd < the tolerance");
                    break;
                }
                case 2: {
                    fileOutput.println("simplex sd < the tolerance times the square root(sum of squares/degrees of freedom");
                }
            }
            fileOutput.println("Step used in numerical differentiation to obtain Hessian matrix");
            fileOutput.println("d(parameter) = parameter*" + this.delta);
        } else {
            fileOutput.println(" ");
            fileOutput.println("Correlation: analyte concentrations and responses");
            fileOutput.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient (R)");
            fileOutput.println(Fmath.truncate(this.xyR, this.prec));
            if (Math.abs(this.xyR) <= 1.0) {
                fileOutput.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient Probability");
                fileOutput.println(Fmath.truncate(Stat.linearCorrCoeffProb(this.xyR, this.nData - 2), this.prec));
            }
            fileOutput.println(" ");
            fileOutput.println("Correlation: observed responses and calculated responses");
            fileOutput.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient");
            fileOutput.println(Fmath.truncate(this.yyR, this.prec));
            if (Math.abs(this.yyR) <= 1.0) {
                fileOutput.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient Probability");
                fileOutput.println(Fmath.truncate(Stat.linearCorrCoeffProb(this.yyR, this.nData - 2), this.prec));
            }
            fileOutput.println();
            fileOutput.println();
            if (this.chiSquare != 0.0) {
                fileOutput.println("Correlation coefficients");
                fileOutput.printtab(" ", this.field);
                for (n = 0; n < this.nParam; ++n) {
                    fileOutput.printtab(stringArray[n], this.field);
                }
                fileOutput.println();
                for (n = 0; n < this.nParam; ++n) {
                    fileOutput.printtab(stringArray[n], this.field);
                    for (int j = 0; j < this.nParam; ++j) {
                        fileOutput.printtab(Fmath.truncate(this.corrCoeff[j][n], this.prec), this.field);
                    }
                    fileOutput.println();
                }
            }
            fileOutput.println();
            fileOutput.printtab("Durbin-Watson d statistic");
            fileOutput.println(Fmath.truncate(super.getDurbinWatsonD(), this.prec));
            fileOutput.println();
            if (this.bestPolyFlag) {
                fileOutput.println("Method bestPolynomial search history");
                fileOutput.println("F-probability significance level: " + this.fProbSignificance + " (" + this.fProbSignificance * 100.0 + " %)");
                fileOutput.println("Degree of best fit polynomial " + this.bestPolynomialDegree);
                fileOutput.println(" ");
                fileOutput.print("Polynomial degree", 2 * this.field);
                fileOutput.print("chi square", 2 * this.field);
                fileOutput.print("F-ratio", this.field);
                fileOutput.print("F-probability", this.field + 2);
                fileOutput.println("F-value at the");
                fileOutput.print("comparison", 2 * this.field);
                fileOutput.print("comparison", 2 * this.field);
                fileOutput.print("   ", this.field);
                fileOutput.print("   ", this.field + 2);
                fileOutput.println("significance level");
                n = (Integer)this.bestPolyArray.get(1);
                int[] nArray = (int[])this.bestPolyArray.get(2);
                int[] nArray2 = (int[])this.bestPolyArray.get(3);
                double[] dArray = (double[])this.bestPolyArray.get(4);
                double[] dArray2 = (double[])this.bestPolyArray.get(5);
                double[] dArray3 = (double[])this.bestPolyArray.get(6);
                double[] dArray4 = (double[])this.bestPolyArray.get(7);
                double[] dArray5 = (double[])this.bestPolyArray.get(8);
                for (int j = 0; j < n; ++j) {
                    fileOutput.print(nArray[j], this.field);
                    fileOutput.print(nArray2[j], this.field);
                    fileOutput.print(Fmath.truncate(dArray[j], this.prec), this.field);
                    fileOutput.print(Fmath.truncate(dArray2[j], this.prec), this.field);
                    fileOutput.print(Fmath.truncate(dArray3[j], this.prec), this.field);
                    fileOutput.print(Fmath.truncate(dArray4[j], this.prec), this.field + 2);
                    fileOutput.println(Fmath.truncate(dArray5[j], this.prec));
                }
            }
            fileOutput.println();
            fileOutput.println("Coefficient of determination,   =                   " + Fmath.truncate(this.multR, this.prec));
            fileOutput.println("Adjusted Coefficient of determination,    =         " + Fmath.truncate(this.adjustedR, this.prec));
            fileOutput.println("Coefficient of determination, F-ratio =             " + Fmath.truncate(this.multipleF, this.prec));
            fileOutput.println("Coefficient of determination, F-ratio probability = " + Fmath.truncate(this.multipleFprob, this.prec));
            fileOutput.println("Total (weighted) sum of squares  =                  " + Fmath.truncate(this.sumOfSquaresTotal, this.prec));
            fileOutput.println("Regression (weighted) sum of squares  =             " + Fmath.truncate(this.sumOfSquaresRegrn, this.prec));
            fileOutput.println("Error (weighted) sum of squares  =                  " + Fmath.truncate(this.chiSquare, this.prec));
        }
    }

    public void compare() {
        this.selectCompare(this.significance, this.compFilename);
    }

    public void compare(double d) {
        this.selectCompare(d, this.compFilename);
    }

    public void compare(String string) {
        this.selectCompare(this.significance, string);
    }

    public void compare(double d, String string) {
        this.selectCompare(d, string);
    }

    private void selectCompare(double d, String string) {
        this.compWindow = true;
        ArrayList<Object> arrayList = this.chooseEquation(1);
        int n = (Integer)arrayList.get(0);
        int n2 = 0;
        int n3 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (n == 6) {
            n2 = (Integer)arrayList.get(1);
            this.degSet = true;
        }
        if (n == 7) {
            n3 = (Integer)arrayList.get(1);
            this.nTermsSet = true;
        }
        if (n == 2) {
            d2 = (Double)arrayList.get(2);
            d3 = (Double)arrayList.get(3);
            this.fiveBotTopSet = true;
        }
        if (n == 4) {
            d2 = (Double)arrayList.get(2);
            d3 = (Double)arrayList.get(3);
            this.fourBotTopSet = true;
        }
        arrayList = this.chooseEquation(2);
        int n4 = (Integer)arrayList.get(0);
        int n5 = 0;
        int n6 = 0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (n4 == 6) {
            n5 = (Integer)arrayList.get(1);
            this.degSet = true;
        }
        if (n4 == 7) {
            n6 = (Integer)arrayList.get(1);
            this.nTermsSet = true;
        }
        if (n4 == 2) {
            d4 = (Double)arrayList.get(2);
            d5 = (Double)arrayList.get(3);
            this.fiveBotTopSet = true;
        }
        if (n4 == 4) {
            d4 = (Double)arrayList.get(2);
            d5 = (Double)arrayList.get(3);
            this.fourBotTopSet = true;
        }
        this.compare(n, n2, d2, d3, n3, n4, n5, d4, d5, n6, d, string);
    }

    public void compare(int n, int n2) {
        this.compare(n, 0, 0.0, 0.0, 0, n2, 0, 0.0, 0.0, 0, this.significance, this.compFilename);
    }

    public void compare(int n, int n2, double d) {
        this.compare(n, 0, 0.0, 0.0, 0, n2, 0, 0.0, 0.0, 0, d, this.compFilename);
    }

    public void compare(int n, int n2, int n3, int n4, double d) {
        this.degSet = true;
        this.compare(n, n2, 0.0, 0.0, 0, n3, n4, 0.0, 0.0, 0, d, this.compFilename);
    }

    public void compare(int n, int n2, String string) {
        this.compare(n, 0, 0.0, 0.0, 0, n2, 0, 0.0, 0.0, 0, this.significance, string);
    }

    public void compare(int n, int n2, int n3, int n4, String string) {
        this.degSet = true;
        this.compare(n, n2, 0.0, 0.0, 0, n3, n4, 0.0, 0.0, 0, this.significance, string);
    }

    public void compare(int n, int n2, int n3, int n4) {
        this.degSet = true;
        this.compare(n, n2, 0.0, 0.0, 0, n3, n4, 0.0, 0.0, 0, this.significance, this.compFilename);
    }

    public void compare(int n, int n2, double d, double d2, int n3, int n4, int n5, double d3, double d4, int n6, double d5, String string) {
        int n7;
        if (!(this.degSet || n2 <= 0 && n5 <= 0)) {
            this.degSet = true;
        }
        double[] dArray = new double[2];
        int[] nArray = new int[2];
        String[] stringArray = new String[2];
        int[] nArray2 = new int[]{n, n4};
        if (!this.compWindow) {
            if (n == 2) {
                d = Db.readDouble("Enter five parameter logistic bottom value");
                d2 = Db.readDouble("Enter five parameter logistic top value");
            }
            if (n == 4) {
                d = Db.readDouble("Enter four parameter logistic bottom value");
                d2 = Db.readDouble("Enter four parameter logistic top value");
            }
            if (n == 6 && !this.degSet) {
                n2 = Db.readInt("Enter the polynomial degree");
            }
            if (n == 7) {
                n3 = Db.readInt("Enter the non-integer polynomial number of terms");
            }
        }
        ArrayList<Object> arrayList = this.fittingForCompare(n, n2, d, d2, n3, false);
        dArray[0] = (Double)arrayList.get(0);
        nArray[0] = (Integer)arrayList.get(1);
        stringArray[0] = (String)arrayList.get(2);
        if (!this.compWindow) {
            if (n == 2) {
                d3 = Db.readDouble("Enter five parameter logistic bottom value");
                d4 = Db.readDouble("Enter five parameter logistic top value");
            }
            if (n == 4) {
                d3 = Db.readDouble("Enter four parameter logistic bottom value");
                d4 = Db.readDouble("Enter four parameter logistic top value");
            }
            if (n == 6 && !this.degSet) {
                n5 = Db.readInt("Enter the polynomial degree");
            }
            if (n == 7) {
                n6 = Db.readInt("Enter the non-integer polynomial number of terms");
            }
        }
        ArrayList<Object> arrayList2 = this.fittingForCompare(n4, n5, d3, d4, n6, true);
        dArray[1] = (Double)arrayList2.get(0);
        nArray[1] = (Integer)arrayList2.get(1);
        stringArray[1] = (String)arrayList2.get(2);
        ArrayList<Object> arrayList3 = ImmunoAssay.comparisonTest(nArray2, dArray[0], nArray[0], this.nAnalyteConcns, dArray[1], nArray[1], this.nAnalyteConcns, d5);
        int n8 = (Integer)arrayList3.get(0);
        int n9 = (Integer)arrayList3.get(1);
        int n10 = (Integer)arrayList3.get(2);
        double d6 = (Double)arrayList3.get(3);
        double d7 = (Double)arrayList3.get(4);
        double d8 = (Double)arrayList3.get(5);
        int n11 = (Integer)arrayList3.get(6);
        int n12 = (Integer)arrayList3.get(7);
        if (n9 != n) {
            n7 = nArray[0];
            nArray[0] = nArray[1];
            nArray[1] = n7;
            double d9 = dArray[0];
            dArray[0] = dArray[1];
            dArray[1] = d9;
            String string2 = stringArray[0];
            stringArray[0] = stringArray[1];
            stringArray[1] = string2;
        }
        if ((n7 = string.indexOf(".")) == -1) {
            string = string + ".txt";
        }
        FileOutput fileOutput = new FileOutput(string);
        fileOutput.println(this.titleZero);
        fileOutput.println("Comparison of two fitting procedures");
        if (this.dataRead) {
            fileOutput.println("Data input file name " + this.dataFilename);
        }
        fileOutput.dateAndTimeln(string);
        fileOutput.println();
        fileOutput.println("Equations compared:");
        fileOutput.println("   Equation One: " + stringArray[0]);
        fileOutput.println("   Equation Two: " + stringArray[1]);
        fileOutput.println();
        fileOutput.print("                    ", this.field);
        fileOutput.print("Eqation", this.field);
        fileOutput.println("Eqation");
        fileOutput.print("                    ", this.field);
        fileOutput.print("One", this.field);
        fileOutput.println("Two");
        fileOutput.print("Sum of squares      ", this.field);
        fileOutput.print(Fmath.truncate(dArray[0], this.prec), this.field);
        fileOutput.println(Fmath.truncate(dArray[1], this.prec));
        fileOutput.print("Degrees of freedom  ", this.field);
        fileOutput.print(this.nAnalyteConcns - nArray[0], this.field);
        fileOutput.println(this.nAnalyteConcns - nArray[1]);
        fileOutput.println();
        switch (n8) {
            case 0: {
                fileOutput.printtab("Extra sum of squares F-ratio =                 ");
                fileOutput.println(Fmath.truncate(d6, this.prec));
                fileOutput.printtab("F-ratio probabilty =                           ");
                fileOutput.println(Fmath.truncate(d7, this.prec));
                fileOutput.printtab("F value at the " + d5 + " significance level = ");
                fileOutput.println(Fmath.truncate(d8, this.prec));
                fileOutput.println();
                if (d7 <= d5) {
                    fileOutput.println("In terms of a best fit Equation Two is the preferred fit.");
                    if (Math.abs(nArray[1] - nArray[0]) == 1) {
                        fileOutput.println("The additional parameter has, given a " + d5 + " significance level, significantly improved the fit.");
                        break;
                    }
                    fileOutput.println("The additional parameters have, given a " + d5 + " significance level, significantly improved the fit.");
                    break;
                }
                fileOutput.println("In terms of a best fit Equation One is the preferred fit");
                if (Math.abs(nArray[1] - nArray[0]) == 1) {
                    fileOutput.println("The additional parameter has not, given a " + d5 + " significance level, significantly improved the fit.");
                    break;
                }
                fileOutput.println("The additional parameters have not, given a " + d5 + " significance level, significantly improved the fit.");
                break;
            }
            case 1: {
                fileOutput.println("The fittings to the two equations cannot be distinguished using an F-test analysis");
                break;
            }
            case 2: {
                fileOutput.printtab("Variance F-ratio =                            ");
                fileOutput.println(Fmath.truncate(d6, this.prec));
                fileOutput.printtab("F-ratio probabilty =                          ");
                fileOutput.println(Fmath.truncate(d7, this.prec));
                fileOutput.printtab("F value at the " + d5 + " significance level = ");
                fileOutput.println(Fmath.truncate(d8, this.prec));
                fileOutput.println();
                if (d7 <= d5) {
                    fileOutput.println("In terms of a best fit Equation Two is the preferred fit");
                    fileOutput.println("as indicated by the F-ratio analysis and a given significance level of " + d5);
                    break;
                }
                fileOutput.println("The fittings to the two equations cannot be distinguished using an F-test analysis");
            }
        }
        fileOutput.println("However, the choice of the model to be used as a standard curve should include, along with this comparison,");
        fileOutput.println("observation of the displayed graphs and of the detailed analyses listed below");
        fileOutput.println();
        fileOutput.println();
        fileOutput.println("Details of the two compared fitting exercises");
        fileOutput.println();
        FileInput fileInput = new FileInput("ImmunoAssayTemp.txt");
        int n13 = fileInput.numberOfLines();
        String string3 = null;
        for (int j = 0; j < n13; ++j) {
            string3 = fileInput.readLine();
            fileOutput.println(string3);
        }
        fileInput.close();
        fileOutput.println();
        fileOutput.println("End of file");
        fileOutput.close();
        this.deleteFile("ImmunoAssayTemp.txt");
    }

    private ArrayList<Object> fittingForCompare(int n, int n2, double d, double d2, int n3, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = null;
        switch (n) {
            case 1: {
                this.fiveParameterLogisticFit();
                string = this.methodNames[1];
                break;
            }
            case 2: {
                this.fiveParameterLogisticFit(d, d2);
                string = this.methodNames[2];
                break;
            }
            case 3: {
                this.fourParameterLogisticFit();
                string = this.methodNames[3];
                break;
            }
            case 4: {
                this.fourParameterLogisticFit(d, d2);
                string = this.methodNames[4];
                break;
            }
            case 5: {
                this.bestPolynomialFit();
                string = this.methodNames[5] + ": degree = " + this.bestPolyDegree;
                break;
            }
            case 6: {
                this.polynomialFit(n2);
                string = this.methodNames[6] + n2;
                break;
            }
            case 7: {
                this.nonIntegerPolynomialFit(n3);
                string = this.methodNames[7];
                break;
            }
            case 8: {
                this.sigmoidThresholdFit();
                string = this.methodNames[8];
                break;
            }
            case 9: {
                this.sipsSigmoidFit();
                string = this.methodNames[9];
                break;
            }
            case 10: {
                this.shiftedRectangularHyperbolaFit();
                string = this.methodNames[10];
                break;
            }
            case 11: {
                this.rectangularHyperbolaFit();
                string = this.methodNames[11];
                break;
            }
            case 12: {
                this.amershamFit();
                string = this.methodNames[12];
                break;
            }
            default: {
                throw new IllegalArgumentException("Method number " + n + " not recognised");
            }
        }
        FileOutput fileOutput = null;
        String string2 = "ImmunoAssayTemp.txt";
        fileOutput = bl ? new FileOutput(string2, 'a') : new FileOutput(string2);
        this.commonPrint(fileOutput);
        fileOutput.println();
        fileOutput.println();
        fileOutput.close();
        arrayList.add(new Double(this.chiSquare));
        arrayList.add(new Integer(this.nParam));
        arrayList.add(string);
        return arrayList;
    }

    public static ArrayList<Object> comparisonTest(int[] nArray, double d, int n, int n2, double d2, int n3, int n4, double d3) {
        int n5;
        double d4;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        double d5 = Double.NaN;
        double d6 = Double.NaN;
        double d7 = Double.NaN;
        double[] dArray = new double[]{d, d2};
        int[] nArray2 = new int[]{n, n3};
        int[] nArray3 = new int[]{n2, n4};
        int[] nArray4 = new int[]{n2 - n, n4 - n3};
        double[] dArray2 = new double[2];
        double d8 = Double.NaN;
        int n6 = 0;
        boolean bl = false;
        int n7 = -1;
        if (n != n3 && n2 == n4) {
            if (nArray2[0] > nArray2[1]) {
                d4 = dArray[0];
                dArray[0] = dArray[1];
                dArray[1] = d4;
                n5 = nArray2[0];
                nArray2[0] = nArray2[1];
                nArray2[1] = n5;
                n5 = nArray3[0];
                nArray3[0] = nArray3[1];
                nArray3[1] = n5;
                n5 = nArray4[0];
                nArray4[0] = nArray4[1];
                nArray4[1] = n5;
                n5 = nArray[0];
                nArray[0] = nArray[1];
                nArray[1] = n5;
            }
            if (dArray[0] > dArray[1]) {
                d8 = dArray[0] - dArray[1];
                n6 = nArray4[0] - nArray4[1];
                d5 = d8 * (double)nArray4[1] / ((double)n6 * dArray[1]);
                d6 = Stat.fCompCDF(d5, n6, nArray4[1]);
                d7 = Stat.fTestValueGivenFprob(d3, n6, nArray4[1]);
                n7 = 0;
            }
        }
        if (n7 == -1) {
            if (dArray[0] == dArray[1] && nArray4[0] == nArray4[1]) {
                n7 = 1;
            } else {
                dArray2[0] = dArray[0] / (double)nArray4[0];
                dArray2[1] = dArray[1] / (double)nArray4[1];
                if (dArray2[0] <= dArray2[1]) {
                    d4 = dArray2[0];
                    dArray2[0] = dArray2[1];
                    dArray2[1] = d4;
                    d4 = dArray[0];
                    dArray[0] = dArray[1];
                    dArray[1] = d4;
                    n5 = nArray2[0];
                    nArray2[0] = nArray2[1];
                    nArray2[1] = n5;
                    n5 = nArray3[0];
                    nArray3[0] = nArray3[1];
                    nArray3[1] = n5;
                    n5 = nArray4[0];
                    nArray4[0] = nArray4[1];
                    nArray4[1] = n5;
                    n5 = nArray[0];
                    nArray[0] = nArray[1];
                    nArray[1] = n5;
                }
                d5 = dArray2[0] / dArray2[1];
                d6 = Stat.fCompCDF(d5, nArray4[0], nArray4[1]);
                d7 = Stat.fTestValueGivenFprob(d3, nArray4[0], nArray4[1]);
                n7 = 2;
            }
        }
        arrayList.add(new Integer(n7));
        arrayList.add(new Integer(nArray[0]));
        arrayList.add(new Integer(nArray[1]));
        arrayList.add(new Double(d5));
        arrayList.add(new Double(d6));
        arrayList.add(new Double(d7));
        arrayList.add(new Integer(nArray4[0]));
        arrayList.add(new Integer(nArray4[1]));
        arrayList.add(new Integer(nArray3[0]));
        arrayList.add(new Integer(nArray3[1]));
        return arrayList;
    }

    public void deleteFile(String string) {
        String[] stringArray;
        boolean bl = true;
        File file = new File(string);
        if (!file.exists()) {
            System.err.println("Method deleteFile: no file or directory of the name " + string + " found");
            bl = false;
        }
        if (bl && !file.canWrite()) {
            System.err.println("Method deleteFile: " + string + " is write protected and cannot be deleted");
            bl = false;
        }
        if (bl && file.isDirectory() && (stringArray = file.list()).length > 0) {
            System.err.println("Method deleteFile: " + string + " is a directory which is not empty; no action was taken");
            bl = false;
        }
        if (bl && !(bl = file.delete())) {
            System.err.println("Method deleteFile: deletion of the temporary file " + string + " failed");
        }
    }

    public static boolean isMonotonic(double[] dArray) {
        double d;
        boolean bl = true;
        int n = dArray.length;
        double d2 = d = dArray[1] - dArray[0];
        if (d == 0.0) {
            bl = false;
        } else {
            for (int j = 2; j < n; ++j) {
                d = dArray[j] - dArray[j - 1];
                if (d == 0.0) {
                    bl = false;
                } else if (Fmath.sign(d) != Fmath.sign(d2)) {
                    bl = false;
                }
                if (!bl) break;
            }
        }
        return bl;
    }

    public static double surfaceNumberConcn(double d, double d2) {
        return ImmunoChemistry.surfaceNumberConcn(d, d2);
    }

    public static double surfaceNumberConcn(double d) {
        return ImmunoChemistry.surfaceNumberConcn(d);
    }

    public static double surfaceMolarConcn(double d, double d2) {
        return ImmunoChemistry.surfaceMolarConcn(d, d2);
    }

    public static double surfaceMolarConcn(double d) {
        return ImmunoChemistry.surfaceMolarConcn(d);
    }

    public static double equivalentVolumeConcn(double d, double d2, double d3, double d4) {
        return ImmunoChemistry.equivalentVolumeConcn(d, d2, d3, d4);
    }

    public static double equivalentVolumeConcn(double d, double d2, double d3) {
        return ImmunoChemistry.equivalentVolumeConcn(d, d2, d3);
    }

    public static double convertSurfaceToVolumeConcn(double d, double d2, double d3) {
        return ImmunoChemistry.convertSurfaceToVolumeConcn(d, d2, d3);
    }

    public static double molecularRadius(double d, double d2) {
        return ImmunoChemistry.molecularRadius(d, d2);
    }

    public static double molecularRadius(double d) {
        return ImmunoChemistry.molecularRadius(d, 7.4E-4);
    }

    public static double effectiveRadius(double d, double d2, double d3) {
        return ImmunoChemistry.effectiveRadius(d, d2, d3);
    }

    public static double getMolWeightIgG1() {
        return ImmunoChemistry.getMolWeightIgG1();
    }

    public static double getMolWeightIgG2() {
        return ImmunoChemistry.getMolWeightIgG2();
    }

    public static double getMolWeightIgG3() {
        return ImmunoChemistry.getMolWeightIgG3();
    }

    public static double getMolWeightIgG4() {
        return ImmunoChemistry.getMolWeightIgG4();
    }

    public static double getMolWeightIgM() {
        return ImmunoChemistry.getMolWeightIgM();
    }

    public static double getMolWeightIgA1() {
        return ImmunoChemistry.getMolWeightIgA1();
    }

    public static double getMolWeightIgA2() {
        return ImmunoChemistry.getMolWeightIgA2();
    }

    public static double getMolWeightIgD() {
        return ImmunoChemistry.getMolWeightIgD();
    }

    public static double getMolWeightIgE() {
        return ImmunoChemistry.getMolWeightIgE();
    }
}

