/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physprop;

import flanagan.interpolation.CubicSpline;
import flanagan.physprop.RefrIndex;

public class Water {
    public static final double MOLWEIGHT = 18.02;

    public static double viscosity(double d) {
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0};
        double[] dArray2 = new double[]{0.0017921, 0.0017313, 0.0016728, 0.0016191, 0.0015674, 0.0015188, 0.0014728, 0.0014284, 0.001386, 0.0013462, 0.0013077, 0.0012713, 0.0012363, 0.0012028, 0.0011709, 0.0011404, 0.0011111, 0.0010828, 0.0010559, 0.0010299, 0.001005, 9.81E-4, 9.579E-4, 9.358E-4, 9.142E-4, 8.937E-4, 8.737E-4, 8.545E-4, 8.36E-4, 8.18E-4, 8.007E-4, 7.84E-4, 7.679E-4, 7.523E-4, 7.371E-4, 7.225E-4, 7.085E-4, 6.947E-4, 6.814E-4, 6.685E-4, 6.56E-4, 6.439E-4, 6.321E-4, 6.207E-4, 6.097E-4, 5.988E-4, 5.883E-4, 5.782E-4, 5.683E-4, 5.588E-4, 5.494E-4, 5.404E-4, 5.315E-4, 5.229E-4, 5.146E-4, 5.064E-4, 4.985E-4, 4.907E-4, 4.832E-4, 4.759E-4, 4.688E-4, 4.618E-4, 4.55E-4, 4.483E-4, 4.418E-4, 4.355E-4, 4.293E-4, 4.233E-4, 4.174E-4, 4.117E-4, 4.061E-4, 4.006E-4, 3.952E-4, 3.9E-4, 3.849E-4, 3.799E-4, 3.75E-4, 3.702E-4, 3.655E-4, 3.61E-4, 3.565E-4, 3.521E-4, 3.478E-4, 3.436E-4, 3.395E-4, 3.355E-4, 3.315E-4, 3.276E-4, 3.239E-4, 3.202E-4, 3.165E-4, 3.13E-4, 3.095E-4, 3.06E-4, 3.027E-4, 2.994E-4, 2.962E-4, 2.93E-4, 2.899E-4, 2.868E-4, 2.838E-4};
        double[] dArray3 = new double[]{0.0, 1.78373E-6, 6.66507E-6, 3.55981E-7, 3.911E-6, 2.60001E-6, 1.28896E-6, 1.84413E-6, 3.3345E-6, 4.1785E-7, 2.7941E-6, 1.00576E-6, 1.58285E-6, 1.66282E-6, 1.36586E-6, 1.27374E-6, 7.39187E-7, 1.76951E-6, 5.82755E-7, 1.29947E-6, 8.1938E-7, 8.23013E-7, 1.28857E-6, 2.27218E-8, 1.62055E-6, 9.50918E-8, 9.99086E-7, 7.08563E-7, 3.66662E-7, 8.24789E-7, 5.34182E-7, 6.38482E-7, 5.1189E-7, 3.13959E-7, 6.32274E-7, 7.56944E-7, -6.00505E-8, 6.83258E-7, 3.27018E-7, 4.08669E-7, 4.38304E-7, 2.38113E-7, 4.09244E-7, 5.24909E-7, -1.08882E-7, 5.10619E-7, 4.66404E-7, 2.3763E-8, 6.38544E-7, -1.77938E-7, 6.73209E-7, -1.14896E-7, 3.86377E-7, 3.69389E-7, -6.39346E-8, 4.86349E-7, -8.14616E-8, 4.39497E-7, 1.23473E-7, 2.66612E-7, 1.00779E-8, 2.93076E-7, 1.76187E-8, 2.36449E-7, 2.36584E-7, 1.72156E-8, 2.94554E-7, 4.56925E-9, 2.87169E-7, 4.67538E-8, 1.25815E-7, 4.99845E-8, 2.74247E-7, 5.30292E-8, 1.13637E-7, 9.24242E-8, 1.16667E-7, 4.09095E-8, 3.19695E-7, -1.19691E-7, 1.59069E-7, 8.34135E-8, 1.07277E-7, 8.74801E-8, 1.42803E-7, -5.86918E-8, 9.19641E-8, 2.90835E-7, -5.53049E-8, -6.96157E-8, 3.33768E-7, -6.54552E-8, -7.19471E-8, 3.53244E-7, -1.41027E-7, 2.10865E-7, -1.02433E-7, 1.98866E-7, -9.30309E-8, 1.73258E-7, 0.0};
        int n = dArray.length;
        if (!(d >= dArray[0]) || !(d <= dArray[n - 1])) {
            throw new IllegalArgumentException("Temperature outside the experimental data limits");
        }
        double d2 = CubicSpline.interpolate(d, dArray, dArray2, dArray3);
        return d2;
    }

    public static double density(double d) {
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 60.0, 65.0, 70.0, 75.0, 80.0, 85.0, 90.0, 95.0, 100.0};
        double[] dArray2 = new double[]{999.87, 999.93, 999.97, 999.99, 1000.0, 999.99, 999.97, 999.93, 999.88, 999.81, 999.73, 999.63, 999.52, 999.4, 999.27, 999.13, 998.97, 998.8, 998.62, 998.43, 998.23, 998.02, 997.8, 997.56, 997.32, 997.07, 996.81, 996.54, 996.26, 995.07, 995.67, 995.37, 995.05, 994.73, 994.4, 994.06, 993.71, 993.36, 992.99, 992.62, 992.24, 991.86, 991.47, 991.07, 990.66, 990.25, 989.82, 989.4, 988.96, 988.52, 988.07, 987.62, 987.15, 986.69, 986.21, 985.73, 983.24, 980.59, 977.81, 974.89, 971.83, 968.65, 965.34, 961.92, 958.38};
        double[] dArray3 = new double[]{0.0, -0.0241154, -0.0235383, -0.00173154, -0.0295356, -1.26193E-4, -0.0299597, -3.51591E-5, -0.0298997, -3.66034E-4, -0.0286362, -0.00508932, -0.0110066, -0.0108844, -0.00545578, -0.0272925, -0.00537436, -0.0112101, -0.00978527, -0.00964883, -0.0116194, -0.00387347, -0.0328867, 0.0154203, -0.0287945, 0.0397577, -0.190236, 0.661187, -2.51451, 3.93686, -2.49294, 0.634886, -0.166608, 0.0315471, -0.0195801, -0.0132268, 0.0124871, -0.0367217, 0.0143998, -0.0208776, 0.00911065, -0.015565, -0.0068508, -0.0170318, 0.0149782, -0.0428809, 0.0365453, -0.0433004, 0.0166564, -0.0233251, 0.0166439, -0.0432504, 0.0363578, -0.0421807, 0.0123651, -0.00727961, -0.00660195, -0.0047126, -0.00574764, -0.00589685, -0.00426496, -0.00584331, -0.00356178, -0.00630955, 0.0};
        int n = dArray.length;
        if (!(d >= dArray[0]) || !(d <= dArray[n - 1])) {
            throw new IllegalArgumentException("Temperature outside the experimental data limits");
        }
        double d2 = CubicSpline.interpolate(d, dArray, dArray2, dArray3);
        return d2;
    }

    public static double elecPerm(double d) {
        double d2 = d - 25.0;
        return 78.54 * (1.0 - 0.004579 * d2 + 1.19E-5 * d2 * d2 - 2.8E-8 * d2 * d2 * d2);
    }

    public static double refractIndex(double d, double d2) {
        return RefrIndex.water(d, d2);
    }
}

