/*
 * Decompiled with CFR 0.152.
 */
package flanagan.plot;

import flanagan.interpolation.CubicSpline;
import flanagan.math.ArrayMaths;
import flanagan.math.Fmath;
import java.awt.Canvas;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;

public class Plot
extends Canvas
implements Serializable {
    protected static final long serialVersionUID = 1L;
    protected double[][] data = null;
    protected double[][] copy = null;
    protected int nCurves = 0;
    protected int[] nPoints = null;
    protected int nmPoints = 0;
    protected int niPoints = 200;
    protected int[] pointOpt = null;
    protected int[] pointSize = null;
    protected int npTypes = 8;
    protected boolean[] errorBar = null;
    protected double[][] errors = null;
    protected double[][] errorsCopy = null;
    protected int[] lineOpt = null;
    protected int[] dashLength = null;
    protected boolean[] minMaxOpt = null;
    protected boolean[] trimOpt = null;
    protected int fontSize = 14;
    protected int xLen = 625;
    protected int yLen = 375;
    protected int xBot = 100;
    protected int xTop = this.xBot + this.xLen;
    protected int yTop = 110;
    protected int yBot = this.yTop + this.yLen;
    protected double xLow = 0.0;
    protected double xHigh = 0.0;
    protected double yLow = 0.0;
    protected double yHigh = 0.0;
    protected int xFac = 0;
    protected int yFac = 0;
    protected int xTicks = 0;
    protected int yTicks = 0;
    protected double xMin = 0.0;
    protected double xMax = 0.0;
    protected double yMin = 0.0;
    protected double yMax = 0.0;
    protected double xOffset = 0.0;
    protected double yOffset = 0.0;
    protected boolean noXoffset = false;
    protected boolean noYoffset = false;
    protected double xLowFac = 0.75;
    protected double yLowFac = 0.75;
    protected String graphTitle = "  ";
    protected String graphTitle2 = "  ";
    protected String xAxisLegend = "  ";
    protected String xAxisUnits = "  ";
    protected String yAxisLegend = "  ";
    protected String yAxisUnits = "  ";
    protected boolean xZero = false;
    protected boolean yZero = false;
    protected boolean noXunits = true;
    protected boolean noYunits = true;
    protected double[] xAxisNo = new double[50];
    protected double[] yAxisNo = new double[50];
    protected String[] xAxisChar = new String[50];
    protected String[] yAxisChar = new String[50];
    protected int[] axisTicks = new int[50];
    protected static double dataFill = Double.NaN;

    public Plot(double[][] dArray) {
        this.initialise(dArray);
    }

    public Plot(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = dArray2.length;
        if (n != n2) {
            throw new IllegalArgumentException("x-data length is not equal to the y-data length");
        }
        double[][] dArray3 = new double[2][n];
        for (int j = 0; j < n; ++j) {
            dArray3[0][j] = dArray[j];
            dArray3[1][j] = dArray2[j];
        }
        this.initialise(dArray3);
    }

    private void initialise(double[][] dArray) {
        int n;
        int n2;
        int n3;
        int n4;
        this.nCurves = dArray.length / 2;
        this.nPoints = new int[this.nCurves];
        this.lineOpt = new int[this.nCurves];
        this.dashLength = new int[this.nCurves];
        this.trimOpt = new boolean[this.nCurves];
        this.minMaxOpt = new boolean[this.nCurves];
        this.pointOpt = new int[this.nCurves];
        this.pointSize = new int[this.nCurves];
        this.errorBar = new boolean[this.nCurves];
        this.nmPoints = 0;
        int n5 = 0;
        for (n4 = 0; n4 < 2 * this.nCurves; ++n4) {
            n5 = dArray[n4].length;
            if (n5 <= this.nmPoints) continue;
            this.nmPoints = n5;
        }
        this.data = new double[2 * this.nCurves][this.nmPoints];
        this.copy = new double[2 * this.nCurves][this.nmPoints];
        this.errors = new double[this.nCurves][this.nmPoints];
        this.errorsCopy = new double[this.nCurves][this.nmPoints];
        n4 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = true;
        for (n3 = 0; n3 < this.nCurves; ++n3) {
            n4 = 2 * n3;
            bl = true;
            n6 = dArray[n4].length;
            n7 = dArray[n4 + 1].length;
            if (n6 != n7) {
                throw new IllegalArgumentException("an x and y array length differ");
            }
            this.nPoints[n3] = n6;
        }
        n4 = 0;
        n3 = 1;
        for (n2 = 0; n2 < this.nCurves; ++n2) {
            bl = true;
            n6 = this.nPoints[n2];
            while (bl) {
                if (n6 < 0) {
                    throw new IllegalArgumentException("curve array index  " + n4 + ": blank array");
                }
                if (dArray[n4][n6 - 1] != dArray[n4][n6 - 1]) {
                    if (dArray[n4 + 1][n6 - 1] != dArray[n4 + 1][n6 - 1]) {
                        --n6;
                        n3 = 0;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                bl = false;
            }
            this.nPoints[n2] = n6;
            n4 += 2;
        }
        n4 = 0;
        for (n2 = 0; n2 < this.nCurves; ++n2) {
            double[][] dArray2 = new double[2][this.nPoints[n2]];
            for (n = 0; n < this.nPoints[n2]; ++n) {
                dArray2[0][n] = dArray[n4][n];
                dArray2[1][n] = dArray[n4 + 1][n];
            }
            dArray2 = Plot.doubleSelectionSort(dArray2);
            for (n = 0; n < this.nPoints[n2]; ++n) {
                dArray[n4][n] = dArray2[0][n];
                dArray[n4 + 1][n] = dArray2[1][n];
            }
            n4 += 2;
        }
        n4 = 0;
        n2 = 1;
        for (int j = 0; j < this.nCurves; ++j) {
            int n8;
            n = 1;
            for (n8 = 1; n8 < this.nPoints[j]; ++n8) {
                if (!(dArray[n4][n8] < dArray[n4][n8 - 1])) continue;
                ++n;
            }
            if (n == this.nPoints[j]) {
                int n9;
                double[] dArray3 = new double[this.nPoints[j]];
                for (n9 = 0; n9 < this.nPoints[j]; ++n9) {
                    dArray3[n9] = dArray[n4][n9];
                }
                for (n9 = 0; n9 < this.nPoints[j]; ++n9) {
                    dArray[n4][n9] = dArray3[this.nPoints[j] - n9 - 1];
                }
                for (n9 = 0; n9 < this.nPoints[j]; ++n9) {
                    dArray3[n9] = dArray[n4 + 1][n9];
                }
                for (n9 = 0; n9 < this.nPoints[j]; ++n9) {
                    dArray[n4 + 1][n9] = dArray3[this.nPoints[j] - n9 - 1];
                }
            }
            for (n8 = 0; n8 < this.nPoints[j]; ++n8) {
                this.data[n4][n8] = dArray[n4][n8];
                this.data[n4 + 1][n8] = dArray[n4 + 1][n8];
                this.copy[n4][n8] = dArray[n4][n8];
                this.copy[n4 + 1][n8] = dArray[n4 + 1][n8];
            }
            this.lineOpt[j] = 1;
            this.dashLength[j] = 5;
            this.trimOpt[j] = false;
            if (this.lineOpt[j] == 1) {
                this.trimOpt[j] = true;
            }
            this.minMaxOpt[j] = true;
            this.pointSize[j] = 6;
            this.errorBar[j] = false;
            this.pointOpt[j] = n2++;
            n4 += 2;
            if (n2 <= this.npTypes) continue;
            n2 = 1;
        }
    }

    public static double[][] doubleSelectionSort(double[][] dArray) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = dArray[0].length;
        double d = 0.0;
        double d2 = 0.0;
        double[][] dArray2 = new double[2][n4];
        for (n = 0; n < n4; ++n) {
            dArray2[0][n] = dArray[0][n];
            dArray2[1][n] = dArray[1][n];
        }
        while (n3 != n4 - 1) {
            n2 = n3 + 1;
            for (n = n3 + 2; n < n4; ++n) {
                if (!(dArray2[0][n] < dArray2[0][n2])) continue;
                n2 = n;
            }
            d = dArray2[0][n2];
            dArray2[0][n2] = dArray2[0][++n3];
            dArray2[0][n3] = d;
            d2 = dArray2[1][n2];
            dArray2[1][n2] = dArray2[1][n3];
            dArray2[1][n3] = d2;
        }
        return dArray2;
    }

    public static double[][] data(int n, int n2) {
        double[][] dArray = new double[2 * n][n2];
        for (int j = 0; j < 2 * n; ++j) {
            for (int k = 0; k < n2; ++k) {
                dArray[j][k] = dataFill;
            }
        }
        return dArray;
    }

    public static void setDataFillValue(double d) {
        dataFill = d;
    }

    public static double getDataFillValue() {
        return dataFill;
    }

    public void setGraphTitle(String string) {
        this.graphTitle = string;
    }

    public void setGraphTitle2(String string) {
        this.graphTitle2 = string;
    }

    public void setXaxisLegend(String string) {
        this.xAxisLegend = string;
    }

    public void setYaxisLegend(String string) {
        this.yAxisLegend = string;
    }

    public void setXaxisUnitsName(String string) {
        this.xAxisUnits = string;
        this.noXunits = false;
    }

    public void setYaxisUnitsName(String string) {
        this.yAxisUnits = string;
        this.noYunits = false;
    }

    public int getXaxisLen() {
        return this.xLen;
    }

    public int getYaxisLen() {
        return this.yLen;
    }

    public int getXlow() {
        return this.xBot;
    }

    public int getYhigh() {
        return this.yTop;
    }

    public int[] getPointsize() {
        return this.pointSize;
    }

    public int[] getDashlength() {
        return this.dashLength;
    }

    public double getXlowFac() {
        return 1.0 - this.xLowFac;
    }

    public double getYlowFac() {
        return 1.0 - this.yLowFac;
    }

    public double getXmin() {
        return this.xMin;
    }

    public double getXmax() {
        return this.xMax;
    }

    public double getYmin() {
        return this.yMin;
    }

    public double getYmax() {
        return this.yMax;
    }

    public int[] getLine() {
        return this.lineOpt;
    }

    public int[] getPoint() {
        return this.pointOpt;
    }

    public int getNiPoints() {
        return this.niPoints;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setXaxisLen(int n) {
        this.xLen = n;
        this.update();
    }

    public void setYaxisLen(int n) {
        this.yLen = n;
        this.update();
    }

    public void setXlow(int n) {
        this.xBot = n;
        this.update();
    }

    public void setYhigh(int n) {
        this.yTop = n;
        this.update();
    }

    public void setXlowFac(double d) {
        this.xLowFac = 1.0 - d;
    }

    public void setYlowFac(double d) {
        this.yLowFac = 1.0 - d;
    }

    public void setNoXoffset(boolean bl) {
        this.noXoffset = bl;
    }

    public void setNoYoffset(boolean bl) {
        this.noYoffset = bl;
    }

    public void setNoOffset(boolean bl) {
        this.noXoffset = bl;
        this.noYoffset = bl;
    }

    public boolean getNoXoffset() {
        return this.noXoffset;
    }

    public boolean getNoYoffset() {
        return this.noYoffset;
    }

    protected void update() {
        this.xTop = this.xBot + this.xLen;
        this.yBot = this.yTop + this.yLen;
    }

    public void setLine(int[] nArray) {
        int n;
        int n2 = nArray.length;
        if (n2 != this.nCurves) {
            throw new IllegalArgumentException("input array of wrong length");
        }
        for (n = 0; n < n2; ++n) {
            if (nArray[n] >= 0 && nArray[n] <= 4) continue;
            throw new IllegalArgumentException("lineOpt must be 0, 1, 2, 3 or 4");
        }
        this.lineOpt = nArray;
        for (n = 0; n < this.lineOpt.length; ++n) {
            int n3;
            int n4;
            if (this.lineOpt[n] != 1 && this.lineOpt[n] != 2) continue;
            boolean bl = false;
            for (n4 = 1; n4 < this.nPoints[n]; ++n4) {
                if (!(this.data[n][n4] < this.data[n][n4 - 1])) continue;
                bl = true;
            }
            if (!bl) continue;
            n4 = 1;
            for (n3 = 1; n3 < this.nPoints[n]; ++n3) {
                if (!(this.data[2 * n][n3] > this.data[2 * n][n3 - 1])) continue;
                ++n4;
            }
            if (n4 == this.nPoints[n]) {
                nArray[n] = -nArray[n];
                continue;
            }
            n4 = 1;
            for (n3 = 1; n3 < this.nPoints[n]; ++n3) {
                if (!(this.data[2 * n][n3] < this.data[2 * n][n3 - 1])) continue;
                ++n4;
            }
            if (n4 == this.nPoints[n]) {
                int n5;
                double[] dArray = new double[this.nPoints[n]];
                for (n5 = 0; n5 < this.nPoints[n]; ++n5) {
                    dArray[n5] = this.data[n][n5];
                }
                for (n5 = 0; n5 < this.nPoints[n]; ++n5) {
                    this.data[n][n5] = dArray[this.nPoints[n] - n5 - 1];
                }
                for (n5 = 0; n5 < this.nPoints[n]; ++n5) {
                    dArray[n5] = this.data[2 * n][n5];
                }
                for (n5 = 0; n5 < this.nPoints[n]; ++n5) {
                    this.data[2 * n][n5] = dArray[this.nPoints[n] - n5 - 1];
                }
                this.lineOpt[n] = -nArray[n];
                continue;
            }
            System.out.println("Curve " + n + " will not support interpolation");
            System.out.println("Straight connecting line option used");
            if (this.lineOpt[n] == 1) {
                this.lineOpt[n] = 3;
            }
            if (this.lineOpt[n] != 2) continue;
            this.lineOpt[n] = 4;
        }
    }

    public void setLine(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("lineOpt must be 0, 1, 2 or 3");
        }
        for (int j = 0; j < this.nCurves; ++j) {
            this.lineOpt[j] = n;
        }
    }

    public void setDashLength(int[] nArray) {
        if (nArray.length != this.nCurves) {
            throw new IllegalArgumentException("input array of wrong length");
        }
        this.dashLength = nArray;
    }

    public void setDashLength(int n) {
        for (int j = 0; j < this.nCurves; ++j) {
            this.dashLength[j] = n;
        }
    }

    public void setPoint(int[] nArray) {
        int n = nArray.length;
        if (n != this.nCurves) {
            throw new IllegalArgumentException("input array of wrong length");
        }
        for (int j = 0; j < n; ++j) {
            if (nArray[j] >= 0 && nArray[j] <= 8) continue;
            throw new IllegalArgumentException("pointOpt must be 0, 1, 2, 3, 4, 5, 6, 7, or 8");
        }
        this.pointOpt = nArray;
    }

    public void setPoint(int n) {
        if (n < 0 || n > 8) {
            throw new IllegalArgumentException("pointOpt must be 0, 1, 2, 3, 4, 5, 6, 7, or 8");
        }
        for (int j = 0; j < this.nCurves; ++j) {
            this.pointOpt[j] = n;
        }
    }

    public void setPointSize(int[] nArray) {
        if (nArray.length != this.nCurves) {
            throw new IllegalArgumentException("input array of wrong length");
        }
        for (int j = 0; j < this.nCurves; ++j) {
            if (nArray[j] != nArray[j] / 2 * 2) {
                int n = j;
                nArray[n] = nArray[n] + 1;
            }
            this.pointSize[j] = nArray[j];
        }
    }

    public void setPointSize(int n) {
        if (n % 2 != 0) {
            ++n;
        }
        for (int j = 0; j < this.nCurves; ++j) {
            this.pointSize[j] = n;
        }
    }

    public void setErrorBars(int n, double[] dArray) {
        if (dArray.length != this.nPoints[n]) {
            throw new IllegalArgumentException("input array of wrong length");
        }
        this.errorBar[n] = true;
        for (int j = 0; j < this.nPoints[n]; ++j) {
            this.errors[n][j] = dArray[j];
            this.errorsCopy[n][j] = dArray[j];
        }
    }

    public void setNiPoints(int n) {
        this.niPoints = n;
    }

    public void setFontSize(int n) {
        this.fontSize = n;
    }

    public void setTrimOpt(boolean[] blArray) {
        this.trimOpt = blArray;
    }

    public void setMinMaxOpt(boolean[] blArray) {
        this.minMaxOpt = blArray;
    }

    public static int scale(double d, double d2) {
        int n = 0;
        double d3 = 0.0;
        boolean bl = false;
        if (d >= 0.0 && d2 > 0.0) {
            d3 = d2;
            bl = true;
        } else if (d < 0.0 && d2 <= 0.0) {
            d3 = -d;
            bl = true;
        } else if (d2 > 0.0 && d < 0.0) {
            d3 = Math.max(d2, -d);
            bl = true;
        }
        if (bl) {
            if (d3 > 100.0) {
                while (d3 > 1.0) {
                    d3 /= 10.0;
                    --n;
                }
            }
            if (d3 <= 0.01) {
                while (d3 <= 0.1) {
                    d3 *= 10.0;
                    ++n;
                }
            }
        }
        return n;
    }

    public static void limits(double d, double d2, double d3, double[] dArray) {
        double d4 = 1.0;
        double d5 = 1.0;
        if (Math.abs(d) < 1.0) {
            d4 = 10.0;
        }
        if (Math.abs(d) < 0.1) {
            d4 = 100.0;
        }
        if (Math.abs(d2) < 1.0) {
            d5 = 10.0;
        }
        if (Math.abs(d2) < 0.1) {
            d5 = 100.0;
        }
        double d6 = Math.floor(10.0 * d * d4) / d4;
        double d7 = Math.ceil(10.0 * d2 * d5) / d5;
        if (d6 >= 0.0 && d7 > 0.0 && d6 < d3 * d7) {
            d6 = 0.0;
        }
        if (d6 < 0.0 && d7 <= 0.0 && -d7 <= -d3 * d6) {
            d7 = 0.0;
        }
        dArray[0] = d6 / 10.0;
        dArray[1] = d7 / 10.0;
    }

    public static double offset(double d, double d2) {
        double d3 = d2 - d;
        double d4 = Fmath.sign(d2);
        double d5 = Fmath.sign(d);
        double d6 = 0.0;
        int n = 0;
        int n2 = 0;
        if (d4 == d5) {
            n2 = (int)Math.floor(Fmath.log10(d3));
            if (d4 == 1.0) {
                n = (int)Math.floor(Fmath.log10(d2));
                if (n - n2 > 1) {
                    d6 = Math.floor(d * Math.pow(10.0, -n2)) * Math.pow(10.0, n2);
                }
            } else {
                n = (int)Math.floor(Fmath.log10(Math.abs(d)));
                if (n - n2 > 1) {
                    d6 = Math.floor(d2 * Math.pow(10.0, -n2)) * Math.pow(10.0, n2);
                }
            }
        }
        return d6;
    }

    public void axesScaleOffset() {
        int n;
        int n2;
        double[] dArray = new double[2];
        int n3 = 0;
        for (n2 = 0; n2 < this.nCurves; ++n2) {
            for (n = 0; n < this.nPoints[n2]; ++n) {
                this.data[n3][n] = this.copy[n3][n];
                this.data[n3 + 1][n] = this.copy[n3 + 1][n];
                this.errors[n2][n] = this.errorsCopy[n2][n];
                if (!this.errorBar[n2]) continue;
                double[] dArray2 = this.errors[n2];
                int n4 = n;
                dArray2[n4] = dArray2[n4] + this.data[n3 + 1][n];
            }
            n3 += 2;
        }
        this.minMax();
        if (!this.noXoffset) {
            this.xOffset = Plot.offset(this.xMin, this.xMax);
        }
        if (this.xOffset != 0.0) {
            n3 = 0;
            for (n2 = 0; n2 < this.nCurves; ++n2) {
                n = 0;
                while (n < this.nPoints[n2]) {
                    double[] dArray3 = this.data[n3];
                    int n5 = n++;
                    dArray3[n5] = dArray3[n5] - this.xOffset;
                }
                n3 += 2;
            }
            this.xMin -= this.xOffset;
            this.xMax -= this.xOffset;
        }
        if (!this.noYoffset) {
            this.yOffset = Plot.offset(this.yMin, this.yMax);
        }
        if (this.yOffset != 0.0) {
            n3 = 1;
            for (n2 = 0; n2 < this.nCurves; ++n2) {
                for (n = 0; n < this.nPoints[n2]; ++n) {
                    double[] dArray4 = this.data[n3];
                    int n6 = n;
                    dArray4[n6] = dArray4[n6] - this.yOffset;
                    if (!this.errorBar[n2]) continue;
                    double[] dArray5 = this.errors[n2];
                    int n7 = n;
                    dArray5[n7] = dArray5[n7] - this.yOffset;
                }
                n3 += 2;
            }
            this.yMin -= this.yOffset;
            this.yMax -= this.yOffset;
        }
        this.xFac = Plot.scale(this.xMin, this.xMax);
        if (this.xFac != 0) {
            n3 = 0;
            for (n2 = 0; n2 < this.nCurves; ++n2) {
                n = 0;
                while (n < this.nPoints[n2]) {
                    double[] dArray6 = this.data[n3];
                    int n8 = n++;
                    dArray6[n8] = dArray6[n8] * Math.pow(10.0, this.xFac + 1);
                }
                n3 += 2;
            }
            this.xMin *= Math.pow(10.0, this.xFac + 1);
            this.xMax *= Math.pow(10.0, this.xFac + 1);
        }
        this.yFac = Plot.scale(this.yMin, this.yMax);
        if (this.yFac != 0) {
            n3 = 1;
            for (n2 = 0; n2 < this.nCurves; ++n2) {
                for (n = 0; n < this.nPoints[n2]; ++n) {
                    double[] dArray7 = this.data[n3];
                    int n9 = n;
                    dArray7[n9] = dArray7[n9] * Math.pow(10.0, this.yFac + 1);
                    if (!this.errorBar[n2]) continue;
                    double[] dArray8 = this.errors[n2];
                    int n10 = n;
                    dArray8[n10] = dArray8[n10] * Math.pow(10.0, this.yFac + 1);
                }
                n3 += 2;
            }
            this.yMin *= Math.pow(10.0, this.yFac + 1);
            this.yMax *= Math.pow(10.0, this.yFac + 1);
        }
        Plot.limits(this.xMin, this.xMax, this.xLowFac, dArray);
        this.xLow = dArray[0];
        this.xHigh = dArray[1];
        if (this.xLow < 0.0 && this.xHigh > 0.0) {
            this.xZero = true;
        }
        Plot.limits(this.yMin, this.yMax, this.yLowFac, dArray);
        this.yLow = dArray[0];
        this.yHigh = dArray[1];
        if (this.yLow < 0.0 && this.yHigh > 0.0) {
            this.yZero = true;
        }
        this.xTicks = Plot.ticks(this.xLow, this.xHigh, this.xAxisNo, this.xAxisChar);
        this.xHigh = this.xAxisNo[this.xTicks - 1];
        if (this.xLow != this.xAxisNo[0]) {
            if (this.xOffset != 0.0) {
                this.xOffset = this.xOffset - this.xLow + this.xAxisNo[0];
            }
            this.xLow = this.xAxisNo[0];
        }
        this.yTicks = Plot.ticks(this.yLow, this.yHigh, this.yAxisNo, this.yAxisChar);
        this.yHigh = this.yAxisNo[this.yTicks - 1];
        if (this.yLow != this.yAxisNo[0]) {
            if (this.yOffset != 0.0) {
                this.yOffset = this.yOffset - this.yLow + this.yAxisNo[0];
            }
            this.yLow = this.yAxisNo[0];
        }
    }

    public static int ticks(double d, double d2, double[] dArray, String[] stringArray) {
        int n;
        int[] nArray = new int[]{1, 1, 1, 2, 3};
        double[] dArray2 = new double[]{1.0, 10.0, 1.0, 0.1, 0.01};
        double[] dArray3 = new double[]{1.0, 1.0, 0.1, 0.01, 0.001};
        double d3 = Math.abs(d2);
        double d4 = Math.abs(d);
        if (d4 > d3) {
            d3 = d4;
        }
        int n2 = 0;
        if (d3 <= 100.0) {
            n2 = 1;
        }
        if (d3 <= 10.0) {
            n2 = 2;
        }
        if (d3 <= 1.0) {
            n2 = 3;
        }
        if (d3 <= 0.1) {
            n2 = 4;
        }
        if (d3 > 100.0 || d3 < 0.01) {
            n2 = 0;
        }
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        int n3 = 0;
        int n4 = 0;
        if (d2 > 0.0 && d >= 0.0) {
            d5 = Math.ceil((d2 - d) / dArray2[n2]) * dArray3[n2];
            n4 = 1;
            d6 = d;
            d7 = d2;
            n3 = 1;
        } else if (d2 <= 0.0 && d < 0.0) {
            d5 = Math.ceil((d2 - d) / dArray2[n2]) * dArray3[n2];
            n4 = -1;
            d6 = d2;
            d7 = d;
            n3 = -1;
        } else {
            double d8 = Math.abs(Math.ceil(d2));
            double d9 = Math.abs(Math.floor(d));
            n = 0;
            if (d8 >= d9) {
                n4 = 2;
                n = (int)Math.rint(10.0 * d8 / (d8 + d9));
                d5 = Math.ceil(d2 * 10.0 / (double)n / dArray2[n2]) * dArray3[n2];
                d6 = 0.0;
                d7 = d2;
                n3 = 1;
            } else {
                n4 = -2;
                n = (int)Math.rint(10.0 * d9 / (d8 + d9));
                d5 = Math.ceil(Math.abs(d * 10.0 / (double)n) / dArray2[n2]) * dArray3[n2];
                d6 = 0.0;
                d7 = d;
                n3 = -1;
            }
        }
        int n5 = 1;
        double d10 = d6;
        boolean bl = true;
        while (bl) {
            d10 += (double)n3 * d5;
            ++n5;
            if (!(Math.abs(d10) >= Math.abs(d7))) continue;
            bl = false;
        }
        n = 0;
        double[] dArray4 = null;
        switch (n4) {
            case 1: {
                int n6;
                dArray4 = new double[n5];
                dArray[0] = Fmath.truncate(d, nArray[n2]);
                for (n6 = 1; n6 < n5; ++n6) {
                    dArray[n6] = Fmath.truncate(dArray[n6 - 1] + d5, nArray[n2]);
                }
                break;
            }
            case -1: {
                int n6;
                dArray4 = new double[n5];
                dArray4[0] = Fmath.truncate(d2, nArray[n2]);
                for (n6 = 1; n6 < n5; ++n6) {
                    dArray4[n6] = Fmath.truncate(dArray4[n6 - 1] - d5, nArray[n2]);
                }
                dArray4 = Fmath.reverseArray(dArray4);
                for (n6 = 0; n6 < n5; ++n6) {
                    dArray[n6] = dArray4[n6];
                }
                break;
            }
            case 2: {
                int n6;
                n = (int)Math.ceil(-d / d5);
                dArray4 = new double[n5 += n];
                dArray[0] = Fmath.truncate((double)(-n) * d5, nArray[n2]);
                for (n6 = 1; n6 < n5; ++n6) {
                    dArray[n6] = Fmath.truncate(dArray[n6 - 1] + d5, nArray[n2]);
                }
                break;
            }
            case -2: {
                int n6;
                n = (int)Math.ceil(d2 / d5);
                dArray4 = new double[n5 += n];
                dArray4[0] = Fmath.truncate((double)n * d5, nArray[n2]);
                for (n6 = 1; n6 < n5; ++n6) {
                    dArray4[n6] = Fmath.truncate(dArray4[n6 - 1] - d5, nArray[n2]);
                }
                dArray4 = Fmath.reverseArray(dArray4);
                for (n6 = 0; n6 < n5; ++n6) {
                    dArray[n6] = dArray4[n6];
                }
                break;
            }
        }
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        double d11 = arrayMaths.maximum();
        double d12 = Math.abs(arrayMaths.minimum());
        boolean bl2 = true;
        int n7 = 0;
        while (bl2) {
            if (Math.abs(dArray[n7]) < d11 * 1.0E-4 || Math.abs(dArray[n7]) < d12 * 1.0E-4) {
                dArray[n7] = 0.0;
                bl2 = false;
                continue;
            }
            if (++n7 < n5) continue;
            bl2 = false;
        }
        for (int j = 0; j < n5; ++j) {
            stringArray[j] = String.valueOf(dArray[j]);
            stringArray[j] = stringArray[j].trim();
        }
        return n5;
    }

    public void minMax() {
        boolean bl = true;
        int n = 0;
        while (bl) {
            if (this.minMaxOpt[n]) {
                bl = false;
                this.xMin = this.data[2 * n][0];
                this.xMax = this.data[2 * n][0];
                this.yMin = this.data[2 * n + 1][0];
                if (this.errorBar[n]) {
                    this.yMin = 2.0 * this.yMin - this.errors[n][0];
                }
                this.yMax = this.data[2 * n + 1][0];
                if (!this.errorBar[n]) continue;
                this.yMax = this.errors[n][0];
                continue;
            }
            if (++n <= this.nCurves) continue;
            throw new IllegalArgumentException("At least one curve must be included in the maximum/minimum calculation");
        }
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (int j = 0; j < this.nCurves; ++j) {
            if (this.minMaxOpt[j]) {
                for (int k = 0; k < this.nPoints[j]; ++k) {
                    if (this.xMin > this.data[n2][k]) {
                        this.xMin = this.data[n2][k];
                    }
                    if (this.xMax < this.data[n2][k]) {
                        this.xMax = this.data[n2][k];
                    }
                    d = this.data[n2 + 1][k];
                    if (this.errorBar[j]) {
                        d = 2.0 * d - this.errors[j][k];
                    }
                    if (this.yMin > d) {
                        this.yMin = d;
                    }
                    d2 = this.data[n2 + 1][k];
                    if (this.errorBar[j]) {
                        d2 = this.errors[j][k];
                    }
                    if (!(this.yMax < d2)) continue;
                    this.yMax = d2;
                }
            }
            n2 += 2;
        }
        if (this.xMin == this.xMax) {
            if (this.xMin == 0.0) {
                this.xMin = 0.1;
                this.xMax = 0.1;
            } else if (this.xMin < 0.0) {
                this.xMin *= 1.1;
            } else {
                this.xMax *= 1.1;
            }
        }
        if (this.yMin == this.yMax) {
            if (this.yMin == 0.0) {
                this.yMin = 0.1;
                this.yMax = 0.1;
            } else if (this.yMin < 0.0) {
                this.yMin *= 1.1;
            } else {
                this.yMax *= 1.1;
            }
        }
    }

    protected static String offsetString(double d) {
        String string = String.valueOf(d);
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "0";
        int n = string.indexOf(46);
        int n2 = string.indexOf(69);
        if (n2 == -1) {
            return string;
        }
        string2 = string.substring(n2 + 1);
        int n3 = Integer.parseInt(string2);
        string2 = string.substring(0, n2);
        if (n3 >= 0) {
            for (int j = 0; j < n3; ++j) {
                string2 = string2 + string5;
            }
            return string2;
        }
        string3 = string2.substring(0, n + 1);
        string4 = string2.substring(n + 1);
        for (int j = 0; j < -n3; ++j) {
            string3 = string2 + string5;
        }
        string3 = string3 + string4;
        return string3;
    }

    public boolean printCheck(boolean bl, int n, int n2, int n3, int n4) {
        boolean bl2 = true;
        if (bl) {
            if (n < this.xBot) {
                bl2 = false;
            }
            if (n > this.xTop) {
                bl2 = false;
            }
            if (n2 < this.xBot) {
                bl2 = false;
            }
            if (n2 > this.xTop) {
                bl2 = false;
            }
            if (n3 > this.yBot) {
                bl2 = false;
            }
            if (n3 < this.yTop) {
                bl2 = false;
            }
            if (n4 > this.yBot) {
                bl2 = false;
            }
            if (n4 < this.yTop) {
                bl2 = false;
            }
        }
        return bl2;
    }

    public void graph(Graphics graphics) {
        int n;
        int n2;
        int n3;
        String string;
        graphics.setFont(new Font("serif", 0, this.fontSize));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.axesScaleOffset();
        String string2 = Plot.offsetString(this.xOffset);
        String string3 = Plot.offsetString(this.yOffset);
        String string4 = "  /( ";
        String string5 = " )";
        String string6 = "  / ";
        String string7 = " ";
        String string8 = " x 10";
        String string9 = "10";
        String string10 = " ";
        String string11 = string4;
        String string12 = string5;
        String string13 = string8;
        if (this.xFac == 0) {
            string11 = string6;
            string12 = "";
            string13 = "";
        }
        String string14 = string4;
        String string15 = string5;
        String string16 = string8;
        if (this.yFac == 0) {
            string14 = string6;
            string15 = "";
            string16 = "";
        }
        if (this.noXunits) {
            if (this.xFac == 0) {
                string11 = string10;
                string12 = string10;
                string13 = string10;
            } else {
                string11 = string6;
                string12 = string7;
                string13 = string9;
            }
        }
        if (this.noYunits) {
            if (this.yFac == 0) {
                string14 = string10;
                string15 = string10;
                string16 = string10;
            } else {
                string14 = string6;
                string15 = string7;
                string16 = string9;
            }
        }
        double d = this.xTop - this.xBot;
        double d2 = this.yBot - this.yTop;
        String string17 = " + ";
        String string18 = string = " - ";
        graphics.drawString(this.graphTitle + " ", 15, 15);
        graphics.drawString(this.graphTitle2 + " ", 15, 35);
        if (this.xOffset < 0.0) {
            string18 = string17;
            this.xOffset = -this.xOffset;
        }
        int n4 = 0;
        String string19 = "";
        String string20 = "";
        String string21 = "";
        String string22 = "";
        if (this.xFac == 0 && this.xOffset == 0.0) {
            graphics.drawString(this.xAxisLegend + string11 + this.xAxisUnits + string12, this.xBot - 4, this.yBot + 32);
        } else if (this.xOffset == 0.0) {
            string19 = this.xAxisLegend + string11 + this.xAxisUnits + string13;
            n4 = fontMetrics.stringWidth(string19);
            graphics.drawString(string19, this.xBot - 4, this.yBot + 42);
            string21 = String.valueOf(-this.xFac - 1);
            graphics.drawString(string21, this.xBot - 4 + n4 + 1, this.yBot + 32);
            graphics.drawString(string12, this.xBot - 4 + (n4 += fontMetrics.stringWidth(string21)) + 1, this.yBot + 42);
        } else if (this.xFac == 0) {
            graphics.drawString(this.xAxisLegend + string18 + string2 + string11 + this.xAxisUnits + string12, this.xBot - 4, this.yBot + 30);
        } else {
            string19 = this.xAxisLegend + string18 + string2 + string11 + this.xAxisUnits + string13;
            n4 = fontMetrics.stringWidth(string19);
            graphics.drawString(string19, this.xBot - 4, this.yBot + 37);
            string21 = String.valueOf(-this.xFac - 1);
            graphics.drawString(string21, this.xBot - 4 + n4 + 1, this.yBot + 32);
            graphics.drawString(string12, this.xBot - 4 + (n4 += fontMetrics.stringWidth(string21)) + 1, this.yBot + 37);
        }
        string18 = string;
        if (this.yOffset < 0.0) {
            string18 = string17;
            this.yOffset = -this.yOffset;
        }
        if (this.yFac == 0 && this.yOffset == 0.0) {
            graphics.drawString(this.yAxisLegend + " ", 15, this.yTop - 25);
            graphics.drawString(string14 + this.yAxisUnits + string15, 15, this.yTop - 10);
        } else if (this.yOffset == 0.0) {
            graphics.drawString(this.yAxisLegend, 15, this.yTop - 35);
            string21 = string14 + this.yAxisUnits + string16;
            graphics.drawString(string21, 15, this.yTop - 15);
            n4 = fontMetrics.stringWidth(string21);
            string22 = String.valueOf(-this.yFac - 1);
            graphics.drawString(string22, 15 + n4 + 1, this.yTop - 20);
            graphics.drawString(string15, 15 + (n4 += fontMetrics.stringWidth(string22)) + 1, this.yTop - 15);
        } else if (this.yFac == 0) {
            graphics.drawString(this.yAxisLegend + string18 + string3, 15, this.yTop - 25);
            graphics.drawString(string14 + this.yAxisUnits + string15, 15, this.yTop - 10);
        } else {
            string20 = this.yAxisLegend + string18 + string3;
            graphics.drawString(string20, 15, this.yTop - 35);
            string21 = string14 + this.yAxisUnits + string16;
            graphics.drawString(string21, 15, this.yTop - 15);
            n4 = fontMetrics.stringWidth(string21);
            string22 = String.valueOf(-this.yFac - 1);
            graphics.drawString(string22, 15 + n4 + 1, this.yTop - 20);
            graphics.drawString(string15, 15 + (n4 += fontMetrics.stringWidth(string22)) + 1, this.yTop - 15);
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        double d3 = 0.0;
        double d4 = this.xHigh - this.xLow;
        double d5 = this.yHigh - this.yLow;
        graphics.drawLine(this.xBot, this.yBot, this.xTop, this.yBot);
        graphics.drawLine(this.xBot, this.yTop, this.xTop, this.yTop);
        graphics.drawLine(this.xBot, this.yBot, this.xBot, this.yTop);
        graphics.drawLine(this.xTop, this.yBot, this.xTop, this.yTop);
        if (this.xZero) {
            n5 = 8;
            n8 = this.xBot + (int)((0.0 - this.xLow) / d4 * d);
            graphics.drawLine(n8, this.yTop, n8, this.yTop + 8);
            graphics.drawLine(n8, this.yBot, n8, this.yBot - 8);
            n6 = this.yTop;
            while (n6 + n5 < this.yBot) {
                n7 = n6 + n5;
                graphics.drawLine(n8, n6, n8, n7);
                n6 = n7 + n5;
            }
        }
        if (this.yZero) {
            n5 = 8;
            n8 = this.yBot - (int)((0.0 - this.yLow) / d5 * d2);
            graphics.drawLine(this.xBot, n8, this.xBot + 8, n8);
            graphics.drawLine(this.xTop, n8, this.xTop - 8, n8);
            n6 = this.xBot;
            while (n6 + n5 < this.xTop) {
                n7 = n6 + n5;
                graphics.drawLine(n6, n8, n7, n8);
                n6 = n7 + n5;
            }
        }
        int n9 = 0;
        for (n3 = 0; n3 < this.xTicks; ++n3) {
            n9 = this.xBot + (int)((this.xAxisNo[n3] - this.xLow) / d4 * d);
            graphics.drawLine(n9, this.yBot, n9, this.yBot - 8);
            graphics.drawLine(n9, this.yTop, n9, this.yTop + 8);
            graphics.drawString(this.xAxisChar[n3] + " ", n9 - 4, this.yBot + 18);
        }
        n3 = 0;
        int n10 = this.yAxisChar[0].length();
        for (n2 = 1; n2 < this.yTicks; ++n2) {
            if (this.yAxisChar[n2].length() <= n10) continue;
            n10 = this.yAxisChar[n2].length();
        }
        n2 = (n10 - 3) * 5;
        double d6 = (double)(-this.yTop + this.yBot) / (double)(this.yTicks - 1);
        for (n = 0; n < this.yTicks; ++n) {
            n3 = this.yBot - (int)Math.round((double)n * d6);
            n3 = this.yBot - (int)((this.yAxisNo[n] - this.yLow) / d5 * d2);
            graphics.drawLine(this.xBot, n3, this.xBot + 8, n3);
            graphics.drawLine(this.xTop, n3, this.xTop - 8, n3);
            graphics.drawString(this.yAxisChar[n] + " ", this.xBot - 30 - n2, n3 + 4);
        }
        n = 0;
        boolean bl = true;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        double[] dArray = new double[this.niPoints];
        boolean bl2 = true;
        for (int j = 0; j < this.nCurves; ++j) {
            int n22;
            CubicSpline cubicSpline;
            n21 = this.nPoints[j];
            double[] dArray2 = new double[n21];
            double[] dArray3 = new double[n21];
            if (this.lineOpt[j] == 1 || this.lineOpt[j] == 2) {
                cubicSpline = new CubicSpline(this.nPoints[j]);
                for (n22 = 0; n22 < n21; ++n22) {
                    dArray2[n22] = this.data[n11][n22];
                }
                d3 = (dArray2[n21 - 1] - dArray2[0]) / (double)(this.niPoints - 1);
                dArray[0] = dArray2[0];
                for (n22 = 1; n22 < this.niPoints; ++n22) {
                    dArray[n22] = dArray[n22 - 1] + d3;
                }
                dArray[this.niPoints - 1] = dArray2[n21 - 1];
                for (n22 = 0; n22 < n21; ++n22) {
                    dArray3[n22] = this.data[n11 + 1][n22];
                }
                cubicSpline.resetData(dArray2, dArray3);
                cubicSpline.calcDeriv();
                n15 = this.xBot + (int)((dArray2[0] - this.xLow) / d4 * d);
                n17 = this.yBot - (int)((dArray3[0] - this.yLow) / d5 * d2);
                for (n22 = 1; n22 < this.niPoints; ++n22) {
                    n16 = this.xBot + (int)((dArray[n22] - this.xLow) / d4 * d);
                    n18 = this.yBot - (int)((cubicSpline.interpolate(dArray[n22]) - this.yLow) / d5 * d2);
                    bl2 = this.printCheck(this.trimOpt[j], n15, n16, n17, n18);
                    if (bl2) {
                        if (this.lineOpt[j] == 2 && ++n > this.dashLength[j]) {
                            n = 0;
                            bl = !bl;
                        }
                        if (bl) {
                            graphics.drawLine(n15, n17, n16, n18);
                        }
                    }
                    n15 = n16;
                    n17 = n18;
                }
            }
            if (this.lineOpt[j] == -1 || this.lineOpt[j] == -2) {
                cubicSpline = new CubicSpline(this.nPoints[j]);
                for (n22 = 0; n22 < n21; ++n22) {
                    dArray2[n22] = this.data[n11][n22];
                }
                for (n22 = 0; n22 < n21; ++n22) {
                    dArray3[n22] = this.data[n11 + 1][n22];
                }
                d3 = (dArray3[n21 - 1] - dArray3[0]) / (double)(this.niPoints - 1);
                dArray[0] = dArray3[0];
                for (n22 = 1; n22 < this.niPoints; ++n22) {
                    dArray[n22] = dArray[n22 - 1] + d3;
                }
                dArray[this.niPoints - 1] = dArray3[n21 - 1];
                cubicSpline.resetData(dArray3, dArray2);
                cubicSpline.calcDeriv();
                n15 = this.xBot + (int)((dArray2[0] - this.xLow) / d4 * d);
                n17 = this.yBot - (int)((dArray3[0] - this.yLow) / d5 * d2);
                for (n22 = 1; n22 < this.niPoints; ++n22) {
                    n18 = this.yBot + (int)((dArray[n22] - this.yLow) / d5 * d2);
                    n16 = this.xBot - (int)((cubicSpline.interpolate(dArray[n22]) - this.xLow) / d4 * d);
                    bl2 = this.printCheck(this.trimOpt[j], n15, n16, n17, n18);
                    if (bl2) {
                        if (this.lineOpt[j] == 2 && ++n > this.dashLength[j]) {
                            n = 0;
                            bl = !bl;
                        }
                        if (bl) {
                            graphics.drawLine(n15, n17, n16, n18);
                        }
                    }
                    n15 = n16;
                    n17 = n18;
                }
            }
            if (this.lineOpt[j] == 3) {
                n = 0;
                bl = true;
                n15 = this.xBot + (int)((this.data[n11][0] - this.xLow) / d4 * d);
                n17 = this.yBot - (int)((this.data[n11 + 1][0] - this.yLow) / d5 * d2);
                for (int k = 1; k < n21; ++k) {
                    n16 = this.xBot + (int)((this.data[n11][k] - this.xLow) / d4 * d);
                    n18 = this.yBot - (int)((this.data[n11 + 1][k] - this.yLow) / d5 * d2);
                    bl2 = this.printCheck(this.trimOpt[j], n15, n16, n17, n18);
                    if (bl2) {
                        graphics.drawLine(n15, n17, n16, n18);
                    }
                    n15 = n16;
                    n17 = n18;
                }
            }
            if (this.lineOpt[j] == 4) {
                n = 0;
                bl = true;
                n15 = this.xBot + (int)((this.data[n11][0] - this.xLow) / d4 * d);
                n17 = this.yBot - (int)((this.data[n11 + 1][0] - this.yLow) / d5 * d2);
                for (int k = 1; k < n21; ++k) {
                    if (++n > this.dashLength[j]) {
                        n = 0;
                        bl = !bl;
                    }
                    n16 = this.xBot + (int)((this.data[n11][k] - this.xLow) / d4 * d);
                    n18 = this.yBot - (int)((this.data[n11 + 1][k] - this.yLow) / d5 * d2);
                    bl2 = this.printCheck(this.trimOpt[j], n15, n16, n17, n18);
                    if (bl) {
                        graphics.drawLine(n15, n17, n16, n18);
                    }
                    n15 = n16;
                    n17 = n18;
                }
            }
            if (this.pointOpt[j] > 0) {
                for (int k = 0; k < n21; ++k) {
                    n19 = this.pointSize[j];
                    n20 = n19 / 2;
                    n12 = this.xBot + (int)((this.data[n11][k] - this.xLow) / d4 * d);
                    n13 = this.yBot - (int)((this.data[n11 + 1][k] - this.yLow) / d5 * d2);
                    switch (this.pointOpt[j]) {
                        case 1: {
                            graphics.drawOval(n12 - n20, n13 - n20, n19, n19);
                            break;
                        }
                        case 2: {
                            graphics.drawRect(n12 - n20, n13 - n20, n19, n19);
                            break;
                        }
                        case 3: {
                            graphics.drawLine(n12 - n20, n13, n12, n13 + n20);
                            graphics.drawLine(n12, n13 + n20, n12 + n20, n13);
                            graphics.drawLine(n12 + n20, n13, n12, n13 - n20);
                            graphics.drawLine(n12, n13 - n20, n12 - n20, n13);
                            break;
                        }
                        case 4: {
                            graphics.fillOval(n12 - n20, n13 - n20, n19, n19);
                            break;
                        }
                        case 5: {
                            graphics.fillRect(n12 - n20, n13 - n20, n19, n19);
                            break;
                        }
                        case 6: {
                            for (n22 = 0; n22 < n20; ++n22) {
                                graphics.drawLine(n12 - n22, n13 - n20 + n22, n12 + n22, n13 - n20 + n22);
                            }
                            for (n22 = 0; n22 <= n20; ++n22) {
                                graphics.drawLine(n12 - n20 + n22, n13 + n22, n12 + n20 - n22, n13 + n22);
                            }
                            break;
                        }
                        case 7: {
                            graphics.drawLine(n12 - n20, n13 - n20, n12 + n20, n13 + n20);
                            graphics.drawLine(n12 - n20, n13 + n20, n12 + n20, n13 - n20);
                            break;
                        }
                        case 8: {
                            graphics.drawLine(n12 - n20, n13, n12 + n20, n13);
                            graphics.drawLine(n12, n13 + n20, n12, n13 - n20);
                            break;
                        }
                        default: {
                            graphics.drawLine(n12 - n20, n13 - n20, n12 + n20, n13 + n20);
                            graphics.drawLine(n12 - n20, n13 + n20, n12 + n20, n13 - n20);
                        }
                    }
                    if (!this.errorBar[j]) continue;
                    n14 = this.yBot - (int)((this.errors[j][k] - this.yLow) / d5 * d2);
                    graphics.drawLine(n12, n13, n12, n14);
                    graphics.drawLine(n12 - 4, n14, n12 + 4, n14);
                    n14 = 2 * n13 - n14;
                    graphics.drawLine(n12, n13, n12, n14);
                    graphics.drawLine(n12 - 4, n14, n12 + 4, n14);
                }
            }
            n11 += 2;
        }
    }

    public static long getSerialVersionUID() {
        return 1L;
    }
}

