/*
 * Decompiled with CFR 0.152.
 */
package flanagan.roots;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.math.Fmath;
import flanagan.roots.RealRootDerivFunction;
import flanagan.roots.RealRootFunction;
import java.util.ArrayList;

public class RealRoot {
    private double root = Double.NaN;
    private double tol = 1.0E-9;
    private int iterMax = 3000;
    private int iterN = 0;
    private double upperBound = 0.0;
    private double lowerBound = 0.0;
    private double estimate = 0.0;
    private int maximumBoundsExtension = 100;
    private boolean noBoundExtensions = false;
    private boolean noLowerBoundExtensions = false;
    private boolean noUpperBoundExtensions = false;
    private boolean suppressLimitReachedMessage = false;
    private boolean returnNaN = false;
    private boolean suppressNaNmessage = false;
    private static int staticIterMax = 3000;
    private static int maximumStaticBoundsExtension = 100;
    private static boolean noStaticBoundExtensions = false;
    private static boolean noStaticLowerBoundExtensions = false;
    private static boolean noStaticUpperBoundExtensions = false;
    private static boolean staticReturnNaN = false;
    private static double realTol = 1.0E-14;

    public void setLowerBound(double d) {
        this.lowerBound = d;
    }

    public void setUpperBound(double d) {
        this.upperBound = d;
    }

    public void resetNaNexceptionToTrue() {
        this.returnNaN = true;
    }

    public void resetNaNexceptionToFalse() {
        this.returnNaN = false;
    }

    public void suppressNaNmessage() {
        this.suppressNaNmessage = true;
    }

    public void supressNaNmessage() {
        this.suppressNaNmessage = true;
    }

    public void allowNaNmessage() {
        this.suppressNaNmessage = false;
    }

    public void setEstimate(double d) {
        this.estimate = d;
    }

    public void setTolerance(double d) {
        this.tol = d;
    }

    public double getTolerance() {
        return this.tol;
    }

    public void setIterMax(int n) {
        this.iterMax = n;
    }

    public int getIterMax() {
        return this.iterMax;
    }

    public int getIterN() {
        return this.iterN;
    }

    public void setmaximumStaticBoundsExtension(int n) {
        this.maximumBoundsExtension = n;
    }

    public void noBoundsExtensions() {
        this.noBoundExtensions = true;
        this.noLowerBoundExtensions = true;
        this.noUpperBoundExtensions = true;
    }

    public void noLowerBoundExtension() {
        this.noLowerBoundExtensions = true;
        if (this.noUpperBoundExtensions) {
            this.noBoundExtensions = true;
        }
    }

    public void noUpperBoundExtension() {
        this.noUpperBoundExtensions = true;
        if (this.noLowerBoundExtensions) {
            this.noBoundExtensions = true;
        }
    }

    public void suppressLimitReachedMessage() {
        this.suppressLimitReachedMessage = true;
    }

    public void supressLimitReachedMessage() {
        this.suppressLimitReachedMessage = true;
    }

    public double brent(RealRootFunction realRootFunction) {
        return this.brent(realRootFunction, this.lowerBound, this.upperBound);
    }

    public double brent(RealRootFunction realRootFunction, double d, double d2) {
        double d3;
        this.lowerBound = d;
        this.upperBound = d2;
        if (d2 == d) {
            throw new IllegalArgumentException("upper cannot equal lower");
        }
        boolean bl = true;
        this.iterN = 0;
        double d4 = 0.0;
        if (d2 < d) {
            d4 = d2;
            d2 = d;
            d = d4;
        }
        double d5 = realRootFunction.function(d2);
        double d6 = realRootFunction.function(d);
        if (Double.isNaN(d6)) {
            if (this.returnNaN) {
                if (!this.suppressNaNmessage) {
                    System.out.println("Realroot: brent: lower bound returned NaN as the function value - NaN returned as root");
                }
                return Double.NaN;
            }
            throw new ArithmeticException("lower bound returned NaN as the function value");
        }
        if (Double.isNaN(d5)) {
            if (this.returnNaN) {
                if (!this.suppressNaNmessage) {
                    System.out.println("Realroot: brent: upper bound returned NaN as the function value - NaN returned as root");
                }
                return Double.NaN;
            }
            throw new ArithmeticException("upper bound returned NaN as the function value");
        }
        boolean bl2 = true;
        int n = 0;
        double d7 = (d2 - d) / 2.0;
        while (bl2) {
            if (d5 * d6 <= 0.0) {
                bl2 = false;
                continue;
            }
            if (this.noBoundExtensions) {
                String string = "RealRoot.brent: root not bounded and no extension to bounds allowed\n";
                string = string + "NaN returned";
                if (!this.suppressNaNmessage) {
                    System.out.println(string);
                }
                return Double.NaN;
            }
            if (++n > this.maximumBoundsExtension) {
                String string = "RealRoot.brent: root not bounded and maximum number of extension to bounds allowed, " + this.maximumBoundsExtension + ", exceeded\n";
                string = string + "NaN returned";
                if (!this.suppressNaNmessage) {
                    System.out.println(string);
                }
                return Double.NaN;
            }
            if (!this.noLowerBoundExtensions) {
                d6 = realRootFunction.function(d -= d7);
            }
            if (this.noUpperBoundExtensions) continue;
            d5 = realRootFunction.function(d2 += d7);
        }
        if (d6 == 0.0) {
            this.root = d;
            bl = false;
        }
        if (d5 == 0.0) {
            this.root = d2;
            bl = false;
        }
        double d8 = d3 = (d + d2) / 2.0;
        double d9 = realRootFunction.function(d3);
        double d10 = d3 - d;
        double d11 = d9;
        double d12 = d3;
        boolean bl3 = true;
        boolean bl4 = true;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        while (bl) {
            if (d9 == 0.0 || Math.abs(d10) < this.tol) {
                bl = false;
                if (d9 == 0.0) {
                    this.root = d12;
                } else if (Math.abs(d10) < this.tol) {
                    this.root = d3;
                }
            } else {
                bl3 = bl4;
                if (bl3) {
                    if (d3 < d || d3 > d2) {
                        bl4 = false;
                    } else {
                        d11 = d9;
                        d8 = d3;
                    }
                } else {
                    bl4 = true;
                }
                if (bl4) {
                    d6 = realRootFunction.function(d);
                    d9 = realRootFunction.function(d3);
                    d5 = realRootFunction.function(d2);
                    d13 = d9 / d5;
                    d14 = d9 / d6;
                    d15 = d6 / d5;
                    d16 = d14 * (d15 * (d13 - d15) * (d2 - d3) - (1.0 - d13) * (d3 - d));
                    d17 = (d15 - 1.0) * (d13 - 1.0) * (d14 - 1.0);
                    d12 = d3;
                    d10 = d16 / d17;
                    d3 += d10;
                } else {
                    d9 = d11;
                    d3 = d8;
                    if (d9 * d6 > 0.0) {
                        d = d3;
                        d6 = d9;
                    } else {
                        d2 = d3;
                        d5 = d9;
                    }
                    d12 = d3;
                    d3 = (d + d2) / 2.0;
                    d9 = realRootFunction.function(d3);
                    d10 = d3 - d12;
                    d11 = d9;
                    d8 = d3;
                }
            }
            ++this.iterN;
            if (this.iterN <= this.iterMax) continue;
            if (!this.suppressLimitReachedMessage) {
                if (!this.suppressNaNmessage) {
                    System.out.println("Class: RealRoot; method: brent; maximum number of iterations exceeded - root at this point, " + Fmath.truncate(d3, 4) + ", returned");
                }
                if (!this.suppressNaNmessage) {
                    System.out.println("Last mid-point difference = " + Fmath.truncate(d10, 4) + ", tolerance = " + this.tol);
                }
            }
            this.root = d3;
            bl = false;
        }
        return this.root;
    }

    public double bisect(RealRootFunction realRootFunction) {
        return this.bisect(realRootFunction, this.lowerBound, this.upperBound);
    }

    public double bisect(RealRootFunction realRootFunction, double d, double d2) {
        this.lowerBound = d;
        this.upperBound = d2;
        if (d2 == d) {
            throw new IllegalArgumentException("upper cannot equal lower");
        }
        if (d2 < d) {
            double d3 = d2;
            d2 = d;
            d = d3;
        }
        boolean bl = true;
        this.iterN = 0;
        double d4 = 1.0E300;
        double d5 = realRootFunction.function(d2);
        double d6 = realRootFunction.function(d);
        if (Double.isNaN(d6)) {
            if (this.returnNaN) {
                if (!this.suppressNaNmessage) {
                    System.out.println("RealRoot: bisect: lower bound returned NaN as the function value - NaN returned as root");
                }
                return Double.NaN;
            }
            throw new ArithmeticException("lower bound returned NaN as the function value");
        }
        if (Double.isNaN(d5)) {
            if (this.returnNaN) {
                if (!this.suppressNaNmessage) {
                    System.out.println("RealRoot: bisect: upper bound returned NaN as the function value - NaN returned as root");
                }
                return Double.NaN;
            }
            throw new ArithmeticException("upper bound returned NaN as the function value");
        }
        boolean bl2 = true;
        int n = 0;
        double d7 = (d2 - d) / 2.0;
        while (bl2) {
            if (d5 * d6 <= 0.0) {
                bl2 = false;
                continue;
            }
            if (this.noBoundExtensions) {
                String string = "RealRoot.bisect: root not bounded and no extension to bounds allowed\n";
                string = string + "NaN returned";
                if (!this.suppressNaNmessage) {
                    System.out.println(string);
                }
                return Double.NaN;
            }
            if (++n > this.maximumBoundsExtension) {
                String string = "RealRoot.bisect: root not bounded and maximum number of extension to bounds allowed, " + this.maximumBoundsExtension + ", exceeded\n";
                string = string + "NaN returned";
                if (!this.suppressNaNmessage) {
                    System.out.println(string);
                }
                return Double.NaN;
            }
            if (!this.noLowerBoundExtensions) {
                d6 = realRootFunction.function(d -= d7);
            }
            if (this.noUpperBoundExtensions) continue;
            d5 = realRootFunction.function(d2 += d7);
        }
        if (d6 == 0.0) {
            this.root = d;
            bl = false;
        }
        if (d5 == 0.0) {
            this.root = d2;
            bl = false;
        }
        double d8 = (d + d2) / 2.0;
        double d9 = 1.0E300;
        double d10 = realRootFunction.function(d8);
        while (bl) {
            if (d10 == 0.0 || d4 < this.tol) {
                bl = false;
                this.root = d8;
            }
            if (d10 * d6 > 0.0) {
                d = d8;
                d6 = d10;
            } else {
                d2 = d8;
                d5 = d10;
            }
            d9 = d8;
            d8 = (d + d2) / 2.0;
            d10 = realRootFunction.function(d8);
            d4 = Math.abs(d8 - d9);
            ++this.iterN;
            if (this.iterN <= this.iterMax) continue;
            if (!this.suppressLimitReachedMessage) {
                if (!this.suppressNaNmessage) {
                    System.out.println("Class: RealRoot; method: bisect; maximum number of iterations exceeded - root at this point, " + Fmath.truncate(d8, 4) + ", returned");
                }
                if (!this.suppressNaNmessage) {
                    System.out.println("Last mid-point difference = " + Fmath.truncate(d4, 4) + ", tolerance = " + this.tol);
                }
            }
            this.root = d8;
            bl = false;
        }
        return this.root;
    }

    public double falsePosition(RealRootFunction realRootFunction) {
        return this.falsePosition(realRootFunction, this.lowerBound, this.upperBound);
    }

    public double falsePosition(RealRootFunction realRootFunction, double d, double d2) {
        this.lowerBound = d;
        this.upperBound = d2;
        if (d2 == d) {
            throw new IllegalArgumentException("upper cannot equal lower");
        }
        if (d2 < d) {
            double d3 = d2;
            d2 = d;
            d = d3;
        }
        boolean bl = true;
        this.iterN = 0;
        double d4 = 1.0E300;
        double d5 = realRootFunction.function(d2);
        double d6 = realRootFunction.function(d);
        if (Double.isNaN(d6)) {
            if (this.returnNaN) {
                if (!this.suppressNaNmessage) {
                    System.out.println("RealRoot: fals: ePositionlower bound returned NaN as the function value - NaN returned as root");
                }
                return Double.NaN;
            }
            throw new ArithmeticException("lower bound returned NaN as the function value");
        }
        if (Double.isNaN(d5)) {
            if (this.returnNaN) {
                if (!this.suppressNaNmessage) {
                    System.out.println("RealRoot: falsePosition: upper bound returned NaN as the function value - NaN returned as root");
                }
                return Double.NaN;
            }
            throw new ArithmeticException("upper bound returned NaN as the function value");
        }
        boolean bl2 = true;
        int n = 0;
        double d7 = (d2 - d) / 2.0;
        while (bl2) {
            if (d5 * d6 <= 0.0) {
                bl2 = false;
                continue;
            }
            if (this.noBoundExtensions) {
                String string = "RealRoot.falsePosition: root not bounded and no extension to bounds allowed\n";
                string = string + "NaN returned";
                if (!this.suppressNaNmessage) {
                    System.out.println(string);
                }
                return Double.NaN;
            }
            if (++n > this.maximumBoundsExtension) {
                String string = "RealRoot.falsePosition: root not bounded and maximum number of extension to bounds allowed, " + this.maximumBoundsExtension + ", exceeded\n";
                string = string + "NaN returned";
                if (!this.suppressNaNmessage) {
                    System.out.println(string);
                }
                return Double.NaN;
            }
            if (!this.noLowerBoundExtensions) {
                d6 = realRootFunction.function(d -= d7);
            }
            if (this.noUpperBoundExtensions) continue;
            d5 = realRootFunction.function(d2 += d7);
        }
        if (d6 == 0.0) {
            this.root = d;
            bl = false;
        }
        if (d5 == 0.0) {
            this.root = d2;
            bl = false;
        }
        double d8 = d + (d2 - d) * Math.abs(d6) / (Math.abs(d6) + Math.abs(d5));
        double d9 = 1.0E300;
        double d10 = realRootFunction.function(d8);
        while (bl) {
            if (d10 == 0.0 || d4 < this.tol) {
                bl = false;
                this.root = d8;
            }
            if (d10 * d6 > 0.0) {
                d = d8;
                d6 = d10;
            } else {
                d2 = d8;
                d5 = d10;
            }
            d9 = d8;
            d8 = d + (d2 - d) * Math.abs(d6) / (Math.abs(d6) + Math.abs(d5));
            d10 = realRootFunction.function(d8);
            d4 = Math.abs(d8 - d9);
            ++this.iterN;
            if (this.iterN <= this.iterMax) continue;
            if (!this.suppressLimitReachedMessage) {
                if (!this.suppressNaNmessage) {
                    System.out.println("Class: RealRoot; method: falsePostion; maximum number of iterations exceeded - root at this point, " + Fmath.truncate(d8, 4) + ", returned");
                }
                if (!this.suppressNaNmessage) {
                    System.out.println("Last mid-point difference = " + Fmath.truncate(d4, 4) + ", tolerance = " + this.tol);
                }
            }
            this.root = d8;
            bl = false;
        }
        return this.root;
    }

    public double bisectNewtonRaphson(RealRootDerivFunction realRootDerivFunction) {
        return this.bisectNewtonRaphson(realRootDerivFunction, this.lowerBound, this.upperBound);
    }

    public double bisectNewtonRaphson(RealRootDerivFunction realRootDerivFunction, double d, double d2) {
        double d3;
        double d4;
        this.lowerBound = d;
        this.upperBound = d2;
        if (d2 == d) {
            throw new IllegalArgumentException("upper cannot equal lower");
        }
        boolean bl = true;
        this.iterN = 0;
        double d5 = 0.0;
        if (d2 < d) {
            d5 = d2;
            d2 = d;
            d = d5;
        }
        double[] dArray = realRootDerivFunction.function(d2);
        double d6 = dArray[0];
        dArray = realRootDerivFunction.function(d);
        double d7 = dArray[0];
        if (Double.isNaN(d7)) {
            if (this.returnNaN) {
                if (!this.suppressNaNmessage) {
                    System.out.println("RealRoot: bisectNewtonRaphson: lower bound returned NaN as the function value - NaN returned as root");
                }
                return Double.NaN;
            }
            throw new ArithmeticException("lower bound returned NaN as the function value");
        }
        if (Double.isNaN(d6)) {
            if (this.returnNaN) {
                if (!this.suppressNaNmessage) {
                    System.out.println("RealRoot: bisectNewtonRaphson: upper bound returned NaN as the function value - NaN returned as root");
                }
                return Double.NaN;
            }
            throw new ArithmeticException("upper bound returned NaN as the function value");
        }
        boolean bl2 = true;
        int n = 0;
        double d8 = (d2 - d) / 2.0;
        while (bl2) {
            if (d6 * d7 <= 0.0) {
                bl2 = false;
                continue;
            }
            if (this.noBoundExtensions) {
                String string = "RealRoot.bisectNewtonRaphson: root not bounded and no extension to bounds allowed\n";
                string = string + "NaN returned";
                if (!this.suppressNaNmessage) {
                    System.out.println(string);
                }
                return Double.NaN;
            }
            if (++n > this.maximumBoundsExtension) {
                String string = "RealRoot.bisectNewtonRaphson: root not bounded and maximum number of extension to bounds allowed, " + this.maximumBoundsExtension + ", exceeded\n";
                string = string + "NaN returned";
                if (!this.suppressNaNmessage) {
                    System.out.println(string);
                }
                return Double.NaN;
            }
            if (!this.noLowerBoundExtensions) {
                dArray = realRootDerivFunction.function(d -= d8);
                d7 = dArray[0];
            }
            if (this.noUpperBoundExtensions) continue;
            dArray = realRootDerivFunction.function(d2 += d8);
            d6 = dArray[0];
        }
        if (d7 == 0.0) {
            this.root = d;
            bl = false;
        }
        if (d6 == 0.0) {
            this.root = d2;
            bl = false;
        }
        double d9 = d4 = (d + d2) / 2.0;
        dArray = realRootDerivFunction.function(d4);
        double d10 = dArray[0] / dArray[1];
        double d11 = d3 = dArray[0];
        double d12 = d4;
        d4 -= d10;
        boolean bl3 = true;
        boolean bl4 = true;
        while (bl) {
            if (d3 == 0.0 || Math.abs(d10) < this.tol) {
                bl = false;
                if (d3 == 0.0) {
                    this.root = d12;
                } else if (Math.abs(d10) < this.tol) {
                    this.root = d4;
                }
            } else {
                bl3 = bl4;
                if (bl3) {
                    if (d4 < d || d4 > d2) {
                        bl4 = false;
                    } else {
                        d11 = d3;
                        d9 = d4;
                    }
                } else {
                    bl4 = true;
                }
                if (bl4) {
                    dArray = realRootDerivFunction.function(d4);
                    d3 = dArray[0];
                    d10 = dArray[0] / dArray[1];
                    d12 = d4;
                    d4 -= d10;
                } else {
                    d3 = d11;
                    d4 = d9;
                    if (d3 * d7 > 0.0) {
                        d = d4;
                        d7 = d3;
                    } else {
                        d2 = d4;
                        d6 = d3;
                    }
                    d12 = d4;
                    d4 = (d + d2) / 2.0;
                    dArray = realRootDerivFunction.function(d4);
                    d3 = dArray[0];
                    d10 = d4 - d12;
                    d11 = d3;
                    d9 = d4;
                }
            }
            ++this.iterN;
            if (this.iterN <= this.iterMax) continue;
            if (!this.suppressLimitReachedMessage) {
                if (!this.suppressNaNmessage) {
                    System.out.println("Class: RealRoot; method: bisectNewtonRaphson; maximum number of iterations exceeded - root at this point, " + Fmath.truncate(d4, 4) + ", returned");
                }
                if (!this.suppressNaNmessage) {
                    System.out.println("Last mid-point difference = " + Fmath.truncate(d10, 4) + ", tolerance = " + this.tol);
                }
            }
            this.root = d4;
            bl = false;
        }
        return this.root;
    }

    public double newtonRaphson(RealRootDerivFunction realRootDerivFunction) {
        return this.newtonRaphson(realRootDerivFunction, this.estimate);
    }

    public double newtonRaphson(RealRootDerivFunction realRootDerivFunction, double d) {
        this.estimate = d;
        boolean bl = true;
        this.iterN = 0;
        double d2 = 1.0E300;
        double[] dArray = realRootDerivFunction.function(d);
        if (Double.isNaN(dArray[0])) {
            if (this.returnNaN) {
                if (!this.suppressNaNmessage) {
                    System.out.println("RealRoot: newtonRaphson: NaN returned as the function value - NaN returned as root");
                }
                return Double.NaN;
            }
            throw new ArithmeticException("NaN returned as the function value");
        }
        if (Double.isNaN(dArray[1])) {
            if (this.returnNaN) {
                if (!this.suppressNaNmessage) {
                    System.out.println("RealRoot: newtonRaphson: NaN returned as the derivative function value - NaN returned as root");
                }
                return Double.NaN;
            }
            throw new ArithmeticException("NaN returned as the derivative function value");
        }
        while (bl) {
            d2 = dArray[0] / dArray[1];
            if (dArray[0] == 0.0 || Math.abs(d2) < this.tol) {
                this.root = d;
                bl = false;
            } else {
                dArray = realRootDerivFunction.function(d -= d2);
                if (Double.isNaN(dArray[0])) {
                    throw new ArithmeticException("NaN returned as the function value");
                }
                if (Double.isNaN(dArray[1])) {
                    throw new ArithmeticException("NaN returned as the derivative function value");
                }
                if (Double.isNaN(dArray[0])) {
                    if (this.returnNaN) {
                        if (!this.suppressNaNmessage) {
                            System.out.println("RealRoot: bisect: NaN as the function value - NaN returned as root");
                        }
                        return Double.NaN;
                    }
                    throw new ArithmeticException("NaN as the function value");
                }
                if (Double.isNaN(dArray[1])) {
                    if (this.returnNaN) {
                        if (!this.suppressNaNmessage) {
                            System.out.println("NaN as the function value - NaN returned as root");
                        }
                        return Double.NaN;
                    }
                    throw new ArithmeticException("NaN as the function value");
                }
            }
            ++this.iterN;
            if (this.iterN <= this.iterMax) continue;
            if (!this.suppressLimitReachedMessage) {
                if (!this.suppressNaNmessage) {
                    System.out.println("Class: RealRoot; method: newtonRaphson; maximum number of iterations exceeded - root at this point, " + Fmath.truncate(d, 4) + ", returned");
                }
                if (!this.suppressNaNmessage) {
                    System.out.println("Last mid-point difference = " + Fmath.truncate(d2, 4) + ", tolerance = " + this.tol);
                }
            }
            this.root = d;
            bl = false;
        }
        return this.root;
    }

    public void setStaticIterMax(int n) {
        staticIterMax = n;
    }

    public int getStaticIterMax() {
        return staticIterMax;
    }

    public void setStaticMaximumStaticBoundsExtension(int n) {
        maximumStaticBoundsExtension = n;
    }

    public void noStaticBoundsExtensions() {
        noStaticBoundExtensions = true;
        noStaticLowerBoundExtensions = true;
        noStaticUpperBoundExtensions = true;
    }

    public void noStaticLowerBoundExtension() {
        noStaticLowerBoundExtensions = true;
        if (noStaticUpperBoundExtensions) {
            noStaticBoundExtensions = true;
        }
    }

    public void noStaticUpperBoundExtension() {
        noStaticUpperBoundExtensions = true;
        if (noStaticLowerBoundExtensions) {
            noStaticBoundExtensions = true;
        }
    }

    public void resetStaticNaNexceptionToTrue() {
        staticReturnNaN = true;
    }

    public void resetStaticNaNexceptionToFalse() {
        staticReturnNaN = false;
    }

    public static double brent(RealRootFunction realRootFunction, double d, double d2, double d3) {
        double d4;
        if (d2 == d) {
            throw new IllegalArgumentException("upper cannot equal lower");
        }
        double d5 = Double.NaN;
        boolean bl = true;
        int n = 0;
        double d6 = 0.0;
        if (d2 < d) {
            d6 = d2;
            d2 = d;
            d = d6;
        }
        double d7 = realRootFunction.function(d2);
        double d8 = realRootFunction.function(d);
        if (Double.isNaN(d8)) {
            if (staticReturnNaN) {
                System.out.println("Realroot: brent: lower bound returned NaN as the function value - NaN returned as root");
                return Double.NaN;
            }
            throw new ArithmeticException("lower bound returned NaN as the function value");
        }
        if (Double.isNaN(d7)) {
            if (staticReturnNaN) {
                System.out.println("Realroot: brent: upper bound returned NaN as the function value - NaN returned as root");
                return Double.NaN;
            }
            throw new ArithmeticException("upper bound returned NaN as the function value");
        }
        boolean bl2 = true;
        int n2 = 0;
        double d9 = (d2 - d) / 2.0;
        while (bl2) {
            if (d7 * d8 <= 0.0) {
                bl2 = false;
                continue;
            }
            if (noStaticBoundExtensions) {
                String string = "RealRoot.brent: root not bounded and no extension to bounds allowed\n";
                string = string + "NaN returned";
                System.out.println(string);
                return Double.NaN;
            }
            if (++n2 > maximumStaticBoundsExtension) {
                String string = "RealRoot.brent: root not bounded and maximum number of extension to bounds allowed, " + maximumStaticBoundsExtension + ", exceeded\n";
                string = string + "NaN returned";
                System.out.println(string);
                return Double.NaN;
            }
            if (!noStaticLowerBoundExtensions) {
                d8 = realRootFunction.function(d -= d9);
            }
            if (noStaticUpperBoundExtensions) continue;
            d7 = realRootFunction.function(d2 += d9);
        }
        if (d8 == 0.0) {
            d5 = d;
            bl = false;
        }
        if (d7 == 0.0) {
            d5 = d2;
            bl = false;
        }
        double d10 = d4 = (d + d2) / 2.0;
        double d11 = realRootFunction.function(d4);
        double d12 = d4 - d;
        double d13 = d11;
        double d14 = d4;
        boolean bl3 = true;
        boolean bl4 = true;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        while (bl) {
            if (d11 == 0.0 || Math.abs(d12) < d3) {
                bl = false;
                if (d11 == 0.0) {
                    d5 = d14;
                } else if (Math.abs(d12) < d3) {
                    d5 = d4;
                }
            } else {
                bl3 = bl4;
                if (bl3) {
                    if (d4 < d || d4 > d2) {
                        bl4 = false;
                    } else {
                        d13 = d11;
                        d10 = d4;
                    }
                } else {
                    bl4 = true;
                }
                if (bl4) {
                    d8 = realRootFunction.function(d);
                    d11 = realRootFunction.function(d4);
                    d7 = realRootFunction.function(d2);
                    d15 = d11 / d7;
                    d16 = d11 / d8;
                    d17 = d8 / d7;
                    d18 = d16 * (d17 * (d15 - d17) * (d2 - d4) - (1.0 - d15) * (d4 - d));
                    d19 = (d17 - 1.0) * (d15 - 1.0) * (d16 - 1.0);
                    d14 = d4;
                    d12 = d18 / d19;
                    d4 += d12;
                } else {
                    d11 = d13;
                    d4 = d10;
                    if (d11 * d8 > 0.0) {
                        d = d4;
                        d8 = d11;
                    } else {
                        d2 = d4;
                        d7 = d11;
                    }
                    d14 = d4;
                    d4 = (d + d2) / 2.0;
                    d11 = realRootFunction.function(d4);
                    d12 = d4 - d14;
                    d13 = d11;
                    d10 = d4;
                }
            }
            if (++n <= staticIterMax) continue;
            System.out.println("Class: RealRoot; method: brent; maximum number of iterations exceeded - root at this point, " + Fmath.truncate(d4, 4) + ", returned");
            System.out.println("Last mid-point difference = " + Fmath.truncate(d12, 4) + ", tolerance = " + d3);
            d5 = d4;
            bl = false;
        }
        return d5;
    }

    public static double bisect(RealRootFunction realRootFunction, double d, double d2, double d3) {
        double d4;
        if (d2 == d) {
            throw new IllegalArgumentException("upper cannot equal lower");
        }
        if (d2 < d) {
            d4 = d2;
            d2 = d;
            d = d4;
        }
        d4 = Double.NaN;
        boolean bl = true;
        int n = 0;
        double d5 = 1.0E300;
        double d6 = realRootFunction.function(d2);
        double d7 = realRootFunction.function(d);
        if (Double.isNaN(d7)) {
            if (staticReturnNaN) {
                System.out.println("RealRoot: bisect: lower bound returned NaN as the function value - NaN returned as root");
                return Double.NaN;
            }
            throw new ArithmeticException("lower bound returned NaN as the function value");
        }
        if (Double.isNaN(d6)) {
            if (staticReturnNaN) {
                System.out.println("RealRoot: bisect: upper bound returned NaN as the function value - NaN returned as root");
                return Double.NaN;
            }
            throw new ArithmeticException("upper bound returned NaN as the function value");
        }
        boolean bl2 = true;
        int n2 = 0;
        double d8 = (d2 - d) / 2.0;
        while (bl2) {
            if (d6 * d7 <= 0.0) {
                bl2 = false;
                continue;
            }
            if (noStaticBoundExtensions) {
                String string = "RealRoot.bisect: root not bounded and no extension to bounds allowed\n";
                string = string + "NaN returned";
                System.out.println(string);
                return Double.NaN;
            }
            if (++n2 > maximumStaticBoundsExtension) {
                String string = "RealRoot.bisect: root not bounded and maximum number of extension to bounds allowed, " + maximumStaticBoundsExtension + ", exceeded\n";
                string = string + "NaN returned";
                System.out.println(string);
                return Double.NaN;
            }
            if (!noStaticLowerBoundExtensions) {
                d7 = realRootFunction.function(d -= d8);
            }
            if (noStaticUpperBoundExtensions) continue;
            d6 = realRootFunction.function(d2 += d8);
        }
        if (d7 == 0.0) {
            d4 = d;
            bl = false;
        }
        if (d6 == 0.0) {
            d4 = d2;
            bl = false;
        }
        double d9 = (d + d2) / 2.0;
        double d10 = 1.0E300;
        double d11 = realRootFunction.function(d9);
        while (bl) {
            if (d11 == 0.0 || d5 < d3) {
                bl = false;
                d4 = d9;
            }
            if (d11 * d7 > 0.0) {
                d = d9;
                d7 = d11;
            } else {
                d2 = d9;
                d6 = d11;
            }
            d10 = d9;
            d9 = (d + d2) / 2.0;
            d11 = realRootFunction.function(d9);
            d5 = Math.abs(d9 - d10);
            if (++n <= staticIterMax) continue;
            System.out.println("Class: RealRoot; method: bisect; maximum number of iterations exceeded - root at this point, " + Fmath.truncate(d9, 4) + ", returned");
            System.out.println("Last mid-point difference = " + Fmath.truncate(d5, 4) + ", tolerance = " + d3);
            d4 = d9;
            bl = false;
        }
        return d4;
    }

    public static double falsePosition(RealRootFunction realRootFunction, double d, double d2, double d3) {
        double d4;
        if (d2 == d) {
            throw new IllegalArgumentException("upper cannot equal lower");
        }
        if (d2 < d) {
            d4 = d2;
            d2 = d;
            d = d4;
        }
        d4 = Double.NaN;
        boolean bl = true;
        int n = 0;
        double d5 = 1.0E300;
        double d6 = realRootFunction.function(d2);
        double d7 = realRootFunction.function(d);
        if (Double.isNaN(d7)) {
            if (staticReturnNaN) {
                System.out.println("RealRoot: fals: ePositionlower bound returned NaN as the function value - NaN returned as root");
                return Double.NaN;
            }
            throw new ArithmeticException("lower bound returned NaN as the function value");
        }
        if (Double.isNaN(d6)) {
            if (staticReturnNaN) {
                System.out.println("RealRoot: falsePosition: upper bound returned NaN as the function value - NaN returned as root");
                return Double.NaN;
            }
            throw new ArithmeticException("upper bound returned NaN as the function value");
        }
        boolean bl2 = true;
        int n2 = 0;
        double d8 = (d2 - d) / 2.0;
        while (bl2) {
            if (d6 * d7 <= 0.0) {
                bl2 = false;
                continue;
            }
            if (noStaticBoundExtensions) {
                String string = "RealRoot.falsePosition: root not bounded and no extension to bounds allowed\n";
                string = string + "NaN returned";
                System.out.println(string);
                return Double.NaN;
            }
            if (++n2 > maximumStaticBoundsExtension) {
                String string = "RealRoot.falsePosition: root not bounded and maximum number of extension to bounds allowed, " + maximumStaticBoundsExtension + ", exceeded\n";
                string = string + "NaN returned";
                System.out.println(string);
                return Double.NaN;
            }
            if (!noStaticLowerBoundExtensions) {
                d7 = realRootFunction.function(d -= d8);
            }
            if (noStaticUpperBoundExtensions) continue;
            d6 = realRootFunction.function(d2 += d8);
        }
        if (d7 == 0.0) {
            d4 = d;
            bl = false;
        }
        if (d6 == 0.0) {
            d4 = d2;
            bl = false;
        }
        double d9 = d + (d2 - d) * Math.abs(d7) / (Math.abs(d7) + Math.abs(d6));
        double d10 = 1.0E300;
        double d11 = realRootFunction.function(d9);
        while (bl) {
            if (d11 == 0.0 || d5 < d3) {
                bl = false;
                d4 = d9;
            }
            if (d11 * d7 > 0.0) {
                d = d9;
                d7 = d11;
            } else {
                d2 = d9;
                d6 = d11;
            }
            d10 = d9;
            d9 = d + (d2 - d) * Math.abs(d7) / (Math.abs(d7) + Math.abs(d6));
            d11 = realRootFunction.function(d9);
            d5 = Math.abs(d9 - d10);
            if (++n <= staticIterMax) continue;
            System.out.println("Class: RealRoot; method: falsePostion; maximum number of iterations exceeded - root at this point, " + Fmath.truncate(d9, 4) + ", returned");
            System.out.println("Last mid-point difference = " + Fmath.truncate(d5, 4) + ", tolerance = " + d3);
            d4 = d9;
            bl = false;
        }
        return d4;
    }

    public static double bisectNewtonRaphson(RealRootDerivFunction realRootDerivFunction, double d, double d2, double d3) {
        double d4;
        double d5;
        if (d2 == d) {
            throw new IllegalArgumentException("upper cannot equal lower");
        }
        double d6 = Double.NaN;
        boolean bl = true;
        int n = 0;
        double d7 = 0.0;
        if (d2 < d) {
            d7 = d2;
            d2 = d;
            d = d7;
        }
        double[] dArray = realRootDerivFunction.function(d2);
        double d8 = dArray[0];
        dArray = realRootDerivFunction.function(d);
        double d9 = dArray[0];
        if (Double.isNaN(d9)) {
            if (staticReturnNaN) {
                System.out.println("RealRoot: bisectNewtonRaphson: lower bound returned NaN as the function value - NaN returned as root");
                return Double.NaN;
            }
            throw new ArithmeticException("lower bound returned NaN as the function value");
        }
        if (Double.isNaN(d8)) {
            if (staticReturnNaN) {
                System.out.println("RealRoot: bisectNewtonRaphson: upper bound returned NaN as the function value - NaN returned as root");
                return Double.NaN;
            }
            throw new ArithmeticException("upper bound returned NaN as the function value");
        }
        boolean bl2 = true;
        int n2 = 0;
        double d10 = (d2 - d) / 2.0;
        while (bl2) {
            if (d8 * d9 <= 0.0) {
                bl2 = false;
                continue;
            }
            if (noStaticBoundExtensions) {
                String string = "RealRoot.bisectNewtonRaphson: root not bounded and no extension to bounds allowed\n";
                string = string + "NaN returned";
                System.out.println(string);
                return Double.NaN;
            }
            if (++n2 > maximumStaticBoundsExtension) {
                String string = "RealRoot.bisectNewtonRaphson: root not bounded and maximum number of extension to bounds allowed, " + maximumStaticBoundsExtension + ", exceeded\n";
                string = string + "NaN returned";
                System.out.println(string);
                return Double.NaN;
            }
            if (!noStaticLowerBoundExtensions) {
                dArray = realRootDerivFunction.function(d -= d10);
                d9 = dArray[0];
            }
            if (noStaticUpperBoundExtensions) continue;
            dArray = realRootDerivFunction.function(d2 += d10);
            d8 = dArray[0];
        }
        if (d9 == 0.0) {
            d6 = d;
            bl = false;
        }
        if (d8 == 0.0) {
            d6 = d2;
            bl = false;
        }
        double d11 = d5 = (d + d2) / 2.0;
        dArray = realRootDerivFunction.function(d5);
        double d12 = dArray[0] / dArray[1];
        double d13 = d4 = dArray[0];
        double d14 = d5;
        d5 -= d12;
        boolean bl3 = true;
        boolean bl4 = true;
        while (bl) {
            if (d4 == 0.0 || Math.abs(d12) < d3) {
                bl = false;
                if (d4 == 0.0) {
                    d6 = d14;
                } else if (Math.abs(d12) < d3) {
                    d6 = d5;
                }
            } else {
                bl3 = bl4;
                if (bl3) {
                    if (d5 < d || d5 > d2) {
                        bl4 = false;
                    } else {
                        d13 = d4;
                        d11 = d5;
                    }
                } else {
                    bl4 = true;
                }
                if (bl4) {
                    dArray = realRootDerivFunction.function(d5);
                    d4 = dArray[0];
                    d12 = dArray[0] / dArray[1];
                    d14 = d5;
                    d5 -= d12;
                } else {
                    d4 = d13;
                    d5 = d11;
                    if (d4 * d9 > 0.0) {
                        d = d5;
                        d9 = d4;
                    } else {
                        d2 = d5;
                        d8 = d4;
                    }
                    d14 = d5;
                    d5 = (d + d2) / 2.0;
                    dArray = realRootDerivFunction.function(d5);
                    d4 = dArray[0];
                    d12 = d5 - d14;
                    d13 = d4;
                    d11 = d5;
                }
            }
            if (++n <= staticIterMax) continue;
            System.out.println("Class: RealRoot; method: bisectNewtonRaphson; maximum number of iterations exceeded - root at this point, " + Fmath.truncate(d5, 4) + ", returned");
            System.out.println("Last mid-point difference = " + Fmath.truncate(d12, 4) + ", tolerance = " + d3);
            d6 = d5;
            bl = false;
        }
        return d6;
    }

    public static double newtonRaphson(RealRootDerivFunction realRootDerivFunction, double d, double d2) {
        double d3 = Double.NaN;
        boolean bl = true;
        int n = 0;
        double d4 = 1.0E300;
        double[] dArray = realRootDerivFunction.function(d);
        if (Double.isNaN(dArray[0])) {
            if (staticReturnNaN) {
                System.out.println("RealRoot: newtonRaphson: NaN returned as the function value - NaN returned as root");
                return Double.NaN;
            }
            throw new ArithmeticException("NaN returned as the function value");
        }
        if (Double.isNaN(dArray[1])) {
            if (staticReturnNaN) {
                System.out.println("RealRoot: newtonRaphson: NaN returned as the derivative function value - NaN returned as root");
                return Double.NaN;
            }
            throw new ArithmeticException("NaN returned as the derivative function value");
        }
        while (bl) {
            d4 = dArray[0] / dArray[1];
            if (dArray[0] == 0.0 || Math.abs(d4) < d2) {
                d3 = d;
                bl = false;
            } else {
                dArray = realRootDerivFunction.function(d -= d4);
                if (Double.isNaN(dArray[0])) {
                    throw new ArithmeticException("NaN returned as the function value");
                }
                if (Double.isNaN(dArray[1])) {
                    throw new ArithmeticException("NaN returned as the derivative function value");
                }
                if (Double.isNaN(dArray[0])) {
                    if (staticReturnNaN) {
                        System.out.println("RealRoot: NewtonRaphson: NaN as the function value - NaN returned as root");
                        return Double.NaN;
                    }
                    throw new ArithmeticException("NaN as the function value");
                }
                if (Double.isNaN(dArray[1])) {
                    if (staticReturnNaN) {
                        System.out.println("NaN as the function value - NaN returned as root");
                        return Double.NaN;
                    }
                    throw new ArithmeticException("NaN as the function value");
                }
            }
            if (++n <= staticIterMax) continue;
            System.out.println("Class: RealRoot; method: newtonRaphson; maximum number of iterations exceeded - root at this point, " + Fmath.truncate(d, 4) + ", returned");
            System.out.println("Last mid-point difference = " + Fmath.truncate(d4, 4) + ", tolerance = " + d2);
            d3 = d;
            bl = false;
        }
        return d3;
    }

    public static ArrayList<Object> quadratic(double d, double d2, double d3) {
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        double d4 = d2 * d2;
        double d5 = 4.0 * d3 * d;
        if (d4 < d5) {
            Complex[] complexArray = ComplexPoly.quadratic(d, d2, d3);
            arrayList.add("complex");
            arrayList.add(complexArray);
        } else {
            double[] dArray = new double[2];
            double d6 = Fmath.sign(d2);
            double d7 = Math.sqrt(d4 - d5);
            d7 = -0.5 * (d2 + d6 * d7);
            dArray[0] = d7 / d3;
            dArray[1] = d / d7;
            arrayList.add("real");
            arrayList.add(dArray);
        }
        return arrayList;
    }

    public static ArrayList<Object> cubic(double d, double d2, double d3, double d4) {
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        double d5 = d3 / d4;
        double d6 = d2 / d4;
        double d7 = d / d4;
        double d8 = (2.0 * d5 * d5 * d5 - 9.0 * d5 * d6 + 27.0 * d7) / 54.0;
        double d9 = d8 * d8;
        double d10 = (d5 * d5 - 3.0 * d6) / 9.0;
        double d11 = d10 * d10 * d10;
        if (d9 >= d11) {
            Complex[] complexArray = ComplexPoly.cubic(d, d2, d3, d4);
            arrayList.add("complex");
            arrayList.add(complexArray);
        } else {
            double[] dArray = new double[3];
            double d12 = Math.acos(d8 / Math.sqrt(d11));
            double d13 = d5 / 3.0;
            double d14 = -2.0 * Math.sqrt(d10);
            dArray[0] = d14 * Math.cos(d12 / 3.0) - d13;
            dArray[1] = d14 * Math.cos((d12 + Math.PI * 2) / 3.0) - d13;
            dArray[2] = d14 * Math.cos((d12 - Math.PI * 2) / 3.0) - d13;
            arrayList.add("real");
            arrayList.add(dArray);
        }
        return arrayList;
    }

    public static ArrayList<Object> polynomial(double[] dArray) {
        boolean bl = true;
        double d = 0.0;
        return RealRoot.polynomial(dArray, bl, d);
    }

    public static ArrayList<Object> polynomial(double[] dArray, boolean bl) {
        double d = 0.0;
        return RealRoot.polynomial(dArray, bl, d);
    }

    public static ArrayList<Object> polynomial(double[] dArray, double d) {
        boolean bl = true;
        return RealRoot.polynomial(dArray, bl, d);
    }

    public static ArrayList<Object> polynomial(double[] dArray, boolean bl, double d) {
        Complex[] complexArray;
        Object[] objectArray;
        int n;
        int n2 = dArray.length;
        if (n2 < 2) {
            throw new IllegalArgumentException("a minimum of two coefficients is required");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        boolean bl2 = true;
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = true;
        while (bl3) {
            if (dArray[n4] == 0.0) {
                ++n3;
                ++n4;
                continue;
            }
            bl3 = false;
        }
        int n5 = n2 - n3;
        double[] dArray2 = new double[n5];
        if (n3 > 0) {
            for (n = 0; n < n5; ++n) {
                dArray2[n] = dArray[n + n3];
            }
        } else {
            for (n = 0; n < n5; ++n) {
                dArray2[n] = dArray[n];
            }
        }
        ArrayList<Object> arrayList2 = new ArrayList<String>(2);
        double[] dArray3 = null;
        switch (n5) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                arrayList2.add("real");
                objectArray = new double[]{-dArray2[0] / dArray2[1]};
                arrayList2.add(objectArray);
                break;
            }
            case 3: {
                arrayList2 = RealRoot.quadratic(dArray2[0], dArray2[1], dArray2[2]);
                if (!((String)arrayList2.get(0)).equals("complex")) break;
                bl2 = false;
                break;
            }
            case 4: {
                arrayList2 = RealRoot.cubic(dArray2[0], dArray2[1], dArray2[2], dArray2[3]);
                if (!((String)arrayList2.get(0)).equals("complex")) break;
                bl2 = false;
                break;
            }
            default: {
                complexArray = new ComplexPoly(dArray2);
                Complex[] complexArray2 = complexArray.roots(bl, new Complex(d, 0.0));
                dArray3 = new double[n5 - 1];
                int n6 = 0;
                for (int j = 0; j < n5 - 1; ++j) {
                    if (!(complexArray2[j].getImag() / complexArray2[j].getReal() < realTol)) continue;
                    dArray3[j] = complexArray2[j].getReal();
                    ++n6;
                }
                if (n6 == n5 - 1) {
                    arrayList2.add("real");
                    arrayList2.add(dArray3);
                    break;
                }
                arrayList2.add("complex");
                arrayList2.add(complexArray2);
                bl2 = false;
            }
        }
        if (n3 == 0) {
            arrayList = arrayList2;
        } else if (bl2) {
            int n7;
            objectArray = new double[n2 - 1];
            complexArray = (Complex[])((double[])arrayList2.get(1));
            for (n7 = 0; n7 < n5 - 1; ++n7) {
                objectArray[n7] = (double)complexArray[n7];
            }
            for (n7 = 0; n7 < n3; ++n7) {
                objectArray[n7 + n5 - 1] = 0.0;
            }
            arrayList.add("real");
            arrayList.add(objectArray);
        } else {
            int n8;
            objectArray = Complex.oneDarray(n2 - 1);
            complexArray = (Complex[])arrayList2.get(1);
            for (n8 = 0; n8 < n5 - 1; ++n8) {
                objectArray[n8] = (double)complexArray[n8];
            }
            for (n8 = 0; n8 < n3; ++n8) {
                objectArray[n8 + n5 - 1] = (double)new Complex(0.0, 0.0);
            }
            arrayList.add("complex");
            arrayList.add(objectArray);
        }
        return arrayList;
    }

    public void resetRealTest(double d) {
        realTol = d;
    }
}

