/*
 * Decompiled with CFR 0.152.
 */
package flanagan.util;

import flanagan.io.PrintToScreen;
import flanagan.math.Fmath;
import flanagan.util.Chars;
import java.util.ArrayList;

public class Strings {
    private String enteredString = null;
    private int nEntered = 0;
    private String editedString = null;
    private int nEdited = 0;
    private boolean[] whiteSpaces = null;
    private String[] tokens = null;
    private int nTokens = 0;
    private int[] tokenInitialIndices = null;
    private int[] tokenFinalIndices = null;
    private boolean tokensDone = false;
    private String[] principalTokens = null;
    private int nPrincipalTokens = 0;
    private int[] principalTokenInitialIndices = null;
    private int[] principalTokenFinalIndices = null;
    private String[] symbolsA = new String[]{"\u00c0", "\u00c1", "\u00c2", "\u00c3", "\u00c4", "\u00c5", "\u00c6", "\u00c7", "\u00c8", "\u00c9", "\u00ca", "\u00cb", "\u00cc", "\u00cd", "\u00ce", "\u00cf", "\u00d0", "\u00d1", "\u00d2", "\u00d3", "\u00d4", "\u00d5", "\u00d6", "\u00d8", "\u00d9", "\u00da", "\u00db", "\u00dc", "\u00dd", "\u00de", "\u00df", "\u00e0", "\u00e1", "\u00e2", "\u00e3", "\u00e4", "\u00e5", "\u00e6", "\u00e7", "\u00e8", "\u00e9", "\u00ea", "\u00eb", "\u00ec", "\u00ed", "\u00ee", "\u00ef", "\u00f0", "\u00f1", "\u00f2", "\u00f3", "\u00f4", "\u00f5", "\u00f6", "\u00f8", "\u00f9", "\u00fa", "\u00fb", "\u00fc", "\u00fd", "\u00fe", "\u00ff", "\u0152", "\u0153", "\u0160", "\u0161", "\u0178", "\u0192"};
    private String[] replSymbolsA = new String[]{"A", "A", "A", "A", "A", "A", "AE", "C", "E", "E", "E", "E", "I", "I", "I", "I", "DH", "N", "O", "O", "O", "O", "O", "O", "U", "U", "U", "U", "Y", "TH", "ss", "a", "a", "a", "a", "a", "a", "ae", "c", "e", "e", "e", "e", "i", "i", "i", "i", "dh", "n", "o", "o", "o", "o", "o", "o", "u", "u", "u", "u", "y", "th", "y", "OE", "oe", "s", "s", "y", "f"};
    private String[] htmlNamesA = new String[]{"&Agrave;", "&Aacute;", "&Acirc;", "&Atilde;", "&Auml;", "&Aring;", "&AElig;", "&Ccedil;", "&Egrave;", "&Eacute;", "&Ecirc;", "&Euml;", "&Igrave;", "&Iacute;", "&Icirc;", "&Iuml;", "&ETH;", "&Ntilde;", "&Ograve;", "&Oacute;", "&Ocirc;", "&Otilde;", "&Ouml;", "&Oslash;", "&Ugrave;", "&Uacute;", "&Ucirc;", "&Uuml;", "&Yacute;", "&THORN;", "&szlig;", "&agrave;", "&aacute;", "&acirc;", "&atilde;", "&auml;", "&aring;", "&aelig;", "&ccedil;", "&egrave;", "&eacute;", "&ecirc;", "&euml;", "&igrave;", "&iacute;", "&icirc;", "&iuml;", "&eth;", "&ntilde;", "&ograve;", "&oacute;", "&ocirc;", "&otilde;", "&ouml;", "&oslash;", "&ugrave;", "&uacute;", "&ucirc;", "&uuml;", "&yacute;", "&thorn;", "&yuml;", "&OE;", "&oe;", "&Scaron;", "&scaron;", "&Ydia;", "&fhook;"};
    private String[] htmlNumbersA = new String[]{"&#192;", "&#193;", "&#194;", "&#195;", "&#196;", "&#197;", "&#198;", "&#199;", "&#200;", "&#201;", "&#202;", "&#203;", "&#204;", "&#205;", "&#206;", "&#207;", "&#208;", "&#209;", "&#210;", "&#211;", "&#212;", "&#213;", "&#214;", "&#216;", "&#217;", "&#218;", "&#219;", "&#220;", "&#221;", "&#222;", "&#223;", "&#224;", "&#225;", "&#226;", "&#227;", "&#228;", "&#229;", "&#230;", "&#231;", "&#232;", "&#233;", "&#234;", "&#235;", "&#236;", "&#237;", "&#238;", "&#239;", "&#240;", "&#241;", "&#242;", "&#243;", "&#244;", "&#245;", "&#246;", "&#248;", "&#249;", "&#250;", "&#251;", "&#252;", "&#253;", "&#254;", "&#255;", "&#338;", "&#339;", "&#352;", "&#353;", "&#376;", "&#402;"};
    private int[] decNumbersA = new int[]{192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 248, 249, 250, 251, 252, 253, 254, 255, 338, 339, 352, 353, 376, 402};
    private int nSymbolsA = this.symbolsA.length;
    private String[] symbolQ = new String[]{"\"", "'", "\u201a", "\u201e", "\u2039", "\u2018", "\u2019", "\u201c", "\u201d", "\u203a", "\u00ab", "\u00bb", "\u2018", "\u2019", "\u201a", "\u201c", "\u201d", "\u201e"};
    private String[] htmlNamesQ = new String[]{"&quot;", "&none", "&sbquo;", "&dbquo;", "&lsaquo;", "&lsquo;", "&rsquo;", "&ldquo;", "&rdquo;", "&rsaquo;", "&laquo;", "&raquo;", "&none;", "&none;", "&none;", "&none;", "&none;", "&none;"};
    private String[] htmlNumbersQ = new String[]{"&#34;", "&#39;", "&#130;", "&#132;", "&#139;", "&#145;", "&#146;", "&#147;", "&#148;", "&#155;", "&#171;", "&#187;", "&#8216;", "&#8217;", "&#8218;", "&#8220;", "&#8221;", "&#8222;"};
    private int[] decNumbersQ = new int[]{34, 39, 130, 132, 139, 145, 146, 147, 148, 155, 171, 187, 8216, 8217, 8218, 8220, 8221, 8222};
    private int nSymbolsQ = this.symbolQ.length;
    private String[] symbolsSQ = new String[]{"'", "\u2018", "\u2019", "\u2018", "\u2019"};
    private String[] htmlNamesSQ = new String[]{"'", "&lsquo;", "&rsquo;", "&none;", "&none;"};
    private String[] htmlNumbersSQ = new String[]{"&#39;", "&#145;", "&#146;", "&#8216;", "&#8217;"};
    private int[] decNumbersSQ = new int[]{39, 145, 146, 8216, 8217};
    private int nSymbolsSQ = this.symbolsSQ.length;
    private String[] symbolsD = new String[]{"-", "\u2013", "\u2014", "\u2013", "\u2014", "\u2013", "\u2014"};
    private String[] htmlNamesD = new String[]{"&none;", "&ndash;", "&mdash;", "\u2013", "&oline;", "&none;", "&none;"};
    private String[] htmlNumbersD = new String[]{"&#45;", "&#150;", "&#151;", "&#8213;", "&#8254;", "&#8211;", "&#8212;"};
    private int[] decNumbersD = new int[]{45, 150, 151, 8213, 8254, 8211, 8212};
    private int nSymbolsD = this.symbolsD.length;
    private String[] articles = new String[]{"a", "an", "the"};
    private int nArticles = this.articles.length;
    private String[] prepositions = new String[]{"about", "above", "across", "after", "against", "along", "among", "around", "at", "before", "behind", "below", "beneath", "beside", "between", "beyond", "but", "by", "despite", "down", "during", "except", "for", "from", "in", "inside", "into", "like", "near", "of", "off", "on", "onto", "out", "outside", "over", "past", "since", "through", "throughout", "till", "to", "toward", "under", "underneath", "until", "up", "upon", "with", "within", "without"};
    private int nPrepositions = this.prepositions.length;
    private String[] conjunctions = new String[]{"and", "&amp", "&", "but", "or", "nor", "for", "so", "yet", "not", "only", "also", "either", "neither", "although", "because", "since", "unless", "until", "while"};
    private int nConjunctions = this.conjunctions.length;

    public Strings(String string) {
        this.enteredString = string;
        this.editedString = string;
        this.nEdited = this.nEntered = string.length();
    }

    public Strings() {
    }

    public String getEditedString() {
        return this.editedString;
    }

    public int getEditedStringLength() {
        return this.nEdited;
    }

    public String getEnteredString() {
        return this.enteredString;
    }

    public int getEnteredStringLength() {
        return this.nEntered;
    }

    public String[] getSingleQuotationMarkHtmlNumbers() {
        return this.htmlNumbersSQ;
    }

    public String toUpperCase() {
        this.editedString = this.editedString.toUpperCase();
        return this.editedString;
    }

    public String toUpperCase(int n) {
        this.editedString = this.editedString.substring(0, n) + this.editedString.substring(n, n + 1).toUpperCase() + this.editedString.substring(n + 1);
        return this.editedString;
    }

    public String toLowerCase() {
        this.editedString = this.editedString.toLowerCase();
        return this.editedString;
    }

    public String toLowerCase(int n) {
        this.editedString = this.editedString.substring(0, n) + this.editedString.substring(n, n + 1).toLowerCase() + this.editedString.substring(n + 1);
        return this.editedString;
    }

    public String toAllTitleCase() {
        this.editedString = this.editedString.toLowerCase();
        this.tokens();
        int n = 0;
        for (int j = 0; j < this.nTokens; ++j) {
            n = this.tokenInitialIndices[j];
            if (Chars.isQuotationMark(this.editedString.charAt(n)) && n < this.nEdited) {
                ++n;
            }
            if (this.whiteSpaces[n]) continue;
            this.toUpperCase(n);
        }
        return this.editedString;
    }

    public static String toAllTitleCase(String string) {
        Strings strings = new Strings(string);
        return strings.toAllTitleCase();
    }

    public String toTitleCase() {
        this.editedString = this.editedString.toLowerCase();
        this.principalTokens();
        int n = 0;
        for (int j = 0; j < this.nPrincipalTokens; ++j) {
            n = this.principalTokenInitialIndices[j];
            if (Chars.isQuotationMark(this.editedString.charAt(n)) && n < this.nEdited) {
                ++n;
            }
            if (this.whiteSpaces[n]) continue;
            this.toUpperCase(n);
        }
        return this.editedString;
    }

    public static String toTitleCase(String string) {
        Strings strings = new Strings(string);
        return strings.toTitleCase();
    }

    public String toSentenceCase() {
        this.editedString = this.editedString.toLowerCase();
        this.tokens();
        int n = this.tokenInitialIndices[0];
        int n2 = -1;
        if (Chars.isQuotationMark(this.editedString.charAt(n)) && n < this.nEdited) {
            ++n;
        }
        if (!this.whiteSpaces[n]) {
            this.toUpperCase(n);
        }
        for (int j = 0; j < this.nTokens - 1; ++j) {
            n = this.tokenFinalIndices[j];
            if (Chars.isQuotationMark(this.editedString.charAt(n))) {
                --n;
            }
            if (this.editedString.charAt(n) != '.') continue;
            n2 = this.tokenInitialIndices[j + 1];
            if (Chars.isQuotationMark(this.editedString.charAt(n2))) {
                ++n2;
            }
            if (this.whiteSpaces[n2]) continue;
            this.toUpperCase(n2);
        }
        return this.editedString;
    }

    public static String toSentenceCase(String string) {
        Strings strings = new Strings(string);
        return strings.toSentenceCase();
    }

    public boolean[] whiteSpaces() {
        this.whiteSpaces = new boolean[this.nEdited];
        boolean bl = true;
        int n = -1;
        for (int j = 0; j < this.nEdited; ++j) {
            this.whiteSpaces[j] = false;
            if (!Character.isWhitespace(this.editedString.charAt(j))) continue;
            this.whiteSpaces[j] = true;
        }
        return this.whiteSpaces;
    }

    public static boolean[] whiteSpaces(String string) {
        Strings strings = new Strings(string);
        return strings.whiteSpaces();
    }

    public String[] tokens() {
        int n;
        this.whiteSpaces();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = true;
        boolean bl2 = false;
        for (n = 0; n < this.nEdited; ++n) {
            if (bl) {
                if (this.whiteSpaces[n]) continue;
                arrayList.add(n);
                bl = false;
                bl2 = true;
                continue;
            }
            if (!bl2 || !this.whiteSpaces[n]) continue;
            arrayList.add(n);
            bl2 = false;
            bl = true;
        }
        n = arrayList.size();
        if (Fmath.isOdd(n)) {
            arrayList.add(this.nEdited);
            ++n;
        }
        this.nTokens = n / 2;
        this.tokens = new String[this.nTokens];
        this.tokenInitialIndices = new int[this.nTokens];
        this.tokenFinalIndices = new int[this.nTokens];
        int n2 = -1;
        for (int j = 0; j < this.nTokens; ++j) {
            int n3 = (Integer)arrayList.get(++n2);
            int n4 = (Integer)arrayList.get(++n2);
            this.tokens[j] = this.editedString.substring(n3, n4).trim();
            this.tokenInitialIndices[j] = n3;
            this.tokenFinalIndices[j] = n4 - 1;
        }
        this.tokensDone = true;
        return this.tokens;
    }

    public static String[] tokens(String string) {
        Strings strings = new Strings(string);
        return strings.tokens();
    }

    public int[] tokenInitialIndices() {
        if (!this.tokensDone) {
            this.tokens();
        }
        return this.tokenInitialIndices;
    }

    public static int[] tokenInitialIndices(String string) {
        Strings strings = new Strings(string);
        return strings.tokenInitialIndices();
    }

    public int[] tokenFinalIndices() {
        if (!this.tokensDone) {
            this.tokens();
        }
        return this.tokenFinalIndices;
    }

    public static int[] tokenFinalIndices(String string) {
        Strings strings = new Strings(string);
        return strings.tokenFinalIndices();
    }

    public String[] principalTokens() {
        int n;
        if (!this.tokensDone) {
            this.tokens();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(0);
        for (n = 1; n < this.nTokens; ++n) {
            int n2;
            String string = Strings.removeQuotationMarks(this.tokens[n]);
            boolean bl = true;
            for (n2 = 0; n2 < this.nArticles; ++n2) {
                if (!string.equalsIgnoreCase(this.articles[n2])) continue;
                bl = false;
                break;
            }
            if (bl) {
                for (n2 = 0; n2 < this.nPrepositions; ++n2) {
                    if (!string.equalsIgnoreCase(this.prepositions[n2])) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                for (n2 = 0; n2 < this.nConjunctions; ++n2) {
                    if (!string.equalsIgnoreCase(this.conjunctions[n2])) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) continue;
            arrayList.add(n);
        }
        this.nPrincipalTokens = arrayList.size();
        this.principalTokens = new String[this.nPrincipalTokens];
        this.principalTokenInitialIndices = new int[this.nPrincipalTokens];
        this.principalTokenFinalIndices = new int[this.nPrincipalTokens];
        for (n = 0; n < this.nPrincipalTokens; ++n) {
            int n3 = (Integer)arrayList.get(n);
            this.principalTokens[n] = this.tokens[n3];
            this.principalTokenInitialIndices[n] = this.tokenInitialIndices[n3];
            this.principalTokenFinalIndices[n] = this.tokenFinalIndices[n3];
        }
        return this.principalTokens;
    }

    public static String[] principalTokens(String string) {
        Strings strings = new Strings(string);
        return strings.principalTokens();
    }

    public String[] principalTokensZero() {
        int n;
        if (!this.tokensDone) {
            this.tokens();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < this.nTokens; ++n) {
            int n2;
            String string = Strings.removeQuotationMarks(this.tokens[n]);
            boolean bl = true;
            for (n2 = 0; n2 < this.nArticles; ++n2) {
                if (!string.equalsIgnoreCase(this.articles[n2])) continue;
                bl = false;
                break;
            }
            if (bl) {
                for (n2 = 0; n2 < this.nPrepositions; ++n2) {
                    if (!string.equalsIgnoreCase(this.prepositions[n2])) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                for (n2 = 0; n2 < this.nConjunctions; ++n2) {
                    if (!string.equalsIgnoreCase(this.conjunctions[n2])) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) continue;
            arrayList.add(n);
        }
        this.nPrincipalTokens = arrayList.size();
        this.principalTokens = new String[this.nPrincipalTokens];
        this.principalTokenInitialIndices = new int[this.nPrincipalTokens];
        this.principalTokenFinalIndices = new int[this.nPrincipalTokens];
        for (n = 0; n < this.nPrincipalTokens; ++n) {
            int n3 = (Integer)arrayList.get(n);
            this.principalTokens[n] = this.tokens[n3];
            this.principalTokenInitialIndices[n] = this.tokenInitialIndices[n3];
            this.principalTokenFinalIndices[n] = this.tokenFinalIndices[n3];
        }
        return this.principalTokens;
    }

    public static String[] principalTokensZero(String string) {
        Strings strings = new Strings(string);
        return strings.principalTokensZero();
    }

    public String removeWhiteSpaces() {
        String string = "";
        for (int j = 0; j < this.nEdited; ++j) {
            char c = this.editedString.charAt(j);
            if (Character.isWhitespace(c)) continue;
            string = string + c;
        }
        return string.trim();
    }

    public static String removeWhiteSpaces(String string) {
        Strings strings = new Strings(string);
        return strings.removeWhiteSpaces();
    }

    public String removeAccents() {
        String string;
        int n;
        String string2 = this.editedString;
        boolean bl = true;
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < this.nSymbolsA; ++n) {
            bl = true;
            while (bl) {
                n2 = string2.indexOf(this.htmlNamesA[n]);
                if (n2 != -1) {
                    n3 = n2 + this.htmlNamesA[n].length();
                    string = string2.substring(0, n2) + this.replSymbolsA[n];
                    if (n3 < this.nEdited) {
                        string = string + string2.substring(n3);
                    }
                    string2 = string;
                    this.nEdited = string2.length();
                    continue;
                }
                bl = false;
            }
        }
        for (n = 0; n < this.nSymbolsA; ++n) {
            bl = true;
            while (bl) {
                n2 = string2.indexOf(this.htmlNumbersA[n]);
                if (n2 != -1) {
                    n3 = n2 + this.htmlNumbersA[n].length();
                    string = string2.substring(0, n2) + this.replSymbolsA[n];
                    if (n3 < this.nEdited) {
                        string = string + string2.substring(n3);
                    }
                    string2 = string;
                    this.nEdited = string2.length();
                    continue;
                }
                bl = false;
            }
        }
        for (n = 0; n < this.nSymbolsA; ++n) {
            for (int j = 0; j < this.nEdited; ++j) {
                if (string2.charAt(j) != this.decNumbersA[n]) continue;
                string2 = string2.substring(0, j) + this.replSymbolsA[n] + string2.substring(j + 1);
                this.nEdited = string2.length();
            }
        }
        this.editedString = string2;
        return string2;
    }

    public static String removeAccents(String string) {
        Strings strings = new Strings(string);
        return strings.removeAccents();
    }

    public String quotationMarksToHtmlNumbers() {
        int n;
        String string = this.editedString;
        boolean bl = true;
        int n2 = -1;
        int n3 = -1;
        block0: for (n = 0; n < this.nSymbolsQ; ++n) {
            bl = true;
            while (bl) {
                n2 = string.indexOf(this.htmlNamesQ[n]);
                if (n2 != -1) {
                    n3 = n2 + this.htmlNamesQ[n].length();
                    String string2 = string.substring(0, n2) + this.htmlNumbersQ[n];
                    if (n3 < this.nEdited) {
                        string2 = string2 + string.substring(n3);
                    }
                    string = string2;
                    this.nEdited = string.length();
                    continue block0;
                }
                bl = false;
            }
        }
        block2: for (n = 0; n < this.nEdited; ++n) {
            char c = string.charAt(n);
            for (int j = 0; j < this.nSymbolsQ; ++j) {
                if (c != this.decNumbersQ[j]) continue;
                String string3 = string.substring(0, n) + this.htmlNumbersQ[j];
                if (n + 1 < this.nEdited) {
                    string3 = string3 + string.substring(n + 1);
                }
                string = string3;
                this.nEdited = string.length();
                continue block2;
            }
        }
        this.editedString = string;
        return string;
    }

    public static String quotationMarksToHtmlNumbers(String string) {
        Strings strings = new Strings(string);
        return strings.quotationMarksToHtmlNumbers();
    }

    public String accentsToHtmlNumbers() {
        int n;
        String string = this.editedString;
        boolean bl = true;
        int n2 = -1;
        int n3 = -1;
        block0: for (n = 0; n < this.nSymbolsA; ++n) {
            bl = true;
            while (bl) {
                n2 = string.indexOf(this.htmlNamesA[n]);
                if (n2 != -1) {
                    n3 = n2 + this.htmlNamesA[n].length();
                    String string2 = string.substring(0, n2) + this.htmlNumbersA[n];
                    if (n3 < this.nEdited) {
                        string2 = string2 + string.substring(n3);
                    }
                    string = string2;
                    this.nEdited = string.length();
                    continue block0;
                }
                bl = false;
            }
        }
        block2: for (n = 0; n < this.nEdited; ++n) {
            char c = string.charAt(n);
            for (int j = 0; j < this.nSymbolsA; ++j) {
                if (c != this.decNumbersA[j]) continue;
                String string3 = string.substring(0, n) + this.htmlNumbersA[j];
                if (n + 1 < this.nEdited) {
                    string3 = string3 + string.substring(n + 1);
                }
                string = string3;
                this.nEdited = string.length();
                continue block2;
            }
        }
        this.editedString = string;
        return string;
    }

    public static String accentsToHtmlNumbers(String string) {
        Strings strings = new Strings(string);
        return strings.accentsToHtmlNumbers();
    }

    public String dashesToHtmlNumbers() {
        int n;
        String string = this.editedString;
        boolean bl = true;
        int n2 = -1;
        int n3 = -1;
        block0: for (n = 0; n < this.nSymbolsD; ++n) {
            bl = true;
            while (bl) {
                n2 = string.indexOf(this.htmlNamesD[n]);
                if (n2 != -1) {
                    n3 = n2 + this.htmlNamesD[n].length();
                    String string2 = string.substring(0, n2) + this.htmlNumbersD[n];
                    if (n3 < this.nEdited) {
                        string2 = string2 + string.substring(n3);
                    }
                    string = string2;
                    this.nEdited = string.length();
                    continue block0;
                }
                bl = false;
            }
        }
        block2: for (n = 0; n < this.nEdited; ++n) {
            char c = string.charAt(n);
            for (int j = 0; j < this.nSymbolsD; ++j) {
                if (c != this.decNumbersD[j]) continue;
                String string3 = string.substring(0, n) + this.htmlNumbersD[j];
                if (n + 1 < this.nEdited) {
                    string3 = string3 + string.substring(n + 1);
                }
                string = string3;
                this.nEdited = string.length();
                continue block2;
            }
        }
        this.editedString = string;
        return string;
    }

    public static String dashesToHtmlNumbers(String string) {
        Strings strings = new Strings(string);
        return strings.dashesToHtmlNumbers();
    }

    public String accentsToDec() {
        String string;
        int n;
        String string2 = this.editedString;
        boolean bl = true;
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < this.nSymbolsA; ++n) {
            bl = true;
            while (bl) {
                n2 = string2.indexOf(this.htmlNamesA[n]);
                if (n2 != -1) {
                    n3 = n2 + this.htmlNamesA[n].length();
                    string = string2.substring(0, n2) + (char)this.decNumbersA[n];
                    if (n3 < this.nEdited) {
                        string = string + string2.substring(n3);
                    }
                    string2 = string;
                    this.nEdited = string2.length();
                    continue;
                }
                bl = false;
            }
        }
        for (n = 0; n < this.nSymbolsA; ++n) {
            bl = true;
            while (bl) {
                n2 = string2.indexOf(this.htmlNumbersA[n]);
                if (n2 != -1) {
                    n3 = n2 + this.htmlNumbersA[n].length();
                    string = string2.substring(0, n2) + (char)this.decNumbersA[n];
                    if (n3 < this.nEdited) {
                        string = string + string2.substring(n3);
                    }
                    string2 = string;
                    this.nEdited = string2.length();
                    continue;
                }
                bl = false;
            }
        }
        this.editedString = string2;
        return string2;
    }

    public static String accentsToDec(String string) {
        Strings strings = new Strings(string);
        return strings.accentsToDec();
    }

    public String dashesToDec() {
        String string;
        int n;
        String string2 = this.editedString;
        boolean bl = true;
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < this.nSymbolsD; ++n) {
            bl = true;
            while (bl) {
                n2 = string2.indexOf(this.htmlNamesD[n]);
                if (n2 != -1) {
                    n3 = n2 + this.htmlNamesD[n].length();
                    string = string2.substring(0, n2) + (char)this.decNumbersD[n];
                    if (n3 < this.nEdited) {
                        string = string + string2.substring(n3);
                    }
                    string2 = string;
                    this.nEdited = string2.length();
                    continue;
                }
                bl = false;
            }
        }
        for (n = 0; n < this.nSymbolsD; ++n) {
            bl = true;
            while (bl) {
                n2 = string2.indexOf(this.htmlNumbersD[n]);
                if (n2 != -1) {
                    n3 = n2 + this.htmlNumbersD[n].length();
                    string = string2.substring(0, n2) + (char)this.decNumbersD[n];
                    if (n3 < this.nEdited) {
                        string = string + string2.substring(n3);
                    }
                    string2 = string;
                    this.nEdited = string2.length();
                    continue;
                }
                bl = false;
            }
        }
        this.editedString = string2;
        return string2;
    }

    public static String dashesToDec(String string) {
        Strings strings = new Strings(string);
        return strings.dashesToDec();
    }

    public String quotationMarksToDec() {
        String string;
        int n;
        String string2 = this.editedString;
        boolean bl = true;
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < this.nSymbolsQ; ++n) {
            bl = true;
            while (bl) {
                n2 = string2.indexOf(this.htmlNamesQ[n]);
                if (n2 != -1) {
                    n3 = n2 + this.htmlNamesQ[n].length();
                    string = string2.substring(0, n2) + (char)this.decNumbersQ[n];
                    if (n3 < this.nEdited) {
                        string = string + string2.substring(n3);
                    }
                    string2 = string;
                    this.nEdited = string2.length();
                    continue;
                }
                bl = false;
            }
        }
        for (n = 0; n < this.nSymbolsQ; ++n) {
            bl = true;
            while (bl) {
                n2 = string2.indexOf(this.htmlNumbersQ[n]);
                if (n2 != -1) {
                    n3 = n2 + this.htmlNumbersQ[n].length();
                    string = string2.substring(0, n2) + (char)this.decNumbersQ[n];
                    if (n3 < this.nEdited) {
                        string = string + string2.substring(n3);
                    }
                    string2 = string;
                    this.nEdited = string2.length();
                    continue;
                }
                bl = false;
            }
        }
        this.editedString = string2;
        return string2;
    }

    public static String quotationMarksToDec(String string) {
        Strings strings = new Strings(string);
        return strings.quotationMarksToDec();
    }

    public String quotationMarksDecToName() {
        block0: for (int j = 0; j < this.nEdited; ++j) {
            char c = this.editedString.charAt(j);
            for (int k = 0; k < this.nSymbolsQ; ++k) {
                if (c != this.decNumbersQ[k]) continue;
                String string = this.editedString.substring(0, j) + this.htmlNamesQ[k];
                if (j < this.nEdited - 1) {
                    string = string + this.editedString.substring(j + 1);
                }
                this.editedString = string;
                this.nEdited = this.editedString.length();
                continue block0;
            }
        }
        return this.editedString;
    }

    public static String quotationMarksDecToName(String string) {
        Strings strings = new Strings(string);
        return strings.quotationMarksDecToName();
    }

    public String quotationMarksDecToHtmlNumber() {
        block0: for (int j = 0; j < this.nEdited; ++j) {
            char c = this.editedString.charAt(j);
            for (int k = 0; k < this.nSymbolsQ; ++k) {
                if (c != this.decNumbersQ[k]) continue;
                String string = this.editedString.substring(0, j) + this.htmlNumbersQ[k];
                if (j < this.nEdited - 1) {
                    string = string + this.editedString.substring(j + 1);
                }
                this.editedString = string;
                this.nEdited = this.editedString.length();
                continue block0;
            }
        }
        return this.editedString;
    }

    public static String quotationMarksDecToHtmlNumber(String string) {
        Strings strings = new Strings(string);
        return strings.quotationMarksDecToHtmlNumber();
    }

    public String replaceDashesWithSpaces() {
        String string;
        int n;
        String string2 = this.editedString;
        boolean bl = true;
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < this.nSymbolsD; ++n) {
            bl = true;
            while (bl) {
                n2 = string2.indexOf(this.htmlNamesD[n]);
                if (n2 != -1) {
                    n3 = n2 + this.htmlNamesD[n].length();
                    string = string2.substring(0, n2) + " ";
                    if (n3 < this.nEdited) {
                        string = string + string2.substring(n3);
                    }
                    string2 = string;
                    this.nEdited = string2.length();
                    continue;
                }
                bl = false;
            }
        }
        for (n = 0; n < this.nSymbolsD; ++n) {
            bl = true;
            while (bl) {
                n2 = string2.indexOf(this.htmlNumbersD[n]);
                if (n2 != -1) {
                    n3 = n2 + this.htmlNumbersD[n].length();
                    string = string2.substring(0, n2) + " ";
                    if (n3 < this.nEdited) {
                        string = string + string2.substring(n3);
                    }
                    string2 = string;
                    this.nEdited = string2.length();
                    continue;
                }
                bl = false;
            }
        }
        for (n = 0; n < this.nSymbolsD; ++n) {
            for (int j = 0; j < this.nEdited; ++j) {
                if (string2.charAt(j) != this.decNumbersD[n]) continue;
                string2 = string2.substring(0, j) + " " + string2.substring(j + 1);
                this.nEdited = string2.length();
            }
        }
        this.editedString = string2;
        return string2;
    }

    public static String replaceDashesWithSpaces(String string) {
        Strings strings = new Strings(string);
        return strings.replaceDashesWithSpaces();
    }

    public String removeQuotationMarks() {
        String string;
        int n;
        String string2 = this.editedString;
        boolean bl = true;
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < this.nSymbolsQ; ++n) {
            bl = true;
            while (bl) {
                n2 = string2.indexOf(this.htmlNamesQ[n]);
                if (n2 != -1) {
                    n3 = n2 + this.htmlNamesQ[n].length();
                    string = string2.substring(0, n2);
                    if (n3 < this.nEdited) {
                        string = string + string2.substring(n3);
                    }
                    string2 = string;
                    this.nEdited = string2.length();
                    continue;
                }
                bl = false;
            }
        }
        for (n = 0; n < this.nSymbolsQ; ++n) {
            bl = true;
            while (bl) {
                n2 = string2.indexOf(this.htmlNumbersQ[n]);
                if (n2 != -1) {
                    n3 = n2 + this.htmlNumbersQ[n].length();
                    string = string2.substring(0, n2);
                    if (n3 < this.nEdited) {
                        string = string + string2.substring(n3);
                    }
                    string2 = string;
                    this.nEdited = string2.length();
                    continue;
                }
                bl = false;
            }
        }
        for (n = 0; n < this.nSymbolsQ; ++n) {
            for (int j = 0; j < this.nEdited; ++j) {
                if (string2.charAt(j) != this.decNumbersQ[n]) continue;
                string2 = string2.substring(0, j) + string2.substring(j + 1);
                this.nEdited = string2.length();
            }
        }
        this.editedString = string2;
        return string2;
    }

    public static String removeQuotationMarks(String string) {
        Strings strings = new Strings(string);
        return strings.removeQuotationMarks();
    }

    public String replaceQuotationMarksBySpaces() {
        String string;
        int n;
        String string2 = this.editedString;
        boolean bl = true;
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < this.nSymbolsQ; ++n) {
            bl = true;
            while (bl) {
                n2 = string2.indexOf(this.htmlNamesQ[n]);
                if (n2 != -1) {
                    n3 = n2 + this.htmlNamesQ[n].length();
                    string = string2.substring(0, n2);
                    if (n3 < this.nEdited) {
                        string = string + " " + string2.substring(n3);
                    }
                    string2 = string;
                    this.nEdited = string2.length();
                    continue;
                }
                bl = false;
            }
        }
        for (n = 0; n < this.nSymbolsQ; ++n) {
            bl = true;
            while (bl) {
                n2 = string2.indexOf(this.htmlNumbersQ[n]);
                if (n2 != -1) {
                    n3 = n2 + this.htmlNumbersQ[n].length();
                    string = string2.substring(0, n2);
                    if (n3 < this.nEdited) {
                        string = string + " " + string2.substring(n3);
                    }
                    string2 = string;
                    this.nEdited = string2.length();
                    continue;
                }
                bl = false;
            }
        }
        for (n = 0; n < this.nSymbolsQ; ++n) {
            for (int j = 0; j < this.nEdited; ++j) {
                if (string2.charAt(j) != this.decNumbersQ[n]) continue;
                string2 = string2.substring(0, j) + " " + string2.substring(j + 1);
                this.nEdited = string2.length();
            }
        }
        this.editedString = string2;
        return string2;
    }

    public String replaceQuotationMarksWithSpaces() {
        String string;
        int n;
        String string2 = this.editedString;
        boolean bl = true;
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < this.nSymbolsQ; ++n) {
            bl = true;
            while (bl) {
                n2 = string2.indexOf(this.htmlNamesQ[n]);
                if (n2 != -1) {
                    n3 = n2 + this.htmlNamesQ[n].length();
                    string = string2.substring(0, n2) + " ";
                    if (n3 < this.nEdited) {
                        string = string + string2.substring(n3);
                    }
                    string2 = string;
                    this.nEdited = string2.length();
                    continue;
                }
                bl = false;
            }
        }
        for (n = 0; n < this.nSymbolsQ; ++n) {
            bl = true;
            while (bl) {
                n2 = string2.indexOf(this.htmlNumbersQ[n]);
                if (n2 != -1) {
                    n3 = n2 + this.htmlNumbersQ[n].length();
                    string = string2.substring(0, n2) + " ";
                    if (n3 < this.nEdited) {
                        string = string + string2.substring(n3);
                    }
                    string2 = string;
                    this.nEdited = string2.length();
                    continue;
                }
                bl = false;
            }
        }
        for (n = 0; n < this.nSymbolsQ; ++n) {
            for (int j = 0; j < this.nEdited; ++j) {
                if (string2.charAt(j) != this.decNumbersQ[n]) continue;
                string2 = string2.substring(0, j) + " " + string2.substring(j + 1);
                this.nEdited = string2.length();
            }
        }
        this.editedString = string2;
        return string2;
    }

    public static String replaceQuotationMarksWithSpaces(String string) {
        Strings strings = new Strings(string);
        return strings.replaceQuotationMarksWithSpaces();
    }

    public String removeQuotationMarksPlus() {
        String string;
        int n;
        String string2 = this.editedString;
        boolean bl = true;
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < this.nSymbolsQ; ++n) {
            bl = true;
            while (bl) {
                n2 = string2.indexOf(this.htmlNamesQ[n]);
                if (n2 != -1) {
                    char c;
                    n3 = n2 + this.htmlNamesQ[n].length();
                    if (!(n3 >= this.nEdited || n2 <= 0 || Character.isWhitespace(c = string2.charAt(n2 - 1)) || string2.charAt(n3) != 's' && string2.charAt(n3) != 'S')) {
                        ++n3;
                    }
                    string = string2.substring(0, n2);
                    if (n3 < this.nEdited) {
                        string = string + string2.substring(n3);
                    }
                    string2 = string;
                    this.nEdited = string2.length();
                    continue;
                }
                bl = false;
            }
        }
        for (n = 0; n < this.nSymbolsQ; ++n) {
            bl = true;
            while (bl) {
                n2 = string2.indexOf(this.htmlNumbersQ[n]);
                if (n2 != -1) {
                    char c;
                    n3 = n2 + this.htmlNumbersQ[n].length();
                    if (!(n3 >= this.nEdited || n2 <= 0 || Character.isWhitespace(c = string2.charAt(n2 - 1)) || string2.charAt(n3) != 's' && string2.charAt(n3) != 'S')) {
                        ++n3;
                    }
                    string = string2.substring(0, n2);
                    if (n3 < this.nEdited) {
                        string = string + string2.substring(n3);
                    }
                    string2 = string;
                    this.nEdited = string2.length();
                    continue;
                }
                bl = false;
            }
        }
        for (n = 0; n < this.nSymbolsQ; ++n) {
            for (int j = 0; j < this.nEdited; ++j) {
                char c;
                n3 = j + 1;
                if (!(n3 >= this.nEdited || j <= 0 || Character.isWhitespace(c = string2.charAt(j - 1)) || string2.charAt(n3) != 's' && string2.charAt(n3) != 'S')) {
                    ++n3;
                }
                if (string2.charAt(j) != this.decNumbersQ[n]) continue;
                string2 = string2.substring(0, j) + string2.substring(n3);
                this.nEdited = string2.length();
            }
        }
        this.editedString = string2;
        return string2;
    }

    public static String removeQuotationMarksPlus(String string) {
        Strings strings = new Strings(string);
        return strings.removeQuotationMarksPlus();
    }

    public String removeDashes() {
        String string;
        int n;
        String string2 = this.editedString;
        boolean bl = true;
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < this.nSymbolsD; ++n) {
            bl = true;
            while (bl) {
                n2 = string2.indexOf(this.htmlNamesD[n]);
                if (n2 != -1) {
                    n3 = n2 + this.htmlNamesD[n].length();
                    string = string2.substring(0, n2);
                    if (n3 < this.nEdited) {
                        string = string + string2.substring(n3);
                    }
                    string2 = string;
                    this.nEdited = string2.length();
                    continue;
                }
                bl = false;
            }
        }
        for (n = 0; n < this.nSymbolsD; ++n) {
            bl = true;
            while (bl) {
                n2 = string2.indexOf(this.htmlNumbersD[n]);
                if (n2 != -1) {
                    n3 = n2 + this.htmlNumbersD[n].length();
                    string = string2.substring(0, n2);
                    if (n3 < this.nEdited) {
                        string = string + string2.substring(n3);
                    }
                    string2 = string;
                    this.nEdited = string2.length();
                    continue;
                }
                bl = false;
            }
        }
        for (n = 0; n < this.nSymbolsD; ++n) {
            for (int j = 0; j < this.nEdited; ++j) {
                if (string2.charAt(j) != this.decNumbersD[n]) continue;
                string2 = string2.substring(0, j) + string2.substring(j + 1);
                this.nEdited = string2.length();
            }
        }
        this.editedString = string2;
        return string2;
    }

    public static String removeDashes(String string) {
        Strings strings = new Strings(string);
        return strings.removeDashes();
    }

    public int[] displayIntegers() {
        int[] nArray = new int[this.nEdited];
        for (int j = 0; j < this.nEdited; ++j) {
            nArray[j] = this.editedString.charAt(j);
        }
        PrintToScreen.print(nArray);
        return nArray;
    }

    public static int[] displayIntegers(String string) {
        Strings strings = new Strings(string);
        return strings.displayIntegers();
    }

    public int indexOfDash() {
        int n;
        int n2;
        int n3 = -1;
        int n4 = -1;
        boolean bl = false;
        for (int j = 0; j < this.nEdited; ++j) {
            String string = this.editedString.substring(j, j + 1);
            for (n2 = 0; n2 < this.nSymbolsD; ++n2) {
                if (!string.equals(this.symbolsD[n2])) continue;
                n3 = j;
                n4 = j;
                bl = true;
                break;
            }
            if (bl) break;
        }
        String[] stringArray = new String[]{"&ndash;", "&mdash;", "&oline;"};
        int n5 = -1;
        n2 = -1;
        for (n = 0; n < 3; ++n) {
            n5 = this.editedString.indexOf(stringArray[n]);
            if (n5 == -1) continue;
            n3 = n5;
            if (n2 == -1) {
                n2 = n5;
                continue;
            }
            if (n2 < n5) {
                n3 = n2;
                continue;
            }
            n2 = n5;
        }
        if (n4 != -1) {
            if (n2 != -1) {
                n4 = n3 = Math.min(n4, n2);
            }
        } else if (n2 != -1) {
            n3 = n2;
            n4 = n2;
        }
        n5 = -1;
        n2 = -1;
        for (n = 0; n < this.nSymbolsD; ++n) {
            n5 = this.editedString.indexOf(this.htmlNumbersD[n]);
            if (n5 == -1) continue;
            n3 = n5;
            if (n2 == -1) {
                n2 = n5;
                continue;
            }
            if (n2 < n5) {
                n3 = n2;
                continue;
            }
            n2 = n5;
        }
        if (n4 != -1) {
            if (n2 != -1) {
                n4 = n3 = Math.min(n4, n2);
            }
        } else if (n2 != -1) {
            n3 = n2;
            n4 = n2;
        }
        return n3;
    }

    public static int indexOfDash(String string) {
        Strings strings = new Strings(string);
        return strings.indexOfDash();
    }

    public boolean nearlyEquals(String string, double d) {
        boolean bl = false;
        String[] stringArray = new String[]{this.editedString, string};
        if (stringArray[0].equalsIgnoreCase(stringArray[1])) {
            bl = true;
        } else {
            int n = stringArray[0].length();
            int n2 = stringArray[1].length();
            int n3 = Math.min(n, n2);
            int n4 = Math.max(n, n2);
            int n5 = 0;
            int n6 = 1;
            if (n == n4) {
                n5 = 1;
                n6 = 0;
            }
            int n7 = (int)Math.round(d * (double)n3);
            int n8 = n4 - n3;
            for (int j = 0; j < n8 + 1; ++j) {
                int n9 = 0;
                for (int k = 0; k < n3; ++k) {
                    if (stringArray[n5].charAt(k) != stringArray[n6].charAt(k + j)) continue;
                    ++n9;
                }
                if (n9 < n7) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static boolean nearlyEquals(String string, String string2, double d) {
        Strings strings = new Strings(string2);
        return strings.nearlyEquals(string, d);
    }
}

