/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.timing;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.anim.timing.TimedDocumentRoot;
import org.apache.batik.anim.timing.TimedElement;

public abstract class TimeContainer
extends TimedElement {
    protected List children = new LinkedList();

    public void addChild(TimedElement e) {
        if (e == this) {
            throw new IllegalArgumentException("recursive datastructure not allowed here!");
        }
        this.children.add(e);
        e.parent = this;
        this.setRoot(e, this.root);
        this.root.fireElementAdded(e);
        this.root.currentIntervalWillUpdate();
    }

    protected void setRoot(TimedElement e, TimedDocumentRoot root) {
        e.root = root;
        if (e instanceof TimeContainer) {
            TimeContainer c = (TimeContainer)e;
            Iterator it = c.children.iterator();
            while (it.hasNext()) {
                TimedElement te = (TimedElement)it.next();
                this.setRoot(te, root);
            }
        }
    }

    public void removeChild(TimedElement e) {
        this.children.remove(e);
        e.parent = null;
        this.setRoot(e, null);
        this.root.fireElementRemoved(e);
        this.root.currentIntervalWillUpdate();
    }

    public TimedElement[] getChildren() {
        return this.children.toArray(new TimedElement[0]);
    }

    protected float sampleAt(float parentSimpleTime, boolean hyperlinking) {
        super.sampleAt(parentSimpleTime, hyperlinking);
        return this.sampleChildren(parentSimpleTime, hyperlinking);
    }

    protected float sampleChildren(float parentSimpleTime, boolean hyperlinking) {
        float mint = Float.POSITIVE_INFINITY;
        Iterator i2 = this.children.iterator();
        while (i2.hasNext()) {
            TimedElement e = (TimedElement)i2.next();
            float t = e.sampleAt(parentSimpleTime, hyperlinking);
            if (!(t < mint)) continue;
            mint = t;
        }
        return mint;
    }

    protected void reset(boolean clearCurrentBegin) {
        super.reset(clearCurrentBegin);
        Iterator i2 = this.children.iterator();
        while (i2.hasNext()) {
            TimedElement e = (TimedElement)i2.next();
            e.reset(clearCurrentBegin);
        }
    }

    protected boolean isConstantAnimation() {
        return false;
    }

    public abstract float getDefaultBegin(TimedElement var1);
}

