/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.values.AnimatableLengthValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;

public class AnimatableLengthListValue
extends AnimatableValue {
    protected short[] lengthTypes;
    protected float[] lengthValues;
    protected short percentageInterpretation;

    protected AnimatableLengthListValue(AnimationTarget target) {
        super(target);
    }

    public AnimatableLengthListValue(AnimationTarget target, short[] types, float[] values, short pcInterp) {
        super(target);
        this.lengthTypes = types;
        this.lengthValues = values;
        this.percentageInterpretation = pcInterp;
    }

    public AnimatableValue interpolate(AnimatableValue result, AnimatableValue to, float interpolation, AnimatableValue accumulation, int multiplier) {
        AnimatableLengthListValue res;
        float[] baseLengthValues;
        short[] baseLengthTypes;
        boolean canInterpolate;
        AnimatableLengthListValue toLengthList = (AnimatableLengthListValue)to;
        AnimatableLengthListValue accLengthList = (AnimatableLengthListValue)accumulation;
        boolean hasTo = to != null;
        boolean hasAcc = accumulation != null;
        boolean bl = canInterpolate = !(hasTo && toLengthList.lengthTypes.length != this.lengthTypes.length || hasAcc && accLengthList.lengthTypes.length != this.lengthTypes.length);
        if (!canInterpolate && hasTo && (double)interpolation >= 0.5) {
            baseLengthTypes = toLengthList.lengthTypes;
            baseLengthValues = toLengthList.lengthValues;
        } else {
            baseLengthTypes = this.lengthTypes;
            baseLengthValues = this.lengthValues;
        }
        int len = baseLengthTypes.length;
        if (result == null) {
            res = new AnimatableLengthListValue(this.target);
            res.lengthTypes = new short[len];
            res.lengthValues = new float[len];
        } else {
            res = (AnimatableLengthListValue)result;
            if (res.lengthTypes == null || res.lengthTypes.length != len) {
                res.lengthTypes = new short[len];
                res.lengthValues = new float[len];
            }
        }
        res.hasChanged = this.percentageInterpretation != res.percentageInterpretation;
        res.percentageInterpretation = this.percentageInterpretation;
        int i2 = 0;
        while (i2 < len) {
            float toV = 0.0f;
            float accV = 0.0f;
            short newLengthType = baseLengthTypes[i2];
            float newLengthValue = baseLengthValues[i2];
            if (canInterpolate) {
                if (hasTo && !AnimatableLengthValue.compatibleTypes(newLengthType, this.percentageInterpretation, toLengthList.lengthTypes[i2], toLengthList.percentageInterpretation) || hasAcc && !AnimatableLengthValue.compatibleTypes(newLengthType, this.percentageInterpretation, accLengthList.lengthTypes[i2], accLengthList.percentageInterpretation)) {
                    newLengthValue = this.target.svgToUserSpace(newLengthValue, newLengthType, this.percentageInterpretation);
                    newLengthType = 1;
                    if (hasTo) {
                        toV = to.target.svgToUserSpace(toLengthList.lengthValues[i2], toLengthList.lengthTypes[i2], toLengthList.percentageInterpretation);
                    }
                    if (hasAcc) {
                        accV = accumulation.target.svgToUserSpace(accLengthList.lengthValues[i2], accLengthList.lengthTypes[i2], accLengthList.percentageInterpretation);
                    }
                } else {
                    if (hasTo) {
                        toV = toLengthList.lengthValues[i2];
                    }
                    if (hasAcc) {
                        accV = accLengthList.lengthValues[i2];
                    }
                }
                newLengthValue += interpolation * (toV - newLengthValue) + (float)multiplier * accV;
            }
            if (!res.hasChanged) {
                res.hasChanged = newLengthType != res.lengthTypes[i2] || newLengthValue != res.lengthValues[i2];
            }
            res.lengthTypes[i2] = newLengthType;
            res.lengthValues[i2] = newLengthValue;
            ++i2;
        }
        return res;
    }

    public short[] getLengthTypes() {
        return this.lengthTypes;
    }

    public float[] getLengthValues() {
        return this.lengthValues;
    }

    public boolean canPace() {
        return false;
    }

    public float distanceTo(AnimatableValue other) {
        return 0.0f;
    }

    public AnimatableValue getZeroValue() {
        float[] vs = new float[this.lengthValues.length];
        return new AnimatableLengthListValue(this.target, this.lengthTypes, vs, this.percentageInterpretation);
    }

    public String getCssText() {
        StringBuffer sb = new StringBuffer();
        if (this.lengthValues.length > 0) {
            sb.append(AnimatableValue.formatNumber(this.lengthValues[0]));
            sb.append(AnimatableLengthValue.UNITS[this.lengthTypes[0] - 1]);
        }
        int i2 = 1;
        while (i2 < this.lengthValues.length) {
            sb.append(',');
            sb.append(AnimatableValue.formatNumber(this.lengthValues[i2]));
            sb.append(AnimatableLengthValue.UNITS[this.lengthTypes[i2] - 1]);
            ++i2;
        }
        return sb.toString();
    }
}

