/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;

public class AnimatableNumberListValue
extends AnimatableValue {
    protected float[] numbers;

    protected AnimatableNumberListValue(AnimationTarget target) {
        super(target);
    }

    public AnimatableNumberListValue(AnimationTarget target, float[] numbers) {
        super(target);
        this.numbers = numbers;
    }

    public AnimatableValue interpolate(AnimatableValue result, AnimatableValue to, float interpolation, AnimatableValue accumulation, int multiplier) {
        AnimatableNumberListValue res;
        AnimatableNumberListValue toNumList = (AnimatableNumberListValue)to;
        AnimatableNumberListValue accNumList = (AnimatableNumberListValue)accumulation;
        boolean hasTo = to != null;
        boolean hasAcc = accumulation != null;
        boolean canInterpolate = !(hasTo && toNumList.numbers.length != this.numbers.length || hasAcc && accNumList.numbers.length != this.numbers.length);
        float[] baseValues = !canInterpolate && hasTo && (double)interpolation >= 0.5 ? toNumList.numbers : this.numbers;
        int len = baseValues.length;
        if (result == null) {
            res = new AnimatableNumberListValue(this.target);
            res.numbers = new float[len];
        } else {
            res = (AnimatableNumberListValue)result;
            if (res.numbers == null || res.numbers.length != len) {
                res.numbers = new float[len];
            }
        }
        int i2 = 0;
        while (i2 < len) {
            float newValue = baseValues[i2];
            if (canInterpolate) {
                if (hasTo) {
                    newValue += interpolation * (toNumList.numbers[i2] - newValue);
                }
                if (hasAcc) {
                    newValue += (float)multiplier * accNumList.numbers[i2];
                }
            }
            if (res.numbers[i2] != newValue) {
                res.numbers[i2] = newValue;
                res.hasChanged = true;
            }
            ++i2;
        }
        return res;
    }

    public float[] getNumbers() {
        return this.numbers;
    }

    public boolean canPace() {
        return false;
    }

    public float distanceTo(AnimatableValue other) {
        return 0.0f;
    }

    public AnimatableValue getZeroValue() {
        float[] ns = new float[this.numbers.length];
        return new AnimatableNumberListValue(this.target, ns);
    }

    public String getCssText() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.numbers[0]);
        int i2 = 1;
        while (i2 < this.numbers.length) {
            sb.append(' ');
            sb.append(this.numbers[i2]);
            ++i2;
        }
        return sb.toString();
    }
}

