/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.util.ArrayList;
import org.apache.batik.apps.svgbrowser.AbstractUndoableCommand;
import org.apache.batik.apps.svgbrowser.UndoableCommand;

public abstract class AbstractCompoundCommand
extends AbstractUndoableCommand {
    protected ArrayList atomCommands = new ArrayList();

    public void addCommand(UndoableCommand command) {
        if (command.shouldExecute()) {
            this.atomCommands.add(command);
        }
    }

    public void execute() {
        int n = this.atomCommands.size();
        int i2 = 0;
        while (i2 < n) {
            UndoableCommand cmd = (UndoableCommand)this.atomCommands.get(i2);
            cmd.execute();
            ++i2;
        }
    }

    public void undo() {
        int size = this.atomCommands.size();
        int i2 = size - 1;
        while (i2 >= 0) {
            UndoableCommand command = (UndoableCommand)this.atomCommands.get(i2);
            command.undo();
            --i2;
        }
    }

    public void redo() {
        int n = this.atomCommands.size();
        int i2 = 0;
        while (i2 < n) {
            UndoableCommand cmd = (UndoableCommand)this.atomCommands.get(i2);
            cmd.redo();
            ++i2;
        }
    }

    public boolean shouldExecute() {
        boolean shouldExecute = true;
        if (this.atomCommands.size() == 0) {
            shouldExecute = false;
        }
        int n = this.atomCommands.size();
        int i2 = 0;
        while (i2 < n && shouldExecute) {
            UndoableCommand command = (UndoableCommand)this.atomCommands.get(i2);
            shouldExecute = command.shouldExecute() && shouldExecute;
            ++i2;
        }
        return shouldExecute;
    }

    public int getCommandNumber() {
        return this.atomCommands.size();
    }
}

