/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JSlider;
import org.apache.batik.apps.svgbrowser.OptionPanel;
import org.apache.batik.util.gui.ExtendedGridBagConstraints;

public class JPEGOptionPanel
extends OptionPanel {
    protected JSlider quality;

    public JPEGOptionPanel() {
        super(new GridBagLayout());
        ExtendedGridBagConstraints constraints = new ExtendedGridBagConstraints();
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.setGridBounds(0, 0, 1, 1);
        this.add((Component)new JLabel(OptionPanel.resources.getString("JPEGOptionPanel.label")), constraints);
        this.quality = new JSlider();
        this.quality.setMinimum(0);
        this.quality.setMaximum(100);
        this.quality.setMajorTickSpacing(10);
        this.quality.setMinorTickSpacing(5);
        this.quality.setPaintTicks(true);
        this.quality.setPaintLabels(true);
        this.quality.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        int i2 = 0;
        while (i2 < 100) {
            labels.put(new Integer(i2), new JLabel("0." + i2 / 10));
            i2 += 10;
        }
        labels.put(new Integer(100), new JLabel("1"));
        this.quality.setLabelTable(labels);
        Dimension dim = this.quality.getPreferredSize();
        this.quality.setPreferredSize(new Dimension(350, dim.height));
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.setGridBounds(1, 0, 1, 1);
        this.add((Component)this.quality, constraints);
    }

    public float getQuality() {
        return (float)this.quality.getValue() / 100.0f;
    }

    public static float showDialog(Component parent) {
        String title = OptionPanel.resources.getString("JPEGOptionPanel.dialog.title");
        JPEGOptionPanel panel = new JPEGOptionPanel();
        OptionPanel.Dialog dialog = new OptionPanel.Dialog(parent, title, panel);
        dialog.pack();
        ((Component)dialog).setVisible(true);
        return panel.getQuality();
    }
}

